/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.realtime.preview.listener;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.MarkdownUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.realtime.preview.RealTimeActivator;
import com.pandora.realtime.preview.RealTimeHelper;
import com.pandora.view.browser.views.BrowserComposite;
import java.io.File;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IElementStateListener;

public class EditorChangeListener
implements IPartListener2 {
    private static final String DIR_PREVIEW = "preview";
    private static Object object = new Object();
    private static EditorChangeListener broswerListenner;
    private IElementStateListener editorFileSaveListener = new IElementStateListener(){

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (RealTimeHelper.getRealTimeInterface() == null) {
                return;
            }
            if (!isDirty && element instanceof IEditorInput) {
                final IEditorInput editorInput = (IEditorInput)element;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (RealTimeHelper.isWebViewShowed()) {
                                BrowserComposite viewer;
                                IFileEditorInput input;
                                String launchURL = null;
                                if (editorInput instanceof IFileEditorInput) {
                                    input = (IFileEditorInput)editorInput;
                                    IFileStore inputFile = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                                    if (RealTimeHelper.getEditorInputFile() != null && !RealTimeHelper.getEditorInputFile().equals(inputFile)) {
                                        return;
                                    }
                                    if (MarkdownUtils.isMarkDown((String)inputFile.getName())) {
                                        launchURL = EditorChangeListener.this.getMdrkDownPreViewURL(inputFile.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
                                    } else {
                                        URL url = RealTimeHelper.getRealTimeInterface().convertURL(inputFile);
                                        if (url != null) {
                                            launchURL = url.toString();
                                        }
                                    }
                                    if (StringUtil.isNotBlank((String)launchURL)) {
                                        RealTimeHelper.getRealTimeInterface().startWebServer(inputFile.getName());
                                    }
                                } else if (editorInput instanceof FileStoreEditorInput) {
                                    input = (FileStoreEditorInput)editorInput;
                                    launchURL = MarkdownUtils.isMarkDown((String)input.getName()) ? EditorChangeListener.this.getMdrkDownPreViewURL(new File(input.getURI())) : input.getURI().toString();
                                }
                                if (StringUtil.isNotBlank(launchURL) && (viewer = RealTimeHelper.getBrowserViewer()) != null) {
                                    if (RealTimeHelper.iSameWithWebViewUri(launchURL, viewer.getRealURL())) {
                                        viewer.refresh();
                                    } else {
                                        viewer.setURL(launchURL);
                                    }
                                    if (viewer.getBrowser() instanceof Browser) {
                                        try {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                        }
                    }
                });
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }
    };

    private EditorChangeListener() {
    }

    public static EditorChangeListener getInstance() {
        if (broswerListenner == null) {
            broswerListenner = new EditorChangeListener();
        }
        return broswerListenner;
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        if (partRef.getId().equals("com.pandora.view.browser.view.WebBrowserView")) {
            if (RealTimeHelper.getEditorInputFile() != null) {
                RealTimeHelper.getRealTimeInterface().beforeRealTimeFileNameChange(RealTimeHelper.getEditorInputFile().getName());
            }
            RealTimeHelper.setRealTimeBrowserURL(true);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IEditorPart editor;
        if (partRef instanceof IEditorReference && (editor = ((IEditorReference)partRef).getEditor(false)) instanceof AbstractTextEditor) {
            ((AbstractTextEditor)editor).getDocumentProvider().removeElementStateListener(this.editorFileSaveListener);
            IEditorReference[] leaveEditors = partRef.getPage().getEditorReferences();
            int num = 0;
            if (leaveEditors.length > 0) {
                IEditorReference[] iEditorReferenceArray = leaveEditors;
                int n = leaveEditors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    if (editorReference.getEditor(false) instanceof AbstractTextEditor) {
                        ++num;
                    }
                    ++n2;
                }
            }
            if (leaveEditors.length == 0 || num == 0) {
                RealTimeHelper.setEditorInputFile(null);
                RealTimeHelper.setEditorInputUrl(null);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        if (partRef instanceof IEditorReference) {
            try {
                if (((IEditorReference)partRef).getEditor(false) instanceof AbstractTextEditor) {
                    try {
                        IEditorInput input = ((IEditorReference)partRef).getEditorInput();
                        if (input != null && input.exists()) {
                            RealTimeHelper.getRealTimeInterface().beforeActiveEditor(input.getName());
                        }
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
                    }
                }
                if (this.needTabChangeJob((IEditorReference)partRef)) {
                    AbstractTextEditor editorPart = (AbstractTextEditor)((EditorReference)partRef).getEditor(false);
                    editorPart.getDocumentProvider().addElementStateListener(this.editorFileSaveListener);
                    IEditorInput iEditorInput = ((IEditorReference)partRef).getEditorInput();
                    boolean isMarkDown = MarkdownUtils.isMarkDown((String)iEditorInput.getName());
                    if (isMarkDown) {
                        IFileEditorInput input;
                        File mdFile = null;
                        if (iEditorInput instanceof IFileEditorInput) {
                            input = (IFileEditorInput)iEditorInput;
                            IFileStore fileStore = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                            mdFile = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                        } else if (iEditorInput instanceof FileStoreEditorInput) {
                            input = (FileStoreEditorInput)iEditorInput;
                            mdFile = new File(input.getURI());
                        }
                        File targetFolder = RealTimeActivator.getDefault().getBundle().getDataFile(DIR_PREVIEW);
                        boolean isValid = MarkdownUtils.isMarkDownHtmlValid(mdFile, (File)targetFolder);
                        this.setChangedEditorInput(editorPart, iEditorInput);
                        RealTimeHelper.setRealTimeBrowserURL(!isValid);
                    } else {
                        this.setChangedEditorInput(editorPart, iEditorInput);
                        RealTimeHelper.setRealTimeBrowserURL(false);
                    }
                }
            }
            catch (Exception e) {
                HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
            }
        }
    }

    private boolean needTabChangeJob(IEditorReference partRef) {
        IEditorInput input;
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return false;
        }
        IEditorPart editor = partRef.getEditor(false);
        if (editor instanceof AbstractTextEditor && (input = editor.getEditorInput()) != null) {
            if (MarkdownUtils.isMarkDown((String)input.getName())) {
                return true;
            }
            return RealTimeHelper.getRealTimeInterface().isRealTimeFileNameEnable(input.getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChangedEditorInput(AbstractTextEditor editor, IEditorInput iEditorInput) {
        if (RealTimeHelper.getRealTimeInterface() == null) {
            return;
        }
        Object object = EditorChangeListener.object;
        synchronized (object) {
            try {
                String launchURL = null;
                IFileStore inputFile = null;
                if (iEditorInput instanceof IFileEditorInput) {
                    IFileEditorInput input = (IFileEditorInput)iEditorInput;
                    inputFile = RealTimeHelper.getRealTimeInterface().convertFile(input.getFile());
                    if (MarkdownUtils.isMarkDown((String)iEditorInput.getName())) {
                        launchURL = this.getMdrkDownPreViewURL(inputFile.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
                    } else {
                        URL url = RealTimeHelper.getRealTimeInterface().convertURL(inputFile);
                        launchURL = url.toString();
                    }
                } else if (iEditorInput instanceof FileStoreEditorInput) {
                    inputFile = null;
                    FileStoreEditorInput input = (FileStoreEditorInput)iEditorInput;
                    launchURL = MarkdownUtils.isMarkDown((String)iEditorInput.getName()) ? this.getMdrkDownPreViewURL(new File(input.getURI())) : input.getURI().toString();
                }
                if (inputFile != null && (launchURL == null || !launchURL.equals(RealTimeHelper.getEditorInputUrl())) && RealTimeHelper.isWebViewShowed()) {
                    RealTimeHelper.getRealTimeInterface().beforeRealTimeFileNameChange(inputFile.getName());
                }
                RealTimeHelper.setEditorInputFile(inputFile);
                RealTimeHelper.setEditorInputUrl(launchURL);
            }
            catch (Exception e) {
                HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
            }
        }
        RealTimeHelper.setRealTimeBrowserURL();
    }

    private String getMdrkDownPreViewURL(File mdFile) {
        try {
            File targetFolder = RealTimeActivator.getDefault().getBundle().getDataFile(DIR_PREVIEW);
            File html = MarkdownUtils.markdownToHtmlFolder((File)mdFile, (File)targetFolder);
            if (html != null && html.exists()) {
                return html.toURI().toString();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
        return mdFile.toURI().toString();
    }
}

