/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.preferences.Messages;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JSDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button suspendOnFirstLine;
    private Button suspendOnExceptions;
    private Button suspendOnErrors;
    private Button suspendOnDebuggerKeyword;
    private Button confirmExitDebugger;

    public JSDebugPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)EclipseUtil.instanceScope(), "com.aptana.js.debug.core"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Group debugGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        debugGroup.setLayout((Layout)gridLayout);
        debugGroup.setLayoutData((Object)new GridData(768));
        debugGroup.setText(Messages.JSDebugPreferencePage_JavascriptDebugOptions);
        this.suspendOnFirstLine = new Button((Composite)debugGroup, 32);
        this.suspendOnFirstLine.setText(Messages.JSDebugPreferencePage_SuspendAtStart);
        this.suspendOnExceptions = new Button((Composite)debugGroup, 32);
        this.suspendOnExceptions.setText(Messages.JSDebugPreferencePage_SuspendOnExceptions);
        this.suspendOnErrors = new Button((Composite)debugGroup, 32);
        this.suspendOnErrors.setText(Messages.JSDebugPreferencePage_SuspendOnErrors);
        this.suspendOnDebuggerKeyword = new Button((Composite)debugGroup, 32);
        this.suspendOnDebuggerKeyword.setText(Messages.JSDebugPreferencePage_SuspendOnDebuggerKeyword);
        this.confirmExitDebugger = new Button(composite, 32);
        this.confirmExitDebugger.setText(Messages.JSDebugPreferencePage_ConfirmExitWhenDebuggerActive);
        this.setInitialValues();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.setDefaultValues();
    }

    public boolean performOk() {
        this.setValues();
        return super.performOk();
    }

    private void setInitialValues() {
        this.suspendOnFirstLine.setSelection(this.getPreferenceStore().getBoolean("com.aptana.js.debug.core.suspend_on_first_line"));
        this.suspendOnExceptions.setSelection(this.getPreferenceStore().getBoolean("com.aptana.js.debug.core.suspend_on_exceptions"));
        this.suspendOnErrors.setSelection(this.getPreferenceStore().getBoolean("com.aptana.js.debug.core.suspend_on_errors"));
        this.suspendOnDebuggerKeyword.setSelection(this.getPreferenceStore().getBoolean("com.aptana.js.debug.core.suspend_on_debugger_keyword"));
        IPreferenceStore uiStore = JSDebugUIPlugin.getDefault().getPreferenceStore();
        if (!uiStore.contains("com.aptana.js.debug.ui.confirm_exit_debugger")) {
            this.confirmExitDebugger.setSelection(true);
        } else {
            this.confirmExitDebugger.setSelection(uiStore.getBoolean("com.aptana.js.debug.ui.confirm_exit_debugger"));
        }
    }

    private void setDefaultValues() {
        this.suspendOnFirstLine.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.js.debug.core.suspend_on_first_line"));
        this.suspendOnExceptions.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.js.debug.core.suspend_on_exceptions"));
        this.suspendOnErrors.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.js.debug.core.suspend_on_errors"));
        this.suspendOnDebuggerKeyword.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.js.debug.core.suspend_on_debugger_keyword"));
        IPreferenceStore uiStore = JSDebugUIPlugin.getDefault().getPreferenceStore();
        this.confirmExitDebugger.setSelection(uiStore.getDefaultBoolean("com.aptana.js.debug.ui.confirm_exit_debugger"));
    }

    private void setValues() {
        this.getPreferenceStore().setValue("com.aptana.js.debug.core.suspend_on_first_line", this.suspendOnFirstLine.getSelection());
        this.getPreferenceStore().setValue("com.aptana.js.debug.core.suspend_on_exceptions", this.suspendOnExceptions.getSelection());
        this.getPreferenceStore().setValue("com.aptana.js.debug.core.suspend_on_errors", this.suspendOnErrors.getSelection());
        this.getPreferenceStore().setValue("com.aptana.js.debug.core.suspend_on_debugger_keyword", this.suspendOnDebuggerKeyword.getSelection());
        IPreferenceStore uiStore = JSDebugUIPlugin.getDefault().getPreferenceStore();
        uiStore.setValue("com.aptana.js.debug.ui.confirm_exit_debugger", this.confirmExitDebugger.getSelection());
        try {
            ((IPersistentPreferenceStore)uiStore).save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
    }
}

