/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class HttpSettingsTab
extends AbstractLaunchConfigurationTab {
    private Image image;
    private Listener dirtyListener;
    private Text httpGetQuery;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Group httpGetGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        httpGetGroup.setLayout((Layout)layout);
        httpGetGroup.setLayoutData((Object)new GridData(768));
        httpGetGroup.setText(Messages.HttpSettingsTab_GET_query);
        this.httpGetQuery = new Text((Composite)httpGetGroup, 2624);
        GridData data = new GridData(768);
        data.heightHint = 60;
        this.httpGetQuery.setLayoutData((Object)data);
        this.dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                HttpSettingsTab.this.setDirty(true);
                HttpSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.hookListeners(true);
        this.setControl((Control)composite);
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.httpGetQuery.addListener(24, this.dirtyListener);
        } else {
            this.httpGetQuery.removeListener(24, this.dirtyListener);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setAdvancedDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hookListeners(false);
        try {
            try {
                this.httpGetQuery.setText(configuration.getAttribute("httpGetData", ""));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                this.hookListeners(true);
            }
        }
        finally {
            this.hookListeners(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("httpGetData", this.httpGetQuery.getText());
    }

    public String getName() {
        return Messages.HttpSettingsTab_HTTP;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-http.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

