/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;

public final class StartPageManager {
    private ILaunchConfigurationType configType;
    private Map<String, String> locations = new HashMap<String, String>();
    private ListenerList listeners = new ListenerList();
    private static StartPageManager instance;

    private StartPageManager() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        this.configType = manager.getLaunchConfigurationType("com.aptana.js.debug.core.webbrowserLaunchConfigurationType");
        manager.addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                StartPageManager.this.launchConfigurationAddedInternal(configuration);
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                if (!(configuration instanceof ILaunchConfigurationWorkingCopy)) {
                    StartPageManager.this.launchConfigurationRemovedInternal(configuration);
                    StartPageManager.this.launchConfigurationAddedInternal(configuration);
                }
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                StartPageManager.this.launchConfigurationRemovedInternal(configuration);
            }
        });
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                this.launchConfigurationAddedInternal(config);
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
    }

    public static StartPageManager getDefault() {
        if (instance == null) {
            instance = new StartPageManager();
        }
        return instance;
    }

    public void dispose() {
        this.locations.clear();
    }

    public void addListener(IStartPageChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IStartPageChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isStartPage(IResource resource) {
        return this.locations.containsValue(resource.getFullPath().toPortableString());
    }

    public void setStartPage(IResource resource) {
        ILaunchConfiguration config = this.findLaunchConfiguration();
        if (config != null) {
            try {
                this.updateLaunchConfiguration(config, resource);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    public void removeStartPage(IResource resource) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("startActionType", -1) == 2) {
                    String location = config.getAttribute("startPagePath", "");
                    if (resource.getFullPath().toPortableString().equals(location)) {
                        this.updateLaunchConfiguration(config, null);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration() {
        try {
            LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
            if (history != null) {
                ILaunchConfiguration[] configs;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = history.getHistory();
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    if (this.configType.equals(config.getType())) {
                        return config;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return this.createConfiguration(Messages.StartPageManager_DefaultConfigurationName);
    }

    private ILaunchConfiguration createConfiguration(String namePrefix) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationWorkingCopy wc = this.configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(namePrefix));
            JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, null);
            config = wc.doSave();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return config;
    }

    private void updateLaunchConfiguration(ILaunchConfiguration config, IResource resource) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        if (resource != null) {
            wc.setAttribute("startActionType", 2);
            wc.setAttribute("startPagePath", resource.getFullPath().toPortableString());
        } else {
            wc.setAttribute("startActionType", 1);
        }
        wc.doSave();
    }

    private void launchConfigurationAddedInternal(ILaunchConfiguration configuration) {
        try {
            if (configuration.getType().equals(this.configType) && configuration.getAttribute("startActionType", -1) == 2) {
                String location = configuration.getAttribute("startPagePath", "");
                this.locations.put(configuration.getName(), location);
                this.notifyListeners(location);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Could not access launch configuration", (Throwable)e);
        }
    }

    private void launchConfigurationRemovedInternal(ILaunchConfiguration configuration) {
        try {
            String location;
            if (configuration.exists() && configuration.getType().equals(this.configType) && (location = this.locations.remove(configuration.getName())) != null) {
                this.notifyListeners(location);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private void notifyListeners(String location) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(location);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IStartPageChangeListener)listener).startPageChanged(resource);
            ++n2;
        }
    }

    public static interface IStartPageChangeListener {
        public void startPageChanged(IResource var1);
    }
}

