/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.idevice.win;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.iphone.jna.LibraryFinder;
import com.pandora.launcher.core.iphone.jna.cf.CFDictionary;
import com.pandora.launcher.core.iphone.jna.cf.CFString;
import com.pandora.launcher.core.iphone.jna.cf.CFType;
import com.pandora.launcher.core.iphone.jna.idevice.IApplicationLogHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IDevice;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceLibrary;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.ILookupApplicationsNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IScheduleHandler;
import com.pandora.launcher.core.iphone.jna.idevice.win.AFCConnection;
import com.pandora.launcher.core.iphone.jna.idevice.win.ApplicationInfo;
import com.pandora.launcher.core.iphone.jna.idevice.win.Messages;
import com.pandora.launcher.core.iphone.jna.idevice.win.WinDevice;
import com.pandora.launcher.core.iphone.jna.md.LibraryInstance;
import com.pandora.launcher.core.iphone.jna.md.MDLibrary;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.sun.jna.Pointer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;

public class WinDeviceLibrary
implements IDeviceLibrary,
MDLibrary.am_device_notification_callback {
    protected Logger log = Logger.getLogger("WinDeviceLibrary");
    protected IDeviceNotificationHandler handler;
    protected Map<String, PList> devices = new HashMap<String, PList>();
    protected WinDfuDeviceConnectedCallback dfuConnect = new WinDfuDeviceConnectedCallback();
    protected WinRecoveryDeviceConnectedCallback recoveryConnect = new WinRecoveryDeviceConnectedCallback();
    protected WinDfuDeviceDisconnectedCallback dfuDisconnect = new WinDfuDeviceDisconnectedCallback();
    protected WinRecoveryDeviceDisconnectedCallback recoveryDisconnect = new WinRecoveryDeviceDisconnectedCallback();
    private static MDLibrary library = LibraryInstance.getMDLibrary();
    private static int MAX_SIZE = 0x6400000;

    @Override
    public void addNotificationHandler(IDeviceNotificationHandler callback) {
        if (library == null) {
            library = LibraryInstance.getMDLibrary();
        }
        if (library == null) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"library is null!!!!!");
            return;
        }
        this.handler = callback;
        MDLibrary.am_device_notification.ByReference[] notif = new MDLibrary.am_device_notification.ByReference[]{new MDLibrary.am_device_notification.ByReference()};
        library.AMDeviceNotificationSubscribe(this, 0, 0, 0, notif);
    }

    @Override
    public void addLookupApplicationsNotificationHandler(IDevice device, ILookupApplicationsNotificationHandler callback) {
        if (device instanceof WinDevice) {
            WinDevice winDevice = (WinDevice)device;
            MDLibrary.am_device.ByReference am_device2 = winDevice.getDev();
            MDLibrary.CFDictionaryRef.ByReference dict = new MDLibrary.CFDictionaryRef.ByReference();
            int code = library.AMDeviceLookupApplications(am_device2, 0, dict);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceLookupApplications code========:" + code));
            if (code == 0) {
                ApplicationInfo appInfo = new ApplicationInfo(am_device2, dict.key);
                callback.LookupApplicationsNotificationHandler(winDevice, appInfo.getApplicationInfo());
            }
        }
    }

    @Override
    public AFCConnection addStartServiceHandler(IDevice device, String serviceName) {
        if (device instanceof WinDevice) {
            WinDevice winDevice = (WinDevice)device;
            MDLibrary.am_device.ByReference am_device2 = winDevice.getDev();
            CFString service_name = CFString.buildString(serviceName);
            MDLibrary.afc_connection.ByReference afc_service = new MDLibrary.afc_connection.ByReference();
            int code = library.AMDeviceStartService(am_device2, service_name, afc_service, 0);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceStartService code========:" + code));
            if (code == 0) {
                AFCConnection amdServiceConn = new AFCConnection();
                amdServiceConn.setAfc_connection(afc_service);
                return amdServiceConn;
            }
        }
        return null;
    }

    @Override
    public AFCConnection addOpenAFCConnectionHandler(AFCConnection afc_service) {
        if (afc_service != null) {
            MDLibrary.afc_connection.ByReference afc_connection2 = afc_service.getAfc_connection();
            MDLibrary.afc_connection.ByReference[] afc_connections = new MDLibrary.afc_connection.ByReference[]{new MDLibrary.afc_connection.ByReference()};
            int code = library.AFCConnectionOpen(afc_connection2.handle, 0, afc_connections);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCConnectionOpen code========:" + code));
            if (code == 0) {
                AFCConnection conn = new AFCConnection();
                conn.setAfc_connection(afc_connections[0]);
                return conn;
            }
        }
        return null;
    }

    @Override
    public void addAMDeviceTransferApplicationHandler(AFCConnection afcConnection, String localPath, IScheduleHandler iScheduleHandler) throws OperateException {
        if (afcConnection == null || afcConnection.getAfc_connection() == null) {
            throw new OperateException(Messages.WinDeviceLibrary_Start_Service_Failed, true);
        }
        CFString path = CFString.buildString(localPath);
        TransferCallback transfer_callback2 = new TransferCallback(iScheduleHandler);
        int code = library.AMDeviceTransferApplication(afcConnection.getAfc_connection().handle, path, 0, transfer_callback2, 0);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceTransferApplication code========:" + code));
        if (code != 0) {
            if (iScheduleHandler.isDelete()) {
                throw new OperateException(String.valueOf(Messages.WinDeviceLibrary_Upload_Package_Failed) + code + "\uff0c\u7531\u4e8eHBuilder\u57fa\u5ea7App\u5347\u7ea7\uff0c\u6240\u4ee5\u8bf7\u91cd\u65b0\u624b\u52a8\u5b89\u88c5" + localPath + "\u5230\u624b\u673a\u4e0a\uff08\u53ef\u4f7f\u7528iTools\u5b89\u88c5\uff09\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
            }
            throw new OperateException(String.valueOf(Messages.WinDeviceLibrary_Upload_Package_Failed) + code + "\uff0c\u8bf7\u624b\u52a8\u5b89\u88c5" + localPath + "\u5230\u624b\u673a\u4e0a\uff08\u53ef\u4f7f\u7528iTools\u5b89\u88c5\uff09\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
        }
    }

    @Override
    public void addAMDeviceInstallApplicationHandler(AFCConnection afcConnection, String localPath, IScheduleHandler iScheduleHandler) throws OperateException {
        MDLibrary.afc_connection.ByReference install_service = afcConnection.getAfc_connection();
        CFString[] keys = new CFString[]{CFString.buildString("PackageType")};
        CFType[] values = new CFType[]{CFString.buildString("Developer")};
        CFDictionary options = CFDictionary.createCFDictionary(keys, values, 1);
        CFString path = CFString.buildString(localPath);
        InstallCallback install_callback2 = new InstallCallback(iScheduleHandler);
        int code = library.AMDeviceInstallApplication(install_service.handle, path, options, install_callback2, 0);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceInstallApplication code========:" + code));
        if (code != 0) {
            if (iScheduleHandler.isDelete()) {
                throw new OperateException(String.valueOf(Messages.WinDeviceLibrary_Install_failed) + code + "\uff0c\u7531\u4e8eHBuilder\u57fa\u5ea7App\u5347\u7ea7\uff0c\u6240\u4ee5\u8bf7\u91cd\u65b0\u624b\u52a8\u5b89\u88c5" + localPath + "\u5230\u624b\u673a\u4e0a\uff08\u53ef\u4f7f\u7528iTools\u5b89\u88c5\uff09\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
            }
            throw new OperateException(String.valueOf(Messages.WinDeviceLibrary_Install_failed) + code + "\uff0c\u8bf7\u624b\u52a8\u5b89\u88c5" + localPath + "\u5230\u624b\u673a\u4e0a\uff08\u53ef\u4f7f\u7528iTools\u5b89\u88c5\uff09\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
        }
    }

    @Override
    public void addAMDeviceUnInstallApplicationHandler(AFCConnection afcConnection, String localPath, IScheduleHandler iScheduleHandler) throws OperateException {
        MDLibrary.afc_connection.ByReference install_service = afcConnection.getAfc_connection();
        CFString[] keys = new CFString[]{CFString.buildString("PackageType")};
        CFType[] values = new CFType[]{CFString.buildString("Developer")};
        CFDictionary options = CFDictionary.createCFDictionary(keys, values, 1);
        CFString path = CFString.buildString(localPath);
        InstallCallback install_callback2 = new InstallCallback(iScheduleHandler);
        int code = library.AMDeviceUninstallApplication(install_service.handle, path, options, install_callback2, 0);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceUninstallApplication code========:" + code));
        if (code != 0) {
            throw new OperateException(String.valueOf(Messages.WinDeviceLibrary_Install_failed) + code, true);
        }
    }

    private String getValue(DictionaryElement dictionaryElement, String key) {
        String value = "";
        PElementType type = dictionaryElement.get(key).getType();
        switch (type) {
            case PLIST: {
                break;
            }
            case KEY: {
                break;
            }
            case STRING: {
                value = dictionaryElement.get(key).asString();
                break;
            }
            case REAL: {
                break;
            }
            case INTEGER: {
                value = Long.toString(dictionaryElement.get(key).asLong());
                break;
            }
            case DATE: {
                value = dictionaryElement.get(key).asDate();
                break;
            }
            case BOOLEAN: {
                value = Boolean.toString(dictionaryElement.get(key).asBoolean());
                break;
            }
            case DATA: {
                value = dictionaryElement.get(key).asData();
                break;
            }
            case ARRAY: {
                break;
            }
            case DICTIONARY: {
                dictionaryElement.get(key).asDict();
                break;
            }
        }
        return value;
    }

    public static String getUTF8XMLString(String content) {
        StringBuffer sb = new StringBuffer();
        sb.append(content);
        String contentString = "";
        String contentUTF8 = "";
        try {
            contentString = new String(sb.toString().getBytes("UTF-8"));
            contentUTF8 = URLEncoder.encode(contentString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return contentUTF8;
    }

    @Override
    public void addAFCFileWriteHandler(AFCConnection connection, String appid, String resourcePath, String targetPath, Set<String> refrences) throws OperateException {
        if (connection != null) {
            File file = new File(resourcePath);
            if (!file.exists()) {
                return;
            }
            MDLibrary.afc_connection.ByReference afc_c = connection.getAfc_connection();
            String libraryPath = this.getWWWDir(appid);
            if ((targetPath = targetPath.replace("\\", "/")).startsWith("/")) {
                targetPath = targetPath.substring(1);
            }
            String[] dirs = targetPath.split("/");
            int i = 0;
            while (i < dirs.length - 1) {
                String path;
                byte[] filePByte;
                byte[] fpathByte;
                MDLibrary.afc_directory.ByReference afcd;
                String dir = dirs[i];
                if (StringUtil.isNotBlank((String)dir) && (afcd = this.readDirectoryRef(afc_c, fpathByte = this.copyToByte(filePByte = (path = String.valueOf(libraryPath) + dir + "/").getBytes(Charset.forName("UTF-8"))))) == null) {
                    int code = library.AFCDirectoryCreate(afc_c, fpathByte);
                    HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryCreate code========:" + code));
                }
                ++i;
            }
            this.createFile(afc_c, libraryPath, file, targetPath, true, refrences);
        }
    }

    @Override
    public void addAFCFileRefWriteHandler(AFCConnection afc_connection2, String appid, String localPath) throws OperateException {
        if (afc_connection2 != null) {
            String debugPath;
            int code;
            String libraryPath;
            byte[] filePByte;
            byte[] fpathByte;
            MDLibrary.afc_connection.ByReference afc_c = afc_connection2.getAfc_connection();
            MDLibrary.afc_directory.ByReference afcd = this.readDirectoryRef(afc_c, fpathByte = this.copyToByte(filePByte = (libraryPath = this.getWWWDir(appid)).getBytes(Charset.forName("utf-8"))));
            if (afcd == null) {
                code = library.AFCDirectoryCreate(afc_c, fpathByte);
                HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryCreate code========:" + code));
            }
            if ((afcd = this.readDirectoryRef(afc_c, fpathByte = this.copyToByte(filePByte = (debugPath = String.valueOf(libraryPath) + ".debug/").getBytes(Charset.forName("utf-8"))))) == null) {
                code = library.AFCDirectoryCreate(afc_c, fpathByte);
                HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryCreate code========:" + code));
            }
            File file = new File(localPath);
            this.createFileAndDir(localPath, afc_c, libraryPath, file, file);
        }
    }

    private void createFileAndDir(String localPath, MDLibrary.afc_connection.ByReference afc_c, String libraryPath, File file, File project) {
        String dirPath = "";
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists() && !HMobileDeviceLauncher.isSpecName(project, f)) {
                    if (f.isFile()) {
                        this.createFile(localPath, afc_c, libraryPath, f);
                    } else {
                        byte[] filePByte;
                        byte[] fpathByte;
                        MDLibrary.afc_directory.ByReference afcd;
                        String path = f.getPath();
                        path = path.replace(localPath, "");
                        if ((path = path.replace("\\", "/")).startsWith("/")) {
                            path = path.substring(1);
                        }
                        if ((afcd = this.readDirectoryRef(afc_c, fpathByte = this.copyToByte(filePByte = (dirPath = String.valueOf(libraryPath) + path + "/").getBytes(Charset.forName("utf-8"))))) == null) {
                            int code = library.AFCDirectoryCreate(afc_c, fpathByte);
                            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryCreate code========:" + code));
                        }
                        this.createFileAndDir(localPath, afc_c, libraryPath, f, project);
                    }
                }
                ++n2;
            }
        }
    }

    private void createFile(String localPath, MDLibrary.afc_connection.ByReference afc_c, String libraryPath, File f) {
        if (f.getName().equals(".") || f.getName().equals("..")) {
            return;
        }
        String path = f.getPath();
        path = path.replace(localPath, "");
        if ((path = path.replace("\\", "/")).startsWith("/")) {
            path = path.replaceFirst("/", "");
        }
        this.createFile(afc_c, libraryPath, f, path, false, null);
    }

    private void createFile(MDLibrary.afc_connection.ByReference afc_c, String libraryPath, File f, String targetPath, boolean needFresh, Set<String> refrences) {
        String dirPath = String.valueOf(libraryPath) + targetPath;
        byte[] filePByte = dirPath.getBytes(Charset.forName("utf-8"));
        byte[] fpathByte = this.copyToByte(filePByte);
        byte[] fileByte = WinDeviceLibrary.getFileBytes(f);
        if (fileByte == null) {
            return;
        }
        MDLibrary.afc_file_ref.ByReference afc_file_ref2 = new MDLibrary.afc_file_ref.ByReference();
        long mode = 3L;
        int code = library.AFCFileRefOpen(afc_c, fpathByte, mode, afc_file_ref2);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefOpen code========:" + code));
        if (code != 0) {
            return;
        }
        code = library.AFCFileRefWrite(afc_c, afc_file_ref2._cnt, fileByte, fileByte.length);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefWrite code========:" + code));
        code = library.AFCFileRefClose(afc_c, afc_file_ref2._cnt);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefClose code========:" + code));
        if (needFresh) {
            this.wirteRefreshFile(afc_c, targetPath, libraryPath, refrences);
        }
    }

    @Override
    public void addAFCFileReadHandler(AFCConnection afc_connection2, String logFilePath, IApplicationLogHandler handler) throws OperateException {
        try {
            MDLibrary.afc_connection.ByReference afc_c = afc_connection2.getAfc_connection();
            byte[] filePByte = logFilePath.getBytes(Charset.forName("utf-8"));
            byte[] fpathByte = this.copyToByte(filePByte);
            MDLibrary.afc_file_ref.ByReference afc_file_ref2 = new MDLibrary.afc_file_ref.ByReference();
            long mode = 2L;
            CFDictionary[] cfDictionarys = new CFDictionary[]{new CFDictionary()};
            int code = library.AFCFileInfoOpen(afc_c, fpathByte, cfDictionarys);
            int length = 0;
            if (cfDictionarys != null && cfDictionarys[0] != null) {
                CFDictionary cfDictionary = cfDictionarys[0];
                MDLibrary.afc_directorys.ByReference[] afc_directorys2 = new MDLibrary.afc_directorys.ByReference[]{new MDLibrary.afc_directorys.ByReference()};
                MDLibrary.afc_directorys.ByReference[] keys = new MDLibrary.afc_directorys.ByReference[]{new MDLibrary.afc_directorys.ByReference()};
                code = library.AFCKeyValueRead(cfDictionary, keys, afc_directorys2);
                boolean isGeted = false;
                while (!isGeted) {
                    MDLibrary.afc_directorys.ByReference values;
                    if (keys != null && keys.length > 0) {
                        String key;
                        if (keys[0] == null || StringUtil.isBlank((String)(key = this.trimBytesToString(keys[0].paths)))) break;
                        if (key.equals("st_size")) {
                            isGeted = true;
                        }
                    }
                    if (afc_directorys2 != null && afc_directorys2.length > 0 && (values = afc_directorys2[0]) != null) {
                        String value = this.trimBytesToString(values.paths);
                        if (isGeted) {
                            length = Integer.parseInt(value) + 1;
                        }
                    }
                    code = library.AFCKeyValueRead(cfDictionary, keys, afc_directorys2);
                }
                library.AFCKeyValueClose(cfDictionary);
            }
            if (length < 1) {
                return;
            }
            code = library.AFCFileRefOpen(afc_c, fpathByte, mode, afc_file_ref2);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefOpen code========:" + code));
            if (code != 0) {
                return;
            }
            byte[] logContentBytes = new byte[length];
            MDLibrary.afc_file_ref.ByReference afc_file_length_ref = new MDLibrary.afc_file_ref.ByReference();
            afc_file_length_ref._cnt = length;
            code = library.AFCFileRefRead(afc_c, afc_file_ref2._cnt, logContentBytes, afc_file_length_ref);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefRead code========:" + code));
            code = library.AFCFileRefClose(afc_c, afc_file_ref2._cnt);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefClose code========:" + code));
            handler.readBytes(this.trimBytes(logContentBytes));
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    private void wirteRefreshFile(MDLibrary.afc_connection.ByReference afc_c, String targetPath, String filePath, Set<String> refrences) {
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"************\u5199\u5237\u65b0\u6587\u4ef6************");
        String fileName = String.valueOf(filePath) + ".debug/.debug";
        byte[] filePByte = fileName.getBytes(Charset.forName("utf-8"));
        byte[] pathBytes = this.copyToByte(filePByte);
        StringBuffer content = new StringBuffer();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        content.append("<root>\n");
        if (refrences == null || refrences.isEmpty()) {
            content.append("\t<item path=\"" + targetPath + "\"/>\n");
        } else {
            for (String refrence : refrences) {
                if (refrence.startsWith("/")) {
                    refrence = refrence.substring(1);
                }
                content.append("\t<item path=\"" + refrence + "\"/>\n");
            }
        }
        content.append("</root>");
        int code = library.AFCRemovePath(afc_c, pathBytes);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCRemovePath code========:" + code));
        if (code == 0 || code == 8) {
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u5220\u9664\u6587\u4ef6\u6210\u529f\u6216\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de");
        }
        byte[] contents = content.toString().getBytes(Charset.forName("utf-8"));
        MDLibrary.afc_file_ref.ByReference afc_file_ref2 = new MDLibrary.afc_file_ref.ByReference();
        long mode = 3L;
        code = library.AFCFileRefOpen(afc_c, pathBytes, mode, afc_file_ref2);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefOpen code========:" + code));
        if (code != 0) {
            return;
        }
        code = library.AFCFileRefWrite(afc_c, afc_file_ref2._cnt, contents, contents.length);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefWrite code========:" + code));
        code = library.AFCFileRefClose(afc_c, afc_file_ref2._cnt);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCFileRefClose code========:" + code));
    }

    private byte[] copyToByte(byte[] filePByte) {
        byte[] b = new byte[filePByte.length + 1];
        System.arraycopy(filePByte, 0, b, 0, filePByte.length);
        b[filePByte.length] = 0;
        return b;
    }

    public static byte[] getFileBytes(File file) {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(file);
            int size = fis.available();
            if (size > MAX_SIZE) {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7100M\uff0c\u540c\u6b65\u5931\u8d25\uff01");
                byte[] byArray = buffer;
                return byArray;
            }
            try {
                bos = new ByteArrayOutputStream(size);
                byte[] b = new byte[size];
                if (b.length > 0) {
                    int n;
                    while ((n = fis.read(b)) != -1) {
                        bos.write(b, 0, n);
                    }
                    buffer = bos.toByteArray();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    @Override
    public AFCConnection addStartHouseArrestServiceHandler(IDevice device, String serviceName) {
        CFType cft;
        WinDevice win = (WinDevice)device;
        MDLibrary.afc_connection.ByReference afc_service = new MDLibrary.afc_connection.ByReference();
        CFString service_name = CFString.buildString(serviceName);
        MDLibrary.am_device.ByReference re = win.getDev();
        String cfDir = String.valueOf(LibraryFinder.CORE_LIBRARY_DIR) + "\\";
        String cfPath = LibraryFinder.CORE_LIBRARY_PATH;
        String mdPath = LibraryFinder.MOBILE_DEVICE_LIBRARY_PATH;
        byte[] cfDirByte = this.getStringBytes(cfDir);
        byte[] cfPathByte = this.getStringBytes(cfPath);
        byte[] mdPathByte = this.getStringBytes(mdPath);
        int code = -1;
        if (PlatformUtil.isWindows()) {
            cft = LibraryInstance.getCTLibrary().DCAMDeviceStartHouseArrestServiceWin32(cfDirByte, cfPathByte, mdPathByte, re, service_name, afc_service, 0);
            if (cft != null) {
                code = 0;
                afc_service.handle = cft;
            }
        } else {
            cft = LibraryInstance.getCTLibrary().DCAMDeviceStartHouseArrestServiceMAC(cfDirByte, cfPathByte, mdPathByte, re, service_name, afc_service, 0);
            if (cft != null) {
                code = 0;
                afc_service.handle = cft;
            }
        }
        if (code != 0) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceStartHouseArrestService code======:" + code));
        }
        if (code == 0) {
            AFCConnection conn = new AFCConnection();
            conn.setAfc_connection(afc_service);
            return conn;
        }
        return null;
    }

    public byte[] getStringBytes(String str) {
        byte[] strByte = str.getBytes(Charset.forName("GB2312"));
        strByte = this.copyToByte(strByte);
        return strByte;
    }

    @Override
    public void addAFCRemovePathHandler(AFCConnection afc_connection2, String filePath, String appid, Set<String> refrences) throws OperateException {
        String libraryPath = this.getWWWDir(appid);
        String fPath = "";
        boolean isLogFile = filePath.startsWith("/Documents/Pandora/apps/");
        if (isLogFile) {
            fPath = filePath;
        } else {
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            fPath = String.valueOf(libraryPath) + filePath;
        }
        MDLibrary.afc_connection.ByReference afc_c = afc_connection2.getAfc_connection();
        try {
            byte[] filePByte = fPath.getBytes(Charset.forName("UTF-8"));
            byte[] pathBytes = this.copyToByte(filePByte);
            int code = library.AFCRemovePath(afc_c, pathBytes);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCRemovePath code========:" + code));
            if (code == 0 || code == 8) {
                HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u5220\u9664\u6587\u4ef6\u6210\u529f\u6216\u8005\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de");
                return;
            }
            this.readDirectoryAndRemove(afc_c, fPath);
        }
        finally {
            if (!isLogFile) {
                this.wirteRefreshFile(afc_c, filePath, libraryPath, refrences);
            }
        }
    }

    public String getWWWDir(String appid) {
        return "/Documents/Pandora/apps/" + appid + "/www/";
    }

    private void readDirectoryAndRemove(MDLibrary.afc_connection afcs, String filePath) {
        byte[] filePByte = filePath.getBytes(Charset.forName("UTF-8"));
        byte[] pathBytes = this.copyToByte(filePByte);
        MDLibrary.afc_directory.ByReference afcd = this.readDirectoryRef(afcs, pathBytes);
        if (afcd == null) {
            return;
        }
        List<String> dirList = this.readDirectory(afcs, afcd);
        int code = library.AFCDirectoryClose(afcs, afcd);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryClose code========:" + code));
        for (String dir : dirList) {
            if (StringUtil.isBlank((String)dir)) continue;
            String path = String.valueOf(filePath) + dir;
            byte[] filePathByte = path.getBytes(Charset.forName("UTF-8"));
            byte[] fpathBytes = this.copyToByte(filePathByte);
            code = library.AFCRemovePath(afcs, fpathBytes);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCRemovePath code========:" + code));
            if (code == 0 || code == 8) {
                HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u5220\u9664\u6587\u4ef6\u6210\u529f\u6216\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de");
                continue;
            }
            this.readDirectoryAndRemove(afcs, String.valueOf(path) + "/");
            code = library.AFCRemovePath(afcs, fpathBytes);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCRemovePath code========:" + code));
            if (code != 0 && code != 8) continue;
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u5220\u9664\u6587\u4ef6\u6210\u529f\u6216\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de");
        }
    }

    private MDLibrary.afc_directory.ByReference readDirectoryRef(MDLibrary.afc_connection afcs, byte[] filePByte) {
        MDLibrary.afc_directory.ByReference[] afc_directory2 = new MDLibrary.afc_directory.ByReference[]{new MDLibrary.afc_directory.ByReference()};
        int code = library.AFCDirectoryOpen(afcs, filePByte, afc_directory2);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AFCDirectoryOpen code========:" + code));
        if (code == 8) {
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728,\u76f4\u63a5\u8fd4\u56de.");
            return null;
        }
        if (code != 0) {
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"\u6253\u5f00\u76ee\u5f55\u5931\u8d25.");
            return null;
        }
        return afc_directory2[0];
    }

    private List<String> readDirectory(MDLibrary.afc_connection afcs, MDLibrary.afc_directory.ByReference afcd) {
        ArrayList<String> dirList = new ArrayList<String>();
        while (true) {
            MDLibrary.afc_directorys.ByReference[] afc_directorys2;
            int code;
            if ((code = library.AFCDirectoryRead(afcs, afcd, afc_directorys2 = new MDLibrary.afc_directorys.ByReference[]{new MDLibrary.afc_directorys.ByReference()})) != 0) {
                return null;
            }
            MDLibrary.afc_directorys.ByReference directorys = afc_directorys2[0];
            if (directorys == null) break;
            String dpath = this.trimBytesToString(directorys.paths);
            if (StringUtil.isBlank((String)dpath) || dpath.equals(".") || dpath.equals("..")) continue;
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)dpath);
            dirList.add(dpath);
        }
        return dirList;
    }

    private String trimBytesToString(byte[] paths) {
        byte[] tmp = this.trimBytes(paths);
        String name = new String(tmp, Charset.forName("UTF-8"));
        return name;
    }

    public byte[] trimBytes(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            return null;
        }
        ArrayList<Byte> list = new ArrayList<Byte>();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 0) break;
            list.add(b);
            ++n2;
        }
        byte[] tmp = new byte[list.size()];
        int i = 0;
        while (i < list.size()) {
            tmp[i] = (Byte)list.get(i);
            ++i;
        }
        return tmp;
    }

    @Override
    public void invoke(MDLibrary.am_device_notification_callback_info info, Pointer arg) {
        try {
            WinDevice device = new WinDevice(info.dev);
            String key = String.valueOf(info.dev.device_id);
            if (info.msg == 1) {
                if (this.handleConnect(info.dev, false)) {
                    PList plist = device.getDeviceInfo();
                    this.devices.put(key, plist);
                    this.handler.onDeviceConnected(device, plist);
                }
            } else if (info.msg == 2 || info.msg == 3) {
                PList deviceInfo = null;
                Set<String> set = this.devices.keySet();
                if (set.size() == 1) {
                    for (String integer : set) {
                        deviceInfo = this.devices.remove(integer);
                    }
                } else {
                    deviceInfo = this.devices.remove(key);
                }
                this.handler.onDeviceDisconnected(null, deviceInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getUUID(PList plist) {
        DictionaryElement dictionaryElement = plist.getValue();
        String uuid = dictionaryElement.get("UniqueDeviceID").asString();
        return uuid;
    }

    protected boolean handleConnect(MDLibrary.am_device.ByReference dev, boolean needThrow) throws OperateException {
        int code = library.AMDeviceConnect(dev);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceConnect code======:" + code));
        if (code != 0) {
            this.log.severe("Unable to connect to device [" + dev.device_id + "]");
            return false;
        }
        code = library.AMDeviceIsPaired(dev);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceIsPaired code======:" + code));
        if (code != 1) {
            this.log.severe("Unable to Paired device [" + dev.device_id + "]");
            if (needThrow) {
                throw new OperateException("\u8fde\u63a5\u8bbe\u5907\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u4e0a\u662f\u5426\u5df2\u4fe1\u4efb\u6b64\u7535\u8111\uff0c\u5982\u679c\u6ca1\u4fe1\u4efb\uff0c\u70b9\u51fb\u4fe1\u4efb\uff0c\u6216\u8005\u91cd\u65b0\u62d4\u63d2\u6570\u636e\u7ebf\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
            }
        }
        code = library.AMDeviceValidatePairing(dev);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceValidatePairing code======:" + code));
        if (code != 0) {
            this.log.severe("Unable to Validate Paired device [" + dev.device_id + "]");
            if (needThrow) {
                throw new OperateException("\u8fde\u63a5\u8bbe\u5907\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u4e0a\u662f\u5426\u5df2\u4fe1\u4efb\u6b64\u7535\u8111\uff0c\u5982\u679c\u6ca1\u4fe1\u4efb\uff0c\u70b9\u51fb\u4fe1\u4efb\uff0c\u6216\u8005\u91cd\u65b0\u62d4\u63d2\u6570\u636e\u7ebf\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
            }
        }
        code = library.AMDeviceStartSession(dev);
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceStartSession code======:" + code));
        if (code != 0) {
            this.log.severe("Unable to start session on device [" + dev.device_id + "]");
            if (needThrow) {
                throw new OperateException("\u8fde\u63a5\u8bbe\u5907\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u4e0a\u662f\u5426\u5df2\u4fe1\u4efb\u6b64\u7535\u8111\uff0c\u5982\u679c\u6ca1\u4fe1\u4efb\uff0c\u70b9\u51fb\u4fe1\u4efb\uff0c\u6216\u8005\u91cd\u65b0\u62d4\u63d2\u6570\u636e\u7ebf\uff0c\u5e76\u91cd\u65b0\u8fd0\u884c\u771f\u673a\u8c03\u8bd5\u3002", true);
            }
        }
        return true;
    }

    @Override
    public void handleDisconnect(IDevice device) {
        WinDevice winDevice = null;
        if (device instanceof WinDevice) {
            winDevice = (WinDevice)device;
            MDLibrary.am_device.ByReference dev = winDevice.getDev();
            int code = library.AMDeviceDisconnect(dev);
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)("AMDeviceDisconnect code======:" + code));
            if (code != 0) {
                this.log.severe("Unable to disconnect to device [" + dev.device_id + "]");
            }
        }
    }

    @Override
    public void handleConnect(IDevice device, boolean needCheck) throws OperateException {
        WinDevice winDevice = null;
        if (device instanceof WinDevice) {
            winDevice = (WinDevice)device;
            this.handleConnect(winDevice.getDev(), needCheck);
        }
    }

    private class InstallCallback
    implements MDLibrary.install_callback {
        IScheduleHandler iScheduleHandler;

        public InstallCallback(IScheduleHandler iScheduleHandler) {
            this.iScheduleHandler = iScheduleHandler;
        }

        @Override
        public void invoke(CFDictionary info, int arg) {
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"**************install******************");
            PList plist = info.toPlist();
            DictionaryElement dic = plist.getValue();
            String key = "PercentComplete";
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(Messages.WinDeviceLibrary_Install_Schedule) + WinDeviceLibrary.this.getValue(dic, key) + "%"));
            this.iScheduleHandler.scheduleHandlerHandler(String.valueOf(Messages.WinDeviceLibrary_Install_Schedule) + WinDeviceLibrary.this.getValue(dic, key) + "%");
        }
    }

    private class TransferCallback
    implements MDLibrary.transfer_callback {
        IScheduleHandler iScheduleHandler;

        public TransferCallback(IScheduleHandler iScheduleHandler) {
            this.iScheduleHandler = iScheduleHandler;
        }

        @Override
        public void invoke(CFDictionary info, int arg) {
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)"*************upload*******************");
            PList plist = info.toPlist();
            DictionaryElement dic = plist.getValue();
            String key = "PercentComplete";
            HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(Messages.WinDeviceLibrary_Upload_failed) + WinDeviceLibrary.this.getValue(dic, key)));
            this.iScheduleHandler.scheduleHandlerHandler(String.valueOf(Messages.WinDeviceLibrary_Upload_failed) + WinDeviceLibrary.this.getValue(dic, key) + "%");
        }
    }

    private class WinDfuDeviceConnectedCallback
    implements MDLibrary.am_restore_device_notification_callback {
        private WinDfuDeviceConnectedCallback() {
        }

        @Override
        public void invoke(MDLibrary.am_recovery_device rdev) {
        }
    }

    private class WinDfuDeviceDisconnectedCallback
    implements MDLibrary.am_restore_device_notification_callback {
        private WinDfuDeviceDisconnectedCallback() {
        }

        @Override
        public void invoke(MDLibrary.am_recovery_device rdev) {
        }
    }

    private class WinRecoveryDeviceConnectedCallback
    implements MDLibrary.am_restore_device_notification_callback {
        private WinRecoveryDeviceConnectedCallback() {
        }

        @Override
        public void invoke(MDLibrary.am_recovery_device rdev) {
        }
    }

    private class WinRecoveryDeviceDisconnectedCallback
    implements MDLibrary.am_restore_device_notification_callback {
        private WinRecoveryDeviceDisconnectedCallback() {
        }

        @Override
        public void invoke(MDLibrary.am_recovery_device rdev) {
        }
    }
}

