/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.jna.idevice.linux;

import com.pandora.launcher.core.iphone.jna.cf.LinPropertyList;
import com.pandora.launcher.core.iphone.jna.idevice.IDevice;
import com.pandora.launcher.core.iphone.jna.md.LinMDLibrary;
import com.pandora.launcher.core.iphone.util.plist.JPlistBuilder;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.util.logging.Logger;

public class LinuxDevice
implements IDevice {
    private Logger log = Logger.getLogger("LinuxDeviceLibrary");
    private LinMDLibrary.idevice_int device;
    private LinMDLibrary.lockdownd_client_int client;

    public LinuxDevice(LinMDLibrary.idevice_int device, LinMDLibrary.lockdownd_client_int client) {
        this.device = device;
        this.client = client;
    }

    @Override
    public void releaseDevice() {
        LinMDLibrary.INSTANCE.idevice_free(this.device);
    }

    @Override
    public PList getDeviceInfo() {
        LinPropertyList.pplist_t pplist;
        block3: {
            pplist = new LinPropertyList.pplist_t();
            try {
                if (LinMDLibrary.INSTANCE.lockdownd_get_value(this.client, null, null, pplist) == 0) break block3;
                this.log.severe("ERROR: get value...");
                return null;
            }
            catch (Exception exception) {
                LinPropertyList.INSTANCE.plist_free(pplist.getPList());
                return null;
            }
        }
        PointerByReference pxml = new PointerByReference();
        LinPropertyList.INSTANCE.plist_to_xml(pplist.getPList(), pxml, IntBuffer.allocate(1024768));
        String splist = pxml.getValue().getString(0L);
        return splist == null ? null : JPlistBuilder.buildPList(splist);
    }

    @Override
    public boolean enterRecovery() {
        try {
            LinMDLibrary.INSTANCE.lockdownd_enter_recovery(this.client);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

