/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing.lexer;

import com.aptana.editor.coffee.parsing.Terminals;
import com.aptana.editor.coffee.parsing.lexer.CoffeeSymbol;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CoffeeRewriter {
    private static Map<Short, Short> BALANCED_PAIRS = new HashMap<Short, Short>();
    private static Map<Short, Short> INVERSES;
    private static Set<Short> EXPRESSION_START;
    private static Set<Short> EXPRESSION_END;
    private static Set<Short> EXPRESSION_CLOSE;
    private static Set<Short> SINGLE_LINERS;
    private static Set<Short> SINGLE_CLOSERS;
    private static Set<Short> IMPLICIT_FUNC;
    private static Set<Short> IMPLICIT_CALL;
    private static Set<Short> IMPLICIT_UNSPACED_CALL;
    private static Set<Short> IMPLICIT_BLOCK;
    private static Set<Short> IMPLICIT_END;
    private static Set<Short> LINEBREAKS;
    private static Set<Short> CHECK_FOR_IMPLICIT_INDENTATION;
    private static Set<Short> IMPLICIT_PARENS_CHECK_1;
    private static Set<Short> IMPLICIT_PARENS_CHECK_2;
    private static Set<Short> IMPLICIT_BRACES;
    private List<CoffeeSymbol> fTokens;
    private boolean seenSingle;

    static {
        BALANCED_PAIRS.put((short)12, (short)60);
        BALANCED_PAIRS.put((short)9, (short)54);
        BALANCED_PAIRS.put((short)8, (short)69);
        BALANCED_PAIRS.put((short)35, (short)41);
        BALANCED_PAIRS.put((short)42, (short)63);
        BALANCED_PAIRS.put((short)25, (short)68);
        BALANCED_PAIRS.put((short)44, (short)52);
        INVERSES = new HashMap<Short, Short>();
        EXPRESSION_START = new HashSet<Short>();
        EXPRESSION_END = new HashSet<Short>();
        for (Map.Entry<Short, Short> entry : BALANCED_PAIRS.entrySet()) {
            Short left = entry.getKey();
            Short right = entry.getValue();
            INVERSES.put(right, left);
            INVERSES.put(left, right);
            EXPRESSION_START.add(left);
            EXPRESSION_END.add(right);
        }
        EXPRESSION_CLOSE = new HashSet<Short>();
        EXPRESSION_CLOSE.add((short)73);
        EXPRESSION_CLOSE.add((short)53);
        EXPRESSION_CLOSE.add((short)57);
        EXPRESSION_CLOSE.add((short)64);
        EXPRESSION_CLOSE.addAll(EXPRESSION_END);
        SINGLE_LINERS = new HashSet<Short>();
        SINGLE_LINERS.add((short)57);
        SINGLE_LINERS.add((short)20);
        SINGLE_LINERS.add((short)21);
        SINGLE_LINERS.add((short)27);
        SINGLE_LINERS.add((short)64);
        SINGLE_LINERS.add((short)74);
        SINGLE_CLOSERS = new HashSet<Short>();
        SINGLE_CLOSERS.add((short)43);
        SINGLE_CLOSERS.add((short)73);
        SINGLE_CLOSERS.add((short)64);
        SINGLE_CLOSERS.add((short)57);
        SINGLE_CLOSERS.add((short)41);
        SINGLE_CLOSERS.add((short)56);
        IMPLICIT_FUNC = new HashSet<Short>();
        IMPLICIT_FUNC.add((short)6);
        IMPLICIT_FUNC.add((short)16);
        IMPLICIT_FUNC.add((short)60);
        IMPLICIT_FUNC.add((short)63);
        IMPLICIT_FUNC.add((short)54);
        IMPLICIT_FUNC.add((short)52);
        IMPLICIT_FUNC.add((short)7);
        IMPLICIT_FUNC.add((short)17);
        IMPLICIT_CALL = new HashSet<Short>();
        IMPLICIT_CALL.add((short)6);
        IMPLICIT_CALL.add((short)10);
        IMPLICIT_CALL.add((short)11);
        IMPLICIT_CALL.add((short)13);
        IMPLICIT_CALL.add((short)14);
        IMPLICIT_CALL.add((short)75);
        IMPLICIT_CALL.add((short)25);
        IMPLICIT_CALL.add((short)26);
        IMPLICIT_CALL.add((short)19);
        IMPLICIT_CALL.add((short)27);
        IMPLICIT_CALL.add((short)24);
        IMPLICIT_CALL.add((short)17);
        IMPLICIT_CALL.add((short)15);
        IMPLICIT_CALL.add((short)32);
        IMPLICIT_CALL.add((short)16);
        IMPLICIT_CALL.add((short)7);
        IMPLICIT_CALL.add((short)20);
        IMPLICIT_CALL.add((short)21);
        IMPLICIT_CALL.add((short)9);
        IMPLICIT_CALL.add((short)12);
        IMPLICIT_CALL.add((short)8);
        IMPLICIT_CALL.add((short)22);
        IMPLICIT_CALL.add((short)23);
        IMPLICIT_UNSPACED_CALL = new HashSet<Short>();
        IMPLICIT_UNSPACED_CALL.add((short)2);
        IMPLICIT_UNSPACED_CALL.add((short)1);
        IMPLICIT_BLOCK = new HashSet<Short>();
        IMPLICIT_BLOCK.add((short)20);
        IMPLICIT_BLOCK.add((short)21);
        IMPLICIT_BLOCK.add((short)8);
        IMPLICIT_BLOCK.add((short)9);
        IMPLICIT_BLOCK.add((short)47);
        IMPLICIT_END = new HashSet<Short>();
        IMPLICIT_END.add((short)40);
        IMPLICIT_END.add((short)5);
        IMPLICIT_END.add((short)3);
        IMPLICIT_END.add((short)4);
        IMPLICIT_END.add((short)53);
        IMPLICIT_END.add((short)62);
        IMPLICIT_END.add((short)31);
        IMPLICIT_END.add((short)43);
        IMPLICIT_END.add((short)35);
        LINEBREAKS = new HashSet<Short>();
        LINEBREAKS.add((short)43);
        LINEBREAKS.add((short)35);
        LINEBREAKS.add((short)41);
        CHECK_FOR_IMPLICIT_INDENTATION = new HashSet<Short>();
        CHECK_FOR_IMPLICIT_INDENTATION.add((short)41);
        CHECK_FOR_IMPLICIT_INDENTATION.add((short)43);
        CHECK_FOR_IMPLICIT_INDENTATION.add((short)64);
        IMPLICIT_PARENS_CHECK_1 = new HashSet<Short>();
        IMPLICIT_PARENS_CHECK_1.add((short)19);
        IMPLICIT_PARENS_CHECK_1.add((short)57);
        IMPLICIT_PARENS_CHECK_1.add((short)20);
        IMPLICIT_PARENS_CHECK_1.add((short)21);
        IMPLICIT_PARENS_CHECK_2 = new HashSet<Short>();
        IMPLICIT_PARENS_CHECK_2.add((short)48);
        IMPLICIT_PARENS_CHECK_2.add((short)49);
        IMPLICIT_PARENS_CHECK_2.add((short)50);
        IMPLICIT_BRACES = new HashSet<Short>();
        IMPLICIT_BRACES.add((short)6);
        IMPLICIT_BRACES.add((short)10);
        IMPLICIT_BRACES.add((short)11);
        IMPLICIT_BRACES.add((short)7);
        IMPLICIT_BRACES.add((short)43);
        IMPLICIT_BRACES.add((short)41);
    }

    List<CoffeeSymbol> rewrite(List<CoffeeSymbol> tokens) {
        this.fTokens = tokens;
        this.removeLeadingNewlines();
        this.removeMidExpressionNewlines();
        this.closeOpenCalls();
        this.closeOpenIndexes();
        this.addImplicitIndentation();
        this.tagPostfixConditionals();
        this.addImplicitBraces();
        this.addImplicitParentheses();
        this.ensureBalance(BALANCED_PAIRS);
        this.rewriteClosingParens();
        return this.fTokens;
    }

    private void removeLeadingNewlines() {
        while (!this.fTokens.isEmpty()) {
            CoffeeSymbol sym = this.fTokens.get(0);
            if (43 != sym.getId()) break;
            this.fTokens.remove(0);
        }
    }

    private void removeMidExpressionNewlines() {
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol sym = this.fTokens.get(i);
            CoffeeSymbol next = null;
            if (i + 1 < this.fTokens.size()) {
                next = this.fTokens.get(i + 1);
            }
            if (sym.getId() == 43 && next != null && EXPRESSION_CLOSE.contains(next.getId())) {
                this.fTokens.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void closeOpenCalls() {
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol sym = this.fTokens.get(i);
            if (42 == sym.getId()) {
                int levels = 0;
                int j = i + 1;
                while (j < this.fTokens.size()) {
                    int index;
                    CoffeeSymbol token = this.fTokens.get(j);
                    if (levels == 0 && (token.getId() == 60 || token.getId() == 63 || token.getId() == 41 && this.fTokens.get(j - 1).getId() == 60)) {
                        index = token.getId() == 41 ? j - 1 : j;
                        this.fTokens.get(index).setId((short)63);
                        break;
                    }
                    if (token == null || levels < 0) {
                        index = token.getId() == 41 ? j - 2 : j - 1;
                        this.fTokens.get(index).setId((short)63);
                        break;
                    }
                    if (EXPRESSION_START.contains(token.getId())) {
                        ++levels;
                    } else if (EXPRESSION_END.contains(token.getId())) {
                        --levels;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void closeOpenIndexes() {
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol sym = this.fTokens.get(i);
            if (44 == sym.getId()) {
                int levels = 0;
                int j = i + 1;
                while (j < this.fTokens.size()) {
                    CoffeeSymbol token = this.fTokens.get(j);
                    if (levels == 0 && (token.getId() == 54 || token.getId() == 52)) {
                        token.setId((short)52);
                        break;
                    }
                    if (token == null || levels < 0) {
                        token.setId((short)52);
                        break;
                    }
                    if (EXPRESSION_START.contains(token.getId())) {
                        ++levels;
                    } else if (EXPRESSION_END.contains(token.getId())) {
                        --levels;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addImplicitBraces() {
        Stack<CoffeeSymbol> stack = new Stack<CoffeeSymbol>();
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol token = this.fTokens.get(i);
            if (EXPRESSION_START.contains(token.getId())) {
                int id = 35 == token.getId() && 8 == this.fTokens.get(i - 1).getId() ? 8 : token.getId();
                stack.add(new CoffeeSymbol((short)id, i));
                ++i;
                continue;
            }
            if (EXPRESSION_END.contains(token.getId())) {
                stack.pop();
                ++i;
                continue;
            }
            int endOfStack = -1;
            if (!stack.isEmpty()) {
                endOfStack = ((CoffeeSymbol)((Object)stack.get(stack.size() - 1))).getId();
            }
            if (72 != token.getId() || (i < 2 || 72 != this.fTokens.get(i - 2).getId()) && 8 == endOfStack) {
                ++i;
                continue;
            }
            stack.push(new CoffeeSymbol(8, "{"));
            int idx = i >= 2 && 7 == this.fTokens.get(i - 2).getId() ? i - 2 : i - 1;
            while (idx >= 2 && this.fTokens.get(idx - 2).getId() == 18) {
                idx -= 2;
            }
            int offsetToUse = 0;
            if (idx >= 1) {
                CoffeeSymbol replacing = this.fTokens.get(idx - 1);
                offsetToUse = replacing.getEnd();
            }
            CoffeeSymbol tok = new CoffeeSymbol(8, offsetToUse, offsetToUse, "{");
            tok.generated = true;
            this.fTokens.add(idx, tok);
            int levels = 0;
            int j = i + 2;
            while (j < this.fTokens.size()) {
                CoffeeSymbol toAdd;
                CoffeeSymbol innerToken = this.fTokens.get(j);
                if (levels == 0 && this.addImplicitBrace(innerToken, j)) {
                    toAdd = new CoffeeSymbol(69, innerToken.getStart(), innerToken.getStart(), "}");
                    toAdd.generated = true;
                    this.fTokens.add(j, toAdd);
                    break;
                }
                if (innerToken == null || levels < 0) {
                    toAdd = new CoffeeSymbol(69, innerToken.getStart(), innerToken.getStart(), "}");
                    toAdd.generated = true;
                    this.fTokens.add(j, toAdd);
                    break;
                }
                if (EXPRESSION_START.contains(innerToken.getId())) {
                    ++levels;
                } else if (EXPRESSION_END.contains(innerToken.getId())) {
                    --levels;
                }
                ++j;
            }
            i += 2;
        }
    }

    private boolean addImplicitBrace(CoffeeSymbol token, int i) {
        Short oneId = -1;
        if (i + 1 < this.fTokens.size()) {
            oneId = this.fTokens.get(i + 1).getId();
        }
        if (18 == oneId) {
            return false;
        }
        short tag = token.getId();
        Short twoId = -2;
        if (i + 2 < this.fTokens.size()) {
            twoId = this.fTokens.get(i + 2).getId();
        }
        Short threeId = -3;
        if (i + 3 < this.fTokens.size()) {
            threeId = this.fTokens.get(i + 3).getId();
        }
        return (43 == tag || 41 == tag) && 72 != twoId && (7 != oneId || 72 != threeId) || 47 == tag && !IMPLICIT_BRACES.contains(oneId);
    }

    private List<CoffeeSymbol> indentation(CoffeeSymbol token) {
        ArrayList<CoffeeSymbol> symbols = new ArrayList<CoffeeSymbol>();
        symbols.add(new CoffeeSymbol(35, token.getEnd(), token.getEnd(), 2));
        symbols.add(new CoffeeSymbol(41, token.getEnd(), token.getEnd(), 2));
        return symbols;
    }

    private void addImplicitIndentation() {
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol token = this.fTokens.get(i);
            short tag = token.getId();
            if (43 == tag && i + 1 < this.fTokens.size() && 74 == this.fTokens.get(i + 1).getId()) {
                this.fTokens.remove(i);
                continue;
            }
            if (57 == tag && 41 != this.fTokens.get(i - 1).getId()) {
                this.fTokens.addAll(i, this.indentation(token));
                i += 2;
                continue;
            }
            if (73 == tag && CHECK_FOR_IMPLICIT_INDENTATION.contains(this.fTokens.get(i + 2).getId())) {
                this.fTokens.addAll(i + 2, this.indentation(token));
                i += 4;
                continue;
            }
            if (SINGLE_LINERS.contains(tag) && 35 != this.fTokens.get(i + 1).getId() && (57 != tag || 19 != this.fTokens.get(i + 1).getId())) {
                short starter = tag;
                List<CoffeeSymbol> indents = this.indentation(token);
                CoffeeSymbol indent = indents.get(0);
                CoffeeSymbol outdent = indents.get(1);
                indent.fromThen = 74 == starter;
                indent.generated = true;
                outdent.generated = true;
                this.fTokens.add(i + 1, indent);
                int levels = 0;
                int j = i + 2;
                while (j < this.fTokens.size()) {
                    int index;
                    CoffeeSymbol innerToken = this.fTokens.get(j);
                    if (levels == 0 && this.addImplicitIndent(innerToken, starter, j)) {
                        index = j;
                        if (47 == this.fTokens.get(j - 1).getId()) {
                            index = j - 1;
                        }
                        outdent.setLocation(innerToken.getEnd(), innerToken.getEnd());
                        this.fTokens.add(index, outdent);
                        break;
                    }
                    if (innerToken == null || levels < 0) {
                        index = j;
                        if (47 == this.fTokens.get(j - 1).getId()) {
                            index = j - 1;
                        }
                        outdent.setLocation(innerToken.getEnd(), innerToken.getEnd());
                        this.fTokens.add(index, outdent);
                        break;
                    }
                    if (EXPRESSION_START.contains(innerToken.getId())) {
                        ++levels;
                    } else if (EXPRESSION_END.contains(innerToken.getId())) {
                        --levels;
                    }
                    ++j;
                }
                if (74 == tag) {
                    this.fTokens.remove(i);
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    private boolean addImplicitIndent(CoffeeSymbol token, short starter, int i) {
        HashSet<Short> toCheck = new HashSet<Short>();
        toCheck.add((short)19);
        toCheck.add((short)74);
        return !";".equals(token.getValue()) && SINGLE_CLOSERS.contains(token.getId()) && (57 != token.getId() || toCheck.contains(starter));
    }

    private void addImplicitParentheses() {
        boolean noCall = false;
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol token = this.fTokens.get(i);
            short tag = token.getId();
            if (26 == tag || 19 == tag) {
                noCall = true;
            }
            CoffeeSymbol prev = null;
            if (i - 1 >= 0) {
                prev = this.fTokens.get(i - 1);
            }
            CoffeeSymbol next = null;
            if (i + 1 < this.fTokens.size()) {
                next = this.fTokens.get(i + 1);
            }
            boolean callObject = !noCall && 35 == tag && next != null && next.generated && 8 == next.getId() && prev != null && IMPLICIT_FUNC.contains(prev.getId());
            this.seenSingle = false;
            if (LINEBREAKS.contains(tag)) {
                noCall = false;
            }
            if (prev != null && !prev.spaced && 33 == tag) {
                token.call = true;
            }
            if (token.fromThen) {
                ++i;
                continue;
            }
            if (!(callObject || prev != null && prev.spaced && (prev.call || IMPLICIT_FUNC.contains(prev.getId())) && (IMPLICIT_CALL.contains(tag) || !token.spaced && !token.newLine && IMPLICIT_UNSPACED_CALL.contains(tag)))) {
                ++i;
                continue;
            }
            this.fTokens.add(i, new CoffeeSymbol(42, token.getStart(), token.getStart(), "("));
            int levels = 0;
            int j = i + 1;
            while (j < this.fTokens.size()) {
                int idx;
                CoffeeSymbol innerToken = this.fTokens.get(j);
                if (levels == 0 && this.addImplicitParens(innerToken, j)) {
                    idx = 41 == innerToken.getId() ? j + 1 : j;
                    this.fTokens.add(idx, new CoffeeSymbol(63, innerToken.getEnd(), innerToken.getEnd(), ")"));
                    break;
                }
                if (innerToken == null || levels < 0) {
                    idx = 41 == innerToken.getId() ? j + 1 : j;
                    this.fTokens.add(idx, new CoffeeSymbol(63, innerToken.getEnd(), innerToken.getEnd(), ")"));
                    break;
                }
                if (EXPRESSION_START.contains(innerToken.getId())) {
                    ++levels;
                } else if (EXPRESSION_END.contains(innerToken.getId())) {
                    --levels;
                }
                ++j;
            }
            if (33 == prev.getId()) {
                prev.setId((short)51);
            }
            i += 2;
        }
    }

    private boolean addImplicitParens(CoffeeSymbol token, int i) {
        if (!this.seenSingle && token.fromThen) {
            return true;
        }
        short tag = token.getId();
        if (IMPLICIT_PARENS_CHECK_1.contains(tag)) {
            this.seenSingle = true;
        }
        CoffeeSymbol prev = null;
        if (i - 1 >= 0) {
            prev = this.fTokens.get(i - 1);
        }
        if (IMPLICIT_PARENS_CHECK_2.contains(tag) && prev != null && 41 == prev.getId()) {
            return true;
        }
        CoffeeSymbol post = null;
        if (i + 1 < this.fTokens.size()) {
            post = this.fTokens.get(i + 1);
        }
        return !token.generated && 47 != prev.getId() && IMPLICIT_END.contains(tag) && (35 != tag || 26 != this.fTokens.get(i - 2).getId() && !IMPLICIT_BLOCK.contains(prev.getId()) && (post == null || !post.generated || 8 != post.getId()));
    }

    private void tagPostfixConditionals() {
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol token = this.fTokens.get(i);
            if (19 != token.getId()) {
                ++i;
                continue;
            }
            int levels = 0;
            int j = i + 1;
            while (j < this.fTokens.size()) {
                CoffeeSymbol innerToken = this.fTokens.get(j);
                if (levels == 0 && (43 == innerToken.getId() || 35 == innerToken.getId())) {
                    if (35 == innerToken.getId()) break;
                    token.setId((short)40);
                    break;
                }
                if (innerToken == null || levels < 0) {
                    if (35 == innerToken.getId()) break;
                    token.setId((short)40);
                    break;
                }
                if (EXPRESSION_START.contains(innerToken.getId())) {
                    ++levels;
                } else if (EXPRESSION_END.contains(innerToken.getId())) {
                    --levels;
                }
                ++j;
            }
            ++i;
        }
    }

    private void ensureBalance(Map<Short, Short> pairs) {
        HashMap<Short, Integer> levels = new HashMap<Short, Integer>();
        HashMap<Short, Integer> openLine = new HashMap<Short, Integer>();
        for (CoffeeSymbol coffeeSymbol : this.fTokens) {
            for (Map.Entry<Short, Short> pair : pairs.entrySet()) {
                int level;
                short open = pair.getKey();
                short close = pair.getValue();
                if (!levels.containsKey(open)) {
                    levels.put(open, 0);
                }
                if (open == coffeeSymbol.getId()) {
                    level = (Integer)levels.get(open);
                    if (level == 0) {
                        openLine.put(open, coffeeSymbol.getStart());
                    }
                    levels.put(open, ++level);
                    continue;
                }
                if (close != coffeeSymbol.getId()) continue;
                level = (Integer)levels.get(open);
                levels.put(open, --level);
                if (level >= 0) continue;
                throw new IllegalStateException(MessageFormat.format("too many {0} at offset {1}", this.getTerminalNameForShort(close), coffeeSymbol.getStart()));
            }
        }
        for (Map.Entry entry : levels.entrySet()) {
            Integer level = (Integer)entry.getValue();
            if (level <= 0) continue;
            Short open = (Short)entry.getKey();
            throw new IllegalStateException(MessageFormat.format("unclosed {0} at offset {1}", this.getTerminalNameForShort(open), openLine.get(open)));
        }
    }

    private String getTerminalNameForShort(Short id) {
        return Terminals.getNameForValue(id);
    }

    private void rewriteClosingParens() {
        Stack<CoffeeSymbol> stack = new Stack<CoffeeSymbol>();
        HashMap<Short, Integer> debt = new HashMap<Short, Integer>();
        for (Short key : INVERSES.keySet()) {
            debt.put(key, 0);
        }
        int i = 0;
        while (i < this.fTokens.size()) {
            CoffeeSymbol token = this.fTokens.get(i);
            short tag = token.getId();
            if (EXPRESSION_START.contains(tag)) {
                stack.push(token);
                ++i;
                continue;
            }
            if (!EXPRESSION_END.contains(tag)) {
                ++i;
                continue;
            }
            Short inv = INVERSES.get(tag);
            int invValue = (Integer)debt.get(inv);
            if (invValue > 0) {
                debt.put(inv, --invValue);
                this.fTokens.remove(i);
                continue;
            }
            CoffeeSymbol match = (CoffeeSymbol)((Object)stack.pop());
            short mtag = match.getId();
            short oppos = INVERSES.get(mtag);
            if (tag == oppos) {
                ++i;
                continue;
            }
            int mtagValue = (Integer)debt.get(mtag);
            debt.put(mtag, ++mtagValue);
            CoffeeSymbol val = new CoffeeSymbol(oppos, token.getStart(), token.getStart(), 35 == mtag ? match.getValue() : Terminals.getValue(oppos));
            if (mtag == this.fTokens.get(i + 2).getId()) {
                this.fTokens.add(i + 3, val);
                stack.push(match);
            } else {
                this.fTokens.add(i, val);
            }
            ++i;
        }
    }
}

