/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.outline;

import com.aptana.editor.coffee.CoffeeScriptEditorPlugin;
import com.aptana.editor.coffee.parsing.ast.CoffeeAccessNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeArrNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeAssignNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeClassNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCodeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeLiteralNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeObjNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeParamNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeValueNode;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CommonOutlineLabelProvider;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.swt.graphics.Image;

public class CoffeeOutlineLabelProvider
extends CommonOutlineLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getImage(((CommonOutlineItem)element).getReferenceNode());
        }
        if (element instanceof CoffeeCodeNode) {
            return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/js_function.png");
        }
        if (element instanceof CoffeeObjNode) {
            return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/object-literal.png");
        }
        if (element instanceof CoffeeClassNode) {
            return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/class_obj.png");
        }
        if (element instanceof CoffeeArrNode) {
            return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/array-literal.png");
        }
        if (element instanceof CoffeeAssignNode) {
            String text;
            CoffeeAssignNode assign = (CoffeeAssignNode)((Object)element);
            if (assign.isFunctionDeclaration()) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/js_function.png");
            }
            if (assign.isObjectProperty()) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/js_property.png");
            }
            IParseNode assignable = assign.getChild(0);
            if (assignable.getChildCount() == 2 && (text = this.getText(assignable.getChild(0))).equals("this")) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/js_property.png");
            }
            return this.getImage(assign.getChild(1));
        }
        if (element instanceof CoffeeValueNode) {
            return this.getImage(((CoffeeValueNode)((Object)element)).getChild(0));
        }
        if (element instanceof CoffeeLiteralNode) {
            CoffeeLiteralNode literal = (CoffeeLiteralNode)((Object)element);
            String literalValue = literal.getText();
            if (literalValue != null && (literalValue.startsWith("\"") || literalValue.startsWith("'"))) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/string.png");
            }
            if ("null".equals(literalValue) || "undefined".equals(literalValue)) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/null.png");
            }
            if ("true".equals(literalValue) || "false".equals(literalValue) || "yes".equals(literalValue) || "on".equals(literalValue) || "off".equals(literalValue) || "no".equals(literalValue)) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/boolean.png");
            }
            boolean isNumber = false;
            try {
                Float.parseFloat(literalValue);
                isNumber = true;
            }
            catch (Exception exception) {}
            if (isNumber) {
                return CoffeeScriptEditorPlugin.getDefault().getImageRegistry().get("icons/number.png");
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getText(((CommonOutlineItem)element).getReferenceNode());
        }
        if (element instanceof CoffeeClassNode) {
            CoffeeClassNode node = (CoffeeClassNode)((Object)element);
            return node.determineName();
        }
        if (element instanceof CoffeeAccessNode) {
            CoffeeAccessNode node = (CoffeeAccessNode)((Object)element);
            return this.getText(node.getChild(0));
        }
        if (element instanceof CoffeeAssignNode) {
            IParseNode expression;
            CoffeeAssignNode node = (CoffeeAssignNode)((Object)element);
            IParseNode assignable = node.getChild(0);
            String text = this.getText(assignable);
            if ("this".equals(text)) {
                text = "@" + this.getText(assignable.getChild(1));
            } else if (node.getChildCount() > 1 && (expression = node.getChild(1)) instanceof CoffeeCodeNode) {
                text = String.valueOf(text) + this.getText(expression);
            }
            return text;
        }
        if (element instanceof CoffeeValueNode) {
            CoffeeValueNode node = (CoffeeValueNode)((Object)element);
            return this.getText(node.getChild(0));
        }
        if (element instanceof CoffeeCodeNode) {
            CoffeeCodeNode node = (CoffeeCodeNode)((Object)element);
            StringBuilder builder = new StringBuilder("(");
            int i = 0;
            while (i < node.getChildCount() - 1) {
                builder.append(this.getText(node.getChild(i)));
                if (i != node.getChildCount() - 2) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append(")");
            return builder.toString();
        }
        if (element instanceof CoffeeParamNode) {
            CoffeeParamNode param = (CoffeeParamNode)((Object)element);
            return this.getText(param.getChild(0));
        }
        if (element instanceof CoffeeNode) {
            CoffeeNode node = (CoffeeNode)((Object)element);
            return node.getText();
        }
        return super.getText(element);
    }
}

