/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.internal.build;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.coffee.parsing.ast.CoffeeCommentNode;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class CoffeeTaskDetector
extends RequiredBuildParticipant {
    private static final String COMMENT_ENDING = "###";

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        if (!context.isFullBuild() && !context.isSave()) {
            return;
        }
        Collection<IProblem> tasks = this.detectTasks(context, monitor);
        context.putProblems("com.aptana.core.task", tasks);
    }

    private Collection<IProblem> detectTasks(BuildContext context, IProgressMonitor monitor) {
        IParseRootNode rootNode = null;
        try {
            rootNode = context.getAST();
        }
        catch (CoreException coreException) {}
        if (rootNode == null) {
            return Collections.emptyList();
        }
        Object[] comments = rootNode.getCommentNodes();
        if (ArrayUtil.isEmpty((Object[])comments)) {
            return Collections.emptyList();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)comments.length);
        ArrayList<IProblem> tasks = new ArrayList<IProblem>(comments.length);
        Document source = new Document(context.getContents());
        String filePath = context.getURI().toString();
        int i = 0;
        Object[] objectArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            Object commentNode = objectArray[n2];
            if (context.isNeedSleep()) {
                BuildHelper.sleepLoop((String)"TASK_TYPE", (int)(++i));
            }
            if (commentNode instanceof CoffeeCommentNode) {
                tasks.addAll(this.processCommentNode(filePath, (IDocument)source, 0, (IParseNode)commentNode, COMMENT_ENDING, context.isNeedSleep()));
            }
            sub.worked(1);
            ++n2;
        }
        sub.done();
        return tasks;
    }
}

