/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.CloseWindowEvent;
import com.pandora.cef3.OpenWindowEvent;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.eclipse.swt.events.TypedEvent;

final class LifeSpanHandler
extends CefLifeSpanHandlerAdapter {
    private final CEF3Browser browser;
    private boolean sentCloseEvent = false;

    public LifeSpanHandler(CEF3Browser browser) {
        this.browser = browser;
    }

    @Override
    public boolean onBeforePopup(CefBrowser browser, String target_url, String target_frame_name) {
        if (this.browser.isSame(browser)) {
            OpenWindowEvent event = new OpenWindowEvent(this.browser);
            event.required = true;
            event.location = target_url;
            this.browser.notifyListeners((TypedEvent)event);
        }
        return true;
    }

    @Override
    public void onAfterCreated(CefBrowser cefBrowser) {
        this.browser.onCreated(cefBrowser);
    }

    @Override
    public boolean runModal(CefBrowser cefBrowser) {
        return false;
    }

    @Override
    public boolean doClose(CefBrowser cefBrowser) {
        CloseWindowEvent event = new CloseWindowEvent(this.browser);
        event.browser = this.browser;
        this.browser.notifyListeners((TypedEvent)event);
        this.sentCloseEvent = true;
        return event.doit;
    }

    @Override
    public void onBeforeClose(CefBrowser cefBrowser) {
        this.browser.onClose();
        if (this.sentCloseEvent) {
            return;
        }
        CloseWindowEvent event = new CloseWindowEvent(this.browser);
        event.browser = this.browser;
        this.browser.notifyListeners((TypedEvent)event);
    }
}

