/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.listener.ConsoleMessageEvent;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Widget;

final class DisplayHandler
extends CefDisplayHandlerAdapter {
    private final CEF3Browser browser;

    public DisplayHandler(CEF3Browser browser) {
        this.browser = browser;
    }

    @Override
    public void onAddressChange(CefBrowser browser, String url) {
        if ("about:blank".equals(url)) {
            return;
        }
        LocationEvent event = new LocationEvent((Widget)this.browser);
        event.location = url;
        event.top = !browser.isPopup();
        this.browser.notifyListeners((TypedEvent)event);
    }

    @Override
    public void onTitleChange(CefBrowser cefBrowser, String title) {
        if ("about:blank".equals(cefBrowser.getURL())) {
            return;
        }
        TitleEvent event = new TitleEvent((Widget)this.browser);
        event.title = title;
        this.browser.notifyListeners((TypedEvent)event);
    }

    @Override
    public boolean onConsoleMessage(CefBrowser cefBrowser, String message, String source, int line) {
        try {
            ConsoleMessageEvent event = new ConsoleMessageEvent(this.browser);
            event.message = message;
            event.source = source;
            event.line = line;
            this.browser.notifyListeners(event);
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return false;
    }
}

