/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.browser.remote.debug.RemoteDebugClient;
import com.pandora.cef3.BrowserFunction;
import com.pandora.cef3.BrowserFunctionCallback;
import com.pandora.cef3.BrowserFunctionRouterHandler;
import com.pandora.cef3.CloseWindowEvent;
import com.pandora.cef3.DevToolsDialog;
import com.pandora.cef3.DisplayHandler;
import com.pandora.cef3.FocusHandler;
import com.pandora.cef3.JSDialogHandler;
import com.pandora.cef3.KeyboardHandler;
import com.pandora.cef3.LifeSpanHandler;
import com.pandora.cef3.ListenerList;
import com.pandora.cef3.LoadHandler;
import com.pandora.cef3.LocationChangingEvent;
import com.pandora.cef3.MenuHandler;
import com.pandora.cef3.OSHelper;
import com.pandora.cef3.OpenWindowEvent;
import com.pandora.cef3.RequestHandler;
import com.pandora.cef3.listener.ConsoleMessageEvent;
import com.pandora.cef3.listener.ConsoleMessageListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefStringVisitor;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public final class CEF3Browser
extends Composite {
    static final String URL_BLANK = "about:blank";
    private static final String URL_TEXT = "html:internal";
    private static final String URL_SCRIPT = "javascript:";
    private static final String ERROR_ID = "com.hbuilder.swt.cef3.error";
    private static boolean hasCreateBrowser = false;
    private static Shell defaultBrowser;
    private Set<ShellListener> devToolShellListeners = new HashSet<ShellListener>();
    private CefClient browserClient;
    private CefBrowser cefBrowser;
    private BrowserFunctionRouterHandler browserFunctionRouterHandler;
    private String loadURL;
    private String loadText;
    private CefRequest loadRequest;
    private static int remoteDebuggingPort;
    private boolean enableDefaultMenu = true;
    private boolean enableDevTools;
    DevToolsDialog devToolsDialog = null;
    private String loadingURL = null;
    private ListenerList<CloseWindowListener> closeWindowListeners = new ListenerList<CloseWindowListener>(CloseWindowListener.class);
    private ListenerList<LocationListener> locationListeners = new ListenerList<LocationListener>(LocationListener.class);
    private ListenerList<OpenWindowListener> openWindowListeners = new ListenerList<OpenWindowListener>(OpenWindowListener.class);
    private ListenerList<ProgressListener> progressListeners = new ListenerList<ProgressListener>(ProgressListener.class);
    private ListenerList<StatusTextListener> statusTextListeners = new ListenerList<StatusTextListener>(StatusTextListener.class);
    private ListenerList<TitleListener> titleListeners = new ListenerList<TitleListener>(TitleListener.class);
    private ListenerList<ConsoleMessageListener> consoleMessageListeners = new ListenerList<ConsoleMessageListener>(ConsoleMessageListener.class);
    private static boolean hasInited;

    static {
        remoteDebuggingPort = -1;
        hasInited = false;
    }

    public CEF3Browser(Composite parent, int style) {
        super(parent, 0x1000000);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.init();
    }

    protected void checkWidget() {
        super.checkWidget();
    }

    public int getRemoteDebuggingPort() {
        return remoteDebuggingPort;
    }

    boolean isSame(CefBrowser cefBrowser) {
        return this.cefBrowser == null || !this.cefBrowser.equals(cefBrowser);
    }

    private void createBrowser() {
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.cefBrowser = this.browserClient.createBrowser(this.loadURL != null ? this.loadURL : URL_BLANK, OS.isLinux(), false);
        frame.add(this.cefBrowser.getUIComponent());
    }

    void createFunction(BrowserFunction function) {
        this.registerFunction(function);
    }

    void destroyFunction(BrowserFunction function) {
        this.deregisterFunction(function);
    }

    private void registerFunction(BrowserFunction function) {
        this.browserFunctionRouterHandler.addBrowserFunction(function);
    }

    private void deregisterFunction(BrowserFunction function) {
        this.browserFunctionRouterHandler.removeBrowserFunction(function);
    }

    private void ensureBrowser() {
        if (this.cefBrowser == null) {
            this.createBrowser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCEF() {
        String string = ERROR_ID;
        synchronized (ERROR_ID) {
            if (!hasInited) {
                remoteDebuggingPort = CEF3Browser.findFreePort(9222);
                HBLog.logError((Plugin)Activator.getDefault(), (String)("remote-debugging-port == " + remoteDebuggingPort));
                CefApp.getInstance(new String[]{"-remote-debugging-port=" + remoteDebuggingPort, "-log-severity=disable", "-lang=zh-CH", "-proxy-server"});
                hasInited = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void init() {
        CEF3Browser.initCEF();
        if (!hasCreateBrowser && defaultBrowser == null || defaultBrowser != null && defaultBrowser.isDisposed()) {
            UIJob job = new UIJob("create default browser"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        defaultBrowser = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 524296);
                        defaultBrowser.setSize(1, 1);
                        defaultBrowser.setLayout((Layout)new FillLayout());
                        CEF3Browser browser = new CEF3Browser((Composite)defaultBrowser, 0);
                        browser.setUrl(CEF3Browser.URL_BLANK);
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        OSHelper.initJNIPath();
        this.browserClient = CefApp.getInstance().createClient();
        hasCreateBrowser = true;
        this.browserClient.addLifeSpanHandler(new LifeSpanHandler(this));
        this.browserClient.addDisplayHandler(new DisplayHandler(this));
        this.browserClient.addLoadHandler(new LoadHandler(this));
        this.browserClient.addFocusHandler(new FocusHandler(this));
        this.browserClient.addContextMenuHandler(new MenuHandler(this));
        this.browserClient.addJSDialogHandler(new JSDialogHandler(this));
        this.browserClient.addKeyboardHandler(new KeyboardHandler(this));
        this.browserClient.addRequestHandler(new RequestHandler(this));
        this.browserFunctionRouterHandler = new BrowserFunctionRouterHandler();
        CefMessageRouter msgRouter = CefMessageRouter.create(this.browserFunctionRouterHandler);
        this.browserClient.addMessageRouter(msgRouter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CEF3Browser.this.onDispose();
                        break;
                    }
                    case 11: {
                        try {
                            if (RemoteDebugClient.getInstence().isOpen() && (RemoteDebugClient.getInstence().getDom().isHighlightEnabled() || RemoteDebugClient.getInstence().getDom().isInspectModeEnabled())) {
                                RemoteDebugClient.getInstence().getDom().hideHighlight(null);
                            }
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                        }
                        CEF3Browser.this.onResize(CEF3Browser.this.cefBrowser);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(1, listener);
        this.addListener(11, listener);
        this.initHighlightConfig();
    }

    private void initHighlightConfig() {
        new BrowserFunction(this, "hideHighlight"){

            @Override
            public void function(Object[] arguments, BrowserFunctionCallback callback) throws Exception {
                if (RemoteDebugClient.getInstence().getDom().isHighlightEnabled()) {
                    Job job = new Job("click hideHighlight Job"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                RemoteDebugClient.getInstence().getDom().hideHighlight(null);
                            }
                            catch (Throwable e) {
                                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }
        };
        this.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
            }

            public void changed(ProgressEvent event) {
                if (event.current == 0) {
                    CEF3Browser.this.execute("document.addEventListener('mousedown',function(){window.cefQuery({request: 'hideHighlight'})}, true)");
                }
            }
        });
    }

    private void onDispose() {
        this.browserFunctionRouterHandler.clearBrowserFunction();
    }

    private void onResize(CefBrowser cefBrowser) {
    }

    void onCreated(CefBrowser cefBrowser) {
    }

    void onClose() {
    }

    void notifyEventListeners(final int eventType, final Event event) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CEF3Browser.this.isDisposed()) {
                    return;
                }
                CEF3Browser.this.notifyListeners(eventType, event);
            }
        });
    }

    void runInUI(Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(runnable);
    }

    void notifyListeners(final TypedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CEF3Browser.this.notifyListenersInternal(event);
            }
        });
    }

    private void notifyListenersInternal(TypedEvent event) {
        block13: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block12: {
                                        if (this.isDisposed()) {
                                            return;
                                        }
                                        event.display = this.getDisplay();
                                        if (!(event instanceof OpenWindowEvent)) break block12;
                                        OpenWindowEvent openWindowEvent = (OpenWindowEvent)event;
                                        OpenWindowListener[] openWindowListenerArray = this.openWindowListeners.getListeners();
                                        int n = openWindowListenerArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            OpenWindowListener listener = openWindowListenerArray[n2];
                                            listener.open((WindowEvent)openWindowEvent);
                                            ++n2;
                                        }
                                        break block13;
                                    }
                                    if (!(event instanceof CloseWindowEvent)) break block14;
                                    CloseWindowEvent closeWindowEvent = (CloseWindowEvent)event;
                                    CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners.getListeners();
                                    int n = closeWindowListenerArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        CloseWindowListener listener = closeWindowListenerArray[n3];
                                        listener.close((WindowEvent)closeWindowEvent);
                                        ++n3;
                                    }
                                    break block13;
                                }
                                if (!(event instanceof LocationChangingEvent)) break block15;
                                LocationChangingEvent locationEvent = (LocationChangingEvent)event;
                                LocationListener[] locationListenerArray = this.locationListeners.getListeners();
                                int n = locationListenerArray.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    LocationListener listener = locationListenerArray[n4];
                                    listener.changing((LocationEvent)locationEvent);
                                    ++n4;
                                }
                                break block13;
                            }
                            if (!(event instanceof LocationEvent)) break block16;
                            LocationEvent locationEvent = (LocationEvent)event;
                            LocationListener[] locationListenerArray = this.locationListeners.getListeners();
                            int n = locationListenerArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                LocationListener listener = locationListenerArray[n5];
                                listener.changed(locationEvent);
                                ++n5;
                            }
                            break block13;
                        }
                        if (!(event instanceof TitleEvent)) break block17;
                        TitleEvent titleEvent = (TitleEvent)event;
                        TitleListener[] titleListenerArray = this.titleListeners.getListeners();
                        int n = titleListenerArray.length;
                        int n6 = 0;
                        while (n6 < n) {
                            TitleListener listener = titleListenerArray[n6];
                            listener.changed(titleEvent);
                            ++n6;
                        }
                        break block13;
                    }
                    if (!(event instanceof ProgressEvent)) break block18;
                    ProgressEvent progressEvent = (ProgressEvent)event;
                    if (progressEvent.current == progressEvent.total) {
                        ProgressListener[] progressListenerArray = this.progressListeners.getListeners();
                        int n = progressListenerArray.length;
                        int n7 = 0;
                        while (n7 < n) {
                            ProgressListener listener = progressListenerArray[n7];
                            listener.completed(progressEvent);
                            ++n7;
                        }
                    } else {
                        ProgressListener[] progressListenerArray = this.progressListeners.getListeners();
                        int n = progressListenerArray.length;
                        int n8 = 0;
                        while (n8 < n) {
                            ProgressListener listener = progressListenerArray[n8];
                            listener.changed(progressEvent);
                            ++n8;
                        }
                    }
                    break block13;
                }
                if (!(event instanceof StatusTextEvent)) break block19;
                StatusTextEvent statusTextEvent = (StatusTextEvent)event;
                StatusTextListener[] statusTextListenerArray = this.statusTextListeners.getListeners();
                int n = statusTextListenerArray.length;
                int n9 = 0;
                while (n9 < n) {
                    StatusTextListener listener = statusTextListenerArray[n9];
                    listener.changed(statusTextEvent);
                    ++n9;
                }
                break block13;
            }
            if (!(event instanceof ConsoleMessageEvent)) break block13;
            ConsoleMessageEvent consoleMessageEvent = (ConsoleMessageEvent)event;
            ConsoleMessageListener[] consoleMessageListenerArray = this.consoleMessageListeners.getListeners();
            int n = consoleMessageListenerArray.length;
            int n10 = 0;
            while (n10 < n) {
                ConsoleMessageListener listener = consoleMessageListenerArray[n10];
                listener.onConsoleMessage(consoleMessageEvent);
                ++n10;
            }
        }
    }

    private void loadURL(CefBrowser browser) {
        this.loadText = null;
        this.loadRequest = null;
        this.ensureBrowser();
        if (browser != null) {
            if (browser.isLoading()) {
                browser.stopLoad();
            }
            browser.loadURL(this.loadURL != null ? this.loadURL : URL_BLANK);
        }
    }

    public boolean isloading() {
        if (this.cefBrowser != null) {
            return this.cefBrowser.isLoading();
        }
        return false;
    }

    private void loadRequest(CefBrowser cefBrowser) {
        this.loadText = null;
        this.loadURL = null;
        this.ensureBrowser();
        if (cefBrowser != null) {
            cefBrowser.stopLoad();
            cefBrowser.loadRequest(this.loadRequest);
            this.loadRequest = null;
        }
    }

    private void loadText(CefBrowser cefBrowser) {
        this.loadURL = null;
        this.loadRequest = null;
        this.ensureBrowser();
        if (cefBrowser != null) {
            cefBrowser.stopLoad();
            cefBrowser.loadString(this.loadText, URL_TEXT);
            this.loadText = null;
        }
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeWindowListeners.add(listener);
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.locationListeners.add(listener);
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.openWindowListeners.add(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.progressListeners.add(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.statusTextListeners.add(listener);
    }

    public void addConsoleMessageListener(ConsoleMessageListener listener) {
        this.consoleMessageListeners.add(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.titleListeners.add(listener);
    }

    public boolean back() {
        this.checkWidget();
        if (this.cefBrowser != null && this.cefBrowser.canGoBack()) {
            this.cefBrowser.goBack();
            return true;
        }
        return false;
    }

    public boolean execute(String script) {
        if (script == null) {
            SWT.error((int)4);
        }
        if (this.cefBrowser != null) {
            this.cefBrowser.executeJavaScript(script, URL_SCRIPT, 1);
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.browserClient != null) {
            this.browserClient.dispose();
        }
    }

    public boolean forward() {
        this.checkWidget();
        if (this.cefBrowser != null && this.cefBrowser.canGoForward()) {
            this.cefBrowser.goForward();
            return true;
        }
        return false;
    }

    public String getText() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            CefStringVisitor visitor = new CefStringVisitor(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public void visit(String string) {
                    this.builder.append(string);
                }

                public String toString() {
                    return this.builder.toString();
                }
            };
            this.cefBrowser.getSource(visitor);
            return visitor.toString();
        }
        return "";
    }

    public String getUrl() {
        if (this.cefBrowser != null) {
            String url = this.cefBrowser.getURL();
            if (url == null || url.isEmpty() || "data:text/html,chromewebdata".equals(url)) {
                return this.loadURL;
            }
            return url;
        }
        return "";
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return this.cefBrowser != null && this.cefBrowser.canGoBack();
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return this.cefBrowser != null && this.cefBrowser.canGoForward();
    }

    public void refresh() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            if (URL_TEXT.equals(this.cefBrowser.getURL())) {
                this.cefBrowser.loadString(this.getText(), URL_TEXT);
                return;
            }
            this.cefBrowser.reloadIgnoreCache();
        }
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeWindowListeners.remove(listener);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.locationListeners.remove(listener);
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.openWindowListeners.remove(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.progressListeners.remove(listener);
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.statusTextListeners.remove(listener);
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.titleListeners.remove(listener);
    }

    public void setJavascriptEnabled(boolean enabled) {
        this.checkWidget();
    }

    public boolean setText(String html) {
        this.checkWidget();
        return this.setText(html, true);
    }

    public boolean setText(String html, boolean trusted) {
        this.checkWidget();
        if (html == null) {
            SWT.error((int)4);
        }
        this.loadText = html;
        this.loadText(this.cefBrowser);
        return true;
    }

    public boolean setUrl(String url) {
        this.loadURL = url;
        this.loadURL(this.cefBrowser);
        return true;
    }

    public boolean setUrl(String url, String postData, HashMap<String, String> headerMap) {
        this.checkWidget();
        if (url == null) {
            SWT.error((int)4);
        }
        CefRequest request = CefRequest.create();
        request.setURL(url);
        if (postData != null) {
            CefPostData pdata = CefPostData.create();
            CefPostDataElement element = CefPostDataElement.create();
            if (postData.length() > 0) {
                try {
                    byte[] bytes = postData.getBytes("UTF-8");
                    element.setToBytes(bytes.length, bytes);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                element.setToEmpty();
            }
            pdata.addElement(element);
            request.setPostData(pdata);
        }
        if (headerMap != null) {
            request.setHeaderMap(headerMap);
        }
        this.loadRequest = request;
        this.loadRequest(this.cefBrowser);
        return true;
    }

    public void stop() {
        this.checkWidget();
        if (this.cefBrowser != null) {
            this.cefBrowser.stopLoad();
        }
    }

    public boolean isDisposed() {
        return super.isDisposed();
    }

    public CefBrowser getCefBroser() {
        return this.cefBrowser;
    }

    public void setMenu(Menu menu) {
        this.enableDefaultMenu = menu == null;
        super.setMenu(menu);
    }

    public boolean enableDefaultMenu() {
        return this.enableDefaultMenu;
    }

    public void setEnableDefaultMenu(boolean enableDefaultMenu) {
        this.enableDefaultMenu = enableDefaultMenu;
    }

    public boolean enableDevTools() {
        return this.enableDevTools;
    }

    public void setEnableDevTools(boolean enable) {
        this.enableDevTools = enable;
    }

    public static void closeAll() {
        if (defaultBrowser != null && !defaultBrowser.isDisposed()) {
            defaultBrowser.dispose();
        }
        if (hasCreateBrowser) {
            CefApp.getInstance().dispose();
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    public void openDevTools() {
        if (this.devToolsDialog == null || this.devToolsDialog.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CEF3Browser.this.devToolsDialog = new DevToolsDialog(CEF3Browser.this);
                    CEF3Browser.this.devToolsDialog.createContent();
                    for (ShellListener listener : CEF3Browser.this.devToolShellListeners) {
                        if (listener == null) continue;
                        CEF3Browser.this.devToolsDialog.getShell().addShellListener(listener);
                    }
                    CEF3Browser.this.devToolsDialog.open();
                }
            });
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CEF3Browser.this.devToolsDialog.isVisible()) {
                    CEF3Browser.this.devToolsDialog.setVisible(true);
                } else if (CEF3Browser.this.devToolsDialog.isMinimized()) {
                    CEF3Browser.this.devToolsDialog.setMinimized(false);
                } else {
                    CEF3Browser.this.devToolsDialog.setFocus();
                }
            }
        });
    }

    public void addDevToolsDialoglistener(ShellListener listener) {
        if (this.devToolsDialog != null && !this.devToolsDialog.isDisposed()) {
            this.devToolsDialog.getShell().addShellListener(listener);
        }
        if (listener != null) {
            this.devToolShellListeners.add(listener);
        }
    }

    public void removeDevToolsDialoglistener(ShellListener listener) {
        if (listener != null) {
            this.devToolShellListeners.remove(listener);
        }
    }

    public boolean isDevToolsDialogOpened() {
        return this.devToolsDialog != null && !this.devToolsDialog.isDisposed();
    }

    /*
     * Exception decompiling
     */
    public static int findFreePort(int defaultPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getLoadingURL() {
        return this.loadingURL;
    }

    public void setLoadingURL(String loadingURL) {
        this.loadingURL = loadingURL;
    }
}

