/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.parsing.ast;

import com.aptana.editor.xml.parsing.XMLParser;
import com.aptana.editor.xml.parsing.ast.XMLNode;
import com.aptana.editor.xml.parsing.ast.XMLNodeType;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class XMLElementNode
extends XMLNode {
    private INameNode fNameNode;
    private boolean fIsSelfClosing;
    private Map<String, String> fAttributes;

    private static String getTagName(String tag) {
        StringTokenizer token = new StringTokenizer(tag);
        return token.nextToken();
    }

    public XMLElementNode(String tag, int start, int end) {
        this(tag, XMLParser.NO_XML_NODES, start, end);
    }

    public XMLElementNode(String tag, XMLNode[] children, int start, int end) {
        super(XMLNodeType.ELEMENT, children, start, end);
        if (tag.length() > 0) {
            try {
                if (tag.endsWith("/>")) {
                    tag = XMLElementNode.getTagName(tag.substring(1, tag.length() - 2));
                    this.fIsSelfClosing = true;
                } else {
                    tag = XMLElementNode.getTagName(tag.substring(1, tag.length() - 1));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        this.fNameNode = new ParseNode.NameNode(tag, start, end);
    }

    public void addOffset(int offset) {
        IRange range = this.fNameNode.getNameRange();
        this.fNameNode = new ParseNode.NameNode(this.fNameNode.getName(), range.getStartingOffset() + offset, range.getEndingOffset() + offset);
        super.addOffset(offset);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XMLElementNode)) {
            return false;
        }
        return this.getName().equals(((XMLElementNode)((Object)obj)).getName());
    }

    public String getAttibute(String name) {
        String result = "";
        if (this.fAttributes != null) {
            result = this.fAttributes.get(name);
        }
        return result;
    }

    public IParseNodeAttribute[] getAttributes() {
        ArrayList<ParseNodeAttribute> attributes = new ArrayList<ParseNodeAttribute>();
        if (this.fAttributes != null && this.fAttributes.size() > 0) {
            for (Map.Entry<String, String> entry : this.fAttributes.entrySet()) {
                attributes.add(new ParseNodeAttribute((IParseNode)this, entry.getKey(), entry.getValue()));
            }
        }
        return attributes.toArray(new IParseNodeAttribute[attributes.size()]);
    }

    public String getName() {
        return this.fNameNode.getName();
    }

    public INameNode getNameNode() {
        return this.fNameNode;
    }

    public String getText() {
        return this.fNameNode.getName();
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.getName().hashCode();
    }

    public boolean isSelfClosing() {
        return this.fIsSelfClosing;
    }

    public void setAttribute(String name, String value) {
        if (this.fAttributes == null) {
            this.fAttributes = new LinkedHashMap<String, String>();
        }
        this.fAttributes.put(name, value);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        String name = this.getName();
        if (name.length() > 0) {
            IParseNode[] children;
            text.append('<').append(name);
            text.append('>');
            IParseNode[] iParseNodeArray = children = this.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode child = iParseNodeArray[n2];
                text.append(child);
                ++n2;
            }
            text.append("</").append(name).append('>');
        }
        return text.toString();
    }
}

