/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist.index;

import com.aptana.editor.xml.contentassist.index.IKeyProvider;
import com.aptana.editor.xml.contentassist.model.ElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XMLIndexReader {
    private IKeyProvider _keyProvider;

    public XMLIndexReader(IKeyProvider keyProvider) {
        this._keyProvider = keyProvider;
    }

    private ElementElement createElementFromKey(Index index, String key) {
        String[] columns = key.split("\u0000");
        ElementElement element = new ElementElement();
        int column = 0;
        element.setName(columns[column++]);
        element.setDisplayName(columns[column++]);
        String[] stringArray = columns[column++].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            element.addAttribute(attribute);
            ++n2;
        }
        if (column < columns.length) {
            element.setDescription(columns[column++]);
        }
        return element;
    }

    public ElementElement getElement(Index index, String name) {
        Iterator iterator;
        String searchKey = String.valueOf(name) + "\u0000";
        List items = index.query(new String[]{this._keyProvider.getElementKey()}, searchKey, 1);
        ElementElement result = null;
        if (items != null && (iterator = items.iterator()).hasNext()) {
            QueryResult item = (QueryResult)iterator.next();
            String key = item.getWord();
            result = this.createElementFromKey(index, key);
        }
        return result;
    }

    public List<ElementElement> getElements(Index index) {
        List items = index.query(new String[]{this._keyProvider.getElementKey()}, "*", 2);
        LinkedList<ElementElement> result = new LinkedList<ElementElement>();
        if (items != null) {
            for (QueryResult item : items) {
                String key = item.getWord();
                ElementElement element = this.createElementFromKey(index, key);
                result.add(element);
            }
        }
        return result;
    }
}

