/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.dtd.DTDSourceConfiguration;
import com.aptana.editor.xml.XMLScanner;
import com.aptana.editor.xml.XMLSubPartitionScanner;
import com.aptana.editor.xml.XMLTagScanner;
import com.aptana.editor.xml.internal.text.rules.DocTypeRule;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class XMLSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__xml_";
    public static final String DEFAULT = "__xml__dftl_partition_content_type";
    public static final String COMMENT = "__xml_comment";
    public static final String CDATA = "__xml_cdata";
    public static final String PRE_PROCESSOR = "__xml_pre_processor";
    public static final String TAG = "__xml_tag";
    public static final String DOCTYPE = "__xml_doctype";
    public static final String[] CONTENT_TYPES = new String[]{"__xml__dftl_partition_content_type", "__xml_comment", "__xml_cdata", "__xml_pre_processor", "__xml_tag", "__xml_doctype"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"org.eclipse.core.runtime.xml"}, {"org.eclipse.core.runtime.xml", "com.aptana.contenttype.dtd"}};
    private final IPredicateRule[] partitioningRules = new IPredicateRule[]{new MultiLineRule("<?", "?>", XMLSourceConfiguration.getToken("__xml_pre_processor")), new MultiLineRule("<!--", "-->", XMLSourceConfiguration.getToken("__xml_comment"), '\u0000', true), new MultiLineRule("<![CDATA[", "]]>", XMLSourceConfiguration.getToken("__xml_cdata")), new DocTypeRule((IToken)new ExtendedToken(XMLSourceConfiguration.getToken("__xml_doctype")), true), new TagRule("/", XMLSourceConfiguration.getToken("__xml_tag")), new TagRule((IToken)new ExtendedToken(XMLSourceConfiguration.getToken("__xml_tag")))};
    private static XMLSourceConfiguration instance;

    private XMLSourceConfiguration() {
    }

    public static synchronized XMLSourceConfiguration getDefault() {
        if (instance == null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"org.eclipse.core.runtime.xml", "com.aptana.contenttype.dtd"}), new QualifiedContentType(new String[]{"text.xml", "source.dtd.embedded.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{"org.eclipse.core.runtime.xml"}), new QualifiedContentType(new String[]{"text.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{COMMENT}), new QualifiedContentType(new String[]{"comment.block.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{PRE_PROCESSOR}), new QualifiedContentType(new String[]{"meta.tag.preprocessor.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{TAG}), new QualifiedContentType(new String[]{"meta.tag.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{CDATA}), new QualifiedContentType(new String[]{"string.unquoted.cdata.xml"}));
            c.addTranslation(new QualifiedContentType(new String[]{DOCTYPE}), new QualifiedContentType(new String[]{"meta.tag.sgml.doctype.xml"}));
            instance = new XMLSourceConfiguration();
        }
        return instance;
    }

    public String[] getContentTypes() {
        return TextUtils.combine((String[][])new String[][]{CONTENT_TYPES, DTDSourceConfiguration.CONTENT_TYPES});
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new XMLSubPartitionScanner();
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "org.eclipse.core.runtime.xml";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        DTDSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getPreProcessorScanner());
        reconciler.setDamager((IPresentationDamager)dr, PRE_PROCESSOR);
        reconciler.setRepairer((IPresentationRepairer)dr, PRE_PROCESSOR);
        dr = new ThemeingDamagerRepairer(this.getCDATAScanner());
        reconciler.setDamager((IPresentationDamager)dr, CDATA);
        reconciler.setRepairer((IPresentationRepairer)dr, CDATA);
        dr = new ThemeingDamagerRepairer(this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, TAG);
        reconciler.setRepairer((IPresentationRepairer)dr, TAG);
        dr = new ThemeingDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMENT);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if (contentType.startsWith("__dtd__")) {
            return DTDSourceConfiguration.getDefault().getContentAssistProcessor(editor, contentType);
        }
        return new CommonContentAssistProcessor(editor);
    }

    private ITokenScanner getCommentScanner() {
        return new CommentScanner(XMLSourceConfiguration.getToken("comment.block.xml"));
    }

    private ITokenScanner getPreProcessorScanner() {
        XMLTagScanner preProcessorScanner = new XMLTagScanner();
        preProcessorScanner.setDefaultReturnToken(XMLSourceConfiguration.getToken("meta.tag.preprocessor.xml"));
        return preProcessorScanner;
    }

    private ITokenScanner getCDATAScanner() {
        return new SingleTokenScanner(XMLSourceConfiguration.getToken("string.unquoted.cdata.xml"));
    }

    private ITokenScanner getXMLScanner() {
        return new XMLScanner();
    }

    private ITokenScanner getXMLTagScanner() {
        return new XMLTagScanner();
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

