/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.build.ui.preferences;

import com.aptana.build.ui.internal.preferences.Messages;
import com.aptana.core.build.IBuildParticipantWorkingCopy;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.widgets.CListTable;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ValidatorFiltersPreferenceComposite
extends Composite {
    private CListTable filterViewer;
    private IBuildParticipantWorkingCopy participant;

    public ValidatorFiltersPreferenceComposite(Composite parent, IBuildParticipantWorkingCopy participantChanges) {
        super(parent, 0);
        this.participant = participantChanges;
        this.setLayout((Layout)new FillLayout());
        this.createFiltersComposite(this);
    }

    private Control createFiltersComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ValidationPreferencePage_LBL_Filter);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(4, 4).create());
        this.filterViewer = new CListTable((Composite)group, 0);
        this.filterViewer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 300).create());
        this.filterViewer.setDescription(Messages.ValidationPreferencePage_Filter_SelectParticipant);
        final IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (StringUtil.isEmpty((String)newText)) {
                    return Messages.ValidationPreferencePage_ERR_EmptyExpression;
                }
                return null;
            }
        };
        this.filterViewer.addListener(new CListTable.Listener(){

            public Object addItem() {
                InputDialog dialog = new InputDialog(ValidatorFiltersPreferenceComposite.this.getShell(), Messages.ValidationPreferencePage_Ignore_Title, Messages.ValidationPreferencePage_Ignore_Message, null, inputValidator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }

            public Object editItem(Object item) {
                String expression = item.toString();
                InputDialog dialog = new InputDialog(ValidatorFiltersPreferenceComposite.this.getShell(), Messages.ValidationPreferencePage_Ignore_Title, Messages.ValidationPreferencePage_Ignore_Message, expression, inputValidator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return item;
            }

            public void itemsChanged(List<Object> rawFilters) {
                String[] filters = new String[rawFilters.size()];
                int i = 0;
                for (Object item : rawFilters) {
                    filters[i++] = item.toString();
                }
                ValidatorFiltersPreferenceComposite.this.participant.setFilters(filters);
            }
        });
        this.filterViewer.setEnabled(true);
        this.filterViewer.setDescription(Messages.ValidationPreferencePage_Filter_Description);
        List expressions = this.participant.getFilters();
        this.filterViewer.setItems(expressions.toArray());
        return group;
    }
}

