local GSE = GSE
local Statics = GSE.Static

GSE.TranslatorLanguageTables[Statics.TranslationShadow]["enUS"] = {
	["power word: shield"] = 17,
	["backstab"] = 53,
	["invisibility"] = 66,
	["incapacitating roar"] = 99,
	["charge"] = 100,
	["trip"] = 101,
	["chains of ice"] = 113,
	["frostbolt"] = 116,
	["polymorph"] = 118,
	["cone of cold"] = 120,
	["frost nova"] = 122,
	["eye of kilrogg"] = 126,
	["slow fall"] = 130,
	["fireball"] = 133,
	["mend pet"] = 136,
	["renew"] = 139,
	["corruption"] = 172,
	["polymorph: chicken"] = 228,
	["slow"] = 246,
	["entangling roots"] = 339,
	["immolate"] = 348,
	["purge"] = 370,
	["kidney shot"] = 408,
	["chain lightning"] = 421,
	["thorns"] = 467,
	["divine protection"] = 498,
	["purify"] = 527,
	["dispel magic"] = 528,
	["nullify poison"] = 550,
	["smite"] = 585,
	["shadow word: pain"] = 589,
	["prayer of healing"] = 596,
	["doom"] = 603,
	["mind control"] = 605,
	["mind rot"] = 606,
	["shadow bolt"] = 686,
	["summon imp"] = 688,
	["zzolddrain life"] = 689,
	["summon felhunter"] = 691,
	["create soulstone"] = 693,
	["summon voidwalker"] = 697,
	["ritual of summoning"] = 698,
	["sleep"] = 700,
	["garrote"] = 703,
	["banish"] = 710,
	["summon succubus"] = 712,
	["tranquility"] = 740,
	["rend"] = 772,
	["rejuvenation"] = 774,
	["true fulfillment"] = 785,
	["cleave"] = 845,
	["polymorph: sheep"] = 851,
	["hammer of justice"] = 853,
	["agony"] = 980,
	["revive pet"] = 982,
	["blessing of protection"] = 1022,
	["blessing of freedom"] = 1044,
	["chain heal"] = 1064,
	["rip"] = 1079,
	["enslave demon"] = 1098,
	["summon infernal"] = 1122,
	["demoralizing shout"] = 1160,
	["mutilate"] = 1329,
	["arcane explosion"] = 1449,
	["life tap"] = 1454,
	["slam"] = 1464,
	["fire nova"] = 1535,
	["whirlwind"] = 1680,
	["levitate"] = 1706,
	["hamstring"] = 1715,
	["battle cry"] = 1719,
	["distract"] = 1725,
	["gouge"] = 1776,
	["stealth"] = 1784,
	["rake"] = 1822,
	["cheap shot"] = 1833,
	["vanish"] = 1856,
	["rupture"] = 1943,
	["blink"] = 1953,
	["feint"] = 1966,
	["resurrection"] = 2006,
	["ancestral spirit"] = 2008,
	["holy word: serenity"] = 2050,
	["heal"] = 2060,
	["flash heal"] = 2061,
	["mind vision"] = 2096,
	["run through"] = 2098,
	["flamestrike"] = 2120,
	["counterspell"] = 2139,
	["shield block"] = 2565,
	["shock"] = 2606,
	["multi-shot"] = 2643,
	["growl"] = 2649,
	["remove corruption"] = 2782,
	["nullify disease"] = 2871,
	["scorch"] = 2948,
	["sprint"] = 2983,
	["cat form"] = 3025,
	["touch of death"] = 3108,
	["presence of death"] = 3109,
	["firebolt"] = 3110,
	["enchanted quickness"] = 3443,
	["teleport: stormwind"] = 3561,
	["teleport: ironforge"] = 3562,
	["teleport: undercity"] = 3563,
	["teleport: darnassus"] = 3565,
	["teleport: thunder bluff"] = 3566,
	["teleport: orgrimmar"] = 3567,
	["summon spirit of old"] = 3652,
	["path of frost"] = 3714,
	["consuming shadows"] = 3716,
	["static electricity"] = 3742,
	["healing ward"] = 4971,
	["cleanse"] = 4987,
	["voidwalker"] = 5108,
	["summon living flame"] = 5110,
	["concussive shot"] = 5116,
	["slice and dice"] = 5171,
	["solar wrath"] = 5176,
	["healing touch"] = 5185,
	["mighty bash"] = 5211,
	["prowl"] = 5215,
	["tiger's fury"] = 5217,
	["shred"] = 5221,
	["freeze"] = 5276,
	["execute"] = 5308,
	["healing stream totem"] = 5394,
	["bear form"] = 5487,
	["searing pain"] = 5676,
	["unending breath"] = 5697,
	["rain of fire"] = 5740,
	["cat form"] = 5759,
	["fear"] = 5782,
	["blessing of aman"] = 5862,
	["create healthstone"] = 6201,
	["thunder clap"] = 6343,
	["seduction"] = 6358,
	["whiplash"] = 6360,
	["ilkrud's guardians"] = 6487,
	["lightning cloud"] = 6535,
	["revenge"] = 6572,
	["flame spike"] = 6725,
	["silence"] = 6726,
	["enveloping winds"] = 6728,
	["bloodlust"] = 6742,
	["sap"] = 6770,
	["mortal coil"] = 6789,
	["maul"] = 6807,
	["summon illusionary nightmare"] = 6905,
	["blessing of sacrifice"] = 6940,
	["weak frostbolt"] = 6949,
	["faerie fire"] = 6950,
	["lightning barrier"] = 6960,
	["flame blast"] = 7101,
	["moist towelette"] = 7108,
	["anti-magic shield"] = 7121,
	["immolate cumulative (test)"] = 7288,
	["soul siphon"] = 7290,
	["redemption"] = 7328,
	["overpower"] = 7384,
	["void bolt"] = 7588,
	["arugal's curse"] = 7621,
	["dominate mind"] = 7645,
	["inferno shell"] = 7739,
	["thundershock"] = 7803,
	["flameblade"] = 7806,
	["sacrifice"] = 7812,
	["lash of pain"] = 7814,
	["summon water terror"] = 7855,
	["lesser invisibility"] = 7870,
	["strong anti-venom"] = 7933,
	["wild regeneration"] = 7948,
	["scry on azrethoc"] = 7960,
	["area burn"] = 8000,
	["healing surge"] = 8004,
	["druid's slumber"] = 8040,
	["earth shock"] = 8042,
	["psychic scream"] = 8122,
	["befuddlement"] = 8140,
	["magma totem"] = 8190,
	["chain burn"] = 8211,
	["lightning bolt"] = 8246,
	["elemental protection totem"] = 8262,
	["lava spout totem"] = 8264,
	["mind tremor"] = 8272,
	["voodoo hex"] = 8277,
	["chain bolt"] = 8292,
	["julie's blessing"] = 8348,
	["purity"] = 8361,
	["blizzard"] = 8364,
	["earthgrab totem"] = 8376,
	["frostbolt volley"] = 8398,
	["forked lightning"] = 8435,
	["curse of weakness"] = 8552,
	["lightning blast"] = 8598,
	["ambush"] = 8676,
	["conjure food"] = 8736,
	["lightning shield"] = 8788,
	["slave drain"] = 8809,
	["moonfire"] = 8921,
	["regrowth"] = 8936,
	["shadow bolt volley"] = 9081,
	["detonation"] = 9435,
	["arcane bubble"] = 9438,
	["tharnariun cure 1"] = 9456,
	["holy smite"] = 9481,
	["shackle undead"] = 9484,
	["searing flames"] = 9552,
	["obsoletedire bear form"] = 9634,
	["jumping lightning"] = 9654,
	["wrath"] = 9739,
	["radiation bolt"] = 9771,
	["portal: stormwind"] = 10059,
	["flow of the northspring"] = 11014,
	["summon witherbark felhunter"] = 11017,
	["flamespit"] = 11021,
	["pyroblast"] = 11366,
	["nether shell"] = 11412,
	["portal: ironforge"] = 11416,
	["portal: orgrimmar"] = 11417,
	["portal: undercity"] = 11418,
	["portal: darnassus"] = 11419,
	["portal: thunder bluff"] = 11420,
	["ice barrier"] = 11426,
	["death & decay"] = 11433,
	["cripple"] = 11443,
	["bone armor"] = 11445,
	["hex"] = 11641,
	["detect invisibility"] = 11649,
	["healing wave of antu'sul"] = 11895,
	["mana burn"] = 11981,
	["healing wave"] = 11986,
	["fireball volley"] = 11988,
	["shadow shield"] = 12040,
	["arcane power"] = 12042,
	["summon atal'ai skeleton"] = 12151,
	["amplify damage"] = 12248,
	["summon shadowcaster"] = 12258,
	["bloodbath"] = 12292,
	["mortal strike"] = 12294,
	["piercing howl"] = 12323,
	["frost armor"] = 12544,
	["frost shock"] = 12548,
	["fade"] = 12685,
	["last stand"] = 12975,
	["dragon's call"] = 13049,
	["arcane intellect"] = 13326,
	["fire blast"] = 13339,
	["torch"] = 13381,
	["pummel"] = 13491,
	["blazing emblem"] = 13744,
	["arcane bolt"] = 13748,
	["adrenaline rush"] = 13750,
	["demon armor"] = 13787,
	["mind blast"] = 13860,
	["divine shield"] = 13874,
	["blade flurry"] = 13877,
	["fist of ragnaros"] = 13902,
	["seal of sacrifice"] = 13903,
	["holy light"] = 13952,
	["holy strike"] = 13953,
	["frost blast"] = 14105,
	["item - purify"] = 14129,
	["abolish poison"] = 14253,
	["crusader strike"] = 14517,
	["curse of agony"] = 14868,
	["holy fire"] = 14914,
	["scorching totem"] = 15038,
	["flame shock"] = 15039,
	["molten blast"] = 15040,
	["fire ward"] = 15041,
	["frost ward"] = 15044,
	["distract test"] = 15054,
	["blast wave"] = 15091,
	["seal of reckoning"] = 15277,
	["fury of ragnaros"] = 15288,
	["acid spit"] = 15653,
	["remove curse"] = 15729,
	["arcane missiles"] = 15735,
	["flamecrack"] = 15743,
	["earthbind totem"] = 15786,
	["moonflare totem"] = 15787,
	["flame buffet totem"] = 15867,
	["superior healing ward"] = 15869,
	["tormenting lash"] = 15969,
	["arcane blast"] = 16067,
	["elemental mastery"] = 16166,
	["curse of recklessness"] = 16231,
	["piercing shadow"] = 16429,
	["soul tap"] = 16430,
	["searing blast"] = 16454,
	["hemorrhage"] = 16511,
	["mind flay"] = 16568,
	["charged arcane bolt"] = 16570,
	["shadow shock"] = 16583,
	["dark whispers"] = 16587,
	["dark mending"] = 16588,
	["shadowform"] = 16592,
	["exorcism"] = 17147,
	["summon water elemental"] = 17162,
	["seal of protection"] = 17177,
	["drain mana"] = 17243,
	["bite"] = 17253,
	["crusader's hammer"] = 17286,
	["stormstrike"] = 17364,
	["domination"] = 17405,
	["summon risen lackey"] = 17618,
	["arcane focus"] = 17633,
	["suffering"] = 17735,
	["curse of the plague rat"] = 17738,
	["mana shield"] = 17740,
	["shadow bulwark"] = 17767,
	["shadowburn"] = 17877,
	["conflagrate"] = 17962,
	["berserker rage"] = 18499,
	["swiftmend"] = 18562,
	["devastate"] = 20243,
	["rebirth"] = 20484,
	["blood fury"] = 20572,
	["stoneform"] = 20594,
	["ferocious bite"] = 22568,
	["barkskin"] = 22812,
	["bloodthirst"] = 23881,
	["shield slam"] = 23922,
	["intimidation"] = 24394,
	["frenzied regeneration"] = 22842,
	["moonkin form"] = 24858,
	["arcane torrent"] = 25046,
	["aura mastery"] = 31821,
	["corrupted earth"] = 32133,
	["corrupted healing stream totem"] = 32135,
	["corrupted air totem"] = 32137,
	["heroism"] = 32182,
	["portal: exodar"] = 32266,
	["portal: silvermoon"] = 32267,
	["teleport: exodar"] = 32271,
	["teleport: silvermoon"] = 32272,
	["shadow burst"] = 32324,
	["mass dispel"] = 32375,
	["soul scream"] = 32421,
	["holy wrath"] = 32445,
	["binding heal"] = 32546,
	["talon of justice"] = 32654,
	["shadow totem"] = 32659,
	["summon dark vortex"] = 32663,
	["avenger's shield"] = 32674,
	["shadow missiles"] = 32675,
	["arcane destruction"] = 32689,
	["arcane lightning"] = 32690,
	["spell shock"] = 32691,
	["incinerate"] = 32707,
	["death coil"] = 32709,
	["shadow nova"] = 32711,
	["hurricane"] = 32717,
	["earth shield"] = 32734,
	["spikes"] = 32740,
	["pain spike"] = 32741,
	["blessing of light"] = 32770,
	["holy shock"] = 32771,
	["hammer of wrath"] = 32772,
	["consecration"] = 32773,
	["holy shield"] = 32777,
	["repentance"] = 32779,
	["falter"] = 32859,
	["shadowguard"] = 32861,
	["drain soul"] = 32862,
	["seed of corruption"] = 32863,
	["feedback"] = 32897,
	["judgment of reckoning"] = 32917,
	["lurk"] = 32926,
	["der'izu focus"] = 32936,
	["blinding light"] = 33009,
	["greater fireball"] = 33051,
	["prayer of mending"] = 33076,
	["seal of command"] = 33127,
	["greater power word: shield"] = 33147,
	["greater polymorph"] = 33173,
	["arcane shock"] = 33175,
	["pain suppression"] = 33206,
	["major heal"] = 33324,
	["shadow mend"] = 33325,
	["icebolt"] = 33463,
	["addle humanoid"] = 33487,
	["brain wash"] = 33502,
	["judgment of command"] = 33554,
	["magma flow totem"] = 33560,
	["greater blessing of might"] = 33564,
	["strength of the storm totem"] = 33570,
	["protection of azeroth"] = 33639,
	["flash of light"] = 33641,
	["inferno"] = 33679,
	["teleport: shattrath"] = 33690,
	["portal: shattrath"] = 33691,
	["lifebloom"] = 33763,
	["everlasting underspore fronds"] = 33770,
	["cyclone"] = 33786,
	["heal other"] = 33910,
	["void drain"] = 33916,
	["draining bolt"] = 33969,
	["rain of chaos"] = 34017,
	["bound soul"] = 34020,
	["kill command"] = 34026,
	["whipped fury"] = 34035,
	["curse of the bleeding hollow"] = 34073,
	["grounding totem"] = 34079,
	["whipped frenzy"] = 34086,
	["chilling words"] = 34087,
	["feeble weapons"] = 34088,
	["doubting mind"] = 34089,
	["riposte"] = 34097,
	["judgment of darkness"] = 34111,
	["greater heal"] = 34119,
	["fungal regrowth"] = 34163,
	["holy bolt"] = 34232,
	["rejuvenate plant"] = 34254,
	["mind shock"] = 34352,
	["poison shield"] = 34355,
	["bloodgem infusion"] = 34379,
	["water bolt"] = 34425,
	["unstable affliction"] = 34438,
	["water bolt volley"] = 34449,
	["misdirection"] = 34477,
	["nether protection"] = 34518,
	["soul channel"] = 34637,
	["decapitation"] = 34722,
	["summon chilled earth"] = 34728,
	["chilled earth"] = 34729,
	["plant white seedling"] = 34759,
	["plant green seedling"] = 34761,
	["plant blue seedling"] = 34762,
	["plant red seedling"] = 34763,
	["summon frostbite"] = 34778,
	["arcane volley"] = 34785,
	["freezing circle"] = 34787,
	["nature shock"] = 34797,
	["greenkeeper's fury"] = 34798,
	["holy fury"] = 34809,
	["water shield"] = 34827,
	["arcane shot"] = 34829,
	["holy word: sanctify"] = 34861,
	["umbrafen buff"] = 34871,
	["elemental armor"] = 34880,
	["holy nova"] = 34944,
	["ravandwyr's ice block"] = 34973,
	["mennu's healing ward"] = 34980,
	["shrink"] = 35013,
	["arcane flare"] = 35106,
	["siphon life"] = 35195,
	["terror totem"] = 35197,
	["starfire"] = 35243,
	["dragon's breath"] = 35250,
	["arcane nova"] = 35261,
	["solarburn"] = 35267,
	["nether shock"] = 35334,
	["nether leech"] = 35335,
	["shadowfury"] = 35373,
	["summon shadow image"] = 35425,
	["feign death"] = 35571,
	["starfall"] = 35749,
	["chain fireball"] = 35853,
	["core overload"] = 35891,
	["suppression"] = 35892,
	["fel flamestrike"] = 35895,
	["fel fireball"] = 35913,
	["astral focus"] = 35914,
	["molten armor"] = 35915,
	["fiery intellect"] = 35917,
	["welding beam"] = 35919,
	["electroshock"] = 35920,
	["power word: fortitude"] = 36004,
	["chill nova"] = 36148,
	["chaos nova"] = 36225,
	["curse of vulnerability"] = 36276,
	["anesthetic"] = 36333,
	["chain felfire"] = 36404,
	["mind sear"] = 36447,
	["consume shadows"] = 36472,
	["desecration"] = 36473,
	["blood heal"] = 36476,
	["stasis"] = 36527,
	["gravity flux"] = 36533,
	["curse of burning shadows"] = 36541,
	["charged arcane shot"] = 36608,
	["arcane shield"] = 36640,
	["poison bolt"] = 36713,
	["holy bolt volley"] = 36743,
	["soul chill"] = 36786,
	["rapid fire"] = 36828,
	["curse of the elements"] = 36831,
	["conjure water"] = 36879,
	["ice armor"] = 36881,
	["conjure mana diamond"] = 36883,
	["fire shield"] = 36907,
	["ice block"] = 36911,
	["mind rend"] = 36924,
	["xi'ri's wrath"] = 36944,
	["serpent sting"] = 36984,
	["summon water elementals"] = 37051,
	["power infusion"] = 37274,
	["fel flames"] = 37488,
	["mark of light"] = 37555,
	["bestial wrath"] = 37587,
	["carrion swarm"] = 37624,
	["fel immolate"] = 37628,
	["melt flesh"] = 37629,
	["touch of darkness"] = 37727,
	["haste"] = 37728,
	["unholy armor"] = 37729,
	["death and decay"] = 37788,
	["ancient fire"] = 37986,
	["seal of blood"] = 38008,
	["stormbolt"] = 38032,
	["mind warp"] = 38047,
	["fel shackles"] = 38051,
	["shadow blast"] = 38085,
	["spitfire totem"] = 38236,
	["poison cleansing totem"] = 38306,
	["aimed shot"] = 38370,
	["sear nova"] = 38445,
	["shock blast"] = 38509,
	["arcane discharge"] = 38539,
	["corrupted searing totem"] = 38581,
	["fire destruction"] = 38648,
	["frost destruction"] = 38649,
	["arcane unlocking"] = 38898,
	["complete domination"] = 39019,
	["summon wrath hound"] = 39272,
	["viper sting"] = 39413,
	["summon windfury totem"] = 39586,
	["searing totem"] = 39588,
	["cyclone totem"] = 39589,
	["drop mine"] = 39685,
	["rizzle's frost trap"] = 39902,
	["lightning prod"] = 40066,
	["electric spur"] = 40076,
	["harpooner's mark"] = 40084,
	["restoration"] = 40097,
	["crushing shadows"] = 40243,
	["mark of anzu"] = 40366,
	["twisting blast"] = 40367,
	["nether vortex"] = 40368,
	["black temple tank trinket"] = 40444,
	["shivan self cleansing"] = 40769,
	["zoomtemp"] = 40822,
	["silencing shriek"] = 40823,
	["doom bolt"] = 40876,
	["blood siphon"] = 41068,
	["bloodbolt"] = 41072,
	["silencing shot"] = 41084,
	["freezing trap"] = 41085,
	["wyvern sting"] = 41186,
	["brute cologne"] = 41233,
	["soul blast"] = 41245,
	["shared suffering"] = 41246,
	["shadow word: death"] = 41375,
	["blessing of spell warding"] = 41451,
	["circle of healing"] = 41455,
	["judgment"] = 41467,
	["divine wrath"] = 41472,
	["reflective shield"] = 41475,
	["dampen magic"] = 41478,
	["spirit mend"] = 42025,
	["spirit heal"] = 42317,
	["protective ward"] = 42478,
	["army of the dead"] = 42650,
	["lesser heal death knight test"] = 42653,
	["frost tomb"] = 42672,
	["njord's rune of protection"] = 42740,
	["conjure refreshment"] = 42955,
	["test arcane shot lab"] = 43337,
	["avenging wrath"] = 43430,
	["orb of fire"] = 43509,
	["curse of the sepulcher"] = 43556,
	["anger of gjalerbron"] = 43560,
	["bash"] = 43612,
	["death shout"] = 43735,
	["prayer of fortitude"] = 43939,
	["conjure refreshment table"] = 43987,
	["lesser healing wave"] = 44256,
	["fire nova totem"] = 44257,
	["wing clip"] = 44286,
	["fel explosion"] = 44314,
	["arcane barrage"] = 44425,
	["living bomb"] = 44457,
	["wretched fireball"] = 44503,
	["wretched frostbolt"] = 44504,
	["fel armor"] = 44520,
	["deadly embrace"] = 44547,
	["flurry"] = 44614,
	["revitalize"] = 45027,
	["water breathing"] = 45328,
	["electrical overload"] = 45336,
	["test blazing blood"] = 45362,
	["soul flay"] = 45442,
	["ghost wolf"] = 45528,
	["legion lightning"] = 45664,
	["warsong mini-gun"] = 45745,
	["land mine barrier"] = 45750,
	["blood strike"] = 45902,
	["tempsmite"] = 46224,
	["anveena's prison"] = 46367,
	["flash of darkness"] = 46442,
	["portal: lower naxxanar"] = 46450,
	["portal: upper naxxanar (horde)"] = 46451,
	["portal: temple city of en'kilah"] = 46452,
	["copy of holy bolt"] = 46487,
	["ignite mana"] = 46543,
	["holyform"] = 46565,
	["test - frostfire 2"] = 46580,
	["raise dead"] = 46584,
	["portal: upper naxxanar (alliance)"] = 47278,
	["claw"] = 47468,
	["strangulate"] = 47476,
	["huddle"] = 47484,
	["penance"] = 47540,
	["empower rune weapon"] = 47568,
	["critter"] = 47731,
	["spark"] = 47751,
	["firebomb"] = 47773,
	["immolation trap"] = 47784,
	["guardian spirit"] = 47788,
	["arcane trap"] = 47789,
	["blood and thunder"] = 47902,
	["furyhammer's immunity"] = 47922,
	["demonic circle"] = 48018,
	["inner fire"] = 48168,
	["crystallize"] = 48179,
	["haunt"] = 48181,
	["rune of asvior"] = 48262,
	["rune of ubbi"] = 48264,
	["nightmare"] = 48319,
	["wild growth"] = 48438,
	["rune of binding"] = 48599,
	["obsidian essence"] = 48616,
	["anti-magic shell"] = 48707,
	["throw saw blade"] = 48984,
	["obliterate"] = 49020,
	["ignite fuel"] = 49063,
	["frost strike"] = 49143,
	["howling blast"] = 49184,
	["copy of 7th legion chain gun"] = 49195,
	["summon gargoyle"] = 49206,
	["dancing rune weapon"] = 49028,
	["teleport: stonard"] = 49358,
	["teleport: theramore"] = 49359,
	["portal: theramore"] = 49360,
	["portal: stonard"] = 49361,
	["summon shadowfiend"] = 49671,
	["front cannon"] = 49692,
	["rune of destruction"] = 49753,
	["air mine"] = 49814,
	["proximity mines"] = 49839,
	["rocket boost"] = 49847,
	["hex of the murloc"] = 49935,
	["smack"] = 49966,
	["touch of misery"] = 50090,
	["magic burn"] = 50198,
	["scalding blast"] = 50257,
	["flame fury"] = 50348,
	["inject plague"] = 50356,
	["engulfing flame"] = 50408,
	["engulfing flames"] = 50409,
	["diluted ethereum essence"] = 50425,
	["anti-magic zone"] = 50462,
	["wing buffet"] = 50521,
	["ice shard"] = 50578,
	["conversion beam"] = 50659,
	["the demoralizer"] = 50672,
	["meatpounder"] = 50676,
	["raven flock"] = 50740,
	["raven heal"] = 50750,
	["revive"] = 50769,
	["blood boil"] = 50842,
	["judgment of onslaught"] = 50905,
	["seal of onslaught"] = 50908,
	["raging consecration"] = 50915,
	["death gate"] = 50977,
	["cataclysm"] = 50980,
	["reconstruction"] = 50985,
	["crystal chains"] = 50997,
	["vampiric bolt"] = 51016,
	["frostbomb"] = 51103,
	["pillar of frost"] = 51271,
	["chaos bolt"] = 51287,
	["shadowflame"] = 51337,
	["decimate"] = 51339,
	["curse of impotence"] = 51340,
	["power release"] = 51431,
	["skin of earth"] = 51489,
	["lava burst"] = 51505,
	["raging shadows"] = 51622,
	["ram"] = 51678,
	["killing spree"] = 51690,
	["fan of knives"] = 51723,
	["blessing of zim'torga"] = 51729,
	["arcane infusion"] = 51732,
	["fire reflection"] = 51758,
	["frost reflection"] = 51763,
	["shadow reflection"] = 51764,
	["arcane reflection"] = 51766,
	["frostfire bolt"] = 51779,
	["mystical bolt"] = 51787,
	["runic intellect"] = 51799,
	["power flux"] = 51806,
	["fury of the blue"] = 51808,
	["deathbolt"] = 51854,
	["coldwind blast"] = 51877,
	["cleanse spirit"] = 51886,
	["teleport: zul'farrak"] = 51958,
	["renewing beam"] = 52011,
	["homing missile"] = 52053,
	["meatsaw"] = 52055,
	["summon explosive rune"] = 52144,
	["jump jets"] = 52197,
	["gundam shot"] = 52201,
	["lightning burst"] = 52269,
	["flame of the seer"] = 52281,
	["swift paws"] = 52358,
	["icy touch"] = 52372,
	["plague strike"] = 52373,
	["unholy frenzy"] = 52499,
	["steam blast"] = 52531,
	["nourish"] = 52554,
	["curse of fatigue"] = 52592,
	["scorpid sting"] = 52604,
	["savage roar"] = 52610,
	["arcane wave"] = 52660,
	["revitalizing rune"] = 52714,
	["renew steel"] = 52774,
	["arctic winds"] = 52814,
	["valroth's smite"] = 52926,
	["flurry of claws"] = 53032,
	["frozen deathbolt"] = 53114,
	["teleport: dalaran - northrend"] = 53140,
	["portal: dalaran - northrend"] = 53142,
	["chimaera shot"] = 53209,
	["assassinate"] = 53214,
	["divine storm"] = 53385,
	["zzoldsword of light"] = 53503,
	["beacon of light"] = 53563,
	["hammer of the righteous"] = 53595,
	["shield of the righteous"] = 53600,
	["poison bolt volley"] = 53616,
	["shadow bite"] = 54049,
	["maker's sanctuary"] = 54166,
	["earth's fury"] = 54193,
	["mend"] = 54194,
	["earth's wrath"] = 54195,
	["water blast"] = 54237,
	["increase critical strike chance 100%"] = 54283,
	["web shot"] = 54290,
	["uber spirit 80 buff"] = 54303,
	["icy veins"] = 54792,
	["missiles"] = 54900,
	["sawblade"] = 54904,
	["typhoon"] = 55087,
	["scourge strike"] = 55090,
	["vampiric blood"] = 55233,
	["mirror image"] = 55342,
	["light as a feather"] = 55416,
	["gymer's smash"] = 55426,
	["gymer's roar"] = 55429,
	["cleanse magic"] = 55598,
	["tranquilizing shot"] = 55625,
	["heart of the phoenix"] = 55709,
	["shockwave"] = 55918,
	["engulfing fireball"] = 55987,
	["engulf in flames"] = 56092,
	["ball lightning"] = 56319,
	["blessing of might"] = 56520,
	["blessing of wisdom"] = 56521,
	["rapid-fire harpoon"] = 56570,
	["time snap"] = 56686,
	["shadow sickle"] = 56702,
	["eyes in the dark"] = 56728,
	["dark counterspell"] = 56730,
	["punch"] = 56746,
	["stomp"] = 56747,
	["roar"] = 56748,
	["gale"] = 56861,
	["rhino strike"] = 56896,
	["storm call"] = 56897,
	["revivify"] = 57090,
	["flame shield"] = 57108,
	["life burst"] = 57143,
	["horn of winter"] = 57330,
	["land mines"] = 57375,
	["reckoning bomb"] = 57412,
	["eye of acherus"] = 57532,
	["greater turn evil"] = 57546,
	["fire cannon"] = 57609,
	["spell reflection"] = 57643,
	["crashing wave"] = 57652,
	["judgment of light"] = 57774,
	["mojo empowered fire ward"] = 57843,
	["blessing of kings"] = 58054,
	["unholy light"] = 58153,
	["hammer of injustice"] = 58154,
	["transferred power"] = 58187,
	["shield disruption"] = 58291,
	["deep freeze"] = 58534,
	["deathstorm"] = 58912,
	["gift of the lich king"] = 58916,
	["presence of the master"] = 58958,
	["launch bomb"] = 59059,
	["clever"] = 59202,
	["anti-air rocket"] = 59622,
	["tricks of the trade"] = 59628,
	["heartstrike"] = 59792,
	["suppression charge"] = 59880,
	["chaos blast"] = 59912,
	["lava lash"] = 60103,
	["hunger for blood"] = 60177,
	["arcane stream"] = 60181,
	["mana detonation"] = 60182,
	["sinister strike"] = 60195,
	["scroll of recall"] = 60322,
	["chained grip"] = 60540,
	["annihilate"] = 60642,
	["deathstrike"] = 60644,
	["back leap"] = 60793,
	["disengage"] = 60932,
	["spirit strike"] = 61193,
	["riptide"] = 61295,
	["survival instincts"] = 61336,
	["earthquake"] = 61882,
	["static disruption visual"] = 61914,
	["hand of reckoning"] = 62124,
	["speed boost"] = 62299,
	["runic shield"] = 62321,
	["runic lightning"] = 62327,
	["runic mending"] = 62328,
	["steam rush"] = 62346,
	["flame cannon"] = 62394,
	["transfer pressure to the weapon systems"] = 62425,
	["transfer pressure to the wheels"] = 62426,
	["increased speed"] = 62471,
	["hurl pyrite barrel"] = 62490,
	["flame lash"] = 62608,
	["power word: barrier"] = 62618,
	["shock grenade"] = 62645,
	["bind sight to depth charge"] = 62695,
	["ritual of summoning test"] = 62735,
	["reel in"] = 62806,
	["great heal"] = 62809,
	["sonic horn"] = 62974,
	["sara's blessing"] = 63134,
	["sara's fervor"] = 63138,
	["sara's anger"] = 63147,
	["hook"] = 63301,
	["dark transformation"] = 63560,
	["obsoleteblack arrow"] = 63672,
	["thunderstomp"] = 63900,
	["psychic horror"] = 64044,
	["plague of frogs"] = 64244,
	["melt ice"] = 64528,
	["throw glaive"] = 64664,
	["divine hymn"] = 64843,
	["twilight bolt"] = 65060,
	["emerald barrage"] = 65063,
	["flowers of the dead"] = 65393,
	["swipe"] = 65402,
	["pounce"] = 65407,
	["vampiric touch"] = 65490,
	["curse of exhaustion"] = 65815,
	["hellfire"] = 65816,
	["insect swarm"] = 65855,
	["force of nature"] = 65861,
	["dive"] = 65864,
	["explosive shot"] = 65866,
	["steady shot"] = 65867,
	["frost trap"] = 65880,
	["eviscerate"] = 65957,
	["blind"] = 65960,
	["windfury totem"] = 65990,
	["strength of earth totem"] = 65991,
	["tremor totem"] = 65992,
	["hand of protection"] = 66009,
	["hand of freedom"] = 66115,
	["napalm"] = 66186,
	["launch"] = 66218,
	["ardent defender"] = 66235,
	["radiance"] = 66862,
	["force punch"] = 67171,
	["fountain of light"] = 67194,
	["throw sawblade"] = 67212,
	["explosive punch"] = 67219,
	["blazing light"] = 67247,
	["vault cracked!"] = 67492,
	["devour magic"] = 67518,
	["spell lock"] = 67519,
	["hex of mending"] = 67534,
	["polymorph insect"] = 67794,
	["frostbite"] = 68246,
	["tidal wave"] = 68249,
	["water missile"] = 68250,
	["unstable searing totem"] = 68835,
	["corrupt soul"] = 68839,
	["unstable fire nova"] = 68847,
	["unstable water nova"] = 68881,
	["summon arcane construct"] = 68990,
	["unstable lightwell"] = 68993,
	["lay waste"] = 69325,
	["dark blessing"] = 69391,
	["incinerating blast"] = 69401,
	["empowered shadow bolt"] = 69528,
	["skybreaker battle standard"] = 69808,
	["kor'kron battle standard"] = 69809,
	["summon skybreaker battle standard"] = 69810,
	["summon kor'kron battle standard"] = 69811,
	["barrens bloom"] = 69867,
	["polymorph: spider"] = 70410,
	["regurgitated ooze"] = 70539,
	["chains of shadow"] = 70645,
	["vegard's thirst"] = 70886,
	["combobulating spray"] = 71103,
	["ice trap"] = 71249,
	["ice tomb"] = 71330,
	["teleport: booty bay"] = 71436,
	["death strike"] = 71489,
	["shadow infusion"] = 71516,
	["hammer of betrayal"] = 71784,
	["replenishing rains"] = 71956,
	["serpent ward"] = 71974,
	["shroud of protection"] = 72065,
	["shroud of spell warding"] = 72066,
	["cursed arrow"] = 72222,
	["ice shot"] = 72268,
	["debug heal"] = 72484,
	["plague blast"] = 73079,
	["leap of faith"] = 73325,
	["mana stream totem"] = 73393,
	["mind spike"] = 73510,
	["unleash life"] = 73685,
	["sun strike"] = 73872,
	["primal strike"] = 73899,
	["earth elemental totem"] = 73903,
	["healing rain"] = 73920,
	["necrotic strike"] = 73975,
	["astral rain"] = 74152,
	["blast nova"] = 74392,
	["storm blast"] = 74772,
	["lunar blessing"] = 75011,
	["curse of shadows"] = 75015,
	["defiled ground"] = 75016,
	["twilight's wrath"] = 75019,
	["bloody rip"] = 75160,
	["spinning rake"] = 75161,
	["burning shadowbolt"] = 75245,
	["flame wave"] = 75413,
	["black shot"] = 75439,
	["haunted touch"] = 75527,
	["tortured soul"] = 75528,
	["acid blast"] = 75637,
	["impaling pull"] = 75684,
	["spinning trident"] = 75698,
	["bubble blast"] = 75761,
	["rampant growth"] = 75790,
	["dark command"] = 75823,
	["fury of the storm"] = 75945,
	["fire and the flames"] = 75946,
	["lava bolt"] = 76110,
	["magma splash"] = 76170,
	["portal: hyjal"] = 76597,
	["vicious charge"] = 76664,
	["soul devour"] = 77001,
	["storm crow form"] = 77042,
	["purify spirit"] = 77130,
	["nimbus bolt"] = 77160,
	["flaming shard ball"] = 77467,
	["outbreak"] = 77575,
	["magma burst"] = 77703,
	["shadow weave"] = 77721,
	["void whip"] = 77722,
	["blazing shield"] = 78125,
	["fuse armor"] = 78128,
	["cauterize wound"] = 78183,
	["stoneskin totem"] = 78222,
	["flametongue weapon"] = 78273,
	["solar beam"] = 78675,
	["tender touch"] = 78965,
	["vendetta"] = 79140,
	["spiritwalker's grace"] = 79206,
	["elemental resistance totem"] = 79429,
	["flametongue totem"] = 79431,
	["twilight fireball"] = 79564,
	["twilight shockwave"] = 79565,
	["mangle"] = 79828,
	["feral charge - cat"] = 79830,
	["ice lance"] = 79859,
	["shadowstep"] = 79864,
	["deadly throw"] = 79866,
	["feral charge"] = 79870,
	["heart strike"] = 79885,
	["feral spirit"] = 79914,
	["soul link"] = 79957,
	["summon felguard"] = 79958,
	["seal of righteousness"] = 79962,
	["seal of truth"] = 79972,
	["magma eruption"] = 80038,
	["ignite"] = 80151,
	["havoc"] = 80240,
	["teleport: deepholm"] = 80256,
	["potion of treasure finding"] = 80263,
	["pulverize"] = 80313,
	["time warp"] = 80353,
	["curse of the legashi"] = 80966,
	["earth rending"] = 81133,
	["air blast"] = 81181,
	["dust devil"] = 81276,
	["rock barrage"] = 81306,
	["cave-in"] = 81309,
	["cold hearted"] = 81430,
	["fierce strike"] = 81460,
	["ground shock"] = 81530,
	["enveloping darkness"] = 82531,
	["rift barrage"] = 82878,
	["unholy darkness"] = 84013,
	["unholy smite"] = 84014,
	["twilight shield"] = 84052,
	["frozen orb"] = 84714,
	["twist phase"] = 84838,
	["light of dawn"] = 85222,
	["templar's verdict"] = 85256,
	["raging blow"] = 85288,
	["speed of light"] = 85499,
	["spectre blast"] = 85536,
	["festering strike"] = 85948,
	["overheat"] = 86633,
	["ancient guardian"] = 86657,
	["guardian of ancient kings"] = 86659,
	["spell ward"] = 86817,
	["shadow eruption"] = 86845,
	["flame jet"] = 87238,
	["inferno leap"] = 87653,
	["storm totem"] = 87720,
	["lightning lash"] = 87762,
	["wind shock"] = 88029,
	["teleport: tol barad"] = 88342,
	["portal: tol barad"] = 88345,
	["nature's cure"] = 88423,
	["summon bound groundshaker"] = 88439,
	["holy word: chastise"] = 88625,
	["anti-air homing missile"] = 88650,
	["zamael's prayer"] = 88663,
	["twilight immolate"] = 88771,
	["molten barrier"] = 89542,
	["felstorm"] = 89751,
	["flee"] = 89792,
	["singe magic"] = 89808,
	["whirling blades"] = 90397,
	["seaswell"] = 90398,
	["janet's heal"] = 90694,
	["janet's renew"] = 90696,
	["enhance magic"] = 91624,
	["plant sunflower"] = 91646,
	["plant spitter"] = 91649,
	["plant rocknut"] = 91704,
	["plant strangler vine"] = 91710,
	["reaper charge"] = 91726,
	["pressurized strike"] = 91727,
	["sweeping claws"] = 91778,
	["putrid bulwark"] = 91837,
	["plant pumpkin bomb"] = 92157,
	["froststorm breath"] = 92380,
	["plant freezya"] = 92440,
	["angry outburst"] = 92700,
	["nitrous boost"] = 92717,
	["fireblast"] = 92915,
	["twilight sunderbolt"] = 93044,
	["miasma of despair"] = 93045,
	["frost whirl"] = 93331,
	["sunfire"] = 93402,
	["burrow attack"] = 93433,
	["unleashed magic"] = 93556,
	["pain and suffering"] = 93581,
	["mend rotten flesh"] = 93654,
	["stormhammer"] = 93824,
	["test fireball"] = 95917,
	["frostburn formula"] = 96331,
	["hypothermia"] = 96332,
	["voodoo bolt"] = 96346,
	["bubbling mixture"] = 96804,
	["wild mushroom test"] = 97066,
	["blast wave test"] = 97071,
	["earthquake test"] = 97076,
	["sunfire test"] = 97224,
	["crush herbs"] = 97386,
	["poison explosion"] = 97516,
	["spirit link totem"] = 98008,
	["flame scythe"] = 98474,
	["leaping flames"] = 98476,
	["holy word: sanctuary"] = 98889,
	["starsurge"] = 98994,
	["dark song"] = 99107,
	["chilling song"] = 99108,
	["peaceful song"] = 99109,
	["stormfire"] = 99212,
	["cauterize"] = 99618,
	["overburn"] = 99939,
	["fieroblast"] = 100094,
	["furious slash"] = 100130,
	["tiger palm"] = 100780,
	["blackout kick"] = 100784,
	["living firebolt"] = 101325,
	["replenishing smoke"] = 101399,
	["spinning crane kick"] = 101546,
	["mass entanglement"] = 102359,
	["putrid spit"] = 102063,
	["shimmering strike"] = 102257,
	["ironbark"] = 102342,
	["cenarion ward"] = 102351,
	["cenarion ward"] = 102352,
	["wild charge"] = 102401,
	["incarnation: king of the jungle"] = 102543,
	["chains of frost"] = 102582,
	["hand of frost"] = 102593,
	["torrent of frost"] = 103904,
	["call dreadstalkers"] = 104316,
	["unending resolve"] = 104773,
	["hand of gul'dan"] = 105174,
	["shattered ice"] = 105289,
	["sling derk"] = 105762,
	["holy avenger"] = 105809,
	["bubble beam"] = 106718,
	["thrash"] = 106830,
	["thrash"] = 106832,
	["berserk"] = 106951,
	["rising sun kick"] = 107428,
	["avatar"] = 107574,
	["arcane annihilation"] = 107865,
	["twilight volley"] = 108172,
	["burst of speed"] = 108212,
	["stone bulwark totem"] = 108270,
	["astral shift"] = 108271,
	["windwalk totem"] = 108273,
	["healing tide totem"] = 108280,
	["ice floes"] = 108839,
	["dark pact"] = 108416,
	["lavaburst"] = 108442,
	["alter time"] = 108978,
	["exhilaration"] = 109304,
	["word of sha: agony"] = 110326,
	["divine star"] = 110744,
	["purifying flames"] = 110968,
	["inquisition"] = 111341,
	["surrender health"] = 111398,
	["fiery purge"] = 111580,
	["control undead"] = 111673,
	["demonic gateway"] = 111771,
	["grimoire: imp"] = 111859,
	["grimoire: voidwalker"] = 111895,
	["grimoire: succubus"] = 111896,
	["grimoire: felhunter"] = 111897,
	["grimoire: felguard"] = 111898,
	["summon fel imp"] = 112866,
	["summon voidlord"] = 112867,
	["summon shivarra"] = 112868,
	["summon observer"] = 112869,
	["summon wrathguard"] = 112870,
	["summon abyssal"] = 112921,
	["summon terrorguard"] = 112927,
	["frost bomb"] = 112948,
	["leap"] = 113190,
	["pesky pod"] = 113355,
	["fists of fury"] = 113656,
	["cindergut burn"] = 113698,
	["ring of frost"] = 113724,
	["shuriken toss"] = 114014,
	["ascendance"] = 114049,
	["light's hammer"] = 114158,
	["eternal flame"] = 114163,
	["holy prism"] = 114165,
	["treant form"] = 114282,
	["skin like wax"] = 114479,
	["spell damage % taken debuff"] = 114724,
	["reduce damage dealt percent debuff"] = 114730,
	["lava beam overload"] = 114738,
	["nether tempest"] = 114923,
	["expel harm"] = 115072,
	["paralysis"] = 115078,
	["renewing mist"] = 115151,
	["resuscitate"] = 115178,
	["breath of fire"] = 115181,
	["void shield"] = 115236,
	["mesmerize"] = 115268,
	["sear magic"] = 115276,
	["clone magic"] = 115284,
	["revival"] = 115310,
	["windstrike"] = 115356,
	["detox"] = 115450,
	["zzoldtemporal shield"] = 115610,
	["mortal cleave"] = 115625,
	["felbolt"] = 115746,
	["bladedance"] = 115748,
	["fellash"] = 115770,
	["tongue lash"] = 115778,
	["optical blast"] = 115781,
	["wrathstorm"] = 115831,
	["cobalt overload"] = 115840,
	["jade overload"] = 115842,
	["jasper overload"] = 115843,
	["amethyst overload"] = 115844,
	["rune of power"] = 116011,
	["disable"] = 116095,
	["angry monkey totem"] = 116470,
	["vivify"] = 116670,
	["effuse"] = 116694,
	["rushing jade wind"] = 116847,
	["life cocoon"] = 116849,
	["dragon roar"] = 118000,
	["flesh to stone"] = 118552,
	["wrath shield"] = 118638,
	["victory rush"] = 118779,
	["hex of lethargy"] = 118903,
	["cleansing flame"] = 118940,
	["breath of fear"] = 119414,
	["shield of protection"] = 119661,
	["jfh test spell"] = 119732,
	["command demon"] = 119898,
	["cauterize master"] = 119899,
	["ancient teleport: dalaran"] = 120145,
	["ancient portal: dalaran"] = 120146,
	["barrage"] = 120360,
	["submerge"] = 120455,
	["halo"] = 120517,
	["dire beast"] = 120679,
	["keg smash"] = 121253,
	["shadow blades"] = 121471,
	["monkey island totem"] = 121936,
	["bro grab not used"] = 122065,
	["mindbender"] = 123040,
	["invoke xuen, the white tiger"] = 123904,
	["touch of karma"] = 124280,
	["enveloping mist"] = 124682,
	["force bolt"] = 125011,
	["gift of amber"] = 125021,
	["censure of agony"] = 125278,
	["leeching fingers"] = 125290,
	["throw"] = 125517,
	["lightwell"] = 126135,
	["deluge"] = 126371,
	["frostjaw broken"] = 128077,
	["fel incinerate"] = 128658,
	["thunder"] = 128999,
	["heal me!"] = 129534,
	["chi burst"] = 130654,
	["soul reaper"] = 130736,
	["arcane brilliance"] = 130958,
	["fel storm"] = 131447,
	["ice column"] = 131559,
	["a murder of crows"] = 131894,
	["zzoldsavage defense"] = 132402,
	["pursuit"] = 132410,
	["chi wave"] = 132467,
	["portal: vale of eternal blossoms"] = 132620,
	["teleport: vale of eternal blossoms"] = 132621,
	["medi-beam"] = 133889,
	["protection field"] = 133890,
	["furious stone breath"] = 133939,
	["unleashed flame"] = 134611,
	["molten inferno"] = 134664,
	["evolution"] = 136209,
	["polymorph: goat"] = 136426,
	["spirit twisting"] = 136506,
	["spirit bolt"] = 136509,
	["storm shield"] = 136748,
	["spirit link idol"] = 136764,
	["lightning lance"] = 136828,
	["marked for death"] = 137619,
	["murderous strike"] = 138333,
	["fatal strike"] = 138334,
	["blooming breath"] = 138443,
	["strike"] = 138537,
	["teleport: shado-pan garrison"] = 138815,
	["soul sear"] = 139414,
	["vicious wound"] = 140274,
	["sand bolt"] = 141264,
	["frost totem"] = 141386,
	["hekima's wisdom"] = 141423,
	["bonechilling blizzard"] = 141428,
	["molt"] = 142651,
	["deafening screech"] = 143343,
	["regenerate"] = 143356,
	["glass shard"] = 143380,
	["war song"] = 143503,
	["kor'kron banner"] = 143591,
	["ravager"] = 143872,
	["swelling pride"] = 144400,
	["defensive stance"] = 145044,
	["turn evil"] = 145067,
	["efflorescence"] = 145205,
	["conjure icewall"] = 145297,
	["ice cluster"] = 145325,
	["freezing field"] = 145357,
	["taunt"] = 145481,
	["retaliation"] = 145485,
	["dash"] = 145626,
	["black arrow"] = 145665,
	["void blast"] = 146715,
	["void shock"] = 147089,
	["magma blast"] = 147102,
	["tumble"] = 147518,
	["flay"] = 147525,
	["fang strike"] = 147533,
	["soul fire"] = 150289,
	["wildfire"] = 151506,
	["clarity of will"] = 152118,
	["death from above"] = 152150,
	["serenity"] = 152173,
	["whirling dragon punch"] = 152175,
	["healing hydration"] = 152242,
	["seraphim"] = 152262,
	["defile"] = 152280,
	["corrupted healing totem summon"] = 152830,
	["meteor"] = 153561,
	["comet storm"] = 153595,
	["arcane orb"] = 153626,
	["pierce armor"] = 153794,
	["nature's fury"] = 154058,
	["dark blast"] = 154193,
	["inferno slice"] = 155080,
	["blast"] = 155209,
	["reanimate"] = 155213,
	["void entropy"] = 155361,
	["impale"] = 155998,
	["convulsive shadows"] = 156112,
	["retched blackrock"] = 156179,
	["bounding cleave"] = 156197,
	["acid torrent"] = 156240,
	["whirl of blood"] = 156366,
	["explosive shard"] = 156390,
	["sanguine strikes"] = 156601,
	["incendiary device"] = 156681,
	["blackrock nova"] = 156816,
	["blackrock barrage"] = 156877,
	["beacon of faith"] = 156910,
	["cloudburst totem"] = 157153,
	["demonbolt"] = 157695,
	["summon doomguard"] = 157757,
	["bloodsoaked heartseeker"] = 158008,
	["shield charge"] = 158136,
	["dark hunt"] = 158315,
	["taze"] = 158338,
	["deploy turret"] = 158599,
	["shadow zone"] = 158704,
	["summon shadow figurines"] = 158719,
	["summon shadow figurine"] = 158728,
	["infesting spores"] = 159996,
	["earth spike"] = 160165,
	["demon's bite"] = 162243,
	["samedi fetish"] = 162495,
	["chaos strike"] = 162794,
	["penetrating shot"] = 164264,
	["launch sawblade"] = 164583,
	["moonfire"] = 164812,
	["blazing wind totem summon"] = 164896,
	["pyre charge"] = 164906,
	["crushing earth"] = 165314,
	["flight form"] = 165962,
	["colossus smash"] = 167105,
	["chain lightning test"] = 167332,
	["aimed shot copy"] = 168941,
	["sacred earth totem"] = 168962,
	["anguish"] = 170176,
	["jealous kiss"] = 170852,
	["fiery nether blast"] = 171030,
	["shadow lock"] = 171138,
	["meteor strike"] = 171156,
	["rapid-fire rockets"] = 171654,
	["lob grenade"] = 171720,
	["cannon blast"] = 171950,
	["crystalline burst"] = 172108,
	["reckoning"] = 175366,
	["sacrificial pact"] = 175900,
	["convert demon"] = 175984,
	["mass polymorph"] = 176204,
	["teleport: warspear"] = 176242,
	["portal: warspear"] = 176244,
	["portal: stormshield"] = 176246,
	["teleport: stormshield"] = 176248,
	["sha'tari defender's medallion"] = 177192,
	["sha'tari defender"] = 177193,
	["trueshot"] = 177269,
	["chaos wave"] = 177288,
	["artifacts collected"] = 177393,
	["summon ice shard"] = 177599,
	["immolation aura"] = 178740,
	["zzoldsearing insanity"] = 179338,
	["ashes to ashes"] = 179546,
	["savage strikes"] = 180163,
	["death throes"] = 180224,
	["dread blades"] = 180374,
	["retrieving the ashbringer"] = 180850,
	["phase blink"] = 181138,
	["guiding light"] = 181197,
	["mannoroth's gaze"] = 181597,
	["empowered mannoroth's gaze"] = 182006,
	["harsh lessons"] = 182952,
	["consecration prototype"] = 183123,
	["stoneblood bolt"] = 183160,
	["hand of hindrance"] = 183218,
	["inspiring light"] = 183242,
	["blight"] = 183569,
	["create soulwell"] = 183601,
	["wrath of the ashbringer"] = 183649,
	["mortar shot"] = 183705,
	["light of the martyr"] = 183998,
	["machine gun"] = 184059,
	["light of the protector"] = 184092,
	["electro-net"] = 184110,
	["nitro injectors"] = 184114,
	["big bronze bomb"] = 184201,
	["short-range missiles"] = 184202,
	["rampage"] = 184367,
	["blade of justice"] = 184575,
	["purified ashbringer"] = 185068,
	["ashbringer"] = 185075,
	["blessing of the ancient watcher"] = 185088,
	["crimson vial"] = 185311,
	["shadow dance"] = 185313,
	["flamethrower"] = 185373,
	["shadowstrike"] = 185438,
	["slash"] = 185497,
	["poisoned knife"] = 185565,
	["pistol shot"] = 185763,
	["lacerate"] = 185855,
	["marked shot"] = 185901,
	["the blades of the fallen prince"] = 186202,
	["aspect of the turtle"] = 186265,
	["raptor strike"] = 186270,
	["aspect of the eagle"] = 186289,
	["bursting shot"] = 186387,
	["blades of the fallen prince"] = 186389,
	["siphon essence"] = 186470,
	["sundering stone"] = 186608,
	["holy might"] = 186987,
	["hand of sacrifice"] = 187190,
	["power of the ashbringer"] = 187350,
	["carve"] = 187708,
	["crash lightning"] = 187874,
	["taking the armaments"] = 188068,
	["earthen spike"] = 188089,
	["shatter"] = 188114,
	["blade dance"] = 188499,
	["rocket barrage"] = 188719,
	["torment bolt"] = 188927,
	["spike trap"] = 189223,
	["the twinblades of the deceiver"] = 189524,
	["stab"] = 190090,
	["vengeful retreat"] = 190229,
	["eye beam"] = 190232,
	["combustion"] = 190319,
	["ignore pain"] = 190456,
	["carrion blast"] = 190816,
	["legacy of the windrunners"] = 190852,
	["mongoose bite"] = 190928,
	["explosive trap"] = 191433,
	["scourge of worlds"] = 191747,
	["essence font"] = 191837,
	["lightning surge totem"] = 192058,
	["ironfur"] = 192081,
	["mark of ursol"] = 192083,
	["legion buster bomb"] = 192687,
	["kingsbane"] = 192759,
	["blood of the assassinated"] = 192923,
	["breaking free"] = 193017,
	["quake"] = 193152,
	["umbilicus eternus"] = 193213,
	["bleeding profusely"] = 193261,
	["saber slash"] = 193315,
	["roll the bones"] = 193316,
	["demonic empowerment"] = 193396,
	["demonwrath"] = 193440,
	["cobra shot"] = 193455,
	["aspect of the wild"] = 193530,
	["dreamwalk"] = 193753,
	["deep meditation"] = 193754,
	["stormcall"] = 193755,
	["naaru lightshift"] = 193757,
	["ritual of return"] = 193758,
	["teleport: hall of the guardian"] = 193759,
	["power of aegwynn"] = 193779,
	["rockbiter"] = 193786,
	["flametongue"] = 193796,
	["teleport: stormshield pvp vendors"] = 193807,
	["teleport: warspear pvp vendors"] = 193808,
	["ragnarok"] = 193826,
	["stampede"] = 193924,
	["hell burst"] = 194098,
	["mylra's magma totem"] = 194183,
	["taking the warswords"] = 194199,
	["celestial alignment"] = 194223,
	["volley"] = 194392,
	["spitting cobra"] = 194407,
	["plague-ridden stab"] = 194436,
	["highblade's will"] = 194462,
	["phoenix's flames"] = 194466,
	["power word: radiance"] = 194509,
	["rune tap"] = 194679,
	["bonestorm"] = 194844,
	["dragonsfire grenade"] = 194855,
	["glacial advance"] = 194913,
	["blighted rune weapon"] = 194918,
	["aldrachi brand"] = 195131,
	["marrowrend"] = 195182,
	["zzoldebonbolt"] = 195245,
	["death's caress"] = 195292,
	["hamlet's wrath"] = 195451,
	["nightblade"] = 195452,
	["strafe"] = 195467,
	["smouldering barrel"] = 195586,
	["black ice"] = 195615,
	["frost fever"] = 195621,
	["grasp felo'melorn"] = 196021,
	["purify soul"] = 196166,
	["purification"] = 196256,
	["cleanse soul"] = 196257,
	["natural cure"] = 196259,
	["rapid detox"] = 196261,
	["implosion"] = 196277,
	["channel demonfire"] = 196447,
	["raaaa-aaam"] = 196638,
	["refreshing jade wind"] = 196725,
	["blackout combo"] = 196736,
	["remorseless winter"] = 196770,
	["frostbrand"] = 196834,
	["feral lunge"] = 196884,
	["voodoo totem"] = 196932,
	["ghostly strike"] = 196937,
	["mechanostride"] = 197021,
	["fire the lasers"] = 197041,
	["fury of air"] = 197211,
	["sundering"] = 197214,
	["scald"] = 197346,
	["finality: eviscerate"] = 197393,
	["finality: nightblade"] = 197395,
	["lunar strike"] = 197628,
	["taking the spear"] = 197650,
	["shuriken storm"] = 197835,
	["wellspring"] = 197995,
	["divine hammer"] = 198034,
	["fire elemental"] = 198067,
	["power of the dark side"] = 198068,
	["brutal haymaker"] = 198245,
	["intercept"] = 198304,
	["holy weapon equipped passive"] = 198456,
	["fel weapon equipped passive"] = 198457,
	["shadow weapon equipped passive"] = 198458,
	["blood weapon equipped passive"] = 198459,
	["fire weapon equipped passive"] = 198460,
	["soul weapon equipped passive"] = 198461,
	["lightning weapon equipped passive"] = 198463,
	["water weapon equipped passive"] = 198465,
	["wind weapon equipped passive"] = 198466,
	["arcane weapon equipped passive"] = 198467,
	["ice weapon equipped passive"] = 198468,
	["brew weapon equipped passive"] = 198469,
	["mist weapon equipped passive"] = 198471,
	["nature weapon equipped passive"] = 198472,
	["blur"] = 198589,
	["piercing shot"] = 198670,
	["earthen shield totem"] = 198838,
	["cinderstorm"] = 198929,
	["drain soul"] = 198590,
	["earthen might"] = 199019,
	["sentinel"] = 199130,
	["spiked tongue"] = 199176,
	["death wish"] = 199261,
	["blessing of glory"] = 199455,
	["take the fists of the heavens"] = 199500,
	["lava weapon equipped passive"] = 199715,
	["glacial spike"] = 199786,
	["i am the weapons of storm"] = 199795,
	["between the eyes"] = 199804,
	["curse of tongues"] = 199890,
	["retrieving the claws of ursoc"] = 199953,
	["curse of fragility"] = 199954,
	["beacon of virtue"] = 200025,
	["ranger's net"] = 200108,
	["take maw of the damned"] = 200136,
	["throwing axes"] = 200163,
	["take thas'dorah"] = 200264,
	["magma wave"] = 200418,
	["despair"] = 200642,
	["tyr's deliverance"] = 200652,
	["gloomblade"] = 200758,
	["exsanguinate"] = 200806,
	["plea"] = 200829,
	["adaptive fur"] = 200850,
	["rage of the sleeper"] = 200851,
	["gory fur"] = 200854,
	["soulstone"] = 201060,
	["snake hunter"] = 201078,
	["annihilation"] = 201427,
	["fury of the illidari"] = 201467,
	["anguish of the deceiver"] = 201473,
	["uh oh..."] = 201729,
	["take the blade"] = 201776,
	["boulderfist"] = 201897,
	["windsong"] = 201898,
	["brutal slash"] = 202028,
	["spinning fire blossom"] = 202077,
	["enraged mangle"] = 202085,
	["sweeping strikes"] = 202161,
	["impending victory"] = 202168,
	["zzoldseal of light"] = 202273,
	["brewmaster staff sheathing passive"] = 202286,
	["blessing of the ancients"] = 202360,
	["i am sheilun staff of the mists"] = 202385,
	["ancestral healing"] = 202495,
	["curse of the dreadblades"] = 202665,
	["new moon"] = 202767,
	["half moon"] = 202768,
	["zzoldblade of wrath"] = 202270,
	["full moon"] = 202771,
	["flanking strike"] = 202800,
	["blunderbuss"] = 202895,
	["moon and stars"] = 202940,
	["star power"] = 202942,
	["sniper shot"] = 203155,
	["rip and tear"] = 203242,
	["greater pyroblast"] = 203286,
	["fury of the eagle"] = 203415,
	["neltharion's fury"] = 203524,
	["dragon scales"] = 203576,
	["overgrowth"] = 203651,
	["fel cannonball"] = 203702,
	["demon spikes"] = 203720,
	["eagle's bite"] = 203757,
	["shear"] = 203783,
	["blessing of spellwarding"] = 204018,
	["blessed hammer"] = 204019,
	["fiery brand"] = 204021,
	["bastion of light"] = 204035,
	["shadow covenant"] = 204065,
	["on the trail"] = 204081,
	["windburst"] = 204147,
	["purge the wicked"] = 204197,
	["shining force"] = 204263,
	["spirit link"] = 204293,
	["skyfury totem"] = 204330,
	["counterstrike totem"] = 204331,
	["focused rage"] = 204488,
	["doom winds"] = 204945,
	["ray of frost"] = 205021,
	["presence of mind"] = 205025,
	["flame on"] = 205029,
	["frozen touch"] = 205030,
	["charged up"] = 205032,
	["void torrent"] = 205065,
	["phantom singularity"] = 205179,
	["summon darkglare"] = 205180,
	["eye for an eye"] = 205191,
	["consumption"] = 205223,
	["healing sphere"] = 205234,
	["wake of ashes"] = 205273,
	["strike of the windlord"] = 205320,
	["phoenix reborn"] = 205393,
	["sheilun's gift"] = 205406,
	["zzoldapocalypse"] = 205488,
	["stormkeeper"] = 205495,
	["blackout strike"] = 205523,
	["odyn's fury"] = 205545,
	["call of nightmares"] = 205588,
	["enveloping shadows"] = 206237,
	["shiv"] = 206328,
	["titan's thunder"] = 207068,
	["pinned prey"] = 207144,
	["giving"] = 207158,
	["ritual of cleansing"] = 207215,
	["frostscythe"] = 207230,
	["don's fireball"] = 207246,
	["obliteration"] = 207256,
	["clawing shadows"] = 207311,
	["epidemic"] = 207317,
	["aldrachi design"] = 207343,
	["dark arbiter"] = 207349,
	["painbringer"] = 207387,
	["ancestral protection totem"] = 207399,
	["soul carver"] = 207407,
	["call of the mother tree"] = 207583,
	["ashbringer's light"] = 207604,
	["shadowy duel"] = 207736,
	["dismantle"] = 207777,
	["gift of the queen"] = 207778,
	["light's wrath"] = 207946,
	["light of t'uure"] = 208065,
	["charlestest2"] = 208134,
	["essence of g'hanir"] = 208253,
	["toranaar's defiance"] = 208323,
	["call of the warblades"] = 208464,
	["dire beast: hawk"] = 208652,
	["doomhammer off-hand active"] = 208717,
	["doomhammer off-hand dissolving"] = 208729,
	["charlestest - slow flash"] = 208778,
	["tidal totem"] = 209069,
	["eye of tyr"] = 209202,
	["last resort"] = 209258,
	["uncontained fel"] = 209261,
	["corrupted blood of zakajz"] = 209566,
	["warbreaker"] = 209577,
	["sharas'dal, scepter of the tides"] = 209683,
	["goremaw's bite"] = 209782,
	["peter's test beam"] = 209794,
	["fracture"] = 209795,
	["power of the waves"] = 209842,
	["play dead"] = 209997,
	["unending thirst"] = 210081,
	["death sweep"] = 210152,
	["word of glory"] = 210191,
	["despawn all followers"] = 210247,
	["a ring unbroken - abandon"] = 210301,
	["open wounds"] = 210666,
	["ashamane's bite"] = 210702,
	["ashamane's rip"] = 210705,
	["ashamane's frenzy"] = 210722,
	["mark of aluneth"] = 210726,
	["eye of fate"] = 210984,
	["chaos blades"] = 211048,
	["fel barrage"] = 211053,
	["desiccating stomp"] = 211073,
	["replenishing roots"] = 211619,
	["thal'kiel's consumption"] = 211714,
	["thal'kiel's discord"] = 211727,
	["titanic power"] = 211740,
	["retrieving the skull of the man'ari"] = 211766,
	["fel eruption"] = 211881,
	["overcharged"] = 211970,
	["unbound touch"] = 211989,
	["mass resurrection"] = 212036,
	["aluneth drinks"] = 212044,
	["ancestral vision"] = 212048,
	["reawaken"] = 212051,
	["absolution"] = 212056,
	["fel devastation"] = 212084,
	["symbols of death"] = 212283,
	["cleaver"] = 212333,
	["vile gas"] = 212338,
	["gastric bloat"] = 212383,
	["protective bile"] = 212384,
	["butchery"] = 212436,
	["call fel lord"] = 212459,
	["wraith walk"] = 212552,
	["shimmer"] = 212653,
	["forces of nightmare"] = 212726,
	["soulgorge"] = 212744,
	["imparting wisdom"] = 212869,
	["retrieving the fangs of ashamane"] = 212994,
	["power thrusters"] = 213043,
	["steam clean"] = 213045,
	["portal: archmage vargoth's retreat"] = 213075,
	["felblade"] = 213241,
	["soulburn"] = 213398,
	["wanderer's special"] = 213435,
	["cursed crew"] = 213522,
	["holy ward"] = 213610,
	["purify disease"] = 213634,
	["cleanse toxins"] = 213644,
	["fate and fortune blood drinking aura"] = 213721,
	["execution sentence"] = 213757,
	["swipe"] = 213764,
	["aluneth charge whispers half-hour timer"] = 214074,
	["aluneth charge whispers"] = 214077,
	["summon aluneth charge bunny"] = 214098,
	["rule of law"] = 214202,
	["exploding keg"] = 214326,
	["scepter of tides afk aura"] = 214330,
	["sidewinders"] = 214579,
	["schism"] = 214621,
	["the hungering maw"] = 214903,
	["soulbiter"] = 214904,
	["fleshsearer"] = 214906,
	["chaos burn"] = 214907,
	["soulgorger"] = 214909,
	["goldrinn's fury"] = 214910,
	["fangs of the first"] = 214911,
	["ursoc's bond"] = 214912,
	["g'hanir's bloom"] = 214913,
	["windflight arrows"] = 214915,
	["voice of the wild gods"] = 214916,
	["ancient power"] = 214917,
	["empowered spellblade"] = 214918,
	["spellborne"] = 214919,
	["wanderer's hardiness"] = 214920,
	["mistweaving"] = 214921,
	["windborne blows"] = 214922,
	["silver touch"] = 214923,
	["unrelenting light"] = 214924,
	["forbidden flame"] = 214925,
	["darkening whispers"] = 214927,
	["slayer's precision"] = 214928,
	["cursed steel"] = 214929,
	["legionblade"] = 214930,
	["stormkeeper's power"] = 214931,
	["earthshattering blows"] = 214932,
	["flow of the tides"] = 214933,
	["soulstealer"] = 214934,
	["thal'kiel's lingering power"] = 214935,
	["stolen power"] = 214936,
	["unbreakable steel"] = 214937,
	["unbreakable bulwark"] = 214939,
	["bringing the light..."] = 215258,
	["punch out!"] = 215373,
	["the maw must feed"] = 215377,
	["justicar's vengeance"] = 215661,
	["truthseeker"] = 215854,
	["divine light"] = 216008,
	["the silver hand"] = 216318,
	["ancient dream"] = 216516,
	["tormented souls"] = 216695,
	["reap souls"] = 216698,
	["zeal"] = 217020,
	["dire frenzy"] = 217200,
	["retrieving fu zan"] = 217814,
	["empower wards"] = 218256,
	["shield of blood"] = 218281,
	["spirit bomb"] = 218679,
	["siphoned power"] = 218713,
	["arcane eclipse"] = 218838,
	["stonebolt"] = 219091,
	["flame bolt"] = 219202,
	["emmarel's assault"] = 219698,
	["summon emmarel shadewarden"] = 219700,
	["test enslave"] = 219707,
	["summon snowfeather"] = 219906,
	["falling rainbow"] = 220255,
	["getsam"] = 220340,
	["emanation of the winds"] = 220584,
	["twisting anima of souls"] = 220645,
	["runes of the darkening"] = 220651,
	["the bonereaper's hook"] = 220655,
	["guise of the deathwalker"] = 220658,
	["bulwark of the iron warden"] = 220662,
	["the sunbloom"] = 220663,
	["acorn of the endless"] = 220679,
	["designs of the grand architect"] = 220681,
	["syriel crescentfall's notes: ravenguard"] = 220683,
	["last breath of the forest"] = 220684,
	["the stars' design"] = 220690,
	["everburning crystal"] = 220691,
	["legend of the monkey king"] = 220692,
	["breath of the undying serpent"] = 220693,
	["the stormfist"] = 220694,
	["lost secrets of the watcher"] = 220696,
	["spark of the fallen exarch"] = 220699,
	["heart of corruption"] = 220701,
	["writings of the end"] = 220703,
	["staff of the lightborn"] = 220705,
	["claw of n'zoth"] = 220706,
	["the cypher of broken bone"] = 220708,
	["tome of otherworldly venoms"] = 220709,
	["lost codex of the amani"] = 220710,
	["the warmace of shirvallah"] = 220712,
	["coil of the drowned queen"] = 220715,
	["rite of the executioner"] = 220718,
	["visage of the first wakener"] = 220724,
	["the burning jewel of sargeras"] = 220729,
	["strom'kar, the bladebreaker"] = 220731,
	["the dragonslayers"] = 220732,
	["burning blood of the worldbreaker"] = 220734,
	["fulminate"] = 221164,
	["furious winds"] = 221202,
	["summon shadow dagger general  bunny"] = 221565,
	["casting circle"] = 221703,
	["light of the naaru"] = 222122,
	["aluneth dungeon whispers two-hour timer"] = 222299,
	["aluneth dalaran whispers (voice)"] = 222395,
	["summon aluneth dalaran bunny"] = 222398,
	["aluneth dalaran whispers control"] = 222401,
	["aluneth dalaran whispers four-hour timer"] = 222412,
	["aluneth general  whispers one-hour timer"] = 222423,
	["aluneth oom whispers (voice)"] = 222426,
	["summon aluneth oom  bunny"] = 222427,
	["aluneth invis whispers (voice)"] = 222430,
	["summon aluneth invis  bunny"] = 222431,
	["aluneth food whispers (voice)"] = 222601,
	["summon aluneth food  bunny"] = 222602,
	["aluneth spellsteal whispers (voice)"] = 222609,
	["summon aluneth spellsteal bunny"] = 222610,
	["aluneth portal whispers (voice)"] = 222611,
	["summon aluneth portal bunny"] = 222612,
	["summon thal'kiel general bunny"] = 222651,
	["summon thal'kiel history bunny"] = 222660,
	["bestow faith"] = 223306,
	["screech"] = 223565,
	["skull of the manari wander aura"] = 223917,
	["cook the books"] = 224716,
	["crusade"] = 224668,
	["teleport: dalaran - broken isles"] = 224869,
	["portal: dalaran - broken isles"] = 224871,
	["mass slow"] = 225254,
	["spit blood"] = 225379,
	["shield of the magi"] = 226024,
	["writhing deep"] = 226194,
	["divine miracle"] = 226277,
	["curse of night"] = 226407,
	["arcane force"] = 227045,
	["moon fall"] = 227082,
	["stormrage"] = 227102,
	["fury of the cosmos"] = 227154,
	["warhawk"] = 227160,
	["soul barrier"] = 227225,
	["bladestorm"] = 227847,
	["void eruption"] = 228260,
	["soul cleave"] = 228477,
	["cancel aura"] = 228755,
}
