--
--	Grail NPCs
--	Written by scott@mithrandir.com
--
--	Version History
--		Stopped keeping history as it was not maintained.
--
--	Each NPC value is a table that can contain:
--		[1] index into Grail.npcNames
--		[2]	code information (see below) like map location
--		[3] optional friendly notes
--		[4] optional faction association
--
--	NPC Codes
--		A:npcId			npcId that is what Blizzard returns for this alias NPC
--		Created			indicates item is created by player
--		D:<npc list>	comma separated list of NPC IDs that drop this item
--		H<holidayCode>	holidayCode is a single character indicating the holiday the NPC is available
--		K:<quest list>	comma separated list of quest IDs for which this is killed
--		Mailbox			indicates item in a mailbox (any map area)
--		Mailbox<mapId>	indicates item in a mailbox in the specified map area
--		N:npcId			npcId whose name is to be used for this NPC
--		Near			indicates the NPC is nearby (any map area)
--		Near<mapId>		indicates the NPC is nearby in the specified map area
--		Preowned		indicates item is already owned
--		Q:<quest list>	comma separated list of quest IDs to which this is associated
--		Self			special NPC indicator for Self (the player)
--		X				indicates NPC is in heroic only
--		Z<mapId>		indicates NPC found in the map area
--		anything else should be the format (without spaces):
--			mapId [mapLevel] : xx.xx , yy.yy > realMapId
--		the "[mapLevel]" is only required for maps with levels, most do not need it
--		the "> realMapId" indicates the coordinates are in a map that contains the realMap...this allows an outer map to show a point for maps that are contained within
--
--	Known issues
--
--
--	Alliance Garrison small plot top step locations:
--		18:	971:46.99,59.27
--		19:	971:50.03,57.75
--		20:	971:51.19,63.58
--	Alliance Garrison medium plot basic entrance locations:
--		22:	971:35.53,49.36
--		25: 971:51.21,47.04
--	Alliance Garrison large plot basic entrance locations:
--		23:	971:45.25,42.49
--		24:	971:40.09,56.58
--
--	Horde Garrison small plot top step locations:
--		18:	976:52.44,37.06
--		19:	976:48.38,33.59
--		20: 976:52.59,40.81
--	Horde Garrison medium plot basic entrance locations:
--		22: 976:51.43,57.39
--		25:	976:57.75,28.14
--	Horde Garrison large plot basic entrance locations:
--		23: 976:58.88,49.06
--		24: 976:60.36,36.51
--
--	Dungeon entrances:
--		Ulduar					495:41.57,17.83
--		Thunder					928:63.73,32.23
--		SM Graveyard 762[1]		20:84.87,30.61
--		SM Cathedral 762[4]		20:85.35,30.62
--		SM Library 762[2]		20:85.29,32.14
--		SM Armory 762[3]		20:85.62,31.59
--		Mechanar				479:70.59,69.73
--		Tempest Keep			479:73.73,63.74
--		Botanica				479:71.72,55.02
--		Arcatraz				479:74.37,57.74
--		Auchanai Crypts			478:34.34,65.61
--		Sethekk Halls			478:44.91,65.61
--		Shadow Labyrinth		478:39.63,73.54
--		Mana Tombs				478:39.63,57.67
--		Blood Furnace			465:46.03,51.79
--		Shattered Halls			465:47.68,51.99
--		Hellfire Ramparts		465:47.63,53.57
--		Black Temple			473:71.05,46.45
--		Grim Batol				700:19.18,54.01
--		Gate of the Setting Sun	811:15.84,74.39
--		Shado-Pan Monastery		809:36.66,47.33
--		Temple of Jade Serpent	806:56.18,57.87
--		Auchindoun				946:46.31,73.93
--		Bloodmaul Slag Mines	941:49.85,24.75
--		Zul Aman				463:82.14,64.35
--
--	UTF-8 file
--
Grail_NPCs_File_Version = 015

if Grail.npcsVersionNumber < Grail_NPCs_File_Version then
Grail.npcsVersionNumber = Grail_NPCs_File_Version

Grail.npcs = {}

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.npcs

if release >= 0 then
G[-220949]={0,'949:56.01,6.68 N:0'}
G[-210949]={0,'949:59.62,33.29 N:0'}
G[-200949]={0,'949:68.63,34.22 N:0'}
G[-190949]={0,'949:57.00,35.88 N:0'}
G[-180949]={0,'949:46.38,92.46 N:0'}
G[-170949]={0,'949:43.10,65.92 N:0'}
G[-170948]={0,'948:71.80,34.57 N:0'}
G[-160949]={0,'949:60.88,53.39 N:0'}
G[-160948]={0,'948:60.45,12.34 N:0'}
G[-150949]={0,'949:51.36,77.64 N:0'}
G[-150948]={0,'948:52.98,14.77 N:0'}
G[-150947]={0,'947:50.41,89.60 N:0'}
G[-150941]={0,'941:49.15,21.37 N:0'}
G[-140949]={0,'949:49.23,80.94 N:0'}
G[-140948]={0,'948:39.46,61.66 N:0'}
G[-140947]={0,'947:63.70,93.94 N:0'}
G[-140941]={0,'941:42.58,12.62 N:0'}
G[-131018]={0,'1018:39.25,52.58 N:0'}
G[-131015]={0,'1015:51.78,44.29 N:0'}
G[-130950]={0,'950:55.06,12.38 N:0'}
G[-130949]={0,'949:44.93,48.23 N:0'}
G[-130948]={0,'948:75.05,26.11 N:0'}
G[-130947]={0,'947:42.08,57.34 N:0'}	-- ? 53.12,65.38
G[-130946]={0,'946:61.33,54.52 N:0'}
G[-130941]={0,'941:70.11,26.84 N:0'}
G[-130038]={0,'38:74.10,44.46 N:0','Down in temple'}
G[-121018]={0,'1018:66.20,44.76 N:0'}
G[-121015]={0,'1015:50.08,15.42 N:0'}
G[-120950]={0,'950:38.52,39.49 N:0'}
G[-120949]={0,'949:42.24,63.34 N:0'}
G[-120948]={0,'948:72.90,32.44 N:0'}
G[-120947]={0,'947:58.48,32.70 N:0'}
G[-120946]={0,'946:83.64,30.93 N:0'}
G[-120941]={0,'941:64.02,16.66 N:0'}
G[-120753]={0,'753[2]:68.39,64.35 N:0'}
G[-120038]={0,'38:76.62,41.53 N:0'}
G[-111018]={0,'1018:59.41,84.12 N:0'}
G[-111015]={0,'1015:57.82,43.42 N:0'}
G[-110950]={0,'950:39.69,14.87 N:0'}
G[-110949]={0,'949:52.36,64.17 N:0'}
G[-110948]={0,'948:70.51,21.94 N:0'}
G[-110947]={0,'947:58.12,59.79 N:0'}
G[-110946]={0,'946:73.60,23.92 N:0'}
G[-110941]={0,'941:66.80,49.53 N:0'}
G[-110857]={0,'857:45.15,84.88 N:0'}
G[-110753]={0,'753[2]:66.03,71.46 N:0'}
G[-110038]={0,'38:77.58,46.02 N:0'}
G[-101024]={0,'1024:38.52,39.78 N:0'}
G[-101018]={0,'1018:46.22,67.82 N:0'}
G[-101017]={0,'1017:42.02,64.49 N:0'}
G[-101015]={0,'1015:57.99,58.20 N:0'}
G[-100978]={0,'978:42.33,81.16 N:0'}
G[-100976]={0,'976:63.61,45.19 N:0'}
G[-100950]={0,'950:44.12,74.66 N:0'}
G[-100949]={0,'949:48.04,55.65 N:0'}
G[-100948]={0,'948:67.45,21.81 N:0'}
G[-100947]={0,'947:25.62,32.89 N:0'}
G[-100946]={0,'946:55.28,23.50 N:0'}
G[-100941]={0,'941:20.94,57.92 N:0'}
G[-100857]={0,'857:66.52,29.42 N:0'}
G[-100811]={0,'811:22.75,27.54 N:0'}
G[-100753]={0,'753[1]:53.98,21.30 N:0'}
G[-100673]={0,'673:61.20,44.29 N:0'}
G[-100606]={0,'606:7.56,34.57 N:0'}
G[-100201]={0,'201:64.93,16.64 N:0'}
G[-100043]={0,'43:40.51,53.32 N:0'}
G[-100038]={0,'38:74.82,49.36 N:0'}
G[-100037]={0,'37:78.51,35.68 N:0'}
G[-100036]={0,'36:32.38,39.40 N:0'}
G[-100028]={0,'28:23.06,35.52 N:0'}
G[-100011]={0,'11:62.86,61.80 N:0'}
G[0]={0,'Self'}
G[1]={1,'1 AdventureGuide'}
G[3]={3,'807:51.70,48.32'}
G[4]={100020483,'893:41.78,71.14'}
G[46]={46,'30:79.78,55.52'}
G[68]={68,'301:70.25,83.80'}
G[114]={114,'39:54,36 H:100057935'}
G[126]={126,'39:53,11 H:100001357'}
G[171]={171,'39:53,11 H:100001357'}
G[197]={197,'864:33.54,52.98'}
G[198]={198,'864:38.77,43.48 30:49.66,39.40>864','Upstairs'}
G[210]={210,'34:17.63,28.95'}
G[233]={233,'39:56.04,31.23'}
G[234]={234,'39:56.33,47.53'}
G[235]={235,'39:56.42,30.53'} -- also moves to 39:56.48,30.38
G[240]={240,'30:42.11,65.93'}
G[241]={241,'30:42.1,67.2'}
G[244]={244,'30:34.6,84.4'}
G[246]={246,'30:34.4,84.3'}
G[247]={247,'30:43.1,85.8'}
G[248]={248,'30:34.9,84'}
G[251]={251,'30:43.1,89.6'}
G[252]={252,'30:29.9,86'}
G[253]={253,'30:43.3,65.8'}
G[255]={255,'30:43.10,85.52'}
G[261]={261,'30:73.97,72.18'}
G[263]={263,'34:71.93,46.44'}
G[264]={264,'34:73.53,46.91'}
G[265]={265,'34:75.81,45.29'}
G[267]={267,'34:72.45,46.91'}
G[268]={268,'34:72.60,47.75'}
G[272]={272,'34:73.90,43.92'}
G[273]={273,'34:74.09,44.72'}
G[276]={276,'34:79.54,47.46'}
G[278]={278,'30:79.46,68.71'}
G[288]={288,'34:18.62,58.35'}
G[289]={289,'34:87.43,35.23'}
G[294]={294,'30:84.60,69.38'}
G[295]={295,'30:43.77,65.82'}
G[302]={302,'34:81.95,59.24'}
G[311]={311,'34:7.8,34.6'}
G[331]={331,'301:49.26,87.77','In tower'}
G[332]={332,'301:81.32,63.51'}
G[342]={342,'36:22.04,42.70'}
G[344]={344,'36:28.90,41.12'}
G[352]={352,'301:70.93,72.48'}
G[375]={375,'864:39.31,43.77 30:49.81,39.49>864'}
G[376]={376,'301:49.53,44.60'}
G[379]={379,'36:15.62,65.33'}
G[382]={382,'36:31.85,44.90'}
G[384]={384,'30:84.15,65.49'}
G[392]={392,'39:30.51,85.61'}
G[415]={415,'36:29.4,43.4 36:29.4,43.5 36:29.5,43.1 36:29.8,43.6 36:31.1,47.4 36:31.1,47.5'}
G[423]={423,'36:16.87,57.92'}
G[430]={430,'36:22,33 H:100058898'}
G[445]={445,'36:22,33 H:100058898'}
G[446]={446,'36:22,33 H:100058898'}
G[448]={448,'30:24.81,95.17'}
G[456]={456,'39:56.2,7.2 H:100001357'}
G[459]={459,'864:39.54,55.11 30:49.87,42.65>864'}
G[460]={460,'27:33.25,38.39>895 895:37.68,37.95'}
G[461]={461,'301:39.25,84.96','In basement'}
G[464]={464,'36:15.32,64.59','Top of tower'}
G[466]={466,'301:69.16,82.73'}
G[469]={469,'37:47.57,10.26'}
G[513]={513,'39:40,14 H:100001357'}
G[514]={514,'30:41.70,65.55'}
G[515]={515,'39:53,9 H:100001357'}
G[523]={523,'39:56.6,49.4'}
G[576]={576,'34:74.20,47.02'}
G[620]={620,'39:56,31'}
G[658]={658,'866:65.68,43.56 27:35.56,70.32>866'}
G[661]={661,'34:75.39,49.01'}
G[663]={663,'34:75.33,48.01'}
G[715]={715,'37:44.02,23.29 37:44.18,22.97'} -- 689:35.7,10.7
G[716]={716,'37:44.24,22.13'}
G[717]={717,'37:44.50,22.67'}
G[718]={718,'37:43.72,22.28 37:44.18,22.27'}
G[733]={733,'37:47.53,10.74'}
G[739]={739,'37:47.25,11.11'}
G[770]={770,'37:47.10,10.70'}
G[773]={773,'37:43.61,23.13'} -- 689:27,77.2
G[786]={786,'866:42.71,62.24 27:32.06,74.17>866'}
G[793]={793,'36:32.31,39.43'}
G[821]={821,'39:56.46,47.57'}
G[823]={823,'864:35.71,39.82'}
G[837]={837,'866:60.72,14.68 27:35.6,64.8>866'}
G[878]={878,'39:56.39,47.35'}
G[888]={888,'34:45.11,67.02'}
G[895]={895,'866:63.65,20.09 27:36.1,65.9>866'}
G[900]={900,'36:28.67,40.95'}
G[911]={911,'864:40.87,53.80 30:50.24,42.28>864'}
G[912]={912,'866:61.89,19.01 27:35.8,65.7>866'}
G[914]={914,'301:79.44,68.89','Upstairs'}
G[915]={915,'864:41.13,45.29 30:50.31,39.91>864'}
G[916]={916,'866:59.56,20.41 27:35.5,66>866'}
G[918]={918,'301:77.51,65.35'}
G[925]={925,'864:41.55,53.24 30:50.43,42.12>864'}
G[926]={926,'866:61.91,24.55 27:35.8,66.7>866'}
G[928]={928,'301:52.85,44.91'}
G[931]={931,'36:29.42,53.76'}
G[951]={951,'864:34.96,38.61 30:48.75,37.82>864'} -- 30:48.56,38.03 30:48.46,38.25
G[963]={963,'30:24.23,74.46'}
G[1068]={1068,'17:17.7,43.8'}
G[1071]={1071,'40:49.80,18.26'}
G[1073]={1073,'35:64.25,26.69'}
G[1089]={1089,'35:23.33,74.94'}
G[1090]={1090,'35:23.30,75.06'}
G[1092]={1092,'35:23.38,75.04'}
G[1104]={1104,'866:61.70,22.07 27:35.80,66.26>866'}
G[1105]={1105,'35:37.24,47.39'}
G[1139]={1139,'35:34.6,43.2 35:34.6,44.6 35:34.7,43.6'}
G[1141]={1141,'301:51.77,93.60'}
G[1142]={1142,'37:46,51 H:100058491'}
G[1144]={1144,'37:46,51 H:100058491'}
G[1153]={1153,'35:37.1,46.3 35:37.2,47.8'}
G[1154]={1154,'35:81.76,61.67'}
G[1156]={1156,'35:81.92,64.61'}
G[1165]={1165,'35:68.01,66.02'}
G[1187]={1187,'35:83.46,65.41'}
G[1217]={1217,'40:10.59,60.59'}
G[1239]={1239,'40:10.95,59.73'}
G[1243]={1243,'27:40.7,65.1 27:47.8,63.4 27:47.8,63.5'}
G[1247]={1247,'27:54.49,50.85'}
G[1252]={1252,'27:53.9,52.1'}
G[1254]={1254,'27:76.32,54.67'}
G[1261]={1261,'27:70.64,48.95'} -- 27:70.67,48.87
G[1265]={1265,'27:70.28,48.16'}
G[1266]={1266,'27:34.6,51.6'}
G[1267]={1267,'27:53.93,50.68'}
G[1269]={1269,'27:53.3,51.9'}
G[1274]={1274,'341:41,54.8'}
G[1293]={1293,'488:85.95,50.86','In mausoleum'}
G[1298]={1298,'301:58.35,69.03'}
G[1317]={1317,'301:52.89,74.44'}
G[1323]={1323,'301:77.18,61.00'}
G[1340]={1340,'35:35.06,46.60'}
G[1343]={1343,'35:25.45,17.95'}
G[1344]={1344,'35:65.33,65.98'}
G[1345]={1345,'35:64.89,66.65'}
G[1354]={1354,'866:43.22,63.12 27:32.16,74.34>866'}
G[1355]={1355,'27:75.6,52.8'}
G[1356]={1356,'341:75.8,11.8'}
G[1365]={1365,'HV 341:30.25,59.43'}
G[1374]={1374,'27:54.2,51.2'}
G[1376]={1376,'27:50.4,49.1 27:57.5,47.4'}
G[1378]={1378,'27:49.4,48.4 27:49.5,48.4 27:53.3,51.9'}
G[1379]={1379,'35:56.3,65.9 35:56.5,65.9 35:58.5,64.5'}
G[1416]={1416,'301:59.72,33.79'}
G[1422]={1422,'37:46.99,10.85'}
G[1427]={1427,'301:62.31,67.94'}
G[1428]={1428,'301:58.10,67.49'}
G[1429]={1429,'301:52.58,83.40'}
G[1431]={1431,'301:60.27,76.75'}
G[1432]={1432,'301:63.77,73.59'}
G[1435]={1435,'301:40.13,85.29'}
G[1449]={1449,'673:54.18,46.44'}
G[1465]={1465,'35:37.19,46.40'}
G[1484]={1484,'40:11.86,57.90'}
G[1493]={1493,'673:35.46,63.66'}
G[1495]={1495,'20:65.49,60.25'}
G[1496]={1496,'20:52.54,54.82'}
G[1499]={1499,'20:61.02,50.56'} -- 20:61.08,50.65 20:60.95,50.46 20:60.91,50.59 20:61.08,50.52 20:60.99,50.47
G[1500]={1500,'20:54.60,29.89'}
G[1515]={1515,'20:60.54,51.86'}
G[1518]={1518,'20:44.62,53.78'}
G[1519]={1519,'20:44.75,53.67'}
G[1521]={1521,'20:65.25,60.42'}
G[1535]={1535,'20:34,48 H:100052079'}
G[1547]={1547,'20:66,56 K:24992'}
G[1548]={1548,'20:56.6,63.8 K:24992'}
G[1561]={1561,'673:41.28,61.15'}
G[1568]={1568,'892:43.42,79.91 20:30.06,71.29>892'}
G[1569]={1569,'892:46.65,58.80 20:30.84,66.20>892'}
G[1570]={1570,'892:55.47,37.75 20:32.97,61.12>892'}
G[1571]={1571,'40:9.4,59.6'}
G[1572]={1572,'35:33.93,50.94'}
G[1573]={1573,'341:55.54,47.76'}
G[1658]={1658,'20:52.6,26.2 H:100003082'}
G[1661]={1661,'892:46.74,58.22 20:30.87,66.05>892'}
G[1682]={1682,'35:35.46,48.53'}
G[1684]={1684,'35:41.52,39.04'}
G[1694]={1694,'27:50.1,49.4 27:57.2,47.7'}
G[1699]={1699,'27:54.73,50.59'}
G[1740]={1740,'892:49.89,56.23 20:31.63,65.57>892'}
G[1745]={1745,'20:60.13,52.39'}
G[1747]={1747,'301:85.71,31.58'}
G[1776]={1776,'38:26.8,33.4 38:26.9,33.7'}
G[1777]={1777,'35:35.43,42.84'}
G[1780]={1780,'21:34.27,16.60'}
G[1854]={1854,'22:52.01,82.88','Circles the statue'}
G[1872]={1872,'27:53.13,49.99'}
G[1931]={1931,'20:44.70,52.62'}
G[1938]={1938,'21:47.07,43.21'}
G[1959]={1959,'341:41.44,52.29'}
G[1960]={1960,'35:14.00,56.49'}
G[1963]={1963,'35:34.83,49.28'}
G[1977]={1977,'27:75.90,54.31'}
G[1992]={1992,'41:42.52,58.18'}
G[2020]={2020,'41:37.05,25.42'}
G[2055]={2055,'382:48.4,69.2'}
G[2057]={2057,'35:56.36,65.98'}
G[2077]={2077,'888:45.94,72.89 41:58.04,38.79>888'}
G[2078]={2078,'41:55.69,52.00'}
G[2079]={2079,'888:45.62,74.55 41:57.96,39.19>888'}
G[2080]={2080,'41:59.93,59.76'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[2081]={2081,'41:55.66,51.99'}
G[2083]={2083,'41:55.77,50.44'}
G[2104]={2104,'40:10.52,55.71'}
G[2107]={2107,'41:64.58,51.13','Upstairs'}
G[2119]={2119,'892:54.17,56.38 20:32.66,65.61>892'}
G[2122]={2122,'892:53.67,56.54 20:32.54,65.65>892'}
G[2123]={2123,'892:47.74,58.16 20:31.11,66.03>892'}
G[2124]={2124,'892:47.04,58.28 20:30.94,66.07>892'}
G[2126]={2126,'892:46.95,59.38 20:30.91,66.34>892'}
G[2150]={2150,'41:59.52,49.18'}
G[2151]={2151,'41:49.35,44.68'}
G[2211]={2211,'20:60.04,52.87','Upstairs'}
G[2215]={2215,'24:29.23,63.34'}
G[2227]={2227,'382:57.61,93.82'}
G[2229]={2229,'24:57.68,46.90'}
G[2278]={2278,'24:57.27,46.34'}
G[2285]={2285,'301:81.55,34.07'}
G[2299]={2299,'29:72.09,65.69'}
G[2307]={2307,'892:45.93,80.47 20:30.67,71.42>892'}
G[2368]={2368,'24:56.4,84 H:100063686'}
G[2369]={2369,'24:52.4,77 H:100063686'}
G[2370]={2370,'24:58.2,84 H:100063686'}
G[2371]={2371,'24:52.6,75.6 H:100063686'}
G[2372]={2372,'24:56.4,74.2 24:57,74.6 24:57.2,74.3 24:57.4,75.6 24:57.6,74.6 24:57.7,74.4 24:57.9,72.3 24:58.2,73.3 24:58.5,73.1 24:58.7,75 24:58.9,74.4'}
G[2373]={2373,'24:59.6,73.6'}
G[2391]={2391,'24:49.10,66.36'}
G[2397]={2397,'24:57.68,45.24'}
G[2409]={2409,'34:77.49,44.29'}
G[2418]={2418,'24:57.19,45.53'}
G[2419]={2419,'24:57.16,45.53'}
G[2437]={2437,'24:57.00,45.72'}
G[2439]={2439,'301:85.68,31.03'}
G[2460]={2460,'341:26.06,69.82'}
G[2461]={2461,'341:26.01,69.65'}
G[2464]={2464,'37:38.40,50.46'}
G[2465]={2465,'37:38.35,51.07'}
G[2486]={2486,'673:41.81,72.84'}
G[2487]={2487,'673:41.10,73.27'}
G[2488]={2488,'673:40.68,73.82'}
G[2490]={2490,'673:42.58,72.00'}
G[2493]={2493,'673:43.39,71.49'}
G[2495]={2495,'37:43.66,23.46'}
G[2496]={2496,'673:41.18,73.06'} -- 689:27.2,76.9
G[2497]={2497,'37:38.42,48.71'}
G[2500]={2500,'673:40.32,67.79'}
G[2501]={2501,'673:42.07,73.39'}
G[2502]={2502,'673:40.54,67.72'}
G[2519]={2519,'37:63.09,41.51'}
G[2545]={2545,'673:44.45,92.89','Walks a short path here'} -- 673:44.57,93.58 673:44.41,92.65
G[2546]={2546,'673:46.70,95.34','Inside lower ship'}
G[2547]={2547,'673:46.7,95'}
G[2548]={2548,'673:44.43,91.55','Inside lower ship'} -- 673:44.50,91.57 673:44.41,91.45
G[2549]={2549,'673:44.45,91.89'}
G[2592]={2592,'16:30.02,59.70'}
G[2608]={2608,'16:39.98,47.82'}
G[2610]={2610,'16:26,83.9'}
G[2634]={2634,'673:59.46,79.05'}
G[2650]={2650,'26:25,59 H:100008704'}
G[2653]={2653,'26:35,65 H:100008704'}
G[2654]={2654,'26:36,71 H:100008704'}
G[2696]={2696,'16:43.2,92.6'}
G[2700]={2700,'16:40,48.8'}
G[2705]={2705,'24:52.2,58.6'}
G[2707]={2707,'26:35,71 H:100008704'}
G[2712]={2712,'16:54.8,55.3'}
G[2713]={2713,'16:54.89,55.46'}
G[2748]={2748,'692:56.6,53.6'}
G[2766]={2766,'16:25.2,85.5 16:25.4,85.2 16:25.5,85.2'}
G[2768]={2768,'16:27.58,83.01'}
G[2769]={2769,'16:27.72,83.27'}
G[2771]={2771,'16:68.98,34.80'}
G[2774]={2774,'16:27.56,82.91'}
G[2784]={2784,'341:40,55'}
G[2785]={2785,'17:26.21,62.30'}
G[2787]={2787,'16:69.68,36.53'}
G[2789]={2789,'16:40.3,49'}
G[2835]={2835,'16:39.90,47.34'}
G[2858]={2858,'673:40.60,73.42'}
G[2859]={2859,'673:41.67,74.53'}
G[2860]={2860,'17:49.49,36.99'}
G[2916]={2916,'341:77.53,11.81'}
G[2918]={2918,'341:33.10,48.58'}
G[2920]={2920,'17:26.28,62.54'}
G[2941]={2941,'28:37.94,30.86'}
G[2947]={2947,'9:48.79,58.79'}
G[2948]={2948,'9:48.62,59.80'}
G[2976]={2976,'9:53.58,48.27'}
G[2980]={2980,'890:39.45,37.25 9:48.95,78.35>890'}
G[2981]={2981,'890:27.74,28.32 9:45.15,75.46>890'}
G[2984]={2984,'9:32.8,36.1'}
G[2985]={2985,'9:47.50,61.32'}
G[2987]={2987,'9:49.59,17.59'}
G[2988]={2988,'9:57.05,60.43'}
G[2994]={2994,'9:60.79,22.67'}
G[2995]={2995,'362:47.02,49.61'}
G[3007]={3007,'362:41.8,42.8'}
G[3009]={3009,'382:46.61,33.15'}
G[3026]={3026,'362:51.75,53.09'}
G[3028]={3028,'362:56.14,46.37'}
G[3032]={3032,'362:21.96,18.83'}	-- Replaced by 51639?
G[3033]={3033,'362:76.47,27.25'}
G[3034]={3034,'362:77.15,27.04'}
G[3039]={3039,'362:57.29,89.78'}
G[3042]={3042,'362:56.98,89.55'}
G[3045]={3045,'362:24.54,22.56'}
G[3047]={3047,'362:22.74,14.53'}
G[3050]={3050,'362:44.1,44.6'}
G[3052]={3052,'9:49.68,17.23'}
G[3054]={3054,'9:47.88,57.10'}
G[3055]={3055,'9:47.16,56.66'}
G[3056]={3056,'9:44.42,17.19 H:100004854'}
G[3057]={3057,'362:60,51.7'}
G[3059]={3059,'9:45,75.4'}
G[3060]={3060,'9:45.22,75.12'}
G[3061]={3061,'9:45.27,75.30'}
G[3062]={3062,'9:45.1,75.1'}
G[3064]={3064,'9:48.6,59'}
G[3079]={3079,'9:46.06,58.19'}
G[3139]={3139,'4:51.95,43.50'}
G[3140]={3140,'4:55.42,75.10'}
G[3142]={3142,'4:52.24,43.15'}
G[3143]={3143,'889:44.93,66.43 4:44.95,66.42>889'}
G[3144]={3144,'321[1]:49.20,72.26'}
G[3145]={3145,'889:45.82,63.44 4:43.46,67.50>889'}
G[3153]={3153,'889:43.56,71.15 4:42.88,69.47>889'}
G[3154]={3154,'4:42.9,69.3'}
G[3155]={3155,'889:41.53,68.56 4:42.36,68.81>889'}
G[3156]={3156,'889:41.59,65.61 4:41.59,65.61>889'}
G[3157]={3157,'889:41.63,69.32 4:42.39,69.00>889'}
G[3188]={3188,'4:55.95,74.72'}
G[3193]={3193,'4:43.38,30.63'}
G[3208]={3208,'4:56.41,20.04'}
G[3216]={3216,'321[2]:58.22,54.61'}
G[3230]={3230,'465:55,36'}
G[3233]={3233,'9:49.52,17.10'}
G[3279]={3279,'11:26.38,28.59'}
G[3287]={3287,'889:34.62,44.21 4:40.60,62.58>889'}
G[3292]={3292,'11:67.69,72.85'}
G[3293]={3293,'4:46.37,22.94'}
G[3309]={3309,'321:49.6,69.4'}
G[3310]={3310,'321[1]:49.64,59.21'}
G[3326]={3326,'321[1]:54.27,34.67'}
G[3332]={3332,'321:66.4,41.7'}
G[3336]={3336,'4:50.85,43.59'}
G[3337]={3337,'11:67.66,39.39'}
G[3338]={3338,'11:49.99,59.84'}
G[3339]={3339,'11:67.72,74.00'}
G[3341]={3341,'607:49.22,82.37'}
G[3344]={3344,'321:39,47.4'}
G[3345]={3345,'321[1]:53.48,49.54'}
G[3347]={3347,'321[1]:55.68,45.76'}
G[3352]={3352,'321[1]:63.88,32.52'}
G[3353]={3353,'321:73.3,45.4'}
G[3355]={3355,'321:76.3,34.6'}
G[3359]={3359,'321[1]:66.47,49.02'}
G[3362]={3362,'321:61.1,35.2 321:61.2,34 321:61.4,35.5 321:61.5,34.3 321:61.5,35.4 321:61.5,35.5 321:69.2,13.2'}
G[3383]={3383,'11:77.29,91.32'}
G[3387]={3387,'607:41.52,47.19'}
G[3389]={3389,'11:37.83,55.27'}
G[3390]={3390,'11:48.59,58.33'}
G[3391]={3391,'11:68.41,69.06'}
G[3399]={3399,'321[1]:32.24,69.65'}
G[3411]={3411,'81:72.05,91.20'}
G[3412]={3412,'321[1]:56.30,56.37'}
G[3418]={3418,'607:41.62,46.51'}
G[3429]={3429,'11:48.70,59.60'}
G[3432]={3432,'11:55.17,41.02'}
G[3433]={3433,'607:41.73,46.64'}
G[3439]={3439,'11:57.54,18.31'}
G[3441]={3441,'362:61.52,80.85'}
G[3442]={3442,'11:62.29,17.48'}
G[3446]={3446,'11:67.86,71.50'}
G[3448]={3448,'11:49.49,58.67'}
G[3449]={3449,'11:30.58,45.93'}
G[3453]={3453,'11:69.59,72.98'}
G[3454]={3454,'607:68.6,44.5'}
G[3464]={3464,'11:66.86,72.79'}
G[3467]={3467,'11:69.91,85.21'}
G[3489]={3489,'11:50.6,57.8'}
G[3494]={3494,'11:68.39,69.20'}
G[3514]={3514,'888:47.20,55.95 41:58.35,34.60>888'}
G[3515]={3515,'41:55.82,53.90'}
G[3516]={3516,'381:24.4,48.8 381:24.5,48.8 381:33.8,10 381:34.3,8.2 381:34.4,8.5 381:34.5,8.4 381:34.6,10.6 381:34.8,9 381:35.3,9.6 381:35.5,9.1 381:39.4,10.7'}
G[3517]={3517,'41:43.96,44.17'}
G[3518]={3518,'301:27.7,38 301:43.2,73.6 301:59.9,69.3 301:59.9,70.1 301:60.1,71.3 301:60.2,68 301:60.3,66.8 301:60.3,71.9 301:60.4,72.5 301:60.5,67.6 301:60.5,72.4 301:60.6,67.4 301:60.8,73.1 301:61,73.7 301:61.4,66.4 301:61.4,74.5 301:61.5,74.8 301:61.6,66.5 301:61.8,66.1 301:61.9,73.8 301:62.4,71 301:62.4,71.6 301:62.4,73.3 301:62.6,72.7 301:62.8,65.9 301:62.9,70.3 301:63.3,71.3 301:63.3,72 301:63.5,71.7 301:63.6,66.3 301:63.6,72.5 301:63.7,71.4 301:63.8,66.5 301:64.1,75 301:64.3,70.4 301:64.3,73.7 301:64.4,67.6 301:64.5,66.4 301:64.5,67.4 301:64.5,73.4 301:64.5,74.5 301:64.6,70.2 301:64.7,74.2 301:64.9,68.4 301:65,68.9 301:65,75.5 301:65.2,76.7 301:65.4,70.6 301:65.5,69.4 301:65.5,76.1 301:65.6,74.8 301:66.2,76.8 301:66.4,70.4 301:66.4,71.4 301:66.4,71.9 301:66.5,71.4 301:66.6,71.6 301:67.3,72.5 301:67.6,72.4 301:67.6,72.7'}
G[3519]={3519,'41:39.50,29.86'}
G[3521]={3521,'11:67.81,40.56'}
G[3535]={3535,'41:52,63.8 H:100005179'}
G[3567]={3567,'41:55.55,49.99'}
G[3568]={3568,'41:34.50,27.82'}
G[3593]={3593,'888:49.19,52.44'}
G[3594]={3594,'888:49.21,53.19 41:58.85,33.92>888'}
G[3595]={3595,'888:47.59,59.45 41:58.45,35.47>888'}
G[3596]={3596,'888:49.21,60.54 41:58.85,35.74>888'}
G[3597]={3597,'888:46.60,56.65 41:58.20,34.78>888'}
G[3610]={3610,'41:55.61,51.49'}
G[3615]={3615,'11:48.7,58.7'}
G[3654]={3654,'749[1]:33.63,14.74'}
G[3674]={3674,'749[1]:61.62,73.41'}
G[3685]={3685,'9:47.5,58.5 9:47.6,58'}
G[3690]={3690,'9:47.6,58'}
G[3691]={3691,'43:36.6,49.6'}
G[3694]={3694,'42:42.51,45.15'}
G[3698]={3698,'43:18,60'}
G[3838]={3838,'41:55.41,88.40'}
G[3841]={3841,'42:51.72,17.65'}
G[3845]={3845,'43:18.3,20.4 43:18.3,20.5'}
G[3846]={3846,'43:18.2,20.6 43:18.3,20.4'}
G[3847]={3847,'43:26.8,36.7'}
G[3848]={3848,'43:85.3,44.4 43:85.3,44.7'}
G[3880]={3880,'43:59,58.8'}
G[3881]={3881,'4:50.74,42.84'}
G[3885]={3885,'43:35.6,71.4 43:35.6,71.5'}
G[3887]={3887,'764[1]:0.00,0.00'}
G[3891]={3891,'43:20.3,38.8'}
G[3894]={3894,'43:37.3,51.8'}
G[3897]={3897,'43:50.9,75.1'}
G[3901]={3901,'43:86.3,44.1 43:86.4,43.1 43:86.7,43 43:87,43.5'}
G[3916]={3916,'43:59.1,59.7'}
G[3920]={3920,'43:78.3,44.9'}
G[3936]={3936,'121:46.03,49.11'}
G[3978]={3978,'362:33.9,47 362:34,46.4 362:34.1,47.6 362:34.6,47.4 362:34.8,48'}
G[3995]={3995,'81:71.12,91.22'}
G[3996]={3996,'43:35.8,49.2'}
G[4046]={4046,'362:70.3,30.8 362:70.7,30.7'}
G[4079]={4079,'43:34.9,49.8'}
G[4087]={4087,'381:56.54,45.99'}
G[4138]={4138,'381:43.5,25.9'}
G[4155]={4155,'381:43.4,51.3 381:43.6,51.2'}
G[4156]={4156,'381:49.10,60.95'}
G[4160]={4160,'381:53.90,38.52'}
G[4202]={4202,'81:63.1,46'}
G[4210]={4210,'381:49.87,36.65'}
G[4214]={4214,'381:40.4,39.2'}
G[4217]={4217,'381:40.5,27.6'}
G[4256]={4256,'341:51.47,26.32'}
G[4265]={4265,'41:56.73,53.51'}
G[4267]={4267,'43:34.41,47.99'}
G[4278]={4278,'764[1]:30.30,69.70'}
G[4311]={4311,'4:46.01,13.79'}
G[4321]={4321,'141:67.48,51.30'}
G[4407]={4407,'81:40.12,31.96'}
G[4421]={4421,'761[1]:22.41,31.65'}
G[4468]={4468,'26:63,76.6  H:100008704'}
G[4486]={4486,'16:13.76,33.91'}
G[4498]={4498,'101:52.2,53.5'}
G[4500]={4500,'141:36.29,31.41'}
G[4501]={4501,'141:37.15,33.08'}
G[4502]={4502,'141:37.36,31.39'}
G[4508]={4508,'761:33,33'}
G[4544]={4544,'121:74.7,43.5 121:75,43 121:76,42.8'}
G[4549]={4549,'382:65.95,49.66'}
G[4551]={4551,'382:63.27,48.58'}
G[4552]={4552,'382:62.17,44.90'}
G[4556]={4556,'382:61.50,41.80'}
G[4563]={4563,'382:86.23,15.97'}
G[4566]={4566,'382:84.97,14.05'}
G[4573]={4573,'382:81.71,31.23'}
G[4584]={4584,'382:84.87,73.54'}
G[4586]={4586,'382:6.3,68.3 382:35,2.2 382:63.9,80.6 382:75,74 382:75.1,172.2 382:75.2,74.5 382:75.4,72.8 382:75.6,74.5 382:75.8,73.4 382:75.8,73.6 382:76.2,72.4 382:78.6,9.2'}
G[4593]={4593,'382:46.90,15.22'}
G[4606]={4606,'382:49.28,17.05'}
G[4611]={4611,'382:47.78,73.37'}
G[4618]={4618,'17:26.19,62.45'}
G[4656]={4656,'101:33.8,53.6 H:100038567'}
G[4663]={4663,'101:55,28.8 H:100049010,100049203'}
G[4664]={4664,'101:56,29.6 H:100049010,100049203'}
G[4665]={4665,'101:52.6,29.4 H:100049010,100049203'}
G[4666]={4666,'101:55.8,28.6 H:100049010,100049203'}
G[4667]={4667,'101:55,26.4 H:100049010,100049203'}
G[4673]={4673,'101:74.78,13.30'}
G[4730]={4730,'381:42.49,32.60'}
G[4732]={4732,'30:84.32,64.87'}
G[4752]={4752,'321:61.4,34.4 321:61.4,34.7 321:61.4,35.5 321:61.5,34.4 321:61.5,34.5 321:69.4,12.6'}
G[4753]={4753,'381:42.77,32.93'}
G[4772]={4772,'27:71.15,48.41'}
G[4773]={4773,'20:61.88,51.86'}
G[4787]={4787,'688[1]:20.83,75.28'}
G[4791]={4791,'141:35.21,30.66'}
G[4792]={4792,'141:55.44,26.27'}
G[4794]={4794,'141:68.27,48.71'}
G[4854]={4854,'692[1]:22.90,26.22'}
G[4855]={4855,'692[1]:24.13,27.03'}
G[4880]={4880,'141:46.89,17.52'}
G[4921]={4921,'141:66.16,46.07'}
G[4926]={4926,'141:36.42,31.88'}
G[4941]={4941,'141:64.75,50.42'}
G[4943]={4943,'362:54.05,80.72'}
G[4944]={4944,'141:68.21,48.62'}
G[4948]={4948,'141:68.04,48.11'}
G[4949]={4949,'321:32.3,37.8 321:32.5,38.7 321:32.8,37.8'}
G[4968]={4968,'141:66.26,49.05','Top floor of tower'}
G[4983]={4983,'141:40.96,36.71'}
G[5086]={5086,'141:59.67,41.06'}
G[5087]={5087,'141:36.53,30.80'}
G[5089]={5089,'141:36.09,54.31'}
G[5099]={5099,'341:25.71,69.67'}
G[5111]={5111,'341:18.14,51.41'}
G[5115]={5115,'341:71.00,89.69'}
G[5146]={5146,'341:25.93,6.14','Up the ramp'}
G[5147]={5147,'341:23.69,5.05','Up the ramp'}
G[5150]={5150,'341:55.09,58.26','Upstairs'}
G[5159]={5159,'341:60.09,36.44'}
G[5161]={5161,'341:48.11,7.64'}
G[5165]={5165,'341:51.83,14.75'}
G[5173]={5173,'341:50.06,7.42'}
G[5174]={5174,'341:68.46,43.55'}
G[5177]={5177,'341:66.59,55.70'}
G[5296]={5296,'121:53.2,31.8 H:100055166,100055167'}
G[5297]={5297,'121:54.6,33.8 H:100055166,100055167'}
G[5299]={5299,'121:53.6,32 H:100055166,100055167'}
G[5385]={5385,'19:63.19,16.85'}
G[5387]={5387,'341:69.91,18.55'}
G[5390]={5390,'121:75.1,42.8'}
G[5393]={5393,'19:60.10,13.49'}
G[5395]={5395,'101:56.3,59.4 101:56.3,59.5'}
G[5396]={5396,'101:66.67,10.94'}
G[5412]={5412,'101:56.3,59.4 101:56.3,59.5'}
G[5419]={5419,'161:48,41 H:100008623'}
G[5457]={5457,'161:33.6,48 H:100008623'}
G[5494]={5494,'301:55.03,69.69'}
G[5496]={5496,'301:39.66,85.71'}
G[5499]={5499,'301:55.65,86.09'}
G[5504]={5504,'301:64.55,37.58'}
G[5511]={5511,'301:63.65,36.98'}
G[5518]={5518,'301:62.84,31.97'}
G[5519]={5519,'301:63.53,31.08'}
G[5543]={5543,'362:28.03,25.22'}
G[5594]={5594,'161:50.9,27 161:50.9,28'}
G[5636]={5636,'26:9.90,44.23'}
G[5637]={5637,'341:68.40,19.95'}
G[5638]={5638,'101:66.2,9.7'}
G[5639]={5639,'321[1]:46.78,58.89 321[1]:52.25,54.33'}
G[5640]={5640,'321[1]:27.99,61.31'}
G[5641]={5641,'101:52.6,54.3'}
G[5642]={5642,'101:66.44,11.82'}
G[5709]={5709,'687:0.00,0.00'}
G[5752]={5752,'101:66.74,10.87'}
G[5767]={5767,'749[1]:46.61,58.42'}
G[5768]={5768,'749[1]:46.65,59.21'}
G[5769]={5769,'362:30.3,68.5 362:30.7,68.4 362:30.9,68.9 362:30.9,69.5 362:45.7,22.7 362:78.1,29.5 362:78.4,28.4 362:78.4,28.7 362:78.5,28.3 362:78.5,28.7'}
G[5770]={5770,'362:75.3,30.5 362:75.5,30.4 362:75.6,31.1 362:75.7,31.5'}
G[5775]={5775,'749[1]:56.79,47.81'}
G[5860]={5860,'28:23.18,35.31'}
G[5887]={5887,'889:41.72,69.98 4:42.40,69.18>889'}
G[5907]={5907,'11:56.4,40.4 11:56.4,40.6 11:56.8,40.3'}
G[6019]={6019,'101:47.83,61.82'}
G[6030]={6030,'35:23.6,74.4 35:23.6,74.5'}
G[6031]={6031,'341:48.77,42.55'}
G[6034]={6034,'381:60.3,37.1 381:60.5,37'}
G[6073]={6073,'43:82.6,69.6 H:100023777,100023797'}
G[6115]={6115,'43:82.6,69.6 H:100023777,100023797'}
G[6206]={6206,'691[2]:68.41,62.58'}
G[6212]={6212,'691:41.6,71.6 H:100009326'}
G[6235]={6235,'691[1]:0.00,0.00'}
G[6294]={6294,'341:74.34,9.47'}
G[6329]={6329,'691[1]:0.00,0.00'}
G[6546]={6546,'141:46.02,57.10'}
G[6566]={6566,'382:77.87,75.96'}
G[6569]={6569,'341:69.22,50.57'}
G[6577]={6577,'35:81.65,64.75'}
G[6706]={6706,'101:64.66,10.53'}
G[6735]={6735,'381:62.54,32.77'}
G[6736]={6736,'41:55.37,52.23'}
G[6740]={6740,'301:60.42,75.24'}
G[6741]={6741,'382:67.73,37.88'}
G[6746]={6746,'362:45.80,64.65'}
G[6766]={6766,'24:67.2,46.4 24:67.2,46.7 24:69.1,44.2 24:70.5,44.9'}
G[6774]={6774,'864:24.08,73.35 30:45.56,47.75>864'}
G[6780]={6780,'888:54.56,84.72 41:60.17,41.71>888'}
G[6782]={6782,'866:87.50,44.46 27:40.88,70.67>866'}
G[6785]={6785,'20:61.87,51.96'}
G[6826]={6826,'341:36.36,3.63'}
G[6887]={6887,'42:39.1,43.1'}
G[6929]={6929,'321[1]:53.63,78.79'}
G[7010]={7010,'321:55.2,55.8'}
G[7023]={7023,'692[1]:29.07,59.02'}
G[7024]={7024,'39:68.32,70.38'}
G[7079]={7079,'691[1]:0.00,0.00'}
G[7156]={7156,'182:63.2,9 H:100020741'}
G[7157]={7157,'182:62.8,13.6 H:100020741'}
G[7158]={7158,'182:63.8,6.8 H:100020741'}
G[7172]={7172,'692[2]:50.26,34.47'}
G[7206]={7206,'692[1]:43.95,41.09'}
G[7269]={7269,'686:57.2,55.6 H:100008623'}
G[7272]={7272,'686:57.97,25.81'}
G[7286]={7286,'686:44.03,16.40'}
G[7291]={7291,'692[1]:26.53,34.81'}
G[7313]={7313,'41:39.18,29.88 41:39.25,29.73'}
G[7316]={7316,'381:36.08,53.48'}
G[7317]={7317,'41:45.03,53.48',"In Ban'ethil Barrow Den"}
G[7323]={7323,'24:71.41,44.96'}
G[7361]={7361,'691[1]:75.99,66.68'}
G[7363]={7363,'19:48.77,31.75'}
G[7406]={7406,'673:43,72.1'}
G[7407]={7407,'686:58.16,89.10 161:39.22,21.34>686'}
G[7438]={7438,'281:67.8,50.2 H:100064353'}
G[7439]={7439,'281:67.8,50.2 H:100064353'}
G[7440]={7440,'281:24.2,50.4 H:100064353'}
G[7441]={7441,'281:24.4,47.6 H:100064353'}
G[7442]={7442,'281:24.4,47.6 H:100064353'}
G[7453]={7453,'281:64.20,37.28'}
G[7505]={7505,'19:39.2,36.2'}
G[7506]={7506,'19:39.2,36.2'}
G[7623]={7623,'38:49.4,55.4 38:49.4,55.5 38:49.5,55.4 38:49.5,55.5'}
G[7740]={7740,'381:44.9,80.9'}
G[7776]={7776,'121:41.4,15.4 121:41.4,15.5 121:41.6,15.3 121:76.1,43.8'}
G[7783]={7783,'19:62.31,26.08'}
G[7784]={7784,'161:59.79,64.08'}
G[7790]={7790,'321:76.2,37.4 321:76.2,37.5 321:76.6,37.6 321:76.7,37.4'}
G[7795]={7795,'686:31.09,44.20'}
G[7800]={7800,'691[3]:0.00,0.00'}
G[7804]={7804,'161:42.46,24.03'}
G[7806]={7806,'26:49.34,37.67'}
G[7807]={7807,'121:53.35,55.70'}
G[7823]={7823,'161:51.36,29.48'}
G[7824]={7824,'161:52.04,27.61'}
G[7846]={7846,'19:54.7,51.2 H:100008244,100010593'}
G[7854]={7854,'121:52.8,47.1'}
G[7875]={7875,'121:74.9,42.6'}
G[7944]={7944,'341:69.53,50.33'}
G[7952]={7952,'4:55.2,75.6'}
G[7953]={7953,'4:55.28,75.49'}
G[7954]={7954,'27:56.27,46.42'}
G[7955]={7955,'27:56.3,46.3'}
G[7995]={7995,'26:59.4,77.8 H:100008704'}
G[7999]={7999,'381:43.01,78.04'}
G[8018]={8018,'26:11.08,46.15'}
G[8115]={8115,'121:74.4,43.4 121:74.4,43.5 121:74.5,43.4'}
G[8126]={8126,'161:52.37,28.31'}
G[8296]={8296,'19:46.7,27.9 H:100008244,100010593', 'In cave'}
G[8297]={8297,'19:46.3,39 H:100008244,100010593'}
G[8298]={8298,'19:73.6,55.6 H:100008244,100010593'}
G[8299]={8299,'19:59.1,35.5 H:100008244,100010593'}
G[8300]={8300,'19:49,35.6 H:100008244,100010593'}
G[8301]={8301,'19:46.8,13.3 H:100008244,100010593'}
G[8302]={8302,'19:52.7,26.9 H:100008244,100010593'}
G[8303]={8303,'19:54,37 H:100008244,100010593'}
G[8304]={8304,'19:37.1,28.3 H:100008244,100010593'}
G[8356]={8356,'362:46.97,58.22'}
G[8359]={8359,'362:45.73,55.86'}
G[8379]={8379,'181:29.3,40.2 181:29.7,40.4 181:29.8,40.5'}
G[8416]={8416,'866:41.67,63.33 27:31.89,74.38>866'}
G[8436]={8436,'28:29.51,26.27'}
G[8516]={8516,'760:52.9,32 760:59.1,31.4 760:59.9,29 760:60,29.6 760:43.3,29.3 760:43.3,29.6 760:43.4,27.5 760:43.7,30.2 760:43.8,26.3 760:43.8,27 760:44.4,25.1 760:44.4,31 760:44.7,24.5 760:45.2,31.5 760:45.3,23.3 760:45.4,23.9 760:45.6,23.1 760:46,32.2 760:46.1,22.4 760:46.1,24.6 760:46.1,32.6 760:46.3,23.6 760:46.6,22.4 760:46.8,32.7 760:46.9,23 760:47.1,23.8 760:50.4,35.6 760:50.5,34.9 760:50.7,34.1 760:50.9,33.3 760:51.1,32 760:51.6,30.8 760:52,30 760:52.3,29.3 760:52.5,29.5 760:52.7,28.7 760:53.3,28.2 760:54.1,28.4 760:55.1,28.8 760:55.5,29.6 760:55.7,29.2 760:56.7,30.3 760:57.1,30.9 760:57.4,31.9 760:58.3,33.3 760:58.4,32.2 760:58.6,33.9 760:59,34.9 760:59.3,35.5 760:59.9,36.3 760:59.9,36.7 760:60.5,37.1 760:61.1,36.2 760:61.1,38.4 760:61.8,37.4 760:62.3,39.3 760:62.4,39.7 760:63,40.2 760:63.5,40.3 760:64.4,41.1 760:64.8,41.2 760:66.2,41.1 760:67.4,41.1 760:67.9,40.7 760:68,32.3 760:68,40.3 760:68.1,34.4 760:68.1,34.6 760:68.4,33.1 760:68.4,35.8 760:68.7,36.1 760:68.7,36.7 760:68.9,32.3 760:68.9,37.7 760:68.9,38.9 760:69,33.1 760:69.1,39.5 760:69.5,31.8 760:69.5,39.7 760:69.8,31.4 760:71,30.6 760:71.3,29.8 760:71.6,30.1 760:72.3,29.1 760:72.8,28.5 760:72.9,28.2 760:73.9,27.6 760:74,23.8 760:74.1,24.7 760:74.1,27.2 760:74.2,25.9 760:74.4,23.3 760:74.5,25.3 760:74.5,26.1 760:74.7,24 760:74.7,26.6 760:74.9,22.7 760:75.1,22 760:75.7,21.5 760:76.3,21.1 760:76.7,20.6 760:77,19.8 760:77.3,19.4 760:77.6,15.6 760:77.7,15.4 760:78,18.5 760:78.1,16.8 760:78.3,18.1 760:78.5,16.7'}
G[8576]={8576,'181:26.82,76.95'}
G[8582]={8582,'11:42.35,15.18'}
G[8586]={8586,'181:42.42,23.59'}
G[8587]={8587,'181:22,51'}
G[8609]={8609,'19:61.25,21.59'}
G[8659]={8659,'321[1]:54.79,45.84','Top of tower'}
G[8670]={8670,'301:60.84,70.78'}
G[8674]={8674,'362:45.11,59.75'}
G[8719]={8719,'301:61.11,70.62'}
G[8890]={8890,'704[1]:46.52,88.19'}
G[8895]={8895,'704[1]:27.27,55.52'}
G[8904]={8904,'704[1]:0.00,0.00'}
G[8960]={8960,'182:38.3,39.1 182:38.4,56.4 182:38.7,46.2 182:39.1,38.3 182:39.3,51.4 182:39.6,39.6 182:39.8,39 182:40.3,34 182:40.9,34.9 182:41.2,34 182:43.9,66.4 182:44.3,66.7 182:44.3,67.8 182:45.3,68 182:45.4,66.2 182:45.4,68.9 182:45.5,66.2 182:45.5,67.6 182:45.5,68.8 182:45.9,66.9 182:46,69.5 182:46.2,17.5 182:49.2,36.8 182:49.5,34.5 182:49.7,34.2 182:50.5,17.2 182:50.9,32.7 615:41.3,34.3'}
G[8962]={8962,'36:28.27,48.87'}
G[8965]={8965,'36:28.35,48.87'}
G[9029]={9029,'704[1]:50.57,62.81'}
G[9046]={9046,'29[14]:74.00,52.99 H:100018987'}
G[9116]={9116,'182:42.01,71.80'}
G[9117]={9117,'201:54.20,62.50'}
G[9176]={9176,'29:40.2,60.4 29:40.2,60.5 29:43.6,60.1'}
G[9177]={9177,'29:71.86,67.96'}
G[9270]={9270,'201:55.08,62.23'}
G[9271]={9271,'201:55.02,62.23'}
G[9272]={9272,'201:31.87,50.28'}
G[9296]={9296,'864:33.38,54.66'}
G[9298]={9298,'281:25.12,58.49'}
G[9316]={9316,'11:44.37,24.86'}
G[9499]={9499,'704[1]:0.00,0.00'}
G[9502]={9502,'704[1]:0.00,0.00'}
G[9503]={9503,'704[2]:51.10,60.60'}
G[9540]={9540,'19:61.47,18.64'}
G[9550]={9550,'HV 321[1]:51.03,71.01'}
G[9562]={9562,'29:73.46,66.27'}
G[9563]={9563,'29:72,64'}
G[9568]={9568,'721[4]:0.00,0.00'}
G[9616]={9616,'341:75.78,23.27'}
G[9618]={9618,'201:43.45,40.93'}
G[9619]={9619,'201:71.24,76.58'}
G[9623]={9623,'201:63.80,19.74'}
G[9736]={9736,'721[5]:0.00,0.00'}
G[9796]={9796,'889:42.98,62.43 4:42.73,67.24>889'}
G[9997]={9997,'201:55.10,62.67'}
G[9998]={9998,'201:43.44,41.33'}
G[9999]={9999,'201:51.96,49.81'}
G[10076]={10076,'704[1]:0.00,0.00'}
G[10176]={10176,'889:45.20,68.38 4:45.18,68.38>889'}
G[10181]={10181,'382:58.05,91.77'}
G[10260]={10260,'29:54.57,23.97',[3]='015'}
G[10299]={10299,'721[4]:30.49,39.73 29:24.30,25.66>721'}
G[10302]={10302,'201:55.35,62.49'}
G[10305]={10305,'281:59.31,49.79'}
G[10307]={10307,'281:25.21,58.47'}
G[10418]={10418,'765:39.15,31.62'}
G[10422]={10422,'765:35.76,34.74'}
G[10424]={10424,'765:38.71,38.78'}
G[10435]={10435,'765[2]:57.03,19.71'}
G[10439]={10439,'765[2]:39.65,22.64'}
G[10445]={10445,'HF 823:55.56,54.99'}
G[10516]={10516,'765:48.89,27.43'}
G[10558]={10558,'765:50.44,29.69'}
G[10578]={10578,'4:55.74,75.36'}
G[10583]={10583,'201:55.98,64.16'}
G[10616]={10616,'30:81.4,66.2'}
G[10618]={10618,'281:46.68,17.72'}
G[10665]={10665,'20:60.13,52.69'}
G[10666]={10666,'20:44.36,53.06'} -- 20:44.37,53.14 20:45.09,53.36 20:44.19,53.93
G[10667]={10667,'23:35.26,68.10'}
G[10738]={10738,'281:36.8,55.6 H:100012842'}
G[10808]={10808,'765:44.03,27.27'}
G[10813]={10813,'765[1]:23.62,78.72'}
G[10822]={10822,'23:67.34,8.92'}
G[10837]={10837,'20:83.26,68.99'}
G[10838]={10838,'22:42.70,84.01'}
G[10839]={10839,'20:83.2,68.6'}
G[10840]={10840,'22:42.97,83.55'}
G[10897]={10897,'241:48.11,67.33'}
G[10916]={10916,'281:29.6,54.8 H:100064353'}
G[10920]={10920,'281:46.85,53.84'}
G[10921]={10921,'182:50.91,80.14'}
G[10922]={10922,'182:43.97,61.83'}
G[10923]={10923,'182:51.12,80.49'}
G[10926]={10926,'23:32.45,83.65'}
G[10929]={10929,'281:58.01,63.77'}
G[10977]={10977,'201:54.83,63.82'}
G[10997]={10997,'765[1]:4.67,52.41'}
G[11017]={11017,'321[1]:56.8,56.4'}
G[11019]={11019,'182:44.1,61.9'}
G[11031]={11031,'382:76.8,74.6'}
G[11032]={11032,'765[1]:27.35,43.50'}
G[11033]={11033,'23:74.92,53.50'}
G[11034]={11034,'23:75.86,51.97'}
G[11035]={11035,'23:53.22,54.58'}
G[11036]={11036,'23:75.61,52.04'}
G[11053]={11053,'22:43.40,83.74'}
G[11055]={11055,'20:83.4,69.9'}
G[11057]={11057,'20:83.28,69.24'}
G[11063]={11063,'23:35.56,68.88'}
G[11079]={11079,'281:48.67,41.02'}
G[11118]={11118,'281:59.86,51.19'}
G[11138]={11138,'281:60.99,48.61'}
G[11139]={11139,'281:58.84,48.27'}
G[11142]={11142,'765[1]:81.99,28.86'}
G[11191]={11191,'281:59.87,49.19'}
G[11192]={11192,'281:59.81,49.13'}
G[11193]={11193,'281:59.78,49.25'}
G[11219]={11219,'43:27.2,35.6'}
G[11259]={11259,'101:55.4,55.7 101:55.5,55.8'}
G[11317]={11317,'101:22.4,73.1 101:22.5,73'}
G[11378]={11378,'889:46.20,63.26 4:46.20,63.26>889'}
G[11401]={11401,'381:43.40,79.39'}
G[11406]={11406,'341:26.2,8.00'}
G[11438]={11438,'101:62.3,38.9'}
G[11520]={11520,'680:42.2,58.2'}
G[11554]={11554,'182:51.41,80.44'}
G[11555]={11555,'182:64.41,5.13'}
G[11556]={11556,'281:21.05,46.18'}
G[11557]={11557,'182:64.89,5.25'}
G[11558]={11558,'182:64.58,3.81 182:64.65,5.90 182:64.55,4.80'}
G[11583]={11583,'755:72,79 H:100019002,100019003'}
G[11596]={11596,'101:60.86,61.86'}
G[11616]={11616,'22:48.13,32.36'}
G[11624]={11624,'101:25.8,68.2'}
G[11625]={11625,'101:66.51,37.53'}
G[11626]={11626,'101:45.37,75.29'}
G[11697]={11697,'43:82.6,69.6 H:100023777,100023797'}
G[11701]={11701,'201:71.4,73.9 201:71.5,74'}
G[11711]={11711,'42:47.70,88.91'}
G[11730]={11730,'261:57.6,79 H:100020461'}
G[11732]={11732,'261:56,80 H:100020461'}
G[11798]={11798,'241:44.29,45.85'}
G[11800]={11800,'241:44.15,45.22'}
G[11801]={11801,'241:51.69,45.09'}
G[11806]={11806,'43:26.68,36.89'}
G[11811]={11811,'161:55.23,60.26'}
G[11814]={11814,'321[1]:32.78,65.16'}
G[11820]={11820,'43:73.77,61.61'}
G[11821]={11821,'81:64.93,82.60'}
G[11832]={11832,'241:36.3,41.9 241:36.5,42.1'}
G[11857]={11857,'607:44.18,33.68'}
G[11858]={11858,'81:72.2,83.9'}
G[11941]={11941,'27:54.6,50.3'}
G[11943]={11943,'4:51.4,41.5 4:51.5,41.5'}
G[12029]={12029,'241:53.33,42.70'}
G[12031]={12031,'101:22.7,72.1'}
G[12032]={12032,'101:22.7,72.5 101:22.8,72.4 611:54.9,16.6'}
G[12042]={12042,'241:52.51,40.55'}
G[12096]={12096,'401:43.12,17.61'}
G[12097]={12097,'401:46.7,84.1'}
G[12201]={12201,'750:27.2,80.6'}
G[12225]={12225,'750[1]:0.00,0.00'}
G[12236]={12236,'750:37.6,70.8'}
G[12238]={12238,'750:25.7,78.4'}
G[12258]={12258,'750:17.6,34.0'}
G[12277]={12277,'101:33.94,53.48'}
G[12340]={12340,'101:23.3,72.8'}
G[12384]={12384,'23:11.34,28.60'}
G[12578]={12578,'182:60.52,25.30'}
G[12596]={12596,'22:42.92,85.06'}
G[12617]={12617,'23:75.85,53.41'}
G[12636]={12636,'23:75.81,53.29'}
G[12676]={12676,'43:73.6,76.6 H:100016305'}
G[12677]={12677,'43:62,49.4 H:100016304'}
G[12678]={12678,'43:41.6,67.4 H:100016303'}
G[12696]={12696,'43:49.75,65.08'}
G[12717]={12717,'43:12.76,34.19'}
G[12719]={12719,'43:12.7,35.3'}
G[12721]={12721,'43:38.88,42.38'}
G[12724]={12724,'43:73.86,62.48'}
G[12736]={12736,'688:48.49,11.75 43:16.52,11.03>688'}
G[12737]={12737,'43:74.19,60.72'}
G[12757]={12757,'43:37.77,43.49'}
G[12759]={12759,'43:48.23,69.75 H:100016408'}
G[12818]={12818,'43:41.49,34.46'}
G[12837]={12837,'43:74.11,60.91'}
G[12858]={12858,'43:68.34,75.30'}
G[12863]={12863,'43:12.46,35.14'}
G[12867]={12867,'43:73.56,60.87'}
G[12876]={12876,'688:42.2,75.6 H:100016782'}
G[12877]={12877,'43:73.04,62.47'}
G[12919]={12919,'141:58.76,60.17'}
G[12920]={12920,'16:68.51,37.82'}
G[12939]={12939,'141:67.76,48.97'}
G[12944]={12944,'704[2]:50.31,58.48'}
G[12997]={12997,'Z301','Deeprun Tram Ironforge side'}	-- also 922[1]
G[13018]={13018,'Z301','Deeprun Tram Stormwind side'}	-- also 922[1]
G[13136]={13136,'261:63.2,45.8 H:100020461'}
G[13158]={13158,'20:87.50,43.29'}
G[13159]={13159,'30:78.8,67.2 H:100001307'}
G[13176]={13176,'401:49.6,82.7'}
G[13179]={13179,'401:49.8,85.6 401:50.4,31 401:50.5,30.9 401:51.3,33'}
G[13180]={13180,'401:49.7,85.7 401:50.2,60.2 401:53.9,27'}
G[13181]={13181,'401:44.3,15.3 401:44.3,15.9 401:45.2,14 401:45.4,14.6 401:45.5,14.4 401:45.5,14.6 401:46.8,16.2 401:47.5,39.6 401:47.7,39 401:49.7,85.5 401:50.3,78.6 401:50.5,80 401:50.6,80.6 401:50.7,81.8'}
G[13236]={13236,'401:50.2,85.1'}
G[13257]={13257,'401:43.4,15.6'}
G[13282]={13282,'750:35.8,10.8'}
G[13283]={13283,'301:79.46,61.26'}
G[13417]={13417,'321[1]:39.55,47.33'}
G[13418]={13418,'HV 321[1]:52.52,77.05'}
G[13429]={13429,'HV 382:68.25,38.87'}
G[13431]={13431,'HV 362:42.45,55.28'}
G[13433]={13433,'HV 341:33.55,67.93'}
G[13434]={13434,'HV 341:33.5,67.6'}
G[13435]={13435,'HV 301:62.81,70.06'}
G[13437]={13437,'401:43.3,18.1 401:48.3,84.3 401:48.4,84.6 401:48.5,84.9 401:49.1,81.5 401:50.6,75.7 401:51.3,61'}
G[13438]={13438,'401:43.1,18.2 401:50.4,65.4 401:50.4,65.5 401:50.5,65.6'}
G[13439]={13439,'401:43.2,18.3 401:44.2,16.1 401:44.8,16.4 401:45.4,16.5 401:45.7,16.5 401:46.8,16.5 401:47.2,16.3 401:47.5,40 401:47.6,39.4 401:47.8,37 401:47.8,38.2 401:48,36.2 401:48,41.3 401:48.3,41.9 401:48.4,16 401:48.6,43.1 401:48.7,35.4 401:48.7,51.3 401:48.7,52 401:48.9,44.3 401:48.9,47.3 401:48.9,47.9 401:48.9,48.6 401:49,16 401:49.1,44.9 401:49.2,46.1 401:49.2,53.4 401:49.4,59.1 401:49.7,16 401:49.7,19.3 401:49.7,19.9 401:49.8,18.1 401:49.8,54.1 401:49.9,57.8 401:50,16.9 401:50.1,57.1 401:50.2,55.3 401:50.2,55.9 401:50.3,21.1 401:50.3,78.9 401:50.3,81.4 401:50.4,60.3 401:50.4,78 401:50.4,80 401:50.4,81.6 401:50.5,81.6 401:50.6,63.4 401:50.6,77.7 401:50.7,22 401:50.7,77.1 401:50.7,81.4 401:50.8,22.6 401:50.8,60.4 401:50.9,60.5 401:51,62.3 401:51.1,23.9 401:51.1,27.4 401:51.1,28 401:51.2,25.1 401:51.2,26.1 401:51.2,28.6 401:51.4,32.8 401:51.6,29.2 401:51.6,32.2 401:51.6,32.9 401:51.8,31 401:51.9,30.4 401:51.9,64.6 401:52.3,66.1'}
G[13442]={13442,'401:43.9,12.7'}
G[13444]={13444,'HV 341:33.15,65.45'}
G[13445]={13445,'HV 321[1]:49.63,78.00'}
G[13596]={13596,'750[1]:0.00,0.00'}
G[13616]={13616,'401:57,82.5'}
G[13617]={13617,'401:42.55,16.82'}
G[13636]={13636,'24:42.34,41.14'}
G[13776]={13776,''}
G[13777]={13777,'24:43.1,43.9'}
G[13797]={13797,'401:45.6,16.6'}
G[13798]={13798,'401:49.3,81.8 401:50.2,80.4 401:50.4,81.3 401:50.7,81.3 401:50.7,81.7'}
G[13816]={13816,'24:45.4,45.3 401:42.6,13.4 401:42.6,13.8'}
G[13817]={13817,'24:58.69,34.24'}
G[13840]={13840,'24:57.79,33.32'}
G[13841]={13841,'24:44.7,46.2'}
G[14266]={14266,'35:61.71,73.04'}
G[14305]={14305,'HC Near'}
G[14322]={14322,'699:62.6,66.2'}
G[14324]={14324,'699[1]:31.81,31.21'}
G[14325]={14325,'699:49.8,78.2'}
G[14326]={14326,'699:69.8,76.6'}
G[14338]={14338,'699:27.8,55.1 699:28.4,55.5 699:28.5,55.4 699:28.5,55.5'}
G[14347]={14347,'261:29.6,10.6'}
G[14358]={14358,'699[2]:48.36,53.75 121:60.32,30.15>699','Upstairs'}
G[14368]={14368,'699:72.4,16.4 699:72.4,16.8 699:72.4,17.5 699:72.5,16.3 699:73,16.6 699:73.1,15.4 699:73.5,15.3 699:73.6,16.6 699:73.7,17.5 699:74.3,16.4 699:74.8,16.7 699:74.9,16.4 699:75,17.5'}
G[14375]={14375,'321:45.2,69.5 321:45.2,72.4 321:45.3,69.2 321:45.3,73.1 321:45.9,73.3 321:46.1,67.8 321:46.1,75.6 321:46.5,76.7 321:46.6,67.4 321:46.7,63.7 321:46.7,67.5 321:46.7,76.1 321:47,64.5 321:47.1,77.9 321:47.4,79 321:47.6,79 321:48.2,66.4 321:48.2,79.8 321:48.3,66.5 321:48.7,71.9 321:48.7,83.5 321:48.8,66.4 321:48.8,79.6 321:49,66.5 321:49,82.6 321:49.1,82.4 321:49.4,81.3 321:49.5,80.2 321:49.5,81.5 321:49.6,66.3 321:49.6,81.1 321:49.9,71.8 321:50,64.1 321:50,70.5 321:50.3,66.7 321:50.6,66.3 321:50.7,80.6 321:50.8,64 321:50.9,66.7 321:51,64.6 321:51.4,67.8 321:51.4,69.9 321:51.4,72.4 321:51.4,79.3 321:51.4,80.2 321:51.5,64.2 321:51.5,66.4 321:51.5,78.9 321:51.5,81.1 321:51.6,67.8 321:51.6,78.2 321:51.6,80.4 321:51.7,81.8 321:51.8,69.4 321:51.8,70 321:51.8,76.9 321:51.9,66.9 321:51.9,71 321:51.9,71.6 321:51.9,72.5 321:51.9,74.6 321:51.9,75.9 321:52,83.1 321:52,83.7 321:52.1,73.9 321:52.2,84.8 321:52.3,85.7 321:52.5,75.7 321:52.5,81.1 321:52.5,81.9 321:52.6,77.6 321:52.7,77 321:53,74.7 321:53.1,74.3 321:53.1,79.5 321:53.6,74 321:53.9,73.1'}
G[14381]={14381,'699:74,13 699:74.3,12.3 699:75.1,12.3'}
G[14382]={14382,'699:78.1,12 699:78.6,11.4 699:79.1,11.5 699:79.4,12.9 699:79.7,13.4 699:79.7,14 699:80,11.3 699:80.1,12.1 699:80.7,12.2 699:81.3,12.5 699:81.4,11.3 699:81.6,12.3 699:81.9,11.4 699:81.9,12.9 699:82.5,12.4 699:82.8,13 699:82.9,11.4'}
G[14383]={14383,'699:83.2,23 699:83.3,24.9 699:83.3,26.2 699:83.4,22.4 699:83.4,23.8 699:83.6,26.5 699:83.8,21.1 699:84,24.2 699:84.2,22.3 699:84.2,25 699:84.3,23 699:84.3,25.5 699:84.5,21.8 699:84.5,23.3 699:84.5,23.9 699:84.5,25.2 699:84.5,26.3'}
G[14387]={14387,'29[16]:54.22,83.34'}
G[14392]={14392,'321:51.2,82.4 321:51.3,83.5 321:51.4,74.5 321:51.4,83.1 321:51.5,83.1 321:51.5,83.5 321:51.7,75.7 321:51.7,76.5 321:51.8,75.3 321:52.4,78.4 321:52.4,82.4 321:52.5,82.6 321:52.6,82.1 321:52.9,78 321:53,77.2 321:53.1,79.1'}
G[14394]={14394,'301:67.17,85.49'}
G[14435]={14435,'261:27,14 H:100019018'}
G[14437]={14437,'29:8.39,35.78'}
G[14444]={14444,'HC Near'}
G[14508]={14508,'673:45.01,25.39','Walks around arena at times'}
G[14624]={14624,'28:38.67,28.68'}
G[14625]={14625,'28:38.11,26.97'}
G[14626]={14626,'28:36.14,28.25 28:37.38,28.93'}
G[14627]={14627,'28:38.46,27.86'}
G[14628]={14628,'28:43.77,28.70'}
G[14634]={14634,'28:37.73,26.58'}
G[14636]={14636,'28:45.86,29.65 H:100062933'}
G[14637]={14637,'121:48.68,44.81'}
G[14721]={14721,'301:71.45,80.45'}
G[14725]={14725,'381:63.2,22.5 381:63.8,22.7'}
G[14726]={14726,'321:63.4,51.1 321:63.5,51'}
G[14727]={14727,'321:37.3,87.5 321:37.8,87.8 321:38,87.2'}
G[14728]={14728,'362:43.3,42.8 362:43.7,42.5 362:43.9,42.1'}
G[14729]={14729,'382:5.4,58.4 382:44.1,34.9 382:63,71.2 382:70.9,29.6 382:71.4,28.3 382:71.4,28.8 382:71.9,28.9 382:72.1,28.3 382:72.3,29.5 382:72.5,28.4 382:72.5,29.4 382:72.6,29.9'}
G[14731]={14731,'26:78.13,81.39'}
G[14733]={14733,'43:61.9,83.9'}
G[14739]={14739,'26:78.80,78.25'}
G[14740]={14740,'26:80.33,81.53'}
G[14741]={14741,'26:79.16,79.53'}
G[14753]={14753,'43:61.5,83.8'}
G[14754]={14754,'11:40.2,20'}
G[14822]={14822,'HF 823:53.22,75.84'}
G[14828]={14828,'HF 823:47.76,64.79'}
G[14829]={14829,'HF 823:51.10,82.04'}
G[14832]={14832,'HF 823:47.90,67.12'}
G[14833]={14833,'HF 823:55.00,70.78'}
G[14841]={14841,'HF 823:49.24,60.79'}
G[14844]={14844,'HF 823:50.55,69.56'}
G[14845]={14845,'HF 823:52.91,67.93'}
G[14847]={14847,'HF 823:51.89,60.93'}
G[14871]={14871,'HF 823:55.93,70.72'}
G[14875]={14875,'689:14.2,15.5'}
G[14902]={14902,'689:15.3,14.5'}
G[14903]={14903,'689:15.3,16.1'}
G[14904]={14904,'689:15.3,16'}
G[14905]={14905,'689:14.1,13.7'}
G[14910]={14910,'689:15.3,15.4 689:15.3,15.5'}
G[14921]={14921,'689:15.1,16'}
G[14983]={14983,'16:39.95,46.68'}
G[15011]={15011,'HH 27:59.6,34.4'}
G[15012]={15012,'HH 4:46.1,13.7'}
G[15021]={15021,'16:68.4,30.4 16:73.3,29.8'}
G[15042]={15042,'793:62.3,56.5'}
G[15070]={15070,'689:14.5,15.8'}
G[15077]={15077,'HX 673:41.6,73.0'}
G[15078]={15078,'HX 673:41.5,73.0'}
G[15079]={15079,'HX 673:41.4,73.0'}
G[15116]={15116,'HX 321[1]:52.36,77.13'}
G[15119]={15119,'HX 341:28.17,74.93'}
G[15126]={15126,'16:68.4,30.4 16:68.4,30.5 16:68.5,30.4 16:68.5,30.5 16:73.4,29.8'}
G[15127]={15127,'16:40.1,46.6'}
G[15170]={15170,'261:46.42,79.07'}
G[15171]={15171,'261:46.01,79.40'}
G[15174]={15174,'261:55.53,36.77'}
G[15177]={15177,'261:54.40,32.73'}
G[15181]={15181,'261:53.21,32.50'}
G[15182]={15182,'261:54.6,32','Top of tower'}
G[15183]={15183,'261:53.62,35.31'}
G[15189]={15189,'261:55.38,36.26'}
G[15190]={15190,'261:55.30,36.20'}
G[15191]={15191,'261:54.89,36.02'}
G[15192]={15192,'161:58,56.1 161:64.2,51.3'}
G[15194]={15194,'261:68.65,63.04'}
G[15197]={15197,'HW 382:67.42,13.20'}
G[15270]={15270,'261:53.19,35.20'}
G[15278]={15278,'893:61.03,45.13 462:38.02,21.00>893'}
G[15279]={15279,'893:64.76,46.50 462:39.23,21.46>893'}
G[15280]={15280,'893:65.48,43.74 462:39.4,20.6>893'}
G[15281]={15281,'893:52.88,49.77 462:35.37,22.52>893'}
G[15283]={15283,'893:63.87,46.45 462:38.94,21.45>893'}
G[15284]={15284,'893:65.32,43.20 462:39.4,20.45>893'}
G[15285]={15285,'893:63.84,42.10 462:38.9,20.1>893'}
G[15295]={15295,'893:63.97,42.83 462:38.97,20.26>893'}
G[15296]={15296,'893:61.80,39.36 462:38.27,19.12>893'}
G[15297]={15297,'893:58.47,38.79 462:37.20,19.05>893'}
G[15298]={15298,'893:41.09,70.78 462:31.57,29.48>893 H:100020483','Up on platform'}
G[15301]={15301,'462:40.42,32.21'}
G[15303]={15303,'HF 823:52.50,56.13'}
G[15306]={15306,'261:53.16,35.11'}
G[15309]={15309,'382:67.48,6.62'}
G[15310]={15310,'30:32.04,50.39'}
G[15339]={15339,'717:39.95,75.32 H:100021220'}
G[15340]={15340,'717:30.93,37.96'}
G[15378]={15378,'766:51.6,84.6 261:28.7,89.7>766'}
G[15379]={15379,'766:50,93.5 766:50.3,93.3 766:50.5,92.9 766:50.8,93.6 766:49.1,84.4 766:49.3,85.2 766:49.4,83 766:49.4,86 766:49.5,82.9 766:50.1,82.3 766:50.2,84.5 766:50.2,86.5 766:50.3,84.1 766:50.4,85.7 766:50.7,82.3 766:50.8,83.7 766:50.8,85.6 766:51.1,84.9 766:51.1,86.6 766:51.2,83 766:51.5,85.3 766:51.7,83.1 766:51.8,84 766:51.8,86.5 766:52.1,86.2 766:52.5,83.4 766:52.5,84.8'}
G[15380]={15380,'766:50.6,85.6 261:28.7,89.7>766'}
G[15395]={15395,'182:64.01,10.31'}
G[15397]={15397,'462:43.68,71.30'}
G[15398]={15398,'462:34,80'}
G[15399]={15399,'462:60.32,62.77'}
G[15400]={15400,'462:59.52,62.60'}
G[15401]={15401,'462:36.70,57.44'}
G[15402]={15402,'462:54.28,70.97'}
G[15403]={15403,'462:48.16,46.00'}
G[15404]={15404,'462:36.36,66.77'}
G[15405]={15405,'462:44.63,53.14'}
G[15406]={15406,'462:70.45,72.35'}
G[15407]={15407,'462:62.2,79.6 H:100023249'}
G[15409]={15409,'462:35.0,84.6 H:100023228'}
G[15416]={15416,'462:50.33,50.76'}
G[15417]={15417,'462:44.72,69.63'}
G[15418]={15418,'462:47.25,46.30'}
G[15433]={15433,'462:48.15,47.66'}
G[15498]={15498,'772:59.39,14.05'}
G[15499]={15499,'772:59.48,14.05'}
G[15500]={15500,'772:59.53,14.00'}
G[15502]={15502,'766:59.3,68.4'}
G[15503]={15503,'766:59.4,68.5'}
G[15504]={15504,'766:59.2,68.5'}
G[15513]={15513,'893:64.20,42.07 462:39.05,20.01>893'}
G[15549]={15549,'HL 704[1]:50.53,62.95 29:14.58,9.21>704'}
G[15556]={15556,'HL 750[2]:51.46,93.73 101:29.10,62.56>750'}
G[15557]={15557,'HL 29:70.12,45.40'}
G[15558]={15558,'HL 35:33.33,46.55'}
G[15559]={15559,'HL 26:50.00,48.03'}
G[15560]={15560,'HL 721[3]:61.78,40.08 29:24.30,25.66>721'}
G[15561]={15561,'HL 21:44.96,41.15'}
G[15562]={15562,'HL 30:34.56,50.26'}
G[15563]={15563,'HL 19:54.28,49.49'}
G[15564]={15564,'HL 382:66.62,38.20','Upstairs, outside'}
G[15565]={15565,'HL 30:39.79,63.67'}
G[15566]={15566,'HL 23:75.73,54.56'}
G[15567]={15567,'HL 28:21.30,79.10'}
G[15568]={15568,'HL 20:61.86,53.91'}
G[15569]={15569,'HL 27:53.92,49.93'}
G[15570]={15570,'HL 261:30.80,13.32'}
G[15572]={15572,'HL 4:53.22,43.61'}
G[15573]={15573,'HL 161:37.24,79.05'}
G[15574]={15574,'HL 281:59.96,49.94'}
G[15575]={15575,'HL 9:48.50,53.25'}
G[15576]={15576,'HL 673:39.94,72.51','On roof'}
G[15577]={15577,'HL 39:56.63,47.09','Top of tower'}
G[15578]={15578,'HL 686:34.51,39.35 161:39.22,21.34>686'}
G[15579]={15579,'HL 321[1]:52.28,59.95'}
G[15580]={15580,'HL 362:72.96,23.31'}
G[15581]={15581,'HL 121:76.71,37.89'}
G[15582]={15582,'HL 11:68.36,69.96'}
G[15583]={15583,'HL 201:50.37,76.17'}
G[15584]={15584,'HL 61:46.34,51.00'}
G[15585]={15585,'HL 29:52.39,23.94'}
G[15586]={15586,'HL 161:51.40,28.81'}
G[15587]={15587,'HL 121:62.56,31.07'}
G[15588]={15588,'HL 607:41.60,47.44'}
G[15592]={15592,'HL 23:35.58,68.82'}
G[15593]={15593,'HL 687[1]:62.93,34.38 38:69.68,53.45>687'}
G[15594]={15594,'HL 22:69.18,73.44','On ramparts'}
G[15595]={15595,'HL 41:56.85,53.10'}
G[15596]={15596,'HL 37:71.04,34.29'}
G[15597]={15597,'HL 11:48.52,59.26'}
G[15598]={15598,'HL 381:39.22,31.86'}
G[15599]={15599,'HL 261:53.02,35.47'}
G[15600]={15600,'HL 181:64.73,79.35'}
G[15601]={15601,'HL 42:49.53,18.95'}
G[15602]={15602,'HL 22:63.51,36.13','In cave'}
G[15603]={15603,'HL 182:38.36,52.85'}
G[15604]={15604,'HL 61:77.09,75.61'}
G[15605]={15605,'HL 43:35.54,48.92'}
G[15606]={15606,'HL 281:53.22,56.75'}
G[15607]={15607,'HL 765[1]:78.64,22.09 23:27.07,15.77>765'}
G[15608]={15608,''}
G[15651]={15651,'462:33.82,55.58'}
G[15659]={15659,'301:62.39,75.02'}
G[15670]={15670,'462:28.2,60.4 H:100021776'}
G[15700]={15700,'HQ 321:38,86'}
G[15727]={15727,'766[3]:54.82,59.15'}
G[15732]={15732,'27:60.30,33.84 40:9.17,60.70 161:52.57,28.06 301:67.84,71.45 504[1]:49.33,44.85 673:40.28,67.64'}
G[15864]={15864,'HL 241:53.65,35.26'}
G[15871]={15871,'HL 341:29.22,17.12'}
G[15891]={15891,'HL 321[1]:49.89,81.20 382:66.0,36.8 362:38.38,63.40'}
G[15892]={15892,'HL 341:30.90,61.58'}
G[15895]={15895,'HL 30:34.24,50.56 341:28.83,16.22 381:38.60,30.27 321[1]:52.38,58.49 481:53.2,32.8 362:71.10,28.25 382:65.60,35.99 504[1]:47.63,43.76 471:74.01,57.48 480:73.05,82.56 811:85.30,64.90 811:62.92,19.27'}
G[15920]={15920,'462:29.90,58.52'} -- 462:30.22,58.33 462:29.88,58.48 462:29.85,58.46 462:30.25,58.44
G[15921]={15921,'462:36.35,66.62'}
G[15924]={15924,'462:67.80,56.54'}
G[15939]={15939,'462:43.34,70.82'}
G[15941]={15941,'462:45.19,56.43'}
G[15942]={15942,'462:46.93,71.78'}
G[15945]={15945,'462:44.87,61.04'}
G[15951]={15951,'462:60.32,61.38','Up ramp'}
G[15968]={15968,'462:36.6,60.6 H:100020765'}
G[15969]={15969,'462:68.71,46.95'}
G[15970]={15970,'462:55.70,54.50'}
G[15991]={15991,'478:57.7,56'}
G[16112]={16112,'23:75.35,76.18'}
G[16115]={16115,'23:76.70,73.10'}
G[16116]={16116,'23:72.65,74.84'}
G[16128]={16128,'504[1]:30.63,48.59'}
G[16134]={16134,'23:73.78,51.88'}
G[16135]={16135,'23:30.22,56.88'}
G[16144]={16144,'462:38.15,73.55'}
G[16183]={16183,'462:49,89'}
G[16191]={16191,'480:53.93,71.02'}
G[16192]={16192,'462:54.37,50.72'}
G[16196]={16196,'462:49,89'}
G[16197]={16197,'463:46.33,28.37'}
G[16198]={16198,'463:47.66,34.86'}
G[16199]={16199,'463:46.02,31.97'}
G[16200]={16200,'463:46.03,33.57'}
G[16201]={16201,'463:72.30,19.10'}
G[16202]={16202,'463:72.50,32.13'}
G[16203]={16203,'463:71.95,32.64'}
G[16204]={16204,'463:54.86,48.57'}
G[16205]={16205,'463:48.91,31.32'}
G[16210]={16210,'462:44.03,70.76'}
G[16213]={16213,'463:45.48,32.43'}
G[16219]={16219,'463:69.3,15.2'}
G[16220]={16220,'463:72.37,29.64'}
G[16224]={16224,'463:47.25,28.54'}
G[16227]={16227,'11:69.13,70.70'}
G[16231]={16231,'463:44.89,32.52'}
G[16237]={16237,'463:60.29,35.63'}
G[16239]={16239,'463:55.08,48.83'}
G[16240]={16240,'463:54.83,48.35'}
G[16251]={16251,'463:44.74,32.28'}
G[16252]={16252,'463:44.77,32.44'}
G[16253]={16253,'463:48.43,30.93'}
G[16261]={16261,'462:43.69,71.55'}
G[16280]={16280,'462:61.32,54.03'}
G[16289]={16289,'463:44.85,32.81'}
G[16291]={16291,'463:55,48.6'}
G[16293]={16293,'463:31.44,48.32'}
G[16295]={16295,'463:62.90,32.77'}
G[16314]={16314,'463:16.2,57.6 H:100022597'}
G[16362]={16362,'462:44.2,85.4'}
G[16365]={16365,'23:75.66,52.05'}
G[16388]={16388,'Z799'}
G[16397]={16397,'462:43.57,71.21'}
G[16399]={16399,'673:48.3,63.3'}
G[16416]={16416,'281:58.03,52.21'}
G[16417]={16417,'161:50.4,27.2'}
G[16418]={16418,'11:65.83,71.92'}
G[16462]={16462,'463:72.20,29.77'}
G[16463]={16463,'463:72.32,31.26'}
G[16464]={16464,'463:72.62,31.56'}
G[16475]={16475,'894:61.18,29.49 464:84.3,43>894'}
G[16477]={16477,'894:52.76,35.88 464:80.4,45.8>894'}
G[16480]={16480,'463:46.40,56.43'}
G[16499]={16499,'894:51.55,44.45 464:79.8,49.4>894'}
G[16500]={16500,'894:50.88,42.34 464:79.6,48.8>894'}
G[16501]={16501,'894:51.11,41.13 464:79.7,48.3>894'}
G[16502]={16502,'894:52.12,41.43 464:80,49.5>894'}
G[16503]={16503,'894:50.87,43.85 464:79.6,49.4>894'}
G[16514]={16514,'894:49.87,37.34 464:79.2,46.4>894'}
G[16522]={16522,'894:27.78,80.42 464:69.27,65.77>894 H:100024414'}
G[16535]={16535,'894:50.65,48.75 464:79.4,51.4>894'}
G[16546]={16546,'894:33.90,69.38 464:72,60.8>894'}
G[16551]={16551,'464:48.7,50.3'}
G[16553]={16553,'464:48.4,49.2'}
G[16554]={16554,'464:64.5,54.1'}
G[16574]={16574,'465:54.3,37.9'}
G[16575]={16575,'465:55.1,36.3'}
G[16576]={16576,'465:65.1,44.2'}
G[16577]={16577,'465:55.2,39.1'}
G[16583]={16583,'465:53.2,38.2'}
G[16588]={16588,'465:52.3,36.4'}
G[16601]={16601,'463:57.54,14.94'}
G[16642]={16642,'480:66.73,16.78'}
G[16648]={16648,'480:73.05,45.28'}
G[16653]={16653,'480:59.16,19.70'}
G[16655]={16655,'480:71.2,56.2'}
G[16658]={16658,'480:53.10,26.65'}
G[16661]={16661,'480:71.73,55.75'}
G[16674]={16674,'480:84.71,28.06'}
G[16681]={16681,'480:92.20.37.53'}
G[16684]={16684,'480:79.66,52.14'}
G[16721]={16721,'464:24.45,54.55'}
G[16723]={16723,'471:27.77,60.01'}
G[16749]={16749,'471:47.26,62.31'}
G[16756]={16756,'471:38.9,51.1'}
G[16761]={16761,'471:38.93,84.85'}
G[16768]={16768,'471:57.0,50.6'}
G[16781]={16781,'479:32.26,68.44'}
G[16789]={16789,'465:28.4,60.3 465:28.5,60.2'}
G[16790]={16790,'465:27.7,60.4'}
G[16791]={16791,'465:27,59.6'}
G[16792]={16792,'465:27,59.8'}
G[16793]={16793,'465:26.4,60.4 465:26.5,60.3'}
G[16794]={16794,'465:26.8,59.7'}
G[16796]={16796,'465:23.42,36.55'}
G[16797]={16797,'465:23.35,37.43 465:23.36,39.32 465:23.37,41.20'}
G[16799]={16799,'465:23.1,40.3'}
G[16802]={16802,'480:53.81,20.26'}
G[16808]={16808,'710[1]:67.31,55.47'}
G[16813]={16813,'Z799'}
G[16814]={16814,'Z799'}
G[16815]={16815,'Z799'}
G[16817]={16817,'HM 301:49.53,72.26 341:63.77,25.33 381:62.17,48.67 471:41.6,24.7 481:61.36,31.92'}
G[16818]={16818,'HM 321[1]:47.73,38.20 362:21.61,27.73 382:67.64,8.27 480:69.86,42.96'}
G[16819]={16819,'465:56.64,66.69'}
G[16820]={16820,'465:50.91,60.20'}
G[16822]={16822,'465:54.67,62.36'}
G[16825]={16825,'465:54.29,63.58'}
G[16826]={16826,'465:54.22,63.59'}
G[16827]={16827,'465:50.88,60.35'}
G[16833]={16833,'465:23.14,40.17'}
G[16834]={16834,'465:23.01,40.37'}
G[16837]={16837,'465:52,62.4 465:52,62.5'}
G[16839]={16839,'465:56.69,66.51'}
G[16841]={16841,'19:54.66,50.44'}
G[16845]={16845,'465:32,27.9'}
G[16850]={16850,'465:23.89,72.17'}
G[16851]={16851,'465:23.98,72.34'}
G[16852]={16852,'465:26.90,37.45'}
G[16857]={16857,'465:49.4,65.6 H:100023338'}
G[16858]={16858,'465:61,81.6'}
G[16885]={16885,'465:16.03,52.15'}
G[16888]={16888,'465:15.80,52.17'}
G[16915]={16915,'465:51.36,30.53'}
G[16924]={16924,'462:47.77,46.58'}
G[16991]={16991,'465:15.70,52.08'}
G[16993]={16993,'465:24.6,76.1'}
G[17006]={17006,'465:23.09,40.22'}
G[17015]={17015,'465:26.4,61.8 465:27.1,61.9'}
G[17062]={17062,'465:33.6,43.6'}
G[17071]={17071,'894:50.50,47.87 464:79.4,51>894'}
G[17079]={17079,'261:54.6,62.8'}
G[17080]={17080,'261:39.57,46.97'}
G[17081]={17081,'261:53,34.7'}
G[17082]={17082,'261:54.49,32.94'}
G[17084]={17084,'465:25.85,74.85 H:100023580'}
G[17085]={17085,'465:28.99,81.46'}
G[17089]={17089,'894:50.20,43.14 464:79.28,49.13>894'}
G[17092]={17092,'24:56.74,47.47'}
G[17094]={17094,'37:38.12,50.09'}
G[17095]={17095,'141:35.86,31.74'}
G[17098]={17098,'321:31.8,38.3 321:49.1,71.6 321:49.2,71'}
G[17101]={17101,'464:61.1,54.2'}
G[17106]={17106,'43:35,49.9'}
G[17110]={17110,'464:49.8,51.9'}
G[17114]={17114,'464:49.37,51.08'}
G[17116]={17116,'464:47.2,50.6'}
G[17120]={17120,'471:55.6,82.6'}
G[17122]={17122,'471:47.59,88.32'}
G[17123]={17123,'465:32.1,28.3'}
G[17127]={17127,'38:26.86,33.57'}
G[17192]={17192,'464:33.83,18.41'}
G[17204]={17204,'471:29.38,33.36 471:31.27,27.71'}
G[17214]={17214,'464:48.39,51.77'}
G[17215]={17215,'464:48.39,51.48'}
G[17226]={17226,'465:26.3,63.7 465:26.4,63.1 465:27,62.7 465:27.1,62.1'}
G[17232]={17232,'464:49.39,50.95'}
G[17240]={17240,'464:47,70.1'}
G[17241]={17241,'464:47.1,70.3'}
G[17242]={17242,'464:47.2,70.1'}
G[17246]={17246,'464:46.7,70.5'}
G[17287]={17287,'43:84,62.7'}
G[17291]={17291,'43:86.9,44.8'}
G[17303]={17303,'43:84,62.7'}
G[17304]={17304,'43:90.94,58.14'}
G[17307]={17307,'797[1]:36.71,81.31'}
G[17308]={17308,'797[1]:42.18,70.96'}
G[17310]={17310,'43:83.9,63'}
G[17311]={17311,'13:28.92,32.71 464:16.37,94.03'}
G[17312]={17312,'464:13.62,73.22'}
G[17326]={17326,'476:48.44,94.17'}
G[17355]={17355,'43:73.16,60.11'}
G[17360]={17360,'464:49.44,50.97'}
G[17361]={17361,'464:55.2,41.7'}
G[17362]={17362,'464:64.48,39.78'}
G[17363]={17363,'464:63.1,67.8'}
G[17364]={17364,'464:28.11,62.39'}
G[17377]={17377,'725[1]:58.07,41.68'}
G[17421]={17421,'476:42.1,21.2'}
G[17423]={17423,'476:52.7,53.3'}
G[17424]={17424,'476:54.7,54'}
G[17433]={17433,'476:55.08,58.00'}
G[17434]={17434,'476:53.3,57.7'}
G[17440]={17440,'464:46.6,20.7'}
G[17441]={17441,'464:44.65,23.49'}
G[17442]={17442,'464:44.8,23.8'}
G[17443]={17443,'464:46.9,22.2'}
G[17445]={17445,'464:46.8,21.2'}
G[17468]={17468,'471:32.86,54.48'}
G[17480]={17480,'464:50.02,50.52'}
G[17488]={17488,'464:48.9,51.1'}
G[17493]={17493,'465:55.2,36.1'}
G[17508]={17508,'476:37.4,61.4 476:37.6,61.3'}
G[17514]={17514,'471:46.4,63.1 471:46.6,62.7'}
G[17528]={17528,'476:38.42,82.00 H:100023900'}
G[17538]={17538,'471:57.89,41.42'}
G[17545]={17545,'477:35.4,77.8 477:35.5,77.7'}
G[17554]={17554,'476:57.68,53.88'}
G[17555]={17555,'471:54.48,36.31'}
G[17584]={17584,'471:81.49,51.43','On the surface'}
G[17586]={17586,'476:63.1,87.9'}
G[17587]={17587,'464:37.6,19.7 464:40.0,37.6 464:42.0,57.6 464:40.6,71 464:46.7,31.9 464:54.0,42.6 464:55.8,29.0 464:55.8,48.2 464:57.6,60.8 464:58.6,41.6'}
G[17599]={17599,'476:63.43,88.73'}
G[17600]={17600,'476:61.2,48.4 476:61.2,48.5'}
G[17613]={17613,'32:47,75.4 32:47,75.5'}
G[17614]={17614,'464:24.2,54.3'}
G[17634]={17634,'467:68.66,50.21'}
G[17636]={17636,'479:32.3,63.6'}
G[17637]={17637,'467:34.1,51'}
G[17642]={17642,'476:55.9,56.9'}
G[17649]={17649,'476:63.00,87.55'}
G[17658]={17658,'476:52.69,53.22'}
G[17663]={17663,'476:56.3,56.8'}
G[17674]={17674,'476:73.9,33.4 476:74.3,34 476:74.5,33.6 476:74.6,33.4 476:75.1,34.6'}
G[17676]={17676,'476:53.3,57.1'}
G[17682]={17682,'476:68.26,81.08'}
G[17684]={17684,'476:55.43,55.26'}
G[17686]={17686,'476:24.88,34.36'}
G[17703]={17703,'476:53.3,54.1 476:53.4,54.5 476:53.5,54.5 476:53.6,54.4 476:54.1,61.5 476:54.2,58.2 476:54.3,55.5 476:54.3,58.7 476:54.3,60.4 476:54.3,60.7 476:54.5,56 476:54.5,59.5 476:54.5,60.7 476:54.6,58.3 476:54.7,55.1 476:54.8,56.9 476:55.1,59.1 476:55.4,54.4 476:55.5,54.4 476:55.6,56.6 476:55.8,55.2 476:56,55.8'}
G[17712]={17712,'476:79,22.3 476:79.1,22.7'}
G[17825]={17825,'476:54.44,54.45'}
G[17831]={17831,'467:23.32,66.21','Sometimes on a quest - will be back'}
G[17834]={17834,'467:78.54,63.15'}
G[17841]={17841,'467:78.40,62.01'}
G[17843]={17843,'476:55.63,55.21'}
G[17844]={17844,'476:55.55,55.43'}
G[17849]={17849,'462:42.03,35.65'}
G[17856]={17856,'467:19.54,50.05'}
G[17858]={17858,'467:79.08,65.27'}
G[17866]={17866,'467:19.65,49.69'}
G[17876]={4949,''}
G[17877]={17877,'467:19.80,50.83'}
G[17882]={17882,'726[1]:26.97,46.22'}
G[17904]={17904,'467:79.11,64.88'}
G[17909]={17909,'467:80.32,64.17'}
G[17923]={17923,'467:19.12,63.48'}	-- 467:19.04,62.36 467:19.00,63.38 467:19.18,64.59 pacing between the points
G[17924]={17924,'467:19.67,52.06'}
G[17925]={17925,'467:19.14,49.38'}
G[17926]={17926,'476:30.3,46'}
G[17927]={17927,'476:30.3,46'}
G[17942]={17942,'728[1]:85.65,67.46'}
G[17956]={17956,'467:80.39,64.16'}
G[17969]={17969,'467:83.37,85.53'}
G[17982]={17982,'476:30.82,46.66'}
G[17986]={17986,'476:30.76,46.84'}
G[18003]={18003,'467:68.20,49.38'}
G[18004]={18004,'467:68.34,50.08'}
G[18005]={18005,'467:67.81,47.91'}
G[18006]={18006,'467:67.65,47.87'}
G[18007]={18007,'467:68.62,48.73'}
G[18008]={18008,'467:41.95,27.19'}
G[18009]={18009,'467:40.85,28.66'}
G[18010]={18010,'467:41.61,27.29'}
G[18011]={18011,'467:85.2,54.7'}
G[18012]={18012,'467:85,54.1'}
G[18013]={18013,'467:30.7,50.9'}
G[18014]={18014,'467:32.9,48.9'}
G[18015]={18015,'467:31.7,49.3'}
G[18016]={18016,'467:84.4,54.4 467:84.5,54.4'}
G[18017]={18017,'467:32.4,51.9'}
G[18018]={18018,'467:32.2,49.5'}
G[18019]={18019,'467:41.21,28.68'}
G[18020]={18020,'476:51.8,52.1'}
G[18024]={18024,'476:55.5,52.4 476:55.5,52.5'}
G[18035]={18035,'467:80.8,36.3'}
G[18063]={18063,'477:55.4,37.7 477:55.5,37.7'}
G[18066]={18066,'477:54.8,39.4 477:54.8,39.5'}
G[18067]={18067,'477:54.8,39.8'}
G[18068]={18068,'477:54.6,39.9'}
G[18070]={18070,'467:80.37,64.72'}
G[18071]={18071,'477:60.66,22.65'}
G[18072]={18072,'477:60.65,22.10'}
G[18073]={18073,'477:60.80,22.38'}
G[18074]={18074,'477:60.50,22.38'}
G[18090]={18090,'477:55.4,37.4 477:55.4,37.5'}
G[18091]={18091,'467:32,50.4'}
G[18096]={18096,'734:50.44,31.56'}
G[18098]={18098,'475:36.30,67.56'}
G[18099]={18099,'477:61.58,22.03 477:62.14,22.80 477:61.99,24.02 477:61.20,24.91 477:60.57,24.96 477:60.08,24.38 477:59.88,23.31 477:59.58,22.47 477:59.86,21.36 477:60.40,20.87 477:60.92,21.51','Wandering around'}
G[18106]={18106,'477:55.6,37.6'}
G[18124]={18124,'467:81,42 H:100024483,100024484'}
G[18141]={18141,'477:56.6,34.3'}
G[18165]={18165,'24:30.9,30.8'}
G[18166]={18166,'481:54.74,44.33'}
G[18180]={18180,'477:71.52,40.81'}
G[18183]={18183,'477:55.48,68.70'}
G[18200]={18200,'477:71.57,40.53'}
G[18209]={18209,'477:33.18,42.31'}
G[18210]={18210,'477:31.4,44.1 477:31.5,44'}
G[18218]={18218,'477:71.38,40.63'}
G[18221]={18221,'38:69.90,36.55'}
G[18222]={18222,'477:54.47,72.08'}
G[18223]={18223,'477:54.61,72.21'}
G[18224]={18224,'477:54.46,72.31'}
G[18229]={18229,'477:32.4,36 477:32.5,36.1'}
G[18233]={18233,'477:55.51,68.78'}
G[18234]={18234,'477:55.3,37.1 477:55.3,37.7 477:55.4,38.6 477:55.5,38.5 477:55.6,37 477:55.7,37.8'}
G[18248]={18248,'475:52,58.2'}
G[18249]={18249,'478:49.7,43.4'}
G[18252]={18252,'478:58.53,53.56'}
G[18253]={18253,'32:47.2,75.1'}
G[18261]={18261,'477:73.80,62.60'}
G[18262]={18262,'478:19.3,64.1 478:19.8,62.1 478:20,63 478:20,63.5 478:20.5,62.8'}
G[18265]={18265,'477:31.36,57.78'}
G[18266]={18266,'465:56.33,62.85'}
G[18267]={18267,'465:55.9,39.1'}
G[18273]={18273,'478:19.7,60.8 478:77.4,87.8'}
G[18276]={18276,'477:30.78,58.14'}
G[18285]={18285,'467:32.80,59.60 H:100025459'}
G[18294]={18294,'477:71.38,40.57'}
G[18295]={18295,'467:68.55,49.36'}
G[18300]={18300,'477:55.6,37.6'}
G[18301]={18301,'477:55.2,36.1'}
G[18302]={18302,'477:56.4,34.4 477:56.6,34.3 477:57.1,34.8'}
G[18333]={18333,'477:31.77,56.79'}
G[18335]={18335,'477:51.94,34.78'}
G[18340]={18340,'467:70.51,80.31'}
G[18343]={18343,'732[1]:32.61,60.35'}
G[18344]={18344,'732[1]:32.56,52.69'}
G[18353]={18353,'477:55.05,70.54'}
G[18369]={18369,'477:72.56,70.69'}
G[18383]={18383,'478:48.8,45.6'}
G[18384]={18384,'478:50.1,46.4'}
G[18385]={18385,'478:50.1,44.9'}
G[18386]={18386,'478:48.9,44.7'}
G[18387]={18387,'478:58.29,54.76'}
G[18389]={18389,'478:57.83,54.24'}
G[18390]={18390,'478:57.40,55.43'}
G[18407]={18407,'477:55.8,37.9'}
G[18408]={18408,'477:54.74,70.88'}
G[18414]={18414,'477:32.3,36.2'}
G[18415]={18415,'477:32.3,36.2'}
G[18416]={18416,'477:53.03,7084 477:53.58,70.99 477:53.85,71.35 477:53.57,71.99 477:54.30,72.34 477:54.53,72.66 477:54.54,73.61 477:55.33,73.26 477:55.69,72.65 477:55.36,71.52 477:54.71,70.37 477:54.33,70.35 477:54.12,69.42 477:53.71,68.69 477:53.86,69.97','Wandering the village'}
G[18417]={18417,'477:27.34,43.08'}
G[18424]={18424,'478:44.03,22.44 478:44.75,21.71 478:44.89,21.12 478:43.69,23.07 478:43.29,23.02 478:43.37,22.59 478:43.44,22.39 478:44.40,24.77'}
G[18427]={18427,'476:53.66,56.26'}
G[18445]={18369,'477:29.52,26.01'}
G[18446]={18446,'478:44.33,26.31'}
G[18447]={18447,'478:50,45.9'}
G[18459]={18459,'478:57.01,53.49'}
G[18471]={18471,'477:42.8,20.8'}
G[18473]={18473,'723[2]:32.81,32.17'}
G[18481]={18481,'481:53.99,44.73'}
G[18482]={18482,'478:11.8,99.2 478:36.4,30.2 478:36.5,30.3 478:36.6,30.6 478:38,26.4 478:38.1,26.5 478:38.7,26.6 478:39.4,24.1 478:39.4,26.3 478:39.5,26.5 478:39.6,24.1 478:40.3,24.9 478:40.4,25.6 478:40.5,25.6 478:40.7,25.4 478:41.9,26.4 478:42.3,26.5 478:42.5,26.6 478:43.3,26.4 478:43.5,26.3 478:43.6,26.5 478:44.5,26.2 478:44.6,26.5 478:45.5,26.4 478:45.5,26.5 478:46,66.7 478:46.5,26.4 478:47.2,27.1 478:47.4,66.7 478:47.9,27.2 478:47.9,66.8 478:48.4,27.5 478:48.5,27.4 478:48.6,27.7 478:48.7,67 478:49.6,28.2 478:50.4,29.2 478:50.5,29.2 478:50.6,29.5 478:84.4,54.2 478:84.8,55.4 478:86.2,55.9 478:90.2,54.7 478:90.6,54.1 478:92.3,52.7 478:94.6,51.1 478:96.6,54.1 478:97.6,53.3 478:98.2,52.4 481:9,92.8 481:37.3,26.3 481:37.7,24.6 481:37.9,26.3 481:77.4,66.9 481:77.4,67.7 481:77.5,64.4 481:77.5,64.7 481:77.6,62.9 481:78,61.3 481:78.1,61.9 481:78.8,61.5 481:79.1,57.1 481:79.1,61.4 481:79.2,58.5 481:79.8,21.3 481:79.8,21.9 481:80.1,55.4 481:80.4,55.6 481:80.4,57.1 481:80.7,55.2 481:80.7,55.9 481:80.9,54.4 481:81.1,30 481:81.1,30.7 481:81.3,34 481:81.5,33.7 481:81.5,54.5 481:81.6,54.1 481:81.8,34.9 481:81.9,53.3 481:82.2,36.4 481:82.2,40.8 481:82.3,52.2 481:82.6,40.3 481:82.8,41.2 481:82.8,51.9 481:82.8,52.5 481:82.9,41.8 481:83,47.3 481:83,49.1 481:83.1,44.3 481:83.1,44.9 481:83.1,47.8 481:83.1,53.5 481:83.2,49.7 481:83.3,54.5 481:83.5,47.1 481:83.6,40.3 481:83.7,54 481:83.9,53.2 481:84,54.5 481:84.3,55.7 481:84.6,54.5'}
G[18484]={18484,'481:72.23,30.73'}
G[18528]={18528,'473:65.3,44'}
G[18530]={18530,'481:42.6,91.4'}
G[18531]={18531,'481:45.20,81.45'}
G[18537]={18537,'481:30.72,34.60'} -- 479:29.6,14.5 479:30.7,17.4 479:30.7,17.5 481:25,21.5 481:41.6,65.2 481:82.6,49.3
G[18538]={18538,'481:23.97,29.72'}	-- 479:29.5,13.9
G[18565]={18565,'478:69.74,44.23'}
G[18566]={18566,'478:63.38,42.72'}
G[18584]={18584,'481:77.2,34.7'}
G[18594]={18594,'481:54.61,80.71'}
G[18596]={18596,'481:54.98,22.53'}
G[18597]={18597,'481:64.47,15.12'}
G[18653]={18653,'481:63.94,15.55'}
G[18675]={18675,'478:37.06,49.53'}
G[18687]={18687,'477:26.1,60.6'}
G[18704]={18704,'478:58.11,53.42'}
G[18705]={18705,'478:49.3,45.9'}
G[18708]={18708,'724[1]:77.70,38.73'}
G[18712]={18712,'478:48.9,44.7'}
G[18713]={18713,'478:57.51,55.77'}
G[18714]={18714,'478:39,43.8'}
G[18715]={18715,'478:40.46,36.15'}
G[18723]={18723,''}		-- Old Hillsbrad
G[18745]={18745,'478:57.18,55.74'}
G[18760]={18760,'478:73.92,35.19'}
G[18785]={18785,'465:25.19,37.23'}
G[18788]={18788,'467:67.83,51.46'}
G[18789]={18789,'477:54.17,75.06'}
G[18803]={18803,'476:55.16,55.97'}
G[18804]={18804,'476:56.1,54.5 476:56.3,54.3'}
G[18809]={18809,'478:59.45,55.42'}
G[18816]={18816,'477:41.2,44.3'}
G[18817]={18817,'477:41.2,44.3'}
G[18891]={18891,'724[1]:17.18,22.21'}
G[18893]={18893,'481:50.24,45.35'}
G[18927]={18927,'301:61.67,74.19'}
G[18930]={18930,'465:87.4,48.2'}
G[18931]={18931,'465:87.37,52.42'}
G[18937]={18937,'475:37.82,61.40'}
G[18938]={18938,'479:33.75,63.99'}
G[18939]={18939,'473:37.61,55.45'}
G[18940]={18940,'481:64.07,41.13'}
G[18944]={18944,'465:84.7,50.2 465:84.8,50.6 465:86.3,50.6 465:86.4,50.3 465:86.5,50.3 465:86.6,50.6 465:88.3,50.3 465:89.4,50.2'}
G[19020]={19020,'477:55.50,36.01'}
G[19035]={19035,'477:61.70,67.09','Pacing about'}
G[19045]={19045,'481:57.99,15.17'}
G[19133]={19133,'477:55.4,37.4 477:55.4,37.5 477:55.5,37.3'}
G[19137]={19137,'477:55.01,70.39'}
G[19148]={19148,'341:30.80,62.93'}
G[19169]={19169,'480:89.66,49.09'}
G[19171]={19171,'471:51.92,42.65'} -- 13:29.36,28.27 464:21.36,54.25>13
G[19172]={19172,'341:58.14,49.39'}
G[19173]={19173,'381:44.71,52.78'}
G[19175]={19175,'321[1]:51.54,75.05'}
G[19176]={19176,'321[1]:40.32,48.97'}
G[19177]={19177,'321[1]:49.98,61.47'}
G[19178]={19178,'382:63.17,47.40'}
G[19188]={19188,'465:15.2,40.8 H:100029476'}
G[19202]={19202,'481:62.81,35.59'}
G[19217]={19217,'479:31.4,66.2'}
G[19219]={19219,'730[1]:50.34,39.53'}
G[19220]={19220,'730[1]:0.00,0.00'}
G[19227]={19227,'481:65.65,69.29'}
G[19229]={19229,'465:87.34,50.75'}
G[19253]={19253,'465:87.4,49.8'}
G[19254]={19254,'19:54.4,50.4 19:54.4,50.5 19:54.5,50.4 19:54.5,50.7'}
G[19255]={19255,'465:55.9,36.8'}
G[19256]={19256,'465:58,41.3'}
G[19273]={19273,'465:65.9,43.6'}
G[19293]={19293,'465:15.62,52.04'}
G[19294]={19294,'465:15.96,51.57'}
G[19308]={19308,'465:54.68,62.78'}
G[19309]={19309,'465:61.70,60.90'}
G[19310]={19310,'465:71.34,62.76'}
G[19333]={19333,'473:29.8,31.3'}
G[19344]={19344,'465:49.24,74.83'}
G[19361]={19361,'465:16.27,65.08'}
G[19367]={19367,'465:49.15,74.84'}
G[19370]={19370,'473:36.8,54.8'}
G[19401]={19401,'465:66.1,43.8'}
G[19402]={19402,'467:83.35,37.54'}
G[19409]={19409,'465:71.40,62.48'}
G[19412]={19412,'Z722'}
G[19417]={19417,'478:35.07,66.19'}
G[19428]={19428,'723[1]:0.00,0.00'}
G[19456]={19456,'462:37.59,86.23'}
G[19466]={19466,'479:32.1,64.2'}
G[19467]={19467,'479:30.7,17.5 479:32,64.2'}
G[19468]={19468,'479:32,64.1'}
G[19469]={19469,'479:32,64.1'}
G[19471]={19471,'475:53.1,54.5 475:53.2,54.4'}
G[19475]={19475,'481:61.65,52.16'}
G[19481]={19481,'479:58.3,86.4 479:58.4,86.5'}
G[19488]={19488,'479:57.5,86.3'}
G[19489]={19489,'479:57.5,86.3'}
G[19569]={19569,'479:20.2,55.9 479:21.3,55.7 479:21.8,55.6'}
G[19570]={19570,'479:32.6,64.4'}
G[19578]={19578,'479:31.5,56.6'}
G[19581]={19581,'473:63.33,30.40'}
G[19583]={19583,'479:45.31,34.88'}
G[19589]={19589,'479:32,55.4'}
G[19606]={19606,'478:49.8,45.3'}
G[19617]={19617,'479:32.3,63.9'}
G[19622]={19622,'782[1]:49.82,15.60'}
G[19634]={19634,'479:34.1,68.1'}
G[19644]={19644,'Near'}
G[19645]={19645,'479:32.9,64.7'}
G[19670]={19670,'478:39.42,58.53'}
G[19671]={19671,'Z732'}
G[19674]={19674,'478:39.38,58.47'}
G[19678]={19678,'481:64.71,70.68'}
G[19682]={19682,'465:61.7,81.7'}
G[19683]={19683,'465:61.8,81.5'}
G[19684]={19684,'481:59.67,41.43 481:77.20,43.53 481:60.71,14.64'}
G[19690]={19690,'479:26.9,77'}
G[19697]={19697,'478:35.09,65.09'}
G[19698]={19698,'478:35.1,65.2'}
G[19709]={19709,'479:32.4,66.7'}
G[19715]={19715,'481:49.41,35.21 481:52.44,33.20 481:56.29,33.45 481:59.70,36.21 481:61.64,40.87 481:61.43,48.58 481:58.53,54.45 481:53.52,56.94 481:48.19,53.04','Walks in circle around outside of Terrace of Light'}
G[19720]={19720,'481:43.63,29.77'}
G[19728]={19728,'479:46.6,56.4 479:46.6,56.5'}
G[19736]={19736,'465:61.7,81.7'}
G[19832]={19832,'479:37.3,63.8'}
G[19840]={19840,'479:48.2,86.7'}
G[19844]={19844,'477:51.81,56.85'}
G[19860]={19860,'161:51.63,28.00'}
G[19880]={19880,'479:32.4,64.3 479:32.5,64.2'}
G[19935]={19935,'161:57.5,56.5 161:57.6,55.9 161:57.7,55.2 161:57.9,58.4 161:58.2,54.3 161:58.2,58.7 161:58.6,54.5 161:59,58.9 161:59.1,53.9 161:59.6,54.1 161:59.8,58.2 161:60.2,57.4 161:60.3,54.7 161:60.5,55.1 161:60.5,56.8 161:60.6,55.8'}
G[19936]={19936,'161:57.6,55.8 161:57.6,56.8 161:57.7,57.5 161:57.9,54.8 161:58.3,54.4 161:58.3,58.7 161:58.7,54.5 161:58.8,58.8 161:59.1,54 161:59.5,54.1 161:59.7,58.2 161:60,54.5 161:60,58.8 161:60.2,57.3 161:60.5,55.1 161:60.5,56.8 161:60.6,55.8 161:60.6,58'}
G[19937]={19937,'465:56.9,77.4'}
G[19945]={19945,'475:34.41,77.74'}
G[19995]={19995,'475:43,53 H:100030431'}
G[19998]={19998,'475:40,56 H:100030431'}
G[20066]={20066,'479:46.7,57'}
G[20067]={20067,'479:44,36'}
G[20071]={20071,'479:58.3,31.6 479:58.8,31 479:60,30.9'}
G[20084]={20084,'479:45.8,36'}
G[20092]={20092,'479:58.4,31.4'}
G[20102]={20102,'11:69.03,70.67'}
G[20110]={20110,'479:71.2,35.2'}
G[20112]={20112,'479:34.6,37.9'}
G[20130]={20130,'161:58.06,54.10'}
G[20142]={20142,'161:65.35,49.72'}
G[20154]={20154,'479:70.9,38.8'}
G[20159]={20159,'465:5.1,51.1 465:5.7,51.1 465:6.4,50.4 465:6.5,50.5 465:6.7,50.4 465:8.4,50.1 465:9,50.5 465:9.4,50.4 465:9.6,50.5 465:9.7,50.4 465:10.5,50.3 465:11.4,50.7 465:11.6,50.5 465:12.1,50.1 465:13.2,50.1 465:13.5,50.1 465:14.9,50.1 465:15.5,51.6 465:15.6,50.9 465:16.1,50.1 465:16.5,50.7 465:17.1,50 465:17.8,49.9 465:19.2,49.6 465:19.4,48.9 465:19.5,49.4 465:19.5,49.6 465:20.7,49.2 465:21.6,49.7 465:22,49.2 465:23.2,49.2 465:23.2,49.5 465:23.8,49.5 465:24.2,49.3 465:24.7,49.3 465:24.7,49.5 465:25.3,61.9 465:25.4,60.3 465:25.5,60.7 465:25.6,61.5 465:25.7,59.7 465:26,49.4 465:26,63 465:26.1,49.5 465:26.1,58.3 465:26.3,58.8 465:26.6,58.7 465:26.7,49.4 465:26.9,49.6 465:27.4,58.2 465:27.6,57.9 465:28.1,50.1 465:28.4,57.3 465:28.5,57.5 465:28.9,50.4 465:29,50.7 465:29.1,57 465:30,51.5 465:30.2,51.4 465:30.3,57.1 465:30.7,57.3 465:31.1,52.4 465:31.1,57.5 465:31.3,52.9 465:31.6,53.3 465:31.7,53.6 465:31.8,57.5 465:31.9,57.4 465:32,54.6 465:32.3,56.4 465:32.5,56.3 465:32.5,56.6 465:45.8,52.2 465:46.6,52.1 465:48,52 465:48.8,51.8 465:50.3,55.4 465:50.3,55.9 465:50.5,54.7 465:51.5,54.1 465:51.9,52.8 465:83.3,65.9 465:85.9,64.9 465:86.8,64.9 465:90.2,65.1 465:91.1,65.1 465:91.9,65'}
G[20162]={20162,'479:33.8,64.2'}
G[20201]={20201,'Z733'}
G[20205]={20205,'479:44.8,36.7'}
G[20206]={20206,'465:56.38,62.91'}
G[20232]={20232,'465:79.34,33.86'}
G[20233]={20233,'894:49.72,37.53 464:79.1,46.6>894'}
G[20234]={20234,'465:78.41,34.90'}
G[20235]={20235,'465:78.26,34.45'}
G[20281]={20281,'479:48.1,63.4 479:48.1,63.5 479:48.7,63.5 479:49.4,64.7 479:49.4,65.8 479:49.5,65.8'}
G[20341]={20341,'479:34.6,37.8'}
G[20393]={20393,'479:26.4,42.3 479:26.4,42.5'}
G[20406]={20406,'382:57.98,90.45'}
G[20407]={20407,'301:65.94,31.37'}
G[20415]={20415,'479:58,84.8 479:58.6,84.8 479:59.1,78.9 479:59.1,79.5 479:59.2,80.7 479:59.2,82.4 479:59.2,83 479:59.2,83.8'}
G[20448]={20448,'479:59.4,32.3 479:59.5,32.3'}
G[20449]={20449,'479:59.2,32.4 479:59.3,32.5'}
G[20450]={20450,'479:59.1,32.1 479:59.9,31.9 479:60.1,32.5'}
G[20463]={20463,'479:57.7,85.2'}
G[20464]={20464,'479:57.7,85'}
G[20470]={20470,'479:44.7,34.9'}
G[20471]={20471,'479:44.7,34.9'}
G[20482]={20482,'479:56.8,38.7'}
G[20494]={20494,'473:29.1,29.4 473:29.1,29.5'}
G[20510]={20510,'473:37.6,56'}
G[20515]={20515,'479:65.20,66.81'}
G[20518]={20518,'479:71.2,39'}
G[20551]={20551,'479:59.4,45.1'}
G[20552]={20552,'479:60.9,41.6'}
G[20604]={20604,'471:62.8,66.9 471:63.6,68.1'}
G[20612]={20612,'480:56.6,52.8'}
G[20677]={20677,'465:13.12,61.03'}
G[20678]={20678,'465:15.6,58.7'}
G[20679]={20679,'465:13.01,58.43'}
G[20735]={20735,'504[1]:57.22,66.83'}
G[20763]={20763,'479:57,37.7 479:57.1,35.3 479:57.1,37.1 479:57.2,32.3 479:57.2,35.8 479:57.8,32.1'}
G[20780]={20780,'479:34.8,38.2'}
G[20793]={20793,'465:68.30,28.54'}
G[20810]={20810,'479:46.4,56.4 479:46.4,56.5 479:46.5,56.4 479:46.5,56.5'}
G[20811]={20811,'479:43.5,35.1'}
G[20871]={20871,'479:42.3,32.6'}
G[20907]={20907,'479:60.1,31.8'}
G[20913]={20913,'479:44.7,14.5'}
G[20914]={20914,'471:81.4,52.6'}
G[20920]={20920,'479:26.2,41.6'}
G[20921]={20921,'479:46.4,56.1 479:46.5,56.1'}
G[21006]={21006,'478:69.66,44.17 478:69.67,43.95'}
G[21007]={21007,'478:63.29,42.39 478:63.41,42.47 478:63.21,42.30 478:63.33,42.68'}
G[21024]={21024,'473:42.2,45'}
G[21027]={21027,'473:52.1,18.8 473:52.3,19.5 473:52.4,20.5 473:52.5,20.4 473:52.5,20.6 473:53,21.9 473:53.3,24.5 473:53.4,19.4 473:53.4,24.4 473:53.6,19.5 473:53.7,21.9 473:53.8,24.7 473:54.2,18.8 473:54.2,24.2 473:54.3,21.3 473:54.5,21.2 473:54.5,23.8 473:54.9,19.3 473:55,23.4 473:55.3,20 473:55.5,20.2 473:55.7,22.6 473:55.8,20.6 473:55.9,22'}
G[21066]={21066,'475:36.3,67.2'}
G[21088]={21088,'475:76,60.4'}
G[21107]={21107,'475:61.15,70.44'}
G[21110]={21110,'475:60.9,68.2'}
G[21112]={21112,'475:60.7,69'}
G[21117]={21117,'475:52.2,57.6'}
G[21118]={21118,'475:60.1,68.3 475:60.3,69 475:60.5,68.3 475:60.5,69.3'}
G[21133]={21133,'465:70.96,63.37'}
G[21147]={21147,'475:51.9,58.4 475:51.9,58.5'}
G[21151]={21151,'475:37.4,64.7 475:37.5,64.7'}
G[21158]={21158,'475:36.3,66.3 475:36.6,66.5'}
G[21175]={21175,'465:55.1,36'}
G[21183]={21183,'473:53.9,23.4 473:53.9,23.5'}
G[21197]={21197,'475:37.4,65 475:37.5,65'}
G[21209]={21209,'465:51.15,60.22'}
G[21256]={21256,'465:55.1,36.3'}
G[21257]={21257,'465:66.2,42'}
G[21277]={21277,'475:44,51.9'}
G[21279]={21279,'465:61.2,81.7'}
G[21283]={21283,'465:55.2,38.7'}
G[21291]={21291,'473:44.6,23.7'}
G[21292]={21292,'473:29.6,50.4 473:29.6,50.5'}
G[21293]={21293,'473:47.5,57.2'}
G[21300]={21300,'475:68.96,33.00'}
G[21311]={21311,'475:52.8,58.9'}
G[21318]={21318,'473:29.6,50.4 473:29.6,50.5'}
G[21330]={21330,'473:35.8,57.7'}
G[21349]={21349,'475:45,72.3'}
G[21357]={21357,'473:39.5,53.7'}
G[21359]={21359,'473:30.4,32.4 473:30.4,32.5 473:30.5,32.4 473:30.5,32.5'}
G[21400]={21400,'478:57.66,53.31'}
G[21402]={21402,'473:62.5,28.5 473:62.6,28.4'}
G[21411]={21411,'481:63.95,70.03'}
G[21460]={21460,'475:60.3,68.3'}
G[21465]={21465,'478:77.57,38.72'}
G[21469]={21469,'475:37,65.7'}
G[21471]={21471,'473:40.4,41.3 473:40.5,41.3'}
G[21475]={21475,'473:38.6,38.2'}
G[21496]={21496,'475:75.2,62.1'}
G[21499]={21499,'473:24,35 H:100030579,100030579'}
G[21657]={21657,'473:57.1,55.5 473:57.3,54.8 473:57.3,56.6 473:57.4,54.3 473:57.5,54.6 473:57.6,57.2 473:58.3,53.8 473:58.4,58.2 473:58.6,53.5 473:58.7,53.4 473:59.2,58.4 473:59.3,58.6 473:59.5,53.4 473:59.6,58.4 473:60,53.9 473:60.2,59 473:60.4,59.5 473:60.5,59.4 473:60.6,54.2 473:61.2,54.8 473:61.2,58 473:61.4,60.1 473:61.6,58.4 473:62,55.3 473:62.2,63.4 473:62.3,60.2 473:62.3,61.5 473:62.4,55.6 473:62.5,55.4 473:62.9,60.4 473:62.9,60.5 473:63,55.7 473:63.7,61 473:63.9,56.1 473:64.4,56.7 473:64.5,56.4 473:64.7,60.8 473:65.1,57.1 473:65.6,60.7 473:65.9,57.4 473:66.1,57.6 473:66.2,60.4 473:66.5,57.7 473:66.5,60.3 473:66.5,60.5 473:67.8,60.4 473:67.9,58.2 473:68,58.5 473:68.3,60.5 473:68.3,83.9 473:68.5,58.4 473:68.8,60.9 473:69.1,83.7 473:69.2,61.7 473:69.2,85.4 473:69.3,58.6 473:69.4,63.2 473:69.4,63.6 473:69.6,63.4 473:69.7,63.8 473:69.7,84.1 473:69.8,58.9 473:70.4,86 473:70.6,59.2 473:70.6,64 473:70.9,59.8 473:71.1,85.8 473:71.2,63.4 473:71.3,60.7 473:71.5,63.5 473:71.6,62.9 473:71.7,60.9 473:71.8,62.4 473:72.1,85.3'}
G[21690]={21690,'475:55.1,72.8'}
G[21691]={21691,'475:60.4,69.1 475:60.5,69'}
G[21700]={21700,'473:58.1,48.3'}
G[21755]={21755,'475:60.3,69'}
G[21769]={21769,'473:28.4,26.5 473:28.5,26.4 473:28.5,26.5'}
G[21770]={21770,'473:30,28.3'}
G[21771]={21771,'473:30.4,30.9 473:30.5,30.9'}
G[21772]={21772,'473:29.9,27.7'}
G[21773]={21773,'473:36.3,56.9'}
G[21774]={21774,'473:36.4,55.7 473:36.4,56.7 473:36.6,55.6 473:36.6,56.5 473:36.8,55.2 473:38.1,54.5 473:61.8,84 473:90.2,83 473:90.3,83.9 473:90.4,82 473:90.7,82.7 473:90.7,84'}
G[21775]={21775,'473:38.3,54'}
G[21777]={21777,'473:36.6,55.2'}
G[21782]={21782,'475:62.2,39.1'}
G[21789]={21789,'473:27.4,21.2 473:27.5,21.2'}
G[21790]={21790,'473:40.8,22.3'}
G[21797]={21797,'473:58.2,70.8'}
G[21822]={21822,'473:61.2,29.2'}
G[21824]={21824,'475:60.4,68.8'}
G[21826]={21826,'473:57.3,49.6'}
G[21860]={21860,'473:61.2,29.2'}
G[21895]={21895,'475:75.8,61.4 475:75.8,61.5'}
G[21896]={21896,'475:75.8,61.4 475:75.8,61.5'}
G[21902]={21902,'478:39.51,54.37'}
G[21937]={21937,'473:36.4,56.9'}
G[21938]={21938,'473:28.5,26.5'}
G[21950]={21950,'475:52.7,59'}
G[21953]={21953,'473:54.7,58.2'}
G[21954]={21954,'473:55.8,58.2'}
G[21955]={21955,'473:56.3,59.5'}
G[21962]={21962,'Z731'}
G[21983]={21983,'475:61.9,39.4 475:61.9,39.5'}
G[21984]={21984,'475:51.8,58.4 475:51.8,58.5'}
G[21998]={21998,'473:21.8,40.9 473:23.1,37.1 473:23.5,34.1 473:23.6,36.9 473:27.2,42.5 473:27.4,21 473:28.4,32.6 473:28.6,32.7 473:28.8,26.9 473:29.4,28.2 473:29.8,28.4 473:30.2,28.6 473:30.3,31 473:30.8,37.9 473:30.9,30.4 473:33,39.2 473:33.9,43 473:35.3,42.5 473:35.6,41.9 473:36,39.1 473:36,68.4 473:36,69.1 473:36.7,69.4 473:37,47.9 473:37.1,37.5 473:37.2,68.3 473:37.4,69.7 473:37.7,21.5 473:37.7,38.2 473:37.7,68.2 473:37.8,38.5 473:38.4,70.2 473:38.7,71.4 473:38.7,71.9 473:39.2,69.6 473:39.3,59 473:39.3,59.9 473:39.5,65.2 473:39.8,70.5 473:40,69.6 473:40.3,69.2 473:40.4,72.2 473:40.7,38.9 473:40.7,68.1 473:40.8,69.3 473:41.1,69.6 473:41.1,71.4 473:41.5,70 473:41.9,45.6 473:42.1,72.8 473:42.2,44 473:42.2,45.1 473:42.2,68.7 473:42.4,70.7 473:42.5,67.4 473:42.5,68.4 473:42.5,72.8 473:42.8,55.6 473:42.8,70.7 473:42.9,69.4 473:43,72.2 473:43.1,51.8 473:43.1,62.6 473:43.4,66.4 473:43.4,69.9 473:43.5,63.3 473:43.5,71.2 473:43.6,73.1 473:44,72.4 473:44.1,40.2 473:44.5,52.9 473:44.6,48.4 473:44.7,44.8 473:45.8,55.5 473:46.6,48.6 473:46.9,57.1 473:47,66.3 473:47.1,63.2 473:47.2,71.6 473:47.4,47.1 473:47.4,65.4 473:47.6,57.2 473:47.7,62.7 473:48.3,57.5 473:48.4,66.5 473:48.9,63.3 473:49.2,58.6 473:49.3,61.2 473:49.3,71.2 473:49.6,59.4 473:49.6,62.4 473:49.6,71.3 473:50.2,64.6 473:50.3,63.5 473:50.4,57.4 473:50.4,57.5 473:50.4,60.8 473:50.4,68.3 473:50.4,69.9 473:50.6,63.2 473:50.8,58.1 473:50.8,58.6 473:50.8,61.3 473:50.8,65.6 473:50.9,59.8 473:50.9,64.4 473:50.9,66.8 473:51,61.6 473:51,64.5 473:51,69 473:51.1,70.6 473:51.2,68.2 473:51.3,57.4 473:51.3,69.6 473:51.5,67.8 473:51.6,57.4 473:51.6,66.3 473:51.8,53.9 473:51.8,63 473:51.8,63.7 473:51.9,61 473:51.9,72.8 473:52,65.2 473:52.1,58.2 473:52.1,60.4 473:52.1,67 473:52.1,70.3 473:52.1,72.4 473:52.2,23 473:52.2,58.9 473:52.3,62.1 473:52.4,68.5 473:52.4,70.9 473:52.5,58.3 473:52.5,72.8 473:52.6,20.8 473:52.6,59.9 473:52.6,63.6 473:52.7,69.6 473:52.8,64.5 473:52.9,57.1 473:52.9,67.4 473:52.9,71.2 473:53,59 473:53,61.2 473:53,68.4 473:53,73.8 473:53.1,68.8 473:53.2,62.6 473:53.2,66 473:53.4,22.6 473:53.4,62 473:53.4,71.6 473:53.5,62.2 473:53.5,67.1 473:53.5,71.6 473:53.6,59.7 473:53.6,64.6 473:53.6,71.4 473:53.7,61.1 473:53.7,67.9 473:53.8,69.9 473:54.1,64.4 473:54.2,63.4 473:54.2,69 473:54.4,66.1 473:54.5,58.7 473:54.5,61.1 473:54.6,59.6 473:54.6,63.2 473:54.6,63.9 473:54.6,64.5 473:54.6,65.5 473:54.8,68.9 473:54.9,38.8 473:55,49.6 473:55,69.5 473:55.3,48.3 473:55.6,59.1 473:55.7,45.2 473:55.7,67.2 473:55.8,36.6 473:56.1,61.4 473:56.9,69.1 473:58.2,70.7 473:58.6,66.4 473:58.8,41.4 473:58.8,58.5 473:59,58.3 473:59,66.7 473:59.6,56.5 473:59.7,43.1 473:59.7,70.2 473:60,42.2 473:61.1,35.2 473:61.1,67.5 473:61.2,40.6 473:61.4,63.9 473:61.7,41 473:62.3,40.3 473:62.3,55.5 473:63.2,30.5 473:63.4,47.9 473:63.4,51.4 473:64,46.5 473:64.3,39.1 473:64.4,88 473:64.7,85.1 473:65,86.1 473:69.4,50.8 473:96.8,90.1'}
G[22004]={22004,'475:75.3,60.9'}
G[22007]={22007,'475:61.9,39.4 475:62,39.5'}
G[22020]={22020,'475:62.7,40.3'}
G[22024]={22024,'473:35.2,39.3 473:35.2,40.2 473:35.2,40.8 473:35.4,37.4 473:35.4,38.3 473:35.4,41.8 473:35.5,41.9'}
G[22042]={22042,'473:38.7,54.2'}
G[22043]={22043,'473:31,29.9'}
G[22053]={22053,'475:61.3,38.4 475:61.3,38.5'}
G[22059]={22059,'473:23.6,36.8 473:34.9,67.6 473:35.6,42.5 473:36,67.9 473:36.3,55.1 473:36.3,69.5 473:36.4,56.7 473:36.6,47.5 473:36.6,56.3 473:36.6,56.5 473:37,54.8 473:37.1,68 473:37.2,66.8 473:37.5,54.9 473:37.6,55.5 473:37.7,38.6 473:37.7,67.1 473:38.1,54.4 473:38.1,67.6 473:38.2,70.2 473:38.4,57.2 473:38.4,68.5 473:38.6,55.3 473:38.7,53.7 473:39.1,45.1 473:39.1,69.1 473:39.3,69.7 473:39.7,50.6 473:40,71.5 473:40.2,71.3 473:40.3,69.3 473:40.6,55.4 473:40.6,71 473:40.7,60.2 473:40.9,21.7 473:41.2,69.2 473:41.3,70.1 473:41.8,69.2 473:42.1,45.2 473:42.1,71.4 473:42.2,72.9 473:42.3,70 473:42.5,62.3 473:42.6,68 473:42.7,72.2 473:42.8,69.3 473:42.8,69.5 473:43,70.6 473:43.2,59.1 473:43.4,54.3 473:43.4,73.2 473:43.5,70.9 473:43.5,71.8 473:43.8,70.3 473:43.9,45.4 473:44,59.2 473:44.1,72.6 473:45.2,62.1 473:45.4,55.8 473:46.7,48.9 473:46.7,54 473:46.9,58.8 473:47.5,53.7 473:49.3,58.1 473:49.3,71.3 473:49.7,68.9 473:50.1,59.8 473:50.2,62 473:50.3,62.6 473:50.4,58.3 473:50.4,64.4 473:50.8,58.8 473:50.8,62.1 473:50.9,57.7 473:50.9,59.9 473:50.9,66.7 473:50.9,69.7 473:51,64.5 473:51.1,62.8 473:51.1,69 473:51.1,70.6 473:51.3,71.5 473:51.4,61.2 473:51.4,64 473:51.4,65.6 473:51.4,68 473:51.5,62 473:51.5,72.8 473:51.8,63.2 473:51.8,66.3 473:52,58.3 473:52,64.4 473:52,65.2 473:52.1,60 473:52.1,66.5 473:52.2,59.1 473:52.2,60.7 473:52.2,68.7 473:52.2,72.4 473:52.3,67.6 473:52.3,69.6 473:52.4,71 473:52.6,69.4 473:52.7,64.1 473:52.7,66 473:52.8,71 473:52.9,63.2 473:52.9,68.4 473:52.9,69.5 473:53,61.2 473:53,65.3 473:53.2,62.2 473:53.2,66.5 473:53.3,59.7 473:53.4,59.2 473:53.4,71.9 473:53.5,59.9 473:53.5,71.5 473:53.6,63.7 473:53.8,61.1 473:53.8,69.9 473:54,67.6 473:54.1,68.7 473:54.2,56.5 473:54.2,62.7 473:54.2,65.3 473:54.2,70.5 473:54.6,49.9 473:54.7,58.8 473:54.7,63.8 473:54.7,68.8 473:55.3,50.7 473:55.5,68.9 473:55.8,59 473:55.8,66.2 473:55.9,56.4 473:56.2,57.1 473:56.4,58.4 473:56.5,57 473:56.8,68.9 473:57.4,66.8 473:57.4,73.9 473:58.3,70.7 473:59,58.7 473:62.5,88.5 473:64.6,62.5 473:67.3,87.3 473:69.8,51.6 473:93,97.3 473:96.9,99'}
G[22103]={22103,'475:53.2,41.1'}
G[22107]={22107,'465:61.2,81.3'}
G[22112]={22112,'473:69.8,61.4'}
G[22113]={22113,'473:59.4,58.7 473:62.5,60.3'}
G[22127]={22127,'475:62.5,38.4'}
G[22133]={22133,'475:62.6,38.3'}
G[22149]={22149,'475:62,38'}
G[22150]={22150,'475:62,38'}
G[22211]={22211,'473:56.3,58.7'}
G[22214]={22214,'473:62.2,29.2'}
G[22215]={22215,'475:36.4,23.4 475:36.5,23.5 475:36.6,23.2 475:37.2,22.2'}
G[22216]={22216,'475:61.68,39.62'}
G[22231]={22231,'465:61.6,81.8'}
G[22272]={22272,'478:37.37,51.28'} -- 478:37.37,50.94 478:37.59,51.41 478:37.16,50.92 478:37.52,51.24 478:37.51,51.54
G[22278]={22278,'478:37.45,50.76'}
G[22292]={22292,'481:52.53,21.00'}
G[22293]={22293,'479:38.1,25.6'}
G[22312]={22312,'475:74.9,60.5'}
G[22364]={22364,'478:31.43,75.65'}
G[22365]={22365,'478:37.73,51.35'}
G[22370]={22370,'478:37.25,50.84 478:37.29,50.99 478:37.71,51.76 478:38.37,51.22 478:38.16,50.50 478:37.83,50.02'}
G[22373]={22373,'481:51.78,20.79'}
G[22377]={22377,'478:30.62,49.07','In Shadow Tomb'}
G[22386]={22386,'475:50,36'}
G[22420]={22420,'478:37.86,51.68'}
G[22421]={22421,'Z728 X'}
G[22423]={22423,'475:1.7,91.6 475:60.8,60 475:61.4,60.5 475:61.7,58.9 475:61.7,60.7 475:62.2,60.4 475:62.3,62.3 475:62.3,65.2 475:62.4,62.5 475:62.5,59.2 475:62.6,64.2 475:62.8,60.4 475:62.8,60.9 475:63,62.1 475:63,63.1 475:63,65 475:63.2,66.5 475:63.4,65.7 475:63.4,67.8 475:63.5,59.3 475:63.5,66 475:63.6,72 475:63.7,62.9 475:63.7,67.6 475:63.9,67.1 475:64,61.9 475:64,65.2 475:64.2,69.8 475:64.3,68.9 475:64.9,67.6 475:64.9,69.3 475:65.1,70.3 475:65.5,70.3'}
G[22424]={22424,'478:53.71,72.38'}
G[22429]={22429,'481:48.6,18.6','Walks in this area'} -- 481:49.61,16.42 481:51.67,15.10 481:52.08,17.73 481:50.13,18.25 481:45.39,22.67 481:46.43,20.02
G[22430]={22430,'465:54.32,63.64','Upstairs'}
G[22433]={22433,'473:65.9,87.1'}
G[22446]={22446,'478:31.01,76.12'}
G[22456]={22456,'478:31.06,76.53'}
G[22458]={22458,'478:30.10,76.14'}
G[22462]={22462,'478:49.71,76.19'}
G[22479]={22479,'479:66.4,67.2'}
G[22481]={22481,'478:30.98,76.18'}
G[22485]={22485,'467:41.28,29.00'}
G[22488]={22488,'475:32.2,91.2'}
G[22489]={22489,'475:53,96.2'}
G[22497]={22497,'481:56.44,49.13'}
G[22818]={22818,'HC Near'}
G[22819]={22819,'481:75.06,47.88'}
G[22820]={22820,'780[1]:48,18.2 467:51.90,33.40>780'}
G[22823]={22823,'467:19.2,51.6'}
G[22836]={22836,'477:31.49,57.61'}
G[22893]={22893,'477:42.8,20.7'}
G[22899]={22899,'479:45.8,36.2'}
G[22914]={22914,'FC Near'}
G[22919]={20482,'475:52.9,15'}
G[22931]={22931,'182:51.53,80.87'}
G[22935]={22935,'43:85.09,43.45'}
G[22940]={22940,'481:64.96,68.09'}
G[22941]={22941,'475:55.48,44.86','On tower'}
G[22995]={22995,'475:55.42,45.25'}
G[23010]={23010,'HV 471:55.81,48.84'}
G[23035]={80648,'723[2]:32.55,59.78'}
G[23038]={23038,'478:64.09,66.89'}
G[23042]={23042,'478:64.05,66.88'}
G[23048]={23048,'478:64.54,66.69'}
G[23053]={23053,'475:55.3,45.9 475:55.5,45.7 475:55.6,47.9 475:55.9,46.7'}
G[23066]={23066,'478:69.2,78.2 H:100032523'}
G[23120]={23120,'475:27.6,52.8'}
G[23127]={23127,'341:55.3,29.1'}
G[23128]={23128,'321:49.2,71.2'}
G[23139]={23139,'473:66.2,85.7'}
G[23140]={23140,'473:66.1,86.4'}
G[23141]={23141,'473:66,86.4'}
G[23149]={23149,'473:63,87.8 473:65.3,90.2'}
G[23158]={23158,'Z796'}
G[23166]={23166,'473:71.6,87.7'}
G[23233]={23233,'475:28.8,57.4'}
G[23253]={23253,'475:28.9,57.9'}
G[23265]={23265,'477:55.7,37.4'}
G[23267]={23267,'473:74.6,86.6 H:100032621'}
G[23268]={23268,'477:55.40,68.69'}
G[23270]={23270,'481:47.24,26.30'}
G[23271]={23271,'481:35.06,32.36'}
G[23272]={23272,'481:44.8,76.2'}
G[23273]={23273,'481:60.86,63.53'}
G[23280]={23280,'475:52,54.4 475:52,54.5'}
G[23286]={23286,'473:67.8,83.4 H:100032726'}
G[23291]={23291,'473:66.8,86.1'}
G[23300]={23300,'475:28.4,58 475:28.5,58.1'}
G[23306]={23306,'478:64.23,66.97'}
G[23316]={23316,'475:28.4,57.6 475:28.5,57.6'}
G[23324]={23324,'473:74.2,88.6 H:100032726'}
G[23334]={23334,'475:27.4,52.7 475:27.5,52.7'}
G[23335]={23335,'475:28,51.4 475:28,51.5'}
G[23340]={23340,'473:64.6,82.2 473:64.7,83.3 473:64.7,83.9 473:64.7,85.1 473:65.2,85.7'}
G[23342]={23342,'473:63.2,83.5 473:64.7,83.1 473:64.7,84.3 473:64.7,84.9 473:65.2,85.5 473:66.7,87.8 473:67.2,82.4 473:67.2,82.7 473:67.8,83.6 473:68,84.9'}
G[23344]={23344,'473:64.7,85.9 473:64.8,82.9 473:64.9,84.1 473:65.2,85.3 473:66.9,82.8'}
G[23345]={13437,'473:64.7,83.2 473:64.7,83.8 473:64.7,85.7 473:64.8,82 473:65,81.4 473:65.2,85.1 473:65.7,80.9 473:66.7,82.3 473:66.9,82.6 473:67.6,84.2 473:67.9,86 473:68.1,83.3 473:68.3,87.1 473:68.3,87.8 473:68.9,89 473:69.1,83.9 473:69.4,90 473:69.7,81.8 473:69.8,79.8 473:69.8,81 473:70.1,78.9 473:70.4,88.1 473:71.3,79.1 473:71.3,90.8 473:71.7,79.3 473:72.4,80.4 473:72.4,86 473:72.6,81.4 473:72.6,82.2 473:72.7,82.8 473:74.1,83.2 473:75.1,87.6 473:75.2,83.3 473:75.4,88.8 473:75.8,90.4 473:75.9,86.4 473:75.9,86.5 473:76.1,82.8 473:76.1,84.2 473:76.3,82.2 473:76.5,82.1 473:78.5,81.6'}
G[23346]={13181,'473:62.2,85.4 473:64.7,82.3 473:64.7,83.2 473:64.7,84.4 473:64.7,85.6 473:65.2,85 473:66.2,88.4'}
G[23348]={23348,'473:64.7,83 473:64.7,83.6 473:65.4,85.4 473:65.4,85.5 473:65.5,85.4 473:65.5,85.5'}
G[23376]={23376,'473:63.4,87.5 473:63.8,87.4 473:64.5,86.8 473:64.5,87.5 473:65.4,89.4 473:65.4,89.5 473:65.5,88.3 473:65.5,88.8'}
G[23383]={23383,'478:61,75 478:68.4,73.8 478:75.04,86.27'}
G[23413]={23413,'475:28.28,52.10'}
G[23415]={23415,'478:63.50,65.81'}
G[23427]={23427,'473:66.2,85.7'}
G[23428]={23428,'475:28.1,58.6'}
G[23433]={23433,'481:66.62,16.42'}
G[23434]={23434,'473:56.4,58.6 473:56.5,58.6 473:57.1,58.2'}
G[23449]={23449,'481:64.31,42.33'}
G[23452]={23452,'473:62.39,29.29'}
G[23461]={23461,'481:66.4,18 481:66.4,18.7 481:66.7,18.4 481:66.8,18.6'}
G[23462]={23462,'481:67.92,17.03'}
G[23463]={23463,'481:67.50,18.83'}
G[23464]={23464,'481:68.04,18.12'}
G[23465]={23465,'481:65.89,19.13'}
G[23466]={23466,'481:66.02,17.33'}
G[23473]={23473,'475:27.9,52.2'}
G[23486]={23486,'27:55.13,37.72'}
G[23546]={23546,'491:60.53,61.08 491:60.39,60.99 491:60.56,61.28'}
G[23547]={23547,'491:61.15,62.64 491:60.80,62.52'}
G[23548]={23548,'491:60.17,61.03 491:60.54,61.28'}
G[23558]={23558,'HB 27:53.68,38.55'}
G[23566]={23566,'141:68.36,51.03'}
G[23567]={23567,'141:29.79,47.67 141:29.73,47.62'}
G[23568]={23568,'141:46.62,24.61'}
G[23569]={23569,'141:63.74,17.04'}
G[23570]={23570,'141:41.54,72.98'}
G[23572]={23572,'141:42.33,72.93'}
G[23574]={23574,'781:35.51,24.73'}
G[23579]={23579,'141:41.86,73.99'}
G[23600]={23600,'141:46.14,57.36 141:46.10,57.43'}
G[23601]={23601,'141:46.05,57.24'}
G[23618]={23618,'9:48.35,53.10'}
G[23627]={23627,'HB 27:56.12,38.05'}
G[23628]={23628,'HB 27:56.58,36.91'}
G[23706]={23706,'4:40.73,17.35'}
G[23710]={23710,'HB 27:56.37,37.84'}
G[23723]={23723,'141:46.66,23.05'}
G[23728]={23728,'491:60.12,62.43'}
G[23729]={23729,'491:58.77,62.76'}
G[23730]={23730,'491:62.3,57.7'}
G[23736]={23736,'491:59.79,63.24'}
G[23749]={23749,'491:28.87,44.24 491:28.81,44.06','Pacing on the second floor of the keep'}
G[23770]={23770,'491:33.97,43.80'}
G[23773]={23773,'491:31.17,40.84'}
G[23778]={23778,'491:78.68,37.13'}
G[23780]={23780,'491:78.60,31.22'}
G[23784]={23784,'491:83.23,43.11'}
G[23797]={23797,'141:53.57,56.91'}
G[23804]={23804,'491:40.29,60.26'}
G[23831]={23831,'491:31.7,42'}
G[23833]={23833,'491:24.24,32.46'}
G[23835]={23835,'141:68.26,51.81','Also circles the fountain'}
G[23843]={23843,'141:55.40,26.36 141:55.58,26.14'}
G[23859]={23859,'491:31.25,43.97'}
G[23870]={23870,'491:36.4,48.4 491:37.4,51.9 491:41.2,49.3'}
G[23872]={23872,'704[2]:47.63,60.09'}
G[23888]={23888,'491:28.94,44.19'}
G[23891]={23891,'491:30.27,28.65'}
G[23892]={23892,'141:72.11,47.05'}
G[23895]={23895,'491:28.97,41.91'}
G[23896]={23896,'141:69.24,51.89'}
G[23904]={23904,'HW Z762'}
G[23905]={23905,'141:69.61,51.77'}
G[23906]={23906,'491:44.47,57.59'}
G[23938]={23938,'491:79.15,31.22'}
G[23948]={23948,'481:75.26,33.43'}
G[23951]={23951,'141:65.08,47.13'}
G[23954]={23954,'523[3]:73.81,36.69'}
G[23961]={23961,'523[1]:68.49,67.11'}
G[23973]={23973,'4:52.5,41.2 462:47.25,46.48'}
G[23975]={23975,'491:59.80,61.48'}
G[23976]={23976,'491:29.11,41.78'}
G[23978]={23978,'491:31.61,41.50'}
G[24018]={24018,'491:38.79,13.07 H:100034090,100034091'}
G[24027]={24027,'491:71.12,39.08'}
G[24032]={24032,'491:49.56,11.59'}
G[24037]={24037,'491:84.66,36.45'}
G[24038]={24038,'491:28.86,43.97'}
G[24056]={24056,'491:60.27,18.69'}
G[24060]={24060,'Near491'}
G[24061]={24061,'491:60.06,16.10'}
G[24106]={24106,'491:55.96,55.79'}
G[24111]={24111,'523[1]:67.60,70.96 491:57.34,46.99>523'} -- 491:59.56,48.87
G[24117]={24117,'491:61.49,22.85'}
G[24122]={24122,'491:59.18,54.57'}
G[24123]={24123,'491:49.31,11.98'}
G[24125]={24125,'491:53,66.1'}
G[24126]={24126,'491:78.54,28.98'}
G[24127]={24127,'491:48.38,11.03'}
G[24129]={24129,'491:48.04,10.74'}
G[24130]={24130,'Near491'}
G[24131]={24131,'491:62.66,16.80'}
G[24135]={24135,'491:48.16,10.67'}
G[24137]={24137,'523:67.7,66.4 523:67.9,66.3 523:67.9,66.5 523:67.9,67.3 523:68.1,68.2 523:68.2,69.6 523:68.3,68.3 523:68.4,68.7 523:68.4,68.9 523:68.4,69.6 523:68.5,67.4 523:68.5,67.7 523:68.5,68.2 523:68.5,68.9 523:68.6,68.8 523:68.6,69.5'}
G[24139]={24139,'491:62.59,16.82'}
G[24145]={24145,'491:56.64,52.38'}
G[24150]={24150,'491:56.90,53.77'}
G[24151]={24151,'491:55.70,57.37'}
G[24152]={24152,'491:26.43,24.50'}
G[24155]={24155,'491:52.01,67.38'}
G[24157]={24157,'491:53.07,66.93'}
G[24176]={24176,'491:60.17,15.62'}
G[24186]={24186,'491:31.16,24.51'}
G[24189]={24189,'491:59.34,55.42'}
G[24191]={24191,'491:59.75,62.43'}
G[24209]={24209,'491:31.28,24.35'}
G[24218]={24218,'491:25.96,24.43'}
G[24227]={24227,'491:30.05,28.64 491:30.13,28.79 491:30.27,28.77'} -- pacing back and forth
G[24234]={24234,'491:48.43,10.44'}
G[24251]={24251,'491:53.58,66.36'}
G[24252]={24252,'491:53.68,65.21'}
G[24256]={24256,'491:48.93,11.98'}
G[24261]={24261,'491:29.68,5.67'}
G[24273]={24273,'491:30.05,28.59'}
G[24282]={24282,'491:61.83,17.19'}
G[24283]={24283,'491:30.77,41.61'}
G[24328]={24328,'491:62.27,17.22'}
G[24359]={24359,'491:26.14,24.58','Circling the fire'}
G[24362]={24362,'491:49.22,12.25'}
G[24369]={24369,'481:75.13,36.68'}
G[24370]={24370,'481:75.49,37.22'}
G[24376]={24376,'491:62.58,16.53'}
G[24390]={24390,'491:48.09,10.48'}
G[24393]={24393,'481:61.75,15.56'}
G[24399]={24399,'491:30.81,28.56'}
G[24458]={24458,'491:65.87,36.78'}
G[24468]={24468,'HB 27:53.54,38.57'}
G[24473]={24473,'491:30.41,26.18'}
G[24494]={24494,'491:30.64,42.78'}
G[24495]={24495,'HB 4:40.32,17.88'}
G[24497]={24497,'HB 4:42.61,17.86'}
G[24498]={24498,'HB 4:40.6,18.2'}
G[24499]={24499,'HB 4:4.19,17.2'}
G[24510]={24510,'HB 4:42.68,17.73'}
G[24519]={24519,'27:53.30,51.47 30:42.62,64.39 464:49.16,51.34'}
G[24525]={24525,'491:35.56,80.62'}
G[24537]={24537,'491:35.60,80.24'}
G[24539]={24539,'491:35.10,80.94'}
G[24541]={24541,'491:36.33,80.48'}
G[24544]={24544,'491:19.78,22.21'}
G[24548]={24548,'491:67.35,60.32'}
G[24634]={24634,'491:64.43,46.95'}
G[24643]={24643,'491:23.08,62.66'}
G[24657]={24657,'HB 4:41.23,18.53'}
G[24702]={24702,'486:77.07,37.82'}
G[24703]={24703,'486:75.90,37.24'}
G[24706]={24706,'486:75.9,37.2'}
G[24709]={24709,'486:75.9,37.3'}
G[24710]={24710,'HB 27:55.13,38.08'}
G[24711]={24711,'HB 4:41.58,18.46'}
G[24717]={24717,'491:74.95,65.41'}
G[24727]={24727,'481:31.33,27.87'}
G[24729]={24729,'301:81.83,28.00'} --301:81.40,27.78 301:81.64,28.23 301:81.99,28.74
G[24730]={24730,'486:75.6,35.8'}
G[24733]={24733,'486:76.8,37.9'}
G[24739]={24739,'43:17.9,49.4 43:17.9,49.5'}
G[24741]={24741,'491:35.34,79.47 491:35.49,79.39','Upstairs'}
G[24750]={24750,'491:75.27,64.97'}
G[24755]={24755,'491:25.02,56.96'}
G[24784]={24784,'491:37.75,79.58'}
G[24795]={24795,'486:45.35,34.50'}
G[24807]={24807,'491:75.05,65.51'}
G[24810]={24810,'491:24.60,58.86'}
G[24811]={24811,'491:78.81,48.87'}
G[24813]={55007,'798[2]:42.61,87.19'}
G[24822]={24822,'798:0,0'}
G[24848]={24848,'798:0,0'}
G[24851]={24851,'463:74.76,67.15'}
G[24866]={24866,'477:55.9,73.7'}
G[24881]={24881,'477:52.8,36'}
G[24885]={24885,'478:55.81,53.74'}
G[24886]={24886,'478:49.9,46.7'}
G[24910]={24910,'491:35.9,67.3 491:37.2,74.8 491:37.8,75 491:38,77.1 491:38.3,78.3 491:38.4,69.2 491:38.4,69.8 491:38.5,70.4 491:38.5,78.9 491:38.6,71 491:38.7,79.5 491:38.9,72.1 491:39.7,74.4 491:39.7,74.5 491:40.2,81.1 491:40.8,81.6 491:41.1,76.2 491:42,82.4 491:43.1,77.7'}  -- on a boat that sails around a bunch
G[24932]={24932,'481:49.10,42.50'}
G[24937]={24937,'465:58.17,17.59'}
G[24965]={24965,'499:47.2,30.7'}
G[24967]={24967,'499:47.4,30.6'}
G[24975]={24975,'499:51.4,32.6 499:51.5,32.6'}
G[25032]={25032,'499:47.3,30.7'}
G[25034]={25034,'499:47.3,35.1'}
G[25046]={25046,'499:50.6,40.8'}
G[25057]={25057,'499:47.6,35.2'}
G[25061]={25061,'499:47.6,35.2'}
G[25069]={25069,'499:49.4,40.3 499:49.5,40.4'}
G[25088]={25088,'499:53.8,34.2'}
G[25108]={25108,'499:50.5,39.1'}
G[25112]={25112,'499:48.4,36.7 499:48.4,37.7 499:48.7,36.8 499:48.7,37.5'}
G[25133]={25133,'499:47.5,35.3 499:47.6,35.5'}
G[25140]={25140,'481:62.74,35.97'}
G[25163]={25163,'499:51.2,33.3'}
G[25169]={25169,'499:50.2,28.2'}
G[25197]={25197,'486:43.50,13.96'}
G[25199]={25199,'486:42.84,13.65'}
G[25205]={25205,'486:42.00,12.78'}
G[25206]={25206,'486:43.03,13.81'}
G[25208]={25208,'486:37.75,23.02'}
G[25211]={25211,'486:42.03,13.15'}
G[25233]={25233,'491:32.28,46.79'}
G[25235]={25235,'486:57.32,66.64 486:57.40,66.52 486:57.17,66.24'}
G[25237]={25237,'486:41.35,53.59'}
G[25245]={25245,'486:58.29,68.04'}
G[25247]={25247,'486:41.74,54.72'}
G[25249]={25249,'486:58.41,67.79'}
G[25250]={25250,'486:56.67,72.64'}
G[25251]={25251,'486:58.73,68.35'}
G[25256]={25256,'486:41.37,53.70'}
G[25257]={18229,'488:40.7,18'}
G[25262]={25262,'486:45.26,33.36'}
G[25272]={25272,'486:41.22,53.35'}
G[25273]={25273,'486:41.62,53.98 486:43.01,55.64'}	-- different dudes standing about
G[25279]={25279,'486:43.19,54.97'}
G[25280]={25280,'486:42.13,56.17'}
G[25285]={25285,'486:56.60,72.47'}
G[25288]={25288,'486:40.36,51.40','On roof'}
G[25289]={25289,'486:42.34,55.99','On roof'}
G[25291]={25291,'486:44.98,33.39'}
G[25292]={25292,'486:54.30,36.10'}
G[25298]={25298,'486:57.83,69.20'}
G[25299]={25299,'486:57.79,69.19'}
G[25301]={25301,'486:56.71,72.62'}
G[25302]={25302,'486:58.53,68.09'}
G[25307]={25307,'486:57.85,67.59'}
G[25314]={25314,'486:32.94,34.41'}
G[25324]={25324,'HM 43:15.8,21'}
G[25326]={25326,'486:49.61,10.59'}
G[25327]={25327,'486:43.33,55.36'}
G[25328]={25328,'486:40.07,52.06'}
G[25329]={25329,'486:32.25,54.08'}
G[25335]={25335,'486:48.32,19.76'}
G[25336]={25336,'486:48.45,19.74'}
G[25339]={25339,'486:50.28,9.73'}
G[25356]={25356,'486:46.37,37.30'}
G[25374]={25374,'486:49.55,9.98'}
G[25376]={25376,'486:46.57,9.35'}
G[25379]={25379,'486:43.72,54.43'}
G[25380]={25380,'486:52.2,52.8'}
G[25381]={25381,'486:52.06,52.49'}
G[25385]={25385,'486:56.05,55.42'}
G[25394]={25394,'486:43.20,55.05'}
G[25395]={25395,'486:56.68,71.45','In bottom of keep'}
G[25425]={25425,'486:56.2,9.1'}
G[25435]={25435,'486:47.13,75.48'}
G[25437]={25437,'486:38.08,52.49'}
G[25438]={25438,'486:37.92,52.59'}
G[25440]={25440,'486:53.10,52.34','Riding in general area'}
G[25450]={25450,'486:43.61,80.53'}
G[25462]={25462,'502:51.3,35.1'}
G[25475]={25475,'486:32.08,54.25'}
G[25476]={25476,'486:32.34,54.27'}
G[25477]={25477,'486:57.58,18.70 486:58.18,18.34'}
G[25480]={25480,'486:46.34,32.84'}
G[25503]={25503,'486:31.7,54.4'}
G[25504]={25504,'486:31.88,52.32','Upstairs'}
G[25516]={25516,'486:87.6,20.1'}
G[25580]={25580,'478:38.7,12.8'}
G[25589]={25589,'486:54.5,11.6 486:55.5,11.4 486:55.5,12 486:55.5,12.6'}
G[25590]={25590,'486:56.98,18.70'}
G[25602]={25602,'486:77.31,36.88'}
G[25604]={25604,'486:74.67,23.66'}
G[25605]={25605,'486:57.50,69.08'}
G[25607]={25607,'486:37.91,52.33'}
G[25636]={25636,'486:44.10,77.89'}
G[25658]={25658,'486:69.8,12.7'}
G[25697]={25697,'728[1]:18.6,50.6 467:48.94,35.80>728'}
G[25702]={25702,'486:57.5,18.7'}
G[25705]={25705,'486:73.42,18.79'}
G[25714]={25714,'486:69.89,14.74'}
G[25729]={25729,'486:34.59,46.43'}
G[25736]={25736,'486:48.96,10.27'}
G[25737]={25737,'486:58.84,68.72'}
G[25747]={25747,'486:57.44,18.74'}
G[25780]={25780,'486:57.06,20.11'}
G[25785]={25785,'486:46.37,32.40'}
G[25807]={25807,'486:61.67,35.78'}
G[25809]={25809,'486:57.05,44.32'}
G[25810]={25810,'486:57.32,44.08'}
G[25811]={25811,'486:56.80,44.04'}
G[25812]={25812,'486:57.19,44.20 486:57.16,43.59 486:56.90,44.13','The bear that circles'}
G[25816]={25816,'486:56.36,69.58'}
G[25825]={25825,'486:55.00,68.93'}
G[25826]={25826,'486:58.55,67.31'}
G[25838]={25838,'486:57.79,55.10'}
G[25849]={25849,'486:77.49,36.97'}
G[25862]={25862,'486:59.43,30.44'}
G[25883]={25883,'HM 43:86.94,41.86'}
G[25884]={25884,'HM 43:51.35,66.15'}
G[25887]={25887,'HM 16:44.30,46.03'}
G[25888]={25888,'HM 464:44.48,52.50'}
G[25889]={25889,'HM 475:41.57,65.90'}
G[25890]={25890,'HM 19:55.53,14.88'}
G[25891]={25891,'HM 476:55.82,67.88'}
G[25892]={25892,'HM 29:68.34,60.63'}
G[25893]={25893,'HM 42:48.73,22.65'}
G[25894]={25894,'HM 101:66.12,17.10'}
G[25895]={25895,'HM 27:53.80,45.24'}
G[25896]={25896,'HM 34:73.69,54.62'}
G[25897]={25897,'HM 141:61.82,40.46'}
G[25898]={25898,'HM 30:43.47,62.63'}
G[25899]={25899,'HM 121:46.82,43.70'}
G[25900]={25900,'HM 465:62.17,58.29'}
G[25902]={25902,'HM 35:32.55,40.95'}
G[25903]={25903,'HM 477:49.61,69.46'}
G[25904]={25904,'HM 36:24.90,53.39'}
G[25905]={25905,'HM 473:39.63,54.64'}
G[25906]={25906,'HM 41:54.88,52.77'}
G[25907]={25907,'HM 478:54.06,55.52'}
G[25908]={25908,'HM 26:14.34,50.08'}
G[25909]={25909,'HM 22:43.47,82.33'}
G[25910]={25910,'HM 39:44.76,62.06'}
G[25911]={25911,'HM 40:13.46,47.07'}
G[25912]={25912,'HM 467:68.80,51.95'}
G[25913]={25913,'HM 479:31.21,62.66'}
G[25914]={25914,'HM 261:60.30,33.51'}
G[25915]={25915,'HM 673:51.96,67.65'}
G[25916]={25916,'HM 161:52.64,30.26'}
G[25917]={25917,'HM 281:61.24,47.25'}
G[25918]={25918,'HM 479:32.11,68.32'}
G[25919]={25919,'HM 261:50.85,41.31'}
G[25920]={25920,'HM 673:50.40,70.38'}
G[25921]={25921,'HM 161:49.82,27.87'}
G[25922]={25922,'HM 281:58.15,47.51'}
G[25923]={25923,'HM 16:69.36,42.57'}
G[25925]={25925,'HM 17:23.09,37.44'}
G[25926]={25926,'HM 475:49.91,58.66'}
G[25927]={25927,'HM 29:51.11,29.21'}
G[25928]={25928,'HM 101:26.15,76.90'}
G[25929]={25929,'HM 4:52.18,47.32'}
G[25930]={25930,'HM 141:33.43,30.91'}
G[25931]={25931,'HM 462:46.40,50.60'}
G[25932]={25932,'HM 121:72.38,47.79'}
G[25933]={25933,'HM 463:46.90,26.34'}
G[25934]={25934,'HM 465:57.12,42.05'}
G[25935]={25935,'HM 24:54.66,50.09'}
G[25936]={25936,'HM 9:51.82,59.25'}
G[25937]={25937,'HM 477:50.91,34.14'}
G[25938]={25938,'HM 473:33.40,30.54'}
G[25939]={25939,'HM 21:49.63,38.22'}
G[25940]={25940,'HM 81:52.92,62.46'}
G[25941]={25941,'HM 38:76.33,13.77'}
G[25942]={25942,'HM 478:52.01,42.91'}
G[25943]={25943,'HM 11:49.96,54.63'}
G[25944]={25944,'HM 26:76.64,74.96'}
G[25946]={25946,'HM 20:57.22,51.76'}
G[25947]={25947,'HM 467:35.44,51.61'}
G[25962]={25962,'HM 16:44.23,45.20 17:19.46,55.80 19:55.54,15.16 22:43.17,82.55 26:14.04,50.08 27:53.76,45.58 29:68.03,60.12 30:43.69,62.23 34:73.64,53.81 35:32.07,41.51 36:25.14,54.20 37:51.97,63.08 38:69.87,16.25 39:44.65,61.21 40:13.59,46.70 41:54.54,52.68 42:48.65,22.88 43:86.48,41.85 81:49.41,50.97 101:66.35,17.00 121:46.96,43.78 141:61.60,41.04 161:52.45,30.54 201:59.55,63.10 261:59.95,33.59 281:61.14,47.65 464:44.45,51.78 465:62.06,57.92 467:69.04,51.92 473:39.59,54.99 475:41.50,65.30 476:56.16,67.08 477:49.92,69.04 478:54.53,55.38 479:31.53,63.02 486:55.11,19.71 488:75.59,43.38 490:33.93,60.18 491:57.97,16.16 493:47.48,66.36 495:41.62,86.83 496:40.51,61.55 510:78.32,75.46 607:48.42,72.45 673:52.10,67.26 700:47.35,28.53 720:53.75,32.05'}
G[25975]={25975,'HM 301:50.05,72.28 341:65.40,25.04 381:63.18,47.50 471:40.88,25.55'}
G[25978]={25978,'486:41.70,54.59'}
G[25982]={25982,'486:77.25,38.47'}
G[25983]={25983,'486:77.6,37'}
G[25984]={25984,'486:64.03,35.76'}
G[25994]={25994,'HM 4:52.41,47.33 9:51.69,59.54 11:49.86,54.97 16:69.93,42.21 17:23.39,37.28 19:45.69,12.99 20:57.44,51.57 21:49.95,38.18 22:29.45,56.90 24:54.81,49.79 26:76.80,75.33 29:50.61,29.33 37:40.53,51.49 38:76.61,13.34 43:51.68,66.21 81:52.76,62.52 101:26.32,76.64 121:72.21,47.89 141:33.65,30.80 161:49.89,27.73 181:60.72,53.31 201:56.63,66.36 261:51.06,41.09 281:58.20,47.71 462:46.60,50.72 463:46.82,26.67 465:56.92,42.15 467:35.42,51.32 473:33.29,30.25 475:49.55,59.04 477:50.76,33.98 478:52.17,42.77 479:32.53,68.44 486:51.15,11.26 488:38.12,48.32 490:19.47,61.28 491:48.62,12.90 493:47.17,61.26 495:40.37,85.23 496:43.56,71.75 510:79.67,53.45 607:40.75,67.60 673:50.19,70.74 700:52.97,46.10 720:53.23,34.62'}
G[26083]={26083,'486:58.21,62.81'}
G[26084]={26084,'486:58.19,62.99'}
G[26085]={26085,'486:58.28,62.77'}
G[26104]={26104,'486:77,37.6'}
G[26110]={26110,'486:33.49,34.38'}
G[26113]={26113,'321[1]:46.60,37.27 362:20.99,26.46 382:68.88,8.45 480:69.50,42.43'}
G[26117]={26117,'486:33.32,34.53'}
G[26125]={26125,'36:59.02,55.01'}
G[26155]={26155,'486:56.7,69.5'}
G[26156]={26156,'488:12.8,51.6'}
G[26158]={26158,'486:78.3,38'}
G[26169]={26169,'486:63.80,46.13'}
G[26170]={26170,'486:84.80,41.68'}
G[26180]={26180,'488:14.2,49.9'}
G[26181]={26181,'488:13.3,48 488:13.3,49.7 488:13.4,49.1 488:13.6,47.9 488:13.8,49.6 488:13.9,48.5'}
G[26186]={26186,'486:82.17,46.40'}
G[26187]={26187,'486:82,46.4'}
G[26194]={26194,'488:48.00,74.87'}
G[26206]={26206,'Near486'}
G[26212]={26212,'490:59.42,25.99'}
G[26213]={26213,'486:63.95,45.71'}
G[26218]={26218,'486:67.21,54.85'}
G[26221]={26221,'HM 301:49.32,72.27 341:65.09,27.72 381:62.11,49.14 471:43.29,26.22 481:60.67,30.63'} -- This NPC is the same for both factions!!!  So Horde is 526221.
G[26226]={26226,'490:59.80,27.57'}
G[26228]={26228,'488:48.26,74.35'}
G[26245]={26245,'488:47.70,76.63'}
G[26260]={26260,'490:65.77,17.80'}
G[26335]={26335,'490:63.68,23.16'}
G[26344]={26344,'488:36.79,65.05'}
G[26361]={26361,'490:59.76,27.44'}
G[26371]={26371,'490:59.08,26.48 490:59.04,26.42 490:59.12,26.17'}
G[26377]={26377,'490:59.09,26.61'}
G[26379]={26379,'488:36.3,45.6 488:38.1,46.3'}
G[26401]={26401,'HM 16:44.22,45.99 17:18.97,56.33 19:55.55,14.76 22:43.44,82.24 26:15.23,50.17 27:53.80,45.14 29:68.32,60.77 30:43.49,62.51 34:73.77,54.50 35:32.58,41.10 36:25.68,53.37 37:52.12,63.57 38:70.13,15.72 39:44.80,62.18 40:13.50,46.98 41:54.83,52.77 42:48.69,22.69 43:86.89,41.84 81:49.35,51.33 101:66.19,17.10 121:46.78,43.67 141:61.87,40.50 161:52.67,30.22 201:59.77,63.25 261:60.38,33.51 281:61.49,47.51 464:44.41,52.47 465:62.45,58.44 467:68.73,51.94 473:39.64,54.56 475:41.53,65.87 476:55.82,67.75 477:49.57,69.41 478:54.01,55.57 479:31.16,62.64 486:55.14,19.91 488:75.24,43.77 490:33.94,60.52 491:57.84,16.17 493:48.37,65.53 495:41.42,86.74 496:40.37,61.39 510:78.07,74.90 607:48.34,72.29 673:52.03,67.71 700:47.32,28.95 720:53.60,31.92 811:79.67,37.44'} -- the one in zone 26 is behind a tree
G[26415]={26415,'488:36.7,46.6'}
G[26420]={26420,'490:79.76,33.61'}
G[26423]={26423,'490:16.43,47.77'}
G[26424]={26424,'490:16.19,47.61'}
G[26440]={26440,'488:48.1,74.9'}
G[26441]={26441,'488:48,74.8'}
G[26443]={26443,'488:57.91,54.17'}
G[26459]={26459,'488:29.04,55.42'}
G[26471]={26471,'488:38,46.3'}
G[26473]={26473,'488:58.98,17.81'}
G[26484]={26484,'490:69.09,40.10'}
G[26500]={26500,'490:13.24,60.87'}
G[26501]={26501,'488:24.20,60.08'}
G[26504]={26504,'488:37.1,48.6'}
G[26505]={26505,'488:36.1,48.8'}
G[26511]={26511,'488:47.71,80.03'}
G[26514]={26514,'490:67.50,15.28'}
G[26519]={26519,'490:15.7,46.8'}
G[26520]={26520,'HM 4:52.15,47.25 9:51.77,59.21 11:49.96,54.54 16:69.41,42.47 17:23.19,37.42 19:46.30,13.73 20:57.29,51.75 21:49.59,38.31 22:29.23,57.34 24:54.70,50.15 26:76.66,75.06 29:51.21,29.26 37:40.51,50.96 38:76.30,13.59 43:51.35,66.22 81:52.95,62.41 101:26.13,77.01 121:72.41,47.76 141:33.49,30.92 161:49.80,27.93 181:60.80,53.56 201:56.25,66.33 261:50.82,41.41 281:58.16,47.43 462:46.40,50.51 463:46.89,26.48 465:57.16,42.00 467:35.47,51.69 473:33.61,30.72 475:49.92,58.74 477:50.97,34.13 478:51.97,42.96 479:32.16,68.33 486:51.16,11.47 488:38.31,48.45 490:19.26,61.17 491:48.64,13.08 493:47.27,61.66 495:40.27,85.41 496:43.42,71.81 510:80.08,53.21 607:40.85,67.73 673:50.34,70.33 700:52.96,45.93 720:53.10,34.54 811:77.88,34.03'}
G[26527]={10667,'521:86.4,61.6 521:86.5,61.4 521:86.5,61.5'}
G[26533]={26533,'521[2]:33.55,45.78'}
G[26543]={26500,'490:17.41,36.36'}
G[26560]={26560,'499:48.36,25.08'}
G[26564]={26564,'488:36.6,47.1'}
G[26574]={26574,'488:37.2,45.8'}
G[26581]={26581,'488:35.9,46.9 488:36.1,46 488:36.2,47.6 488:36.5,46.4 488:36.7,47.6 488:37.1,46.5'}
G[26584]={26584,'490:65.2,47.8'}
G[26588]={26588,'490:49.20,34.10'}
G[26593]={26593,'488:35.21,30.04','Inside cave Maw of Neltharion'}
G[26595]={26595,'488:49.14,75.66'}
G[26602]={26602,'486:56.57,20.06'}
G[26604]={26604,'490:16.67,48.29'}
G[26618]={26618,'488:35.8,48.3'}
G[26632]={26632,'534[1]:60.26,13.17'}
G[26647]={26647,'488:54.69,23.88 488:54.50,23.62 488:54.98,23.85'}
G[26649]={26649,'488:37.3,46.8'}
G[26652]={26652,'488:35.8,45.8 488:35.8,46.9 488:36.4,45.3 488:36.5,45.3 488:36.6,45.5'}
G[26653]={26653,'488:26.2,50.7'}
G[26659]={26659,'488:59.40,18.18'}
G[26660]={26660,'488:55.02,23.43'}
G[26661]={26661,'488:54.70,23.26'}
G[26666]={26666,'490:65.1,47.7'}
G[26673]={26673,'488:29.00,55.45'}
G[26701]={26500,'490:45.00,28.36'}
G[26723]={26206,'520[1]:36.26,69.04'}
G[26733]={26733,'488:22.6,41.7'}
G[26787]={26500,'490:71.74,26.20'}
G[26796]={26796,'520[1]:18.94,52.79'}
G[26814]={26814,'490:69.48,17.50'}
G[26821]={26821,'490:26.41,35.71'}
G[26837]={26837,'488:28.73,57.10'}
G[26851]={26851,'488:60.32,51.54'}
G[26854]={26854,'488:36.5,47.8'}
G[26859]={26859,'488:47.2,33'}
G[26860]={26860,'490:20.7,64.2'}
G[26868]={26868,'490:22.6,66.1'}
G[26873]={26873,'488:40.26,66.85'}
G[26875]={26875,'490:31.84,60.17'}
G[26876]={26876,'490:59.89,26.68'}
G[26877]={26877,'488:39.52,25.91'}
G[26878]={26878,'488:77.01,49.79'}
G[26879]={26879,'486:58.96,68.29'}
G[26880]={26880,'490:31.31,59.11'}
G[26881]={26881,'488:29.18,55.33'}
G[26883]={26883,'490:77.09,48.65'}
G[26884]={26884,'490:73.76,34.02'}
G[26885]={26885,'490:76.97,48.44'}
G[26886]={26886,'490:73.91,34.13'}
G[26896]={26896,'488:48.46,24.13'}
G[26905]={26905,'491:58.2,62.1'}
G[26914]={26914,'491:58.6,62.8'}
G[26917]={26917,'488:59.84,54.66'}
G[26924]={26924,'490:69.42,19.48'} -- need to have "On the Other Side" buff to see him
G[26932]={26932,'490:55.13,23.38'}
G[26935]={26935,'490:57.52,41.26'}
G[26944]={26944,'490:65,47.8'}
G[26949]={26949,'488:59.52,53.30'}
G[26953]={26953,'491:78.61,29.49'}
G[26964]={26964,'491:79.4,30.7'}
G[26969]={26969,'486:41.6,53.4 486:41.6,53.5'}
G[26972]={26972,'486:41.97,54.11'}
G[26973]={26973,'488:29.18,55.64'}
G[26978]={26978,'488:64.42,26.94 488:64.47,26.34'}
G[26979]={26979,'488:46.7,33.4 488:46.7,33.5'}
G[26983]={26983,'488:60.02,55.20'}
G[26989]={26989,'486:57.92,71.54'}
G[27001]={27001,'486:57.5,72.3'}
G[27028]={27028,'488:76,62'}
G[27037]={27037,'490:22,65.1'}
G[27046]={27046,'486:33.13,34.44'}
G[27060]={27060,'488:28.9,56.1'}
G[27102]={27102,'490:20.9,64.1 490:23.3,64.9'}
G[27120]={27120,'490:26.4,65.7 490:26.5,65.8'}
G[27136]={27136,'488:78.49,48.34 488:78.64,48.09'}
G[27155]={27155,'488:78.64,48.18'}
G[27156]={27156,'488:77.80,50.33'}
G[27157]={27157,'488:89.67,46.37'}
G[27158]={27158,'488:78.91,45.33'}
G[27159]={27159,'488:77.84,50.29'}
G[27172]={27172,'488:77.7,62.7'}
G[27215]={27215,'HB 27:54.67,38.10'}
G[27216]={27216,'HB 4:4.53,17.6'}
G[27221]={27221,'490:65.2,47.4 490:65.2,47.5'}
G[27227]={27227,'490:65.1,47.3'}
G[27243]={27243,'488:76.8,63.2'}
G[27248]={27248,'488:77,62.9'}
G[27255]={27255,'488:64.10,71.99 488:62.98,72.15 488:62.52,73.64 488:62.59,74.92 488:63.63,75.99 488:64.77,72.52 488:65.01,73.52 488:64.92,75.39 488:64.68,76.36'}
G[27262]={27262,'490:22.5,62.9'}
G[27266]={27266,'490:22.2,64.7'}
G[27267]={27267,'488:76,63.2'}
G[27277]={27277,'490:32.10,59.97'}
G[27295]={27295,'490:31.16,59.47'}
G[27314]={27314,'488:79.14,47.17'}
G[27316]={27316,'488:76.75,47.52 488:76.79,47.35'}
G[27317]={27317,'488:77.10,50.11'}
G[27318]={27318,'488:79.07,53.20'}
G[27319]={27319,'488:85.86,51.02'}
G[27320]={27320,'488:76.4,62.6 488:76.5,62.6 488:77.3,62.2 488:77.6,61.9'}
G[27337]={27337,'488:76.8,63.1'}
G[27344]={27344,'491:79.04,29.71'}
G[27347]={27347,'488:87.17,57.48'}
G[27348]={27348,'488:87.24,57.39'}
G[27350]={27350,'488:73.6,73.4 488:73.6,73.5'}
G[27371]={27371,'490:39.54,43.56'}
G[27388]={27388,'490:21,64.1'}
G[27391]={27391,'490:32.42,59.95'}
G[27412]={27412,'488:81.52,42.20'}
G[27416]={27416,'490:39.64,43.37'}
G[27422]={27422,'490:34.4,32.7 490:34.5,32.6'}
G[27423]={27423,'490:34.5,32.6'}
G[27451]={27451,'490:34.4,33 490:34.5,33'}
G[27464]={27464,'490:33.9,32.8'}
G[27468]={27468,'490:39.36,43.87'}
G[27469]={27469,'490:34.77,55.61'}
G[27478]={27478,'HB 341:18.82,53.09'}
G[27483]={27483,'534[1]:65.67,23.77'}
G[27484]={27484,'490:40.48,42.65'}
G[27486]={27486,'490:26.47,35.77'}
G[27489]={27489,'HB 321[1]:50.37,73.50'}
G[27495]={27495,'490:23.02,80.16'}
G[27497]={27497,'490:21.93,29.93'}
G[27499]={27499,'490:26.46,31.76'}
G[27506]={27506,'488:52.21,50.04'}
G[27520]={27520,'490:22.18,81.23'}
G[27532]={27532,'490:10.1,77.2'}
G[27545]={27545,'490:25.61,33.31'}
G[27546]={27546,'490:35.39,66.89 H:100036940'}
G[27562]={27562,'490:22.12,81.25'}
G[27563]={27563,'490:10.1,77.2'}
G[27565]={27565,'490:11.2,76.6'}
G[27575]={27575,'488:59.24,54.32'}
G[27581]={27581,'490:44.04,47.95'}
G[27582]={27582,'490:59.18,26.18'}
G[27602]={27602,'490:21.99,80.73'}
G[27606]={27606,'490:11.3,76.7'}
G[27646]={27646,'490:64.80,43.41'}
G[27658]={27658,'528:48.2,80.7 528:48.4,80.1 528:48.9,80.4 528:49,80.9 528:49.4,79 528:49.4,79.7 528:49.4,80.6 528:49.6,80.7 528:49.8,79 528:49.9,78.4 528:49.9,79.8 528:50,79.2 528:50,80.3 528:50,81.5 528:50.1,80.8 528:50.1,81.8 528:50.5,80 528:50.5,80.6 528:50.6,80.1 528:50.9,79.2 528:51.5,79.2'}
G[27708]={27708,'490:14.8,86.4 490:14.8,86.5'}
G[27719]={27719,'490:22.4,63.9'}
G[27720]={27720,'490:22.3,64.1'}
G[27759]={27759,'490:14.8,86.6 490:14.9,86.4'}
G[27763]={27763,'488:43,50.9'}
G[27765]={27765,'488:60.07,54.20'}
G[27783]={27783,'490:29.91,59.78'}
G[27784]={27784,'488:76.81,47.52 488:76.67,47.37 488:76.80,47.07 488:76.99,47.27 488:76.85,47.33'}
G[27785]={27785,'488:59.61,54.46'}
G[27801]={27801,'493:64.56,48.60'}
G[27803]={27803,'488:60.00,55.08'}
G[27804]={27804,'488:58.1,55.4 488:58.3,55.8 488:58.6,56.3 488:58.7,56.5'}
G[27828]={27828,'488:84.17,54.68'}
G[27844]={27844,'488:64.74,27.93'}
G[27856]={10667,'488:60.00,54.51'}
G[27857]={27857,'488:81.17,50.65'}
G[27872]={27872,'488:37.80,23.41'}
G[27915]={10667,'521:47.7,39.3 521:47.7,39.9 521:47.8,39.3 521:47.9,40.5 521:47.7,39.9'}
G[27922]={27922,'491:67.45,60.58'}
G[27986]={18180,'493:27.10,58.65'}
G[27987]={27987,'493:39.68,58.65'}
G[27990]={27990,'488:59.79,54.70'}
G[28012]={28012,'Near528'}
G[28016]={26423,'Near534'}
G[28027]={28027,'493:54.58,56.36'}
G[28030]={28030,'496:75.37,58.61'}
G[28031]={28031,'493:26.67,59.03'}
G[28032]={28032,'493:27.24,59.89'}
G[28033]={28033,'493:25.36,58.47'}
G[28034]={28034,'496:38,44 H:100038321'}
G[28035]={28035,'496:40,47 H:100038321'}
G[28036]={28036,'496:40,47 H:100038321'}
G[28037]={28037,'493:25.27,58.44'}
G[28039]={28039,'496:40.27,66.62'}
G[28042]={28042,'496:48.77,78.87'}
G[28043]={28043,'496:48.15,63.88'}
G[28044]={28044,'496:58.07,72.43'}
G[28045]={28045,'496:35.62,52.23'}
G[28046]={28046,'493:26.70,59.55'}
G[28056]={28056,'496:40.41,48.20'}
G[28059]={28059,'496:39.41,66.96'}
G[28062]={28062,'496:40.53,65.61'}
G[28070]={28070,'Near526'}
G[28082]={28082,'493:55.00,69.12'}
G[28092]={28092,'201:47.38,9.22'}
G[28095]={28095,'493:50.53,76.60'}
G[28097]={28097,'493:50.54,77.25'}
G[28099]={28099,'496:40.36,48.21'}
G[28106]={28106,'493:23.4,83.3 493:23.5,83.2'}
G[28107]={28107,'493:33.4,74.8 493:33.5,74.8'}
G[28114]={28114,'493:42.15,38.64'}
G[28120]={28120,'Near493'}
G[28122]={28122,'Near493'} -- about 493:74.50,51.16 when quest 12578 concludes
G[28125]={28125,'496:58.68,72.49'}
G[28126]={28126,'161:50.78,27.55'}
G[28138]={28138,'493:55.49,69.68'}
G[28160]={28160,'504[1]:68.58,42.07'}
G[28179]={28179,'492:87.4,75.9 492:87.5,75.8'}
G[28191]={28191,'493:25.58,66.53'}
G[28195]={28195,'486:78.53,51.53'}
G[28196]={28196,'488:48.51,74.39'}
G[28197]={28197,'491:24.66,57.78'}
G[28204]={28204,'496:41.33,65.13'}
G[28205]={28205,'496:35.03,52.11'}
G[28214]={28214,'Near493'}
G[28216]={28216,'Near493'}
G[28217]={28217,'493:55.70,64.98'}
G[28228]={28228,'488:83.98,26.10'}
G[28244]={3144,'496:40.8,66.7'}
G[28266]={28266,'493:25.4,58.4 493:25.4,58.5 493:25.5,58.4 493:25.5,58.5'}
G[28283]={28283,'496:58.06,72.04'}
G[28284]={28284,'496:58.25,72.05'}
G[28309]={28309,'496:40.18,68.93'}
G[28314]={28314,'491:71.46,39.21'}
G[28328]={28328,'493:27.07,59.89'}
G[28357]={28357,'502:47.6,28.9 502:47.7,29.5 502:48.2,28.4 502:48.9,27.4 502:48.9,27.5 502:49.5,28.1'}
G[28374]={28374,'493:42.12,28.90'}
G[28375]={28375,'486:37.84,23.19'}
G[28376]={28376,'493:42.34,28.70'}
G[28377]={28377,'502:52.28,33.97'}
G[28382]={28382,'486:67.27,54.85'}
G[28401]={28401,'496:63.71,70.40'}
G[28444]={28444,'502:48.85,29.70'}
G[28464]={28464,'493:65.08,60.31'}
G[28472]={28472,'502:47.48,26.55'}
G[28479]={28479,'496:59.50,58.05'}
G[28480]={28480,'496:59.39,56.42'}
G[28484]={28484,'496:59.16,56.20'}
G[28497]={28497,'493:26.87,58.94'}
G[28503]={28503,'496:27.08,46.15','In Voltarus above Reliquary of Pain'}
G[28510]={28510,'502:50.9,35.5 502:51,35.3 502:51.3,34 502:51.6,34.3 502:51.6,34.8'}
G[28518]={28518,'496:14.06,73.80'}
G[28519]={28519,'496:21,70.2 H:100038660,100038673'}
G[28527]={28527,'496:59.98,57.92'}
G[28532]={28532,'496:14.28,74.04'}
G[28561]={28561,'496:53.39,39.01'}
G[28568]={28568,'493:50.48,62.13'}
G[28574]={28574,'493:50.13,61.36'}
G[28589]={28589,'496:19.87,75.45'}
G[28615]={28615,'496:14.01,73.59'}
G[28618]={28618,'496:32.18,74.39'}
G[28621]={28621,'23:51.35,21.31'}
G[28623]={28623,'496:41.55,64.43'}
G[28624]={28624,'496:60.03,56.71'}
G[28647]={28647,'502:52.4,37.8 502:52.6,37.6 502:53.1,36.4 502:53.1,36.9 502:53.5,36.5 502:53.6,36.4'}
G[28653]={28653,'502:51.8,35.6 502:52.3,34.8 502:52.4,34.3 502:52.5,34.5 502:53.1,33.6 502:53.3,33.4'}
G[28658]={28658,'502:54,35'}
G[28667]={28667,'493:72.46,57.52'}
G[28668]={28216,'493:71.97,57.01'}
G[28674]={28674,'504[1]:72.19,45.77'}
G[28699]={28699,'504[1]:36.17,33.55'}
G[28701]={28701,'504[1]:40.67,35.34'}
G[28703]={28703,'504[1]:42.64,32.05'}
G[28705]={28705,'504[1]:40.61,64.85'}
G[28706]={28706,'504[1]:36.58,37.28'}
G[28718]={28718,'504[1]:36.4,28.4'}
G[28742]={28742,'504[1]:53.03,64.95'}
G[28746]={28746,'493:49.95,61.53'}
G[28771]={28771,'493:42.07,28.66'}
G[28787]={28787,'493:35.56,47.41'}
G[28907]={28377,'502:53.48,36.56'}
G[28910]={28910,'502:54.68,57.44'}
G[28911]={28911,'502:54.2,57.4'}
G[28912]={26581,'502:62.9,68 502:63.2,68.6'}
G[28913]={26170,'502:56.2,80.1'}
G[28914]={28914,'502:56.2,80'}
G[28919]={28919,'502:55.8,52.3 502:55.9,52.9'}
G[28923]={28923,'525[2]:19.16,58.53'}
G[29006]={29006,'493:53.3,56.6'}
G[29043]={29043,'493:55.71,69.47'}
G[29047]={29047,'502:54.4,34.2 502:54.4,34.5 502:54.5,34.5 502:54.7,33.4 502:54.8,34.1'}
G[29049]={29049,'504[1]:49.02,37.38'}
G[29053]={29053,'502:52.8,81.3 502:52.9,82.5 502:53,81.7'}
G[29077]={29077,'502:65.67,83.79'}
G[29110]={25462,'502:53.57,36.85'}
G[29120]={29120,'533[3]:0.00,0.00'}
G[29137]={29137,'496:32.03,74.42'}
G[29142]={29142,'301:61.30,64.67'}
G[29146]={29146,'493:55.53,68.70'}
G[29149]={29149,'493:54.2,53.9'}
G[29155]={29155,'486:41.58,53.60'}
G[29156]={29156,'504[1]:56.30,46.68'}
G[29157]={29157,'493:26.78,60.08'}
G[29158]={29158,'486:58.58,68.30'}
G[29159]={29159,'491:79.44,29.42'}
G[29160]={29160,'490:20.7,64.3'}
G[29161]={29161,'490:32.01,59.79'}
G[29162]={29162,'488:76.8,63.2'}
G[29169]={29169,'496:40.63,66.89'}
G[29173]={28444,'502:34.4,31 502:34.5,31 502:34.6,31.5 502:38.9,38.2 502:39.1,39.1 502:39.5,38'}
G[29211]={29211,'496:36.69,72.48'}
G[29306]={29306,'530[1]:46.95,28.90'}
G[29310]={29310,'522[1]:29.12,50.34'}
G[29343]={29343,'492:42.9,25'}
G[29344]={29344,'492:19.6,48.1'}
G[29375]={29375,'495:70,59 H:100041556'}
G[29380]={29380,'495:25,46 H:100042203'}
G[29396]={29396,'492:19.7,48.3'}
G[29405]={29405,'492:19.7,47.8'}
G[29428]={29428,'495:40.93,85.31'}
G[29430]={29430,'495:41.67,80.01'}
G[29431]={29431,'495:41.02,86.43'}
G[29432]={29432,'495:50.01,81.77'}	-- 495:50.48,81.65
G[29434]={29434,'495:41.51,74.89 495:42.31,73.97 495:43.48,75.24','In cave'}
G[29445]={29445,'495:33.42,57.96'}
G[29455]={29455,'496:17.64,57.54'}
G[29456]={29456,'492:19.9,47.6'}
G[29473]={29473,'495:41.14,86.14'}
G[29480]={29480,'23:83.88,50.43'}
G[29481]={29481,'495:42.81,68.90'}
G[29527]={29527,'504[1]:52.31,55.61','Upstairs in Curiosities & Moore'}
G[29532]={29532,'504[2]:35.46,57.55'}
G[29535]={29535,'504[2]:63.47,11.63'}
G[29560]={29344,'492:9.5,46.4 492:9.5,47.2'}
G[29579]={28070,'Near495'}
G[29592]={29592,'495:53.14,65.73'}
G[29593]={29593,'495:30.26,74.76'}
G[29611]={29611,'301:85.78,31.73'}
G[29631]={29631,'504[1]:70,39'}
G[29647]={29647,'496:19.73,56.39'}
G[29650]={29650,'495:29.61,74.07'}
G[29651]={29651,'495:37.31,49.66'}
G[29687]={29687,'496:32.15,75.74'}
G[29688]={29688,'496:25.3,63.9'}
G[29689]={29689,'496:25.28,63.96'}
G[29690]={29690,'496:32.18,75.63'}
G[29721]={29721,'495:40.74,84.55'}
G[29727]={29727,'495:29.18,74.90'}
G[29732]={29732,'495:29.83,75.72'}
G[29733]={29733,'496:32.02,75.61'}
G[29743]={29743,'495:29.40,73.77'}
G[29744]={29744,'495:28.83,74.07'}
G[29750]={29750,'495:29.50,74.33'}
G[29751]={29751,'495:25.24,68.47','In back of cave'}
G[29795]={26581,'492:59.9,34.9 492:60,33.6 492:60.1,33.2 492:60.2,36.1 492:60.3,32.4 492:60.4,36.6 492:60.6,31.8 492:60.7,37.2 492:61.2,38.4 492:61.3,31.1 492:61.4,38.8 492:61.6,31 492:61.6,39.3 492:62.1,40.3 492:62.4,30.4 492:62.4,40.9 492:62.5,30.4 492:62.5,30.5 492:62.6,41.4 492:62.7,41.5 492:63.4,43.2 492:63.5,29.5 492:63.5,43.4 492:63.8,44.4 492:64.1,29 492:64.1,45.2 492:64.3,45.7 492:64.5,28.7 492:64.5,46.2 492:64.7,46.8 492:65,28.3 492:65,47.7 492:65.4,48.7 492:65.5,48.9 492:65.6,27.7 492:65.8,49.5 492:66.3,27 492:66.4,50.8 492:66.7,26.6 492:66.7,51.4 492:67.2,52.3 492:67.4,26.3 492:67.4,52.5 492:67.5,52.4 492:67.9,26.3 492:68.1,52.8 492:68.5,26.4 492:68.6,52.8 492:69.2,26.8 492:69.3,52.4 492:69.4,32 492:69.4,32.6 492:69.4,33.8 492:69.5,27.3 492:69.5,31.2 492:69.5,31.7 492:69.5,32.9 492:69.5,34.3 492:69.5,34.7 492:69.5,51.9 492:69.6,27.6 492:69.6,29.4 492:69.6,29.7 492:69.6,36.1 492:69.6,36.7 492:69.7,38.3 492:69.7,38.9 492:69.7,40.1 492:69.7,51.1 492:69.8,41.3 492:69.8,42 492:69.8,42.6 492:69.8,50.1 492:69.9,44.3 492:69.9,45 492:69.9,46 492:69.9,47.2 492:69.9,48.3 492:69.9,48.5'}
G[29796]={29796,'495:50.88,65.59'}
G[29799]={26170,'492:56,38.9 492:56.1,39.8 492:56.3,38.3 492:56.3,40.7 492:56.5,41.3 492:56.7,41.9 492:56.9,38 492:57.2,43.1 492:57.4,38.8 492:57.4,43.6 492:57.5,38.4 492:57.5,39.1 492:57.5,44 492:57.6,39.6 492:57.9,44.6 492:58,40.7 492:58.4,41.7 492:58.4,45.5 492:58.5,41.9 492:58.6,45.8 492:58.9,42.9 492:59.4,44.1 492:59.4,47.3 492:59.5,44.3 492:59.8,45 492:59.9,48.4 492:60,45.5 492:60,48.7 492:60.4,46.5 492:60.4,49.6 492:60.5,49.9 492:60.6,47 492:61,51.2 492:61.1,48.1 492:61.2,51.7 492:61.3,48.6 492:61.4,52.5 492:61.5,49.1 492:61.6,53.1 492:61.7,49.7 492:62,54.1 492:62.3,50.9 492:62.4,55.4 492:62.4,55.9 492:62.4,56.5 492:62.5,51.3 492:62.6,51.5 492:62.9,56.5 492:63,52.5 492:63.4,53.9 492:63.4,56.3 492:63.6,54.4 492:63.6,54.5 492:63.8,55.7'}
G[29801]={29801,'495:31.42,38.08'}
G[29804]={29343,'492:44.1,24.7'}
G[29806]={29806,'495:37.7,46.4 495:37.7,46.5'}
G[29839]={29839,'495:49.75,71.80'}
G[29855]={29855,'495:40.78,51.20'}
G[29885]={29885,'495:44.39,68.93'}
G[29937]={29937,'495:37.29,49.73'}
G[29950]={29950,'495:30.64,36.33'}
G[29951]={29951,'495:44.49,28.18'}
G[29975]={29481,'495:47.47,69.09'}
G[29997]={29997,'495:48.33,72.12'}
G[30002]={30002,'492:44.6,20.4 492:44.6,20.5'}
G[30007]={18471,'496:48.4,56.3 496:48.5,56.3'}
G[30009]={22893,'496:48.4,56.4 496:48.5,56.4 496:48.5,56.5'}
G[30041]={30041,'495:48.44,72.15'}
G[30052]={30052,'495:39.66,59.90','Walking a path'}
G[30056]={30056,'492:41,23.9'}
G[30074]={30074,'492:43.3,25.3'}
G[30082]={30052,'495:38.26,61.70'}
G[30099]={30099,'495:75.38,63.56'}
G[30105]={30105,'495:65.42,60.16'}
G[30115]={30115,'504[1]:30.50,48.83'}
G[30116]={30116,'504[1]:31.27,48.11'}
G[30127]={30099,'495:63.21,63.24'}
G[30137]={30137,'504[2]:49.10,46.00'} -- wanders around the whole area 504[2]:55.01,52.22 504[2]:48.91,45.47 504[2]:43.15,38.38
G[30152]={30152,'495:31.28,38.17'}
G[30216]={30216,'492:42.9,25.8 492:43.1,25.3 492:43.4,24.4 492:43.5,24.4 492:43.5,24.5'}
G[30218]={30056,'492:43.2,21.1'}
G[30223]={30223,'492:87.1,75.9'}
G[30224]={30224,'492:86.1,75.8'}
G[30226]={30226,'492:86.8,76.6'}
G[30227]={30227,'492:87,79'}
G[30232]={30232,'492:32.4,42.9 492:32.5,42.9'}
G[30247]={30247,'495:36.44,49.09'}
G[30252]={30252,'495:64.84,59.07'}
G[30271]={30271,'510:72.17,80.96'}
G[30294]={30294,'495:63.51,59.75'}
G[30295]={29445,'495:56.2,51.4 495:56.2,51.5'}
G[30314]={30314,'492:43.75,24.37'}
G[30344]={30344,'492:55.4,38.4 492:55.4,38.5 492:55.4,39.6 492:55.6,40.2 492:55.8,37.8 492:55.8,41.1 492:55.9,41.5 492:56.3,37.4 492:56.3,42.5 492:56.5,37.3 492:56.5,43.1 492:57,44.4 492:57.3,45 492:57.5,45.2 492:57.6,37.4 492:57.7,45.6 492:57.9,38.2 492:58.2,39.4 492:58.2,46.5 492:58.4,40 492:58.5,40.3 492:58.5,47 492:58.6,40.6 492:58.8,47.6 492:59.2,42 492:59.4,42.5 492:59.4,49 492:59.6,49.4 492:59.8,43.4 492:59.9,50.2 492:60.1,44.1 492:60.1,50.6 492:60.4,44.8 492:60.4,51.5 492:60.6,45.3 492:60.7,52.4 492:60.8,45.8 492:60.8,52.7 492:61.2,46.8 492:61.4,54.4 492:61.5,47.4 492:61.6,55 492:61.7,48 492:61.8,55.6 492:62.1,56.9 492:62.3,49.3 492:62.4,49.5 492:62.8,50.4 492:62.8,57.5 492:63.1,51 492:63.2,57.3 492:63.4,51.6 492:63.6,52.2 492:63.7,57 492:63.8,52.8 492:64.1,53.9 492:64.3,54.8 492:64.3,56.3'}
G[30345]={30345,'492:55.2,39.8 492:55.3,38.8 492:55.5,40.4 492:55.6,38.2 492:55.7,41 492:55.9,41.5 492:56.4,37 492:56.4,43 492:56.6,43.4 492:56.9,44.1 492:57.4,37.4 492:57.4,37.5 492:57.4,45.2 492:57.5,37.4 492:57.5,45.4 492:57.7,38 492:57.7,45.8 492:57.9,38.6 492:58.3,46.6 492:58.4,40 492:58.5,40.4 492:58.6,40.5 492:58.7,47.4 492:58.9,47.8 492:59.2,48.5 492:59.4,42.4 492:59.4,42.5 492:59.5,42.6 492:59.6,49.3 492:60,50.3 492:60.2,44.3 492:60.2,50.9 492:60.4,44.8 492:60.4,51.6 492:60.5,45 492:60.7,52.2 492:60.8,52.6 492:60.9,46 492:61.1,53.7 492:61.3,46.9 492:61.4,54.5 492:61.5,47.4 492:61.5,47.5 492:61.6,54.9 492:61.9,48.5 492:62,56.1 492:62.2,56.7 492:62.4,49.6 492:62.5,49.7 492:62.5,57.3 492:62.9,50.5 492:63,57.8 492:63.4,51.7 492:63.5,52 492:63.5,57.6 492:63.8,52.9 492:63.8,57 492:64.2,53.9 492:64.4,54.5 492:64.4,55.9 492:64.6,55.4 492:64.6,55.5'}
G[30348]={30348,'HL 486:59.09,65.63'}
G[30357]={30357,'HL 490:60.56,27.68'}
G[30358]={30358,'HL 488:29.75,55.91'}
G[30359]={30359,'HL 495:28.89,73.72'}
G[30360]={30360,'HL 486:33.80,34.36'}
G[30362]={30362,'HL 493:49.77,63.62'}
G[30363]={30363,'HL 488:48.77,78.16'}
G[30364]={30364,'HL 486:57.40,43.72'}
G[30365]={30365,'HL 493:63.81,49.02'}
G[30367]={30367,'HL 490:80.52,37.11'}
G[30368]={30368,'HL 501:49.03,13.95'}
G[30369]={30369,'HL 496:58.91,55.97'}
G[30370]={30370,'HL 495:41.15,84.73'}
G[30371]={30371,'HL 486:42.94,49.58'}
G[30372]={30372,'HL 490:64.18,46.98'}
G[30373]={30373,'HL 488:35.10,48.34'}
G[30374]={30374,'HL 495:64.59,51.33'}
G[30375]={30375,'HL 495:31.26,37.62'}
G[30381]={30381,'495:65.67,51.46'}
G[30382]={28070,'495:39.56,56.36'}
G[30390]={29445,'495:71.4,48.9'}
G[30395]={30395,'495:61.18,39.01','In cave'}
G[30401]={30401,'495:30.2,74.7'}
G[30406]={30406,'492:36.1,33.1'}
G[30433]={30433,'492:87.80,78.07'}
G[30469]={30469,'495:48.52,54.36','In cave'}
G[30472]={30472,'495:36.97,49.51'}
G[30481]={30481,'Near'}
G[30490]={30490,'504[2]:31.29,49.65'}
G[30531]={30531,'HL 523[1]:47.42,69.63 491:57.34,46.99>523'}
G[30533]={30533,'HL 533[1]:21.8,44.0 488:26.01,50.83>533'}
G[30534]={30534,'HL 534[1]:68.85,79.12 496:28.53,86.94>534'}
G[30535]={30535,'HL 526[1]:29.41,62.04 495:39.54,26.92>526'}
G[30536]={30536,'HL 520[1]:55.23,64.73 486:27.50,26.10>520'}
G[30537]={30537,' HL 530[1]:45.67,61.57 496:76.27,21.19>530'}
G[30538]={30538,'HL 524[1]:48.75,22.94 491:57.25,46.59>524'}
G[30548]={30548,'495:44.52,64.55','In back of cave'}
G[30562]={30562,'492:79.8,30.9'}
G[30569]={30569,'496:70.47,23.28'}
G[30596]={30596,'492:83.1,72.9'}
G[30631]={30631,'492:35.4,66.4'}
G[30657]={30657,'492:85.7,76'}
G[30658]={30658,'536[1]:47.63,89.77 504[1]:66.81,68.15>536'}
G[30671]={30671,'496:70.1,22.9'}
G[30676]={30676,'496:70.06,20.93'}
G[30677]={28179,'492:86,75.8'}
G[30683]={30226,'492:82.9,72.8'}
G[30686]={30686,'492:83,73'}
G[30708]={30708,'492:35.4,66.4 492:35.4,66.5 492:35.5,66.4 492:35.5,66.5'}
G[30709]={30709,'362:29.2,21.8'}
G[30714]={30714,'492:83,73'}
G[30824]={30824,'492:60,33.8 492:60,35.2 492:60.1,33.2 492:60.1,35.6 492:60.4,32.2 492:60.4,36.5 492:60.5,31.9 492:60.9,37.4 492:61,37.7 492:61.1,31.2 492:61.4,38.6 492:61.6,39.2 492:61.7,30.9 492:62,39.9 492:62.3,40.6 492:62.5,30.6 492:62.7,41.3 492:62.8,41.6 492:63.3,29.8 492:63.4,43.1 492:63.5,43.3 492:63.6,29.5 492:63.7,29.4 492:63.9,44.4 492:64.1,44.9 492:64.3,45.5 492:64.6,28.7 492:64.6,46.4 492:64.8,47 492:65,47.6 492:65.3,28.1 492:65.4,48.5 492:65.5,28 492:65.6,48.8 492:66.1,50 492:66.2,27.2 492:66.3,50.5 492:66.5,26.9 492:66.5,50.9 492:66.8,51.6 492:67.4,26.3 492:67.5,52.4 492:67.8,52.7 492:68.2,26.4 492:68.5,26.4 492:69.1,26.8 492:69.2,52.5 492:69.4,31.4 492:69.4,31.6 492:69.4,33.2 492:69.4,33.8 492:69.4,34.6 492:69.4,52 492:69.5,27.4 492:69.5,30.2 492:69.5,30.5 492:69.5,35 492:69.5,35.7 492:69.5,51.9 492:69.6,27.6 492:69.6,37.4 492:69.6,38.3 492:69.6,38.8 492:69.7,28.8 492:69.7,40 492:69.7,41.2 492:69.7,41.8 492:69.7,42.7 492:69.7,50.8 492:69.8,44.3 492:69.8,45 492:69.8,46 492:69.8,47.2 492:69.8,48.2 492:69.8,49.3 492:69.8,49.6'}
G[30825]={30825,'492:60,34.8 492:60.1,34 492:60.2,33.2 492:60.4,32.4 492:60.4,36.4 492:60.4,36.5 492:60.6,32 492:60.6,36.8 492:60.9,37.5 492:61.4,31.2 492:61.4,38.7 492:61.7,39.3 492:61.9,39.7 492:62.1,30.8 492:62.3,40.6 492:62.5,30.5 492:62.5,41 492:62.8,30.2 492:62.8,41.6 492:63.3,42.8 492:63.5,29.6 492:63.5,43.4 492:63.9,29.3 492:63.9,44.3 492:64.2,45.2 492:64.4,45.8 492:64.6,28.7 492:64.6,46.3 492:64.9,28.4 492:64.9,47.2 492:65.1,47.8 492:65.4,48.5 492:65.5,48.7 492:65.6,27.8 492:65.9,49.6 492:66.3,27.1 492:66.4,50.7 492:66.7,51.3 492:66.8,26.7 492:66.9,51.6 492:67.4,26.4 492:67.6,26.4 492:67.7,52.4 492:68.3,26.5 492:68.3,52.6 492:68.6,26.6 492:68.7,52.6 492:69.4,27.6 492:69.4,31.1 492:69.4,32.2 492:69.4,32.8 492:69.4,34.2 492:69.4,34.5 492:69.4,51.9 492:69.5,28.4 492:69.5,29.1 492:69.5,29.9 492:69.5,30.5 492:69.5,34.4 492:69.5,35.2 492:69.5,35.8 492:69.5,36.5 492:69.5,51.5 492:69.6,38 492:69.6,38.6 492:69.6,51.3 492:69.7,40.4 492:69.7,40.6 492:69.7,41.6 492:69.7,42.6 492:69.7,50.3 492:69.8,44.2 492:69.8,45.3 492:69.8,46 492:69.8,47 492:69.8,48.4 492:69.8,49.1 603:42.2,14.3'}
G[30869]={30869,'501:71.98,30.97'}
G[30871]={30871,'524[2]:43.99,18.21 491:57.25,46.59>524'}
G[30944]={30944,'492:54.1,71.1'}
G[30946]={30946,'492:44,24.6'}
G[30997]={10667,'521:31.4,45.3 521:31.4,45.5 521:32.1,44.4 521:32.1,45.1 521:32.2,44.4 521:32.2,44.8 521:32.4,45.5 521:32.4,45.8 521:32.5,44.9 521:32.5,45.7 521:32.6,44.4 521:32.7,45.3 521:32.8,44.3'}
G[31036]={31036,'501:49.83,18.08'}
G[31044]={28179,'492:79.8,71.8'}
G[31051]={31051,'501:48.46,21.16'}
G[31052]={31052,'501:53.07,20.88'}
G[31053]={31053,'501:22.27,34.39'}
G[31054]={31054,'501:43.72,17.16'}
G[31069]={30227,'492:79.41,72.37'}
G[31078]={31078,'492:19.33,47.78'}
G[31081]={31081,'504[1]:67.73,47.17'}
G[31082]={28510,'502:34,30.3 502:34.2,30.5'}
G[31084]={28444,'23:83.42,49.44'}
G[31085]={31085,'504[1]:69.38,40.69'}
G[31091]={31091,'501:22.2,35 501:22.3,35.5 501:22.5,35 501:49.8,18 501:50,18.5 501:50.5,18'}
G[31101]={31101,'501:21.8,35.5 501:21.9,35.3 501:51.7,21.1'}
G[31102]={31102,'501:22.5,34.6 501:53.3,20.8 501:53.8,21'}
G[31106]={31106,'501:22,34.4 501:22,34.5 501:47.1,21.1'}
G[31107]={31107,'501:22.4,35.4 501:22.4,35.7 501:22.5,35.4 501:22.5,35.7 501:48.6,24.5 501:48.7,24.2'}
G[31108]={31108,'501:47.2,21 501:71.9,31.3 501:72,31.5'}
G[31109]={31109,'501:51.07,24.63'}
G[31134]={31134,'536[1]:45.99,80.44'}
G[31135]={31135,'492:30.8,29.1'}
G[31151]={31151,'501:21.8,34.4 501:21.8,34.5 501:50.2,17.8'}
G[31153]={31153,'501:50.22,17.74'}
G[31154]={31154,'492:31.6,30.9'}
G[31237]={31237,'492:53.8,87'}
G[31240]={31240,'492:79.5,72.7'}
G[31241]={31241,'492:79.4,72.9 492:79.5,72.8'}
G[31259]={31259,'492:0.7,51.4 492:0.9,57.7 492:1.8,52.6 492:4.1,60.6 492:4.3,65 492:4.6,61.8 492:5.3,63.1 492:5.3,66.9 492:5.7,65.8 492:5.9,64 492:41.2,25.1 492:55.1,41 492:55.2,40.3 492:55.3,41.6 492:55.4,37.4 492:55.4,38.3 492:55.4,38.5 492:55.6,40.1 492:55.8,40.8 492:55.9,41.8 492:56,38.4 492:56,38.8 492:56.1,42.9 492:56.2,37.3 492:56.2,43.6 492:56.4,44.7 492:56.5,41 492:56.5,41.6 492:56.8,36.2 492:56.8,37 492:56.9,44.4 492:57,45.7 492:57.1,45 492:57.2,43.1 492:57.4,37.7 492:57.4,39 492:57.4,46.6 492:57.5,38.3 492:57.5,38.7 492:57.5,43.9 492:57.6,36.9 492:57.8,40.1 492:57.8,46.8 492:57.9,45.5 492:58,40.8 492:58.3,41.5 492:58.3,45.3 492:58.4,48.3 492:58.5,38 492:58.5,47.1 492:58.6,42.3 492:58.6,46.2 492:58.7,38.9 492:58.8,47.6 492:58.9,40 492:59,40.5 492:59,42.9 492:59.1,49.7 492:59.3,50.5 492:59.4,44.1 492:59.4,48.8 492:59.5,48.3 492:59.6,41.1 492:59.8,44.6 492:59.8,48.6 492:60,42.2 492:60,42.5 492:60,44.3 492:60,49.8 492:60.1,46 492:60.3,51.4 492:60.3,52.4 492:60.3,53.1 492:60.4,46.5 492:60.4,53.6 492:60.5,43.4 492:60.5,44.6 492:60.5,49.8 492:60.5,50.9 492:60.6,44.4 492:60.6,53.8 492:60.8,46.3 492:61,47.5 492:61.2,52 492:61.2,52.6 492:61.3,47.4 492:61.3,48.8 492:61.3,54.5 492:61.4,56.3 492:61.5,45.7 492:61.6,53.5 492:61.7,53.3 492:61.9,47.3 492:61.9,49.6 492:62,56.6 492:62.1,47.9 492:62.3,50.6 492:62.3,56.1 492:62.4,49 492:62.4,55.2 492:62.4,57.7 492:62.5,48.4 492:62.5,48.8 492:62.5,49.7 492:62.7,51.8 492:63,50.7 492:63,57.9 492:63.3,52.8 492:63.3,56.5 492:63.4,53.9 492:63.4,56.4 492:63.6,50.4 492:63.6,52.5 492:63.6,54.5 492:63.7,51.2 492:63.7,52.1 492:63.7,57.7 492:64,53.7 492:64,56 492:64.4,56.7 492:64.5,53.4 492:64.5,56.9 492:64.7,53.8 492:64.7,55.5 492:65,55.4'}
G[31261]={31261,'492:2.7,49.1 492:2.9,45.2 492:3.6,44.1 492:4.4,53 492:4.6,53.5 492:5.4,42.1 492:6,42.1 492:6,57.1 492:6.1,56 492:7,58.8 492:7.2,40.4 492:7.4,60.2 492:7.6,60.1 492:7.8,39.8 492:7.8,60.6 492:8.6,62.5 492:9.3,39.2 492:9.8,39.3 492:10.2,39.7 492:10.5,50.5 492:10.5,54.7 492:10.7,48.3 492:10.9,60.6 492:42.4,22.1 492:43.2,24.2 492:43.3,24.5 492:44.4,26.9 492:46,24.6 492:59.9,33.9 492:59.9,34.5 492:60.2,36.3 492:60.2,36.9 492:60.3,31.9 492:60.3,32.7 492:60.5,33.2 492:60.5,33.6 492:60.5,35.2 492:60.7,36.1 492:60.9,31.2 492:60.9,32.4 492:60.9,37 492:61.2,39.1 492:61.4,38.1 492:61.4,39.7 492:61.5,37.9 492:61.6,40 492:61.7,31.6 492:62.2,39.3 492:62.2,41.2 492:62.3,30 492:62.4,30.8 492:62.4,41.7 492:62.5,30.2 492:62.5,40.8 492:62.5,41.8 492:62.6,30.9 492:62.7,40.3 492:63,42.7 492:63.1,29.3 492:63.3,43.6 492:63.6,29.5 492:63.6,42.4 492:63.6,43 492:63.6,44.1 492:63.9,45.6 492:64,45.2 492:64.2,29.1 492:64.3,46.5 492:64.4,28.3 492:64.5,45.9 492:64.6,45.3 492:64.6,46.9 492:64.8,28 492:64.8,28.7 492:64.8,47.6 492:65.3,49.2 492:65.4,27.4 492:65.4,49.5 492:65.5,48 492:65.6,28.5 492:65.6,49.5 492:65.9,49.3 492:66,27.6 492:66.3,26.6 492:66.4,51.4 492:66.4,51.5 492:66.5,27.5 492:66.5,49.9 492:66.9,26.4 492:66.9,50.9 492:67.2,26.6 492:67.3,51.9 492:67.3,52.7 492:67.5,52.2 492:68,26.3 492:68.3,27 492:68.3,52.5 492:68.5,27 492:68.6,52.2 492:68.7,26.2 492:68.7,53 492:69,31.7 492:69.1,29.6 492:69.1,32.7 492:69.1,35.4 492:69.2,29 492:69.2,31 492:69.2,34.2 492:69.2,35.7 492:69.2,36.5 492:69.2,51.1 492:69.3,38.2 492:69.3,40.1 492:69.3,41 492:69.3,41.7 492:69.4,28.1 492:69.4,38.9 492:69.4,42.6 492:69.4,44 492:69.4,44.6 492:69.4,46.2 492:69.4,47.3 492:69.4,47.7 492:69.4,49.2 492:69.4,49.6 492:69.5,29.2 492:69.5,35.2 492:69.5,41.7 492:69.5,50.5 492:69.5,51.6 492:69.6,27.2 492:69.6,30.7 492:69.6,35.8 492:69.6,39.7 492:69.7,31.5 492:69.7,33.4 492:69.7,34.2 492:69.7,44.9 492:69.8,28 492:69.8,30.1 492:69.8,37.3 492:69.8,48.7 492:69.9,38 492:70,39 492:70,40.7 492:70,44.3 492:70.1,42.5 492:70.1,49.9 492:70.2,45.8 492:70.2,46.9 492:70.2,47.5'}
G[31273]={31273,'492:66.9,66.4 492:67.1,67.3 492:67.2,67.5 492:67.2,68.8 492:67.3,69.5 492:67.7,68.3 492:67.8,68.6 492:67.9,71.1 492:68.1,67.4 492:68.5,69.7 492:68.7,64.5 492:68.7,69.1 492:68.8,64.3 492:68.9,65.9 492:69,67.2 492:69.3,67.9 492:70,62.3 492:70,62.5 492:70.4,65 492:70.4,67.3 492:70.5,65 492:70.5,67.2 492:70.8,68.3 492:70.8,68.5'}
G[31279]={31279,'492:31.8,64.8 492:31.9,64.2'}
G[31304]={31304,'492:66.1,65.4 492:66.1,65.5 492:66.3,64.1 492:66.4,66.5 492:66.5,66.5 492:66.7,65.7 492:66.8,64 492:67.2,63.3 492:67.3,69.1 492:67.4,67.6 492:67.5,67.7 492:67.7,70.3 492:67.9,64.5 492:68.1,63.4 492:68.1,63.5 492:68.1,67.4 492:68.1,69.4 492:68.4,62.4 492:68.5,62.3 492:68.6,69.1 492:68.7,66.4 492:68.7,66.5 492:68.8,62.7 492:68.8,64.4 492:68.8,64.5 492:69.1,68.3 492:69.2,70.4 492:69.2,70.5 492:69.5,66 492:69.5,67.3 492:69.5,67.5 492:69.8,63.2 492:69.8,64.6 492:70.2,61.9 492:70.4,64.1 492:70.5,65.1 492:70.8,62.9 492:70.9,63.9 492:71.6,61.1 492:71.6,62.7'}
G[31440]={31440,'492:54.9,84.2'}
G[31444]={31444,'492:51.8,86.7'}
G[31557]={31557,'504:65.6,32.2'}
G[31737]={31737,'492:59.9,53.4 492:59.9,53.5 492:60.6,49.8 492:61.6,52.5 492:62.1,51.8 492:62.7,51 492:62.7,51.6'}
G[31776]={31776,'492:57,62.5'}
G[31781]={31781,'492:51.9,57.6'}
G[31808]={31808,'492:62.6,51.3'}
G[31833]={31833,'492:57.4,47.4 492:57.4,47.5 492:57.5,46.7 492:57.6,48.3 492:58.4,46.1 492:59.4,52.6'}
G[31834]={31834,'492:58.3,46'}
G[31868]={31868,'492:68,51.8'}
G[31892]={31892,'492:54.4,59.1 492:54.5,59.5 492:54.6,59.2'}
G[32273]={32273,'521[2]:51.58,41.68'}
G[32301]={32301,'492:2.3,44.9 492:3.9,43.1 492:4.4,52.2 492:4.8,42.8 492:4.8,53.1 492:5.3,42.3 492:5.4,53.9 492:6.1,56.4 492:6.8,58.4 492:6.8,59.1 492:7.8,60.7 492:8.5,61.4 492:8.7,39.6 492:8.8,62.1 492:10.1,62.6 492:10.4,40.3 492:10.6,46.8 492:10.6,51.7 492:10.6,53.5 492:10.7,48.2 492:10.7,53.4 492:11,51.4 492:11,61.2 492:46,26.5 492:59.9,33 492:60.1,33.6 492:60.2,34.7 492:60.3,31.8 492:60.3,36 492:60.4,37 492:60.5,33.7 492:60.5,35.3 492:60.5,35.9 492:60.6,32.1 492:60.6,32.6 492:60.7,37.2 492:61.1,38 492:61.1,39 492:61.2,31.4 492:61.4,39.6 492:61.5,38 492:61.5,38.5 492:61.6,31.1 492:61.9,30.4 492:61.9,31.5 492:62,39.9 492:62,40.8 492:62.4,41.6 492:62.6,30.6 492:62.6,40.4 492:62.6,41.2 492:63,30 492:63.2,42.2 492:63.3,29.3 492:63.3,42.9 492:63.4,44.1 492:63.5,42.3 492:63.5,42.7 492:63.6,43.6 492:64.1,29.7 492:64.2,28.4 492:64.2,45.3 492:64.3,28.9 492:64.4,46.1 492:64.4,46.9 492:64.5,45.1 492:64.5,46 492:64.6,28.7 492:64.8,47.4 492:65.1,28.2 492:65.2,48.2 492:65.3,48.6 492:65.4,27.3 492:65.4,49.5 492:65.5,48.4 492:65.6,27.6 492:65.7,49.1 492:65.8,49.6 492:66.3,27.1 492:66.4,50.6 492:66.6,50.4 492:66.7,51.7 492:66.8,51.4 492:67.2,52.5 492:67.3,26.2 492:67.4,26.5 492:67.5,52.2 492:67.9,26.4 492:68,26.5 492:68.1,52.6 492:68.6,53 492:69,26.4 492:69.2,29.1 492:69.2,35 492:69.2,36.9 492:69.2,52 492:69.3,27.3 492:69.3,30.6 492:69.3,33.3 492:69.3,33.7 492:69.3,35.9 492:69.3,39.2 492:69.4,28.1 492:69.4,30.4 492:69.4,32.1 492:69.4,37.9 492:69.4,39.6 492:69.4,41.2 492:69.4,42.3 492:69.4,42.5 492:69.4,44.6 492:69.4,49.3 492:69.4,49.9 492:69.4,50.5 492:69.5,27 492:69.5,28.7 492:69.5,29.6 492:69.5,30.8 492:69.5,32 492:69.5,33.5 492:69.5,35 492:69.5,36.5 492:69.5,51.7 492:69.6,27.5 492:69.6,33.4 492:69.6,38.3 492:69.6,38.8 492:69.7,35.9 492:69.7,40.1 492:69.7,40.8 492:69.8,41.6 492:69.8,43.8 492:69.8,44.7 492:69.8,46.1 492:69.8,48.6 492:69.8,49.9 492:69.9,47 492:69.9,48.3 492:69.9,51.4 492:70.1,42.9'}
G[32302]={32302,'492:41.3,25.3 492:41.6,25.9 492:55.3,39 492:55.4,38.4 492:55.4,39.8 492:55.5,39.3 492:55.7,40.4 492:55.8,37.5 492:55.8,40.9 492:55.9,41.9 492:56.1,37.3 492:56.4,43.2 492:56.6,43.6 492:56.7,43.4 492:57,36.9 492:57.1,44.8 492:57.5,45.4 492:57.7,37.4 492:57.9,45.8 492:58,38.2 492:58.2,39.1 492:58.2,46.6 492:58.3,39.5 492:58.5,40 492:58.5,47.2 492:58.8,47.8 492:58.9,41.1 492:59.2,41.7 492:59.3,48.8 492:59.4,42.5 492:59.5,42.4 492:59.6,49.2 492:59.8,43.3 492:59.8,43.6 492:60,50 492:60.1,50.9 492:60.3,51.5 492:60.4,44.5 492:60.5,44.9 492:60.5,51.4 492:60.6,52.2 492:60.8,45.5 492:60.9,53.3 492:61.2,54 492:61.4,46.9 492:61.4,54.6 492:61.5,47.2 492:61.5,54.3 492:61.5,54.9 492:61.8,48.4 492:61.8,56.3 492:61.8,56.6 492:62.3,49.5 492:62.4,49.3 492:62.4,57.6 492:62.5,50 492:62.6,57.5 492:63.3,51.3 492:63.4,51.5 492:63.4,57.2 492:63.5,51.7 492:63.7,52.6 492:64.1,53.7 492:64.3,54.5 492:64.4,56.4 492:64.4,56.7 492:64.5,55.1 492:64.5,55.7'}
G[32337]={32337,'504[1]:54.00,32.27'}
G[32404]={31237,'492:64.5,44'}
G[32408]={31237,'492:68,51.7'}
G[32413]={32413,'504[1]:44.64,63.30'}
G[32423]={31237,'492:71.6,37.6'}
G[32430]={32430,'492:54,36.9'}
G[32444]={32444,'492:54,42.9'}
G[32497]={31237,'492:49.2,73.1'}
G[32516]={32516,'504[2]:43.16,24.42'}
G[32540]={32540,'495:66.16,61.43'}
G[32548]={32548,'486:29.4,24.8 486:29.5,24.8'}
G[32571]={32571,'495:62.61,60.92'}
G[32594]={32594,'495:67.1,60.9'}
G[32599]={32599,'488:79.3,65.1'}
G[32639]={32639,'947:32.39,41.87'}
G[32641]={32641,'24:57.94,72.62'}
G[32798]={32798,'HN 4:51.82,42.07 9:46.93,59.53 20:61.62,53.11 462:47.77,47.13'}
G[32799]={32799,'HN 27:53.99,50.70 30:42.98,65.40 41:55.59,51.36 464:49.07,51.25'}
G[32800]={31279,'492:31.3,62.4 492:31.4,59 492:31.7,57.8 492:31.8,64.8 492:31.9,57.2 492:31.9,64.2'}
G[32801]={32801,'HM 486:55.10,19.94'}
G[32802]={32802,'HM 493:48.09,66.36'}
G[32803]={32803,'HM 488:75.29,43.80'}
G[32804]={32804,'HM 491:57.80,16.12'}
G[32805]={32805,'HM 490:33.90,60.45'}
G[32806]={32806,'HM 495:41.44,86.69'}
G[32807]={32807,'HM 510:78.18,74.95'}
G[32808]={32808,'HM 496:40.37,61.30'}
G[32809]={32809,'HM 486:51.13,11.54'}
G[32810]={32810,'HM 493:47.06,61.56'}
G[32811]={32811,'HM 488:38.26,48.47'}
G[32812]={32812,'HM 491:48.61,13.15'}
G[32813]={32813,'HM 490:19.32,61.15'}
G[32814]={32814,'HM 495:40.27,85.35'}
G[32815]={32815,'HM 510:79.97,53.23'}
G[32816]={32816,'HM 496:43.37,71.74'}
G[32836]={32836,'HN 27:54.11,50.82 30:43.04,65.33 41:55.72,51.30 464:49.02,51.19'}
G[32837]={32837,'HN 4:51.90,41.87 9:47.12,59.89 20:61.35,52.98 462:47.65,47.31'}
G[32862]={32862,'42:72.38,18.75 H:100046318'}
G[32863]={32863,'42:58.8,19.4 H:100044979'}
G[32867]={32867,'529[2]:13.21,57.21'}
G[32871]={32871,'529[2]:80.92,45.50 H:100046053'}
G[32912]={32912,'42:50.31,20.33'}
G[32932]={32932,'42:44.6,30.8'}
G[32959]={32959,'42:50.82,17.95'}
G[32960]={32960,'42:50.9,18'}
G[32963]={32963,'42:58.91,19.45'}
G[32964]={11711,'42:64.51,5.47'}
G[32965]={32965,'42:58.89,19.41'}
G[32966]={32966,'42:58.88,19.53'}
G[32967]={32967,'42:43.5,80.9'}
G[32968]={32968,'42:43.5,80.9'}
G[32970]={32970,'42:64,5.4 H:100045040'}
G[32971]={32971,'42:50.22,19.78'}
G[32972]={32972,'42:50.93,18.21'}	-- moves about
G[32973]={32973,'42:51.78,18.01'}
G[32977]={32977,'42:51.2,19.6'}
G[32978]={32978,'42:51.2,19.7'} --  42:56.8,30 removed because it is fleeting
G[32979]={32979,'42:51.00,19.19'}
G[32987]={32987,'42:42.68,45.15'}
G[33022]={33022,'42:58.6,32.6 H:100044927'}
G[33025]={33025,'496:69.99,20.96'}
G[33048]={33048,'42:42.97,39.01'}
G[33055]={33055,'42:63.75,5.98'}
G[33072]={33072,'42:45.4,74.9'}
G[33091]={33091,'42:43.7,53.4 42:43.7,53.5'}
G[33107]={33107,'42:42.6,45.1'}
G[33112]={33112,'42:44.43,56.78'}
G[33117]={33117,'42:40.94,56.48'}
G[33119]={33119,'42:45.4,48.5 42:45.5,48.5'}
G[33126]={33126,'42:42.9,39'}
G[33131]={33131,'42:42.79,40.17'}
G[33132]={33132,'42:42.46,38.56'}
G[33133]={33133,'42:43.68,39.85'}
G[33166]={33166,'42:49.2,57'}
G[33175]={33175,'42:52.4,18'}
G[33176]={33176,'42:69.09,19.24'}
G[33177]={33177,'42:46.8,33.2'}
G[33178]={33178,'42:72.28,19.09'}
G[33182]={33182,'43:29,24.1'}
G[33187]={33187,'43:26.9,22'}
G[33204]={33204,'43:26.8,22'}
G[33222]={33222,'492:76.5,19.2'}
G[33223]={33223,'492:76.6,19.2'}
G[33225]={33225,'492:76.6,19.2'}
G[33231]={33231,'42:42.59,45.29'}
G[33232]={33232,'42:38.6,42.4'}
G[33250]={33250,'42:45.2,75.1'}
G[33253]={33253,'42:44.41,75.47'}
G[33256]={33256,'688[1]:47.95,13.43'}
G[33258]={33258,'688[1]:47.93,13.10'}
G[33260]={33260,'688[1]:48.48,12.05'}
G[33261]={33261,'688[1]:48.48,11.62'}
G[33263]={33263,'11:42.42,15.77'}
G[33276]={33276,'43:26.9,36.7 43:27,36.3'}
G[33280]={33280,'301:53.9,81.4 605:59.7,72.6'}
G[33284]={33284,'11:42.27,15.20'}
G[33294]={33294,'43:64.16,84.50'}
G[33309]={33309,'492:76.6,19.5'}
G[33312]={33312,'492:76.6,19.5'}
G[33315]={33315,'492:76.6,19.4 492:76.6,19.5'}
G[33335]={33335,'492:76.5,19.8'}
G[33361]={33361,'492:76.4,24.5 492:76.5,24.5'}
G[33372]={33372,'492:76,24.4 492:76,24.5'}
G[33373]={33373,'492:76.5,24.2'}
G[33379]={33379,'492:76.4,23.9 492:76.5,23.9'}
G[33403]={33403,'492:76.2,24.6'}
G[33405]={33405,'492:76.4,24.4 492:76.4,24.5 492:76.5,24.5'}
G[33417]={33417,'492:69.4,23 492:69.5,23.1'}
G[33421]={33421,'43:72.93,80.44'}
G[33443]={33443,'43:20.2,38.8'}
G[33445]={33445,'43:26.8,36'}
G[33454]={33454,'43:34.7,48.6'}
G[33532]={33532,'HC Near'}
G[33533]={33533,'HC Near'}
G[33536]={33536,'182:50.3,14.5 182:50.9,14.5 182:51.9,15 182:52.6,14.5 182:53.1,17.4 182:54,16.8 182:54.5,20.6 182:55.2,19 529:53,37.9 529:53,39.1 529:53.1,36 529:53.1,37.3 529:53.2,36 529:53.3,37.2 529:53.3,39 529:53.3,39.6 529:53.3,39.7 529:53.4,38.4 529:53.7,39 529:53.7,39.8 529:53.9,35.9 529:53.9,37.6 529:54.3,35.3 529:54.3,35.4 529:54.3,35.9 529:54.3,36.5 529:54.3,37.7 529:54.4,36.8 529:54.4,38.9 529:54.4,39.5 529:54.5,35.4 529:54.5,38.5 529:54.6,35.5 529:54.6,36.7 529:54.6,37 529:54.6,37.9 529:54.6,38.5 529:54.6,39.5 529:54.7,36 529:54.8,37.9 529:55.5,38 529:55.6,37.4 610:63.9,59.5 640:71.8,47.7 614:52.4,59.4'}
G[33538]={33538,'492:76.4,23.8'}
G[33539]={33539,'492:76.2,24.6'}
G[33540]={33540,'492:76,24.5'}
G[33541]={33541,'492:76.5,24.2'}
G[33542]={33542,'492:76.3,24.3'}
G[33544]={33544,'492:76.4,24.5'}
G[33545]={33545,'492:76,24.4 492:76,24.5'}
G[33547]={33547,'492:76.5,24.3'}
G[33548]={33548,'492:76.4,23.9 492:76.5,23.9'}
G[33549]={33549,'492:76.2,24.6'}
G[33592]={33592,'492:76.3,19.1'}
G[33593]={33593,'492:76.1,19.2'}
G[33625]={33625,'492:76.4,19.4 492:76.4,19.5'}
G[33646]={33646,'492:76.4,19.4 492:76.4,19.5'}
G[33647]={33647,'492:76.4,19.4 492:76.4,19.5 492:76.5,19.5'}
G[33648]={33648,'492:76.5,19.8'}
G[33649]={33649,'492:76.5,19.8'}
G[33652]={33652,'492:76.3,19.1'}
G[33654]={33654,'492:76.4,19.1'}
G[33655]={33655,'492:76.1,19.2'}
G[33656]={33656,'492:76.1,19.1'}
G[33658]={33658,'492:76.3,24.3'}
G[33659]={33659,'492:76.2,24.4'}
G[33726]={33726,'43:73.33,62.19'}
G[33727]={33727,'43:86.4,43.7 43:86.5,43.7'}
G[33759]={33759,'492:69.9,23.4 492:69.9,23.5'}
G[33760]={33760,'43:72.20,57.65','In mine'}
G[33762]={33762,'492:73.8,20'}
G[33763]={33763,'492:69.9,23.4 492:69.9,23.5'}
G[33769]={33769,'492:73.8,19.5'}
G[33770]={33770,'492:73.6,20'}
G[33771]={33771,'492:69.9,23.4'}
G[33777]={33777,'43:75.4,75.8 43:75.6,75.5 43:75.7,75.2'}
G[33817]={33817,'492:69.7,22.8'}
G[33837]={8582,'43:73.61,62.14'}
G[33849]={33849,'492:72.59,22.62'}
G[33889]={33889,'43:82.54,53.81'}
G[33956]={33956,'529:14,88.6 529:15.2,89.5 529:15.3,87.3 529:15.3,88.8 529:15.4,88.4 529:15.8,87 529:15.8,88.2 529:15.9,90 529:16.1,88.8 529:16.6,88.1 529:16.6,88.7 529:16.8,89.5'}
G[33957]={33957,'529:14.8,87 529:14.9,87.6 529:15.1,88.7 529:15.5,88.6 529:15.6,87.1 529:15.7,87.6 529:16.1,90.2'}
G[33977]={33760,'43:72.20,57.65','In mine'}
G[33981]={33981,'42:57.39,33.85'}
G[34041]={34041,'42:59.1,19.6'}
G[34122]={34122,'43:12.08,33.83'}
G[34195]={34195,'43:94.40,46.82'}
G[34210]={34210,'492:69.5,22.4'}
G[34233]={34233,'43:90.76,58.15'}
G[34239]={34239,'43:36.4,49.8'}
G[34242]={34242,'43:89.6,48.7'}
G[34251]={34251,'43:38,30.1'}
G[34258]={34258,'11:67.44,38.74'}
G[34283]={34283,'43:52.1,56.5'}
G[34284]={34284,'11:66.50,45.55 11:66.49,45.45'}
G[34289]={34289,'43:52.33,56.77'}
G[34290]={34290,'43:52.32,56.51'}
G[34292]={34292,'43:52.09,56.72'}
G[34301]={34301,'42:45.2,74.7'}
G[34303]={34303,'43:11.40,35.36'}
G[34320]={34320,''}
G[34335]={34335,'43:59.1,59.9'}
G[34340]={34340,'42:37.7,82.8'}
G[34341]={34341,'81:74.27,47.72'}
G[34342]={34342,'42:37.7,82.9'}
G[34343]={34343,'42:37.4,82.2 42:37.5,82.3 42:37.7,82.9'}
G[34354]={34354,'43:35.1,71.6'}
G[34358]={34358,'43:59.1,59.9'}
G[34359]={34359,'43:37.99,42.84 43:38.10,43.80 43:39.24,43.58'}
G[34365]={34365,'HC 504[1]:49.36,63.25'}
G[34374]={34374,'43:18.14,20.59'}
G[34377]={34377,'43:62.2,51'}
G[34378]={34378,'43:35.02,72.07'}
G[34395]={34395,'43:37.98,43.86'}
G[34402]={34402,'42:45.3,75.1'}
G[34403]={34403,'42:45.3,75.1'}
G[34404]={34404,'42:45.3,75.1'}
G[34413]={34413,'42:40.61,84.44'}
G[34422]={33091,'42:32.8,84.3'}
G[34423]={34423,'42:32.3,85.2'}
G[34435]={34435,'HD 301:47.80,26.69'}
G[34446]={34446,'42:45.7,71.8'}
G[34476]={34476,'HD 382:68.30,15.63'}
G[34477]={34477,'HD 4:47.47,17.63'}
G[34478]={34478,'HD 27:61.66,37.34'}
G[34479]={34479,'HD 381:68.47,39.87'}
G[34480]={34480,'HD 362:57.08,17.37'}
G[34481]={34481,'HD 27:61.63,37.50'}
G[34482]={34482,'HD 4:47.47,17.86'}
G[34483]={34483,'HD 462:47.99,49.47'}
G[34484]={34484,'HD 464:47.61,55.74'}
G[34498]={34498,'42:45.6,71.7'}
G[34510]={34510,'43:38.8,43.3'}
G[34512]={34512,'43:52.09,56.50'}
G[34513]={34513,'11:56.58,40.29'}
G[34518]={34518,'43:60.67,52.68'}
G[34547]={34547,'11:58.01,49.31'}
G[34559]={34559,'43:50.13,67.57'}
G[34560]={34560,'11:53.9,41.5 11:54,41.3'}
G[34569]={34569,'43:49.96,67.24'}
G[34571]={34571,'545:37.41,63.35'}
G[34578]={34578,'11:54.6,41.4 11:54.6,41.5'}
G[34596]={34596,'43:46.16,63.27'}
G[34599]={3698,'43:18,60'}
G[34604]={34604,'43:22.3,53.1'}
G[34613]={34613,'11:37.5,45.8'}
G[34626]={34626,'11:60.65,85.37'}
G[34634]={34634,'11:55.11,78.53 11:54.94,78.79'}
G[34638]={34638,'11:55.20,78.40'}
G[34644]={34644,'HY 27:59.81,34.33'}
G[34651]={34651,'11:67.02,74.80'}
G[34653]={34653,'HY 27:52.6,36.4 27:53.4,51.4 27:59.77,34.72 30:34.17,51.08 30:42.25,64.07 41:55.96,51.00 42:50.7,18.8 61:78.31,72.49 381:63.41,47.61 465:55.12,63.40 471:76.17,53.29'}
G[34654]={34654,'HY 4:46.24,14.30 4:52.8,44.1 20:58.7,51.5 24:56.14,47.32 9:46.8,59.1 362:29.93,65.13 382:65.54,8.13 462:46.6,47.3 462:55.5,53.2'}
G[34668]={34668,'605:56.43,76.96'}
G[34673]={34673,'605:60.48,77.57'}
G[34674]={34674,'11:62.6,17'}
G[34675]={34675,'HY 30:34.09,51.54'}
G[34676]={34676,'HY 381:61.48,49.11'}
G[34677]={34677,'HY 382:63.92,11.44'}
G[34678]={34678,'HY 362:30.80,63.69'}
G[34679]={34679,'HY 4:46.59,13.80'}
G[34689]={34689,'605:59.42,73.62'}
G[34692]={34692,'605:57.81,77.14'}
G[34693]={34693,'605:58.88,75.26'} -- 605:59.49,77.73 605:58.30,73.04
G[34695]={34695,'605:59.74,76.02'}
G[34696]={34696,'605:57.90,74.25'}
G[34697]={34697,'605:60.34,77.84'}
G[34698]={34698,'11:62.50,16.76'}
G[34708]={34708,'HY 27:60.04,34.31'}
G[34710]={34710,'HY 30:33.71,50.63'}
G[34711]={34711,'HY 381:61.89,46.19'}
G[34712]={34712,'HY 382:63.21,8.91'}
G[34713]={34713,'HY 4:46.36,13.86'}
G[34714]={34714,'HY 362:30.4,68.9'}
G[34744]={34744,'HY 30:33.89,50.80'}
G[34749]={34749,'11:77.24,91.39'}
G[34768]={34768,'HY 382:65.26,14.25'}
G[34771]={34771,'492:76.1,24.1'}
G[34828]={34828,'11:62.37,63.90'}
G[34835]={34835,'605:44.3,74.9 605:44.4,75.5 605:44.6,74.4 605:44.7,75.5 605:45.1,74.8'}
G[34841]={34841,'11:38,46.5 11:38.1,46.3'}
G[34850]={34850,'611:59.14,23.91'}
G[34863]={34863,'611:54.63,16.73'}
G[34872]={34872,'605:60.20,74.63'}
G[34874]={34874,'605:58.24,76.53'}
G[34876]={34876,'605:36.4,71.8 605:36.6,71.7 605:36.7,71 605:36.8,70.4'}
G[34877]={34877,'605:35.1,77.7 605:35.4,76.9 605:35.5,78.7 605:35.7,76.4 605:35.7,77.3 605:35.7,77.5 605:36.5,76.6 605:36.6,76.1 605:36.8,75.4'}
G[34878]={34878,'605:41,81.4 605:41,81.5 605:41.7,81.5 605:41.9,80.9 605:42.1,80.4'}
G[34880]={34880,'492:76.3,19.6'}
G[34882]={34882,'492:69.5,23.1'}
G[34884]={34884,'611:55.2,26.5 611:55.4,26.1 611:55.4,27.5 611:55.5,26.7 611:55.5,27.5 611:55.7,29.3 611:55.7,32 611:55.7,38.9 611:55.8,37.7 611:55.9,26.3 611:56,32.8 611:56.1,30.3 611:56.1,30.9 611:56.2,39.5 611:56.3,23.2 611:56.3,37.4 611:56.5,31.7 611:56.5,39.7 611:56.6,30.9 611:56.6,34.1 611:56.6,41.9 611:56.7,35.2 611:56.7,38.6 611:56.8,35.9 611:57,25 611:57.1,25.6 611:57.4,22.3 611:57.4,22.9 611:57.4,23.8 611:57.5,23.9 611:57.5,41.1 611:57.7,30.2 611:57.7,40.4 611:57.8,21.9 611:57.9,23.2 611:58.1,24.5 611:58.1,41.5 611:58.3,31.2 611:58.5,31.4 611:58.6,21.3 611:58.6,42.6 611:58.8,33 611:58.9,24 611:59,30.3 611:59,32.4 611:59,41.7 611:59.2,22 611:59.2,22.7 611:59.5,22.2 611:59.5,29.7 611:59.7,29.3 611:59.8,22.7 611:59.8,26.1 611:59.9,23.5 611:59.9,26.7 611:59.9,30.6 611:59.9,41.3 611:60,28.3 611:60,42.7 611:60.1,36 611:60.1,36.6 611:60.2,24.7 611:60.3,31.7 611:60.3,37.8 611:60.3,42.4 611:60.4,32.9 611:60.4,33.8 611:60.4,34.7 611:60.5,22.3 611:60.5,22.7 611:60.5,33.3 611:60.5,38 611:60.5,41.3 611:60.6,42.5 611:60.7,24.3 611:60.7,25.3 611:60.8,27.2 611:60.8,41.9 611:60.9,28.6 611:60.9,34 611:61,16.8 611:61.1,26.3 611:61.1,35 611:61.1,36.8 611:61.4,28.1 611:61.4,31.1 611:61.4,36.4 611:61.5,22.4 611:61.5,27.4 611:61.5,35.4 611:61.6,17.2 611:61.6,27.6 611:61.6,28.7 611:61.6,31.1 611:61.6,36.2 611:61.6,36.5 611:61.7,25.7 611:61.8,33.7 611:61.8,41.4 611:62.1,32.2 611:62.3,32.5 611:62.4,41.8 611:62.5,32.3 611:62.7,32.7 611:62.9,34 611:63,20.7 611:63,42.1 611:63.3,20.1 611:63.6,33.5 611:63.7,23.4 611:63.7,42.2 611:63.8,16 611:63.8,19.2 611:63.8,44.2 611:64,21.5 611:64,32.3 611:64,44.5 611:64.1,23.9 611:64.1,42.9 611:64.2,33.4 611:64.5,42.5 611:64.6,21.9 611:64.6,41.8 611:64.8,33 611:65,33.5 611:65.3,26.7 611:65.3,37.8 611:65.4,36.9 611:65.6,27.4 611:65.6,41.7 611:65.7,43.7 611:65.8,31.4 611:65.9,28.6 611:66,31.7 611:66.1,29.7 611:66.2,33.1 611:66.2,34.6 611:66.2,38.4 611:66.3,33.8 611:66.5,43.9 611:66.6,34.9 611:66.7,30.2 611:66.7,34.3 611:66.7,36.4 611:67.1,37.3 611:67.2,37.9 611:67.2,38.5 611:67.7,39 611:67.8,37.8 611:68.2,42.1 611:68.3,41 611:68.4,42.7 611:68.5,42 611:68.5,43.3'}
G[34912]={34912,'492:76.2,19.5'}
G[34913]={34850,'611:59.78,22.16'}
G[34914]={34914,'492:76.1,24.1'}
G[34936]={34571,'611:59.59,26.79'}
G[35053]={35053,'605:56.31,77.10'}
G[35054]={35054,'605:56.31,76.77'}
G[35068]={35068,'321[1]:47.64,71.23'}
G[35077]={35077,'611:55.20,62.89'}
G[35085]={35085,'181:29.12,66.16'}
G[35086]={35086,'181:27.00,77.07'}
G[35087]={35087,'181:29.68,66.88'}
G[35088]={35088,'181:29.72,67.07'}
G[35091]={35091,'181:29.15,66.24'}
G[35094]={35094,'492:69.5,23.1'}
G[35095]={35095,'181:27.01,73.52 H:100047039'}
G[35112]={35112,'611:65.77,77.77'}
G[35115]={35115,'611:65.32,77.65'}
G[35120]={35120,'605:30.11,71.95'}
G[35129]={35129,'181:28.36,75.59'}
G[35136]={35136,'81:70.92,80.57'}
G[35137]={35137,'81:58.80,54.28'}
G[35138]={35138,'81:32.02,61.84'}
G[35142]={35142,'181:70.36,36.25'}
G[35187]={35187,'181:47.23,20.85'}
G[35195]={35086,'181:27,77'}
G[35222]={35222,'605:56.71,76.93','Upstairs'}
G[35256]={35256,'HD 504[1]:34.47,38.19'}
G[35260]={35260,'HD 478:39.79,21.80'}
G[35261]={35261,'HD 478:40.17,22.25'}
G[35281]={35281,'381:43.8,78.6'}
G[35286]={35286,'101:54.7,8.8'}
G[35295]={35295,'101:44.6,29.5'}
G[35298]={35298,'101:44.8,29.6'}
G[35369]={35369,'611:56.78,85.49','In basement'}
G[35378]={35378,'611:56.86,81.44'}
G[35384]={35384,'101:76.94,17.99'}
G[35478]={35478,'101:57.72,49.74'}
G[35481]={35481,'101:36.76,71.68'}
G[35506]={35506,'101:64.8,7.7 101:64.9,7.2 101:65,9.4 101:65.1,10 101:66.3,10.9 101:66.9,10 101:67.4,10.7 101:67.6,10.6 101:68,9.4 101:68,10.3'}
G[35510]={35510,'101:65.1,8.2 101:67,9.7 101:67.6,10.6 101:68.1,10'}
G[35550]={35112,'611:59.37,83.81'}
G[35552]={35077,'611:31.13,72.35'}
G[35556]={35556,'101:70.65,32.89'}
G[35562]={35562,'101:39.07,26.94'}
G[35566]={35077,'611:48.90,52.76'}
G[35591]={35591,'101:51.6,76 H:100049200,100049220'}
G[35618]={35618,'611:40.55,39.43'}
G[35632]={35632,'101:53.90,33.27'}
G[35642]={35642,'946:28.37,74.23'}
G[35646]={35646,'811[3]:75.10,43.74'}
G[35648]={35648,'181:47.15,21.06'}
G[35650]={34668,'544:27.87,75.55'}
G[35657]={35657,'181:50.68,75.30'}
G[35661]={35661,'101:70.37,32.96'}
G[35754]={35754,'181:47.1,21'}
G[35755]={35755,'181:47.29,21.19'}
G[35756]={35756,'181:47.24,21.27'}
G[35757]={35757,'101:60.9,28.9'}
G[35758]={34673,'544:27.94,74.42'}
G[35769]={34872,'544:31.27,79.26'}
G[35773]={35773,'101:38.80,26.96'}
G[35786]={34695,'544:27.84,74.29'}
G[35817]={35817,'181:52.22,74.24'}
G[35827]={35827,'101:30.94,30.89'}
G[35833]={35833,'181:59.01,71.90'}
G[35837]={35837,'544:31.19,74.12','In cave'}
G[35839]={35839,'611:67.61,64.32'}
G[35840]={34571,'611:70.78,55.08'}
G[35867]={35867,'181:55.49,52.13'}
G[35869]={35869,'611:71.40,64.43'}
G[35870]={35870,'611:70.44,65.54'}
G[35871]={35871,'611:71.40,65.73'}
G[35872]={35872,'611:68.03,64.71'}
G[35873]={35873,'611:70.20,65.85'}
G[35874]={35874,'611:71.49,61.20'}
G[35875]={35875,'544:37.62,78.03'}
G[35893]={35893,'544:35.43,75.72'}
G[35902]={35902,'101:29.08,8.08'}
G[35906]={35115,'611:55.72,80.69'}
G[35911]={35112,'611:30.37,73.12'}
G[35917]={35893,'544:34.61,66.86'}
G[36034]={36034,'101:57.46,47.72'}
G[36048]={36048,'101:58.78,46.42'}
G[36052]={36052,'101:58.45,49.85'}
G[36056]={36056,'101:58.29,50.09'}
G[36060]={36060,'101:58.59,48.74'}
G[36077]={36077,'181:50.42,74.29'}
G[36112]={36112,'544:25.28,59.84'}
G[36127]={36127,'544:23.23,67.51'}
G[36132]={36132,'545:37.41,63.24'}
G[36140]={34850,'545:35.94,66.17'}
G[36145]={4949,'544:11.77,62.72','In ship'}
G[36146]={36146,'181:45.06,75.48'}
G[36161]={4949,'544:12.41,63.14'}
G[36163]={36163,'101:71.72,45.57'}
G[36170]={35115,'545:36.51,62.26'}
G[36185]={36185,'101:40.50,95.48','Inside cave'}
G[36188]={4949,'544:35.92,66.72'}
G[36196]={36196,'750:38.2,58 101[21]:13.02,46.30>750'}
G[36205]={36205,'545:32.77,66.15'}
G[36210]={36210,'181:42.71,25.11'}
G[36290]={35115,'545:28.96,63.92'}
G[36291]={36291,'545:28.93,64.02'}
G[36296]={36296,'764[1]:39.31,52.46 H:100050320'}
G[36329]={36329,'101:36.69,71.22'}
G[36332]={35112,'545:36.41,61.25'}
G[36334]={35187,'181:55.71,14.76'}
G[36335]={35187,'181:32.97,23.55'}
G[36336]={35187,'181:62.19,21.07'}
G[36337]={35187,'181:31.06,26.77'}
G[36361]={35187,'181:55.95,12.15'}
G[36372]={36372,'181:25.59,37.96'}
G[36378]={36378,'101:36.39,71.14'}
G[36379]={36379,'181:50.53,74.74'}
G[36398]={36056,'101:72.28,67.35'}
G[36410]={36410,'101:54.24,9.28'}
G[36425]={34668,'544:36.02,67.52'}
G[36436]={36436,'181:27.92,39.91'}
G[36444]={36056,'101:82.34,80.86'}
G[36451]={34850,'545:29.03,65.05'}
G[36452]={34571,'545:37.63,65.21'}
G[36456]={36456,'545:36.89,84.17'}
G[36457]={35378,'545:37.67,72.76'}
G[36458]={36458,'545:32.52,75.49'}
G[36470]={34872,'544:44.54,64.36'}
G[36471]={34872,'544:45.36,64.75'}
G[36479]={36479,'381:49.8,16.6 381:49.9,15.4 381:49.9,16'}
G[36487]={36185,'101:73.38,73.05'}
G[36500]={36500,'181:42.22,76.09'}
G[36502]={36502,'601[1]:44.38,13.63'}
G[36594]={36594,'181:49.56,28.76'}
G[36596]={36596,'181:42.61,23.69'}
G[36600]={36600,'544:24.64,77.94'}
G[36606]={36606,'545:28.13,50.04'}
G[36608]={36608,'544:24.61,77.87'}
G[36616]={36616,'545:42.58,35.96'}
G[36624]={36624,'492:74.2,31.3'}
G[36642]={36642,'492:53.5,90.7 492:74.5,31.1'}
G[36644]={36644,'9:47.66,59.58'}
G[36648]={36648,'362:60.30,51.69'}
G[36658]={36658,'602:45.72,23.49'}
G[36666]={36666,'601[1]:45.37,14.82'}
G[36669]={36669,'504[1]:40.00,58.09'}
G[36670]={36670,'504[1]:70.05,31.44'}
G[36674]={36674,'301:41.59,47.21'}
G[36676]={36676,'181:67.08,20.53'}
G[36689]={24848,'181:71.81,16.70'}
G[36694]={36694,'890:30.92,50.58 9:46.19,82.68>890'}
G[36728]={36728,'181:14.34,65.02'}
G[36729]={34693,'181:12.52,67.45'}
G[36730]={36730,'181:14.01,64.84'}
G[36743]={35112,'545:26.44,46.91','On top of tower'}
G[36744]={36744,'181:29.38,57.61'}
G[36745]={36745,'181:34.31,44.91'}
G[36746]={36746,'181:29.11,57.94'}
G[36749]={36749,'181:29.46,57.68'}
G[36752]={36752,'181:29.52,66.84'}
G[36785]={35817,'181:14.46,75.57'}
G[36795]={36795,'181:39.14,51.77'}
G[36799]={36799,'301:27.37,24.15'}
G[36803]={36803,'890:15.62,30.24 9:41.23,76.08>890'}
G[36894]={36894,'181:34.53,44.68'}
G[36895]={36895,'181:34.46,44.74'}
G[36903]={36903,'181:14.47,65.71'}
G[36915]={36915,'610:45.23,23.35'}
G[36918]={36918,'181:10.55,69.85'}
G[36919]={36596,'181:13.86,64.49'}
G[36920]={36920,'181:41.50,53.64'}
G[36921]={36921,'181:41.39,53.93'}
G[36954]={25462,'603[1]:76.92,78.98'}
G[36955]={4968,'603:37,10.2 603:41.2,13.9 603:10.9,27.2 603:11.1,29.3 603:11.3,28.1 603:11.5,28.2 603:13,24.2 603:13.2,22.8 603:13.3,22.6 603:13.4,22.3 603:13.6,22.2 603:13.6,22.5 603:13.7,22 603:14.4,21.1 603:14.9,20.7 603:15.2,20.4 603:15.5,20.2 603:15.9,19.4 603:16.7,18.6 603:16.7,19.8 603:17.8,19.4 603:18.4,19.6 603:18.5,18.6 603:19,19.9 603:20.2,20.4 603:20.8,20.8 603:22,21.7 603:22.5,22.3 603:23.1,22.8 603:23.6,23.4 603:24.2,23.9 603:24.6,24 603:24.7,24.5 603:25.7,25.1 603:25.7,25.7 603:26.6,26.9 603:27.1,27.5 603:27.4,25.1 603:27.4,25.8 603:27.6,26 603:28,25.4 603:30.8,29 603:32.6,30.5 603:39.5,34.7 603:39.8,33.1 603:40.5,34.3 603:41.1,34.7 603:48.7,42.8 603:49.6,44.2 603:50.7,44.1 603:51,44.7 603:76,77.5 603:76.1,76.3 603:76.2,76.9 603:76.3,77 603:76.6,76.8 603:76.7,77.6 603:77.6,79.5'}
G[36956]={36956,'181:58.10,52.31'}
G[36958]={36958,'181:43.76,77.32'}
G[36959]={36959,'181:60.61,50.53'}
G[36990]={10181,'602:40.2,79.8 602:40.3,79.4 602:40.4,78.9 602:40.4,79.8 602:40.9,79.7 602:40.9,80.5 602:41,79.7 602:41.1,78.9 602:41.3,79.1 602:41.5,79.8 602:47.1,41.4 602:47.1,42.6 602:47.2,42.9 602:47.3,42.1 602:47.4,41.9 602:47.5,41.4 602:47.5,41.9 602:47.6,42.7 602:47.7,42 602:47.8,42.7 602:48.5,42.3 602:48.6,42.4 602:48.6,43.1 602:48.8,42.6 602:49.4,43.5 602:49.8,43.5 602:50,43 602:50.4,43.1 602:50.6,42.3 602:50.6,43 602:50.6,43.6 602:50.8,42.4 602:51,42.7 602:51.6,43 602:51.7,42.7 602:52,42.3 602:52.2,41.5 602:52.4,41.2 602:52.5,42.6 602:52.7,41.2 602:52.8,42 602:52.8,42.3 602:53.1,41.3 602:53.7,41.7 602:54.1,39.9 602:54.3,40.8 602:54.3,41.3 602:54.4,41.7 602:54.6,39.9 602:54.7,40.1 602:54.7,40.7 602:54.9,40.6'}
G[36993]={4968,'602:40.3,79.8 602:40.4,79.8 602:40.9,79.9 602:40.9,80 602:40.9,80.5 602:40.9,80.7 602:41.1,79.1 602:41.2,79.4 602:41.5,79.7 602:41.5,79.8 602:42,79 602:46.8,42.5 602:47.1,42.5 602:47.2,43.7 602:47.3,41.8 602:47.4,42.4 602:47.6,42.3 602:47.6,42.5 602:47.7,42.6 602:48.1,42.4 602:49,42.6 602:49.4,43 602:50,43.1 602:50,43.5 602:50.1,43 602:50.5,43.1 602:50.6,43.5 602:51.2,43.2 602:51.4,43.6 602:51.8,42.9 602:52,43 602:52.1,42.2 602:52.1,42.3 602:52.5,42.3 602:52.6,42.8 602:52.8,41.2 602:53,42.1 602:53.1,41.1 602:53.6,41.7 602:54.2,41.4 602:54.3,40.2 602:54.4,40.4 602:54.4,41 602:54.6,39.9 602:54.7,41 602:54.8,39.7 602:54.8,40.9'}
G[36999]={36999,'181:59.34,50.74'}
G[37009]={37009,'181:60.56,51.01'}
G[37024]={37024,'9:49.37,17.33'}
G[37061]={37061,'181:66.35,20.26'}
G[37064]={37064,'181:66.54,19.60'}
G[37065]={34850,'545:51.81,80.49'}
G[37081]={37081,'866:67.14,41.30 27:36.87,70.05>866'}
G[37087]={37087,'866:61.86,22.54 27:35.79,66.02>866'}
G[37102]={34571,'545:59.86,91.71'}
G[37106]={37106,'605:48.76,57.65'}
G[37113]={37113,'866:69.84,44.01 27:37.41,70.58>866'}
G[37115]={37115,'866:61.18,13.80 27:35.7,64.6>866'}
G[37120]={28444,'604:42.4,22.6 604:42.4,22.7 604:42.5,22.4 604:42.9,22.8 604:42.9,22.9'}
G[37121]={37121,'866:61.27,14.53 27:35.7,64.8>866'}
G[37135]={37135,'607:31.41,13.33'}
G[37136]={37136,'607:37.13,13.90','In tower'}
G[37137]={37137,'607:37.53,17.00'}
G[37138]={37138,'607:39.48,20.34'}
G[37142]={37142,'181:52.98,49.77'}
G[37153]={37153,'607:37.65,16.64'}
G[37154]={37154,'607:39.63,19.89'}
G[37172]={37172,'HA 321:50.79,75.25'}
G[37179]={37179,'605:47.70,57.75'}
G[37195]={35077,'545:68.71,73.25'}
G[37221]={4968,'603:39.1,13.9 603:40.3,71 603:41.3,72.2 603:41.4,73.4 603:41.6,72.3 603:42.1,72.9 603:42.2,74.5 603:42.4,73.9 603:43,74.4 603:43.1,75.5 603:43.4,75.4 603:43.6,75.4 603:43.7,75.4 603:44,75.7 603:44,76.6 603:44.8,76.2 603:44.8,76.3 603:45.1,76.8 603:45.2,76.9 603:45.5,77.9'}
G[37223]={10181,'603:38.9,70 603:40.4,70.8 603:41.5,73.1 603:41.9,74.2 603:42.1,74.7 603:42.3,74.4 603:42.5,73.3 603:42.5,74.2 603:42.7,74.2 603:42.7,75.1 603:43.1,74.8 603:43.2,75.7 603:43.5,75.3 603:43.7,75.2 603:44.3,76 603:44.3,76.1 603:44.4,76.6 603:44.8,76.4 603:44.9,76.4 603:44.9,76.5 603:45.1,77 603:45.2,77.5 603:45.5,77.2 603:45.6,77.3 603:45.6,77.5 603:45.7,78.1'}
G[37515]={37515,'607:44.33,33.29'}
G[37516]={37516,'607:44.50,33.55'}
G[37527]={37527,'499:44.4,45.4 499:44.4,45.5 499:44.5,45.4 499:44.5,45.5'}
G[37554]={10181,'603:41.2,13.9 603:12.3,25 603:12.5,24.3 603:12.9,23.5 603:13.2,22.7 603:13.3,22.4 603:13.3,22.6 603:13.5,21.3 603:13.5,21.9 603:13.6,22 603:13.6,22.5 603:14.3,21.2 603:14.9,20 603:15,20.5 603:15.3,20.4 603:15.8,19.9 603:15.9,19.4 603:16.5,19.6 603:17.1,18.4 603:17.1,18.7 603:17.8,18.9 603:19.2,18.8 603:19.8,19.1 603:20.4,19.5 603:20.5,19.1 603:21,19.6 603:21.4,20.6 603:21.6,20.1 603:22.7,21.8 603:23.1,20.9 603:23.7,21.3 603:23.9,22.8 603:24.4,23.6 603:24.5,22.5 603:26.8,25.1 603:26.8,26.5 603:26.9,26.3 603:39.4,33.9 603:40,33.9 603:40.8,35.2 603:50.4,44.4 603:50.8,43.9 603:65.4,63.3 603:74.1,73.6 603:74.7,74.2 603:75.3,74.8 603:75.9,75.4 603:76.3,76.9 603:76.5,76 603:76.6,76.2 603:76.6,77.2 603:76.7,77.6 603:76.8,77.5 603:76.9,77.2 603:77.3,78.5 603:77.7,77.1 603:77.9,78.9 603:78.3,78.2'}
G[37570]={37570,'607:50.41,40.67'}
G[37582]={37582,'601:41.1,9.4 601:41.1,9.7 601:41.2,10.1 601:41.4,8.4 601:41.4,9 601:41.5,8.5 601:41.5,10.2 601:41.6,8.6 601:41.8,9.6 601:44.4,12.2 601:63.9,90.2 601:63.9,90.7 601:64.2,90.4 601:64.3,90.5 602:40.9,80.5 602:41.1,79.6 602:41.2,79.1 602:41.3,79.1 602:41.4,80.2 602:41.5,80.2 602:41.6,80.1 602:43.9,25.8 602:44.1,25.1 602:44.2,23.2 602:44.2,23.8 602:44.2,26 602:44.2,26.7 602:44.3,25.2 602:44.5,23.1 602:44.5,23.7 602:44.5,25.4 602:44.5,25.5 602:44.8,24 602:45.2,19.9 602:45.8,19.6 602:46.4,19.4 602:47,19.1 602:47.4,19.1 602:47.6,18.9 602:48.2,18.4 602:48.3,18.4 602:48.4,18.8 602:48.6,18.4 602:48.6,18.7 602:54,39.5 602:54,40.2 602:54.1,40.5 602:54.6,39.9 602:54.9,39.5 603:29.9,57.2 603:30.1,57.7 603:30.2,57.8 603:30.3,57 603:30.4,58.5 603:30.4,58.7 603:30.7,57.1 603:30.8,57.1 603:30.8,57.9 603:31.2,57.7 603:31.3,58.8 603:33.1,61.9 603:39.5,73.6 603:39.8,74.5 603:40.1,72.5 603:40.2,72.2 603:40.2,73.6 603:40.4,73.2 603:40.5,72.1 603:40.5,72.5 603:40.7,72.8 603:40.8,71.8 603:41.3,74.4 603:41.5,72.7 603:41.7,72.9 603:42.2,73.5 603:42.3,73.8 603:42.4,75.3 603:42.5,73.8 603:42.6,74.2 603:42.7,75.2 603:43.3,75 603:43.4,75.5 603:43.9,75.3 603:44.1,75.7 603:44.3,76.2 603:44.3,76.7 603:44.9,76.3 603:44.9,76.9 603:45.2,77.9 603:45.3,76.8 603:45.5,77.3 603:45.6,77.4 603:46,79.1 603:46,79.3 603:46.6,79.3 603:46.9,79.9'}
G[37591]={37591,'602:47,61.7 602:47.3,61.3 602:47.3,61.9 602:47.4,61.1 602:47.5,61.3 602:47.6,60.8 602:54.2,40.1 602:54.3,40 602:54.4,39.3 602:54.5,40.5 602:54.7,39.7 602:54.9,39.5 602:54.9,40.7 602:55.3,39.2 602:64.9,54.9 602:65,55.5 602:65.3,54.1 602:65.4,54.3 602:65.4,54.9 602:65.4,55.9 602:65.6,55 602:65.7,54.4 602:65.7,55 602:65.9,54.2 602:66,55.7 602:66.1,55.6'}
G[37592]={37592,'602:40.9,80.5 602:41.4,79.4 602:46,63.5 602:46.4,62.7 602:46.9,61.5 602:47.3,61.7 602:47.4,61.1 602:47.4,61.3 602:47.5,60.2 602:47.5,61.1 602:47.8,61.5 602:47.8,61.9 602:48,61.1 602:54.2,40.2 602:54.3,40.1 602:54.4,40.6 602:54.5,40.5 602:54.5,40.6 602:54.7,39.9 602:54.7,40 602:65,54.9 602:65.1,54.4 602:65.1,55 602:65.1,55.5 602:65.2,54.3 602:65.6,55.1 602:65.7,54.1 602:65.8,54.2 602:65.8,55 602:65.9,55.8 602:66.1,55.5'}
G[37596]={10181,'601:63.9,90.3 601:64.1,90.9 601:64.5,90.5'}
G[37597]={4968,'601:63.8,90.2 601:63.9,90.1 601:64.1,90.8 601:64.6,90.4 601:64.6,90.5'}
G[37602]={37602,'605:59.62,76.48'}
G[37675]={37675,'HA 381:42,52 471:73,56 341:33,66 301:62.41,75.37'}
G[37679]={37679,'607:41.49,46.81'}
G[37717]={37717,'607:41.49,46.59'}
G[37724]={37724,'9:45,75.3'}
G[37737]={37737,'9:45,75.4'}
G[37776]={37776,'504[1]:44.68,71.89 504[1]:46.43,60.97'}
G[37779]={37779,'601:40.8,11.2 601:40.9,10.9 601:41.4,10.1 601:41.4,10.4 601:41.5,10.7 601:41.6,10.2 601:41.8,9.9 601:41.8,10.7 601:44.3,14.5 601:63.8,90.3 601:63.9,90.3 601:64,90.6 601:64.4,90.7 601:64.5,90.4 601:64.7,90.7 602:40.4,79.4 602:40.4,80.3 602:40.9,80.1 602:40.9,80.5 602:41,79.2 602:41,79.3 602:41,80 602:41.5,79.8 602:41.5,80.3 602:43.6,25.4 602:44,26 602:44,26.6 602:44.2,25.8 602:44.3,20.8 602:44.3,23.6 602:44.4,25.4 602:44.5,25.6 602:44.5,26.7 602:44.7,20.4 602:44.8,23.2 602:44.9,20.5 602:45.9,20.1 602:47,19.1 602:47.9,18.9 602:48,19.3 602:48.1,18.4 602:48.3,18.4 602:48.6,18.7 602:53.9,39.7 602:54.7,39.8 602:54.8,39.4 603:29.8,57 603:30.1,57.8 603:30.1,58.6 603:30.3,57.2 603:30.3,58.1 603:30.4,58.6 603:30.5,57.1 603:30.6,57.4 603:30.9,57.8 603:31.3,58.3 603:31.3,58.6 603:31.3,59.1 603:33,60.3 603:33.4,60.9 603:39.5,73.1 603:39.5,73.5 603:39.5,73.6 603:40,72.2 603:40,72.8 603:40.7,71.7 603:40.7,73.5 603:40.8,72.9 603:41,73.6 603:41.2,72.8 603:41.3,72.4 603:41.5,72.4 603:41.5,73.6 603:41.6,73 603:41.8,73.1 603:42.8,74 603:43.2,75.6 603:43.4,74.7 603:43.5,75.4 603:43.5,75.5 603:44.4,76.6 603:44.7,77.2 603:45,77 603:45.1,77.6 603:45.2,78.4 603:45.9,78.3 603:45.9,79 603:46,79.6 603:46.4,79.2 603:47.1,79.5 603:47.2,80 603:47.3,81.6 603:47.7,80.7'}
G[37780]={37780,'504[1]:52.31,22.96 504[1]:53.58,37.05 504[1]:50.14,32.54 504[1]:50.79,18.43'}
G[37783]={35378,'545:70.88,39.83'}
G[37803]={37803,'545:70.76,39.94'}
G[37811]={37811,'607:41.64,69.82'}
G[37812]={37812,'607:45.15,85.43'}
G[37815]={35378,'545:60.25,91.85'}
G[37822]={37822,'545:63.34,82.91'}
G[37834]={37834,'607:45.09,85.32'}
G[37835]={37835,'607:45.1,85.3'}
G[37837]={37679,'607:41.64,69.81'}
G[37847]={3432,'607:44.51,88.09'}
G[37873]={37873,'545:69.31,72.97'}
G[37874]={36132,'545:72.72,80.08'}
G[37876]={35112,'545:78.28,72.04'}
G[37887]={37887,'HA 301:62.52,74.96'}
G[37888]={37888,'23:10.09,65.67'}
G[37908]={37908,'607:42.61,70.22'}
G[37909]={37909,'607:41.10,71.00'}
G[37910]={37910,'607:41.64,69.42'}
G[37915]={37915,'20:83.57,69.95'}
G[37951]={37951,'891:42.82,53.45 4:62.46,84.45>891'}
G[37969]={37969,'891:45.10,85.31 4:63.24,95.34>891'}	-- 891:45.58,85.12 moves about a bit
G[37987]={37987,'891:45.72,85.01 4:45.75,85.01>891'}
G[38005]={38005,'891:56.83,63.69 4:67.24,87.95>891'}
G[38037]={38037,'891:52.55,53.70 4:65.78,84.54>891'}
G[38039]={37887,'HA 381:45.41,57.75'}
G[38040]={37887,'HA 471:73.66,57.00'}
G[38041]={37887,'HA 341:33.57,65.59'}
G[38042]={37887,'HA 321[1]:53.00,76.83'}
G[38043]={37887,'HA 480:64.43,66.51'}
G[38044]={37887,'HA 362:44.00,52.67'}
G[38045]={37887,'HA 382:66.55,38.60'}
G[38066]={38066,'HA 301:61.50,75.29'}
G[38113]={38113,'603[1]:36.48,66.89'}
G[38120]={36379,'544:45.34,65.20'}
G[38122]={34673,'544:45.25,64.86'}
G[38124]={36077,'544:45.27,65.56'}
G[38140]={38140,'607:50.74,86.82','Inside fortress dressed as cheese'}
G[38143]={38143,'545:70.66,39.71'}
G[38144]={36132,'545:49.83,56.92'}
G[38149]={35077,'545:41.94,37.60'}
G[38152]={38140,'607:50.3,87.1'}
G[38160]={4968,'601:41.9,12.8 601:42.4,13.8 601:42.7,14.6 601:43.2,13.5 601:43.3,11.9 601:43.3,13.4 601:43.3,14.7 601:43.4,12.4 601:43.4,12.9 601:43.4,13.7 601:43.5,11.8 601:43.6,12.1 601:43.8,13.7 601:43.9,13.2 601:43.9,13.3 601:44,11.3 601:44,15.8 601:44.1,11.1 601:44.1,13.9 601:44.4,14.5 601:44.4,14.8 601:44.5,11.4 601:44.5,11.9 601:44.5,12.9 601:44.6,11.4 601:44.6,14.8 601:44.7,12.4 601:44.7,13.4 601:44.8,14.1 601:44.9,14.6 601:45,15.7 601:45.2,14.1 601:45.4,15.5 601:45.5,12.3 601:45.5,13.6 601:45.5,14.1 601:45.6,13.1 601:45.6,15.2 601:45.7,13 601:45.7,15.1 601:46.1,15.7 601:46.2,15.7 601:48.8,20 601:48.9,19.4'}
G[38161]={10181,'601:43.1,13.5 601:43.3,12.4 601:43.4,10 601:43.4,12.3 601:43.4,12.5 601:43.4,12.8 601:43.4,13.6 601:43.4,14.7 601:43.5,13.2 601:43.7,13.4 601:43.7,15.7 601:43.8,11.2 601:43.8,14.2 601:44,15.5 601:44.1,12.1 601:44.1,13.6 601:44.2,11.3 601:44.2,11.9 601:44.2,14.5 601:44.4,14.5 601:44.5,11.4 601:44.5,12.2 601:44.5,12.4 601:44.7,12.5 601:44.8,15.7 601:45,14.7 601:45.1,13 601:45.2,14 601:45.3,14.7 601:45.3,15.5 601:45.4,13.5 601:45.5,12.7 601:45.5,14.9 601:45.5,15.5 601:45.6,14.1 601:45.6,14.4 601:45.7,12.4 601:45.7,13.4 601:45.8,14.9 601:45.9,15.5 601:46.5,15.3'}
G[38188]={4968,'602:39.2,15.6 602:39.2,16.5 602:39.3,15.4 602:39.3,15.7 602:39.4,15.4 602:39.4,16.5 602:39.5,15.2 602:39.7,16.2 602:39.7,16.3 602:39.8,15.3 602:40.1,16.8 602:40.1,16.9 602:40.4,17.6 602:40.5,17.3 602:40.5,17.4 602:40.8,17.8 602:41,18.1 602:41.3,18.5 602:41.4,18.7 602:41.6,18.3 602:41.6,18.4 602:41.7,19 602:41.7,19.6 602:41.9,19.3 602:42.3,19.9 602:42.5,19.4 602:42.9,20.3 602:43,19.5 602:43.2,20.9 602:43.4,20.5 602:43.5,20.5 602:43.8,21.2 602:44.2,19.8 602:44.2,21.5 602:44.4,20.3 602:44.8,20.2 602:44.9,21.7 602:45,20.3 602:45.1,20.6 602:45.2,20.7 602:45.2,21.5 602:45.6,20.5 602:45.9,19.4 602:46,19.4 602:46,20.2 602:46.4,20 602:46.6,20.5 602:46.7,20.7 602:47.2,19.4 602:47.2,19.6 602:47.4,19.3 602:47.5,19.5 602:47.8,19.2 602:48.2,18.4 602:48.2,18.9 602:48.4,18.4 602:48.5,19.1 602:48.6,18.9 602:48.7,18.3'}
G[38189]={10181,'602:39.1,15.5 602:39.2,15.6 602:39.5,16.4 602:39.7,16.2 602:40.1,16.7 602:40.5,17.3 602:40.5,17.6 602:41.2,18.4 602:41.5,18.6 602:41.9,19.5 602:42,19 602:43.3,20.2 602:43.3,20.3 602:43.4,20.5 602:43.6,19.9 602:43.9,20.1 602:44.1,20.8 602:44.5,20.5 602:45.1,20.2 602:45.1,20.4 602:45.7,19.9 602:45.8,19.8 602:46.9,19.5 602:47.2,19.3 602:47.3,19.4 602:47.3,19.5 602:47.5,19.3 602:47.5,19.5 602:47.5,19.6 602:48.3,18.4 602:48.4,19 602:48.9,18.6'}
G[38237]={38237,'201:30.62,51.15'}
G[38242]={38242,'891:50.07,52.74 4:64.94,84.21>891'}
G[38243]={38243,'891:58.06,54.04 4:67.67,84.66>891'}
G[38244]={38244,'891:52.88,49.92 4:65.90,83.25>891'}
G[38245]={38245,'891:58.05,49.25 4:67.66,83.02>891'}
G[38246]={38246,'891:59.69,52.06 4:68.22,83.68>891'}
G[38247]={38247,'891:56.39,50.09 4:67.10,83.31>891'}
G[38255]={38237,'Near201'}
G[38263]={38263,'201:76.43,48.34'}
G[38269]={38269,'201:55.72,60.60'}
G[38270]={38270,'201:55.05,60.56'}
G[38274]={38274,'201:71.01,76.60'} -- 201:71.00,76.62 201:70.08,77.47 201:70.47,76.78 201:70.90,75.65
G[38275]={38275,'201:43.2,41.6 201:43.3,41'}
G[38276]={38276,'201:43.2,41.7 201:43.3,41'}
G[38277]={38277,'201:43.2,41.7 201:43.3,41'}
G[38293]={38293,'HA 341:35.35,68.98 381:45.05,56.42 471:76.00,57.74'}
G[38294]={38294,'HK 504[1]:52.42,66.41'}
G[38295]={38295,'HA 480:64.42,70.31 382:64.30,37.55 362:44.22,55.86'}
G[38314]={38314,'607:50.30,40.40'}
G[38316]={38316,'604:39.4,21.6 604:40.1,21.4 604:40.1,21.5'}
G[38323]={38323,'607:49.9,49.6'}
G[38325]={38325,'HA 301:60.61,76.36','In inn, upstairs'}
G[38328]={38328,'HA 321[1]:57.59,60.82'}
G[38343]={38237,'Near201'}
G[38378]={38378,'607:29.8,9'}
G[38379]={38379,'607:38.79,11.39'}
G[38380]={38380,'607:35,9.5'}
G[38381]={38381,'544:52.20,73.23'}
G[38383]={38383,'607:39.06,11.44'}
G[38387]={34668,'544:45.17,64.90'}
G[38432]={34874,'544:52.20,73.14'}
G[38440]={38440,'891:58.95,66.87'}
G[38441]={38441,'544:54.16,17.20'}
G[38442]={38442,'891:58.90,23.09 4:58.91.23.08>891'}
G[38502]={38502,'201:83.50,46.00'}
G[38504]={38504,'201:53.83,62.50'}
G[38517]={34693,'544:53.72,34.93'}
G[38534]={34874,'161:51.24,29.96'}
G[38535]={38535,'161:51.21,29.92'}
G[38539]={35112,'611:32.38,57.01'}
G[38578]={38578,'161:40.25,77.17'}
G[38606]={4968,'604:38.4,20.1 604:38.4,20.7 604:39,20.1 604:39,20.5 604:39,21 604:39.1,20.4 604:39.4,21.5 604:39.7,20.4 604:39.7,20.9'}
G[38607]={38607,'604:39,20.7 604:39.3,20.6 604:39.4,20.2 604:39.4,20.3 604:39.4,21.5 604:39.9,20.8'}
G[38608]={38608,'604:39,18.6'}
G[38609]={10181,'604:38.4,20'}
G[38611]={35378,'611:38.60,60.22'}
G[38619]={38619,'607:69.26,49.09'}
G[38620]={38620,'607:67,46.6'}
G[38621]={38621,'607:64.9,46.1'}
G[38622]={38622,'607:74.00,47.50'}
G[38623]={38623,'607:71,50'}
G[38647]={38647,'544:56.56,71.95'}
G[38703]={34874,'161:71.86,45.42'}
G[38704]={38535,'161:72.20,45.22'}
G[38706]={38706,'161:55.65,60.86'}
G[38738]={37106,'544:51.79,47.10'}
G[38801]={38801,'607:66.97,46.59'}
G[38804]={38804,'607:66.9,46.7'}
G[38849]={34874,'161:44.59,52.66'}
G[38871]={38871,'607:56.1,42.7'}
G[38873]={38873,'607:56.2,42.6'}
G[38876]={38876,'607:56.2,42.7'}
G[38878]={38878,'607:61.9,42.1'}
G[38911]={38911,'892:49.20,56.32 20:31.45,65.60>892'}
G[38912]={38912,'607:56.2,42.7'}
G[38917]={38917,'606:48.43,18.97'}
G[38922]={38922,'161:33.27,77.02'}
G[38925]={38925,'20:44.74,53.65'}
G[38927]={38927,'161:42.30,23.84'}
G[38928]={34668,'544:72.86,57.04'}
G[38935]={4949,'544:36.79,43.13'}
G[38966]={38966,'891:61.55,65.85 4:61.58,65.88>891'}
G[38977]={38977,'20:61.64,34.56'}
G[38978]={38978,'20:61.60,34.39'}
G[38986]={38986,'607:50,49.5'}
G[39003]={39003,'607:49.8,50.4 607:49.8,50.5'}
G[39007]={39007,'891:60.53,62.88 4:68.51,87.67>891'}
G[39034]={39034,'161:51.79,28.06'}
G[39059]={38535,'161:50.02,82.91'}
G[39065]={35875,'544:36.27,43.36'}
G[39066]={35893,'544:33.79,38.79'}
G[39083]={39083,'607:49.1,66.9'}
G[39084]={39084,'607:49.4,67.5 607:49.5,67.5'}
G[39085]={39085,'607:49.2,67.8'}
G[39116]={39116,'382:49.49,29.65'}
G[39118]={39118,'607:43.5,78.3'}
G[39144]={39144,'141:35.49,30.08'}
G[39154]={39154,'607:43.46,78.23'}
G[39155]={39155,'607:47.2,88.5'}
G[39175]={39175,'201:44.11,40.28'}
G[39178]={39178,'161:52.25,28.07'}
G[39188]={39155,'607:49.3,86.7'}
G[39199]={36077,'Near544'}
G[39206]={39206,'889:42.11,69.51 4:42.51,69.04>889'}
G[39210]={39210,'607:38.93,10.88'}
G[39211]={39211,'607:49.20,67.80'}
G[39212]={39212,'607:66.38,47.13'}
G[39214]={39214,'889:43.39,70.65 4:42.84,69.34>889'}
G[39218]={39218,'607:49.4,86.9'}
G[39220]={39220,'607:49.6,87.1'}
G[39226]={39226,'615:56.02,13.69'}
G[39256]={39256,'81:71.8,45.4 81:71.8,45.6'}
G[39270]={39270,'4:57.91,45.13'}
G[39322]={39322,'607:68.6,49'}
G[39323]={39323,'4:49.59,40.17','On top of tower'}
G[39324]={39324,'4:35.85,41.37'}
G[39325]={39325,'4:40.49,35.36'}
G[39326]={39326,'4:42.70,49.91'}
G[39341]={39341,'544:56.30,27.32'}
G[39377]={39377,'121:41.4,15.4 121:41.4,15.5'}
G[39379]={39379,'4:45.00,14.78'}
G[39380]={39380,'4:44.90,14.82'}
G[39406]={39406,'606:90.15,56.38'}
G[39407]={39407,'121:81.54,42.44'}
G[39413]={39413,'606:89.58,59.09'}
G[39423]={39423,'4:53.10,43.14'}
G[39427]={39427,'606:35.75,19.67'}
G[39429]={39429,'606:35.69,19.43'}
G[39432]={39432,'606:28.4,30 606:28.5,29.9 606:30.1,31.7'}
G[39433]={39433,'606:30.12,31.29'}
G[39434]={39434,'606:28.17,29.88'}
G[39435]={39435,'606:28.62,30.20 606:28.29,29.98'}
G[39442]={39442,'606:76.94,62.04'}
G[39451]={39451,'606:77.05,62.15'}
G[39509]={39509,'604:40.1,21.4 604:40.1,21.5 604:40.1,21.7 604:40.7,21.1 604:40.7,21.3'}
G[39590]={39590,'4:58.82,23.16'}
G[39604]={39604,'4:56.31,20.27'}
G[39605]={25237,'321[1]:48.11,70.48'}
G[39609]={39609,'4:57.65,9.77'}
G[39621]={39621,'606:71.92,58.07'}
G[39622]={39622,''}
G[39627]={39627,'606:32.35,37.16'}
G[39638]={39638,'615:42,68 H:100062281,100062282'}
G[39640]={39640,'606:27.25,40.80',"Inside cave Gar'gol's Hovel"}
G[39642]={39642,'606:27.21,35.19'}
G[39643]={39643,'606:27.17,35.22'}
G[39646]={39646,'606:25.80,41.64'}
G[39653]={39653,'121:56.88,54.96'}
G[39656]={39656,'121:51.9,48.1'}
G[39665]={39665,'753[1]:48.01,72.21'}
G[39667]={39667,'610:53.44,43.02'}
G[39679]={39679,'753[1]:0.00,0.00'}
G[39697]={39697,'607:49.22,82.33'}
G[39723]={39723,'121:32.61,45.66'}
G[39725]={39725,'121:77.23,56.48'}
G[39738]={39738,'606:25.83,41.68'}
G[39840]={39840,'121:51.9,46.6'}
G[39847]={39847,'121:74.6,42.9'}
G[39857]={33091,'606:47.73,35.51'}
G[39858]={5769,'606:27.11,62.65'}
G[39865]={39865,'241:45.47,44.84'}
G[39869]={39869,'606:47.65,35.51'}
G[39875]={39875,'615:49.24,42.57'}
G[39876]={39876,'615:49.42,42.71 615:49.58,42.13'}
G[39877]={39877,'615:55.54,12.53'}
G[39878]={39878,'615:49.13,41.96'}
G[39881]={39881,'615:49.02,57.02 615:49.41,57.46 615:49.45,57.50 615:49.56,57.41 615:49.46,57.59'}
G[39882]={39882,'615:41.29,34.23'}
G[39883]={39667,'610:57.12,28.78'}
G[39884]={39884,'610:57.34,28.90'}
G[39887]={39887,'610:44.73,22.58'}
G[39893]={39893,'121:74.6,42.9'}
G[39894]={39894,'121:52.2,48.1'}
G[39895]={39895,'61:11.13,11.22'}
G[39896]={39896,'121:55.6,57 H:100008705,100055166,100055167'}
G[39908]={28070,'759[1]:56.16,44.02'}
G[39918]={39918,'610:49,42 H:100053053'}
G[39925]={39925,'606:64.01,22.65'}
G[39927]={39927,'606:18.98,40.94'}
G[39928]={39928,'606:19.03,37.01'}
G[39930]={39930,'606:19.22,37.89'}
G[39932]={39932,'606:13.65,32.79'}
G[39933]={39933,'606:22.26,44.92'}
G[39946]={39946,'121:86.07,45.28'}
G[39963]={39963,'61:10.55,8.53'}
G[39992]={39992,'121:88.46,44.44'}
G[40027]={40027,'61:75.90,74.61'}
G[40028]={40028,'61:75.93,74.69'}
G[40032]={40032,'121:50.69,17.15'}
G[40035]={40035,'121:51.15,17.84'}
G[40052]={40052,'121:56.96,55.38'}
G[40078]={40078,'121:57.08,53.79'}
G[40082]={40082,'61:90.07,53.01'}
G[40093]={40093,'Near606'}
G[40096]={40096,'606:44.50,18.86'}
G[40105]={36915,'610:46.33,46.92'}
G[40109]={40109,'161:40.12,76.97'}
G[40129]={40129,'121:65.88,62.86'}
G[40131]={40131,'121:65.94,62.83'}
G[40132]={40132,'121:57.24,54.98'}
G[40139]={40139,'606:56.76,18.83','In Hyjal Barrow Dens'}
G[40172]={81280,'606:22.21,44.91'}
G[40178]={38917,'606:52.13,17.42'}
G[40221]={39877,'615:64.07,42.29'}
G[40224]={5296,'121:53.2,31.8 H:100055166,100055167'}
G[40226]={40226,'121:45.34,41.26'}
G[40227]={40227,'615:41.13,34.26'}
G[40276]={40276,'610:52,40 H:100054345'}
G[40278]={40278,'606:64.06,22.49'}
G[40289]={40289,'606:62.05,24.92'}
G[40331]={40331,'606:27.06,63.01'}
G[40341]={40341,'606:24.66,55.68'}
G[40344]={40344,'141:41.87,73.88'}
G[40345]={40345,'141:41.82,73.92'}
G[40358]={40358,'141:42.82,72.43'}
G[40367]={40367,'121:77.31,56.79'}
G[40369]={40369,'121:77.2,56.5'}
G[40398]={40398,'614:72.89,37.35'}	-- this technically could be Near
G[40429]={40429,'609:68.1,55.2 609:68.3,54.3 609:68.3,54.5 609:68.3,55.7 609:68.3,56.2 609:68.4,54.1 609:68.4,54.2 609:68.4,55.1 609:68.4,55.4 609:68.4,55.7 609:68.4,55.8 609:68.4,56.6 609:68.5,56.7 609:68.6,54.1 609:68.6,55.3 609:68.6,56.5 609:68.6,56.7 609:68.7,53.7 609:68.7,57 609:68.8,54.4 609:68.8,55.8 609:68.9,55 609:68.9,55.6 609:69,55.6 609:69.1,54.2 609:69.1,54.9 609:69.1,55.7 609:69.2,55 609:69.3,53.4 609:69.5,54.2 609:69.5,55.1 609:69.6,55 609:69.6,55.7 609:69.6,55.8 609:70,55.3 609:70.2,55.3 609:70.2,55.6 609:70.5,55 609:70.6,54.9 609:70.6,55.2 609:70.6,56.3 609:70.7,54.1 609:70.7,55.1 609:71,55.6 609:71.5,54.9 609:72,55.1 609:72.6,55.1 609:74,54.6 609:74.1,53.4 609:74.2,54'}
G[40475]={40475,'61:76.49,73.63'}
G[40487]={40487,'61:77.19,74.50'}
G[40510]={40510,'615:67.2,49.6 H:100054614'}
G[40552]={40552,'381:36.61,47.85'}
G[40553]={40553,'41:55.47,50.42'}
G[40554]={40554,'61:77.98,73.32'}
G[40556]={40556,'61:78.10,73.70'}
G[40578]={40578,'606:37.22,56.18'}
G[40580]={40580,'161:42.49,24.27'}
G[40589]={40589,'161:52.56,29.05'}
G[40591]={40591,'61:78.07,73.10'}
G[40595]={40595,'61:78.23,73.64'}
G[40619]={40619,'606:95.35,51.32'}
G[40639]={40639,'615:48.99,49.20'}
G[40640]={40640,'615:39.42,58.97'}
G[40641]={40641,'615:48.99,49.12'}
G[40642]={39887,'615:49.16,56.99'}
G[40643]={40643,'615:49.18,56.95'}
G[40644]={40644,'615:49.69,57.15'}
G[40645]={40645,'615:56.98,80.55'}
G[40690]={39887,'610:45.02,23.52'}
G[40707]={40707,''}
G[40712]={40712,'686:56.75,89.18 161:39.22,21.34>686'}
G[40720]={40720,'606:37.26,56.17'}
G[40726]={40726,'61:78.12,73.09'}
G[40727]={40727,'61:78.26,73.60'}
G[40737]={39887,'610:44.4,24.8'}
G[40768]={40768,'61:79.14,71.94'}
G[40772]={40619,'606:72.22,74.69'}
G[40773]={40773,'606:71.92,74.09'}
G[40788]={40788,'767[2]:0.00,0.00'}
G[40809]={40809,'9:47.44,58.64'}
G[40816]={40816,'606:72.23,73.94'}
G[40825]={36915,''}
G[40827]={40827,'161:40.05,77.54'}
G[40833]={40833,'606:63.25,21.52'}
G[40834]={40834,'606:26.25,41.91'}
G[40837]={40837,'606:26.31,41.95'}
G[40851]={43287,'615:49.52,41.22'}
G[40852]={43287,'610:56.12,31.13'}
G[40855]={40855,'610:45.2,19.7 K:27729'}
G[40866]={43287,'614:56.90,75.53'}
G[40867]={43287,'615:48.55,57.43'}
G[40871]={43287,'615:51.41,62.43'}
G[40879]={40879,'81:72.5,61.4 81:72.5,61.5'}
G[40881]={40881,'81:70.8,62.9'}
G[40885]={40885,'61:91.63,78.55'}
G[40888]={40888,'61:91.68,79.33'}
G[40894]={40894,'43:35.3,71.2'}
G[40895]={40895,'43:35.4,71.2'}
G[40896]={40896,'81:59.5,56.9'}
G[40897]={40897,'81:59.46,56.97'}
G[40898]={40898,'81:58.97,56.36'}
G[40899]={40899,'81:58.7,56'}
G[40900]={40900,'81:58.7,56'}
G[40901]={40901,'81:73.29,56.61'}
G[40902]={40902,'81:66.23,62.93'}
G[40903]={40903,'81:65.76,63.31'}
G[40905]={40905,'81:72.2,62 H:100055181'}
G[40907]={40907,'81:66.06,64.23'}
G[40908]={40908,'81:58.5,55.3'}
G[40913]={40913,'121:76.97,56.63'}
G[40916]={40916,'615:39.1,78.6 615:39.7,54 615:51.2,63'}
G[40917]={40917,'615:39.1,78.6 615:39.6,54 615:51.2,63'}
G[40918]={40918,'615:39.5,54.7 615:51.7,62.5 615:53.9,67.1'}
G[40919]={40919,'615:29.5,78.9 615:39.1,78.6 615:40.6,75.1 615:51.6,62.7'}
G[40920]={40920,'615:39.6,53.8 615:51.3,62.4 615:51.3,62.5'}
G[40921]={40921,'615:50.3,79'}
G[40926]={35893,'81:74.44,47.66'}
G[40950]={40950,'27:53.71,52.19'}
G[40951]={40951,'27:53.70,52.10'}
G[40966]={40966,'121:50.21,16.72'}
G[40973]={40973,'81:72.5,61.4 81:72.5,61.5'}
G[40978]={40978,'615:40.56,75.28'}
G[40983]={26604,'610:57.30,29.29'}
G[40987]={40987,'610:54,50 H:100062138'}
G[40997]={40997,'606:43.54,45.88','On top floor'}
G[41003]={41003,'606:44.1,46'}
G[41005]={41005,'606:44.44,46.23'}
G[41006]={41006,'606:42.18,45.46'}
G[41017]={41017,'610:53.8,52.6 H:100055186'}
G[41023]={41023,'81:66.13,63.70'}
G[41049]={40510,'615:36.43,78.68'}
G[41050]={41050,'615:38.99,58.60'}
G[41054]={41054,'81:58.8,56'}
G[41058]={41058,'61:91.68,78.81 61:91.67,79.17'} -- first for Alliance, second for Horde
G[41060]={41060,'61:96.83,72.47'}
G[41068]={41068,'606:40.35,44.32'}
G[41071]={41071,'81:66.2,54.6'}
G[41074]={41074,'40:49.89,79.24'}
G[41075]={41075,'40:49.94,79.16'}
G[41086]={41086,'40:57.50,71.76'}
G[41124]={41124,'19:40.4,11.7 19:40.5,11.7'}
G[41125]={41125,'19:42.6,13.9'}
G[41128]={41128,'40:57.84,71.50'}
G[41129]={41129,'40:57.47,71.43'}
G[41133]={41133,'19:59.4,3.2 19:59.5,3.4 19:59.5,3.5'}
G[41134]={41134,'19:53.1,80.3 19:62.2,1.4 19:62.2,1.5'}
G[41140]={41140,'4:53.09,43.58'}
G[41159]={41159,'19:54.3,50 19:54.4,50.5'}
G[41167]={41167,'40:47.58,65.48 H:100055243'}
G[41183]={41183,'610:51.6,52 H:100054639'}
G[41184]={41184,'61:88.57,54.86'}
G[41190]={41190,'61:91.39,57.78'}
G[41204]={41204,'61:91.31,53.84'}
G[41205]={41205,'61:86.75,51.58'}
G[41214]={41214,'161:55.88,60.60'}
G[41215]={41215,'161:33.30,77.35'}
G[41227]={41227,'615:37,83 H:100062281,100062282'}
G[41229]={41229,'81:71,79.7'}
G[41233]={41233,'81:48.4,51.8'}
G[41238]={41238,'40:57.46,71.63'}
G[41239]={4949,'477:60.4,24 477:60.5,24'}
G[41240]={41240,'81:48.64,51.52'}
G[41248]={41248,'610:46.05,46.85'}
G[41252]={41252,'610:46.62,46.73'}
G[41263]={41263,'477:60.4,23.9 477:60.5,23.8'}
G[41265]={41265,'19:73.18,47.44'}
G[41276]={41276,'81:72.1,76'}
G[41277]={41277,'81:72.1,76'}
G[41278]={17246,'81:70.9,79.7'}
G[41282]={41282,'81:72.1,76'}
G[41297]={41297,'40:11.09,57.78'}
G[41298]={41298,'27:62.51,53.70'}
G[41307]={41307,'40:15.23,29.38'}
G[41308]={41308,'606:44.34,47.98'}
G[41321]={41321,'40:56.87,71.11'}
G[41322]={41322,'40:56.32,41.85'}
G[41323]={41323,'40:38.6,39'}
G[41324]={41324,'610:63.98,59.80'}
G[41325]={41325,'40:49.90,18.56'}
G[41332]={41332,'35:81.88,64.08'}
G[41340]={41324,'610:63.98,59.80'}
G[41341]={36915,'610:63.86,59.94'}
G[41344]={41252,'610:64.21,59.89'}
G[41347]={41248,'610:63.89,59.39'}
G[41350]={41350,'81:72.7,81.1'}
G[41354]={41354,'19:71.05,60.14'}
G[41363]={41363,'27:56.83,47.10'}
G[41381]={41381,'606:27.40,55.63'}
G[41383]={41383,'121:46.77,45.35'}
G[41392]={41392,'61:46.40,57.89'}
G[41402]={41402,'19:60.63,62.96 19:61.59,63.11 19:62.93,64.23'}
G[41411]={41411,'40:38.93,39.35'}
G[41412]={41412,'40:38.63,39.51'}
G[41413]={41413,'40:38.8,39.7'}
G[41415]={41415,'40:26.93,26.08'}
G[41421]={41421,'61:46.81,55.95'}
G[41426]={41426,'40:13.68,38.18'}
G[41428]={41428,'40:14.40,23.92'}
G[41433]={41433,'40:26.77,26.73'}
G[41434]={41434,'81:53.5,42.5 81:53.6,42.4'}
G[41435]={41435,'40:26.82,25.88'}
G[41441]={41441,'81:48.4,51.9 81:48.5,51.9'}
G[41444]={41444,'61:46.8,56.1'}
G[41446]={41446,'61:46.36,57.79'}
G[41456]={41456,'615:33.11,77.89'}
G[41457]={41457,'615:57.16,85.20'}
G[41476]={41476,'615:46.36,78.58'}
G[41480]={5769,'606:19.54,37.78'}
G[41482]={41482,'81:39.97,33.55'}
G[41486]={41486,'81:39.6,30.8'}
G[41487]={41487,'81:33.1,59.6'}
G[41488]={41488,'81:39.6,30.8'}
G[41492]={41492,'606:57.12,55.95'}
G[41497]={41497,'606:56.84,56.02'}
G[41498]={41498,'606:64.27,53.60'}
G[41503]={41503,'40:56.39,40.47'}
G[41504]={40341,'606:41.88,60.79'}
G[41507]={41507,'606:42.24,60.57'}
G[41530]={41530,'610:60,80.8 610:60,81.5 610:60.1,80.4 610:60.5,80.9'}
G[41531]={39875,'615:51.63,52.22'}
G[41535]={40639,'615:56.93,80.49'}
G[41540]={39887,'615:62.67,49.88'}
G[41541]={40643,'615:62.71,49.94'}
G[41578]={41578,'27:70.41,48.92'}
G[41580]={41580,'121:57.08,53.95'}
G[41598]={39887,'614:42.76,37.95'}
G[41600]={36915,'614:42.69,37.91'}
G[41612]={41612,'40:56.36,39.83'}
G[41615]={41615,'40:56.42,39.92'}
G[41618]={36915,'610:38.75,31.71'}
G[41621]={41621,'4:55.89,12.32'}
G[41636]={40917,'614:42.7,37.8'}
G[41638]={41638,'81:32.3,60.5 81:32.4,60 81:32.7,61 81:33.1,59.6'}
G[41639]={40919,'614:42.73,37.92'}
G[41640]={39881,'614:52.60,27.82'}
G[41652]={41652,'614:31.6,59.2 H:100057102,100057118'}
G[41657]={41657,'614:30,59 H:100057102,100057118'}
G[41662]={41662,'614:54.44,72.91'}
G[41663]={41663,'614:51.4,61.4 614:51.4,61.5 614:51.5,61.4 614:51.5,61.5'}
G[41664]={41664,'81:33.1,59.6'}
G[41665]={40645,'614:55.61,72.99'}
G[41666]={40639,'614:55.50,72.90'}
G[41667]={41667,'614:55.46,72.97'}
G[41668]={40921,'614:51.5,60.8'}
G[41669]={40918,'614:51.4,60.9 614:51.5,60.9'}
G[41670]={41670,'614:51.4,60.9 614:51.5,60.9'}
G[41678]={41678,'43:49.87,65.76'}
G[41711]={40917,'610:39,32'}
G[41750]={40917,'610:38.9,31.7 610:39.5,31.3'}
G[41769]={40917,'610:39.4,30.7 610:39.5,30.7 610:39.6,30.3'}
G[41770]={40918,'615:50.3,79'}
G[41786]={41786,'27:82.86,48.40'}
G[41802]={39881,'615:62.60,49.56 615:62.69,50.53'}
G[41804]={41804,'27:82.64,48.29'}
G[41810]={40917,'615:60.2,63.6'}
G[41811]={40916,'615:60.2,63.7'}
G[41813]={40919,'615:60.2,63.6 615:60.3,63.4 615:60.5,63.4 615:60.5,63.5'}
G[41853]={41853,'27:78.25,20.51'}
G[41861]={41861,'606:62.14,21.59'}
G[41863]={41863,'610:63.9,59.9'}
G[41885]={41863,'610:63.9,59.8'}
G[41908]={41908,'614:42.9,51'}
G[41910]={41910,'614:47.36,49.76'}
G[41925]={41925,'614:46,60 H:100056571,100056812'}
G[41926]={41926,'614:46,60 H:100056571,100056812'}
G[41937]={41937,'81:62,67.8 H:100056474'}
G[41944]={41944,'16:12.94,36.16'}
G[41949]={41949,'16:13.36,35.95'}
G[41966]={41966,'16:13.35,34.18'}
G[41983]={41983,'16:13.06,69.23'}
G[41990]={41990,'81:67.10,64.55','In cave'}
G[41991]={41991,'81:67.14,64.50','In cave'}
G[41992]={41992,'81:67.17,64.46','In cave'}
G[42023]={42023,'81:71.1,91.2'}
G[42028]={42028,'81:65.86,64.14'}
G[42033]={42033,'81:52.95,39.14'}
G[42039]={42039,'81:45.04,32.76'}
G[42047]={42047,'81:45.02,32.82'}
G[42050]={42050,'81:45.12,32.77'}
G[42074]={40978,'615:46.22,79.56'}
G[42076]={40640,'615:29.02,78.51'}
G[42077]={40640,'615:33.13,75.87'}
G[42088]={42088,'16:12.82,34.08'}
G[42091]={42091,'81:39.69,46.41','Top of tree'}
G[42106]={41023,'81:45.60,34.15'}
G[42114]={42114,'614:55,46 K:26124'}
G[42115]={42115,'614:57,74 K:26105'}
G[42129]={42129,'341:39.74,57.25'} -- 341:39.80,57.30
G[42130]={42130,'16:67.72,34.80'}
G[42140]={42140,'40:13.93,34.96'}
G[42160]={42160,'40:49.44,17.21'}
G[42170]={42170,'27:87.68,50.20'}
G[42197]={42197,'614:38.75,44.82'}
G[42224]={42224,'27:38.9,33.4 27:39.2,33.9 27:39.5,34.2 27:39.8,32.1 27:39.9,31.2 27:39.9,33.3 27:40.6,33 27:40.9,31.7 27:41.2,30.6'}
G[42256]={42256,'30:81.85,66.05'}
G[42262]={42262,'19:60.20,13.39'}
G[42264]={42264,'19:60.47,13.82'}
G[42288]={42288,'301:50.56,71.87'}
G[42298]={42298,'19:62.25,26.32'}
G[42299]={42299,'19:55.12,49.58'}
G[42308]={42308,'39:60.05,19.28'}
G[42317]={42317,'895:38.71,32.82 27:33.63,36.45>895'}
G[42323]={42323,'27:33.89,34.78>895 895:39.41,28.39'}
G[42324]={42324,'27:34.28,37.51>895 895:40.68,35.73'}
G[42331]={42331,'27:34.53,35.06>895 895:41.09,29.14'}
G[42333]={42333,'768[1]:54.06,38.61'}
G[42334]={42334,'19:34.68,67.80 H:100008244,100010593'}
G[42342]={42342,'39:40.52,47.96'}
G[42344]={42344,'19:49.8,71.5'}
G[42348]={42348,'19:47.2,69.1'}
G[42349]={42349,'19:46.36,87.18'}
G[42352]={42352,'19:43.9,87.8 19:44,87.1 19:44.4,86.1 19:44.9,86.2 19:45.1,86.5 19:45.4,88.1 19:45.8,88.3 19:46,88.5 19:46.1,86.5 19:46.2,85.1 19:46.4,86.2 19:46.5,85.4 19:46.5,85.6 19:47.2,88.2 19:47.2,89 19:47.3,87.2 19:47.5,88.6 19:47.6,88.4'}
G[42353]={42353,'895:48.74,52.88 27:37.43,44.04>895'}
G[42366]={38535,'895:38.03,33.56 27:33.38,36.74>895'}
G[42396]={42396,'895:39.50,38.39 27:33.93,38.56>895'}
G[42405]={42405,'39:49.65,19.39'}
G[42406]={42406,'39:49.8,18.8'}
G[42410]={40917,'613:64.5,68.7'}
G[42411]={39887,'613:69.61,75.34'}
G[42425]={42425,'39:42.10,64.13'}
G[42426]={42426,'39:42,63.4'}
G[42443]={29611,''}
G[42464]={42464,'26:77.30,79.97'}
G[42465]={42465,'640:56.34,12.15 640:56.29,13.31 640:56.13,12.91'}
G[42466]={42466,'640:39.94,19.36'}
G[42467]={42467,'640:56.51,42.65'}
G[42469]={42469,'640:34.18,34.29'}
G[42472]={42472,'640:72.22,53.99'}
G[42489]={42489,'895:38.39,33.49 27:33.51,36.71>895'}
G[42491]={42491,'895:38.21,33.67 27:33.44,36.78>895'}
G[42497]={42497,'39:49.5,19.2'}
G[42498]={42498,'39:49.58,19.60'}
G[42506]={42506,'321[1]:56.53,62.49'}
G[42536]={42536,'26:72,51 H:100008704'}
G[42553]={42553,'895:40.61,28.08 27:34.36,34.66>895'}
G[42555]={42555,'26:73,50 H:100008704'}
G[42558]={42308,'39:49.74,19.50'}
G[42573]={42573,'640:49.49,53.35'}
G[42574]={42574,'640:46.53,57.29'}
G[42575]={42575,'39:56.97,47.10'}
G[42600]={3057,''}
G[42609]={42609,'26:73.2,53.6 H:100008704'}
G[42611]={42611,'895:39.23,26.56 27:33.83,34.09>895'}
G[42612]={42612,'26:78.04,78.11'}
G[42613]={42613,'26:78.17,81.31','Upstairs'}
G[42614]={42466,'640:64.13,36.88'}
G[42618]={42618,'891:50.03,49.94 4:64.92,83.25>891'}
G[42622]={42622,'26:67.64,66.60'}
G[42624]={42624,'26:67.78,66.29'}
G[42630]={42630,'895:38.20,40.21 27:33.4,39.2>895'}
G[42637]={25272,'321[1]:47.95,71.03'}
G[42640]={42640,'181:60.19,50.43'}
G[42641]={42641,'181:60.15,50.39'}
G[42642]={42642,'26:67.81,66.51'}
G[42643]={42643,'181:54.54,51.17'}
G[42651]={23975,'39:42.98,65.01'}
G[42672]={42672,'181:26.16,78.84'}
G[42677]={42677,'39:42.4,69.4 H:100058117'}
G[42684]={42684,'640:62.38,47.73 640:62.17,46.64 640:61.87,45.04 640:61.53,44.00 640:62.05,37.59 640:63.95,45.86 640:64.33,49.31 640:65.05,52.76 640:62.46,53.13','Flying around on a gunship'}
G[42708]={42708,'895:37.28,65.21 27:33.09,48.69>895'}
G[42730]={42730,'640:46.1,45.7'}
G[42731]={42731,'640:46.16,45.74'}
G[42736]={42736,'37:33.72,37.16'}
G[42750]={234,'39:56.24,47.69'}
G[42752]={878,'382:70.4,47 605:69.9,79.7 605:70.4,79.1 615:51.1,63.2 614:42.6,37.7'}
G[42790]={42790,'37:47.20,10.65'}
G[42811]={42811,'37:63.25,38.77','Upstairs'}
G[42812]={42812,'37:63.46,39.04'}
G[42813]={42813,'37:63.29,39.82'}
G[42814]={42814,'37:63.43,41.07'}
G[42896]={42896,'26:31.82,58.55'}
G[42898]={42898,'26:31.87,58.39'}
G[42899]={42899,'640:56.52,41.05'}
G[42928]={38607,'341:39.21,56.06'}
G[42933]={42933,'27:49.91,44.98'}
G[42936]={42936,'381:43.91,76.16'}
G[42968]={36132,'41:55.23,89.19'}
G[42975]={42975,'765[1]:73.00,20.60'}
G[42978]={42978,'700:82.50,49.83'}
G[42983]={42983,'30:41.72,64.64'}
G[43000]={43000,'30:81.83,66.55'}
G[43006]={43006,'888:47.38,59.70 41:58.39,35.54>888'}
G[43009]={43009,'480:81.15,37.63'}
G[43010]={43010,'893:64.93,42.38 462:39.3,20.2>893'}
G[43042]={43042,'37:52.64,66.10'}
G[43043]={52646,'673:55.74,41.22'}
G[43045]={52753,'37:47.86,11.86'}
G[43062]={43062,'321[1]:51.30,55.98'}
G[43063]={43063,'43:49.45,67.09'}
G[43065]={43065,'640:49.62,52.94'}
G[43071]={43071,'640:27.92,68.71'}
G[43072]={43072,'36:77.8,65.8'}
G[43073]={43073,'182:43.58,28.70'}
G[43079]={43079,'182:44.29,61.87'}
G[43082]={43082,'640:60.80,38.99 640:61.33,38.33 640:62.25,38.03 640:64.10,46.81 640:64.64,51.41','In the main cabin on a gunship'}
G[43086]={43086,'38:72.03,12.05'}
G[43087]={43087,'38:70.04,38.56'}
G[43088]={43088,'38:30.78,34.61'}
G[43095]={34668,'673:34.69,29.54'}
G[43096]={43096,'673:33.65,29.18'}
G[43097]={43097,'673:35.1,27.6'}
G[43098]={43098,'673:34.6,27.9'}
G[43099]={43099,'673:46.23,28.15'}
G[43107]={43107,'19:47.13,89.35'}
G[43108]={43108,'26:66.3,44.3'}
G[43109]={43109,'26:66.3,44.3'}
G[43116]={43116,'Near640'}
G[43124]={43124,'20:58.84,51.93'}
G[43156]={43156,'26:63.8,60'}
G[43157]={43157,'26:63.9,59.8'}
G[43158]={43158,'640:69.95,60.09 H:100060816'}
G[43160]={43160,'640:28.21,69.62'}
G[43168]={43168,'640:24.52,62.41'}
G[43169]={43169,'640:24.74,62.18'}
G[43184]={43184,'36:26.29,40.12'}
G[43185]={43185,'36:17.94,18.62'}
G[43187]={43187,'700:78.85,51.75'}
G[43190]={43190,'700:73.76,53.86'}
G[43191]={43191,'700:76.53,49.47'}
G[43193]={42641,'700:82.59,49.93'}
G[43194]={43194,'36:29.66,44.55'}
G[43200]={43200,'26:30.7,47.1'}
G[43221]={43221,'36:28.66,40.72'} -- 36:28.66,40.74 36:28.89,40.90
G[43239]={43239,'321[1]:65.69,41.08'}
G[43270]={43270,'36:47.52,41.95'}
G[43272]={43272,'36:33.55,11.85'}
G[43274]={43274,'36:25.90,10.49'}
G[43275]={43275,'36:28.31,16.95'}
G[43278]={43278,'864:34.82,54.79 30:48.55,42.57>864'}
G[43287]={43287,'610:42.42,66.13'}
G[43289]={43287,'615:57.11,75.16'}
G[43290]={43290,'615:57.05,17.05'}
G[43295]={43295,'613:69.48,75.32'}
G[43298]={43298,'26:34.4,67.9 26:34.5,68.1'}
G[43299]={43299,'26:35.65,68.46'}
G[43300]={43270,'Near36'}
G[43302]={43275,'Near36'}
G[43303]={43274,'Near36'}
G[43305]={43272,'Near36'}
G[43319]={43319,'640:24.61,62.18'}
G[43327]={43327,'36:50.60,42.83'}
G[43329]={43329,'36:51.81,40.08'}
G[43344]={43344,'640:34.08,35.23 640:34.56,34.48 640:34.51,33.31'}
G[43371]={43371,'36:52.8,54.6'}
G[43395]={43395,'640:71.79,47.59'}
G[43397]={43397,'640:49.68,52.94'}
G[43438]={43438,'768[1]:62.60,65.06'}
G[43442]={43442,'640:68.47,26.36'}
G[43453]={35618,'34:79.07,44.19'}
G[43454]={43454,'673:41.33,61.23 H:100059143'}
G[43455]={43455,'866:61.23,17.47 27:35.7,65.4>866'}
G[43458]={43184,'36:52.55,55.42'}
G[43459]={43270,'36:52.43,55.54'}
G[43461]={43274,'36:52.41,55.41'}
G[43462]={43275,'36:52.54,55.56'}
G[43504]={43504,'673:43.84,56.53'}
G[43508]={43508,'36:53.05,67.78'}
G[43546]={43272,'36:70.26,60.14'}
G[43549]={43549,'606:71.60,75.35'}
G[43556]={43556,'673:46.65,93.68','Pacing on deck'} -- 673:46.83,94.37 673:46.68,92.97 673:46.67,95.30 673:46.79,94.63
G[43570]={43570,'26:65.77,44.88'}
G[43581]={43190,'700:76.59,49.52'}
G[43607]={43275,'36:77.63,65.33'}
G[43611]={43184,'36:77.68,65.52'}
G[43661]={43661,'673:44.72,92.77'}
G[43690]={43690,'301:61.99,31.21'}
G[43693]={43693,'301:77.43,67.70'}
G[43697]={43697,'34:21,56.6'}
G[43701]={43701,'27:53.81,52.76'}
G[43702]={43702,'27:75.8,54.4'}
G[43727]={35378,'545:41.64,36.51'}
G[43730]={43730,'34:18.32,57.66'}
G[43731]={43731,'34:20.02,57.82'}
G[43733]={43221,'36:77.20,65.91'}
G[43738]={43738,'34:44.92,67.42'}
G[43769]={43769,'301:70.23,73.36'}
G[43792]={42465,'640:49.74,53.30'}
G[43795]={43795,'362:63.2,79.8'}
G[43804]={42472,'640:57.35,12.53 640:59.36,14.24'}
G[43805]={43805,'640:56.07,14.38'}
G[43806]={42466,'640:54.6,14.3 640:55.4,13.1 640:55.5,13.1 640:56.5,13.4 640:56.6,14.1'}
G[43809]={42730,'640:56.06,13.46'}
G[43812]={43184,'36:58.57,55.65'}
G[43818]={43065,'640:49.6,53'}
G[43835]={42730,'640:49.27,52.80'}
G[43837]={43837,'640:49.4,52.8 640:49.8,52.7'}
G[43849]={43849,'673:42,73.6'}
G[43861]={311,'34:18.35,58.04'}
G[43870]={43870,'362:75.32,27.66'}
G[43881]={43881,'362:25.24,13.82'}
G[43884]={43884,'37:47.13,10.56'}
G[43885]={43885,'37:47.67,10.35'}
G[43886]={43886,'37:47.98,12.01'}
G[43897]={43897,'640:22.68,52.02'}
G[43898]={43898,'640:22.76,52.10'}
G[43929]={43929,'Near H:100097985'}
G[43943]={25237,'700:74.79,53.06'}
G[43991]={43991,'464:49.71,49.10'}
G[44010]={42684,'640:64.47,82.13'}
G[44017]={44017,'37:53.46,66.75'}
G[44018]={44018,'37:53.37,66.30'}
G[44019]={44019,'37:53.21,66.93'}
G[44021]={44021,'37:52.66,66.81'}
G[44024]={44024,'700:73.80,53.93'}
G[44025]={42465,'640:63.32,25.03'}
G[44028]={44028,'34:20.32,27.63'}
G[44036]={44036,'462:43.96,69.97'}
G[44042]={43187,'700:74.28,53.29'}
G[44043]={44043,'37:53.06,66.20 37:52.81,66.77'}
G[44080]={44080,'640:62.61,26.92'}
G[44082]={44082,'673:55.24,42.49'}
G[44083]={44083,'673:55.41,42.19'}
G[44084]={44084,'673:55.63,42.22'}
G[44098]={44098,'34:18.08,25.32'}
G[44099]={44099,'673:55.30,41.93'}
G[44100]={44100,'673:55.01,42.26','Walks in area'} -- 673:55.04,41.85 673:55.02,42.43 673:54.76,42.40
G[44112]={44112,'673:42.43,73.22'}
G[44143]={44143,'640:27.59,44.84'}
G[44169]={43190,'700:75.30,54.85'}
G[44200]={44200,'35:25.40,17.80'}
G[44204]={44204,'640:28.00,68.64'}
G[44216]={44216,'680[1]:70.43,11.40'}
G[44217]={44217,'680[1]:68.62,11.84'}
G[44222]={44222,'640:64.4,82.2 640:64.5,82.2'}
G[44230]={44230,'23:61.64,43.84'}
G[44231]={44231,'23:52.77,53.57'}
G[44232]={44232,'23:34.90,67.89'}
G[44233]={44233,'23:18.46,27.37'}
G[44238]={26814,'301:85.81,25.95'}
G[44247]={44247,'301:78.94,71.17'}
G[44293]={1747,'Near301'}
G[44303]={44303,'607:66.96,46.59'}
G[44345]={44345,'35:34.80,49.11'}
G[44365]={10181,'21:57.36,10.19'}
G[44372]={44372,'640:47,89.4'}
G[44374]={44374,'161:33.21,76.90'}
G[44375]={44375,'688[1]:48.20,13.10 43:16.52,11.03>688'}
G[44387]={44387,'688:31.1,67.5 688:31.2,65.7 688:31.4,66.5 688:31.5,66.4 688:31.5,66.5 688:32.2,67.9 688:32.4,68.5 688:32.5,65.7 688:32.5,67 688:32.5,68.4'}
G[44395]={35873,'301:57.48,24.90'}
G[44402]={44402,'761[1]:67.46,82.77'}
G[44407]={44407,'17:64.34,35.04'}
G[44409]={44409,'17:48.99,36.20'}
G[44410]={44410,'17:21.71,57.80'}
G[44415]={44415,'761[1]:19.92,35'}
G[44441]={28179,'22:41.99,14.73','Top of keep'}
G[44451]={10181,'22:49,63.7'}
G[44452]={26581,'22:47.77,65.19'}
G[44453]={26170,'22:41.07,70.45'}
G[44454]={44454,'22:49.27,54.91'}
G[44456]={44456,'22:48.87,54.78'}
G[44457]={44457,'22:48.53,54.90'}
G[44458]={44458,'22:50.65,52.57'}
G[44462]={44462,'22:47.31,64.41'}
G[44466]={44466,'22:47.58,65.56'}
G[44467]={44467,'22:41.26,70.07'}
G[44471]={44471,'22:41.01,70.49'}
G[44472]={44472,'22:48.43,31.95'}	-- 22:48.21,31.79 22:48.60,32.11
G[44490]={39887,'614:69.75,34.42'}
G[44540]={40917,'614:69.7,34.4 614:69.7,34.5'}
G[44556]={44556,'691[1]:63.02,33.41'}
G[44560]={44560,'691[2]:65.19,47.05'}
G[44561]={44561,'691[3]:23.90,39.07'}
G[44563]={44563,'691[4]:34.53,19.82'}
G[44566]={44566,'767[2]:0.00,0.00'}
G[44615]={44615,'21:57.42,10.14'}
G[44618]={44618,'35:78.56,76.25','In cave'}
G[44635]={44635,'35:73.29,35.98'}
G[44637]={44637,'762:38.7,31.1 762:75.8,79.3 762:75.9,80.4 762:76,80.7'}
G[44640]={44640,'21:57.52,10.49'}
G[44660]={44637,'762:65.2,73.7 762:20.1,14.2 762:20.1,14.9 762:20.1,15.5 762:20.4,16.5 762:20.4,17.9 762:20.5,16 762:20.6,15.4'}
G[44690]={44637,'762:67,33.3 762:60.6,93.9'}
G[44706]={44637,'762:32.7,55.9 762:49.1,86.9'}
G[44725]={44725,'321[1]:45.20,53.69'}
G[44726]={44726,'321[1]:44.79,51.56'}
G[44728]={44728,'762:38.7,31.1 762:75.8,78.7 762:75.8,79.9 762:76,80.5'}
G[44735]={44735,'321[1]:45.50,53.77'}
G[44738]={44728,'762:65.2,73.8'}
G[44741]={44741,'762[3]:63.38,94.15'}
G[44746]={44746,'762:32.7,54.1 762:47.9,73.5 762:48.9,72 762:48.9,73.2 762:48.9,73.5 762:48.9,74.7 762:48.9,75.6 762:49.5,74.1'}
G[44749]={44749,'301:33.10,39.50'}
G[44778]={44778,'21:56.77,9.19'}
G[44784]={44784,'21:56.27,8.40'}
G[44789]={44789,'21:58.09,8.99'}
G[44799]={44799,'640:47.31,51.40'}
G[44800]={44800,'762:66.8,77.1 762:44.3,64.3 762:44.3,64.9 762:45,66.7 762:45.2,63.7 762:45.2,64.8 762:45.2,66 762:45.5,65.8 762:45.5,67 762:45.6,65.2'}
G[44802]={44802,'640:47.32,51.36'}
G[44804]={44800,'762[3]:66.91,83.75'}
G[44805]={44800,'762:32.7,52.8 762:48.3,64.2 762:48.8,64.3 762:48.9,67.5 762:49.1,65.4 762:49.1,66.1 762:49.1,66.7 762:49.5,64.8 762:49.6,64.1'}
G[44806]={44806,'301:34.77,38.22'}
G[44807]={44807,'301:52.00,5.81'}
G[44818]={44818,'640:51.28,50.00'}
G[44823]={44823,'640:51.29,50.05'}
G[44833]={39667,'161:30.49,65.51'}
G[44837]={44837,'760[1]:24.52,23.72 61:47.56,23.60>760'}
G[44853]={44853,'321:48.4,83.3 321:48.5,83.2'}
G[44859]={44859,'35:82.79,63.45'}
G[44860]={26814,'720:64.38,22.33'}
G[44866]={44866,'321[1]:54.03,73.30'}
G[44870]={44870,'35:58.53,29.10'}
G[44871]={44871,'321:53.3,74.3 321:53.3,74.5 321:53.7,74.1 321:54,73.4'}
G[44905]={44458,'22:42.65,14.96','Top of keep'}
G[44912]={44912,'21:44.79,20.91'}
G[44916]={44916,'21:44.02,21.36'}
G[44917]={44917,'21:43.99,21.29'}
G[44919]={44919,'321[1]:48.92,59.24'}
G[44927]={44927,'890:30.83,49.46 9:46.15,82.31>890'}
G[44929]={44929,'686:58.27,88.68 161:39.22,21.34>686'}
G[44943]={44943,'673:46.68,95.32'}
G[44945]={44945,'640:55.36,14.16'}
G[44968]={29428,'640:61.38,26.17'}
G[44969]={44969,'699[5]:11.13,38.78 121:64.84,30.26>699'}
G[44971]={44971,'699[5]:7.04,36.13 121:64.84,30.26>699'}
G[44973]={43442,'640:59.60,14.04'}
G[44978]={44978,'321[1]:34.98,67.83'}
G[44991]={40052,'699[2]:90.65,44.86 121:60.32,30.15>699'}
G[44999]={44999,'699[2]:87.41,52.39 121:60.32,30.15>699'}
G[45009]={2784,'341:40,55'}
G[45012]={45012,'22:50.49,52.71'}
G[45013]={45013,'22:49.3,53.2'}
G[45040]={45040,'699[1]:71.67,91.95 121:62.49,24.90>699'}
G[45042]={4949,'737:33.36,50.18'}
G[45043]={45043,'640:20.71,61.58'}
G[45046]={25237,''}
G[45052]={45052,'699:71.3,91.2 699:71.3,93.2 699:71.4,92.4 699:71.6,92.4 699:71.6,92.5 699:71.9,91.2'}
G[45098]={45098,'22:38.8,55.3'}
G[45107]={45107,'763[1]:46.20,51.84 22:69.06,73.00>763'}
G[45108]={45108,'763[1]:47.32,51.76 22:69.06,73.00>763'}
G[45109]={45109,'763[1]:46.03,58.48 22:69.06,73.00>763'}
G[45110]={45110,'763[1]:47.30,58.41 22:69.06,73.00>763'}
G[45129]={44471,'22:39.4,70.6 22:39.6,70.4 22:39.6,70.5'}
G[45137]={45137,'321[1]:35.58,69.11'}
G[45147]={45147,'22:42.37,15.20'}
G[45149]={45149,'22:44.82,12.53'}
G[45155]={45155,'22:57.39,35.63'}
G[45157]={45157,'22:43.21,15.93'}
G[45165]={45165,'22:42.70,84.11'}
G[45167]={21330,'700:79.09,78.29'}
G[45168]={44806,'700:77.01,69.86'}
G[45169]={45169,'700:76.76,69.83'}
G[45170]={45170,'700:79.29,78.53'}
G[45171]={45171,'700:76.02,79.70'}
G[45172]={45172,'700:67.67,65.96'}
G[45173]={45173,'700:79.43,77.64'}
G[45180]={26814,'720:64.56,28.60'}
G[45186]={45186,'720:64.63,28.67'}
G[45195]={45195,'21:45.2,48.3 21:45.2,51.4 21:45.3,49.2 21:45.8,53.6 21:45.9,53.4 21:46.1,51.4 21:46.2,49.4 21:46.2,49.5 21:46.4,51.5 21:46.4,54.6 21:46.7,52 21:46.8,51 21:46.9,52.6 21:47,45.7 21:47,48.5 21:47,49.5 21:47.3,47 21:47.3,48 21:47.4,53.5 21:47.4,55.2 21:47.5,55.4 21:47.5,55.5 21:47.6,50.4 21:47.7,51 21:47.9,51.6 21:47.9,54.3 21:48.4,53.3 21:48.5,50.1 21:48.5,50.5 21:48.8,52.2 21:48.8,53.7 21:49.3,53.2'}
G[45200]={16115,'765[1]:66.25,86.69 23:27.07,15.77>765'}
G[45201]={45201,'765[1]:65.25,87.16 23:27.07,15.77>765'}
G[45202]={45202,'720:65,30 K:27187'}
G[45206]={16112,'765[2]:67.92,72.09 23:43.45,19.36>765'}
G[45226]={45226,'301:74.54,19.03'}
G[45228]={45228,'21:55.89,46.35'}
G[45244]={45244,'321[1]:50.46,38.36'}
G[45254]={45254,'21:59.27,34.41'}
G[45257]={45257,'19:60.7,28.1 H:100008244,100010593'}
G[45258]={45258,'19:60.6,75.4 H:100008244,100010593'}
G[45260]={45260,'19:31.4,69.5 H:100008244,100010593'}
G[45262]={45262,'19:32.2,44 H:100008244,100010593'}
G[45271]={45271,'61:44.63,50.01'}
G[45277]={45277,'61:42.17,48.39'}
G[45278]={45278,'61:42.17,48.39'} -- I cheated and copied from 45277
G[45296]={26814,'720:64.50,28.00','Down in Chamber of the Stars'}
G[45301]={45301,'684:56.51,18.13 H:100060956'}	-- 545:51,17
G[45306]={45306,'301:62.99,34.07'}
G[45312]={44789,'684:57.47,18.94'}
G[45315]={45315,'684:57.54,18.23'}
G[45320]={45320,'321:45.3,10.6 321:48.4,89.4 321:48.4,89.7 321:48.4,90.5 321:48.5,89.4 321:48.5,89.7'}
G[45323]={45323,'765[1]:66.98,89.33 23:27.07,15.77>765'}
G[45328]={45323,'765[2]:67.62,82.30 23:43.45,19.36>765'}
G[45329]={16115,'765[2]:68.04,72.69 23:43.45,19.36>765'}
G[45330]={16116,'765[2]:67.11,72.62 23:43.45,19.36>765'}
G[45331]={45201,'765[2]:68.64,73.13 23:43.45,19.36>765'}
G[45332]={42730,'700:44.04,10.55'}
G[45337]={45337,'321[1]:49.18,70.93'}
G[45339]={45339,'321[1]:48.15,72.94'}
G[45340]={45340,'756[1]:44.77,82.41'}
G[45347]={45347,'321[1]:37.92,87.61'}
G[45362]={42573,'700:44.20,18.13'}
G[45386]={42573,'700:43.83,11.33'}
G[45389]={45389,'684:65.64,34.10'}
G[45391]={39875,'700:44.00,11.24'}
G[45400]={45400,'23:8.82,66.59'}
G[45412]={45412,'765[2]:39.13,20.31'}
G[45417]={45417,'23:9.02,66.52'}
G[45428]={45428,'23:4.14,36.02'}
G[45429]={45429,'23:18.37,74.85'}
G[45430]={45430,''}
G[45431]={45428,'23:74.36,53.33'}
G[45432]={42574,'700:44.41,11.56'}
G[45442]={45442,'61:39.15,25.76'}
G[45451]={45451,'23:35.71,69.31','Tower top, moving around tower'}
G[45460]={39875,'613:64.4,68.7 613:64.5,68.7'}
G[45462]={39877,'613:69.8,75.2'}
G[45474]={44789,'Near684'}
G[45482]={45482,'23:51.63,21.41'}
G[45500]={45500,'23:35.02,68.15'}
G[45518]={45518,'700:29.30,25.99'}
G[45522]={45522,'700:29.85,31.28'}
G[45525]={10181,'21:51.77,66.05'}
G[45528]={45528,'700:29.33,25.97'}
G[45530]={25237,'321:32.2,37.8 321:32.7,37.7 321:33.5,37.9'}
G[45540]={45540,'321[1]:36.92,87.48'}
G[45562]={45562,'700:29.80,31.42'}
G[45574]={45574,'23:52.77,51.38'}
G[45575]={45575,'23:53.79,53.99','Tower top'}
G[45617]={10181,'21:51.90,65.01'}
G[45626]={45626,'21:51.89,64.73'}
G[45631]={44640,'21:51.70,66.55'}
G[45658]={45658,'700:45.27,75.36'}
G[45665]={45665,'700:45.32,75.35'}
G[45668]={21330,'700:43.36,57.35'}
G[45669]={45669,'700:43.41,57.34'}
G[45675]={45675,'700:36.37,65.96'}
G[45728]={45728,'24:31.4,37.4 H:100061310'}
G[45729]={45429,'23:75.77,52.41'}
G[45730]={45428,'23:28.46,25.91'}
G[45735]={45735,'23:61.58,43.13'}
G[45736]={45736,'23:61.32,42.86'}
G[45752]={45752,'21:58.06,69.91'}
G[45772]={45772,'720:45.2,37.8'}
G[45786]={45786,'38:73.16,14.90'}
G[45796]={332,'700:36.37,65.95'}
G[45799]={45799,'720:45.25,37.96'}
G[45816]={45816,'23:48.00,23.04'}
G[45817]={45817,'704:46.7,65.3 704:46.8,65.9'}
G[45818]={45818,'704:44,77 704:44.3,77.6 704:44.5,76.9 704:44.8,78.2'}
G[45820]={45820,'704:40.3,67.1 704:40.9,66.4 704:40.9,67.4 704:41,67.5 704:41.5,93.2'}
G[45821]={45821,'704:35.9,77.5 704:36,77.4 704:36.2,76.2'}
G[45823]={45823,'704:35.4,77.8 704:35.9,77.6 704:36,77.3 704:36.1,78.7 704:36.5,78.5 704:36.6,77 704:36.6,78.4'}
G[45824]={45824,'704:51.3,52.2 704:51.3,53.2'}
G[45826]={45826,'23:50.00,19.52'}
G[45828]={45828,'23:17.74,27.88'}
G[45831]={45831,'23:27.65,20.85'}
G[45839]={45839,'704:36.3,74.1 704:36.4,75.4 704:36.4,75.5 704:36.5,75.5 704:36.6,74.9'}
G[45840]={45840,'704:58.1,22.4 704:58.1,22.5 704:58.5,23 704:58.6,21.9'}
G[45849]={45849,'704[1]:37.37,80.07 29:14.58,9.21>704'}
G[45850]={45850,'704[1]:35.99,81.00 29:14.58,9.21>704'}
G[45867]={45867,'23:25.39,19.79 H:100061378'}
G[45868]={45868,'23:29.42,19.66 H:100061378'}
G[45874]={45874,'720:63.44,32.49'}
G[45878]={35115,'Z21'}
G[45879]={45879,'Z21'}
G[45880]={45880,'Z21'}
G[45888]={45888,'704[2]:46.89,66.13 29:14.58,9.21>704'}
G[45890]={45890,'704[2]:58.07,22.25 29:14.58,9.21>704'}
G[45891]={9177,'704[1]:36.72,74.59 29:14.58,9.21>704'}
G[45892]={45892,'704[1]:36.19,77.28 29:14.58,9.21>704'}
G[45894]={45894,'704[1]:40.95,67.21 29:14.58,9.21>704'}
G[45896]={45896,'21:47.4,77.6 H:100061505'}
G[45898]={45898,'704[1]:44.29,77.79 29:14.58,9.21>704'}
G[45899]={45899,'704[2]:50.77,52.68 29:14.58,9.21>704'}
G[45903]={45903,'704[1]:36.06,77.68 29:14.58,9.21>704'}
G[45948]={45948,'38:84.02,40.12'}
G[45966]={42396,'27:25.76,31.95 27[10]:34.07,32.19'}
G[45982]={45982,'700:70.24,43.26'}
G[45983]={45983,'700:70.31,43.39'}
G[46003]={46003,'720:40.00,40.55'}
G[46006]={46006,'22:39.44,69.54'}
G[46010]={46010,'38:73.64,9.16'}
G[46011]={46011,'22:50.50,52.23'}
G[46022]={46022,'23:73.81,52.36'}
G[46071]={27785,'38:69.47,54.52'}
G[46077]={27785,'687[1]:49.99,17.15 38:69.68,53.45>687'}
G[46089]={46089,'700:78.24,62.54'}
G[46090]={46090,'700:78.46,62.60'}
G[46124]={10181,'21:45.32,84.47'}
G[46125]={44640,'21:45.34,84.35'}
G[46126]={46126,'720:63.6,32.6 K:27627'}
G[46127]={46127,'720:66.6,27.6 K:27627'}
G[46128]={46128,'720:65.6,32.8 K:27627'}
G[46129]={46129,'720:64.2,27.2 K:27627'}
G[46134]={46134,'720:58.88,46.07'}
G[46135]={46135,'720:54.18,41.88','Inside the dam'}
G[46136]={46136,'720:56.62,54.93 720:56.73,53.84 720:56.49,53.26 720:56.28,53.53 720:55.98,53.96'}
G[46138]={46138,'23:77.54,79.35'}
G[46143]={46143,'700:45.92,65.43'}
G[46172]={46172,'38:69.07,76.50'}
G[46174]={46174,'700:45.78,71.73 700:47.88,74.55'}
G[46175]={46175,'700:53.07,74.59 700:52.89,74.56 700:52.97,74.26 700:52.89,74.09 700:52.70,74.06 700:52.86,74.31 700:53.22,74.10'}
G[46176]={46176,'700:46.50,59.44 700:46.57,59.12 700:46.25,58.73 700:45.96,58.65'}
G[46177]={46177,'700:45.91,65.49'}
G[46182]={46182,'38:74.24,12.17'}
G[46233]={46233,'692[1]:63.97,73.01 17:34.28,10.37>692'}
G[46234]={46234,'692[1]:63.75,72.57 17:34.28,10.37>692'}
G[46235]={46235,'692:64.1,72.6 692:64.2,72.4 692:65,72.7'}
G[46236]={46236,'692:64.1,72.6 692:64.2,72.4 692:64.7,72.8 692:64.8,72.4'}
G[46241]={46241,'692:64.2,72.4 692:64.2,72.5 692:64.7,72.6 692:64.8,72.4'}
G[46242]={42573,'700:37.48,88.64'}
G[46243]={42574,'700:37.56,88.73'}
G[46247]={46247,'692[1]:63.99,72.12 17:34.28,10.37>692'}
G[46254]={448,'690[1]:19.96,31.57'}
G[46255]={46255,'27:29.52,37.71 27[10]:66.39,81.63'}
G[46264]={46264,'690[1]:77.22,44.63'}
G[46274]={46274,'27:27.97,37.79 27[10]:53.08,82.32'}
G[46313]={46313,'700:54.81,44.20'}
G[46318]={46318,'700:55.14,43.56'}
G[46319]={46319,'700:53.84,43.26'}
G[46323]={45675,'700:53.30,42.70'}
G[46324]={46324,'700:53.21,42.71'}
G[46338]={46338,'610:55.28,38.92'}
G[46409]={46409,'690[1]:42.36,54.01'}
G[46410]={46410,'690[1]:56.61,53.86'}
G[46413]={46413,'700:27.64,63.86','Bottom of lake'}
G[46417]={46417,'690[1]:50.03,58.27'}
G[46424]={46424,'687:54.3,79.3'}
G[46458]={46338,'610:58.41,48.68'}
G[46463]={46338,'610:58.41,48.67'}
G[46474]={46474,'610:60.50,69.61'}
G[46475]={46475,'26:32.2,42.6'}
G[46476]={46476,'26:64,59.9'}
G[46496]={46496,'720:58.4,82.9 720:58.5,82.8'}
G[46513]={42574,'Near700'}
G[46583]={46175,'700:52.41,70.33'}
G[46585]={46175,'700:46.1,65.6'}
G[46590]={46590,'720:70.4,59.2 H:100062483'}
G[46591]={46591,'700:49.01,29.77'}
G[46592]={46592,'720:69.4,58.2 720:69.4,58.5 720:69.6,58.4 720:69.6,58.6 720:69.9,59.5'}
G[46603]={46603,'720:60.28,38.28'}
G[46612]={42308,'756[1]:30.26,28.63'}
G[46623]={46623,'687:54.5,79.2'}
G[46626]={46176,'700:50.48,70.58'}
G[46627]={46175,'700:50.54,70.81'}
G[46628]={46143,'700:50.50,70.62'}
G[46637]={46637,'321[1]:67.50,38.81'}
G[46638]={46638,'321[1]:67.35,38.73'}
G[46650]={46650,'17:92.64,38.96'}
G[46652]={46652,'17:65.07,38.40'}
G[46653]={46653,'17:64.27,38.13'}
G[46654]={46654,'17:66.39,55.49'}
G[46655]={46655,'17:66.45,55.51'}
G[46656]={46656,'687:54.4,78.9 687:54.5,78.9'}
G[46657]={45301,'545:51,17 H:100060956'}
G[46660]={46660,'17:18.4,41.4 17:18.4,41.5 17:18.5,41.4 17:18.5,41.5'}
G[46664]={46664,'17:47.15,56.47 17:46.83,56.29 17:46.61,56.50'}
G[46671]={46671,'700:37.42,93.23'}
G[46676]={46676,'38:68.20,36.17'}
G[46708]={46708,'321:56.4,61.2 321:56.4,61.5 321:56.5,61.2 321:56.9,61.5'}
G[46717]={46717,'700:45.39,87.97'}
G[46750]={46750,'720:77.27,63.26'}
G[46757]={46236,'17:52.2,51.2'}
G[46758]={46241,'17:52.2,51.4 17:52.2,51.5'}
G[46759]={46235,'17:52.2,51.4 17:52.2,51.5'}
G[46760]={46234,'17:49.25,36.92'}
G[46768]={46768,'17:50.27,54.31'}
G[46769]={46769,'17:50.25,53.26'}
G[46804]={46804,'700:60.16,58.00'}
G[46805]={46805,'700:57.48,58.14'}
G[46806]={46806,'700:62.60,48.64'}
G[46811]={46811,'700:50.8,60.2'}
G[46812]={46812,'700:50.8,60.2'}
G[46814]={46814,'700:60.42,58.30'}
G[46850]={46850,'700:62.49,48.41 700:62.55,48.28'}
G[46852]={46852,'17:20.58,56.07'}
G[46853]={46853,'17:20.63,56.19'}
G[46854]={46854,'17:20.58,56.30'}
G[46855]={46852,'Near17'}
G[46856]={46853,'Near17'}
G[46857]={46854,'Near17'}
G[46860]={46860,'17:15.3,42.8 17:15.6,42.8'}
G[46861]={46861,'17:6.2,39.3 17:7.5,42.5 17:7.8,35.8 17:7.9,39.5 17:8.3,36.8 17:8.3,38 17:8.4,38.5 17:8.4,40.5 17:8.5,39.3 17:8.7,37.4 17:8.9,43.4 17:9,37.5 17:9.1,43.8 17:9.2,42.4 17:9.3,40.8 17:9.4,35.6 17:9.4,39.9 17:9.5,37.4 17:9.5,40 17:9.5,40.6 17:9.9,37.9 17:9.9,42.2 17:10.1,38.5 17:10.2,36 17:10.5,37.1 17:10.5,38.1 17:10.5,40.7 17:10.6,35.4 17:10.7,40 17:11.2,39.4 17:11.3,41.8 17:11.6,38.3 17:11.6,42.3 17:12.1,38.9 17:12.4,40.1 17:12.5,39.9 17:13.3,36.2 17:82.1,37.4'}
G[46872]={45799,'720:59.58,72.02'}
G[46873]={39667,'720:59.70,71.82'}
G[46875]={46338,'720:59.66,71.99'}
G[46883]={46883,'720:59.57,47.33'}
G[46889]={46889,'756:28.3,25 756:28.4,26.3 756:29.1,27.5 756:29.2,25.3 756:29.2,26.4 756:29.2,26.5 756:29.5,26.4 756:29.5,26.7 756:29.5,27.9 756:29.6,25.2 756:29.9,28.5 756:62.3,39.5 756:62.4,39 756:62.4,40.9 756:62.6,38.4 756:62.7,39.5 756:62.7,40.5 756:62.9,39.3 756:63.5,40.9 756:63.7,39.4 756:63.9,39.9 756:63.9,41.8'}
G[46901]={46901,'HD 4:47.35,18.02'}
G[46902]={46902,'756:28.1,25.5 756:28.3,26.5 756:28.4,25.4 756:29.2,24.2 756:29.2,26.5 756:29.3,24.9 756:29.3,25.5 756:29.5,25.4 756:29.5,26.7 756:29.6,25.5 756:60.3,38.4 756:60.4,38.9 756:60.4,39.6 756:61.1,39.5 756:61.2,38.5 756:61.3,38.4 756:62,38.4 756:62,38.5 756:62.3,39.8 756:62.5,38.4 756:62.6,38.8 756:63.2,39.6'}
G[46906]={34693,'756:27.9,25.2 756:28.2,27.7 756:28.3,25.8 756:28.4,26.5 756:28.5,25.4 756:28.6,26.4 756:28.9,26.8 756:29.1,27.5 756:29.5,25.5 756:29.6,25.3 756:30,27.7 756:30.2,29 756:57.4,39.8 756:58.1,39.3 756:58.1,39.5 756:58.3,38.4 756:58.7,39.2 756:58.7,39.5 756:59.1,38.4 756:59.5,39.2 756:59.6,39.6'}
G[46908]={46908,'HD 381:69.91,40.62'}
G[46916]={46916,'17:8,40.8 17:8.1,41.5 17:8.4,40.2 17:8.4,42.5 17:8.8,41.8 17:8.8,42.7 17:9.1,38.3 17:9.1,38.9 17:9.2,44.3 17:9.2,44.5 17:9.3,39.7 17:9.4,36.4 17:9.4,37.4 17:9.4,41.1 17:9.5,36.4 17:9.6,38.2 17:9.6,41.3 17:9.6,41.5 17:9.7,46 17:9.8,46.7 17:10,42.6 17:10.1,34.8 17:10.2,38.7 17:10.2,43.9 17:10.3,39.6 17:10.4,37.3 17:10.7,38.7 17:11,38.2 17:11.1,39.9 17:11.2,41.1 17:11.3,36.9 17:11.4,41.6 17:11.5,40.5 17:11.5,41.6 17:11.6,39.1 17:11.7,36.2 17:11.8,38.4 17:11.8,39.9 17:12.1,36.7 17:12.6,39.3 17:12.7,39.7 17:12.8,36.5 17:12.8,37.5 17:13,36.4'}
G[46917]={46917,'17:13,43.4 17:13,43.5 17:13.1,45.2 17:14.3,46.3 17:14.4,42.7 17:14.6,42.7 17:15.4,46.7 17:15.5,46.7 17:17,48 17:17.2,47.4 17:17.4,45.6 17:17.7,44.6 17:18,45.8 17:19.1,46.7 17:19.3,46 17:20.1,44.8 17:21,44 17:21.3,43.3 17:21.9,43.5 17:22.4,43.1 17:22.5,43.4'}
G[46920]={46920,'720:73.6,72.6 H:100062483'}
G[46930]={46930,'17:20.86,55.72'}
G[46935]={18471,'700:50.74,58.31'}
G[46936]={22893,'700:50.7,58.4 700:50.7,58.5'}
G[46938]={46938,'17:16.7,48.8'}
G[46964]={35115,'764[1]:0.00,0.00'}
G[46972]={46972,'17:20.80,57.35'}
G[46978]={26814,'720:43.98,57.08'}
G[46987]={46987,'606:28.28,29.74'}
G[46993]={46993,'720:46.8,58.6 H:100062768'}
G[46998]={46987,'606:27.04,62.64'}
G[47002]={46987,'606:43.80,45.95'}
G[47005]={39667,'720:54.29,35.27'}
G[47006]={47006,'764[1]:62.06,57.24'}
G[47011]={47011,'17:18.8,42.9'}
G[47013]={47013,'17:18.8,42.9'}
G[47014]={47014,'720:80.4,47.8 H:100062483'}
G[47018]={47018,'17:18.8,42.9'}
G[47021]={47011,''}
G[47022]={47013,''}
G[47024]={47018,''}
G[47041]={47041,'38:21.2,51.9'}
G[47118]={47118,'700:43.88,57.27'}
G[47119]={47119,'700:81.66,77.11'}
G[47121]={47121,'700:28.54,24.86'}
G[47147]={47147,'700:60.42,57.65'}
G[47154]={47154,'700:48.54,28.11'}
G[47155]={47155,'700:56.78,15.11'}
G[47158]={26814,'720:36.13,15.77'}
G[47159]={47159,'720:24.44,64.08 720:24.46,64.27'}
G[47162]={47162,'756[1]:32.89,59.37'}
G[47195]={44143,'640:30.7,77.8'}
G[47202]={47202,'720:41,70 K:27940'}
G[47231]={47231,'764[1]:0.00,0.00'}
G[47233]={47233,'321[1]:44.64,61.60'}
G[47240]={47240,'709:73.39,59.18'}
G[47246]={47246,'321[1]:48.49,62.91'}
G[47250]={47250,'27:27.72,31.93 27[10]:50.97,31.92'}
G[47266]={47266,'28:68.57,53.38'}
G[47267]={47267,'28:68.49,53.28'}
G[47268]={47268,'28:68.74,53.34'}
G[47269]={47269,'28:68.91,53.27'}
G[47280]={47269,'Near28'}
G[47281]={47269,'28:54.68,72.22'}
G[47293]={44789,'764[1]:64.36,57.87'}
G[47317]={47317,'700:61.48,67.42'}
G[47318]={47318,'720:49.67,39.11'}
G[47332]={47269,'Near28'}
G[47341]={47341,'182:41.9,72'}
G[47366]={47366,'182:41.89,71.94'}
G[47374]={47374,'Near700'}
G[47383]={47383,'61:69.88,85.17'}
G[47393]={47393,'28:39.42,67.86'}
G[47417]={43190,'700:54.35,43.85'}
G[47429]={47269,'28:39.83,67.91'}
G[47432]={47432,'24:29.21,64.04'}
G[47440]={47440,'28:38.84,68.92'}
G[47462]={47462,'28:43.06,29.19'}
G[47471]={47471,'61:12.85,33.98'}
G[47492]={47374,'700:27.32,36.79'}
G[47493]={42641,'700:29.63,40.98'}
G[47551]={47551,'24:33.28,73.63'}
G[47554]={47554,'24:33.29,73.55'}
G[47556]={47556,'182:60.58,9.51'}
G[47571]={47571,'321[1]:49.05,70.56'}
G[47580]={45442,'61:30.47,49.27'}
G[47592]={332,'700:25.99,38.79'}
G[47603]={26917,'700:21.77,57.09'}
G[47605]={45528,'700:22.13,56.55'}
G[47611]={47611,'Near700'}
G[47617]={47617,'182:44.1,61.8'}
G[47626]={47626,'756[2]:58.76,39.49'}
G[47670]={47571,'720:24.37,64.55'}
G[47671]={43190,'700:36.42,38.12'}
G[47681]={47681,'24:36.62,70.20'}
G[47684]={47684,'720:54.91,32.72'}
G[47692]={47692,'182:41.26,49.95'}
G[47696]={47696,'182:41.27,49.90'}
G[47709]={47709,'720:52.9,27.6 720:53,27.2'}
G[47715]={47715,'720:52.98,27.70'}
G[47723]={47723,'700:36.73,37.95'}
G[47739]={47739,'756[2]:60.65,41.24'}
G[47745]={4046,'61:50.14,62.57'}
G[47751]={47751,'700:36.39,37.99'}
G[47759]={47759,'24:32.6,78 H:100063090'}
G[47779]={47779,'29:16.99,51.29'}
G[47781]={47781,'24:36.17,61.15'}
G[47789]={47789,'24:38.6,62.6 H:100063250'}
G[47811]={43184,'29:17.27,52.08'}
G[47843]={47843,'182:43.45,28.19'}
G[47869]={47869,'24:40.32,59.40'}
G[47875]={47875,'22:44.65,18.47'}
G[47899]={47899,'24:36.34,60.24'}
G[47900]={47900,'24:40.32,59.34'}
G[47902]={45518,'700:59.07,69.80'}
G[47904]={45522,'700:59.02,69.81'}
G[47905]={45562,'700:44.91,90.90','In Obsidian Lair'}
G[47923]={47923,'182:45.6,20.2'}
G[47927]={47927,'28:41.05,68.78'}
G[47931]={47931,'182:61.84,26.77'}
G[47940]={47159,'720:24.40,64.09'}
G[47959]={45799,'720:55.02,34.04'}
G[47967]={47967,'720:21.85,64.03'}
G[47972]={47159,'720:22.51,63.18'}
G[47991]={42573,'700:48.40,14.56'}
G[48001]={48001,'29:45.45,46.34'}
G[48010]={48010,'700:49.78,29.17'}
G[48012]={48012,'720:58.97,46.13'}
G[48013]={48013,'700:49.79,29.28'}
G[48014]={48014,'700:49.14,29.31'}
G[48020]={47900,'24:40.30,59.34'}
G[48021]={47869,'24:40.26,59.33'}
G[48022]={46883,'Near720'}
G[48032]={48032,'Near182'} -- initially at 182:48.68,25.16
G[48033]={48033,'29:46.80,44.08'}
G[48034]={26814,'720:63.90,33.85'}
G[48039]={48039,'708:51.42,49.62'}
G[48042]={48042,'Near182'}
G[48044]={48044,'Near182'}
G[48046]={48046,'700:62.56,48.59'}
G[48051]={4949,'737:33.38,50.35'}
G[48053]={48053,'700:63.15,47.61'}
G[48059]={42573,'700:48.70,16.63'}
G[48061]={48061,'708:51.41,49.61'}
G[48062]={48062,'708:51.4,49 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48066]={48066,'708:50.93,49.70'}
G[48069]={48069,'708:50.6,50.5 708:50.9,49.2 708:50.9,49.7'}
G[48070]={48070,'708:51.4,49 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48071]={48071,'708:51.3,49.1 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48074]={48074,'708:51.42,49.61'}
G[48082]={26814,'720:54.64,41.79'}
G[48085]={48085,'29:45.32,51.74'}
G[48099]={48099,'29:39.2,55.4 29:39.2,56.1 29:39.2,56.5'}
G[48100]={48100,'29:45.1,52.5 29:45.3,52.4'}
G[48109]={43184,'29:46.39,46.02'}
G[48110]={43221,'29:46.32,45.96'}
G[48111]={48111,'29:44.41,63.47'}
G[48126]={48126,'182:43.93,28.16'}
G[48127]={48127,'182:56.3,8.2'}
G[48129]={48129,'24:49.15,66.34'}
G[48133]={48133,'29:30.68,33.72'}
G[48162]={26814,'720:23.55,60.25'}
G[48173]={46591,'700:49,29.7'}
G[48174]={48014,'700:49.1,29.4'}
G[48175]={48010,'700:49.7,29.2'}
G[48186]={26814,'720:27.03,7.56'}
G[48203]={48203,'720:26.62,8.03'}
G[48208]={48208,'61:43.40,43.44'}
G[48218]={48218,'24:49.56,74.38'}
G[48237]={46883,'720:56.92,62.43'}
G[48250]={48250,'709:74.77,59.60'}
G[48254]={48254,'709:72.94,60.94'}
G[48255]={48255,'709:73.72,57.59'}
G[48264]={27804,'700:44.08,10.54'}
G[48265]={27803,'700:44.08,10.54'}
G[48273]={48273,'720:22.29,64.93'}
G[48274]={48274,'720:26.61,8.37'}
G[48275]={26664,'720:56.20,33.60'}
G[48292]={10299,'29:82.11,31.52'}
G[48306]={43184,'29:73.49,67.19'}
G[48307]={43221,'29:73.63,67.16'}
G[48312]={48312,'29:69.63,42.90','In cave on top of hill'}
G[48314]={48314,'29:70.17,47.29','In cave'}
G[48316]={48133,'29:66.52,40.53','In cave'}
G[48318]={48318,'29:17.78,52.77'}
G[48319]={48319,'24:47.9,71.2 24:48.4,72.3 24:48.4,73 24:48.7,71.3 24:48.7,72.4 24:48.7,72.5'}
G[48321]={48321,'29:46.15,41.80'}
G[48322]={48322,'24:47.9,72.5'}
G[48333]={48333,'182:54.7,18.4'}
G[48339]={48339,'182:43.94,27.86'}
G[48346]={43184,'Near29'}
G[48349]={48349,'182:44.00,27.86'}
G[48358]={48358,'709:53.7,80.4 709:53.7,80.5'}
G[48360]={48360,'709:55.2,81.1 709:55.5,80.6'}
G[48361]={48361,'709:55.6,78.4 709:55.7,78.6'}
G[48363]={48363,'709:54.4,79.4 709:54.4,79.6 709:54.5,79.7 709:55,79.2'}
G[48364]={46804,'700:54.39,16.75'}
G[48365]={21330,'700:54.76,17.37 700:54.88,17.17'}
G[48366]={48366,'700:54.60,17.54'}
G[48367]={48367,'700:54.33,16.75'}
G[48368]={48368,'700:54.3,16.8'}
G[48417]={48417,'756[2]:33.30,48.65'}
G[48419]={48419,'756[1]:59.81,71.78'}
G[48420]={48420,'756[1]:60.32,71.42'}
G[48428]={48428,'720:40,22 H:100063700'}
G[48431]={48203,'720:29.61,21.85'}
G[48445]={48445,'756[1]:44.66,82.78'}
G[48459]={48459,'182:43.33,30.43'}
G[48461]={48461,'182:64.09,10.29'}
G[48469]={48469,'182:44.2,28'}
G[48470]={48218,'24:29.30,83.88'}
G[48472]={46591,'700:38.12,34.49'}
G[48491]={48491,'182:44.34,28.07'}
G[48492]={48492,'182:61.91,26.66'}
G[48493]={48493,'182:56.76,18.50'}
G[48501]={48501,'720:67.34,42.79'}
G[48503]={48218,'24:27.14,88.35'}
G[48513]={48513,'321[1]:36.6,87.0'}
G[48522]={48522,'756[2]:60.67,40.49'}
G[48528]={26814,'720:36.15,20.26','In the Chamber of the Moon'}
G[48530]={48013,'700:54.74,17.95'}
G[48545]={44640,'24:57.08,46.23'}
G[48558]={26814,'720:39.00,23.24','In the Chamber of the Moon'}
G[48559]={48559,'29:17.4,51.7 29:17.5,51.7'}
G[48564]={47684,'720:52.02,65.46'}
G[48565]={48559,'29:54.6,24.4 29:54.7,24.6'}
G[48567]={48559,''}
G[48568]={3144,'29:44.6,44.4 29:44.6,44.5'}
G[48569]={3144,'29:54.6,24.4 29:54.6,24.5'}
G[48621]={48203,'720:42.16,25.92'}
G[48658]={48658,'281:50.72,54.87'}
G[48659]={48659,'281:50.80,55.01'}
G[48660]={48660,'281:50.69,55.07'}
G[48698]={26814,'720:41.35,5.56'}
G[48704]={48704,'23:73.74,53.06'}
G[48722]={48722,'281:65.32,46.19'}
G[48723]={48723,'281:65.37,46.20'}
G[48731]={48731,''}
G[48732]={48732,''}
G[48733]={39875,''}
G[48734]={42684,''}
G[48736]={48736,'381:48.13,14.47'}
G[48761]={46883,'720:67.23,42.90'}
G[48764]={48764,'42:52.4,30.8 H:100064450'}
G[48797]={48797,'673:39.48,69.54','Swims in harbor'}
G[48808]={48808,'673:40.52,68.20'}
G[48965]={48965,'281:59.74,49.66'}
G[48993]={42640,'700:77.63,16.63'}
G[49000]={47374,'700:82.12,80.05'}
G[49002]={49002,'700:81.84,80.39'}
G[49020]={44806,'700:78.82,76.90'}
G[49022]={49022,'700:80.96,79.40'}
G[49035]={49035,'Z24'}
G[49044]={49044,'892:40.51,78.53 20:29.43,70.94>892'}
G[49151]={26814,'720:33.33,19.66'}
G[49201]={49201,'24:60.04,63.67'}
G[49203]={26814,'720:32.59,30.66'}
G[49204]={28070,'720:32.59,30.89'}
G[49240]={49240,'24:61.86,84.22'}
G[49243]={49243,'24:60.08,63.35'}
G[49248]={28070,'720:44.85,67.32'}
G[49252]={44806,'700:81.04,79.34'}
G[49345]={46883,'720:52.94,65.51'}
G[49351]={28070,'720:44.85,67.32'}
G[49358]={21330,'700:55.25,17.32'}
G[49374]={48367,'700:55.21,17.31'}
G[49378]={47374,'700:80.07,74.53','Circling in airship'}
G[49379]={49002,'700:80.05,74.50','Circling in airship'}
G[49386]={49386,'700:48.61,30.68'}
G[49387]={49387,'700:53.87,42.08'}
G[49396]={49396,'281:55.94,28.13'}
G[49399]={49399,'281:45.61,41.58'}
G[49400]={49400,'281:46.29,42.58'}
G[49402]={49402,'281:48.08,40.61'}
G[49407]={49407,'281:45.78,41.01'}
G[49408]={49408,'720:26.9,7.4 720:26.9,7.5'}
G[49417]={45518,'700:14.87,16.34'}
G[49425]={49425,'892:67.01,42.35 20:35.75,62.23>892'}
G[49436]={49436,'281:55.89,28.27'}
G[49439]={49439,'700:77.69,16.65'}
G[49441]={49441,'700:77.67,16.69'}
G[49444]={49444,'606:42.65,28.14'}
G[49476]={49444,'753[1]:33.08,65.99'}
G[49479]={32973,'888:42.53,50.49 41:57.20,33.27>888'}
G[49480]={1992,'888:38.91,27.69 41:56.07,26.29','In cave'}
G[49523]={49523,'720:41.36,5.57'}
G[49537]={49537,'281:55.97,28.24'}
G[49635]={49635,'673:41.49,74.36'}
G[49636]={49636,'673:41.7,74'}
G[49687]={49687,'24:33.6,49.3'}
G[49748]={49748,'381:45.21,49.88'}
G[49810]={45528,'700:14.15,15.47'}
G[49856]={49856,'23:76.16,50.95'}
G[49920]={49920,'17:91.2,37.2 17:91.3,37.7 17:91.5,38'}
G[49941]={28070,'759[3]:47.15,44.40'}
G[49943]={49943,'769[1]:54.48,15.83 720:76.75,84.45>769'}
G[50038]={50038,'747:31.69,16.14 720:60.52,64.19>747'}
G[50048]={50048,'768:53.61,94.92'}
G[50049]={50049,'301:37.18,56.26','In basement'}
G[50068]={50068,'606:42.66,45.71'}
G[50082]={40997,'606:43.55,45.89'}
G[50084]={50084,'606:41.18,42.59'}
G[50263]={50263,'281:61.87,74.66'}
G[50270]={39887,'767:49.9,89.7'}
G[50272]={40917,'767:49.9,89.1 767:49.9,89.7 767:50,90.9 767:50,91.5'}
G[50366]={50366,'281:59.68,50.48'}
G[50367]={50367,'181:50.70,73.90'}
G[50371]={50371,'611:57.91,75.55'}
G[50385]={50385,'757[1]:18.80,55.61 700:19.18,54.01>757'}
G[50387]={45562,'757[1]:19.80,52.55 700:19.18,54.01>757'}
G[50390]={45522,'757[1]:19.22,55.45 700:19.18,54.01>757'}
G[50401]={50401,'720:45.57,57.76'}
G[50480]={50480,'301:63.77,61.53'}
G[50482]={50482,'321:25.1,90.1 321:71.4,36.3 321:71.8,36.7 321:71.9,36.1 321:72.4,35.4 321:72.5,36.2'}
G[50587]={50587,'261:53.28,33.50'}
G[50588]={50588,'261:53.57,33.35'}
G[50601]={50601,'27:62.55,53.80'}
G[50622]={50622,'700:53.96,41.90'}
G[50631]={50631,'27:76.19,53.04'}
G[50690]={50690,'381:37.64,80.43'}
G[51287]={51287,'709:53.8,80.4 709:54.3,80.7 709:54.5,80.2 709:54.5,80.8'}
G[51288]={51288,'709:74.56,60.93'}
G[51574]={51574,'HM 37:52.05,63.55'}
G[51575]={51575,'HM 181:60.79,53.48'}
G[51582]={51582,'HM 37:40.59,50.94'}
G[51585]={51585,'HM 17:19.00,56.18'}
G[51586]={51586,'HM 607:48.33,72.23'}
G[51587]={51587,'HM 607:40.85,67.79'}
G[51588]={51588,'HM 81:49.30,51.33'}
G[51602]={51602,'HM 38:70.25,15.73'}
G[51603]={51603,'HM 19:46.23,13.78'}
G[51604]={51604,'HM 22:29.17,57.35'}
G[51606]={51606,'HM 201:59.86,63.24'}
G[51607]={51607,'HM 201:56.32,66.34'}
G[51639]={51639,'362:21.96,18.83'}
G[51650]={51650,'HM 700:47.26,28.97'}
G[51651]={51651,'HM 700:53.13,46.18'}
G[51652]={51652,'HM 720:53.15,34.53'}
G[51653]={51653,'HM 720:53.59,31.85'}
G[51664]={51664,'182:36.36,58.26'}
G[51665]={35873,'HW 30:32.04,50.51'}
G[51677]={51677,'Near281'}
G[51682]={51682,'HM 606:62.82,22.72'}
G[51697]={51697,'HM 615:49.35,42.00'}
G[51698]={51698,'HM 640:49.40,51.32'}
G[51934]={51934,'30:32.35,50.88'}
G[51988]={51988,'301:56.32,53.99'}
G[51989]={51989,'321[1]:57.97,57.61'}
G[52015]={52015,'709:75.00,60.37'}
G[52019]={52019,'769[1]:29.25,38.64'}
G[52053]={52053,'793:31.77,24.11'}
G[52064]={52064,'HW 30:32.09,50.60'}
G[52122]={52122,'795:70.2,40.6'}
G[52135]={33091,'795:47.01,91.38'}
G[52192]={52192,'11:44.33,25.10'}
G[52207]={52207,'11:47.53,39.58'}
G[52219]={52219,'606:24.49,60.90'}
G[52234]={52234,'Near37'}
G[52281]={44019,'37:52.88,67.35 37:52.58,66.51 37:53.16,65.87'}
G[52292]={52292,'381:43.95,78.87'}
G[52294]={715,'37:44.13,22.91'}
G[52309]={52309,'11:41.07,39.21'}
G[52319]={52319,'382:55.29,50.25'}
G[52346]={52346,'37:50.37,21.74'}
G[52371]={52346,'37:76.09,66.65','In cave'}
G[52374]={52374,'37:76.09,66.66'}
G[52382]={52382,'321[1]:48.76,70.15'}
G[52408]={52408,'301:49.53,87.50','In tower'}
G[52410]={469,'37:47.75,12.00'}
G[52444]={41006,'795:42.52,59.69'}
G[52467]={40331,'795:48.54,86.25'}
G[52476]={52476,'795:50.94,87.38'}
G[52477]={40278,'795:36.01,59.01'}
G[52478]={39925,'795:35.79,59.38'}
G[52488]={52488,'795:43.80,88.96'}
G[52489]={52489,'795:50.64,87.26'}
G[52490]={40997,'795:43.04,80.58'}
G[52491]={41003,'795:34.50,56.23'}
G[52492]={41005,'795:36.29,56.35'}
G[52493]={40139,'795:47.55,90.54'}
G[52494]={52494,'795:64.88,67.25'}
G[52646]={52646,'673:55.30,41.95'}
G[52651]={52651,'362:36.8,59.6'}
G[52654]={52234,'301:25.93,29.29'}
G[52657]={52657,'362:35.6,53.8'}
G[52669]={39928,'606:27.17,62.56'}
G[52671]={39930,'606:27.10,62.02'}
G[52730]={52730,'793:49.34,39.09'}
G[52753]={52753,'37:47.86,11.86'}
G[52767]={38966,'673:41.03,73.13',}
G[52793]={40289,'606:60.31,29.86'}
G[52823]={52823,'795:52.99,90.91'}
G[52824]={52824,'795:45.58,85.81'}
G[52835]={52835,'486:32.6,27.4'}
G[52838]={5769,'606:27.08,54.48'}
G[52844]={40139,'606:26.80,62.15'}
G[52845]={33091,'606:27.36,55.23'}
G[52906]={52488,'606:26.00,61.28'}
G[52921]={52921,'795:66.09,63.97'}
G[52924]={38966,'781:14.19,52.92'} -- at end of dungeon is 781:93.33,53.59
G[52925]={52925,'781:13.76,51.83'}
G[52933]={52933,'781:13.74,54.06'}
G[52937]={52937,'606:27.55,62.43'}
G[52986]={52986,'606:27.53,62.50'}
G[52995]={52995,'606:62.2,23.2'}
G[53009]={24848,'486:46.6,35.6'}
G[53023]={53023,'X 793:30.75,47.14 37:72.09,32.91>793'}
G[53024]={53024,'X 793:30.59,47.32 37:72.09,32.91>793'}
G[53043]={53043,'X 793:30.51,50.95 37:72.09,32.91>793'}
G[53056]={53056,'795:57.48,49.46'}
G[53073]={53073,'606:27.49,61.58 606:27.14,61.65 606:26.86,61.77'} -- some days he wanders, others he is just in another place
G[53080]={41492,'795:46.88,89.99'}
G[53081]={52234,'321[1]:32.62,68.15'}
G[53149]={24848,'486:31,24'}
G[53151]={53151,'X 793:30.83,47.28 37:72.09,32.91>793'}
G[53196]={29428,'795:46.76,90.18'}
G[53210]={24848,'486:31,24'}
G[53214]={53214,'795:46.91,90.00'}
G[53215]={24848,'486:23,30.8'}
G[53233]={39925,'795:51.89,30.98'}
G[53259]={53259,'795:34.30,56.43'}
G[53304]={29428,'795:36.23,56.58'}
G[53310]={53310,'795:50,50'}
G[53349]={24848,'486:23.2,22.8'}
G[53352]={53352,'301:26.22,29.27'}
G[53365]={52824,'795:50,86'}
G[53371]={53371,'321[1]:50,77'}
G[53385]={33091,'795:47.14,90.42'}
G[53422]={53422,'321[1]:48.6,71.8 301:54,56'}
G[53466]={53371,'301:54,56'}
G[53519]={35875,'720:34.26,77.56'}
G[53524]={53524,'720:47.65,88.91'}
G[53528]={53528,'382:62.66,35.48'}
G[53566]={53566,'808:56.67,18.17'}
G[53567]={52835,'520:60,21'}
G[53652]={35875,'614:69.81,34.19'}
G[53677]={53677,'614:69.54,34.30'}
G[53738]={35875,'640:56.52,12.50'}
G[53763]={53763,'382:68.86,7.86'}
G[53783]={53783,'606:19.59,36.38'}
G[53881]={53881,'795:44.08,86.34'}
G[53882]={53882,'795:44.42,88.81'}
G[53925]={35875,'795:51.45,25.79'}
G[53949]={53949,'301:60.06,75.13'}
G[53950]={53950,'301:24.04,44.81'}
G[54004]={54004,'321[1]:48.13,46.86'}
G[54014]={35875,'795:49.60,31.77'}
G[54021]={54021,'301:64.17,46.28'}
G[54117]={54117,'301:58.89,52.73'}
G[54118]={54021,'301:65.16,33.46'}
G[54135]={54135,'808:38.80,25.49','In cave'}
G[54141]={54141,'321[1]:54.42,77.63'}
G[54142]={53950,'4:57.33,9.01'}
G[54146]={54146,'321[1]:58.05,48.42'}
G[54163]={29428,'795:66,65'}
G[54168]={4949,'606:60.22,29.83'}
G[54233]={54233,'486:46,34.8'}
G[54312]={35875,'606:60.22,30.12'}
G[54313]={4949,'606:60.63,31.46'}
G[54314]={38917,'606:49.10,19.58'}
G[54334]={54334,'HF 301:62.11,32.18 301:62.27,72.97 341:27.52,73.32 381:38.56,49.39 481:52.02,29.14 504[1]:49.90,50.37'} -- another one wanders SW
G[54393]={54393,'606:27.75,63.63'}
G[54432]={54432,'820[1]:81.23,23.95'}
G[54476]={54476,'820[1]:79.59,44.97'}
G[54485]={54485,'HF 823:51.63,77.85'}
G[54548]={4949,'819[1]:48.70,19.73'}
G[54567]={54567,'808:55.09,32.54'}
G[54568]={54568,'808:50.23,21.27'}
G[54590]={54590,'819[1]:56.8,27.8 H:100077957'}
G[54601]={54601,'HF 823:53.29,54.37'}
G[54603]={54603,'797[1]:48.45,68.07 465:47.63,53.57>797'}
G[54605]={54605,'HF 823:50.69,65.13'}
G[54606]={17493,'797[1]:48.45,68.07 465:47.63,53.57>797'}
G[54608]={53566,'808:57.54,34.69'}
G[54609]={53566,'808:50.27,21.48'}
G[54614]={54614,'806:46.13,84.57'}
G[54615]={54615,'806:50.41,88.26'}
G[54616]={54616,'806:43.59,90.68'}
G[54617]={54617,'806:45.17,94.98'}
G[54629]={54629,'725[1]:50.94,90.22 465:46.03,51.79>725'}
G[54636]={54636,'725[1]:50.94,90.22 465:46.03,51.79>725'}	-- location is just a guess until horde can verify
G[54667]={54667,'728[1]:18.81,11.18 467:48.94,35.80>728'}
G[54668]={54668,'728[1]:17.86,12.08 467:48.94,35.80>728'}
G[54674]={54674,'726[1]:31.47,65.28 467:54.14,34.39>726'}
G[54675]={54667,'726[1]:30.86,65.22 467:54.14,34.39>726'}
G[54678]={54678,'726[1]:29.53,64.43 467:54.14,34.39>726'}
G[54692]={19670,'732[1]:34.41,19.47 478:39.63,57.67>732'}
G[54694]={54694,'732[1]:32.73,19.43 54694>732'}
G[54697]={54697,'806:43.49,75.92'}
G[54698]={54698,'722[1]:46.2,23.6 478:34.34,65.61>722'}
G[54725]={54725,'722[1]:44.21,71.01 478:34.34,65.61>722'}
G[54751]={54476,'820[6]:52.12,44.47'}
G[54786]={53566,'808:51.41,46.38'}
G[54787]={54787,'808:39.40,29.54'}
G[54840]={54840,'723[1]:72.16,35.50 478:44.91,65.61>723'}
G[54847]={54847,'723[1]:47.86,67.01 478:44.91,65.61>723'}
G[54848]={54667,'727[1]:17.88,27.27 467:50.40,33.35>727'}
G[54849]={54678,'727[1]:17.48,25.92 467:50.40,33.35>727'}
G[54851]={54851,'727[1]:18.83,27.67 467:50.40,33.35>727'}
G[54854]={54854,'806:43.32,76.01'}
G[54870]={54870,'321[1]:48.58,70.56'}
G[54890]={54890,'724[1]:21.28,13.10 478:39.63,73.54>724'}
G[54891]={54891,'724[1]:22.58,12.49 478:39.63,73.54>724'}
G[54913]={54913,'806:45.01,24.96'}
G[54914]={54914,'806:45.21,25.06'}
G[54915]={54915,'806:41.62,23.69'}
G[54917]={54917,'806:41.60,28.33'}
G[54918]={54918,'806:38.94,24.08'}
G[54922]={54922,'806:43.26,24.72'}
G[54926]={54926,'806:43.10,23.60'}
G[54931]={17493,'710[1]:58.61,88.44 465:47.68,51.99>710'}
G[54932]={54636,'710[1]:58.8,88.8 465:47.68,51.99>710'}
G[54933]={54603,'710[1]:58.61,88.44 465:47.68,51.99>710'}
G[54934]={54629,'710[1]:58.62,88.60 465:47.68,51.99>710'}
G[54943]={54943,'808:55.09,32.82'}
G[54960]={54960,'806:58.89,81.48'}
G[54961]={54961,'806:53.66,91.41'}
G[54968]={54968,'819[1]:40,52.6 H:100077957'}
G[54969]={54969,'816:87.34,50.04'}
G[54971]={4949,'819[2]:46.79,44.93'}
G[54975]={54567,'808:65.59,42.58'}
G[54998]={54998,'806:49.65,45.83'}
G[55007]={55007,'798[2]:42.61,87.19'}
G[55009]={54697,'806:41.03,73.97'}
G[55020]={55020,'808:70.62,38.72'}
G[55021]={55021,'808:63.44,41.91'}
G[55054]={54870,'4:63.52,0.01'}	-- TODO: Attempt to get the real location on Hellscream's Fist which reports as 4:0,0
G[55084]={55084,'806:41.01,74.08'}
G[55094]={55094,'806:38.01,23.79'}
G[55122]={55122,'806:58.07,80.65'}
G[55135]={54870,'806:30.74,10.21'}
G[55136]={17493,'710[1]:67.20,51.70 465:47.68,51.99>710'}
G[55138]={54603,'710[1]:67.20,51.70 465:47.68,51.99>710'}
G[55172]={54870,'806:28.42,24.94'}
G[55180]={55180,'806:28.19,24.82'}
G[55196]={55196,'806:54.18,82.41'}
G[55209]={55209,'806:43.21,75.94'}
G[55210]={55210,'HL 720:31.59,62.99'}
G[55211]={55211,'HL 720:65.52,18.68'}
G[55216]={55216,'HL 640:27.71,69.17'}
G[55217]={55217,'HL 640:49.70,54.88'}
G[55218]={55218,'HL 700:51.87,33.07'}
G[55219]={55219,'HL 700:50.91,70.45'}
G[55224]={55224,'HL 606:26.69,62.05'}
G[55227]={55227,'HL 606:62.54,22.82'}
G[55228]={55228,'HL 615:57.25,86.14'}
G[55234]={55234,'806:46.65,46.15'}
G[55274]={55234,'806:38.66,42.25'}	-- TODO: Probably should be a Near, but would like specific area if we can put that capability in place
G[55282]={54616,'806:58.86,81.78'}
G[55283]={55283,'806:58.93,81.93'}
G[55284]={55284,'806:59.07,81.89'}
G[55333]={54617,'806:58.98,81.83'}
G[55382]={54334,'HF 21:75.48,3.27 321[1]:48.22,62.16 362:43.93,52.60 382:62.06,46.93 481:51.80,29.25 480:74.32,81.89 504[1]:50.27,50.40'}
G[55403]={55403,'806:31.14,17.53'}
G[55413]={55234,'806:46.56,45.62','Running all around town'}
G[55438]={55438,'806:48.67,24.94'}
G[55477]={54568,'808:68.88,64.97'}
G[55478]={55021,'808:69.13,66.65'}
G[55479]={55479,'808:68.11,66.40'}
G[55497]={55403,'Near806'}
G[55521]={55521,'806:31.14,21.58'}
G[55531]={55531,'520[1]:36.06,81.20'}
G[55532]={55532,'816:84.43,56.05'}
G[55535]={55535,'520[1]:35.25,80.93'}
G[55536]={55535,'520[1]:37.30,81.66'}
G[55537]={55535,'520[1]:36.14,83.00'}
G[55564]={55564,'533[3]:14.92,83.88 488:26.01,50.83>533'}
G[55583]={54568,'808:30.96,36.73'}
G[55585]={55021,'808:29.90,39.77'}
G[55586]={53566,'808:30.00,60.36'}
G[55588]={55588,'808:31.82,39.70'}
G[55592]={55592,'808:24.64,69.79'}
G[55595]={54567,'808:32.94,35.61'}
G[55614]={55614,'806:44.25,15.01'}
G[55624]={54476,'816:27.24,64.21'}
G[55646]={55180,'806:28.65,47.46'}
G[55647]={55647,'806:28.64,47.38'}
G[55648]={55648,'806:28.60,47.43'}
G[55658]={55658,'522[1]:26.62,50.61'}
G[55672]={53566,'808:19.46,51.23'}
G[55677]={26664,'534[1]:35.50,83.17 496:28.53,86.94>534'}
G[55737]={30676,'530[1]:36.52,35.09 496:81.22,28.88>530'}
G[55738]={30671,'530[1]:57.32,34.60 496:76.27,21.19>530'}
G[55768]={54961,'806:27.59,32.68'}
G[55788]={55788,'806:52.60,38.12'}
G[55789]={54617,'301:78.80,39.99'}	-- 301:26.11,20.63 (location prior to new MoP quests)
G[55809]={55809,'806:45.71,43.70'}
G[55828]={55828,'806:28.62,47.48'}
G[55835]={55835,'526[1]:35.75,34.95 495:39.54,26.92>526'}
G[55940]={55021,'808:42.28,86.34'}
G[55942]={54568,'808:36.36,72.51'}
G[55943]={55943,'808:50.09,76.66'}
G[55944]={55944,'808:42.21,86.53'}
G[55963]={55614,'806:44.25,15.01'}
G[56012]={55588,'808:51.31,48.29'}
G[56013]={56013,'808:51.44,48.29'}
G[56027]={56027,'525[1]:11.68,53.71 495:45.37,21.39>525'}
G[56062]={56062,'806:46.46,45.81'}
G[56063]={56063,'806:55.31,45.32'}
G[56064]={56064,'806:54.89,45.31'}
G[56065]={56065,'806:54.56,44.41'}	-- 806:54.92,45.12
G[56072]={56072,'524[2]:45.07,18.05 491:57.25,46.59>524'}
G[56110]={54926,'807:84.08,21.03'}
G[56111]={54913,'807:19.87,56.92'}
G[56112]={56112,'857:60.08,25.00'}
G[56113]={56113,'807:61.14,34.30'}
G[56114]={56112,'857:67.36,32.74'}
G[56115]={56115,'857:76.21,7.07'}
G[56133]={56133,'807:85.94,22.11'}
G[56138]={56138,'807:68.88,43.30'}
G[56204]={56204,'807:83.69,21.02'}
G[56205]={56205,'807:75.21,24.05'}
G[56207]={56207,'807:81.45,25.01'}
G[56208]={56208,'807:78.12,32.90'}
G[56222]={55196,'806:58.97,81.70'}
G[56287]={54961,'806:53.78,90.63'}
G[56312]={56312,'807:78.18,32.81'}
G[56313]={56313,'806:26.27,37.33'}
G[56327]={56327,'806:25.96,38.73'}
G[56329]={56329,'806:33.35,42.21'}
G[56336]={56336,'806:27.99,47.18'}
G[56339]={54870,'806:28.26,47.78'}
G[56345]={54961,'806:50.91,27.07'}
G[56346]={56346,'806:50.94,27.03'}
G[56347]={56347,'806:45.43,29.14 806[6]:60.88,37.06'}
G[56348]={56348,'806:47.14,46.16'}
G[56351]={56351,'806:25.88,38.00'}
G[56358]={56358,'806:27.03,50.84'}
G[56364]={81280,'806:59.00,81.99'}
G[56366]={55196,'806:58.97,81.69'}
G[56406]={55521,'806:28.30,47.79'}
G[56416]={54567,'808:36.49,84.23'}
G[56418]={54568,'808:39.30,86.22'}
G[56432]={56432,'806:65.98,79.28'}
G[56433]={56433,'806:65.98,79.38'}
G[56434]={1747,'806:65.91,79.27'}
G[56439]={56439,'867[1]:68.33,57.97'}
G[56440]={56440,'807:82.70,21.22'}
G[56465]={56465,'807:82.66,25.55'}
G[56467]={56347,'806:46.30,29.40'}
G[56474]={56474,'807:68.71,43.12'}
G[56490]={54870,'Near806'}
G[56525]={55521,'806:28.98,49.08'}
G[56541]={63009,'877[3]:20.80,22.12'}
G[56611]={56133,'807:68.79,43.25'}
G[56662]={54567,'808:15.79,49.11'}
G[56707]={56707,'806:46.28,45.46'}
G[56708]={56708,'806:52.58,38.11'}
G[56714]={56714,'807:18.29,31.22'}
G[56720]={56720,'807:19.54,56.88'}
G[56737]={56737,'806:57.95,82.51'}
G[56773]={56773,'807:60.60,33.68'}
G[56774]={56774,'806:45.77,44.00'}
G[56782]={56782,'806:58.13,58.66'}
G[56784]={56784,'806:58.03,59.01'}
G[56786]={56786,'806:56.26,60.44'}
G[56787]={56787,'806:57.53,56.01'}
G[56802]={56802,'807:59.82,27.94'}
G[56832]={56832,'807:64.89,26.94'}
G[56833]={56833,'807:65.47,26.06 H:100083767'}
G[56866]={56113,'807:61.14,34.30'}
G[56877]={56877,'875[1]:47.32,65.45'}
G[56884]={60688,'877[1]:69.85,45.33'}
G[56899]={56899,'29:54.11,23.86'}
G[57108]={54870,'806:28,47'}
G[57198]={57198,'807:11.60,49.53'}
G[57209]={57209,'807:52.60,62.96'}
G[57211]={57211,'807:52.73,62.98'}
G[57242]={57242,'806:55.84,57.08'}
G[57250]={56133,'807:68.81,43.50'}
G[57298]={57298,'807:52.95,51.59'}
G[57319]={57319,'806:53.89,61.91'}
G[57324]={57324,'806:53.91,61.94'}
G[57385]={57385,'807:38.58,51.72'}
G[57401]={57401,'807:44.16,34.23'}
G[57402]={57402,'807:44.63,34.05'}
G[57405]={57405,'807:62.66,59.74'}
G[57407]={57407,'807:63.62,58.52'}
G[57408]={57408,'807:41.32,38.13','Underground'}
G[57424]={57424,'807:63.55,58.43'}
G[57706]={56133,'807:32.12,68.33'}
G[57707]={56138,'807:32.31,68.45'}
G[57708]={56474,'807:32.23,68.47'}
G[57739]={54568,'808:38.78,86.33'}
G[57744]={57744,'857:75.84,7.60'}
G[57864]={57864,'820[1]:79.65,45.14'}
G[57913]={10667,'816:87.33,49.29'}
G[57934]={56133,'807:55.88,49.42'}
G[58113]={58113,'857:59.88,24.68'}
G[58114]={58114,'857:59.87,24.81'}
G[58149]={26500,'534[1]:37.18,80.52 496:28.53,86.94>534'}
G[58160]={58160,'857:68.80,22.24'}
G[58206]={56112,'Near857'}
G[58225]={58225,'806:65.35,31.67'}
G[58228]={58228,'806:57.55,45.10'}
G[58278]={58278,'857:29.68,39.05'}
G[58376]={58376,'857:81.29,6.82'}
G[58379]={56115,'857:76.27,7.12'}
G[58408]={58408,'811:56.72,43.57'}
G[58413]={58413,'806:57.33,45.34'}
G[58420]={58420,'806:58.61,43.65'}
G[58421]={18180,'807:16.00,82.48'}
G[58422]={715,'807:16.07,82.62'}
G[58434]={58434,'807:15.90,82.25'}
G[58444]={58420,'806:58.58,43.65'}
G[58465]={58465,'811:33.98,38.00'}
G[58467]={58467,'811:56.79,43.26'}
G[58468]={58468,'811:56.74,42.65'}
G[58469]={59343,'811:56.69,43.14'}
G[58470]={59342,'811:56.54,43.21'}
G[58471]={58471,'811:33.67,38.40'}	-- *** after Golden Lotus revamp we have: [58471]={58471,'811:21.30,71.50'}
G[58503]={58465,'811:33.97,38.13'}
G[58504]={58471,'811:34.06,38.13'}
G[58506]={58506,'806:58.02,43.71'}
G[58508]={58508,'806:57.48,44.02'}
G[58509]={58509,'806:58.26,45.05'}
G[58510]={58510,'806:58.47,44.70'}
G[58511]={58511,'806:57.29,43.47'}
G[58547]={58547,'857:44.18,42.94'}
G[58562]={58562,'807:52.22,48.67'}
G[58563]={58563,'807:52.23,48.66'}
G[58564]={58564,'806:57.76,45.07'}
G[58567]={58567,'807:52.01,48.34'}
G[58590]={58590,'874[1]:0.00,0.00'}
G[58607]={58113,'857:15.98,39.79'}
G[58609]={1747,'857:40.48,34.65'}
G[58630]={58630,'857:29.06,51.14'}
G[58632]={58632,'871[1]:0.00,0.00'}
G[58646]={58646,'807:52.74,47.94'}
G[58647]={58647,'807:53.04,51.71'}
G[58704]={58704,'811:18.11,63.56'}
G[58705]={58705,'807:52.76,51.84'}
G[58706]={58706,'807:53.17,51.79 H:100089812,100089813,100089814'}	-- probably need to make this a SELLS instead of HAS (so we do not try to kill)
G[58707]={58707,'807:53.07,51.86'}
G[58708]={58708,'807:53.12,52.05'}
G[58709]={58709,'807:34.42,46.76'}
G[58710]={58710,'807:53.56,52.57'}
G[58712]={58712,'807:52.98,51.34'}
G[58713]={58713,'807:52.67,51.99'}
G[58714]={58714,'807:52.60,51.63'}
G[58715]={58715,'807:52.58,51.71'}
G[58716]={58716,'807:53.40,51.60'}
G[58717]={58717,'807:53.18,52.24'}
G[58718]={58718,'807:52.89,52.13'}
G[58721]={58646,'807:52.01,48.02'}
G[58723]={58646,'807:51.98,48.02'}
G[58735]={58735,'857:67.44,32.70'}
G[58736]={58736,'807:60.97,32.85'}
G[58743]={58743,'811:18.48,71.53'}
G[58745]={58745,'857:67.45,32.63'}
G[58761]={58761,'807:45.10,33.78'}
G[58779]={58779,'857:67.63,25.73'}
G[58785]={56474,'Near807'}
G[58814]={56112,'Near857'}
G[58818]={58818,'811:33.84,70.44'}
G[58819]={58819,'811:35.37,74.06'}
G[58820]={58820,'811:33.77,69.68'}
G[58821]={58735,'857:24.71,34.04'}
G[58843]={58843,'807:20.30,58.67'}
G[58911]={59333,'811:35.27,74.86'}
G[58919]={58465,'811:21.47,71.59'}
G[58920]={58471,'811:21.39,71.45'}
G[58945]={58945,'806:27.58,24.25'}
G[58954]={58954,'857:15.70,39.71'}
G[58962]={58962,'811:20.45,73.51 811:20.05,75.63','Moves between spots'}
G[58970]={58745,'857:24.70,33.99'}
G[59022]={55122,'806:54.21,82.49'}
G[59048]={59048,'857:25.14,33.46'}
G[59049]={59049,'857:67.76,32.49'}
G[59058]={59058,'806:58.76,81.28'}
G[59073]={59073,'809:72.27,91.85'}
G[59074]={59074,'876[4]:46.56,50.07 876[4]:38.82,56.28'}	-- second position is after he moves if you are not quick enough
G[59076]={59076,'809:70.74,90.36'}
G[59077]={59077,'809:71.57,92.83'}
G[59080]={59080,'898[4]:49.46,36.78'}
G[59119]={59119,'807:31,29 H:100086433,100086434'}
G[59120]={59120,'807:29.82,28.74'}
G[59121]={59121,'807:30,42 H:100086433,100086434'}
G[59123]={59123,'807:29.75,33.97 H:100086435,100086436'}
G[59124]={59124,'807:32.72,30.44'}
G[59138]={58547,'857:40.60,33.69'}
G[59150]={59150,'871[1]:0.00,0.00'}
G[59173]={59173,'806:46.92,45.99','Pacing back and forth'}
G[59178]={55788,'806:46.63,45.32'}
G[59186]={59186,'806:47.05,46.24'}
G[59188]={1747,'857:40.63,33.73'}
G[59189]={1747,'857:40.43,34.70'}
G[59254]={55788,'806:52.59,38.09'}
G[59263]={59263,'809:74.96,88.86'}
G[59272]={59272,'809:74.67,76.92'}
G[59273]={59273,'809:74.78,88.68'}
G[59332]={58408,'811:33.82,38.50'}
G[59333]={59333,'811:33.40,38.04'}
G[59334]={58468,'811:33.13,38.98'}
G[59335]={59335,'809:69.98,70.54 H:100080241'}
G[59336]={58819,'811:35.29,76.75'}
G[59337]={58468,'811:35.12,75.37'}
G[59338]={58467,'811:33.87,72.22'}
G[59340]={58408,'811:21.48,71.18'}
G[59341]={59341,'811:42.23,45.93'}
G[59342]={59342,'811:43.67,46.09'}
G[59343]={59343,'811:42.32,46.00'}
G[59353]={59353,'809:71.76,70.28'}
G[59354]={59354,'809:71.36,69.30'}
G[59371]={59371,'809:64.70,61.75'}
G[59374]={59354,'809[9]:65.93,60.40'}
G[59377]={54961,'806:28.2,46.8'}
G[59383]={59383,'806:48.32,46.06'}
G[59391]={59391,'806:48.31,61.35'}
G[59402]={59402,'809:65.49,60.82'}
G[59405]={59405,'809:64.24,61.38'}
G[59411]={54961,'806:44.77,67.09'}
G[59418]={54961,'806:49.29,61.47'}
G[59441]={55122,'809:71.54,93.08','Upstairs'}
G[59442]={54870,'809:71.64,93.11','Upstairs'}	-- ?? 809:62.98,80.19
G[59448]={55521,'809:62.76,79.83'}
G[59449]={55180,'809:62.68,80.67'}
G[59450]={54616,'809:54.17,83.27'}
G[59451]={54614,'809:53.67,83.27'}
G[59452]={59452,'809:51.97,67.25'}
G[59479]={59479,'876[4]:43.23,44.79'}
G[59492]={55614,'806:43.83,12.53'}
G[59533]={59533,'807:42.39,50.00'}
G[59550]={54616,'806:58.56,82.30'}
G[59569]={59569,'806:38.82,31.22'}
G[59573]={59573,'809:60.24,85.78'}
G[59584]={59584,'857:67.93,45.23'}
G[59585]={59585,'807:55.59,52.07'}
G[59586]={59586,'857:67.56,43.51'}
G[59597]={59597,'809:64.88,60.49'}
G[59608]={1747,'Near857'}
G[59620]={54961,'806:58.85,81.12'}
G[59636]={59636,'809:60.17,85.91'}
G[59639]={59639,'807:45,28 H:100086404'}
G[59695]={59695,'809:57.71,61.75'}
G[59696]={59696,'809:57.22,61.20'}
G[59701]={59701,'809:58.09,61.46'}
G[59703]={59703,'809:51.66,67.83'}
G[59704]={56133,'876[1]:75.01,36.13'}
G[59716]={59716,'809:57.32,60.19'}
G[59719]={59719,'857:40.42,49.24'}
G[59727]={59727,'806:54.57,61.76'}
G[59732]={59732,'806:57.01,44.03'}
G[59733]={59733,'806:55.38,23.73'}
G[59735]={59735,'806:50.82,26.80'}
G[59736]={59736,'806:43.58,24.54'}
G[59755]={59755,'809:42.45,68.91'}
G[59806]={59452,'809:49.09,70.38'}
G[59821]={59821,'809:59.63,78.26'}
G[59822]={59822,'876[1]:76.90,35.23'}
G[59855]={57744,'807:17.97,56.44'}
G[59856]={56714,'807:17.99,55.89'}
G[59894]={59894,'809:52,67.2'}
G[59899]={56784,'806:49.30,61.42'}
G[59905]={59905,'811:57.26,42.99'}
G[59906]={63266,'811:74.17,41.82'}
G[60021]={56474,'807:18.16,55.82'}
G[60042]={60042,'808:50.22,76.63'}
G[60055]={60055,'808:36.31,72.35'}
G[60135]={60135,'857:67.62,42.50'}
G[60136]={60136,'857:67.49,44.59'}
G[60139]={60139,'857:45.99,78.91'}
G[60161]={60161,'809:44.48,89.92'}
G[60173]={60173,'857:51.53,76.85'}
G[60175]={60175,'809:48.14,49.04'}
G[60178]={60178,'809:42.94,88.32'}
G[60182]={60182,'857:51.65,75.29'}
G[60230]={60230,'807:84.50,21.06'}
G[60231]={60231,'807:56.49,50.36'}
G[60232]={60232,'857:76.74,8.38'}
G[60289]={60289,'857:52.43,77.98'}
G[60299]={60299,'857:45.35,84.05 H:100080827'}
G[60358]={60358,'857:42.27,89.84'}
G[60416]={60416,'809:42.81,69.63'}
G[60422]={60422,'857:51.56,77.42'}
G[60436]={60436,'809:63.17,29.38'}
G[60441]={60441,'857:52.47,76.60'}
G[60491]={60491,'Z809 H:100089317'}
G[60503]={60503,'809:42.42,69.65'}
G[60506]={60506,'857:31.34,63.42'}
G[60528]={60528,'857:31.29,63.59'}
G[60529]={60529,'857:31.36,63.62'}
G[60564]={60564,'809:36.47,77.02'}
G[60566]={54567,'301:74.20,91.99'}
G[60570]={54568,'4:45.6,12.6'}
G[60578]={60578,'867[1]:35.91,44.60 806:56.18,57.87>867'}
G[60585]={60585,'886:80.53,55.99'}
G[60588]={60506,'857:31.31,63.58'}
G[60596]={60596,'809:42.36,69.79'}
G[60622]={60622,'810:67.94,67.67'}
G[60673]={60673,'857:68.35,42.09'}
G[60674]={60674,'857:68.34,43.49'}
G[60675]={60675,'857:67.21,41.14'}
G[60677]={60677,'809:40.31,81.53'}
G[60678]={60678,'809:40.27,81.57'}
G[60679]={60679,'809:42.49,69.32'}
G[60684]={60684,'810:67.25,52.22'}
G[60687]={60687,'810:67.20,52.28'}
G[60688]={60688,'810:71.15,56.69'}
G[60694]={60694,'809:60.61,21.35'}
G[60735]={60735,'810:66.98,51.42'}
G[60757]={60694,'809:67.04,33.34'}
G[60785]={60694,'809:60.61,21.35'}
G[60795]={54961,'809:43.79,51.05'}
G[60857]={60622,'810:67.94,67.68'}
G[60864]={60864,'810:82.59,73.02'}
G[60871]={60688,'810:71.18,56.74'}
G[60903]={60903,'810:82.71,73.16'}
G[60951]={60903,'810:82.69,73.10'}
G[60968]={60968,'809:67.23,55.91 809:70.27,51.27 809:71.76,44.90 809:66.41,46.34 809:68.48,44.60'}	-- Xuen exists in more than one place at the same time, though logically, one probably will get the next fight in the round from the nearest one
G[60970]={55122,'806:58.86,81.67'}
G[60973]={60973,'809:75.13,87.93'}
G[60981]={54913,'809:68.54,56.42'}
G[61016]={61016,'810:61.58,79.35'}
G[61020]={61020,'810:51.67,87.25'}
G[61021]={61021,'810:76.42,82.53'}
G[61026]={61026,'807:36.19,68.29'}
G[61065]={60973,'Near809'}
G[61066]={60688,'810:76.42,82.43'}
G[61097]={60175,'809:48.11,48.99'}
G[61118]={61118,'809:66.30,50.67'}
G[61121]={61121,'811:84.62,62.42'}
G[61161]={61161,'810:39.21,62.01'}
G[61203]={62321,'880:52.38,68.07'}
G[61218]={54961,'806:54.02,91.19'}
G[61261]={60687,'810:82.68,73.02'}
G[61297]={61297,'Near809'}
G[61371]={54961,'809:62.33,29.05'}
G[61398]={61398,'885[3]:39.18,75.02'}
G[61454]={60684,'809:29.27,62.26'}
G[61467]={61467,'810:79.38,84.45'}
G[61468]={61021,'810:79.46,84.48'}
G[61469]={61021,'810:76.93,78.78'}
G[61470]={61470,'810:75.86,83.14'}
G[61473]={61473,'809:43.91,89.55'}
G[61474]={61474,'809:72.54,94.17'}
G[61482]={61482,'810:49.14,71.23'}
G[61485]={61485,'887[1]:50.35,44.23'}
G[61495]={61495,'809:63.44,28.73','Upstairs'}
G[61496]={61496,'809:63.36,30.63'}
G[61503]={61503,'809:63.73,30.71'}
G[61504]={61504,'809:57.73,59.70'}
G[61511]={61511,'809:62.43,30.12'}
G[61512]={61512,'809:34.54,59.12'}
G[61528]={61528,'680[1]:33.97,77.51'}
G[61534]={61503,'Near809'}
G[61539]={61539,'810:43.86,65.76'}
G[61580]={61580,'810:39.35,62.29'}
G[61581]={61581,'810:39.34,62.21'}
G[61583]={61583,'810:38.80,62.39'}
G[61584]={61584,'810:39.42,61.96'}
G[61585]={61585,'810:39.15,62.07'}
G[61621]={59272,'809:74.67,76.87'}
G[61625]={61625,'810:49.20,71.31'}
G[61636]={61636,'899[1]:50.28,82.49'}
G[61693]={59354,'809[9]:64.64,60.92'}
G[61716]={61716,'680[1]:67.95,11.30'}
G[61724]={61724,'680[1]:68.14,11.58'}
G[61744]={61744,'809:53.98,84.26'}
G[61759]={61759,'873:56.72,75.74'}
G[61796]={29611,'301:82.60,28.10'}
G[61816]={61816,'809:34.96,59.40'}
G[61819]={60687,'809:31.29,61.51'}	-- 809:35.12,59.66
G[61820]={61016,'809:29.24,62.30'}
G[61822]={61822,'680[1]:68.31,12.80'}
G[61823]={61823,'680[1]:69.36,10.92'}
G[61847]={54961,'809:57.34,61.69'}
G[61850]={54961,'809:57.34,61.69'}
G[61880]={61880,'810:70.34,86.66'}
G[61881]={61881,'810:70.46,86.37'}
G[61962]={54961,'811:83.27,29.68'}
G[61970]={61970,'858:62.05,56.76 H:100082870'}
G[62092]={25237,'321[1]:70.62,31.38'}
G[62112]={62112,'811:14.15,76.98'}
G[62124]={62124,'810:67.37,80.68'}
G[62151]={62151,'858:54.88,36.16'}
G[62166]={62166,'858:72.56,28.67'}
G[62180]={62180,'858:54.32,36.08'}
G[62202]={62202,'858:70.19,25.64'}
G[62203]={62203,'858:73.68,27.58'}
G[62205]={62205,'887[2]:0.00,0.00'}
G[62216]={60684,'809:31.34,61.61'}
G[62227]={60687,'Near809'}
G[62232]={62180,'Near858'}
G[62236]={60687,'877[2]:83.48,56.20 809:36.70,47.46>877'}
G[62273]={60688,'810:61.64,79.33'}
G[62274]={60688,'810:54.02,78.06'}
G[62275]={60688,'810:47.48,78.87'}
G[62278]={62278,'810:53.93,78.12'}
G[62295]={62295,'Near810'}
G[62304]={60687,'810:49.01,70.45'}
G[62321]={62321,'806:47.38,37.01'}
G[62322]={62322,'806:48.16,34.59'}
G[62377]={62377,'807:48.31,33.47'}
G[62378]={60864,'Near810'}
G[62379]={62379,'Near810'}
G[62385]={62385,'807:44.25,34.20'}
G[62410]={60688,'810:76.37,82.46'}
G[62412]={60688,'810:61.10,83.03'}
G[62436]={61021,'810:67.32,80.85'}
G[62444]={61021,'810:74.27,84.96'}
G[62491]={65289,'882:49.59,60.71'}
G[62519]={62519,'858:55.11,34.25'}
G[62538]={62202,'858:54.98,34.05'}
G[62540]={62540,'858:43.32,63.50'}
G[62547]={61482,'810:49.14,71.23'}
G[62573]={62573,'810:51.27,83.03'}
G[62658]={62658,'807:70.82,24.09'}
G[62666]={62666,'858:51.21,11.40'}
G[62667]={62667,'858:50.73,11.71'}
G[62668]={62668,'858:51.16,11.19'}
G[62730]={61016,'810:61.60,79.29'}
G[62736]={60688,'810:61.12,83.07'}
G[62754]={62754,'858:52.98,12.38'}
G[62767]={62767,'858:27.4,16.0'}
G[62771]={62771,'858:38.64,17.25'}
G[62772]={62772,'858:38.16,17.34'}
G[62774]={62774,'858:54.94,34.13'}
G[62779]={56133,'858:50.44,12.05'}
G[62786]={61020,'810:53.99,86.96'}
G[62788]={61020,'810:53.99,86.96'}
G[62802]={61021,'810:46.12,82.47'}
G[62810]={62810,'810:28.86,22.58'}
G[62859]={62859,'858:51.13,11.12'}
G[62871]={62871,'809:72.67,92.34'}
G[62872]={62872,'857:51.52,77.18'}
G[62898]={62898,'810:54.29,79.05'}
G[62901]={62901,'810:71.08,57.32'}
G[62903]={62903,'810:74.39,81.46'}
G[62909]={62909,'810:50.08,71.98'}
G[62923]={62923,'806:22.87,30.60'}
G[62963]={56133,'858:54.13,20.34'}
G[62973]={56133,'858:50.18,10.19'}
G[62996]={62996,'903[1]:70.03,46.75'}
G[63009]={63009,'810:49.53,70.51'}
G[63013]={63013,'811[3]:40.28,70.73 811:87.29,69.37'}
G[63014]={63014,'30:40.31,66.01'}
G[63054]={62666,'858:51.16,11.36'}
G[63061]={63061,'4:52.71,41.29'}
G[63067]={63067,'9:49.21,56.07'}
G[63070]={63070,'41:55.22,51.34'}
G[63071]={63071,'858:25.70,50.29'}
G[63072]={63072,'858:54.37,35.93'}
G[63073]={63073,'20:60.93,54.32'}
G[63075]={63075,'27:53.83,50.09'}
G[63077]={63077,'464:49.31,52.17'}
G[63080]={63080,'462:47.35,47.35'}
G[63083]={63083,'42:50.12,20.17'}
G[63086]={63086,'321[1]:37.57,79.28'}
G[63145]={63145,'807:51.75,47.77'}
G[63146]={63146,'807:51.88,48.26'}
G[63154]={63154,'807:52.01,48.33'}
G[63156]={63156,'807:51.95,48.32'}
G[63193]={54961,'806:27.56,32.63'}
G[63194]={63194,'37:46.01,40.44'}
G[63195]={61016,'Near810'}
G[63196]={63196,'Near810'}
G[63197]={63197,'Near810'}
G[63217]={54961,'806:30.85,34.06'}
G[63218]={63218,'858:50.19,12.44'}
G[63238]={63238,'895:40.08,35.61'}
G[63258]={63258,'864:41.19,52.13'}
G[63265]={63265,'807:52.00,48.31'}
G[63266]={63266,'811:33.49,40.78'}
G[63272]={63272,'892:53.22,56.84'}
G[63285]={63285,'866:63.21,22.26'}
G[63296]={63296,'889:42.08,68.69 4:42.50,68.85>889'}
G[63307]={54961,'806:28.83,32.62'}
G[63310]={63310,'891:52.57,51.85 4:65.79,83.91>891'}
G[63314]={22893,'899[1]:50.00,18.54'}
G[63315]={18471,'809:68.69,48.39'}
G[63317]={63317,'858:55.65,72.54'}
G[63327]={63327,'890:27.97,28.34'}
G[63328]={62180,'Near858'}
G[63331]={63331,'888:48.69,52.46 41:58.72,33.73>888'}
G[63332]={63332,'893:63.42,42.64'}
G[63335]={63335,'894:50.46,48.66 464:79.41,51.61>894'}
G[63349]={63349,'858:54.73,72.16'}
G[63367]={63367,'809:72.65,93.01'}
G[63484]={63484,'873:53.52,65.76'}
G[63497]={63497,'811:14.22,79.28'}
G[63498]={63498,'858:56.10,70.18'}
G[63500]={63500,'858:50.21,12.24'}
G[63501]={63501,'858:55.83,34.87'}
G[63535]={63535,'809:62.36,79.64'}
G[63542]={63542,'809:56.35,84.39'}
G[63577]={54961,'806:46.84,46.16'}
G[63596]={63596,'301:69.49,25.16'}
G[63614]={63614,'810:49.01,71.33'}
G[63622]={63622,'Near810'}
G[63623]={61021,'Near810'}
G[63624]={61020,'Near810'}
G[63626]={63626,'321[1]:52.56,59.27'}
G[63721]={12919,'857:68.43,43.52'}
G[63748]={63748,'806:28.18,38.98'}
G[63750]={54961,'809:62.32,29.06'}
G[63751]={63751,'809:62.58,79.48'}
G[63754]={63754,'809:53.78,84.11'}
G[63758]={62540,'858:54.26,35.78'}
G[63778]={63778,'807:70.01,23.57 807:55.33,50.15 806:45.72,43.81 807:18.55,56.37'}
G[63784]={54961,'809:62.32,29.06'}
G[63785]={63785,'858:54.83,36.20'}
G[63809]={63809,'806:30.76,41.09 H:100085783'}
G[63822]={63822,'807:16.19,82.53'}
G[63876]={62540,'858:43.32,63.50'}
G[63955]={63955,'Near858'}
G[63983]={63983,'811:83.64,31.09'}
G[63984]={63984,'811:83.41,31.17'}
G[63994]={63994,'811:61.12,20.88'}
G[63996]={63996,'811:62.03,20.62'}
G[64001]={64001,'811:62.68,23.37'}
G[64002]={64002,'811:62.79,20.88'}
G[64007]={64007,'811:63.18,22.31'}
G[64010]={64010,'811:61.25,23.54'}
G[64011]={64011,'811:60.93,23.68'}
G[64013]={62540,'858:43.32,63.50'}
G[64028]={64028,'811:86.44,61.56'}
G[64029]={64029,'811:85.22,62.86'}
G[64030]={64030,'811:84.23,61.44'}
G[64031]={64031,'811:84.20,62.53'}
G[64032]={64032,'811:84.63,63.79'}
G[64033]={64033,'811:86.56,60.06'}
G[64036]={64036,'811:87.15,60.81'}
G[64041]={64041,'903[1]:67.19,38.84'}
G[64047]={64047,'903[2]:57.32,77.26'}
G[64076]={64076,'811[3]:30.93,64.01'}
G[64085]={64085,'811:72.4,50.4'}
G[64101]={64101,'811[3]:43.94,46.65'}
G[64144]={64144,'811[3]:36.72,77.67 811:86.90,70.11'}
G[64149]={64149,'811[3]:35.74,67.30'}
G[64231]={64231,'807:53.58,51.23'}
G[64236]={60688,'810:47.48,78.84'}
G[64259]={64259,'858:54.90,72.83'}
G[64310]={64310,'806:43.10,68.49'}
G[64314]={64314,'807:53.88,47.41','In small cave'}
G[64315]={64315,'807:55.14,47.38'}
G[64330]={64330,'30:41.66,83.67'}
G[64337]={64337,'Near'}
G[64344]={62540,'858:41.76,72.03'}
G[64361]={56133,'876[4]:50.12,48.56'}
G[64387]={63009,'877[1]:68.96,43.16 809:36.70,47.46>877'}
G[64395]={64395,'807:53.52,51.18'}
G[64399]={64399,'867[1]:35.99,44.12 806:56.18,57.87>867'}
G[64432]={63266,'885[1]:30.28,19.26 811:80.82,32.72>885'}
G[64448]={64448,'807:56.02,51.80'}
G[64457]={64457,'807:55.30,50.62'}
G[64464]={64464,'807:52.72,50.42'}
G[64467]={62112,'875[1]:60.91,88.53 811:15.84,74.39>875'}
G[64484]={64484,'811:85.88,62.37'}
G[64488]={64488,'811:84.38,61.67'}
G[64490]={62540,'858:41.76,72.03'}
G[64508]={64508,'811:85.50,60.20'}
G[64517]={64517,'887[1]:57.90,22.98'}
G[64521]={64521,'809:68.92,46.48'}
G[64531]={64531,'811:62.42,21.55'}
G[64533]={64533,'811:60.53,21.55'}
G[64534]={64534,'811:63.37,20.80'}
G[64540]={1747,'809:68.78,43.13'}
G[64542]={58113,'809:68.73,43.02'}
G[64559]={64559,'858:44.57,41.40'}
G[64562]={64562,'898[1]:26.83,58.75'}	-- starting skull location
G[64563]={64562,'898[1]:26.89,58.65'}	-- starting skull location
G[64566]={58113,'811:62.92,28.19'}
G[64572]={64572,'811:86.59,60.00'}
G[64582]={64582,'811:60.82,23.68'}
G[64596]={66209,'806:46.22,84.78'}
G[64597]={64597,'807:54.66,47.04'}
G[64599]={64599,'858:55.02,35.55'}
G[64607]={64607,'810:38.07,64.32'}
G[64610]={58735,'811:83.99,58.64'}
G[64616]={64616,'873:54.42,72.58'}
G[64672]={63785,'858:56.26,58.22'}
G[64691]={64691,'811:82.11,29.59'}
G[64705]={63785,'858:56.24,57.58'}
G[64724]={64724,'858:42.15,33.46 H:100087878'}
G[64738]={64764,'871[2]:39.26,13.39'}
G[64764]={64764,'871[2]:39.26,13.39'}
G[64815]={64815,'858:54.77,34.07'}
G[64822]={64616,'873:75.30,76.27'}
G[64827]={64764,'874[1]:72.70,46.89'}
G[64838]={64764,'874[1]:72.70,46.89'}
G[64841]={64842,'874[2]:49.03,78.52'}
G[64842]={64842,'874[2]:49.03,78.52'}
G[64854]={64855,'874[2]:49.17,24.82'}
G[64855]={64855,'874[2]:49.17,24.82'}
G[64901]={63367,'884:43.72,64.86'}
G[64922]={28070,'811:83.45,31.05'}
G[65189]={65189,'857:31.15,63.16'}
G[65229]={65229,'858:33.41,62.44 H:100087871'}
G[65253]={63072,'858:31.80,88.94'}
G[65289]={65289,'857:51.81,76.06'}
G[65327]={62166,'858:72.55,28.57'}
G[65341]={61539,'810:48.66,71.06'}
G[65354]={65354,'858:66.82,65.33'}
G[65365]={64815,'858:48.11,49.64','In Amberglow Hollow underground'}
G[65395]={65395,'858:54.71,34.76'}
G[65502]={65502,'858:66.29,32.01 A:100088715'}
G[65511]={65511,'858:42.53,55.75'}
G[65528]={65528,'807:83.76,20.18'}
G[65558]={54568,'Near808'}
G[65648]={65648,'39:60.86,18.51'}
G[65651]={65651,'36:33.29,52.58'}
G[65655]={65655,'34:19.83,43.69'}
G[65656]={65656,'673:51.46,73.39'}
G[65669]={65669,'806:57.52,45.31'}	-- blue
G[65670]={65669,'806:57.52,45.31'}	-- green
G[65671]={65669,'806:57.51,45.29'}	-- yellow
G[65690]={61020,'810:51.67,87.32'}
G[65865]={65865,'862:42.24,62.33'}
G[65908]={65908,'806:46.62,85.16'}
G[65910]={65910,'806:46.25,84.73'}
G[65998]={65998,'806:31.42,21.77'}
G[65999]={54870,'806:31.66,21.91'}
G[66023]={66023,'806:46.04,85.14'}
G[66085]={66085,'807:51.99,48.45'}
G[66126]={66126,'4:43.86,28.86'}
G[66129]={66129,'807:52.03,48.41'}
G[66130]={66130,'807:51.75,48.36'}
G[66135]={66135,'11:58.61,53.04'}
G[66136]={66136,'43:20.20,29.55'}
G[66137]={66137,'81:59.66,71.58'}
G[66190]={54870,'806:31.62,11.32'}
G[66199]={66199,'806:39.55,90.03'}
G[66209]={66209,'806:46.22,84.69'}
G[66220]={66220,'806:29.18,13.79'}
G[66225]={66225,'806:27.21,15.71'}
G[66247]={66247,'810:74.83,81.36'}
G[66260]={66260,'809:48.59,42.71'}
G[66292]={66292,'806:42.02,92.82'}
G[66296]={60688,'806:46.25,84.81'}
G[66352]={66352,'121:59.69,49.75'}
G[66372]={66372,'101:57.11,45.69'}
G[66409]={66409,'810:49.13,71.50'}
G[66412]={66412,'241:46.00,60.39'}
G[66415]={66415,'809:64.31,61.43'}
G[66422]={66422,'607:39.59,79.14'}
G[66442]={66442,'182:40.03,56.58'}
G[66466]={66466,'281:65.69,64.47'}
G[66478]={66478,'26:62.93,54.65'}
G[66512]={66512,'23:67.01,52.37'}
G[66515]={66515,'28:35.42,27.76'}
G[66518]={66518,'38:76.75,41.39'}
G[66520]={66520,'29:25.55,47.62'}
G[66522]={66522,'32:40.18,76.50'}
G[66550]={66550,'465:64.37,49.31'}
G[66551]={66551,'467:17.20,50.52'}
G[66552]={66552,'477:60.99,49.36'}
G[66553]={66553,'481:58.89,70.03'}
G[66557]={66557,'473:30.49,41.82'}
G[66581]={54617,'806:41.46,79.14'}
G[66635]={66635,'491:28.59,33.82'}
G[66636]={66636,'510:50.19,59.05'}
G[66638]={66638,'488:59.02,76.99'}
G[66639]={66639,'496:13.18,66.79'}
G[66646]={54870,'806:34.78,10.63'}
G[66656]={54870,'806:33.66,10.61'}
G[66657]={60688,'806:33.71,10.60'}
G[66659]={66659,'806:30.53,7.49'}
G[66660]={66660,'806:30.55,7.14'}
G[66662]={66662,'806:31.99,13.28'}
G[66665]={60688,'806:29.13,13.84'}
G[66667]={55521,'806:31.05,11.02'}
G[66675]={66675,'492:77.36,19.61'}
G[66730]={66730,'806:47.97,54.12'}
G[66733]={66733,'857:62.19,45.88'}
G[66734]={66734,'807:46.00,43.69'}
G[66738]={66738,'809:35.84,73.69'}
G[66739]={66739,'858:55.10,37.56'}
G[66741]={66741,'811:31.18,74.14'}
G[66769]={58465,'811:33.98,38.00'}
G[66815]={66815,'640:49.92,57.05'}
G[66819]={66819,'606:61.37,32.84'}
G[66822]={66822,'700:56.56,56.84'}
G[66824]={66824,'720:56.58,41.91'}
G[66838]={66853,'806:32.06,13.37'}
G[66841]={66853,'806:32.04,13.37'}
G[66845]={66845,'806:29.13,13.72'}
G[66848]={66660,'806:29.37,13.58'}
G[66853]={66853,'806:32.06,13.38'}
G[66875]={62774,'858:55.14,35.38'}
G[66918]={66918,'810:36.30,52.26'}
G[66949]={54617,'806:58.93,81.93'}
G[66998]={66998,'903[1]:47.50,69.93'}
G[67091]={63072,'858:31.80,88.94'}
G[67138]={56133,'858:50.18,10.19'}
G[67153]={55403,'806:28.57,22.16'}
G[67370]={67370,'823:47.04,62.75'}
G[67386]={66292,'857:16.51,79.14','Aboard Skyfire'}
G[67402]={67402,'857:75.86,34.17'}
G[67414]={38966,'914:56.08,75.20'}
G[67436]={67436,'857:39.27,61.86'}
G[67438]={67438,'857:13.90,41.20'}
G[67444]={54614,'857:16.72,78.58','Aboard Skyfire'}
G[67447]={3387,'857:12.66,62.73'}
G[67498]={67438,'857:13.82,41.23'}
G[67503]={67436,'857:39.19,61.96'}
G[67508]={67508,'857:56.36,42.16'}
G[67533]={67533,'857:20.60,58.04'}
G[67534]={67534,'857:20.48,58.06'}
G[67535]={67535,'857:13.79,55.85'}
G[67536]={67536,'857:26.05,58.07'}
G[67537]={67537,'857:22.56,62.33'}
G[67542]={67542,'857:25.54,60.47'}
G[67553]={67533,'857:25.25,60.42'}
G[67554]={67533,'857:22.38,62.27'}
G[67555]={67436,'Near857'}
G[67556]={67438,'Near857'}
G[67557]={67508,'Near857'}
G[67558]={35874,'857:84.32,18.86'}
G[67562]={67562,'857:13.76,55.79'}
G[67565]={67565,'807:53.37,51.45'}
G[67581]={16802,'809:57.07,79.01'}
G[67603]={67834,'809:57.12,78.59'}
G[67608]={55521,'857:12.92,56.13'}
G[67618]={55647,'857:10.30,55.71'}
G[67628]={55180,'857:75.83,34.46'}
G[67630]={54614,'857:89.66,32.79'}
G[67631]={67631,'857:89.68,33.08'}
G[67660]={30116,'928:28.29,52.42'}	-- phase 1 location on ship
G[67662]={67662,'928:33.52,35.15'}	-- phase 2 location at camp.  phase 1 is NPC 567662
G[67663]={36670,'928:32.47,35.24'}	-- phase 2 location at camp.  phase 1 is NPC 567663
G[67673]={34771,'928:32.42,35.22'}	-- phase 2 location at camp.  phase 1 is NPC 567673
G[67682]={28070,'809:59.83,75.95'}
G[67716]={68275,'809:59.81,76.04'}
G[67734]={67734,'809:59.97,75.32'}
G[67751]={67751,'857:10.56,53.75'}
G[67767]={67767,'857:10.52,53.48','Circling fire'}
G[67812]={67812,'857:8.74,64.36'}
G[67834]={67834,'811:20.94,15.57'}
G[67840]={25237,'903[2]:32.23,84.67'}
G[67844]={67844,'809:55.8,34'}
G[67847]={47571,'857:76.32,34.07'}
G[67865]={63778,'857:10.69,53.70'}
G[67866]={56133,'809:71.66,93.22'}
G[67867]={25237,'857:8.67,64.44'}
G[67880]={67880,'857:10.07,53.87'}
G[67881]={67881,'857:89.53,33.54 H:100091854,100091855,100091856'}
G[67901]={67901,'857:15.69,57.69'}
G[67939]={54870,'857:10.38,53.72'}
G[67940]={55122,'857:89.56,32.58'}
G[67948]={1747,'811[4]:66.18,33.31'}
G[67951]={67734,'809[21]:61.88,25.79'}
G[67976]={7944,'857:16.51,79.14','Aboard Skyfire'}
G[67983]={67983,'928:38.54,51.12'}
G[67984]={33538,'928:32.70,35.02'}	-- phase 1 location
G[67985]={70358,'928:28.21,52.84'}	-- phase 1 location on ship
G[67986]={33542,'928:53.94,49.86'}	-- Conqueror's Terrace
G[67989]={68586,'928:38.48,51.33'}
G[67990]={16802,'928:32.51,35.59'}	-- phase 2 location in camp.  phase 1 is NPC 567990
G[67992]={4968,'928:63.24,72.22'}	-- Phase 2 location.  Phase 1 is NPC 70370.
G[67993]={30115,'928:34.74,89.19'}	-- Phase 1 location.  Phase 2 is NPC 567993.
G[67994]={67994,'928:63.47,73.60'}	-- Phase 2 location.  No Phase 1 location.
G[67995]={67995,'928:34.54,89.46'}	-- Phase 1 location.  Phase 2 is NPC 567995.
G[67996]={67996,'928:63.93,73.99'}	-- Phase 1 location.  Phase 2 is NPC 567996.
G[67997]={34880,'928:64.82,73.17'}	-- Phase 1 location.  Phase 2 is NPC 67997.
G[67998]={67998,'928:51.79,47.13'}	-- Beast Pens location
G[67999]={67999,'928:51.85,47.18'}	-- Beast Pens location
G[68000]={68000,'928:63.20,72.29'}
G[68003]={68003,'809:48.80,50.47'}
G[68004]={1747,'809:52.97,46.45'}
G[68017]={1747,'811[4]:66.18,33.31'}
G[68023]={38966,'809:71.63,93.19'}
G[68025]={4949,'889:44.61,66.73'}
G[68059]={4949,'889:44.65,66.74'}
G[68072]={25237,'Near857'}
G[68077]={67834,'41:40,50'}
G[68084]={16802,'480:91.2,37.6'}
G[68106]={1747,'924[1]:26.80,39.00'}
G[68166]={54616,'857:17.33,78.67','Aboard Skyfire'}
G[68182]={68182,'857:16.71,78.54','Aboard Skyfire'}
G[68223]={25237,'809:56,32'}
G[68226]={68226,'857:88.33,34.69'}
G[68242]={29611,'811[4]:67.47,43.30'}
G[68274]={68274,'857:81.49,18.27'}
G[68275]={68275,'857:80.19,16.40'}
G[68287]={36648,'809:60.4,55.2'}
G[68311]={68311,'857:85.24,29.13'}
G[68337]={68337,'809:32.6,30.6'}
G[68370]={16802,'809:53.8,49.2'}
G[68375]={68375,'809:65.12,60.79'}
G[68392]={29611,'857:85.29,29.12'}
G[68399]={29611,'Near857'}
G[68417]={68417,'809:59.20,84.26'}
G[68462]={68462,'858:61.17,87.55'}
G[68463]={68463,'810:57.13,42.17'}
G[68464]={68464,'806:28.92,35.99'}
G[68465]={68465,'809:64.94,93.73'}
G[68501]={68337,'809:32.89,26.34'}
G[68526]={68526,'922[2]:69.97,47.06'}
G[68531]={68531,'922[2]:23.86,81.90'}
G[68538]={68003,'857:88.89,31.75'}
G[68544]={68003,'857:43.45,86.54'}
G[68586]={68586,'504[2]:50,48'}
G[68589]={68586,'924[2]:31.50,50.18'}
G[68590]={68586,'924[2]:45.24,53.86'}
G[68651]={4968,'381:38.92,32.79'}
G[68687]={30115,'924[1]:34.27,48.70'}
G[68690]={29611,'857:87.91,33.10'}
G[68908]={55283,'857:89.80,32.44'}
G[68939]={1747,'809:56.38,34.31'}
G[68987]={1747,'809:55.96,31.88'}
G[69026]={29611,'912:42.03,14.93'}
G[69090]={55122,'857:87.72,33.07','In the keep'}
G[69227]={69227,'928:46.15,69.11'}
G[69228]={69228,'928:49.77,80.34'}
G[69326]={69326,'928:55.19,30.87'}
G[69359]={69359,'929:41.76,79.30'}
G[69360]={69360,'929:52.01,75.51'}
G[69371]={69371,'928:47.01,66.74'}	-- phase 2 location
G[69389]={69389,'928:38.47,51.17'}
G[69413]={61021,'928:58.67,42.76'}
G[69418]={69418,'928:32.63,34.91'} -- phase 1 location
G[69425]={58113,'928:46.73,66.77'}	-- phase 2 location
G[69433]={69433,'928:32.78,32.67'}	-- phase 1 location
G[69461]={69461,'928:57.6,33.8 H:100094721,100094862'}
G[69522]={69522,'HM 858:56.07,69.59'}
G[69529]={69529,'HM 806:47.18,47.18'}
G[69533]={69533,'HM 857:73.99,9.50'}
G[69535]={69535,'HM 809:71.15,90.86'}
G[69536]={69536,'HM 810:71.52,56.30'}
G[69550]={69550,'HM 807:51.81,51.32'}
G[69551]={69551,'HM 811:77.76,33.99'}
G[69572]={69572,'HM 811:79.67,37.26'}
G[69668]={69668,'928:64.87,72.94'}	-- Phase 1 location.  Phase 2 is NPC 569668.
G[69670]={69670,'928:40.11,59.13'}	-- Phase 2 location.  No phase 1 location? Or is this really phase 1 location?  What differs from NPC 569670 which is at base?
G[69673]={69673,'928:31.46,83.24'}	-- Phase 1 location.  Phase 2 is NPC 569673.
G[69674]={69674,'928:31.67,83.20'}	-- Phase 1 location.  Phase 2 is NPC 569674.
G[69675]={58735,'928:42.32,75.04'}	-- Phase 1 location.  Phase 2 is NPC 569675.
G[69677]={69677,'928:63.82,74.03'}	-- Phase 1 location.  Phase 2 is NPC 569677.
G[69678]={19644,'928:64.12,73.91'}	-- Phase 1 location.  Phase 2 is NPC 569678.
G[69741]={4968,'928:63.16,73.87'}
G[69742]={16802,'928:32.91,32.58'}
G[69782]={64616,'873:54.60,71.76','Upstairs'}
G[70022]={70022,'929:33.00,53.89','In cave'}
G[70100]={64616,'933:60.26,28.69'}
G[70160]={60688,'928:51.42,46.08'}
G[70183]={70183,'928:63.25,72.25'}
G[70296]={70296,'301:67.55,18.51'}
G[70297]={61021,'928:63.20,73.90'}	-- Alliance version of Taoshi
G[70301]={70301,'321[1]:69.8,40.8'}
G[70316]={61021,'928:51.42,46.18'}
G[70320]={61021,'934[1]:35.76,79.84'}
G[70358]={70358,'810:50.79,73.38'}
G[70360]={30115,'810:49.93,69.04'}
G[70370]={4968,'928:34.60,89.43'}	-- Phase 1 position on ship, Phase 2 is NPC 67992
G[70398]={70398,'807:58.92,46.92'}
G[70476]={64616,'873:75.29,76.28'}
G[70517]={20735,'928:31.56,83.13'}	-- Phase 1 position.  Phase 2 is NPC 570517.
G[70520]={37527,'928:36.72,64.78'}	-- phase 2 location	[TODO: Deal with location 928:32.44,35.56 which is at camp when not in the field]
G[70551]={70358,'928:58.78,42.69'}
G[70552]={67998,'928:58.70,42.69'}
G[70561]={70567,'928:32.45,35.23'}
G[70567]={70567,'928:63.24,72.20'}
G[70751]={70751,'925[1]:60.42,77.43'}
G[70752]={70752,'922[2]:52.33,25.38'}	-- 922[2]:54.33,27.92
G[70859]={4949,'941:48.74,65.30'}
G[70860]={70860,'941[1]:43.13,41.33'}
G[70902]={70902,'947[15]:60.09,31.98'}
G[70909]={79917,'941:30.90,25.82'}
G[70910]={79917,'941:46.40,32.16'}
G[70941]={79917,'941[8]:50.60,54.38'}
G[70978]={38966,'4:49.69,40.08'}
G[70980]={70980,'809:44.97,47.84'}
G[71027]={55283,'4:54.41,9.80'}	-- 13:59.53,46.21
G[71143]={71143,'951:33.80,81.59'}
G[71148]={38966,'4:56.39,73.41'}
G[71150]={56133,'4:49.75,40.06'}
G[71320]={38243,'4:51.79,39.29'}
G[71322]={38243,'4:51.79,39.29'}	-- this was 71320 until 32810 was turned in
G[71333]={71333,'4:55.03,73.30'}
G[71336]={71336,'811:85.74,59.56'}
G[71352]={64616,'806:58.76,59.20'}
G[71424]={64616,'873:73.25,79.63'}
G[71426]={64616,'873:75.25,76.32'}
G[71483]={71483,'811:62.2,23.8'}
G[71502]={71502,'947:52.03,32.66'}
G[71641]={71641,'947:41.29,55.11'}
G[71823]={71823,'951:44.82,71.98'}
G[71864]={71864,'951:59.06,48.85'}
G[71868]={71868,'951[22]:42.39,70.47'}
G[71869]={71869,'951[22]:62.15,35.29'}
G[71876]={71869,'951[22]:52.87,56.35'}
G[71908]={71908,'951:40.39,77.78'}
G[71919]={71919,'951:37.30,78.12'}
G[71939]={71939,'951:21.92,39.75'}
G[71940]={71940,'951:23.09,71.07'}
G[71955]={71955,'951:34.16,47.49'}
G[71986]={71986,'951:19.13,63.76'}
G[72007]={72007,'951:59.45,40.75'}
G[72045]={72045,'951:26.26,38.58'}
G[72049]={72049,'951:43.57,69.84'}
G[72160]={72160,'38:74.06,44.41'}
G[72193]={72193,'951:33.78,83.32'}
G[72230]={74651,'941:57.14,41.49'}
G[72245]={72245,'951:47.36,88.12'}
G[72274]={72274,'941:38.54,52.43'}
G[72297]={72297,'941:68.49,22.45'}
G[72348]={72348,'941:71.71,24.66'}
G[72373]={72373,'941:63.22,60.03'}
G[72413]={72413,'947:77.46,37.61'}
G[72426]={72426,'951:40.93,73.45'}
G[72571]={72571,'950:45.45,35.87'}
G[72623]={72623,'947:29.47,24.55'}
G[72637]={78430,'947:29.26,25.70'}
G[72654]={72654,'1024:49.41,39.27'}
G[72695]={64616,'951:34.52,53.84'}
G[72723]={64616,'811:83.17,29.65'}
G[72751]={1181758,'951:49.37,69.41'}
G[72754]={1181758,'951:34.57,26.67'}
G[72755]={72755,'951:66.06,23.26'}
G[72761]={72761,'951:43.69,53.29'}
G[72762]={72762,'951:43.05,69.04'}
G[72764]={72764,'951:22.31,67.95'}
G[72765]={72765,'951:23.35,33.03'}
G[72767]={72767,'951:28.39,28.31'}
G[72769]={72769,'951[22]:58.81,27.50'}
G[72771]={72771,'951[22]:67.13,22.78'}
G[72775]={72775,'951:65.82,72.98'}
G[72777]={72777,'951:64.77,70.72'}
G[72805]={72805,'951:65.16,55.89'}
G[72807]={72807,'951:51.04,45.83'}
G[72808]={72808,'951:54.64,44.49'}
G[72814]={78430,'941:31.46,16.25'}
G[72822]={3432,'950:49.30,47.99'}
G[72836]={78430,'941:31.82,11.83'}
G[72837]={72837,'941:31.75,11.77'}
G[72841]={72841,'951:29.74,36.90'}
G[72842]={72842,'Z951 H:100104266'}
G[72843]={72843,'Z951 H:100104266'}
G[72844]={72844,'Z951 H:100104266'}
G[72870]={72870,'951:34.58,53.59'}
G[72874]={78558,'941:31.73,11.88'}
G[72875]={72875,'951:52.85,75.52'}
G[72890]={72890,'941:30.79,41.51'}
G[72892]={72892,'951:54.19,75.65'}
G[72894]={72894,'951:52.05,82.57'}
G[72895]={72895,'951:68.27,35.51'}
G[72897]={72897,'951:33.30,34.38'}
G[72908]={72908,'951:40.44,69.08'}
G[72909]={72909,'951:38.74,70.08'}
G[72939]={72939,'321[1]:38.94,46.84'}
G[72940]={72274,'Near941'}
G[72970]={72970,'951:62.67,62.81'}
G[72976]={72976,'941:66.03,49.09'}
G[72997]={62295,'951:39.13,46.77'}
G[73018]={73018,'951:41.91,73.55'}
G[73021]={73021,'951:37.05,76.37'}
G[73025]={73025,'951:35.59,77.47'}
G[73082]={73082,'951:34.72,59.68'}
G[73097]={72373,'Near941'}
G[73136]={54961,'811:67.43,45.84'}
G[73138]={64616,'873:54.74,72.72'}
G[73157]={73157,'951[22]:48.85,33.45'}
G[73158]={73158,'951:31.07,52.46'}
G[73160]={73160,'Z951 H:100104266'}
G[73161]={73161,'951:24.25,52.64'}
G[73162]={73162,'951[22]:61.08,49.30'}
G[73163]={73163,'951:42.85,69.42'}
G[73166]={73166,'951:22.36,36.25'}
G[73167]={73167,'951:68.47,58.31'}
G[73169]={73169,'951:52.81,82.47'}
G[73170]={73170,'951:56.65,75.84'}
G[73171]={73171,'951:65.88,42.07'}
G[73172]={73172,'951:43.70,34.93'}
G[73173]={73173,'951:42.54,25.71'}
G[73175]={73175,'951:54.69,53.91'}
G[73277]={73277,'951:68.43,44.81'}
G[73279]={73279,'951:14.52,45.19'}
G[73281]={73281,'951:26.06,22.85'}
G[73282]={73282,'951:65.46,30.18'}
G[73284]={73284,'941:67.13,49.16'}
G[73293]={73293,'951:41.25,47.28'}
G[73303]={73303,'951:42.86,55.20'}
G[73318]={54961,'953[12]:50.08,60.07'}
G[73335]={73335,'953[12]:50,60'}
G[73343]={73343,'951:46.77,46.90'}
G[73348]={73348,'951:23.12,71.65'}
G[73353]={73353,'951:22.01,40.93'}
G[73360]={73360,'941:44.63,43.38'}
G[73373]={73373,'941:21.18,41.61'}
G[73395]={78994,'947:46.38,38.62'}
G[73425]={73425,'947:40.60,54.82'}
G[73426]={73426,'1018:49.07,82.34'}
G[73468]={73468,'947:23.08,24.38 H:100113103'}
G[73480]={77417,'941:21.95,14.64'}
G[73570]={73570,'951:65.00,50.60'}
G[73626]={73626,'951:34.68,60.32'}
G[73649]={73649,'951:34.69,52.85'}
G[73657]={73657,'951:41.79,63.73'}
G[73666]={73666,'951:35.79,35.39'}
G[73691]={10667,'811:80.65,33.16'}
G[73703]={73703,'951:70.53,80.95'}
G[73877]={73877,'947:47.09,14.40','In cave'}
G[73953]={76748,'947:36.39,19.28'}
G[73973]={77270,'947:39.81,18.69'}
G[74000]={79917,'941:36.00,25.77'}
G[74009]={44375,'688[1]:48.47,12.06 43:16.52,11.03>688'}
G[74020]={74020,'811[4]:41.15,43.29'}
G[74043]={17468,'947:49.12,38.51'}
G[74056]={74056,'823:48.99,88.33'}
G[74121]={74121,'947:42.14,57.36'}
G[74125]={74125,'949:54.23,55.93'}
G[74146]={74146,'947:42.39,18.51'}
G[74148]={74148,'947:41.76,15.04'}
G[74163]={70860,'941:48.62,64.71'}
G[74222]={74222,'941:35.92,25.72'}
G[74223]={74223,'941:46.40,32.04'}
G[74224]={74224,'947:41.46,15.80'}
G[74233]={74233,'947:62.46,36.83'}
G[74253]={74272,'941:57.65,41.58'}
G[74254]={74254,'941[2]:50.83,70.15 H:100112566'}
G[74272]={74272,'941:16.78,57.83'}
G[74273]={70860,'941[1]:43.55,23.12'}
G[74330]={74272,'941:70.06,38.17'}
G[74343]={74343,'947:46.63,37.34'}
G[74358]={74358,'941:41.61,52.91'}
G[74367]={44837,'760[1]:24.52,23.72 61:47.56,23.60>760'}
G[74408]={12736,'688[1]:48.46,11.73 43:16.52,11.03>688'}
G[74409]={44375,'688[2]:87.49,86.16'}
G[74434]={74434,'760[1]:44.37,59.74'}
G[74476]={74476,'688[1]:12.15,41.29'}
G[74507]={74507,'941:19.04,58.36'}
G[74547]={74547,'947:47.04,14.35','In cave'}
G[74565]={74565,'688[1]:54.73,59.05'}
G[74593]={74651,'949:46.58,71.48'}
G[74594]={70860,'949:37.28,77.01'}
G[74606]={74606,'949:41.45,74.10'}
G[74611]={74611,'949:40.49,71.95'}
G[74635]={74635,'941:24.50,28.81'}
G[74651]={74651,'941:20.80,57.93'}
G[74741]={74741,'947:42.86,40.38'}
G[74790]={74790,'964[1]:66.46,20.89'}
G[74808]={4949,'976:50.82,37.58'}
G[74877]={78994,'947:34.21,63.25'}
G[74888]={44837,'760[1]:36,70 61:47.56,23.60>760'}
G[74927]={74927,'964[1]:64.95,24.79'}
G[74977]={74977,'941:64.97,39.49'}
G[75005]={75005,'947:46.04,38.92'}
G[75008]={75008,'949:41.42,66.11'}
G[75028]={79537,'946:49.79,48.65'}
G[75043]={75043,'947:49.43,36.83 H:100113103,100114877,100115278,100115281,100114984,100115507,100115343,100114972'}
G[75119]={79537,'946:55.67,67.69'}
G[75121]={75121,'946:55.50,67.68'}
G[75127]={78554,'949:52.84,59.69'}
G[75136]={78568,'949:63.17,52.40'}
G[75145]={78554,'947:52.23,46.05'}
G[75146]={79576,'949:63.22,52.26'}
G[75155]={75155,'688[2]:84.90,86.10'}
G[75176]={70860,'941[1]:43.13,23.26'}
G[75177]={70860,'941[1]:34.22,72.94'}
G[75186]={4949,'941[2]:70.75,78.58'}
G[75188]={70860,'941[3]:66.41,56.49'}
G[75191]={75191,'964[1]:45.14,48.03'}
G[75207]={75207,'949:63.27,54.51 H:100116159'}
G[75246]={75121,'946:61.00,72.53'}
G[75249]={78577,'946:60.52,72.40'}
G[75250]={79537,'946:57.24,77.05'}
G[75256]={78519,'946:57.18,76.93'}
G[75283]={75283,'946:76.27,42.72'}
G[75288]={75288,'946:70.50,56.84'}
G[75290]={75290,'946:76.30,42.85'}
G[75311]={75311,'946:77.75,43.97'}
G[75323]={75323,'946:70.53,57.32'}
G[75324]={75324,'946:70.77,56.78'}
G[75389]={75121,'946:42.96,76.23'}
G[75392]={79537,'946:42.89,76.08'}
G[75469]={75311,'946:82.64,37.78'}
G[75483]={75483,'947:65.82,36.32'}
G[75593]={75593,'949:42.66,37.82'}
G[75606]={33260,'688[1]:48.47,12.06 43:16.52,11.03>688'}
G[75607]={33256,'688[1]:48.46,11.73'}
G[75710]={14627,'949:47.55,94.09'}
G[75803]={78554,'946:69.57,20.46'}
G[75804]={78994,'946:69.55,20.52'}
G[75805]={78558,'946:54.18,36.42'}
G[75806]={70860,'946:61.51,10.95'}
G[75808]={74651,'946:58.93,20.15'}
G[75819]={75819,'949:42.76,63.01'}
G[75873]={3391,'946:62.06,10.41'}
G[75874]={78568,'946:69.38,20.34'}
G[75878]={78994,'949:47.71,93.31'}
G[75884]={75884,'947:45.70,26.31'}
G[75896]={75896,'946:73.07,38.74'}
G[75913]={75896,'946:76.72,55.24'}
G[75924]={3391,'946:58.95,20.72'}
G[75941]={3391,'946:55.68,41.16'}
G[75942]={75968,'Near946'}
G[75958]={70860,'946:58.91,20.20'}
G[75959]={70860,'946:55.60,40.95'}
G[75968]={75968,'946:61.79,38.88'}
G[76067]={78994,'947:40.60,54.94'}
G[76111]={9540,'19:51.79,28.72'}
G[76186]={76186,'947:45.79,26.29'}
G[76200]={76200,'947:56.96,57.49'}
G[76204]={45417,'947:53.60,57.28'}
G[76240]={70860,'941:19.74,44.76'}
G[76266]={76266,'989[2]:53.59,35.76'}
G[76267]={76267,'989[2]:46.50,30.33'}
G[76292]={76292,'989[2]:47.52,37.27'}
G[76407]={76407,'947:0.00,0.00'}
G[76411]={74272,'976:49.71,49.64'}	-- garrison level 1 location
G[76447]={76447,'947:45.49,37.72'}
G[76452]={76452,'941:64.74,39.75'}
G[76484]={70860,'941:76.15,55.16'}
G[76487]={72274,'941:73.43,58.83'}
G[76508]={76508,'950:40.75,12.96'}
G[76517]={76517,'949:52.40,78.35'}
G[76518]={76518,'969[3]:37.44,36.94'}
G[76534]={76534,'949:53.13,79.74'}
G[76552]={79795,'947:46.36,38.62'}
G[76557]={70860,'941:20.94,57.92'}
G[76609]={41124,'19:48.73,31.88'}
G[76616]={74272,'941:17.67,56.70'}
G[76622]={4949,'941:70.07,38.27'}
G[76662]={76662,'941:24.14,39.32'}
G[76665]={76665,'946:65.42,50.73'}
G[76687]={76687,'946:30.91,70.74'}
G[76688]={74611,'949:46.27,69.28'}
G[76720]={4949,'941[6]:53.24,56.18'}
G[76725]={74222,'941:76.15,55.16'}
G[76730]={76730,'941:76.32,54.98'}
G[76746]={76746,'941[1]:42.77,44.74'}
G[76748]={76748,'947:36.39,19.26'}
G[76790]={76790,'946[13]:52.20,38.77'}
G[76804]={75121,'946:50.01,48.61'}
G[76826]={76826,'946:36.20,65.05'}
G[76862]={76862,'941:19.23,59.18'}
G[76872]={76872,'976:43.08,57.13'}
G[76889]={76889,'941:19.53,51.01'}
G[76904]={76904,'946:58.84,12.07'}
G[76926]={76926,'946:63.10,26.06'}
G[76941]={76941,'941:21.63,55.08'}
G[76987]={74606,'949:39.32,71.99'}
G[76998]={76998,'951:25.45,27.15'}
G[77014]={77014,'949:36.85,67.91'}
G[77031]={77031,'946:56.89,25.97'}
G[77082]={77082,'946:44.84,90.51'}
G[77093]={77093,'949:53.48,70.74'}
G[77106]={77106,'941:84.11,65.10 H:100109121'}
G[77120]={45658,'995[3]:14.23,45.38'}
G[77147]={77147,'941:84.11,65.11'}
G[77160]={14627,'941:86.39,48.92'}
G[77161]={78568,'971:64.69,67.37'}
G[77167]={78568,'Near941'}
G[77184]={78558,'962:64.28,47.02'}
G[77209]={79243,'971:41.22,49.31'}	-- garrison level 1 location
G[77210]={77210,'941:83.21,62.76'}
G[77211]={77211,'947:46.11,25.49'}
G[77217]={77217,'971:64.50,69.86'}
G[77221]={77221,'321[1]:53.84,78.82'}
G[77270]={77270,'947:46.27,15.88'}
G[77282]={17468,'947:46.37,38.69'}
G[77312]={78554,'947:52.23,46.04'}
G[77354]={77354,'971:46.99,59.27'}	-- plot 18
G[77356]={77356,'971:46.99,59.27'}	-- plot 18
G[77359]={77359,'971:46.99,59.27'}	-- plot 18
G[77363]={77363,'971:46.99,59.27'}	-- plot 18
G[77365]={77365,'971:46.99,59.27'}	-- plot 18
G[77367]={77367,'971:40.09,56.58'}	-- plot 24
G[77372]={77372,'971:46.99,59.27'}	-- plot 18
G[77377]={77377,'971:40.09,56.58'}	-- plot 24
G[77378]={77378,'971:46.99,59.27'}	-- plot 18
G[77382]={77382,'971:46.99,59.27'}
G[77383]={77383,'971:46.99,59.27'}	-- location is top of stairs for plot 18
G[77417]={77417,'947:19.08,28.56'}
G[77426]={77426,'946:49.03,91.66'}
G[77528]={77528,'946:35.64,79.86'}
G[77580]={75121,'946:45.70,74.45'}
G[77581]={79537,'946:45.70,74.05'}
G[77582]={78519,'946:31.21,73.60'}
G[77629]={77629,'946:34.01,73.97'}
G[77730]={77730,'971:65.22,41.84'}	-- garrison level 2 location ? 65.07,42.01
G[77733]={77733,'971:54.52,13.92'}	-- garrison level 2 location, though he moves about a bit
G[77734]={77734,'984[1]:48.02,33.15'}
G[77737]={77737,'946:62.15,63.74'}
G[77775]={77775,'971:46.99,59.27'}	-- plot 18
G[77777]={77777,'971:46.99,59.27'}	-- plot 18
G[77778]={77778,'971:46.99,59.27'}	-- plot 18
G[77781]={77781,'971:46.99,59.27'}	-- plot 18
G[77784]={77784,'946:49.19,92.28','Top of lift'}
G[77789]={77789,'Near H:100097985'}
G[77791]={77791,'971:46.99,59.27'}	-- plot 18
G[77792]={77792,'971:46.99,59.27'}	-- plot 18
G[77799]={77082,'946:43.42,75.96'}
G[77831]={77831,'971:46.99,59.27'}	-- plot 18
G[77853]={19644,'946:84.55,31.70'}
G[77857]={77857,'948:51.19,50.56'}
G[77869]={77737,'946:50.42,87.50'}
G[77905]={77905,'984[1]:48.18,32.44'}
G[77911]={77210,'941:82.64,69.83'}
G[77928]={3391,'941:78.18,55.14'}
G[77945]={77945,'941:87.43,52.82'}
G[77979]={77979,'941:46.38,15.97'}
G[77980]={77980,'941:47.01,16.88'}
G[77981]={77981,'941:44.73,12.68'}
G[77982]={21984,'947:59.22,82.25'}
G[77988]={77988,'941:42.55,14.80'}
G[77995]={77995,'941:47.83,18.94'}
G[77998]={77998,'941:43.62,15.52'}
G[78028]={77737,'946:57.25,76.89'}
G[78030]={78030,'949:41.35,91.47'}
G[78056]={78239,'941:48.70,14.70'}
G[78082]={81789,'946:50.39,87.32'}
G[78083]={78083,'946:50.51,87.55'}
G[78102]={78102,'946:57.54,76.70'}
G[78168]={78168,'947:57.98,88.72'}
G[78185]={78239,'941:48.70,14.70'}
G[78187]={41006,'949:39.92,37.15'}
G[78192]={41005,'976:41.92,45.49'}
G[78197]={78197,'949:40.32,40.30'}
G[78207]={78207,'971:46.99,59.27'}	-- location is top of stairs for plot 18
G[78208]={78208,'941:52.63,40.42'}
G[78209]={78209,'941:52.51,40.42'}
G[78222]={78222,'941[1]:20.12,52.81'}
G[78239]={78239,'941:40.22,21.46'}
G[78251]={41006,'949:54.16,56.07'}
G[78257]={78257,'949:52,54 H:100114037,100114038'}
G[78258]={21984,'947:58.14,93.89'}
G[78269]={78269,'949[20]:0.00,0.00'}
G[78272]={70860,'941:41.79,69.68'}
G[78277]={78277,'950:65.57,58.43'}
G[78323]={3391,'Near941'}
G[78428]={78428,'941:39.43,23.46'}
G[78430]={78430,'970:49.49,14.21'}
G[78466]={3391,'976:52.46,53.40'}	-- Garrison Level 1 position
G[78470]={78239,'941:39.54,23.59'}
G[78482]={78482,'946:56.85,65.75'}
G[78487]={26859,'976:51.28,51.48'}	-- Garrison Level 1 position
G[78495]={81890,'976:40.83,51.93'}
G[78513]={78513,'946:51.65,50.51'}
G[78515]={78515,'946:51.64,50.52'}
G[78519]={78519,'946:56.51,67.13'}
G[78520]={77737,'946:55.12,67.41'}
G[78534]={78534,'946:49.89,56.16'}
G[78538]={78538,'946:51.62,50.48'}
G[78550]={78550,'947:60.69,96.27'}
G[78553]={4949,'970:50.05,13.34'}
G[78554]={78554,'970:71.49,62.70'}
G[78557]={78557,'978:53.68,68.86'}
G[78558]={78558,'970:54.73,48.26'}
G[78559]={78558,'970:60.26,56.34'}
G[78560]={78558,'970:71.95,40.46'}
G[78561]={78558,'970[1]:81.32,50.20'}
G[78562]={78558,'970:49.51,14.41'}
G[78563]={78558,'970:44.40,80.68'}
G[78564]={78564,'971:37.34,36.88 H:100122422,100122423,100122401,100122399,100122406,100122404,100122417,100122415,100122414,100122410,100122409,100122407'}	-- TODO: Really these should be done only on the alias one that has them...wonder how to do that properly if it is even possible.
G[78568]={78568,'970:44.07,29.68'}
G[78569]={14627,'970:44.09,29.57'}
G[78573]={78573,'970:62.28,52.99'}
G[78577]={78577,'946:55.57,67.01'}
G[78578]={78578,'941:39.55,19.67'}
G[78659]={78659,'941:51.82,16.75'}
G[78746]={78659,'941:51.81,16.75'}
G[78785]={78659,'941:40.55,21.85'}
G[78791]={78791,'941:26.16,53.17'}
G[78792]={78659,'941:39.54,23.59'}
G[78810]={78239,'941:38.00,14.80'}
G[78821]={78659,'941:37.56,14.12'}
G[78870]={78909,'941:25.70,51.70'}
G[78882]={21984,'947:58.14,93.89'}
G[78883]={78883,'970:54.07,48.78'}
G[78907]={78909,'941:25.71,51.68'}
G[78909]={78909,'941:25.48,50.65'}
G[78910]={78910,'941:28.54,50.52'}
G[78937]={21984,'947:67.97,90.11'}
G[78985]={78985,'976:47.64,39.33'}
G[78989]={78989,'941:41,52'}
G[78994]={78994,'970:58.82,14.11'}
G[78996]={74272,'970:43.04,26.36'}
G[78999]={78999,'947:58.96,84.82'}
G[79043]={17468,'947:40.53,54.92'}
G[79047]={72890,'941:30.76,41.45'}
G[79061]={79061,'947:43.19,61.34'}
G[79070]={79070,'950:81.28,70.34'}
G[79133]={79133,'946:69.88,20.81'}
G[79159]={79159,'946:69.26,19.29'}
G[79176]={79176,'946:71.06,29.74'}
G[79188]={79188,'950:79.46,50.24'}
G[79201]={79201,'950:71.13,52.35'}
G[79206]={17468,'947:26.97,8.10'}
G[79210]={79210,'946:71.89,29.41'}
G[79229]={79229,'941:59.44,31.79'}
G[79243]={79243,'947:29.05,16.21'}
G[79252]={78430,'976:49.54,36.31'}	-- Garrison level 1 position
G[79263]={79263,'950:86.38,66.20'}
G[79269]={79269,'978:48.80,37.79'}
G[79281]={79281,'950:83.06,67.97'}
G[79282]={79282,'950:78.79,69.23'}
G[79310]={79310,'950:78.58,48.57'}
G[79312]={79312,'950:78.97,58.88'}
G[79315]={79315,'970[1]:51.16,46.72'}
G[79316]={79316,'970[1]:50.87,49.80'}
G[79320]={79320,'949:42.76,63.06'}
G[79322]={79322,'949:42.75,62.98'}
G[79329]={80630,'946:70.14,20.12'}
G[79331]={79331,'949:42.70,63.08'}
G[79335]={79335,'946:83.13,31.72'}
G[79337]={79337,'949:42.76,63.01'}
G[79356]={79210,'946:70.89,30.48'}
G[79392]={79392,'946:84.97,30.97'}
G[79393]={79393,'946:84.19,30.31'}
G[79407]={79407,'976:50.93,46.77'}
G[79415]={70860,'941:21.76,56.41'}
G[79416]={79416,'949:41.34,72.69'}
G[79432]={79432,'946:75.88,47.61'}
G[79434]={77737,'946:46.32,74.09'}
G[79457]={78554,'971:44.09,53.29'}	-- garrison level 1 location
G[79470]={78554,'947:28.79,16.23'}
G[79492]={79492,'971:61.38,74.95'}
G[79514]={79514,'946:43.73,59.19'}
G[79519]={79519,'948:43.64,12.93'}
G[79537]={79537,'970:73.24,38.88'}
G[79539]={79539,'948:37.89,18.02'}
G[79544]={79544,'946:53.81,89.37'}
G[79567]={78994,'947:28.92,16.40'}
G[79573]={79573,'946:69.48,21.45'}
G[79576]={79576,'950:63.52,61.89'}
G[79581]={79581,'950:39.55,73.04'}
G[79598]={79598,'948:50.33,36.73'}
G[79604]={70860,'946:71.44,29.61'}
G[79608]={78994,'946:69.67,21.08'}
G[79609]={79609,'976:51.18,31.72'}
G[79612]={79612,'946:71.83,29.75'}
G[79618]={79618,'946:69.65,21.61'}
G[79627]={79627,'946:71.24,29.94'}
G[79635]={17468,'947:26.94,8.07'}
G[79661]={79661,'970[1]:82.84,44.36'}
G[79674]={78568,'950:63.06,61.95'}
G[79675]={75121,'970[1]:50.18,48.28'}
G[79680]={79680,'946:71.41,29.65'}
G[79681]={79681,'947:62.56,62.57'}
G[79689]={16554,'946:56.02,68.34'}
G[79696]={79696,'946:55.38,66.78'}
G[79722]={79722,'950:65.88,68.63'}
G[79724]={79724,'946:71.22,47.48'}
G[79740]={79740,'976:53.92,54.98'}	-- Garrison Level 1 position
G[79743]={79743,'950:66.76,68.66'}
G[79748]={79748,'948:40.08,43.94'}
G[79774]={88228,'976:43.19,47.81 H:100122412,100122405,100122403,100122402,100122400,100122424,100122421,100122418,100122416,100122413,100122411,100122408'}
G[79779]={79779,'947:60.78,68.39'}
G[79795]={79795,'970[1]:45.37,15.81'}
G[79813]={79813,'976:52.44,37.06'}	-- plot 18 location
G[79814]={79814,'976:52.44,37.06'}	-- plot 18 location
G[79815]={79815,'976:60.36,36.51'}	-- plot 24 location
G[79817]={79817,'976:52.44,37.06'}	-- plot 18 location
G[79820]={79820,'976:52.44,37.06'}	-- plot 18 location
G[79821]={79821,'976:52.44,37.06'}	-- plot 18 location
G[79826]={79826,'976:52.44,37.06'}	-- plot 18 location
G[79829]={79829,'976:52.44,37.06'}	-- plot 18 location
G[79830]={79830,'976:52.44,37.06'}	-- plot 18 location
G[79831]={79831,'976:52.44,37.06'}	-- plot 18 location
G[79832]={79832,'976:52.44,37.06'}	-- plot 18 location
G[79833]={79833,'976:52.44,37.06'}	-- plot 18 location
G[79834]={79834,'976:52.44,37.06'}	-- plot 18 location
G[79836]={79836,'976:61.97,35.39'}
G[79853]={79853,'946:62.89,50.44'}
G[79857]={79857,'976:52.44,37.06'}	-- plot 18 location
G[79858]={79858,'976:32.18,41.68'}	-- garrison level 3 location ? 976:31.72,42.13
G[79862]={79862,'976:52.44,37.06'}	-- plot 18 location
G[79863]={79863,'976:52.44,37.06'}	-- plot 18 location
G[79864]={79864,'976:52.44,37.06'}	-- plot 18 location
G[79867]={79867,'976:52.44,37.06'}	-- plot 18 location
G[79870]={79870,'946:64.21,47.80'}
G[79890]={79890,'948:51.62,31.35'}
G[79892]={79892,'976:38.10,72.21'}
G[79893]={79893,'971:54.07,13.68'}
G[79896]={79896,'941:55.71,75.30'}
G[79897]={79897,'Near950'}
G[79899]={79897,'950:74.87,61.64'}
G[79901]={79901,'946:62.87,50.32'}
G[79917]={79917,'970:41.83,41.67'}
G[79921]={79921,'946:71.19,29.44'}
G[79953]={79953,'971:40.28,53.61'}	-- garrison level 1 location
G[79954]={14627,'950:63.54,61.83'}
G[79963]={79963,'946:69.59,21.55'}
G[79966]={79966,'947:39.82,29.40'}
G[79971]={79971,'976:37,70'}
G[79978]={79978,'946:58.09,53.06'}
G[79979]={79979,'946:57.42,51.12'}
G[80001]={80001,'950:86.38,66.20'}
G[80003]={4949,'950:82.84,45.07'}
G[80005]={80005,'993[4]:25.38,47.43'}
G[80028]={80028,'946:61.35,54.40'}
G[80073]={79537,'947:59.52,30.37'}
G[80075]={80075,'947:61.91,29.68'}	-- ? 56.24,32.61
G[80076]={80076,'947:59.36,26.56'}
G[80078]={72413,'947:56.51,23.59'}
G[80079]={80079,'947:56.49,23.53'}
G[80083]={80083,'950:40.44,76.22'}
G[80103]={80103,'946:81.36,27.92'}
G[80108]={80075,'947:56.91,34.64'}
G[80140]={11378,'950:82.93,44.14'}
G[80142]={78558,'946:74.98,31.20'}
G[80148]={80148,'947:56.93,34.72'}
G[80153]={75288,'948:46.58,46.53'}	-- 948:46.51,45.61
G[80155]={75324,'948:36.97,24.49'}
G[80157]={75323,'948:36.88,24.57'}
G[80159]={80159,'971:36.86,64.77'}	-- garrison level 2 location ? 33.70,51.29
G[80161]={18261,'950:85.42,54.60'}
G[80163]={80163,'971:48.96,42.25'}	-- garrison level 1 location ? 43.21,54.12
G[80165]={79392,'947:43.56,77.29'}
G[80178]={80178,'948:47.10,31.63'}
G[80184]={80184,'950:79.87,48.85'}
G[80193]={79393,'946:84.16,30.74'}
G[80196]={80196,'947:46.61,37.74'}
G[80229]={79210,'946:62.12,69.24'}
G[80232]={23066,'948:47.99,34.73'}
G[80233]={80233,'948:45.43,36.31'}
G[80248]={80248,'947:46.41,25.23'}
G[80260]={79392,'Near946'}
G[80265]={79519,'948:51.57,31.07'}
G[80297]={80297,'978:48.31,50.36'}
G[80319]={18261,'950[10]:44.86,19.85'}
G[80339]={79210,'946:68.77,70.53'}
G[80341]={79210,'Near946'}
G[80342]={79210,'946:64.52,81.62'}
G[80378]={80378,'947:43.69,51.67'}
G[80389]={79393,'Near946'}
G[80390]={79393,'946:68.31,70.33'}
G[80396]={79393,'946:62.25,68.29'}
G[80429]={79627,'950:68.57,64.43'}
G[80434]={80434,'950:75.07,22.74'}
G[80451]={80451,'950:68.59,64.46'}
G[80456]={74272,'941:21.04,57.91'}
G[80469]={85320,'948:45.40,36.74'}
G[80470]={80470,'948:45.40,36.74'}
G[80481]={80481,'948:52.10,49.95'}
G[80508]={80508,'948:44.49,24.01'}
G[80521]={78568,'970:40.07,48.50', 'On top of tank'}	-- WoD 40.10,48.42
G[80553]={79393,'946:71.17,29.88'}
G[80568]={78994,'971:47.01,50.94'}	-- garrison level 1 location
G[80586]={80586,'950:70.46,9.75 H:100113080','In cave'}
G[80593]={80593,'950:71.34,17.88'}
G[80595]={80595,'950:72.78,19.71'}
G[80597]={74272,'950:71.66,19.74'}
G[80606]={80606,'947:53.38,68.00'}
G[80607]={79392,'946:61.95,69.28'}
G[80608]={79392,'946:69.95,69.45'}
G[80617]={79392,'Near946'}
G[80623]={79210,'946:71.19,29.85'}
G[80624]={79743,'950:63.50,61.85'}
G[80627]={80630,'946:62.57,67.87'}
G[80628]={80630,'946:69.63,69.85'}
G[80630]={80630,'946:64.52,81.77'}
G[80632]={80630,'Near946'}
G[80635]={80635,'947:55.67,71.98'}
G[80639]={80639,'948:48.98,48.99'}
G[80645]={78430,'971:43.17,44.75'}	-- garrison level 2 location
G[80648]={80648,'948:46.78,45.96'}
G[80672]={79392,'946:69.74,20.79'}
G[80685]={80685,'949:47,65 H:100114020,100114021'}
G[80689]={80689,'949:45,64 H:100114022,100114023'}
G[80690]={80690,'949:46.62,71.52'}
G[80696]={80696,'949:47,64 H:100114024,100114025'}
G[80707]={80707,'947:53.11,65.38'}
G[80714]={80714,'949:58,60 H:100112378,100113260'}
G[80725]={80725,'949:41,60 H:100114037,100114038'}
G[80727]={80635,'947:53.69,57.28'}
G[80740]={80740,'948:54.86,54.23'}
G[80744]={80744,'949:61.73,52.35'}
G[80746]={80746,'948:52.09,49.41'}
G[80757]={80757,'949:57.20,61.95'}
G[80758]={80758,'948:62.20,42.62'}
G[80761]={46022,'947:53.45,57.31'}
G[80762]={82476,'949:59.32,56.36'}
G[80782]={80782,'941:54.27,67.46'}
G[80785]={80785,'949:58,63 H:100113453,100113454'}
G[80803]={80803,'970:71.92,62.06'}
G[80827]={80827,'947:45.18,38.83'}
G[80833]={80833,'946:70.84,29.62'}
G[80834]={80834,'948:60.48,38.75'}
G[80854]={80854,'946:69.43,21.14'}
G[80856]={21984,'949:46.07,54.75'}
G[80859]={80859,'947:52.60,59.70'}
G[80860]={80481,'948:54.85,54.28'}
G[80863]={80746,'948:54.83,54.18'}
G[80864]={80434,'950:40.43,56.79'}
G[80865]={45429,'947:53.66,57.25'}
G[80866]={80866,'950:40.40,56.74'}
G[80874]={78568,'949:64.99,48.53'}
G[80895]={16134,'947:55.05,68.20'}
G[80907]={80907,'947:54.18,70.76'}
G[80921]={79576,'949:64.21,51.94'}
G[80922]={80987,'949:64.20,51.77'}
G[80965]={79393,'946:71.33,29.60'}
G[80966]={79392,'946:69.60,21.07'}
G[80968]={80630,'946:69.78,20.74'}
G[80978]={78994,'949:63.99,57.20'}
G[80987]={80987,'949:63.14,52.29'}
G[81019]={81019,'950:46.79,57.39'}
G[81038]={81038,'949:42.01,46.83'}
G[81039]={81039,'950:61.98,40.55'}
G[81043]={81043,'949:41.91,46.90'}
G[81076]={81076,'949:52.84,59.87'}
G[81086]={81086,'950:55.50,42.09'}
G[81097]={81097,'950:55.44,42.09'}
G[81103]={352,'971:43.12,44.89'}
G[81109]={81109,'948:61.47,72.93'}
G[81123]={81123,'950:62.13,40.43'}
G[81126]={81126,'947:45.81,37.33'}
G[81128]={81128,'948:61.45,72.96'}
G[81134]={81134,'950:56.09,43.79'}
G[81140]={81140,'947:61.86,29.14'}
G[81144]={81144,'950:84.06,76.84'}
G[81152]={81152,'947:40.64,54.88'}
G[81153]={81152,'947:40.66,54.87'}
G[81166]={81166,'976:45.41,50.63'}
G[81173]={81173,'947:35.38,36.95'}
G[81176]={81176,'947:35.84,36.96'}
G[81185]={81185,'949:54.82,65.29'}
G[81186]={70860,'950:48,48'}
G[81189]={35875,'950:82.88,45.07'}
G[81193]={81193,'950:49.38,47.84'}
G[81194]={81194,'950:55.49,42.19'}
G[81195]={81195,'950:56.06,43.76'}
G[81202]={81202,'949:43.56,65.01'}
G[81207]={81207,'949:47.20,55.13'}
G[81209]={81209,'941:38.03,47.46'}
G[81210]={81210,'941:37.75,47.48'}
G[81216]={81216,'950:51.82,58.79'}
G[81218]={80757,'949:54.45,66.66'}
G[81230]={81230,'950:46.81,57.51'}
G[81240]={81240,'949:43,48 H:100114018,100114019'}
G[81241]={80757,'949:58.91,62.52'}
G[81280]={81280,'950:63.08,61.94'}
G[81284]={81284,'947:57.48,57.28'}
G[81292]={81292,'947:44.92,38.51'}
G[81319]={74651,'950:82.86,45.02'}
G[81324]={81324,'947:56.72,23.44'}
G[81335]={74272,'950:55.57,55.91'}
G[81346]={81346,'971:44.84,53.01'}
G[81347]={81347,'971:43.15,45.74'}
G[81361]={81361,'950:83.79,76.84'}
G[81412]={81039,'950:66.97,33.75'}
G[81415]={70860,'950:66.94,33.79'}
G[81443]={55521,'948:58.48,92.20'}
G[81492]={81492,'971:38.26,36.73'}	-- garrison level 2 location, using for garrison level 3 location as well  which is so close: 971:38.30,37.01
G[81499]={81499,'947:49.80,81.49'}
G[81514]={81514,'948:61.93,42.24'}
G[81518]={81518,'949:45.94,52.69'}
G[81528]={81528,'949:42.50,59.69 H:100113448,100113449'}
G[81529]={81529,'949:38.96,51.16'}
G[81530]={81530,'947:50.00,81.22'}
G[81537]={81537,'949:51.71,66.37 H:100113461'}
G[81540]={81540,'949:51.83,41.28'}
G[81548]={81548,'949:46.12,46.69'}
G[81575]={81575,'949:42.06,79.23'}
G[81588]={78568,'949:46.08,76.85'}
G[81589]={80987,'949:46.11,76.65'}
G[81590]={78994,'949:46.05,76.67'}
G[81600]={47267,'949:42.11,83.44'}
G[81601]={47267,'Near949'}
G[81617]={81617,'949:49.42,70.93 H:100114026,100114027'}
G[81627]={81627,'947:55.96,32.84'}
G[81630]={81630,'949:47,72 H:100114029,100114030'}
G[81631]={81631,'949:49.47,70.94'}
G[81634]={81634,'949:49.46,70.94'}
G[81659]={81659,'949:47.61,72.74'}
G[81674]={81674,'949:45.87,54.97'}
G[81678]={81678,'941[1]:28.28,45.72'}
G[81685]={81685,'949:45.6,58.8 H:100114037,100114038'}
G[81688]={81688,'976:62.05,73.88'}
G[81691]={81691,'949[16]:48.77,30.10'}
G[81731]={81731,'949:49.36,49.66'}
G[81738]={81738,'949:51.89,49.93'}
G[81747]={81747,'949:51.03,51.60'}
G[81751]={14627,'949[17]:50.10,22.41'}
G[81761]={81761,'970:62.20,52.93'}
G[81762]={81762,'970:62.27,52.97'}
G[81763]={81763,'970:62.21,52.94'}
G[81765]={81765,'1011:62.10,23.02'}
G[81770]={79519,'948:48.56,44.48'}
G[81772]={80987,'949:47.78,93.27'}
G[81773]={81109,'948:59.12,79.18'}
G[81775]={81775,'949:48.29,47.60 H:100113586,100113590'}
G[81784]={81128,'948:59.10,79.22'}
G[81789]={81789,'946:55.64,67.77'}
G[81790]={18261,'950:82.58,46.76'}
G[81794]={81280,'950:64.23,59.57'}
G[81797]={18261,'950:82.60,46.63'}
G[81870]={81870,'978:45.97,76.23'}
G[81890]={81890,'948:45.94,46.32'}
G[81891]={81960,'948:45.90,46.36'}
G[81912]={81912,'947:55.99,32.61'}
G[81913]={81890,'948:40.03,44.04'}
G[81915]={81960,'948:39.99,60.47'}
G[81920]={81920,'948:40.20,43.57'}
G[81929]={81929,'948:39.90,60.87'}
G[81947]={81947,'976:62.87,34.81'}
G[81948]={79316,'971:40.53,54.00'}
G[81949]={81960,'948:39.79,60.68'}
G[81953]={74272,'950:51.31,61.59'}
G[81955]={81955,'950:79.22,52.65'}
G[81959]={81890,'948:40.27,43.43'}
G[81960]={81960,'948:39.13,48.94'}
G[81961]={81890,'948:39.19,48.95'}
G[81964]={81960,'948:39.48,61.60'}
G[81972]={81109,'948:58.48,92.33'}
G[81978]={81109,'948:58.82,92.84'}
G[81981]={81981,'976:43.86,83.12'}
G[81987]={72413,'947:55.94,32.90'}
G[82037]={82037,'947:29.01,16.24'}
G[82070]={74272,'950:71.58,19.72'}
G[82078]={82078,'950:82.55,43.97'}
G[82080]={82080,'950:82.60,43.95'}
G[82086]={82086,'949:48.21,71.48'}
G[82092]={82092,'950:63.53,61.42'}
G[82094]={82094,'950:63.48,61.40'}
G[82100]={82100,'948:38.92,48.82'}
G[82101]={82100,'948:38.94,48.86'}
G[82104]={82104,'941:59.45,31.80'}
G[82112]={82112,'947:56.93,34.71'}
G[82119]={82119,'950:65.02,58.31'}
G[82123]={82123,'948:32.57,29.05'}	-- ?? 962:41.74,71.49
G[82124]={82124,'948:37.70,51.06','Upstairs in inn'}
G[82126]={82124,'948:37.54,50.76','Downstairs in inn'}
G[82138]={78482,'950:71.72,19.65'}
G[82179]={78482,'950:55.52,55.92'}
G[82181]={78482,'950[12]:46.10,32.79'}
G[82194]={82194,'948:37.70,53.81'}
G[82196]={82196,'947:46.07,59.13'}
G[82212]={82212,'948:37.67,53.87'}
G[82214]={78482,'950:71.54,19.76'}
G[82222]={81731,'949:52.28,48.97'}
G[82225]={81731,'949:52.86,51.73'}
G[82227]={82227,'947:58.05,57.64'}
G[82228]={74606,'949:42.06,85.92'}
G[82233]={74651,'949:42.05,85.82'}
G[82252]={82252,'950:62.14,62.08'}
G[82254]={82254,'949:43.72,84.00'}
G[82256]={82256,'947:49.02,38.62'}
G[82270]={78554,'19:66.59,28.25'}
G[82274]={82254,'Near949'} -- 949:43.07,83.73
G[82277]={82194,'948:37.75,53.75'}
G[82278]={82212,'948:37.69,53.87'}
G[82293]={82212,'948:37.60,53.95'}
G[82302]={82302,'949:50.33,47.45'}
G[82318]={82318,'947:54,21 H:100119317'}
G[82334]={82254,'949:48.05,94.16'}	-- seems Blizzard took this out of a dungeon map 949[17]:50.09,22.35
G[82337]={74651,'949:47.71,93.31'}
G[82338]={74606,'949:47.78,93.27'}
G[82348]={78554,'947:56.19,32.38'}
G[82366]={82366,'947:53.37,67.50'}
G[82375]={55122,'948:36.82,56.94'}
G[82402]={81890,'948:36.88,56.67'}
G[82403]={81960,'948:36.84,56.78'}
G[82437]={82437,'949:59.52,65.93'}
G[82439]={82439,'949:47.64,72.74'}
G[82447]={82447,'19:52.00,28.52'}
G[82466]={82466,'971:47,45'}
G[82468]={81109,'948:61.59,72.85'}
G[82476]={82476,'949:58.26,59.90'}
G[82477]={82476,'949:58.97,62.50'}
G[82496]={82496,'947:54,45'}
G[82497]={82497,'947:55,41'}
G[82499]={82499,'949:59.51,57.90'}
G[82509]={75323,'948:47.12,45.85'}
G[82537]={82537,'947:56.69,23.01'}
G[82569]={82569,'949:57.05,71.93'}
G[82574]={85147,'949:55.93,71.54'}
G[82575]={85119,'949:55.93,71.54'}
G[82599]={82599,'950:69.93,52.50'}
G[82610]={82610,'949:46.26,66.70'}
G[82612]={82612,'948:39.55,43.34'}
G[82621]={79519,'948:50.28,36.70'}
G[82622]={82622,'948:41.11,42.89'}
G[82658]={82658,'950:71.11,52.42'}
G[82660]={82660,'978:44.77,74.61'}
G[82664]={82664,'948:39.35,59.82'}
G[82669]={82669,'948:39.24,62.84'}
G[82688]={82688,'950:74,36'}
G[82691]={82691,'948:40.00,43.20'}
G[82709]={9296,'948:39.60,61.20'}
G[82713]={82713,'948:56.01,40.85'}
G[82720]={75288,'948:46.54,45.61'}
G[82727]={82727,'950:78.29,52.59'}
G[82732]={82732,'949:46.26,69.98'}
G[82746]={82746,'950:67.14,56.04'}
G[82759]={82759,'948:56.18,42.54'}
G[82764]={82764,'950:52.48,55.76'}
G[82776]={82776,'971:33.03,35.22'}	-- garrison level 3 location
G[82786]={82786,'948:60.07,53.55'}
G[82788]={82788,'948:60.20,53.15'}	-- ? 948:60.06,53.63
G[82813]={82813,'948:46.63,46.75'}
G[82816]={21984,'949:44.29,61.65'}
G[82832]={21984,'949:44.29,61.65'}
G[82833]={82833,'941:46.41,15.89'}
G[82851]={4949,'19:71.82,47.75'}
G[82881]={82881,'947:60.96,24.44'}
G[82893]={82893,'978:43.97,75.34'}
G[82901]={82901,'978:44.79,74.99'}
G[82905]={82905,'949:62.04,53.39'}
G[82909]={82909,'978:43.30,76.66'}
G[82928]={82928,'946:38.18,12.34'}
G[82966]={82966,'978:44.76,74.44'}
G[82996]={82996,'946:33.54,37.06'}
G[83011]={83011,'946:35.05,39.00'}
G[83051]={83051,'950:49.91,37.09'}
G[83052]={83052,'950:49.90,37.08'}
G[83053]={83053,'950:41.82,36.99'}
G[83054]={79627,'950:41.82,36.99'}
G[83058]={83058,'951:25.46,27.21'}
G[83325]={83325,'928:63.24,72.29'}
G[83405]={83405,'949:44.59,61.31'}
G[83439]={83439,'976:47.33,37.42'}
G[83448]={83448,'949:50.87,79.91'}
G[83449]={83449,'949:50.45,77.07'}
G[83450]={83450,'949:50.44,76.99'}
G[83455]={83455,'947:51.45,61.61'}
G[83458]={83458,'949:45.6,58.8 H:100114037,100114038'}
G[83463]={83463,'948:43.90,48.90'}
G[83482]={83482,'976:47.24,38.11'}	-- garrison level 1 location
G[83489]={83489,'949:45.60,52.82'}
G[83491]={83491,'971:50.05,42.14'}	-- garrison level 1 location
G[83494]={83494,'947:59.08,82.27'}
G[83504]={83504,'976:47.33,37.42'}
G[83529]={44637,'948:40.10,43.34'}
G[83549]={83904,'948:39.67,60.85'}
G[83569]={21984,'949:46.04,54.75'}
G[83575]={83575,'950:39.69,14.80'}
G[83577]={83577,'950:35.41,19.88'}
G[83606]={83606,'950:82.85,46.73'}
G[83608]={44637,'948:52.07,23.54'}
G[83609]={83904,'948:52.10,23.54'}
G[83612]={83612,'987[1]:68.97,41.17'}
G[83680]={83680,'950:61.64,68.89'}
G[83686]={83686,'950:39.63,24.61'}
G[83723]={74272,'950:55.57,55.91'}
G[83730]={78482,'950:55.47,55.92'}
G[83734]={83686,'950:39.61,24.53'}
G[83772]={44637,'948:53.51,27.46'}
G[83773]={83904,'948:53.59,27.50'}
G[83774]={83774,'949:47.72,52.07'}
G[83820]={83820,'949:44.93,86.88'}
G[83823]={78558,'946:85.18,31.71'}
G[83837]={83837,'949:51.07,70.58'}
G[83846]={83846,'1008[2]:50.52,66.32'}
G[83848]={83848,'950:40.08,16.16'}
G[83858]={83858,'971:39.18,42.70'}
G[83869]={83869,'978:45.77,28.80'}
G[83888]={83888,'950:53.70,15.01'}
G[83899]={44637,'948:57.07,34.51'}
G[83900]={83904,'948:57.13,34.51'}
G[83903]={44637,'948:57.10,34.52'}
G[83904]={83904,'948:57.14,34.53'}
G[83929]={78430,'946:84.80,31.52'}
G[83959]={23066,'948:46.51,46.82'}
G[83995]={83995,'978:45.27,27.13'}
G[84002]={84002,'947:59.51,94.46'}
G[84095]={84095,'946:49.23,88.01'}
G[84122]={84122,'948:46.65,46.75'}
G[84131]={21984,'949:43.94,48.85'}
G[84173]={84173,'978:44.61,73.91'}
G[84176]={84176,'949:38.77,73.61'}
G[84185]={41006,'949:40.95,43.07'}
G[84223]={26814,'978:42.81,76.81'}
G[84243]={84243,'948:47.18,31.74'}
G[84247]={84247,'941:48.80,67.39'}
G[84248]={84248,'971:51.21,47.04'}	-- plot 25
G[84259]={84259,'948:40.11,43.22'}
G[84261]={84261,'948:39.67,60.87'}
G[84262]={79519,'948:46.50,54.33'}
G[84268]={79953,'971:28.73,35.04'}	-- garrison level 3, but her location is 971:28.85,35.39 after the shipyard is upgraded to level 3 because there is a ship table in the garrison from that point on
G[84270]={79243,'971:29.30,34.83'}	-- garrison level 3
G[84276]={79519,'948:51.35,50.28'}
G[84286]={84286,'971:40.35,61.17'}
G[84291]={84261,'948:39.51,61.68'}
G[84292]={84259,'948:40.08,42.72'}
G[84372]={84372,'947:26.95,7.27'}
G[84385]={84385,'947:44.23,40.93'}
G[84407]={84407,'950:79.19,52.66'}
G[84459]={84459,'950:49.42,16.59'}
G[84473]={84473,'978:45.11,28.03'}
G[84492]={84492,'947:44.98,39.18'}
G[84494]={84494,'941:46,48'}
G[84499]={84499,'1008[1]:0.00,0.00'}
G[84506]={84506,'941:60.28,27.20'}
G[84511]={79953,'971:31.43,33.68'}
G[84523]={84523,'947:58,26'}
G[84524]={84524,'971:35.53,49.36'}	-- plot 22
G[84550]={84550,'1008[1]:64.79,1.22'}
G[84554]={84554,'1008[1]:65.35,1.64'}
G[84632]={84632,'950:77.43,47.36'}
G[84637]={18471,'950:62.97,36.00'}
G[84660]={84660,'978:47.14,26.66'}
G[84684]={79953,'971:29.65,34.24'}
G[84689]={84689,'941:20,60'}
G[84702]={78558,'950:77.13,36.87'}
G[84720]={84720,'950:56.90,19.11'}
G[84724]={84724,'947:57.85,21.53'}
G[84726]={84726,'950:86.65,28.32'}
G[84728]={84728,'947:58.31,20.84'}
G[84739]={84966,'941:54.39,51.74'}
G[84743]={81202,'949:46.19,55.09'}
G[84747]={84747,'941:55.92,48.61'}
G[84748]={81202,'949:43.93,48.82'}
G[84776]={84776,'971:43,54'}
G[84784]={22893,'950:56.77,12.90'}
G[84807]={84807,'948:47.28,29.18'}
G[84811]={84811,'949:55.91,71.57'}
G[84825]={84825,'947:60.86,32.64'}
G[84830]={84830,'947:46.96,38.65'}
G[84837]={84837,'978:36.49,37.79'}
G[84857]={84857,'971:46.99,59.27'}	-- plot 18
G[84861]={84861,'950:86.65,28.32'}
G[84871]={84871,'946:44.34,37.95'}
G[84889]={84892,'947:29.88,18.21'}
G[84892]={84892,'950:75.73,66.74'}
G[84908]={84908,'947:51.32,81.09'}
G[84928]={4949,'19:48.73,31.78'}
G[84929]={78554,'19:51.93,28.65'}
G[84947]={84947,'971:35.53,49.36'}	-- plot 22 location
G[84951]={84951,'948:34.14,58.52'}
G[84963]={84963,'947:35.66,72.26'}
G[84966]={84966,'947:37.34,72.60'}
G[84967]={84967,'976:57.28,53.86'}	-- Garrison level 1 location
G[84973]={72413,'947:74.90,57.99'}
G[84974]={79537,'947:75.13,57.89'}
G[84975]={80079,'947:75.19,57.53'}
G[85043]={85043,'948:69.88,20.73'}
G[85048]={85048,'976:51.43,57.39'}	-- plot 22 location
G[85062]={85062,'948:62.56,73.88'}
G[85077]={85147,'949:46.36,69.65'}
G[85080]={55122,'948:39.98,60.66'}
G[85089]={81731,'949:51.30,47.99'}
G[85106]={85106,'941:20.08,56.39'}
G[85119]={85119,'949:53.02,59.81'}
G[85124]={85124,'949:45.08,26.44'}
G[85130]={85119,'949:60.71,64.78'}
G[85146]={85146,'970[1]:81.32,50.20'}
G[85147]={85147,'949:45.68,70.60'}
G[85150]={85150,'947:63.10,94.42'}
G[85190]={85190,'948:68.33,38.93'}
G[85199]={85199,'950:65.81,9.02 949:57.60,43.17'}
G[85206]={85206,'948:44.34,12.04'}
G[85213]={81492,'19:66.94,27.92'}
G[85219]={85219,'948:32.49,47.25'}
G[85247]={26859,'19:71.88,48.97'}
G[85278]={82610,'949:53.31,59.73'}
G[85289]={85289,'976:53.81,42.54'}
G[85299]={85299,'948:70.82,23.11'}
G[85320]={85320,'948:46.21,45.68'}
G[85344]={85344,'971:58.87,53.45'}
G[85378]={45109,'947:46.17,31.40'}	-- ? 947:61.47,63.29
G[85379]={45110,'950:58.96,38.52'}	-- ? 947:46.22,31.40
G[85413]={45109,'971:51.21,47.04'}	-- entrance to plot 25
G[85414]={45110,'976:57.75,28.14'}	-- plot 25 location
G[85418]={85418,'971:28.49,38.64'}
G[85425]={85425,'948:47.13,31.68'}
G[85426]={85436,'949:49.40,49.65'}
G[85431]={85436,'949:50.88,51.39'}	-- Sparring Arena-based location
G[85432]={85436,'949:51.32,47.96'}
G[85436]={85436,'949:52.87,51.78'}
G[85439]={85439,'941:21,56'}
G[85440]={85440,'941:61,71'}
G[85514]={85514,'971:42.79,45.41'}
G[85519]={85519,'823:47.27,61.99'}
G[85520]={85520,'948:52.90,54.97'}
G[85524]={85524,'949:44.09,63.26'}
G[85538]={85538,'949:44.91,63.99'}
G[85540]={85540,'949:48.08,52.17'}
G[85545]={85545,'941:51.75,21.44'}
G[85546]={85546,'823:48.38,71.36'}
G[85550]={85550,'948:39.66,60.66'}
G[85562]={85562,'949:49.43,49.59'}
G[85566]={85566,'948:40.03,43.92'}
G[85598]={75323,'948:44.41,24.04'}
G[85601]={82254,'949:46.48,93.57'}
G[85694]={85694,'949:53,68 H:100114035,100114036'}
G[85695]={85695,'949:53,67 H:100114033,100114034'}
G[85708]={85708,'971:53.02,14.88'}
G[85718]={85718,'949:44.52,91.53'}
G[85725]={85725,'949:44.66,90.51'}
G[85749]={85749,'978:44.10,74.17'}
G[85751]={85751,'941:20.70,60.22'}
G[85777]={77031,'971:53.26,69.08'}	-- garrison level 2 position
G[85779]={85779,'949:50,75 H:100114031,100114032'}
G[85786]={85786,'949:51.28,66.24'}
G[85807]={85807,'949:61.47,57.61'}
G[85839]={85839,'971:42.13,45.27'}
G[85840]={85840,'1011:42.55,36.40'}
G[85849]={85849,'1009:29.65,52.92'}
G[85857]={85857,'971:34.23,32.82'}
G[85882]={85882,'971:62,73'}
G[85889]={81280,'948:61.61,72.80'}
G[85892]={85892,'948:50.66,77.19'}
G[85924]={85924,'949:41,54.6 H:100114037,100114038'}
G[85960]={85960,'949:40.14,60.27'}
G[85980]={85980,'949:44.07,48.82'}
G[85984]={12919,'971:53.67,14.60'}
G[86024]={86024,'947:50.22,75.86'}
G[86065]={86065,'1009:31.99,50.00'}
G[86069]={86069,'1009:35.54,75.80'}
G[86084]={86084,'1009:47.98,30.64'}
G[86213]={86213,'947:50.95,79.00'}
G[86260]={86260,'949:57.91,42.70'}
G[86264]={86264,'949:59.47,32.82'}
G[86272]={86272,'925[1]:56.69,76.03'}
G[86312]={86312,'1011:44.16,45.46'}
G[86315]={86315,'1011:45.54,34.61'}
G[86355]={80648,'948:64.29,37.11'}
G[86381]={86381,'948:50.95,55.95'}
G[86390]={86390,'1009:51.46,61.59'}
G[86393]={74272,'950[12]:46.11,34.65'}
G[86419]={80758,'948:66.50,51.59'}
G[86439]={86439,'949:48.4,47.2 H:100114037,100114038'}
G[86442]={86442,'946:69.61,20.80'}
G[86475]={80758,'948:64.10,37.01'}
G[86499]={86499,'949:45.67,26.72'}
G[86501]={85147,'949:46.36,69.70'}
G[86502]={61020,'949:53.02,59.81'}
G[86521]={81280,'949:53.29,59.79'}
G[86522]={86522,'946:67.54,42.12'}
G[86531]={86531,'946:39.29,38.51'}
G[86536]={86536,'949:50.06,21.66'}
G[86563]={78558,'1014[10]:72.48,45.66'}
G[86577]={86577,'949:45.95,27.91'}
G[86589]={86589,'971:46.11,45.81'}
G[86597]={86597,'948:35.79,52.20'}
G[86614]={86614,'976:50.91,50.65'}	-- Garrison Level 1 position
G[86629]={86629,'976:51.43,57.39'}	-- plot 22 location
G[86677]={86677,'971:52.01,44.82'}
G[86696]={86696,'976:52.44,37.06'}	-- plot 18 location
G[86832]={38966,'321[1]:48.11,70.51'}
G[86927]={86084,'Near'}
G[86934]={79979,'941:69.65,27.47'}
G[86946]={23066,'948:43.83,24.63'}
G[86949]={86949,'946:85.01,31.06'}
G[86964]={87561,'950:46.69,57.48'}
G[86973]={46804,'971:45.25,42.49'}	-- plot 23 location
G[86974]={86974,'971:45.25,42.49'}	-- plot 23 location
G[86979]={27221,'976:58.88,49.06'}	-- plot 23 location
G[87056]={87056,'976:62.18,35.74'}
G[87110]={87110,'950:56.23,9.81'}
G[87116]={87121,'976:51.70,58.70'}
G[87121]={87121,'976:51.43,57.39'}	-- plot 22 location
G[87123]={87123,'948:46.30,45.31'}
G[87124]={87124,'947:50.03,31.26'}
G[87125]={87125,'946:49.08,80.40'}
G[87207]={87207,'971:52.13,45.48'}
G[87212]={87215,'971:34.62,49.00'}
G[87215]={87215,'971:34.58,49.18'}
G[87216]={87215,'971:34.64,49.24'}
G[87217]={87215,'971:35.53,49.36'}	-- plot 22 location
G[87242]={26584,'976:58.88,49.06'}	-- plot 23 location
G[87305]={87305,'976:51.43,57.39'}	-- plot 22 location
G[87344]={87344,'950:42.10,36.92'}
G[87391]={87391,'1009:51.82,61.45'}
G[87393]={87393,'950:50.37,41.28'}
G[87561]={87561,'948:54.20,62.97'}
G[87698]={87698,'947:62.91,33.50'}
G[87706]={79201,'950:50.26,41.12'}
G[87764]={87764,'946:69.46,5.81'}
G[87788]={87788,'950:36.93,24.48'}
G[87971]={87971,'941:74.95,30.05'}
G[87991]={87991,'971:35.53,49.36'}	-- plot 22
G[87992]={46854,'971:35.53,49.36'}	-- plot 22
G[87994]={87994,'971:35.53,49.36'}	-- plot 22
G[87995]={2487,'971:35.53,49.36'}	-- plot 22
G[87996]={64842,'971:35.53,49.36'}	-- plot 22
G[87997]={11036,'971:35.53,49.36'}	-- plot 22
G[87998]={58113,'971:35.53,49.36'}	-- plot 22
G[87999]={40997,'971:35.53,49.36'}	-- plot 22
G[88000]={49444,'971:35.53,49.36'}	-- plot 22
G[88001]={38237,'971:35.53,49.36'}	-- plot 22
G[88002]={28444,'971:35.53,49.36'}	-- plot 22
G[88003]={88003,'971:35.53,49.36'}	-- plot 22
G[88004]={88004,'971:35.53,49.36'}	-- plot 22
G[88005]={54961,'971:35.53,49.36'}	-- plot 22
G[88006]={88006,'971:35.53,49.36'}	-- plot 22
G[88007]={88007,'971:35.53,49.36'}	-- plot 22
G[88009]={88009,'971:35.53,49.36'}	-- plot 22
G[88013]={47269,'971:35.53,49.36'} -- plot 22
G[88017]={46338,'971:35.53,49.36'} -- plot 22
G[88022]={47869,'971:35.53,49.36'}	-- plot 22
G[88023]={61021,'971:35.53,49.36'} -- plot 22
G[88024]={9177,'971:35.53,49.36'} -- plot 22
G[88025]={39930,'971:35.53,49.36'}	-- plot 22
G[88026]={43184,'971:35.53,49.36'}	-- plot 22
G[88027]={47366,'971:35.53,49.36'} -- plot 22
G[88086]={88086,'1015:53.68,43.95'}
G[88112]={41003,'971:47.38,89.11'}
G[88115]={88867,'1015:47.00,41.37'}
G[88145]={88145,'971:46.99,59.27'}	-- plot 18
G[88155]={88155,'1009:52.03,63.54'}
G[88161]={88161,'1011:65.04,59.17'}
G[88173]={44637,'948:39.67,43.06'}
G[88179]={44637,'948:40.10,43.36'}
G[88187]={88187,'950:35.53,22.13'}
G[88193]={83609,'948:39.42,62.17'}
G[88195]={83904,'948:39.73,60.90'}
G[88223]={78564,'971:37.73,35.92'}	-- garrison level 2 location ? 37.67,36.23
G[88228]={88228,'976:43.65,47.81'}	-- garrison level 2 location
G[88240]={88240,'950:52.38,19.17'}
G[88276]={67996,'947:43.56,77.29'}
G[88279]={88279,'949:58.17,44.27'}
G[88358]={88358,'950:79.68,30.25'}
G[88361]={88361,'950:79.69,30.18'}
G[88392]={88392,'976:52.44,37.06'}	-- plot 18
G[88394]={88394,'949:55.80,43.83'}
G[88412]={88412,'949:44.04,61.55'}
G[88448]={47571,'978:45.85,28.94'}
G[88478]={88478,'950:59.22,16.26'}
G[88487]={81280,'948:54.28,62.96'}
G[88500]={88500,'950:79.46,30.29'}
G[88530]={41005,'949:40.94,43.01'}
G[88545]={88545,'971:46.99,59.27'}	-- plot 18
G[88546]={88546,'976:52.44,37.06'}	-- plot 18
G[88570]={88570,'1011:64.02,62.06'}
G[88798]={88798,'1015:47.06,41.48'}
G[88863]={88863,'1015:50.34,61.02'}
G[88867]={88867,'1015:51.78,44.29'}
G[88873]={88873,'1015:50.01,48.55'}
G[88890]={88867,'1015:54.18,42.01'}
G[88892]={88892,'971:61.07,79.30'}
G[88906]={88906,'950:58.51,15.00'}
G[88923]={88923,'1015:47.94,48.66'}
G[88972]={79537,'947:66.43,26.16'}
G[89009]={88867,'1015:57.86,43.35'}
G[89023]={89023,'1015:48.38,34.54'}
G[89025]={89025,'1015:61.32,38.60'}
G[89048]={88923,'1015:47.97,48.65'}
G[89050]={89050,'1015:48.06,49.15'}
G[89051]={88873,'1015:53.45,62.90'}
G[89053]={89053,'1015:62.98,57.73'}
G[89063]={89063,'948:59.70,11.42'}
G[89090]={89090,'1015:57.81,43.36'}
G[89158]={1229314,'947:59.78,94.47'}
G[89179]={41005,'949:54.24,55.87'}
G[89288]={89288,'1015:60.13,59.34'}
G[89326]={89326,'1015:53.28,45.31'}
G[89341]={89341,'1015:47.12,41.42'}
G[89362]={93011,'1015:43.53,43.47'}
G[89398]={95238,'1015:43.30,43.16'}
G[89400]={79519,'945:16.11,44.37'}
G[89660]={89660,'1015[17]:53.40,47.60'}
G[89661]={89661,'1015[17]:28.89,42.42'}
G[89675]={89675,'945:50.57,42.79'}
G[89686]={89686,'945:26.52,30.70'}
G[89699]={89699,'945:20.96,51.84'}
G[89753]={25256,'976:40.16,56.67'}	-- garrison level 3 location  ? 976:39.96,57.53
G[89754]={89754,'945:50.59,44.29'}
G[89763]={38607,'971:34.14,32.81'}
G[89777]={89777,'945:43.14,35.97'}
G[89793]={26814,'971:34.22,32.75'}
G[89794]={89794,'1015:47.97,27.17'}
G[89795]={89795,'1015:47.99,27.13'}
G[89805]={89805,'971:34.18,32.66'}
G[89806]={16575,'976:40.22,56.02'}
G[89822]={74651,'945:73.43,71.12'}
G[89829]={89829,'1017:31.09,55.98'}
G[89849]={89849,'1015[17]:52.98,47.82'}
G[89857]={89857,'945:39.52,34.23'}
G[89865]={89865,'1015:50.01,35.10'}
G[89936]={89936,'945:41.21,35.40'}
G[89937]={89937,'949:56.14,6.65'}
G[89975]={89975,'1015:47.95,26.99'}
G[89978]={89978,'1015:53.40,16.31'}
G[90024]={90024,'945:42.09,37.86'}
G[90065]={89794,'1015:46.65,15.78'}
G[90066]={90066,'945:51.15,43.08'}
G[90074]={90074,'945:40.24,35.31'}
G[90109]={90109,'1015:49.31,59.84'}
G[90122]={90122,'945:37,33 H:100128252'}
G[90167]={90423,'1015:49.67,15.37'}
G[90176]={90176,'941:70.11,26.86'}
G[90177]={90177,'949:56.74,17.16'}
G[90180]={80079,'949:52.57,9.85'}
G[90233]={78558,'946:67.43,6.57'}
G[90237]={45675,'946:67.50,6.63'}
G[90238]={90238,'945:69.53,54.18'}
G[90250]={90250,'23[20]:52.24,77.95'}
G[90255]={97644,'1015:41.25,50.51'}
G[90262]={90262,'949:57.14,26.75'}
G[90286]={90286,'945:32.35,72.25'}
G[90309]={90177,'945:58.50,60.35'}
G[90312]={90312,'945:21.47,37.88'}
G[90317]={109196,'1015:43.17,43.61'}
G[90369]={11034,'1014[10]:74.94,48.29'}	-- 23:74.27,53.25
G[90383]={91131,'1015:53.79,16.82'}
G[90389]={90389,'1015:56.66,17.69'}
G[90412]={90412,'948:72.82,32.58'}
G[90417]={78558,'1014[10]:28.51,48.32'}
G[90418]={67996,'1014[10]:28.45,48.91'}
G[90423]={90423,'1015:49.39,15.53'}
G[90425]={90425,'945:31.77,70.74'}
G[90426]={90426,'945:31.71,67.05'}
G[90429]={90429,'945:31.26,71.97'}
G[90437]={90437,'945:26.63,75.20'}
G[90438]={90438,'945:26.15,76.28'}
G[90443]={90443,'945:10.73,54.95'}
G[90452]={90452,'945:12.90,56.00'}
G[90473]={90473,'823:53.25,87.60'}
G[90474]={97644,'Near1015'}
G[90481]={74651,'945:61.51,45.84'}
G[90482]={90482,'945:16.23,56.89'}
G[90497]={90497,'945:12.76,56.83'}
G[90519]={90519,'945:44.83,37.83 H:100128255'}
G[90542]={90542,'1015:42.65,8.04'}
G[90543]={90916,'1015:48.90,26.40'}
G[90553]={70860,'945:9.68,56.22'}
G[90584]={90584,'945:44.22,41.54'}
G[90585]={90585,'945:12.82,56.10'}
G[90621]={90621,'1015:35.65,53.37'}
G[90644]={90644,'945:47.28,70.48'}
G[90703]={90703,'945:25.89,76.11'}
G[90738]={89794,'1015:49.94,26.55'}
G[90749]={66292,'1017:33.71,51.02'}
G[90782]={90782,'945:17.20,42.68'}
G[90783]={54614,'1017:33.76,50.76'}
G[90851]={90851,'945:20.25,51.20'}
G[90866]={7944,'1017:33.60,50.82'}
G[90885]={90885,'945:20.50,49.69'}
G[90894]={90894,'971:34.21,32.73'}
G[90916]={90916,'1015:48.66,16.54'}
G[90963]={90963,'945:58.14,58.68'}
G[90974]={90974,'945:58.43,60.44'}
G[90977]={90977,'945:58.64,60.25'}
G[90985]={90985,'1015:43.85,9.10'}
G[90991]={90991,'945:59.85,47.50'}
G[90993]={90993,'945:59.92,47.49'}
G[91014]={91017,'971:31.29,39.61'}
G[91017]={91017,'971:31.17,39.58'}
G[91020]={91020,'971:34.21,32.73'}
G[91024]={91024,'971:34.21,32.73'}
G[91025]={91025,'971:34.21,32.75'}
G[91026]={91361,'976:33.84,42.42'}
G[91029]={91029,'976:40.16,56.67'}
G[91030]={91030,'976:40.16,56.67'}
G[91031]={91031,'976:40.16,56.67'}
G[91033]={91033,'976:40.16,56.67'}
G[91034]={91034,'976:40.16,56.67'}
G[91061]={91065,'1015:40.78,9.32'}
G[91065]={91065,'1015:47.44,12.18'}
G[91066]={92783,'1018:48.87,70.20'}
G[91072]={91072,'976:40.93,47.75'}
G[91093]={91093,'945:41.06,68.68'}
G[91109]={33091,'1018:51.93,64.09'}
G[91115]={91115,'1015:61.36,62.03'}
G[91131]={91131,'1015:48.25,22.76'}
G[91144]={91144,'1031:20.42,61.55'}
G[91157]={91157,'1015:47.68,28.17'}
G[91158]={91158,'1017:36.82,30.95'}
G[91165]={91165,'Near1015'}
G[91166]={91165,'1015:62.87,51.45'}
G[91172]={78558,'1014[10]:70.53,44.06'}	-- also at 1014[10]:70.85,43.90 when doing the 39733 quest
G[91195]={25256,'976:40.48,56.09'}
G[91196]={38607,'971:34.23,32.63'}
G[91204]={91204,'1017:44.16,69.97'}
G[91222]={91222,'1017:37.38,63.85'}
G[91223]={91223,'1018:49.66,85.83'}
G[91227]={91227,'945:22.06,50.57'}
G[91242]={91242,'949:56.75,17.23'}
G[91243]={91243,'945:13.51,56.85'}
G[91249]={96465,'1017:44.80,77.42'}
G[91251]={91251,'945:16.36,58.41'}
G[91290]={79519,'945:57.43,58.88'}
G[91291]={79519,'945:25.78,38.87'}
G[91292]={79519,'945:60.46,46.24'}
G[91299]={48559,'945:27.06,44.42'}
G[91318]={91318,'1018:48.60,88.23'}
G[91324]={91324,'945:33.45,37.31'}
G[91351]={48559,'945:32.57,37.47'}
G[91361]={91361,'976:33.40,42.30'}
G[91362]={91361,'976:33.68,42.34'}
G[91364]={91361,'976:33.37,42.84'}	-- garrison level 3
G[91371]={91371,'1015:45.27,11.99'}
G[91403]={88867,'1015:61.69,41.10'}
G[91404]={91404,'971:34.21,32.74'}	-- garrison level 3
G[91419]={91419,'1015:56.61,59.60'}
G[91459]={91459,'1021:0.00,0.00'}
G[91462]={33091,'1018:54.69,72.85'}
G[91473]={91473,'1017:36.08,27.56'}
G[91481]={91222,'1017:42.02,64.49'}
G[91486]={91486,'1017:45.19,70.33'}
G[91519]={91222,'1017:43.80,68.21'}
G[91531]={91531,'1022:64.48,43.84'}
G[91553]={91222,'1017:46.24,70.37'}
G[91558]={91222,'Near1017'}
G[91571]={90177,'946:44.30,65.39'}
G[91573]={81280,'945:32.79,37.48'}
G[91575]={91575,'1022:54.65,39.99'}
G[91581]={91581,'1017:39.56,19.32'}
G[91589]={91589,'971:33.77,36.37'}
G[91590]={91590,'1017:36.11,27.36'}
G[91593]={91593,'949:51.06,10.95'}
G[91601]={91601,'949:51.16,15.26'}
G[91650]={100573,'1018:65.18,67.03'}
G[91721]={91721,'945:48.09,44.96'}
G[91750]={75121,'946:44.32,65.33'}
G[91751]={90177,'946:44.30,65.39'}
G[91803]={91803,'1017:46.56,83.92'}
G[91866]={91866,'23[20]:73.79,19.68'}
G[91871]={91871,'945:52.79,39.99'}
G[91913]={90177,'945:73.42,71.12'}
G[91923]={80079,'962:69.47,52.98'}
G[91935]={79537,'945:9.83,53.59'}
G[91954]={91954,'811[3]:75.10,43.74'}
G[92055]={21183,'945:47.37,70.38'}
G[92120]={21183,'945:62.59,31.11'}
G[92213]={78558,'947:27.60,10.28'}
G[92218]={92218,'1017:40.87,80.98'}
G[92219]={29611,'971:32.03,31.94'}
G[92223]={92223,'971:34.27,32.82'}
G[92317]={48559,'945:32.79,37.47'}
G[92326]={92326,'1018:65.19,58.24'}
G[92338]={21183,'945:62.76,27.85'}
G[92400]={38966,'976:39.13,54.84'}	-- garrison level 3
G[92401]={70860,'949:56.74,17.16'}
G[92408]={92408,'945:60,21 H:100128232'}
G[92414]={92414,'1017:31.18,57.96'}
G[92420]={40289,'1018:60.57,61.47'}
G[92451]={92451,'945:27.52,32.76'}
G[92464]={92464,'1014[10]:42.97,33.55'}
G[92465]={92465,'945:49.00,72.58'}
G[92495]={92495,'945:62.93,72.48'}
G[92508]={92508,'945:63.11,80.66'}
G[92539]={96254,'1017:60.14,50.76'}
G[92545]={92545,'945:58.15,58.57'}
G[92546]={92546,'945:31.88,71.33'}
G[92552]={92552,'945:35.56,46.66 H:100126950'}
G[92561]={91473,'1017:44.83,59.35'}
G[92566]={91473,'1017:46.55,67.78'}
G[92567]={91473,'1017:43.70,67.85'}
G[92569]={91473,'1017:45.87,72.69'}
G[92573]={91473,'1017:47.01,71.71'}
G[92575]={92575,'945:31.37,73.36'}
G[92604]={92604,'1017:44.32,22.76'}
G[92616]={92616,'945:50.42,44.28'}
G[92618]={92618,'1018:38.91,61.45'}
G[92619]={92619,'1018:42.35,59.00'}
G[92620]={40619,'1018:42.47,58.97'}
G[92636]={92636,'945:38.47,77.69'}
G[92647]={92647,'945:45.89,47.24 H:100128258'}
G[92657]={92657,'945:50.92,74.55'}
G[92680]={92680,'1018:51.44,57.00'}
G[92683]={92683,'1018:42.13,59.03'}
G[92688]={92688,'1018:54.79,52.78'}
G[92697]={92697,'1018:51.49,56.85'}
G[92710]={40289,'1018:64.97,61.18'}
G[92718]={92718,'1032[1]:80.10,36.55'}
G[92742]={40289,'1018:52.46,63.42'}
G[92751]={92751,'1017:60.68,67.76'}
G[92766]={92766,'945:54.28,80.72'}
G[92776]={92776,'1032[1]:46.70,27.65'}
G[92782]={92782,'1032[1]:70.42,30.74'}
G[92783]={92783,'1018:66.20,44.54'}
G[92788]={92788,'1018:57.55,55.90'}
G[92805]={92805,'945:55.27,74.74'}
G[92817]={92817,'945:54.26,80.83'}
G[92819]={92819,'945:54.40,80.87'}
G[92842]={40619,'1018:40.85,53.01'}
G[92850]={40619,'1018:40.73,53.01'}
G[92873]={92873,'945:10.77,55.11'}
G[92909]={11034,'Near1014'}
G[92941]={92941,'945:32.65,35.93'}
G[92954]={92954,'1018:43.88,50.36'}
G[92977]={92977,'945:12.21,56.94'}
G[92980]={93011,'1032[1]:74.45,35.96'}
G[92986]={18417,'1032[1]:74.41,37.18'}
G[92987]={92718,'1018[13]:23.14,40.74'}
G[93001]={93001,'945:16.33,57.18'}
G[93002]={93002,'945:52.35,65.10'}
G[93003]={93003,'945:54.60,57.07'}
G[93011]={93011,'1028:22.08,55.83'}
G[93024]={93024,'945:56.97,35.16'}
G[93027]={92718,'1018[3]:23.14,40.74'}
G[93029]={93029,'1018[3]:43.16,82.08'}
G[93076]={93076,'945:36.12,79.14 H:100128257'}
G[93111]={93111,'1018:60.74,32.44'}
G[93112]={93112,'1028:40.05,67.19'}
G[93115]={93115,'1028:40.36,69.90'}
G[93125]={93125,'945:34.56,78.17'}
G[93127]={93011,'1028:60.51,44.76'}
G[93149]={92718,'1018:38.87,50.93'}
G[93157]={93157,'1018:56.96,56.34'}
G[93166]={93166,'1017:48.24,50.34'}
G[93189]={93189,'1014[10]:46.15,26.51'}
G[93231]={93231,'1017:68.50,54.35'}
G[93234]={93234,'1017:71.44,42.51'}
G[93326]={78558,'1015:43.55,43.42'}
G[93337]={78558,'1015:45.09,42.90'}
G[93354]={78558,'1015:47.95,27.21'}
G[93377]={93377,'1022:28.99,44.72'}
G[93396]={93396,'945:59.69,45.92'}
G[93399]={11034,'23:74.27,53.16'}
G[93446]={93446,'1017:68.16,48.73'}
G[93489]={93489,'1018:54.49,82.42'}
G[93531]={93531,'1014[10]:38.27,40.33'}
G[93581]={93581,'1018:46.28,84.55'}
G[93596]={93596,'945:49.26,40.96'}
G[93600]={93600,'1018:53.75,79.83'}
G[93603]={91158,'1017:55.04,72.56'}
G[93658]={90177,'945:62.66,27.66'}
G[93659]={74272,'945:62.90,27.87'}
G[93716]={93716,'1028:62.74,48.37'}
G[93759]={109196,'1028:38.79,60.64'}
G[93787]={93787,'23[20]:53.44,78.63'}
G[93805]={93805,'1024:38.57,69.03'}
G[93812]={93812,'947:28.68,10.85'}
G[93822]={93822,'947:28.20,10.63'}
G[93823]={93823,'1035[1]:58.98,29.73'}
G[93826]={93826,'1024[6]:54.95,63.22'}
G[93833]={95956,'1024:43.63,59.90'}
G[93836]={93836,'1024[8]:59.78,32.53'}
G[93841]={95410,'1024:52.47,44.72'}
G[93846]={93826,'1024:53.20,70.02'}
G[93890]={93890,'1018:48.40,84.65'}
G[94068]={94068,'1024:49.45,39.24'}
G[94101]={94101,'1024:40.00,52.30'}
G[94117]={94117,'1018:37.05,58.48'}
G[94138]={94138,'1014[4]:42.49,75.94'}
G[94141]={94141,'1014[4]:42.48,74.69'}
G[94159]={94159,'1014[4]:41.15,74.32'}
G[94179]={94179,'1018:54.38,73.58'}
G[94227]={10181,'1017:56.78,66.29'}
G[94228]={10181,'1017:62.56,68.07'}
G[94366]={94366,'1018:38.92,64.70'}
G[94409]={18180,'1024:40.04,52.25'}
G[94410]={95238,'1028:33.94,70.05'}
G[94429]={91242,'947:29.77,10.65'}
G[94434]={94434,'1024:39.93,52.24'}
G[94472]={94472,'945:39.50,28.26 H:100128231'}
G[94561]={94561,'1024:49.03,55.26'}
G[94571]={99153,'1024:44.88,65.71'}
G[94789]={94789,'941:41.59,72.31'}
G[94801]={94801,'941:40.04,72.22'}
G[94863]={94863,'1018:69.44,49.38'}
G[94864]={83837,'978:45.97,29.10'}
G[94870]={94870,'971:33.11,37.10'}
G[94902]={93011,'1054:49.40,55.13'}
G[94977]={40619,'1018:40.73,53.03'}
G[95002]={95002,'947:29.82,10.69'}
G[95013]={95013,'1024:38.74,63.41'}
G[95028]={108326,'1018:39.13,51.05'}
G[95044]={95044,'945:12.69,55.40'}
G[95054]={95054,'945:31.91,73.09'}
G[95056]={95056,'945:47.20,52.50'}
G[95117]={95117,'1018:69.49,49.33'}
G[95130]={95130,'1024:37.47,64.30'}
G[95138]={95138,'1018:67.38,53.42'}
G[95186]={95186,'1024:41.13,61.57'}
G[95191]={95191,'1024:43.70,59.90'}
G[95202]={95202,'1018:54.29,68.32'}
G[95226]={95226,'1028:38.27,73.66'}
G[95234]={95234,'321[1]:53.12,57.60'}
G[95235]={95235,'945:21.21,49.56'}
G[95236]={95236,'945:19.00,39.96'}
G[95237]={18417,'1052[1]:57.70,67.42'}
G[95238]={95238,'1052[2]:59.38,51.31, 1052[1]:60.20,68.35'}	-- in both places for acceptance of quest 41066, and turnin, but not giving next quest...only downstairs location for that.
G[95240]={93011,'1052[1]:57.69,67.48'}
G[95256]={95256,'1024:39.42,36.94'}
G[95266]={95266,'1024:46.76,37.87'}
G[95290]={95290,'1024:48.49,27.71'}
G[95310]={95310,'1024:42.35,29.65'}
G[95318]={95318,'1018:61.08,69.33'}
G[95392]={97667,'1024[31]:39.73,53.31'}
G[95395]={95396,'1018:61.05,73.23'}
G[95396]={95396,'1018:62.77,71.71'}
G[95410]={95410,'1024:45.69,39.12'}
G[95421]={97667,'1024:45.21,32.52'}
G[95424]={95424,'945:57.96,59.34'}
G[95438]={95438,'1024:40.02,52.36'}
G[95611]={10181,'1017:60.93,65.32'}
G[95726]={95726,'1018:61.88,72.60'}
G[95753]={95753,'1024[31]:74.57,55.57'}
G[95755]={10181,'1017:55.07,72.64'}
G[95799]={95799,'1024[31]:51.76,63.65'}
G[95872]={95872,'1024:51.38,31.98'}
G[95956]={95956,'1024:41.19,61.49'}
G[96014]={18013,'945:61.66,45.70'}
G[96038]={95956,'Near1024'}
G[96072]={96072,'1024:43.75,72.77'}
G[96083]={96083,'1024:40.25,64.05'}
G[96084]={96084,'1024:40.01,57.96'}
G[96129]={96129,'1017:44.47,47.16'}
G[96147]={96147,'945:57.83,59.79'}
G[96183]={96183,'1014[10]:74.64,44.96'}
G[96229]={96229,'1017:42.44,47.87'}
G[96254]={96254,'1017:43.17,49.16'}
G[96257]={96257,'1017:46.73,44.44'}
G[96258]={96257,'1017:46.32,44.82'}
G[96270]={96270,'1024[29]:61.26,72.71'}
G[96277]={96277,'1028:75.25,36.64'}
G[96278]={96278,'1028:72.82,32.79'}
G[96286]={97667,'1024[8]:41.90,84.48'}
G[96304]={96304,'971:41.85,47.73'}
G[96362]={96362,'971:44.29,50.98'}
G[96420]={97297,'1028:60.58,44.86'}
G[96436]={109196,'1028:64.05,52.30'}
G[96441]={96441,'1028:64.30,59.17'}
G[96451]={96451,'971:44.01,51.42'}
G[96453]={97667,'1024:49.28,24.20'}
G[96465]={96465,'1017:42.79,82.69'}
G[96469]={96469,'1035[1]:58.37,84.85'}
G[96494]={96494,'1028[1]:47.21,19.13'}
G[96513]={96513,'1024:57.62,56.61'}
G[96520]={95956,'1024:38.40,61.24'}
G[96586]={96586,'1035[1]:41.01,37.13'}
G[96621]={96621,'1024:48.76,27.19'}
G[96644]={66292,'1014[10]:29.10,46.88'}
G[96655]={95238,'1028:60.53,44.66'}
G[96663]={48736,'301:18.67,51.08'}
G[96665]={93011,'1032[1]:49.14,49.44'}
G[96666]={93011,'1032[3]:62.27,53.31'}
G[96669]={18417,'1032[3]:62.27,53.31'}
G[96675]={95238,'1032[2]:41.09,47.17'}
G[96682]={96682,'1032[2]:46.94,18.72'}
G[96683]={96683,'4:61.35,8.92'}
G[96686]={10181,'4:61.37,8.87'}
G[96705]={96705,'971:44.00,51.46'}
G[96735]={96735,'976:47.21,37.75'}
G[96984]={96984,'1024:54.71,44.98'}
G[96986]={96986,'1024:53.46,43.54'}
G[96997]={96997,'1032[1]:49.39,33.21'}
G[97074]={97074,'1017:48.02,54.57'}
G[97094]={97094,'1024[16]:51.92,81.44'}	-- outer map I think is 1024:41.06,45.52
G[97130]={97130,'1024:55.28,41.79'}
G[97193]={97094,'Near1024'}
G[97228]={97228,'1032[2]:46.81,33.91'}
G[97258]={97258,'1017:51.46,56.94'}
G[97270]={93446,'1017:69.90,45.50'}
G[97296]={78558,'301:72.55,47.02'}
G[97297]={97297,'1028:69.93,44.23'}
G[97301]={97667,'1024:53.37,64.01'}
G[97303]={93011,'1028:69.86,37.91'}
G[97305]={97074,'1017:36.78,31.11'}
G[97306]={97306,'1017:33.75,45.85'}
G[97319]={93234,'1022:65.44,47.02'}
G[97344]={95956,'1024:53.37,64.01'}
G[97345]={97345,'1024:48.31,40.68'}
G[97370]={97370,'1028:68.74,27.59'}
G[97389]={97389,'1035[1]:59.22,13.44'}
G[97407]={93841,'1024:53.16,68.76'}
G[97419]={93234,'1022:45.36,32.65'}
G[97480]={93234,'1022:46.85,49.29'}
G[97553]={97553,'1024:41.28,72.59'}
G[97558]={93234,'1022:43.22,67.36'}
G[97643]={97644,'1032[2]:41.33,47.36'}
G[97644]={97644,'1032[3]:24.44,55.73'}
G[97662]={95956,'1024:40.36,71.69'}
G[97666]={97553,'1014[10]:70.51,44.35'}
G[97667]={97667,'1024:39.00,37.32'}
G[97846]={97094,'1024[16]:30.61,62.79'}
G[97854]={97854,'1080:53.92,45.79'}
G[97891]={97891,'1038:29.45,39.33'}
G[97892]={33091,'1038:27.90,51.76'}
G[97903]={97903,'1038:31.30,52.50'}
G[97919]={97919,'1024:46.50,7.95'}
G[97923]={101195,'1077:30.92,54.26'}
G[97925]={41308,'1024:32.19,66.86'}
G[97974]={97974,'1024:57.59,56.43'}
G[97978]={78558,'1032[3]:62.54,53.52'}
G[97979]={96465,'1017:65.88,59.40'}
G[97986]={96465,'1017:70.19,69.37'}
G[97988]={96254,'1017:70.30,69.25'}
G[98000]={98613,'1077:52.72,51.06'}
G[98002]={40997,'1077:52.56,51.45'}	-- in release 21796 at: 1077:52.62,51.45
G[98013]={38243,'1077:47.27,7.51'}
G[98067]={25197,'1024:42.73,10.93'}
G[98092]={98092,'1014[4]:37.84,45.09'}
G[98093]={98093,'1014[4]:37.41,44.25'}
G[98102]={98102,'1014[4]:40.78,75.40'}
G[98229]={93011,'1028:28.60,63.06'}
G[98486]={98486,'1028:26.89,63.06'}
G[98498]={98498,'1017:78.89,59.40'}
G[98584]={40289,'1018:52.46,63.42'}
G[98587]={98587,'1017:78.25,58.64'}
G[98613]={98613,'1052[1]:58.64,54.38'}
G[98632]={109295,'1052[1]:58.01,54.59'}
G[98685]={98685,'481:54,39'}
G[98690]={98690,'504[1]:50,46'}
G[98695]={98613,'1068[1]:81.28,61.13'}
G[98711]={97644,'1028:73.15,33.81'}
G[98794]={98794,'1038:27.91,47.46'}
G[98825]={93805,'1024[6]:74.77,75.11'}
G[98955]={98955,'1017:58.66,65.51'}
G[99045]={97644,'1028:60.52,44.83'}
G[99153]={99153,'1024[29]:43.29,28.26'}
G[99190]={99153,'1024[29]:49.18,72.16'}
G[99247]={93011,'1014[10]:74.95,49.00'}
G[99254]={18417,'1014[10]:74.99,49.06'}
G[99262]={109196,'1014[10]:74.42,51.28'}
G[99343]={97644,'Near1014'}
G[99398]={67996,'24:28.74,37.32'}
G[99415]={99415,'24:28.73,37.19'}
G[99491]={95956,'1080:34.00,56.53'}
G[99905]={99905,'1080:42.32,46.45'}
G[100031]={100031,'23[20]:63.10,37.23'}
G[100387]={33091,'1018:52.52,64.15'}
G[100395]={48736,'301:20.09,34.90'}
G[100429]={1747,'301:85.89,31.58'}
G[100453]={100453,'4:57.17,10.53'}
G[100482]={89975,'1015:47.97,25.90'}
G[100495]={100495,'1024:54.43,41.46'}
G[100573]={100573,'1018:62.33,76.23'}
G[100622]={100622,'1035[1]:43.63,34.63'}
G[100635]={100635,'1035[1]:59.76,13.49'}
G[100675]={109196,'301:85.32,32.28'}
G[100786]={100786,'Near1014'}
G[100866]={100866,'4:45.71,15.88'}
G[100873]={95238,'4:45.82,15.12'}
G[100973]={1747,'301:85.76,31.77'}
G[100982]={100982,'1028:33.93,69.96'}
G[101004]={101004,'301:40.28,77.72'}
G[101035]={10181,'4:45.68,15.93'}
G[101061]={101061,'1014[10]:57.56,45.72'}
G[101064]={101061,'241:56.27,31.84'}
G[101195]={101195,'1077:44.50,51.08'}	-- in release 21796 he is at 1077:44.66,51.97, does he move?
G[101259]={101259,'1077:0.00,0.00'}	-- could not get map to appear near her
G[101310]={42129,'1014[10]:46.15,21.35'}
G[101313]={17468,'1014[10]:46.30,20.57'}
G[101314]={101314,'20:78.96,40.98'}
G[101513]={101513,'1014[4]:41.44,78.07'}
G[101547]={78558,'32:46.99,75.09'}
G[101759]={101759,'301:76,17'}
G[101927]={18417,'1015:43.55,43.47'}
G[101943]={101943,'1015:42.48,46.93'}
G[102018]={102018,'Near1014'}
G[102120]={102120,'673:40.76,69.12'}
G[102333]={102333,'Near1014'}
G[102478]={102478,'1014[10]:60.03,53.44'}
G[102574]={102478,'1072:43.54,24.65'}
G[102578]={102478,'1072:36.64,29.13'}
G[102585]={109196,'301:84.39,33.74'}
G[102589]={102589,'1040:49.97,53.67'}
G[102594]={102594,'1014[4]:30.47,70.42'}
G[102655]={101314,'1040:49.36,53.43'}
G[102669]={98613,'1072:42.81,46.61'}
G[102700]={102700,'1068[2]:58.86,42.94'}
G[102709]={102709,'1040:49.34,37.71'}
G[102799]={97644,'1014[10]:73.85,46.04'}
G[102938]={7999,'1018:67.45,56.12'}
G[102940]={102940,'1072:47.29,53.94'}
G[102988]={78558,'1015:49.66,26.80'}
G[103022]={7999,'1018:69.54,49.52'}
G[103023]={103023,'1072:42.82,46.91'}
G[103025]={103025,'1052[2]:59.72,45.71'}
G[103092]={103092,'1014[10]:48.48,63.37'}
G[103156]={18417,'1014[10]:65.64,67.29'}
G[103176]={103176,'1015:38.39,47.80'}
G[103180]={103180,'1015:37.51,49.20'}
G[103761]={97644,'1052[1]:59.30,57.60'}
G[103778]={37570,'1077:68.99,75.89'}
G[103875]={33091,'241:66.74,60.53'}
G[104241]={33091,'1077:45.93,51.03'}
G[104381]={104381,'1014[10]:71.39,50.63'}
G[104385]={104385,'490:50.51,37.61'}
G[104535]={101259,'490:51.28,36.83'}
G[104728]={7999,'1018:66.21,44.78'}
G[104799]={7999,'1018:57.82,38.59'}
G[104885]={7999,'1018:66.93,50.13'}
G[104921]={7999,'1018:53.71,55.89'}
G[105464]={105464,'1014[11]:67.36,62.69'}
G[106558]={106558,'1076[2]:44.92,37.37'}
G[106629]={106629,'1015:38.81,53.26'}
G[106879]={104381,'1014[10]:69.69,43.06'}
G[106881]={106881,'1015:64.25,56.12'}
G[106914]={106914,'1015:50.41,30.79'}
G[106915]={106915,'1015:50.46,30.73'}
G[106930]={106930,'1014[10]:28.48,74.54'}
G[106951]={106951,'1014[10]:60.33,17.31'}
G[107244]={106914,'1015:63.85,28.94'}
G[107245]={106915,'1015:63.88,28.88'}
G[107334]={107334,'1015[17]:30.32,45.31'}
G[107447]={107447,'1021:0.00,0.00'}
G[107498]={107498,'1017:54.05,30.20'}
G[107499]={107499,'1017:50.31,34.04'}
G[107659]={107659,'34:19.53,57.18'}
G[107660]={107660,'1080:42.95,38.99'}
G[107674]={107674,'1017:51.31,56.97'}
G[107675]={107675,'1017:51.37,57.25'}
G[107723]={18417,'1052[2]:58.41,51.62'}
G[107840]={107840,'1017:36.96,31.84 1017:44.86,59.26 1017:37.35,63.77 1017:33.82,45.75'}
G[107934]={107934,'301:37.08,43.09'}
G[107968]={20735,'1014[10]:26.01,52.08'}
G[107979]={107979,'30:36.78,52.57'}
G[107995]={89794,'1015:57.56,13.55'}
G[108017]={108017,'1024[6]:54.91,77.94'}
G[108069]={99153,'1024[29]:51.23,54.00'}
G[108072]={108072,'1017:74.90,55.57'}
G[108239]={108239,'1052[1]:57.95,56.86'}
G[108304]={108304,'1018:59.42,84.12'}
G[108305]={93826,'1024:47.47,84.73'}
G[108326]={108326,'1052[1]:56.22,38.86'}
G[108328]={108328,'1015:53.39,45.43'}
G[108434]={93826,'1024[6]:54.82,64.19'}
G[108571]={18417,'1052[1]:58.63,57.85'}
G[108572]={93011,'1052[1]:58.59,57.85'}
G[108776]={11034,'22:51.56,79.05'}
G[108777]={1854,'22:51.44,79.03'}
G[108778]={78577,'22:51.34,79.01'}
G[108782]={108782,'1052[1]:57.59,52.31'}
G[108916]={108916,'301:18.99,26.45'}
G[108961]={108961,'Near1014'}
G[109045]={109045,'1018:66.82,75.67'}
G[109196]={109196,'1014[10]:95.16,64.90'}
G[109295]={109295,'1014[10]:95.13,65.14'}
G[109326]={109326,'1015:50.07,21.42'}
G[109334]={88873,'1015:51.94,61.79'}
G[109631]={109631,'1018:66.68,77.25'}
G[110695]={17204,'1091:44.91,9.39'}
G[110896]={110896,'1018:56.95,53.27'}
G[111086]={111086,'1091:44.15,11.30'}
G[111109]={111109,'1014[10]:57.61,45.75'}
G[111981]={111981,'1018:59.76,32.92'}
G[112052]={112052,'1018:63.31,39.52'}
G[112130]={78558,'1014[12]:26.76,35.01'}
G[112407]={112407,'1052[1]:59.16,54.30'}
G[112666]={108326,'Near1014'}
G[112953]={112953,'1052[1]:58.66,43.11'}
G[113547]={113547,'4:55.65,11.04'}
G[113637]={78558,'32[21]:29.78,48.84'}
G[113655]={28070,'32[21]:30.86,49.03'}
G[113813]={113813,'1014[10]:66.30,68.11'}
G[113836]={67996,'32[21]:30.16,51.16'}
G[113911]={113911,'1017:33.33,31.42'}
G[113986]={78558,'32[21]:50.06,48.39'}
G[114562]={114562,'1077:31.22,53.75'}
G[151891]={63054,'807:45.11,33.81'}
G[500001]={40643,'615:39.12,78.71 A:40643'}
G[500002]={39887,'615:39.08,78.53 A:40642'}
G[500003]={39881,'615:49.22,57.01 A:39881'}
G[500004]={39881,'615:39.23,78.63 A:39881'}
G[500005]={39881,'615:29.55,78.93 A:39881'}
G[500006]={14305,'HC 341:33.29,48.01 A:14305','Down stairs underground'}
G[500007]={14305,'HC 39:57.52,52.55 A:14305'}
G[500008]={14305,'HC 301:48.99,89.74 A:14305'}
G[500009]={33532,'HC 488:71.68,39.58 A:33532'}
G[500010]={33532,'HC 490:50.70,44.45 A:33532'}
G[500011]={33532,'HC 488:59.80,54.23 A:33532'}
G[500012]={33532,'HC 493:27.09,58.75 A:33532'}
G[500013]={22818,'HC 465:88.33,50.39 A:22818'}
G[500014]={22818,'HC 161:59.79,57.40 A:22818'}
G[500015]={39627,'Near606 A:39627'}
G[500016]={40278,'795:51.54,85.50 A:52477'}
G[500017]={39925,'795:66.03,66.08 A:52478'}
G[500018]={40278,'795:66.23,66.10 A:52477'}
G[500019]={39925,'795:41.90,61.48 A:52478'}
G[500020]={45165,'22:39.82,69.73 A:45165'}
G[500021]={46654,'17:15.96,33.40 A:46654'}
G[500022]={500022,'HW 700:78.87,77.79 A:1208129'}
G[500023]={500022,'HW 39:52.91,53.74 A:1190047'}
G[500024]={500024,'301:60.08,75.08 A:1209076'}
G[500025]={500025,'321[1]:54.5,77.8 A:1209095'}
G[500026]={44789,'684:79.66,75.66 A:45312'}
G[500027]={44789,'764[1]:27.94,60.56 A:47293'}
G[500028]={44789,'764[4]:60.32,40.82 A:47293'}
G[500029]={44789,'764[6]:58.84,52.46 A:47293'}
G[500030]={42039,'81:45.53,33.71 A:42039'}
G[500031]={57864,'816:25.98,62.92 A:57864'}
G[500032]={500032,'816:71.61,80.63 A:55624'}
G[500033]={57864,'816:87.86,49.89 A:57864'}
G[500034]={36077,'544:53.16,36.55 A:38124','In mine'}
G[500035]={36077,'544:54.39,16.93 A:38124'}
G[500036]={34668,'544:43.63,25.32 A:38387'}
G[500037]={36379,'544:43.85,25.30 A:38120'}
G[500038]={33533,'HC 488:72.83,36.41 A:33533'}
G[500039]={33533,'HC 490:50.57,45.16 A:33533'}
G[500040]={33533,'HC 488:59.80,54.22 A:33533'}
G[500041]={33533,'HC 201:47.39,9.20 493:40.25,82.73>201 A:33533'}
G[500042]={14444,'HC 9:60.75,23.10 A:14444'}
G[500043]={14444,'HC 382:58.05,91.77 A:14444'}
G[500044]={45400,'23:53.02,53.20 A:45400'}
G[500045]={45417,'23:52.92,53.07 A:45417'}
G[500046]={45400,'23:61.61,42.60 A:45400'}
G[500047]={45417,'23:61.47,42.69 A:45417'}
G[500048]={45400,'23:50.59,20.09 A:45400'}
G[500049]={45429,'23:50.44,20.15 A:45729'}
G[500050]={45417,'23:50.54,20.17 A:45417'}
G[500051]={45429,'23:27.61,21.17 A:45729'}
G[500052]={45417,'23:73.71,52.09 A:45417'}	-- this is the final resting place and I believe exists once 27526 is turned in
G[500053]={45400,'23:73.62,51.87 A:45400'} -- see comments for npc 500052
G[500054]={53566,'808:65.98,22.81 A:53566'}
G[500055]={56133,'807:68.85,43.40 A:56133'}
G[500056]={56133,'807:55.89,49.43 A:56133'}
G[500057]={56474,'807:18.09,55.68 A:56474'}
G[500058]={56138,'807:52.68,62.82 A:56138'}
G[500059]={56133,'807:55.83,49.35 A:56133'}
G[500060]={56133,'807:32.25,68.55 A:56133'}
G[500062]={56474,'807:32.24,68.29 A:56474'}
G[500063]={56138,'807:32.33,68.47 A:56138'}
G[500064]={56133,'807:36.03,68.97 A:56133'}
G[500065]={56474,'807:35.99,69.09 A:56474'}
G[500066]={56138,'807:36.12,69.05 A:56138'}
G[500067]={56133,'807:36.00,69.11 A:56133'}
G[500068]={56133,'807:75.27,35.50'}
G[500069]={58113,'857:60.42,25.57 A:58113'}
G[500070]={56112,'857:66.40,32.53 A:56114'}
G[500071]={63542,'809:54.17,83.42 A:63542'}
G[500072]={58745,'857:24.70,33.99 A:58745'}
G[500073]={55122,'809:53.91,83.56 A:59441','Wandering around camp'}
G[500074]={56133,'858:50.18,10.19 A:62779'}
G[500075]={63317,'858:56.58,75.92 A:63317'}
G[500076]={60973,'809:74.93,88.55 A:60973'}
G[500077]={56133,'858:44.42,16.80 A:62779','Down in Morrowchamber'}
G[500078]={62667,'858:50.29,12.06 A:62667'}
G[500079]={62666,'858:50.22,12.10 A:62666'}
G[500080]={60687,'809:35.12,59.66 A:61819'}
G[500081]={54617,'806:46.47,96.30 A:54617'}
G[500082]={54617,'806:46.20,84.81 A:54617'}
G[500083]={55521,'806:30.79,52.27 A:56406'}
G[500084]={58468,'811:56.45,43.24 A:58468'}
G[500085]={64563,'898[3]:48.98,21.22 A:64563'}	-- Baron location for turnin
G[500086]={64563,'898[3]:49.08,20.63 A:64562'}	-- Spirit location for turnin
G[500087]={4949,'891:58.59,62.04 A:68025'}
G[500088]={15892,'HL 381:45.16,52.25 A:15892'}
G[500089]={58646,'807:52.92,51.83 A:58646'}
G[500090]={78554,'970:48.54,14.18 A:78554'}
G[500091]={18927,'301:73.90,55.87 A:18927'}
G[500092]={18927,'301:63.75,31.97 A:18927'}
G[500093]={18927,'301:49.73,90.01 A:18927'}
G[500094]={18927,'504[1]:46.33,72.69 A:18927'}
G[500095]={18927,'504[1]:44.16,58.91 A:18927'}
G[500096]={19171,'471:60.94,28.57 A:19171'}
G[500097]={19171,'471:68.01,61.73 A:19171'}
G[500098]={19171,'464:21.36,54.25 A:19171'}
G[500099]={19169,'462:54.18,50.76 A:19169'}
G[500100]={19169,'480:62.50,73.92 A:19169'}
G[500101]={19169,'480:59.09,60.91 A:19169'}
G[500102]={19169,'480:78.14,57.64 A:19169'}
G[500103]={19169,'504[1]:62.73,30.31 A:19169'}
G[500104]={19169,'504[1]:50.89,22.41 A:19169'}
G[500105]={19177,'321[1]:32.32,65.85 A:19177'}
G[500106]={20102,'11:67.52,74.16 A:20102'}
G[500107]={20102,'161:50.89,30.10 A:20102'}
G[500108]={20102,'161:51.52,26.68 A:20102'}
G[500109]={20102,'161:52.24,28.58 A:20102'}
G[500110]={20102,'161:51.95,29.38 A:20102'}
G[500111]={20102,'281:58.74,48.38 A:20102'}
G[500112]={20102,'281:59.76,49.70 A:20102'}
G[500113]={20102,'281:59.89,50.89 A:20102'}
G[500114]={20102,'281:61.04,48.87 A:20102'}
G[500115]={20102,'479:32.30,64.80 A:20102'}
G[500116]={20102,'479:32.90,66.72 A:20102'}
G[500117]={20102,'479:33.85,64.11 A:20102'}
G[500118]={20102,'481:28.12,47.06 A:20102'}
G[500119]={20102,'481:49.17,31.50 A:20102'}
G[500120]={20102,'481:53.00,51.12 A:20102'}
G[500121]={20102,'481:55.26,80.52 A:20102'}
G[500122]={20102,'481:58.02,46.14 A:20102'}
G[500123]={20102,'481:54.92,38.48 A:20102'}
G[500124]={20102,'481:58.97,58.09 A:20102'}
G[500125]={20102,'481:63.60,39.76 A:20102'}
G[500126]={20102,'495:40.77,84.50 A:20102'}
G[500127]={20102,'504[2]:33.15,52.45 A:20102'}
G[500128]={20102,'673:40.56,68.29 A:20102'}
G[500129]={20102,'673:40.51,73.08 A:20102'}
G[500130]={20102,'673:41.70,74.21 A:20102'}
G[500131]={77210,'941:82.83,76.33 A:77210'}
G[500132]={70860,'949:45.86,70.30 A:74594'}
G[500133]={70860,'949:46.10,70.20 A:74594'}
G[500134]={79537,'947:62.58,26.22 A:80073'}
G[500135]={1230865,'971:44.28,53.92 A:1230865'}	-- garrison level 2 location
G[500136]={78568,'949:53.00,59.78 A:75136'}
G[500137]={79576,'949:53.31,59.89 A:75146'}
G[500138]={79243,'971:29.26,33.14 A:77209'}	-- garrison level 3 location
G[500139]={77383,'971:51.19,63.58 A:77383'}	-- location is top of stairs for plot 20
G[500140]={78207,'971:51.19,63.58 A:78207'}	-- location is top of stairs for plot 20
G[500141]={77365,'971:51.19,63.58 A:77365'}	-- plot 20
G[500142]={77831,'971:51.19,63.58 A:77831'}	-- plot 20
G[500143]={79519,'948:51.57,31.36 A:79519'}
G[500144]={80648,'948:60.52,39.01 A:80648'}
G[500145]={79519,'948:46.50,46.66 A:81770'}
G[500146]={79953,'971:28.76,35.02 A:79953'}	-- garrison level 3 location
G[500147]={1234243,'971:34.11,32.57 A:1234243'}	-- garrison level 3 position
G[500148]={77372,'971:51.19,63.58 A:77372'}	-- plot 20
G[500149]={77777,'971:51.19,63.58 A:77777'}	-- plot 20
G[500150]={4949,'970[1]:81.54,44.81 A:78553'}
G[500151]={3391,'941:57.43,48.31 A:78466'}	-- garrison level 1, barracks position
G[500152]={70860,'941:19.74,44.76 A:70860'}
G[500153]={72274,'941:55.48,56.63 A:72274'}
G[500154]={3391,'941:42.16,55.51 A:78466'}	-- garrison level 2 position
G[500155]={77354,'971:51.19,63.58 A:77354'}	-- plot 20
G[500156]={77781,'971:51.19,63.58 A:77781'}	-- plot 20
G[500157]={77356,'971:51.19,63.58 A:77356'}	-- plot 20
G[500158]={77775,'971:51.19,63.58 A:77775'}	-- plot 20
G[500159]={82610,'949:46.19,55.09 A:82610'}
G[500160]={78994,'947:65.23,26.18 A:73395'}
G[500161]={72413,'947:65.33,25.98 A:80078'}
G[500162]={80079,'947:65.39,26.17 A:80079'}
G[500163]={79537,'947:65.32,26.38 A:80073'}
G[500164]={1225726,'946:59.97,16.48 A:1225726'}
G[500165]={74651,'946:55.55,40.97 A:75808'}
G[500166]={47269,'976:51.43,57.39 A:88013'} -- plot 22
G[500167]={47269,'976:58,27 A:88013'} -- plot 25
G[500168]={46338,'976:51.43,57.39 A:88017'} -- plot 22
G[500169]={46338,'976:58,27 A:88017'} -- plot 25
G[500170]={47869,'976:51.43,57.39 A:88022'} -- plot 22
G[500171]={47869,'976:58,27 A:88022'} -- plot 25
G[500172]={61021,'976:51.43,57.39 A:88023'} -- plot 22
G[500173]={61021,'976:58,27 A:88023'} -- plot 25
G[500174]={9177,'976:51.43,57.39 A:88024'} -- plot 22
G[500175]={9177,'976:58,27 A:88024'} -- plot 25
G[500176]={47366,'976:51.43,57.39 A:88027'} -- plot 22
G[500177]={47366,'976:58,27 A:88027'} -- plot 25
G[500178]={39930,'976:51.43,57.39 A:88025'}	-- plot 22
G[500179]={39930,'976:58,27 A:88025'}	-- plot 25
G[500180]={43184,'976:51.43,57.39 A:88026'}	-- plot 22
G[500181]={43184,'976:58,27 A:88026'}	-- plot 25
G[500182]={87991,'976:51.43,57.39 A:87991'}	-- plot 22
G[500183]={87991,'976:58,27 A:87991'}	-- plot 25
G[500184]={46854,'976:51.43,57.39 A:87992'}	-- plot 22
G[500185]={46854,'976:58,27 A:87992'}	-- plot 25
G[500186]={11036,'976:51.43,57.39 A:87997'}	-- plot 22
G[500187]={11036,'976:58,27 A:87997'}	-- plot 25
G[500188]={2487,'976:51.43,57.39 A:87995'}	-- plot 22
G[500189]={2487,'976:58,27 A:87995'}	-- plot 25
G[500190]={64842,'976:51.43,57.39 A:87996'}	-- plot 22
G[500191]={64842,'976:58,27 A:87996'}	-- plot 25
G[500192]={87994,'976:51.43,57.39 A:87994'}	-- plot 22
G[500193]={87994,'976:58,27 A:87994'}	-- plot 25
G[500194]={58113,'976:51.43,57.39 A:87998'}	-- plot 22
G[500195]={58113,'976:58,27 A:87998'}	-- plot 25
G[500196]={40997,'976:51.43,57.39 A:87999'}	-- plot 22
G[500197]={40997,'976:58,27 A:87999'}	-- plot 25
G[500198]={88007,'976:51.43,57.39 A:88007'}	-- plot 22
G[500199]={88007,'976:58,27 A:88007'}	-- plot 25
G[500200]={49444,'976:51.43,57.39 A:88000'}	-- plot 22
G[500201]={49444,'976:58,27 A:88000'}	-- plot 25
G[500202]={38237,'976:51.43,57.39 A:88001'}	-- plot 22
G[500203]={38237,'976:58,27 A:88001'}	-- plot 25
G[500204]={28444,'976:51.43,57.39 A:88002'}	-- plot 22
G[500205]={28444,'976:58,27 A:88002'}	-- plot 25
G[500206]={88003,'976:51.43,57.39 A:88003'}	-- plot 22
G[500207]={88003,'976:58,27 A:88003'}	-- plot 25
G[500208]={88004,'976:51.43,57.39 A:88004'}	-- plot 22
G[500209]={88004,'976:58,27 A:88004'}	-- plot 25
G[500210]={54961,'976:51.43,57.39 A:88005'}	-- plot 22
G[500211]={54961,'976:58,27 A:88005'}	-- plot 25
G[500212]={88006,'976:51.43,57.39 A:88006'}	-- plot 22
G[500213]={88006,'976:58,27 A:88006'}	-- plot 25
G[500214]={88009,'976:51.43,57.39 A:88009'}	-- plot 22
G[500215]={88009,'976:58,27 A:88009'}	-- plot 25
G[500216]={91242,'947:27.52,11.26 A:91242'}
G[500217]={84857,'971:51.19,63.58 A:84857'}	-- plot 20
G[500218]={77363,'971:51.19,63.58 A:77363'}	-- plot 20
G[500219]={77791,'971:51.19,63.58 A:77791'}	-- plot 20
G[500220]={81152,'971:31.01,31.07 A:81152'}	-- garrison level 3 location
G[500221]={77359,'971:51.19,63.58 A:77359'}	-- plot 20
G[500222]={77792,'971:51.19,63.58 A:77792'}	-- plot 20
G[500223]={77382,'971:51.19,63.58 A:77382'}	-- plot 20
G[500224]={77778,'971:51.19,63.58 A:77778'}	-- plot 20
G[500225]={78558,'947:75.07,57.89 A:92213'}
G[500226]={47006,'764[7]:48.89,82.50 A:47006'}
G[500227]={47006,'764[4]:60.41,41.03 A:47006'}
G[500228]={47006,'764[6]:58.69,53.52 A:47006'}
G[500229]={3391,'941:37.65,50.29 A:78466'}	-- garrison level 3 position
G[500230]={91242,'941:41.46,69.89 A:91242'}
G[500231]={79813,'976:52.59,40.81 A:79813'}	-- plot 20 location
G[500232]={79814,'976:52.59,40.81 A:79814'}	-- plot 20 location
G[500233]={79867,'976:52.59,40.81 A:79867'}	-- plot 20 location
G[500234]={79817,'976:52.59,40.81 A:79817'}	-- plot 20 location
G[500235]={79821,'976:52.59,40.81 A:79821'}	-- plot 20 location
G[500236]={79820,'976:52.59,40.81 A:79820'}	-- plot 20 location
G[500237]={79826,'976:52.59,40.81 A:79826'}	-- plot 20 location
G[500238]={86696,'976:52.59,40.81 A:86696'}	-- plot 20 location
G[500239]={79829,'976:52.59,40.81 A:79829'}	-- plot 20 location
G[500240]={79831,'976:52.59,40.81 A:79831'}	-- plot 20 location
G[500241]={79832,'976:52.59,40.81 A:79832'}	-- plot 20 location
G[500242]={79830,'976:52.59,40.81 A:79830'}	-- plot 20 location
G[500243]={79834,'976:52.59,40.81 A:79834'}	-- plot 20 location
G[500244]={79833,'976:52.59,40.81 A:79833'}	-- plot 20 location
G[500245]={79864,'976:52.59,40.81 A:79864'}	-- plot 20 location
G[500246]={79863,'976:52.59,40.81 A:79863'}	-- plot 20 location
G[500247]={1234243,'976:43.92,48.57 A:1234243'}	-- garrison level 3 position
G[500248]={74651,'941:74.02,29.68 A:72230'}
G[500249]={74272,'941:73.93,29.61 A:74253'}
G[500250]={3391,'976:37.61,50.28 A:78466'}	-- garrison level 3 Horde
G[500251]={79857,'976:52.59,40.81 A:79857'}	-- plot 20 location
G[500252]={77378,'971:51.19,63.58 A:77378'}	-- plot 20
G[500253]={88545,'971:51.19,63.58 A:88545'}	-- plot 20
G[500254]={88546,'976:52.59,40.81 A:88546'}	-- plot 20
G[500255]={88145,'971:51.19,63.58 A:88145'}	-- plot 20
G[500256]={88392,'976:52.59,40.81 A:88392'}	-- plot 20
G[500257]={1234474,'949:51.85,50.03 A:1234474'}	-- Lumber Mill-based location
G[500258]={103025,'1052[1]:56.20,54.14'}
G[500259]={108328,'1015:53.33,45.41 A:108328'}
G[500260]={18417,'1054:49.40,54.86'}
G[500261]={91223,'1018[14]:62.94,48.95 A:91223'}
G[500262]={7999,'1018:63.20,42.22 A:104728'}
G[500263]={98102,'1014[11]:68.03,62.99 A:98102'}
G[500264]={98102,'1014[10]:49.49,41.19 A:98102'}
G[500265]={98102,'1014[11]:67.64,62.13 A:98102'}
G[500382]={382,'36:29.73,44.51 A:382'}
G[501759]={101759,'321[1]:52,41 A:101759'}
G[502079]={2079,'41:58.13,38.94 A:2079'}
G[502080]={2080,'41:43.93,44.19 A:2080'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[502081]={70358,'928:53.93,49.77 A:67985'}	-- phase 2 location at Beast Pens
G[502487]={2487,'673:41.53,72.93 A:2487'}
G[503515]={3515,'41:41.05,45.56 A:3515','Wanders a bit around here'}
G[504508]={4508,'761[1]:65.29,81.51 A:4508'}
G[509271]={9271,'201:43.9,7.3 A:9271'}
G[514305]={14305,'HC 381:43.16,78.05 A:14305'}
G[514444]={14444,'HC 181:25.79,50.47 A:14444'}
G[514625]={14625,'28:50.01,39.05 A:14625'}
G[514626]={14626,'28:42.24,34.51 A:14626'}
G[515732]={15732,'20:61.02,59.36 161:52.57,28.06 321[1]:50.20,61.82 462:56.46,51.80 504[1]:49.33,44.85 673:40.28,67.64 A:15732'}
G[515892]={15892,'HL 301:61.74,75.71 A:15892'}
G[516116]={16116,'23:76.09,75.35 A:16116'}
G[518927]={18927,'301:66.95,72.50 A:18927'}
G[519169]={19169,'480:90.23,57.58 A:19169'}
G[519171]={19171,'471:60.14,48.91 A:19171'}
G[519175]={19175,'321[1]:69.87,49.50 A:19175'}
G[519176]={19176,'362:40.91,56.15 A:19176'}
G[519177]={19177,'321[1]:39.56,78.21 A:19177'}
G[519178]={19178,'382:67.69,39.24 A:19178'}
G[520102]={20102,'11:68.21,71.38 A:20102'}
G[522818]={22818,'HC 478:39.73,64.56 A:22818'}
G[526221]={26221,'HM 321[1]:47.24,37.87 362:21.21,24.06 382:66.89,13.51 480:68.68,42.91 481:60.67,30.63 A:26221'} -- Horde version since Blizzard really is doing some odd things
G[526935]={26935,'490:64.94,43.42 A:26935'}
G[528401]={28401,'496:60.22,57.70 A:28401'}
G[528518]={28518,'Near496 A:28518'}
G[532959]={32959,'42:50.13,19.46 A:32959'}
G[532971]={32971,'42:50.68,19.73 A:32971'}
G[532972]={32972,'42:50.80,18.71 A:32972'}
G[533178]={33178,'42:72.37,18.81 A:33178'}
G[533532]={33532,'HC 488:46.85,59.37 A:33532'}
G[533533]={33533,'HC 486:43.75,14.13 A:33533'}
G[534668]={34668,'605:59.67,77.05 A:34668'}
G[534872]={34872,'605:60.14,74.61 A:34872'}
G[534874]={34874,'605:60.00,78.19 A:34874'}
G[535120]={35120,'605:29.66,71.91 A:35120'}
G[535222]={35222,'605:20.87,13.69 A:35222'}
G[535867]={35867,'181:66.55,20.35 A:35867'}
G[536163]={36163,'101:73.34,41.64 A:36163'}
G[536210]={36210,'181:53.26,49.96 A:36210'}
G[536471]={34872,'544:51.85,47.20 A:36471'}
G[536749]={36749,'181:60.64,50.59 A:36749'}
G[537570]={37570,'607:48.20,38.65 A:37570'}
G[537675]={37675,'HA 321[1]:53.03,77.14 480:64.54,67.31 362:43.61,53.00 382:65.89,38.71 A:37675'}
G[538120]={36379,'544:68.94,46.45 A:38120'}
G[538124]={36077,'544:51.72,47.39 A:38124'}
G[538242]={38242,'891:50.72,52.09 A:38242'}
G[538243]={38243,'891:57.66,52.64 4:67.53,84.17>891 A:38243'}
G[538387]={34668,'544:37.35,41.91 A:38387'}
G[538647]={38647,'544:54.00,16.98 A:38647'}
G[538738]={37106,'544:54.44,16.92 A:38738'}
G[538935]={4949,'544:42.15,17.38 A:38935'}
G[539433]={39433,'606:28.22,29.76 A:39433'}
G[539627]={39627,'606:29.64,29.27 A:39627'}
G[539858]={5769,'606:19.54,37.82 A:39858'}
G[539877]={39877,'615:53.28,33.09 A:39877'}
G[539881]={39881,'615:40.59,75.04 A:39881'}
G[539908]={28070,'759[1]:56.17,3.73 A:39908'}
G[540639]={40639,'615:32.91,69.24 A:40639'}
G[540642]={39887,'615:33.23,68.35 A:40642'}
G[540643]={40643,'615:33.00,67.55 615:33.00,67.70 615:32.99,67.89 A:40643'}
G[540645]={40645,'615:56.59,80.25 A:40645','At surface'}
G[540772]={40619,'606:72.08,74.02 A:40772'}
G[541006]={41006,'606:32.78,70.75 A:41006'}
G[541600]={36915,'614:55.71,72.98 A:41600'}
G[542039]={42039,'81:45.62,34.23 A:42039'}
G[542076]={40640,'615:46.39,79.05 A:42076'}
G[542077]={40640,'615:33.13,75.87 A:42077'}
G[542466]={42466,'640:33.11,24.11 A:42466'}
G[542790]={42790,'37:38.47,48.62 A:42790'}
G[543733]={43221,'36:77.20,65.91 A:43733'}
G[543885]={43885,'Near37 A:43885'}
G[544293]={1747,'301:80.27,62.12 A:44293','Up on third floor'}
G[544365]={10181,'21:44.89,41.65 A:44365'}
G[544402]={44402,'761[1]:23.40,31.57 A:44402'}
G[544415]={44415,'761[1]:23.78,30.70 A:44415'}
G[544453]={26170,'22:39.91,69.47 A:44453'}
G[544467]={44467,'22:40.03,69.23 A:44467'}
G[544640]={44640,'21:44.82,40.92 A:44640'}
G[544806]={44806,'301:26.13,47.29 A:44806'}
G[544916]={44916,'21:45.81,41.94 A:44916'}
G[544917]={44917,'21:45.76,41.91 A:44917'}
G[545165]={45165,'22:53.84,64.68 A:45165'}
G[545172]={45172,'700:79.22,78.29 A:45172'}
G[545200]={16115,'765[1]:21.59,80.75 23:27.07,15.77>765 A:45200'}
G[545201]={45201,'765[1]:24.15,76.31 23:27.07,15.77>765 A:45201'}	-- this location is valid after 35563 is completed
G[545206]={16112,'765[2]:43.87,14.12 23:43.45,19.36>765 A:45206'}
G[545277]={45277,'Near61 A:45277'}
G[545278]={45278,'Near61 A:45278'}
G[545312]={44789,'684:72.96,30.11 A:45312'}
G[545323]={45323,'765[1]:21.66,79.72 23:27.07,15.77>765 A:45323'}
G[545328]={45323,'765[2]:49.73,22.34 23:43.45,19.36>765 A:45328'}
G[545329]={16115,'765[2]:44.82,20.47 23:43.45,19.36>765 A:45329'}
G[545330]={16116,'765[2]:42.45,12.70 23:43.45,19.36>765 A:45330'}
G[545331]={45201,'765[2]:49.82,18.49 23:43.45,19.36>765 A:45331'}
G[545400]={45400,'23:35.01,69.28 A:45400'}	-- the first stop...still only has three original quests
G[545417]={45417,'23:34.85,69.14 A:45417'}
G[545429]={45429,'23:35.26,68.86 A:45429'}
G[545451]={45451,'23:50.49,20.22 A:45451'}
G[545474]={44789,'684:79.66,75.66 A:45474'}
G[545574]={45574,'23:60.61,43.33 A:45574'}
G[545729]={45429,'23:61.57,43.22 A:45729'}
G[545730]={45428,'23:73.75,52.17 A:45730'}
G[546409]={46409,'690[1]:22.07,27.20 A:46409'}
G[546612]={42308,'756[2]:59.05,36.56 756[2]:60.31,38.84 A:46612'}
G[546654]={46654,'17:21.17,57.77 A:46654'}
G[546664]={46664,'17:17.98,30.55 A:46664'}
G[546804]={46804,'700:60.18,57.83 A:46804'}
G[547006]={47006,'764[1]:63.09,71.36 764[1]:59.36,61.16 A:47006'}
G[547293]={44789,'764[1]:63.09,71.36 A:47293'}
G[547393]={47393,'28:40.81,51.67 A:47393'}
G[547429]={47269,'28:38.97,26.02 A:47429'}
G[547900]={47900,'24:36.64,61.20 A:47900'}
G[548020]={47900,'24:36.56,58.07 A:48020'}
G[548021]={47869,'24:38.16,56.41 A:48021'}
G[548218]={48218,'24:50.03,74.34 A:48218'}
G[548306]={43184,'29:73.49,67.19 A:48306'}
G[549020]={44806,'700:78.92,76.65 A:49020'}
G[549476]={49444,'753[2]:68.84,55.96 A:49476'}
G[549480]={1992,'Near41 A:49480','In cave'}
G[552234]={52234,'Near673 A:52234'}
G[552477]={40278,'795:41.57,61.32 A:52477','In Molten Flow cave'}
G[552478]={39925,'795:51.30,85.81 A:52478'}
G[552823]={52823,'795:57.73,49.51 A:52823'}
G[552838]={5769,'606:27.11,62.81 A:52838'}
G[552845]={33091,'606:27.02,62.69 A:52845'}
G[552924]={38966,'781:93.31,53.54 A:52924'}
G[552925]={52925,'781:91.77,55.19 A:52925'}
G[553073]={53073,'606:27.49,61.58 A:53073'}
G[553080]={41492,'795:45.60,86.22 A:53080'}
G[553566]={53566,'808:59.68,19.10 A:53566'}
G[553738]={35875,'640:64.05,46.09 A:53738'}
G[554616]={54616,'806:41.39,79.57 A:54616'}
G[554617]={54617,'806:46.47,96.30 A:54617'}
G[554786]={53566,'808:51.58,48.33 A:54786'}
G[554914]={54914,'806:42.74,23.17 A:54914'}
G[554943]={54943,'808:55.10,32.39 A:54943'}
G[554960]={54960,'806:58.05,80.56 A:54960'}
G[554975]={54567,'808:79.81,39.28 A:54975'}
G[555020]={55020,'808:78.48,42.84 A:55020'}
G[555521]={55521,'806:28.10,24.70 A:55521'}
G[555595]={54567,'808:24.78,69.76 A:55595'}
G[555624]={54476,'816:29.34,39.98 A:55624'}
G[556111]={54913,'807:18.06,31.01 A:56111'}
G[556112]={56112,'857:28.85,50.57 A:56112'}
G[556114]={56112,'857:25.19,34.54 A:56114'}
G[556133]={56133,'807:68.87,43.14 A:56133'}
G[556138]={56138,'807:68.77,43.43 A:56138'}
G[556312]={56312,'807:74.41,34.52 A:56312'}
G[556339]={54870,'806:28.67,47.54 A:56339'}	-- this location is after turn in of 29824
G[556406]={55521,'806:27.23,50.78 A:56406'}	-- this move was during 29937
G[556474]={56474,'807:54.27,38.73 A:56474'}
G[556720]={56720,'807:17.85,56.25 A:56720'}
G[557298]={57298,'807:48.29,33.87 A:57298'}	-- at home
G[557402]={57402,'807:52.99,51.74 A:57402'}	-- at Halfhill
G[557864]={57864,'820[6]:51.06,43.48 A:57864'}
G[558113]={58113,'857:59.88,24.68 A:58113'}
G[558114]={58114,'857:28.70,50.88 A:58114'}
G[558422]={715,'807:19.90,75.67 A:58422'}
G[558465]={58465,'811:56.57,43.60 A:58465'}
G[558468]={58468,'811:56.51,43.39 A:58468'}
G[558471]={58471,'811:56.51,43.60 A:58471'}
G[558607]={58113,'857:28.90,50.86 A:58607'}
G[558630]={58630,'857:24.87,34.36 A:58630'}
G[558646]={58646,'807:52.25,48.79 A:58646'}
G[558647]={58647,'807:31.51,58.07 A:58647'}	-- at home
G[558705]={58705,'807:41.72,30.02 A:58705'}	-- at home
G[558707]={58707,'807:30.95,53.10 A:58707'}	-- at home
G[558708]={58708,'807:29.53,30.60 A:58708'}	-- at home
G[558709]={58709,'807:53.07,52.05 A:58709'}	-- at Halfhill
G[558745]={58745,'857:15.09,39.43 A:58745'}
G[558761]={58761,'807:52.97,51.79 A:58761'}	-- Halfhill
G[559441]={55122,'809:53.77,82.68 A:59441'}
G[559856]={56714,'807:17.91,55.75 A:59856'}
G[559905]={59905,'811:44.77,76.33 A:59905'}
G[560622]={60622,'810:76.19,72.91 A:60622'}
G[560679]={60679,'809:36.94,76.22 A:60679'}
G[560687]={60687,'810:71.02,56.55 A:60687'}
G[560795]={54961,'809:43.76,51.11 A:60795'}
G[560973]={60973,'809:75.20,88.26 A:60973'}
G[561021]={61021,'810:74.23,85.04 A:61021'}
G[561161]={61161,'810:35.40,56.65 A:61161'}
G[561482]={61482,'810[13]:56.18,20.17 A:61482'}
G[561539]={61539,'810:39.45,61.93 A:61539'}
G[561819]={60687,'809:35.32,49.56 A:61819'}
G[561820]={61016,'809:31.82,60.12 A:61820'}
G[561822]={61822,'680[1]:31.67,76.37 A:61822'}	-- at end of dungeon
G[561823]={61823,'680[1]:32.07,75.90 A:61823'}	-- at end of dungeon
G[562151]={62151,'858:28.65,42.14 A:62151'}
G[562180]={562180,'Near858 A:62180'}
G[562274]={60688,'810:54.07,77.87 A:62274'}
G[562295]={562295,'Near810 A:62295'}
G[562304]={60687,'810:49.18,71.05 A:62304'}
G[562378]={562378,'Near810 A:62378'}
G[562379]={562295,'Near810 A:62379'}
G[562666]={62666,'858:38.18,17.18 A:62666'}
G[562667]={62667,'858:38.30,17.13 A:62667'}
G[562668]={62668,'858:38.20,17.11 A:62668'}
G[562774]={62774,'858:55.06,35.47 A:62774'}
G[562779]={56133,'858:54.10,20.48 A:62779'}
G[563195]={563195,'Near810 A:63195'}
G[563196]={563196,'Near810 A:63196'}
G[563197]={563197,'Near810 A:63197'}
G[563310]={63310,'891:51.95,52.02 A:63310'}
G[563317]={63317,'858:54.77,72.11 A:63317'}
G[563349]={63349,'858:56.57,75.83 A:63349'}	-- only appears here after OCC:31190
G[563367]={63367,'873:51.91,43.74 A:63367'}
G[563535]={63535,'809:61.20,82.22 A:63535'}
G[563542]={63542,'809:54.70,84.22 A:63542'}
G[563622]={563622,'Near810 A:63622'}
G[563623]={563623,'Near810 A:63623'}
G[563624]={563624,'Near810 A:63624'}
G[563751]={63751,'809:63.67,86.65'}
G[563754]={63754,'809:61.25,82.29 A:63754'}
G[564259]={64259,'858:53.64,76.05 A:64259'}
G[564432]={63266,'885[3]:38.68,81.40 811:80.82,32.72>885 A:64432'}
G[564467]={62112,'875[1]:52.30,60.57 811:15.84,74.39>875 A:64467'}
G[564521]={64521,'809:72.03,94.25 A:64521'}	-- Location for quest 31393 when I checked last
G[564562]={64562,'Near898 A:64562'}	-- skull location floating through dungeon
G[564563]={64562,'Near898 A:64563'}	-- skull location floating through dungeon
G[564738]={64764,'871[1]:31.91,84.42 A:64738'}
G[564764]={64764,'871[1]:31.92,84.41 A:64764'}
G[565558]={565558,'Near808'}
G[566292]={66292,'806:48.05,88.39 A:66292'}
G[567660]={30116,'928:46.86,66.91 A:67660'}	-- phase 2 location
G[567662]={67662,'928:28.40,53.36 A:67662'}	-- phase 1 location on ship.  phase 2 is NPC 67662
G[567663]={36670,'928:28.60,52.46 A:67663'}	-- phase 1 location on ship.  phase 2 is NPC 67663
G[567673]={34771,'928:28.42,52.44 A:67673'}	-- phase 1 location on ship.  phase 2 is NPC 67673
G[567734]={67734,'809:32.90,26.27 A:67734'}
G[567984]={33538,'928:36.76,64.90 A:67984'}	-- phase 2 location	[TODO: Deal with the location 928:32.52,35.68 which is at camp when not in the field]
G[567985]={70358,'928:53.93,49.77 A:67985'}	-- phase 2 location at Conqueror's Terrace	; Beast Pens NPC is 502081
G[567986]={33542,'928:47.2,40.6 A:67986'}	-- Beast Pens
G[567990]={16802,'928:28.36,52.43 A:67990'}	-- phase 1 location on ship.  phase 2 is NPC 67990
G[567992]={4968,'862:19.34,18.86 A:67992'}
G[567993]={30115,'928:63.25,72.13 A:67993'}	-- Phase 2 location.  Phase 1 is NPC 67993.
G[567995]={67995,'928:62.70,73.56 A:67995'}	-- Phase 2 location.  Phase 1 is NPC 67995.
G[567996]={67996,'928:55.74,74.40'}	-- Phase 2 location.  Phase 1 is NPC 67996.
G[567997]={34880,'928:40.19,59.56'}	-- Phase 2 location.  Phase 1 is NPC 67997.
G[567998]={67998,'928:61.88,51.99 A:67998'}	-- Conqueror's Terrace location
G[567999]={67999,'928:61.89,52.09 A:67999'}	-- Conqueror's Terrace location
G[568004]={1747,'857:88.98,31.71 A:68004'}
G[568025]={4949,'891:38.39,46.47 A:68025'}
G[568072]={68072,'Near857 A:68072'}
G[568399]={68399,'Near857 A:68399'}
G[568651]={4968,'41:39.98,50.48 A:68651'}
G[569418]={69418,'928:36.64,64.68 A:69418'}	-- phase 2 location [TODO: Deal with the location 928:32.53,35.74 which is the location at camp when not in the field]
G[569433]={69433,'928:46.92,66.90 A:69433'}	-- phase 2 location
G[569668]={69668,'928:40.15,59.30'}	-- Phase 2 location.  Phase 1 is NPC 69668.
G[569670]={69670,'928:64.83,73.11'}	-- Phase 5 location.
G[569673]={69673,'928:42.16,66.45'}	-- Phase 2 location.  Phase 1 is NPC 69673.
G[569674]={69674,'928:42.30,66.32'}	-- Phase 2 location.  Phase 1 is NPC 69674
G[569675]={58735,'928:55.89,74.41'}	-- Phase 2 location.  Phase 1 NPC is 69675.
G[569677]={69677,'928:55.55,74.44'}	-- Phase 2 location.  Phase 1 is NPC 69677.
G[569678]={19644,'928:55.61,74.52'}	-- Phase 2 location.  Phase 1 is NPC 69678.
G[570297]={61021,'928:32.89,32.68 A:70297'}	-- Horde version of Taoshi
G[570517]={20735,'928:42.21,66.33 A:70517'}	-- Phase 2 position.  Phase 1 is NPC 70517.
G[570860]={70860,'941:20.75,57.97 A:70860'}
G[570941]={79917,'941[8]:49.72,51.91 A:70941'}
G[570980]={70980,'809:43.76,51.12 A:70980'}
G[571333]={71333,'4:49.80,40.10 A:71333'}
G[572230]={74651,'941:57.41,41.47 A:72230'}
G[572274]={72274,'941:47.57,45.57 A:72274'}
G[573395]={78994,'947:52.23,46.15 A:73395'}
G[573480]={77417,'941:19.88,14.62 A:73480'}
G[574009]={44375,'688[2]:87.74,86.41 43:16.52,11.03>688 A:74009'}
G[574043]={17468,'947:49.30,37.40 A:74043'}
G[574163]={70860,'976:50.14,37.92 A:74163'}
G[574253]={74272,'941:57.38,41.42 A:74253'}
G[574594]={70860,'949:41.49,74.08 A:74594'}
G[574606]={74606,'949:46.58,71.53 A:74606'}
G[574611]={74611,'949:41.48,74.14 A:74611'}
G[574635]={74635,'941:24.44,29.04 A:74635'}
G[575136]={78568,'949:53.43,60.33 A:75136'}
G[575146]={79576,'949:53.48,60.43 A:75146'}
G[575177]={70860,'941[2]:50.40,32.67 A:75177'}
G[575256]={78519,'946:60.92,72.45 A:75256'}
G[575606]={33260,'688[2]:87.74,86.41 43:16.52,11.03>688 A:75606'}
G[575803]={78554,'946:63.04,25.89 A:75803'}
G[575804]={78994,'946:63.06,25.83 A:75804'}
G[575808]={74651,'946:62.01,10.99 A:75808'}
G[575874]={78568,'946:63.08,26.11 A:75874'}
G[575884]={75884,'947:45.84,25.58 A:75884'}
G[576411]={74272,'941:40.77,67.09 A:76411'}
G[577160]={14627,'949:69.63,26.10 A:77160'}
G[577161]={78568,'941:88.40,49.48 A:77161'}
G[577184]={78558,'947:29.21,25.73 A:77184'}
G[577209]={79243,'971:31.68,31.17 A:77209'}	-- garrison level 2 location
G[577210]={77210,'941:82.61,69.75 A:77210'}
G[577282]={17468,'947:35.72,36.89 A:77282'}
G[577354]={77354,'971:50.03,57.75 A:77354'}	-- plot 19
G[577356]={77356,'971:50.03,57.75 A:77356'}	-- plot 19
G[577359]={77359,'971:50.03,57.75 A:77359'}	-- plot 19
G[577363]={77363,'971:50.03,57.75 A:77363'}	-- plot 19
G[577365]={77365,'971:50.03,57.75 A:77365'}	-- plot 19
G[577367]={77367,'971:45.25,42.49 A:77367'}	-- plot 23
G[577372]={77372,'971:50.03,57.75 A:77372'}	-- plot 19
G[577377]={77377,'971:45.25,42.49 A:77377'}	-- plot 23
G[577378]={77378,'971:50.03,57.75 A:77378'}	-- plot 19
G[577382]={77382,'971:50.03,57.75 A:77382'}	-- plot 19
G[577383]={77383,'971:50.03,57.75 A:77383'}	-- location is top of stairs for plot 19
G[577737]={77737,'946[13]:68.38,19.34 A:77737'}
G[577775]={77775,'971:50.03,57.75 A:77775'}	-- plot 19
G[577777]={77777,'971:50.03,57.75 A:77777'}	-- plot 19
G[577778]={77778,'971:50.03,57.75 A:77778'}	-- plot 19
G[577781]={77781,'971:50.03,57.75 A:77781'}	-- plot 19
G[577791]={77791,'971:50.03,57.75 A:77791'}	-- plot 19
G[577792]={77792,'971:50.03,57.75 A:77792'}	-- plot 19
G[577831]={77831,'971:50.03,57.75 A:77831'}	-- plot 19
G[577928]={3391,'941:50.04,56.20 A:77928'}
G[578028]={77737,'946:60.90,72.54 A:78028'}
G[578207]={78207,'971:50.03,57.75 A:78207'}	-- location is top of stairs for plot 19
G[578323]={3391,'941:88.40,49.55 A:78323'}
G[578466]={3391,'941:48.72,68.93 A:78466'}	-- pre-garrison position
G[578487]={26859,'976:45.95,42.71 A:78487'}	-- Garrison Level 3 position
G[578553]={4949,'970:71.92,62.06 A:78553'}
G[578554]={78554,'970[1]:80.72,45.23 A:78554'}
G[578559]={78558,'970:71.54,62.37 A:78559'}
G[578560]={78558,'970:73.02,38.09 A:78560'}
G[578563]={78558,'970:43.14,28.74 A:78563'}
G[578564]={78564,'971:38.47,31.46 A:78564 H:100122422,100122423,100122401,100122399,100122406,100122404,100122417,100122415,100122414,100122410,100122409,100122407'}	-- garrison level 3 location
G[578994]={78994,'970[1]:50.59,48.31 A:78994'}
G[578996]={74272,'970:73.18,38.94 A:78996'}
G[579043]={17468,'947:35.27,49.14 A:79043'}
G[579519]={79519,'948:45.39,18.26 A:79519'}
G[579537]={79537,'970[1]:50.25,48.25 A:79537'}
G[579573]={79573,'946:71.59,29.90 A:79573'}
G[579740]={79740,'976:39.31,55.42 A:79740'}	-- Garrison Level 3 position
G[579748]={79748,'948:40.18,60.26 A:79748'}
G[579813]={79813,'976:48.38,33.59 A:79813'}	-- plot 19 location
G[579814]={79814,'976:48.38,33.59 A:79814'}	-- plot 19 location
G[579815]={79815,'976:58.88,49.06 A:79815'}	-- plot 23 location
G[579817]={79817,'976:48.38,33.59 A:79817'}	-- plot 19 location
G[579820]={79820,'976:48.38,33.59 A:79820'}	-- plot 19 location
G[579821]={79821,'976:48.38,33.59 A:79821'}	-- plot 19 location
G[579826]={79826,'976:48.38,33.59 A:79826'}	-- plot 19 location
G[579829]={79829,'976:48.38,33.59 A:79829'}	-- plot 19 location
G[579830]={79830,'976:48.38,33.59 A:79830'}	-- plot 19 location
G[579831]={79831,'976:48.38,33.59 A:79831'}	-- plot 19 location
G[579832]={79832,'976:48.38,33.59 A:79832'}	-- plot 19 location
G[579833]={79833,'976:48.38,33.59 A:79833'}	-- plot 19 location
G[579834]={79834,'976:48.38,33.59 A:79834'}	-- plot 19 location
G[579857]={79857,'976:48.38,33.59 A:79857'}	-- plot 19 location
G[579862]={79862,'976:48.38,33.59 A:79862'}	-- plot 19 location
G[579863]={79863,'976:48.38,33.59 A:79863'}	-- plot 19 location
G[579864]={79864,'976:48.38,33.59 A:79864'}	-- plot 19 location
G[579867]={79867,'976:48.38,33.59 A:79867'}	-- plot 19 location
G[579953]={79953,'971:31.17,32.85 A:79953'}	-- garrison level 2 location
G[580073]={79537,'947:62.45,26.28 A:80073'}
G[580078]={72413,'947:61.92,29.61 A:80078'}
G[580079]={80079,'947:62.48,26.22 A:80079'}
G[580153]={75288,'948:45.93,45.77 A:80153'}
G[580159]={80159,'971:48.96,41.09 A:80159'}	-- garrison level 1 location
G[580163]={80163,'971:37.94,63.85 A:80163'}	-- garrison level 2 location
G[580193]={79393,'Near946 A:80193'}
G[580648]={80648,'948:66.84,51.70 A:80648'}
G[580758]={80758,'948:46.72,46.38 A:80758'}
G[581152]={81152,'971:46.52,54.30 A:81152'}
G[581530]={81530,'947:50.57,82.29 A:81530'}
G[581770]={79519,'948:45.87,45.73 A:81770'}
G[581790]={18261,'950:64.24,59.55 A:81790'}
G[582574]={85147,'949:60.71,64.77 A:82574'}
G[582610]={82610,'949:44.90,63.95 A:82610'}
G[583606]={83606,'950:63.49,60.70 A:83606'}
G[583823]={78558,'946:84.81,31.43 A:83823'}
G[583858]={83858,'976:48.19,47.01 A:83858'}
G[584248]={84248,'971:35.53,49.36 A:84248'}	-- plot 22
G[584524]={84524,'971:51.21,47.04 A:84524'}	-- plot 25
G[584702]={78558,'950:92.34,31.43 A:84702'}
G[584857]={84857,'971:50.03,57.75 A:84857'}	-- plot 19
G[584947]={84947,'971:51.21,47.04 A:84947'}	-- plot 25 location
G[585048]={85048,'976:57.75,28.14 A:85048'}	-- plot 25 location
G[585413]={45109,'971:35.53,49.36 A:85413'}	-- entrance to plot 22
G[585414]={45110,'976:51.43,57.39 A:85414'}	-- plot 22 location
G[585431]={85436,'949:52.04,49.49 A:85431'}	-- Lumber Mill-based location
G[585777]={77031,'971:53.48,69.35 A:85777'}	-- garrison level 1 position
G[585984]={12919,'976:38,72 A:85984'}
G[586475]={80758,'948:66.75,51.58 A:86475'}
G[586629]={86629,'976:57.75,28.14 A:86629'}	-- plot 25 location
G[586696]={86696,'976:48.38,33.59 A:86696'}	-- plot 19 location
G[586946]={23066,'Near A:86946'}
G[586973]={46804,'971:40.09,56.58 A:86973'}	-- plot 24 location
G[586974]={86974,'971:40.09,56.58 A:86974'}	-- plot 24 location
G[586979]={27221,'976:60.36,36.51 A:86979'}	-- plot 24 location
G[587121]={87121,'976:57.75,28.14 A:87121'}	-- plot 25 location
G[587217]={87215,'971:51.21,47.04 A:87217'}	-- plot 25 location
G[587242]={26584,'976:60.36,36.51 A:87242'}	-- plot 24 location
G[587305]={87305,'976:57.75,28.14 A:87305'}	-- plot 25 location
G[587991]={87991,'971:51.21,47.04 A:87991'}	-- plot 25
G[587992]={46854,'971:51.21,47.04 A:87992'}	-- plot 25
G[587994]={87994,'971:51.21,47.04 A:87994'}	-- plot 25
G[587995]={2487,'971:51.21,47.04 A:87995'}	-- plot 25
G[587996]={64842,'971:51.21,47.04 A:87996'}	-- plot 25
G[587997]={11036,'971:51.21,47.04 A:87997'}	-- plot 25
G[587998]={58113,'971:51.21,47.04 A:87998'}	-- plot 25
G[587999]={40997,'971:51.21,47.04 A:87999'}	-- plot 25
G[588000]={49444,'971:51.21,47.04 A:88000'}	-- plot 25
G[588001]={38237,'971:51.21,47.04 A:88001'}	-- plot 25
G[588002]={28444,'971:51.21,47.04 A:88002'}	-- plot 25
G[588003]={88003,'971:51.21,47.04 A:88003'}	-- plot 25
G[588004]={88004,'971:51.21,47.04 A:88004'}	-- plot 25
G[588005]={54961,'971:51.21,47.04 A:88005'}	-- plot 25
G[588006]={88006,'971:51.21,47.04 A:88006'}	-- plot 25
G[588007]={88007,'971:51.21,47.04 A:88007'}	-- plot 25
G[588009]={88009,'971:51.21,47.04 A:88009'}	-- plot 25
G[588013]={47269,'971:51.21,47.04 A:88013'} -- plot 25
G[588017]={46338,'971:51.21,47.04 A:88017'} -- plot 25
G[588022]={47869,'971:51.21,47.04 A:88022'} -- plot 25
G[588023]={61021,'971:51.21,47.04 A:88023'} -- plot 25
G[588024]={9177,'971:51.21,47.04 A:88024'} -- plot 25
G[588025]={39930,'971:51.21,47.04 A:88025'}	-- plot 25
G[588026]={43184,'971:51.21,47.04 A:88026'}	-- plot 25
G[588027]={47366,'971:51.21,47.04 A:88027'} -- plot 25
G[588145]={88145,'971:50.03,57.75 A:88145'}	-- plot 19
G[588392]={88392,'976:48.38,33.59 A:88392'}	-- plot 19
G[588545]={88545,'971:50.03,57.75 A:88545'}	-- plot 19
G[588546]={88546,'976:48.38,33.59 A:88546'}	-- plot 19
G[588892]={88892,'976:54.66,14.42 A:88892'}
G[589023]={89023,'1015:46.96,41.22 A:89023'}
G[589793]={26814,'976:40.18,56.62 A:89793'}	-- Horde location
G[590238]={90238,'945:62.57,50.89 A:90238'}
G[590749]={66292,'1017:33.81,46.03 A:90749'}
G[591166]={91165,'1015:61.30,50.79 A:91166'}
G[591223]={91223,'1018[14]:62.94,48.95 A:91223'}
G[591242]={91242,'949:50.61,16.69 A:91242'}
G[591750]={75121,'946[30]:53.57,69.07 A:91750'}
G[591751]={90177,'946[30]:56.75,66.65 A:91751'}
G[591913]={90177,'947:75.13,57.79 A:91913'}
G[591923]={80079,'962:62.45,54.23 A:91923'}
G[592213]={78558,'941:40.8,73.2 A:92213'}
G[592718]={92718,'1032[1]:49.45,49.82 A:92718'}
G[592842]={40619,'1018:43.82,50.29 A:92842'}
G[592850]={40619,'1018[3]:43.24,80.95 A:92850'}	-- i think outer map location is 1018:40.58,44.28
G[592986]={18417,'1032[1]:48.68,49.31 A:92986'}
G[593805]={93805,'1024:38.62,68.42 A:93805'}
G[593822]={93822,'947:28.20,11.69 A:93822'}
G[594429]={91242,'941:40.71,70.25 A:94429'}
G[594789]={94789,'941:42.10,71.04 A:94789'}	-- location after accepting 39243
G[594870]={94870,'976:41.46,47.18 A:94870'}
G[594902]={93011,'1014[10]:65.64,67.30 A:94902'}
G[595237]={18417,'1052[1]:58.58,57.88 A:95237'}
G[595240]={93011,'1052[1]:58.62,57.78 A:95240'}
G[595424]={95424,'945:60.42,46.73 A:95424'}
G[596362]={96362,'976:47.35,38.45 A:96362'}
G[596644]={66292,'301:18.92,42.75 A:96644'}
G[596665]={93011,'1032[1]:50.80,72.79 A:96665'}
G[596683]={96683,'1014[10]:29.12,46.89 A:96683'}
G[596686]={10181,'4:61.48,8.77 A:96686'}
G[596705]={96705,'976:47.11,37.54 A:96705'}
G[597296]={78558,'321[1]:52.53,88.16 A:97296'}
G[597553]={97553,'1024[5]:47.35,44.68 A:97553'}
G[598102]={98102,'1014[10]:51.70,70.46 A:98102'}
G[598632]={109295,'1052[1]:59.93,48.92 A:98632'}
G[600000]={600000,'951:36.69,34.07'}
G[600001]={600000,'951:25.48,27.18 N:600000'}
G[600002]={600000,'951:27.35,39.07 N:600000'}
G[600003]={600000,'951:30.60,36.51 N:600000'}
G[600004]={600000,'951:22.39,35.41 N:600000'}
G[600005]={600000,'951:22.15,49.27 N:600000'}
G[600006]={600000,'951:24.80,53.04 N:600000'}
G[600007]={600000,'951:25.68,45.84 N:600000'}
G[600008]={600000,'951:22.26,68.07 N:600000'}
G[600009]={600000,'951:26.85,68.75 N:600000'}
G[600010]={600000,'951:30.99,76.30 N:600000'}
G[600011]={600000,'951:35.34,76.44 N:600000'}
G[600012]={600000,'951:38.74,71.62 N:600000'}
G[600013]={600000,'951:39.81,79.50 N:600000'}
G[600014]={600000,'951:34.84,84.20 N:600000'}
G[600015]={600000,'951:43.560,84.040 N:600000'}
G[600016]={600000,'951:46.99,53.73 N:600000'}
G[600017]={600000,'951:46.70,46.74 N:600000'}
G[600018]={600000,'951:51.16,45.69 N:600000'}
G[600019]={600000,'951:55.55,44.33 N:600000'}
G[600020]={600000,'951:58.02,50.68 N:600000'}
G[600021]={600000,'951:65.61,47.87 N:600000'}
G[600022]={600000,'951:63.80,59.15 N:600000'}
G[600023]={600000,'951:64.90,75.57 N:600000'}
G[600024]={600000,'951:60.16,66.05 N:600000'}
G[600025]={600000,'951:49.72,65.73 N:600000'}
G[600026]={600000,'951:53.10,70.82 N:600000'}
G[600027]={600000,'951:52.66,62.75 N:600000'}
G[600028]={600000,'951:44.13,65.42 N:600000'}
G[600029]={600000,'951:26.02,61.44 N:600000'}
G[600030]={600000,'951:24.63,38.56 N:600000'}
G[600031]={600000,'951:59.93,31.33 N:600000'}
G[600032]={600000,'951:29.77,31.73 N:600000'}
G[600034]={600001,'951:28.16,35.12 N:600000'}
G[600035]={600001,'951:26.69,64.98 N:600000'}
G[600036]={600001,'951:64.55,70.32 N:600000'}
G[600037]={600001,'951:59.25,49.48 N:600000'}
G[600038]={600002,'951:69.46,33.09 N:600000'}
G[600039]={600002,'951:54.02,78.20 N:600000'}
G[600040]={600000,'951:47,26 N:600000'}
G[600041]={600000,'951:61.69,88.53 N:600000'}
G[700000]={700000,'23:74.29,53.24 A:90369'}
G[700001]={700001,'22:51.62,81.85 A:108776'}
G[700002]={700002,'22:52.11,83.19 A:108776'}
G[700003]={700003,'1077:45.65,50.03 A:114562'}
G[700004]={700004,'1015:49.21,16.09 A:90383'}
G[700005]={700005,'1015:49.10,16.69 A:89978'}
G[1000033]={1000033,'39:25.97,16.90'}
G[1000034]={1000034,'39:40.63,17.03'}
G[1000035]={1000035,'39:25.90,47.75'}
G[1000036]={1000036,'39:40.52,47.78'}
G[1000055]={1000055,'30:72.65,60.33'}
G[1000056]={1000056,'30:79.80,55.50'}
G[1000061]={1000061,'34:17.72,29.04'}
G[1000068]={1000068,'30:24.55,74.68'}
G[1000256]={1000256,'35:37.3,46.5'}
G[1000259]={1000259,'40:13.94,34.81'}
G[1000261]={1000261,'40:13.52,41.38'}
G[1002059]={1002059,'27:87.63,50.14'}
G[1002076]={1002076,'37:38.51,48.52'}
G[1002083]={1002083,'673:41.26,61.17'}
G[1002688]={1002688,'16:29.87,59.77'}
G[1002701]={1002701,'16:79.81,31.65','In cave'}
G[1002702]={1002702,'16:30.02,59.03'}
G[1002713]={1002713,'16:40.2,49'}
G[1002908]={1002908,'9:53.52,48.28'}
G[1003972]={1003972,'11:68.26,71.25'}
G[1004141]={1004141,'11:50.28,25.69'}
G[1006751]={1006751,'41:57.64,63.01'}
G[1006752]={1006752,'41:37.17,25.33'}
G[1007510]={1007510,'41:43.94,44.04 41:43.91,43.99 41:43.95,44.08'}	-- TODO: Determine what the locs are when turned in at original dude.  because turned it at 2nd dude only keeps them there.
G[1007923]={1007923,'41:59.84,59.86'}
G[1020985]={1020985,'141:55.44,25.92'}
G[1020992]={1020992,'141:29.63,48.59'}
G[1021042]={1021042,'141:29.84,48.24'}
G[1024776]={1024776,'21:44.2,42.6'}
G[1035251]={1035251,'101:36.1,30.4 101:36.1,30.5'}
G[1112948]={1112948,'40:14.38,24.05'}
G[1131474]={1131474,'692[2]:50.01,33.39 17:34.28,10.37>692'}
G[1138492]={1138492,'16:57.21,34.55'}
G[1142151]={1142151,'40:13.61,38.21'}
G[1142195]={1142195,'121:71.7,55.9'}
G[1142487]={1142487,'691[2]:68.60,62.21'}
G[1151286]={1151286,'181:59.5,31.2'}
G[1152097]={1152097,'760:46.1,22.2 760:46.5,22.3 760:46.5,23'}
G[1156561]={1000068,'30:24.57,78.22 N:1000068'}
G[1161521]={1161521,'201:38.44,66.07'}
G[1161526]={1161526,'201:68.54,36.54'}
G[1164869]={1164869,'704:54.1,27.2'}
G[1164955]={1164955,'201:56.50,12.53'}
G[1164956]={1164956,'201:23.57,50.03'}
G[1164957]={1164957,'201:77.18,49.99'}
G[1175084]={1142487,'691[2]:63.19,67.86 N:1142487'}
G[1175085]={1142487,'691[2]:65.73,57.83 N:1142487'}
G[1176091]={1176091,'182:59.68,8.12'}
G[1176392]={1176392,'22:62.58,58.56'}
G[1177544]={1177544,'23:32.22,83.42'}
G[1179485]={1179485,'699:26.4,57.3 699:26.4,58.3 699:26.4,58.5 699:26.5,58.5 699:26.6,57.3 699:26.6,58.3'}
G[1179517]={1179517,'699[4]:70.69,24.11'}
G[1179551]={1179551,'181:79.2,74.8'}
G[1179697]={1179697,'673:46.4,26.1 H:100018706'}
G[1179880]={1179880,'721:33.3,44.7 721:33.4,44.1 721:33.5,44.9 721:33.7,44.3'}
G[1180025]={1180025,'30:84.7,64.4'}
G[1180055]={1180055,'749:42.4,51.5 749:43.1,51.9'}
G[1180056]={1180056,'9:35.1,61.6 9:35.8,60.9'}
G[1180366]={1180366,''}
G[1180448]={1180448,'261:55.06,35.99'}
G[1180503]={1180503,'261:43.56,42.07'}
G[1180715]={1180715,'301:62.40,69.4'}
G[1180743]={1180743,'341:33.83,65.70 321[1]:49.29,78.27'}
G[1180746]={1180746,'341:33.47,65.58 321[1]:49.15,78.06'}
G[1180747]={1180747,'341:33.76,66.33 321[1]:49.55,78.11'}
G[1180748]={1180748,'341:33.85,66.64 321[1]:49.17,77.75'}
G[1180793]={1180793,'341:33.4,66 321[1]:49.53,77.81'}
G[1180918]={1180918,'462:48.17,46.29'}
G[1181011]={1181011,'462:69.24,52.10'}
G[1181147]={1000068,'463:48.3,31.6 N:1000068'}
G[1181150]={1181150,'463:79.63,17.58'}
G[1181153]={1181153,'463:72.2,31.2'}
G[1181638]={1000068,'465:28,60.3 N:1000068'}
G[1181748]={1181748,'464:50.5,11.6'}
G[1181756]={1181756,'476:61.2,41.8'}
G[1181758]={1181758,'476:61.2,49.4 476:61.2,49.6'}
G[1181889]={1000068,'476:55.2,59.1 N:1000068'}
G[1182032]={1182032,'476:37.6,61.3'}
G[1182115]={1000068,'467:79.08,64.83 N:1000068'}
G[1182165]={1000068,'467:32,49.4 467:32,49.5 N:1000068'}
G[1182392]={1182392,'477:55.7,37.9'}
G[1182393]={1182393,'477:54.68,70.74'}
G[1182549]={1182549,'478:67.9,53.4 478:67.9,53.5'}
G[1182587]={1000068,'478:57.59,54.70 N:1000068'}
G[1182588]={1000068,'478:49.8,45.2 N:1000068'}
G[1182947]={1182947,'724[1]:53.31,58.78 478:39.63,73.54>724'}
G[1183284]={1000068,'467:41.74,27.27 N:1000068'}
G[1183770]={1183770,'479:23.2,68.1'}
G[1183811]={1000068,'479:32.1,64.7 N:1000068'}
G[1183877]={1183877,''}
G[1184300]={1184300,'479:60.3,78'}
G[1184660]={1000068,'475:51.9,57.8 N:1000068'}
G[1184825]={1184825,'475:34.3,77.3 475:34.4,77.8 475:34.5,77.7 475:35.7,79.1'}
G[1184945]={1000068,'473:30.4,30.9 473:30.5,30.8 N:1000068'}
G[1184946]={1000068,'473:38.3,54 N:1000068'}
G[1185035]={1000068,'475:36.6,67.3 N:1000068'}
G[1185126]={1185126,'473:51.4,72.8 473:51.5,72.7'}
G[1185165]={1185165,'475:73.3,40.1'}
G[1185166]={1000068,'465:61.2,80.6 N:1000068'}
G[1186426]={1000068,'141:41.75,73.11 N:1000068'}
G[1186585]={1186585,'491:75.93,19.74'}
G[1186887]={1186887,'27:53.50,50.45 30:42.39,65.87 4:52.6,42.4 464:48.9,51.0 462:47.6,46.4'} -- for Alliance 20:61,52.7 is not right PS Seemed right this year
G[1187236]={1187236,'321[1]:49.39,77.61 341:33.65,65.63'}
G[1187273]={1187273,'141:29.70,47.63'}
G[1187559]={1187559,'HM 21:49.62,38.60'}
G[1187564]={1187564,'HM 39:45.1,62.48'}
G[1187565]={1187565,'486:54.63,35.88'}
G[1187851]={1187851,'486:57.56,69.13'}
G[1187905]={1187905,'486:48.55,59.03'}
G[1187914]={1187564,'HM 16:44.58,46.1 N:1187564'}
G[1187916]={1187564,'HM 43:86.77,41.51 N:1187564'}
G[1187917]={1187564,'HM 464:44.7,52.5 N:1187564'}
G[1187919]={1187564,'HM 475:41.8,65.9 N:1187564'}
G[1187920]={1187564,'HM 19:55.2,15.3 N:1187564'}
G[1187921]={1187564,'HM 476:55.8,68.7 N:1187564'}
G[1187922]={1187564,'HM 29:68.5,59.8 N:1187564'}
G[1187923]={1187564,'HM 42:48.92,22.58 N:1187564'}
G[1187924]={1187564,'HM 101:65.89,16.93 N:1187564'}
G[1187925]={1187564,'HM 27:53.8,44.7 N:1187564'}
G[1187926]={1187564,'HM 34:73.2,55.1 N:1187564'}
G[1187927]={1187564,'HM 141:62.04,40.41 N:1187564'}
G[1187928]={1187564,'HM 30:43.22,62.92 N:1187564'}
G[1187929]={1187564,'HM 121:46.66,43.72 N:1187564'}
G[1187930]={1187564,'HM 465:51.9,58.5 N:1187564'}
G[1187932]={1187564,'HM 35:32.32,40.2 N:1187564'}
G[1187933]={1187564,'HM 477:49.6,69.9 N:1187564'}
G[1187934]={1187564,'HM 36:24.6,54 N:1187564'}
G[1187935]={1187564,'HM 473:39.6,54.3 N:1187564'}
G[1187936]={1187564,'HM 41:54.7,52.7 N:1187564'}
G[1187937]={1187564,'HM 478:54.2,55.4 N:1187564'}
G[1187938]={1187564,'HM 26:14.47,49.81 N:1187564'}
G[1187939]={1187564,'HM 22:43.6,82.4 N:1187564'}
G[1187940]={1187564,'HM 40:13.2,47.4 N:1187564'}
G[1187941]={1187564,'HM 467:68.5,52.2 N:1187564'}
G[1187942]={1187564,'HM 479:31,62.8 N:1187564'}
G[1187943]={1187564,'HM 261:60.4,33.14 N:1187564'}
G[1187944]={1187564,'HM 673:51.7,67.2 N:1187564'}
G[1187945]={1187564,'HM 161:52.64,30.07 N:1187564'}
G[1187946]={1187564,'HM 281:61.38,47.17 N:1187564'}
G[1187947]={1187559,'HM 16:69.15,42.83 N:1187559'}
G[1187948]={1187559,'HM 43:51.58,66.66 N:1187559'}
G[1187949]={1187559,'HM 479:32.29,68.26 N:1187559'}
G[1187950]={1187559,'HM 261:50.86,41.80 N:1187559'}
G[1187951]={1187559,'HM 673:50.50,70.69 N:1187559'}
G[1187952]={1187559,'HM 161:49.81,28.17 N:1187559'}
G[1187953]={1187559,'HM 281:58.05,47.24 N:1187559'}
G[1187954]={1187559,'HM 17:24.05,37.08 N:1187559'}
G[1187955]={1187559,'HM 475:50.01,59.00 N:1187559'}
G[1187956]={1187559,'HM 29:51.45,29.11 N:1187559'}
G[1187957]={1187559,'HM 101:26.19,77.29 N:1187559'}
G[1187958]={1187559,'HM 4:51.98,47.19 N:1187559'}
G[1187959]={1187559,'HM 141:33.26,30.71 N:1187559'}
G[1187960]={1187559,'HM 462:46.38,50.35 N:1187559'}
G[1187961]={1187559,'HM 121:72.45,47.57 N:1187559'}
G[1187962]={1187559,'HM 463:47.12,25.97 N:1187559'}
G[1187963]={1187559,'HM 465:57.16,41.82 N:1187559'}
G[1187964]={1187559,'HM 24:54.56,49.85 N:1187559'}
G[1187965]={1187559,'HM 9:51.93,59.46 N:1187559'}
G[1187966]={1187559,'HM 477:51.07,34.02 N:1187559'}
G[1187967]={1187559,'HM 473:33.49,30.32 N:1187559'}
G[1187968]={1187559,'HM 81:52.99,62.27 N:1187559'}
G[1187969]={1187559,'HM 38:76.70,14.12 N:1187559'}
G[1187970]={1187559,'HM 478:51.94,43.18 N:1187559'}
G[1187971]={1187559,'HM 11:49.86,54.39 N:1187559'}
G[1187972]={1187559,'HM 26:76.69,74.60 N:1187559'}
G[1187974]={1187559,'HM 20:57.04,51.72 N:1187559'}
G[1187975]={1187559,'HM 467:35.57,51.75 N:1187559'}
G[1188085]={1188085,'486:56.81,55.56'}
G[1188261]={1188261,'490:64.29,19.76'}
G[1188364]={1188364,'488:47.70,80.01'}
G[1188365]={1188365,'490:36.95,32.35'}
G[1188418]={1000256,'488:37.6,46.5 488:37.7,46.4 N:1000256'}
G[1188419]={1188419,'488:36.64,64.97'}
G[1188649]={1000068,'488:77,62.8 N:1000068'}
G[1188667]={1188667,'490:31.80,59.55'}
G[1189303]={500022,'HW 30:43.73,65.90 N:500022'}
G[1189311]={1189311,'488:78.62,52.29'}
G[1189989]={1189989,'HB 27:56.01,37.05'}
G[1189990]={1189989,'HB 4:40.67,17.38 N:1189989'}
G[1190020]={1000256,'488:77.34,51.43 N:1000256'}
G[1190034]={500022,'HW 41:55.36,52.28 N:500022'}
G[1190035]={500022,'HW 43:37.01,49.26 N:500022'}
G[1190036]={500022,'HW 27:54.49,50.77 N:500022'}
G[1190037]={500022,'HW 464:48.49,49.04 N:500022'}
G[1190038]={500022,'HW 381:62.26,33.16 N:500022'}
G[1190039]={500022,'HW 341:18.32,50.98 N:500022'}
G[1190040]={500022,'HW 301:60.51,75.34 N:500022'}
G[1190041]={500022,'HW 471:59.23,18.50 N:500022'}
G[1190042]={500022,'HW 42:37,44.1 N:500022'}	-- was removed
G[1190043]={500022,'HW 35:35.54,48.50 N:500022'}
G[1190044]={500022,'HW 40:10.81,61.00 N:500022'}
G[1190045]={500022,'HW 476:55.70,59.96 N:500022'}
G[1190046]={500022,'HW 36:26.46,41.51 N:500022'}
G[1190047]={500022,'HW 39:56.81,47.32 N:500022'}
G[1190048]={500022,'HW 34:73.79,44.25 N:500022'}
G[1190050]={500022,'HW 81:40.53,17.69 N:500022'}
G[1190051]={500022,'HW 101:66.33,6.58 N:500022'}
G[1190052]={500022,'HW 141:66.59,45.28 N:500022'}	-- Theramore...now destroyed
G[1190053]={500022,'HW 121:46.33,45.19 N:500022'}
G[1190054]={500022,'HW 26:14.19,44.60 N:500022'}
G[1190055]={500022,'HW 465:54.25,63.70 N:500022'}
G[1190056]={500022,'HW 465:23.42,36.38 N:500022'}
G[1190057]={500022,'HW 467:67.16,48.94 N:500022'}
G[1190058]={500022,'HW 467:41.91,26.17 N:500022'}
G[1190059]={500022,'HW 478:56.59,53.23 N:500022'}
G[1190060]={500022,'HW 477:54.19,75.87 N:500022'}
G[1190061]={500022,'HW 475:35.83,63.73 N:500022'}
G[1190062]={500022,'HW 475:61.05,68.08 N:500022'}
G[1190063]={500022,'HW 473:37.02,58.29 N:500022'}
G[1190064]={500022,'HW 4:51.54,41.59 N:500022'}
G[1190065]={500022,'HW 9:46.79,60.41 N:500022'}
G[1190066]={500022,'HW 20:60.98,51.40 N:500022'}
G[1190067]={500022,'HW 462:48.20,47.87 N:500022'}
G[1190068]={500022,'HW 462:43.70,71.03 N:500022'}
G[1190069]={500022,'HW 321[1]:53.91,78.93 N:500022'}
G[1190070]={500022,'HW 362:45.62,64.85 N:500022'}
G[1190071]={500022,'HW 382:67.74,37.75 N:500022'}
G[1190072]={500022,'HW 480:79.43,57.65 N:500022'}
G[1190073]={500022,'HW 480:67.60,72.92 N:500022'}
G[1190074]={500022,'HW 21:46.45,42.90 N:500022'}
G[1190075]={500022,'HW 463:48.68,31.91 N:500022'}
G[1190076]={500022,'HW 11:49.51,57.91 N:500022'}
G[1190077]={500022,'HW N:500022'}	-- was removed
G[1190078]={500022,'HW 24:57.86,47.27 N:500022'}
G[1190079]={500022,'HW 43:73.96,60.60 N:500022'}
G[1190080]={500022,'HW 81:50.39,63.80 N:500022'}
G[1190081]={500022,'HW 61:46.1,51.4 61:46.1,51.5 N:500022'}	-- was removed
G[1190082]={500022,'HW 16:69.01,33.28 N:500022'}
G[1190083]={500022,'HW 101:24.08,68.29 N:500022'}
G[1190084]={500022,'HW 37:37.37,51.77 N:500022'}
G[1190085]={500022,'HW 141:36.78,32.43 N:500022'}
G[1190086]={500022,'HW 38:46.89,56.90 N:500022'}
G[1190087]={500022,'HW 17:3,46.1 N:500022'}	-- was removed
G[1190088]={500022,'HW 121:74.83,45.14 N:500022'}
G[1190089]={500022,'HW 26:78.19,81.46 N:500022'}
G[1190090]={500022,'HW 465:56.80,37.45 N:500022'}
G[1190091]={500022,'HW 465:26.90,59.47 N:500022'}
G[1190096]={500022,'HW 467:30.63,50.87 N:500022'}
G[1190097]={500022,'HW 478:48.73,45.18 N:500022'}
G[1190098]={500022,'HW 477:56.68,34.49 N:500022'}
G[1190099]={500022,'HW 475:53.43,55.54 N:500022'}
G[1190100]={500022,'HW 475:76.22,60.39 N:500022'}
G[1190101]={500022,'HW 473:30.27,27.70 N:500022'}
G[1190102]={500022,'HW 11:67.34,74.66 N:500022'}
G[1190103]={500022,'HW 673:40.91,73.72 N:500022'}
G[1190104]={500022,'HW 141:41.86,74.09 N:500022'}
G[1190105]={500022,'HW 161:52.56,27.10 N:500022'}
G[1190106]={500022,'HW 281:59.83,51.22 N:500022'}
G[1190107]={500022,'HW 261:55.47,36.79 N:500022'}
G[1190108]={500022,'HW 23:75.57,52.31 N:500022'}
G[1190109]={500022,'HW 467:78.46,62.88 N:500022'}
G[1190110]={500022,'HW 481:28.21,49.07 N:500022'}
G[1190111]={500022,'HW 481:56.31,81.93 N:500022'}
G[1190112]={500022,'HW 475:62.90,38.33 N:500022'}
G[1190113]={500022,'HW 479:32.02,64.44 N:500022'}
G[1190114]={500022,'HW 479:43.32,36.10 N:500022'}
G[1190115]={500022,'HW 473:61.00,28.17 N:500022'}
G[1190116]={500022,'HW 473:56.37,59.82 N:500022'}
G[1190535]={1190535,'496:36.71,72.77'}
G[1190602]={1190602,'496:59.52,57.20'}
G[1190657]={1190657,'496:59.42,44.33'}
G[1190768]={1190768,'493:80.41,55.81'}
G[1190777]={1190777,'493:72.14,57.53'}
G[1190917]={1190917,'502:55.2,46.2'}
G[1190936]={1190936,'502:55.8,51.1 502:56.1,52.1'}
G[1191728]={1000256,'496:32.27,75.67 N:1000256'}
G[1191760]={1191760,'495:37.43,46.84'}
G[1191761]={1191761,'495:37.6,46.8'}
G[1191766]={1191766,'496:34.94,83.90'}
G[1191878]={500022,'HW 496:59.32,57.20 N:500022'}
G[1191879]={500022,'HW 496:40.86,66.04 N:500022'}
G[1191880]={500022,'HW 490:20.89,64.76 N:500022'}
G[1191881]={500022,'HW 490:65.36,47.00 N:500022'}
G[1191882]={500022,'HW 490:31.94,60.21 N:500022'}
G[1191883]={500022,'HW 490:59.63,26.36 N:500022'}
G[1192018]={500022,'HW 493:26.61,59.20 N:500022'}
G[1192060]={1192060,'495:77.15,62.87'}
G[1192071]={1192060,'495:63.14,62.3 N:1192060'}
G[1192072]={1192072,'495:24.05,61.71'}
G[1192078]={1192078,'495:64,64.7 495:64.1,64.4'}
G[1192079]={1192079,'495:64.6,61.7 495:65,60.9 495:65.4,60.4'}
G[1192080]={1192080,'495:64.2,59.4 495:64.2,59.6 495:64.5,59.4 495:64.5,59.6'}
G[1192524]={1192524,'495:67.4,60'}
G[1192833]={1192833,'492:79.8,30.9'}
G[1193195]={1193195,'492:54,87.3'}
G[1193400]={1193400,'492:54.4,86.2'}
G[1194032]={1187564,'HM 486:55.21,20.18 N:1187564'}
G[1194033]={1187559,'HM 486:51.05,11.80 N:1187559'}
G[1194034]={1187559,'HM 493:47.30,61.49 N:1187559'}
G[1194035]={1187564,'HM 493:47.9,66.1 N:1187564'}
G[1194036]={1187564,'HM 488:75.07,43.83 N:1187564'}
G[1194037]={1187559,'HM 488:38.47,48.19 N:1187559'}
G[1194038]={1187564,'HM 491:57.7,15.7 N:1187564'}
G[1194039]={1187559,'HM 491:48.41,13.34 N:1187559'}
G[1194041]={1187564,'HM 490:34.16,60.59 N:1187564'}
G[1194042]={1187559,'HM 490:19.13,61.46 N:1187559'}
G[1194043]={1187559,'HM 495:40.38,85.59 N:1187559'}
G[1194044]={1187564,'HM 495:41.3,87 N:1187564'}
G[1194045]={1187564,'HM 510:77.60,75.23 N:1187564'}
G[1194046]={1187559,'HM 510:80.34,52.70 N:1187559'}
G[1194048]={1187559,'HM 496:43.32,71.35 N:1187559'}
G[1194049]={1187564,'HM 496:40.4,61 N:1187564'}
G[1194056]={500022,'HW 491:58.32,62.82 N:500022'}
G[1194057]={500022,'HW 491:30.83,41.43 N:500022'}
G[1194058]={500022,'HW 491:60.48,15.90 N:500022'}
G[1194059]={500022,'HW 486:58.52,67.87 N:500022'}
G[1194060]={500022,'HW 486:57.12,18.82 N:500022'}
G[1194061]={500022,'HW 488:28.95,56.22 N:500022'}
G[1194062]={500022,'HW 488:77.50,51.29 N:500022'}
G[1194063]={500022,'HW 495:28.72,74.28 N:500022'}
G[1194064]={500022,'HW 504[1]:42.35,63.14 N:500022'}
G[1194065]={500022,'HW 491:25.44,59.82 N:500022'}
G[1194066]={500022,'HW 488:60.15,53.45 N:500022'}
G[1194067]={500022,'HW 488:48.11,74.66 N:500022'}
G[1194068]={500022,'HW 486:78.45,49.16 N:500022'}
G[1194069]={500022,'HW 495:41.07,85.85 N:500022'}
G[1194070]={500022,'HW 495:30.92,37.16 N:500022'}
G[1194071]={500022,'HW 504[1]:48.15,41.30 N:500022'}
G[1194072]={500022,'HW 504[2]:38.16,59.63 N:500022'}
G[1194073]={500022,'HW 491:49.44,10.75 N:500022'}
G[1194074]={500022,'HW 491:52.10,66.15 N:500022'}
G[1194075]={500022,'HW 491:79.26,30.62 N:500022'}
G[1194076]={500022,'HW 486:76.66,37.47 N:500022'}
G[1194077]={500022,'HW 486:41.71,54.40 N:500022'}
G[1194078]={500022,'HW 488:37.83,46.47 N:500022'}
G[1194079]={500022,'HW 488:76.82,63.28 N:500022'}
G[1194080]={500022,'HW 495:67.65,50.69 N:500022'}
G[1194081]={500022,'HW 504[1]:66.82,29.61 N:500022'}
G[1194084]={500022,'HW 486:49.74,9.98 N:500022'}
G[1194105]={1194105,'42:53.25,19.65'}
G[1194119]={500022,'HW 495:37.09,49.51 N:500022'}
G[1194122]={1194122,'42:54.2,29.3'}
G[1194378]={1194378,'35:41.37,38.98'}
G[1194387]={1194378,'35:36.75,61.14 N:1194378'}
G[1194388]={1194378,'35:61.70,73.18 N:1194378'}
G[1194389]={1194378,'35:68.11,66.14 N:1194378'}
G[1194390]={1194378,'35:73.17,35.89 N:1194378'}
G[1194391]={1194378,'35:53.70,38.10 N:1194378'}
G[1194555]={1194555,'529:15.6,89.3'}
G[1194714]={1194714,'42:57.4,33.8'}
G[1195134]={1195134,'43:46.3,61.3'}
G[1195431]={1195431,'181:20.26,70.40'}
G[1195433]={1195433,'101:69.3,29.2'}
G[1195435]={1195435,'181:20.03,69.98'}
G[1195438]={1195438,'101:77.00,18.08'}
G[1195445]={1195445,'101:74.8,13.3'}
G[1195497]={1195497,'101:78.74,23.16'}
G[1195517]={1195517,'101:75.88,26.61'}
G[1195600]={1195600,'101:69.31,21.19'}
G[1195642]={1195642,'181:58.98,71.85'}
G[1195676]={1195676,'181:43.81,77.37'}
G[1196393]={1196393,'750:38.2,58.1 101[21]:12.57,49.33>750'}
G[1196394]={1196394,'545:32.77,66.39'}
G[1196832]={1196832,'181:49.52,28.77'}
G[1196833]={1196833,'181:53.00,29.06'}
G[1201578]={1201578,'181:55.14,51.94'}
G[1201742]={1201742,''}
G[1202135]={1202135,'201:45.49,7.74'}
G[1202264]={1202264,'201:53.1,51.9'}
G[1202335]={1202335,'607:67,46.6'}
G[1202407]={1202407,'161:41.88,57.52'}
G[1202474]={1202474,'720:84.48,43.21 161:37.78,82.38>720'}
G[1202598]={1202598,'607:40.4,77.8'}
G[1202613]={1202613,'544:51.37,13.08'}
G[1202697]={1202697,'606:27.18,35.22'}
G[1202701]={1202701,'606:88.26,58.56'}
G[1202706]={1202706,'606:28.43,36.38'}
G[1202712]={1202712,'606:25.81,41.66',"In cave Gar'gol's Hovel"}
G[1202714]={1202714,'615:40.49,75.47'}
G[1202759]={1202759,'610:57.86,35.10'}
G[1202859]={1202859,'610:46.53,47.38'}
G[1202871]={1202871,'610:49.67,40.89'}
G[1202916]={1202916,'610:55.11,54.98'}
G[1202975]={1202975,'61:79.61,75.08'}
G[1203128]={1203128,'610:56.42,30.08'}
G[1203134]={1203134,'121:65.91,62.87'}
G[1203140]={1203140,'615:40.4,75.4'}
G[1203186]={1203186,'81:64.97,49.37'}
G[1203207]={1203207,'606:31.28,77.08'}
G[1203301]={1203301,'610:60.39,69.83'}
G[1203305]={1203305,'615:57.26,89.93'}
G[1203395]={1203395,'610:38.9,26.9'}
G[1203733]={1203733,'30:74.04,73.32'}
G[1203734]={1203734,'30:24.78,95.26'}
G[1203755]={1201578,'181:52.31,50.30 N:1201578'}
G[1204050]={1204050,'181:53.54,47.37'}
G[1204274]={1204274,'640:53.59,73.79'}
G[1204344]={1000256,'36:16.24,65.34 36:16.03,64.65 N:1000256'}
G[1204351]={1204351,'36:17.87,18.62'}
G[1204406]={1204406,'673:62.39,46.79 673:48.51,81.00 673:50.2,75.9 673:54.2,65.4 673:54.2,65.5 673:57,54.4 673:57,54.5'}
G[1204450]={1204450,'673:50.24,91.45','Inside lower ship'}
G[1204578]={1204578,'673:40.63,73.22'}
G[1204817]={1204817,'34:23.45,35.41'}
G[1204824]={1204824,'34:20.37,27.46','In catacombs'}
G[1204825]={1204825,'34:18.02,25.37','In catacombs'}
G[1204959]={1204959,'640:66.45,20.61'}
G[1205134]={1205134,'640:63.72,55.40'}
G[1205143]={1205143,'21:53.85,12.95'}
G[1205198]={1205198,'301:50.19,42.64','In catacombs'}
G[1205207]={1205207,'640:67.20,70.18'}
G[1205258]={1205258,'22:53.76,80.44','Bottom of crypt'}
G[1205266]={1205266,'720:64.85,29.57'}
G[1205332]={1000068,'141:37.46,31.52 N:1000068'}
G[1205350]={1205350,'21:59.2,34.3'}
G[1205540]={1205540,'720:65.17,33.80'}
G[1205874]={1205874,'720:39.64,45.42'}
G[1205875]={1205875,'23:77.56,79.41'}
G[1206109]={1206109,'321[1]:49.66,76.48'}
G[1206111]={1206111,'301:62.91,71.54'}
G[1206116]={1206109,'321[1]:66.42,49.29 N:1206109'}
G[1206293]={1206293,'720:74.14,64.44'}
G[1206294]={1206111,'301:62.28,29.93 N:1206111'}
G[1206335]={1206335,'17:50.25,54.28'}
G[1206336]={1206336,'17:47.97,50.91'}
G[1206374]={1206374,'17:50.26,53.27'}
G[1206504]={1206504,'17:18.84,30.28','In the cave'}
G[1206569]={1202697,'700:57.94,33.50 N:1202697'}
G[1206585]={1206585,'182:51.48,83.81'}
G[1206944]={1206944,'24:39.72,63.04'}
G[1207104]={1207104,'182:60.4,22.3 182:60.5,22.2'}
G[1207125]={1207125,'29:73.73,67.33'}
G[1207179]={1207179,'281:24.47,47.61'}
G[1207279]={1206109,'24:56.54,47.11 24:59.91,63.56 N:1206109'}
G[1207291]={1207291,'281:67.06,55.09'}
G[1207303]={1207303,'29:17,51.6'}
G[1207304]={1207303,'29:72.92,65.14 N:1207303'}
G[1207320]={1206111,'341:25.56,69.62 N:1206111'}
G[1207321]={1206111,'381:44.93,49.88 N:1206111'}
G[1207322]={1206111,'471:55.30,47.33 N:1206111'}
G[1207323]={1206109,'362:42.33,57.81 N:1206109'}
G[1207324]={1206109,'382:65.93,50.00 N:1206109'}
G[1207325]={1206109,'480:62.17,60.44 N:1206109'}
G[1207359]={1207359,'606:59.15,83.87'}
G[1207406]={1207406,'767[1]:51.11,43.05'}
G[1207407]={1207407,'768[1]:60.18,71.32'}
G[1207408]={1207408,'769:62.1,31.7 720:76.75,84.45>769'}
G[1207409]={1207409,'747:31.57,24.82 720:60.52,64.19>747'}
G[1207410]={1207410,'759:48.4,60.8 759:48.6,60.9'}
G[1207411]={1207411,'757[1]:26.66,30.02 700:19.18,54.01>757'}
G[1207412]={1207412,'753[1]:42.17,69.44'}
G[1207982]={1187564,'HM 37:51.7,63.1 N:1187564'}
G[1207983]={1187559,'HM 37:40.70,51.80 N:1187559'}
G[1207984]={1187564,'HM 17:18.6,55.8 N:1187564'}
G[1207985]={1187564,'HM 607:48.27,72.46 N:1187564'}
G[1207986]={1187559,'HM 607:40.71,67.35 N:1187559'}
G[1207987]={1187564,'HM 201:59.78,62.90 N:1187564'}
G[1207988]={1187564,'HM 38:70.1,14.2 N:1187564'}
G[1207989]={1187559,'HM 19:46.31,14.13 N:1187559'}
G[1207990]={1187559,'HM 22:29.09,56.60 N:1187559'}
G[1207991]={1187559,'HM 181:60.45,53.57 N:1187559'}
G[1207992]={1187559,'HM 201:56.50,65.85 N:1187559'}
G[1207993]={1187564,'HM 81:49.50,51.14 N:1187564'}
G[1208089]={1187564,'HM 700:47.15,28.32 N:1187564'}
G[1208090]={1187559,'HM 700:53.27,46.37 N:1187559'}
G[1208093]={1187564,'HM 720:53,32 N:1187564'}
G[1208094]={1187559,'HM 720:52.98,34.58 N:1187559'}
G[1208115]={500022,'HW 42:50.79,18.89 N:500022'}
G[1208116]={500022,'HW 121:51.07,17.82 N:500022'}
G[1208117]={500022,'HW 43:50.25,67.26 N:500022'}
G[1208118]={500022,'HW 43:38.65,42.35 N:500022'}
G[1208119]={500022,'HW 43:12.99,34.10 N:500022'}
G[1208120]={500022,'HW 16:40.07,49.09 N:500022'}
G[1208121]={500022,'HW 17:20.87,56.32 N:500022'}
G[1208122]={500022,'HW 19:60.69,14.08 N:500022'}
G[1208123]={500022,'HW 19:44.35,87.60 N:500022'}
G[1208124]={500022,'HW 35:83.03,63.53 N:500022'}
G[1208125]={500022,'HW 37:53.16,66.98 N:500022'}
G[1208126]={500022,'HW 38:28.93,32.40 N:500022'}
G[1208127]={500022,'HW 26:66.16,44.44 N:500022'}
G[1208128]={500022,'HW 700:60.35,58.25 N:500022'}
G[1208129]={500022,'HW 700:79.48,78.54 N:500022'}
G[1208130]={500022,'HW 700:49.60,30.36 N:500022'}
G[1208131]={500022,'HW 700:43.50,57.27 N:500022'}
G[1208132]={500022,'HW 614:54.68,72.12 N:500022'}
G[1208133]={500022,'HW 615:49.72,57.39 N:500022'}
G[1208134]={500022,'HW 22:43.38,84.36 N:500022'}
G[1208135]={500022,'HW 40:58.21,39.20 N:500022'}
G[1208136]={500022,'HW 40:26.07,25.99 N:500022'}
G[1208137]={500022,'HW 17:65.85,35.65 N:500022'}
G[1208138]={500022,'HW 28:39.48,66.02 N:500022'}
G[1208139]={500022,'HW 38:71.65,14.10 N:500022'}
G[1208140]={500022,'HW 181:57.10,50.17 N:500022'}
G[1208141]={500022,'HW 610:63.49,60.17 N:500022'}
G[1208142]={500022,'HW 615:49.19,41.88 N:500022'}
G[1208143]={500022,'HW 17:18.36,42.73 N:500022'}
G[1208144]={500022,'HW 19:40.47,11.29 N:500022'}
G[1208145]={500022,'HW 24:60.26,63.75 N:500022'}
G[1208146]={500022,'HW 21:44.30,20.29 N:500022'}
G[1208147]={500022,'HW 673:35.04,27.22 N:500022'}
G[1208148]={500022,'HW 26:31.82,57.87 N:500022'}
G[1208149]={500022,'HW 20:83.04,72.08 N:500022'}
G[1208150]={500022,'HW 700:53.40,42.85 N:500022'}
G[1208151]={500022,'HW 700:45.11,76.80 N:500022'}
G[1208152]={500022,'HW 700:75.36,54.92 N:500022'}
G[1208153]={500022,'HW 700:75.41,16.53 N:500022'}
G[1208154]={500022,'HW 615:51.48,62.39 N:500022'}
G[1208155]={500022,'HW 614:51.35,60.56 N:500022'}
G[1208156]={500022,'HW 22:48.28,63.66 N:500022'}
G[1208157]={500022,'HW 101:56.72,50.12 N:500022'}
G[1208158]={500022,'HW 182:44.58,28.99 N:500022'}
G[1208159]={500022,'HW 182:61.86,26.71 N:500022'}
G[1208160]={500022,'HW 121:41.45,15.68 N:500022'}
G[1208161]={500022,'HW 121:51.97,47.63 N:500022'}
G[1208162]={500022,'HW 606:63.05,24.15 N:500022'}
G[1208163]={500022,'HW 606:18.63,37.32 N:500022'}
G[1208164]={500022,'HW 606:42.68,45.71 N:500022'}
G[1208165]={500022,'HW 11:56.21,40.03 N:500022'}
G[1208166]={500022,'HW 11:62.51,16.60 N:500022'}
G[1208167]={500022,'HW 607:39.29,20.10 N:500022'}
G[1208168]={500022,'HW 607:40.71,69.31 N:500022'}
G[1208169]={500022,'HW 607:39.01,10.99 N:500022'}
G[1208170]={500022,'HW 607:65.60,46.54 N:500022'}
G[1208171]={500022,'HW 607:49.05,68.50 N:500022'}
G[1208172]={500022,'HW 81:66.49,64.19 N:500022'}
G[1208173]={500022,'HW 81:71.02,79.08 N:500022'}
G[1208174]={500022,'HW 81:59.05,56.33 N:500022'}
G[1208175]={500022,'HW 81:39.48,32.81 N:500022'}
G[1208176]={500022,'HW 81:31.53,60.66 N:500022'}
G[1208177]={500022,'HW 161:55.70,60.96 N:500022'}
G[1208178]={500022,'HW 720:26.59,7.24 N:500022'}
G[1208179]={500022,'HW 720:54.68,33.01 N:500022'}
G[1208180]={500022,'HW 201:55.27,62.12 N:500022'}
G[1208181]={500022,'HW 640:51.19,49.91 N:500022'}
G[1208183]={500022,'HW 640:47.36,51.71 N:500022'}
G[1208184]={1208184,'HM 606:62.78,22.99'}
G[1208187]={1208184,'HM 615:49.29,41.91 N:1208184'}
G[1208188]={1208184,'HM 640:49.41,51.43 N:1208184'}
G[1208316]={1206111,'504[1]:37.55,62.97 N:1206111'}
G[1208317]={1206109,'504[1]:59.2,27.4 N:1206109'}
G[1208420]={1208420,'673:35.51,63.57'}
G[1208535]={1208535,'795:69,42'}
G[1208549]={1208549,'781:15.99,55.99'}
G[1208550]={1208549,'X 793:31.42,48.17 37:72.09,32.91>793 N:1208549'}
G[1208825]={1208825,'381:69.42,39.69'}
G[1209072]={1209072,'301:55.40,43.40','In catacombs'}
G[1209076]={500024,'301:65.07,33.52 N:500024'}
G[1209094]={1209072,'382:65.8,74.7 N:1209072'}
G[1209095]={500025,'321[1]:54.5,77.8 321[1]:71.6,49.8 N:500025'}
G[1209673]={1209673,'808:26.46,33.68'}
G[1209845]={1209845,'806:53.71,91.51'}
G[1211316]={1211316,'807:19.84,55.93'}
G[1211754]={1211754,'809:57.11,47.89'}
G[1212181]={1212181,'806:30.89,17.49'}
G[1212389]={1212389,'858:53.08,12.36','Down in the Amber Vault'}
G[1213767]={1213767,'807[14]:31.36,52.90','In a cave whose entrance is 35,19'}
G[1213770]={1213770,'809[8]:41.66,44.11','In back of cave whose entrance is 809:59.20,53.14'}
G[1213771]={1213771,'809:72.02,33.98'}
G[1213793]={1213793,'809:52.57,51.54'}
G[1214062]={1214062,'858:41.88,63.72'}
G[1214205]={1214218,'811:83.0,30.4 N:1214218'}
G[1214206]={1214218,'811:83.0,30.4 N:1214218'}
G[1214207]={1214218,'811:83.0,30.4 N:1214218'}
G[1214208]={1214218,'811:83.0,30.4 N:1214218'}
G[1214209]={1214218,'811:83.08,30.43 N:1214218'}
G[1214210]={1214218,'811:83.5,30.5 N:1214218'}
G[1214211]={1214218,'811:83.5,30.5 N:1214218'}
G[1214212]={1214218,'811:83.5,30.5 N:1214218'}
G[1214213]={1214218,'811:83.5,30.5 N:1214218'}
G[1214214]={1214218,'811:83.5,30.5 N:1214218'}
G[1214215]={1214218,'811:83.70,30.66 N:1214218'}
G[1214217]={1214218,'811:83.5,30.5 N:1214218'}
G[1214218]={1214218,'811:83.55,30.59 N:1214218'}
G[1214219]={1214218,'811:83.5,30.5 N:1214218'}
G[1214220]={1214218,'811:83.5,30.5 N:1214218'}
G[1214221]={1214218,'811:83.5,30.5 N:1214218'}
G[1214222]={1214218,'811:83.5,30.5 N:1214218'}
G[1214223]={1214218,'811:83.5,30.5 N:1214218'}
G[1214224]={1214218,'811:83.5,30.5 N:1214218'}
G[1214225]={1214218,'811:83.7,30.8 N:1214218'}
G[1214226]={1214218,'811:83.7,30.8 N:1214218'}
G[1214438]={1214438,'809:64.23,45.11'}
G[1214562]={1214562,'858:44.57,41.32'}
G[1214871]={1214871,'806:48.57,20.61'}
G[1215705]={1215705,'807:52.03,49.06'}
G[1215844]={1215844,'806:27.60,24.29'}
G[1215873]={500022,'857:28.25,50.74 N:500022'}
G[1215874]={500022,'HW 806:41.68,23.14 N:500022'}
G[1215875]={500022,'HW 903[2]:58.88,78.25 N:500022'}
G[1215876]={500022,'HW 858:55.21,71.19 N:500022'}
G[1215877]={500022,'HW 858:55.93,32.28 N:500022'}
G[1215879]={500022,'HW 873:55.10,72.24 N:500022'}
G[1215880]={500022,'HW 806:45.77,43.60 N:500022'}
G[1215881]={500022,'HW 806:28.01,47.39 N:500022'}
G[1215884]={500022,'HW 806:48.09,34.62 N:500022'}
G[1215886]={500022,'HW 806:55.71,24.41 N:500022'}
G[1215889]={500022,'HW 806:54.61,63.32 N:500022'}
G[1215891]={500022,'HW 806:59.56,83.24 N:500022'}
G[1215892]={500022,'HW 857:51.40,77.29 N:500022'}
G[1215894]={500022,'HW 857:75.92,6.87 N:500022'}
G[1215895]={500022,'HW 809:57.45,59.95 N:500022'}
G[1215897]={500022,'HW 809:72.73,92.28 N:500022'}
G[1215898]={500022,'HW 809:62.7,80.5 N:500022'}
G[1215899]={500022,'HW 809:64.21,61.27 N:500022'}
G[1215900]={500022,'HW 809:54.07,82.81 N:500022'}
G[1215902]={500022,'HW 810:71.12,57.79 N:500022'}
G[1215903]={500022,'HW 811:35.13,77.78 N:500022'}
G[1215904]={500022,'HW 857:61.02,25.14 N:500022'}
G[1215905]={500022,'HW 807:83.64,20.14 N:500022'}
G[1215906]={500022,'HW 807:19.87,55.79 N:500022'}
G[1215907]={500022,'HW 806:44.80,84.37 N:500022'}
G[1215908]={500022,'HW 806:28.45,13.27 N:500022'}
G[1215914]={500022,'HW 809:62.50,28.90 N:500022'}
G[1215915]={500022,'HW 811[3]:37.86,65.93 N:500022'}
G[1216161]={1181758,'857:39.21,61.92 N:1181758'}
G[1216162]={1181758,'857:13.87,41.34 N:1181758'}
G[1216163]={1181758,'857:56.30,42.05 N:1181758'}
G[1216274]={1216274,'857:8.45,63.92'}
G[1216322]={1203733,'857:12.73,56.70 N:1203733'}
G[1216609]={1216609,'HM 857:85.59,29.16'}
G[1216837]={1216837,'873:54.99,72.65'}
G[1217845]={1217848,'HM 858:56.06,69.44 N:1217848'}
G[1217846]={1217848,'HM 806:47.14,47.09 N:1217848'}
G[1217847]={1217848,'HM 857:73.94,9.39 N:1217848'}
G[1217848]={1217848,'HM 809:71.09,90.98'}
G[1217849]={1217848,'HM 810:71.43,56.33 N:1217848'}
G[1217850]={1217848,'HM 807:51.81,51.19 N:1217848'}
G[1217851]={1187564,'HM 811:79.92,37.29 N:1187564'}
G[1217852]={1187559,'HM 811:77.78,33.66 N:1187559'}
G[1218072]={1218072,'928:39.12,56.01 928:40.65,71.43 928:50.18,85.91 928:53.18,81.39 928:52.95,45.10 928:54.27,48.85'}
G[1218077]={1218077,'928:34.62,64.83','In cave from beach'}
G[1218750]={1218750,'807:52.28,48.69'}
G[1218765]={1218765,'807:51.61,48.67'}
G[1218951]={1214218,'811:82,31 N:1214218'}
G[1218952]={1214218,'811:82.93,31.13 N:1214218'}
G[1218953]={1214218,'811:82,31 N:1214218'}
G[1218954]={1214218,'811:82,31 N:1214218'}
G[1218955]={1214218,'811:82.89,31.41 N:1214218'}
G[1218956]={1214218,'811:82,31 N:1214218'}
G[1218957]={1214218,'811:82,31 N:1214218'}
G[1218958]={1214218,'811:82,31 N:1214218'}
G[1220832]={1220832,'951:40.40,92.98'}
G[1220901]={1220901,'951:49.71,69.42'}
G[1220902]={1220902,'951:53.94,47.21'}
G[1220903]={1220903,'951:58.51,60.06'}
G[1220986]={1220986,'951:22.69,58.94'}
G[1221036]={1221036,'951:70.7,80.9'}
G[1221376]={1221376,'951:52.09,46.14'}
G[1221413]={1221413,'867[1]:69.09,58.08'}
G[1221617]={1221617,'951[22]:62.91,34.88','In cave'}
G[1222684]={1222684,'H:100102225 Z951'}
G[1223533]={1223533,'947:44.48,63.57'}
G[1224228]={1002076,'947:37.18,23.13 N:1002076','In cave'}
G[1224305]={1224305,'941:60.28,27.20'}
G[1224306]={1224306,'941:58.37,31.09'}
G[1224750]={1224750,'947:47.14,46.03'}
G[1224753]={1224753,'947:67.04,84.18','In cave'}
G[1224754]={1224754,'947:39.19,83.91'}
G[1224755]={1224755,'947:37.52,59.24'}
G[1224756]={1224756,'947:54.92,45.01'}
G[1224770]={1224770,'947:45.82,24.57','In cave'}
G[1224780]={1224780,'947:29.99,45.35'}
G[1224781]={1224781,'947[15]:56.27,49.19'}
G[1224783]={1224783,'947:51.75,35.49'}
G[1224784]={1224784,'947:51.14,79.13'}
G[1224785]={1224785,'947:20.37,30.64'}
G[1225501]={1223533,'947:45.21,60.49 N:1223533'}
G[1225502]={1223533,'947:43.75,60.62 N:1223533'}
G[1225503]={1223533,'947:44.49,59.14 N:1223533'}
G[1225726]={1225726,'946:61.80,27.54'}
G[1225778]={1225778,'946:76.27,42.76'}
G[1226702]={1000068,'947:45.60,37.80 N:1000068'}	-- this does not exist until the garrison is constructed (or something else)...perhaps they are no longer here
G[1226831]={1226831,'947:49.39,37.59','Upstairs'}
G[1226861]={1226861,'947:31.26,39.12'}
G[1226862]={1226862,'947:34.40,46.17'}
G[1226865]={1226865,'947:84.56,44.78'}
G[1226961]={1203733,'941[1]:28.87,44.85 N:1203733'}
G[1226987]={1226987,'946:30.89,70.82'}
G[1227069]={1227069,'946:49.21,88.05'}
G[1227134]={1227134,'947:42.10,61.22'}
G[1227504]={1227504,'941:84.09,65.14'}
G[1227737]={1227737,'946:37.25,79.39'}
G[1227743]={1227743,'947:26.53,5.68'}
G[1227793]={1227793,'946:36.52,95.98'}
G[1227806]={1227806,'941:82.64,69.83'}
G[1227951]={1227951,'946:64.91,13.31'}
G[1227953]={1227953,'946:65.46,11.37','In cave'}
G[1227954]={1227954,'946:52.56,29.54'}
G[1227955]={1227955,'946:62.08,32.40'}
G[1227956]={1227956,'946:57.37,28.66'}
G[1227996]={1227996,'946:66.50,86.94'}
G[1228012]={1228012,'946:77.03,49.95'}
G[1228013]={1228013,'946:35.40,96.56'}
G[1228014]={1228014,'946:75.78,44.72','On platform'}
G[1228015]={1228015,'946:64.58,79.20'}
G[1228016]={1228016,'946:62.42,47.97'}
G[1228017]={1228017,'946:55.25,66.73'}
G[1228018]={1228018,'946[14]:28.25,34.96'}
G[1228019]={1228019,'946:65.44,88.61'}
G[1228020]={1228020,'946:46.95,91.74'}
G[1228021]={1228021,'946:38.33,84.51'}
G[1228022]={1228022,'946:38.16,12.34'}
G[1228023]={1228023,'946:33.29,76.81'}
G[1228024]={1228024,'946:81.85,34.94','In mine'}
G[1228025]={1228025,'946:75.68,41.40','Under bridge'}
G[1228026]={1228026,'946:78.21,14.72'}
G[1228483]={1228483,'946:65.96,85.14','Very deep in water'}
G[1229314]={1229314,'947:59.79,94.46'}
G[1229330]={1229330,'949:39.70,39.90'}
G[1229331]={1229331,'946:45.27,37.06'}
G[1229333]={1229333,'941:68.00,18.92'}
G[1229344]={1229344,'950:46.37,16.04'}
G[1229354]={1229354,'946:73.52,51.37','In water'}
G[1230303]={1203733,'950:78.97,58.93 N:1203733'}	-- 950:78.63,48.32
G[1230665]={1230665,'946:69.77,20.70'}
G[1230741]={1230741,'950:63.10,62.02'}
G[1230865]={1230865,'971:48.38,40.93'}	-- garrison level 1 location
G[1230882]={1230882,'950:71.04,52.31'}
G[1230933]={1230933,'947:56.95,34.73'}
G[1230977]={1230977,'950:82.94,44.22'}
G[1231100]={1231100,'941:54.22,67.52'}
G[1231183]={1231183,'948:66.61,51.69'}
G[1231184]={1231184,'948:66.80,51.39'}
G[1231901]={1231901,'950:81.33,70.35'}
G[1231903]={1231903,'949:47.60,72.75'}
G[1231918]={1231918,'947:50.00,81.23'}
G[1232024]={1232024,'950:51.87,62.10'}
G[1232353]={1232353,'948:35.49,32.04'}
G[1232397]={1232397,'971:42.92,44.59'}
G[1232398]={1203733,'971:42.68,44.77 N:1203733'}
G[1232400]={1232397,'971:42.67,44.73 N:1232397'}	-- garrison level 2 location
G[1232405]={1000068,'947:57.46,57.26 N:1000068'}
G[1232406]={1233511,'950:69.93,52.50 N:1233511','Hanging in tree'}
G[1232416]={1233291,'976:49.04,41.72 N:1233291'}	-- garrison level 1 location
G[1232489]={1232489,'949:47.88,94.25'}	-- it seems Blizzard took this out of a dungeon map 949[17]:44.39,25.67
G[1232492]={1232492,'949:47.96,94.35'}
G[1232494]={1232494,'947:52.88,24.86','Bottom of water'}
G[1232571]={1232571,'950:47.21,74.27','In tree'}
G[1232579]={80470,'947:57.91,45.32 N:80470'}
G[1232582]={1232582,'947:37.75,44.27'}
G[1232583]={1232583,'947:33.49,39.65'}
G[1232584]={1232598,'950:50.12,82.29 N:1232598'}
G[1232586]={1232586,'947:36.68,44.46'}
G[1232587]={1232587,'947:35.88,40.88'}
G[1232588]={1232588,'947:38.49,43.05'}
G[1232589]={1232589,'947:34.17,43.48'}
G[1232590]={1232590,'950:50.02,66.48'}
G[1232591]={1232591,'947:36.79,41.41'}
G[1232592]={1232592,'947:55.28,74.87'}
G[1232595]={1232598,'950:52.67,80.08 N:1232598'}
G[1232596]={1232596,'947:52.82,48.38'}
G[1232598]={1232598,'950:77.83,51.94','On top of tower'}
G[1232621]={1232621,'947:55.82,20.00','On top of mushroom'}
G[1232624]={1232624,'947:58.88,21.93'}
G[1232985]={1232598,'950:88.27,42.62 N:1232598'}
G[1233033]={1232598,'950:70.59,18.60 N:1232598'}
G[1233034]={1232598,'950:64.59,17.62 N:1232598'}
G[1233099]={1000068,'948:39.78,42.65 N:1000068'}
G[1233100]={1000068,'948:39.46,61.66 N:1000068'}
G[1233101]={1233101,'947:37.18,26.02'}
G[1233107]={1244694,'1017:67.94,57.76'}
G[1233134]={1233134,'950:58.27,52.48','In tree'}
G[1233135]={1233135,'950:51.72,60.29'}
G[1233206]={1233206,'950:67.65,59.72'}
G[1233229]={1233229,'947:60.92,24.43','In cave'}
G[1233241]={1233241,'947:48.72,47.53'}
G[1233263]={1233263,'950:55.43,55.95 950:51.83,58.74 950:46.76,57.46 950:52.03,68.74'}
G[1233291]={1233291,'976:49.05,41.69'}	-- Garrison Level 1 position
G[1233391]={1233391,'949:47.72,52.07'}
G[1233505]={1233505,'949:45.31,81.94'}	-- arbitrarily mapped ID to location...cannot tell which for sure
G[1233511]={1233511,'950:45.62,52.01'}
G[1233520]={1233520,'949:45.97,93.57'}
G[1233525]={1233525,'949:41.98,81.55'}
G[1233539]={1233549,'950:43.22,57.55 N:1233549'}
G[1233549]={1233549,'950:48.06,60.12'}
G[1233551]={1233549,'950:44.69,67.57 N:1233549'}
G[1233555]={1233549,'950:48.58,72.77 N:1233549'}
G[1233557]={1233549,'950:55.34,68.27 N:1233549'}
G[1233559]={1233559,'949:45.80,89.31'}
G[1233560]={1233560,'950:45.85,66.29'}
G[1233561]={1233561,'950:58.30,59.32','In tree'}
G[1233611]={1233611,'950:67.38,49.08'}
G[1233613]={1233613,'950:64.70,65.82'}
G[1233623]={1233623,'950:56.57,72.94'}
G[1233641]={1233641,'950:64.77,35.72'}
G[1233642]={1233642,'950:38.36,49.33'}
G[1233645]={1233645,'950:52.41,44.38'}
G[1233649]={1233649,'950:75.37,47.10'}
G[1233651]={1233651,'950:61.76,57.46','In tree'}
G[1233658]={1233623,'950[12]:65.92,57.54 N:1233623'}
G[1233715]={1233715,'950:38.35,58.73'}
G[1233768]={1233768,'950:57.80,62.04','On rock outcropping'}
G[1233773]={1233773,'950:62.54,67.08'}
G[1234147]={1234147,'948:36.81,17.14'}
G[1234154]={1234154,'948:42.69,18.32'}
G[1234157]={1234157,'948:50.50,22.10'}
G[1234159]={1234159,'948:50.76,28.75','Under bridge'}
G[1234243]={1234243,'971:36.11,34.87'}	-- garrison level 2 position
G[1234432]={1234432,'948:58.70,60.24'}
G[1234449]={1234449,'948:43.23,27.24','In tree'}
G[1234454]={1234449,'948:60.24,53.87 N:1234449','In tree'}
G[1234455]={1234449,'948:51.89,48.92 N:1234449','On wall'}
G[1234456]={1234456,'948:47.92,30.68'}
G[1234458]={1234458,'948:56.23,28.78'}
G[1234461]={1234461,'948:54.36,32.54'}
G[1234471]={1234471,'948:59.63,81.33'}
G[1234472]={1234472,'948:59.16,90.62'}
G[1234473]={1234473,'948:55.53,90.84','On high shelf'}
G[1234474]={1234474,'949:51.04,51.62'}	-- Sparring Arena-based location
G[1234618]={1234618,'948:61.11,55.38'}
G[1234703]={1234704,'948:43.90,15.01 N:1234704'}
G[1234704]={1234704,'948:43.82,24.63'}
G[1234705]={1234704,'948:69.15,43.34 N:1234704'}
G[1234734]={1234704,'948:48.97,62.56 N:1234704'}
G[1234735]={1234704,'948:55.66,22.09 N:1234704'}
G[1234736]={1234704,'948:53.13,84.50 N:1234704'}
G[1234740]={1234740,'948:36.29,39.34'}
G[1234744]={1235073,'948:53.31,55.52 N:1235073'}
G[1234746]={1235073,'948:48.35,52.61 N:1235073'}
G[1234748]={1235073,'948:48.35,52.61 N:1235073'}
G[1235073]={1235073,'948:51.88,64.65'}
G[1235090]={1235073,'948:60.97,63.87 N:1235073'}
G[1235091]={1235091,'948:47.77,36.12'}
G[1235095]={1235095,'948:52.47,42.80'}
G[1235097]={1235097,'948:36.44,57.79'}
G[1235103]={1235103,'948:37.15,47.50'}
G[1235104]={1235104,'948:34.14,27.52'}
G[1235105]={1235104,'948:33.29,27.27 N:1235104'}
G[1235129]={1235129,'949:49.47,70.95'}
G[1235135]={1235135,'948:56.30,45.30'}
G[1235141]={1235141,'948:50.33,25.80'}
G[1235143]={1235143,'948:49.21,37.20'}
G[1235168]={1235168,'948:46.92,34.04','In tree'}
G[1235172]={1234147,'948:42.17,21.69 N:1234147'}
G[1235282]={1235282,'948:71.64,48.59'}
G[1235289]={1235289,'948:41.86,50.42'}
G[1235299]={1235299,'948:68.42,88.98'}
G[1235300]={1235300,'948:63.58,67.37'}
G[1235307]={1235307,'948:66.47,56.53'}
G[1235310]={1235310,'948:60.87,84.60'}
G[1235313]={1235313,'948:40.59,54.98'}
G[1235365]={1235365,'948:36.19,54.46'}
G[1235860]={1235860,'947:66.97,33.48'}
G[1236140]={1236140,'949[19]:34.56,66.76'}
G[1236141]={1236141,'949:42.36,83.41'}
G[1236165]={1236206,'976:50,50 N:1236206'}	-- Arbitrarily set this to Horde
G[1236206]={1236206,'971:31.44,31.04'}	-- Arbitrarily set this to Alliance
G[1236483]={1236483,'946:28.39,74.19','In cave'}
G[1236610]={1236610,'950:35.47,57.25'}
G[1236935]={1236935,'946:70.13,7.11'}
G[1237016]={1237016,'947:33.27,30.73'}	-- this exists prior to garrison construction
G[1237021]={1237021,'947:26.40,32.88'}	-- this exists prior to garrison construction
G[1237022]={1233291,'976:48.51,41.44 N:1233291'}
G[1237705]={1237705,'950:79.73,30.23'}
G[1237790]={1237790,'947:73.76,55.81'}
G[1237821]={1237821,'949:40.32,40.30'}
G[1237946]={1237946,'950:40.34,68.63','In cave'}
G[1239120]={1239120,'1015[18]:43.98,24.68'}
G[1239328]={1239328,'1015:65.69,56.92'}
G[1239791]={1239791,'971:34.32,32.48'}	-- Alliance version	-- TODO: Make Horde version 976:40,56.2
G[1239902]={1239902,'945:58.50,60.45'}	-- Arbitrarily set to Alliance
G[1240003]={1240003,'945:36.31,43.50'}
G[1240289]={1240289,'945:15.93,49.78','In cave'}
G[1240317]={1240317,'945:16.09,44.25'}
G[1240543]={1240543,'945:17.01,52.93'}
G[1240547]={1240547,'945:32.44,37.40'}
G[1240552]={1240552,'1015[17]:68.88,13.24'}
G[1240577]={1240577,'945:19.30,40.95'}
G[1240580]={1240580,'945:28.73,23.34'}
G[1240616]={1240616,'281:68.03,73.87 H:100122224'}
G[1240617]={1240617,'43:56.39,49.26 H:100122226'}
G[1240625]={1240625,'381:43.03,75.74 H:100122239','Upstairs'}
G[1240629]={1208420,'1015:53.18,64.44 N:1208420'}
G[1240630]={1244694,'1015:49.65,34.48 N:1244694'}
G[1240634]={1208420,'1015:57.87,12.26 N:1208420'}
G[1240637]={1240639,'1015:42.62,8.08 N:1240639'}
G[1240638]={1240638,'1015:55.88,56.85'}
G[1240639]={1240639,'1015:58.35,43.79'}
G[1240641]={1208420,'1015:49.41,57.98 N:1208420'}
G[1240642]={1208420,'1015:56.45,34.81 N:1208420'}
G[1240643]={1240643,'1015:49.36,45.37'}
G[1240645]={1240639,'1015[18]:69.26,48.27 N:1240639'}
G[1240690]={1208420,'1015:57.15,31.06 N:1208420'}
G[1240855]={1240855,'945:32.42,70.40'}
G[1241146]={1208420,'1017:42.62,65.80 N:1208420'}
G[1241147]={1244694,'1017:40.64,68.52 N:1244694'}
G[1241148]={1244694,'1017:48.13,74.22 N:1244694'}
G[1241149]={1241149,'1017:42.34,61.13'}
G[1241150]={1244694,'1017:35.17,68.98 N:1244694'}
G[1241151]={1244694,'1017:52.02,80.59 N:1244694'}
G[1241152]={1208420,'1017:46.76,80.40 N:1208420'}
G[1241153]={1244694,'1017:50.33,40.99 N:1244694'}
G[1241154]={1244694,'1017:49.76,78.00 N:1244694'}
G[1241155]={1208420,'1017:39.47,65.19 N:1208420'}
G[1241180]={1208420,'1017:35.03,36.59 N:1208420'}
G[1241206]={1244694,'1017:41.75,46.04 N:1244694'}
G[1241207]={1244694,'1017:44.16,69.97 N:1244694'}
G[1241208]={1208420,'1017:32.74,27.92 N:1208420'}
G[1241212]={1208420,'1017:33.14,36.08 N:1208420'}
G[1241213]={1244694,'1017:39.56,19.32 N:1244694'}
G[1241272]={1208420,'1022:19.58,46.87 N:1208420'}
G[1241280]={1208420,'1017[9]:19.97,41.34 N:1208420'}
G[1241433]={1241433,'945:56.97,65.05'}
G[1241434]={1241434,'945:54.82,69.31','Up in a tree'}
G[1241449]={1241449,'945:61.24,75.88'}
G[1241450]={1241450,'945:62.13,70.73'}
G[1241504]={1241504,'945:30.38,71.98'}
G[1241518]={1244694,'1017:69.15,44.78 N:1244694'}
G[1241521]={1241521,'945:40.61,79.80'}
G[1241522]={1241522,'945:40.78,75.58'}
G[1241524]={1241524,'945:37.05,46.27'}
G[1241533]={1241533,'945:41.58,73.28'}
G[1241557]={1208420,'1017:31.09,55.98 N:1208420'}
G[1241558]={1208420,'1017:35.73,54.10 N:1208420'}
G[1241560]={1241560,'945:22.00,47.77'}
G[1241561]={1241561,'945:58.5,25.3'}
G[1241562]={1244694,'1017:35.92,47.94 N:1244694'}
G[1241563]={1241563,'945:62.60,20.53'}
G[1241564]={1244694,'1017:46.60,64.96 N:1244694'}
G[1241565]={1241565,'945:26.7,44.3'}
G[1241566]={1241566,'945:51.73,24.27'}
G[1241599]={1241599,'945:64.59,42.11','In tree'}
G[1241600]={1241600,'945:49.90,81.24'}
G[1241601]={1241601,'945:49.95,79.62'}
G[1241602]={1241602,'945:69.75,55.99'}
G[1241605]={1241605,'945:47.90,70.40'}
G[1241656]={1241656,'945:50.81,64.99'}
G[1241657]={1241657,'945:31.41,31.07'}
G[1241664]={1241664,'945:25.3,50.2'}
G[1241665]={1208420,'1017:48.00,62.37 N:1208420'}
G[1241666]={1241666,'945:46.27,72.77'}
G[1241671]={1241671,'945:63.40,28.07'}
G[1241673]={1241565,'945:26.54,62.96 N:1241565','Up in tower'}
G[1241674]={1241674,'945:34.69,34.65','Down in Vault of Eyes'}
G[1241692]={1241692,'945:14.96,54.42','In building'}
G[1241699]={1241699,'945:17.36,56.92'}
G[1241712]={1241712,'945:35.9,78.6'}
G[1241713]={1241713,'945:15.99,59.40','In tower'}
G[1241714]={1241714,'945:33.90,78.13'}
G[1241715]={1241714,'945:35.03,77.33 N:1241714'}
G[1241716]={1241714,'945:34.41,78.30 N:1241714'}
G[1241717]={1241717,'1017:49.69,47.33'}
G[1241725]={1239902,'945:61.50,45.88 N:1239902'}	-- Arbitrarily set to Horde
G[1241742]={1241742,'945:46.87,36.65'}
G[1241745]={1241745,'945:46.93,44.36'}
G[1241760]={1241760,'945:46.85,42.16'}
G[1241764]={1241764,'945:73.64,43.24'}
G[1241775]={1241775,'945:37.73,80.74'}
G[1241835]={1241835,'945:49.95,76.77', 'In cave'}
G[1241840]={1241840,'1017:69.82,45.72'}
G[1241841]={1241841,'945:48.55,75.21'}
G[1241847]={1241847,'945:43.1,38.3'}
G[1241848]={1241848,'945:42.85,35.38','Top of tower'}
G[1242249]={1242249,'945:28.86,34.59','In cave'}
G[1242649]={1242649,'945:51.64,32.64'}
G[1243402]={1243402,'1024:39.00,37.32'}
G[1243454]={1243454,'1017:57.65,71.88'}
G[1243690]={1243690,'945:65.88,85.04'}
G[1243693]={1243693,'945:54.94,90.65'}
G[1243836]={1243836,'1017:46.73,44.44'}
G[1243912]={500022,'971:43.73,51.59 N:500022'}
G[1244446]={1244446,'1024:52.40,51.50'}
G[1244453]={1244453,'1017:36.74,31.12'}
G[1244466]={1244466,'1028:69.84,37.50'}
G[1244559]={1244559,'1022:34.17,27.92'}
G[1244692]={1244694,'1028:63.42,54.17 N:1244694'}
G[1244694]={1244694,'1028:54.78,59.26'}
G[1244887]={1244694,'1017:58.04,47.52 N:1244694'}
G[1244899]={1244694,'1017:73.32,41.50 N:1244694'}
G[1244901]={1208420,'1017:68.97,41.83 N:1208420'}
G[1244902]={1208420,'1017:59.31,58.46 N:1208420'}
G[1244903]={1208420,'1017:61.81,62.78 N:1208420'}
G[1244904]={1244694,'1017:57.95,63.21 N:1244694'}
G[1244905]={1244694,'1017:62.67,73.62 N:1244694'}
G[1244909]={1244694,'1017:61.41,44.40 N:1244694'}
G[1244912]={1208420,'1017:60.84,42.73 N:1208420'}
G[1244913]={1208420,'1017:55.01,47.18 N:1208420'}
G[1244917]={1208420,'1017:81.86,67.50 N:1208420'}
G[1244923]={1244923,'1032[1]:77.91,35.63'}
G[1245531]={1244694,'1024:37.35,33.79 N:1244694'}
G[1245532]={1208420,'1024[31]:34.30,80.46 N:1208420'}
G[1245536]={1240639,'1024:46.67,28.13 N:1240639'}
G[1245537]={1240639,'1024:54.18,41.60 N:1240639'}
G[1245548]={1208420,'1024[16]:60.66,25.11 N:1208420'}
G[1246037]={1208420,'1015:55.63,18.55 N:1208420'}
G[1246206]={1244694,'1015:58.64,53.38 N:1244694'}
G[1246353]={1244694,'1028:82.08,50.44 N:1244694'}
G[1246466]={1248534,'1014[12]:45.80,65.05 N:1248534'}
G[1246555]={1244694,'1032[1]:58.68,34.72 N:1244694'}
G[1246556]={1244694,'1032[1]:47.34,54.63 N:1244694'}
G[1246557]={1244694,'1032[2]:32.09,48.17 N:1244694'}
G[1246558]={1244694,'1032[2]:41.41,32.86 N:1244694'}
G[1246559]={1244694,'1032[2]:57.04,40.18 N:1244694'}
G[1246560]={1244694,'1032[2]:41.47,63.59 N:1244694'}
G[1246561]={1244694,'1032[3]:24.44,9.94 N:1244694'}
G[1246562]={1244694,'1032[3]:17.98,81.04 1032[3]:23.23,81.63 N:1244694'}
G[1248534]={1248534,'1018:53.47,55.96'}
G[1249997]={1244694,'1015:59.88,63.19 N:1244694'}
G[1250080]={1244694,'1015:62.38,58.40 N:1244694'}
G[1250081]={1244694,'1015:62.99,54.17 N:1244694'}
G[1250084]={1244694,'1015:53.68,43.95 N:1244694'}
G[1250091]={1244694,'1015:55.37,27.74 N:1244694'}
G[1250097]={1244694,'1015:50.20,50.29 N:1244694'}
G[1250103]={1244694,'1015:63.64,39.17 N:1244694'}
G[1250104]={1244694,'1015:62.81,44.79 N:1244694'}
G[1250106]={1244694,'1015:47.85,7.73 N:1244694'}
G[1250108]={1244694,'1015:56.89,24.99 N:1244694'}
G[1250536]={1250536,'1017:49.97,32.63'}
G[1250984]={1244694,'1017:72.12,54.88 N:1244694'}
G[1250985]={1208420,'1017:75.15,49.47 N:1208420'}
G[1250987]={1244694,'1017:73.96,52.24 N:1244694'}
G[1250990]={1250990,'1017:75.52,50.78'}
G[1251124]={1251124,'1024[29]:59.46,41.16'}
G[1251425]={1251425,'1018:66.82,75.67'}
G[1251552]={1244694,'1015:65.47,29.56 N:1244694'}
G[1251571]={1251571,'1017:58.55,64.24'}
G[1251713]={1244694,'1017:65.58,57.38 N:1244694'}
G[1251716]={1251716,'1017:42.47,34.08 N:1251716'}
G[1251720]={1244694,'1017:82.40,54.53 N:1244694'}
G[1251723]={1244694,'1017:73.14,45.68 N:1244694'}
G[1251737]={1244694,'1017:50.05,18.17 N:1244694'}
G[1251738]={1208420,'1017:32.07,47.20 N:1208420'}
G[1251761]={1251761,'1017:65.37,43.11'}
G[1251762]={1244694,'1017:49.08,59.99 N:1244694'}
G[1251764]={1244694,'1017:37.20,38.66 N:1244694'}
G[1251772]={1244694,'1017:73.98,58.59 N:1244694'}
G[1251780]={1244694,'1017:43.69,80.10 N:1244694'}
G[1251782]={1244694,'1017:44.98,38.23 N:1244694'}
G[1251820]={1208420,'1017:47.45,34.10 N:1208420'}
G[1251853]={1244694,'1017:75.67,60.60 N:1244694'}
G[1251854]={1244694,'1017:71.93,44.24 N:1244694'}
G[1251856]={1244694,'1017:74.41,41.84 N:1244694'}
G[1251857]={1208420,'1017:78.42,71.39 N:1208420'}
G[1254027]={1244694,'1015:53.62,18.13 N:1244694'}
G[1258690]={1244694,'1015:54.86,52.14 N:1244694'}
G[3234618]={1234618,'948:42.42,26.67 N:1234618'}
G[3243912]={500022,'976:47.08,37.93 A:1243912'}
G[5102700]={102700,'1068[2]:60.43,34.52 A:102700'}
G[5103092]={103092,'1068[1]:81.59,60.22 A:103092'}
G[5106558]={106558,'1076[2]:43.65,38.81 A:106558'}
G[100001307]={100001307,'D:13159 Q:123'}
G[100001357]={100001357,'D:515,126,456,171,513 Q:26353'}
G[100003082]={100003082,'D:1658 Q:25030'}
G[100004854]={100004854,'D:3056 Q:770'}
G[100005179]={100005179,'D:3535 Q:927'}
G[100008244]={100008244,'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25772'}
G[100008623]={100008623,'D:5457,7269,5419 Q:351'}
G[100008704]={100008704,'D:2650,2653,2654,2707,4468,7995,42536,42555,42609 Q:485'}
G[100008705]={100008705,'D:39896 Q:25475'}
G[100009326]={100009326,'D:6212 Q:2945'}
G[100010593]={100010593,'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25771'}
G[100012842]={100012842,'D:10738 Q:28471'}
G[100016303]={100016303,'D:12678 Q:23'}
G[100016304]={100016304,'D:12677 Q:24'}
G[100016305]={100016305,'D:12676 Q:2'}
G[100016408]={100016408,'D:12759 Q:1918'}
G[100016782]={100016782,'D:12876 Q:6922'}
G[100017203]={100017203,'Q:7604'}
G[100018356]={100018356,'Z699 Q:7498'}
G[100018357]={100018357,'Z699 Q:7499'}
G[100018358]={100018358,'Z699 Q:7500'}
G[100018359]={100018359,'Z699 Q:7501'}
G[100018360]={100018360,'Z699 Q:7502'}
G[100018361]={100018361,'Z699 Q:7503'}
G[100018362]={100018362,'Z699 Q:7504'}
G[100018363]={100018363,'Z699 Q:7505'}
G[100018364]={100018364,'Z699 Q:7506'}
G[100018628]={100018628,'D:12944 Q:7604'}
G[100018706]={100018706,'D:1179697 Q:7810'}
G[100018769]={100018769,'Created Q:7649'}
G[100018770]={100018769,'Created Q:7650'}
G[100018771]={100018769,'Created Q:7651'}
G[100018987]={100018987,'D:9046 Q:7761'}
G[100019002]={100019002,'D:11583 Q:7783'}
G[100019003]={100019002,'D:11583 Q:7781'}
G[100019016]={100019016,'D:14347 Q:7785'}	-- TODO: Technically should not be D: since you get it if you have one of two other objects...another thing to think about
G[100019018]={100019018,'D:14435 Q:7787'}
G[100019228]={100019228,'Created Q:7907'}
G[100019257]={100019257,'Created Q:7928'}
G[100019267]={100019267,'Created Q:7929'}
G[100019277]={100019277,'Created Q:7927'}
G[100019423]={100019423,'Created Q:7937'}
G[100019424]={100019424,'Created Q:7938'}
G[100019443]={100019443,'Created Q:7944'}
G[100019452]={100019452,'Created Q:7945'}
G[100019802]={100019802,'Preowned Q:8183'}
G[100020461]={100020461,'D:11732,11730,13136 Q:8308'}
G[100020483]={100020483,'D:15298 Q:8338'}
G[100020644]={100020644,'Preowned Q:8446'}
G[100020741]={100020741,'D:7156,7157,7158 Q:8470'}
G[100020765]={100020765,'D:15968 Q:8482'}
G[100021220]={100021220,'D:15339 Q:8791'}
G[100021221]={100021221,'Z766 Q:8801'}
G[100021230]={100021230,'Z766 Q:8784'}
G[100021776]={100021776,'D:15670 Q:8887'}
G[100022597]={100022597,'D:16314 Q:9175'}
G[100022727]={100022727,'Preowned Q:9250'}
G[100022733]={100022733,'Preowned Q:9251'}
G[100023179]={100023179,'321[1]:46.16,37.49 Q:9324'}	-- this is the location of "Flame of Orgrimmar" that you need to click to get the item
G[100023180]={100023180,'362:21.45,27.02 Q:9325'}	-- this is the location of "Flame of Thunder Bluff" that you need to click to get the item
G[100023181]={100023181,'382:68.25,8.83 Q:9326'}	-- this is the location of "Flame of the Undercity" that you need to click to get the item
G[100023182]={100023182,'301:49.79,72.68 Q:9330'}	-- this is the location of "Flame of Stormwind" that you need to click to get the item
G[100023183]={100023183,'341:64.47,24.94 Q:9331'}	-- this is the location of "Flame of Ironforge" that you need to click to get the item
G[100023184]={100023184,'381:63.99,47.03 Q:9332'}	-- this is the location of "Flame of Darnassus" that you need to click to get the item
G[100023228]={100023228,'D:15409 Q:8474'}
G[100023249]={100023249,'D:15407 Q:9360'}
G[100023338]={100023338,'D:16857 Q:9373'}
G[100023580]={100023580,'D:17084 Q:9418'}
G[100023678]={100023678,'Z464 Q:9455'}
G[100023759]={100023759,'Z464 Q:9514'}
G[100023777]={100023777,'D:6073,6115,11697 Q:26443'}
G[100023797]={100023777,'D:6073,6115,11697 Q:26447'}
G[100023837]={100023837,'Z476 Q:9550'}
G[100023850]={100023850,'Z464 Q:9564'}
G[100023870]={100023870,'Z476 Q:9576'}
G[100023900]={100023900,'D:17528 Q:9594'}
G[100023910]={100023910,'Z464 Q:9616'}
G[100024132]={100024132,'Mailbox476 Q:9672'}	-- moved from Z464
G[100024330]={100024330,'Z467 Q:9731'}
G[100024367]={100024367,'Z727 Q:9764'}
G[100024407]={100024407,'Z467 Q:9875'}
G[100024414]={100024414,'D:16522 Q:9798'}
G[100024483]={100024483,'D:18124 Q:9827'}
G[100024484]={100024483,'D:18124 Q:9828'}
G[100024504]={100024504,'Z477 Q:9861'}
G[100024558]={100024558,'Z477 Q:9872'}
G[100024559]={100024558,'Z477 Q:9871'}
G[100025459]={100025459,'D:18285 Q:9911'}
G[100028552]={100028552,'Z465 Q:10229'}
G[100029233]={100029233,'Z479 Q:10182'}
G[100029234]={100029234,'Z479 Q:10305'}
G[100029235]={100029235,'Z479 Q:10306'}
G[100029236]={100029236,'Z479 Q:10307'}
G[100029476]={100029476,'D:19188 Q:10134'}
G[100029588]={100029588,'Z465 Q:10395'}
G[100029590]={100029588,'Z465 Q:10393'}
G[100030431]={100030431,'D:19995,19998 Q:10524'}
G[100030579]={100030579,'D:21499 Q:10623'}
G[100030756]={100030579,'D:21499 Q:10621'}
G[100031120]={100031120,'Z475 Q:10719'}
G[100031345]={100031345,'Z473 Q:10793'}
G[100031363]={100031363,'Z475 Q:10797'}
G[100031384]={100031384,'Z475 Q:10810'}
G[100031489]={100031489,'Z475 Q:10825'}
G[100031707]={100031707,'Z478 Q:10880'}
G[100031890]={100031890,'Created Q:10938'}
G[100031891]={100031891,'Created Q:10939'}
G[100031907]={100031907,'Created Q:10940'}
G[100031914]={100031914,'Created Q:10941'}
G[100032385]={100032385,'Z779 Q:11002'}
G[100032386]={100032385,'Z779 Q:11003'}
G[100032405]={100032405,'Z782 Q:11007'}
G[100032523]={100032523,'D:23066 Q:11021'}
G[100032621]={100032621,'D:23267 Q:11041'}
G[100032726]={100032726,'D:23286,23324 Q:11081'}
G[100033289]={100033289,'Z491 Q:11237'}
G[100033314]={100033314,'Z491 Q:11249'}
G[100033345]={100033314,'Z491 Q:11260'}
G[100033347]={100033289,'Z491 Q:11266'}
G[100033961]={100033961,'Z491 Q:11395'}
G[100033962]={100033961,'Z491 Q:11398'}
G[100034090]={100034090,'D:24018 Q:11452'}
G[100034091]={100034090,'D:24018 Q:11453'}
G[100034469]={100034469,'Z467 Q:11531'}
G[100034777]={100034777,'Z486 Q:11632'}
G[100034815]={100034815,'Z486 Q:11654'}
G[100034984]={100034984,'Z486 Q:11729'}
G[100035568]={100035568,'480:69.17,43.42 Q:11935'}	-- this is the location of "Flame of Silvermoon" that you need to click to get the item
G[100035569]={100035569,'471:41.12,26.11 Q:11933'}	-- this is the location of "Flame of the Exodar" that you need to click to get the item
G[100035648]={100035648,'Z486 Q:11941'}
G[100035723]={100035723,'Z728 Q:11972'}
G[100036742]={100036742,'Z488 Q:12055'}
G[100036744]={100036744,'Z488 Q:12057'}
G[100036746]={100036742,'Z488 Q:12059'}
G[100036756]={100036756,'Z488 Q:12067'}
G[100036780]={100036780,'Z488 Q:12085'}
G[100036855]={100036855,'Z488 Q:12146'}
G[100036856]={100036855,'Z488 Q:12147'}
G[100036940]={100036940,'D:27546 Q:12105'}
G[100036958]={100036958,'Z488 Q:12168'}
G[100037163]={100037163,'Created Q:12517'}
G[100037164]={100037164,'Created Q:12798'}
G[100037432]={100037432,'Z488 Q:12271'}
G[100037571]={100037736,'Created Q:12278'}
G[100037599]={100037736,'Created Q:12306'}
G[100037736]={100037736,'Created Q:12420'} -- technically bought for 200 tokens
G[100037737]={100037736,'Created Q:12421'} -- technically bought for 200 tokens
G[100037830]={100036940,'Z490 Q:12423'}
G[100037833]={100037833,'Z488 Q:12419'}
G[100038280]={100038280,'Z704 Q:12491'}
G[100038281]={100038280,'Z704 Q:12492'}
G[100038321]={100038321,'D:28034,28035,28036 Q:12507'}
G[100038567]={100038567,'D:4656 Q:14330'}
G[100038660]={100038660,'D:28519 Q:12631'}
G[100038673]={100038673,'D:28519 Q:12633'}
G[100040666]={100040666,'Z492 Q:12839'}
G[100041267]={100041267,'Z495 Q:12888'}
G[100041556]={100041556,'D:29375 Q:12922'}
G[100042203]={100042203,'D:29380 Q:12979'}
G[100042772]={100042772,'Z492 Q:13043'}
G[100043039]={100037163,'Created Q:12517'}
G[100043242]={100043242,'Z492 Q:13136'}
G[100043297]={100043297,'Z492 Q:13148'}
G[100043512]={100043512,'Z522 Q:13204'}
G[100043876]={100043876,'Q13265,13268,13269,13270,13272'}	-- perhaps not related
G[100044148]={100044148,'Created Q:12518'}
G[100044158]={100044158,'Created Q:13311'}
G[100044259]={100044259,'Created Q:13324'}
G[100044276]={100044276,'Created Q:13325'}
G[100044294]={100044294,'Created Q:13327'}
G[100044326]={100044326,'Created Q:13326'}
G[100044569]={100044569,'Z535 Q:13372'}
G[100044577]={100044577,'Z535 Q:13375'}
G[100044725]={100044725,'Z495 Q:13420'}
G[100044927]={100044927,'D:33022 Q:13557'}
G[100044979]={100044979,'D:32863 Q:13506'}
G[100045040]={100045040,'D:32970 Q:13510'}
G[100045506]={100045506,'Z529 Q:13604'}
G[100045857]={100045506,'Z529 Q:13817'}
G[100045858]={100045858,'Created Q:6607,13826'}
G[100046004]={100046004,'Z504 Q:13845'}
G[100046052]={100046052,'Z529 Q:13631'}
G[100046053]={100046052,'A:32871 Q:13819'}
G[100046128]={100046128,'Z43 Q:13868'}
G[100046318]={100046318,'D:32862 Q:13591'}
G[100046544]={100046544,''}
G[100046545]={100046545,''}
G[100046856]={100046856,'Z605 Q:28607'}
G[100046955]={100046955,'Z492 Q:14095'}
G[100047039]={100047039,'D:35095 Q:14127'}
G[100048679]={100048679,'Z504 Q:14203'}
G[100049010]={100049010,'D:4667,4664,4663,4666,4665 Q:14232'}
G[100049200]={100049200,'D:35591 Q:14344'}
G[100049203]={100049010,'D:4667,4664,4663,4666,4665 Q:14362'}
G[100049220]={100049200,'D:35591 Q:14376'}
G[100049643]={100049643,'Z718 Q:24429'}
G[100049644]={100049643,'Z718 Q:24428'}
G[100049667]={100048679,'Z504 Q:24431'}
G[100049676]={100049676,'Z492 Q:24442'}
G[100049776]={100049776,'Z607 Q:24518'}
G[100049932]={100049932,'Z607 Q:24606'}
G[100050320]={100050320,'D:36296 Q:14483,24745'}
G[100050379]={100050379,'Z601 Q:14443'}
G[100050380]={100050379,'Z601 Q:24554'}
G[100051315]={100051315,'Z604 Q:24914'}
G[100052079]={100052079,'D:1535 Q:24979'}
G[100052197]={100052197,'Z640 Q:25047'}
G[100052843]={100052843,'Q:28799,28803,28804'}
G[100053053]={100053053,'D:39918 Q:25377'}
G[100054345]={100054345,'D:40276 Q:25467'}
G[100054614]={100054614,'D:40510 Q:25442'}
G[100054639]={100054639,'D:41183 Q:25503'}
G[100055166]={100055166,'D:39896 Q:25451'}
G[100055167]={100055167,'D:39896 Q:25454'}
G[100055181]={100055181,'D:40905 Q:25647'}
G[100055186]={100055186,'D:41017 Q:25419'}
G[100055243]={100055243,'D:41167 Q:25736'}
G[100056474]={100056474,'D:41937 Q:26016'}
G[100056571]={100056571,'D:41925,41926 Q:26019'}
G[100056812]={100056571,'D:41925,41926 Q:26090'}
G[100056836]={100056836,'Created Q:29396,29397'}
G[100057102]={100057102,'D:41652,41657 Q:26144'}
G[100057118]={100057102,'D:41652,41657 Q:26149'}
G[100057935]={100057935,'D:114 Q:26252'}
G[100058117]={100058117,'D:42677 Q:26296'}
G[100058491]={100058491,'D:1142,1144 Q:26407'}
G[100058898]={100058898,'D:430,445,446 Q:26519'}
G[100059143]={100059143,'D:43454 Q:26617'}
G[100060816]={100060816,'D:43158 Q:27100'}
G[100060956]={100060956,'D:45301,46657 Q:27322'}
G[100061310]={45728,'D:45728 Q:27480'}
G[100061378]={100061378,'D:45867,45868 Q:27551'}
G[100061505]={100061505,'D:45896 Q:27574'}
G[100062021]={100062021,'Created Q:27664'}
G[100062044]={100062044,'Created Q:27666'}
G[100062045]={100062045,'Created Q:27665'}
G[100062046]={100062046,'Created Q:27667'}
G[100062056]={100062056,'Created Q:27675'}
G[100062138]={100062138,'D:40987 Q:27687'}
G[100062281]={100062281,'D:39638,41227 Q:27716'}
G[100062282]={100062281,'D:39638,41227 Q:27717'}
G[100062483]={100062483,'D:46590,46920,47014 Q:27760'}
G[100062768]={100062768,'D:46993 Q:27925,28132'}
G[100062933]={100062933,'D:14636 28:45,30.8 Q:28058'} -- from Pillaclencher's Ornate Pillow
G[100063090]={100063090,'D:47759 Q:28154'}
G[100063127]={100063127,'Q:28798'}
G[100063128]={100063128,'Q:29261,29262'}
G[100063250]={100063250,'D:47789 Q:28196'}
G[100063276]={100062056,'Created Q:27686'}
G[100063686]={100063686,'D:2368,2369,2370,2371 Q:28356'}
G[100063700]={100063700,'D:48428 Q:28376'}
G[100064353]={100064353,'D:10916,7438,7439,7440,7441,7442 Q:28462'}
G[100064397]={100064397,'Q:28800,28801,28802'}
G[100064450]={100064450,'D:48764 Q:28529'}
G[100065894]={100065894,'Z708 Q:28777'}
G[100065895]={100065895,'Z720 Q:28778'}
G[100065896]={100065896,'Z720 Q:28775'}
G[100065897]={100065897,'Z720 Q:28776'}
G[100069854]={100069854,'Mailbox Q:29298'}
G[100071635]={100071635,'Z823'} -- bogus zone just to get it to appear
G[100071636]={100071636,'Z823'} -- bogus zone just to get it to appear
G[100071637]={100071637,'Z823'} -- bogus zone just to get it to appear
G[100071638]={100071638,'Z823'} -- bogus zone just to get it to appear
G[100071715]={100071715,'Z823'} -- bogus zone just to get it to appear
G[100071716]={100071716,'Z823'} -- bogus zone just to get it to appear
G[100071951]={100071951,'Z823'} -- bogus zone just to get it to appear
G[100071952]={100071952,'Z823'} -- bogus zone just to get it to appear
G[100071953]={100071953,'Z823'} -- bogus zone just to get it to appear
G[100074642]={100074642,'Z807 Q:30414'}
G[100074643]={100074643,'Z807 Q:30439'}
G[100074644]={100074644,'Z807 Q:30390'}
G[100074645]={100074645,'Z807 Q:30408'}
G[100074647]={100074647,'Z807 Q:30402'}
G[100074649]={100074649,'Z807 Q:30396'}
G[100074651]={100074651,'Z807 Q:30386'}
G[100074652]={100074652,'Z807 Q:30433'}
G[100074654]={100074654,'Z807 Q:30421'}
G[100074655]={100074655,'Z807 Q:30427'}
G[100077957]={100077957,'D:54590,54968 Q:30105'}
G[100078960]={100078960,'Z806 Q:30140'}
G[100078961]={100078961,'Z806 Q:30141'}
G[100078962]={100078962,'Z806 Q:30139'}
G[100079264]={100079264,'Z807 Q:30422'}
G[100079265]={100079265,'Z807 Q:30425'}
G[100079266]={100079266,'Z807 Q:30424'}
G[100079267]={100079267,'Z807 Q:30423'}
G[100079268]={100079268,'Z807 Q:30389'}
G[100079323]={100079323,'Created Q:30452'}
G[100079326]={100079326,'Created Q:30451'}
G[100080240]={100080240,'Z807 Q:30597'}	-- actually any Pandaria zone
G[100080241]={100080241,'D:59335 Q:30582'}
G[100080827]={100080827,'D:60299 Q:30675'}
G[100082870]={100082870,'D:61970 Q:31023'}
G[100083767]={100083767,'D:56833 Q:29758'}
G[100083769]={100083769,'Mailbox Q:31055'}
G[100083770]={100083770,'Mailbox Q:31093'}
G[100083771]={100083771,'Mailbox Q:31094'}
G[100083772]={100083772,'Mailbox Q:31095'}
G[100083773]={100083773,'Mailbox Q:31097'}
G[100083774]={100083774,'Mailbox Q:31096'}
G[100083777]={100083777,'Mailbox Q:31100'}
G[100083779]={100083779,'Mailbox Q:31102'}
G[100083780]={100083780,'Mailbox Q:31103'}
G[100085477]={100085477,'Created Q:31794'}
G[100085557]={100085557,'Created Q:31795'}
G[100085558]={100085558,'Created Q:31796'}
G[100085783]={100085783,'D:63809 Q:31261'}
G[100086404]={100086404,'D:59639 Q:31312'}
G[100086425]={100086425,'Q:31332'}
G[100086433]={100086433,'D:59119,59121 Q:31325'}	-- TODO: Make this available from the chief one kills as well
G[100086434]={100086434,'D:59119,59121 Q:31326'}
G[100086435]={100086435,'D:59123 Q:31328'}
G[100086436]={100086436,'D:59123 Q:31329'}
G[100086542]={100086542,'Z806 Z807 Z809 Z810 Z811 Z873 Z951 Q:31443'}	-- From Fishing in Jade Forest
G[100086544]={100086544,'Z858 Q:31444'}	-- From Fishing in Dread Wastes
G[100086545]={100086545,'Z857 Q:31446'}	-- From Fishing in Krasarang Wilds
G[100087871]={100087871,'D:65229 Q:31598'}
G[100087878]={100087878,'D:64724 Q:31599'}
G[100088715]={100088715,'D:65502 Q:31677'}
G[100089155]={100089155,'Z806 Q:31784'}
G[100089169]={100089169,'Created Q:31786'}
G[100089170]={100089170,'Created Q:31787'}
G[100089171]={100089171,'Created Q:31788'}
G[100089172]={100089172,'Created Q:31789'}
G[100089173]={100089173,'Created Q:31790'}
G[100089174]={100089174,'Created Q:31791'}
G[100089175]={100089175,'Created Q:31792'}
G[100089176]={100089176,'Created Q:31793'}
G[100089178]={100089178,'Created Q:31797'}
G[100089179]={100089179,'Created Q:31798'}
G[100089180]={100089180,'Created Q:31799'}
G[100089181]={100089181,'Created Q:31800'}
G[100089182]={100089182,'Created Q:31801'}
G[100089183]={100089183,'Created Q:31802'}
G[100089184]={100089184,'Created Q:31803'}
G[100089185]={100089185,'Created Q:31804'}
G[100089209]={100089209,'Created Q:31805'}
G[100089317]={100089317,'D:60491 Q:31809'}
G[100089812]={100089812,'D:58706 Q:31936'}	-- TODO: Need to make a "Buy from" instead of kill :-)
G[100089813]={100089813,'D:58706 Q:31937'}
G[100089814]={100089814,'D:58706 Q:31938'}
G[100091819]={100091819,'Q:32161'}
G[100091821]={100091821,'Q:32162'}
G[100091822]={100091822,'Q:32163'}
G[100091854]={100091819,'D:67881 Q:32164'}
G[100091855]={100091821,'D:67881 Q:32165'}
G[100091856]={100091822,'D:67881 Q:32166'}
G[100092441]={100092441,'Created Q:32295'}
G[100094721]={100094721,'D:69461 Q:32621'}
G[100094862]={100094862,'D:69461 Q:32630'}
G[100095383]={100095383,'Created Q:32686'}
G[100095384]={100095384,'Created Q:32687'}
G[100095385]={100095385,'Created Q:32688'}
G[100095386]={100095386,'Created Q:32689'}
G[100095387]={100095387,'Created Q:32690'}
G[100095388]={100095388,'Created Q:32691'}
G[100095389]={100095389,'Created Q:32692'}
G[100095390]={100095390,'Created Q:32693'}
G[100097979]={100097979,'Q:32838'}
G[100097982]={100097982,'Q:32844'}
G[100097985]={100097985,'D:43929,77789 Q:32850'}
G[100097986]={100097986,'Q:32852'}
G[100097988]={100097988,'Q:32856'}
G[100102225]={100102225,'D:1222684 Q:32974'}
G[100104257]={100104257,'Q:33239'}
G[100104264]={100104264,'Q:33234'}
G[100104265]={100104265,'Q:33235'}
G[100104266]={100104266,'D:72842,72843,72844,73160 Q:33236'}
G[100104267]={100104267,'Q:33238'}
G[100109121]={100109121,'D:77106 Q:34067'}
G[100109258]={100109258,'Q:37669'}
G[100111812]={100111812,'Q:37669'}
G[100111813]={100111813,'Q:37669'}
G[100111814]={100111814,'Q:37669'}
G[100111815]={100111815,'Q:37669'}
G[100111816]={100111816,'Q:37669'}
G[100111817]={100111817,'Q:37669'}
G[100111818]={100111818,'Q:37669'}
G[100112378]={100112378,'D:80714 Q:35021'}
G[100112566]={100113103,'D:74254 Q:35058'}
G[100113080]={100113080,'D:80586 Q:33928'}
G[100113103]={100113103,'D:75043 Q:35342'}
G[100113107]={100113107,'Q:35356'}
G[100113109]={100113109,'Q:35377'}
G[100113260]={100112378,'D:80714 Q:35642'}
G[100113448]={100113448,'D:81528 Q:35811'}
G[100113449]={100113448,'D:81528 Q:35812'}
G[100113453]={100113453,'D:80785 Q:35813'}
G[100113454]={100113453,'D:80785 Q:35814'}
G[100113461]={100113461,'D:81537 Q:35820'}
G[100113586]={100113586,'D:81775 Q:35944'}
G[100113590]={100113586,'D:81775 Q:35948'}
G[100114018]={100114018,'D:81240 Q:36075'}
G[100114019]={100114018,'D:81240 Q:36076'}
G[100114020]={100114020,'D:80685 Q:36078'}
G[100114021]={100114020,'D:80685 Q:36080'}
G[100114022]={100114022,'D:80689 Q:36081'}
G[100114023]={100114022,'D:80689 Q:36083'}
G[100114024]={100114024,'D:80696 Q:36084'}
G[100114025]={100114024,'D:80696 Q:36086'}
G[100114026]={100114026,'D:81617 Q:36090'}
G[100114027]={100114026,'D:81617 Q:36091'}
G[100114029]={100114029,'D:81630 Q:36092'}
G[100114030]={100114029,'D:81630 Q:36094'}
G[100114031]={100114031,'D:85779 Q:36096'}
G[100114032]={100114031,'D:85779 Q:36097'}
G[100114033]={100114033,'D:85695 Q:36098'}
G[100114034]={100114033,'D:85695 Q:36101'}
G[100114035]={100114035,'D:85694 Q:36103'}
G[100114036]={100114035,'D:85694 Q:36104'}
G[100114037]={100114037,'D:83458,81685,80725,78257,86439,85924 Q:36105'}
G[100114038]={100114037,'D:83458,81685,80725,78257,86439,85924 Q:36106'}
G[100114054]={100114054,'Q:36109'}
G[100114877]={100114877,'D:75043 Q:36176'}
G[100114965]={100114965,'D:74254 Q:36205'}
G[100114972]={100114972,'D:75043 Q:36236'}
G[100114973]={100114973,'D:74254 Q:36301'}
G[100114984]={100114984,'D:75043 Q:36239'}
G[100115008]={100115008,'D:74254 Q:36255'}
G[100115278]={100115278,'D:75043 Q:36286'}
G[100115281]={100115008,'D:75043 Q:36308'}
G[100115287]={100115287,'D:74254 Q:36314'}
G[100115343]={100115343,'D:75043 Q:36309'}
G[100115467]={100115467,'D:85199 Q:36385'}
G[100115507]={100115507,'D:75043 Q:36408'}
G[100115593]={100115593,'D:74254 Q:36435'}
G[100116120]={100116120,'948:37.73,56.32'}
G[100116159]={100116159,'D:75207 Q:36502'}
G[100116173]={100116173,'D:74254 Q:36505'}
G[100116395]={100116395,'Q:37290'}
G[100116438]={100116438,'D:74254 Q:36589'}
G[100119208]={100119208,'Mail Q:37322'}
G[100119317]={100119317,'D:82318 Q:37332'}
G[100122224]={100122224,'D:1240616 Q:38089'}
G[100122226]={100122226,'D:1240617 Q:38090'}
G[100122239]={100122239,'D:1240625 Q:38100'}
G[100122399]={100122399,'D:578564,78564 Q:38190'}	-- really sold by...do not kill NPC :-)
G[100122400]={100122404,'D:79774 Q:38179'}
G[100122401]={100122401,'D:578564,78564 Q:38189'}	-- really sold by...do not kill NPC :-)
G[100122402]={100122406,'D:79774 Q:38178'}
G[100122403]={100122399,'D:79774 Q:38177'}
G[100122404]={100122404,'D:578564,78564 Q:38192'}	-- really sold by...do not kill NPC :-)
G[100122405]={100122401,'D:79774 Q:38176'}
G[100122406]={100122406,'D:578564,78564 Q:38191'}	-- really sold by...do not kill NPC :-)
G[100122407]={100122407,'D:578564,78564 Q:38200'}	-- really sold by...do not kill NPC :-)
G[100122408]={100122407,'D:79774 Q:38186'}
G[100122409]={100122409,'D:578564,78564 Q:38199'}	-- really sold by...do not kill NPC :-)
G[100122410]={100122412,'D:578564,78564 Q:38201'}	-- really sold by...do not kill NPC :-)
G[100122411]={100122409,'D:79774 Q:38185'}
G[100122412]={100122412,'D:79774 Q:38187'}
G[100122413]={100122414,'D:79774 Q:38184'}
G[100122414]={100122414,'D:578564,78564 Q:38198'}	-- really sold by...do not kill NPC :-)
G[100122415]={100122415,'D:578564,78564 Q:38197'}	-- really sold by...do not kill NPC :-)
G[100122416]={100122415,'D:79774 Q:38183'}
G[100122417]={100122417,'D:578564,78564 Q:38196'}	-- really sold by...do not kill NPC :-)
G[100122418]={100122417,'D:79774 Q:38182'}
G[100122419]={100122420,'D:79774'}
G[100122420]={100122420,'D:578564,78564'}	-- really sold by...do not kill NPC :-)
G[100122421]={100122422,'D:79774 Q:38181'}
G[100122422]={100122422,'D:578564,78564 Q:38195'}	-- really sold by...do not kill NPC :-)
G[100122423]={100122423,'D:578564,78564 Q:38193'}	-- really sold by...do not kill NPC :-)
G[100122424]={100122423,'D:79774 Q:38180'}
G[100126950]={100126950,'D:92552 Q:38932'}
G[100127989]={100127989,'Q:39278'}
G[100128231]={100128231,'D:94472 Q:39355'}
G[100128232]={100128232,'D:92408 Q:39356'}
G[100128250]={100128250,'D:90974,96014 Q:39358'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100128252]={100128252,'D:90122 Q:39360'}
G[100128255]={100128255,'D:90519 Q:39363'}
G[100128256]={100128256,'D:90284 Q:39364'}	-- TODO: Set up NPC 90284
G[100128257]={100128257,'D:93076 Q:39365'}
G[100128258]={100128258,'D:92647 Q:39366'}
G[100128491]={100128491,'D:90974,96014 Q:39359'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100129747]={100129747,'Q:40168'}	-- TODO: Need to get list of bosses that can drop this
G[100129928]={100129928,'Q:40173'}	-- TODO: Need to get list of bosses that can drop this
G[100133377]={100133377,'Q:40786'}	-- TODO: Need to get list of bosses that can drop this
G[100133378]={100133377,'Q:40787'}	-- TODO: Need to get list of bosses that can drop this
G[200033529]={100046544,''}
G[200033530]={100046545,''}
end

if release >= 19342 then
G[6774]={6774,'864:45.37,49.00'}
end

local N = Grail.npc
for key, value in pairs(Grail.npcs) do
	if value[2] then
		N.locations[key] = {}
		local codeArray = { strsplit(" ", value[2]) }
		local controlCode
		for _, code in pairs(codeArray) do
			controlCode = strsub(code, 1, 1)
			if 'A' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local alias = tonumber(strsub(code, 3))
					if nil ~= alias then
						N.nameIndex[key] = alias
						N.aliases[alias] = N.aliases[alias] or {}
						tinsert(N.aliases[alias], key)
					else
						print("*** NPC processing of",key,"has improper alias")
					end
				end
			elseif 'C' == controlCode then
				tinsert(N.locations[key], { created = true })
			elseif 'D' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.droppedBy[key] = N.droppedBy[key] or {}
					local npcIds = { strsplit(',', strsub(code, 3)) }
					for _, anNPCId in pairs(npcIds) do
						local npcNumber = tonumber(anNPCId)
						if nil ~= npcNumber then
							tinsert(N.droppedBy[key], npcNumber)
							N.has[npcNumber] = N.has[npcNumber] or {}
							tinsert(N.has[npcNumber], key)
						end
					end
				end
			elseif 'H' == controlCode then
				-- the "has" codes are deprecated as we will populate the data based on "drop" codes instead
				if 2 < strlen(code) then
					local subcode = strsub(code, 2, 2)
					if ':' ~= subcode then
						local holidays = N.holiday[key]
						if nil == holidays then
							holidays = ''
						end
						N.holiday[key] = holidays .. subcode
					end
				end
			elseif 'K' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.kill[key] = N.kill[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.kill[key], tonumber(questId))
					end
				end
			elseif 'M' == controlCode then
				local t1 = { mailbox = true }
				if 7 < strlen(code) then
					t1.mapArea = tonumber(strsub(code, 8))
				end
				tinsert(N.locations[key], t1)
			elseif 'N' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local nameIndexToUse = tonumber(strsub(code, 3))
					N.nameIndex[key] = nameIndexToUse
				else
					local t1 = { near = true }
					if 4 < strlen(code) then
						t1.mapArea = tonumber(strsub(code, 5))
					end
					tinsert(N.locations[key], t1)
				end
			elseif 'P' == controlCode then
				-- we do nothing special for "Preowned" at the moment
			elseif 'Q' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.questAssociations[key] = N.questAssociations[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.questAssociations[key], tonumber(questId))
					end
				end
			elseif 'S' == controlCode then
				-- we do nothing special for "Self" at the moment
			elseif 'X' == controlCode then
				N.heroic[key] = true
			elseif 'Z' == controlCode then
				tinsert(N.locations[key], { ["mapArea"]=tonumber(strsub(code, 2)) })
			else	-- a real coordinate
				tinsert(N.locations[key], Grail:_LocationStructure(code))
			end
		end
	end
	if value[3] then N.comment[key] = value[3] end
	if value[4] then N.faction[key] = value[4] end

end
-- TODO: Go through all the Grail.npc.droppedBy values and make sure the locations for the NPCs are added to those keys

Grail.npcs = nil
--	18.84/19.29 idle after a couple minutes at startup without these changes.
--	18.25/18.69	idle after a couple minutes at startup WITH these changes.


end
