local ggf = GottaGoFast;
local constants = ggf.Constants;
local utility = ggf.Utility;
local version = constants.Version;

function GottaGoFast.VersionCheck()
  local lastVersion = ggf.GetVersion(nil);
  utility.DebugPrint("Last Version: " .. lastVersion);
  utility.DebugPrint("Current Version: " .. version);
  if (lastVersion == nil or lastVersion == 0) then
    -- First Time Run
    ggf.VersionFirstRun();
  elseif (lastVersion < 25000) then
    ggf:Print("欢迎来到版本 2.5");
    ggf:Print("新档案已经加入，在回报Bug之前我建议先完全重启您的客户端");
    ggf:Print("历史：你的秘境纪录现在选择性的储存在子插件GottaGoFastHistory，停用它以避免此未来功能");
    ggf:Print("怪物点数：加入了新功能来显示敌方部队的计算。默认为停用");
  elseif (lastVersion < 25200) then
    ggf:Print("个别怪物值：在提示中显示相对敌方部队怪物的数值，默认为启用");
  end
  ggf.SetVersion(nil, version);
end

function GottaGoFast.VersionFirstRun()
  utility.DebugPrint("First Run");
  GottaGoFast.SendHistoryFlag = true;
end
