function GottaGoFast.InitOptions()
  GottaGoFast.LSM = LibStub:GetLibrary("LibSharedMedia-3.0");
  GottaGoFast.LSM:Register("font", "Myriad Condensed Web", "Interface\\Addons\\GottaGoFast\\MyriadCondensedWeb.ttf")
  local defaults = {
    profile = {
      GoldTimer = true,
      TimerType = "TrueTimerMS",
      FrameAnchor = "RIGHT",
      FrameX = 0,
      FrameY = 0,
      TimerAlign = "CENTER",
      TimerX = 0,
      TimerY = 0,
      TimerFont = "Myriad Condensed Web",
      TimerFontSize = 29,
      TimerColor = "ffffffff",
      TimerFontFlag = "OUTLINE",
      ObjectiveAlign = "LEFT",
      ObjectiveX = 0,
      ObjectiveY = -40,
      ObjectiveFont = "Myriad Condensed Web",
      ObjectiveFontSize = 21,
      ObjectiveCollapsed = false,
      ObjectiveColor = "ffffffff",
      ObjectiveCompleteColor = "ff0ff000",
      ObjectiveFontFlag = "OUTLINE",
      IncreaseColor = "ffffffff",
      LevelInTimer = true,
      LevelInObjectives = false,
      AffixesInObjectives = true,
      IncreaseInObjectives = true,
      MobPoints = false,
      IndividualMobValue = true,
      ObjectiveCompleteInObjectives = true,
      History = {},
      DebugMode = false,
      Version = 0,
    },
  }
  local options = {
    name = "GottaGoFast",
    handler = GottaGoFast,
    type = "group",
    args = {
      cms = {
        name = "挑战模式",
        type = "group",
        args = {
          TimerType = {
            order = 1,
            type = "select",
            name = "计时类型",
            desc = "真实计时是从地城开始时不用系统时间定时。\nI 建议您使用此选项。\n暴雪的计时已知有最高达20秒的bug。\nI 将会很快回报细节。",
            values = {["TrueTimerMS"] = "真实计时 (毫秒)", ["TrueTimerNoMS"] = "真实计时 (无毫秒)", ["Blizzard"] = "Blizzard内建计时"},
            get = GottaGoFast.GetTimerType,
            set = GottaGoFast.SetTimerType,
          },
          GoldTimer = {
            order = 2,
            type = "toggle",
            name = "金牌计时",
            desc = "切换是否显示金牌计时",
            get = GottaGoFast.GetGoldTimer,
            set = GottaGoFast.SetGoldTimer,
          },
          LevelInObjectives = {
            order = 3,
            type = "toggle",
            name = "挑战等级显示(目标)",
            desc = "在目标列表显示目前挑战等级",
            get = GottaGoFast.GetLevelInObjectives,
            set = GottaGoFast.SetLevelInObjectives,
          },
          AffixesInObjectives = {
            order = 4,
            type = "toggle",
            name = "词缀显示(目标)",
            desc = "在目标列表显示目前词缀",
            get = GottaGoFast.GetAffixesInObjectives,
            set = GottaGoFast.SetAffixesInObjectives,
          },
          LevelInTimer = {
            order = 5,
            type = "toggle",
            name = "挑战等级显示(计时)",
            desc = "在计时器开头显示目前挑战等级",
            get = GottaGoFast.GetLevelInTimer,
            set = GottaGoFast.SetLevelInTimer,
          },
          IncreaseInObjectives = {
            order = 6,
            type = "toggle",
            name = "钥石升级显示(目标)",
            desc = "奖励钥石计时分离",
            get = GottaGoFast.GetIncreaseInObjectives,
            set = GottaGoFast.SetIncreaseInObjectives,
          },
          ObjectiveCompleteInObjectives = {
            order = 7,
            type = "toggle",
            name = "挑战目标完成显示(目标)",
            desc = "显示我们已经完成的目标时间",
            get = GottaGoFast.GetObjectiveCompleteInObjectives,
            set = GottaGoFast.SetObjectiveCompleteInObjectives,
          },
          MobPoints = {
            order = 8,
            type = "toggle",
            name = "怪物点数",
            desc = "显示用於计算敌方部队百分比的精确点数",
            get = GottaGoFast.GetMobPoints,
            set = GottaGoFast.SetMobPoints,
          },
          IndividualMobValue = {
            order = 9,
            type = "toggle",
            name = "个别怪物值",
            desc = "在提示中显示相对敌方部队的个别怪物数值",
            get = GottaGoFast.GetIndividualMobValue,
            set = GottaGoFast.SetIndividualMobValue,
          }
        }
      },
      displayFrame = {
        name = "显示: 框架",
        type = "group",
        args = {
          unlocked = {
            order = 1,
            type = "toggle",
            name = "不锁定",
            desc = "切换计时器框架锁定状态",
            get = GottaGoFast.GetUnlocked,
            set = GottaGoFast.SetUnlocked,
          },
          ObjectiveCollapsed = {
            order = 2,
            type = "toggle",
            name = "目标追踪器收起",
            desc = "收起目标追踪器当离开挑战模式/时光漫游",
            get = GottaGoFast.GetObjectiveCollapsed,
            set = GottaGoFast.SetObjectiveCollapsed,
          },
          TimerX = {
            order = 3,
            type = "range",
            name = "计时器水平位置",
            desc = "默认: 0",
            min = -100,
            max = 100,
            step = 1,
            get = GottaGoFast.GetTimerX,
            set = GottaGoFast.SetTimerX,
          },
          TimerY = {
            order = 4,
            type = "range",
            name = "计时器垂直位置",
            desc = "默认: 0",
            min = -100,
            max = 100,
            step = 1,
            get = GottaGoFast.GetTimerY,
            set = GottaGoFast.SetTimerY,
          },
          ObjectiveX = {
            order = 5,
            type = "range",
            name = "目标水平位置",
            desc = "默认: 0",
            min = -100,
            max = 100,
            step = 1,
            get = GottaGoFast.GetObjectiveX,
            set = GottaGoFast.SetObjectiveX,
          },
          ObjectiveY = {
            order = 6,
            type = "range",
            name = "目标垂直位置",
            desc = "默认: -40",
            min = -100,
            max = 100,
            step = 1,
            get = GottaGoFast.GetObjectiveY,
            set = GottaGoFast.SetObjectiveY,
          },
          DemoMode = {
            order = 19,
            type = "execute",
            name = "演示模式",
            desc = "显示GottaGoFast示范秘境来演示与设置目的",
            func = GottaGoFast.ToggleDemoMode,
          },
        },
      },
      displayFont = {
        name = "显示: 字体",
        type = "group",
        args = {
          TimerFontSize = {
            order = 7,
            type = "range",
            name = "计时器文字大小",
            desc = "默认: 29",
            min = 8,
            max = 32,
            step = 1,
            get = GottaGoFast.GetTimerFontSize,
            set = GottaGoFast.SetTimerFontSize,
          },
          ObjectiveFontSize = {
            order = 8,
            type = "range",
            name = "目标文字大小",
            desc = "默认: 21",
            min = 8,
            max = 32,
            step = 1,
            get = GottaGoFast.GetObjectiveFontSize,
            set = GottaGoFast.SetObjectiveFontSize,
          },
          TimerFontFlag = {
            order = 9,
            type = "select",
            name = "计时文字样式",
           desc = "默认: 描边",
            values = {["OUTLINE"] = "描边", ["THICKOUTLINE"] = "粗描边", ["MONOCHROME"] = "无消除锯齿", ["NONE"] = "无"},
            get = GottaGoFast.GetTimerFontFlag,
            set = GottaGoFast.SetTimerFontFlag,
          },
          ObjectiveFontFlag = {
            order = 10,
            type = "select",
            name = "目标文字样式",
            desc = "默认: 描边",
            values = {["OUTLINE"] = "描边", ["THICKOUTLINE"] = "粗描边", ["MONOCHROME"] = "无消除锯齿", ["NONE"] = "无"},
            get = GottaGoFast.GetObjectiveFontFlag,
            set = GottaGoFast.SetObjectiveFontFlag,
          },
          TimerAlign = {
            order = 11,
            type = "select",
            name = "计时对齐",
            desc = "默认: 中央",
            values = {["LEFT"] = "左", ["CENTER"] = "中央", ["RIGHT"] = "右"},
            get = GottaGoFast.GetTimerAlign,
            set = GottaGoFast.SetTimerAlign,
          },
          ObjectiveAlign = {
            order = 12,
            type = "select",
            name = "目标对齐",
            desc = "默认: 左",
            values = {["LEFT"] = "左", ["CENTER"] = "中央", ["RIGHT"] = "右"},
            get = GottaGoFast.GetObjectiveAlign,
            set = GottaGoFast.SetObjectiveAlign,
          },
          TimerFont = {
            order = 13,
            type = "select",
            dialogControl = "LSM30_Font",
            name = "计时字体",
            desc = "默认: Arial, Monospaced Fonts like MyriadCondensedWeb are recommended",
            values = GottaGoFast.LSM:HashTable("font"),
            get = GottaGoFast.GetTimerFont,
            set = GottaGoFast.SetTimerFont,
          },
          ObjectiveFont = {
            order = 14,
            type = "select",
            dialogControl = "LSM30_Font",
            name = "目标字体",
            desc = "默认: Arial, Monospaced Fonts like MyriadCondensedWeb are recommended",
            values = GottaGoFast.LSM:HashTable("font"),
            get = GottaGoFast.GetObjectiveFont,
            set = GottaGoFast.SetObjectiveFont,
          },
          ObjectiveColor = {
            order = 15,
            type = "color",
            name = "目标颜色",
            desc = "默认: 白",
            get = GottaGoFast.GetObjectiveColor,
            set = GottaGoFast.SetObjectiveColor,
            hasAlpha = false,
          },
          ObjectiveCompleteColor = {
            order = 16,
            type = "color",
            name = "目标完成颜色",
            desc = "默认: 绿",
            get = GottaGoFast.GetObjectiveCompleteColor,
            set = GottaGoFast.SetObjectiveCompleteColor,
            hasAlpha = false,
          },
          TimerColor = {
            order = 17,
            type = "color",
            name = "计时颜色",
            desc = "默认: 白",
            get = GottaGoFast.GetTimerColor,
            set = GottaGoFast.SetTimerColor,
            hasAlpha = false,
          },
          IncreaseColor = {
            order = 18,
            type = "color",
            name = "钥石升级颜色",
            desc = "默认: 白",
            get = GottaGoFast.GetIncreaseColor,
            set = GottaGoFast.SetIncreaseColor,
            hasAlpha = false,
          },
        },
      },
    },
  };
  GottaGoFast.db = LibStub("AceDB-3.0"):New("GottaGoFastDB", defaults, true);
  LibStub("AceConfig-3.0"):RegisterOptionsTable("GottaGoFast", options);
  GottaGoFast.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("GottaGoFast", "GottaGoFast");
end
