--[[
LibObjectiveProgress: Weight Data
Last Updated: Patch 7.1.0 PTR; 2016-10-13T19:45:42Z

If you would like a copy of this data in a different format for your own purposes or to be informed of future updates:
Contact Simca@Malfurion - either through MMO-Champion, through Curse (MMOSimca), or in-game

You may use this data in any form for any purpose without my permission (though it'd be cool if you gave a shoutout somewhere).
]]--

local LOP = LibStub("LibObjectiveProgress-1.0")
if not LOP then return end


-- Data obtained from Criteria.db2 / CriteriaTree.db2 / Scenario.db2 / ScenarioStep.db2 / Map.db2
function LOP:LoadWeightDataByMap()
    LOP.MapBasedWeights = {
        -- Hall of Valor
        [1477] = {
            {
                [97087] = 1.73913,
                [96611] = 1.73913,
                [96608] = 1.73913,
                [96677] = 1.73913,
                [96640] = 1.73913,
                [95834] = 1.73913,
                [96664] = 1.73913,
                [95832] = 1.73913,
                [95842] = 1.73913,
                [97068] = 4.34783,
                [96574] = 4.34783,
            },
            {
                [95832] = 1.44928,
                [95834] = 1.44928,
                [97068] = 3.62319,
                [96664] = 1.44928,
                [96574] = 3.62319,
                [95842] = 1.44928,
                [96640] = 1.44928,
                [96611] = 1.44928,
                [97087] = 1.44928,
                [96608] = 1.44928,
                [96677] = 1.44928,
            },
        },
        -- Black Rook Hold
        [1501] = {
            {
                [101839] = 1.33333,
                [98691] = 1.33333,
                [98706] = 2,
                [98366] = 1.33333,
                [98368] = 1.33333,
                [101549] = 0.33333,
                [102138] = 3.33333,
                [98275] = 1.33333,
                [98280] = 1.33333,
                [98243] = 1.33333,
                [98677] = 0.33333,
                [98538] = 3.33333,
                [98521] = 3.33333,
                [98813] = 1.33333,
                [98681] = 2,
                [98370] = 1.33333,
            },
            {
                [102095] = 1.11111,
                [98792] = 1.11111,
                [98370] = 1.11111,
                [98900] = 1.11111,
                [98810] = 1.66667,
                [98368] = 1.11111,
                [98366] = 1.11111,
                [98521] = 2.77778,
                [98538] = 2.77778,
                [98677] = 0.27778,
                [98681] = 1.66667,
                [98706] = 1.66667,
                [102788] = 1.11111,
                [98280] = 1.11111,
                [101549] = 0.27778,
                [98275] = 1.11111,
                [98243] = 1.11111,
                [102094] = 1.11111,
                [98691] = 1.11111,
                [101839] = 1.11111,
                [102138] = 2.77778,
                [101923] = 1.11111,
                [98813] = 1.11111,
            },
        },
        -- Eye of Azshara
        [1456] = {
            {
                [106785] = 0.52632,
                [101414] = 1.05263,
                [91796] = 5.26316,
                [97172] = 0.52632,
                [91782] = 5.26316,
                [97170] = 2.10526,
                [97173] = 2.10526,
                [91783] = 2.10526,
                [95861] = 2.10526,
                [95939] = 5.26316,
                [100216] = 2.10526,
                [106787] = 0.52632,
                [106786] = 0.52632,
                [97171] = 5.26316,
                [95920] = 1.05263,
                [99630] = 0.52632,
                [91793] = 0.52632,
                [91792] = 5.26316,
                [99629] = 0.52632,
                [91781] = 2.10526,
                [91794] = 0.52632,
                [91785] = 1.05263,
                [95940] = 0.52632,
            },
            {
                [91783] = 1.75439,
                [95861] = 1.75439,
                [100216] = 1.75439,
                [91782] = 4.38596,
                [91785] = 0.87719,
                [91781] = 1.75439,
                [95920] = 0.87719,
                [97171] = 4.38596,
                [97170] = 1.75439,
                [97173] = 1.75439,
                [97172] = 0.4386,
                [91796] = 4.38596,
                [95947] = 1.75439,
                [95939] = 4.38596,
                [106785] = 0.4386,
                [99629] = 0.4386,
                [106786] = 0.4386,
                [99630] = 0.4386,
                [95940] = 0.4386,
                [91794] = 0.4386,
                [106787] = 0.4386,
                [101414] = 0.87719,
                [91790] = 1.75439,
                [91792] = 4.38596,
                [91793] = 0.4386,
            },
        },
        -- Darkheart Thicket
        [1466] = {
            {
                [95771] = 1.42857,
                [95779] = 3.57143,
                [99358] = 1.42857,
                [101679] = 1.42857,
                [95766] = 1.42857,
                [99359] = 1.07143,
                [99360] = 3.21429,
                [95769] = 1.42857,
                [95772] = 1.42857,
                [100531] = 2.85714,
                [101991] = 1.42857,
                [100526] = 1.42857,
                [100527] = 1.07143,
                [100539] = 1.42857,
                [99365] = 1.42857,
                [99366] = 1.42857,
                [100529] = 0.35714,
            },
            {
                [100527] = 0.89286,
                [99366] = 1.19048,
                [99360] = 2.67857,
                [99358] = 1.19048,
                [100531] = 2.38095,
                [95772] = 1.19048,
                [95766] = 1.19048,
                [95771] = 1.19048,
                [95769] = 1.19048,
                [100539] = 1.19048,
                [101991] = 1.19048,
                [99359] = 0.89286,
                [99365] = 1.19048,
                [101679] = 1.19048,
                [100529] = 0.29762,
                [100526] = 1.19048,
                [95779] = 2.97619,
            },
        },
        -- Vault of the Wardens
        [1493] = {
            {
                [99649] = 5.71429,
                [102583] = 1.90476,
                [99956] = 1.90476,
                [97674] = 1.90476,
                [102584] = 1.90476,
                [100364] = 1.90476,
                [98963] = 0.47619,
                [95771] = 1.90476,
                [96480] = 0.47619,
                [96657] = 5.71429,
                [97677] = 0.47619,
                [96584] = 1.90476,
                [97678] = 3.80952,
                [96587] = 1.90476,
                [98177] = 5.71429,
                [98533] = 4.7619,
                [98926] = 1.90476,
            },
            {
                [96657] = 4.7619,
                [95771] = 1.5873,
                [97674] = 1.5873,
                [102583] = 1.5873,
                [99956] = 1.5873,
                [96587] = 1.5873,
                [99649] = 4.7619,
                [98177] = 4.7619,
                [96584] = 1.5873,
                [98963] = 0.39683,
                [102584] = 1.5873,
                [98533] = 3.96825,
                [98926] = 1.5873,
                [97678] = 3.1746,
                [97677] = 0.39683,
                [96480] = 0.39683,
                [100364] = 1.5873,
            },
        },
        -- Neltharion's Lair
        [1458] = {
            {
                [102404] = 1.81818,
                [91332] = 1.81818,
                [92610] = 1.81818,
                [92351] = 1.81818,
                [91008] = 1.81818,
                [90998] = 1.81818,
                [102253] = 1.81818,
                [102232] = 1.81818,
                [90997] = 1.81818,
                [92350] = 1.81818,
                [91000] = 3.63636,
                [101438] = 1.81818,
                [91006] = 1.81818,
                [105636] = 1.81818,
                [105720] = 1.81818,
                [98406] = 1.81818,
                [102287] = 4.54545,
                [96247] = 0.45455,
                [91001] = 1.81818,
                [102430] = 0.45455,
            },
            {
                [102430] = 0.37879,
                [91332] = 1.51515,
                [102253] = 1.51515,
                [91001] = 1.51515,
                [92351] = 1.51515,
                [102232] = 1.51515,
                [101438] = 1.51515,
                [92610] = 1.51515,
                [92350] = 1.51515,
                [91008] = 1.51515,
                [91006] = 1.51515,
                [102404] = 1.51515,
                [90998] = 1.51515,
                [91000] = 3.0303,
                [105720] = 1.51515,
                [102287] = 3.78788,
                [105636] = 1.51515,
                [90997] = 1.51515,
                [96247] = 0.37879,
                [98406] = 1.51515,
            },
        },
        -- Maw of Souls
        [1492] = {
            {
                [97097] = 2.66667,
                [97043] = 2.66667,
                [99188] = 2.66667,
                [102375] = 2,
                [98919] = 2.66667,
                [97182] = 4,
                [99033] = 2.66667,
                [97185] = 6.66667,
                [97119] = 0.66667,
                [97200] = 2.66667,
                [102104] = 2.66667,
                [97365] = 2.66667,
                [99307] = 8,
                [98973] = 0.66667,
            },
            {
                [98973] = 0.55556,
                [97097] = 2.22222,
                [99033] = 2.22222,
                [97185] = 5.55556,
                [97119] = 0.55556,
                [97182] = 3.33333,
                [102104] = 2.22222,
                [102375] = 1.66667,
                [99188] = 2.22222,
                [97043] = 2.22222,
                [97365] = 2.22222,
                [99307] = 6.66667,
                [97200] = 2.22222,
                [98919] = 2.22222,
            },
        },
        -- Arcway
        [1516] = {
            {
                [98728] = 1.88172,
                [98756] = 1.07527,
                [105617] = 1.07527,
                [105682] = 2.15054,
                [98732] = 0.26882,
                [105651] = 1.07527,
                [98759] = 1.07527,
                [105876] = 0.26882,
                [102351] = 0.26882,
                [105915] = 1.07527,
                [105921] = 1.07527,
                [105706] = 2.15054,
                [98425] = 1.07527,
                [106059] = 1.07527,
                [98733] = 1.07527,
                [105952] = 1.6129,
                [98770] = 1.07527,
                [105629] = 0.26882,
            },
            {
                [98728] = 1.56951,
                [105921] = 0.89686,
                [105629] = 0.22422,
                [98732] = 0.22422,
                [106059] = 0.89686,
                [98759] = 0.89686,
                [105706] = 1.79372,
                [105651] = 0.89686,
                [98756] = 0.89686,
                [105682] = 1.79372,
                [105617] = 0.89686,
                [105876] = 0.22422,
                [98770] = 0.89686,
                [102351] = 0.22422,
                [98425] = 0.89686,
                [105952] = 1.34529,
                [98733] = 0.89686,
                [105915] = 0.89686,
            },
        },
        -- Court of Stars
        [1571] = {
            {
                [105705] = 2.5,
                [105704] = 2.5,
                [104247] = 2.5,
                [104246] = 2.5,
                [111563] = 2.5,
                [104270] = 5,
                [105703] = 0.625,
                [105699] = 1.875,
                [104251] = 2.5,
                [104277] = 2.5,
                [104295] = 0.625,
                [105715] = 2.5,
                [104278] = 6.25,
                [104300] = 2.5,
            },
            {
                [105704] = 2.08333,
                [104251] = 2.08333,
                [104270] = 4.16667,
                [104277] = 2.08333,
                [104278] = 5.20833,
                [104246] = 2.08333,
                [104247] = 2.08333,
                [105703] = 0.52083,
                [105705] = 2.08333,
                [105715] = 2.08333,
                [105699] = 1.5625,
                [111563] = 2.08333,
                [104300] = 2.08333,
                [104295] = 0.52083,
            },
        },
    }
end


-- Data obtained from QuestObjective.db2 (filtered on Type=0 and Flags&0x64 in order to eliminate non-NPCs and things without progress bars)
function LOP:LoadWeightDataByQuest()
    LOP.QuestBasedWeights = {
        [35637] = {
            [85260] = 0.2,
            [85261] = 1,
            [85265] = 2,
            [82531] = 2.94118,
            [85262] = 7.69231,
            [85263] = 20,
        },
        [35641] = {
            [85260] = 0.2,
            [85261] = 1,
            [85265] = 2,
            [82531] = 2.94118,
            [85262] = 7.69231,
            [85263] = 20,
        },
        [35974] = {
            [85726] = 10,
            [85728] = 2.94118,
            [85727] = 2,
            [83800] = 1,
            [85729] = 0.2994,
        },
        [35977] = {
            [85726] = 10,
            [85728] = 2.94118,
            [85727] = 2,
            [83800] = 1,
            [85729] = 0.2994,
        },
        [36069] = {
            [84010] = 1,
            [88960] = 0.1,
            [83990] = 25,
            [83975] = 4,
            [83980] = 4,
            [83983] = 4,
            [83976] = 2.94118,
            [83982] = 2.94118,
            [83984] = 2.94118,
        },
        [36070] = {
            [84010] = 1,
            [88960] = 0.1,
            [83990] = 25,
            [83975] = 4,
            [83980] = 4,
            [83983] = 4,
            [83976] = 2.94118,
            [83982] = 2.94118,
            [83984] = 11.11111,
        },
        [36338] = {
            [85197] = 0.2,
            [85000] = 1,
            [85195] = 2.94118,
            [85200] = 25,
            [84754] = 2.22222,
            [83856] = 2,
            [84279] = 2,
            [85370] = 10,
            [84997] = 2.94118,
            [85393] = 1,
            [85103] = 2.94118,
        },
        [36347] = {
            [85079] = 0.2,
            [85319] = 1,
            [81542] = 1.2987,
            [84945] = 2.94118,
            [84908] = 5,
            [81543] = 6.25,
            [85321] = 25,
        },
        [36348] = {
            [85079] = 0.2,
            [85319] = 1,
            [81542] = 1.2987,
            [84945] = 2.94118,
            [84908] = 5,
            [81543] = 6.25,
            [85321] = 25,
        },
        [36383] = {
            [85228] = 1,
            [85229] = 5,
            [85230] = 20,
            [86298] = 0.5,
        },
        [36489] = {
            [85228] = 1,
            [85229] = 5,
            [85230] = 20,
            [86298] = 0.5,
        },
        [36490] = {
            [86556] = 0.5,
            [85609] = 1,
            [85607] = 2.5,
            [85608] = 5,
            [85610] = 7.69231,
            [85611] = 11.11111,
            [85037] = 20,
            [85452] = 0.001,
        },
        [36491] = {
            [86556] = 0.5,
            [85609] = 1,
            [85607] = 2.5,
            [85608] = 5,
            [85610] = 7.69231,
            [85611] = 11.11111,
            [85037] = 20,
            [85452] = 0.001,
        },
        [36807] = {
            [87378] = 0.2994,
            [87370] = 1,
            [87371] = 2.94118,
            [87377] = 20,
            [87373] = 2.94118,
            [87364] = 1.49254,
            [86869] = 0.74627,
            [86599] = 4,
            [88407] = 2.94118,
            [88405] = 2,
        },
        [36808] = {
            [85197] = 0.2,
            [85000] = 1,
            [85195] = 2.94118,
            [85200] = 25,
            [84754] = 2.22222,
            [83856] = 2,
            [84279] = 2,
            [85370] = 10,
            [84997] = 2.94118,
            [85393] = 1,
            [85103] = 2.94118,
        },
        [36809] = {
            [87378] = 0.2994,
            [87370] = 1,
            [87372] = 2.94118,
            [87377] = 20,
            [87373] = 2.94118,
            [87364] = 1.49254,
            [86869] = 2.94118,
            [86599] = 4,
            [88407] = 2.94118,
            [88405] = 2,
        },
        [36811] = {
            [90660] = 0.5,
            [90659] = 1.49254,
            [103176] = 2.5,
            [90662] = 25,
            [90663] = 25,
            [106629] = 25,
        },
        [36814] = {
            [88278] = 0.25,
            [88174] = 1,
            [88175] = 5,
            [88176] = 20,
        },
        [36815] = {
            [88278] = 0.25,
            [88174] = 1,
            [88175] = 5,
            [88176] = 20,
        },
        [36816] = {
            [87640] = 1,
            [87642] = 4,
            [87644] = 7.69231,
            [87645] = 14.28571,
            [87646] = 16.66667,
            [88116] = 4,
        },
        [36817] = {
            [87640] = 1,
            [87642] = 4,
            [87644] = 7.69231,
            [87645] = 14.28571,
            [87646] = 16.66667,
            [88116] = 4,
        },
        [36818] = {
            [86955] = 1,
            [86957] = 2.94118,
            [86958] = 7.69231,
            [87574] = 14.28571,
            [86960] = 20,
            [86992] = 5.88235,
            [87017] = 5.88235,
            [87024] = 5.88235,
            [86947] = 2,
            [87264] = 2,
        },
        [36819] = {
            [86955] = 1,
            [86957] = 2.94118,
            [86958] = 7.69231,
            [87574] = 14.28571,
            [86960] = 20,
            [86992] = 5.88235,
            [87017] = 5.88235,
            [87024] = 5.88235,
            [86947] = 2,
            [87264] = 2,
        },
        [36820] = {
            [88200] = 4,
            [88201] = 7.69231,
            [88202] = 11.11111,
            [88203] = 25,
            [88204] = 50,
            [88931] = 4,
        },
        [36821] = {
            [88200] = 4,
            [88201] = 7.69231,
            [88202] = 11.11111,
            [88203] = 25,
            [88204] = 50,
            [88931] = 4,
        },
        [36822] = {
            [87624] = 0.74627,
            [87610] = 1.49254,
            [87618] = 5,
            [87621] = 14.28571,
            [84384] = 20,
            [88860] = 2,
        },
        [36823] = {
            [87624] = 0.74627,
            [87610] = 1.49254,
            [87618] = 5,
            [87621] = 14.28571,
            [84384] = 20,
            [88860] = 2,
        },
        [36826] = {
            [87507] = 0.2,
            [87513] = 1,
            [87514] = 2,
            [87512] = 4,
            [87511] = 14.28571,
            [87742] = 20,
            [87510] = 2,
            [87333] = 2.94118,
        },
        [36827] = {
            [87507] = 0.2,
            [87513] = 1,
            [87513] = 2,
            [87512] = 4,
            [87511] = 14.28571,
            [87742] = 20,
            [87510] = 2,
            [87333] = 2.94118,
        },
        [36860] = {
            [87030] = 0.5,
            [87031] = 0.5,
            [87032] = 0.5,
            [87033] = 0.5,
            [88256] = 0.001,
            [87034] = 1,
            [87036] = 2,
            [86558] = 4,
            [86559] = 2.94118,
            [87037] = 0.5,
            [87038] = 0.5,
            [86560] = 2,
            [88260] = 5,
            [89095] = 0.5,
            [87029] = 25,
            [87026] = 25,
            [87019] = 25,
            [86621] = 25,
            [87027] = 25,
        },
        [37466] = {
            [91287] = 1,
            [91284] = 2.94118,
            [91285] = 6.66667,
            [91286] = 10,
            [91449] = 4,
        },
        [37495] = {
            [90109] = 2.5,
            [89097] = 14.28571,
            [112018] = 4,
        },
        [37585] = {
            [87624] = 0.74627,
            [87610] = 1.49254,
            [87618] = 5,
            [87621] = 14.28571,
            [84384] = 20,
            [88860] = 2,
        },
        [37622] = {
            [87624] = 0.74627,
            [87610] = 1.49254,
            [87618] = 5,
            [87621] = 14.28571,
            [84384] = 20,
            [88860] = 2,
        },
        [37623] = {
            [85260] = 0.4,
            [85261] = 2,
            [85265] = 4,
            [82531] = 5.88235,
            [85262] = 11.11111,
            [85263] = 25,
        },
        [37624] = {
            [85260] = 0.4,
            [85261] = 2,
            [85265] = 4,
            [82531] = 5.88235,
            [85262] = 11.11111,
            [85263] = 25,
        },
        [37625] = {
            [87507] = 0.2,
            [87513] = 1,
            [87514] = 2,
            [87512] = 4,
            [87511] = 14.28571,
            [87742] = 20,
            [87510] = 2.94118,
            [87333] = 2.94118,
        },
        [37626] = {
            [87507] = 0.2,
            [87513] = 1,
            [87513] = 2,
            [87512] = 4,
            [87511] = 14.28571,
            [87742] = 20,
            [87510] = 2.94118,
            [87333] = 2.94118,
        },
        [37627] = {
            [87640] = 1,
            [87642] = 4,
            [87644] = 7.69231,
            [87645] = 14.28571,
            [87646] = 16.66667,
            [88116] = 4,
        },
        [37628] = {
            [87640] = 1,
            [87642] = 4,
            [87644] = 7.69231,
            [87645] = 14.28571,
            [87646] = 16.66667,
            [88116] = 4,
        },
        [37629] = {
            [86955] = 1,
            [86957] = 2.94118,
            [86958] = 7.69231,
            [87574] = 14.28571,
            [86960] = 20,
            [86992] = 5.88235,
            [87017] = 5.88235,
            [87024] = 5.88235,
            [86947] = 2,
            [87264] = 2,
        },
        [37630] = {
            [86955] = 1,
            [86957] = 2.94118,
            [86958] = 7.69231,
            [87574] = 14.28571,
            [86960] = 20,
            [86992] = 5.88235,
            [87017] = 5.88235,
            [87024] = 5.88235,
            [86947] = 2,
            [87264] = 2,
        },
        [37631] = {
            [85079] = 0.2,
            [85319] = 1,
            [81542] = 1.2987,
            [84945] = 2.94118,
            [84908] = 5,
            [81543] = 6.25,
            [85321] = 25,
        },
        [37632] = {
            [85079] = 0.2,
            [85319] = 1,
            [81542] = 1.2987,
            [84945] = 2.94118,
            [84908] = 5,
            [81543] = 6.25,
            [85321] = 25,
        },
        [37633] = {
            [85726] = 14.28571,
            [85728] = 4.34783,
            [85727] = 2.94118,
            [83800] = 1.49254,
            [85729] = 0.44843,
        },
        [37634] = {
            [85726] = 14.28571,
            [85728] = 4.34783,
            [85727] = 2.94118,
            [83800] = 1.49254,
            [85729] = 0.44843,
        },
        [37635] = {
            [85197] = 0.2,
            [85000] = 1,
            [85195] = 2.94118,
            [85200] = 25,
            [84754] = 2.22222,
            [83856] = 2,
            [84279] = 2,
            [85370] = 10,
            [84997] = 2.94118,
            [85393] = 1,
            [85103] = 2.94118,
        },
        [37636] = {
            [85197] = 0.2,
            [85000] = 1,
            [85195] = 2.94118,
            [85200] = 25,
            [84754] = 2.22222,
            [83856] = 2,
            [84279] = 2,
            [85370] = 10,
            [84997] = 2.94118,
            [85393] = 1,
            [85103] = 2.94118,
        },
        [37779] = {
            [89025] = 4,
            [89803] = 5,
            [89802] = 10,
            [89808] = 5,
            [89811] = 2,
        },
        [37865] = {
            [90048] = 2.94118,
            [90047] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 14.28571,
            [90122] = 14.28571,
            [90087] = 25,
            [90024] = 10,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [37866] = {
            [90048] = 2.94118,
            [90047] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 14.28571,
            [90122] = 14.28571,
            [90087] = 25,
            [90024] = 10,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [37921] = {
            [90025] = 2,
            [89951] = 5.88235,
            [93147] = 5.88235,
            [93174] = 5.88235,
            [91596] = 10,
        },
        [37938] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [90777] = 10,
            [91262] = 1,
            [95236] = 1,
        },
        [37963] = {
            [91094] = 0.74627,
            [90468] = 7.69231,
            [90467] = 2.94118,
            [90469] = 10,
        },
        [37965] = {
            [90480] = 2.94118,
            [90537] = 10,
            [90648] = 1,
            [90547] = 20,
            [90542] = 20,
            [90541] = 10,
        },
        [37966] = {
            [90478] = 1,
            [90302] = 2.94118,
            [90425] = 2,
            [90501] = 2.94118,
            [91817] = 10,
            [92544] = 5.88235,
            [92597] = 5,
        },
        [37970] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [89675] = 10,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
            [92647] = 10,
        },
        [38009] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [90777] = 10,
            [91262] = 1,
            [95236] = 1,
        },
        [38020] = {
            [90478] = 1,
            [90302] = 2.94118,
            [90425] = 2,
            [90501] = 2.94118,
            [91817] = 10,
            [92544] = 5.88235,
            [92597] = 5,
        },
        [38040] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [38043] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [38051] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [90868] = 7.69231,
            [93036] = 10,
        },
        [38054] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [93036] = 7.69231,
            [90868] = 10,
        },
        [38204] = {
            [88200] = 4,
            [88201] = 7.69231,
            [88202] = 11.11111,
            [88203] = 25,
            [88204] = 50,
            [88931] = 4,
        },
        [38205] = {
            [88200] = 4,
            [88201] = 7.69231,
            [88202] = 11.11111,
            [88203] = 25,
            [88204] = 50,
            [88931] = 4,
        },
        [38343] = {
            [89759] = 2,
            [91384] = 1,
            [91575] = 2,
            [91424] = 2,
            [91926] = 2,
            [92040] = 10,
            [97445] = 2,
            [97443] = 2,
            [93377] = 2,
            [93005] = 2.94118,
        },
        [38372] = {
            [91121] = 2.94118,
            [91122] = 2.94118,
            [91598] = 2.94118,
            [91182] = 4,
            [96932] = 2,
            [94207] = 2.94118,
            [94208] = 2.94118,
            [92180] = 4,
            [91130] = 4,
        },
        [38374] = {
            [92238] = 1,
            [92239] = 2,
            [92240] = 2.94118,
            [92241] = 5,
            [96992] = 10,
            [100474] = 14.28571,
        },
        [38409] = {
            [91565] = 1,
        },
        [38439] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
            [92647] = 10,
            [89675] = 10,
        },
        [38442] = {
            [96248] = 1,
            [96249] = 2,
            [96250] = 2.94118,
            [96251] = 5,
        },
        [38569] = {
            [90025] = 2,
            [89951] = 5.88235,
            [93147] = 5.88235,
            [93174] = 5.88235,
            [91596] = 10,
        },
        [38587] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 2.94118,
            [92411] = 7.69231,
            [92408] = 7.69231,
            [91009] = 7.69231,
            [92274] = 14.28571,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [92002] = 1,
            [91098] = 7.69231,
        },
        [38588] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 2.94118,
            [92411] = 7.69231,
            [92408] = 7.69231,
            [91009] = 7.69231,
            [92274] = 10,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [92002] = 1,
            [91098] = 7.69231,
        },
        [38708] = {
            [92939] = 1,
            [92958] = 4,
            [92959] = 7.69231,
        },
        [38716] = {
            [93067] = 2.94118,
            [92954] = 2.94118,
            [93061] = 2.94118,
            [92963] = 7.69231,
            [92965] = 7.69231,
            [92966] = 7.69231,
            [91839] = 5,
            [95247] = 5,
            [93031] = 14.28571,
            [94974] = 7.69231,
            [92971] = 7.69231,
            [95430] = 2.94118,
            [91860] = 2.94118,
        },
        [38748] = {
            [93074] = 5,
            [93169] = 5.88235,
            [93159] = 10,
            [93111] = 5,
            [112052] = 5,
        },
        [38842] = {
            [93389] = 2.94118,
            [99008] = 4,
            [93444] = 5,
            [94572] = 1,
        },
        [38865] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [93036] = 7.69231,
            [90868] = 10,
        },
        [38866] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [93036] = 7.69231,
            [90868] = 10,
        },
        [38868] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [91262] = 1,
            [95236] = 1,
        },
        [38869] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [91262] = 1,
            [95236] = 1,
        },
        [38870] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [38871] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [38876] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
        },
        [38877] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
        },
        [38939] = {
            [93941] = 1,
            [93942] = 2,
            [93943] = 2.94118,
            [93944] = 5,
            [94211] = 10,
        },
        [39029] = {
            [94205] = 5.88235,
            [94204] = 5.88235,
            [110896] = 11.11111,
        },
        [39119] = {
            [94401] = 1,
            [94402] = 2,
            [94403] = 2.94118,
            [94404] = 5,
            [94405] = 10,
        },
        [39274] = {
            [95013] = 4,
            [94687] = 2.94118,
            [96124] = 4,
            [99406] = 7.69231,
        },
        [39279] = {
            [94651] = 1,
            [95226] = 2.5,
            [96400] = 4,
            [97142] = 5,
        },
        [39317] = {
            [94983] = 5,
            [94986] = 10,
            [95174] = 5,
            [95204] = 10,
        },
        [39371] = {
            [95270] = 5,
            [95310] = 5,
        },
        [39393] = {
            [95747] = 5,
            [97799] = 5,
            [98089] = 1,
            [98087] = 2.94118,
            [98088] = 5,
            [95319] = 5,
            [95320] = 5,
        },
        [39424] = {
            [95290] = 7.69231,
            [96361] = 7.69231,
        },
        [39441] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [39442] = {
            [90855] = 1,
            [90704] = 2.94118,
            [89706] = 2.94118,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 11.11111,
            [93028] = 4,
        },
        [39443] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [93036] = 7.69231,
            [90868] = 10,
        },
        [39444] = {
            [90867] = 1,
            [93035] = 2,
            [90371] = 2.94118,
            [90337] = 4,
            [93014] = 4,
            [93036] = 7.69231,
            [90868] = 10,
        },
        [39445] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
        },
        [39446] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 14.28571,
            [93034] = 2.94118,
        },
        [39447] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [91262] = 1,
            [95236] = 1,
        },
        [39448] = {
            [90303] = 0.1,
            [90706] = 2.94118,
            [90789] = 2.94118,
            [90300] = 2.94118,
            [90620] = 1,
            [90782] = 10,
            [89686] = 5,
            [90950] = 10,
            [92451] = 25,
            [90265] = 6.66667,
            [91068] = 8.33333,
            [93334] = 7.69231,
            [91262] = 1,
            [95236] = 1,
        },
        [39449] = {
            [90478] = 1,
            [90302] = 2.94118,
            [90425] = 2,
            [90501] = 2.94118,
            [91817] = 10,
            [92544] = 5.88235,
            [92597] = 5,
        },
        [39450] = {
            [90478] = 1,
            [90302] = 2.94118,
            [90425] = 2,
            [90501] = 2.94118,
            [91817] = 10,
            [92544] = 5.88235,
            [92597] = 5,
        },
        [39451] = {
            [90048] = 2.94118,
            [90047] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 14.28571,
            [90122] = 14.28571,
            [90087] = 25,
            [90024] = 10,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [39452] = {
            [90048] = 2.94118,
            [90047] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 14.28571,
            [90122] = 14.28571,
            [90087] = 25,
            [90024] = 10,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [39453] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 2.94118,
            [92411] = 7.69231,
            [92408] = 7.69231,
            [91009] = 7.69231,
            [92274] = 14.28571,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [92002] = 1,
            [91098] = 7.69231,
        },
        [39454] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 2.94118,
            [92411] = 7.69231,
            [92408] = 7.69231,
            [91009] = 7.69231,
            [92274] = 10,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [92002] = 1,
            [91098] = 7.69231,
        },
        [39576] = {
            [108014] = 10,
            [96287] = 5,
            [108009] = 2.5,
            [96588] = 14.28571,
            [98957] = 10,
            [104733] = 10,
            [96021] = 14.28571,
        },
        [39742] = {
            [97969] = 2.94118,
            [97970] = 5,
            [100326] = 10,
            [96783] = 20,
        },
        [39998] = {
            [97945] = 0.5,
            [97946] = 1,
            [97947] = 2,
            [97948] = 2.94118,
            [97949] = 5,
        },
        [40050] = {
            [97919] = 5,
            [97933] = 10,
            [98311] = 10,
        },
        [40111] = {
            [98492] = 2,
            [98493] = 2.94118,
            [98494] = 5,
            [98495] = 10,
        },
        [40121] = {
            [98585] = 1,
            [98749] = 2,
        },
        [40226] = {
            [102949] = 5,
            [102948] = 2.94118,
            [102947] = 1,
        },
        [40316] = {
            [94386] = 5,
            [94196] = 5,
            [94152] = 5,
            [95693] = 10,
            [94153] = 5,
            [104531] = 5.88235,
        },
        [40895] = {
            [102250] = 7.69231,
            [102523] = 11.11111,
        },
        [40896] = {
            [102251] = 7.69231,
        },
        [40925] = {
            [102406] = 2,
            [102407] = 14.28571,
        },
        [40951] = {
            [98653] = 6.66667,
            [102827] = 6.66667,
        },
        [40978] = {
            [96146] = 10,
            [97449] = 10,
        },
        [40979] = {
            [102691] = 7.69231,
            [97165] = 10,
            [102452] = 14.28571,
        },
        [40981] = {
            [102542] = 2.94118,
        },
        [40984] = {
            [102542] = 2.94118,
        },
        [40985] = {
            [102542] = 4,
            [102214] = 14.28571,
        },
        [41013] = {
            [102623] = 10,
        },
        [41024] = {
            [102251] = 7.69231,
            [102736] = 2.94118,
        },
        [41025] = {
            [102251] = 7.69231,
        },
        [41026] = {
            [102251] = 7.69231,
        },
        [41122] = {
            [103150] = 14.28571,
            [103173] = 7.69231,
            [103174] = 4,
        },
        [41127] = {
            [103177] = 2,
            [103196] = 2,
            [103234] = 10,
            [103227] = 5,
            [103178] = 5.88235,
            [104690] = 14.28571,
            [102633] = 5,
            [102634] = 7.69231,
            [104691] = 14.28571,
        },
        [41144] = {
            [95148] = 7.69231,
            [95013] = 7.69231,
            [96124] = 7.69231,
            [94687] = 4,
        },
        [41227] = {
            [103650] = 7.69231,
        },
        [41257] = {
            [103651] = 7.69231,
        },
        [41308] = {
            [103837] = 5,
            [103851] = 14.28571,
        },
        [41417] = {
            [103992] = 1,
        },
        [41420] = {
            [103650] = 7.69231,
        },
        [41421] = {
            [103651] = 7.69231,
        },
        [41623] = {
            [97796] = 2,
            [97808] = 5.88235,
            [98757] = 11.11111,
        },
        [41705] = {
            [104614] = 14.28571,
            [104615] = 7.69231,
            [104624] = 12.5,
            [104660] = 25,
        },
        [41706] = {
            [104590] = 7.69231,
            [104582] = 5.88235,
            [104589] = 4,
        },
        [41757] = {
            [96021] = 14.28571,
            [96287] = 5.88235,
            [96397] = 5.88235,
            [98957] = 7.69231,
            [104733] = 14.28571,
        },
        [41896] = {
            [105365] = 2,
            [105366] = 5,
            [105781] = 25,
        },
        [41925] = {
            [89759] = 7.69231,
            [91384] = 4,
            [91575] = 7.69231,
            [91424] = 7.69231,
            [91926] = 10,
            [92040] = 14.28571,
            [97445] = 7.69231,
            [97443] = 7.69231,
            [91948] = 25,
            [93005] = 20,
            [91657] = 14.28571,
        },
        [41927] = {
            [98429] = 4,
            [98432] = 7.69231,
            [98433] = 14.28571,
            [98434] = 20,
        },
        [41930] = {
            [97945] = 2.94118,
            [97946] = 7.69231,
            [97947] = 14.28571,
            [97948] = 20,
            [97949] = 25,
        },
        [41961] = {
            [93067] = 7.69231,
            [92954] = 7.69231,
            [93061] = 7.69231,
            [92963] = 14.28571,
            [92965] = 14.28571,
            [92966] = 14.28571,
            [91839] = 11.11111,
            [95247] = 7.69231,
            [93031] = 14.28571,
            [94974] = 7.69231,
            [92971] = 14.28571,
            [95430] = 5.88235,
            [91860] = 5.88235,
            [108941] = 16.66667,
        },
        [41992] = {
            [93155] = 5.88235,
            [97337] = 7.69231,
            [97338] = 2.94118,
            [92989] = 14.28571,
        },
        [42004] = {
            [105718] = 5,
        },
        [42013] = {
            [105746] = 7.69231,
            [105748] = 5.88235,
            [105532] = 4,
            [105751] = 20,
            [105749] = 7.69231,
        },
        [42018] = {
            [91094] = 2.94118,
            [90468] = 7.69231,
            [90467] = 5.88235,
            [90469] = 14.28571,
            [105947] = 4,
            [105950] = 5.88235,
            [105961] = 7.69231,
        },
        [42019] = {
            [89025] = 5.88235,
            [89803] = 7.69231,
            [89802] = 25,
            [89808] = 10,
            [89811] = 4,
        },
        [42022] = {
            [91287] = 2.94118,
            [91284] = 5.88235,
            [91285] = 7.69231,
            [91286] = 25,
            [106105] = 5.88235,
        },
        [42023] = {
            [106650] = 2,
        },
        [42025] = {
            [110585] = 5,
        },
        [42027] = {
            [90660] = 4,
            [90659] = 5.88235,
            [103176] = 7.69231,
            [90662] = 25,
        },
        [42028] = {
            [105793] = 20,
            [105902] = 7.69231,
            [105826] = 7.69231,
            [105823] = 5.88235,
            [105807] = 4,
        },
        [42070] = {
            [103650] = 7.69231,
        },
        [42082] = {
            [105554] = 7.69231,
            [105585] = 4,
            [105613] = 6.66667,
        },
        [42087] = {
            [105823] = 5.88235,
            [105826] = 7.69231,
            [106067] = 0.5,
        },
        [42111] = {
            [100271] = 7.69231,
            [100273] = 11.11111,
            [100274] = 14.28571,
            [106374] = 2.94118,
        },
        [42174] = {
            [97796] = 2,
            [97808] = 5.88235,
            [98757] = 11.11111,
        },
        [42277] = {
            [107384] = 2.94118,
            [107383] = 7.69231,
            [107381] = 11.11111,
            [107382] = 14.28571,
        },
        [42373] = {
            [95290] = 5.88235,
            [96361] = 5.88235,
        },
        [42431] = {
            [99223] = 4,
            [107258] = 2,
            [107455] = 1,
            [107454] = 7.69231,
        },
        [43183] = {
            [103651] = 7.69231,
        },
        [43241] = {
            [92383] = 4,
            [95951] = 4,
            [106842] = 1,
            [109796] = 5.88235,
            [110032] = 5,
            [110423] = 20,
        },
        [43247] = {
            [103650] = 7.69231,
        },
        [43248] = {
            [103651] = 7.69231,
        },
        [43336] = {
            [92383] = 5.88235,
            [95951] = 5.88235,
            [106842] = 1.49254,
            [110423] = 20,
        },
        [43483] = {
            [110671] = 2,
            [110486] = 25,
        },
        [43583] = {
            [110933] = 2.94118,
            [111020] = 5.88235,
            [113704] = 2,
        },
        [43598] = {
            [103650] = 7.69231,
        },
        [43599] = {
            [103651] = 7.69231,
        },
        [43600] = {
            [103650] = 7.69231,
        },
        [43601] = {
            [103651] = 7.69231,
        },
        [43932] = {
            [111910] = 5.88235,
            [111911] = 10,
        },
        [43964] = {
            [112134] = 1,
            [112135] = 5,
            [112136] = 10,
            [112137] = 20,
        },
        [44049] = {
            [111479] = 14.28571,
            [111456] = 4,
            [111469] = 2,
        },
        [44054] = {
            [112446] = 1,
            [112447] = 2.94118,
            [112448] = 5,
            [112449] = 1,
            [112450] = 10,
        },
        [44737] = {
            [115025] = 5.88235,
            [115031] = 5,
            [115026] = 2,
            [115739] = 5,
            [115751] = 25,
        },
        [44744] = {
            [115089] = 7.69231,
            [115090] = 5,
        },
        [44780] = {
            [115383] = 2.94118,
            [115384] = 7.69231,
            [115385] = 11.11111,
        },
        [44823] = {
            [116315] = 10,
        },
        [44857] = {
            [106765] = 14.28571,
            [106764] = 10,
        },
        [44867] = {
            [115961] = 7.69231,
            [115962] = 11.11111,
        },
        [44892] = {
            [115679] = 4,
            [115677] = 2,
            [115665] = 4,
            [115669] = 10,
            [115673] = 14.28571,
            [115927] = 7.69231,
        },
        [44893] = {
            [115680] = 4,
            [115678] = 2,
            [115663] = 4,
            [115667] = 10,
            [115671] = 14.28571,
            [115925] = 7.69231,
        },
        [44894] = {
            [115681] = 4,
            [115675] = 2,
            [115666] = 4,
            [115670] = 10,
            [115674] = 14.28571,
            [115922] = 7.69231,
        },
        [44895] = {
            [115682] = 4,
            [115676] = 2,
            [115664] = 4,
            [115668] = 10,
            [115672] = 14.28571,
            [115917] = 7.69231,
        },
        [44938] = {
            [116159] = 2.94118,
        },
        [45307] = {
            [100998] = 5,
            [102913] = 10,
            [100999] = 5,
        },
    }
end
