#!/bin/bash

uninstall_type=$1
showtip=$2

#color
close="\033[0m"
red="\033[1;31m"
green="\033[1;32m"
yellow="\033[1;33m"
#display width
all_width=100


#0 uninstall
#1 clean install
if [ -z $uninstall_type ];then
	uninstall_type=0
fi

#0 no show
#1 show wait for install
if [ -z $showtip ];then
	showtip=0
fi


function output_ok()
{
	len=$(($all_width-${#1}))
	string=$green"%"$len"s"$close"\n"
	printf $string "[ok]"
}

function output_fail()
{
	len=$(($all_width-${#1}+3))
	string=$red"%"$len"s"$close"\n"
	printf $string "[error]"
}

#####################################################################################
#		uninstall start
#####################################################################################
#check user
userid=`id -u`
if [ "$?" == "0" -a "$userid" != "0" ];then
	echo  -e  $red"Permission denied!You need 'root' privilege to uninstall this software!"$close
	exit 1
fi


runDir=`pwd`
scriptDir=`dirname $0`
cd $scriptDir
#echo "This script is used to remove NginxSafeog!"
echo

if [ "$showtip" == "1" ];then
	read -p "Are you sure to remove NginxSafedog?[Y/n]" remove
	if [ "$remove" != "Y" ] && [ "$remove" != "y" ];then
		exit 0
	fi
fi

uduninstall=""
#get LONG_BIT.
longbit=`getconf LONG_BIT`
if [ "$?" == "0" -a "$longbit" == "32" ];then
	ln_libpath="/usr/lib"
else
	if [ -d "/usr/lib64" ];then
		ln_libpath="/usr/lib64"
	else
		ln_libpath="/usr/lib"
	fi			
fi

lib_path="/etc/safedog/libs/nginx"

if [ "$?" == "0" -a "$longbit" == "32" ];then
	uduninstall="sdauduninstall NF-7400LN"
else	
	uduninstall="sdauduninstall NF-7400LN64"
fi


###########################################################################
#
if [ ! -f /etc/nginxsd.conf ];then
	echo  -e  $red"Nginx defense module do not install,exit."$close
	if [ "$uninstall_type" == "0" ];then
		exit 1
	fi
fi


#stop nginx
install_log="stop nginx server..."
echo -n -e $install_log

stop_ret=1
nginx_pid=`ps -ef | grep sbin/nginx | grep master | awk '{print $2}'`
if [ ! -z $nginx_pid ];then
	kill -QUIT $nginx_pid
fi

nginx_pid=`ps -ef | grep nginx | grep worker | tail -1 |awk '{print $2}'`
if [ ! -z $nginx_pid ];then
	killall nginx
	sleep 1
fi


output_ok "$install_log"

###########################################################################
#get configure

nginx_installdir=`cat /etc/nginxsd.conf | grep "NginxInstallPath"|awk -F = '{print $2}'`
installdir=`grep InstallDir /etc/nginxsd.conf`
installdir=${installdir#*InstallDir=}

#restort nginx.bak to nginx
bak_nginx=$installdir"/backup/nginx.bak"
cur_nginx=$nginx_installdir"sbin/nginx"

bak_nginx_conf=$installdir"/backup/nginx.conf.bak"
cur_nginx_conf=$nginx_installdir"conf/nginx.conf"

###########################################################################
install_log="restore nginx.bak to nginx..."
echo -n -e $install_log

#remove safedog nginx configure
if [ -f $bak_nginx_conf ];then
	find_ret=`cat $cur_nginx_conf | grep "#safedog nginx configure begin"`
	if [ ! -z "$find_ret" ];then
		sed -i '/#safedog nginx configure begin.*;/d' $cur_nginx_conf
		sed -i '0,/limit_rate .*;/{/limit_rate .*;/d}' $cur_nginx_conf
		sed -i '0,/limit_conn_zone $binary_remote_addr zone=addr:10m.*;/{/limit_conn_zone $binary_remote_addr zone=addr:10m.*;/d}' $cur_nginx_conf
		sed -i '0,/limit_conn .*;/{/limit_conn .*;/d}' $cur_nginx_conf
		sed -i '/#safedog nginx configure end.*;/d' $cur_nginx_conf
	fi
fi	

if [ -f $bak_nginx ];then
	rm  -f  $cur_nginx
	mv  $bak_nginx  $cur_nginx
	output_ok  "$install_log"
else
	#echo "can not find $installdir/backup/nginx.bak, exit uninstall..."
	output_fail  "$install_log"
	if [ "$uninstall_type" == "0" ];then
		exit 1
	fi	
fi
###########################################################################
#remove library
install_log="remove file of Nginx Defense Module..."
echo -n -e $install_log

if [ -d $installdir ];then
	rm -rf $installdir
#	echo "remove nginx safedog's install directory ok!"
fi

logdir=/var/log/nginxsd
if [ -d $logdir ];then
	rm -rf $logdir
#	echo "remove log ok!"
fi


conf=/etc/nginxsd.conf
if [ -f $conf ];then
	rm -f $conf
#	echo "remove configure file ok!"
fi

$uduninstall  >/dev/null 2>&1


chattr -i $lib_path/libnginx_safedog_plugin.so.0.0.0
rm -f 	$lib_path/libnginx_safedog_plugin.so.0.0.0
rm -f 	$ln_libpath/libnginx_safedog_plugin.so.0
rm -f  $ln_libpath/libnginx_safedog_plugin.so


if [ ! -d "/etc/ApacheSafeDog" ];then
	killall sdalog>/dev/null 2>&1
	sdmonitor -k sdacm >/dev/null 2>&1
	killall sdacm>/dev/null 2>&1

	rm -f /etc/rc2.d/S99sdaboot
	rm -f /etc/rc3.d/S99sdaboot
	rm -f /etc/rc4.d/S99sdaboot
	rm -f /etc/rc5.d/S99sdaboot
	rm -f /etc/rc6.d/S99sdaboot
	rm -f /etc/init.d/sdaboot
	rm -f /usr/bin/sdaboot
	
	rm -f /usr/bin/sdacm
	rm -f /etc/safedog/nginx/bin/sdacm
	rm -f /usr/bin/sdalog
	rm -f /etc/safedog/nginx/bin/sdalog
	rm -f /usr/bin/sdaudinstall
	rm -f /etc/safedog/nginx/bin/sdaudinstall
	rm -f /usr/bin/sdauduninstall	
	rm -f /etc/safedog/nginx/bin/sdauduninstall:
	
	chattr -i  $lib_path/libSPModule.so.0.0.0 2>/dev/null
	rm -f  $lib_path/libSPModule.so.0.0.0
	rm -f  $ln_libpath/libSPModule.so.0
	rm -f  $ln_libpath/libSPModule.so
	
	chattr -i  $lib_path/libWPCPlugin.so.0.0.0 2>/dev/null
	rm -f  $lib_path/libWPCPlugin.so.0.0.0
	rm -f  $ln_libpath/libWPCPlugin.so.0
	rm -f  $ln_libpath/libWPCPlugin.so
	
	rm -f $ln_libpath/libQtNetwork.so
	rm -f $ln_libpath/libQtNetwork.so.4 
	rm -f $ln_libpath/libboost_regex.so
	rm -f $ln_libpath/libboost_regex.so.1.49.0
	rm -f $ln_libpath/libboost_filesystem.so
	rm -f $ln_libpath/libboost_filesystem.so.1.49.0
	rm -f $ln_libpath/libboost_system.so
	rm -f $ln_libpath/libboost_system.so.1.49.0
	rm -f $ln_libpath/libboost_thread.so
	rm -f $ln_libpath/libboost_thread.so.1.49.0
	rm -f $ln_libpath/libluajit-5.1.so.2
	rm -f $ln_libpath/libluajit-5.1.so
	
	rm -rf $lib_path
	
fi
#echo "remove bin and library ok!"

output_ok  "$install_log"

############################################################
#start the nginx server
############################################################
install_log="start nginx server..."
echo -e -n  "$install_log" 

start_ret=1

nginx_startcmd=$nginx_installdir"sbin/nginx"
$nginx_startcmd 2> /dev/null
sleep 5
start_ret=$?

if [ $start_ret != 0 ];then
	output_fail "$install_log"
	echo -e $red"please start nginx server by youself."$close
else
	output_ok	"$install_log"
	echo -e $green"uninstall nginx defense module succeed.."$close
fi

