#!/bin/bash
#Program:
#		This script is used to install NginxSafeDog module.



VERSION="2.4"


#step num
nowstep=$1
allstep=$2
showtype=$3
silent_install=$4


if [ -z $nowstep ];then
	nowstep=10
fi

if [ -z $allstep ];then
	allstep=10
fi

#0 no show
#1 show wait for install
if [ -z $showtype ];then
	showtype=1
fi

# 1: silent install
if [ -z $silent_install ];then
	silent_install=0
fi

mainstep="step "$nowstep"/"$allstep
childstep="step "$nowstep


#display width
all_width=100
#main step width
main_width=3
#"   step 9.1, "
child_width=$(($main_width+${#childstep}+4))
#color
close="\033[0m"
red="\033[1;31m"
green="\033[1;32m"
yellow="\033[1;33m"
#space
main_space="\033[${main_width}G"
child_space="\033[${child_width}G"


$g_NginxPath
$g_NginxConfPath
$g_NginxExePath
$g_NginxExeName
$g_ExistNginx
$g_ExistNginxService
$g_NginxStartCmd
$g_NginxStopCmd
$g_NginxReloadCmd
$g_NginxVersion

#the function is used to check whether the command was excuted successfully.
function checkcmd()
{
	if [ "$?" != "0" ];then
		output_fail $install_log
	#		exit 1
	fi
}
function GetPid()
{
	test $# -ne 1 && return 1
	prog=$1
	pids=$(ps aux|grep $prog|grep -v grep|awk '{print $2}')
	test -z "$pids" && return 2 || return 0
}

function output_ok()
{
	len=$(($all_width-${#1}))
	string=$green"%"$len"s"$close"\n"
	printf $string "[ok]"
}

function output_fail()
{
	len=$(($all_width-${#1}+3))
	string=$red"%"$len"s"$close"\n"
	printf $string "[error]"
	
	echo -e  $main_space$red"Sorry! Install nginx defense module failed!"$close
	clean_install
	exit
}

function output_warn()
{
	len=$(($all_width-${#1}+2))
	string=$yellow"%"$len"s"$close"\n"
	printf $string "[warn]"
}

#check Nginx
function check_Nginx()
{
	g_ExistNginx="false"

	#"checking nginx process"
	for progname in nginx/sbin/nginx
	do 			
		g_NginxExePath=`ps -ef | grep $progname | grep master | awk '{print $11}'`
		if [ ! -z $g_NginxExePath ];then
			g_ExistNginx="true"
		fi
	done	
	
	#get nginx dir
	if [ "$g_ExistNginx" == "true" ];then
		g_NginxPath=${g_NginxExePath%%/sbin*}
		#check conf and sbin dir
		if [ ! -d $g_NginxPath"/conf" ] || [ ! -d $g_NginxPath"/sbin" ]; then
			#no exist
			g_NginxPath=""
			g_ExistNginx="false"
			return -1
		fi
		
		g_NginxReloadCmd=$g_NginxExePath" -s reload"
		g_NginxExeName="nginx"	
	fi
}

function wait_for_install()
{	
	local log
	log=$1
	
	a=10;
	while [ $a != 0 ]
	do
		echo -n -e "\r"$log", install Nginx Defend Module in "$a" seconds,please enter \"CTRL+c\" to skip.  "
		let "a--"
		sleep 1
	done
	
	echo -e -n	"\r"$log", start install Nginx Defend Module..."
	printf "%40s\n" ""
}

function clean_install()
{
	./uninstall.sh 1 >/dev/null 2>&1
}

function is_support_module()
{
	local check_module
	check_module=$1

	for mod in nginx_upstream_jvm_route ngx_cache_purge ngx_http_substitutions_filter_module nginx-upstream-jvm-route lua-nginx-module nginx_upstream_check_module nginx-backtrace ngx_http_accounting_module nginx-limit-upstream testcookie-nginx-module 
	do
		#str=${check_module##*"/"}
		str=${check_module}
		find_ret=`echo $str | grep $mod`
		if [ ! -z $find_ret ];then
			return 1
		fi
	done

	#echo 'no support module:'$check_module
	return 0
}

function backup_oldconfig_to_new()
{
    local old_install_dir=/etc/NginxSafedog;
	if [ -d $old_install_dir ];then
	  if [ -d $old_install_dir/conf ];then
		cp -r -f $old_install_dir/conf $SafeDogInstallDir
		checkcmd
	  fi
	  if [ -d $old_install_dir/GeneralConfig ];then
		cp -r -f $old_install_dir/GeneralConfig $SafeDogInstallDir
		checkcmd
	  fi
	  if [ -d $old_install_dir/Analysis ];then
		cp -r -f $old_install_dir/Analysis $SafeDogInstallDir
		checkcmd
	  fi
	  if [ -d $old_install_dir/backup ];then
		cp -r -f $old_install_dir/backup	$SafeDogInstallDir/
		checkcmd
	  fi
	  if [ -f $old_install_dir/yours.db ];then
		cp -f $old_install_dir/yours.db $SafeDogInstallDir/yours.db
		checkcmd
	  fi
	  rm -rf $old_install_dir
	  checkcmd
    fi
}

##############################################################################################
##############################################################################################
#start install

runDir=`pwd`
scriptDir=`dirname $0`
cd $scriptDir

#installed apache,exit
if [ -f "/etc/apachesd.conf" ];then
	echo -e  $main_space$red"Sorry! you have installed apache Defense module, Can not install nginx Defense module again..."$close
	exit
fi

#check start install
cp -a -f ./dependpkg/bin/sdaudinstall  ./
chmod +x  ./sdaudinstall
./sdaudinstall "10" "check"  >/dev/null 2>&1
ret=$?
if [ "$ret" == "2" ];then
	echo -e  $main_space$red"Version error! Can not install..."$close
	exit
fi


check_Nginx

if [ $g_ExistNginx == "true" ];then
	echo 
	echo -e		$mainstep",  start install Nginx Defense Module.."
else
	echo
	
	#silent install,get nginx failed then exit
	if [ "$silent_install" == "1" ];then
		exit
	fi
	
	if [ "$showtype" == "1" ];then
		echo -e	-n	$mainstep",  will you need to install Nginx Defense Module?"
		read -p 	"[Y/n]:"  IsInstallNginx
	
		if [ "$IsInstallNginx" != "Y" ] && [ "$IsInstallNginx" != "y" ];then
			echo -e  $red"Nginx defense module is not installed, try to reinstall separately by entering: ./install.py -n"$close
			exit
		fi
	else
		echo -e		$mainstep",  start install Nginx Defense Module.."
	fi
fi

#let user input Nginx install path.
#:||:<<\READDIR
input_num=2

if [ ! -z $g_NginxPath ]; then
	installlog=$main_space$childstep".1, Nginx path:"$g_NginxPath	
	if [ "$showtype" == "1" ];then
		wait_for_install "$installlog"
	else
		echo -e $installlog
	fi
else
	echo -e 		$main_space$childstep".1, input Nginx install path: [enter \"CTRL+c\" to exit]"
	echo -e 		$child_space"For example:/usr/local/nginx"
	echo -e -n		$child_space		
	read -p 	"Please input the absolute path:" g_NginxPath
	while [ ! -d "$g_NginxPath" ]
	do
		if [ "$input_num" == "0" ];then
			echo -e $child_space$red"Error:install nginx defense module failed!"$close
			exit
		fi
		
		echo -e 		$child_space$yellow"Warn: the path you inputted is not exist!"$close
		echo -e -n		$child_space
		read -p "Please input the absolute path:" g_NginxPath
		
		input_num=$(($input_num-1))
	done
	
#check conf sbin
	if [ ! -d $g_NginxPath"/conf" ] || [ ! -d $g_NginxPath"/sbin" ]; then
		echo -e $child_space$red"Error: cann't not find sbin or conf directory!"$close
		exit	
	fi
	
	g_ExistNginx="true"
	g_NginxExeName="nginx"
	g_NginxExePath=$g_NginxPath"/sbin/nginx"
	g_NginxReloadCmd=$g_NginxExePath" -s reload"	

fi

#################################################################################################
#check add module
#get  nginx version
$g_NginxExePath -V 2> /tmp/sd_tmp

#add module more than 3,exit
add_module_num=`grep -o "\-\-add-module=" /tmp/sd_tmp | wc -l`
if [ $add_module_num -gt 10 ];then
	echo -e  $child_space$red"\nSorry! exist the nonsupported module of nginx, exit install!"$close
	exit	
fi

tmp_str=`cat /tmp/sd_tmp | grep "configure"| grep "\-\-add-module"`
tmp_str=${tmp_str#*"--add-module="}
rm -rf /tmp/sd_tmp

while [ ! -z "$tmp_str" ]
do
	add_module=`echo $tmp_str | awk  '{print $1}'`
	is_support_module "$add_module"
	if [ $? -eq 0 ];then
		echo -e  $child_space$red"\nSorry! exist the nonsupported module of nginx, exit install!"$close
		exit
	fi
	
   tmp_str=${tmp_str#*$add_module}
   find_tmp_str=${tmp_str#*"--add-module="}
   if [ "$tmp_str" == "$find_tmp_str" ];then
		tmp_str=""
   else
		tmp_str=$find_tmp_str
   fi
#   echo "tmp_str string:"$tmp_str
done	

#################################################################################################
#stop nginx
stop_ret=1
waitseconds=2

nginx_pid=`ps -ef | grep nginx/sbin/nginx | grep master | awk '{print $2}'`
if [ ! -z $nginx_pid ];then
	kill -QUIT $nginx_pid
fi

nginx_pid=`ps -ef | grep nginx | grep worker | tail -1 | awk '{print $2}'`
if [ ! -z $nginx_pid ];then
	killall nginx
	sleep 1
fi

sleep $waitseconds

#################################################################################################
install_log=$childstep".2, copy libraries"
echo -e -n $main_space"$install_log"
#READDIR
#install path 
SafeDogInstallDir=/etc/safedog/nginx
if [ ! -d $SafeDogInstallDir ];then 
	mkdir -p $SafeDogInstallDir
	checkcmd
fi
chmod 755 $SafeDogInstallDir
checkcmd

SafeDogLogDir=/etc/safedog/logs
if [ ! -d $SafeDogLogDir ];then
	mkdir -p $SafeDogLogDir
	checkcmd
fi
chmod 755 $SafeDogLogDir
checkcmd

SafeDogBinDir=/etc/safedog/nginx/bin
if [ ! -d $SafeDogBinDir ]; then
	mkdir -p $SafeDogBinDir
	checkcmd
fi

#create necessary directory and file
if [ ! -d $SafeDogInstallDir/Analysis ];then 
	mkdir -p $SafeDogInstallDir/Analysis
	checkcmd
fi
chmod 777 $SafeDogInstallDir/Analysis
checkcmd
cp -f ./SynSvr.dat $SafeDogInstallDir/Analysis/
checkcmd
chmod 666 $SafeDogInstallDir/Analysis/SynSvr.dat
checkcmd
cp -f ./uninstall.sh $SafeDogInstallDir/
checkcmd


#set path information to nginxsd.conf 
echo "InstallDir=$SafeDogInstallDir">/etc/nginxsd.conf
echo "SDConfPath=$SafeDogConfPath">>/etc/nginxsd.conf
echo "NginxInstallPath=$g_NginxPath/">>/etc/nginxsd.conf  
echo "NginxReloadCmd=$g_NginxReloadCmd">>/etc/nginxsd.conf


#get  nginx version
$g_NginxExePath -v 2> /tmp/sdinstall_tmp
g_NginxVersion=` cat /tmp/sdinstall_tmp | grep 'nginx version' |awk -F'/' '{print $2}' | awk -F'.' '{print $1"."$2}'`
rm -rf /tmp/sdinstall_tmp
if [ -z "$g_NginxVersion" ];then
	echo -e  $child_space$red"\nSorry! get Nginx version failed,exit install!"$close
	clean_install
	exit
fi

#get nginx bit
nginx_bit=`file $g_NginxExePath | awk '{print $3}'| awk -F "-" '{print $1}'`
if [ "$nginx_bit" != "32" ] || [ "$nginx_bit" != "64" ]; then
	nginx_bit=`file $g_NginxExePath | awk '{print $3}'| awk -F "-" '{print $1}'`
fi

#detect the library path.
longbit=`getconf LONG_BIT`
if [ "$?" == "0" -a "$longbit" == "32" ];then
	ln_libpath="/usr/lib"
else
	if [ -d "/usr/lib64" ];then
		ln_libpath="/usr/lib64"
	else
		ln_libpath="/usr/lib"
	fi			
fi

libpath="/etc/safedog/libs/nginx"
if [ ! -d $libpath ];then
	mkdir -p $libpath
	checkcmd
fi

#echo "library path:$libpath"

#NginxSafeDog configure file monitor
if [ ! -d $SafeDogInstallDir"/conf" ];then
	cp -r -f ./dependpkg/conf $SafeDogInstallDir
	checkcmd
fi

#must update configure file
cp -r -f ./dependpkg/conf/WPCDefTrojan.conf $SafeDogInstallDir"/conf"
checkcmd
cp -r -f ./dependpkg/conf/WPCBackGroundProtect.conf $SafeDogInstallDir"/conf"
checkcmd
cp -r -f ./dependpkg/conf/WPCThreadControl.conf $SafeDogInstallDir"/conf"
checkcmd

#echo "copy configuration file ok!"
cp -r -f ./dependpkg/GeneralConfig $SafeDogInstallDir
checkcmd
#echo "copy GeneralConfig file ok!"
chmod 644 ./dependpkg/db/*.db
checkcmd
cp -f ./dependpkg/db/*.db $SafeDogInstallDir
checkcmd
#echo "copy db file ok!"
#echo "copy define_page"
chmod 644 ./dependpkg/define_page/*
checkcmd
cp -r -f ./dependpkg/define_page  $SafeDogInstallDir
checkcmd
#echo "copy define_page ok"


#creat log directory
logdir=/var/log/nginxsd
if [ ! -e $logdir ];then
	mkdir /var/log/nginxsd
	checkcmd
fi


#copy dynamic libraries to $libpath
chmod +x ./dependpkg/lib/*
checkcmd
cp -f ./dependpkg/lib/libnginx_safedog_plugin.so.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libSPModule.so.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libWPCPlugin.so.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libQtCore.so.4.7.4 $libpath
checkcmd
cp -f ./dependpkg/lib/libQtNetwork.so.4.7.4 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_regex.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_filesystem.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_system.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_thread.so.1.49.0 $libpath
checkcmd
#if [ ! -f $libpath/libpcre.so.0.0.1 ];then
#	cp -f ./dependpkg/lib/libpcre.so.0.0.1 	$libpath
#fi
if [ ! -f $ln_libpath/libssl.so.6 ];then
	cp -f ./dependpkg/lib/libssl.so.6	 $libpath
	ln -s $libpath/libssl.so.6 $ln_libpath/libssl.so.6
fi
if [ ! -f $ln_libpath/libcrypto.so.6 ];then
	cp -f ./dependpkg/lib/libcrypto.so.6	 $libpath
	ln -s $libpath/libcrypto.so.6 $ln_libpath/libcrypto.so.6
fi
if [ ! -f $ln_libpath/libluajit-5.1.so.2 ];then
	cp -f ./dependpkg/lib/libluajit-5.1.so.2.1.0	 $libpath
fi

ln -s -f $libpath/libnginx_safedog_plugin.so.0.0.0 $ln_libpath/libnginx_safedog_plugin.so >/dev/null
checkcmd
ln -s -f $libpath/libnginx_safedog_plugin.so.0.0.0 $ln_libpath/libnginx_safedog_plugin.so.0 >/dev/null
checkcmd
ln -s -f $libpath/libSPModule.so.0.0.0 $ln_libpath/libSPModule.so >/dev/null
checkcmd
ln -s -f $libpath/libSPModule.so.0.0.0 $ln_libpath/libSPModule.so.0 >/dev/null
checkcmd
ln -s -f $libpath/libWPCPlugin.so.0.0.0 $ln_libpath/libWPCPlugin.so >/dev/null
checkcmd
ln -s -f $libpath/libWPCPlugin.so.0.0.0 $ln_libpath/libWPCPlugin.so.0 >/dev/null
checkcmd
ln -s -f $libpath/libQtCore.so.4.7.4 $ln_libpath/libQtCore.so >/dev/null
checkcmd
ln -s -f $libpath/libQtCore.so.4.7.4 $ln_libpath/libQtCore.so.4 >/dev/null
checkcmd
ln -s -f $libpath/libQtNetwork.so.4.7.4 $ln_libpath/libQtNetwork.so >/dev/null
checkcmd
ln -s -f $libpath/libQtNetwork.so.4.7.4 $ln_libpath/libQtNetwork.so.4 >/dev/null
checkcmd
ln -s -f $libpath/libboost_regex.so.1.49.0 $ln_libpath/libboost_regex.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_regex.so.1.49.0 $ln_libpath/libboost_regex.so.1.49.0 > /dev/null
checkcmd
ln -s -f $libpath/libboost_filesystem.so.1.49.0 $ln_libpath/libboost_filesystem.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_filesystem.so.1.49.0 $ln_libpath/libboost_filesystem.so.1.49.0 >/dev/null
checkcmd
ln -s -f $libpath/libboost_system.so.1.49.0 $ln_libpath/libboost_system.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_system.so.1.49.0 $ln_libpath/libboost_system.so.1.49.0 >/dev/null
checkcmd
ln -s -f $libpath/libboost_thread.so.1.49.0 $ln_libpath/libboost_thread.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_thread.so.1.49.0 $ln_libpath/libboost_thread.so.1.49.0 >/dev/null
checkcmd

#if [ ! -f $ln_libpath/libpcre.so.1 ];then
#	ln -s -f $libpath/libpcre.so.0.0.1	$ln_libpath/libpcre.so.1 >/dev/null
#fi
#checkcmd
if [ ! -f $ln_libpath/libluajit-5.1.so.2 ];then
	ln -s -f $libpath/libluajit-5.1.so.2.1.0 $ln_libpath/libluajit-5.1.so.2 >/dev/null
fi
checkcmd
if [ ! -f $ln_libpath/libluajit-5.1.so ];then
	ln -s -f $libpath/libluajit-5.1.so.2.1.0 $ln_libpath/libluajit-5.1.so >/dev/null
fi
checkcmd


#echo "copy dynamic libraries ok!"
output_ok "$install_log"

#########################################################################################
install_log=$childstep".3, copy bin and set boot"
echo -e -n  $main_space"$install_log"
#copy bin and set boot
chmod +x ./dependpkg/bin/*
checkcmd
chmod +x ./dependpkg/script/*
checkcmd


cp -a -f ./dependpkg/bin/sdacm $SafeDogBinDir
ln -s -f $SafeDogBinDir/sdacm  /usr/bin/sdacm
checkcmd

cp -a -f ./dependpkg/bin/sdalog $SafeDogBinDir
ln -s -f $SafeDogBinDir/sdalog /usr/bin/sdalog
checkcmd

cp -a -f ./dependpkg/bin/sdaudinstall $SafeDogBinDir
ln -s -f $SafeDogBinDir/sdaudinstall /usr/bin/sdaudinstall
checkcmd

cp -a -f ./dependpkg/bin/sdauduninstall $SafeDogBinDir
ln -s -f $SafeDogBinDir/sdauduninstall /usr/bin/sdauduninstall
checkcmd

#cp -a -f ./dependpkg/script/sdaboot /etc/init.d
#checkcmd
rm -f /etc/rc2.d/S99sdaboot
checkcmd
rm -f /etc/rc3.d/S99sdaboot
checkcmd
rm -f /etc/rc4.d/S99sdaboot
checkcmd
rm -f /etc/rc5.d/S99sdaboot
checkcmd
#if [ -d /etc/rc2.d ]; then
#	ln -s -f /etc/init.d/sdaboot /etc/rc2.d/S99sdaboot >/dev/null
#else 
#	if [ -d /etc/rc.d/rc2.d ]; then
#		ln -s -f /etc/init.d/sdaboot /etc/rc.d/rc2.d/S99sdaboot >/dev/null
#	fi
#fi
#checkcmd
#if [ -d /etc/rc3.d ]; then
#	ln -s -f /etc/init.d/sdaboot /etc/rc3.d/S99sdaboot >/dev/null
#else
#	if [ -d /etc/rc.d/rc3.d ]; then
#		ln -s -f /etc/init.d/sdaboot /etc/rc.d/rc3.d/S99sdaboot >/dev/null
#	fi
#fi
#checkcmd
#if [ -d /etc/rc4.d ]; then
#	ln -s -f /etc/init.d/sdaboot /etc/rc4.d/S99sdaboot >/dev/null
#else
#	if [ -d /etc/rc.d/rc4.d ]; then
#		ln -s -f /etc/init.d/sdaboot /etc/rc.d/rc4.d/S99sdaboot >/dev/null
#	fi
#fi
#checkcmd
#if [ -d /etc/rc5.d ]; then
#	ln -s -f /etc/init.d/sdaboot /etc/rc5.d/S99sdaboot >/dev/null
#else
#	if [ -d /etc/rc.d/rc5.d ]; then
#		ln -s -f /etc/init.d/sdaboot /etc/rc.d/rc5.d/S99sdaboot >/dev/null
#	fi
#fi
#checkcmd

killall sdacm >/dev/null 2>&1
#sdacm
#sdmonitor >/dev/null 2>&1
sleep $waitseconds
#start sdacm
#sdmonitor -r sdacm >/dev/null 2>&1

#cp -a -f ./dependpkg/bin/SDDownload $SafeDogInstallDir
#checkcmd

#backup old nginx
mkdir -p $SafeDogInstallDir/backup 2> /dev/null

output_ok "$install_log"

###########################################################
install_log=$childstep".4, download nginx.."
echo -e -n  $main_space"$install_log"

# download nginx
nginx_old=$SafeDogInstallDir"/nginx"
if [ -f $nginx_old ];then
	rm -rf  $nginx_old
fi

tryDownNum=3
NginxVer=$g_NginxVersion"_"$VERSION"_"$nginx_bit
SDDownload -n -v $NginxVer >/dev/null  2>&1
ret=$?
while [ $ret != 1 ]
do
	tryDownNum=$(($tryDownNum-1))
	
	if [ $tryDownNum == 0 ];then
		echo
		echo -e $main_space$red"download nginx failed, May This version is not supported!!!"$close
		clean_install
		exit 	
	fi	
	
	SDDownload -n -v $NginxVer >/dev/null  2>&1
	ret=$?
done

sleep 1
#check download ok
if [ ! -f $SafeDogInstallDir"/nginx" ];then
	echo
	echo -e $main_space$red"download nginx failed!!!exit.."$close
	clean_install
	exit 
fi
#cp -a -f ./dependpkg/bin/nginx $SafeDogInstallDir

#echo "copy bin and set boot ok!"
output_ok "$install_log"


###########################################################
#selinux setting
getenforcepath=`which getenforce 2>/dev/null`
if [[ "x$getenforcepath" != "x" ]]; then
	seflag=`getenforce`
	if [ "$seflag" == "Enforcing" ];then
		chcon -t textrel_shlib_t '$libpath/libSPModule.so.0.0.0' >/dev/null 2>&1
		chcon -t textrel_shlib_t '$libpath/libWPCPlugin.so.0.0.0' >/dev/null 2>&1
		chcon -t textrel_shlib_t '$libpath/libnginx_safedog_plugin.so.0.0.0' >/dev/null 2>&1
		chcon -R -t httpd_sys_content_t "$SafeDogInstallDir/Analysis/">/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/mine.db" >/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/yours.db" >/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/WaterMark.db" >/dev/null 2>&1
		chcon --reference=$g_NginxConfPath "$SafeDogConfPath" >/dev/null 2>&1
		chattr +i '$libpath/libSPModule.so.0.0.0' >/dev/null 2>&1
		chattr +i '$libpath/libWPCPlugin.so.0.0.0' >/dev/null 2>&1
		chattr +i '$libpath/libnginx_safedog_plugin.so.0.0.0' >/dev/null 2>&1
		#echo "selinux setting ok!"
	fi
fi

###########################################################
#update version
sdaudinstall 10  >/dev/null 2>&1

##########################################################
#                start the nginx server
##########################################################
#echo "Prepare to start the nginx server"
install_log=$childstep".5, start the nginx server.."
echo -e -n  $main_space"$install_log" 

#backup user nginx
if [ ! -f $g_NginxPath"/sbin/nginx.sdbak" ];then
	cp -a -f $g_NginxExePath $g_NginxPath"/sbin/nginx.sdbak"
fi
	
if [ ! -f $SafeDogInstallDir"/backup/nginx.bak" ];then
	mv $g_NginxExePath $SafeDogInstallDir"/backup/nginx.bak"
fi

#backup user nginx conf
if [ ! -f $g_NginxPath"/conf/nginx.conf.sdbak" ];then
	cp -a -f $g_NginxPath"/conf/nginx.conf" $g_NginxPath"/conf/nginx.conf.sdbak"
fi

if [ ! -f $SafeDogInstallDir"/backup/nginx.conf.bak" ];then
	cp -a -f $g_NginxPath"/conf/nginx.conf" $SafeDogInstallDir"/backup/nginx.conf.bak"
fi


chmod +x $SafeDogInstallDir"/nginx"
mv $SafeDogInstallDir"/nginx" $g_NginxExePath


#start nginx
$g_NginxExePath 2> /dev/null
sleep 5
start_ret=$?
##################################################################
if [ $start_ret == 0 ];then
	output_ok "$install_log"	

	echo -e  $main_space$green"Tips:"$close
	echo -e  $main_space"(1)If you want to change the configuration of nginx defense module, please modify the files in "$green"$SafeDogInstallDir/conf;"$close
	echo -e  $main_space"(2)If you want to check nginx defense module log, please use command: "$green"sdalog -n"$close";"
	echo -e  $main_space"(3)If nginx defense module is failed to use, you can try to restart Nginx."

	if [ -f "/etc/nginxsd.conf" ];then
		cp -f  /etc/nginxsd.conf  $SafeDogInstallDir
	fi
	
	backup_oldconfig_to_new
	./dependpkg/bin/movedata 
else
	echo -e  $main_space$red"Sorry! Start the nginx server failed!"$close
fi

if [ -f "/usr/bin/sdmonitor" ];then
        sdmonitor -r sdacm
else
        sdacm
fi


if [ -f "/etc/apachesd.conf" ];then
	apache_restartcmd=`cat /etc/apachesd.conf | grep "RESTART_COMMAND"|awk -F = '{print $2}'`
	if [ ! -z "$apache_restartcmd" ];then
		$apache_restartcmd  >/dev/null 2>&1
	fi
fi
