#!/bin/bash
#Program:
#		This script is used to install ApacheSafeDog module.


VERSION="2.2"

$g_ApachePath
$g_ApacheConfPath
$g_ApacheExePath
$g_ApacheExeName
$g_ExistApache
$g_ApacheReloadCmd
$g_ApacheRestartCmd
$g_ApacheStopCmd
$g_ApacheVersion

#step num
nowstep=$1
allstep=$2
showtype=$3
silent_install=$4

if [ -z $nowstep ];then
	nowstep=9
fi

if [ -z $allstep ];then
	allstep=10
fi

#0 no show
#1 show wait for install
if [ -z $showtype ];then
	showtype=1
fi

if [ -z $silent_install ];then
	silent_install=0
fi


mainstep="step "$nowstep"/"$allstep
childstep="step "$nowstep


#display width
all_width=100
#main step width
main_width=3
child_width=$(($main_width+${#childstep}+4))
#color
close="\033[0m"
red="\033[1;31m"
green="\033[1;32m"
yellow="\033[1;33m"
#space
main_space="\033[${main_width}G"
child_space="\033[${child_width}G"

SafeDogInstallDir=/etc/safedog/apache

#the function is used to check whether the command was excuted successfully.
function checkcmd()
{
	if [ "$?" != "0" ];then
		output_fail $install_log
	fi
}
function GetPid()
{
	test $# -ne 1 && return 1
	prog=$1
	pids=$(ps aux|grep $prog|grep -v grep|awk '{print $2}')
	test -z "$pids" && return 2 || return 0
}

function output_ok()
{
	len=$(($all_width-${#1}))
	string=$green"%"$len"s"$close"\n"
	printf $string "[ok]"
}

function output_fail()
{
	len=$(($all_width-${#1}+3))
	string=$red"%"$len"s"$close"\n"
	printf $string "[fail]"
	
	echo -e  $main_space$red"Sorry! Install apache defense module failed!"$close
	clean_install
	restart_apache "$g_ApacheRestartCmd"
	exit
}

function output_warn()
{
	len=$(($all_width-${#1}+2))
	string=$yellow"%"$len"s"$close"\n"
	printf $string "[warn]"
}

#find apache
function find_apache()
{
	for progname in httpd apache2 apached
	do 		
		#find apache service
		testcmd="service "$progname" status"
		$testcmd>/dev/null 2>&1
		ret=$?
		if [ "$ret" == "0" ] || [ "$ret" == "2" ] || [ "$ret" == "3" ]; then
			g_ExistApache="true"
			g_ApacheExePath=$progname
			g_ApacheRestartCmd="service "$progname" restart"
			g_ApacheReloadCmd="service "$progname" graceful"
			g_ApacheStopCmd="service "$progname" stop"
			g_ApacheExeName=$progname
			get_apache_confpath
			if [ ! -z $g_ApacheConfPath ]; then
				return  1
			fi
		else
			testcmd="service "$progname" stop"
			$testcmd>/dev/null 2>&1
			ret=$?
			if [ "$ret" == "0" ]; then
				g_ExistApache="true"
				g_ApacheExePath=$progname
				g_ApacheRestartCmd="service "$progname" restart"
				g_ApacheReloadCmd="service "$progname" graceful"
				g_ApacheStopCmd="service "$progname" stop"
				g_ApacheExeName=$progname
				get_apache_confpath
				if [ ! -z $g_ApacheConfPath ]; then
					return  1
				fi
			fi
		fi
		
		#"find apache process"
		g_ApacheExePath=`ps -ef | grep $progname | grep -v grep | tail -3 | head -1 | awk '{print $8}'`
		if [ ! -z $g_ApacheExePath ];then
			g_ExistApache="true"
			g_ApacheRestartCmd=$g_ApacheExePath" -k restart"
			g_ApacheReloadCmd=$g_ApacheExePath" -k graceful"
			g_ApacheStopCmd=$g_ApacheExePath" -k stop"
			g_ApacheExeName=$progname
			return 1
		fi
		
	done

	# not found
	g_ExistApache="false"
}

function get_apache_confpath()
{
	httpd_root=`$g_ApacheExePath -V 2>/dev/null | grep HTTPD_ROOT|awk -F '"' '{print $2}'`
	conf_file=`$g_ApacheExePath -V 2>/dev/null | grep SERVER_CONFIG_FILE|awk -F '"' '{print $2}'`
	
	#conf file in http root dir
	first_char=`echo ${conf_file:0:1}`
	if [ "$first_char" == "/"  ];then
		g_ApacheConfPath=$conf_file
	else
		g_ApacheConfPath=$httpd_root"/"$conf_file
	fi
	
	if [ ! -f "$g_ApacheConfPath" ];then
		g_ApacheConfPath=""
		g_ExistApache="false"
	fi
}

function wait_for_install()
{	
	local log
	log=$1
	
	a=10;
	while [ $a != 0 ]
	do
		echo -n -e "\r"$log"install Apache Defend Module in "$a" seconds, enter \"CTRL+c\" to stop install.  "
		let "a--"
		sleep 1
	done
	
	echo -e -n	"\r"$log"start install Apache Defend Module..."
	printf "%40s\n" ""
}

function clean_install()
{
	./uninstall.sh 1 >/dev/null 2>&1
}


# stop apache
function stop_apache()
{
	GetPid $g_ApacheExeName
	if [ ! -z "$pids" ];then
		$g_ApacheStopCmd >/dev/null 2>&1
		sleep 1
	fi
}


# restart apache
# input : $1 restart command
# output: restartok
# output: 1 ok, 0 error
function restart_apache()
{
	local restart_cmd
	restart_cmd=$1
		
	$restart_cmd >/dev/null 2>&1
	local restart_ret=$?
	if [ $restart_ret -eq 0 ];then
		sleep 2
		GetPid $g_ApacheExeName
		test $? -eq 0 && new_pids=$pids		
		
		if [ -z "$new_pids" ];then
			$restart_cmd >/dev/null 2>&1
			sleep 2
			GetPid $g_ApacheExeName
			test $? -eq 0 && new_pids=$pids		
		fi		
		
		#new pids null,return
		if [ -z "$new_pids" ];then
			restartok="false"
			return 0
		fi
		
		if [ "$old_pids" == "$new_pids" ];then
			restartok="false"
			return 0
		else
			apache_num=`ps -ef | grep $g_ApacheExeName | grep -v grep |wc -l`
			if [ "$apache_num" != "0" ];then
				restartok="true"
				return 1
			fi
		fi
	else
		restartok="false"
		#echo $restart_cmd", restart failed." 
	fi
	return 0
}

function check_apache_version()
{
	g_ApacheVersion=`$g_ApacheExePath -V 2>/dev/null|grep "Server version"|awk -F 'Apache/' '{print $2}'|awk -F '.' '{print $1"."$2}'`
	if [ "$g_ApacheVersion" != "2.2" ]  && [ "$g_ApacheVersion" != "2.4" ];then
		echo -e  $child_space$red"Safedog is failed to install Apache Defense Module, it's only for Apache Version 2.2/2.4."$close
		exit
	fi

	if [ "$g_ApacheVersion" == "2.4" ];then
		lib_apache_plugin="libapache_safedog_2_4.so"
	fi
}

function backup_oldconfig_to_new()
{
    local old_install_dir=/etc/ApacheSafeDog
	if [ -d $old_install_dir ];then
	  echo "backup the 2.7 config files to 2.8 install dirs."

      cp -r -f $old_install_dir/Analysis/* $SafeDogInstallDir/Analysis
	  checkcmd
	  cp -r -f $old_install_dir/conf/* $SafeDogInstallDir/conf
	  checkcmd
	  cp -r -f $old_install_dir/GeneralConfig/* $SafeDogInstallDir/GeneralConfig
	  checkcmd
	  cp -f $old_install_dir/yours.db $SafeDogInstallDir/yours.db
	  checkcmd
	  
	  rm -rf /etc/ApacheSafeDog
	  checkcmd
    fi
}

function delete_old_config()
{
    local old_install_dir=/etc/ApacheSafeDog
	if [ -d $old_install_dir ];then
		#删除原有的配置
		apconf=`grep ApacheConfPath /etc/apachesd.conf`
		apconf=${apconf#*ApacheConfPath=}
		if [ -f $apconf ];then
			delstr="#Begin SafeDogSite-ApacheFilter edits - remove only on uninstall"	
			sed -i "/$delstr/d" $apconf
			sdconf=`grep SDConfPath /etc/apachesd.conf`
			sdconf=${sdconf#*SDConfPath=}
			sdconf=${sdconf//\//\\\/}
			sed -i "/Include \"$sdconf\"/d" $apconf
		fi


		#调用卸载程序删除产品信息
		uduninstall=""
		#get LONG_BIT.
		longbit=`getconf LONG_BIT`
		if [ "$?" == "0" -a "$longbit" == "32" ];then
			uduninstall="sdauduninstall NF-7400LP"
		else	
			uduninstall="sdauduninstall NF-7400LP64"
		fi
		$uduninstall >/dev/null 2>&1
		
		rm -rf /etc/apachesd.conf
		checkcmd
	fi
}

function backup_config()
{
    local tmp_config_dir=$SafeDogInstallDir/config_backup
	if [ -d $SafeDogInstallDir/conf ];then
	  echo "backup the config files to tmp. tmp path: $SafeDogInstallDir/config_backup"

	  mkdir -p $tmp_config_dir
	  checkcmd
	  cp -r -f $SafeDogInstallDir/Analysis $tmp_config_dir
	  checkcmd
	  cp -r -f $SafeDogInstallDir/conf $tmp_config_dir
	  checkcmd
	  cp -r -f  $SafeDogInstallDir/GeneralConfig $tmp_config_dir
	  checkcmd
	  cp -f $SafeDogInstallDir/yours.db $tmp_config_dir/yours.db
	  checkcmd
    fi
}

function restore_config()
{
    local tmp_config_dir=$SafeDogInstallDir/config_backup
	if [ -d $tmp_config_dir ];then
	  echo "restore the old 2.8 config to the new."

	  cp -r -f $tmp_config_dir/Analysis/* $SafeDogInstallDir/Analysis
	  checkcmd
	  cp -r -f $tmp_config_dir/conf/* $SafeDogInstallDir/conf 
	  checkcmd
	  cp -r -f  $tmp_config_dir/GeneralConfig/* $SafeDogInstallDir/GeneralConfig 
	  checkcmd
	  cp -f $tmp_config_dir/yours.db $SafeDogInstallDir/yours.db 
	  checkcmd
	  rm -rf $tmp_config_dir
    fi
}

#old version may have sdaboot,it's remove now, so must be compatible
function remove_bootsrcipt()
{
	killall sdacm>/dev/null 2>&1

	rm -f /etc/rc2.d/S99sdaboot
	rm -f /etc/rc3.d/S99sdaboot
	rm -f /etc/rc4.d/S99sdaboot
	rm -f /etc/rc5.d/S99sdaboot
	rm -f /etc/init.d/sdaboot
	
	rm -f /usr/bin/sdaboot
}

function start_sdacm()
{
    sdmonitor_path=/usr/bin/sdmonitor
	if [ -f ${sdmonitor_path} ]; then
		sdmonitor
		sleep 1
	    ${sdmonitor_path} -r sdacm
	else
	    /usr/bin/sdacm
	fi
}

##############################################################################################
##############################################################################################
#start install

runDir=`pwd`
scriptDir=`dirname $0`
cd $scriptDir


#installed nginx,exit
if [ -f "/etc/nginxsd.conf" ];then
	echo -e  $main_space$red"Sorry! you have installed nginx Defense module, Can not install apache Defense module again..."$close
	exit
fi

#delete old config
delete_old_config

#back oldconfig
backup_config

remove_bootsrcipt

#check start install
cp -a -f ./dependpkg/bin/sdaudinstall  ./
chmod +x  ./sdaudinstall
./sdaudinstall "4" "check" >/dev/null 2>&1
ret=$?
if [ "$ret" == "2" ];then
	echo -e  $main_space$red"Version error! Can not install..."$close
	exit
fi



find_apache
#get apache config path
get_apache_confpath

if [ $g_ExistApache == "true" ];then
	echo
	echo -e		$mainstep",  start install Apache Defense Module.."
else
	echo
	
	#silent install,get apache failed then exit
	if [ "$silent_install" == "1" ];then
		exit
	fi

	#normal install
	if [ "$showtype" == "1" ];then
		echo -e	-n	$mainstep",  will you need to install Apache Defense Module?"
		read -p 	"[Y/n]:"  IsInstallApache
		if [ "$IsInstallApache" != "Y" ] && [ "$IsInstallApache" != "y" ];then
			echo -e  $red"Apache defense module is not installed!!"$close
			exit
		fi
	else
		echo -e		$mainstep",  start install Apache Defense Module.."
	fi
fi

#let user input apache configuration path.
#:||:<<\READDIR
input_num=2

if [ ! -z $g_ApacheConfPath ]; then
	installlog=$main_space$childstep".1, "
	if [ "$showtype" == "1" ];then
		wait_for_install "$installlog"
	else
		installlog=$main_space$childstep".1, start install Apache Defend Module..."
		echo -e $installlog
	fi
else
	echo -e 		$main_space$childstep".1, input apache executable file's path: [enter \"CTRL+c\" to exit]"
	echo -e 		$child_space"For example:/usr/local/apache/bin/httpd"
	echo -e -n		$child_space		
	read -p 	"Please input the absolute path:" g_ApacheExePath
	while [ ! -f "$g_ApacheExePath" ]
	do
		if [ "$input_num" == "0" ];then
			echo -e $child_space$red"Error:install apache defense module failed!"$close
			exit
		fi
		
		echo -e 		$child_space$yellow"Warn: the path you inputted is not exist or not the apache executable file!"$close
		echo -e 		$child_space"For example:/usr/local/apache/bin/httpd"
		echo -e -n		$child_space
		read -p "Please input the absolute path:" g_ApacheExePath
		
		input_num=$(($input_num-1))
	done
	
	g_ExistApache="true"
	g_ApacheExeName="httpd"

	get_apache_confpath
	
	g_ApacheRestartCmd=$g_ApacheExePath" -k restart"
	g_ApacheReloadCmd=$g_ApacheExePath" -k graceful"
	g_ApacheStopCmd=$g_ApacheExePath" -k stop"

fi

#################################################################################################
#check apache version
lib_apache_plugin="libapache_safedog_2_2.so"

check_apache_version

#stop apache
stop_apache

#stop sdacm
killall sdacm >/dev/null 2>&1
#################################################################################################
install_log=$childstep".2, copy libraries"
echo -e -n $main_space"$install_log"
#READDIR
#install path 
if [ ! -d $SafeDogInstallDir ];then 
	mkdir -p $SafeDogInstallDir
	checkcmd
fi
chmod 755 $SafeDogInstallDir
checkcmd
#create necessary directory and file
if [ ! -d $SafeDogInstallDir/Analysis ];then 
	mkdir -p $SafeDogInstallDir/Analysis
	checkcmd
fi

chmod 777 $SafeDogInstallDir/Analysis
checkcmd

cp -f ./SynSvr.dat $SafeDogInstallDir/Analysis/
checkcmd
chmod 666 $SafeDogInstallDir/Analysis/SynSvr.dat
checkcmd

safedog_logs_dir='/etc/safedog/logs'
if [ ! -d ${safedog_logs_dir} ];then 
    mkdir -p ${safedog_logs_dir}
    checkcmd
fi
chmod 777 ${safedog_logs_dir}
checkcmd

cp -f ./uninstall.sh $SafeDogInstallDir/
checkcmd

SafeDogConfPath=${SafeDogInstallDir}/SafeDogSiteApacheFilter.Conf
grep -l "#Begin SafeDogSite-ApacheFilter edits - remove only on uninstall" $g_ApacheConfPath >/dev/null 2>&1
if [ $? != 0 ];then
	sed -i "1i #Begin SafeDogSite-ApacheFilter edits - remove only on uninstall" $g_ApacheConfPath
fi
grep -l "Include \"$SafeDogConfPath\"" $g_ApacheConfPath >/dev/null 2>&1
if [ $? != 0 ];then
	sed -i "2i Include \"$SafeDogConfPath\"" $g_ApacheConfPath
fi
#####echo "modify apache configuration file ok!"
#detect the library path.
longbit=`getconf LONG_BIT`

libpath="/etc/safedog/libs/apache"

#create libs path if not exists
if [ ! -d ${libpath} ];then 
	mkdir -p ${libpath}
	checkcmd
fi
chmod 755 ${libpath}
checkcmd

#remove -i
if [ -f "$libpath/$lib_apache_plugin.0.0.0" ];then
	chattr -i $libpath/$lib_apache_plugin.0.0.0
fi

if [ -f "$libpath/libWPCPlugin.so.0.0.0" ];then
	chattr -i $libpath/libWPCPlugin.so.0.0.0
fi

if [ -f "$libpath/libSPModule.so.0.0.0" ];then
	chattr -i $libpath/libSPModule.so.0.0.0
fi


#echo "library path:$libpath"
#create SafeDogSiteApacheFilter.Conf
touch $SafeDogConfPath
echo "LoadFile \"$libpath/libQtCore.so\"">$SafeDogConfPath
echo "LoadFile \"$libpath/libQtNetwork.so\"">>$SafeDogConfPath
echo "LoadFile \"$libpath/libboost_regex.so\"">>$SafeDogConfPath
echo "LoadFile \"$libpath/libboost_thread.so\"">>$SafeDogConfPath
echo "LoadFile \"$libpath/libboost_system.so\"">>$SafeDogConfPath
echo "LoadFile \"$libpath/libboost_filesystem.so\"">>$SafeDogConfPath

echo "LoadFile \"$libpath/libSPModule.so\"">>$SafeDogConfPath
echo "LoadFile \"$libpath/libWPCPlugin.so\"">>$SafeDogConfPath

echo "LoadModule apache_safe_dog_filter_module \"$libpath/$lib_apache_plugin\"">>$SafeDogConfPath
echo "ApacheFilterDirPath \"$SafeDogInstallDir\"">>$SafeDogConfPath
echo "SetOutputFilter ApacheSafeDogOutputFilter">>$SafeDogConfPath
#echo "create SafeDogSiteApacheFilter.conf ok!"

#set path information to apachedf.conf 
echo "InstallDir=$SafeDogInstallDir">/etc/apachesd.conf
echo "SDConfPath=$SafeDogConfPath">>/etc/apachesd.conf
echo "ApacheConfPath=$g_ApacheConfPath">>/etc/apachesd.conf
#ApacheSafeDog configure file monitor

cp -r -f ./dependpkg/conf $SafeDogInstallDir
checkcmd
chmod 666 $SafeDogInstallDir/conf/*.conf
checkcmd
#echo "copy configuration file ok!"

cp -r -f ./dependpkg/GeneralConfig $SafeDogInstallDir
checkcmd
chmod 666 $SafeDogInstallDir/GeneralConfig/*.dat
checkcmd
#echo "copy GeneralConfig file ok!"

chmod 644 ./dependpkg/db/*.db
checkcmd
cp -f ./dependpkg/db/*.db $SafeDogInstallDir
checkcmd
chmod 644 $SafeDogInstallDir/*.db
checkcmd
#echo "copy db file ok!"

#creat log directory
logdir=/var/log/apachesd
if [ ! -e $logdir ];then
	mkdir /var/log/apachesd
	checkcmd
fi

#copy dynamic libraries to $libpath
chmod +x ./dependpkg/lib/*
checkcmd
cp -f ./dependpkg/lib/$lib_apache_plugin.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libSPModule.so.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libWPCPlugin.so.0.0.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libQtCore.so.4.7.4 $libpath
checkcmd
cp -f ./dependpkg/lib/libQtNetwork.so.4.7.4 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_regex.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_filesystem.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_system.so.1.49.0 $libpath
checkcmd
cp -f ./dependpkg/lib/libboost_thread.so.1.49.0 $libpath
checkcmd

ln -s -f $libpath/$lib_apache_plugin.0.0.0 $libpath/$lib_apache_plugin >/dev/null
checkcmd
ln -s -f $libpath/libSPModule.so.0.0.0 $libpath/libSPModule.so >/dev/null
checkcmd
ln -s -f $libpath/libSPModule.so.0.0.0 $libpath/libSPModule.so.0 >/dev/null
checkcmd
ln -s -f $libpath/libWPCPlugin.so.0.0.0 $libpath/libWPCPlugin.so >/dev/null
checkcmd
ln -s -f $libpath/libWPCPlugin.so.0.0.0 $libpath/libWPCPlugin.so.0 >/dev/null
checkcmd
ln -s -f $libpath/libQtCore.so.4.7.4 $libpath/libQtCore.so >/dev/null
checkcmd
ln -s -f $libpath/libQtCore.so.4.7.4 $libpath/libQtCore.so.4 >/dev/null
checkcmd
ln -s -f $libpath/libQtNetwork.so.4.7.4 $libpath/libQtNetwork.so >/dev/null
checkcmd
ln -s -f $libpath/libQtNetwork.so.4.7.4 $libpath/libQtNetwork.so.4 >/dev/null
checkcmd
ln -s -f $libpath/libboost_regex.so.1.49.0 $libpath/libboost_regex.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_filesystem.so.1.49.0 $libpath/libboost_filesystem.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_system.so.1.49.0 $libpath/libboost_system.so >/dev/null
checkcmd
ln -s -f $libpath/libboost_thread.so.1.49.0 $libpath/libboost_thread.so >/dev/null
checkcmd
#echo "copy dynamic libraries ok!"
output_ok "$install_log"

#########################################################################################
install_log=$childstep".3, copy bin"
echo -e -n  $main_space"$install_log"
#copy bin and set boot
chmod +x ./dependpkg/bin/*
checkcmd
chmod +x ./dependpkg/script/*
checkcmd

APACHE_BIN_PATH=/etc/safedog/apache/bin

if [ ! -d ${APACHE_BIN_PATH} ];then 
	mkdir -p ${APACHE_BIN_PATH}
	checkcmd
fi

cp -a -f ./dependpkg/bin/sdacm ${APACHE_BIN_PATH}
checkcmd
ln -s -f ${APACHE_BIN_PATH}/sdacm /usr/bin/sdacm
checkcmd

cp -a -f ./dependpkg/bin/sdalog ${APACHE_BIN_PATH}
checkcmd
ln -s -f ${APACHE_BIN_PATH}/sdalog /usr/bin/sdalog
checkcmd

cp -a -f ./dependpkg/bin/sdaudinstall ${APACHE_BIN_PATH}
checkcmd
ln -s -f ${APACHE_BIN_PATH}/sdaudinstall /usr/bin/sdaudinstall
checkcmd

cp -a -f ./dependpkg/bin/sdauduninstall ${APACHE_BIN_PATH}
checkcmd
ln -s -f ${APACHE_BIN_PATH}/sdauduninstall /usr/bin/sdauduninstall
checkcmd


#echo "copy bin and set boot ok!"
output_ok "$install_log"


###########################################################
#selinux setting
getenforcepath=`which getenforce 2>/dev/null`
if [[ "x$getenforcepath" != "x" ]]; then
	seflag=`getenforce`
	if [ "$seflag" == "Enforcing" ];then
		chcon -t textrel_shlib_t "$libpath/libSPModule.so.0.0.0" >/dev/null 2>&1
		chcon -t textrel_shlib_t "$libpath/libWPCPlugin.so.0.0.0" >/dev/null 2>&1
		chcon -t textrel_shlib_t "$libpath/$lib_apache_plugin.0.0.0" >/dev/null 2>&1
		chcon -R -t httpd_sys_content_t "$SafeDogInstallDir/Analysis/">/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/mine.db" >/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/yours.db" >/dev/null 2>&1
		chcon -t httpd_sys_content_t "$SafeDogInstallDir/WaterMark.db" >/dev/null 2>&1
		chcon --reference="$g_ApacheConfPath" "$SafeDogConfPath" >/dev/null 2>&1
		chattr +i "$libpath/libSPModule.so.0.0.0" >/dev/null 2>&1
		chattr +i "$libpath/libWPCPlugin.so.0.0.0" >/dev/null 2>&1
		chattr +i "$libpath/$lib_apache_plugin.0.0.0" >/dev/null 2>&1
		#echo "selinux setting ok!"
	fi
fi

###########################################################
#update version
sdaudinstall 4  >/dev/null 2>&1


###########################################################
#
install_log=$childstep".4, Install apache defense module succeed.."
echo -e -n  $main_space"$install_log"


output_ok "$install_log"

##########################################################
#                restart the apache server
##########################################################
old_pids=""
new_pids=""
ret=0
restartok="false"


#echo "Prepare to restart the apache server"
restartlog=$childstep".5, restart the apache server.."
echo -e -n  $main_space"$restartlog" 

GetPid $g_ApacheExeName
if [ $? -eq 0 ];then
	old_pids=$pids
fi


#restart apache
restart_apache "$g_ApacheRestartCmd"


#restart apache failed,try again
if [ "$restartok" == "false" ];then
	for restartcmd in "service httpd restart"\
				  "service apache2 restart"\
				  "/etc/init.d/httpd restart"\
				  "/etc/init.d/apache2 restart"\
				  "httpd -k restart"\
				  "apache2 -k restart"\
				  "apachectl -k restart"\
				  "apache2ctl -k restart"
	do
		#echo -n "Try to run command:$restartcmd"
		restart_apache "$restartcmd"
		if [ "$restartok" == "true" ];then
			g_ApacheReloadCmd=`echo $restartcmd | sed "s/restart/graceful/"`
			break;
		fi
	done
fi


if [ "$restartok" == "true" ];then
	#save 
	echo "HTTP_NAME=$g_ApacheExeName">>/etc/apachesd.conf
	echo "RESTART_COMMAND=$g_ApacheReloadCmd">>/etc/apachesd.conf
	
	#start sdacm
	#if [ -f "/usr/bin/sdmonitor" ];then
	#	sdmonitor >/dev/null 2>&1
	#	sleep 2
	#	sdmonitor -r sdacm >/dev/null 2>&1
	#else	
	start_sdacm
	#fi
	
	output_ok "$restartlog"	

	echo -e  $main_space$green"Tips:"$close
	echo -e  $main_space"(1)If you want to change the configuration of apache defense module, please modify the files in "$green"$SafeDogInstallDir/conf;"$close
	echo -e  $main_space"(2)If you want to check apache defense module log, please use command: "$green"sdalog"$close";"
	echo -e  $main_space"(3)If apache defense module is failed to use, you can try to restart Apache service."	
	
	restore_config

	backup_oldconfig_to_new

	sleep 1
    ./dependpkg/bin/movedata
else
	output_fail "$restartlog"
fi


