(defun c:bcopy (/ e el ss *error*)
  (defun *error* (msg) (command ".erase" ss "") (princ))
  (setq ss (ssadd))
  (while (setq e (nentselp "\nѡʵ: "))
    (setq el (entget (car e)))
    (cond ((ssmemb (car e) ss)
	   (entdel (car e))
	  )
	  (t
	   (entmake el)
	   (if (= (length e) 4)
	     (vla-transformby
	       (vlax-ename->vla-object (entlast))
	       (vlax-tmatrix (caddr e))
	     )
	   )
	   (ssadd (entlast) ss)
	  )
    )
    (sssetfirst nil ss)
  )
  (cond	((and (> (sslength ss) 0)
	      (setq P1 (getpoint "\nָ<ԭλ>:"))
	 )
	 (command ".move" "non" P1)
	 (while	(/= 0 (getvar "cmdactive"))
	   (command "\\")
	 )
	)
  )
  (princ)
)

(defun c:add_to_blk (/ blk bn bname mat ss ssl)
  (if (and
	(setq bn (nentselp "\nʰȡͼ: "))
	(= (length bn) 4)		;
	(progn
	  (princ "\nѡʵ...")
	  (setq ss (ssget ))
	)
      )					;end and 
    (progn
      (setq bname (cdr (assoc 2 (entget (last (last bn))))) ;ȡ
	    blk	  (vla-item (vla-get-blocks *doc*) bname) ;ȡ鶨
	    mat	  (ea:matrix_inverse (caddr bn)) ;ȡWCS->OCS
      )
      (setq ssl (mapcar 'vlax-ename->vla-object (fsxm-ss->enlist ss)))
      (foreach e ssl (vla-transformby e (vlax-tmatrix mat)))
					;任鶨UCS
      (vlax-invoke *doc* 'CopyObjects ssl blk)
      (vla-regen *doc* acActiveviewport) ;Insert
      (foreach e ssl (vla-delete e))
    )
  )
  (princ)
)

(defun ea:matrix_inverse (matrix /	m0     m1     m2     m3
			  m00	 m01	m02    m03    m10    m11
			  m12	 m13	m20    m21    m22    m23
			  _a	 ea:determinant	      a11    a12
			  a21	 a22	a33    a34    a41    a42
			  a43	 a13	a23    a31    a32
			 )
  ;;ʽչʽ
  (defun ea:determinant	(a00 a01 a02 a10 a11 a12 a20 a21 a22 /)
    (- (+ (* a00 a11 a22)
	  (* a01 a12 a20)
	  (* a02 a21 a10)
       )
       (* a02 a11 a20)
       (* a01 a10 a22)
       (* a00 a21 a12)
    )
  )
  (setq	m0 (car matrix)
	m1 (cadr matrix)
	m2 (nth 2 matrix)
	m3 (last matrix)
  )
  (setq	m00 (car m0)
	m01 (cadr m0)
	m02 (nth 2 m0)
	m03 (last m0)
  )
  (setq	m10 (car m1)
	m11 (cadr m1)
	m12 (nth 2 m1)
	m13 (last m1)
  )
  (setq	m20 (car m2)
	m21 (cadr m2)
	m22 (nth 2 m2)
	m23 (last m2)
  )
  (setq	a11 (ea:determinant m11 m12 m13 m21 m22 m23 0.0 0.0 1.0)
	a12 (- (ea:determinant m10 m12 m13 m20 m22 m23 0.0 0.0 1.0))
	a13 (ea:determinant m10 m11 m13 m20 m21 m23 0.0 0.0 1.0)
	a21 (- (ea:determinant m01 m02 m03 m21 m22 m23 0.0 0.0 1.0))
	a22 (ea:determinant m00 m02 m03 m20 m22 m23 0.0 0.0 1.0)
	a23 (- (ea:determinant m00 m01 m03 m20 m21 m23 0.0 0.0 1.0))
	a31 (ea:determinant m01 m02 m03 m11 m12 m13 0.0 0.0 1.0)
	a32 (- (ea:determinant m00 m02 m03 m10 m12 m13 0.0 0.0 1.0))
	a33 (ea:determinant m00 m01 m03 m10 m11 m13 0.0 0.0 1.0)
	a41 (- (ea:determinant m01 m02 m03 m11 m12 m13 m21 m22 m23))
	a42 (ea:determinant m00 m02 m03 m10 m12 m13 m20 m22 m23)
	a43 (- (ea:determinant m00 m01 m03 m10 m11 m13 m20 m21 m23))
  )
  (list	(list a11 a21 a31 a41)
	(list a12 a22 a32 a42)
	(list a13 a23 a33 a43)
	'(0.0 0.0 0.0 1.0)
  )
)