;;ͼԪС
(defun c:min_dist (/	      en1	 en2	    lst
		   a	      bzbl	 PLINE_LIST DISTLST
		   GETENLST   CURVE_MINDIST
		  )
  (defun curve_mindist (en1 en2 / all_lst intpoint lst1 lst2 minlst)
    (cond ((setq intpoint (fsxm-interpt
			    (vlax-ename->vla-object en1)
			    (vlax-ename->vla-object en2)
			    0
			  )
	   )
	   intpoint
	  )
	  (t
	   (setq lst1 (getenlst en1)
		 lst2 (getenlst en2)
	   )
	   (setq all_lst
		  (vl-remove nil
			     (append (distlst lst1 en1 en2)
				     (distlst lst2 en2 en1)
			     )
		  )
	   )
	   (setq minlst	(car (vl-sort all_lst
				      '(lambda (a b)
					 (< (nth 2 a) (nth 2 b))
				       )
			     )
			)
	   )
	   (list (nth 2 minlst) (car minlst) (cadr minlst))
	  )
    )
  )
  (defun getenlst (en1 / data en1type)
    (setq data	  (entget en1)
	  en1type (cdr (assoc 0 data))
    )
    (cond ((= en1type "LINE")
	   (list (vlax-curve-getStartPoint en1)
		 (vlax-curve-getendPoint en1)
	   )
	  )
	  ((= en1type "ARC")
	   (list (vlax-curve-getStartPoint en1)
		 (vlax-curve-getendPoint en1)
		 (list (cdr (assoc 10 data))
		       (cdr (assoc 40 data))
		 )
	   )
	  )
	  ((= en1type "CIRCLE")
	   (list (list (cdr (assoc 10 data))
		       (cdr (assoc 40 data))
		 )
	   )
	  )
	  (t				;(wcmatch en1type "*POLYLINE")
	   (pline_list en1)
	  )
    )
  )
  (defun distlst (lst1 en1 en2 / cen cen_ner prj pt r)
    (mapcar '(lambda (pt)
	       (setq cen (car pt))
	       (if (and cen (listp cen))
		 (progn
		   (setq r (cadr pt))
		   (setq prj (vlax-curve-getclosestpointto en2 cen))
		   (setq cen_ner (polar cen (angle cen prj) r))
		   (if (vlax-curve-getParamAtPoint en1 cen_ner)
		     (list
		       cen_ner
		       prj
		       (abs (- (distance cen prj) r))
		     )
		   )
		 )
		 (progn
		   (setq prj (vlax-curve-getclosestpointto en2 pt))
		   (list pt prj (distance pt prj))
		 )
	       )
	     )
	    lst1
    )
  )
  (defun pline_list
	 (en / bg cen cenplst fun index l_arc obj pt ptlst sd)
    (setq obj (vlax-ename->vla-object en))
    (setq l_arc (vlax-curve-getEndParam en))
    (setq index	0
	  ptlst	nil
	  cenplst nil
    )
    (repeat (fix l_arc)
      (setq pt (vlax-curve-getPointAtParam en index))
      (setq ptlst (cons pt ptlst))
      (setq bg (vla-GetBulge obj index))
      (cond ((= bg 0))
	    (t
	     (if (> bg 0)
	       (setq fun '+)
	       (setq fun '-)
	     )
	     (setq sd (vlax-curve-getSecondDeriv en index))
	     (setq cen (mapcar fun pt sd))
	     (setq cenplst (cons (list cen (distance cen pt)) cenplst))
	    )
      )
      (setq index (1+ index))
    )
    (if	(not (vlax-curve-isClosed en))
      (setq ptlst (cons (vlax-curve-getEndPoint en) ptlst))
    )
    (append ptlst cenplst)
  )
  ;;===========================================================
  (setq	en1 (car (fsxm-entsel
		   "\nѡͼԪ1:"
		   '((0 . "line,arc,circle,*POLYLINE"))
		 )
	    )
  )
  (or en1 (fsxm-silenceexit))
  (sssetfirst nil (ssadd en1 (ssadd)))
  (setq	en2 (car (fsxm-entsel
		   "\nѡͼԪ2:"
		   '((0 . "line,arc,circle,*POLYLINE"))
		 )
	    )
  )
  (or en2 (fsxm-silenceexit))
  (sssetfirst nil)
  (setq lst (curve_mindist en1 en2))
  (cond	((listp (car lst))
	 (mapcar '(lambda (a) (fsxm-pt-grdraw (trans a 0 1) 1)) lst)
	 (alert
	   (strcat
	     (princ "\nͼԪΪ0, ཻ:\n")
	     (fsxm-tostring (princ lst))
	   )
	 )
	)
	(t
	 (cond ((/= 0 (car lst))
		(entmake (list '(0 . "line")
			       (cons 10 (cadr lst))
			       (cons 11 (caddr lst))
			 )
		)
		(sssetfirst nil (ssadd (entlast) (ssadd)))
	       )
	 )	 
	 (alert
	   (princ
	     (strcat
	       "\n**ͼԪСΪ=>:"
	       (fsxm-tostring  (car lst))
	       "\n\n**ǰעΪ=>:"
	       (rtos (setq bzbl (getvar "dimlfac")) 2 5)
	       "\n\n**ǰע=>:"
	       (fsxm-tostring (* bzbl (car lst)))
	     )
	   )
	 )
	)
  )
  (princ)
)