(defun c:SL_Screw (/	 ͷ  blk   data  dim1	 dim2  ept   h
		   inf	 ins   ldcl  len   line	 lpt   n     pt
		   r	 rst   size  spt   ss	 start tp
		  )
  (setq	data
	 '(
	   ("1_8_FM_H" 2.0858 0.6 0.0)
	   ("1_8_PM_H" 0.5858 0.6 1.8)
	   ("5_32_FM_H" 1.9821 0.6 0.0)
	   ("5_32_PM_H" 0.7459 0.6 2.2)
	  )
  )
  (setq	ldcl
	 '("screw"
	   (:DIALOG
	    (LABEL "˿ - Ʒ")
	    "spacer;"
	    (:ROW
	     "spacer;"
	     (:BOXED_COLUMN
	      (HEIGHT 10)
	      (WIDTH 30)
	      (:POPUP_LIST
	       (KEY "size")
	       (LABEL "С")
	       (LIST "1/8\"\n5/32\"")
	      )
	      (:POPUP_LIST
	       (KEY "type")
	       (LABEL "")
	       (LIST "Բͷ(PM)\nƽͷ(FM)")
	      )
	      (:EDIT_BOX
	       (ALLOW_ACCEPT TRUE)
	       (KEY "length")
	       (LABEL "")
	      )
	      "spacer;"
	     )
	     "spacer;"
	    )
	    "spacer;"
	    "ok_cancel;"
	   )
	  )
  )
  (setq rst (fsxm-ldcl ldcl "screw"))
  (or rst (fsxm-silenceexit))
  (if (= (fsxm-getdxf "size" rst) "0")
    (setq size "1_8"
	  r    1.5875
    )
    (setq size "5_32"
	  r    1.984375
    )
  )
  (if (= (fsxm-getdxf "type" rst) "0")
    (setq tp "PM")			;Բͷ
    (setq tp "FM")			;ƽͷ
  )
  (setq len (distof (fsxm-getdxf "length" rst)))
  (setq blk (strcat size "_" tp "_" "H"))
  (setq inf (assoc blk data))
  (setq start (cadr inf))
  (setq h (caddr inf))
  (setq ͷ (cadddr inf))

  (setq ins (getpoint "\nָ:"))
  ;;ע1
  (command "DIMLINEAR"
	   "non"
	   ins
	   "non"
	   (mapcar '- ins (list 0 len 0))
	   "non"
	   (mapcar '+ ins (list 5 0 0))
  )
  (setq dim1 (entlast))
  (fsxm-setendxf
    dim1
    '((8 . "Dim") (3 . "GB-35_b0.25"))
    nil
  )
  ;;ע2
  (setq lpt (mapcar '- ins (list 0 len 0)))
  (command "DIMLINEAR"
	   "non"
	   (mapcar '- lpt (list r 0 0))
	   "non"
	   (mapcar '+ lpt (list r 0 0))
	   "T"
	   "W<>"
	   "non"
	   (mapcar '+ lpt (list 0 -2.5 0))
  )
  (setq dim2 (entlast))
  (fsxm-setendxf
    dim2
    '((8 . "Dim") (3 . "IN-35_b0.25"))
    nil
  )
  ;;ͷ 
  (entmake
    (list
      '(0 . "INSERT")
      (cons 2 blk)
      (cons 10 ins)
    )
  )
  ;;
  (setq pt (mapcar '- ins (list 0 start 0)))
  (setq n (1+ (fix (/ (- len start) h))))
  (repeat n
    (entmake
      (list
	'(0 . "INSERT")
	(cons 2 size)
	(cons 10 pt)
      )
    )
    (command ".EXPLODE" "l")
    (setq pt (mapcar '- pt (list 0 h 0)))
  )
  ;;߽
  (setq spt (mapcar '+ ins (list -3 (- len) 0)))
  (setq ept (mapcar '+ ins (list 3 (- len) 0)))
  (entmake (list
	     '(0 . "LINE")
	     (cons 10 (mapcar '+ ins (list -3 (- len) 0)))
	     (cons 11 (mapcar '+ ins (list 3 (- len) 0)))
	   )
  )
  (setq line (entlast))
  ;;޼
  (fstl_autoload "fs_etr")
  (fsxm_fence_trim
    line
    (mapcar '- ins (list 0 (+ len 1) 0))
    nil
  )
  (command "trim"
	   ""
	   "e"
	   "n"
	   (list line spt)
	   (list line ept)
	   ""
  )
  ;;ɾ
  (setq	ss (ssget "w"
		  spt
		  (mapcar '- ins (list -3 (1+ len) 0))
	   )
  )
  (ssdel line ss)
  (command "erase" ss "")
  ;;
  (entmake (list
	     '(0 . "LINE")
	     '(8 . "Center")
	     '(48 . 0.5)
	     (cons 10 (mapcar '+ ins (list 0 (+ 0.5 ͷ) 0)))
	     (cons 11 (mapcar '- ins (list 0 (+ 0.5 len) 0)))
	   )
  )
  (princ)
)