(defun c:LayerCtrl (/			 all
		    dcl			 layer
		    layers		 laysobj
		    ss			 vss
		    LAYERCTRL:ACT:SELALL LAYERCTRL:ACT:SELREV
		    SELLAYERS		 LAYERCTRL:DCL:SHOW
		    LAYERCTRL:ACT:SEL	 LAYERCTRL
		    LAYERCTRL:ACT:FREE	 LAYERCTRL:ACT:FREEZE
		    LAYERCTRL:ACT:UNLOCK LAYERCTRL:ACT:LOCK
		    LAYERCTRL:ACT:ON	 LAYERCTRL:ACT:OFF
		   )
  (setq	dcl '("ls"
	      (:DIALOG
	       (LABEL "ʫCAD - ͼ")
	       (:ROW
		(:BOXED_ROW
		 (LABEL "ѡͼ")
		 "spacer;"
		 (:COLUMN
		  (:ROW
		   (:BUTTON
		    (HEIGHT 3)
		    (KEY "sel")
		    (LABEL ">")
		    (HORIZONTAL_MARGIN NONE)
		   )
		   (:BUTTON
		    (HEIGHT 3)
		    (KEY "selall")
		    (LABEL "ȫѡ")
		    (HORIZONTAL_MARGIN NONE)
		   )
		   (:BUTTON
		    (HEIGHT 3)
		    (IS_DEFAULT TRUE)
		    (KEY "selrev")
		    (LABEL "ѡ")
		    (HORIZONTAL_MARGIN NONE)
		   )
		  )
		  (:LIST_BOX
		   (HEIGHT 20)
		   (KEY "laylist")
		   (MULTIPLE_SELECT TRUE)
		   (WIDTH 25)
		   (HORIZONTAL_MARGIN NONE)
		  )
		  "spacer;"
		 )
		 "spacer;"
		)
		(:COLUMN
		 (:BOXED_COLUMN
		  (LABEL "ͼ")
		  (:BUTTON
		   (HEIGHT 3)
		   (IS_CANCEL TRUE)
		   (KEY "cancel")
		   (LABEL "ȡ")
		  )
		  (:ROW
		   (:BTN (KEY "off") (LABEL "ر"))
		   (:BTN (KEY "on") (LABEL ""))
		  )
		  (:ROW
		   (:BTN (KEY "freeze") (LABEL ""))
		   (:BTN (KEY "free") (LABEL "ⶳ"))
		  )
		  (:ROW
		   (:BTN (KEY "lock") (LABEL ""))
		   (:BTN (KEY "unlock") (LABEL ""))
		  )
		 )
		)
	       )
	      )
	      "btn"
	      (:BUTTON (HEIGHT 5) (WIDTH 12))
	     )
  )
  (setq LaysObj (vla-get-layers *doc*))
  (vlax-for a LaysObj (setq all (cons (vla-get-name a) all)))
  (setq all (acad_strlsort all))
  ;;vla-put-layeron vla-put-Freeze vla-put-lock
  ;;ر
  (defun layerctrl:act:off ()
    (layerctrl 'vla-put-LayerOn 0)
  )
  (defun layerctrl:act:on ()
    (layerctrl 'vla-put-LayerOn 1)
  )
  ;;
  (defun layerctrl:act:lock ()
    (layerctrl 'vla-put-Lock 1)
  )
  (defun layerctrl:act:unlock ()
    (layerctrl 'vla-put-Lock 0)
  )
  ;;
  (defun layerctrl:act:Freeze ()
    (layerctrl 'vla-put-Freeze 1)
  )
  (defun layerctrl:act:Free ()
    (layerctrl 'vla-put-Freeze 0)
    (vla-Regen *doc* acAllViewports)
  )
  ;;ͼ״̬
  (defun layerctrl (fun val)
    (foreach lay (dcl:list-getv "laylist")
      (vl-catch-all-apply fun (list (vla-item LaysObj lay) val))
    )
    (return t)
  )
  ;;ʼ
  (defun layerctrl:dcl:show ()
    (selLayers layers)
  )
  ;;ù
  (defun selLayers (lst)
    (dcl:list-set "laylist" all)
    (set_tile "laylist" "")
    (foreach a lst
      (set_tile "laylist" (itoa (vl-position a all)))
    )
  )
  ;;ѡ
  (defun layerctrl:act:selrev (/ sel)
    (get_tile "laylist")
    (setq sel (dcl:list-getv "laylist"))
    (selLayers
      (vl-remove-if '(lambda (a) (vl-position a sel)) all)
    )
  )
  ;;ȫѡ
  (defun layerctrl:act:selall ()
    (selLayers all)
  )
  ;;ѡ
  (defun layerctrl:act:sel ()
    (return "sel")
  )
  (if (setq ss (ssget))
    (progn
      (setq vss (vla-get-ActiveSelectionSet *doc*))
      (setq layers nil)
      (vlax-for	obj vss
	(setq layer (vla-get-Layer obj))
	(or (vl-position layer layers)
	    (setq layers (cons layer layers))
	)
      )
    )
    (setq layers all)
  )
  (if (= (fsxm-ldcl dcl "layerctrl") "sel")
    (c:LayerCtrl)
  )
  (princ)
)