/////////
//general
var replayLabel="replay";
var exitTrouble="exit troubleshooting";
var help="help";

//////////
//whatToDo
var wantHelp="do you want assistance?";
var yesOrNo="Choose yes or no.";
var yes="yes";
var recommendation="(recommended)";
var no="no";
var yesExplanation="Show how to set up printer and install printer software.";
var noExplanation="Printer is already set up. Install printer software now.";

////////////
//driverCopy
var pleaseWait="please wait";
var waitStatementOne="File configuration is occuring and may take a few minutes.";
var waitStatementThree="Do not click cancel on any screen during this time.";
var waitStatementFour="Wait for guidance before doing other set up tasks.";
var waitStatementTwo="Set up guidance will automatically continue when file configuration is complete.";

////////////////////
//connectionWarning
var connectionWarningTitle="connection not selected";
var connectionWarningText1="To install the printer, a connection must be selected from the pull-down menu. It cannot be left blank.";
var connectionWarningText2="Click the left arrow button to select a connection.";

///////////
//usbDialog
var usbTitle="you have selected USB";
var usbText="To continue installing using USB, you must connect your printer to your computer with a USB cable.";
var chooseText="choose parallel instead";
var usbOnlyText="To continue installing, you must connect your printer to your computer with a USB cable.";
var usbVerify="Verify the following:";
var usbVerifyOne="your computer has a USB port";
var usbVerifyTwo="the USB cable is securely connected to the computer and printer";
var usbRetry="If the printer is properly connected and installation will not continue, try reconnecting the USB cable to the computer.";
var usbHelp="need more help?";

///////////
//usbHelp
var usbHelpTitle="more help";
var usbHelpText="If the printer is properly connected and installation will still not continue, contact your computer's manufacturer for information on configuring the computer's BIOS for USB.";

///////////
//bluetoothDialog
var bluetoothDialogTitle="verify Bluetooth connection";
var bluetoothDialogText="To continue, the printer must be turned on and placed within 10 meters of your computer.";
var bluetoothOptions='If installation still will not continue, press and hold the power button for three seconds. If the blue light does not flash, click "go to web" for more information.';
var chooseContinueText="go to web";

//////////////
//noBluetoothSupport
var noBluetoothTitle="Bluetooth not available";
var noBluetoothText="A Bluetooth connection was not detected. Do one of the following";
var bluetoothOptionOne="click the right arrow button to continue with the printer software installation";
var bluetoothOptionTwo='click "choose USB instead" to do a USB installation instead of Bluetooth';
var chooseUSBText="choose USB instead";

///////////////////
//installToFileDialog
var installToFileTitle="Bluetooth information";
var installToFileTextOne="The printer software has been successfully installed, however, a Bluetooth printer port could not be detected. Printing cannot occur until a Bluetooth port is configured.";
var installToFileTextTwo='Click "go to web" for Bluetooth port configuration instructions.';
var chooseGoToWeb="go to web";
var chooseUsbInstead="choose USB instead";

////////////		
//portDialog
var portDialogTitle1="which port are you using?";
var portDialogTitle2="is the printer connected?";
var portTextOne="The installer was unable to locate your printer.";
var portTextTwo="Verify that the printer is connected to your computer.";
var portTextThree='Then click the "locate printer" button, or select from the available choices and click the right arrow button.';
var choiceText="available choices";
var locateText="locate printer";

////////////
//exitDialog
var exitTitle="warning";
var cautionTitle="caution";
var exitTextOne="You are about to exit the install process and may not be able to use your printer.";
var exitTextTwo="Click the left arrow button to continue installing.";
var exitTextThree="You are about to exit without completing all recommended steps.";
var exitTextFour="Click the left arrow button to continue.";

////////////////
//haveEverything
var everythingTitle="do you have everything?";
var titleOne="included in the box:";
var titleTwo="purchased separately:";
var printerLabel="printer";
var powerLabel="power cord";
var cartridgeLabel="print cartridges";
var cartridgeSingleLabel="print cartridge";
var cableLabel="printer cable";
var usbCableLabel="USB printer cable";
var usbLabel="USB";
var computerLabel="computer with Bluetooth support";
var orLabel="or";
var parallelLabel="parallel";
var paperLabel="white paper";

////////////// 
//haveDuplexer
var duplexerTitle="do you have a two-sided printing module?";
var duplexerText1="The Automatic Two-Sided Printing Module is an accessory enabling the printer to automatically print on both sides of the page.";
var duplexerText2="The module can be purchased separately if one did not come with the printer.";
var duplexerText1="The Automatic Two-Sided Printing Module is an optional accessory that is purchased separately. It enables the printer to automatically print on both sides of the page.";

////////////
//whichCable
var cableTitle="which cable are you using?";
var cableTitleTwo="how are you connecting?";
var parallelOrUsb="Choose USB or parallel.";
var bluetoothOrUsb="Choose Bluetooth or USB.";
var bluetoothLabel="Bluetooth";
var helpLabel="help";
var tellMeMoreLabel="tell me more";

////////////
//helpChoose
var chooseTitle="help";
var usbRequirement="USB requires:";
var usbOne="an available USB port on the computer";
var usbTwo="Windows 98, 2000, Me or XP";
var usbTwo2="Windows 98, 2000, or Me";
var usbThree="any USB cable";
var parallelRequirement="Parallel requires:";
var parallelOne="an available parallel port on the computer";
var parallelTwo="Windows 95, 98, 2000, Me, XP or NT 4.0";
var parallelThree="an IEEE-1284 bi-directional parallel cable";

////////////
//helpChoose2
var tellMeBlueOne="Bluetooth is a new wireless technology that allows you to print, without cables, from laptops, PDA's, cell phones and other Bluetooth devices up to 10 meters away.";
var tellMeBlueOne2="Bluetooth is a new wireless technology that allows you to print, without cables, from laptops, PDA's, mobile phones and other Bluetooth devices up to 10 meters away.";
var bluetoothRequirement="Bluetooth requires:";
var bluetoothOne="laptop or computer with a built-in or accessory Bluetooth card";
var bluetoothTwo="Windows 2000 or XP";
var bluetoothThree="Windows 2000";

////////////
//whitePaper
var whyTitle="why white paper?";
var whyOne="The printer will automatically calibrate and print a calibration page after the print cartridges are installed.";
var whyOneCross="Printer calibration will occur later in this install process.";
var whyTwo="White paper must be loaded in order for the printer to do an accurate calibration.";

////////////
//retryRecommend
var retryRecommendTitle="still no sample?";
var retryRecommendTitle2="still no page?";
var retryRecommendText1="Uninstall and re-install the printer software. Write down the following steps because this screen will disappear.";
var retryRecommendText2="Disconnect cable from printer only.";
var retryRecommendText3='Eject and re-insert printer CD, then select "remove printer software".';
var retryRecommendText4='Once uninstall is complete, eject and re-insert printer CD again. Install local printer software using "yes (recommended)" path.';
var retryRecommendText5='Disconnect cable from printer only and click the "x" to exit.';
var retryRecommendText6='Click the "x" to exit.';

////////////////
//attachDuplexer
var attachDuplexerTitle="attach two-sided printing module";
var attachDuplexerOne="Turn knob on printer's Rear Access Door counter-clockwise, then remove door.";
var attachDuplexerTwo="Firmly snap module into back of printer. Make sure module's access door is closed.";
var connectDuplexerWarning="(NOTE: Do not push side buttons on Automatic Two-Sided Printing Module during insertion.)";

//////////////
//connectCable
var usbTitle="connect USB cable";
var parallelTitle="connect parallel cable";
var connectCableOne="Plug printer cable into printer, and snap both clips into notches on connector.";
var connectCableTwo="Plug printer cable into computer, and tighten screws on connector.";
var connectCableThree="Plug USB cable firmly into printer until it stops.";
var connectCableFour="Plug USB cable into a USB port located on the computer.";
var connectCableWarning="(NOTE: HP recommends that you use an IEEE-1284 compliant cable.)";
var connectCableWarningGeneric="(NOTE: It is recommended to use an IEEE-1284 compliant cable.)";

///////////			
//powerCord
var powerTitle="plug in power cord";
var powerBluetoothOne="Place printer within 10 meters of computer.";
var powerBluetoothTwo="Plug power cord into printer.";
var powerBluetoothThree="Plug power cord into an electrical outlet.";
var powerBluetoothFour="Turn on printer.";
var powerCordOne="Plug power cord into printer.";
var powerCordTwo="Plug power cord into an electrical outlet.";
var powerCordThree="Turn on printer if printer does not automatically power on.";
var powerCordNote="(NOTE: Do not click cancel on any screen that may appear on the computer screen once the printer is turned on.)";

///////////
//loadPaper		
var paperTitle="load white paper";
var loadPaperOne="Pull out paper tray.";
var loadPaperTwo="Place white paper into paper tray and push paper forward until it stops.";
var loadPaperThree="Push in paper tray.";
var whyLabel="why white paper?";
var loadPaperOneF="Lower the paper tray and press down until it snaps into place.";
var loadPaperTwoF="Pull out paper tray.";
var loadPaperThreeF="Place white paper into paper tray and push paper forward until it stops.";
var loadPaperFourF="Push paper guide forward to the edge of the paper.";
var loadPaperOneFBolt="Lower the paper tray.";
var loadPaperOneCross="Lift top cover.";
var loadPaperTwoCross="Completely unfold paper tray in two steps.";
var loadPaperThreeCross="Place white paper into paper tray and push paper forward until it stops.";
var loadPaperFourCross="Leave top cover open.";
var loadPaper1="Slide paper guide firmly against paper.";
var loadPaper2="Remove the Out tray.";
var loadPaper3="Raise the Out tray.";
var loadPaper4="Slide out paper guides.";
var loadPaper5="Load white paper into paper tray and push paper forward until it stops.";
var loadPaper6="Slide paper guides firmly against paper.";
var loadPaper7="Replace the Out tray and pull out the Out tray extension.";
var loadPaper8="Lower the Out tray and pull out the Out tray extension.";
var loadPaper9="Unfold Out tray extension.";

///////////////////
//prepareCartridges
var prepareTitle="prepare print cartridges";
var prepareCartridgesOne="Remove Tri-Color and Black Print Cartridges from packaging.";
var prepareCartridgesTwo="Carefully remove plastic tape from both print cartridges.";
var prepareWarning="(NOTE: Do not touch or remove copper strip on print cartridges.)";
var prepareTitle1="prepare print cartridge";
var prepareCartridgesOne1="Remove print cartridge from packaging.";
var prepareCartridgesTwo1="Carefully remove plastic tape from print cartridge.";
var prepareWarning1="(NOTE: Do not touch or remove copper strip on print cartridge.)";
var preparePurchaseBlackPen="For crisp black text, you can purchase the optional Black Print Cartridge.";
var preparePurchaseColorPen="For color printing, you can purchase the optional Tri-Color Print Cartridge.";
var prepareWarning2="(NOTE: Keep cartridge(s) upright.)";

///////////////////
//installCartridges
var installTitle="install print cartridges";
var installCartridgesOne="Open top cover.";
var installCartridgesTwo="Lift cradle latches, then insert print cartridges.";
var installCartridgesThree="Firmly press down cradle latches until they snap into place.";
var installCartridgesFour="Close top cover.";
var installWarning="(NOTE: Printer will print a calibration page.)";
var installWarning2="(NOTE: Printer will automatically generate and print a calibration page.)";
var installTitle1="install print cartridge";
var installCartridgesTwoR1="Lift right cradle latch, then insert print cartridge.";
var installCartridgesThreeR1="Firmly press down right cradle latch until it snaps into place.";
var installCartridgesTwoL1="Lift left cradle latch, then insert print cartridge.";
var installCartridgesThreeL1="Firmly press down left cradle latch until it snaps into place.";
var installCartridgesTwoOld="Insert print cartridges.";
var installCartridgesThreeOld="Press cartridges down and forward until they snap into place.";
var installCartridgesCrossOne="Open top cover if closed.";
var installCartridgesCrossTwo="Hold each cartridge so copper strip is on the bottom and toward the printer. Slide each cartridge into its respective cradle (tri-color on the left and black on the right) at an upward angle until resistance is felt. With thumb on cartridge and fingers on cradle, push each cartridge until snap is heard.";
var installCartridgesCrossThree="Close top cover.";
var installCartridgesCrossSingle="Insert Tri-Color Print Cartridge into left cradle. Hold cartridge so copper strip is on the bottom and toward the printer. Slide cartridge into the cradle at an upward angle until resistance is felt. With thumb on cartridge and fingers on cradle, push cartridge until snap is heard.";
var installCartridgesMalibuThree="Close cradle latches. Pull each latch forward, then press down to tuck tabs into place.";
var installCartridgesCrossBlack="Insert Black Print Cartridge into right cradle. Hold cartridge so copper strip is on the bottom and toward the printer. Slide cartridge into the cradle at an upward angle until resistance is felt. With thumb on cartridge and fingers on cradle, push cartridge until snap is heard.";
var installCartridgesTwoOldOne="Insert print cartridge.";
var installCartridgesThreeOldOne="Press cartridge down and forward until it snaps into place.";
var installCartridgesCrossSingleB="Insert Black Print Cartridge into right cradle. Hold cartridge so copper strip is on the bottom and toward the printer. Slide cartridge into the cradle at an upward angle until resistance is felt. With thumb on cartridge and fingers on cradle, push cartridge until snap is heard.";
var installCartridgesMalibuThreeOne="Close cradle latch. Pull latch forward, then press down to tuck tabs into place.";

/////////////
//calibration
var calibrationTitle="confirm calibration page";
var calibrationText="Did a calibration page print?";

/////////////
//printSample
var printTitle="print sample page";
var printSampleOne="You have successfully installed your printer.";
var printSampleTwo='Click "print sample page" to view HP professional quality printing.';
var printSampleTwoGeneric='Click "print sample page" to view professional quality printing.';
var printSampleThree="You can print this sample on plain paper or on the paper that came with your printer.";
var printLabel="print sample page";
var printSampleUsb="You have successfully installed your USB printer.";
var printSampleBluetooth="You have successfully installed your Bluetooth printer.";

///////////////
//confirmSample
var confirmTitle="confirm print sample";
var confirmText="Is sample page printing?";
var againLabel="print sample again";

///////////////
//confirmPage
var confirmPageTitle="confirm calibration page";
var confirmPageText="Is calibration page printing?";
var againPageLabel="print page again";

////////
//doEreg
var eregTitle="register printer";
var doEregOne="Registration is fast and easy, and will give you these exclusive benefits:";
var doEregTwo="Your information will be kept strictly confidential.";
var doEregSubOne="Faster expert technical support";
var doEregSubTwo="Early notice of product and software upgrades";
var doEregSubThree="Online tips and tricks";
var registerLabel="register my printer";
var privacyLabel="read privacy statement";

/////////////
//eregPrivacy
var privacyTitle="hp privacy statement";

//////////////////
//troubleshootSoft
var troubleTitle="verify the following...";
var troubleSubTitle="Click any button for help.";
var troubleConnection="Bluetooth light is on OR USB cable is properly connected.";
var troubleBluetooth="Bluetooth light is on.";
var troubleConnection2="Bluetooth connection is established OR USB cable is properly connected.";
var troubleBluetooth2="Bluetooth connection is established.";
var troubleCable="Cable is properly connected to printer and computer.";
var troublePower="Printer is plugged in and turned on.";
var troublePaper="Paper is loaded and paper tray is pushed in all the way.";
var troubleTape="Tape has been removed from the print cartridges.";
var troubleCartridges="Print cartridges are installed correctly.";
var troubleInstall="...and click the right arrow button to install";
var troubleContinue="...and click the right arrow button when finished";
var troubleSingleTape="Tape has been removed from the print cartridge.";
var troubleTray="Paper tray is completely lowered and paper is loaded.";
var troubleCartridge="Print cartridge is installed correctly.";
var troubleDuplexer="Automatic two-sided printing module is attached.";
var troubleDuplexer2="Two-sided printing module is attached.";
var troublePaperCross="Paper is loaded and pushed to rear of tray.";
var troubleIf="If sample is still not printing and printer lights are flashing, press the power button.";
var troubleIf2="If calibration page is still not printing and printer lights are flashing, press the power button.";

///////////////			
//notEverything
var notEverythingTitle="something is missing";
var notEverythingOne="HP recommends not continuing printer installation.";
var notEverythingTwo="If the missing item(s) should have been included in the box (printer, ink cartridge(s), power cord), contact HP support.";
var notEverythingOneGeneric="It is recommended to discontinue printer installation.";
var notEverythingTwoGeneric="If the missing item(s) should have been included in the box (printer, ink cartridge(s), power cord), contact the support organization.";
var notEverythingThree="Otherwise, obtain the missing item(s).";
var notEverythingFour='Click the "x" to end printer installation.';

//////////////////
//noBluetoothSupport
var noBluetoothSupportTitle="why not Bluetooth?";
var noBluetoothSupportOne="This printer cannot use Bluetooth with Windows 98 or Me.";
var noBluetoothSupportTwo="Do one of the following:";
var noBluetoothSupportThree="upgrade your operating system to Windows 2000";
var noBluetoothSupportFour="continue this installation with a USB connection";
var noBluetoothSupportThreeXP="upgrade your operating system to Windows 2000 or XP";

//////////////////
//noWebSupport
var noWebSupportTitle="internet access required";
var noWebSupportOne="Internet access is required to configure this printer for a Bluetooth connection.";
var noWebSupportTwo="Do one of the following:";
var noWebSupportThree="obtain internet access to continue with Bluetooth configuration";
var noWebSupportFour="repeat this installation with a USB connection";

/////////////////
//additional
var loadPaperOne2="Remove tape from printer.";
var loadPaperTwo2="Pull out paper tray.";
var loadPaperThree2="Place white paper into paper tray and push paper forward until it stops.";
var loadPaperFour2="Push in paper tray.";
var installQuestion="how do you want to install?";
var installChoose="choose one";

///////////////////
//connectDialog
var connectDialogTitle="is printer connected?";
var connectTextOne="Confirm power cord is plugged into computer and electrical outlet.";
var connectTextTwo="Confirm printer power button is 'on'.";
var connectTextThree="Confirm printer cable is plugged into computer and printer.";
var connectTextThreewBTH="Verify cable connections are secure or printer is within 10 meters of computer.";
var connectTextThreeBTH="Verify printer is within 10 meters of computer.";
var connectTextFour='Click "locate printer".';

///////////////////
//detectDialog
var detectDialogTitle="printer not detected";
var detectTextOne="Select the LPT port that the printer is connected to and click the right arrow button.";
var detectTextThree="Select the specific connection from the pull-down menu below.";
var detectChoices="connection choices:";

///////////////////
//connectHelp
var connectHelpTitle="printer still not detected";
var connectHelpText="A connection to the printer cannot be detected.";
var connectHelpText1="Check that the cable is connected to both the printer and the computer.";
var connectHelpText1wBTH="Verify cable connections are secure or printer is within 10 meters of computer.";
var connectHelpText1BTH="Verify printer is within 10 meters of computer.";
var connectHelpText2="Click the left arrow button and select a different connection than previously chosen.";

///////////////////
//connectHelpDialog
var connectHelpOne="Click the left arrow button to continue installing.";
var connectHelpTwo='Click the "x" to exit.';

//////////////
//removeTape
var removeTapeTitle="remove tape from printer";
var removeTapeTextOne="Remove tape from outside of printer.";
var removeTapeTextTwo="Open printer cover.";
var removeTapeTextThree="On left, locate and remove tape securing the print cartridge cradle.";
var removeTapeTextFour="On right, locate and remove tape securing the print cartridge cradle.";
var removeTapeText="To protect the printer, some moveable components have been secured with tape and/or packing materials. Removal of these items is recommended before continuing.";

////////////////////////////////////////////////////////////////////
// Function names correspond to respective html file with few
// exceptions 

function whatToDo(part){

	var NetworkSupportAvailable = new String(); 
	HpfInst.GetProcessString(HPIFile, "network_support", NetworkSupportAvailable);

	switch(part){
		case "title":
			document.write(wantHelp);
			break;
		case "tutorial":
			document.write(yes + spaces(1) + recommendation);
			break;
		case "tutorialText":
			document.write(yesExplanation);
			break;
		case "software":
			document.write(no);
			break;
		case "softwareText":
			document.write(noExplanation);
			break;
		case "tutorialBtn":
			document.write('<div id="opt1Button">');
			document.write('<a class="link" onClick="tutorial();" onMouseOver="SwapImageEx(this,0,\'images/largeBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + yes + '>');
			document.write('<img name="tutorialBtn" src="images/largeBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "softwareBtn":
			document.write('<div id="opt2Button">');
			document.write('<a class="link" onClick="softwareOnly();" onMouseOver="SwapImageEx(this,0,\'images/largeBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + no + '>');
			document.write('<img name="softwareBtn" src="images/largeBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "flowBtns":
			if (NetworkSupportAvailable.value == "true")
			{
			 	writeBtns('disabled','','active','commonBack();');
			}	
			else
			{
			 	writeBtns('disabled','','disabled','');
			}	
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;
	}
}

function driverCopy(part){

	switch(part) {
		case "title":
			document.write("<blink>" + pleaseWait + "</blink>");
			break;	
		case "text":
			document.write(waitStatementOne + '<p><span class="warning"><ul><li>' + waitStatementThree + '</li><li>' + waitStatementFour + '</li></ul></span><p>' + waitStatementTwo);
			break;	
		case "flowBtns":
			writeBtns('disabled','','disabled','');
			break;
		case "exitBtn":
			writeExit('disabled','');
			break;
	}
}

function pleaseWaitMessage(part){

	switch(part) {
		case "title":
			document.write("<blink>" + pleaseWait + "</blink>");
			break;	
		case "text":
			document.write(waitStatementOne + '<p><span class="warning"><ul><li>' + waitStatementThree + '</li><li>' + waitStatementFour + '</li></ul></span><p>');
			break;	
		case "flowBtns":
			writeBtns('disabled','','disabled','');
			break;
		case "exitBtn":
			writeExit('disabled','');
			break;
	}
}

function bluetoothDialog(part)
{
	switch(part) {
		case "title":
			document.write(bluetoothDialogTitle);
			break;	
		case "text":
			document.write(bluetoothDialogText);
			break;
		case "chooseLabel": 
			document.write(chooseContinueText);
			break;
		case "chooseBtn":
			document.write('<div id="chooseButton">');
			document.write('<a class="link" onClick="LoadJumpURLFromVPM(\'techsupport\',\'Bluetooth-Install\');cancelConfirmed();"; onMouseOver="SwapImageEx(this,0,\'images/smallBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + chooseContinueText + '>');
			document.write('<img name="chooseBtn" src="images/smallBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "flowBtns":
			writeBtns('disabled','','active','bluetoothDialogBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;
	}
}

function installToFile(part){

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	switch(part) {
		case "title":
			document.write(installToFileTitle);
			break;	
		case "text":
			document.write(installToFileTextOne);
			document.write('<p>'); 
                  document.write(installToFileTextTwo);              	
                  break;
		case "chooseLabel": 
			document.write(chooseGoToWeb);
			break;
		case "chooseUsbLabel":
			break;
		case "chooseBtn":
			document.write('<div id="primaryBtn">');
			document.write('<a class="link" onClick="LoadJumpURL(\'techsupport\',\'Bluetooth-Install\');cancelConfirmed();"; onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapimageEx(this)" alt=' + chooseGoToWeb + '>');
			document.write('<img name="chooseBtn" src="images/medBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "chooseUsbBtn":
			break;
		case "flowBtns":
			if (IsAssist.value == "true")
			{
				writeBtns('active','exitDialogNext();','active','installToFileBack();');
			}
			else
			{
				writeBtns('active','exitDialogNext();','disabled','');
			}
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;	

	}
}

function connectionWarning(part)
{
	switch(part) {
		case "title":
			document.write(connectionWarningTitle);
			break;	
		case "text":
			document.write(connectionWarningText1 + '<p>');
			document.write(connectionWarningText2);
			break;
		case "flowBtns":
			writeBtns('disabled','','active','connectionWarningBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function retryRecommend(part){

	var HasCalibrationSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

	var IO = new String(); 
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	switch(part) {
		case "title":
			if (HasCalibrationSupport.value != "false")
			{
				document.write(retryRecommendTitle2);
			}
			else
			{
				document.write(retryRecommendTitle);
			}
			break;	
		case "text":
			if (IO.value == "bluetooth")
			{
				document.write(retryRecommendText1);
				document.write('<ol><li>' + retryRecommendText3 + '</li>'); 
				document.write('<li>' + retryRecommendText4 + '</li></ol>'); 
			}
			else
			{
				document.write(retryRecommendText1);
				document.write('<ol><li>' + retryRecommendText5 + '</li>'); 
                  		document.write('<li>' + retryRecommendText3 + '</li>'); 
				document.write('<li>' + retryRecommendText4 + '</li></ol>'); 
			}
                  	break;
		case "flowBtns":
			writeBtns('disabled','','active','commonBack();');
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;	

	}
}

//for exitDialog and exitDialog2
function exitDialog(part){

	switch(part) {
		case "title":
			document.write(exitTitle);
			break;
		case "title2":
			document.write(cautionTitle);
			break;
		case "text":
			document.write(exitTextOne);
			document.write('<p>');
			document.write(exitTextTwo);
			break;
		case "text2":
			document.write(exitTextThree);
			document.write('<p>');
			document.write(exitTextFour);
			break;
		case "flowBtns":
			writeBtns('disabled','exitDialogNext();','active','exitDialogBack();');
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;	

	}
}

//for noBluetoothSupport
function noBluetoothSupport(part){

	switch(part) {
		case "title":
			document.write(noBluetoothSupportTitle);
			break;
		case "text":
			document.write(noBluetoothSupportOne);
			document.write(noBluetoothSupportTwo);
			document.write("<ul><li>" + noBluetoothSupportThree);
			document.write('<br>');
			document.write("<li>" + noBluetoothSupportFour + "</ul>");
			break;
		case "flowBtns":
			writeBtns('disabled','','active','noBluetoothSupportBack();');
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;	
	}
}

//for noWebSupport
function noWebSupport(part){

	switch(part) {
		case "title":
			document.write(noWebSupportTitle);
			break;
		case "text":
			document.write(noWebSupportOne);
			document.write(noWebSupportTwo);
			document.write("<ul><li>" + noWebSupportThree);
			document.write('<br>');
			document.write("<li>" + noWebSupportFour + "</ul>");
			break;
		case "flowBtns":
			writeBtns('active','exitDialogNext();','disabled','');
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;	

	}
}

function haveEverything(part)
{
	var UserConnect = new String();
	HpfInst.GetProcessString(HPIFile, "io_connect", UserConnect);

	var Duplexer = new String(); 
	HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

	var UsbOnly = new String(); 
	HpfInst.GetProcessString(HPIFile, "usb_only", UsbOnly);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	var SingleCartridge = new String(); 
	HpfInst.GetProcessString(HPIFile, "single_cartridge", SingleCartridge);

	var NoUsbSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "os_no_support_usb", NoUsbSupport);

	switch(part) {
		case "leftIdeaImage":
			document.write('<img src="images/inventoryIdeaUnit1.gif">');
			break;
		case "rightIdeaImage":
			document.write('<img src="images/inventoryIdeaUnit1.gif">');
			break;
		case "title":
			document.write(everythingTitle);
			break;
		case "line5Image":
			if ((HasBluetooth.value == "true") && (UserConnect.value == "usb"))
			{
				document.write('<img class="blueLine1" src="images/blueDividerLine.gif">');
			}
			else
			{
				document.write('<img class="blueLine2" src="images/blueDividerLine2.gif">');
			}
			break;
		case "printerImage":
			document.write('<img src="images/inventoryPrinter.gif">');
			break;
		case "duplexerImage":
			if (Duplexer.value == "true")
			{ 
				document.write('<img src="images/inventoryDuplexer.gif">');
			}
			break;
		case "bluetoothImage":
			if (HasBluetooth.value == "true")
			{ 
				if (UserConnect.value == "bluetooth")
				{
					document.write('<img src="images/inventoryBluetooth.gif">');
				}
			}
			break;
		case "parallelImage":
			if ((UsbOnly.value == "false") && (HasBluetooth.value == "false")) 
			{
				document.write('<img src="images/inventoryParallel.gif">');
			}
			break;
		case "USBImage":
			if ((HasBluetooth.value == "false") && (NoUsbSupport.value == "false"))
			{
				document.write('<img src="images/inventoryUsbCable.gif">');
			}
			break;
		case "printer":
			document.write(printerLabel);
			break;
		case "power":
			document.write(powerLabel);
			break;
		case "cartridge":
			if (SingleCartridge.value != "false")
			{
				document.write(cartridgeSingleLabel);
			}
			else
			{
				document.write(cartridgeLabel);
			}
			break;
		case "choice":
			if (HasBluetooth.value == "true")
			{ 
				if (UserConnect.value == "bluetooth")
				{
					document.write(computerLabel);
				}
				else 
				{
					document.write(usbCableLabel);
				}
			}
			else
			{
				document.write(cableLabel);
			}
			break;
		case "usb":
			if ((HasBluetooth.value == "false") && (NoUsbSupport.value == "false"))
			{
				document.write(usbLabel);
			}
			break;
		case "or":
			if ((UsbOnly.value == "false") && (HasBluetooth.value == "false") && (NoUsbSupport.value == "false"))
			{
				document.write(orLabel);
			}
			break;
		case "or2":
			document.write(orLabel);
			break;
		case "parallel":
			if ((UsbOnly.value == "false") && (HasBluetooth.value == "false")) 
			{
				document.write(parallelLabel);
			}
			break;
		case "paper":
			document.write(paperLabel);
			break;
		case "notEverythingBtn":
			document.write('<div id="notEverythingButton">');
			document.write('<a class="link" onClick="everythingNo();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + no + '>');
			document.write('<img name="notEverythingBtn" src="images/medBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "yesEverythingBtn":
			document.write('<div id="yesEverythingButton">');
			document.write('<a class="link" onClick="everythingYes();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + yes + '>');
			document.write('<img name="yesEverythingBtn" src="images/medBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "noFooter":
			document.write(no);
			break;
		case "yesFooter":
			document.write(yes);
			break;
		case "flowBtns":
			writeBtns('disabled','','active','everythingBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function haveDuplexer(part){

	switch(part) {
		case "title":
			document.write(duplexerTitle);
			break;
		case "instructions":
			document.write(duplexerText1 + '<p>');
			document.write(duplexerText2);
			break;
		case "noFooter":
			document.write(no);
			break;
		case "yesFooter":
			document.write(yes);
			break;
		case "flowBtns":
			writeBtns('disabled','','active','everythingBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function whichCable(part)
{
	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		switch(part) {
			case "title":
				if (HasBluetooth.value == "true")
				{
					document.write(cableTitleTwo);
				}
				else
				{
					document.write(cableTitle);
				}
				break;
			case "usbLabel": //NOTE: case title misleading
				if (HasBluetooth.value == "true")
				{
					document.write(bluetoothLabel);
				}
				else
				{
					document.write(usbLabel);
				}
				break;
			case "parallelLabel": //NOTE: case title misleading
				if (HasBluetooth.value == "true")
				{
					document.write(usbLabel);
				}
				else
				{
					document.write(parallelLabel);
				}
				break;
			case "imageOne":
				if (HasBluetooth.value == "true")
				{
					document.write('<div id="usbIdeaUnit"><img src="images/installBTHIdeaUnit.gif" border="0"></div>');
				}
				else
				{
					document.write('<div id="usbIdeaUnit"><img src="images/installUSBIdeaUnit.gif" border="0"></div>');
				}
				break;
			case "imageTwo":
				if (HasBluetooth.value == "true")
				{
					document.write('<div id="parallelIdeaUnit"><img src="images/installUSBIdeaUnit.gif" border="0"></div>');
				}
				else
				{
					document.write('<div id="parallelIdeaUnit"><img src="images/installParallelIdeaUnit.gif" border="0"></div>');
				}
				break;
			case "help":
				if (HasBluetooth.value == "false")
				{
					document.write(helpLabel);
				}
				break;
			case "tellMeMore1":
				if (HasBluetooth.value == "true")
				{
					document.write(tellMeMoreLabel);
				}
				break;
			case "tellMeMore2":
				if (HasBluetooth.value == "true")
				{
					document.write(tellMeMoreLabel);
				}
				break;
			case "usbBtn":  //NOTE: case tmisleading
				document.write('<div id="usbButton">');
				if (HasBluetooth.value == "true")
				{
					document.write('<a class="link" onClick="cableInstallBluetooth();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + bluetoothLabel + '>');
					document.write('<img name="paraBtn" src="images/medBtn1.gif" border="0"></a>');
				}
				else
				{
					document.write('<a class="link" onClick="cableInstallUSB();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + usbLabel + '>');
					document.write('<img name="usbBtn" src="images/medBtn1.gif" border="0"></a>');
				}
				document.write('</div>');
				break;
			case "parallelBtn": //NOTE: case misleading
				document.write('<div id="parallelButton">');
				if (HasBluetooth.value == "true")
				{
					document.write('<a class="link" onClick="cableInstallUSB();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + usbLabel + '>');
					document.write('<img name="usbBtn" src="images/medBtn1.gif" border="0"></a>');
				}
				else
				{
					document.write('<a class="link" onClick="cableInstallParallel();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + parallelLabel + '>');
					document.write('<img name="paraBtn" src="images/medBtn1.gif" border="0"></a>');
				}
				document.write('</div>');
				break;
			case "helpBtn":
				if (HasBluetooth.value == "false")
				{
				 	writeHelpBtn('helpMe();');
				}
				break;
			case "tellMeMore1Btn":
				if (HasBluetooth.value == "true")
				{
					document.write('<div id="tellMeButton1">');
					document.write('<a class="link" onClick="tellMeMore1();" onMouseOver="SwapImageEx(this,0,\'images/smallBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + tellMeMoreLabel + '>');
					document.write('<img name="tellMeMore1Btn" src="images/smallBtn1.gif" border="0"></a>');
					document.write('</div>');
				}
				break;
			case "tellMeMore2Btn":
				if (HasBluetooth.value == "true")
				{
					document.write('<div id="tellMeButton2">');
					document.write('<a class="link" onClick="tellMeMore2();" onMouseOver="SwapImageEx(this,0,\'images/smallBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + tellMeMoreLabel + '>');
					document.write('<img name="tellMeMore2Btn" src="images/smallBtn1.gif" border="0"></a>');
					document.write('</div>');
				}
				break;
			case "flowBtns":
				writeBtns('disabled','','active','whichCableBack();');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;	
		}
}

function helpChoose(part)
{
	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	switch(part) 
	{
		case "title":
			if (HasBluetooth.value == "true")
			{
				document.write(tellMeMoreLabel);
			}
			else
			{
				document.write(chooseTitle);
			}
			break;
		case "text":
			if (HasBluetooth.value == "true")
			{
				document.write(usbRequirement);
				document.write("<ul><li>" + usbOne + "<br>");
				document.write("<li>" + usbTwo2 + "<br>");
				document.write("<li>" + usbThree + "</ul>");
			}
			else
			{
				document.write(usbRequirement);
				document.write("<ul><li>" + usbOne + "<br>");
				document.write("<li>" + usbTwo + "<br>");
				document.write("<li>" + usbThree + "</ul>");
				document.write(parallelRequirement);
				document.write("<ul><li>" + parallelOne + "<br>");
				document.write("<li>" + parallelTwo + "<br>");
				document.write("<li>" + parallelThree + "</ul>");
			}
			break;
		case "flowBtns":
			writeBtns('disabled','','active','helpChooseBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function helpChoose2(part)
{
	switch(part) 
	{
		case "title":
			document.write(tellMeMoreLabel);
			break;
		case "text":
			document.write(tellMeBlueOne);
			break;
		case "flowBtns":
			writeBtns('disabled','','active','helpChoose2Back();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	

	}
}

function removeTape(part)
{				
	var color = "blue01";
	//var step = one;
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	var UnitPrep = new String(); 
	HpfInst.GetProcessString(HPIFile, "unit_prep", UnitPrep);

	switch(part) {
		case "stepNumber":
			document.write(step.value);
			break;
		case "stepTitle":
			document.write(removeTapeTitle);
			break;
		case "instructions":
			document.write(removeTapeText + "<p>");
			if (UnitPrep.value == "processTwo")
			{
				document.write("<ol><li>" + removeTapeTextOne + "</li><p>");
				document.write("<li>" + removeTapeTextTwo + "<p>");
				document.write("<li>" + removeTapeTextThree + "</li></ol>");
			}
			else if (UnitPrep.value == "processThree")
			{
				document.write("<ol><li>" + removeTapeTextOne + "</li><p>");
				document.write("<li>" + removeTapeTextTwo + "<p>");
				document.write("<li>" + removeTapeTextFour + "</li></ol>");
			}
			break;				
		case "dot":
                  document.write('<img src="images/' +  color + 'circle.gif">');
			break;
		case "flowBtns":
			writeBtns('active','removeTapeNext();','active','removeTapeBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
		}
}

function whitePaper(part)
{
	var HasAutocalibration = new String(); 
	HpfInst.GetProcessString(HPIFile, "autocalibrate", HasAutocalibration);

	var HasCalibrationSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

	switch(part) {
		case "title":
			document.write(whyTitle);
			break;
		case "text":
			if (HasCalibrationSupport.value != "false")
			{
				document.write(whyOneCross + spaces(1));
			}
			else if (HasAutocalibration.value == "true")
			{
				document.write(whyOne + spaces(1));
			}
			document.write(whyTwo);
			break;
		case "flowBtns":
			writeBtns('disabled','','active','whitePaperBack();');
			break;
		case "exitBtn":
			writeExit('active','after');
			break;	

	}
}

function attachDuplexer(part)
{		
		var color = "blue01";
		//var step = two; 

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		switch(part) {
			case "stepNumber": 
				document.write(step.value);
				break;
			case "stepTitle": 
				document.write(attachDuplexerTitle);
				break;
			case "instructions":
                        document.write("<ol><li>" + attachDuplexerOne + "</li>");
				document.write("<p>");
				document.write("<li>" + attachDuplexerTwo + "</li><p>");
				document.write('<span class="warning">' + connectDuplexerWarning + '</span></ol>');
				break;		
			case "animation":
				document.write('<img src="animation/duplexer.gif" name ="attachDuplexerAnimation">');
				document.write('</img>');
				break;
			case "dot":
                        document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'attachDuplexerNext()\');','active','ClearAnimation(\'attachDuplexerBack()\');');
				break;	
			case "exitBtn":
				writeExit('active','before');
				break;	
		}
}

function connectCable(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var NoBthSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "os_no_support_bth", NoBthSupport);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var IsOEM = new String(); 
		HpfInst.GetProcessString(HPIFile, "oem", IsOEM);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true"))
		//{
		//	var step = three;
		//}
		//else
		//{
		//	var step = two;
		//}

		switch(part) {
			case "stepNumber":
				document.write(step.value);
				break;
			case "usbStepTitle": 
				document.write(usbTitle);
				break;
			case "parallelStepTitle": 
				document.write(parallelTitle);
				break;
			case "whyNoBluetooth":
				if (HasBluetooth.value == "true") 
				{
					if (NoBthSupport.value == "true") 
					{
						document.write(noBluetoothSupportTitle);
					}
				}
				break;
			case "usbInstructions":
		  		document.write("<ol><li>" + connectCableThree + "</li>");
				document.write('<p>');
				document.write("<li>" + connectCableFour + "</li></ol>");
				break;
			case "parallelInstructions":
		  		document.write("<ol><li>" + connectCableOne + "</li>");
				document.write('<p>');
				document.write("<li>" + connectCableTwo + "</li>");
				document.write('<p>');
				if (IsOEM.value == "true")
				{
					document.write('<span class="warning">' + connectCableWarningGeneric + '</span></ol>');
				}
				else
				{
					document.write('<span class="warning">' + connectCableWarning + '</span></ol>');
				}
				break;
			case "usbAnimation":
				document.write('<img src="animation/USBCord.gif"  name="connectUsbAnimation">');
				document.write('</img>');
				break;
			case "parallelAnimation":
				document.write('<img src="animation/parallelCord.gif"  name="connectParallelAnimation">');
				document.write('</img>');
				break;
			case "dot":
				document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'connectUSBNext()\');','active','ClearAnimation(\'connectUSBBack()\');');
				break;
			case "flowBtnsP":
				writeBtns('active','ClearAnimation(\'connectParallelNext()\');','active','ClearAnimation(\'connectParallelBack()\');');
				break;
			case "noBluetoothBtn":
				if (HasBluetooth.value == "true") 
				{
					if (NoBthSupport.value == "true") 
					{
						document.write('<div id="noBth">');
						document.write('<a class="link" onClick="ClearAnimation(\'whyNoBth()\');" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + noBluetoothSupportTitle + '>');
						document.write('<img name="noBthBtn" src="images/medBtn1.gif" border="0"></a>');
						document.write('</div>');
					}
				}
				break;	
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}

function powerCord(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true"))
		//{
		//	var step = four;
		//}
		//else
		//{
		//	var step = three;
		//}

		switch(part) {
			case "stepNumber":
				document.write(step.value);
				break;
			case "stepTitle": 
				document.write(powerTitle);
				break;
			case "instructions":
				if (IO.value == "bluetooth")
				{
					document.write("<ol><li>" + powerBluetoothOne + "</li>");
					document.write('<p>');
					document.write("<li>" + powerBluetoothTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + powerBluetoothThree + "</li>");
					document.write('<p>');
					document.write("<li>" + powerBluetoothFour + "</li></ol>");
				}
				else
				{ 	
		  			document.write("<ol><li>" + powerCordOne + "</li>");
					document.write('<p>');
					document.write("<li>" + powerCordTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + powerCordThree + '</li><p>');
					if (IO.value == "usb")
					{
						document.write('<span class="warning">' + powerCordNote + '</span></ol>');
					}
					else
					{
						document.write("</ol>");
					}
				}
				break;
			case "animation":
				if (IO.value == "bluetooth")
				{
					document.write('<img src="animation/powerCord_bt.gif"  name="powerCordAnimation">');
					document.write('</img>');
				}
				else
				{
					document.write('<img src="animation/powerCord.gif"  name="powerCordAnimation">');
					document.write('</img>');
				}
				break;
			case "dot":
				document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'powerCordNext()\');','active','ClearAnimation(\'powerCordBack()\');');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}

function loadPaper(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var LoadPaperSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "loadpaper_support", LoadPaperSupport);

		var HasAutocalibration = new String(); 
		HpfInst.GetProcessString(HPIFile, "autocalibrate", HasAutocalibration);

		var HasCalibrationSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true"))
		//{
		//	var step = five;
		//}
		//else
		//{
		//	var step = four;
		//}

		switch(part) {
			case "stepNumber":
				document.write(step.value);
				break;
			case "stepTitle": 
				document.write(paperTitle);
				break;
			case "instructions":
				if (LoadPaperSupport.value == "processOne")
				{
					document.write("<ol><li>" + loadPaperOneCross + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperTwoCross + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperThreeCross + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper1 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperFourCross + "</li></ol>");	
				}
				else if (LoadPaperSupport.value == "processTwo")
				{
					document.write("<ol><li>" + loadPaper3 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper5 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper6 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper8 + "</li></ol>");
				}
				else if (LoadPaperSupport.value == "processThree")
				{
					document.write("<ol><li>" + loadPaper2 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper5 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper6 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper7 + "</li></ol>");
				}
				else if (LoadPaperSupport.value == "processFour")
				{
					document.write("<ol><li>" + loadPaperOneFBolt + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper9 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper4 + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaper6 + "</li></ol>");
				}
				else if (LoadPaperSupport.value == "processFive")
				{
					document.write("<ol><li>" + loadPaperOneF + "</li>");	
					document.write('<p>');
					document.write("<li>" + loadPaperTwoF + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperThreeF + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperFourF + "</li></ol>");
				}
				else if (LoadPaperSupport.value == "processSix")
				{
					document.write("<ol><li>" + loadPaperOneFBolt + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperTwoF + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperThreeF + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperFourF + "</li></ol>");
				}
				else	if (LoadPaperSupport.value == "processSeven")
				{
					document.write("<ol><li>" + loadPaperOne + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + loadPaperThree + "</li></ol>");	
				}
				break;
			case "why":
				if ((HasAutocalibration.value == "true") || (HasCalibrationSupport.value != "false"))
				{
					document.write(whyLabel);
				}
				break;
			case "animation":
				document.write('<img src="animation/insertPaper.gif" name="loadPaperAnimation">');
				document.write('</img>');
				break;
			case "dot":
				document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "whyBtn":
				if ((HasAutocalibration.value == "true") || (HasCalibrationSupport.value != "false"))
				{
					document.write('<div id="whyButton">');
					document.write('<a class="link" onClick="ClearAnimation(\'whyWhitePaper()\');" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + whyLabel + '>');
					document.write('<img name="whyBtn" src="images/medBtn1.gif" border="0"></a>');
					document.write('</div>');
				}
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'loadPaperNext()\');','disabled','');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}

function prepareCartridges(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var HasSingleCartridge = new String(); 
		HpfInst.GetProcessString(HPIFile, "single_cartridge", HasSingleCartridge);

		var CanCartridgeInvert = new String(); 
		HpfInst.GetProcessString(HPIFile, "invert_cartridge", CanCartridgeInvert);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true"))
		//{
		//	var step = six;
		//}
		//else
		//{
		//	var step = five;
		//}

		switch(part) {
			case "stepNumber":
				document.write(step.value);
				break;
			case "stepTitle": 
				if (HasSingleCartridge.value != "false")
				{
					document.write(prepareTitle1);
				}
				else
				{
					document.write(prepareTitle);
				}
				break;
			case "instructions":
				if (HasSingleCartridge.value != "false")
				{
					document.write("<ol><li>" + prepareCartridgesOne1 + "</li>");
					document.write('<p>');
					if (CanCartridgeInvert.value == "false")
					{
						document.write('<span class="warning">' + prepareWarning2 + '</span>');
						document.write('<p>');
					}
					document.write("<li>" + prepareCartridgesTwo1 + "</li>");
					document.write('<p>');
					document.write('<span class="warning">' + prepareWarning1 + '</span>');
					document.write('<p>');
					document.write('<p>');
					if (HasSingleCartridge.value == "tri-color")
					{
						document.write(preparePurchaseBlackPen + '</ol>');
					}
					else if (HasSingleCartridge.value == "black")
					{
						document.write(preparePurchaseColorPen + '</ol>');
					}
				}
				else
				{
					document.write("<ol><li>" + prepareCartridgesOne + "</li>");
					document.write('<p>');
					if (CanCartridgeInvert.value == "false")
					{
						document.write('<span class="warning">' + prepareWarning2 + '</span>');
						document.write('<p>');
					}
					document.write("<li>" + prepareCartridgesTwo + "</li>");
					document.write('<p>');
					document.write('<span class="warning">' + prepareWarning + '</span></ol>');
				}
				break;
			case "animation":
				document.write('<img src="animation/prepInk.gif"  name="prepareCartridgesAnimation">');
				document.write('</img>');
				break;
			case "dot":
				document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'prepareCartridgesNext()\');','active','ClearAnimation(\'prepareCartridgesBack()\');');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}

function installCartridges(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var CartridgeType = new String(); 
		HpfInst.GetProcessString(HPIFile, "installcartridge_support", CartridgeType);

		var HasSingleCartridge = new String(); 
		HpfInst.GetProcessString(HPIFile, "single_cartridge", HasSingleCartridge);

		var AutoCalibrate = new String(); 
		HpfInst.GetProcessString(HPIFile, "autocalibrate", AutoCalibrate);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true"))
		//{
		//	var step = seven;
		//}
		//else
		//{
		//	var step = six;
		//}

		switch(part) {
			case "stepNumber":
				document.write(step.value);
				break;
			case "stepTitle": 
				if (HasSingleCartridge.value != "false") 
				{
					document.write(installTitle1);
				}
				else
				{
					document.write(installTitle);
				}
				break;
			case "instructions":
				if ((CartridgeType.value == "tig2.xTwo") && (HasSingleCartridge.value == "false")) 
				{
					document.write("<ol><li>" + installCartridgesCrossOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossThree + '</li></ol>');		
				} 
				else if ((CartridgeType.value == "tig2.xTwo") && (HasSingleCartridge.value == "tri-color")) 
				{
					document.write("<ol><li>" + installCartridgesCrossOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossSingle + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossThree + '</li></ol>');		
				} 
				else if ((CartridgeType.value == "tig2.xTwo") && (HasSingleCartridge.value == "black")) 
				{
					document.write("<ol><li>" + installCartridgesCrossOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossSingleB + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesCrossThree + '</li></ol>');		
				} 
				else if ((CartridgeType.value == "tig2.xOne")&& (HasSingleCartridge.value == "false")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesMalibuThree + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');
				}
				else if ((CartridgeType.value == "tig2.xOne")&& (HasSingleCartridge.value == "tri-color")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoL1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesMalibuThreeOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');
				}
				else if ((CartridgeType.value == "tig2.xOne")&& (HasSingleCartridge.value == "black")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoR1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesMalibuThreeOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');
				}
				else if ((CartridgeType.value == "tig2.5") && (HasSingleCartridge.value == "false")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwo + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesThree + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');
				}
				else if ((CartridgeType.value == "tig2.5") && (HasSingleCartridge.value == "tri-color")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoL1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesThreeL1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');			
				}	
				else if ((CartridgeType.value == "tig2.5") && (HasSingleCartridge.value == "black")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoR1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesThreeR1 + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');			
				}	
				else if ((CartridgeType.value == "tig2.0") && (HasSingleCartridge.value == "false")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoOld + "</li>");
					document.write('<p>');
					document.write("<li>" +installCartridgesThreeOld + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');			
				} 
				else if ((CartridgeType.value == "tig2.0") && (HasSingleCartridge.value != "false")) 
				{
					document.write("<ol><li>" + installCartridgesOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesTwoOldOne + "</li>");
					document.write('<p>');
					document.write("<li>" +installCartridgesThreeOldOne + "</li>");
					document.write('<p>');
					document.write("<li>" + installCartridgesFour + "</li>");
					document.write('<p>');			
				} 
				if (AutoCalibrate.value == "true")
				{
					document.write('<span class="warning">' + installWarning2 + '</span></ol>');
				}
				break;
			case "animation":
				document.write('<img src="animation/insertInk.gif"  name="installCartridgesAnimation">');
				document.write('</img>');
				break;
			case "dot":
				document.write('<img src="images/' +  color + 'circle.gif">');
				break;
			case "flowBtns":
				writeBtns('active','ClearAnimation(\'installCartridgesNext()\');','active','ClearAnimation(\'installCartridgesBack()\');');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}

function printSample(part){

		var color = "blue01";

		var Duplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var HasCalibrationSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

		var IsAssist = new String();
		HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

		var IsNetworkInstallation = new String(); 
		HpfInst.GetProcessString(HPIFile, "network_install", IsNetworkInstallation);

		var IsOEM = new String(); 
		HpfInst.GetProcessString(HPIFile, "oem", IsOEM);

		var step = new String();
		HpfInst.GetProcessString(HPIFile, "current_step_number", step);

		//if (((HasBluetooth.value == "true") && (IO.value == "usb")) || (Duplexer.value == "true") || (HasCalibrationSupport.value != "false"))
		//{
		//	var step = eight;
		//}
		//else
		//{
		//	var step = seven;
		//}

		switch(part) {
			case "stepNumber": 
				if ((IsAssist.value == "true") && ((IsNetworkInstallation.value == "false") || (IsNetworkInstallation.value == "unknown")))
				{
					document.write(step.value);
				}
				break;
			case "stepTitle": 
				if ((IsNetworkInstallation.value == "false") || (IsNetworkInstallation.value == "unknown"))
				{
					document.write(printTitle);
				}
				break;
			case "networkTitle":
				if (IsNetworkInstallation.value == "true")
				{
					document.write(printTitle);
				}
				break;
			case "instructions":
				if (IsOEM.value == "true")
				{
		  	      	document.write('<ol><li>' + printSampleTwoGeneric + "</ol>");
				}
				else
				{
		  	      	document.write('<ol><li>' + printSampleTwo + "</ol>");
				}
				break;
			case "print":
		  	      document.write(printLabel);
				break;
			case "animation":
				document.write('<img src="animation/confirmSample.gif"  name="confirmSampleAnimation">');
				document.write('</img>');
				break;
			case "dot":
				if ((IsNetworkInstallation.value == "false") || (IsNetworkInstallation.value == "unknown"))
				{
                        	document.write('<img src="images/' +  color + 'circle.gif">');
				}
				break;
			case "printBtn":
				document.write('<div id="secondaryBtn">');
				document.write('<a class="link" onClick="ClearAnimation(\'printSampleYes()\');" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + printLabel + '>');
				document.write('<img name="printBtn" src="images/medBtn1.gif" border="0"></a>');
				document.write('</div>');
				break;
			case "flowBtns":
				if (IsAssist.value == "true")
				{
					writeBtns('active','ClearAnimation(\'printSampleNext()\');','active','ClearAnimation(\'printSampleBack()\');');
				}
				else
				{
					if (HasCalibrationSupport.value != "false")
					{
						writeBtns('active','ClearAnimation(\'printSampleNext()\');','active','ClearAnimation(\'printSampleBack()\');');
					} 
					else
					{
						writeBtns('active','ClearAnimation(\'printSampleNext()\');','disabled','');
					}
				}
				break;	
			case "exitBtn":
				writeExit('active','after');
				break;
		}
}

function confirmSample(part){

		var color = "blue01";

		var HasCalibrationSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

		var IsNetworkInstallation = new String(); 
		HpfInst.GetProcessString(HPIFile, "network_install", IsNetworkInstallation);

		switch(part) {
			case "stepTitle": 
				if ((IsNetworkInstallation.value == "false") || (IsNetworkInstallation.value == "unknown"))
				{
					if (HasCalibrationSupport.value != "false")
					{
						document.write(confirmPageTitle);
					}
					else
					{
						document.write(confirmTitle);
					}
				}
				break;
			case "networkTitle":
				if (IsNetworkInstallation.value == "true")
				{ 
					if (HasCalibrationSupport.value != "false")
					{
						document.write(confirmPageTitle);
					}
					else
					{
						document.write(confirmTitle);
					}
				}
				break;
			case "confirmation":
				if (HasCalibrationSupport.value != "false")
				{
					document.write(confirmPageText);
				}
				else
				{
					document.write(confirmText);
				}
				break;
			case "yes":
		  		document.write(yes);
				break;	
			case "no":
		  		document.write(no);
				break;
			case "again":
				if (HasCalibrationSupport.value != "false")
				{
					document.write(againPageLabel);
				}
				else
				{
					document.write(againLabel);
				}
				break;							
			case "dot":
				if ((IsNetworkInstallation.value == "false") || (IsNetworkInstallation.value == "unknown"))
				{
					document.write('<img src="images/' +  color + 'circle.gif">');
				}
				break;
			case "yesBtn":
				document.write('<div id="yes">');
				if (HasCalibrationSupport.value != "false")
				{
					document.write('<a class="link" onClick="confirmPageYes();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')"onMouseOut="SwapImageEx(this)" alt=' + yes + '>');
				}
				else
				{
					document.write('<a class="link" onClick="confirmSampleYes();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')"onMouseOut="SwapImageEx(this)" alt=' + yes + '>');
				}
				document.write('<img name="yesBtn" src="images/medBtn1.gif" border="0"></a>');
				document.write('</div>');
				break;
			case "noBtn":
				document.write('<div id="no">');
				document.write('<a class="link" onClick="confirmSampleNo();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + no + '>');
				document.write('<img name="noBtn" src="images/medBtn1.gif" border="0"></a>');
				document.write('</div>');
				break;
			case "againBtn":
				document.write('<div id="primaryBtn">');
				if (HasCalibrationSupport.value != "false")
				{
					document.write('<a class="link" onClick="confirmPageAgain();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + againPageLabel + '>');
				}
				else
				{
					document.write('<a class="link" onClick="confirmSampleAgain();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + againLabel + '>');
				}
				document.write('<img name="againBtn" src="images/medBtn1.gif" border="0"></a>');
				document.write('</div>');
				break;
			case "flowBtns":
				if (HasCalibrationSupport.value != "false")
				{
					writeBtns('disabled','ClearAnimation(\'confirmPageNext()\');','active','confirmSampleBack();');
				}
				else
				{
					writeBtns('disabled','ClearAnimation(\'confirmSampleNext()\');','active','confirmSampleBack();');
				}
				break;
			case "exitBtn":
				writeExit('active','after');
				break;
		}
}

function troubleshootSoft(part){

		var IO = new String(); 
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var IsAssist = new String();
		HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

		var HasDuplexer = new String();
		HpfInst.GetProcessString(HPIFile, "duplexer", HasDuplexer);

		var HasCalibrationSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

		var UnAssistInstallDone = new String();
	      	HpfInst.GetProcessString(HPIFile, "unassist_install_done", UnAssistInstallDone);

		var HasSingleCartridge = new String(); 
		HpfInst.GetProcessString(HPIFile, "single_cartridge", HasSingleCartridge);

		var LoadPaperSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "loadpaper_support", LoadPaperSupport);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		switch(part) {
			case "title":
				document.write(troubleTitle);
				break;
			case "verifyCable":
				if (HasBluetooth.value == "true")
				{
					if (IO.value == "bluetooth")
					{
						document.write('<li>' + troubleDuplexer);
					}
					else if (IO.value == "usb")
					{
						document.write('<li>' + troubleCable);
					}
					else
					{
						document.write('<li>' + troubleConnection);
					}
				}
				else
				{
					document.write('<li>' + troubleCable);
				}
				break;
			case "verifyPower":
				document.write('<li>' + troublePower);
				break;
			case "verifyPaper":
				if (LoadPaperSupport.value == "processOne")
				{
					document.write('<li>' + troublePaperCross);
				}
				else if ((LoadPaperSupport.value == "processFive") || (LoadPaperSupport.value == "processSix"))
				{
					document.write('<li>' + troubleTray);
				}
				else
				{
					document.write('<li>' + troublePaper);
				}
				break;
			case "verifyTape":
				if (HasSingleCartridge.value != "false")
				{
				 	document.write('<li>' + troubleSingleTape);
				}
				else
				{
					document.write('<li>' + troubleTape);
				}
				break;
			case "verifyCartridges":
				if (HasSingleCartridge.value != "false")
				{
					document.write('<li>' + troubleCartridge);
				}
				else
				{
					document.write('<li>' + troubleCartridges);
				}
				break;
			case "verifyDuplexer":
				if (HasDuplexer.value != "false")
				{
					document.write('<li>' + troubleDuplexer);
				}
				break;
			case "ifNo":
				if ((IsAssist.value == "true")||(UnAssistInstallDone.value == "true"))
				{
					if (HasCalibrationSupport.value != "false")
					{ 
						document.write (troubleIf2);
					}
					else
					{ 
						document.write (troubleIf);
					}
				}
				break;
	            case "footer":
				if ((IsAssist.value == "false") && (UnAssistInstallDone.value == "false")) 
				{
					document.write (troubleInstall);			
				}
				else
				{
					document.write(troubleContinue);
				}
	                  break;
			case "flowBtns":
				writeBtns('active','troubleshootSoftNext();','active','troubleshootSoftBack();');
				break;
			case "exitBtn":
				writeExit('active','before');
				break;
		}
}		

function notEverything(part){

	var IsOEM = new String(); 
	HpfInst.GetProcessString(HPIFile, "oem", IsOEM);

	switch(part){
		case "title":
			document.write(notEverythingTitle);
			break;
		case "text":
			if (IsOEM.value == "true")
			{
				document.write(notEverythingOneGeneric + spaces(1));
		      		document.write(notEverythingTwoGeneric + spaces(1));
			}
			else
			{
				document.write(notEverythingOne + spaces(1));
		      		document.write(notEverythingTwo + spaces(1));
			}
			document.write(notEverythingThree);
			document.write('<br><br>');
			document.write(notEverythingFour);
			break;
		case "flowBtns":
			writeBtns('disabled','notEverythingNext();','active','notEverythingBack();');
			break;
		case "exitBtn":
			writeExit('active','neither');
			break;
	}
}

function BthUrl()
{
	return "www.hp.com/support/bluetooth";

}

function connectDialog(part)
{
	var IO = new String(); 
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	switch(part) {
		case "title":	
			document.write(connectDialogTitle);
			break;	
		case "text":
			document.write("<ol><li>" + connectTextOne);
		      document.write("<li>" + connectTextTwo);	
			if (IO.value == "bluetooth")
			{
				document.write("<li>" + connectTextThreeBTH);
			}
			else if (HasBluetooth.value == "true")
			{
				document.write("<li>" + connectTextThreewBTH);
			}
			else
			{
				document.write("<li>" + connectTextThree);
			}
			document.write("<li>" + connectTextFour + "</ol>");			
                  break;	
		case "locate":
			document.write(locateText);
			break;
		case "flowBtns":
			writeBtns('disabled','connectDialogNext();','active','connectDialogBack();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function detectDialog(part)
{
	var NoUsbSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "os_no_support_usb", NoUsbSupport);

	var IO = new String(); 
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	switch(part) {
		case "title":	
			document.write(detectDialogTitle);
			break;	
		case "text":
			if (((NoUsbSupport.value == "true") || (IO.value == "parallel")) && (IsAssist.value == "true"))
			{
				document.write(detectTextOne);
			}
			else
			{
				document.write(detectTextThree);
			}
                  break;
		case "detectTitle":
          		document.write(detectChoices);
                  break;
		case "flowBtns":
			writeBtns('active','detectDialogNext();','active','detectDialogBack();');
			break;
		case "helpBtn":
			writeHelpBtn('toConnectHelp();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

function connectHelpDialog(part)
{
	var IO = new String(); 
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	var USBPortsFound = new String(); 
	HpfInst.GetProcessString(HPIFile, "usb_port_detection", USBPortsFound);

	switch(part) {
		case "title":	
			document.write(connectHelpTitle);
			break;	
		case "text":
			document.write(connectHelpText);
			if (USBPortsFound.value == "false")
			{
				document.write('<ul><li>' + connectHelpOne + '</li>');
				document.write('<li>' + connectHelpTwo + '</li>');
			}
			else if (IO.value == "bluetooth")
			{
				document.write('<ul><li>' + connectHelpText1BTH + '</li>');
			}
			else if (HasBluetooth.value == "true")
			{
				document.write('<ul><li>' + connectHelpText1wBTH + '</li>');
			}
			else
			{
				document.write('<ul><li>' + connectHelpText1 + '</li>');
			}
			if (USBPortsFound.value != "false")
			{
				document.write('<li>' + connectHelpText2 + '</li>');
			}
			document.write('</ul>');
                  break;
		case "flowBtns":
			writeBtns('disabled','','active','connectHelpBack();');
			break;
		case "helpBtn":
			writeHelpBtn('toConnectHelp();');
			break;
		case "exitBtn":
			writeExit('active','before');
			break;	
	}
}

