///////////////////////////////////////////////
//for screen-reader support *only* (accessibilty)
var replayButton="replay";
var helpButton="help";
var exitButtonLabel="exit";
var continueButton="continue";
var backButton="back";

////////////////////////////////////////////////////////////////////////////////
// Setup
////////////////////////////////////////////////////////////////////////////////

var UtilBroker = Components.classes["component://netscape/utilitybroker"].createInstance();
UtilBroker = UtilBroker.QueryInterface(Components.interfaces.hpIUtilityBroker);

var HpfInst = Components.classes["@dugout/infield/instservice;1"].getService(Components.interfaces.IInstService);

////////////////////////////////////////////////////////////////////////////////
// Global Values
////////////////////////////////////////////////////////////////////////////////
var strTempPath = new String();
HpfInst.GetProcessString("master.hpi", "2", strTempPath);
var HPIFile = strTempPath.value + "master.hpi";

var strDriverName = new String();
HpfInst.GetProcessString( HPIFile, "printerdriver", strDriverName);

if(top.document.debug)
{
	if(top.document.URL.match(/\?/))
	{
		params=top.document.URL.slice(top.document.URL.indexOf("?")+1)
		if(params)
			params=params.split(",");

		if(params && params.length)
		{
			for(var i=0;i<params.length;i++)
			{
				keyval=params[i].split("=");
				if(keyval && keyval.length > 1)
					HpfInst.SetProcessString(keyval[0],keyval[1])
			}
		}
	}
}

var bResult = Object();

var PES_MACROS  = 1;
var PES_ESCAPES = 2;
var PES_FIELDS  = 4;
var PES_ALL     = PES_MACROS | PES_ESCAPES | PES_FIELDS;
var Timeout     = 60;

//for UI...  move to a localized file if numbers ever localized
var one = "1"; 
var two = "2";
var three = "3";
var four = "4";
var five = "5";
var six = "6";
var seven = "7";
var eight = "8";
var nine = "9";

////////////////////////////////////////////////////////////////////////////////
// More/Less Global Functions
////////////////////////////////////////////////////////////////////////////////

//HpfInst.InitProcess(null, true);

function OutputToLogFile(message)
{
	var now = new Date();
	HpfInst.OutputToLogFile( "[" + now.toString() + "] " + message);
}

function spaces(num)
{
   var spc = new String();

   for(var i=0; i<num; i++)
      spc += "\u00a0";

   return spc;
}

function continueWhenUSBAttached()
{
	HpfInst.IsGlueFinished( bResult);
	if( bResult.value)
	{
		ClearAnimation('location = "driverCopy.html"');
	}
	else
	{
		setTimeout( "continueWhenUSBAttached();", 1250);
	}
}

// log HTML page URL
OutputToLogFile(document.URL);

function ConvertStringToBool(strInput, bDefault)
{
	var sInput = strInput.toLowerCase();
	var result = bDefault;

	if ( "true" == sInput)
	{
		result = true;
	}
	else if ( "false" == sInput)
	{
		result = false;
	}

	return result;
}

function cancelConfirmed()
{
      DisableBackground();
	HpfInst.InstRestoreSourcePath();

	var inString = "$CloseApp$"; 
	var returnValue = new Object();
	var outString = new Object();
	UtilBroker.HPExpandString(inString,outString,returnValue);
}

function commonBack()
{
	window.back();
}

// Its unnecessary to call setport after a call to FindDeviceOnPort
// because that function will set these macros
function setPort(port)
{
	// passes in port and may have a colon on the end
	HpfInst.SetProcessString( "port", port);

	// remove colon on end for sport macro
	var sport = port.split( ":");
	HpfInst.SetProcessString( "sport", sport[0]);
}

////////////////////////////////////////////////////////////////////////////////
//  functions for whatToDo.html
////////////////////////////////////////////////////////////////////////////////
// NOTE THAT THIS IS A DUMMY PAGE TO ALLOW TIME FOR THE CHARSET TO LOAD & TO CHECK FOR OS COMPATIBILITY
// Requirements on entry:
//
// Requirements on exit:
//

function onloadWhatTemp()
{
	//determine and store state variables
	SetInitialStateVariables();

	// cement browser down
        var returnValue = new Object();
        var outString = new Object();	
        var inString = "$DisableMoveWindow$"; 
	UtilBroker.HPExpandString( inString, outString, returnValue);

	EnableBackground();

       //first check to see if we are in hardware first
	checkForHw1st();

}

function onunloadWhatTemp(){}

function checkForHw1st()
{
   dump("\nJS: In checkForHw1st()");
  var strTemp = new String();
	var glueInstalledDriver;
	var hw1st;
	var result;
	var bPnp;
	var bUsb;

	HpfInst.GetProcessString( HPIFile, "pnp", strTemp);
	bPnp = ConvertStringToBool( strTemp.value, false);

	HpfInst.GetProcessString( HPIFile, "usb", strTemp);
	bUsb = ConvertStringToBool( strTemp.value, false);

	hw1st = bPnp || bUsb;
	if ( hw1st)
	{
		HpfInst.SetProcessString( "hw1st", "true");
	}
	else
	{
		HpfInst.SetProcessString( "hw1st", "false");
	}

	HpfInst.DidGlueRun( bResult);
	if( bResult.value)
	{
		HpfInst.WaitOnGlueFinish( Timeout, bResult);
	}

	var strInstalledPort = new String();
	HpfInst.GlueInstalledDriver( strDriverName.value, strInstalledPort, bResult);
	if( bResult.value)
	{
		glueInstalledDriver = true;
		HpfInst.SetProcessString( "GlueInstalledDriver", "true");
		setPort( strInstalledPort.value);
	}
	else
	{
		glueInstalledDriver = false;
		HpfInst.SetProcessString( "GlueInstalledDriver", "false");
	}

	if ( hw1st || glueInstalledDriver)
	{
		// next screen is Install Progress
		// the port/sport macros have been set by the cmdline or by the return value
		// from GlueInstalledDriver above
		location="driverCopy.html";
	} 
   else
   {
      //if not hardware first, check for network support
      checkForNetworkSupport();
   }
}

function checkForNetworkSupport()
{
   dump("\nJS: In checkForNetworkSupport()");
   var NetworkSupportAvailable = new String(); 
	HpfInst.GetProcessString(HPIFile, "network_support", NetworkSupportAvailable);

	if (NetworkSupportAvailable.value == "true")
	{
		//user going to network install path
		HpfInst.SetProcessString("network_install", "true");
		location="installType.html";
	}
	else
	{
	   // if no network support, start with whattodo2
	  setTimeout("goToVPMStartProcess();",300); 	   
	}		
}

function goToVPMStartProcess()
{
   dump("\nJS: In goToVPMStartProcess()");
	location="whatToDo2.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for whatToDo2.html
////////////////////////////////////////////////////////////////////////////////
//
// Requirements on entry:
//
// Requirements on exit:
//

function onloadWhat()
{
	//determine and store state variables (redone here as user may come back to change paths)

	SetInitialStateVariables();

	HpfInst.InitProcess( null, true);

}

function onunloadWhat()
{
	//user not going to network install path
	HpfInst.SetProcessString("network_install", "false");
}

function tutorial()
{
	//user taking assisted path
	HpfInst.SetProcessString("assist_install", "true");

	var Duplexer = new String(); 
	HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	if (Duplexer.value == "optional") 
	{
		location = "haveDuplexer.html";
	}
	else if (HasBluetooth.value == "false")
	{	
		location="haveEverything.html";
	}
	else
	{
		var NoBthSupport = new String(); 
		HpfInst.GetProcessString(HPIFile, "os_no_support_bth", NoBthSupport);

		if (NoBthSupport.value == "true")
		{
			//user can only install using usb as os does not support bth
			HpfInst.SetProcessString("io_connect", "usb");
			location="haveEverything.html";		
		}
		else
		{
			location="whichCable.html";
		}
	}
}

function softwareOnly()
{
	//user taking unassisted path
	HpfInst.SetProcessString("io_connect", "unknown");
	HpfInst.SetProcessString("assist_install", "false");
	location="troubleshootSoft.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for haveDuplexer.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadDuplexer(){}

function onunloadDuplexer(){}

function duplexerBack()
{
	window.back();
}

function duplexerYes()
{
	//user will be in attach duplexer state
	HpfInst.SetProcessString( "duplexer", "true");
	location="haveEverything.html";
}

function duplexerNo()
{
	//user will not be in attach duplexer state
	HpfInst.SetProcessString( "duplexer", "false");
	location="haveEverything.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for haveEverything.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadEverything()
{  
	var UsbOnly = new String(); 
	HpfInst.GetProcessString(HPIFile, "usb_only", UsbOnly);

	var NoUsbSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "os_no_support_usb", NoUsbSupport);

	if (UsbOnly.value == "true") 
	{
		//user limited to usb-related states
		HpfInst.SetProcessString( "io_connect", "usb");
	}
	else if (NoUsbSupport.value == "true") 
	{
		//user limited to parallel-related states (note: bth products do not get to this screen as no bth product is supported on no usb support os(s))
		HpfInst.SetProcessString( "io_connect", "parallel");
	}
}

function onunloadEverything(){}

function everythingBack()
{
	window.back();
}

function everythingYes()
{
	var IO = new String(); 	
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	if (IO.value == "unknown")
	{
		location="whichCable.html";
	}
 	else
	{
		location="removeTape.html";
	}
}

function everythingNo()
{
	location="notEverything.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for whichCable.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadCable(){}

function onunloadCable(){}

function whichCableBack()
{
	window.back();
}

function cableInstallUSB()
{
	//user selects usb installation
      HpfInst.SetProcessString( "io_connect", "usb");

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	if (HasBluetooth.value == "false")
	{ 
		location="removeTape.html";
	}
	else
	{
		location="haveEverything.html";
	}
}

function cableInstallParallel()
{
	//user selects parallel installation
	HpfInst.SetProcessString( "io_connect", "parallel");

	location="removeTape.html";
}

function cableInstallBluetooth()
{
	var PortArray = new String();
	var NumPorts = new Number();
	var strInstalledPort = new String();

	//used to determine if BTH install has to be to file or to BTH port
	HpfInst.FindDeviceOnPortEx( HPIFile, "BTH:", PortArray, NumPorts, strInstalledPort, "BTH", 1, bResult);

	if (NumPorts.value == 0)
	{
		//there are no bth ports on this printer; user taken to state where dongle attachment is possible through installation to file
		HpfInst.SetProcessString( "bth_install_to_file", "true");
		setPort("FILE:");
	}

	//user selects bluetooth installation
      HpfInst.SetProcessString( "io_connect", "bluetooth");
	location="haveEverything.html";
}

function helpMe()
{
	location="helpMeChoose.html";
}

function tellMeMore1()
{
	location="helpMeChoose2.html";
}

function tellMeMore2()
{
	location="helpMeChoose.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for removeTape.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadRemoveTape(){}

function onunloadRemoveTape(){}

function removeTapeBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function removeTapeNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;	
	HpfInst.SetProcessString("current_step_number", step);

	var IO = new String(); 	
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var Duplexer = new String(); 	
	HpfInst.GetProcessString(HPIFile, "duplexer", Duplexer);

	if (Duplexer.value == "true")
	{
		location="attachDuplexer.html";
	}
	else if (IO.value == "usb")
	{
		location="connectUSB.html";
	}
	else
	{
		location="connectParallel.html";
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectParallel.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadParallel(){}

function onunloadParallel(){}

function connectParallelBack()
{	
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function connectParallelNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;
	HpfInst.SetProcessString("current_step_number", step);

	location="powerCord.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectBluetooth.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadBluetooth(){}

function onunloadBluetooth(){}

function whyNoBth()
{
	location = "noBluetoothSupport.html";     
}

function connectBluetoothBack()
{	
	window.back();
}

function connectBluetoothNext()
{
	location="powerCord.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectUSB.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadUSB(){}

function onunloadUSB(){}

function connectUSBBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function connectUSBNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;	
	HpfInst.SetProcessString("current_step_number", step);

	location="powerCord.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for powerCord.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadPower()
{
	continueWhenUSBAttached();
}

function onunloadPower(){}

function powerCordBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function powerCordNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;
	HpfInst.SetProcessString("current_step_number", step);

   	var strCheckUSB = new String(); 	
	HpfInst.GetProcessString(HPIFile, "conduct_usb_check", strCheckUSB);

	if (strCheckUSB.value == "true")
	{
	   	var bHotPluggedUSB = new Object();
      		HpfInst.IsCurrentDeviceHotPlugged(HPIFile, bHotPluggedUSB);
	   	if (bHotPluggedUSB.value)
	   	{
	      		OutputToLogFile("\nJS: powerCordNext: DETECTED Crossbow printer");
		      	location="pleaseWait.html";
	   	}
		else
		{
			installProcess();
		}
	}
   	else
   	{
		installProcess();
   	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for driverCopy.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadDriver()
{
	setTimeout( "conductInstallProgress();", 500);
}

function conductInstallProgress()
{	
	var strHW1ST = new String();
	var glueInstalledDriver;
	var hw1st;
	var result;

	HpfInst.BeginWaitCursor();
	HpfInst.GetProcessString( HPIFile, "hw1st", strHW1ST);
	hw1st = ConvertStringToBool( strHW1ST.value, false);

	var strInstalledPort = new String();
	HpfInst.GlueInstalledDriver( strDriverName.value, strInstalledPort, bResult);

	if ( !hw1st && !bResult.value)
	{
	   	dump("\nJS: Calling GLUE in HPI file! ");
		HpfInst.ProcessAndWait( HPIFile, "call_run_glue_install");
		HpfInst.WaitOnGlueFinish( Timeout, bResult);
	}

	HpfInst.ProcessAndWait( HPIFile, "install");
	HpfInst.EndWaitCursor();
	afterInstall();			
}

// make conditional dependent on release
function afterInstall()
{
	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	var strPort = new String();
	HpfInst.GetProcessString(HPIFile, "port", strPort);

	var IsNetworkInstallation = new String(); 
	HpfInst.GetProcessString(HPIFile, "network_install", IsNetworkInstallation);

	var HasCalibrationSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	if (IsNetworkInstallation.value == "true")
	{	
		location = "printSample.html";
	}
	else if (IsAssist.value == "true")
	{	
		location = "loadPaper.html";
	}
	else if ((strPort.value.toLowerCase() == "file:") && (HasBluetooth.value == "true"))
	{
		location = "installToFile.html";
	}
	else if (HasCalibrationSupport.value != "false")
	{
		location = "doCalibration.html";
	}
	else
	{
		location = "printSample.html";
	}
}

function writeProgressPlugin()
{
	document.write( '<embed type="application/x-instprogress" height="45" width="463" debug="4" success_target="">');
}

function onunloadDriver(){}

////////////////////////////////////////////////////////////////////////////////
//  functions for bluetoothDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadBluetoothDialog(){}

function onunloadBluetoothDialog(){}

function bluetoothDialogNext(){}

function bluetoothDialogBack()
{
	window.back();
}

////////////////////////////////////////////////////////////////////////////////
//  functions for loadPaper.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadPaper(){}

function onunloadPaper(){}

function loadPaperBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function loadPaperNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;
	HpfInst.SetProcessString("current_step_number", step);

	location="prepareCartridges.html";
}

function whyWhitePaper()
{
	location="whyWhitePaper.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for prepareCartridges.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadPrepareCartridges(){}

function onunloadPrepareCartridges(){}

function prepareCartridgesBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function prepareCartridgesNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;
	HpfInst.SetProcessString("current_step_number", step);

	location="installCartridges.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for installCartridges.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadCartridges(){}

function onunloadCartridges(){}

function installCartridgesBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function installCartridgesNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;
	HpfInst.SetProcessString("current_step_number", step);

	var HasCalibrationSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

	var BthInstallToFile = new String(); 	
	HpfInst.GetProcessString(HPIFile, "bth_install_to_file", BthInstallToFile);	

	if (BthInstallToFile.value == "true") 
	{
		location="installToFile.html";
	} 
	else if (HasCalibrationSupport.value != "false") 
	{
		location="doCalibration.html";
	}
	else
	{
		location="printSample.html";
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for calibration.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadCalibration(){}

function onunloadCalibration(){}

function calibrationBack()
{
	window.back();
}

function calibrationNext()
{
	location="printSample.html";
}

function calibrationYes()
{
	location="printSample.html";
}

function calibrationNo()
{
	location="troubleshootCalibration.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for printSample.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadSample()
{
	HpfInst.InstRestoreSourcePath();	

	if(!GetDisplayValue("printSample"))
		location = "whatNext.html"
}

function onunloadSample(){}

function printSampleBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function printSampleNext()
{	
	location="whatNext.html";
}

function printSampleYes()
{
	var HasCalibrationSupport = new String(); 
	HpfInst.GetProcessString(HPIFile, "calibration_support", HasCalibrationSupport);

	eval('PrintDemoPage(1)'); 

	if (HasCalibrationSupport.value != "false") 
	{
		location="whatNext.html";
	}
	else
	{
		location="confirmSample.html";
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for attachDuplexer.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadAttachDuplexer(){}

function onunloadAttachDuplexer(){}

function attachDuplexerBack()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	if(step.value != "1")
	{
		// Decrement the current step number
		step = parseInt(step.value) - 1;
		HpfInst.SetProcessString("current_step_number", step);
	}

	window.back();
}

function attachDuplexerNext()
{
	// Update the current step number
	var step = new String();
	HpfInst.GetProcessString(HPIFile, "current_step_number", step);

	step = parseInt(step.value) + 1;	
	HpfInst.SetProcessString("current_step_number", step);

	var IO = new String(); 	
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	if (IO.value == "bluetooth")
	{
		location="powerCord.html";
	}
	else if (IO.value == "parallel")
	{
		location="connectParallel.html";
	}
	else
	{
		location="connectUsb.html";
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for confirmSample.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadConfirmSample(){}

function onunloadConfirmSample()
{
}

function confirmSampleBack()
{
	window.back();
}

function confirmSampleNext()
{
	location="whatNext.html";
}

function confirmPageNext()
{
	location="answerQuestions.html";
}

function confirmSampleYes()
{
	confirmSampleNext();
}

function confirmPageYes()
{
	confirmPageNext();
}

function confirmSampleNo()
{
	var IsNetworkInstall = new String();
	HpfInst.GetProcessString(HPIFile, "network_install", IsNetworkInstall);

	var SecondTroubleshootAttempt = new String();
	HpfInst.GetProcessString(HPIFile, "second_troubleshoot_attempt", SecondTroubleshootAttempt);

	if (IsNetworkInstall.value == "true")
	{
		location="netTrouble.html";
	}
	else
	{
		if (SecondTroubleshootAttempt.value == "true")
		{
			location="retryRecommend.html";
		}
		else
		{
			location="troubleshootSoft.html";
		}
	}
}

function confirmSampleAgain()
{
	printSampleYes();
}

function confirmPageAgain()
{
	location = "doCalibration.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for portDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadPortDialog()
{  	
	continueWhenUSBAttached();
}

function onunloadPortDialog(){}

var mutexOnTryToLocate = false;
function portDialogStep1()
{
      // block if still processing a call to onTryToLocate()
	if ( mutexOnTryToLocate)
	{
		return;
	}
	mutexOnTryToLocate = true;

	var strInstalledPort = new String();
	var PortArray = new String();
	var NumPorts = new Number();

	var IO = new String();
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var BthInstallToFile = new String();
	HpfInst.GetProcessString(HPIFile, "bth_install_to_file", BthInstallToFile);

	var strProduct = new String(); 
	HpfInst.GetProcessString(HPIFile, "product", strProduct);

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	var UsbOnly = new String(); 
	HpfInst.GetProcessString(HPIFile, "usb_only", UsbOnly);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	HpfInst.BeginWaitCursor();

	if (BthInstallToFile.value == "true")
	{
		var portName = new String();
		HpfInst.FindBT3ComPort(portName, bResult);

	   	if (bResult.value)
		{
			//user has 3Com BTH accessory ~~ user removed from concluding install-to-file states
			HpfInst.SetProcessString( "bth_install_to_file", "false");
			setPort(portName.value.toLowerCase());
			location="driverCopy.html";
		}
		else
		{
			if (IsAssist.value == "true")
			{
				setPort("FILE:");
				location="driverCopy.html";
			}	
			else
			{
				var PortArray = new String();
				var NumPorts = new Number();
				var strInstalledPort = new String();
				HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
				//Setup for Port Chooser screens
				HpfInst.SetProcessString( "PortArray", PortArray.value);
				mutexExitStart = false;
				location="portDialog.html";
			}	
		}	
	}
	else if (IsAssist.value == "true")
	{
		if (IO.value == "parallel") 
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "LPT", 1, bResult);
		}
		else if (IO.value == "usb") 
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "USB", 1, bResult);
			if (NumPorts.value == 0)
			{
				HpfInst.SetProcessString("usb_port_detection", "false");
			}
			else
			{
				HpfInst.SetProcessString("usb_port_detection", "true");
			}
		}
		else if (IO.value == "bluetooth") 
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "BTH:", PortArray, NumPorts, strInstalledPort, "BTH FILE", 1, bResult);
		}
	}
	else
	{
		if (UsbOnly.value == "true") 
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
		}
		else if (HasBluetooth.value == "true") 
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
		}
		else
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
		}
	}

	HpfInst.EndWaitCursor();
	if ( bResult.value)
	{
		mutexOnTryToLocate = false;
		location="driverCopy.html";
	}
	else
	{
		HpfInst.SetProcessString( "PortArray", PortArray.value);
		//alert( "try to locate failed");
		mutexOnTryToLocate = false;
		location="detectDialog.html";	// force a refresh of the screen to update the port select form
	}
}

function portDialogBack()
{
	window.back();
}

function portDialogNext()
{
	var BthInstallToFile = new String();
	HpfInst.GetProcessString(HPIFile, "bth_install_to_file", BthInstallToFile);

	var port = new String();
	HpfInst.GetProcessString( HPIFile, "port", port);

	if ( "usb:" == port.value.toLowerCase())
	{
		location="usbDialog.html";
	}
	else if (BthInstallToFile.value == "true")
	{
		setPort("FILE:");
		location="driverCopy.html";	
	}
	else if ( "bth:" == port.value.toLowerCase())
	{
		location="bluetoothDialog.html";
	}
	else
	{
		location="driverCopy.html";
	}
}

function writePortDropdown()
{
	var param=writePortDropdown.arguments.length?writePortDropdown.arguments[0]:null;
	var PortArray = new String();
	HpfInst.GetProcessString( HPIFile, "PortArray", PortArray);

	var strPortArray = PortArray.value.split(";");

	var port = new String();
	HpfInst.GetProcessString( HPIFile, "port", port);

	if (param!="options")
	{
		document.write('<form name="PortSelect" method="post" action="">');
		document.write('<select name="ConnectSelect" onchange="setPort(document.PortSelect.ConnectSelect.value);">')
	}
	for (var i in strPortArray)
	{
		if ( strPortArray[i].toLowerCase()==port.value.toLowerCase())
		{
			document.write("<option SELECTED> " + strPortArray[i]);
		}
		else
		{
			document.write("<option> " + strPortArray[i]);
		}
	}
	if(param!="options")
	{
		document.write('</select>');
		document.write('</form>');
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for installToFile.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadInstallToFile(){}

function onunloadInstallToFile(){}

function installToFileBack()
{
	window.back();
}

function installToFileNext(){}

function gotoUsb()
{
	location="whichCable.html";
}
////////////////////////////////////////////////////////////////////////////////
//  functions for retryRecommend.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadRetryRecommend(){}

function onunloadRetryRecommend(){}

function retryRecommendBack()
{
	window.back();
}

function retryRecommendNext(){}

////////////////////////////////////////////////////////////////////////////////
//  functions for troubleshootSoft.html 
////////////////////////////////////////////////////////////////////////////////
//

function onloadTroubleshootSoft()
{
	//user in troubleshoot state
	HpfInst.SetProcessString( "in_troubleshoot", "true");
}

function onunloadTroubleshootSoft()
{
	//user to be taken to a different troubleshoot state 
	HpfInst.SetProcessString("second_troubleshoot_attempt", "true");
}

function troubleshootSoftBack()
{
	//user leaving troubleshoot state
	HpfInst.SetProcessString( "in_troubleshoot", "false");
	window.back();
}

function troubleshootSoftNext()
{
	//user leaving troubleshoot state
	HpfInst.SetProcessString( "in_troubleshoot", "false");

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

      	var UnAssistInstallDone = new String();
	HpfInst.GetProcessString(HPIFile, "unassist_install_done", UnAssistInstallDone);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	var strCheckUSB = new String(); 	
	HpfInst.GetProcessString(HPIFile, "conduct_usb_check", strCheckUSB);

	if ((IsAssist.value == "false") && (UnAssistInstallDone.value == "false")) 
	{
		if (HasBluetooth.value == "true")
		{
			HpfInst.DidGlueRun( bResult);
			if( bResult.value)
			{
				HpfInst.WaitOnGlueFinish( Timeout, bResult);
			}
			//HpfInst.IsGlueFinished( bResult);
			//if (! bResult.value)
			//{
				//user going in bth install-to-file installation state
				HpfInst.SetProcessString( "bth_install_to_file", "true");
			//}
		}

		if (strCheckUSB.value == "true")
		{
	   		var bHotPluggedUSB = new Object();
      			HpfInst.IsCurrentDeviceHotPlugged(HPIFile, bHotPluggedUSB);
	   		if (bHotPluggedUSB.value)
	   		{
	      			OutputToLogFile("\nJS: troubleshootSoftNext: DETECTED Crossbow printer");
	      			location="pleaseWait.html";
	   		}
			else
			{
				installProcess();
			}
		}
		else
		{
			installProcess();
		}
	}
	else
	{
		window.back();
	}
}

////////////////////////////////////////////////////////////////////////////////
//  functions for notEverything.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadNotEverything(){}

function onunloadNotEverything(){}

function notEverythingBack()
{
	window.back();
}

function notEverythingNext()
{
      location="exitDialog.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for helpMeChoose.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadHelpChoose(){}

function onunloadHelpChoose(){}

function helpChooseBack()
{
	window.back();
}

function helpChooseNext(){}

////////////////////////////////////////////////////////////////////////////////
//  functions for helpMeChoose2.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadHelpChoose2(){}

function onunloadHelpChoose2(){}

function helpChoose2Back()
{
	window.back();
}

function helpChoose2Next(){}

////////////////////////////////////////////////////////////////////////////////
//  functions for noBluetoothSupport.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadNoBluetoothSupport(){}

function onunloadNoBluetoothSupport(){}

function noBluetoothSupportBack()
{
	window.back();
}

////////////////////////////////////////////////////////////////////////////////
//  functions for whyWhitePaper.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadWhitePaper(){}

function onunloadWhitePaper(){}

function whitePaperBack()
{
	window.back();
}

function whitePaperNext(){}

////////////////////////////////////////////////////////////////////////////
//  installProcess function
////////////////////////////////////////////////////////////////////////////
//

var mutexExitStart = false; 
function installProcess()
{
 	// block if we're already processing a call to exitStart()
	if ( mutexExitStart)
	{
		return "#";
	}
	mutexExitStart = true;

	var strTemp = new String();
	var glueInstalledDriver;
	var hw1st;
	var result;
	var bPnp;
	var bUsb;

	HpfInst.GetProcessString( HPIFile, "pnp", strTemp);
	bPnp = ConvertStringToBool( strTemp.value, false);

	HpfInst.GetProcessString( HPIFile, "usb", strTemp);
	bUsb = ConvertStringToBool( strTemp.value, false);

	hw1st = bPnp || bUsb;
	if ( hw1st)
	{
		HpfInst.SetProcessString( "hw1st", "true");
	}
	else
	{
		HpfInst.SetProcessString( "hw1st", "false");
	}

	//HpfInst.DidWMChangeHappen( bResult);
	//if( bResult.value)
	//{
	//	HpfInst.WaitOnGlueFinish( Timeout, bResult);
	//}

	HpfInst.DidGlueRun( bResult);
	if( bResult.value)
	{
		HpfInst.WaitOnGlueFinish( Timeout, bResult);
	}

	var BthInstallToFile = new String();
	HpfInst.GetProcessString(HPIFile, "bth_install_to_file", BthInstallToFile);

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	var strInstalledPort = new String();
	HpfInst.GlueInstalledDriver( strDriverName.value, strInstalledPort, bResult);

	if( bResult.value)
	{
		glueInstalledDriver = true;
		HpfInst.SetProcessString( "GlueInstalledDriver", "true");
		setPort( strInstalledPort.value);
	}
	else
	{
		glueInstalledDriver = false;
		HpfInst.SetProcessString( "GlueInstalledDriver", "false");
	}

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	if ( hw1st || glueInstalledDriver)
	{
		// Next screen is Driver Copy screen to install, ironically enough, non-driver files
		// the port/sport macros have been set by the cmdline or by the return value
		// from GlueInstalledDriver(...) above
		   location="driverCopy.html";
	}
	else if (BthInstallToFile.value == "true")
	{
		var portName = new String();
		HpfInst.FindBT3ComPort(portName, bResult);

	   	if (bResult.value)
		{
			//user has 3Com BTH accessory ~~ user removed from concluding install-to-file states
			HpfInst.SetProcessString("bth_install_to_file", "false");
			setPort(portName.value.toLowerCase());
			if (IsAssist.value == "false")
			{
				//to prevent state of installation from print confirmation page
            			HpfInst.SetProcessString( "unassist_install_done", "true");
			}
			location="driverCopy.html";
		}
		else
		{
			if (IsAssist.value == "true")
			{
				setPort("FILE:");
				location="driverCopy.html";
			}	
			else
			{
				var PortArray = new String();
				var NumPorts = new Number();
				var strInstalledPort = new String();
				HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);

				//Setup for Port Chooser screens
				HpfInst.SetProcessString( "PortArray", PortArray.value);
				mutexExitStart = false;
				location="connectDialog.html";
			}
		}
	}
	else
	{
		var PortArray = new String();
		var NumPorts = new Number();
		var strInstalledPort = new String();

		var IO = new String();
		HpfInst.GetProcessString(HPIFile, "io_connect", IO);

		var UsbOnly = new String(); 
		HpfInst.GetProcessString(HPIFile, "usb_only", UsbOnly);

		var HasBluetooth = new String(); 
		HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

		HpfInst.BeginWaitCursor();

		if (IsAssist.value == "true")
		{	
			if (IO.value == "parallel") 
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "LPT", 1, bResult);
			}
			else if (IO.value == "usb") 
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "USB", 1, bResult);
				if (NumPorts.value == 0)
				{
					HpfInst.SetProcessString("usb_port_detection", "false");
				}
				else
				{
					HpfInst.SetProcessString("usb_port_detection", "true");
				}
			}
			else if (IO.value == "bluetooth") 
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "BTH:", PortArray, NumPorts, strInstalledPort, "BTH FILE", 1, bResult);
			}
		}
		else
		{
			if (UsbOnly.value == "true") 
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
			else if (HasBluetooth.value == "true") 
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
			else
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
		}

		HpfInst.EndWaitCursor();
		if ( bResult.value)
		{
			mutexExitStart = false;
			if (IsAssist.value == "false")
			{
				//to prevent state of installation from print confirmation page
            			HpfInst.SetProcessString( "unassist_install_done", "true");
			}
			location="driverCopy.html";
		}
		else
		{
			//Setup for Port Chooser screens
			HpfInst.SetProcessString( "PortArray", PortArray.value);
			mutexExitStart = false;
			location="connectDialog.html";
		}
	}

	mutexExitStart = false;
}

function LoadJumpURLFromVPM()
{
	// assume first parameter is the action and if 
	// there is a second parameter that it is the manufacturer
	var retVal=new Object();

	//get all of the URL params
	var actionStr=LoadJumpURL.arguments[0];
	var mfgStr=LoadJumpURL.arguments[1];
	var prodStr = new Object();
	var langStr = new Object();

	UtilBroker.HPGetMacro("PROD",prodStr, retVal);
	UtilBroker.HPGetMacro("LANG",langStr,retVal);

	LogMessage("Jumpstation: action=" + actionStr + " mfg=" + (mfgStr?mfgStr:"default"))

	if(JumpstationSupportsLang(actionStr,langStr))
	{
		var serverStr=new Object();
		UtilBroker.HPGetMacro("JUMPSERVER",serverStr,retVal);

		if(serverStr.value == "")
			serverStr.value="hpdjjs.com"

		//set manufacturer if none specified
		if(!mfgStr || mfgStr == "")
		{
			var mfgStrContainer=new Object();
			UtilBroker.HPGetMacro("MFG",mfgStrContainer,retVal);

			if(mfgStrContainer.value == "")
				mfgStr = "HP";
			else
				mfgStr = mfgStrContainer.value;
		}

		//create new URL
		var JumpStationURL="http://" + serverStr.value + "/jumpstation?action=" + actionStr + "&mfg=" + mfgStr + "&lang=" + langStr.value + "&product=" + prodStr.value;

		//convert white spaces to '+' to be valid in a URL and then load the URL
		var re=/\s+/;
		LoadOutsideURLFromVPM(JumpStationURL.replace(re,"+"));
	}
	else
		parent.location.href = "support_language_mismatch.html";
}

function LoadOutsideURLFromVPM()
{ 
	//first see if there is a default browser
	var retString=new Object();
	var retVal=new Object();
	var inString= "$DefaultBrowser$";

	UtilBroker.HPExpandString(inString,retString,retVal);

	if(retString != "")
	{
		//check to see if they are connected to the Internet
		inString="$InetConnectionStatus$";
		UtilBroker.HPExpandString(inString,retString,retVal);

		if(retString.value != "")
		{
			//launch browser with URL
			inString="$run," + LoadOutsideURL.arguments[0] + "$";
			UtilBroker.HPExpandString(inString,retString,retVal);
		}
		else
			parent.location.href = "nowebsupport.html";
	}
	else
	{
		// uh-oh do we have an html page in case they don't have a default broweser?
		parent.location.href = "nowebsupport.html";
	}     
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadConnectDialog()
{  
	continueWhenUSBAttached();
}

function onunloadConnectDialog(){}

var mutexOnLocate = false;
function tryToLocate()
{
      // block if still processing a call to onTryToLocate()
	if (mutexOnLocate)
	{
		return;
	}
	mutexOnLocate = true;

	var strInstalledPort = new String();
	var PortArray = new String();
	var NumPorts = new Number();

	var IO = new String();
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var BthInstallToFile = new String();
	HpfInst.GetProcessString(HPIFile, "bth_install_to_file", BthInstallToFile);

	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	var UsbOnly = new String(); 
	HpfInst.GetProcessString(HPIFile, "usb_only", UsbOnly);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	HpfInst.BeginWaitCursor();

	if (BthInstallToFile.value == "true")
	{
		var portName = new String();
		HpfInst.FindBT3ComPort(portName, bResult);

	   	if (bResult.value)
		{
			//user has 3Com BTH accessory ~~ user removed from concluding install-to-file states
			HpfInst.SetProcessString( "bth_install_to_file", "false");
			setPort(portName.value.toLowerCase());
			location="driverCopy.html";
		}
		else
		{
			if (IsAssist.value == "true")
			{
				setPort("FILE:");
				location="driverCopy.html";
			}	
			else
			{
				var PortArray = new String();
				var NumPorts = new Number();
				var strInstalledPort = new String();
				HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);

				//Setup for Port Chooser screens
				HpfInst.SetProcessString( "PortArray", PortArray.value);
				mutexExitStart = false;
				location="detectDialog.html";
			}	
		}	
	}
	else 
	{
		if (IO.value == "parallel")
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "LPT", 1, bResult);
		}
		else if (IO.value == "usb")
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "USB", 1, bResult);
			if (NumPorts.value == 0)
			{
				HpfInst.SetProcessString("usb_port_detection", "false");
			}
			else
			{
				HpfInst.SetProcessString("usb_port_detection", "true");
			}
		}
		else if (IO.value == "bluetooth")
		{
			HpfInst.FindDeviceOnPortEx( HPIFile, "BTH:", PortArray, NumPorts, strInstalledPort, "BTH FILE", 1, bResult);
		}
		else
		{
			if (UsbOnly.value == "true")
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
			else if (HasBluetooth.value == "true")
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "FILE:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
			else
			{
				HpfInst.FindDeviceOnPortEx( HPIFile, "LPT1:", PortArray, NumPorts, strInstalledPort, "*", 1, bResult);
			}
		}
	}
	HpfInst.EndWaitCursor();
	if ( bResult.value)
	{
		mutexOnLocate = false;
		location="driverCopy.html";
	}
	else
	{
		var USBPortsFound = new String(); 
		HpfInst.GetProcessString(HPIFile, "usb_port_detection", USBPortsFound);
		if ((USBPortsFound.value == "false") && (IO.value == "usb"))
		{
			location = "connectHelpDialog.html";
		}	
		else
		{
			HpfInst.SetProcessString("PortArray", PortArray.value);
			mutexOnLocate = false;
			location="detectDialog.html";
		}
	}
}

function connectDialogBack()
{
	window.back();
}

function connectDialogNext()
{
	tryToLocate();
}

////////////////////////////////////////////////////////////////////////////////
//  functions for detectDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadDetectDialog()
{  	
	continueWhenUSBAttached();
}

function onunloadDetectDialog(){}

function detectDialogBack()
{
	window.back();
}

function detectDialogNext()
{
	var port = new String();
	HpfInst.GetProcessString(HPIFile, "port", port);

	var HasBluetooth = new String(); 
	HpfInst.GetProcessString(HPIFile, "has_bth", HasBluetooth);

	//if (spaces(3) == port.value.toLowerCase())
	//{
	//	location = "connectionWarning.html";
	//}

	if (("file:" == port.value.toLowerCase())&& (HasBluetooth.value == "true"))
	{
		var portName = new String();
		HpfInst.FindBT3ComPort(portName, bResult);
		if (bResult.value)
		{
			//user has 3 COM accessory ~~ removed from concluding install-to-file states
			HpfInst.SetProcessString( "bluetooth_install_to_file", "false");
			setPort(portName.value.toLowerCase());
		}
		else
		{
			setPort("FILE:");
		}
		location="driverCopy.html";
 	}
	else if ( "file:" == port.value.toLowerCase())
	{
		setPort("FILE:");
		location="driverCopy.html";
	}
	else if ( "bth:" == port.value.toLowerCase())
	{
		location="bluetoothDialog.html";
	}
	else if ( "usb:" == port.value.toLowerCase())
	{
		location="connectHelpDialog.html";
	}
	else
	{
		location="driverCopy.html";
	}
}

function toConnectHelp()
{
	location="tempHelp.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectHelpDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadConnectHelpDialog()
{  	
	continueWhenUSBAttached();
}

function onunloadConnectHelpDialog()
{
}

function connectHelpBack()
{
	var IsAssist = new String();
	HpfInst.GetProcessString(HPIFile, "assist_install", IsAssist);

	var IO = new String();
	HpfInst.GetProcessString(HPIFile, "io_connect", IO);

	var strInstalledPort = new String();
	var PortArray = new String();
	var NumPorts = new Number();

	if ((IO.value == "usb") && (IsAssist.value == "true"))
	{
		HpfInst.FindDeviceOnPortEx( HPIFile, "USB:", PortArray, NumPorts, strInstalledPort, "USB", 1, bResult);
		if (NumPorts.value != 0)
		{
			HpfInst.SetProcessString("usb_port_detection", "true");
			HpfInst.SetProcessString("PortArray", PortArray.value);
			location="detectDialog.html";
		}

	}

	window.back();
}

////////////////////////////////////////////////////////////////////////////////
//  functions for connectionWarning.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadConnectionWarning()
{
}

function onunloadConnectionWarning()
{
}

function connectionWarningBack()
{
	window.back();
}

function connectionWarningNext()
{
	location = "exitDialog.html";
}

////////////////////////////////////////////////////////////////////////////////
//  functions for pleaseWait.html
////////////////////////////////////////////////////////////////////////////////
// 
// Requirements on entry:
//
// Requirements on exit:
//

function onloadPleaseWait()
{
	setTimeout("installProcess();", 12000);
}

function onunloadPleaseWait(){}

////////////////////////////////////////////////////////////////////////////////
// exitApp()
// general exit function applied to all pages before installation is 'successful'
////////////////////////////////////////////////////////////////////////////////

function exitApp()		
{
	location='exitDialog.html'; //driver not installed; user should not exit out		
}

////////////////////////////////////////////////////////////////////////////////
// exitApp2()
// general exit function applied after/during print sample page
////////////////////////////////////////////////////////////////////////////////

function exitApp2()
{
	location='exitDialog2.html'; //driver is installed; would just perfer if user did not exit out		
}

////////////////////////////////////////////////////////////////////////////////
//  functions for exitDialog.html
////////////////////////////////////////////////////////////////////////////////
//

function onloadExit(){}

function onunloadExit(){}

function exitDialogBack()
{
	window.back();
}

function exitDialogNext()
{
      cancelConfirmed();
}

////////////////////////////////////////////////////////////////////////////////
//  functions for button appearance
////////////////////////////////////////////////////////////////////////////////
//
function writeBtns(nextState, nextFunc, backState, backFunc)
{
	if ((nextState != "invisible") || (backState != "invisible"))
	{
		writeBtnBackgnd();
	}
	switch (nextState)
	{
		case "active":
			document.write('<div id="nextStep">');
			document.write('<a class="link" onClick="' + nextFunc + ';" onMouseOver="SwapImageEx(this,0,\'images/rt_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + continueButton + '>');
			document.write('<img name="nextBtn" src="images/rt_active.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "disabled":
			document.write('<div id="nextStep">');
			document.write('<img name="nextBtn" src="images/rt_disabled.gif" border="0">');
			document.write('</div>');
			break;
		case "invisible":
			break;
	}

	switch (backState)
	{
		case "active":
			document.write('<div id="backStep">');
			document.write('<a class="link" onClick="' + backFunc + ';" onMouseOver="SwapImageEx(this,0,\'images/lf_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + backButton + '>');
			document.write('<img name="backBtn" src="images/lf_active.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "disabled":
			document.write('<div id="backStep">');
			document.write('<img name="backBtn" src="images/lf_disabled.gif" border="0">');
			document.write('</div>');
			break;
		case "invisible":
			break;
	}
}

function writeExit(state, installation)
{
	switch(state)
	{
		case "active":
			writeExitBackgnd();
			switch(installation)
			{
				case "before":
					document.write('<div id="exitApp">');
					document.write('<a class="link" onClick="exitApp();"  onMouseOver="SwapImageEx(this,0,\'images/exit_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + exitButtonLabel + '>');
					document.write('<img name="exitBtn" src="images/exit_active.gif" border="0"></a>');
					document.write('</div>');
					break;
				case "after":
					document.write('<div id="exitApp">');
					document.write('<a class="link" onClick="exitApp2();"  onMouseOver="SwapImageEx(this,0,\'images/exit_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + exitButtonLabel + '>');
					document.write('<img name="exitBtn" src="images/exit_active.gif" border="0"></a>');
					document.write('</div>');
					break;
				case "neither":
					document.write('<div id="exitApp">');
					document.write('<a class="link" onClick="cancelConfirmed();"  onMouseOver="SwapImageEx(this,0,\'images/exit_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + exitButtonLabel + '>');
					document.write('<img name="exitBtn" src="images/exit_active.gif" border="0"></a>');
					document.write('</div>');
					break;
				}
			break;
		case "disabled":
			writeExitBackgnd();
			document.write('<div id="exitApp">');
			document.write('<img name="exitBtn" src="images/exit_disabled.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "invisible":
			break;		
	}
}

function writeBtnBackgnd()
{
	document.write('<div id="seGrey">');
	document.write('<img src="images/seCorner.gif">');
	document.write('</div>');
}

function writeExitBackgnd()
{
	document.write('<div id="neGrey">');
	document.write('<img src="images/neCorner.gif">');
	document.write('</div>');
}

function writeHelpBtn(func)
{
	document.write('<div id="secondaryLabel" class="footerText">' + help + '</div>');
	document.write('<div id="secondaryBtn">');
	document.write('<a class="link" onClick="' + func + '"  onMouseOver="SwapImageEx(this,0,\'images/help_mouse.gif\')" onMouseOut="SwapImageEx(this)" alt=' + helpButton + '>');
	document.write('<img name="twoBtn" src="images/help_active.gif" border="0"></a>');
	document.write('</div>');
}

////////////////////////////////////////////////////////////////////////////////
//  functions for animation replay
////////////////////////////////////////////////////////////////////////////////
//

function replayAnimation(part, page)
{
	switch(part){
		case "replayBtn":
			document.write('<div id="replayButton">');
			document.write('<a class="link" onClick="ReplayAnimationHandler();" onMouseOver="SwapImageEx(this,0,\'images/medBtn2.gif\')" onMouseOut="SwapImageEx(this)" alt=' + replayButton + '>');
			document.write('<img name="animationBtn" src="images/medBtn1.gif" border="0"></a>');
			document.write('</div>');
			break;
		case "replayTxt":
			document.write(replayLabel);
			break;
	}
}

function ReplayAnimationHandler()
{
	var img=document.getElementById("animation");
	img=img.getElementsByTagName("IMG").item(0);
	var src=img.getAttribute("src");
	if(!img.mode)
		img.mode="upper";

	for(var i=0;;i++)
	{
		if(i>=src.length)
		{
			i=0;
			if(img.mode=="upper")
				img.mode="lower";
			else
				img.mode="upper";
		}

		if(img.mode=="upper" && src[i]!=src[i].toUpperCase())
		{
			src=src.slice(0,i) + src[i].toUpperCase() + src.slice(i+1)
			break;
		}
		else if(img.mode=="lower" && src[i]!=src[i].toLowerCase())
		{
			src=src.slice(0,i) + src[i].toLowerCase() + src.slice(i+1)
			break;
		}
	}

	img.src=src;
}

var timerid=null;
function ClearAnimation(fnCallback)
{
	var imgDiv=document.getElementById("animation");
	var createNewImgElement=true;

	if(!imgDiv)
	{
		imgDiv=document.getElementById("netWaitAnimation");
		createNewImgElement=false;
	}

	if(imgDiv)
	{
		var img=imgDiv.getElementsByTagName("IMG").item(0);
		img.src=null;
		imgDiv.removeChild(img);

		if(createNewImgElement)
		{
			img=document.createElement("IMG");
			img.setAttribute("src","images/blank.gif");
			imgDiv.appendChild(img);
		}

		if(fnCallback && !timerid)
		{
			var delay=GetMacroValue("AnimationDelay");
			if(delay && (Number(delay) > 256))
				delay=Number(delay);
			else
				delay=256;

			if(!top.document.URL.match(/attachduplexer|connect(parallel|usb)|powercord|printersearch/i))
				delay=delay*2;

			timerid=setTimeout(fnCallback,delay);
		}
	}
else
	eval(fnCallback);
}

