﻿<?php
header("Content-type:text/html;charset=utf-8");  

session_start(); 
$session_admin = isset($_SESSION['admin']) ? $_SESSION['admin'] : ''; 
if ($session_admin == '') {
	die("Can not access");
}

require_once("../common.php");
checkadminrights($session_admin, 'departments');

$departid = isset($_POST['departid']) ? $_POST['departid'] : '';

if ($departid == '') {
	die("Can not access");
}

$methodname = 'Admin.GetDepartments';
$requestinfo = '<?xml version="1.0" encoding="utf-8"?><request>' . 
    '<ip>' . getip() . '</ip>' . 
	'<parentdepartid>' . $departid . '</parentdepartid>' . 
	'</request>';
$responseinfo = '';
$responsexml = null;
$errorcode = ERRORCODE_UNKNOWN;

$cmd = new COM("OpenCom.Command");
$methodname = iconv('UTF-8', 'GBK//IGNORE', $methodname);
$requestinfo = iconv('UTF-8', 'GBK//IGNORE', $requestinfo);
if ($cmd->Execute($methodname, $requestinfo, $responseinfo, 10000)) {
	$responseinfo = iconv('GBK', 'UTF-8//IGNORE', $responseinfo);
	$responsexml = simplexml_load_string($responseinfo);
	$errorcode = $responsexml->errorcode;
}
$cmd = null;

$html_departs = '';

if ($errorcode == ERRORCODE_OK) {
	$childs = $responsexml->departments->children();

	$itemcount = 0;
	foreach($childs as $child) {
		$itemcount += 1;
	}

	$itemindex = 0;
	foreach($childs as $child) {
		$itemindex += 1;
		$attrs = $child->attributes();
		$islast = ($itemcount == $itemindex) ? ' jstree-last' : ''; 
		$html_departs .= '<li id="depart_' . $attrs->departid . '" class="jstree-closed jstree-unchecked' . $islast . '">' .
			'<ins class="jstree-icon">&nbsp;</ins><a href="#"><ins class="jstree-checkbox">&nbsp;</ins><ins class="jstree-icon">&nbsp;</ins>' . $attrs->departname . '</a></li>';
	}
}

$methodname = 'Admin.GetDepartmentUsers';
$requestinfo = '<?xml version="1.0" encoding="utf-8"?><request>' . 
    '<ip>' . getip() . '</ip>' . 
	'<departid>' . $departid . '</departid>' . 
	'</request>';
$responseinfo = '';
$responsexml = null;
$errorcode = ERRORCODE_UNKNOWN;

$cmd = new COM("OpenCom.Command");
$methodname = iconv('UTF-8', 'GBK//IGNORE', $methodname);
$requestinfo = iconv('UTF-8', 'GBK//IGNORE', $requestinfo);
if ($cmd->Execute($methodname, $requestinfo, $responseinfo, 10000)) {
	$responseinfo = iconv('GBK', 'UTF-8//IGNORE', $responseinfo);
	$responsexml = simplexml_load_string($responseinfo);
	$errorcode = $responsexml->errorcode;
}
$cmd = null;

$html_users = '';

if ($errorcode == ERRORCODE_OK) {

	$itemcount = 0;
	foreach ($responsexml->users->item as $item) {
		$itemcount += 1;
	}

	$itemindex = 0;
	foreach ($responsexml->users->item as $item) {
		$itemindex += 1;
		$showname = $item->nickname;
		if ($item->actualname != '')  $showname = $item->actualname;
		$islast = ($itemcount == $itemindex) ? ' jstree-last' : ''; 
		$html_users .= '<li rel="person" class="jstree-leaf jstree-unchecked' . $islast . '" id="user_' . $item->userid . '">' .
			'<ins class="jstree-icon">&nbsp;</ins><a href="#"><ins class="jstree-checkbox">&nbsp;</ins><ins class="jstree-icon">&nbsp;</ins>' . $showname . '</a></li>';
	}
}

if (($html_departs != '') || ($html_users != '')) {
	echo '<ul>' . $html_departs . $html_users . '</ul>';
} else {
	echo '';
}
?>