<?php
defined('ERRORCODE_OK') or define('ERRORCODE_OK', 0);
defined('ERRORCODE_UNKNOWN') or define('ERRORCODE_UNKNOWN', 1);
defined('ERRORCODE_UNKNOWNVERSION') or define('ERRORCODE_UNKNOWNVERSION', 2);
defined('ERRORCODE_INVALIDPARAMS') or define('ERRORCODE_INVALIDPARAMS', 3);
defined('ERRORCODE_EXISTS') or define('ERRORCODE_EXISTS', 4);
defined('ERRORCODE_NOTEXISTS') or define('ERRORCODE_NOTEXISTS', 5);
defined('ERRORCODE_TIMEOUT') or define('ERRORCODE_TIMEOUT', 6);
defined('ERRORCODE_LOGINED') or define('ERRORCODE_LOGINED', 7);
defined('ERRORCODE_NOTLOGINED') or define('ERRORCODE_NOTLOGINED', 8);
defined('ERRORCODE_NOACCOUNT') or define('ERRORCODE_NOACCOUNT', 9);
defined('ERRORCODE_PWDERROR') or define('ERRORCODE_PWDERROR', 10);
defined('ERRORCODE_USERLOCK') or define('ERRORCODE_USERLOCK', 11);
defined('ERRORCODE_TOKENERR') or define('ERRORCODE_TOKENERR', 12);
defined('ERRORCODE_OVERSTEP') or define('ERRORCODE_OVERSTEP', 13);
defined('ERRORCODE_NOPERMISSION') or define('ERRORCODE_NOPERMISSION', 14);

function strtoxml($str) {
	$xml = $str;
	$xml = str_ireplace('&', '&amp;', $xml);
	$xml = str_ireplace('<', '&lt;', $xml);
	$xml = str_ireplace('>', '&gt;', $xml);
	$xml = str_ireplace('"', '&quot;', $xml);
	$xml = str_ireplace('\'', '&apos;', $xml);
	return $xml;
}

function xmltostr($xml) {
	$str = $xml;
	$str = str_ireplace('&lt;', '<', $str);
	$str = str_ireplace('&gt;', '>', $str);
	$str = str_ireplace('&quot;', '"', $str);
	$str = str_ireplace('&apos;', '\'', $str);
	$str = str_ireplace('&amp;', '&', $str);
	return $str;
}

function getip(){   
   if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))   
           $ip = getenv("HTTP_CLIENT_IP");   
       else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))   
           $ip = getenv("HTTP_X_FORWARDED_FOR");   
       else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))   
           $ip = getenv("REMOTE_ADDR");   
       else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))   
           $ip = $_SERVER['REMOTE_ADDR'];   
       else  
           $ip = "unknown";   
   return($ip);   
}

function checkadminrights($adminname, $rights) {
	$methodname = 'Admin.GetAdmin';
	$requestinfo = '<?xml version="1.0" encoding="utf-8"?><request>' . 
		'<ip>' . getip() . '</ip>' . 
		'<adminname>' . strtoxml($adminname) . '</adminname>' . 
		'</request> ';
	$responseinfo = '';
	$responsexml = null;
	$errorcode = ERRORCODE_UNKNOWN;

	$cmd = new COM("OpenCom.Command");
	$methodname = iconv('UTF-8', 'GBK//IGNORE', $methodname);
	$requestinfo = iconv('UTF-8', 'GBK//IGNORE', $requestinfo);
	if ($cmd->Execute($methodname, $requestinfo, $responseinfo, 5000)) {
		$responseinfo = iconv('GBK', 'UTF-8//IGNORE', $responseinfo);
		$responsexml = simplexml_load_string($responseinfo);
		$errorcode = $responsexml->errorcode;
	}
	$cmd = null;

	if (strpos($responsexml->adminrights, $rights) === false) {
echo<<<EOT
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<title></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<link type="text/css" rel="stylesheet" href="../css/base.css" />
	<script src="../js/md5.js" type="text/javascript"></script>
	</head>
	<body>
		<div class="msgbox">
			<div class="msgbox_text">
				<img width="40px" height="40px" align="absmiddle" src="../images/warning.gif" />&nbsp;无权访问此页面！
			</div>
		</div>
	</body>
	</html>
EOT;
	die;
	}//if
}
?>