﻿/**
 * jQuery EasyUI 1.3.6
 *
 * Copyright (c) 2009-2014 www.jeasyui.com. All rights reserved.
 *
 * Licensed under the GPL license: http://www.gnu.org/licenses/gpl.txt
 * To use it on other terms please contact us at info@jeasyui.com
 *
 */
(function($) {
    var _1 = 0;
    function _2(a, o) {
        for (var i = 0,
                 _3 = a.length; i < _3; i++) {
            if (a[i] == o) {
                return i;
            }
        }
        return - 1;
    };
    function _4(a, o, id) {
        if (typeof o == "string") {
            for (var i = 0,
                     _5 = a.length; i < _5; i++) {
                if (a[i][o] == id) {
                    a.splice(i, 1);
                    return;
                }
            }
        } else {
            var _6 = _2(a, o);
            if (_6 != -1) {
                a.splice(_6, 1);
            }
        }
    };
    function _7(a, o, r) {
        for (var i = 0,
                 _8 = a.length; i < _8; i++) {
            if (a[i][o] == r[o]) {
                return;
            }
        }
        a.push(r);
    };
    function _9(_a) {
        var _b = $.data(_a, "datagrid");
        var _c = _b.options;
        var _d = _b.panel;
        var dc = _b.dc;
        var ss = null;
        if (_c.sharedStyleSheet) {
            ss = typeof _c.sharedStyleSheet == "boolean" ? "head": _c.sharedStyleSheet;
        } else {
            ss = _d.closest("div.datagrid-view");
            if (!ss.length) {
                ss = dc.view;
            }
        }
        var cc = $(ss);
        var _e = $.data(cc[0], "ss");
        if (!_e) {
            _e = $.data(cc[0], "ss", {
                cache: {},
                dirty: []
            });
        }
        return {
            add: function(_f) {
                var ss = ["<style type=\"text/css\" easyui=\"true\">"];
                for (var i = 0; i < _f.length; i++) {
                    _e.cache[_f[i][0]] = {
                        width: _f[i][1]
                    };
                }
                var _10 = 0;
                for (var s in _e.cache) {
                    var _11 = _e.cache[s];
                    _11.index = _10++;
                    ss.push(s + "{width:" + _11.width + "}");
                }
                ss.push("</style>");
                $(ss.join("\n")).appendTo(cc);
                cc.children("style[easyui]:not(:last)").remove();
            },
            getRule: function(_12) {
                var _13 = cc.children("style[easyui]:last")[0];
                var _14 = _13.styleSheet ? _13.styleSheet: (_13.sheet || document.styleSheets[document.styleSheets.length - 1]);
                var _15 = _14.cssRules || _14.rules;
                return _15[_12];
            },
            set: function(_16, _17) {
                var _18 = _e.cache[_16];
                if (_18) {
                    _18.width = _17;
                    var _19 = this.getRule(_18.index);
                    if (_19) {
                        _19.style["width"] = _17;
                    }
                }
            },
            remove: function(_1a) {
                var tmp = [];
                for (var s in _e.cache) {
                    if (s.indexOf(_1a) == -1) {
                        tmp.push([s, _e.cache[s].width]);
                    }
                }
                _e.cache = {};
                this.add(tmp);
            },
            dirty: function(_1b) {
                if (_1b) {
                    _e.dirty.push(_1b);
                }
            },
            clean: function() {
                for (var i = 0; i < _e.dirty.length; i++) {
                    this.remove(_e.dirty[i]);
                }
                _e.dirty = [];
            }
        };
    };
    function _1c(_1d, _1e) {
        var _1f = $.data(_1d, "datagrid").options;
        var _20 = $.data(_1d, "datagrid").panel;
        if (_1e) {
            if (_1e.width) {
                _1f.width = _1e.width;
            }
            if (_1e.height) {
                _1f.height = _1e.height;
            }
        }
        if (_1f.fit == true) {
            var p = _20.panel("panel").parent();
            _1f.width = p.width();
            _1f.height = p.height();
        }
        _20.panel("resize", {
            width: _1f.width,
            height: _1f.height
        });
    };
    function _21(_22) {
        var _23 = $.data(_22, "datagrid").options;
        var dc = $.data(_22, "datagrid").dc;
        var _24 = $.data(_22, "datagrid").panel;
        var _25 = _24.width();
        var _26 = _24.height();
        var _27 = dc.view;
        var _28 = dc.view1;
        var _29 = dc.view2;
        var _2a = _28.children("div.datagrid-header");
        var _2b = _29.children("div.datagrid-header");
        var _2c = _2a.find("table");
        var _2d = _2b.find("table");
        _27.width(_25);
        var _2e = _2a.children("div.datagrid-header-inner").show();
        _28.width(_2e.find("table").width());
        if (!_23.showHeader) {
            _2e.hide();
        }
        _29.width(_25 - _28._outerWidth());
        _28.children("div.datagrid-header,div.datagrid-body,div.datagrid-footer").width(_28.width());
        _29.children("div.datagrid-header,div.datagrid-body,div.datagrid-footer").width(_29.width());
        var hh;
        _2a.css("height", "");
        _2b.css("height", "");
        _2c.css("height", "");
        _2d.css("height", "");
        hh = Math.max(_2c.height(), _2d.height());
        _2c.height(hh);
        _2d.height(hh);
        _2a.add(_2b)._outerHeight(hh);
        if (_23.height != "auto") {
            var _2f = _26 - _29.children("div.datagrid-header")._outerHeight() - _29.children("div.datagrid-footer")._outerHeight() - _24.children("div.datagrid-toolbar")._outerHeight();
            _24.children("div.datagrid-pager").each(function() {
                _2f -= $(this)._outerHeight();
            });
            dc.body1.add(dc.body2).children("table.datagrid-btable-frozen").css({
                position: "absolute",
                top: dc.header2._outerHeight()
            });
            var _30 = dc.body2.children("table.datagrid-btable-frozen")._outerHeight();
            _28.add(_29).children("div.datagrid-body").css({
                marginTop: _30,
                height: (_2f - _30)
            });
        }
        _27.height(_29.height());
    };
    function _31(_32, _33, _34) {
        var _35 = $.data(_32, "datagrid").data.rows;
        var _36 = $.data(_32, "datagrid").options;
        var dc = $.data(_32, "datagrid").dc;
        if (!dc.body1.is(":empty") && (!_36.nowrap || _36.autoRowHeight || _34)) {
            if (_33 != undefined) {
                var tr1 = _36.finder.getTr(_32, _33, "body", 1);
                var tr2 = _36.finder.getTr(_32, _33, "body", 2);
                _37(tr1, tr2);
            } else {
                var tr1 = _36.finder.getTr(_32, 0, "allbody", 1);
                var tr2 = _36.finder.getTr(_32, 0, "allbody", 2);
                _37(tr1, tr2);
                if (_36.showFooter) {
                    var tr1 = _36.finder.getTr(_32, 0, "allfooter", 1);
                    var tr2 = _36.finder.getTr(_32, 0, "allfooter", 2);
                    _37(tr1, tr2);
                }
            }
        }
        _21(_32);
        if (_36.height == "auto") {
            var _38 = dc.body1.parent();
            var _39 = dc.body2;
            var _3a = _3b(_39);
            var _3c = _3a.height;
            if (_3a.width > _39.width()) {
                _3c += 18;
            }
            _38.height(_3c);
            _39.height(_3c);
            dc.view.height(dc.view2.height());
        }
        dc.body2.triggerHandler("scroll");
        function _37(_3d, _3e) {
            for (var i = 0; i < _3e.length; i++) {
                var tr1 = $(_3d[i]);
                var tr2 = $(_3e[i]);
                tr1.css("height", "");
                tr2.css("height", "");
                var _3f = Math.max(tr1.height(), tr2.height());
                tr1.css("height", _3f);
                tr2.css("height", _3f);
            }
        };
        function _3b(cc) {
            var _40 = 0;
            var _41 = 0;
            $(cc).children().each(function() {
                var c = $(this);
                if (c.is(":visible")) {
                    _41 += c._outerHeight();
                    if (_40 < c._outerWidth()) {
                        _40 = c._outerWidth();
                    }
                }
            });
            return {
                width: _40,
                height: _41
            };
        };
    };
    function _42(_43, _44) {
        var _45 = $.data(_43, "datagrid");
        var _46 = _45.options;
        var dc = _45.dc;
        if (!dc.body2.children("table.datagrid-btable-frozen").length) {
            dc.body1.add(dc.body2).prepend("<table class=\"datagrid-btable datagrid-btable-frozen\" cellspacing=\"0\" cellpadding=\"0\"></table>");
        }
        _47(true);
        _47(false);
        _21(_43);
        function _47(_48) {
            var _49 = _48 ? 1 : 2;
            var tr = _46.finder.getTr(_43, _44, "body", _49); (_48 ? dc.body1: dc.body2).children("table.datagrid-btable-frozen").append(tr);
        };
    };
    function _4a(_4b, _4c) {
        function _4d() {
            var _4e = [];
            var _4f = [];
            $(_4b).children("thead").each(function() {
                var opt = $.parser.parseOptions(this, [{
                    frozen: "boolean"
                }]);
                $(this).find("tr").each(function() {
                    var _50 = [];
                    $(this).find("th").each(function() {
                        var th = $(this);
                        var col = $.extend({},
                            $.parser.parseOptions(this, ["field", "align", "halign", "order", {
                                sortable: "boolean",
                                checkbox: "boolean",
                                resizable: "boolean",
                                fixed: "boolean"
                            },
                                {
                                    rowspan: "number",
                                    colspan: "number",
                                    width: "number"
                                }]), {
                                title: (th.html() || undefined),
                                hidden: (th.attr("hidden") ? true: undefined),
                                formatter: (th.attr("formatter") ? eval(th.attr("formatter")) : undefined),
                                styler: (th.attr("styler") ? eval(th.attr("styler")) : undefined),
                                sorter: (th.attr("sorter") ? eval(th.attr("sorter")) : undefined)
                            });
                        if (th.attr("editor")) {
                            var s = $.trim(th.attr("editor"));
                            if (s.substr(0, 1) == "{") {
                                col.editor = eval("(" + s + ")");
                            } else {
                                col.editor = s;
                            }
                        }
                        _50.push(col);
                    });
                    opt.frozen ? _4e.push(_50) : _4f.push(_50);
                });
            });
            return [_4e, _4f];
        };
        var _51 = $("<div class=\"datagrid-wrap\">" + "<div class=\"datagrid-view\">" + "<div class=\"datagrid-view1\">" + "<div class=\"datagrid-header\">" + "<div class=\"datagrid-header-inner\"></div>" + "</div>" + "<div class=\"datagrid-body\">" + "<div class=\"datagrid-body-inner\"></div>" + "</div>" + "<div class=\"datagrid-footer\">" + "<div class=\"datagrid-footer-inner\"></div>" + "</div>" + "</div>" + "<div class=\"datagrid-view2\">" + "<div class=\"datagrid-header\">" + "<div class=\"datagrid-header-inner\"></div>" + "</div>" + "<div class=\"datagrid-body\"></div>" + "<div class=\"datagrid-footer\">" + "<div class=\"datagrid-footer-inner\"></div>" + "</div>" + "</div>" + "</div>" + "</div>").insertAfter(_4b);
        _51.panel({
            doSize: false
        });
        _51.panel("panel").addClass("datagrid").bind("_resize",
            function(e, _52) {
                var _53 = $.data(_4b, "datagrid").options;
                if (_53.fit == true || _52) {
                    _1c(_4b);
                    setTimeout(function() {
                            if ($.data(_4b, "datagrid")) {
                                _54(_4b);
                            }
                        },
                        0);
                }
                return false;
            });
        $(_4b).hide().appendTo(_51.children("div.datagrid-view"));
        var cc = _4d();
        var _55 = _51.children("div.datagrid-view");
        var _56 = _55.children("div.datagrid-view1");
        var _57 = _55.children("div.datagrid-view2");
        return {
            panel: _51,
            frozenColumns: cc[0],
            columns: cc[1],
            dc: {
                view: _55,
                view1: _56,
                view2: _57,
                header1: _56.children("div.datagrid-header").children("div.datagrid-header-inner"),
                header2: _57.children("div.datagrid-header").children("div.datagrid-header-inner"),
                body1: _56.children("div.datagrid-body").children("div.datagrid-body-inner"),
                body2: _57.children("div.datagrid-body"),
                footer1: _56.children("div.datagrid-footer").children("div.datagrid-footer-inner"),
                footer2: _57.children("div.datagrid-footer").children("div.datagrid-footer-inner")
            }
        };
    };
    function _58(_59) {
        var _5a = $.data(_59, "datagrid");
        var _5b = _5a.options;
        var dc = _5a.dc;
        var _5c = _5a.panel;
        _5a.ss = $(_59).datagrid("createStyleSheet");
        _5c.panel($.extend({},
            _5b, {
                id: null,
                doSize: false,
                onResize: function(_5d, _5e) {
                    setTimeout(function() {
                            if ($.data(_59, "datagrid")) {
                                _21(_59);
                                _97(_59);
                                _5b.onResize.call(_5c, _5d, _5e);
                            }
                        },
                        0);
                },
                onExpand: function() {
                    _31(_59);
                    _5b.onExpand.call(_5c);
                }
            }));
        _5a.rowIdPrefix = "datagrid-row-r" + (++_1);
        _5a.cellClassPrefix = "datagrid-cell-c" + _1;
        _5f(dc.header1, _5b.frozenColumns, true);
        _5f(dc.header2, _5b.columns, false);
        _60();
        dc.header1.add(dc.header2).css("display", _5b.showHeader ? "block": "none");
        dc.footer1.add(dc.footer2).css("display", _5b.showFooter ? "block": "none");
        if (_5b.toolbar) {
            if ($.isArray(_5b.toolbar)) {
                $("div.datagrid-toolbar", _5c).remove();
                var tb = $("<div class=\"datagrid-toolbar\"><table cellspacing=\"0\" cellpadding=\"0\"><tr></tr></table></div>").prependTo(_5c);
                var tr = tb.find("tr");
                for (var i = 0; i < _5b.toolbar.length; i++) {
                    var btn = _5b.toolbar[i];
                    if (btn == "-") {
                        $("<td><div class=\"datagrid-btn-separator\"></div></td>").appendTo(tr);
                    } else {
                        var td = $("<td></td>").appendTo(tr);
                        var _61 = $("<a href=\"javascript:void(0)\"></a>").appendTo(td);
                        _61[0].onclick = eval(btn.handler ||
                        function() {});
                        _61.linkbutton($.extend({},
                            btn, {
                                plain: true
                            }));
                    }
                }
            } else {
                $(_5b.toolbar).addClass("datagrid-toolbar").prependTo(_5c);
                $(_5b.toolbar).show();
            }
        } else {
            $("div.datagrid-toolbar", _5c).remove();
        }
        $("div.datagrid-pager", _5c).remove();
        if (_5b.pagination) {
            var _62 = $("<div class=\"datagrid-pager\"></div>");
            if (_5b.pagePosition == "bottom") {
                _62.appendTo(_5c);
            } else {
                if (_5b.pagePosition == "top") {
                    _62.addClass("datagrid-pager-top").prependTo(_5c);
                } else {
                    var _63 = $("<div class=\"datagrid-pager datagrid-pager-top\"></div>").prependTo(_5c);
                    _62.appendTo(_5c);
                    _62 = _62.add(_63);
                }
            }
            _62.pagination({
                total: (_5b.pageNumber * _5b.pageSize),
                pageNumber: _5b.pageNumber,
                pageSize: _5b.pageSize,
                pageList: _5b.pageList,
                onSelectPage: function(_64, _65) {
                    _5b.pageNumber = _64;
                    _5b.pageSize = _65;
                    _62.pagination("refresh", {
                        pageNumber: _64,
                        pageSize: _65
                    });
                    _95(_59);
                }
            });
            _5b.pageSize = _62.pagination("options").pageSize;
        }
        function _5f(_66, _67, _68) {
            if (!_67) {
                return;
            }
            $(_66).show();
            $(_66).empty();
            var _69 = [];
            var _6a = [];
            if (_5b.sortName) {
                _69 = _5b.sortName.split(",");
                _6a = _5b.sortOrder.split(",");
            }
            var t = $("<table class=\"datagrid-htable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody></tbody></table>").appendTo(_66);
            for (var i = 0; i < _67.length; i++) {
                var tr = $("<tr class=\"datagrid-header-row\"></tr>").appendTo($("tbody", t));
                var _6b = _67[i];
                for (var j = 0; j < _6b.length; j++) {
                    var col = _6b[j];
                    var _6c = "";
                    if (col.rowspan) {
                        _6c += "rowspan=\"" + col.rowspan + "\" ";
                    }
                    if (col.colspan) {
                        _6c += "colspan=\"" + col.colspan + "\" ";
                    }
                    var td = $("<td " + _6c + "></td>").appendTo(tr);
                    if (col.checkbox) {
                        td.attr("field", col.field);
                        $("<div class=\"datagrid-header-check\"></div>").html("<input type=\"checkbox\"/>").appendTo(td);
                    } else {
                        if (col.field) {
                            td.attr("field", col.field);
                            td.append("<div class=\"datagrid-cell\"><span></span><span class=\"datagrid-sort-icon\"></span></div>");
                            $("span", td).html(col.title);
                            $("span.datagrid-sort-icon", td).html("&nbsp;");
                            var _6d = td.find("div.datagrid-cell");
                            var pos = _2(_69, col.field);
                            if (pos >= 0) {
                                _6d.addClass("datagrid-sort-" + _6a[pos]);
                            }
                            if (col.resizable == false) {
                                _6d.attr("resizable", "false");
                            }
                            if (col.width) {
                                _6d._outerWidth(col.width);
                                col.boxWidth = parseInt(_6d[0].style.width);
                            } else {
                                col.auto = true;
                            }
                            _6d.css("text-align", (col.halign || col.align || ""));
                            col.cellClass = _5a.cellClassPrefix + "-" + col.field.replace(/[\.|\s]/g, "-");
                            _6d.addClass(col.cellClass).css("width", "");
                        } else {
                            $("<div class=\"datagrid-cell-group\"></div>").html(col.title).appendTo(td);
                        }
                    }
                    if (col.hidden) {
                        td.hide();
                    }
                }
            }
            if (_68 && _5b.rownumbers) {
                var td = $("<td rowspan=\"" + _5b.frozenColumns.length + "\"><div class=\"datagrid-header-rownumber\"></div></td>");
                if ($("tr", t).length == 0) {
                    td.wrap("<tr class=\"datagrid-header-row\"></tr>").parent().appendTo($("tbody", t));
                } else {
                    td.prependTo($("tr:first", t));
                }
            }
        };
        function _60() {
            var _6e = [];
            var _6f = _70(_59, true).concat(_70(_59));
            for (var i = 0; i < _6f.length; i++) {
                var col = getColOptions(_59, _6f[i]);
                if (col && !col.checkbox) {
                    _6e.push(["." + col.cellClass, col.boxWidth ? col.boxWidth + "px": "auto"]);
                }
            }
            _5a.ss.add(_6e);
            _5a.ss.dirty(_5a.cellSelectorPrefix);
            _5a.cellSelectorPrefix = "." + _5a.cellClassPrefix;
        };
    };
    function _72(_73) {
        var _74 = $.data(_73, "datagrid");
        var _75 = _74.panel;
        var _76 = _74.options;
        var dc = _74.dc;
        var _77 = dc.header1.add(dc.header2);
        _77.find("input[type=checkbox]").unbind(".datagrid").bind("click.datagrid",
            function(e) {
                if (_76.singleSelect && _76.selectOnCheck) {
                    return false;
                }
                if ($(this).is(":checked")) {
                    checkAll(_73);
                } else {
                    _11a(_73);
                }
                e.stopPropagation();
            });
        var _78 = _77.find("div.datagrid-cell");
        _78.closest("td").unbind(".datagrid").bind("mouseenter.datagrid",
            function() {
                if (_74.resizing) {
                    return;
                }
                $(this).addClass("datagrid-header-over");
            }).bind("mouseleave.datagrid",
            function() {
                $(this).removeClass("datagrid-header-over");
            }).bind("contextmenu.datagrid",
            function(e) {
                var _79 = $(this).attr("field");
                _76.onHeaderContextMenu.call(_73, e, _79);
            });
        _78.unbind(".datagrid").bind("click.datagrid",
            function(e) {
                var p1 = $(this).offset().left + 5;
                var p2 = $(this).offset().left + $(this)._outerWidth() - 5;
                if (e.pageX < p2 && e.pageX > p1) {
                    _89(_73, $(this).parent().attr("field"));
                }
            }).bind("dblclick.datagrid",
            function(e) {
                var p1 = $(this).offset().left + 5;
                var p2 = $(this).offset().left + $(this)._outerWidth() - 5;
                var _7a = _76.resizeHandle == "right" ? (e.pageX > p2) : (_76.resizeHandle == "left" ? (e.pageX < p1) : (e.pageX < p1 || e.pageX > p2));
                if (_7a) {
                    var _7b = $(this).parent().attr("field");
                    var col = getColOptions(_73, _7b);
                    if (col.resizable == false) {
                        return;
                    }
                    $(_73).datagrid("autoSizeColumn", _7b);
                    col.auto = false;
                }
            });
        var _7c = _76.resizeHandle == "right" ? "e": (_76.resizeHandle == "left" ? "w": "e,w");
        _78.each(function() {
            $(this).resizable({
                handles: _7c,
                disabled: ($(this).attr("resizable") ? $(this).attr("resizable") == "false": false),
                minWidth: 25,
                onStartResize: function(e) {
                    _74.resizing = true;
                    _77.css("cursor", $("body").css("cursor"));
                    if (!_74.proxy) {
                        _74.proxy = $("<div class=\"datagrid-resize-proxy\"></div>").appendTo(dc.view);
                    }
                    _74.proxy.css({
                        left: e.pageX - $(_75).offset().left - 1,
                        display: "none"
                    });
                    setTimeout(function() {
                            if (_74.proxy) {
                                _74.proxy.show();
                            }
                        },
                        500);
                },
                onResize: function(e) {
                    _74.proxy.css({
                        left: e.pageX - $(_75).offset().left - 1,
                        display: "block"
                    });
                    return false;
                },
                onStopResize: function(e) {
                    _77.css("cursor", "");
                    $(this).css("height", "");
                    $(this)._outerWidth($(this)._outerWidth());
                    var _7d = $(this).parent().attr("field");
                    var col = getColOptions(_73, _7d);
                    col.width = $(this)._outerWidth();
                    col.boxWidth = parseInt(this.style.width);
                    col.auto = undefined;
                    $(this).css("width", "");
                    _54(_73, _7d);
                    _74.proxy.remove();
                    _74.proxy = null;
                    if ($(this).parents("div:first.datagrid-header").parent().hasClass("datagrid-view1")) {
                        _21(_73);
                    }
                    _97(_73);
                    _76.onResizeColumn.call(_73, _7d, col.width);
                    setTimeout(function() {
                            _74.resizing = false;
                        },
                        0);
                }
            });
        });
        dc.body1.add(dc.body2).unbind().bind("mouseover",
            function(e) {
                if (_74.resizing) {
                    return;
                }
                var tr = $(e.target).closest("tr.datagrid-row");
                if (!_7e(tr)) {
                    return;
                }
                var _7f = _80(tr);
                _fb(_73, _7f);
                e.stopPropagation();
            }).bind("mouseout",
            function(e) {
                var tr = $(e.target).closest("tr.datagrid-row");
                if (!_7e(tr)) {
                    return;
                }
                var _81 = _80(tr);
                _76.finder.getTr(_73, _81).removeClass("datagrid-row-over");
                e.stopPropagation();
            }).bind("click",
            function(e) {
                var tt = $(e.target);
                var tr = tt.closest("tr.datagrid-row");
                if (!_7e(tr)) {
                    return;
                }
                var _82 = _80(tr);
                if (tt.parent().hasClass("datagrid-cell-check")) {
                    if (_76.singleSelect && _76.selectOnCheck) {
                        if (!_76.checkOnSelect) {
                            _11a(_73, true);
                        }
                        _107(_73, _82);
                    } else {
                        if (tt.is(":checked")) {
                            _107(_73, _82);
                        } else {
                            _10e(_73, _82);
                        }
                    }
                } else {
                    var row = _76.finder.getRow(_73, _82);
                    var td = tt.closest("td[field]", tr);
                    if (td.length) {
                        var _83 = td.attr("field");
                        _76.onClickCell.call(_73, _82, _83, row[_83]);
                    }
                    if (_76.singleSelect == true) {
                        selectRow(_73, _82);
                    } else {
                        if (_76.ctrlSelect) {
                            if (e.ctrlKey) {
                                if (tr.hasClass("datagrid-row-selected")) {
                                    unselectRow(_73, _82);
                                } else {
                                    selectRow(_73, _82);
                                }
                            } else {
                                $(_73).datagrid("clearSelections");
                                selectRow(_73, _82);
                            }
                        } else {
                            if (tr.hasClass("datagrid-row-selected")) {
                                unselectRow(_73, _82);
                            } else {
                                selectRow(_73, _82);
                            }
                        }
                    }
                    _76.onClickRow.call(_73, _82, row);
                }
                e.stopPropagation();
            }).bind("dblclick",
            function(e) {
                var tt = $(e.target);
                var tr = tt.closest("tr.datagrid-row");
                if (!_7e(tr)) {
                    return;
                }
                var _84 = _80(tr);
                var row = _76.finder.getRow(_73, _84);
                var td = tt.closest("td[field]", tr);
                if (td.length) {
                    var _85 = td.attr("field");
                    _76.onDblClickCell.call(_73, _84, _85, row[_85]);
                }
                _76.onDblClickRow.call(_73, _84, row);
                e.stopPropagation();
            }).bind("contextmenu",
            function(e) {
                var tr = $(e.target).closest("tr.datagrid-row");
                if (!_7e(tr)) {
                    return;
                }
                var _86 = _80(tr);
                var row = _76.finder.getRow(_73, _86);
                _76.onRowContextMenu.call(_73, e, _86, row);
                e.stopPropagation();
            });
        dc.body2.bind("scroll",
            function() {
                var b1 = dc.view1.children("div.datagrid-body");
                b1.scrollTop($(this).scrollTop());
                var c1 = dc.body1.children(":first");
                var c2 = dc.body2.children(":first");
                if (c1.length && c2.length) {
                    var _87 = c1.offset().top;
                    var _88 = c2.offset().top;
                    if (_87 != _88) {
                        b1.scrollTop(b1.scrollTop() + _87 - _88);
                    }
                }
                dc.view2.children("div.datagrid-header,div.datagrid-footer")._scrollLeft($(this)._scrollLeft());
                dc.body2.children("table.datagrid-btable-frozen").css("left", -$(this)._scrollLeft());
            });
        function _80(tr) {
            if (tr.attr("datagrid-row-index")) {
                return parseInt(tr.attr("datagrid-row-index"));
            } else {
                return tr.attr("node-id");
            }
        };
        function _7e(tr) {
            return tr.length && tr.parent().length;
        };
    };
    function _89(_8a, _8b) {
        var _8c = $.data(_8a, "datagrid");
        var _8d = _8c.options;
        _8b = _8b || {};
        var _8e = {
            sortName: _8d.sortName,
            sortOrder: _8d.sortOrder
        };
        if (typeof _8b == "object") {
            $.extend(_8e, _8b);
        }
        var _8f = [];
        var _90 = [];
        if (_8e.sortName) {
            _8f = _8e.sortName.split(",");
            _90 = _8e.sortOrder.split(",");
        }
        if (typeof _8b == "string") {
            var _91 = _8b;
            var col = getColOptions(_8a, _91);
            if (!col.sortable || _8c.resizing) {
                return;
            }
            var _92 = col.order || "asc";
            var pos = _2(_8f, _91);
            if (pos >= 0) {
                var _93 = _90[pos] == "asc" ? "desc": "asc";
                if (_8d.multiSort && _93 == _92) {
                    _8f.splice(pos, 1);
                    _90.splice(pos, 1);
                } else {
                    _90[pos] = _93;
                }
            } else {
                if (_8d.multiSort) {
                    _8f.push(_91);
                    _90.push(_92);
                } else {
                    _8f = [_91];
                    _90 = [_92];
                }
            }
            _8e.sortName = _8f.join(",");
            _8e.sortOrder = _90.join(",");
        }
        if (_8d.onBeforeSortColumn.call(_8a, _8e.sortName, _8e.sortOrder) == false) {
            return;
        }
        $.extend(_8d, _8e);
        var dc = _8c.dc;
        var _94 = dc.header1.add(dc.header2);
        _94.find("div.datagrid-cell").removeClass("datagrid-sort-asc datagrid-sort-desc");
        for (var i = 0; i < _8f.length; i++) {
            var col = getColOptions(_8a, _8f[i]);
            _94.find("div." + col.cellClass).addClass("datagrid-sort-" + _90[i]);
        }
        if (_8d.remoteSort) {
            _95(_8a);
        } else {
            _96(_8a, $(_8a).datagrid("getData"));
        }
        _8d.onSortColumn.call(_8a, _8d.sortName, _8d.sortOrder);
    };
    function _97(_98) {
        var _99 = $.data(_98, "datagrid");
        var _9a = _99.options;
        var dc = _99.dc;
        dc.body2.css("overflow-x", "");
        if (!_9a.fitColumns) {
            return;
        }
        if (!_99.leftWidth) {
            _99.leftWidth = 0;
        }
        var _9b = dc.view2.children("div.datagrid-header");
        var _9c = 0;
        var _9d;
        var _9e = _70(_98, false);
        for (var i = 0; i < _9e.length; i++) {
            var col = getColOptions(_98, _9e[i]);
            if (_9f(col)) {
                _9c += col.width;
                _9d = col;
            }
        }
        if (!_9c) {
            return;
        }
        if (_9d) {
            _a0(_9d, -_99.leftWidth);
        }
        var _a1 = _9b.children("div.datagrid-header-inner").show();
        var _a2 = _9b.width() - _9b.find("table").width() - _9a.scrollbarSize + _99.leftWidth;
        var _a3 = _a2 / _9c;
        if (!_9a.showHeader) {
            _a1.hide();
        }
        for (var i = 0; i < _9e.length; i++) {
            var col = getColOptions(_98, _9e[i]);
            if (_9f(col)) {
                var _a4 = parseInt(col.width * _a3);
                _a0(col, _a4);
                _a2 -= _a4;
            }
        }
        _99.leftWidth = _a2;
        if (_9d) {
            _a0(_9d, _99.leftWidth);
        }
        _54(_98);
        if (_9b.width() >= _9b.find("table").width()) {
            dc.body2.css("overflow-x", "hidden");
        }
        function _a0(col, _a5) {
            if (col.width + _a5 > 0) {
                col.width += _a5;
                col.boxWidth += _a5;
            }
        };
        function _9f(col) {
            if (!col.hidden && !col.checkbox && !col.auto && !col.fixed) {
                return true;
            }
        };
    };
    function _a6(_a7, _a8) {
        var _a9 = $.data(_a7, "datagrid");
        var _aa = _a9.options;
        var dc = _a9.dc;
        var tmp = $("<div class=\"datagrid-cell\" style=\"position:absolute;left:-9999px\"></div>").appendTo("body");
        if (_a8) {
            _1c(_a8);
            if (_aa.fitColumns) {
                _21(_a7);
                _97(_a7);
            }
        } else {
            var _ab = false;
            var _ac = _70(_a7, true).concat(_70(_a7, false));
            for (var i = 0; i < _ac.length; i++) {
                var _a8 = _ac[i];
                var col = getColOptions(_a7, _a8);
                if (col.auto) {
                    _1c(_a8);
                    _ab = true;
                }
            }
            if (_ab && _aa.fitColumns) {
                _21(_a7);
                _97(_a7);
            }
        }
        tmp.remove();
        function _1c(_ad) {
            var _ae = dc.view.find("div.datagrid-header td[field=\"" + _ad + "\"] div.datagrid-cell");
            _ae.css("width", "");
            var col = $(_a7).datagrid("getColumnOption", _ad);
            col.width = undefined;
            col.boxWidth = undefined;
            col.auto = true;
            $(_a7).datagrid("fixColumnSize", _ad);
            var _af = Math.max(_b0("header"), _b0("allbody"), _b0("allfooter"));
            _ae._outerWidth(_af);
            col.width = _af;
            col.boxWidth = parseInt(_ae[0].style.width);
            _ae.css("width", "");
            $(_a7).datagrid("fixColumnSize", _ad);
            _aa.onResizeColumn.call(_a7, _ad, col.width);
            function _b0(_b1) {
                var _b2 = 0;
                if (_b1 == "header") {
                    _b2 = _b3(_ae);
                } else {
                    _aa.finder.getTr(_a7, 0, _b1).find("td[field=\"" + _ad + "\"] div.datagrid-cell").each(function() {
                        var w = _b3($(this));
                        if (_b2 < w) {
                            _b2 = w;
                        }
                    });
                }
                return _b2;
                function _b3(_b4) {
                    return _b4.is(":visible") ? _b4._outerWidth() : tmp.html(_b4.html())._outerWidth();
                };
            };
        };
    };
    function _54(_b5, _b6) {
        var _b7 = $.data(_b5, "datagrid");
        var _b8 = _b7.options;
        var dc = _b7.dc;
        var _b9 = dc.view.find("table.datagrid-btable,table.datagrid-ftable");
        _b9.css("table-layout", "fixed");
        if (_b6) {
            fix(_b6);
        } else {
            var ff = _70(_b5, true).concat(_70(_b5, false));
            for (var i = 0; i < ff.length; i++) {
                fix(ff[i]);
            }
        }
        _b9.css("table-layout", "auto");
        fixCellWidth(_b5);
        setTimeout(function() {
                _31(_b5);
                resizeEditor(_b5);
            },
            0);
        function fix(_bb) {
            var col = getColOptions(_b5, _bb);
            if (!col.checkbox) {
                _b7.ss.set("." + col.cellClass, col.boxWidth ? col.boxWidth + "px": "auto");
            }
        };
    };
    function fixCellWidth(_bc) {
        var dc = $.data(_bc, "datagrid").dc;
        dc.body1.add(dc.body2).find("td.datagrid-td-merged").each(function() {
            var td = $(this);
            var _bd = td.attr("colspan") || 1;
            var _be = getColOptions(_bc, td.attr("field")).width;
            for (var i = 1; i < _bd; i++) {
                td = td.next();
                _be += getColOptions(_bc, td.attr("field")).width + 1;
            }
            $(this).children("div.datagrid-cell")._outerWidth(_be);
        });
    };
    function resizeEditor(target) {
        var dc = $.data(target, "datagrid").dc;
        dc.view.find("div.datagrid-editable").each(function() {
            var _c1 = $(this);
            var _c2 = _c1.parent().attr("field");
            var col = $(target).datagrid("getColumnOption", _c2);
            _c1._outerWidth(col.width);
            var ed = $.data(this, "datagrid.editor");
            if (ed.actions.resize) {
                ed.actions.resize(ed.target, _c1.width());
            }
        });
    };
    function getColOptions(target, filed) {
        // 获取列
        function getCol(columns) {
            if (columns) {
                for (var i = 0; i < columns.length; i++) {
                    var cc = columns[i];
                    for (var j = 0; j < cc.length; j++) {
                        var c = cc[j];
                        if (c.field == filed) {
                            return c;
                        }
                    }
                }
            }
            return null;
        };
        // 获取grid参数
        var opts = $.data(target, "datagrid").options;
        var col = getCol(opts.columns);
        if (!col) {
            col = getCol(opts.frozenColumns);
        }
        return col;
    };
    function _70(_c8, _c9) {
        var _ca = $.data(_c8, "datagrid").options;
        var _cb = (_c9 == true) ? (_ca.frozenColumns || [[]]) : _ca.columns;
        if (_cb.length == 0) {
            return [];
        }
        var _cc = [];
        function _cd(_ce) {
            var c = 0;
            var i = 0;
            while (true) {
                if (_cc[i] == undefined) {
                    if (c == _ce) {
                        return i;
                    }
                    c++;
                }
                i++;
            }
        };
        function _cf(r) {
            var ff = [];
            var c = 0;
            for (var i = 0; i < _cb[r].length; i++) {
                var col = _cb[r][i];
                if (col.field) {
                    ff.push([c, col.field]);
                }
                c += parseInt(col.colspan || "1");
            }
            for (var i = 0; i < ff.length; i++) {
                ff[i][0] = _cd(ff[i][0]);
            }
            for (var i = 0; i < ff.length; i++) {
                var f = ff[i];
                _cc[f[0]] = f[1];
            }
        };
        for (var i = 0; i < _cb.length; i++) {
            _cf(i);
        }
        return _cc;
    };
    function _96(_d0, _d1) {
        var _d2 = $.data(_d0, "datagrid");
        var _d3 = _d2.options;
        var dc = _d2.dc;
        _d1 = _d3.loadFilter.call(_d0, _d1);
        _d1.total = parseInt(_d1.total);
        _d2.data = _d1;
        if (_d1.footer) {
            _d2.footer = _d1.footer;
        }
        if (!_d3.remoteSort && _d3.sortName) {
            var _d4 = _d3.sortName.split(",");
            var _d5 = _d3.sortOrder.split(",");
            _d1.rows.sort(function(r1, r2) {
                var r = 0;
                for (var i = 0; i < _d4.length; i++) {
                    var sn = _d4[i];
                    var so = _d5[i];
                    var col = getColOptions(_d0, sn);
                    var _d6 = col.sorter ||
                        function(a, b) {
                            return a == b ? 0 : (a > b ? 1 : -1);
                        };
                    r = _d6(r1[sn], r2[sn]) * (so == "asc" ? 1 : -1);
                    if (r != 0) {
                        return r;
                    }
                }
                return r;
            });
        }
        if (_d3.view.onBeforeRender) {
            _d3.view.onBeforeRender.call(_d3.view, _d0, _d1.rows);
        }
        _d3.view.render.call(_d3.view, _d0, dc.body2, false);
        _d3.view.render.call(_d3.view, _d0, dc.body1, true);
        if (_d3.showFooter) {
            _d3.view.renderFooter.call(_d3.view, _d0, dc.footer2, false);
            _d3.view.renderFooter.call(_d3.view, _d0, dc.footer1, true);
        }
        if (_d3.view.onAfterRender) {
            _d3.view.onAfterRender.call(_d3.view, _d0);
        }
        _d2.ss.clean();
        _d3.onLoadSuccess.call(_d0, _d1);
        var _d7 = $(_d0).datagrid("getPager");
        if (_d7.length) {
            var _d8 = _d7.pagination("options");
            if (_d8.total != _d1.total) {
                _d7.pagination("refresh", {
                    total: _d1.total
                });
                if (_d3.pageNumber != _d8.pageNumber) {
                    _d3.pageNumber = _d8.pageNumber;
                    _95(_d0);
                }
            }
        }
        _31(_d0);
        dc.body2.triggerHandler("scroll");
        _d9(_d0);
        $(_d0).datagrid("autoSizeColumn");
    };
    function _d9(_da) {
        var _db = $.data(_da, "datagrid");
        var _dc = _db.options;
        if (_dc.idField) {
            var _dd = $.data(_da, "treegrid") ? true: false;
            var _de = _dc.onSelect;
            var _df = _dc.onCheck;
            _dc.onSelect = _dc.onCheck = function() {};
            var _e0 = _dc.finder.getRows(_da);
            for (var i = 0; i < _e0.length; i++) {
                var row = _e0[i];
                var _e1 = _dd ? row[_dc.idField] : i;
                if (_e2(_db.selectedRows, row)) {
                    selectRow(_da, _e1, true);
                }
                if (_e2(_db.checkedRows, row)) {
                    _107(_da, _e1, true);
                }
            }
            _dc.onSelect = _de;
            _dc.onCheck = _df;
        }
        function _e2(a, r) {
            for (var i = 0; i < a.length; i++) {
                if (a[i][_dc.idField] == r[_dc.idField]) {
                    a[i] = r;
                    return true;
                }
            }
            return false;
        };
    };
    function _e3(_e4, row) {
        var _e5 = $.data(_e4, "datagrid");
        var _e6 = _e5.options;
        var _e7 = _e5.data.rows;
        if (typeof row == "object") {
            return _2(_e7, row);
        } else {
            for (var i = 0; i < _e7.length; i++) {
                if (_e7[i][_e6.idField] == row) {
                    return i;
                }
            }
            return - 1;
        }
    };
    function _e8(_e9) {
        var _ea = $.data(_e9, "datagrid");
        var _eb = _ea.options;
        var _ec = _ea.data;
        if (_eb.idField) {
            return _ea.selectedRows;
        } else {
            var _ed = [];
            _eb.finder.getTr(_e9, "", "selected", 2).each(function() {
                _ed.push(_eb.finder.getRow(_e9, $(this)));
            });
            return _ed;
        }
    };
    function _ee(_ef) {
        var _f0 = $.data(_ef, "datagrid");
        var _f1 = _f0.options;
        if (_f1.idField) {
            return _f0.checkedRows;
        } else {
            var _f2 = [];
            _f1.finder.getTr(_ef, "", "checked", 2).each(function() {
                _f2.push(_f1.finder.getRow(_ef, $(this)));
            });
            return _f2;
        }
    };
    function _f3(_f4, _f5) {
        var _f6 = $.data(_f4, "datagrid");
        var dc = _f6.dc;
        var _f7 = _f6.options;
        var tr = _f7.finder.getTr(_f4, _f5);
        if (tr.length) {
            if (tr.closest("table").hasClass("datagrid-btable-frozen")) {
                return;
            }
            var _f8 = dc.view2.children("div.datagrid-header")._outerHeight();
            var _f9 = dc.body2;
            var _fa = _f9.outerHeight(true) - _f9.outerHeight();
            var top = tr.position().top - _f8 - _fa;
            if (top < 0) {
                _f9.scrollTop(_f9.scrollTop() + top);
            } else {
                if (top + tr._outerHeight() > _f9.height() - 18) {
                    _f9.scrollTop(_f9.scrollTop() + top + tr._outerHeight() - _f9.height() + 18);
                }
            }
        }
    };
    function _fb(_fc, _fd) {
        var _fe = $.data(_fc, "datagrid");
        var _ff = _fe.options;
        _ff.finder.getTr(_fc, _fe.highlightIndex).removeClass("datagrid-row-over");
        _ff.finder.getTr(_fc, _fd).addClass("datagrid-row-over");
        _fe.highlightIndex = _fd;
    };
    function selectRow(jq, rowIndex, _103) {
        var dg = $.data(jq, "datagrid");
        var dc = dg.dc;
        var opts = dg.options;
        var selectedRows = dg.selectedRows;
        if (opts.singleSelect) {
            unselectAll(jq);
            selectedRows.splice(0, selectedRows.length);
        }
        // start 默认仅能选择一行，多选勾选check
        //unselectAll(jq);
        //selectedRows.splice(0, selectedRows.length);
        //// end

        if (!_103 && opts.checkOnSelect) {
            _107(jq, rowIndex, true);
        }
        var row = opts.finder.getRow(jq, rowIndex);
        if (opts.idField) {
            _7(selectedRows, opts.idField, row);
        }
        opts.finder.getTr(jq, rowIndex).addClass("datagrid-row-selected");
        opts.onSelect.call(jq, rowIndex, row);
        _f3(jq, rowIndex);
    };
    function unselectRow(_109, _10a, _10b) {
        var _10c = $.data(_109, "datagrid");
        var dc = _10c.dc;
        var opts = _10c.options;
        var _10d = $.data(_109, "datagrid").selectedRows;
        if (!_10b && opts.checkOnSelect) {
            _10e(_109, _10a, true);
        }
        opts.finder.getTr(_109, _10a).removeClass("datagrid-row-selected");
        var row = opts.finder.getRow(_109, _10a);
        if (opts.idField) {
            _4(_10d, opts.idField, row[opts.idField]);
        }
        opts.onUnselect.call(_109, _10a, row);
    };
    function _10f(_110, _111) {
        var _112 = $.data(_110, "datagrid");
        var opts = _112.options;
        var rows = opts.finder.getRows(_110);
        var _113 = $.data(_110, "datagrid").selectedRows;
        if (!_111 && opts.checkOnSelect) {
            checkAll(_110, true);
        }
        opts.finder.getTr(_110, "", "allbody").addClass("datagrid-row-selected");
        if (opts.idField) {
            for (var _115 = 0; _115 < rows.length; _115++) {
                _7(_113, opts.idField, rows[_115]);
            }
        }
        opts.onSelectAll.call(_110, rows);
    };
    function unselectAll(_116, _117) {
        var _118 = $.data(_116, "datagrid");
        var opts = _118.options;
        var rows = opts.finder.getRows(_116);
        var _119 = $.data(_116, "datagrid").selectedRows;
        if (!_117 && opts.checkOnSelect) {
            _11a(_116, true);
        }
        opts.finder.getTr(_116, "", "selected").removeClass("datagrid-row-selected");
        if (opts.idField) {
            for (var _11b = 0; _11b < rows.length; _11b++) {
                _4(_119, opts.idField, rows[_11b][opts.idField]);
            }
        }
        opts.onUnselectAll.call(_116, rows);
    };
    function _107(_11c, _11d, _11e) {
        var _11f = $.data(_11c, "datagrid");
        var opts = _11f.options;
        if (!_11e && opts.selectOnCheck) {
            selectRow(_11c, _11d, true);
        }
        var tr = opts.finder.getTr(_11c, _11d).addClass("datagrid-row-checked");
        var ck = tr.find("div.datagrid-cell-check input[type=checkbox]");
        ck._propAttr("checked", true);
        tr = opts.finder.getTr(_11c, "", "checked", 2);
        if (tr.length == opts.finder.getRows(_11c).length) {
            var dc = _11f.dc;
            var _120 = dc.header1.add(dc.header2);
            _120.find("input[type=checkbox]")._propAttr("checked", true);
        }
        var row = opts.finder.getRow(_11c, _11d);
        if (opts.idField) {
            _7(_11f.checkedRows, opts.idField, row);
        }
        opts.onCheck.call(_11c, _11d, row);
    };
    function _10e(_121, _122, _123) {
        var _124 = $.data(_121, "datagrid");
        var opts = _124.options;
        if (!_123 && opts.selectOnCheck) {
            unselectRow(_121, _122, true);
        }
        var tr = opts.finder.getTr(_121, _122).removeClass("datagrid-row-checked");
        var ck = tr.find("div.datagrid-cell-check input[type=checkbox]");
        ck._propAttr("checked", false);
        var dc = _124.dc;
        var _125 = dc.header1.add(dc.header2);
        _125.find("input[type=checkbox]")._propAttr("checked", false);
        var row = opts.finder.getRow(_121, _122);
        if (opts.idField) {
            _4(_124.checkedRows, opts.idField, row[opts.idField]);
        }
        opts.onUncheck.call(_121, _122, row);
    };
    function checkAll(_126, _127) {
        var _128 = $.data(_126, "datagrid");
        var opts = _128.options;
        var rows = opts.finder.getRows(_126);
        if (!_127 && opts.selectOnCheck) {
            _10f(_126, true);
        }
        var dc = _128.dc;
        var hck = dc.header1.add(dc.header2).find("input[type=checkbox]");
        var bck = opts.finder.getTr(_126, "", "allbody").addClass("datagrid-row-checked").find("div.datagrid-cell-check input[type=checkbox]");
        hck.add(bck)._propAttr("checked", true);
        if (opts.idField) {
            for (var i = 0; i < rows.length; i++) {
                _7(_128.checkedRows, opts.idField, rows[i]);
            }
        }
        opts.onCheckAll.call(_126, rows);
    };
    function _11a(_129, _12a) {
        var _12b = $.data(_129, "datagrid");
        var opts = _12b.options;
        var rows = opts.finder.getRows(_129);
        if (!_12a && opts.selectOnCheck) {
            unselectAll(_129, true);
        }
        var dc = _12b.dc;
        var hck = dc.header1.add(dc.header2).find("input[type=checkbox]");
        var bck = opts.finder.getTr(_129, "", "checked").removeClass("datagrid-row-checked").find("div.datagrid-cell-check input[type=checkbox]");
        hck.add(bck)._propAttr("checked", false);
        if (opts.idField) {
            for (var i = 0; i < rows.length; i++) {
                _4(_12b.checkedRows, opts.idField, rows[i][opts.idField]);
            }
        }
        opts.onUncheckAll.call(_129, rows);
    };
    function beginEdit(target, index) {
        var opts = $.data(target, "datagrid").options;
        var tr = opts.finder.getTr(target, index);
        var row = opts.finder.getRow(target, index);
        // 正在编辑,直接出去
        if (tr.hasClass("datagrid-row-editing")) {
            return;
        }
        if (opts.onBeforeEdit.call(target, index, row) == false) {
            return;
        }
        // 标识为正在编辑
        tr.addClass("datagrid-row-editing");
        // 准备编辑单元格
        beginEditRow(target, index);
        // 重绘编辑
        resizeEditor(target);
        tr.find("div.datagrid-editable").each(function() {
            var filed = $(this).parent().attr("field");
            var ed = $.data(this, "datagrid.editor");
            ed.actions.setValue(ed.target, row[filed]);
        });
        validateRow(target, index);
        opts.onBeginEdit.call(target, index, row);
    };
    function stopEdit(_133, _134, _135) {
        var opts = $.data(_133, "datagrid").options;
        var _136 = $.data(_133, "datagrid").updatedRows;
        var _137 = $.data(_133, "datagrid").insertedRows;
        var tr = opts.finder.getTr(_133, _134);
        var row = opts.finder.getRow(_133, _134);
        if (!tr.hasClass("datagrid-row-editing")) {
            return;
        }
        if (!_135) {
            if (!validateRow(_133, _134)) {
                return;
            }
            var changed = false;
            var newValues = {};
            tr.find("div.datagrid-editable").each(function() {
                var field = $(this).parent().attr("field");
                var ed = $.data(this, "datagrid.editor");
                // 获取值
                var value = ed.actions.getValue(ed.target);
                if(ed.type == 'eovacombo' || ed.type == 'eovafind'){
                    // 获取文本
                    var text = ed.actions.getText(ed.target);
                    // 如果文本有变更，更新文本
                    if (row[field] != text) {
                        row[field] = text;
                        changed = true;
                        newValues[field] = text;
                        // 更新文本同时，将值存入 字段的值列
                        row[field+'_val'] = value;
                    }
                } else {
                    // 如果文本有变更，更新文本
                    if (row[field] != value) {
                        row[field] = value;
                        changed = true;
                        newValues[field] = value;
                    }
                }
            });
            if (changed) {
                if (_2(_137, row) == -1) {
                    if (_2(_136, row) == -1) {
                        _136.push(row);
                    }
                }
            }
            opts.onEndEdit.call(_133, _134, row, newValues);
        }
        tr.removeClass("datagrid-row-editing");
        _13c(_133, _134);
        $(_133).datagrid("refreshRow", _134);
        if (!_135) {
            opts.onAfterEdit.call(_133, _134, row, newValues);
        } else {
            opts.onCancelEdit.call(_133, _134, row);
        }
    };
    function _13d(_13e, _13f) {
        var opts = $.data(_13e, "datagrid").options;
        var tr = opts.finder.getTr(_13e, _13f);
        var _140 = [];
        tr.children("td").each(function() {
            var cell = $(this).find("div.datagrid-editable");
            if (cell.length) {
                var ed = $.data(cell[0], "datagrid.editor");
                _140.push(ed);
            }
        });
        return _140;
    };
    function _141(_142, _143) {
        var _144 = _13d(_142, _143.index != undefined ? _143.index: _143.id);
        for (var i = 0; i < _144.length; i++) {
            if (_144[i].field == _143.field) {
                return _144[i];
            }
        }
        return null;
    };
    // 准备编辑单元格
    function beginEditRow(target, index) {
        var opts = $.data(target, "datagrid").options;
        var tr = opts.finder.getTr(target, index);
        tr.children("td").each(function() {
            var cell = $(this).find("div.datagrid-cell");
            var thisFiled = $(this).attr("field");
            var col = getColOptions(target, thisFiled);
            if (col && col.editor) {
                // 编辑器类型 参数
                var tmpType, tmpOpts;
                if (typeof col.editor == "string") {
                    tmpType = col.editor;
                } else {
                    tmpType = col.editor.type;
                    tmpOpts = col.editor.options;
                }
                var tmpEditor = opts.editors[tmpType];
                if (tmpEditor) {
                    var cellHtml = cell.html();
                    var cellOutWidth = cell._outerWidth();
                    cell.addClass("datagrid-editable");
                    cell._outerWidth(cellOutWidth);
                    cell.html("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\"><tr><td></td></tr></table>");
                    cell.children("table").bind("click dblclick contextmenu",
                        function(e) {
                            e.stopPropagation();
                        });
                    $.data(cell[0], "datagrid.editor", {
                        actions: tmpEditor,
                        target: tmpEditor.init(cell.find("td"), tmpOpts),
                        field: thisFiled,
                        type: tmpType,
                        oldHtml: cellHtml
                    });
                }
            }
        });
        _31(target, index, true);
    };
    function _13c(_14d, _14e) {
        var opts = $.data(_14d, "datagrid").options;
        var tr = opts.finder.getTr(_14d, _14e);
        tr.children("td").each(function() {
            var cell = $(this).find("div.datagrid-editable");
            if (cell.length) {
                var ed = $.data(cell[0], "datagrid.editor");
                if (ed.actions.destroy) {
                    ed.actions.destroy(ed.target);
                }
                cell.html(ed.oldHtml);
                $.removeData(cell[0], "datagrid.editor");
                cell.removeClass("datagrid-editable");
                cell.css("width", "");
            }
        });
    };
    function validateRow(_14f, _150) {
        var tr = $.data(_14f, "datagrid").options.finder.getTr(_14f, _150);
        if (!tr.hasClass("datagrid-row-editing")) {
            return true;
        }
        // eova nice validate error
//        if(tr.find('input').hasClass('n-invalid')){
//        	alert('eova nice validate error');
//            return false;
//        }
        var vbox = tr.find(".validatebox-text");
        vbox.validatebox("validate");
        vbox.trigger("mouseleave");
        var _151 = tr.find(".validatebox-invalid");
        return _151.length == 0;
    };
    function getChanges(jq, type) {
        // 自动结束所有编辑单元格
        var data = $.data(jq, "datagrid").data;
        for ( var i = 0, len = data.rows.length; i < len; i++) {
        	var tr = $.data(jq, "datagrid").options.finder.getTr(jq, i);
            if (tr.hasClass("datagrid-row-editing") && tr.find('input').hasClass('n-invalid')) {
            	alert("数据未通过校验，暂时无法保存！");
                return;
            }
            if (validateRow(jq, i)) {
                stopEdit(jq, i, false);
            }
        }
        // 自动结束所有编辑单元格END
        
        var _155 = $.data(jq, "datagrid").insertedRows;
        var _156 = $.data(jq, "datagrid").deletedRows;
        var _157 = $.data(jq, "datagrid").updatedRows;
        if (!type) {
            var rows = [];
            rows = rows.concat(_155);
            rows = rows.concat(_156);
            rows = rows.concat(_157);
            return rows;
        } else {
            if (type == "inserted") {
                return _155;
            } else {
                if (type == "deleted") {
                    return _156;
                } else {
                    if (type == "updated") {
                        return _157;
                    }
                }
            }
        }
        return [];
    };
    function _158(_159, _15a) {
        var _15b = $.data(_159, "datagrid");
        var opts = _15b.options;
        var data = _15b.data;
        var _15c = _15b.insertedRows;
        var _15d = _15b.deletedRows;
        $(_159).datagrid("cancelEdit", _15a);
        var row = opts.finder.getRow(_159, _15a);
        if (_2(_15c, row) >= 0) {
            _4(_15c, row);
        } else {
            _15d.push(row);
        }
        _4(_15b.selectedRows, opts.idField, row[opts.idField]);
        _4(_15b.checkedRows, opts.idField, row[opts.idField]);
        opts.view.deleteRow.call(opts.view, _159, _15a);
        if (opts.height == "auto") {
            _31(_159);
        }
        $(_159).datagrid("getPager").pagination("refresh", {
            total: data.total
        });
    };
    function _15e(_15f, _160) {
        var data = $.data(_15f, "datagrid").data;
        var view = $.data(_15f, "datagrid").options.view;
        var _161 = $.data(_15f, "datagrid").insertedRows;
        view.insertRow.call(view, _15f, _160.index, _160.row);
        _161.push(_160.row);
        $(_15f).datagrid("getPager").pagination("refresh", {
            total: data.total
        });
    };
    function _162(_163, row) {
        var data = $.data(_163, "datagrid").data;
        var view = $.data(_163, "datagrid").options.view;
        var _164 = $.data(_163, "datagrid").insertedRows;
        view.insertRow.call(view, _163, null, row);
        _164.push(row);
        $(_163).datagrid("getPager").pagination("refresh", {
            total: data.total
        });
    };
    function _165(_166) {
        var _167 = $.data(_166, "datagrid");
        var data = _167.data;
        var rows = data.rows;
        var _168 = [];
        for (var i = 0; i < rows.length; i++) {
            _168.push($.extend({},
                rows[i]));
        }
        _167.originalRows = _168;
        _167.updatedRows = [];
        _167.insertedRows = [];
        _167.deletedRows = [];
    };
    function _169(_16a) {
        var data = $.data(_16a, "datagrid").data;
        var ok = true;
        for (var i = 0,
                 len = data.rows.length; i < len; i++) {
            if (validateRow(_16a, i)) {
                stopEdit(_16a, i, false);
            } else {
                ok = false;
            }
        }
        if (ok) {
            _165(_16a);
        }
    };
    function _16b(_16c) {
        var _16d = $.data(_16c, "datagrid");
        var opts = _16d.options;
        var _16e = _16d.originalRows;
        var _16f = _16d.insertedRows;
        var _170 = _16d.deletedRows;
        var _171 = _16d.selectedRows;
        var _172 = _16d.checkedRows;
        var data = _16d.data;
        function _173(a) {
            var ids = [];
            for (var i = 0; i < a.length; i++) {
                ids.push(a[i][opts.idField]);
            }
            return ids;
        };
        function _174(ids, _175) {
            for (var i = 0; i < ids.length; i++) {
                var _176 = _e3(_16c, ids[i]);
                if (_176 >= 0) { (_175 == "s" ? selectRow: _107)(_16c, _176, true);
                }
            }
        };
        for (var i = 0; i < data.rows.length; i++) {
            stopEdit(_16c, i, true);
        }
        var _177 = _173(_171);
        var _178 = _173(_172);
        _171.splice(0, _171.length);
        _172.splice(0, _172.length);
        data.total += _170.length - _16f.length;
        data.rows = _16e;
        _96(_16c, data);
        _174(_177, "s");
        _174(_178, "c");
        _165(_16c);
    };
    function _95(_179, _17a) {
        var opts = $.data(_179, "datagrid").options;
        if (_17a) {
            opts.queryParams = _17a;
        }
        var _17b = $.extend({},
            opts.queryParams);
        if (opts.pagination) {
            $.extend(_17b, {
                page: opts.pageNumber,
                rows: opts.pageSize
            });
        }
        if (opts.sortName) {
            $.extend(_17b, {
                sort: opts.sortName,
                order: opts.sortOrder
            });
        }
        if (opts.onBeforeLoad.call(_179, _17b) == false) {
            return;
        }
        $(_179).datagrid("loading");
        setTimeout(function() {
                _17c();
            },
            0);
        function _17c() {
            var _17d = opts.loader.call(_179, _17b,
                function(data) {
                    setTimeout(function() {
                            $(_179).datagrid("loaded");
                        },
                        0);
                    _96(_179, data);
                    setTimeout(function() {
                            _165(_179);
                        },
                        0);
                },
                function() {
                    setTimeout(function() {
                            $(_179).datagrid("loaded");
                        },
                        0);
                    opts.onLoadError.apply(_179, arguments);
                });
            if (_17d == false) {
                $(_179).datagrid("loaded");
            }
        };
    };
    function _17e(_17f, _180) {
        var opts = $.data(_17f, "datagrid").options;
        _180.rowspan = _180.rowspan || 1;
        _180.colspan = _180.colspan || 1;
        if (_180.rowspan == 1 && _180.colspan == 1) {
            return;
        }
        var tr = opts.finder.getTr(_17f, (_180.index != undefined ? _180.index: _180.id));
        if (!tr.length) {
            return;
        }
        var row = opts.finder.getRow(_17f, tr);
        var _181 = row[_180.field];
        var td = tr.find("td[field=\"" + _180.field + "\"]");
        td.attr("rowspan", _180.rowspan).attr("colspan", _180.colspan);
        td.addClass("datagrid-td-merged");
        for (var i = 1; i < _180.colspan; i++) {
            td = td.next();
            td.hide();
            row[td.attr("field")] = _181;
        }
        for (var i = 1; i < _180.rowspan; i++) {
            tr = tr.next();
            if (!tr.length) {
                break;
            }
            var row = opts.finder.getRow(_17f, tr);
            var td = tr.find("td[field=\"" + _180.field + "\"]").hide();
            row[td.attr("field")] = _181;
            for (var j = 1; j < _180.colspan; j++) {
                td = td.next();
                td.hide();
                row[td.attr("field")] = _181;
            }
        }
        fixCellWidth(_17f);
    };
    $.fn.datagrid = function(_182, _183) {
        if (typeof _182 == "string") {
            return $.fn.datagrid.methods[_182](this, _183);
        }
        _182 = _182 || {};
        return this.each(function() {
            var state = $.data(this, "datagrid");
            var opts;
            if (state) {
                opts = $.extend(state.options, _182);
                state.options = opts;
            } else {
                opts = $.extend({},
                    $.extend({},
                        $.fn.datagrid.defaults, {
                            queryParams: {}
                        }), $.fn.datagrid.parseOptions(this), _182);
                $(this).css("width", "").css("height", "");
                var _185 = _4a(this, opts.rownumbers);
                if (!opts.columns) {
                    opts.columns = _185.columns;
                }
                if (!opts.frozenColumns) {
                    opts.frozenColumns = _185.frozenColumns;
                }
                opts.columns = $.extend(true, [], opts.columns);
                opts.frozenColumns = $.extend(true, [], opts.frozenColumns);
                opts.view = $.extend({},
                    opts.view);
                $.data(this, "datagrid", {
                    options: opts,
                    panel: _185.panel,
                    dc: _185.dc,
                    ss: null,
                    selectedRows: [],
                    checkedRows: [],
                    data: {
                        total: 0,
                        rows: []
                    },
                    originalRows: [],
                    updatedRows: [],
                    insertedRows: [],
                    deletedRows: []
                });
            }
            _58(this);
            _72(this);
            _1c(this);
            if (opts.data) {
                _96(this, opts.data);
                _165(this);
            } else {
                var data = $.fn.datagrid.parseData(this);
                if (data.total > 0) {
                    _96(this, data);
                    _165(this);
                }
            }
            if (state) {
                // 如果grid已经初始化了，就不自动load data，反之绑定事件加载多次，如需加载手工调用load方法
                return;
            }
            _95(this);
        });
    };
    var editorsObj = {
        text: {
            init: function(_187, _188) {
                var _189 = $("<input type=\"text\" class=\"datagrid-editable-input\">").appendTo(_187);
                return _189;
            },
            getValue: function(_18a) {
                return $(_18a).val();
            },
            setValue: function(_18b, _18c) {
                $(_18b).val(_18c);
            },
            resize: function(_18d, _18e) {
                $(_18d)._outerWidth(_18e)._outerHeight(22);
            }
        },
        textarea: {
            init: function(_18f, _190) {
                var _191 = $("<textarea class=\"datagrid-editable-input\"></textarea>").appendTo(_18f);
                return _191;
            },
            getValue: function(_192) {
                return $(_192).val();
            },
            setValue: function(_193, _194) {
                $(_193).val(_194);
            },
            resize: function(_195, _196) {
                $(_195)._outerWidth(_196);
            }
        },
        checkbox: {
            init: function(_197, _198) {
                var _199 = $("<input type=\"checkbox\">").appendTo(_197);
                _199.val(_198.on);
                _199.attr("offval", _198.off);
                return _199;
            },
            getValue : function(jq) {
                if ($(jq).is(":checked")) {
                    return $(jq).val();
                } else {
                    return $(jq).attr("offval");
                }
            },
            setValue : function(jq, value) {
                var checked = false;
                if ($(jq).val() == value) {
                    checked = true;
                }
                $.fn.prop ? $(jq).prop("checked", checked) : $(jq).attr("checked", checked);
                // $(jq)._propAttr("checked", checked);
            }
        },
        numberbox: {
            init: function(container, options) {
                var gridNumBoxObj = $("<input type=\"text\" class=\"datagrid-editable-input\">").appendTo(container);
                gridNumBoxObj.numberbox(options);
                return gridNumBoxObj;
            },
            destroy: function(target) {
                $(target).numberbox("destroy");
            },
            getValue: function(target) {
                $(target).blur();
                return $(target).numberbox("getValue");
            },
            setValue: function(target, value) {
                $(target).numberbox("setValue", value);
            },
            resize: function(target, value) {
                $(target)._outerWidth(value)._outerHeight(22);
            }
        },
        validatebox: {
            init: function(_1a7, _1a8) {
                var _1a9 = $("<input type=\"text\" class=\"datagrid-editable-input\">").appendTo(_1a7);
                _1a9.validatebox(_1a8);
                return _1a9;
            },
            destroy: function(_1aa) {
                $(_1aa).validatebox("destroy");
            },
            getValue: function(_1ab) {
                return $(_1ab).val();
            },
            setValue: function(_1ac, _1ad) {
                $(_1ac).val(_1ad);
            },
            resize: function(_1ae, _1af) {
                $(_1ae)._outerWidth(_1af)._outerHeight(22);
            }
        },
        datebox: {
            init: function(_1b0, _1b1) {
                var _1b2 = $("<input type=\"text\">").appendTo(_1b0);
                _1b2.datebox(_1b1);
                return _1b2;
            },
            destroy: function(_1b3) {
                $(_1b3).datebox("destroy");
            },
            getValue: function(_1b4) {
                return $(_1b4).datebox("getValue");
            },
            setValue: function(_1b5, _1b6) {
                $(_1b5).datebox("setValue", _1b6);
            },
            resize: function(_1b7, _1b8) {
                $(_1b7).datebox("resize", _1b8);
            }
        },
        combobox: {
            init: function(_1b9, _1ba) {
                var _1bb = $("<input type=\"text\">").appendTo(_1b9);
                _1bb.combobox(_1ba || {});
                return _1bb;
            },
            destroy: function(_1bc) {
                $(_1bc).combobox("destroy");
            },
            getValue: function(_1bd) {
                var opts = $(_1bd).combobox("options");
                if (opts.multiple) {
                    return $(_1bd).combobox("getValues").join(opts.separator);
                } else {
                    return $(_1bd).combobox("getValue");
                }
            },
            setValue: function(_1be, _1bf) {
                var opts = $(_1be).combobox("options");
                if (opts.multiple) {
                    if (_1bf) {
                        $(_1be).combobox("setValues", _1bf.split(opts.separator));
                    } else {
                        $(_1be).combobox("clear");
                    }
                } else {
                    $(_1be).combobox("setValue", _1bf);
                }
            },
            resize: function(_1c0, _1c1) {
                $(_1c0).combobox("resize", _1c1);
            }
        },
        combotree: {
            init: function(_1c2, _1c3) {
                var _1c4 = $("<input type=\"text\">").appendTo(_1c2);
                _1c4.combotree(_1c3);
                return _1c4;
            },
            destroy: function(_1c5) {
                $(_1c5).combotree("destroy");
            },
            getValue: function(_1c6) {
                var opts = $(_1c6).combotree("options");
                if (opts.multiple) {
                    return $(_1c6).combotree("getValues").join(opts.separator);
                } else {
                    return $(_1c6).combotree("getValue");
                }
            },
            setValue: function(_1c7, _1c8) {
                var opts = $(_1c7).combotree("options");
                if (opts.multiple) {
                    if (_1c8) {
                        $(_1c7).combotree("setValues", _1c8.split(opts.separator));
                    } else {
                        $(_1c7).combotree("clear");
                    }
                } else {
                    $(_1c7).combotree("setValue", _1c8);
                }
            },
            resize: function(_1c9, _1ca) {
                $(_1c9).combotree("resize", _1ca);
            }
        },
        combogrid: {
            init: function(_1cb, _1cc) {
                var _1cd = $("<input type=\"text\">").appendTo(_1cb);
                _1cd.combogrid(_1cc);
                return _1cd;
            },
            destroy: function(_1ce) {
                $(_1ce).combogrid("destroy");
            },
            getValue: function(_1cf) {
                var opts = $(_1cf).combogrid("options");
                if (opts.multiple) {
                    return $(_1cf).combogrid("getValues").join(opts.separator);
                } else {
                    return $(_1cf).combogrid("getValue");
                }
            },
            setValue: function(_1d0, _1d1) {
                var opts = $(_1d0).combogrid("options");
                if (opts.multiple) {
                    if (_1d1) {
                        $(_1d0).combogrid("setValues", _1d1.split(opts.separator));
                    } else {
                        $(_1d0).combogrid("clear");
                    }
                } else {
                    $(_1d0).combogrid("setValue", _1d1);
                }
            },
            resize: function(_1d2, _1d3) {
                $(_1d2).combogrid("resize", _1d3);
            }
        }
    };
    $.fn.datagrid.methods = {
        options: function(jq) {
            var _1d4 = $.data(jq[0], "datagrid").options;
            var _1d5 = $.data(jq[0], "datagrid").panel.panel("options");
            var opts = $.extend(_1d4, {
                width: _1d5.width,
                height: _1d5.height,
                closed: _1d5.closed,
                collapsed: _1d5.collapsed,
                minimized: _1d5.minimized,
                maximized: _1d5.maximized
            });
            return opts;
        },
        setSelectionState: function(jq) {
            return jq.each(function() {
                _d9(this);
            });
        },
        createStyleSheet: function(jq) {
            return _9(jq[0]);
        },
        getPanel: function(jq) {
            return $.data(jq[0], "datagrid").panel;
        },
        getPager: function(jq) {
            return $.data(jq[0], "datagrid").panel.children("div.datagrid-pager");
        },
        getColumnFields: function(jq, _1d6) {
            return _70(jq[0], _1d6);
        },
        getColumnOption: function(jq, _1d7) {
            return getColOptions(jq[0], _1d7);
        },
        resize: function(jq, _1d8) {
            return jq.each(function() {
                _1c(this, _1d8);
            });
        },
        load: function(jq, _1d9) {
            return jq.each(function() {
                var opts = $(this).datagrid("options");
                opts.pageNumber = 1;
                var _1da = $(this).datagrid("getPager");
                _1da.pagination("refresh", {
                    pageNumber: 1
                });
                _95(this, _1d9);
            });
        },
        reload: function(jq, _1db) {
            return jq.each(function() {
                _95(this, _1db);
            });
        },
        reloadFooter: function(jq, _1dc) {
            return jq.each(function() {
                var opts = $.data(this, "datagrid").options;
                var dc = $.data(this, "datagrid").dc;
                if (_1dc) {
                    $.data(this, "datagrid").footer = _1dc;
                }
                if (opts.showFooter) {
                    opts.view.renderFooter.call(opts.view, this, dc.footer2, false);
                    opts.view.renderFooter.call(opts.view, this, dc.footer1, true);
                    if (opts.view.onAfterRender) {
                        opts.view.onAfterRender.call(opts.view, this);
                    }
                    $(this).datagrid("fixRowHeight");
                }
            });
        },
        loading: function(jq) {
            return jq.each(function() {
                var opts = $.data(this, "datagrid").options;
                $(this).datagrid("getPager").pagination("loading");
                if (opts.loadMsg) {
                    var _1dd = $(this).datagrid("getPanel");
                    if (!_1dd.children("div.datagrid-mask").length) {
                        $("<div class=\"datagrid-mask\" style=\"display:block\"></div>").appendTo(_1dd);
                        var msg = $("<div class=\"datagrid-mask-msg\" style=\"display:block;left:50%\"></div>").html(opts.loadMsg).appendTo(_1dd);
                        msg._outerHeight(40);
                        msg.css({
                            marginLeft: ( - msg.outerWidth() / 2),
                            lineHeight: (msg.height() + "px")
                        });
                    }
                }
            });
        },
        loaded: function(jq) {
            return jq.each(function() {
                $(this).datagrid("getPager").pagination("loaded");
                var _1de = $(this).datagrid("getPanel");
                _1de.children("div.datagrid-mask-msg").remove();
                _1de.children("div.datagrid-mask").remove();
            });
        },
        fitColumns: function(jq) {
            return jq.each(function() {
                _97(this);
            });
        },
        fixColumnSize: function(jq, _1df) {
            return jq.each(function() {
                _54(this, _1df);
            });
        },
        fixRowHeight: function(jq, _1e0) {
            return jq.each(function() {
                _31(this, _1e0);
            });
        },
        freezeRow: function(jq, _1e1) {
            return jq.each(function() {
                _42(this, _1e1);
            });
        },
        autoSizeColumn: function(jq, _1e2) {
            return jq.each(function() {
                _a6(this, _1e2);
            });
        },
        loadData: function(jq, data) {
            return jq.each(function() {
                _96(this, data);
                _165(this);
            });
        },
        getData: function(jq) {
            return $.data(jq[0], "datagrid").data;
        },
        getRows: function(jq) {
            return $.data(jq[0], "datagrid").data.rows;
        },
        getFooterRows: function(jq) {
            return $.data(jq[0], "datagrid").footer;
        },
        getRowIndex: function(jq, id) {
            return _e3(jq[0], id);
        },
        getChecked: function(jq) {
            return _ee(jq[0]);
        },
        getSelected: function(jq) {
            var rows = _e8(jq[0]);
            return rows.length > 0 ? rows[0] : null;
        },
        getSelections: function(jq) {
            return _e8(jq[0]);
        },
        clearSelections: function(jq) {
            return jq.each(function() {
                var _1e3 = $.data(this, "datagrid");
                var _1e4 = _1e3.selectedRows;
                var _1e5 = _1e3.checkedRows;
                _1e4.splice(0, _1e4.length);
                unselectAll(this);
                if (_1e3.options.checkOnSelect) {
                    _1e5.splice(0, _1e5.length);
                }
            });
        },
        clearChecked: function(jq) {
            return jq.each(function() {
                var _1e6 = $.data(this, "datagrid");
                var _1e7 = _1e6.selectedRows;
                var _1e8 = _1e6.checkedRows;
                _1e8.splice(0, _1e8.length);
                _11a(this);
                if (_1e6.options.selectOnCheck) {
                    _1e7.splice(0, _1e7.length);
                }
            });
        },
        scrollTo: function(jq, _1e9) {
            return jq.each(function() {
                _f3(this, _1e9);
            });
        },
        highlightRow: function(jq, _1ea) {
            return jq.each(function() {
                _fb(this, _1ea);
                _f3(this, _1ea);
            });
        },
        selectAll: function(jq) {
            return jq.each(function() {
                _10f(this);
            });
        },
        unselectAll: function(jq) {
            return jq.each(function() {
                unselectAll(this);
            });
        },
        selectRow: function(jq, _1eb) {
            return jq.each(function() {
                selectRow(this, _1eb);
            });
        },
        selectRecord: function(jq, id) {
            return jq.each(function() {
                var opts = $.data(this, "datagrid").options;
                if (opts.idField) {
                    var _1ec = _e3(this, id);
                    if (_1ec >= 0) {
                        $(this).datagrid("selectRow", _1ec);
                    }
                }
            });
        },
        unselectRow: function(jq, _1ed) {
            return jq.each(function() {
                unselectRow(this, _1ed);
            });
        },
        checkRow: function(jq, _1ee) {
            return jq.each(function() {
                _107(this, _1ee);
            });
        },
        uncheckRow: function(jq, _1ef) {
            return jq.each(function() {
                _10e(this, _1ef);
            });
        },
        checkAll: function(jq) {
            return jq.each(function() {
                checkAll(this);
            });
        },
        uncheckAll: function(jq) {
            return jq.each(function() {
                _11a(this);
            });
        },
        beginEdit: function(jq, _1f0) {
            return jq.each(function() {
                beginEdit(this, _1f0);
            });
        },
        endEdit: function(jq, _1f1) {
            return jq.each(function() {
                stopEdit(this, _1f1, false);
            });
        },
        cancelEdit: function(jq, _1f2) {
            return jq.each(function() {
                stopEdit(this, _1f2, true);
            });
        },
        getEditors: function(jq, _1f3) {
            return _13d(jq[0], _1f3);
        },
        getEditor: function(jq, _1f4) {
            return _141(jq[0], _1f4);
        },
        refreshRow: function(jq, _1f5) {
            return jq.each(function() {
                var opts = $.data(this, "datagrid").options;
                opts.view.refreshRow.call(opts.view, this, _1f5);
            });
        },
        validateRow: function(jq, _1f6) {
            return validateRow(jq[0], _1f6);
        },
        updateRow: function(jq, _1f7) {
            return jq.each(function() {
                var opts = $.data(this, "datagrid").options;
                opts.view.updateRow.call(opts.view, this, _1f7.index, _1f7.row);
            });
        },
        appendRow: function(jq, row) {
            return jq.each(function() {
                _162(this, row);
            });
        },
        insertRow: function(jq, _1f8) {
            return jq.each(function() {
                _15e(this, _1f8);
            });
        },
        deleteRow: function(jq, _1f9) {
            return jq.each(function() {
                _158(this, _1f9);
            });
        },
        getChanges: function(jq, _1fa) {
            return getChanges(jq[0], _1fa);
        },
        acceptChanges: function(jq) {
            return jq.each(function() {
                _169(this);
            });
        },
        rejectChanges: function(jq) {
            return jq.each(function() {
                _16b(this);
            });
        },
        mergeCells: function(jq, _1fb) {
            return jq.each(function() {
                _17e(this, _1fb);
            });
        },
        showColumn: function(jq, _1fc) {
            return jq.each(function() {
                var _1fd = $(this).datagrid("getPanel");
                _1fd.find("td[field=\"" + _1fc + "\"]").show();
                $(this).datagrid("getColumnOption", _1fc).hidden = false;
                $(this).datagrid("fitColumns");
            });
        },
        hideColumn: function(jq, _1fe) {
            return jq.each(function() {
                var _1ff = $(this).datagrid("getPanel");
                _1ff.find("td[field=\"" + _1fe + "\"]").hide();
                $(this).datagrid("getColumnOption", _1fe).hidden = true;
                $(this).datagrid("fitColumns");
            });
        },
        sort: function(jq, _200) {
            return jq.each(function() {
                _89(this, _200);
            });
        }
    };
    $.fn.datagrid.parseOptions = function(_201) {
        var t = $(_201);
        return $.extend({},
            $.fn.panel.parseOptions(_201), $.parser.parseOptions(_201, ["url", "toolbar", "idField", "sortName", "sortOrder", "pagePosition", "resizeHandle", {
                sharedStyleSheet: "boolean",
                fitColumns: "boolean",
                autoRowHeight: "boolean",
                striped: "boolean",
                nowrap: "boolean"
            },
                {
                    rownumbers: "boolean",
                    singleSelect: "boolean",
                    ctrlSelect: "boolean",
                    checkOnSelect: "boolean",
                    selectOnCheck: "boolean"
                },
                {
                    pagination: "boolean",
                    pageSize: "number",
                    pageNumber: "number"
                },
                {
                    multiSort: "boolean",
                    remoteSort: "boolean",
                    showHeader: "boolean",
                    showFooter: "boolean"
                },
                {
                    scrollbarSize: "number"
                }]), {
                pageList: (t.attr("pageList") ? eval(t.attr("pageList")) : undefined),
                loadMsg: (t.attr("loadMsg") != undefined ? t.attr("loadMsg") : undefined),
                rowStyler: (t.attr("rowStyler") ? eval(t.attr("rowStyler")) : undefined)
            });
    };
    $.fn.datagrid.parseData = function(_202) {
        var t = $(_202);
        var data = {
            total: 0,
            rows: []
        };
        var _203 = t.datagrid("getColumnFields", true).concat(t.datagrid("getColumnFields", false));
        t.find("tbody tr").each(function() {
            data.total++;
            var row = {};
            $.extend(row, $.parser.parseOptions(this, ["iconCls", "state"]));
            for (var i = 0; i < _203.length; i++) {
                row[_203[i]] = $(this).find("td:eq(" + i + ")").html();
            }
            data.rows.push(row);
        });
        return data;
    };
    var _204 = {
        render: function(_205, _206, _207) {
            var _208 = $.data(_205, "datagrid");
            var opts = _208.options;
            var rows = _208.data.rows;
            var _209 = $(_205).datagrid("getColumnFields", _207);
            if (_207) {
                if (! (opts.rownumbers || (opts.frozenColumns && opts.frozenColumns.length))) {
                    return;
                }
            }
            var _20a = ["<table class=\"datagrid-btable\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>"];
            for (var i = 0; i < rows.length; i++) {
                var css = opts.rowStyler ? opts.rowStyler.call(_205, i, rows[i]) : "";
                var _20b = "";
                var _20c = "";
                if (typeof css == "string") {
                    _20c = css;
                } else {
                    if (css) {
                        _20b = css["class"] || "";
                        _20c = css["style"] || "";
                    }
                }
                var cls = "class=\"datagrid-row " + (i % 2 && opts.striped ? "datagrid-row-alt ": " ") + _20b + "\"";
                var _20d = _20c ? "style=\"" + _20c + "\"": "";
                var _20e = _208.rowIdPrefix + "-" + (_207 ? 1 : 2) + "-" + i;
                _20a.push("<tr id=\"" + _20e + "\" datagrid-row-index=\"" + i + "\" " + cls + " " + _20d + ">");
                _20a.push(this.renderRow.call(this, _205, _209, _207, i, rows[i]));
                _20a.push("</tr>");
            }
            _20a.push("</tbody></table>");
            $(_206).html(_20a.join(""));
        },
        renderFooter: function(_20f, _210, _211) {
            var opts = $.data(_20f, "datagrid").options;
            var rows = $.data(_20f, "datagrid").footer || [];
            var _212 = $(_20f).datagrid("getColumnFields", _211);
            var _213 = ["<table class=\"datagrid-ftable\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>"];
            for (var i = 0; i < rows.length; i++) {
                _213.push("<tr class=\"datagrid-row\" datagrid-row-index=\"" + i + "\">");
                _213.push(this.renderRow.call(this, _20f, _212, _211, i, rows[i]));
                _213.push("</tr>");
            }
            _213.push("</tbody></table>");
            $(_210).html(_213.join(""));
        },
        renderRow: function(_214, _215, _216, index, row) {
            var opts = $.data(_214, "datagrid").options;
            var tbody = [];
            if (_216 && opts.rownumbers) {
                var _219 = index + 1;
                if (opts.pagination) {
                    _219 += (opts.pageNumber - 1) * opts.pageSize;
                }
                tbody.push("<td class=\"datagrid-td-rownumber\"><div class=\"datagrid-cell-rownumber\">" + _219 + "</div></td>");
            }
            for (var i = 0; i < _215.length; i++) {
                var field = _215[i];
                var col = $(_214).datagrid("getColumnOption", field);
                if (col) {
                    var value = row[field];
                    var css = col.styler ? (col.styler(value, row, index) || "") : "";
                    var _21c = "";
                    var _21d = "";
                    if (typeof css == "string") {
                        _21d = css;
                    } else {
                        if (css) {
                            _21c = css["class"] || "";
                            _21d = css["style"] || "";
                        }
                    }
                    var cls = _21c ? "class=\"" + _21c + "\"": "";
                    var _21e = col.hidden ? "style=\"display:none;" + _21d + "\"": (_21d ? "style=\"" + _21d + "\"": "");
                    tbody.push("<td field=\"" + field + "\" " + cls + " " + _21e + ">");
                    var _21e = "";
                    if (!col.checkbox) {
                        if (col.align) {
                            _21e += "text-align:" + col.align + ";";
                        }
                        if (!opts.nowrap) {
                            _21e += "white-space:normal;height:auto;";
                        } else {
                            if (opts.autoRowHeight) {
                                _21e += "height:auto;";
                            }
                        }
                    }
                    tbody.push("<div style=\"" + _21e + "\" ");
                    tbody.push(col.checkbox ? "class=\"datagrid-cell-check\"": "class=\"datagrid-cell " + col.cellClass + "\"");
                    tbody.push(">");
                    if (col.checkbox) {
                        tbody.push("<input type=\"checkbox\" " + (row.checked ? "checked=\"checked\"": ""));
                        tbody.push(" name=\"" + field + "\" value=\"" + (value != undefined ? value: "") + "\">");
                    } else {
                        if (col.formatter) {
                            tbody.push(col.formatter(value, row, index, field));
                        } else {
                            tbody.push(value);
                        }
                    }
                    tbody.push("</div>");
                    tbody.push("</td>");
                }
            }
            return tbody.join("");
        },
        refreshRow: function(_21f, _220) {
            this.updateRow.call(this, _21f, _220, {});
        },
        updateRow: function(_221, _222, row) {
            var opts = $.data(_221, "datagrid").options;
            var rows = $(_221).datagrid("getRows");
            $.extend(rows[_222], row);
            var css = opts.rowStyler ? opts.rowStyler.call(_221, _222, rows[_222]) : "";
            var _223 = "";
            var _224 = "";
            if (typeof css == "string") {
                _224 = css;
            } else {
                if (css) {
                    _223 = css["class"] || "";
                    _224 = css["style"] || "";
                }
            }
            var _223 = "datagrid-row " + (_222 % 2 && opts.striped ? "datagrid-row-alt ": " ") + _223;
            function _225(_226) {
                var _227 = $(_221).datagrid("getColumnFields", _226);
                var tr = opts.finder.getTr(_221, _222, "body", (_226 ? 1 : 2));
                var _228 = tr.find("div.datagrid-cell-check input[type=checkbox]").is(":checked");
                tr.html(this.renderRow.call(this, _221, _227, _226, _222, rows[_222]));
                tr.attr("style", _224).attr("class", tr.hasClass("datagrid-row-selected") ? _223 + " datagrid-row-selected": _223);
                if (_228) {
                    tr.find("div.datagrid-cell-check input[type=checkbox]")._propAttr("checked", true);
                }
            };
            _225.call(this, true);
            _225.call(this, false);
            $(_221).datagrid("fixRowHeight", _222);
        },
        insertRow: function(_229, _22a, row) {
            var _22b = $.data(_229, "datagrid");
            var opts = _22b.options;
            var dc = _22b.dc;
            var data = _22b.data;
            if (_22a == undefined || _22a == null) {
                _22a = data.rows.length;
            }
            if (_22a > data.rows.length) {
                _22a = data.rows.length;
            }
            function _22c(_22d) {
                var _22e = _22d ? 1 : 2;
                for (var i = data.rows.length - 1; i >= _22a; i--) {
                    var tr = opts.finder.getTr(_229, i, "body", _22e);
                    tr.attr("datagrid-row-index", i + 1);
                    tr.attr("id", _22b.rowIdPrefix + "-" + _22e + "-" + (i + 1));
                    if (_22d && opts.rownumbers) {
                        var _22f = i + 2;
                        if (opts.pagination) {
                            _22f += (opts.pageNumber - 1) * opts.pageSize;
                        }
                        tr.find("div.datagrid-cell-rownumber").html(_22f);
                    }
                    if (opts.striped) {
                        tr.removeClass("datagrid-row-alt").addClass((i + 1) % 2 ? "datagrid-row-alt": "");
                    }
                }
            };
            function _230(_231) {
                var _232 = _231 ? 1 : 2;
                var _233 = $(_229).datagrid("getColumnFields", _231);
                var _234 = _22b.rowIdPrefix + "-" + _232 + "-" + _22a;
                var tr = "<tr id=\"" + _234 + "\" class=\"datagrid-row\" datagrid-row-index=\"" + _22a + "\"></tr>";
                if (_22a >= data.rows.length) {
                    if (data.rows.length) {
                        opts.finder.getTr(_229, "", "last", _232).after(tr);
                    } else {
                        var cc = _231 ? dc.body1: dc.body2;
                        cc.html("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody>" + tr + "</tbody></table>");
                    }
                } else {
                    opts.finder.getTr(_229, _22a + 1, "body", _232).before(tr);
                }
            };
            _22c.call(this, true);
            _22c.call(this, false);
            _230.call(this, true);
            _230.call(this, false);
            data.total += 1;
            data.rows.splice(_22a, 0, row);
            this.refreshRow.call(this, _229, _22a);
        },
        deleteRow: function(_235, _236) {
            var _237 = $.data(_235, "datagrid");
            var opts = _237.options;
            var data = _237.data;
            function _238(_239) {
                var _23a = _239 ? 1 : 2;
                for (var i = _236 + 1; i < data.rows.length; i++) {
                    var tr = opts.finder.getTr(_235, i, "body", _23a);
                    tr.attr("datagrid-row-index", i - 1);
                    tr.attr("id", _237.rowIdPrefix + "-" + _23a + "-" + (i - 1));
                    if (_239 && opts.rownumbers) {
                        var _23b = i;
                        if (opts.pagination) {
                            _23b += (opts.pageNumber - 1) * opts.pageSize;
                        }
                        tr.find("div.datagrid-cell-rownumber").html(_23b);
                    }
                    if (opts.striped) {
                        tr.removeClass("datagrid-row-alt").addClass((i - 1) % 2 ? "datagrid-row-alt": "");
                    }
                }
            };
            opts.finder.getTr(_235, _236).remove();
            _238.call(this, true);
            _238.call(this, false);
            data.total -= 1;
            data.rows.splice(_236, 1);
        },
        onBeforeRender: function(_23c, rows) {},
        onAfterRender: function(_23d) {
            var opts = $.data(_23d, "datagrid").options;
            if (opts.showFooter) {
                var _23e = $(_23d).datagrid("getPanel").find("div.datagrid-footer");
                _23e.find("div.datagrid-cell-rownumber,div.datagrid-cell-check").css("visibility", "hidden");
            }
        }
    };
    $.fn.datagrid.defaults = $.extend({},
        $.fn.panel.defaults, {
            sharedStyleSheet: false,
            frozenColumns: undefined,
            columns: undefined,
            fitColumns: false,
            resizeHandle: "right",
            autoRowHeight: true,
            toolbar: null,
            striped: false,
            method: "post",
            nowrap: true,
            idField: null,
            url: null,
            data: null,
            loadMsg: "Processing, please wait ...",
            rownumbers: false,
            singleSelect: false,
            ctrlSelect: false,
            selectOnCheck: true,
            checkOnSelect: true,
            pagination: false,
            pagePosition: "bottom",
            pageNumber: 1,
            pageSize: 10,
            pageList: [10, 20, 30, 40, 50],
            queryParams: {},
            sortName: null,
            sortOrder: "asc",
            multiSort: false,
            remoteSort: true,
            showHeader: true,
            showFooter: false,
            scrollbarSize: 18,
            rowStyler: function(_23f, _240) {},
            loader: function(_241, _242, _243) {
                var opts = $(this).datagrid("options");
                if (!opts.url) {
                    return false;
                }
                $.ajax({
                    type: opts.method,
                    url: opts.url,
                    data: _241,
                    dataType: "json",
                    success: function(data) {
                        _242(data);
                    },
                    error: function() {
                        _243.apply(this, arguments);
                    }
                });
            },
            loadFilter: function(data) {
                if (typeof data.length == "number" && typeof data.splice == "function") {
                    return {
                        total: data.length,
                        rows: data
                    };
                } else {
                    return data;
                }
            },
            editors: editorsObj,
            finder: {
                getTr: function(_244, _245, type, _246) {
                    type = type || "body";
                    _246 = _246 || 0;
                    var _247 = $.data(_244, "datagrid");
                    var dc = _247.dc;
                    var opts = _247.options;
                    if (_246 == 0) {
                        var tr1 = opts.finder.getTr(_244, _245, type, 1);
                        var tr2 = opts.finder.getTr(_244, _245, type, 2);
                        return tr1.add(tr2);
                    } else {
                        if (type == "body") {
                            var tr = $("#" + _247.rowIdPrefix + "-" + _246 + "-" + _245);
                            if (!tr.length) {
                                tr = (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr[datagrid-row-index=" + _245 + "]");
                            }
                            return tr;
                        } else {
                            if (type == "footer") {
                                return (_246 == 1 ? dc.footer1: dc.footer2).find(">table>tbody>tr[datagrid-row-index=" + _245 + "]");
                            } else {
                                if (type == "selected") {
                                    return (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr.datagrid-row-selected");
                                } else {
                                    if (type == "highlight") {
                                        return (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr.datagrid-row-over");
                                    } else {
                                        if (type == "checked") {
                                            return (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr.datagrid-row-checked");
                                        } else {
                                            if (type == "last") {
                                                return (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr[datagrid-row-index]:last");
                                            } else {
                                                if (type == "allbody") {
                                                    return (_246 == 1 ? dc.body1: dc.body2).find(">table>tbody>tr[datagrid-row-index]");
                                                } else {
                                                    if (type == "allfooter") {
                                                        return (_246 == 1 ? dc.footer1: dc.footer2).find(">table>tbody>tr[datagrid-row-index]");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                getRow: function(_248, p) {
                    var _249 = (typeof p == "object") ? p.attr("datagrid-row-index") : p;
                    return $.data(_248, "datagrid").data.rows[parseInt(_249)];
                },
                getRows: function(_24a) {
                    return $(_24a).datagrid("getRows");
                }
            },
            view: _204,
            onBeforeLoad: function(_24b) {},
            onLoadSuccess: function() {},
            onLoadError: function() {},
            onClickRow: function(_24c, _24d) {},
            onDblClickRow: function(_24e, _24f) {},
            onClickCell: function(_250, _251, _252) {},
            onDblClickCell: function(_253, _254, _255) {},
            onBeforeSortColumn: function(sort, _256) {},
            onSortColumn: function(sort, _257) {},
            onResizeColumn: function(_258, _259) {},
            onSelect: function(_25a, _25b) {},
            onUnselect: function(_25c, _25d) {},
            onSelectAll: function(rows) {},
            onUnselectAll: function(rows) {},
            onCheck: function(_25e, _25f) {},
            onUncheck: function(_260, _261) {},
            onCheckAll: function(rows) {},
            onUncheckAll: function(rows) {},
            onBeforeEdit: function(_262, _263) {},
            onBeginEdit: function(_264, _265) {},
            onEndEdit: function(_266, _267, _268) {},
            onAfterEdit: function(_269, _26a, _26b) {},
            onCancelEdit: function(_26c, _26d) {},
            onHeaderContextMenu: function(e, _26e) {},
            onRowContextMenu: function(e, _26f, _270) {}
        });
})(jQuery);