-- Taiwanese localization file for zhTW.
local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("ElvUI", "zhTW")
if not L then return end

-- *_DESC locales
L["AURAS_DESC"] = "小地圖旁的光環圖示設定."
L["BAGS_DESC"] = "調整 ElvUI 背包設定."
L["CHAT_DESC"] = "對話框架設定."
L["DATATEXT_DESC"] = "螢幕資訊文字顯示設定."
L["ELVUI_DESC"] = "ElvUI 為一套功能完整，可用來替換 WOW 原始介面的 UI 套件"
L["NAMEPLATE_DESC"] = "修改血條設定."
L["UNITFRAME_DESC"] = "修改單位框架設定."
L["ACTIONBARS_DESC"] = "修改動作條設定."
L["PANEL_DESC"] = "調整左、右對話框的尺寸，此設定將會影響對話與背包框架的尺寸."
L["SKINS_DESC"] = "調整外觀設定."
L["TOGGLESKIN_DESC"] = "啟用/停用此外觀."
L["TOOLTIP_DESC"] = "浮動提示資訊設定選項."
L["SEARCH_SYNTAX_DESC"] = [=[因為新增加的 LibItemSearch，你現在可以使用更進階的物品搜尋. 下面是一份搜尋語法的文件. 想要看更完整的解釋請到: https://github.com/Jaliborc/LibItemSearch-1.2/wiki/Search-Syntax.

條件搜尋:
    • q:[品質] 或 quality:[品質]. 舉例，q:史詩 會搜尋所有史詩物品.
    • l:[裝等]，lvl:[裝等] 或 level:[裝等]. 舉例，l:30 會搜尋所有裝等30的物品.
    • t:[類型]，type:[類型] 或 slot:[類型]. 舉例，t:武器 會搜尋所有武器.
    • n:[名稱] 或 name:[名稱]. 舉例，輸入 n:muffins 會搜尋所有物品名稱中含有 "muffins".
    • s:[套裝] 或 set:[套裝]. 舉例，s:火 會在你定義的套裝名稱起始為 火 的套裝中搜尋所有裝備.
    • tt:[關鍵字]，tip:[關鍵字] 或 tooltip:[關鍵字]. 舉例，tt:綁定 會搜尋所有物品提示中含有綁定兩字的物品 如 帳號綁定，裝備綁定 或 拾取綁定.


搜尋運算子:
    • ! : 反向搜尋. 舉例，!q:史詩 會搜尋所有不是史詩的物品
    • | : 聯集搜尋. 輸入 q:史詩 | t:武器 會搜尋所有史詩物品 或是 武器.
    • & : 交集搜尋. 舉例，q:史詩 & t:武器 會搜尋所有既是史詩 也是 武器的物品
    • >, <, <=, => : 在數值搜尋時進行比較. 舉例，輸入 lvl: >30 會搜尋所有裝等大於30的物品.


以下的關鍵字也可以被使用:
    • soulbound, bound, bop : 拾取綁定.
    • bou : 使用後綁定.
    • boe : 裝備後綁定.
    • boa : 帳號綁定.
    • quest : 任務綁定
    • reagents, reagent, crafting : 專業技能材料
    • naval : 海軍裝備.
    • follower, followe, follow : 追隨者物品
    • relic, reli, rel : 神器符文.
    • power, powe, pow : 賦予神器能量物品.]=];
L["TEXT_FORMAT_DESC"] = [=[請填入代碼以變更文字格式。

範例：
[namecolor][name] [difficultycolor][smartlevel] [shortclassification]
[healthcolor][health:current-max]
[powercolor][power:current]

生命/能量值格式：
'current' - 目前數值
'percent' - 百分比
'current-max' - 目前數值 - 最大值，當兩者相同時，僅會顯示最大值
'current-percent' - 目前數值 - 百分比
'current-max-percent' - 目前數值 - 最大值 - 百分比，當目前數值等同於最大值時，僅會顯示最大值
'deficit' - 顯示損失數值，若未損失生命/能量值，將不予顯示

名稱格式：
'name:short' - 名稱上限為 10 個字元
'name:medium' - 名稱上限為 15 個字元
'name:long' - 名稱上限為 20 個字元

若要停用此功能，此欄位請留空。如需更多資訊，請至 http://www.tukui.org]=];

--ActionBars
L["Action Paging"] = "快捷列翻頁"
L["ActionBars"] = "快捷列"
L["Allow Masque to handle the skinning of this element."] = "允許 Masque 來處理此元件的皮膚"
L["Alpha"] = "透明度"
L["Anchor Point"] = "定位方向"
L["Automatic"] = "自動"
L["Backdrop Spacing"] = "背景間距"
L["Backdrop"] = "背景"
L["Button Size"] = "按鈕尺寸"
L["Button Spacing"] = "按鈕間距"
L["Buttons Per Row"] = "每行按鈕數"
L["Buttons"] = "按鈕數"
L["Change the alpha level of the frame."] = "改變框架透明度."
L["Color of the actionbutton when not usable."] = "無法使用的技能快捷鍵顏色."
L["Color of the actionbutton when out of power (Mana, Rage, Focus, Holy Power)."] = "施放能量 (法力、怒氣、集中值、聖能) 不足的技能快捷鍵顏色."
L["Color of the actionbutton when out of range."] = "超出施放範圍的技能快捷鍵顏色."
L["Color of the actionbutton when usable."] = "可使用的技能快捷鍵顏色."
L["Color when the text is about to expire"] = "即將冷卻完畢的數字顏色."
L["Color when the text is in the days format."] = "以天顯示的文字顏色."
L["Color when the text is in the hours format."] = "以小時顯示的文字顏色."
L["Color when the text is in the minutes format."] = "以分顯示的文字顏色."
L["Color when the text is in the seconds format."] = "以秒顯示的文字顏色."
L["Cooldown Text"] = "冷卻文字"
L["Darken Inactive"] = "非啟用者變暗";
L["Days"] = "天"
L["Display bind names on action buttons."] = "在快捷列按鈕上顯示快捷鍵名稱."
L["Display cooldown text on anything with the cooldown spiral."] = "在任何冷卻動畫上顯示技能冷卻時間."
L["Display macro names on action buttons."] = "在快捷列按鈕上顯示巨集名稱."
L["Expiring"] = "即將冷卻完畢"
L["Flyout Direction"] = "飛出方向"
L["Global Fade Transparency"] = "全局漸隱透明度"
L["Height Multiplier"] = "高度倍數"
L["Hide Cooldown Bling"] = "隱藏冷卻閃光"
L["Hides the bling animation on buttons at the end of the global cooldown."] = "隱藏當公共冷卻時間結束時的閃光動畫"
L["Hours"] = "時"
L["If you unlock actionbars then trying to move a spell might instantly cast it if you cast spells on key press instead of key release."] = "如果你將快捷列解鎖後嘗試移動技能, 技能可能會馬上施放因為你使用按下施法而非釋放施法"
L["Inherit Global Fade"] = "繼承全局漸隱"
L["Inherit the global fade, mousing over, targetting, setting focus, losing health, entering combat will set the remove transparency. Otherwise it will use the transparency level in the general actionbar settings for global fade alpha."] = "繼承全局漸隱, 當滑鼠滑過, 設為目標, 設為焦點, 損失血量, 進入戰鬥時都會變為不透明, 除此之外將會使用在全局快捷列中的所設定的全局漸隱透明度"
L["Key Down"] = "按下施法"
L["Keybind Mode"] = "快捷鍵綁定模式"
L["Keybind Text"] = "快捷鍵文字"
L["Low Threshold"] = "冷卻時間低閥值"
L["Macro Text"] = "巨集名稱"
L["Masque Support"] = "Masque 支援"
L["Minutes"] = "分"
L["Mouse Over"] = "滑鼠滑過顯示"
L["Multiply the backdrops height or width by this value. This is usefull if you wish to have more than one bar behind a backdrop."] = "根據此值增加背景的高度或寬度. 一般用來設定在一個背景框裡放置多條快捷列."
L["Not Usable"] = "無法使用"
L["Out of Power"] = "施放能量不足"
L["Out of Range"] = "超出施放範圍"
L["Restore Bar"] = "還原快捷列"
L["Restore the actionbars default settings"] = "恢復此快捷列的預設設定"
L["Seconds"] = "秒"
L["Show Empty Buttons"] = "顯示空白按鈕"
L["Shows a swipe animation when a spell is recharging but still has charges left."] = "當法術仍有可使用次數並在充能時顯示一個倒數動畫"
L["The amount of buttons to display per row."] = "每行所顯示的按鈕數量."
L["The amount of buttons to display."] = "快捷列按鈕顯示數量."
L["The button you must hold down in order to drag an ability to another action button."] = "需按住此按鈕，才可將技能拖曳至另一快捷鈕中."
L["The first button anchors itself to this point on the bar."] = "快捷列第一個按鈕的所在位置."
L["The size of the action buttons."] = "快捷列按鈕尺寸."
L["The spacing between the backdrop and the buttons."] = "背景與按鈕之間的間隙"
L["This setting will be updated upon changing stances."] = "此設定將在切換姿態時更新"
L["Threshold before text turns red and is in decimal form. Set to -1 for it to never turn red"] = "冷卻時間低於此秒數後將變為紅色數字, 並以小數顯示, 設為- 1 冷卻時間將不會變為紅色."
L["Toggles the display of the actionbars backdrop."] = "顯示/隱藏快捷列背景框."
L["Transparency level when not in combat, no target exists, full health, not casting, and no focus target exists."] = "當非戰鬥, 沒有目標, 滿血, 未施法且沒有焦點目標存在時的透明度"
L["Usable"] = "可以使用"
L["Use Draw Swipe"] = "使用充能動畫"
L["Use Position Override"] = "使用位置覆蓋"
L["Visibility State"] = "顯示狀態"
L["When enabled it will use the Anchor Point setting to determine growth direction, otherwise it will be determined by where the bar is positioned."] = "當啟用時會使用定位點的位置來決定按鈕增長的方向,否則將會依照快捷列的位置來決定"
L["Width Multiplier"] = "寬度倍數"
L["Zone Ability"] = "要塞技能"
L[ [=[This works like a macro, you can run different situations to get the actionbar to page differently.
 Example: '[combat] 2;']=] ] = [=[此功能與巨集概念類似, 可根據不同情況切換至不同的快捷列設定。
例如：'[combat] 2;']=]
L[ [=[This works like a macro, you can run different situations to get the actionbar to show/hide differently.
 Example: '[combat] show;hide']=] ] = [=[此功能與巨集概念類似, 可根據不同情境, 切換顯示/隱藏快捷列。
例如：'[combat] show;hide']=]

--Bags
L["Add an item or search syntax to the ignored list. Items matching the search syntax will be ignored."] = "增加一個物品或是搜尋語法到忽略清單. 符合搜尋語法的物品將會被忽略"
L["Add Item or Search Syntax"] = "增加物品或是搜尋語法"
L["Adjust the width of the bag frame."] = "調整背包框架寬度."
L["Adjust the width of the bank frame."] = "調整銀行框架寬度."
L["Ascending"] = "升序"
L["Bag Sorting"] = "背包排序"
L["Bag-Bar"] = "背包條"
L["Bar Direction"] = "背包條排序方向"
L["Blizzard Style"] = "暴雪風格"
L["Bottom to Top"] = "底部至頂部"
L["Button Size (Bag)"] = "單個格子尺寸 (背包)"
L["Button Size (Bank)"] = "單個格子尺寸 (銀行)"
L["Clear Search On Close"] = "關閉時清空搜尋"
L["Condensed"] = "濃縮"
L["Currency Format"] = "貨幣格式"
L["Descending"] = "降序"
L["Direction the bag sorting will use to allocate the items."] = "整理背包物品時，將依此排序方向排放物品."
L["Disable Bag Sort"] = "停用背包排序"
L["Disable Bank Sort"] = "停用銀行排序"
L["Display Item Level"] = "顯示物品等級"
L["Display the junk icon on all grey items that can be vendored."] = "在所有可販賣的灰色物品上顯示垃圾圖示"
L["Display the upgrade icon on items that WoW considers an upgrade for your character."] = "為WoW認為可以為你角色提升的物品顯示升級圖標"
L["Displays item level on equippable items."] = "在可裝備物品上顯示裝備等級"
L["Enable/Disable the all-in-one bag."] = "啟用/停用整合背包."
L["Enable/Disable the Bag-Bar."] = "啟用/停用背包條."
L["Full"] = "滿"
L["Global"] = "全局"
L["Here you can add items or search terms that you want to be excluded from sorting. To remove an item just click on its name in the list."] = "在此你可以新增物品或是搜尋語法來排除排序某些物品. 要移除物品請點選列表中的物品名稱"
L["Icons and Text (Short)"] = "圖示與文字(簡短)"
L["Icons and Text"] = "圖示與文字"
L["Ignored Items and Search Syntax (Global)"] = "忽略的物品與搜尋語法 (全局)"
L["Ignored Items and Search Syntax (Profile)"] = "忽略的物品與搜尋語法 (個人)"
L["Item Count Font"] = "物品記數字型"
L["Item Level Threshold"] = "物品等級閥值"
L["Item Level"] = "物品等級"
L["Money Format"] = "金幣格式"
L["Panel Width (Bags)"] = "框架寬度 (背包)"
L["Panel Width (Bank)"] = "框架寬度 (銀行)"
L["Search Syntax"] = "搜尋語法"
L["Set the size of your bag buttons."] = "設定你的背包格子大小."
L["Short (Whole Numbers)"] = "短 (完整數字)"
L["Show Coins"] = "顯示硬幣"
L["Show Junk Icon"] = "顯示垃圾圖示"
L["Show Upgrade Icon"] = "顯示升級圖標"
L["Smart"] = "智慧"
L["Sort Direction"] = "排序方向"
L["Sort Inverted"] = "倒序排列"
L["The direction that the bag frames be (Horizontal or Vertical)."] = "背包框架排序方向 (水平或垂直)."
L["The direction that the bag frames will grow from the anchor."] = "新增的背包框架將從錨點依此方向增加."
L["The display format of the currency icons that get displayed below the main bag. (You have to be watching a currency for this to display)"] = "背包主框架下方的兌換通貨圖示顯示格式.需先設定監控特定兌換通貨，才會顯示於背包框架."
L["The display format of the money text that is shown at the top of the main bag."] = "在背包主框架上方的金幣顯示格式"
L["The frame is not shown unless you mouse over the frame."] = "僅於滑鼠移經快捷列時顯示框架."
L["The minimum item level required for it to be shown."] = "顯示的最低物品等級"
L["The size of the individual buttons on the bag frame."] = "背包框架單個格子的大小."
L["The size of the individual buttons on the bank frame."] = "銀行框架單個格子的大小."
L["The spacing between buttons."] = "兩個按鈕間的距離."
L["Top to Bottom"] = "頂部至底部"
L["Use coin icons instead of colored text."] = "使用硬幣圖示取代上色文字"

--Buffs and Debuffs
L["Begin a new row or column after this many auras."] = "在這些光環旁開始新的行或列."
L["Count xOffset"] = "層數X偏移"
L["Count yOffset"] = "層數Y偏移"
L["Defines how the group is sorted."] = "定義群組的排序方式."
L["Defines the sort order of the selected sort method."] = "定義所選排序方式的排序方向."
L["Disabled Blizzard"] = "停用暴雪框架"
L["Fade Threshold"] = "漸隱時間閥值"
L["Index"] = "索引"
L["Indicate whether buffs you cast yourself should be separated before or after."] = "將你自身施放的增益放於整體增益最前方或或最後方."
L["Limit the number of rows or columns."] = "最大行數或列數."
L["Max Wraps"] = "每行最大數"
L["No Sorting"] = "不分類"
L["Other's First"] = "他人光環優先"
L["Seperate"] = "光環分離"
L["Set the size of the individual auras."] = "設定每個光環的尺寸."
L["Sort Method"] = "分類方式"
L["The direction the auras will grow and then the direction they will grow after they reach the wrap after limit."] = "光環增加的方向與到達每行最大數後換行增加的方向"
L["Threshold before text changes red, goes into decimal form, and the icon will fade. Set to -1 to disable."] = "冷卻時間低於此秒數後將變為紅色數字且以小數顯示, 並且圖示會漸隱. 設定為-1 禁用此功能."
L["Time xOffset"] = "時間X偏移"
L["Time yOffset"] = "時間Y偏移"
L["Time"] = "時間"
L["Wrap After"] = "每行光環數"
L["Your Auras First"] = "自身光環優先"

--Chat
L["Above Chat"] = "對話框上方"
L["Adjust the height of your right chat panel."] = "調整右側聊天框的高度"
L["Adjust the width of your right chat panel."] = "調整右側聊天框的寬度"
L["Alerts"] = "警示"
L["Allowed Combat Repeat"] = "戰鬥連續按鍵修復"
L["Attempt to create URL links inside the chat."] = "對話視窗出現網址時建立連結."
L["Attempt to lock the left and right chat frame positions. Disabling this option will allow you to move the main chat frame anywhere you wish."] = "鎖定左右對話框架的位置.禁用此選項將允許你移動對話框架到任意位置."
L["Auto-Close Pet Battle Log"] = "自動關閉寵物對戰日誌"
L["Below Chat"] = "對話框下方"
L["Chat EditBox Position"] = "對話輸入框位置"
L["Chat History"] = "對話記錄"
L["Class Color Mentions"] = "使用職業上色"
L["Custom Timestamp Color"] = "自訂時間戳記顏色"
L["Display LFG Icons in group chat."] = "在隊伍聊天中顯示預組圖示"
L["Display the hyperlink tooltip while hovering over a hyperlink."] = "滑鼠懸停在超鏈接上時顯示鏈接提示框."
L["Enable the use of separate size options for the right chat panel."] = "啟用獨立的右聊天框大小選項"
L["Exclude Name"] = "排除名字"
L["Excluded names will not be class colored."] = "排除的名字將不會使用職業顏色"
L["Excluded Names"] = "排除的名字"
L["Fade Chat"] = "對話內容漸隱"
L["Fade Tabs No Backdrop"] = "隱藏拖出的聊天框"
L["Fade the chat text when there is no activity."] = "未出現新訊息時，隱藏對話框的文字."
L["Fade Undocked Tabs"] = "隱藏分離的聊天框"
L["Fades the text on chat tabs that are docked in a panel where the backdrop is disabled."] = "當你把一個聊天框拖出聊天背景框的時候會自動隱藏掉,注意這個聊天框並沒有被刪除,關閉該選項你可以重新找到它"
L["Fades the text on chat tabs that are not docked at the left or right chat panel."] = "當你把一個聊天框設置為分離狀態時會自動隱藏掉,注意這個聊天框並沒有被刪除,關閉該選項你可以重新找到它"
L["Font Outline"] = "字體描邊"
L["Font"] = "字體"
L["Hide Both"] = "全部隱藏"
L["Hyperlink Hover"] = "超連結提示資訊"
L["Keyword Alert"] = "關鍵字警報"
L["Keywords"] = "關鍵字"
L["Left Only"] = "僅顯示左框背景"
L["LFG Icons"] = "隨機隊列圖標"
L["List of words to color in chat if found in a message. If you wish to add multiple words you must seperate the word with a comma. To search for your current name you can use %MYNAME%.\n\nExample:\n%MYNAME%, ElvUI, RBGs, Tank"] = "如果在對話信息中發現如下文字會自動上色該文字. 如果你需要添加多個詞必須用逗號分開. 如要搜尋角色名稱可使用%MYNAME %.\n\n例如:\n%MYNAME%, ElvUI, RBGs, Tank"
L["Lock Positions"] = "鎖定位置"
L["Log the main chat frames history. So when you reloadui or log in and out you see the history from your last session."] = "記錄對話歷史,當你重載,登錄和退出時會恢復你最後一次會話"
L["No Alert In Combat"] = "戰鬥中不警報"
L["Number of messages you scroll for each step."] = "每次滾動的聊天資訊數目"
L["Number of repeat characters while in combat before the chat editbox is automatically closed."] = "當你在戰鬥中按下技能鍵時,有可能你的輸入框還處於打開狀態,這個功能可以在你按下技能鍵並且在輸入框中輸入下列個數字符串卻沒有放出技能時幫你自動關閉輸入框"
L["Number of time in seconds to scroll down to the bottom of the chat window if you are not scrolled down completely."] = "對話框滾動到底部所需要的滾動時間(秒)."
L["Panel Backdrop"] = "對話框背景"
L["Panel Height"] = "對話框高度"
L["Panel Texture (Left)"] = "對話框材質(左)"
L["Panel Texture (Right)"] = "對話框材質(右)"
L["Panel Width"] = "對話框寛度"
L["Position of the Chat EditBox, if datatexts are disabled this will be forced to be above chat."] = "對話編輯框位置,如果底部的信息文字被禁用的話,將會強制顯示在對話框頂部."
L["Prevent the same messages from displaying in chat more than once within this set amount of seconds, set to zero to disable."] = "單位時間(秒) 內屏蔽重複對話信息, 設定為0 禁用此功能."
L["Require holding the Alt key down to move cursor or cycle through messages in the editbox."] = "開啟該選項使你在查看聊天歷史記錄時需要按住Alt+上下鍵,如果關閉則直接按上下鍵即可"
L["Right Only"] = "僅顯示右框背景"
L["Right Panel Height"] = "右面板高度"
L["Right Panel Width"] = "右面板寬度"
L["Scroll Interval"] = "滾動間隔"
L["Scroll Messages"] = "滾動資訊數目"
L["Separate Panel Sizes"] = "分離框體大小"
L["Set the font outline."] = "字體描邊設定."
L["Short Channels"] = "隱藏頻道名稱"
L["Shorten the channel names in chat."] = "在對話視窗中隱藏頻道名稱."
L["Show Both"] = "全部顯示"
L["Spam Interval"] = "洗頻訊息間隔"
L["Sticky Chat"] = "記憶對話頻道"
L["Tab Font Outline"] = "分頁字體描邊"
L["Tab Font Size"] = "分頁字體尺寸"
L["Tab Font"] = "分頁字體"
L["Tab Panel Transparency"] = "標籤面板透明"
L["Tab Panel"] = "標籤面板"
L["Timestamp Color"] = "時間戳顏色"
L["Toggle showing of the left and right chat panels."] = "顯示/隱藏左、右對話框背景."
L["Toggle the chat tab panel backdrop."] = "顯示/隱藏對話框架標籤面板背景."
L["URL Links"] = "網址連結"
L["Use Alt Key"] = "對話歷史Alt鍵"
L["Use class color for the names of players when they are mentioned."] = "當玩家名字被提及時使用職業顏色"
L["When opening the Chat Editbox to type a message having this option set means it will retain the last channel you spoke in. If this option is turned off opening the Chat Editbox should always default to the SAY channel."] = "打開此選項將會保存你的輸入框為上一次輸入的頻道, 關閉此選項輸入框將始終保持在說的頻道."
L["Whisper Alert"] = "密語警報"
L[ [=[Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.

Please Note:
-The image size recommended is 256x128
-You must do a complete game restart after adding a file to the folder.
-The file type must be tga format.

Example: Interface\AddOns\ElvUI\media\textures\copy

Or for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.]=] ] = [=[若要設定對話框背景, 請將你希望設定為背景的檔案置放於WoW 目錄底下的「Textures」資料夾中, 並指定該檔名.

請注意：
- 影像尺寸建議為 256 x 128
- 在此資料夾新增檔案後, 請務必重新啟動遊戲.
- 檔案必須為 tga 格式.

範例：Interface\AddOns\ElvUI\media\textures\copy

對多數玩家來說, 較簡易的方式是將 tga 檔放入 WoW 資料夾中, 然後在此處輸入檔案名稱.]=]

--Credits
L["Coding:"] = "編碼:"
L["Credits"] = "嗚謝"
L["Donations:"] = "捐款: "
L["ELVUI_CREDITS"] = "我想透過這個特別方式, 向那些協助測試、編碼及透過捐款協助過我的人表達感謝, 請曾提供協助的朋友至論壇傳私訊給我, 我會將你的名字添加至此處."
L["Testing:"] = "測試："

--DataBars
L["Current - Percent (Remaining)"] = "當前值 - 百分百(剩餘)"
L["Current - Remaining"] = "當前值 - 剩餘值"
L["DataBars"] = "數據條"
L["Hide In Combat"] = "戰鬥中隱藏"
L["Hide Outside PvP"] = "PvP外隱藏"
L["Setup on-screen display of information bars."] = "設置各種數據條"

--DataTexts
L["24-Hour Time"] = "24小時制"
L["Add Currency ID"] = "添加貨幣ID"
L["Battleground Texts"] = "戰場資訊"
L["Block Combat Click"] = "戰鬥中屏蔽點擊"
L["Block Combat Hover"] = "戰鬥中屏蔽提示"
L["Blocks all click events while in combat."] = "戰鬥中禁用點擊事件"
L["Blocks datatext tooltip from showing in combat."] = "戰鬥中禁用浮動提示"
L["BottomLeftMiniPanel"] = "小地圖左下內側"
L["BottomMiniPanel"] = "小地圖底部內側"
L["BottomRightMiniPanel"] = "小地圖右下內側"
L["Custom Currencies"] = "自定義貨幣"
L["Custom Currency"] = "自定義貨幣"
L["Datatext Panel (Left)"] = "左側資訊框"
L["Datatext Panel (Right)"] = "右側資訊框"
L["DataTexts"] = "資訊文字"
L["Display data panels below the chat, used for datatexts."] = "在對話框下顯示用於資訊的框架."
L["Display In Main Tooltip"] = "在浮動提示資訊顯示"
L["Display minimap panels below the minimap, used for datatexts."] = "顯示小地圖下方的資訊框."
L["Displayed Currency"] = "顯示的金額"
L["Gold Format"] = "金幣格式"
L["If enabled, then this currency will be displayed in the main Currencies datatext tooltip."] = true;
L["If not set to true then the server time will be displayed instead."] = "若關閉此選項將顯示伺服器時間."
L["left"] = "左"
L["LeftChatDataPanel"] = "左對話框"
L["LeftMiniPanel"] = "小地圖左側"
L["Local Time"] = "本地時間"
L["middle"] = "中"
L["Minimap Panels"] = "小地圖欄"
L["Panel Transparency"] = "面板透明"
L["Panels"] = "對話框"
L["right"] = "右"
L["RightChatDataPanel"] = "右對話框"
L["RightMiniPanel"] = "小地圖右側"
L["Small Panels"] = "迷你面板"
L["The display format of the money text that is shown in the gold datatext and its tooltip."] = "在信息文字中顯示的金錢格式"
L["This allows you to create a new datatext which will track the currency with the supplied currency ID. The datatext can be added to a panel immediately after creation."] = "這允許你根據貨幣的ID來創建新的信息文字. 信息文字在創建後可以立即被添加到面板中."
L["Toggle 24-hour mode for the time datatext."] = "切換時間顯示為24小時制."
L["TopLeftMiniPanel"] = "Minimap TopLeft (Inside)"
L["TopMiniPanel"] = "Minimap Top (Inside)"
L["TopRightMiniPanel"] = "Minimap TopRight (Inside)"
L["Use Tooltip"] = "使用浮動提示"
L["When inside a battleground display personal scoreboard information on the main datatext bars."] = "處於戰場時, 在主資訊文字條顯示你的戰場得分訊息."
L["Word Wrap"] = "自動換行"

--Distributor
L["Must be in group with the player if he isn't on the same server as you."] = "如果不是同一服務器, 那他必需和你在同一隊伍中."
L["Sends your current profile to your target."] = "發送你的配置文件到當前目標."
L["Sends your filter settings to your target."] = "發送你的過濾器配置到當前目標."
L["Share Current Profile"] = "分享當前的配置文件"
L["Share Filters"] = "分享過濾器配置"
L["This feature will allow you to transfer settings to other characters."] = "此功能將使你設置轉移給其他角色."
L["You must be targeting a player."] = "你必須以一名玩家為目標."

--General
L["Accept Invites"] = "接受組隊邀請"
L["Adjust the position of the threat bar to either the left or right datatext panels."] = "調整仇恨條的位置於左側或右側資訊面板"
L["AFK Mode"] = "離開模式"
L["Announce Interrupts"] = "斷法通告"
L["Announce when you interrupt a spell to the specified chat channel."] = "在指定對話頻道通知斷法信息."
L["Attempt to support eyefinity/nvidia surround."] = "嘗試支持eyefinity/nvidia surround"
L["Auto Greed/DE"] = "自動貪婪/分解"
L["Auto Repair"] = "自動修裝"
L["Auto Scale"] = "自動縮放"
L["Automatically accept invites from guild/friends."] = "自動接受公會成員/朋友的組隊邀請."
L["Automatically repair using the following method when visiting a merchant."] = "與商人對話時，透過下列方式自動修復裝備."
L["Automatically scale the User Interface based on your screen resolution"] = "依螢幕解析度自動縮放 UI 介面."
L["Automatically select greed or disenchant (when available) on green quality items. This will only work if you are the max level."] = "當你的等級達到滿級時, 自動選擇貪婪或分解綠色物品."
L["Automatically vendor gray items when visiting a vendor."] = "當訪問商人時自動出售灰色物品."
L["Bonus Reward Position"] = "額外獎勵位置"
L["Bottom Panel"] = "底部面板"
L["Chat Bubbles Style"] = "聊天氣泡樣式"
L["Chat Bubbles"] = "聊天氣泡"
L["Direction the bar moves on gains/losses"] = "條增加/減少時的方向"
L["Disable Tutorial Buttons"] = "禁用教程按鈕"
L["Disables the tutorial button found on some frames."] = "禁用部分框體上的教程按鈕"
L["Display a panel across the bottom of the screen. This is for cosmetic only."] = "顯示跨越螢幕底部的面板,僅僅是用于裝飾."
L["Display a panel across the top of the screen. This is for cosmetic only."] = "顯示跨越螢幕頂部的面板,僅僅是用于裝飾."
L["Display battleground messages in the middle of the screen."] = "屏幕中間顯示戰場信息"
L["Display emotion icons in chat."] = "在對話中顯示表情圖示."
L["Emotion Icons"] = "表情圖示"
L["Enable + Adjust Movers"] = "啟用並移動其他框架"
L["Enable/Disable the loot frame."] = "啟用/停用拾取框架."
L["Enable/Disable the loot roll frame."] = "啟用/停用擲骰框架."
L["Enables the ElvUI Raid Control panel."] = "啟用ElvUI團隊控制台"
L["Enhanced PVP Messages"] = "PVP增強信息"
L["General"] = "一般設定"
L["Height of the objective tracker. Increase size to be able to see more objectives."] = "任務框體的高度.增加大小以看到更多目標"
L["Hide At Max Level"] = "在最高等級時隱藏"
L["Hide Error Text"] = "隱藏錯誤文字"
L["Hide In Vehicle"] = "騎乘時隱藏"
L["Hides the red error text at the top of the screen while in combat."] = "戰鬥中隱藏螢幕頂部紅字錯誤信息."
L["Log Taints"] = "錯誤記錄";
L["Login Message"] = "登入資訊"
L["Loot Roll"] = "擲骰"
L["Loot"] = "拾取"
L["Lowest Allowed UI Scale"] = "最低允許UI縮放"
L["Multi-Monitor Support"] = "多顯示器支持"
L["Name Font"] = "名稱字體"
L["Number Prefix"] = "數值縮寫"
L["Objective Frame Height"] = "任務框架高度"
L["Order Hall Command Bar"] = "職業大廳命令條"
L["Party / Raid"] = "小隊/團隊"
L["Party Only"] = "僅小隊"
L["Position of bonus quest reward frame relative to the objective tracker."] = "額外獎勵框架相對於任務框架的相對位置"
L["Raid Only"] = "僅團隊"
L["Remove Backdrop"] = "移除背景"
L["Reset all frames to their original positions."] = "重設所有框架至預設位置."
L["Reset Anchors"] = "重置位置"
L["Reverse Fill Direction"] = "翻轉填充方向"
L["Send ADDON_ACTION_BLOCKED errors to the Lua Error frame. These errors are less important in most cases and will not effect your game performance. Also a lot of these errors cannot be fixed. Please only report these errors if you notice a Defect in gameplay."] = "發送ADDON_ACTION_BLOCKED錯誤至Lua錯誤框, 這些錯誤並不重要, 不會影響你的遊戲體驗. 並且很多這類錯誤無法被修復. 請只將影響遊戲體驗的錯誤發送給我們."
L["Skin Backdrop (No Borders)"] = "美化背景(無邊界)"
L["Skin Backdrop"] = "美化背景"
L["Skin the blizzard chat bubbles."] = "美化暴雪對話泡泡."
L["Talking Head Scale"] = "特寫框體縮放"
L["The font that appears on the text above players heads. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "玩家頭頂姓名的字體. |cffFF0000警告: 你需要重新開啟遊戲或重新登錄才能使用此功能.|r"
L["The Thin Border Theme option will change the overall apperance of your UI. Using Thin Border Theme is a slight performance increase over the traditional layout."] = "細邊框主題會改變所有的外觀,使用細邊框主題會略微提升性能"
L["The unit prefixes you want to use when values are shortened in ElvUI. This is mostly used on UnitFrames."] = "在ElvUI中數值單位的縮寫. 該選項主要應用在單位框體."
L["Thin Border Theme"] = "細邊框主題"
L["Toggle Tutorials"] = "教學開關"
L["Top Panel"] = "頂部面板"
L["When you go AFK display the AFK screen."] = "當你離開時顯示AFK界面"

--Media
L["Applies the font and font size settings throughout the entire user interface. Note: Some font size settings will be skipped due to them having a smaller font size by default."] = "把該字體設置應用到所有ElvUI設置中去,但是某些設置並不會被改變."
L["Applies the primary texture to all statusbars."] = "將主要材質應用到所有狀態條"
L["Apply Font To All"] = "應用字體到所有"
L["Apply Texture To All"] = "應用材質到所有"
L["Backdrop color of transparent frames"] = "透明框架的背景顏色"
L["Backdrop Color"] = "背景顏色"
L["Backdrop Faded Color"] = "背景透明色"
L["Border Color"] = "邊框顏色"
L["Color some texts use."] = "數值(非文字)使用的顏色"
L["CombatText Font"] = "戰鬥文字字體"
L["Default Font"] = "預設字體"
L["Fonts"] = "字體"
L["Main backdrop color of the UI."] = "介面背景主色"
L["Main border color of the UI."] = "介面邊框主色"
L["Media"] = "材質"
L["Primary Texture"] = "主要材質"
L["Replace Blizzard Fonts"] = "替代暴雪字體"
L["Replaces the default Blizzard fonts on various panels and frames with the fonts chosen in the Media section of the ElvUI config. NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this. Enabled by default."] = "用ElvUI字體設置代替暴雪原有字體設置,如果禁用有可能導致你的UI出問題,默認開啟開選項."
L["Secondary Texture"] = "次要材質"
L["Set the font size for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"] = "設定介面上所有字體的尺寸, 但不包含本身有獨立設定的字體(如單位框架字體、資訊文字字體等...)"
L["Textures"] = "材質"
L["The font that combat text will use. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "戰鬥資訊將使用此字體, |​​cffFF0000警告:需重啟遊戲或重新登入才可使此變更生效.|r"
L["The font that the core of the UI will use."] = "核心UI 所使用的字體."
L["The texture that will be used mainly for statusbars."] = "此材質主用於狀態列上."
L["This texture will get used on objects like chat windows and dropdown menus."] = "主要用於對話視窗及下拉選單等物件的材質."
L["Value Color"] = "數值顏色"

--Maps
L["Adjust the size of the minimap."] = "調整小地圖尺寸."
L["Always Display"] = "總是顯示"
L["Bottom Left"] = "左下"
L["Bottom Right"] = "右下"
L["Bottom"] = "下"
L["Change settings for the display of the location text that is on the minimap."] = "改變小地圖所在位置文字的顯示設定."
L["Enable/Disable the minimap. |cffFF0000Warning: This will prevent you from seeing the minimap datatexts.|r"] = "是否啟用小地圖. |cffFF0000警告: 關掉後你將看不到小地圖周圍的資訊文字.|r"
L["Instance Difficulty"] = "副本難度"
L["Left"] = "左"
L["LFG Queue"] = "隨機隊列"
L["Location Text"] = "所在位置文字"
L["Make the world map smaller."] = "讓世界地圖更小."
L["Map Opacity When Moving"] = "移動時地圖透明度"
L["Maps"] = "地圖"
L["Minimap Buttons"] = "小地圖按鈕"
L["Minimap Mouseover"] = "小地圖滑鼠滑過"
L["Open Ticket"] = "表單"
L["Puts coordinates on the world map."] = "在世界地圖上放置坐標"
L["Reset Zoom"] = "重置縮放"
L["Right"] = "右"
L["Scale"] = "縮放"
L["Smaller World Map"] = "更小的世界地圖"
L["Top Left"] = "左上"
L["Top Right"] = "右上"
L["Top"] = "上"
L["World Map Coordinates"] = "世界地圖坐標"
L["X-Offset"] = "X偏移"
L["Y-Offset"] = "Y偏移"

--Misc
L["Filters are not allowed to have commas in their name. Stripping commas from filter name."] = true;
L["Install"] = "安裝"
L["Run the installation process."] = "執行安裝程序"
L["Toggle Anchors"] = "解鎖元件定位"
L["Unlock various elements of the UI to be repositioned."] = "解鎖介面上的各種元件, 以便更改位置."
L["Version"] = "版本"

--NamePlates
L["# Displayed Auras"] = "顯示光環的數量"
L["Actions"] = "動作"
L["Add a Name or NPC ID to the list."] = "向列表添加一個姓名或者NPC ID"
L["Add Name or NPC ID"] = "添加姓名或NPC ID"
L["Add Nameplate Filter"] = "添加姓名版過濾器"
L["Add Regular Filter"] = "添加常規過濾器"
L["Add Special Filter"] = "添加特殊過濾器"
L["Always Show Target Health"] = "始終顯示目標血量"
L["Always Show"] = "始終顯示"
L["Apply this filter if a buff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a buff has remaining time less than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time less than this. Set to zero to disable."] = true;
L["Background Glow"] = "背景發光"
L["Bad Color"] = "危險顏色"
L["Bad Scale"] = "危險縮放"
L["Bad Transition Color"] = "危險過渡顏色"
L["Base Height for the Aura Icon"] = "光環圖標基礎高度"
L["Border Glow"] = "邊框發光"
L["Border"] = "邊框"
L["Boss Auras"] = "Boss光環"
L["Cast Bar"] = "施法條"
L["Cast Color"] = "施法條顏色"
L["Cast No Interrupt Color"] = "無法打斷的顏色"
L["Cast Time Format"] = "施法時間格式"
L["Casting"] = "施法"
L["Channel Time Format"] = "通道法術時間格式"
L["Clamp nameplates to the top of the screen when outside of view."] = "當姓名板在屏幕外面時將他們緊靠在屏幕上方"
L["Clamp Nameplates"] = "緊靠姓名板"
L["Clear Filter"] = "清空過濾器"
L["Clickable Height"] = "可點擊高度"
L["Clickable Width"] = "可點擊寬度"
L["Color Tanked"] = "被坦住的顏色"
L["Control enemy nameplates toggling on or off when in combat."] = "控制戰鬥中敵對姓名板的開啟和關閉"
L["Control friendly nameplates toggling on or off when in combat."] = "控制戰鬥中友方姓名板的開啟和關閉"
L["Controls how big of an area on the screen will accept clicks to target unit."] = "決定屏幕上一個多大的光環才允許通過點擊選定到目標框體上"
L["Controls how many auras are displayed, this will also affect the size of the auras."] = "控制顯示多少光環，這也會影響光環大小"
L["Controls which nameplates will be displayed."] = "控制何種姓名板被顯示"
L["Copy settings from another unit."] = "從其他框架中複製設置"
L["Copy Settings From"] = "複製設置"
L["Current Level"] = "當前等級"
L["Default Settings"] = "默認設置"
L["Detection"] = "探測"
L["Display a healer icon over known healers inside battlegrounds or arenas."] = "戰場或競技場中，為已確認為補職的玩家標上補職圖示."
L["Display Minions"] = "顯示僕從"
L["Display Minor Units"] = "顯示僕從單位"
L["Display NPC Titles whenever healthbars arent displayed and names are."] = "無論是否顯示NPC的名字和血條都顯示NPC的頭銜"
L["Display Style"] = "顯示格式"
L["Elite Icon"] = "精英標誌"
L["Enable/Disable the scaling of targetted nameplates."] = "啟用/禁用目標姓名板的縮放"
L["Enemy Combat Toggle"] = "敵對戰鬥開關"
L["Enemy NPC Frames"] = "敵對NPC框架"
L["Enemy Player Frames"] = "敵對玩家框架"
L["Enemy"] = "敵對"
L["ENEMY_NPC"] = "敵對NPC"
L["ENEMY_PLAYER"] = "敵對玩家"
L["Filter already exists!"] = "過濾器已存在！"
L["Filter Priority"] = "過濾器優先順序"
L["Filter"] = "過濾器"
L["Filters Page"] = "過濾器介面"
L["Friendly Combat Toggle"] = "友方戰鬥開關"
L["Friendly NPC Frames"] = "友方NPC框架"
L["Friendly Player Frames"] = "友方玩家框架"
L["FRIENDLY_NPC"] = "友方NPC"
L["FRIENDLY_PLAYER"] = "友方玩家"
L["General Options"] = "常規選項"
L["Good Color"] = "正常顏色"
L["Good Scale"] = "正常縮放"
L["Good Transition Color"] = "正常過渡顏色"
L["Healer Frames"] = "補職框架"
L["Healer Icon"] = "補職圖示"
L["HEALER"] = "補"
L["Health Color"] = "血量顏色"
L["Health Threshold"] = "血量閾值"
L["Hide Delay"] = "隱藏延遲"
L["Hide Frame"] = "隱藏框架"
L["Hide Spell Name"] = "隱藏法術名字"
L["Hide Time"] = "隱藏時間"
L["Hide When Empty"] = "空白時隱藏"
L["Hide"] = "隱藏"
L["How many seconds the castbar should stay visible after the cast failed or was interrupted."] = "在施法失敗或被打斷時施法條保持可見的秒數"
L["Icon Base Height"] = "圖示基礎高度"
L["If enabled then it checks if auras are missing instead of being present on the unit."] = "如果選中則將會檢查光環是否缺失而不是光環是否存在"
L["If enabled then it will require all auras to activate the filter. Otherwise it will only require any one of the auras to activate it."] = "如果選中則要求滿足所有光環. 不啟用則只要求任一光環存在即可啟動."
L["If enabled then the filter will only activate if the level of the unit is equal to or higher than this value."] = "如果選中則過濾器僅僅在單位等級大於等於該值的時候啟動"
L["If enabled then the filter will only activate if the level of the unit is equal to or lower than this value."] = "如果選中則過濾器僅僅在單位等級小於等於該值的時候啟動"
L["If enabled then the filter will only activate if the level of the unit matches this value."] = "如果選中則過濾器僅僅在單位等級符合該值的時候啟動"
L["If enabled then the filter will only activate if the level of the unit matches your own."] = "如果選中則過濾器僅僅在單位等級符合你的等級的時候啟動"
L["If enabled then the filter will only activate if the unit is casting interruptible spells."] = "如果選中則過濾器僅僅在單位施放可打斷技能的時候啟動"
L["If enabled then the filter will only activate when the unit is in combat."] = "如果選中則過濾器僅僅在單位在戰鬥中的時候啟動"
L["If enabled then the filter will only activate when the unit is out of combat."] = "如果選中則過濾器僅僅在單位不在戰鬥中的時候啟動"
L["If enabled then the filter will only activate when you are in combat."] = "如果選中則過濾器僅僅在你在戰鬥中的時候啟動"
L["If enabled then the filter will only activate when you are out of combat."] = "如果選中則過濾器僅僅在你不在戰鬥中的時候啟動"
L["If the aura is listed with a number then you need to use that to remove it from the list."] = "如果光環和一個數一起列出你需要用它來將其移出列表"
L["If this list is empty, and if 'Interruptible' is checked, then the filter will activate on any type of cast that can be interrupted."] = "如果列表為空, 並且'可打斷'被選中, 那麼過濾器會在任何可被打斷的施法時啟動"
L["If this threshold is used then the health of the unit needs to be higher than this value in order for the filter to activate. Set to 0 to disable."] = "如果這個閾值被設置則單位的血量需要比設定值更高才會將過濾器啟動. 設為0以禁用."
L["If this threshold is used then the health of the unit needs to be lower than this value in order for the filter to activate. Set to 0 to disable."] = "如果這個閾值被設置則單位的血量需要比設定值更低才會將過濾器啟動. 設為0以禁用."
L["In Combat"] = "戰鬥中"
L["Interruptible"] = "可打斷"
L["Is Targeted"] = "目標"
L["LEVEL_BOSS"] = "Set level to -1 for boss units or set to 0 to disable.";
L["Load Distance"] = "讀取距離"
L["Low Health Threshold"] = "低生命值閾值"
L["Lower numbers mean a higher priority. Filters are processed in order from 1 to 100."] = "更低的數值意味著更高的優先順序. 過濾器將按照1至100的順序進行."
L["Make the unitframe glow yellow when it is below this percent of health, it will glow red when the health value is half of this value."] = "姓名板在此設定值下會變黃色, 在設定值一半以下會變紅色"
L["Match Player Level"] = "符合玩家等級"
L["Maximum Level"] = "最高等級"
L["Maximum Time Left"] = true;
L["Minimum Level"] = "最低等級"
L["Minimum Time Left"] = true;
L["Missing"] = "缺失"
L["Name Color"] = "姓名顏色"
L["NamePlates"] = "姓名板(血條)"
L["Non-Target Transparency"] = "非目標透明度"
L["Not Targeted"] = "非目標"
L["Only load nameplates for units within this range."] = "僅僅讀取在此範圍內的姓名板"
L["Only Show Target"] = "僅顯示目標"
L["Out Of Combat"] = "戰鬥外"
L["Over Health Threshold"] = "高於血量閾值"
L["Personal Auras"] = "個人光環"
L["Player in Combat"] = "玩家戰鬥中"
L["Player Nameplate"] = "玩家姓名板"
L["Player Out of Combat"] = "玩家戰鬥外"
L["PLAYER"] = "玩家"
L["Reaction Colors"] = "聲望顏色"
L["Reaction Type"] = "聲望類型"
L["Remove a Name or NPC ID from the list."] = "從列表中移除姓名或NPC ID"
L["Remove Buff"] = "移除增益"
L["Remove Debuff"] = "移除減益"
L["Remove Name or NPC ID"] = "移除姓名或NPC ID"
L["Remove Name"] = "刪除篩選名"
L["Remove Nameplate Filter"] = "移除姓名版過濾器"
L["Require All"] = "要求全部"
L["Require of the selected auras."] = "要求選擇的光環"
L["Reset filter priority to the default state."] = "重置過濾器優先順序到預設狀態"
L["Reset Priority"] = "重置優先順序"
L["Return filter to its default state."] = "返回過濾器至預設狀態"
L["Scale of the nameplate that is targetted."] = "縮放選定目標的姓名板"
L["Select Nameplate Filter"] = "選擇姓名版過濾器"
L["Set Settings to Default"] = "恢復默認設置"
L["Set the transparency level of nameplates that are not the target nameplate."] = "設定未被選中目標的姓名板的透明度"
L["Set to either stack nameplates vertically or allow them to overlap."] = "設置將姓名板垂直排列或者允許重疊"
L["Shortcut to 'Filters' section of the config."] = "一個到'過濾器'功能表的快速鍵"
L["Shortcuts"] = "快速鍵"
L["Show In Combat"] = "戰鬥中顯示"
L["Show NPC Titles"] = "顯示NPC頭銜"
L["Show With Target"] = "有目標時顯示"
L["Side Arrows"] = "側面箭頭"
L["Style Filter"] = "樣式過濾器"
L["Suramar Detection"] = "蘇拉瑪衛兵探測"
L["Tagged NPC"] = "標記的NPC"
L["Tanked Color"] = "坦克顏色"
L["Target Glow Color"] = "目標高亮顏色"
L["Target Indicator"] = "目標指示器"
L["Target Scale"] = "目標縮放"
L["Target, Quest, Combat"] = "目標、任務、戰鬥"
L["Targeted Nameplate"] = "目標姓名板"
L["Texture"] = "材質"
L["These filters don't use a list of spells like the regular filters. Instead they use the WoW API and some code logic to determine if an aura should be allowed or blocked."] = "這些過濾器不像常規過濾器那樣使用一個法術列表, 而是使用魔獸API和部分代碼邏輯來決定光環顯示與否."
L["These filters use a list of spells to determine if an aura should be allowed or blocked. The content of these filters can be modified in the 'Filters' section of the config."] = "這些過濾器使用一個法術清單來決定光環顯示與否. 這些過濾器的內容可以在設置中的'過濾器'選項中更改."
L["Threat"] = "仇恨"
L["Time To Hold"] = "停留時間"
L["Toggle Off While In Combat"] = "戰鬥時關閉"
L["Toggle On While In Combat"] = "戰鬥時啟用"
L["Top Arrow"] = "頂部箭頭"
L["Triggers"] = "觸發器"
L["Under Health Threshold"] = "低於血量閾值"
L["Unit in Combat"] = "單位戰鬥中"
L["Unit Out of Combat"] = "單位戰鬥外"
L["Unit Type"] = "單位類型"
L["Use Class Color"] = "使用職業顏色"
L["Use drag and drop to rearrange filter priority or right click to remove a filter."] = "使用拖拽的方式調整過濾器優先順序, 或者右鍵移除一個過濾器"
L["Use Portrait"] = "使用頭像"
L["Use Static Position"] = "固定位置"
L["Use Tanked Color when a nameplate is being effectively tanked by another tank."] = "當另一個坦克更有效的坦住時姓名板使用被坦住的顏色"
L["Use Target Glow"] = "目標外框高亮"
L["Use Target Scale"] = "使用目標縮放"
L["Use Threat Color"] = "使用仇恨顏色"
L["When enabled the nameplate will stay visible in a locked position."] = "啟用後姓名板將在鎖定的位置持續可見"
L["You can't remove a default name from the filter, disabling the name."] = "你不能從過濾器中移除一個默認名字. 已禁用."

--Profiles Export/Import
L["Aura Filters"] = "光環過濾器"
L["Choose Export Format"] = "選擇導出格式"
L["Choose What To Export"] = "選擇導出內容"
L["Decode Text"] = "解碼文字"
L["Error decoding data. Import string may be corrupted!"] = "解碼錯誤.導出字符串可能已損壞！"
L["Error exporting profile!"] = "導出配置文件失敗"
L["Export Now"] = "現在導出"
L["Export Profile"] = "導出配置文件"
L["Exported"] = "已導出"
L["Filters (All)"] = "過濾器(全部)"
L["Filters (NamePlates)"] = "過濾器(姓名板)"
L["Filters (UnitFrames)"] = "過濾器(框架)"
L["Global (Account Settings)"] = "全域(賬號設置)"
L["Import Now"] = "現在導入"
L["Import Profile"] = "導入配置文件"
L["Importing"] = "正在導入"
L["NamePlate Style Filters"] = "姓名版樣式過濾器"
L["Plugin"] = "插件"
L["Private (Character Settings)"] = "個人(角色配置)"
L["Profile imported successfully!"] = "配置文件導入成功"
L["Profile Name"] = "配置文件名稱"
L["Profile"] = "配置文件"
L["Table"] = "表"

--Skins
L["Achievement Frame"] = "成就"
L["AddOn Manager"] = "插件管理"
L["Alert Frames"] = "警報"
L["Archaeology Frame"] = "考古學框架"
L["Auction Frame"] = "拍賣"
L["Barbershop Frame"] = "美容院"
L["BG Map"] = "戰場地圖"
L["BG Score"] = "戰場積分"
L["Black Market AH"] = "黑市"
L["Calendar Frame"] = "行事曆"
L["Character Frame"] = "角色"
L["Contribution"] = "捐獻"
L["Death Recap"] = "死亡回放"
L["Debug Tools"] = "除錯工具"
L["Gossip Frame"] = "對話"
L["Guild Control Frame"] = "公會控制"
L["Guild Frame"] = "公會"
L["Guild Registrar"] = "公會註冊"
L["Help Frame"] = "幫助"
L["Inspect Frame"] = "觀察"
L["Item Upgrade"] = "裝備升級"
L["KeyBinding Frame"] = "快捷鍵"
L["LF Guild Frame"] = "尋求公會"
L["LFG Frame"] = "地下城"
L["Loot Frames"] = "拾取框架"
L["Loss Control"] = "失去控制"
L["Macro Frame"] = "巨集"
L["Mail Frame"] = "信箱"
L["Merchant Frame"] = "商人"
L["Mirror Timers"] = "鏡像計時器"
L["Misc Frames"] = "其他"
L["Non-Raid Frame"] = "非團隊框架"
L["Orderhall"] = "職業大廳"
L["Pet Battle"] = "寵物戰鬥"
L["Petition Frame"] = "回報GM"
L["PvP Frames"] = "PvP框架"
L["Quest Choice"] = "任務選擇"
L["Quest Frames"] = "任務"
L["Raid Frame"] = "團隊框架"
L["Skins"] = "美化外觀"
L["Socket Frame"] = "珠寶插槽"
L["Spellbook"] = "技能書"
L["Stable"] = "獸欄"
L["Tabard Frame"] = "外袍"
L["Talent Frame"] = "天賦"
L["TalkingHead"] = "特寫框體"
L["Taxi Frame"] = "載具"
L["Time Manager"] = "時間管理"
L["Trade Frame"] = "交易"
L["TradeSkill Frame"] = "專業技能"
L["Trainer Frame"] = "訓練師"
L["Transmogrify Frame"] = "塑型"

--Tooltip
L["Always Hide"] = "總是隱藏"
L["Bags Only"] = "僅背包"
L["Bags/Bank"] = "背包/銀行"
L["Bank Only"] = "僅銀行"
L["Both"] = "兩者"
L["Choose when you want the tooltip to show. If a modifer is chosen, then you need to hold that down to show the tooltip."] = "選擇何時顯示提示.如果選擇了設置鍵，你需要按住它來顯示提示"
L["Comparison Font Size"] = "比較字體大小"
L["Cursor Anchor"] = "指針錨點"
L["Custom Faction Colors"] = "自定義聲望顏色"
L["Display guild ranks if a unit is guilded."] = "當目標有公會時顯示其位階."
L["Display how many of a certain item you have in your possession."] = "顯示當前物品在你身上的數量"
L["Display player titles."] = "顯示玩家稱號."
L["Display the players talent spec and item level in the tooltip, this may not immediately update when mousing over a unit."] = "當按住shift時展示該玩家的專精和裝等,由於需要讀取所以不會在指向某玩家時立即更新."
L["Display the spell or item ID when mousing over a spell or item tooltip."] = "滑鼠提示中顯示技能或物品的ID"
L["Guild Ranks"] = "公會會階"
L["Header Font Size"] = "標題名字大小"
L["Health Bar"] = "生命條"
L["Hide tooltip while in combat."] = "戰鬥時不顯示提示."
L["Inspect Info"] = "更多信息"
L["Item Count"] = "物品數量"
L["Never Hide"] = "從不隱藏"
L["Player Titles"] = "玩家稱號"
L["Should tooltip be anchored to mouse cursor"] = "提示錨定在滑鼠"
L["Spell/Item IDs"] = "技能/物品ID"
L["Target Info"] = "目標信息"
L["Text Font Size"] = "字體大小"
L["This setting controls the size of text in item comparison tooltips."] = "設置對比框中的文字大小"
L["Tooltip Font Settings"] = "提示文字設置"
L["When in a raid group display if anyone in your raid is targeting the current tooltip unit."] = "顯示團隊中目標與你目前浮動提示目標相同的隊友."

--UnitFrames
L["%s and then %s"] = "%s 與 %s"
L["2D"] = "2D"
L["3D"] = "3D"
L["Above"] = "向上"
L["Absorbs"] = "吸收"
L["Add a spell to the filter. Use spell ID if you don't want to match all auras which share the same name."] = "添加一個技能到過濾器.使用法術ID以避免匹配到同名的光環"
L["Add a spell to the filter."] = "添加一個技能到過濾器"
L["Add Spell ID or Name"] = "添加技能ID或者名字"
L["Add SpellID"] = "添加技能ID"
L["Additional Filter Override"] = "額外過濾器覆蓋"
L["Additional Filter"] = "額外的過濾器"
L["Additional Power Text"] = "額外能量文字"
L["Allow auras considered to be part of a boss encounter."] = "允許被認為是首領戰鬥中的光環"
L["Allow Boss Encounter Auras"] = "允許首領戰鬥中的光環"
L["Allow non-personal auras from additional filter when 'Block Non-Personal Auras' is enabled."] = "當'不顯示非個人光環'開啟時允許來自額外過濾器的非個人光環"
L["Allow Whitelisted Auras"] = "允許白名單中的光環"
L["An X offset (in pixels) to be used when anchoring new frames."] = "錨定新框架時的X偏移(單位:像素)"
L["An Y offset (in pixels) to be used when anchoring new frames."] = "錨定新框架時的Y偏移(單位:像素)"
L["Anticipation"] = "預感"
L["Ascending or Descending order."] = "升序或降序"
L["Assist Frames"] = "助理框架"
L["Assist Target"] = "助理目標"
L["At what point should the text be displayed. Set to -1 to disable."] = "在何時顯示文本. 設定為-1 禁用此功能."
L["Attach Text To"] = "文字附著於"
L["Attach To"] = "附加到"
L["Aura Bars"] = "光環條"
L["Auto-Hide"] = "自動隱藏"
L["Bad"] = "危險"
L["Bars will transition smoothly."] = "狀態條平滑增減"
L["Below"] = "向下"
L["Blacklist Modifier"] = "黑名單功能鍵"
L["Blacklist"] = "黑名單"
L["Block Auras Without Duration"] = "不顯示沒有持續時間的光環"
L["Block Blacklisted Auras"] = "不顯示黑名單中的光環"
L["Block Non-Dispellable Auras"] = "顯示可以驅散的光環"
L["Block Non-Personal Auras"] = "顯示個人光環"
L["Borders"] = "邊框"
L["Buff Indicator"] = "Buff 提示器"
L["Buffs"] = "增益光環"
L["By Type"] = "類型"
L["Camera Distance Scale"] = "視角鏡頭的距離"
L["Castbar"] = "施法條"
L["Center"] = "置中"
L["Check if you are in range to cast spells on this specific unit."] = "檢查你是否在技能有效範圍內."
L["Choose UIPARENT to prevent it from hiding with the unitframe."] = "使用UIPARENT來防止它隨框體隱藏"
L["Class Backdrop"] = "生命條背景職業色"
L["Class Castbars"] = "施法條職業色"
L["Class Color Override"] = "職業色覆蓋"
L["Class Health"] = "生命條職業色"
L["Class Power"] = "能量條職業色"
L["Class Resources"] = "職業能量"
L["Click Through"] = "點擊穿透";
L["Color all buffs that reduce the unit's incoming damage."] = "減少目標受到的傷害的所有 Buff 的顏色."
L["Color aurabar debuffs by type."] = "按類型顯示光環條顔色."
L["Color castbars by the class of player units."] = "按職業顯示施法條顏色"
L["Color castbars by the reaction type of non-player units."] = "按非玩家單位的聲望顯示施法條顏色"
L["Color health by amount remaining."] = "按數值變化血量顏色."
L["Color health by classcolor or reaction."] = "以職業色顯示生命."
L["Color power by classcolor or reaction."] = "以職業色顯示能量."
L["Color the health backdrop by class or reaction."] = "生命條背景色以職業色顯示."
L["Color the unit healthbar if there is a debuff that can be dispelled by you."] = "如果單位目標的減益光環可被驅散, 加亮顯示其生命值."
L["Color Turtle Buffs"] = "減傷類 Buff 的顏色"
L["Colored Icon"] = "圖示色彩"
L["Coloring (Specific)"] = "著色（具體）"
L["Coloring"] = "著色"
L["Combat Fade"] = "戰鬥隱藏"
L["Combat Icon"] = "戰鬥按鈕"
L["Combo Point"] = "連擊點"
L["Configure Auras"] = "設置光環"
L["Copy From"] = "複製自"
L["Count Font Size"] = "計數字體尺寸"
L["Create a custom fontstring. Once you enter a name you will be able to select it from the elements dropdown list."] = "輸入一個名稱創建自定義字體樣式之後, 你可以在組件的下拉菜單中選擇使用."
L["Create a filter, once created a filter can be set inside the buffs/debuffs section of each unit."] = "創造一個過濾器, 一旦創造, 每個單位的buff/debuff 都能使用."
L["Create Filter"] = "創造過濾器"
L["Current - Max | Percent"] = "目前值- 最大值| 百分比"
L["Current - Max"] = "目前值 - 最大值"
L["Current - Percent"] = "目前值 - 百分比"
L["Current / Max"] = "目前/最大值"
L["Current"] = "目前值"
L["Custom Dead Backdrop"] = "自定義死亡背景"
L["Custom Health Backdrop"] = "自訂生命條背景"
L["Custom Texts"] = "自定義字體"
L["Debuff Highlighting"] = "減益光環加亮顯示"
L["Debuffs"] = "減益光環"
L["Decimal Threshold"] = "小數閾值"
L["Deficit"] = "虧損值"
L["Delete a created filter, you cannot delete pre-existing filters, only custom ones."] = "刪除一個創造的過濾器, 你不能刪除內建的過濾器, 只能刪除你自已添加的."
L["Delete Filter"] = "刪除過濾器"
L["Detach From Frame"] = "從框架分離"
L["Detached Width"] = "分離寬度"
L["Direction the health bar moves when gaining/losing health."] = "生命條的增減方向."
L["Disable Debuff Highlight"] = "禁用debuff高亮"
L["Disabled Blizzard Frames"] = "禁用暴雪框架"
L["Disables the focus and target of focus unitframes."] = "禁用焦點和目標的焦點框架"
L["Disables the player and pet unitframes."] = "禁用玩家和寵物框架"
L["Disables the target and target of target unitframes."] = "禁用目標和目標的目標框架"
L["Disconnected"] = "離線"
L["Display a spark texture at the end of the castbar statusbar to help show the differance between castbar and backdrop."] = "在施法狀態條的末端顯示一個火花材質來區分施法條和背景條."
L["Display Frames"] = "顯示框架"
L["Display icon on arena frame indicating the units talent specialization or the units faction if inside a battleground."] = "當處於競技場或戰場內, 在框架上顯示天賦圖示"
L["Display Player"] = "顯示玩家"
L["Display Target"] = "顯示目標"
L["Display Text"] = "顯示文本"
L["Display the castbar icon inside the castbar."] = "在施法條內顯示圖標"
L["Display the castbar inside the information panel, the icon will be displayed outside the main unitframe."] = "如果關閉施法條內顯示圖標,你可以自定義施法條外圖標的大小和位置"
L["Display the combat icon on the unitframe."] = "在單位框架內顯示戰鬥圖標"
L["Display the rested icon on the unitframe."] = "在單位框架上顯示充分休息圖示."
L["Display the target of your current cast. Useful for mouseover casts."] = "顯示你當前的施法目標. 可以轉換成鼠标滑過類型."
L["Display tick marks on the castbar for channelled spells. This will adjust automatically for spells like Drain Soul and add additional ticks based on haste."] = "若為需引導的法術, 在施法條上顯示每跳週期傷害. 啟動此功能後, 針對吸取靈魂這類的法術, 將自動調整顯示每跳週期傷害, 並視加速等級增加額外的周期傷害."
L["Don't display any auras found on the 'Blacklist' filter."] = "不顯示任何'黑名單'過濾器中的光環."
L["Don't display auras that are longer than this duration (in seconds). Set to zero to disable."] = "不顯示高於此時間(單位:秒)的光環.設置為0以禁用"
L["Don't display auras that are not yours."] = "不顯示不是你施放的光環."
L["Don't display auras that are shorter than this duration (in seconds). Set to zero to disable."] = true;
L["Don't display auras that cannot be purged or dispelled by your class."] = "不顯示你不能驅散的光環."
L["Don't display auras that have no duration."] = "不限時沒有持續時間的光環."
L["Down"] = "下"
L["Duration Reverse"] = "持續時間反轉"
L["Duration Text"] = "持續時間文字"
L["Duration"] = "持續時間"
L["Enabling this allows raid-wide sorting however you will not be able to distinguish between groups."] = "啟用後將可以在整個團隊內排序，但你不再可以區分不同小隊"
L["Enabling this inverts the grouping order when the raid is not full, this will reverse the direction it starts from."] = "啟用後翻轉未滿團隊的隊伍順序(起始方向)"
L["Enemy Aura Type"] = "敵對光環類型"
L["Fade the unitframe when out of combat, not casting, no target exists."] = "非戰鬥/施法/目標不存在時隱藏單位框架"
L["Fill"] = "填充"
L["Filled"] = "全長"
L["Filter Type"] = "過濾器類型"
L["Fluid Position Buffs on Debuffs"] = "增益流動定位在減益上"
L["Fluid Position Debuffs on Buffs"] = "減益流動定位在增益上"
L["Force Off"] = "強制關閉"
L["Force On"] = "強制開啓"
L["Force Reaction Color"] = "強制聲望顏色"
L["Force the frames to show, they will act as if they are the player frame."] = "強制框架顯示."
L["Forces Debuff Highlight to be disabled for these frames"] = "為這些框架強制禁用debuff高亮"
L["Forces reaction color instead of class color on units controlled by players."] = "對於玩家控制的角色強制使用聲望顏色而不是職業顏色"
L["Format"] = "格式"
L["Frame Level"] = "框架層次"
L["Frame Orientation"] = "框架方向"
L["Frame Strata"] = "框架層級"
L["Frame"] = "框架"
L["Frequent Updates"] = "立即更新生命值"
L["Friendly Aura Type"] = "友好目標光環類型"
L["Friendly"] = "友好"
L["Glow"] = "閃爍"
L["Good"] = "安全"
L["Group By"] = "隊伍排列方式"
L["Grouping & Sorting"] = "分組與排序"
L["Groups Per Row/Column"] = "每行/列的組數"
L["Growth direction from the first unitframe."] = "增長方向從第一個頭像框架開始."
L["Growth Direction"] = "增長方向"
L["Heal Absorbs"] = "治療吸收盾"
L["Heal Prediction"] = "治療量預測"
L["Health Backdrop"] = "生命條背景"
L["Health Border"] = "生命條邊框"
L["Health By Value"] = "生命條顏色依數值變化"
L["Health"] = "生命條"
L["Height"] = "高"
L["Horizontal Spacing"] = "水平間隔"
L["Horizontal"] = "水平"
L["How far away the portrait is from the camera."] = "人像和鏡頭間有多遠"
L["Icon Inside Castbar"] = "施法條內的圖標"
L["Icon Size"] = "圖標尺寸"
L["Icon"] = "圖示"
L["Icon: BOTTOM"] = "圖示: 底部"
L["Icon: BOTTOMLEFT"] = "圖示: 底部左側"
L["Icon: BOTTOMRIGHT"] = "圖示: 底部右側"
L["Icon: LEFT"] = "圖示: 左側"
L["Icon: RIGHT"] = "圖示: 右側"
L["Icon: TOP"] = "圖示: 頂部"
L["Icon: TOPLEFT"] = "圖示: 頂部左側"
L["Icon: TOPRIGHT"] = "圖示: 頂部右側"
L["If no other filter options are being used then it will block anything not on the 'Whitelist' filter, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = "若沒有啓用其他過濾器，那只會顯示'白名單'裡面的光環."
L["If not set to 0 then override the size of the aura icon to this."] = "若設為 0，光環圖示大小將不會變更為此值."
L["If the unit is an enemy to you."] = "如果是你的敵對目標"
L["If the unit is friendly to you."] = "如果是你的友好目標"
L["If you have a lot of 3D Portraits active then it will likely have a big impact on your FPS. Disable some portraits if you experience FPS issues."] = "如果你同時激活了很多3D頭像你很可能有FPS的影響.如果你有這方面的問題請禁用一部分頭像"
L["Ignore mouse events."] = "忽略滑鼠事件.";
L["InfoPanel Border"] = "信息面板邊框"
L["Information Panel"] = "信息面板"
L["Inset"] = "插入"
L["Inside Information Panel"] = "插入信息面板"
L["Interruptable"] = "可斷法的施法顏色"
L["Invert Grouping Order"] = "反轉隊伍排序"
L["JustifyH"] = '橫向字體對齊';
L["Latency"] = "延遲"
L["Left to Right"] = "左到右"
L["Main statusbar texture."] = "主狀態條材質"
L["Main Tanks / Main Assist"] = "主坦克 / 主助理"
L["Make textures transparent."] = "材質透明"
L["Match Frame Width"] = "匹配視窗寬度"
L["Max amount of overflow allowed to extend past the end of the health bar."] = "顯示在生命值條末端的治療吸收盾的最大量"
L["Max Bars"] = "最多"
L["Max Overflow"] = "最大治療吸收盾"
L["Maximum Duration"] = "最大持續時間"
L["Method to sort by."] = "排序方式"
L["Middle Click - Set Focus"] = "滑鼠中鍵 - 設置焦點"
L["Middle clicking the unit frame will cause your focus to match the unit."] = "滑鼠中鍵點擊單位框架設置焦點."
L["Middle"] = "中間"
L["Minimum Duration"] = "最低持續時間"
L["Model Rotation"] = "模型旋轉"
L["Mouseover"] = "滑鼠滑過顯示"
L["Name"] = "姓名"
L["Neutral"] = "中立"
L["Non-Interruptable"] = "不可斷法的施法條色"
L["Not valid spell id"] = "無效的技能ID"
L["Num Rows"] = "行數"
L["Number of Groups"] = "每隊單位數量"
L["Offset of the powerbar to the healthbar, set to 0 to disable."] = "偏移能量條與生命條的位置, 設定為0 禁用此功能."
L["Offset position for text."] = "偏移文本的位置."
L["Offset"] = "偏移"
L["OOR Alpha"] = "超出距離透明度"
L["Others"] = "他人的"
L["Overlay the healthbar"] = "頭像重疊顯示於生命條上"
L["Overlay"] = "重疊顯示"
L["Override any custom visibility setting in certain situations, EX: Only show groups 1 and 2 inside a 10 man instance."] = "複寫可見性的設定, 例如: 在10人副本里只顯示1隊和2隊."
L["Override the default class color setting."] = "覆蓋默認職業色設置."
L["Owners Name"] = "所有者姓名"
L["Parent"] = "跟隨框架"
L["Party Pets"] = "隊伍寵物"
L["Party Targets"] = "隊伍目標"
L["Per Row"] = "每行"
L["Percent"] = "百分比"
L["Personal"] = "個人的"
L["Pet Name"] = "寵物名字"
L["Player Frame Aura Bars"] = "玩家框架光環條"
L["Portrait"] = "頭像"
L["Position Buffs on Debuffs"] = "增益在減益上"
L["Position Debuffs on Buffs"] = "減益在減益上"
L["Position the Model horizontally."] = "水平放置模型"
L["Position the Model vertically."] = "垂直放置模型"
L["Position"] = "位置"
L["Power text will be hidden on NPC targets, in addition the name text will be repositioned to the power texts anchor point."] = "NPC 目標將隱藏能量值文字."
L["Power"] = "能量"
L["Powers"] = "能量"
L["Priority"] = "優先級"
L["Profile Specific"] = "角色專用"
L["PvP & Prestige Icon"] = "PvP和威望圖標"
L["PvP Text"] = "PvP文字"
L["PVP Trinket"] = "PVP 飾品"
L["Raid Icon"] = "團隊圖示"
L["Raid-Wide Sorting"] = "全團隊排序"
L["Raid40 Frames"] = "40人團隊框架"
L["RaidDebuff Indicator"] = "團隊副本減益光環標示"
L["Range Check"] = "距離檢查"
L["Rapidly update the health, uses more memory and cpu. Only recommended for healing."] = "實時更新生命值會佔用更多的內存的和CPU, 只推薦治療角色開啟."
L["Reaction Castbars"] = "聲望施法條"
L["Reactions"] = "陣營聲望"
L["Ready Check Icon"] = true;
L["Remaining"] = "剩餘數值"
L["Remove a spell from the filter. Use the spell ID if you see the ID as part of the spell name in the filter."] = "從過濾器中移除一個技能. 當你看見有ID在過濾器中的技能名字時使用技能ID"
L["Remove a spell from the filter."] = "從過濾器中移除一個技能."
L["Remove Spell ID or Name"] = "移除技能ID或者名稱"
L["Remove SpellID"] = "移除技能ID"
L["Rest Icon"] = "充分休息圖示"
L["Restore Defaults"] = "恢復預設"
L["Right to Left"] = "右到左"
L["RL / ML Icons"] = "團隊隊長/裝備分配圖示"
L["Role Icon"] = "角色定位圖示"
L["Seconds remaining on the aura duration before the bar starts moving. Set to 0 to disable."] = true
L["Select a unit to copy settings from."] = "選擇從哪單位複制."
L["Select an additional filter to use. If the selected filter is a whitelist and no other filters are being used (with the exception of Block Non-Personal Auras) then it will block anything not on the whitelist, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = "請選擇一個過濾器, 若你啓用的是'白名單', 則只顯示'白名單'裡的光環."
L["Select Filter"] = "選擇過濾器"
L["Select Spell"] = "選擇技能"
L["Select the display method of the portrait."] = "選擇頭像的顯示方式"
L["Set the filter type. Blacklist will hide any auras in the list and show all others. Whitelist will show any auras in the filter and hide all others."] = "設置過濾器類型. 黑名單將隱藏列表內的任何光環而顯示其他. 白名單將顯示過濾器內的任何光環而隱藏其他所有光環."
L["Set the font size for unitframes."] = "設定單位框架字體尺寸."
L["Set the order that the group will sort."] = "設定組排序的順序."
L["Set the orientation of the UnitFrame."] = "設置框架的方向"
L["Set the priority order of the spell, please note that prioritys are only used for the raid debuff module, not the standard buff/debuff module. If you want to disable set to zero."] = "設定該法術的優先順序. 請注意, 優先級只用於Raid Debuff模塊, 而不是標準的Buff/Debuff模塊. 設定為0 禁用此功能."
L["Set the type of auras to show when a unit is a foe."] = "當單位是敵對時設定光環顯示的類型."
L["Set the type of auras to show when a unit is friendly."] = "當單位是友好時設定光環顯示的類型."
L["Sets the font instance's horizontal text alignment style."] = "設定橫向字體的對齊方式."
L["Show a incomming heal prediction bar on the unitframe. Also display a slightly different colored bar for incoming overheals."] = "在單位框架中顯示即將回复的的預測治療量, 過量治療則以不同顏色顯示. "
L["Show Aura From Other Players"] = "顯示其他玩家的光環"
L["Show Auras"] = "顯示光環"
L["Show Dispellable Debuffs"] = "顯示無法驅散的debuff"
L["Show For DPS"] = "為輸出顯示"
L["Show For Healers"] = "為治療顯示"
L["Show For Tanks"] = "為坦克顯示"
L["Show When Not Active"] = "顯示當前無效的光環"
L["Size and Positions"] = "大小和位置"
L["Size of the indicator icon."] = "提示圖示尺寸"
L["Size Override"] = "尺寸覆蓋"
L["Size"] = "尺寸"
L["Smart Aura Position"] = "智能光環位置"
L["Smart Raid Filter"] = "智能團隊過濾"
L["Smooth Bars"] = "平滑化"
L["Sort By"] = "排序"
L["Spaced"] = "留空"
L["Spacing"] = "間隙"
L["Spark"] = "火花"
L["Spec Icon"] = "天賦圖示"
L["Stack Counter"] = "層數計數"
L["Stack Threshold"] = "層數閾值"
L["Start Near Center"] = "由中心開始"
L["Statusbar Fill Orientation"] = "狀態條填充方向"
L["StatusBar Texture"] = "狀態條材質"
L["Strata and Level"] = "框架層級和層次"
L["Style"] = "風格"
L["Tank Frames"] = "坦克框架"
L["Tank Target"] = "坦克目標"
L["Tapped"] = "被攻擊"
L["Target Glow"] = "選中高亮"
L["Target On Mouse-Down"] = "滑鼠按下設為目標"
L["Target units on mouse down rather than mouse up. \n\n|cffFF0000Warning: If you are using the addon 'Clique' you may have to adjust your clique settings when changing this."] = "按下滑鼠時設為目標,而不是鬆開滑鼠按鍵時. \n\n|cffFF0000警告: 如果使用'Clique'等點擊施法插件, 你可能需要調整這些插件的設置."
L["Text Color"] = "文字顔色"
L["Text Format"] = "文字格式"
L["Text Position"] = "文字位置"
L["Text Threshold"] = "文本閥值"
L["Text Toggle On NPC"] = "NPC 文字顯示開關"
L["Text xOffset"] = "文字X軸偏移"
L["Text yOffset"] = "文字Y軸偏移"
L["Text"] = "文本"
L["Textured Icon"] = "圖示紋理"
L["The alpha to set units that are out of range to."] = "單位框架超出距離的透明度."
L["The debuff needs to reach this amount of stacks before it is shown. Set to 0 to always show the debuff."] = "減益需要達到這個數量的層數才會顯示. 設為0來一直顯示它."
L["The following macro must be true in order for the group to be shown, in addition to any filter that may already be set."] = "為了顯示設定過的過濾器下面的巨集必須啟用."
L["The font that the unitframes will use."] = "單位框架字體."
L["The initial group will start near the center and grow out."] = "最初的隊伍由中心開始增長."
L["The name you have selected is already in use by another element."] = "你所選的名稱已經被另一組件佔用."
L["The object you want to attach to."] = "你想依附的目標."
L["Thin Borders"] = "細邊框"
L["This dictates the size of the icon when it is not attached to the castbar."] = "指定未吸附在施法條內時圖示的尺寸"
L["This opens the UnitFrames Color settings. These settings affect all unitframes."] = "這將開啟單位框體顏色設置.這些設置會影響所有單位框體"
L["Threat Display Mode"] = "仇恨顯示模式"
L["Threshold before text goes into decimal form. Set to -1 to disable decimals."] = "文字變為小數時的閾值.設為-1以禁用小數"
L["Ticks"] = "週期傷害"
L["Time Remaining Reverse"] = "剩餘時間反轉"
L["Time Remaining"] = "剩餘時間"
L["Transparent"] = "透明"
L["Turtle Color"] = "減傷類的顏色"
L["Uniform Threshold"] = "統一閾值"
L["UnitFrames"] = "單位框架"
L["Up"] = "上"
L["Use Custom Level"] = "使用自訂層次"
L["Use Custom Strata"] = "使用自訂層級"
L["Use Dead Backdrop"] = "死亡背景"
L["Use Default"] = "自定義默認值"
L["Use the custom health backdrop color instead of a multiple of the main health color."] = "自定義生命條背景色."
L["Use the profile specific filter 'Buff Indicator (Profile)' instead of the global filter 'Buff Indicator'."] = "使用配置文件內的增益指示器而不是全域的"
L["Use thin borders on certain unitframe elements."] = "使用細邊框"
L["Use this backdrop color for units that are dead or ghosts."] = "死亡或靈魂狀態背景"
L["Value must be a number"] = "數值必須為一個數字"
L["Vertical Orientation"] = "垂直方向"
L["Vertical Spacing"] = "垂直間隔"
L["Vertical"] = "垂直"
L["Visibility"] = "可見性"
L["What point to anchor to the frame you set to attach to."] = "增益光環框架於其依附框架的依附位置."
L["What to attach the buff anchor frame to."] = "Buff 定位附加到的框架."
L["What to attach the debuff anchor frame to."] = "Debuff 定位附加到的框架."
L["When true, the header includes the player when not in a raid."] = "若啟用, 隊伍中將顯示玩家."
L["Whitelist"] = "白名單"
L["Width"] = "寬"
L["Will show Buffs in the Debuff position when there are no Debuffs active, or vice versa."] = "如果沒有debuff則把buff顯示在debuff位置"
L["xOffset"] = "X軸偏移"
L["yOffset"] = "Y軸偏移"
L["You can't remove a pre-existing filter."] = "你不能刪除一個內建的過濾器"
L["You cannot copy settings from the same unit."] = "你不能從相同的單位複制設定"
L["You may not remove a spell from a default filter that is not customly added. Setting spell to false instead."] = "你不能移除一個內建技能, 僅能停用此技能."
L["You need to hold this modifier down in order to blacklist an aura by right-clicking the icon. Set to None to disable the blacklist functionality."] = "按住設置按鍵+右鍵單擊會把該玩家加入黑名單, 設為無以關閉該功能"
