-- Russian localization file for ruRU.
local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("ElvUI", "ruRU")
if not L then return; end

-- *_DESC locales
L["AURAS_DESC"] = "Настройка иконок эффектов, находящихся у миникарты."
L["BAGS_DESC"] = "Настройки сумок ElvUI"
L["CHAT_DESC"] = "Настройте отображение чата ElvUI."
L["DATATEXT_DESC"] = "Установка отображения информационных текстов."
L["ELVUI_DESC"] = "ElvUI это аддон для полной замены пользовательского интерфейса World of Warcraft."
L["NAMEPLATE_DESC"] = "Настройки индикаторов здоровья."
L["UNITFRAME_DESC"] = "Modify the unitframe settings."
L["ACTIONBARS_DESC"] = "Modify the actionbar settings."
L["PANEL_DESC"] = "Регулирование размеров левой и правой панелей. Это окажет эффект на чат и сумки."
L["SKINS_DESC"] = "Установки скинов"
L["TOGGLESKIN_DESC"] = "Включить/выключить этот скин."
L["TOOLTIP_DESC"] = "Опций подсказки"
L["SEARCH_SYNTAX_DESC"] = [=[С добавлением библиотеки LibItemSearch, у вас появился доступ к большему количеству поисковых запросов. Здесь представлена документация по синтаксису поисковых запросов. Полная инструкция доступна по адресу: https://github.com/Jaliborc/LibItemSearch-1.2/wiki/Search-Syntax.

Специфический поик:
    • q:[качество] или quality:[качество]. Например, q:эпическое покажет все предметы эпического качества (слово "эпическое" не обязательно вводить до конца).
    • l:[уровень], lvl:[уровень] or level:[уровень]. Например, l:30 покажет все предметы с уровнем 30. Это относитя именно к уровню предметов, а не требуемому уровню персонажа.
    • t:[запрос], type:[запрос] or slot:[запрос]. Например, t:оружие покажет все предметы, являющиеся оружием.
    • n:[имя] or name:[имя]. Например, n:muffins покажет все предметы, в имени которых соержится "muffins".
    • s:[набор] or set:[набор]. Например, s:fire покажет предметы из наборов экипировки, название которых начинается с "fire".
    • tt:[запрос], tip:[запрос] or tooltip:[запрос]. Например, tt:уникальный покажет все предметы, которые являются уникальными или уникальными использующимися.


Операторы поиска:
    • ! : Обращает результат поиска. Например, !q:эпическое покажет все НЕ эпические предметы.
    • | : Объединет запросы. Например, "q:эпическое | t:оружие" отобразит все предметы эпического качества ИЛИ являющиеся оружием.
    • & : Суммирует запросы. Например, "q:эпическое & t:оружие" отобразит все оружие эпического качества.
    • >, <, <=, => : сразнения для численных запросов. Например, запрос "lvl: >30" покажет все предметы с уровнем выше 30.


Также могут быть использованы следующие параметры:
    • soulbound, bound, bop : персональные при поднятии.
    • bou : персональные при использовании.
    • boe : персональные при одевании.
    • boa : привязоные к учетной записи.
    • quest : специальные предметы для заданий.
    • reagents, reagent, crafting : Реагенты профессий.
    • naval : Оборудование флота.
    • follower, followe, follow : Предметы последователей.
    • relic, reli, rel : Реликвии артефактов.
    • power, powe, pow : Предметы, дающие силу артефакта.]=];
L["TEXT_FORMAT_DESC"] = [=[Строка для изменения вида текста.

Примеры:
[namecolor][name] [difficultycolor][smartlevel] [shortclassification]
[healthcolor][health:current-max]
[powercolor][power:current]

Форматы здоровья/резурсов:
"current" - текущее значение
"percent" - значение в процентах
"current-max" - текущее значение, за которым идет максимальное значение. Будет отображать только максимальное значение, если текущее равно ему.
"current-percent" - текущее значение, за которым идет значение в процентах.Будет отображать только максимальное значение, если текущее равно ему.
"current-max-percent" - текущее значение, максимальное значение, за которым идет значение в процентах, Будет отображать только максимальное значение, если текущее равно ему.
"deficit" - отображает значение недостающего до максимума здоровья/ресурса. Не будет отображать ничего, если текущее значение равно максимальному.

Форматы имени:
"name:short" - Имя с ограничением длины в 10 символов
"name:medium" - Имя с ограничением длины в 15 символов
"name:long" - Имя с ограничением длины в 20 символов

Для отключения оставьте поле пустым, для дополнительной информации посетите http://www.tukui.org]=];

--ActionBars
L["Action Paging"] = "Переключение панелей"
L["ActionBars"] = "Панели команд"
L["Allow Masque to handle the skinning of this element."] = "Разрешить Masque обрабатывать этот элемент."
L["Alpha"] = "Прозрачность"
L["Anchor Point"] = "Точка фиксации"
L["Automatic"] = "Автоматически"
L["Backdrop Spacing"] = "Отступ фона"
L["Backdrop"] = "Фон"
L["Button Size"] = "Размер кнопок"
L["Button Spacing"] = "Отступ кнопок"
L["Buttons Per Row"] = "Кнопок в ряду"
L["Buttons"] = "Кнопок"
L["Change the alpha level of the frame."] = "Изменяет прозрачность этого элемента"
L["Color of the actionbutton when not usable."] = "Цвет кнопок, которые невозможно использовать."
L["Color of the actionbutton when out of power (Mana, Rage, Focus, Holy Power)."] = "Цвет кнопок на панелях команд, когда не хватает ресурса (маны, ярости, концентрации, силы света)"
L["Color of the actionbutton when out of range."] = "Цвет кнопок панелей команд, когда цель вне радиуса действия"
L["Color of the actionbutton when usable."] = "Цвет кнопок, которые можно использовать."
L["Color when the text is about to expire"] = "Цвет текста почти завершившегося восстановления."
L["Color when the text is in the days format."] = "Цвет текста времени восстановления в днях."
L["Color when the text is in the hours format."] = "Цвет текста времени восстановления в часах."
L["Color when the text is in the minutes format."] = "Цвет текста времени восстановления в минутах."
L["Color when the text is in the seconds format."] = "Цвет текста времени восстановления в секундах."
L["Cooldown Text"] = "Текст восстановления"
L["Darken Inactive"] = "Неактивные затенены"
L["Days"] = "Дни"
L["Display bind names on action buttons."] = "Отображать назначенные клавиши на кнопках."
L["Display cooldown text on anything with the cooldown spiral."] = "Отображать время восстановления на кнопках/предметах."
L["Display macro names on action buttons."] = "Отображать названия макросов на кнопках."
L["Expiring"] = "Завершение"
L["Flyout Direction"] = "Направление раскрытия"
L["Global Fade Transparency"] = "Глобальная прозрачность"
L["Height Multiplier"] = "Множитель высоты"
L["Hide Cooldown Bling"] = "Скрыть вспышку восстановления"
L["Hides the bling animation on buttons at the end of the global cooldown."] = "Прятать анимацию вспышки на кнопках в конце глобального времени восстановления."
L["Hours"] = "Часы"
L["If you unlock actionbars then trying to move a spell might instantly cast it if you cast spells on key press instead of key release."] = "Если вы разблокируете панели, а затем попытаетесь переместить заклинание, оно может быть применено мгновенно, если включено применение при нажатии."
L["Inherit Global Fade"] = "Использовать глобальную прозрачность"
L["Inherit the global fade, mousing over, targetting, setting focus, losing health, entering combat will set the remove transparency. Otherwise it will use the transparency level in the general actionbar settings for global fade alpha."] = "Использовать глобальную прозрачность. Наведение мыши, наличие цели, фокуса, потеря здоровья и вступление в бой уберут прозрачность. В остальных случаях будет использоваться уровень прозрачности из общих настроек панелей команд."
L["Key Down"] = "При нажатии клавиши"
L["Keybind Mode"] = "Назначить клавиши"
L["Keybind Text"] = "Текст клавиш"
L["Low Threshold"] = "Минимальное значение"
L["Macro Text"] = "Названия макросов"
L["Masque Support"] = "Поддержка Masque"
L["Minutes"] = "Минуты"
L["Mouse Over"] = "При наведении" --Also used in Bags
L["Multiply the backdrops height or width by this value. This is usefull if you wish to have more than one bar behind a backdrop."] = "Умножает высоту или ширину фона панели на это значение. Это полезно, когда Вы хотите иметь более одной панели на данном фоне."
L["Not Usable"] = "Нельзя использовать"
L["Out of Power"] = "Мало ресурса"
L["Out of Range"] = "Вне радиуса"
L["Restore Bar"] = "Восстановить панель"
L["Restore the actionbars default settings"] = "Восстанавливает настройки панели по умолчанию."
L["Seconds"] = "Секунды"
L["Show Empty Buttons"] = "Показывать пустые кнопки"
L["Shows a swipe animation when a spell is recharging but still has charges left."] = "Отображать анимацию заполнения, когда заклинание перезаряжается, но все еще имеет заряды."
L["The amount of buttons to display per row."] = "Количество кнопок в каждом ряду"
L["The amount of buttons to display."] = "Количество отображаемых кнопок."
L["The button you must hold down in order to drag an ability to another action button."] = "Кнопка, которую вы должны деражть нажатой для перемещения способностей на панелях команд."
L["The first button anchors itself to this point on the bar."] = "Первая кнопка прикрепляется к этой точке панели"
L["The size of the action buttons."] = "Размер кнопок панели команд."
L["The spacing between the backdrop and the buttons."] = "Расстояние между фоном панели и кнопками."
L["This setting will be updated upon changing stances."] = "Эта настройка вступит в силу при смене стойки."
L["Threshold before text turns red and is in decimal form. Set to -1 for it to never turn red"] = "Время, после которого текст станет красным и начнет отображать доли секунды. Установите -1, чтобы не отображать текст в такой форме."
L["Toggles the display of the actionbars backdrop."] = "Включить отображение фона панели команд."
L["Transparency level when not in combat, no target exists, full health, not casting, and no focus target exists."] = "Уровень прозрачности вне боя, без цели, без фокуса, с полным здоровьем и без произношения заклинаний."
L["Usable"] = "Можно использовать"
L["Use Draw Swipe"] = "Отрисовывать заполнение"
L["Use Position Override"] = "Использовать точку фиксации"
L["Visibility State"] = "Статус отображения"
L["When enabled it will use the Anchor Point setting to determine growth direction, otherwise it will be determined by where the bar is positioned."] = "Если включено, будет использоваться точка фиксации для определения направления роста панели. В противном случае будет использоваться позиция фиксатора на экране."
L["Width Multiplier"] = "Множитель ширины"
L["Zone Ability"] = "Способность местности"
L[ [=[This works like a macro, you can run different situations to get the actionbar to page differently.
 Example: '[combat] 2;']=] ] = [=[Работает как макрос. Вы можете задать различные условия для отображения разных панелей.
 Пример: '[combat] 2;']=]
L[ [=[This works like a macro, you can run different situations to get the actionbar to show/hide differently.
 Example: '[combat] show;hide']=] ] = [=[Работает как макрос. Вы можете задать различные условия для показа/скрытия панели.
 Пример: '[combat] show;hide']=]

--Bags
L["Add an item or search syntax to the ignored list. Items matching the search syntax will be ignored."] = "Добавить предмет или синтаксис поиска в список игнорируемых. Предметы, соответствующие синтаксису, буду игнорироваться."
L["Add Item or Search Syntax"] = "Добавить предмет или синтаксис поиска"
L["Adjust the width of the bag frame."] = "Установить размер фрейма сумок"
L["Adjust the width of the bank frame."] = "Установить размер фрейма банка"
L["Ascending"] = "Восходящее"
L["Bag Sorting"] = "Сортировка сумок"
L["Bag-Bar"] = "Панель сумок"
L["Bar Direction"] = "Направление панели"
L["Blizzard Style"] = "Стиль Blizzard"
L["Bottom to Top"] = "Снизу вверх"
L["Button Size (Bag)"] = "Размер слотов сумок"
L["Button Size (Bank)"] = "Размер слотов банка"
L["Clear Search On Close"] = "Сбрасывать поиск при закрытии"
L["Condensed"] = "Через запятую"
L["Currency Format"] = "Формат валюты"
L["Descending"] = "Нисходящее"
L["Direction the bag sorting will use to allocate the items."] = "Направление расположения предметов при сортировке."
L["Disable Bag Sort"] = "Отключить сортировку сумок"
L["Disable Bank Sort"] = "Отключить сортировку банка"
L["Display Item Level"] = "Отображать уровень предметов"
L["Display the junk icon on all grey items that can be vendored."] = "Показывать иконку монетки на серых предметах, которые можно продать."
L["Display the upgrade icon on items that WoW considers an upgrade for your character."] = "Отображать иконку на предметах, которые игра считает апгрейдом для персонажа."
L["Enable/Disable the all-in-one bag."] = 'Включить/выключить режим сумки "все в одной". '
L["Enable/Disable the Bag-Bar."] = "Включить/выключить панель сумок"
L["Full"] = "Полный"
L["Global"] = "Глобальный"
L["Here you can add items or search terms that you want to be excluded from sorting. To remove an item just click on its name in the list."] = "Здесь вы можете добавить предметы или запросы поиска, которые вы хотите исключить из сортировки. Для удаления предмета просто кликните на его имени в списке."
L["Icons and Text (Short)"] = "Иконки и текст (короткий)"
L["Icons and Text"] = "Иконки и текст"
L["Ignored Items and Search Syntax (Global)"] = "Игнорируемые предметы и синтаксис (Глобальный)"
L["Ignored Items and Search Syntax (Profile)"] = "Игнорируемые предметы и синтаксис (Профиль)"
L["Item Count Font"] = "Шрифт кол-ва предметов"
L["Item Level Threshold"] = "Ограничение уровня предметов"
L["Item Level"] = "Уровень предметов"
L["Money Format"] = "Формат денег"
L["Panel Width (Bags)"] = "Ширина сумок"
L["Panel Width (Bank)"] = "Ширина банка"
L["Search Syntax"] = "Синтаксис поиска"
L["Set the size of your bag buttons."] = "Установите размер кнопок на панели."
L["Short (Whole Numbers)"] = "Короткий (целые)"
L["Show Coins"] = "Показывать монеты"
L["Show Junk Icon"] = "Иконки мусора"
L["Show Upgrade Icon"] = "Иконка апгрейда"
L["Smart"] = "Умный"
L["Sort Direction"] = "Направление сортировки" --Also used in Buffs and Debuffs
L["Sort Inverted"] = "Инвертированная сортировка"
L["The direction that the bag frames be (Horizontal or Vertical)."] = "Расположение сумок (горизонтально или вертикально)"
L["The direction that the bag frames will grow from the anchor."] = "Направление, в котором будут расположены кнопки сумок относительно фиксатора."
L["The display format of the currency icons that get displayed below the main bag. (You have to be watching a currency for this to display)"] = "Формат отображения валюты в сумках. (У вас должна быть выбрана валюта для отслеживания, чтобы видеть результат)"
L["The display format of the money text that is shown at the top of the main bag."] = "Формат отображения текста золота в верхней части основной сумки."
L["The frame is not shown unless you mouse over the frame."] = "Отображать только при наведении мыши."
L["The minimum item level required for it to be shown."] = "Минимальный уровень предмета, который будет показан в сумках."
L["The size of the individual buttons on the bag frame."] = "Размер каждого слота в сумок"
L["The size of the individual buttons on the bank frame."] = "Размер каждого слота в банке"
L["The spacing between buttons."] = "Расстояние между кнопками"
L["Top to Bottom"] = "Сверху вниз"
L["Use coin icons instead of colored text."] = "Использовать иконки монет вместо окрашенного текста."

--Buffs and Debuffs
L["Begin a new row or column after this many auras."] = "Начинать новый ряд/столбец после этого количества аур."
L["Count xOffset"] = "Отступ стаков по X"
L["Count yOffset"] = "Отступ стаков по Y"
L["Defines how the group is sorted."] = "Определяет условия сортировки"
L["Defines the sort order of the selected sort method."] = "Определяет порядок в выбранном методе сортировки."
L["Disabled Blizzard"] = "Отключить ауры Blizzard"
L["Fade Threshold"] = "Значение мерцания"
L["Index"] = "Порядок наложения"
L["Indicate whether buffs you cast yourself should be separated before or after."] = "Определяет должны ли Ваши баффы находиться отдельно перед или после остальных."
L["Limit the number of rows or columns."] = "Определяет максимальное количество рядов/столбцов."
L["Max Wraps"] = "Максимум рядов"
L["No Sorting"] = "Без сортировки"
L["Other's First"] = "Сначала чужие"
L["Seperate"] = "Разделение"
L["Set the size of the individual auras."] = "Устанавливает размер аур"
L["Sort Method"] = "Метод сортировки"
L["The direction the auras will grow and then the direction they will grow after they reach the wrap after limit."] = "Направление роста аур и сторона с которой будет добавляться новый ряд."
L["Threshold before text changes red, goes into decimal form, and the icon will fade. Set to -1 to disable."] = "Пороговое значение, после которого цвет текста изменится на красный и начнет показывать десятые доли секунд, а иконка начнет мигать. Установите на -1 для отключения"
L["Time xOffset"] = "Отступ времени по X"
L["Time yOffset"] = "Отступ времени по Y"
L["Time"] = "Время"
L["Wrap After"] = "Размер ряда"
L["Your Auras First"] = "Сначала свои"

--Chat
L["Above Chat"] = "Над чатом"
L["Adjust the height of your right chat panel."] = "Настроить высоту правой панели чата"
L["Adjust the width of your right chat panel."] = "Настроить ширину правой панели чата."
L["Alerts"] = "Оповещения"
L["Allowed Combat Repeat"] = "Повторяющиеся символы"
L["Attempt to create URL links inside the chat."] = "Пытаться создавать интернет-ссылки в чате."
L["Attempt to lock the left and right chat frame positions. Disabling this option will allow you to move the main chat frame anywhere you wish."] = "Закрепляет позиции левого и правого чата к соответственным панелям. Отключение этой опции позволит перемещать чат независимо от них."
L["Auto-Close Pet Battle Log"] = "Автоматически закрывать журнал битв питомцев"
L["Below Chat"] = "Под чатом"
L["Chat EditBox Position"] = "Позиция поля ввода"
L["Chat History"] = "История чата"
L["Class Color Mentions"] = "Упоминания цветом класса"
L["Custom Timestamp Color"] = "Свой цвет времени"
L["Display LFG Icons in group chat."] = "Отображать иконки выбранных ролей в чате"
L["Display the hyperlink tooltip while hovering over a hyperlink."] = "Отображать подсказку ссылки на при наведении на нее мыши. Действует на предметы, достижения, сохранения подземелий и тд."
L["Enable the use of separate size options for the right chat panel."] = "Включить использование отдельных настроек ширины и высоты для правой панели чата."
L["Exclude Name"] = "Исключить имя";
L["Excluded names will not be class colored."] = "Исключенные имена не окрашиваются в цвет класса";
L["Excluded Names"] = "Исключенные имена";
L["Fade Chat"] = "Затухание чата"
L["Fade Tabs No Backdrop"] = "Затухание без фона"
L["Fade the chat text when there is no activity."] = "Исчезновение строк чата при отсутствии аткивности"
L["Fade Undocked Tabs"] = "Затухание незакрепленных"
L["Fades the text on chat tabs that are docked in a panel where the backdrop is disabled."] = "Исчезновение текста на вкладках, закрепленных на какой-либо из панелей чата, при отключенном фоне."
L["Fades the text on chat tabs that are not docked at the left or right chat panel."] = "Заставляет текст на вкладках, не закрепленных на правой или левой панелях чата, исчезать до наведения курсора."
L["Font Outline"] = "Граница шрифта" --Also used in UnitFrames section
L["Font"] = "Шрифт"
L["Hide Both"] = "Скрыть оба"
L["Hyperlink Hover"] = "Подсказка над ссылками"
L["Keyword Alert"] = "Звук ключевых слов"
L["Keywords"] = "Ключевые слова"
L["Left Only"] = "Только левый"
L["LFG Icons"] = "Иконки роли"
L["List of words to color in chat if found in a message. If you wish to add multiple words you must seperate the word with a comma. To search for your current name you can use %MYNAME%.\n\nExample:\n%MYNAME%, ElvUI, RBGs, Tank"] = "Список слов для окрашивания, если они обнаружены в чате. Если Вы хотите добавить несколько слов, то разделяйте их запятыми. Для поиска имени Вашего текущего персонажа используйте %MYNAME%.\n\nПример:\n%MYNAME%, ElvUI, РБГ, Танк"
L["Lock Positions"] = "Закрепить"
L["Log the main chat frames history. So when you reloadui or log in and out you see the history from your last session."] = "Записывать содержимое основных чатов. Таким образом, после перезагрузки интерфейса или входа/выхода из игры, Вы увидите сообщения из прошлой сессии."
L["No Alert In Combat"] = "Без оповещений в бою"
L["Number of messages you scroll for each step."] = "Количество сообщений, прокручивающихся за шаг."
L["Number of repeat characters while in combat before the chat editbox is automatically closed."] = "Кол-во одинаковых символов введенных в бою, после которого поле ввода автоматически закроется."
L["Number of time in seconds to scroll down to the bottom of the chat window if you are not scrolled down completely."] = "Время в секундах, через которое чат автоматически покрутится вниз до конца, если Вы не сделаете это вручную."
L["Panel Backdrop"] = "Фон панелей"
L["Panel Height"] = "Высота панели"
L["Panel Texture (Left)"] = "Текстура левой панели"
L["Panel Texture (Right)"] = "Текстура правой панели"
L["Panel Width"] = "Ширина панели"
L["Position of the Chat EditBox, if datatexts are disabled this will be forced to be above chat."] = "Позиция поля ввода для чата. Если инфо-тексты отключены, оно всегда будет над чатом."
L["Prevent the same messages from displaying in chat more than once within this set amount of seconds, set to zero to disable."] = "Предотвращает появление одинаковых сообщения в чате чаще указанного количества секунд. Установите на нуль для отключения."
L["Require holding the Alt key down to move cursor or cycle through messages in the editbox."] = "Требовать зажатой клавиши Alt для перемещения курсора или переключения между предыдущими отправленными сообщениями."
L["Right Only"] = "Только правый"
L["Right Panel Height"] = "Высота правого чата"
L["Right Panel Width"] = "Ширина правого чата"
L["Scroll Interval"] = "Интервал прокрутки"
L["Scroll Messages"] = "Прокручивание сообщений"
L["Separate Panel Sizes"] = "Разные размеры панелей"
L["Set the font outline."] = "Устанавливает границу шрифта."
L["Short Channels"] = "Короткие каналы"
L["Shorten the channel names in chat."] = "Сокращать названия каналов чата."
L["Show Both"] = "Показать оба"
L["Spam Interval"] = "Интервал спама"
L["Sticky Chat"] = "Клейкий чат"
L["Tab Font Outline"] = "Граница шрифта вкладок"
L["Tab Font Size"] = "Размер шрифта вкладок"
L["Tab Font"] = "Шрифт вкладок"
L["Tab Panel Transparency"] = "Прозрачность панели вкладок"
L["Tab Panel"] = "Панель вкладок"
L["Timestamp Color"] = "Цвет времени"
L["Toggle showing of the left and right chat panels."] = "Переключить отображение панелей чата."
L["Toggle the chat tab panel backdrop."] = "Показать/скрыть фон панели под вкладками чата"
L["URL Links"] = "Интернет-ссылки"
L["Use Alt Key"] = "Использовать Alt"
L["Use class color for the names of players when they are mentioned."] = "Окрашивать имена игроков цветом их класса."
L["When opening the Chat Editbox to type a message having this option set means it will retain the last channel you spoke in. If this option is turned off opening the Chat Editbox should always default to the SAY channel."] = "При открытии строки ввода сообщения, если эта опция включена, будет выбран последний канал, в который Вы писали. В противном случае всегда будет установлен канал 'сказать'."
L["Whisper Alert"] = "Звук шепота"
L[ [=[Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.

Please Note:
-The image size recommended is 256x128
-You must do a complete game restart after adding a file to the folder.
-The file type must be tga format.

Example: Interface\AddOns\ElvUI\media\textures\copy

Or for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.]=] ] = [=[Укажите имя файла в папке World of Warcraft, который Вы хотите использовать в качестве фона панелей.

Пожалуйста, учтите:
-Рекомендованный размер изображения 256x128
-Вы должны полностью перезапустить игру после добавления нового файла в папку.
-Тип файла должен быть tga.

Пример: Interface\AddOns\ElvUI\media\textures\copy

Для большинства пользователей будет легче просто положить tga файл в папку игры, а затем написать имя файла здесь.]=]

--Credits
L["Coding:"] = "Написание кода:"
L["Credits"] = "Благодарности"
L["Donations:"] = "Финансовая поддержка:"
L["ELVUI_CREDITS"] = "Я бы хотел выделить следующих людей, которые помогли мне в разработке аддона тестированием, кодингом и поддержкой при помощи донаций. Пожалуйста, отметьте, что в разделе донаций я написал имена людей, написавших мне в ЛС на форуме. Если Ваше имя пропущено, и Вы хотите его видеть, отправьте мне сообщение."
L["Testing:"] = "Тестирование:"

--DataBars
L["Current - Percent (Remaining)"] = "Текущий - Процент (Осталось)"
L["Current - Remaining"] = "Текущий - Осталось"
L["DataBars"] = "Инфо-полосы"
L["Hide In Combat"] = "Скрывать в бою"
L["Hide Outside PvP"] = "Скрывать вне PvP"
L["Setup on-screen display of information bars."] = "Контролирует отображение информационных полос."

--DataTexts
L["24-Hour Time"] = "24х часовой формат"
L["Add Currency ID"] = "Добавить ID валюты"
L["Battleground Texts"] = "Текст ПБ"
L["Block Combat Click"] = "Блокировать нажатия в бою"
L["Block Combat Hover"] = "Блокировать подсказки в бою"
L["Blocks all click events while in combat."] = "Блокирует действия по клику в бою."
L["Blocks datatext tooltip from showing in combat."] = "Скрывает подказки инфо-текстов в бою."
L["BottomLeftMiniPanel"] = "Миникарта снизу слева (внутри)"
L["BottomMiniPanel"] = "Миникарта снизу (внутри)"
L["BottomRightMiniPanel"] = "Миникарта снизу справа (внутри)"
L["Custom Currencies"] = "Свои валюты"
L["Custom Currency"] = "Своя валюта"
L["Datatext Panel (Left)"] = "Панель информации (левая)"
L["Datatext Panel (Right)"] = "Панель информации (правая)"
L["DataTexts"] = "Инфо-тексты"
L["Display data panels below the chat, used for datatexts."] = "Отображать панели под чатом, используется для инфо-текстов"
L["Display In Main Tooltip"] = "Отображать в основной подсказке"
L["Display minimap panels below the minimap, used for datatexts."] = "Отображать панели информационных текстов под миникартой."
L["Displayed Currency"] = "Отображаемая валюта"
L["Gold Format"] = "Формат золота"
L["If enabled, then this currency will be displayed in the main Currencies datatext tooltip."] = "При включении будет отображать данную валюту в основной подсказке инфо-текста валют."
L["If not set to true then the server time will be displayed instead."] = "Если отключено, будет отображаться серверное время."
L["left"] = "Слева"
L["LeftChatDataPanel"] = "Левая панель чата"
L["LeftMiniPanel"] = "Миникарта, слева"
L["Local Time"] = "Местное время"
L["middle"] = "В центре"
L["Minimap Panels"] = "Информация у миникарты"
L["Panel Transparency"] = "Прозрачность панели"
L["Panels"] = "Панели"
L["right"] = "Справа"
L["RightChatDataPanel"] = "Правая панель чата"
L["RightMiniPanel"] = "Миникарта, справа"
L["Small Panels"] = "Малые панели"
L["The display format of the money text that is shown in the gold datatext and its tooltip."] = "Формат отображения золота на инфо-тексте золота и его подсказке."
L["This allows you to create a new datatext which will track the currency with the supplied currency ID. The datatext can be added to a panel immediately after creation."] = "Позволяет создать свой инфо-текст для отслеживания валюты по ID. После создания инфо-текст будет немедленно добавлен в список."
L["Toggle 24-hour mode for the time datatext."] = "Включить 24х часовой формат отображения времени."
L["TopLeftMiniPanel"] = "Миникарта сверху слева (внутри)"
L["TopMiniPanel"] = "Миникарта сверху (внутри)"
L["TopRightMiniPanel"] = "Миникарта сверху справа (внутри)"
L["Use Tooltip"] = "Использовать подсказку"
L["When inside a battleground display personal scoreboard information on the main datatext bars."] = "На полях боя отображать личную информацию на основных полосах инфо-текстов"
L["Word Wrap"] = "Перенос слов"

--Distributor
L["Must be in group with the player if he isn't on the same server as you."] = "Вы должны быть в группе в данным игроком, если он не с Вашего сервера."
L["Sends your current profile to your target."] = "Отправить текущий профиль цели."
L["Sends your filter settings to your target."] = "Отправить Ваши фильтры цели."
L["Share Current Profile"] = "Передать текущий профиль"
L["Share Filters"] = "Передать фильтры"
L["This feature will allow you to transfer settings to other characters."] = "Эта функция позволит Вам передавать свои настройки другим персонажам."
L["You must be targeting a player."] = "Целью должен быть игрок."

--General
L["Accept Invites"] = "Принимать приглашения"
L["Adjust the position of the threat bar to either the left or right datatext panels."] = "Изменяет позицию полосы угрозы"
L["AFK Mode"] = "Режим АФК"
L["Announce Interrupts"] = "Объявлять о прерываниях"
L["Announce when you interrupt a spell to the specified chat channel."] = "Объявлять о прерванных Вами заклинаниях в указанный канал чата."
L["Attempt to support eyefinity/nvidia surround."] = "Пытаться поддерживать eyefinity/nvidia surround"
L["Auto Greed/DE"] = "Авто. не откажусь/распылить"
L["Auto Repair"] = "Автоматический ремонт"
L["Auto Scale"] = "Автоматический масштаб"
L["Automatically accept invites from guild/friends."] = "Автоматически принимать приглашения в группу от друзей и гильдии."
L["Automatically repair using the following method when visiting a merchant."] = "Автоматически чинить экипировку за счет выбранного источника при посещении торговца."
L["Automatically scale the User Interface based on your screen resolution"] = "Автоматически масштабировать UI в зависимости от вашего разрешения"
L["Automatically select greed or disenchant (when available) on green quality items. This will only work if you are the max level."] = "Автоматически выбирать \"не откажусь\" или \"распылить\" (когда доступно) при розыгрыше предметов зеленого качества. Эта опция работает, только если вы максимального уровня."
L["Automatically vendor gray items when visiting a vendor."] = "Автоматически продавать предметы серого качества при посещении торговца."
L["Bonus Reward Position"] = "Позиция бонусной награды"
L["Bottom Panel"] = "Нижняя панель"
L["Chat Bubbles Style"] = "Стиль облачков сообщений"
L["Chat Bubbles"] = "Облачка сообщений"
L["Direction the bar moves on gains/losses"] = "направление заполнения полосы"
L["Disable Tutorial Buttons"] = "Отключить кнопки обучения"
L["Disables the tutorial button found on some frames."] = "Отключает кнопки обучения на некоторых фреймах."
L["Display a panel across the bottom of the screen. This is for cosmetic only."] = "Отображать панель на нижней границе экрана. Это косметический элемент."
L["Display a panel across the top of the screen. This is for cosmetic only."] = "Отображать панель на верхней границе экрана. Это косметический элемент."
L["Display battleground messages in the middle of the screen."] = "Отображать сообщения полей боя в центре экрана."
L["Display emotion icons in chat."] = "Показывать смайлы в чате"
L["Emotion Icons"] = "Иконки эмоций"
L["Enable + Adjust Movers"] = "Включить и двигать фиксаторы"
L["Enable/Disable the loot frame."] = "Включить/выключить окно добычи ElvUI."
L["Enable/Disable the loot roll frame."] = "Включить/выключить фрейм распределения добычи ElvUI."
L["Enables the ElvUI Raid Control panel."] = "Включает панель управления рейдом ElvUI."
L["Enhanced PVP Messages"] = "Улущенные PvP сообщения"
L["General"] = "Общие"
L["Height of the objective tracker. Increase size to be able to see more objectives."] = "Высота списка заданий. Увеличение размера позволить видеть большее количество."
L["Hide At Max Level"] = "Прятать на максимальном уровне"
L["Hide Error Text"] = "Прятать сообщения об ошибках"
L["Hide In Vehicle"] = "Прятать в транспорте"
L["Hides the red error text at the top of the screen while in combat."] = "Скрывать красный текст ошибок вверху экрана в бою."
L["Log Taints"] = "Отслеживать недочеты"
L["Login Message"] = "Сообщение загрузки"
L["Loot Roll"] = "Раздел добычи"
L["Loot"] = "Добыча"
L["Lowest Allowed UI Scale"] = "Наименьший возможный масштаб"
L["Multi-Monitor Support"] = "Поддержка нескольких мониторов"
L["Name Font"] = "Шрифт имени"
L["Number Prefix"] = "Сокращения значений"
L["Objective Frame Height"] = "Высота списка заданий"
L["Order Hall Command Bar"] = "Полоса оплота класса"
L["Party / Raid"] = "Группа / Рейд"
L["Party Only"] = "Только группа"
L["Position of bonus quest reward frame relative to the objective tracker."] = "Позиция наград за бонусные задания относительно списка квестов."
L["Raid Only"] = "Только рейд"
L["Remove Backdrop"] = "Скрыть фон"
L["Reset all frames to their original positions."] = "Установить все фреймы на позиции по умолчанию"
L["Reset Anchors"] = "Сбросить позиции"
L["Reverse Fill Direction"] = "Обратное заполнение"
L["Send ADDON_ACTION_BLOCKED errors to the Lua Error frame. These errors are less important in most cases and will not effect your game performance. Also a lot of these errors cannot be fixed. Please only report these errors if you notice a Defect in gameplay."] = "Отображать ошибки типа ADDON_ACTION_BLOCKED в фрейме ошибок lua. Эти ошибки в большинстве случаев не сильно важны и не влияют на производительность. Также многие из этих ошибок не могут быть исправлены. Пожалуйста, сообщайте об этих ошибках только если Вы заметите дефект в игре."
L["Skin Backdrop (No Borders)"] = "Стилизовать фон (без границ)"
L["Skin Backdrop"] = "Стилизовать фон"
L["Skin the blizzard chat bubbles."] = "Стилизовать облачка сообщения Blizzard"
L["Smaller World Map"] = "Маленькая карта мира"
L["Talking Head Scale"] = 'Масштаб "говорящей головы"'
L["The font that appears on the text above players heads. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "Шрифт, которым будет написан текст над головами игроков. |cffFF0000ВНИМАНИЕ: Необходим перезапуск игры или релог для начала действия этой настройки.|r"
L["The Thin Border Theme option will change the overall apperance of your UI. Using Thin Border Theme is a slight performance increase over the traditional layout."] = "Тонкие границы изменят общий вид интерфейса. Это небольшое улучшение производительности относительно традиционного вида."
L["The unit prefixes you want to use when values are shortened in ElvUI. This is mostly used on UnitFrames."] = "Сокращения для значений, показываемых ElvUI. В большинстве своем ипользуются для рамок юнитов."
L["Thin Border Theme"] = "Тонкие границы"
L["Toggle Tutorials"] = "Показать помощь"
L["Top Panel"] = "Верхняя панель"
L["When you go AFK display the AFK screen."] = "Отображать специальный экран, когда вы переходите в состояние \"Отсутствует\"."

--Media
L["Applies the font and font size settings throughout the entire user interface. Note: Some font size settings will be skipped due to them having a smaller font size by default."] = "Применить этот шрифт ко всем элементам интерфейса. Некоторые шрифты будут пропущены из-за более мелкого размера по умолчанию."
L["Applies the primary texture to all statusbars."] = "Применяет основную текстуу ко всем полосам состояния."
L["Apply Font To All"] = "Применить ко всем шрифтам"
L["Apply Texture To All"] = "Применить ко всем текстурам"
L["Backdrop color of transparent frames"] = "Цвет фона прозрачных фреймов"
L["Backdrop Color"] = "Цвет фона"
L["Backdrop Faded Color"] = "Цвет прозрачного фона"
L["Border Color"] = "Цвет окантовки"
L["Color some texts use."] = "Цвет некоторых текстов."
L["CombatText Font"] = "Шрифт текста боя"
L["Default Font"] = "Шрифт по умолчанию"
L["Fonts"] = "Шрифты"
L["Main backdrop color of the UI."] = "Основной цвет фона интерфейса."
L["Main border color of the UI."] = "Основной цвет границ интерфейса"
L["Media"] = "Медиа"
L["Primary Texture"] = "Основная текстура"
L["Replace Blizzard Fonts"] = "Заменять шрифты Blizzard"
L["Replaces the default Blizzard fonts on various panels and frames with the fonts chosen in the Media section of the ElvUI config. NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this. Enabled by default."] = "Заменяет шрифты, используемые Blizzard по умолчанию на различных панелях и фреймах, шрифтами, установленными в секции \"Медиа\" (этой секции). Любые дочерние шрифты к заменяемым, также будут изменены. Включено по умолчанию."
L["Secondary Texture"] = "Вторичная текстура"
L["Set the font size for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"] = "Установите размер шрифта для всего интерфейса. Это не действует на элементы с собственными настройками шрифтов (например, рамки юнитов)."
L["Textures"] = "Текстуры"
L["The font that combat text will use. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "Шрифт текста боя. |cffFF0000ВНИМАНИЕ: это действие потребует перезапуска игры или повторного входа в мир.|r"
L["The font that the core of the UI will use."] = "Шрифт для основного интерфейса."
L["The texture that will be used mainly for statusbars."] = "Эта текстура будет использоваться в основном для полос состояния."
L["This texture will get used on objects like chat windows and dropdown menus."] = "Эта текстура будет использоваться для таких объектов как окно чата и выпадающие меню."
L["Value Color"] = "Цвет значений"

--Maps
L["Adjust the size of the minimap."] = "Изменяет размер миникарты"
L["Always Display"] = "Всегда отображать"
L["Bottom Left"] = "Внизу слева"
L["Bottom Right"] = "Внизу справа"
L["Bottom"] = "Внизу"
L["Change settings for the display of the location text that is on the minimap."] = "Изменяет опции отображения названия локации на миникарте"
L["Enable/Disable the minimap. |cffFF0000Warning: This will prevent you from seeing the minimap datatexts.|r"] = "Включить/выключить миникарту. |cffFF0000АХТУНГ: отключение карты уберет и соответственные инфо-тексты.|r"
L["Instance Difficulty"] = "Сложность подземелья"
L["Left"] = "Левый"
L["LFG Queue"] = "Очередь"
L["Location Text"] = "Текст локации"
L["Make the world map smaller."] = "Сделать карту мира меньше. Она больше не будет занимать весь экран в увеличенном варианте."
L["Map Opacity When Moving"] = "Прозрачность карты в движении"
L["Maps"] = "Карты"
L["Minimap Buttons"] = "Кнопки миникарты"
L["Minimap Mouseover"] = "При наведении мыши"
L["Open Ticket"] = "Открытый запрос"
L["Puts coordinates on the world map."] = "Добавляет координаты на карту мира."
L["Reset Zoom"] = "Сброс приближения"
L["Right"] = "Правый"
L["Scale"] = "Масштаб"
L["Top Left"] = "Вверху слева"
L["Top Right"] = "Вверху справа"
L["Top"] = "Вверху"
L["World Map Coordinates"] = "Координаты карты мира"
L["X-Offset"] = "Отступ по X"
L["Y-Offset"] = "Отступ по Y"

--Misc
L["Filters are not allowed to have commas in their name. Stripping commas from filter name."] = "Фильтры не могут иметь запятые в имени, удаляю запятые."
L["Install"] = "Установка"
L["Run the installation process."] = "Запустить процесс установки"
L["Toggle Anchors"] = "Показать фиксаторы"
L["Unlock various elements of the UI to be repositioned."] = "Разблокировать элементы интерфейса для их перемещения."
L["Version"] = "Версия"

--NamePlates
L["# Displayed Auras"] = "Кол-во аур"
L["Actions"] = "Действия"
L["Add a Name or NPC ID to the list."] = "Добавить имя или ID НИПа в список."
L["Add Name or NPC ID"] = "Добавить имя или ID НИПа"
L["Add Nameplate Filter"] = "Добавить фильтр индикаторов"
L["Add Regular Filter"] = "Добавить обычный фильтр"
L["Add Special Filter"] = "Добавить специальный фильтр"
L["Always Show Target Health"] = "Всегда показывать здоровье цели"
L["Always Show"] = "Всегда отображать"
L["Apply this filter if a buff has remaining time greater than this. Set to zero to disable."] = "Применять фильтр, если оставшееся время баффа больше указанного. Установите на 0 для отключения."
L["Apply this filter if a buff has remaining time less than this. Set to zero to disable."] = "Применять фильтр, если оставшееся время баффа меньше указанного. Установите на 0 для отключения."
L["Apply this filter if a debuff has remaining time greater than this. Set to zero to disable."] = "Применять фильтр, если оставшееся время дебаффа больше указанного. Установите на 0 для отключения."
L["Apply this filter if a debuff has remaining time less than this. Set to zero to disable."] = "Применять фильтр, если оставшееся время дебаффа меньше указанного. Установите на 0 для отключения."
L["Background Glow"] = "Фоновое свечение"
L["Bad Color"] = "Плохой цвет"
L["Bad Scale"] = "Плохой масштаб"
L["Bad Transition Color"] = "Цвет плохого перехода"
L["Base Height for the Aura Icon"] = "Базовая высота иконок аур"
L["Border Glow"] = "Свечение границы"
L["Border"] = "Граница"
L["Boss Auras"] = "Ауры боссов"
L["Cast Bar"] = "Полоса заклинаний"
L["Cast Color"] = "Цвет полосы заклинаний"
L["Cast No Interrupt Color"] = "Цвет непрерываемого"
L["Cast Time Format"] = "Формат времени заклинания"
L["Casting"] = "Заклинания"
L["Channel Time Format"] = "Формат времени поддерживаемого"
L["Clamp nameplates to the top of the screen when outside of view."] = "Собирать индикаторы на верхней границе экрана, когда их юнит вне поля зрения."
L["Clamp Nameplates"] = "Собирать индикаторы"
L["Clear Filter"] = "Очистить фильтр"
L["Clickable Height"] = "Кликабельная высота"
L["Clickable Width"] = "Кликабельная ширина"
L["Color Tanked"] = "Окрашивать танкуемых"
L["Control enemy nameplates toggling on or off when in combat."] = "Контроллирует показ/скрытие вражеских индикаторов в бою."
L["Control friendly nameplates toggling on or off when in combat."] = "Контроллирует показ/скрытие дружеских индикаторов в бою."
L["Controls how big of an area on the screen will accept clicks to target unit."] = "Определяет размер области экрана, клик на которой бдет считаться кликом по юниту."
L["Controls how many auras are displayed, this will also affect the size of the auras."] = "Контроллирует кол-во отображаемых эффектов. Также влияет на размер иконок."
L["Controls which nameplates will be displayed."] = "Определяет, какие индикаторы быдут отображаться."
L["Copy settings from another unit."] = "Скопировать настройки с другого юнита."
L["Copy Settings From"] = "Скопировать из"
L["Current Level"] = "Текущий уровень"
L["Default Settings"] = "Умолчания"
L["Detection"] = "Обнаружение"
L["Display a healer icon over known healers inside battlegrounds or arenas."] = "Отображать иконки лекаря над известными целителями на полях боя и аренах"
L["Display Minions"] = "Отображать миньонов"
L["Display Minor Units"] = "Отображать малых существ"
L["Display NPC Titles whenever healthbars arent displayed and names are."] = "Отображать татилу НИП, когда полосы здоровья отключены, а имена нет."
L["Display Style"] = "Стиль отображения"
L["Elite Icon"] = "Иконки элиты"
L["Enable/Disable the scaling of targetted nameplates."] = "Включить/выключить масштабирование индикатора цели."
L["Enemy Combat Toggle"] = "Переключение в бою (враги)"
L["Enemy NPC Frames"] = "Враждебные НИП"
L["Enemy Player Frames"] = "Враждебные игроки"
L["Enemy"] = "Враг" --Also used in UnitFrames
L["ENEMY_NPC"] = "Враждебный НИП"
L["ENEMY_PLAYER"] = "Враждебный игрок"
L["Filter already exists!"] = "Фильтр уже существует!"
L["Filter Priority"] = "Приоритет фильтров"
L["Filter"] = "Фильтр"
L["Filters Page"] = "Фильтры"
L["Friendly Combat Toggle"] = "Переключение в бою (друзья)"
L["Friendly NPC Frames"] = "Дружественные НИП"
L["Friendly Player Frames"] = "Дружественные игроки"
L["FRIENDLY_NPC"] = "Дружественный НИП"
L["FRIENDLY_PLAYER"] = "Дружественный игрок"
L["General Options"] = "Общие"
L["Good Color"] = "Хороший цвет"
L["Good Scale"] = "Хороший масштаб"
L["Good Transition Color"] = "Цвет хорошего перехода"
L["Healer Frames"] = "Лекари"
L["Healer Icon"] = "Иконки лекарей"
L["HEALER"] = "Лекарь"
L["Health Color"] = "Цвет здоровья"
L["Health Threshold"] = "Значение здоровья"
L["Hide Delay"] = "Задержка скрытия"
L["Hide Frame"] = "Скрыть рамку"
L["Hide Spell Name"] = "Скрыть название заклинания"
L["Hide Time"] = "Скрыть время"
L["Hide When Empty"] = "Скрывать пустые"
L["Hide"] = "Скрыть" --Also used in DataTexts
L["How many seconds the castbar should stay visible after the cast failed or was interrupted."] = "После прерывания или отмены, полоса заклинаний будет оставаться видимой указаное количество секунд."
L["Icon Base Height"] = "Базовая высота иконки"
L["If enabled then it checks if auras are missing instead of being present on the unit."] = "Если включено, то будет проверять отсутствие ауры вместо ее наличия."
L["If enabled then it will require all auras to activate the filter. Otherwise it will only require any one of the auras to activate it."] = "Если включено, то для активации фильтра потребуется наличие всех аур. В противном случае наличия любой из списка."
L["If enabled then the filter will only activate if the level of the unit is equal to or higher than this value."] = "Если включено, то фильтр будет акитивирован, когда уровень юнита больше либо равен этому числу."
L["If enabled then the filter will only activate if the level of the unit is equal to or lower than this value."] = "Если включено, то фильтр будет акитивирован, когда уровень юнита меньше либо равен этому числу."
L["If enabled then the filter will only activate if the level of the unit matches this value."] = "Если включено, то фильтр будет акитивирован, когда уровень юнита равен этому числу."
L["If enabled then the filter will only activate if the level of the unit matches your own."] = "Если включено, то фильтр будет акитивирован, когда уровень юнита равен вашему."
L["If enabled then the filter will only activate if the unit is casting interruptible spells."] = "Если включено, то фильтр будет акитивирован, когда юнит произносит прерываемое заклинание."
L["If enabled then the filter will only activate when the unit is in combat."] = "Если включено, фильтр будет активирован только когда юнит в бою."
L["If enabled then the filter will only activate when the unit is out of combat."] = "Если включено, фильтр будет активирован только когда юнит вне боя."
L["If enabled then the filter will only activate when you are in combat."] = "Если включено, фильтр будет активирован только когда вы в бою."
L["If enabled then the filter will only activate when you are out of combat."] = "Если включено, фильтр будет активирован только когда вы вне боя."
L["If the aura is listed with a number then you need to use that to remove it from the list."] = "Если аура добавлена номером, то для удаления потребуется номер."
L["If this list is empty, and if 'Interruptible' is checked, then the filter will activate on any type of cast that can be interrupted."] = 'Если список пуст и "Прерываемые" включено, то фильтр будет активирован при произнесении люблго прерываемого заклинания.'
L["If this threshold is used then the health of the unit needs to be higher than this value in order for the filter to activate. Set to 0 to disable."] = "Если используется, то уровень здоровья .нита должен быть выше указанного, чтобы фильтр активировался."
L["If this threshold is used then the health of the unit needs to be lower than this value in order for the filter to activate. Set to 0 to disable."] = "Если используется, то уровень здоровья .нита должен быть ниже указанного, чтобы фильтр активировался."
L["In Combat"] = "В бою"
L["Interruptible"] = "Прерываемые"
L["Is Targeted"] = "Взят в цель"
L["LEVEL_BOSS"] = "Установите на -1 для боссов или 0 для отключения.";
L["Load Distance"] = "Дистанция показа"
L["Low Health Threshold"] = "Пороговое значение здоровья"
L["Lower numbers mean a higher priority. Filters are processed in order from 1 to 100."] = "Меньшее значение = большему приоритету. Фильтры обрабатываются в порядке от 1 к 100."
L["Make the unitframe glow yellow when it is below this percent of health, it will glow red when the health value is half of this value."] = "Заставляет индикатор подсвечиваться желтым при установленном проценте здоровья. При достижении половины этого значения свечение станет красным."
L["Match Player Level"] = "Соответсвие уровню игрока"
L["Maximum Level"] = "Максимальный уровень"
L["Maximum Time Left"] = "Максимум оставшегося времени"
L["Minimum Level"] = "Минимальный уровень"
L["Minimum Time Left"] = "Минимум оставшегося времени"
L["Missing"] = "Отсутствует"
L["Name Color"] = "Цвет имени"
L["NamePlates"] = "Индикаторы здоровья"
L["Non-Target Transparency"] = "Прозрачность не цели"
L["Not Targeted"] = "Не взят в цель"
L["Only load nameplates for units within this range."] = "Отображать индикаторы для юнитов на этом расстоянии и ближе."
L["Only Show Target"] = "Только цель"
L["Out Of Combat"] = "Вне боя"
L["Over Health Threshold"] = "Более значения здоровья"
L["Personal Auras"] = "Личные ауры"
L["Player in Combat"] = "Игрок в бою"
L["Player Nameplate"] = "Игрок"
L["Player Out of Combat"] = "Игрок вне боя"
L["PLAYER"] = "Игрок"
L["Reaction Colors"] = "Цвета отношений"
L["Reaction Type"] = "Тип реакции"
L["Remove a Name or NPC ID from the list."] = "Удалить имя или ID НИПа из списка."
L["Remove Name or NPC ID"] = "Удалить имя или ID НИПа"
L["Remove Nameplate Filter"] = "Удалить фильтр индикаторов"
L["Require All"] = "Все"
L["Reset filter priority to the default state."] = "Сбросить приоритеты фильтров на значение по умолчанию."
L["Reset Priority"] = "Сбросить приоритеты"
L["Return filter to its default state."] = "Вернуть фильтры к значениям по умолчанию."
L["Scale of the nameplate that is targetted."] = "Масштаб индикатора цели."
L["Select Nameplate Filter"] = "Выбрать фильтр индикаторов"
L["Set Settings to Default"] = "Сбросить настройки на умолчания"
L["Set the transparency level of nameplates that are not the target nameplate."] = "Устанавливает степень прозрачности для индикаторов юнитов, не являющихся вашей целью."
L["Set to either stack nameplates vertically or allow them to overlap."] = "Выстраивать индикаторы в столбик или позволить им накладываться друг на друга."
L["Shortcut to 'Filters' section of the config."] = "Ярлык для секицц фильтров в настройках."
L["Shortcuts"] = "Ярлыки"
L["Show In Combat"] = "Показывать в бою"
L["Show NPC Titles"] = "Титулы НИП"
L["Show With Target"] = "Отображать с целью"
L["Side Arrows"] = "Стрелки по сторонам"
L["Style Filter"] = "Фильтры стиля"
L["Suramar Detection"] = "Сурамарское обнаружение"
L["Tagged NPC"] = "Чужой НИП"
L["Tanked Color"] = "Цвет танкуемого"
L["Target Indicator"] = "Индикатор цели"
L["Target Scale"] = "Масштаб цели";
L["Target, Quest, Combat"] = "Цель, Задание, Бой"
L["Targeted Nameplate"] = "Индиатор цели"
L["Texture"] = "Текстура"
L["These filters don't use a list of spells like the regular filters. Instead they use the WoW API and some code logic to determine if an aura should be allowed or blocked."] = "Эти фильтры не используют список заклинаний, в отличие от обычных фильтро. Вместо этого они используют WoW API и логические операции для определения отображения аур."
L["These filters use a list of spells to determine if an aura should be allowed or blocked. The content of these filters can be modified in the 'Filters' section of the config."] = "Эти фильтры используют списки заклинаний для определения стоит ли блокироват ь ауру. Их можно изменить в разделе 'Фильтры' окна настроек."
L["Threat"] = "Угроза"
L["Time To Hold"] = "Время задержки"
L["Toggle Off While In Combat"] = "Включать в бою"
L["Toggle On While In Combat"] = "Отключить в бою"
L["Top Arrow"] = "Стрелка сверху"
L["Triggers"] = "Триггеры"
L["Under Health Threshold"] = "Менее значения здоровья"
L["Unit in Combat"] = "Юнит в бою"
L["Unit Out of Combat"] = "Юнит вне боя"
L["Unit Type"] = "Тип юнита"
L["Use Class Color"] = "Использовать цвет класса"
L["Use drag and drop to rearrange filter priority or right click to remove a filter."] = "Используйте перетаскивание для смены приоритета или ПКМ для удаления фильтра."
L["Use Portrait"] = "Отображать портрет"
L["Use Static Position"] = "Фиксированная позиция"
L["Use Tanked Color when a nameplate is being effectively tanked by another tank."] = "Использовать этот цвет для юнитов, которых держит другой танк."
L["Use Target Glow"] = "Использовать выделение цели"
L["Use Target Scale"] = "Масштабирование цели"
L["Use Threat Color"] = "Использовать цвет угрозы"
L["When enabled the nameplate will stay visible in a locked position."] = "Если включено, то индикатор игрока будет оставаться видимым на фиксированной позиции."
L["You can't remove a default name from the filter, disabling the name."] = "Вы не можете удалить имя по умолчанию из фильтра, отключаю имя."

--Profiles Export/Import
L["Aura Filters"] = "Фильтры аур"
L["Choose Export Format"] = "Выберите формат экспорта"
L["Choose What To Export"] = "Выберите что экспортировать"
L["Decode Text"] = "Декодировать"
L["Error decoding data. Import string may be corrupted!"] = "Ошибка при кодировании. Импортируемая строка может быть повреждена!"
L["Error exporting profile!"] = "Ошибка при экспорте профиля!"
L["Export Now"] = "Экспортировать"
L["Export Profile"] = "Экспорт профиля"
L["Exported"] = "Экспортировано"
L["Filters (All)"] = "Фильтры (Все)"
L["Filters (NamePlates)"] = "Фильтры (Индикаторы здоровья)"
L["Filters (UnitFrames)"] = "Фильтры (Рамки юнитов)"
L["Global (Account Settings)"] = "Глобальные (настройки аккаунта)"
L["Import Now"] = "Импортировать"
L["Import Profile"] = "Импорт профиля"
L["Importing"] = "Импортирую"
L["NamePlate Style Filters"] = "Фильтры стилей индикаторов здоровья"
L["Plugin"] = "Плагин"
L["Private (Character Settings)"] = "Private (Настройки персонажа)"
L["Profile imported successfully!"] = "Профиль успешно импортирован!"
L["Profile Name"] = "Имя профиля"
L["Profile"] = "Профиль"
L["Table"] = "Таблица"

--Skins
L["Achievement Frame"] = "Достижения"
L["AddOn Manager"] = "Модификации"
L["Alert Frames"] = "Предупреждения"
L["Archaeology Frame"] = "Археология"
L["Auction Frame"] = "Аукцион"
L["Barbershop Frame"] = "Парикмахерская"
L["BG Map"] = "Карта ПБ"
L["BG Score"] = "Таблица ПБ"
L["Black Market AH"] = "Черный Рынок"
L["Calendar Frame"] = "Календарь"
L["Character Frame"] = "Окно персонажа"
L["Contribution"] = "Вклад"
L["Death Recap"] = "Информация о смерти"
L["Debug Tools"] = "Инструменты отладки"
L["Gossip Frame"] = "Диалоги"
L["Guild Control Frame"] = "Управление гильдией"
L["Guild Frame"] = "Гильдия"
L["Guild Registrar"] = "Регистратор гильдий"
L["Help Frame"] = "Помощь"
L["Inspect Frame"] = "Осмотр"
L["Item Upgrade"] = "Улучшение предметов"
L["KeyBinding Frame"] = "Назначение клавиш"
L["LF Guild Frame"] = "Поиск гильдии"
L["LFG Frame"] = "Поиск группы"
L["Loot Frames"] = "Добыча"
L["Loss Control"] = "Потеря контроля"
L["Macro Frame"] = "Макросы"
L["Mail Frame"] = "Почта"
L["Merchant Frame"] = "Торговец"
L["Mirror Timers"] = "Таймеры"
L["Misc Frames"] = "Прочие фреймы"
L["Non-Raid Frame"] = "Не рейдовые фреймы"
L["Orderhall"] = "Оплот класса"
L["Pet Battle"] = "Битвы питомцев"
L["Petition Frame"] = "Хартия гильдии"
L["PvP Frames"] = "ПвП фреймы"
L["Quest Choice"] = "Выбор задания"
L["Quest Frames"] = "Задания"
L["Raid Frame"] = "Рейд"
L["Skins"] = "Скины"
L["Socket Frame"] = "Инкрустирование"
L["Spellbook"] = "Книга заклинаний"
L["Stable"] = "Стойла"
L["Tabard Frame"] = "Создание накидки"
L["Talent Frame"] = "Таланты"
L["TalkingHead"] = "Говорящая голова"
L["Taxi Frame"] = "Такси"
L["Time Manager"] = "Секундомер"
L["Trade Frame"] = "Обмен"
L["TradeSkill Frame"] = "Профессия"
L["Trainer Frame"] = "Тренер"
L["Transmogrify Frame"] = "Окно трансмогрификации"

--Tooltip
L["Always Hide"] = "Всегда скрывать"
L["Bags Only"] = "Только в сумках"
L["Bags/Bank"] = "Сумки/Банк"
L["Bank Only"] = "Только в банке"
L["Both"] = "Оба"
L["Choose when you want the tooltip to show. If a modifer is chosen, then you need to hold that down to show the tooltip."] = "Выберите, когда Вы хотите видеть подсказку. Если выбран модификатор, то подсказка будет показана только, если он зажат."
L["Comparison Font Size"] = "Размер шрифта сравнения"
L["Cursor Anchor"] = "Около курсора"
L["Custom Faction Colors"] = "Свои цвета отношения"
L["Display guild ranks if a unit is guilded."] = "Отображать ранг в гильдии."
L["Display how many of a certain item you have in your possession."] = "Отображать количество предметов в сумках"
L["Display player titles."] = "Отображать звания"
L["Display the players talent spec and item level in the tooltip, this may not immediately update when mousing over a unit."] = "Показывать специализацию и уровень предметов в подсказке. Может обновиться не сразу после наведения курсора."
L["Display the spell or item ID when mousing over a spell or item tooltip."] = "Отображать ID заклинания или предмета в подсказке при наведении мыши."
L["Guild Ranks"] = "Ранги гильдии"
L["Header Font Size"] = "Размер шрифта заголовка"
L["Health Bar"] = "Полоса здоровья"
L["Hide tooltip while in combat."] = "Скрывать подсказку в бою"
L["Inspect Info"] = "Информация осмотра"
L["Item Count"] = "Кол-во предметов"
L["Never Hide"] = "Никогда не скрывать"
L["Player Titles"] = "Звания игроков"
L["Should tooltip be anchored to mouse cursor"] = "Привязывает подсказку к курсору мыши."
L["Spell/Item IDs"] = "ID заклинаний/предметов"
L["Target Info"] = "Информация о цели"
L["Text Font Size"] = "Размер шрифта текста"
L["This setting controls the size of text in item comparison tooltips."] = "Эта опция контролирует размер текста подсказок сравнения предметов."
L["Tooltip Font Settings"] = "Шрифты подсказок"
L["When in a raid group display if anyone in your raid is targeting the current tooltip unit."] = "В рейдовой группе отображать выбравших в цель юнит, для которого показана подсказка"

--UnitFrames
L["%s and then %s"] = "%s, а затем %s"
L["2D"] = '2D'
L["3D"] = '3D'
L["Above"] = "Сверху"
L["Absorbs"] = "Поглощения"
L["Add a spell to the filter. Use spell ID if you don't want to match all auras which share the same name."] = "Добавить заклинание в фильтр. Используйте ID, если вы не хотите фильтровать все заклинания с одинаковым именем."
L["Add a spell to the filter."] = "Добавить заклинание в фильтр"
L["Add Spell ID or Name"] = "Добавить ID или имя заклинания"
L["Add SpellID"] = "Добавить ID заклинания"
L["Additional Filter Override"] = "Принудительный доп. фильтр."
L["Additional Filter"] = "Дополнительный фильтр"
L["Additional Power Text"] = "Текст дополнительного ресурса"
L["Allow auras considered to be part of a boss encounter."] = "Разрешить считать ауры частью боя с боссом"
L["Allow Boss Encounter Auras"] = "Разрешить ауры битв с боссами"
L["Allow non-personal auras from additional filter when 'Block Non-Personal Auras' is enabled."] = "Пропускает не личные ауры из дополнительного фильтра, когда включено блокирование не персональных аур."
L["Allow Whitelisted Auras"] = "Разрешиь ауры из белого списка"
L["An X offset (in pixels) to be used when anchoring new frames."] = "Отступ по оси X (в пикселях) при фиксации новой рамки."
L["An Y offset (in pixels) to be used when anchoring new frames."] = "Отступ по оси Y (в пикселях) при фиксации новой рамки."
L["Anticipation"] = "Предчувствие"
L["Ascending or Descending order."] = "Восходящий или нисходящий порядок."
L["Assist Frames"] = "Помощники"
L["Assist Target"] = "Цели помощников"
L["At what point should the text be displayed. Set to -1 to disable."] = "При каком значении должен показываться текст. Установите -1 для отключения."
L["Attach Text To"] = "Привязать текст к"
L["Attach To"] = "Прикрепить к"
L["Aura Bars"] = "Полосы аур"
L["Auto-Hide"] = "Автоматически скрывать"
L["Bad"] = "Плохое"
L["Bars will transition smoothly."] = "Полосы будут изменяться плавно"
L["Below"] = "Снизу"
L["Blacklist Modifier"] = "Модификатор черного писка"
L["Blacklist"] = "Черный список"
L["Block Auras Without Duration"] = "Блокировать ауры без длительности"
L["Block Blacklisted Auras"] = "Блокировать ауры из черного списка"
L["Block Non-Dispellable Auras"] = "Блокировать не развеиваемые ауры"
L["Block Non-Personal Auras"] = "Блокировать чужие ауры"
L["Borders"] = "Границы"
L["Buff Indicator"] = "Индикатор баффов"
L["Buffs"] = "Баффы"
L["By Type"] = "По типу"
L["Camera Distance Scale"] = "Дистанция камеры"
L["Castbar"] = "Полоса заклинаний"
L["Center"] = "Центр"
L["Check if you are in range to cast spells on this specific unit."] = "Проверять находится ли конкретный юнит в радиюсе действия Ваших заклинаний."
L["Choose UIPARENT to prevent it from hiding with the unitframe."] = "Выберите UIPARENT, чтобы не дать полосе скрываться вместе с рамкой."
L["Class Backdrop"] = "Фон по классу"
L["Class Castbars"] = "Полоса заклинаний по классу"
L["Class Color Override"] = "Принудительный цвет класса"
L["Class Health"] = "Здоровье по классу"
L["Class Power"] = "Ресурс по классу"
L["Class Resources"] = "Ресурсы класса"
L["Click Through"] = "Клик насквозь"
L["Color all buffs that reduce the unit's incoming damage."] = "Окрашивать все баффы, уменьшающие входящий урон по цели."
L["Color aurabar debuffs by type."] = "Окрашивать полосы аур-дебаффов по типу"
L["Color castbars by the class of player units."] = "Окрашивать полосу заклинаний по цвету класса игроков."
L["Color castbars by the reaction type of non-player units."] = "Окрашивать полосу заклинаний по цвету реакции НИП."
L["Color health by amount remaining."] = "Окрашивает полосу здоровья в зависимости от оставшегося его количества."
L["Color health by classcolor or reaction."] = "Окрашивает полосу здоровья по цвету класса или отношению."
L["Color power by classcolor or reaction."] = "Окрашивает полосу ресурсов по цвету класса или реакции."
L["Color the health backdrop by class or reaction."] = "Окрасить фон полосы здоровья по цвету класса или реакции."
L["Color the unit healthbar if there is a debuff that can be dispelled by you."] = "Изменять цвет полосы здоровья, если на юните есть дебафф, который Вы можете снять."
L["Color Turtle Buffs"] = "Окрашивать Turtle Buffs"
L["Colored Icon"] = "Окрашенная иконка"
L["Coloring (Specific)"] = "Окрашивание конкретных"
L["Coloring"] = "Окрашивание"
L["Combat Fade"] = "Скрытие"
L["Combat Icon"] = "Иконка боя"
L["Combo Point"] = "Очко серии"
L["Configure Auras"] = "Настроить Ауры"
L["Copy From"] = "Скопировать из"
L["Count Font Size"] = "Размер шрифта стаков"
L["Create a custom fontstring. Once you enter a name you will be able to select it from the elements dropdown list."] = "Создать свою текстовую строку. После ввода имени вы сможете выбрать её в выпадающем списке"
L["Create a filter, once created a filter can be set inside the buffs/debuffs section of each unit."] = "Создает фильтр. После создания он может быть установлен в секции баффов/дебаффов любого юнита."
L["Create Filter"] = "Создать фильтр"
L["Current - Max | Percent"] = "Текущее - Макс. | Процент"
L["Current - Max"] = "Текущее - Максимальное"
L["Current - Percent"] = "Текущее - Процент"
L["Current / Max"] = "Текущее / Максимальное"
L["Current"] = "Текущее"
L["Custom Dead Backdrop"] = "Свой фон мертвого"
L["Custom Health Backdrop"] = "Свой фон полосы здоровья"
L["Custom Texts"] = "Свой текст"
L["Debuff Highlighting"] = "Подсветка дебаффов"
L["Debuffs"] = "Дебаффы"
L["Decimal Threshold"] = "Десятые доли после..."
L["Deficit"] = "Дефицит"
L["Delete a created filter, you cannot delete pre-existing filters, only custom ones."] = "Удалить созданный фильтр. Вы не можете удалять фильтры по умолчанию, только созданные вручную."
L["Delete Filter"] = "Удалить фильтр"
L["Detach From Frame"] = "Открепить от рамки"
L["Detached Width"] = "Ширина при откреплении"
L["Direction the health bar moves when gaining/losing health."] = "Направление, в котором заполняется полоса при потере/восполнении здоровья."
L["Disable Debuff Highlight"] = "Отключить подсветку дебаффов"
L["Disabled Blizzard Frames"] = "Отключить фреймы Blizzard"
L["Disables the focus and target of focus unitframes."] = "Отключает фреймы фокуса и цели фокуса."
L["Disables the player and pet unitframes."] = "Отклчает фреймы игрока и питомца."
L["Disables the target and target of target unitframes."] = "Отключает фреймы цели и цели цели."
L["Disconnected"] = "Не в сети"
L["Display a spark texture at the end of the castbar statusbar to help show the differance between castbar and backdrop."] = "Отображать свечение на краю полосы заклинаний для более четкого отделения ее от фона."
L["Display Frames"] = "Показать рамки"
L["Display icon on arena frame indicating the units talent specialization or the units faction if inside a battleground."] = "Отображать иконку на рамках арены, показывающую специализацию или фракцию на полях боя."
L["Display Player"] = "Показывать себя"
L["Display Target"] = "Показывать цель"
L["Display Text"] = "Показывать текст"
L["Display the castbar icon inside the castbar."] = "Отображать иконку на полосе заклинаний."
L["Display the castbar inside the information panel, the icon will be displayed outside the main unitframe."] = "Отображать полосу заклинаний на информационной панели, иконка будет отображатсья рядом с рамкой."
L["Display the combat icon on the unitframe."] = "Отображать иконку боя на рамке игрока."
L["Display the rested icon on the unitframe."] = "Отображать иконку отдыха на рамке игрока"
L["Display the target of your current cast. Useful for mouseover casts."] = "Отображать имя цели заклинания на полосе."
L["Display tick marks on the castbar for channelled spells. This will adjust automatically for spells like Drain Soul and add additional ticks based on haste."] = "Отображать метки тиков на полосе заклинаний для поддерживаемых заклинаний. Они будут автоматически масштабироваться для заклинаний вроде Похищения души и добавлять новые тики, основываясь на показателе скорости."
L["Don't display any auras found on the 'Blacklist' filter."] = 'Не отображать ауры, обнаруженные в фильтре "Blacklist".'
L["Don't display auras that are longer than this duration (in seconds). Set to zero to disable."] = "Не отображать ауры длительностью более этого значения (в секундах). Установите на 0 для отключения."
L["Don't display auras that are not yours."] = "Не отображать ауры, наложенные не вами."
L["Don't display auras that are shorter than this duration (in seconds). Set to zero to disable."] = "Не отображать ауры длительностью менее этого значения (в секундах). Установите на 0 для отключения."
L["Don't display auras that cannot be purged or dispelled by your class."] = "Не отображать ауры, которые не могут быть развеяны вашим классом."
L["Don't display auras that have no duration."] = "Не отображать ауры без длительности"
L["Down"] = "Вниз"
L["Duration Reverse"] = "Длительность, обратное"
L["Duration Text"] = "Текст длительности"
L["Duration"] = "Длительность"
L["Enabling this allows raid-wide sorting however you will not be able to distinguish between groups."] = "Включение опции позволит Вам проводить сортировку в пределах всего рейда, но взамен Вы не сможете понять кто в какой группе."
L["Enabling this inverts the grouping order when the raid is not full, this will reverse the direction it starts from."] = "Включение опции инвертирует порядок группировки в неполном рейде, она изменит направление роста и точку его начала."
L["Enemy Aura Type"] = "Тип аур врага"
L["Fade the unitframe when out of combat, not casting, no target exists."] = "Скрывать фрейм, когда Вы вне боя, не произносите заклинаний или отсутствует цель."
L["Fill"] = "Заполнение"
L["Filled"] = "По ширине рамки"
L["Filter Type"] = "Тип фильтра"
L["Fluid Position Buffs on Debuffs"] = "Переменная позиция баффов над дебаффами"
L["Fluid Position Debuffs on Buffs"] = "Переменная позиция дебаффов над баффами"
L["Force Off"] = "Постоянно выключен"
L["Force On"] = "Постоянно включен"
L["Force Reaction Color"] = "Принудительная реакция"
L["Force the frames to show, they will act as if they are the player frame."] = "Принудительно показать рамки, они будут вести себя как рамка игрока."
L["Forces Debuff Highlight to be disabled for these frames"] = "Принудительно не отображает подсветку дебаффов на этих рамках."
L["Forces reaction color instead of class color on units controlled by players."] = "Принудительно окрашивает полосу здоровья по цвету реакции для рамок игроков."
L["Format"] = "Формат"
L["Frame Level"] = "Уровень рамки"
L["Frame Orientation"] = "Направление рамки"
L["Frame Strata"] = "Слой рамки"
L["Frame"] = "Рамка"
L["Frequent Updates"] = "Частое обновление"
L["Friendly Aura Type"] = "Тип аур друга"
L["Friendly"] = "Дружественный"
L["Glow"] = "Свечение"
L["Good"] = "Хорошее"
L["Group By"] = "Группировать по"
L["Grouping & Sorting"] = "Группировка и сортировка"
L["Groups Per Row/Column"] = "Групп на ряд/столбец"
L["Growth direction from the first unitframe."] = "Направление роста от первого фрейма."
L["Growth Direction"] = "Направление роста"
L["Heal Absorbs"] = "Поглощение исцеления"
L["Heal Prediction"] = "Входящее исцеление"
L["Health Backdrop"] = "Фон полосы здоровья"
L["Health Border"] = "Граница здоровья"
L["Health By Value"] = "Здоровье по значению"
L["Health"] = "Здоровье"
L["Height"] = "Высота"
L["Horizontal Spacing"] = "Отступ по горизонтали"
L["Horizontal"] = "Горизонтально" --Also used in bags module
L["How far away the portrait is from the camera."] = "Как далеко от персонажа находится камера."
L["Icon Inside Castbar"] = "Иконка на полосе"
L["Icon Size"] = "Размер иконки"
L["Icon"] = "Иконка"
L["Icon: BOTTOM"] = "Иконка: внизу"
L["Icon: BOTTOMLEFT"] = "Иконка: внизу слева"
L["Icon: BOTTOMRIGHT"] = "Иконка: внизу справа"
L["Icon: LEFT"] = "Иконка: слева"
L["Icon: RIGHT"] = "Иконка: справа"
L["Icon: TOP"] = "Иконка: вверху"
L["Icon: TOPLEFT"] = "Иконка: вверху слева"
L["Icon: TOPRIGHT"] = "Иконка: вверху справа"
L["If no other filter options are being used then it will block anything not on the 'Whitelist' filter, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = 'Если не используется никакой другой фильтр, то будут блокироваться ауры вне фильтра "Whitelist". В противном случае будет просто добавлять ауры в белый список в дополнение к другим опциям фильтрации.'
L["If not set to 0 then override the size of the aura icon to this."] = "Если установлено не на 0, то устанавливать размер иконок аур на заданное число."
L["If the unit is an enemy to you."] = "Если юнит враждебен вам."
L["If the unit is friendly to you."] = "Если юнит дружественен к вам."
L["If you have a lot of 3D Portraits active then it will likely have a big impact on your FPS. Disable some portraits if you experience FPS issues."] = "Если у вас активно много 3D портретов, то это может сказаться на производительности. Отключите их на каких-нибудь фреймах, если заметите проблемы."
L["Ignore mouse events."] = "Игнорировать мышь"
L["InfoPanel Border"] = "Граница инфо панели"
L["Information Panel"] = "Информационная панель"
L["Inset"] = "Внутри"
L["Inside Information Panel"] = "На инфо панели"
L["Interruptable"] = "Прерываемые"
L["Invert Grouping Order"] = "Инвертировать порядок группировки"
L["JustifyH"] = "Выравнивание"
L["Latency"] = "Задержка"
L["Left to Right"] = "Слева направо"
L["Main statusbar texture."] = "Основная текстура полос состояния (здоровье, ресурс и тд)."
L["Main Tanks / Main Assist"] = "Танки/помощники"
L["Make textures transparent."] = "Сделать текстуры прозрачными"
L["Match Frame Width"] = "По ширине рамки"
L["Max amount of overflow allowed to extend past the end of the health bar."] = "Максимальное значение переполнения, которое может отображаться за пределами полосы здровья."
L["Max Bars"] = "Максимум полос"
L["Max Overflow"] = "Макс. переполнение"
L["Maximum Duration"] = "Максимальная длительность"
L["Method to sort by."] = "Метод сортировки."
L["Middle Click - Set Focus"] = "Средний клик - фокус"
L["Middle clicking the unit frame will cause your focus to match the unit."] = "Нажатие средней кнопкой мыши на фрейм юнита запомнит его в фокус."
L["Middle"] = "Центр"
L["Minimum Duration"] = "Минимальная длительность"
L["Model Rotation"] = "Вращение модели"
L["Mouseover"] = "При наведении"
L["Name"] = "Имя" --Also used in Buffs and Debuffs
L["Neutral"] = "Нейтральный"
L["Non-Interruptable"] = "Непрерываемые"
L["Not valid spell id"] = "Неверный ID заклинания"
L["Num Rows"] = "Рядов"
L["Number of Groups"] = "Количество групп"
L["Offset of the powerbar to the healthbar, set to 0 to disable."] = "Смещение полосы ресурсов относительно полосы здоровья. Установите на 0 для отключения."
L["Offset position for text."] = "Отступ для текста."
L["Offset"] = "Смещение"
L["OOR Alpha"] = "Прозрачность вне радиуса"
L["Others"] = "Чужое"
L["Overlay the healthbar"] = "Отображение портрета на полосе здоровья."
L["Overlay"] = "Наложение"
L["Override any custom visibility setting in certain situations, EX: Only show groups 1 and 2 inside a 10 man instance."] = "Игнорировать пользовательские настройки отображения в определенных ситуациях. Пример: показывать только группы 1 и 2 в подземелье на 10 человек."
L["Override the default class color setting."] = "Перекрывает установки цвета класса по умолчанию."
L["Owners Name"] = "Имя хозяина"
L["Parent"] = "Родитель"
L["Party Pets"] = "Питомцы группы"
L["Party Targets"] = "Цели группы"
L["Per Row"] = "Кол-во в ряду"
L["Percent"] = "Процент"
L["Personal"] = "Свое"
L["Pet Name"] = "Имя питомца"
L["Player Frame Aura Bars"] = "Полосы аур рамки игрока"
L["Portrait"] = "Портрет"
L["Position Buffs on Debuffs"] = "Баффы на месте дебаффов"
L["Position Debuffs on Buffs"] = "Дебаффы на месте баффов"
L["Position the Model horizontally."] = "Позиционирование модели по горизонтали."
L["Position the Model vertically."] = "Позиционирование модели по вертикали."
L["Position"] = "Позиция"
L["Power text will be hidden on NPC targets, in addition the name text will be repositioned to the power texts anchor point."] = "Текст ресурса будет спрятан для НИП. Также текст имени будет смещен в точку расположения текста ресурса."
L["Power"] = "Ресурс"
L["Powers"] = "Ресурсы"
L["Priority"] = "Приоритет"
L["Profile Specific"] = "По профилю"
L["PvP & Prestige Icon"] = "Иконки PvP и престижа"
L["PvP Text"] = "Текст PvP"
L["PVP Trinket"] = "ПвП Аксессуар"
L["Raid Icon"] = "Рейдовая иконка"
L["Raid-Wide Sorting"] = "Общерейдовая сортировка"
L["Raid40 Frames"] = "Рейд 40"
L["RaidDebuff Indicator"] = "Индикатор рейдовых дебаффов"
L["Range Check"] = "Проверка дистанции"
L["Rapidly update the health, uses more memory and cpu. Only recommended for healing."] = "Более частое обновление состояния здоровья, использует больше памяти и ресурсов процессора. Рекомендуется только для целителей."
L["Reaction Castbars"] = "Полоса заклинаний по реакции"
L["Reactions"] = "Отношение"
L["Ready Check Icon"] = "Иконка готовности"
L["Remaining"] = "Оставшееся"
L["Remove a spell from the filter. Use the spell ID if you see the ID as part of the spell name in the filter."] = "Удалить заклинание из фильтра. Используйте ID, если в фильтре имя удаляемого заклинания содержит ID."
L["Remove a spell from the filter."] = "Удалить заклинание из фильтра."
L["Remove Spell ID or Name"] = "Удалить ID или имя заклинания"
L["Remove SpellID"] = "Удалить ID заклинания"
L["Rest Icon"] = "Иконка отдыха"
L["Restore Defaults"] = "Восстановить умолчания" --Also used in Media and ActionBars sections
L["Right to Left"] = "Справа налево"
L["RL / ML Icons"] = "Иконки лидера/ответственного"
L["Role Icon"] = "Иконка роли"
L["Seconds remaining on the aura duration before the bar starts moving. Set to 0 to disable."] = "Полоса начнет убывать, когда оставшееся время ауры упадет ниже этого значения в секундах. Установите на 0 для отключения."
L["Select a unit to copy settings from."] = "Выберите юнит, установки которого Вы хотите скопировать."
L["Select an additional filter to use. If the selected filter is a whitelist and no other filters are being used (with the exception of Block Non-Personal Auras) then it will block anything not on the whitelist, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = 'Выберите дополнительный фильтр для использования. Если выбраный фильтр имеет тип "белый список" и не используется никакой другой фильтр (за исключением блокиования чужих аур), то будут блокироваться ауры вне белого списка. В противном случае будет просто добавлять ауры в белый список в дополнение к другим опциям фильтрации.'
L["Select Filter"] = "Выбрать фильтр"
L["Select Spell"] = "Выбрать заклинание"
L["Select the display method of the portrait."] = "Выбирите метод отображения портрета"
L["Set the filter type. Blacklist will hide any auras in the list and show all others. Whitelist will show any auras in the filter and hide all others."] = "Выберите тип фильтра. Черный список будет скрывать содержащиеся заклинания и отображать остальные. Белый список будет показывать включенные заклинания и скрывать все остальные."
L["Set the font size for unitframes."] = "Устанавливает шрифт для рамок юнитов."
L["Set the order that the group will sort."] = "Устанавливает метод сортировки в группе."
L["Set the orientation of the UnitFrame."] = "Устанавливает ориентацию рамки."
L["Set the priority order of the spell, please note that prioritys are only used for the raid debuff module, not the standard buff/debuff module. If you want to disable set to zero."] = "Устанавливает порядок заклинания. Заметьте, что приоритеты используются только для модуля рейдовых дебаффов, а не для стандартных баффов/дебаффов. Для отключения приоритетности установите на 0."
L["Set the type of auras to show when a unit is a foe."] = "Устанавливает тип аур для отображения, когда юнит враг."
L["Set the type of auras to show when a unit is friendly."] = "Устанавливает тип аур для отображения, когда юнит друг."
L["Sets the font instance's horizontal text alignment style."] = "Устанавливает выравнивание текста по горизонтали"
L["Show a incomming heal prediction bar on the unitframe. Also display a slightly different colored bar for incoming overheals."] = "Отображать объем входящего исцеления на рамках. Также отображает немного иначе окрашенную полосу для избыточного исцеления."
L["Show Aura From Other Players"] = "Отображать чужие"
L["Show Auras"] = "Показать ауры"
L["Show Dispellable Debuffs"] = "Показывать развеиваемые дебаффы"
L["Show For DPS"] = "Показывать для бойцов"
L["Show For Healers"] = "Показывать для лекарей"
L["Show For Tanks"] = "Показывать для танков"
L["Show When Not Active"] = "Показывать при отсутствии"
L["Size and Positions"] = "Размер и позиция"
L["Size of the indicator icon."] = "Размер иконки индикатора"
L["Size Override"] = "Свой размер"
L["Size"] = "Размер"
L["Smart Aura Position"] = "Умная позиция аур"
L["Smart Raid Filter"] = "Умный фильтр рейда"
L["Smooth Bars"] = "Плавные полосы"
L["Sort By"] = "Сортировать по"
L["Spaced"] = "Раздельно"
L["Spacing"] = "Отступ"
L["Spark"] = "Искра"
L["Spec Icon"] = "Иконка специализации"
L["Stack Counter"] = "Количество стаков"
L["Stack Threshold"] = "Стаки"
L["Start Near Center"] = "Начинать от центра"
L["Statusbar Fill Orientation"] = "Направление заполнения полосы"
L["StatusBar Texture"] = "Текстура полос состояния"
L["Strata and Level"] = "Слой и уровень"
L["Style"] = "Стиль"
L["Tank Frames"] = "Танки"
L["Tank Target"] = "Цели танков"
L["Tapped"] = "Чужой"
L["Target Glow"] = "Подсветка цели"
L["Target On Mouse-Down"] = "Выделение при нажати"
L["Target units on mouse down rather than mouse up. \n\n|cffFF0000Warning: If you are using the addon 'Clique' you may have to adjust your clique settings when changing this."] = "Выделять при нажатии кнопки мыши, а не при ее отпускании.\n\n|cffFF0000Внимание: Если Вы используете аддон 'Clique', то Вы также должны изменить его настройки при изменении этой."
L["Text Color"] = "Цвет текста"
L["Text Format"] = "Формат текста"
L["Text Position"] = "Позиция текста"
L["Text Threshold"] = "Значение текста"
L["Text Toggle On NPC"] = "Переключение текста для НИП"
L["Text xOffset"] = "Отсуп текста по Х"
L["Text yOffset"] = "Отсуп текста по Y"
L["Text"] = "Текст"
L["Textured Icon"] = "Иконка с текстурой"
L["The alpha to set units that are out of range to."] = "Прозрачность рамок юнитов, находящихся вне дальности действия заклинаний."
L["The debuff needs to reach this amount of stacks before it is shown. Set to 0 to always show the debuff."] = "Для показа этого дебаффа, он должен надрать указанное количество стаков. Пи установке на 0, показывается всегда."
L["The following macro must be true in order for the group to be shown, in addition to any filter that may already be set."] = "Следующий фильтр должен быть верен для отображения группы в дополнение к любому другому уже установленному фильтру."
L["The font that the unitframes will use."] = "Шрифт рамок юнитов"
L["The initial group will start near the center and grow out."] = "Первая группа появится в центре и будет расти наружу."
L["The name you have selected is already in use by another element."] = "Выбранное вами имя уже используется другим элементом"
L["The object you want to attach to."] = "Объект, к которому Вы хотите прикрепить полосы"
L["Thin Borders"] = "Тонкие границы"
L["This dictates the size of the icon when it is not attached to the castbar."] = "Определяет размер иконки, когда она не привязана к инфо панели."
L["This opens the UnitFrames Color settings. These settings affect all unitframes."] = "Открывает опции окрашивания рамок юнитов. Эти настройки влияют на все рамки."
L["Threat Display Mode"] = "Режим отображения угрозы"
L["Threshold before text goes into decimal form. Set to -1 to disable decimals."] = "Граница, после которых текст будет показывать десятые доли. Установите на -1 для отключения."
L["Ticks"] = "Тики"
L["Time Remaining Reverse"] = "Оставшееся время, обратное"
L["Time Remaining"] = "Оставшееся время"
L["Transparent"] = "Прозрачный"
L["Turtle Color"] = "Цвет Turtle Buffs"
L["Uniform Threshold"] = "Граница убывания"
L["UnitFrames"] = "Рамки юнитов"
L["Up"] = "Вверх"
L["Use Custom Level"] = "Свой уровень"
L["Use Custom Strata"] = "Свой слой"
L["Use Dead Backdrop"] = "Фон мертвого"
L["Use Default"] = "Использовать умолчания"
L["Use the custom health backdrop color instead of a multiple of the main health color."] = "Использовать свой фоновый цвет вместо основного цвета полосы здоровья."
L["Use the profile specific filter 'Buff Indicator (Profile)' instead of the global filter 'Buff Indicator'."] = "Использовать фильтр \"Buff Indicator (Profile)\", привязанный к профилю вместо глобального."
L["Use thin borders on certain unitframe elements."] = "Использовать тонкие границы на некоторых элементах рамок юнитов."
L["Use this backdrop color for units that are dead or ghosts."] = "Использовать этот цвет фона для юнитов, которые мертвы или бегут с кладбища."
L["Value must be a number"] = "Значение должно быть числом"
L["Vertical Orientation"] = "Заполнение по вертикали"
L["Vertical Spacing"] = "Отступ по вертикали"
L["Vertical"] = "Вертикально" --Also used in bags section
L["Visibility"] = "Видимость"
L["What point to anchor to the frame you set to attach to."] = "К какой точке выбранного фиксатора прикрепить ауры."
L["What to attach the buff anchor frame to."] = "К чему прикреплять баффы."
L["What to attach the debuff anchor frame to."] = "К чему прикреплять дебаффы."
L["When true, the header includes the player when not in a raid."] = "Отображать игрока в группе."
L["Whitelist"] = "Белый список"
L["Width"] = "Ширина" --Also used in NamePlates module
L["Will show Buffs in the Debuff position when there are no Debuffs active, or vice versa."] = "При отсутствии дебаффов, будет показывать баффы на их месте или наоборот."
L["xOffset"] = "Отступ по Х"
L["yOffset"] = "Отступ по Y"
L["You can't remove a pre-existing filter."] = "Вы не можете удалить фильтр по умолчанию."
L["You cannot copy settings from the same unit."] = "Вы не можете копировать установки из того же юнита."
L["You may not remove a spell from a default filter that is not customly added. Setting spell to false instead."] = "Вы не можете удалить заклинание из фильтра по умолчанию, которое не было добавлено в него вручную. Отключаю использование в фильтре этого заклинания."
L["You need to hold this modifier down in order to blacklist an aura by right-clicking the icon. Set to None to disable the blacklist functionality."] = "Вам нужно будет удерживать этот модификатор для занесения ауры в черный список при нажатии ПКМ. Установите на \"Нет\" для отключения возможности заносить их туда."
