-- German localization file for deDE.
local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("ElvUI", "deDE")
if not L then return end

-- *_DESC locales
L["AURAS_DESC"] = "Konfiguriere die Symbole für die Stärkungs- und Schwächungszauber nahe der Minimap."
L["BAGS_DESC"] = "Konfiguriere die Einstellungen für die Taschen."
L["CHAT_DESC"] = "Anpassen der Chateinstellungen für ElvUI."
L["DATATEXT_DESC"] = "Bearbeite die Anzeige der Infotexte."
L["ELVUI_DESC"] = "ElvUI ist ein komplettes Benutzerinterface für World of Warcraft."
L["NAMEPLATE_DESC"] = "Konfiguriere die Einstellungen für die Namensplaketten."
L["UNITFRAME_DESC"] = "Konfiguriere die Einstellungen für die Einheitenfenster."
L["ACTIONBARS_DESC"] = "Konfiguriere die Einstellungen für die Aktionsleisten."
L["PANEL_DESC"] = "Stellt die Größe der linken und rechten Leisten ein, dies hat auch Einfluss auf den Chat und die Taschen."
L["SKINS_DESC"] = "Passe die Einstellungen für externe Addon Skins/Optionen an."
L["TOGGLESKIN_DESC"] = "Aktiviere/Deaktiviere diesen Skin."
L["TOOLTIP_DESC"] = "Konfiguriere die Einstellungen für Tooltips."
L["SEARCH_SYNTAX_DESC"] = [=[Mit der Ergänzung von LibItemSearch, kannst du jetzt erweitert nach Gegenständen suchen. Nachfolgend findest du eine Dokumentation des Suchsyntax. Die volle Erklärung findest du hier: https://github.com/Jaliborc/LibItemSearch-1.2/wiki/Search-Syntax.

Spezifische Suche:
    • q:[quality] oder quality:[quality]. Beispielsweise q:episch findet alle epischen Gegenstände.
    • l:[level], lvl:[level] oder level:[level]. Zum Beispiel: l:30 findet alle Gegenstände mit Level 30.
    • t:[suche], type:[suche] oder slot:[suche]. Beispielsweise t:waffe findet alle Waffen.
    • n:[name] oder name:[name]. Beispielsweise wenn du n:muffins eintippst, findest du alle Gegenstände die "muffins" im Namen haben.
    • s:[set] oder set:[set]. Zum Beispiel: s:feuer findet alle Gegenstände eines Ausrüstungssets mit Feuer im Namen.
    • tt:[suche], tip:[suche] oder tooltip:[suche]. Beispielsweise tt:gebunden findet alle Gegenstände die am Account, beim Aufheben oder beim Ausrüsten gebunden sind.


Suchoperatoren:
    • ! : Negiert eine Suche. Zum Beispiel !q:episch findet alle Gegenstände die NICHT episch sind.
    • | : Kombiniert zwei Suchen. q:episch | t:waffe findet alle Gegenstände die episch ODER Waffen sind.
    • & : Teilt zwei Suchen. Beispielsweise q:episch & t:waffen findet alle Gegenstände die episch UND Waffen sind.
    • >, <, <=, => : Führt eine numerische Suche durch. Zum Beispiel: lvl: >30 findet alle Gegenstände mit Level 30 oder HÖHER.


Die folgenden Suchbegriffe können auch benutzt werden:
    • soulbound, bound, bop : Beim Aufheben gebundene Gegenstände.
    • bou : Beim Benutzen gebundene Gegenstände.
    • boe : Beim Ausrüsten gebundene Gegenstände.
    • boa : An den Account gebundene Gegenstände.
    • quest : Gebundene Quest Gegenstände.
    • reagents, reagent, crafting : Berufs Reagenzien.
    • naval : Schiffsausrüstung.
    • follower, followe, follow : Anhänger Gegenstände.
    • relic, reli, rel : Artefakt Relikte.
    • power, powe, pow : Gegenstände die Artefaktkraft gewähren.]=];
L["TEXT_FORMAT_DESC"] = [=[Wähle eine Zeichenfolge um das Textformat zu ändern.

Beispiele:
[namecolor][name] [difficultycolor][smartlevel] [shortclassification]
[healthcolor][health:current-max]
[powercolor][power:current]

Leben / Kraft Formate:
'current' - Aktueller Wert
'percent' - Prozentualer Wert
'current-max' - Aktueller Wert gefolgt von dem maximalen Wert. Es wird nur der Maximale Wert anzeigt, wenn der aktuelle Wert auch das Maximum ist
'current-percent' - Aktueller Wert gefolgt von dem prozentualen Wert. Es wird nur der maximale Wert angezeigt, wenn der aktuelle Wert auch das Maximum ist
'current-max-percent' - Aktueller Wert, Maximaler Wert, gefolgt von dem prozentualen Wert. Es wird nur der maximale Wert angezeigt, wenn der aktuelle Wert auch das Maximum ist
'deficit' - Zeigt das Defizit. Es wird nichts angezeigt, wenn kein Defizit vorhanden ist

Namensformate:
'name:short' - Name auf 10 Zeichen beschränkt
'name:medium' - Name auf 15 Zeichen beschränkt
'name:long' - Name auf 20 Zeichen beschränkt

Zum Deaktvieren lasse das Feld leer. Brauchst du mehr Informationen besuche http://www.tukui.org]=];

--ActionBars
L["Action Paging"] = "Seitenwechsel der Aktionsleisten"
L["ActionBars"] = "Aktionsleisten"
L["Allow Masque to handle the skinning of this element."] = "Erlaubt Masque das Gestalten dieser Elememte."
L["Alpha"] = "Alpha"
L["Anchor Point"] = "Ankerpunkt" --also in unitframes
L["Automatic"] = "Automatisch"
L["Backdrop Spacing"] = "Hintergrund Abstand"
L["Backdrop"] = "Hintergrund"
L["Button Size"] = "Größe der Tasten" --Also used in Bags
L["Button Spacing"] = "Abstand der Tasten" --Also used in Bags
L["Buttons Per Row"] = "Tasten pro Zeile"
L["Buttons"] = "Tasten"
L["Change the alpha level of the frame."] = "Ändere den Alphakanal des Fensters."
L["Color of the actionbutton when not usable."] = "Farbe der Aktionsleisten wenn nicht nutzbar."
L["Color of the actionbutton when out of power (Mana, Rage, Focus, Holy Power)."] = "Die Farbe der Aktionstasten, wenn keine Kraft, wie z.B. Mana, Wut, Fokus oder Heilige Kraft, mehr vorhanden ist."
L["Color of the actionbutton when out of range."] = "Die Farbe der Aktionstasten, wenn das Ziel außer Reichweite ist."
L["Color of the actionbutton when usable."] = "Farbe der Aktionsleisten wenn nutzbar."
L["Color when the text is about to expire"] = "Färbe den Text in dieser Farbe, wenn er in Kürze abläuft."
L["Color when the text is in the days format."] = "Färbe den Text in dieser Farbe, wenn er Tagen angezeigt wird."
L["Color when the text is in the hours format."] = "Färbe den Text in dieser Farbe, wenn er in Stunden angezeigt wird."
L["Color when the text is in the minutes format."] = "Färbe den Text in dieser Farbe, wenn er sich im Minutenformat angezeigt wird."
L["Color when the text is in the seconds format."] = "Färbe den Text in dieser Farbe, wenn er in Sekunden angezeigt wird."
L["Cooldown Text"] = "Abklingzeittext"
L["Darken Inactive"] = "Inaktives verdunkeln"
L["Days"] = "Tage"
L["Display bind names on action buttons."] = "Zeige Tastaturbelegungen auf der Aktionsleiste an."
L["Display cooldown text on anything with the cooldown spiral."] = "Zeige die Abklingzeit auf allen Tasten mit Hilfe iner animierten Spirale."
L["Display macro names on action buttons."] = "Zeige Makronamen auf der Aktionsleiste an."
L["Expiring"] = "Auslaufend"
L["Flyout Direction"] = "Ausklapprichtung"
L["Global Fade Transparency"] = "Globales Transparenz verblassen"
L["Height Multiplier"] = "Höhenmultiplikator"
L["Hide Cooldown Bling"] = "Versteckt das Abklingzeitsleuchten"
L["Hides the bling animation on buttons at the end of the global cooldown."] = "Versteckt das Leuchten auf den Tasten am Ende der globalen Abklingzeit."
L["Hours"] = "Stunden"
L["If you unlock actionbars then trying to move a spell might instantly cast it if you cast spells on key press instead of key release."] = "Wenn du die Aktionsleisten entsperrst und versuchst einen Zauber zu verschieben, wird voraussichtlich der Zauber ausgelöst beim drücken anstatt beim loslassen der Taste."
L["Inherit Global Fade"] = "Globales verblassen vererben"
L["Inherit the global fade, mousing over, targetting, setting focus, losing health, entering combat will set the remove transparency. Otherwise it will use the transparency level in the general actionbar settings for global fade alpha."] = "Vererbt das globale Verblassen, mouseover, anvisieren, Focus setzen, Gesundheit verlieren, Kampf betreten wird die Transparenz entfernen. Andernfalls wird das Transparenzlevel, in den allgemeinen Einstellungen der Aktionsleisten, globales verblassen Alpha verwendet."
L["Key Down"] = "Aktion bei Tastendruck"
L["Keybind Mode"] = "Tastaturbelegung"
L["Keybind Text"] = "Tastaturbelegungstext"
L["Low Threshold"] = "Niedrige CD-Schwelle"
L["Macro Text"] = "Makrotext"
L["Masque Support"] = "Masque Unterstützung"
L["Minutes"] = "Minuten"
L["Mouse Over"] = "Mouseover" --Also used in Bags
L["Multiply the backdrops height or width by this value. This is usefull if you wish to have more than one bar behind a backdrop."] = "Multipliziere die Höhe und die Breite des Hintergrundes. Das ist nützlich, wenn du mehr als eine Leiste hinter einem Hintergrund haben möchtest."
L["Not Usable"] = "Nicht nutzbar"
L["Out of Power"] = "Keine Kraft"
L["Out of Range"] = "Außer Reichweite"
L["Restore Bar"] = "Leiste zurücksetzen"
L["Restore the actionbars default settings"] = "Wiederherstellung der vordefinierten Aktionsleisteneinstellung"
L["Seconds"] = "Sekunden"
L["Show Empty Buttons"] = "Zeige leere Tasten"
L["Shows a swipe animation when a spell is recharging but still has charges left."] = "Zeigt eine 'Swipe' Animation wenn ein Zauber am Aufladen ist aber immer noch Aufladungen hat." -- not a really good translation for 'Swipe'
L["The amount of buttons to display per row."] = "Anzahl der Aktionstasten in einer Reihe."
L["The amount of buttons to display."] = "Anzahl der angezeigten Aktionstasten."
L["The button you must hold down in order to drag an ability to another action button."] = "Die Taste, die du gedrückt halten musst, um eine Fähigkeit zu einer anderen Aktionstaste zu ziehen."
L["The first button anchors itself to this point on the bar."] = "Der erste Aktionstaste dockt an diesen Punkt in der Leiste an."
L["The size of the action buttons."] = "Die Größe der Aktionstasten."
L["The spacing between the backdrop and the buttons."] = "Der Abstand zwischen dem Hintergrund und den Tasten."
L["This setting will be updated upon changing stances."] = "Diese Einstellungen werden bei Gestaltwandel aktualisiert"
L["Threshold before text turns red and is in decimal form. Set to -1 for it to never turn red"] = "CD-Schwelle bevor der Text rot wird. Setze diesen Wert auf -1, wenn er nie rot werden soll"
L["Toggles the display of the actionbars backdrop."] = "Aktiviere den Hintergrund der Aktionsleisten."
L["Transparency level when not in combat, no target exists, full health, not casting, and no focus target exists."] = "Transparenz Level wenn nicht im Kampf, kein Ziel ausgewählt, volle Gesundheit, nicht am Zaubern und kein Fokus existiert."
L["Usable"] = "Nutzbar"
L["Use Draw Swipe"] = "Benutze Draw Swipe" -- really bad
L["Use Position Override"] = "Benutze Überschreibung der Position"
L["Visibility State"] = "Sichbarkeitszustand"
L["When enabled it will use the Anchor Point setting to determine growth direction, otherwise it will be determined by where the bar is positioned."] = "Wenn aktiviert, wird der Ankerpunkt benutzt um die Wachstumsrichtung festzulegen. Andernfalls wird festgelegt wo die Leiste positioniert ist."
L["Width Multiplier"] = "Breitenmultiplikator"
L["Zone Ability"] = "Zonen Fähigkeit"
L[ [=[This works like a macro, you can run different situations to get the actionbar to page differently.
 Example: '[combat] 2;']=] ] = [=[Dieses funktioniert wie ein Makro, du kannst verschiedene Situationen haben um die Aktionsleiste zu wechseln.
 Beispiel: '[combat] 2;']=]
L[ [=[This works like a macro, you can run different situations to get the actionbar to show/hide differently.
 Example: '[combat] show;hide']=] ] = [=[Dieses funktioniert wie ein Makro, du kannst verschiedene Situationen haben um die Aktionsleiste ein-/auszublenden.
 Beispiel: '[combat] show;hide']=]

--Bags
L["Add an item or search syntax to the ignored list. Items matching the search syntax will be ignored."] = "Füge ein Gegenstand oder ein Suchoperator zu der Ignorierliste hinzu. Gegenstände die auf den Suchoperator zutreffen werden ignoriert."
L["Add Item or Search Syntax"] = "Füge Gegenstand oder Suchoperator hinzu"
L["Adjust the width of the bag frame."] = "Passe die Breite des Taschenfensters an."
L["Adjust the width of the bank frame."] = "Passe die Breite des Bankfensters an."
L["Ascending"] = "Aufsteigend"
L["Bag Sorting"] = "Taschen Sortierung"
L["Bag-Bar"] = "Taschenleiste"
L["Bar Direction"] = "Ausrichtung Leiste"
L["Blizzard Style"] = "Blizzard Stil"
L["Bottom to Top"] = "Von unten nach oben"
L["Button Size (Bag)"] = "Tasten Größe (Tasche)"
L["Button Size (Bank)"] = "Tasten Größe (Bank)"
L["Clear Search On Close"] = "Leere Suche beim Schließen"
L["Condensed"] = "Gekürzt"
L["Currency Format"] = "Währungsformat"
L["Descending"] = "Absteigend"
L["Direction the bag sorting will use to allocate the items."] = "Die Richtung, in welche die Gegenstände in den Taschen sortiert werden."
L["Disable Bag Sort"] = "Deaktiviere Taschensortierung"
L["Disable Bank Sort"] = "Deaktiviere Banksortierung"
L["Display Item Level"] = "Itemlevel anzeigen"
L["Display the junk icon on all grey items that can be vendored."] = "Zeigt das Müll Symbol auf allen grauen Gegenständen an die verkauft werden können."
L["Display the upgrade icon on items that WoW considers an upgrade for your character."] = "Zeigt ein Aufwertungs-Symbol auf einen Gegenstand, welcher deinen Charakter verbessern würde laut WoW."
L["Displays item level on equippable items."] = "Zeigt das Itemlevel für ausrüstbare Gegenstände an."
L["Enable/Disable the all-in-one bag."] = "Einschalten/Ausschalten der zusammengefassten Tasche."
L["Enable/Disable the Bag-Bar."] = "Aktiviere/Deaktiviere die Taschenleiste."
L["Full"] = "Voll"
L["Global"] = true; -- no need to translate this
L["Here you can add items or search terms that you want to be excluded from sorting. To remove an item just click on its name in the list."] = "Hier kannst du Gegenstände oder Suchbedingungen vom Suchen ausschließen. Um ein Gegenstand zu entfernen, klicke einfach auf den Namen in der Liste."
L["Icons and Text (Short)"] = "Symbole und Text (Kurz)"
L["Icons and Text"] = "Symbole und Text"
L["Ignored Items and Search Syntax (Global)"] = "Ignorierte Gegenstände oder Suchoperatoren (Global)"
L["Ignored Items and Search Syntax (Profile)"] = "Ignorierte Gegenstände oder Suchoperatoren (Profil)"
L["Item Count Font"] = "Gegenstandszähler Schriftart"
L["Item Level Threshold"] = "Itemlevel Schwellenwert"
L["Item Level"] = "Itemlevel"
L["Money Format"] = "Geldformat"
L["Panel Width (Bags)"] = "Leistenbreite (Taschen)"
L["Panel Width (Bank)"] = "Leistenbreite (Bank)"
L["Search Syntax"] = "Suchsyntax"
L["Set the size of your bag buttons."] = "Setze die Größe der Taschen Taste."
L["Short (Whole Numbers)"] = "Kurz (ganze Zahlen)"
L["Show Coins"] = "Währungssymbole anzeigen"
L["Show Junk Icon"] = "Zeige Müll Symbol"
L["Show Upgrade Icon"] = "Zeige Aufwertungs-Symbol"
L["Smart"] = "Elegant"
L["Sort Direction"] = "Sortierrichtung" --Also used in Buffs and Debuffs
L["Sort Inverted"] = "Umgekehrtes sortieren"
L["The direction that the bag frames be (Horizontal or Vertical)."] = "Die Ausrichtung der Leiste (Horizontal oder Vertikal)."
L["The direction that the bag frames will grow from the anchor."] = "Die Richtung in welche das Fenster vom Ankerpunkt aus wächst (Horizontal oder Vertikal)."
L["The display format of the currency icons that get displayed below the main bag. (You have to be watching a currency for this to display)"] = "Das Anzeigeformat für die Währungssymbole, welche unter der Haupttasche angezeigt werden. (Du musst eine Währung beobachten, damit diese angezeigt wird)"
L["The display format of the money text that is shown at the top of the main bag."] = "Das Anzeigeformat für Gold oben an der Haupttasche."
L["The frame is not shown unless you mouse over the frame."] = "Das Fenster ist nicht sichtbar, außer man bewegt die Maus darüber."
L["The minimum item level required for it to be shown."] = "Das minimale Itemlevel um angezeigt zu werden."
L["The size of the individual buttons on the bag frame."] = "Die Größe der einzelnen Tasten auf dem Taschenfenster."
L["The size of the individual buttons on the bank frame."] = "Die Größe der einzelnen Tasten auf dem Bankfenster."
L["The spacing between buttons."] = "Der Abstand zwischen den Tasten."
L["Top to Bottom"] = "Von oben nach unten"
L["Use coin icons instead of colored text."] = "Benutze Währungssymbole anstatt von farbigem Text."

--Buffs and Debuffs
L["Begin a new row or column after this many auras."] = "Beginne nach so vielen Stärkungszaubern eine neue Reihe oder Spalte."
L["Count xOffset"] = "Den Versatz auf der X-Achse zählen"
L["Count yOffset"] = "Den Versatz auf der Y-Achse zählen"
L["Defines how the group is sorted."] = "Lege fest, wie die Gruppe sortiert wird."
L["Defines the sort order of the selected sort method."] = "Legt die Sortierreihenfolge der ausgewählten Sortiermethode fest."
L["Disabled Blizzard"] = "Blizzard deaktivieren"
L["Fade Threshold"] = "Zeit bis zum verblassen"
L["Index"] = "Index"
L["Indicate whether buffs you cast yourself should be separated before or after."] = "Wenn du einen Stärkungszauber auf dich selber wirkst, zeige diesen zuerst in der Leiste."
L["Limit the number of rows or columns."] = "Beschränkung für die Anzahl an Leisten oder Spalten."
L["Max Wraps"] = "Maximale Leisten"
L["No Sorting"] = "Nicht Sortieren"
L["Other's First"] = "Andere zuerst"
L["Seperate"] = "Seperat"
L["Set the size of the individual auras."] = "Lege die Größe der individuellen Stärkungszauber fest."
L["Sort Method"] = "Sortiermethode"
L["The direction the auras will grow and then the direction they will grow after they reach the wrap after limit."] = "Die Richtung, die Aura wird wachsen wird und dann die Richtung dei Sie wachsen wird, nachdem sie die Grenze nach Wrap erreichen."
L["Threshold before text changes red, goes into decimal form, and the icon will fade. Set to -1 to disable."] = "Die Schwelle bevor der Text rot und das Symbol verblassen wird (in Dezimalform). Setze sie auf -1 um die Schwelle zu deaktivieren."
L["Time xOffset"] = "Zeit X-Versatz"
L["Time yOffset"] = "Zeit Y-Versatz"
L["Time"] = "Zeit"
L["Wrap After"] = "Neue Reihe/Spalte beginnen"
L["Your Auras First"] = "Deine Auren zuerst"

--Chat
L["Above Chat"] = "Über dem Chat"
L["Adjust the height of your right chat panel."] = "Passe die Höhe des rechten Chatfensters an."
L["Adjust the width of your right chat panel."] = "Passe die Breite des rechten Chatfensters an."
L["Alerts"] = "Alarme"
L["Allowed Combat Repeat"] = "Erlaubte Kampf Wiederholungen"
L["Attempt to create URL links inside the chat."] = "Eine Möglichkeit um Internet-Links im Chat anzuzeigen."
L["Attempt to lock the left and right chat frame positions. Disabling this option will allow you to move the main chat frame anywhere you wish."] = "Fixiere das rechte und linke Chatfenster. Deaktiviere diese Option um das Hauptchatfenster nach Belieben zu verschieben."
L["Auto-Close Pet Battle Log"] = "Kampfhaustier Kampflog automatisch schließen"
L["Below Chat"] = "Unter dem Chat"
L["Chat EditBox Position"] = "Position der Texteingabeleiste"
L["Chat History"] = "Chatverlauf"
L["Class Color Mentions"] = "Erwähnung in Klassenfarbe"
L["Custom Timestamp Color"] = "Benutzerdefinierte Zeitstempel Farbe"
L["Display LFG Icons in group chat."] = "LFG Symbole im Gruppenchat anzeigen"
L["Display the hyperlink tooltip while hovering over a hyperlink."] = "Zeigt den Hyperlink Tooltip beim Überfahren eines Hyperlinks."
L["Enable the use of separate size options for the right chat panel."] = "Benutze getrennte Größenoptionen für das rechte Chatfenster."
L["Exclude Name"] = "Ausgeschlossener Name"
L["Excluded names will not be class colored."] = "Ausgeschlossene Namen werden nicht in Klassenfarbe erscheinen."
L["Excluded Names"] = "Ausgeschlossene Namen"
L["Fade Chat"] = "Chat Verblassen"
L["Fade Tabs No Backdrop"] = "Verblasst Tabs ohne Hintergrund"
L["Fade the chat text when there is no activity."] = "Lässt den Chat Text verblassen, wenn keine Aktivität besteht."
L["Fade Undocked Tabs"] = "Verblasst nicht angedockte Tabs"
L["Fades the text on chat tabs that are docked in a panel where the backdrop is disabled."] = "Verblasst den Text für die Chat Tabs, die nicht angedockt sind und deren Hintergrund deaktiviert ist."
L["Fades the text on chat tabs that are not docked at the left or right chat panel."] = "Verblasst den Text für die Chat Tabs, die nicht am linken oder rechten Chat angedockt sind."
L["Font Outline"] = "Kontur der Schriftart" --Also used in UnitFrames section
L["Font"] = "Schriftart"
L["Hide Both"] = "Verstecke Beide"
L["Hyperlink Hover"] = "Hyperlink Hover"
L["Keyword Alert"] = "Stichwort Alarm"
L["Keywords"] = "Stichwort"
L["Left Only"] = "Nur Links"
L["LFG Icons"] = "LFG Symbole"
L["List of words to color in chat if found in a message. If you wish to add multiple words you must seperate the word with a comma. To search for your current name you can use %MYNAME%.\n\nExample:\n%MYNAME%, ElvUI, RBGs, Tank"] = "Liste der Wörter die farblich im Chat erscheinen, wenn sie in einer Nachricht gefunden werden. Wenn du möchtest, kannst du mehrere Wörter hinzufügen. Diese müssen durch ein Komma getrennt werden. Um deinen momentanen Namen zu suchen, benutze %MYNAME%.\n\nBeispiel:\n%MYNAME%, ElvUI, RBGs, Tank"
L["Lock Positions"] = "Positionen fixieren"
L["Log the main chat frames history. So when you reloadui or log in and out you see the history from your last session."] = "Sichert den Chatverlauf der Hauptchatfenster. Wenn du dein UI neulädst oder einloggst, siehst du den Chatverlauf der letzten Sitzung."
L["No Alert In Combat"] = "Kein Alarm im Kampf"
L["Number of messages you scroll for each step."] = "Anzahl der Nachrichten die mit jeden Schritt gescrollt werden."
L["Number of repeat characters while in combat before the chat editbox is automatically closed."] = "Anzahl der wiederholten Zeichen im Kampf, bevor das Chateingabefeld automatisch schließt."
L["Number of time in seconds to scroll down to the bottom of the chat window if you are not scrolled down completely."] = "Anzahl der Sekunden um im Chatfenster nach unten zu scrollen, wenn du nicht komplett nach unten gescrollt bist."
L["Panel Backdrop"] = "Fensterhintergrund"
L["Panel Height"] = "Fensterhöhe"
L["Panel Texture (Left)"] = "Fenstertextur (Links)"
L["Panel Texture (Right)"] = "Fenstertextur (Rechts)"
L["Panel Width"] = "Leistenbreite"
L["Position of the Chat EditBox, if datatexts are disabled this will be forced to be above chat."] = "Position der Texteingabeleiste. Sind die Infotexte deaktiviert, dann wird diese über dem Chat angebracht."
L["Prevent the same messages from displaying in chat more than once within this set amount of seconds, set to zero to disable."] = "Verhindert, dass die gleiche Nachricht im Chat mehr als einmal, innerhalb dieser festgelegten Anzahl von Sekunden, angezeigt wird. Auf Null setzen um diese Option zu deaktivieren."
L["Require holding the Alt key down to move cursor or cycle through messages in the editbox."] = "Erfordert dass die Alt-Taste gedrückt wird, um mit den Mauszeiger durch die Nachrichten zu scrollen."
L["Right Only"] = "Nur Rechts"
L["Right Panel Height"] = "Rechte Fensterhöhe"
L["Right Panel Width"] = "Rechte Fensterbreite"
L["Scroll Interval"] = "Scroll-Interval"
L["Scroll Messages"] = "Scroll Nachrichten"
L["Separate Panel Sizes"] = "Getrennte Chatfenster Größenoptionen"
L["Set the font outline."] = "Setzt die Schrift auf Outline." --Also used in UnitFrames section
L["Short Channels"] = "Kurze Kanäle"
L["Shorten the channel names in chat."] = "Kürze Kanalnamen im Chat."
L["Show Both"] = "Zeige Beide"
L["Spam Interval"] = "Spam-Interval"
L["Sticky Chat"] = "Kanal merken"
L["Tab Font Outline"] = "Tab Schriftkontur"
L["Tab Font Size"] = "Tab Schriftgröße"
L["Tab Font"] = "Tab Schriftart"
L["Tab Panel Transparency"] = "Tableisten Transparenz"
L["Tab Panel"] = "Tableiste anzeigen"
L["Timestamp Color"] = "Zeitstempel Farbe"
L["Toggle showing of the left and right chat panels."] = "Aktiviere den Hintergrund des linken und rechten Chatfensters"
L["Toggle the chat tab panel backdrop."] = "Aktiviere den Hintergrund der oberen Tableisten der Chatfenster"
L["URL Links"] = "URL Links"
L["Use Alt Key"] = "Benutze Alt-Taste"
L["Use class color for the names of players when they are mentioned."] = "Benutze Klassenfarben von Spielernamen, wenn sie erwähnt werden."
L["When opening the Chat Editbox to type a message having this option set means it will retain the last channel you spoke in. If this option is turned off opening the Chat Editbox should always default to the SAY channel."] = "Beim Öffnen der Texteingabeleiste wird dem Kanal beigetreten, in den zu letzt geschrieben wurde. Wenn diese Option deaktiviert ist, wird standardmäßig der SAGEN-Kanal beim öffnen der Texteingabeleiste aufgerufen."
L["Whisper Alert"] = "Flüster Alarm"
L[ [=[Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.

Please Note:
-The image size recommended is 256x128
-You must do a complete game restart after adding a file to the folder.
-The file type must be tga format.

Example: Interface\AddOns\ElvUI\media\textures\copy

Or for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.]=] ] = [=[Gib einen Dateinamen im World of Warcraft Verzeichnis an. Textures Ordner, den du als Fensterhintergrund eingestellt haben willst.

Bitte beachten:
-Als Bildgröße 256x128 wird empfohlen.
-Du musst das Spiel komplett neu starten, nachdem du die Datei hinzugefügt hast.
-Der Dateityp muss im Format tga sein.

Zum Beispiel: Interface\AddOns\ElvUI\media\textures\copy

Für die meisten Anwender ist es allerdigns einfacher, eine tga-Datei in ihren WoW-Ordner abzulegen. Anschließend kann man den Namen der Datei hier eingeben.]=]

--Credits
L["Coding:"] = "Programmierung:"
L["Credits"] = "Danksagung"
L["Donations:"] = "Spenden:"
L["ELVUI_CREDITS"] = "Ich möchte mich hier bei folgenden Personen bedanken, die durch ihre tatkräftige Unterstützung beim Testen und Coden, sowie durch Spenden, sehr geholfen haben. Bitte beachten: Für Spenden poste ich nur die Namen, die mich im Forum via PM angeschrieben haben. Sollte dein Name fehlen und du möchtest deinen Namen hinzugefügt haben, schreib mir bitte eine PM im Forum."
L["Testing:"] = "Tester:"

--DataBars
L["Current - Percent (Remaining)"] = "Aktuell - Prozent (Verleibend)"
L["Current - Remaining"] = "Aktuell - Verbleibend"
L["DataBars"] = "Informationsleisten"
L["Hide In Combat"] = "Im Kampf ausblenden"
L["Hide Outside PvP"] = "Verstecke ausserhalb von PvP"
L["Setup on-screen display of information bars."] = "Einstellung der Informationsleisten."

--DataTexts
L["24-Hour Time"] = "24-Stunden-Format"
L["Add Currency ID"] = "Währungs-ID hinzufügen"
L["Battleground Texts"] = "Schlachtfeld-Infotexte"
L["Block Combat Click"] = "Blockiere Klicks im Kampf"
L["Block Combat Hover"] = "Blockiere Hovereffekt im Kampf"
L["Blocks all click events while in combat."] = "Blockiere alle Klickevents im Kampf."
L["Blocks datatext tooltip from showing in combat."] = "Blockiere Infotextetooltips im Kampf."
L["BottomLeftMiniPanel"] = "Minimap Untenlinks (Innen)"
L["BottomMiniPanel"] = "Minimap Unten (Innen)"
L["BottomRightMiniPanel"] = "Minimap Untenrechts (Innen)"
L["Custom Currencies"] = "Benutzerdefinierte Währungen"
L["Custom Currency"] = "Benutzerdefinierte Währung"
L["Datatext Panel (Left)"] = "Infotextleiste (Links)"
L["Datatext Panel (Right)"] = "Infotextleiste (Rechts)"
L["DataTexts"] = "Infotexte"
L["Display data panels below the chat, used for datatexts."] = "Zeige die Infoleisten unter dem Chat, benutzt für Infotexte."
L["Display In Main Tooltip"] = "Zeige im Haupt-Tooltip"
L["Display minimap panels below the minimap, used for datatexts."] = "Zeige Minimap Leisten unter der Minimap, benutzt für Infotexte."
L["Displayed Currency"] = "Angezeigte Währung"
L["Gold Format"] = "Gold-Format"
L["If enabled, then this currency will be displayed in the main Currencies datatext tooltip."] = "Wenn aktiviert, wird diese Währung im Währungsinfotext Tooltip angezeigt."
L["If not set to true then the server time will be displayed instead."] = "Wenn nicht ausgewählt, wird stattdessen die Serverzeit angezeigt."
L["left"] = "Links"
L["LeftChatDataPanel"] = "Linker Chat"
L["LeftMiniPanel"] = "Minimap Links"
L["Local Time"] = "Lokale Zeit"
L["middle"] = "Mitte"
L["Minimap Panels"] = "Minimap Leisten"
L["Panel Transparency"] = "Panel Transparenz"
L["Panels"] = "Leisten"
L["right"] = "Rechts"
L["RightChatDataPanel"] = "Rechter Chat"
L["RightMiniPanel"] = "Minimap Rechts"
L["Small Panels"] = "Schmale Leisten"
L["The display format of the money text that is shown in the gold datatext and its tooltip."] = "Das Anzeigeformat für Gold in den Haupt-Infoleisten und Tooltips."
L["This allows you to create a new datatext which will track the currency with the supplied currency ID. The datatext can be added to a panel immediately after creation."] = "Dieses erlaubt dir einen neuen Infotext zu erstellen, der die Währung verfolgt mit der bereitgestellten Währungs-ID. Der Infotext kann sofort nach der Erstellung einer Leiste hinzugefügt werden."
L["Toggle 24-hour mode for the time datatext."] = "Wählt das 24-Stunden-Format für den Zeit-Infotext."
L["TopLeftMiniPanel"] = "Minimap Obenlinks (Innen)"
L["TopMiniPanel"] = "Minimap Oben (Innen)"
L["TopRightMiniPanel"] = "Minimap Obenrechts (Innen)"
L["Use Tooltip"] = "Benutze Tooltip"
L["When inside a battleground display personal scoreboard information on the main datatext bars."] = "Zeige innerhalb eines Schlachtfeldes persönliche Statistiken in den Haupt-Infoleisten."
L["Word Wrap"] = "Zeilenumbruch"

--Distributor
L["Must be in group with the player if he isn't on the same server as you."] = "Du musst mit dem Spieler in einer Gruppe sein wenn dieser nicht auf deinem Server ist wie du."
L["Sends your current profile to your target."] = "Sende dein momentanes Profil an dein Ziel."
L["Sends your filter settings to your target."] = "Sende deine Filter Einstellungen an dein Ziel."
L["Share Current Profile"] = "Teile das momentane Profil"
L["Share Filters"] = "Teile Filter"
L["This feature will allow you to transfer settings to other characters."] = "Dieses Feature erlaubt es dir Einstellungen an andere Charaktere zu schicken."
L["You must be targeting a player."] = "Du musst einen Spieler anvisiert haben."

--General
L["Accept Invites"] = "Einladungen akzeptieren"
L["Adjust the position of the threat bar to either the left or right datatext panels."] = "Bestimme die Position der Bedrohungsleiste in den rechten oder linken Infotextleisten."
L["AFK Mode"] = "AFK Modus"
L["Announce Interrupts"] = "Unterbrechungen ankündigen"
L["Announce when you interrupt a spell to the specified chat channel."] = "Melde über den angegebenen Chatkanal einen unterbrochenen Zauber."
L["Attempt to support eyefinity/nvidia surround."] = "Versucht Eyefinity/NVIDIA Surround zu unterstützen"
L["Auto Greed/DE"] = "Auto-Gier/DE"
L["Auto Repair"] = "Auto-Reparatur"
L["Auto Scale"] = "Auto-Skalierung"
L["Automatically accept invites from guild/friends."] = "Automatisch Einladungen von Gildenmitgliedern/Freunden akzeptieren"
L["Automatically repair using the following method when visiting a merchant."] = "Repariere automatisch deine Ausrüstungsgegenstände, wenn du eine der folgenden Methoden auswählst."
L["Automatically scale the User Interface based on your screen resolution"] = "Automatische Skalierung des Interfaces, angepasst an deine Bildschirmeinstellung"
L["Automatically select greed or disenchant (when available) on green quality items. This will only work if you are the max level."] = "Automatisch Gier oder Entzauberung auf Gegenstände von grüner Qualität wählen (sofern verfügbar). Das funktioniert nur, wenn du die maximale Stufe erreicht hast."
L["Automatically vendor gray items when visiting a vendor."] = "Automatischer Verkauf von grauen Gegenständen bei einem Händlerbesuch."
L["Bonus Reward Position"] = "Bonusbeute Position"
L["Bottom Panel"] = "Untere Leiste"
L["Chat Bubbles Style"] = "Sprechblasen Stil"
L["Chat Bubbles"] = "Sprechblasen"
L["Direction the bar moves on gains/losses"] = "Richtung in die der Balken wächst/sinkt"
L["Disable Tutorial Buttons"] = "Deaktiviere Tutorial Tasten"
L["Disables the tutorial button found on some frames."] = "Deaktiviert die Tutorial Taste auf einigen Fenstern."
L["Display a panel across the bottom of the screen. This is for cosmetic only."] = "Zeige eine Leiste am unterem Bildschirmrand. Das ist rein kosmetisch."
L["Display a panel across the top of the screen. This is for cosmetic only."] = "Zeige eine Leiste am oberen Bildschirmrand. Das ist rein kosmetisch."
L["Display battleground messages in the middle of the screen."] = "Zeigt Schlachtfeld Nachrichten in der Mitte des Bildschirms."
L["Display emotion icons in chat."] = "Zeige Emoticons im Chat."
L["Emotion Icons"] = "Emoticons"
L["Enable + Adjust Movers"] = "Aktiveren + Anpassen der Anker"
L["Enable/Disable the loot frame."] = "Aktiviere/Deaktiviere das Beutefenster."
L["Enable/Disable the loot roll frame."] = "Aktiviere/Deaktiviere das Beutewürfelfenster."
L["Enables the ElvUI Raid Control panel."] = "Aktiviert das ElvUI Raid Control Panel."
L["Enhanced PVP Messages"] = "Erweiterte PvP Nachrichten"
L["General"] = "Allgemein"
L["Height of the objective tracker. Increase size to be able to see more objectives."] = "Höhe des Questfenster. Größe verändern um mehr Ziele zu sehen."
L["Hide At Max Level"] = "Auf max. Level vestecken"
L["Hide Error Text"] = "Fehlertext verstecken"
L["Hide In Vehicle"] = "Im Fahrzeug verstecken"
L["Hides the red error text at the top of the screen while in combat."] = "Den roten Fehlertext im oberen Teil des Bildschirms im Kampf verstecken"
L["Log Taints"] = "Log Fehler"
L["Login Message"] = "Login Nachricht"
L["Loot Roll"] = "Würfelfenster"
L["Loot"] = "Beute"
L["Lowest Allowed UI Scale"] = "Niedrigste erlaubte UI Skalierung"
L["Multi-Monitor Support"] = "Multi-Monitor-Unterstützung"
L["Name Font"] = "Schriftart von Spielernamen"
L["Number Prefix"] = "Nummern-Präfix"
L["Objective Frame Height"] = "Questfenster Höhe"
L["Order Hall Command Bar"] = "Orderhallen Kommando Leiste"
L["Party / Raid"] = "Gruppe / Schlachtzug"
L["Party Only"] = "Nur in der Gruppe"
L["Position of bonus quest reward frame relative to the objective tracker."] = "Position vom Bonusbeute Fenster, relativ zum Questfenster."
L["Raid Only"] = "Nur im Schlachtzug"
L["Remove Backdrop"] = "Hintergrund entfernen"
L["Reset all frames to their original positions."] = "Setze alle Einheiten an ihre ursprüngliche Position zurück."
L["Reset Anchors"] = "Ankerpunkte zurücksetzen"
L["Reverse Fill Direction"] = "Umgekehrtes Füllen"
L["Send ADDON_ACTION_BLOCKED errors to the Lua Error frame. These errors are less important in most cases and will not effect your game performance. Also a lot of these errors cannot be fixed. Please only report these errors if you notice a Defect in gameplay."] = "Sende ADDON_ACTION_BLOCKED Fehler zum Lua-Fehlerfenster. Diese Fehler sind weniger wichtig und werden deine Spielleistung nicht beeinflussen. Viele dieser Fehler können nicht beseitigt werden. Bitte melde diese Fehler nur, wenn es einen Defekt im Spiel verursacht."
L["Skin Backdrop (No Borders)"] = "Skin für den Hintergrund (kein Rahmen)"
L["Skin Backdrop"] = "Skin für den Hintergrund"
L["Skin the blizzard chat bubbles."] = "Skin die Blizzard Chat Sprechblasen."
L["Talking Head Scale"] = "Sprechender Kopf Skalierung"
L["The font that appears on the text above players heads. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "Die Schrift, die über den Köpfen der Spieler auftaucht. |cffFF0000WARNUNG: Das benötigt einen Neustart des Spiels oder einen Relog um in Effekt zu treten.|r"
L["The Thin Border Theme option will change the overall apperance of your UI. Using Thin Border Theme is a slight performance increase over the traditional layout."] = "Das Dünne Rahmen Theme ändert das gesamte Erscheinungsbild deines UI. Das Benutzten des Dünnen Rahmen Theme ist ein kleiner performance Schub gegenüber dem traditionellen Layout."
L["The unit prefixes you want to use when values are shortened in ElvUI. This is mostly used on UnitFrames."] = "Der Einheitenpräfix den du benutzen möchtest wenn die Werte von ElvUI verkürzt sind. Wird meist auf den Einheitenfenstern benutzt."
L["Thin Border Theme"] = "Dünner Rahmen Theme"
L["Toggle Tutorials"] = "Tutorial starten"
L["Top Panel"] = "Obere Leiste"
L["When you go AFK display the AFK screen."] = "AFK Bildschirm anzeigen wenn du AFK bist."

--Media
L["Applies the font and font size settings throughout the entire user interface. Note: Some font size settings will be skipped due to them having a smaller font size by default."] = "Wendet die Schrift und Schriftgröße überall im Interface an. Hinweis: Einige Schriftarten werden übersprungen, weil sie eine kleinere Schriftgröße als Standard haben."
L["Applies the primary texture to all statusbars."] = "Wendet die Primäre Textur auf alle Statusbars an."
L["Apply Font To All"] = "Schriftart auf alles anwenden."
L["Apply Texture To All"] = "Textur auf alles anwenden"
L["Backdrop color of transparent frames"] = "Hintergrundfarbe von transparenten Fenstern"
L["Backdrop Color"] = "Hintergrundfarbe"
L["Backdrop Faded Color"] = "Transparente Hintergrundfarbe"
L["Border Color"] = "Rahmenfarbe"
L["Color some texts use."] = "Allgemeine Farbe der meisten Texte"
L["CombatText Font"] = "Schriftart vom Kampftext"
L["Default Font"] = "Allgemeine Schriftart"
L["Fonts"] = "Schrift"
L["Main backdrop color of the UI."] = "Allgemeine Hintergrundfarbe der Benutzeroberfläche."
L["Main border color of the UI."] = "Standard-Rahmenfarbe der Benutzeroberfläche"
L["Media"] = "Medien"
L["Primary Texture"] = "Primäre Textur"
L["Replace Blizzard Fonts"] = "Blizzard Schriftarten überschreiben"
L["Replaces the default Blizzard fonts on various panels and frames with the fonts chosen in the Media section of the ElvUI config. NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this. Enabled by default."] = "Ersetzt die Standard Blizzard Schriftarten in verschiedenen Fenstern und Leisten mit den im Medienbereich des ElvUI Config gewählten Schriftenarten. (NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this.) Standardmäßig aktiviert."
L["Secondary Texture"] = "Sekundäre Textur"
L["Set the font size for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"] = "Setze die Größe für die Schriftart der gesamten Benutzeroberfläche fest. Notiz: Dies hat keinen Einfluss auf Optionen, die ihre eigenen Einstellungen haben (Einheitenfenster Schrift, Infotext Schrift, ect..)"
L["Textures"] = "Texturen"
L["The font that combat text will use. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "Die Schriftart des Kampftextes. |cffFF0000WARNUNG: Nach der änderung dieser Option muss das Spiel neu gestartet werden.|r"
L["The font that the core of the UI will use."] = "Die Schriftart, die hauptsächlich vom UI verwendet wird."
L["The texture that will be used mainly for statusbars."] = "Diese Textur wird vorallem für Statusbars verwendet."
L["This texture will get used on objects like chat windows and dropdown menus."] = "Diese Textur wird für Objekte wie Chatfenster und Dropdown-Menüs benutzt."
L["Value Color"] = "Farbwert"

--Maps
L["Adjust the size of the minimap."] = "Stelle die Größe der Minimap ein."
L["Always Display"] = "Immer anzeigen"
L["Bottom Left"] = "Unten links"
L["Bottom Right"] = "Unten rechts"
L["Bottom"] = "Unten"
L["Change settings for the display of the location text that is on the minimap."] = "Ändere die Einstellungen für die Anzeige des Umgebungstextes an der Minimap."
L["Enable/Disable the minimap. |cffFF0000Warning: This will prevent you from seeing the minimap datatexts.|r"] = "Aktiviere/Deaktiviere die Minimap. |cffFF0000Warnung: Durch diese Einstellung wird verhindert dass die Infotextleisten an der Minimap angezeigt werden.|r"
L["Instance Difficulty"] = "Instanz Schwierigkeitsgrad"
L["Left"] = "Links"
L["LFG Queue"] = "LFG Warteschlange"
L["Location Text"] = "Umgebungstext"
L["Make the world map smaller."] = "Macht die Weltkarte kleiner."
L["Map Opacity When Moving"] = "Deckkraft der Karte während der Bewegung"
L["Maps"] = "Karten";
L["Minimap Buttons"] = "Minimap Tasten"
L["Minimap Mouseover"] = "Minimap Mouseover"
L["Open Ticket"] = "Offenes Ticket"
L["Puts coordinates on the world map."] = "Platziert Koordinaten auf der Weltkarte."
L["Reset Zoom"] = "Zoom zurücksetzen"
L["Right"] = "Rechts"
L["Scale"] = "Skalierung"
L["Smaller World Map"] = "Kleinere Weltkarte"
L["Top Left"] = "Oben links"
L["Top Right"] = "Oben rechts"
L["Top"] = "Oben"
L["World Map Coordinates"] = "Weltkarten Koordinaten"
L["X-Offset"] = "X-Versatz"
L["Y-Offset"] = "Y-Versatz"

--Misc
L["Enable"] = "Eingeschaltet"
L["Filters are not allowed to have commas in their name. Stripping commas from filter name."] = "Filtern ist es nicht erlaubt Kommas im Namen zu haben. Entferne Kommas vom Filter Namen."
L["Install"] = "Installation"
L["Run the installation process."] = "Startet den Installationsprozess."
L["Toggle Anchors"] = "Ankerpunkte umschalten"
L["Unlock various elements of the UI to be repositioned."] = "Schalte verschiedene Elemente der Benutzeroberfläche frei um sie neu zu positionieren."
L["Version"] = "Version"

--NamePlates
L["# Displayed Auras"] = "# angezeigte Auren"
L["Actions"] = "Aktionen"
L["Add a Name or NPC ID to the list."] = "Füge einen Namen oder NPC ID der Liste hinzu."
L["Add Name or NPC ID"] = "Füge Name oder NPC ID hinzu"
L["Add Nameplate Filter"] = "Füge Namensplaketten Filter hinzu"
L["Add Regular Filter"] = "Füge regulären Filter hinzu"
L["Add Special Filter"] = "Füge speziellem Filter hinzu"
L["Always Show Target Health"] = "Zeige immer Ziel Gesundheit"
L["Always Show"] = "Immer anzeigen"
L["Apply this filter if a buff has remaining time greater than this. Set to zero to disable."] = "Diesen Filter anwenden, wenn die Dauer von einem Stärkungszauber größer als dieses ist. Setze auf 0 um zu deaktivieren."
L["Apply this filter if a buff has remaining time less than this. Set to zero to disable."] = "Diesen Filter anwenden, wenn die Dauer von einem Stärkungszauber kleiner als dieses ist. Setze auf 0 um zu deaktivieren."
L["Apply this filter if a debuff has remaining time greater than this. Set to zero to disable."] = "Diesen Filter anwenden, wenn die Dauer von einem Schwächungszauber größer als dieses ist. Setze auf 0 um zu deaktivieren."
L["Apply this filter if a debuff has remaining time less than this. Set to zero to disable."] = "Diesen Filter anwenden, wenn die Dauer von einem Schwächungszauber kleiner als dieses ist. Setze auf 0 um zu deaktivieren."
L["Background Glow"] = "Hintergrund Leuchten"
L["Bad Color"] = "Schlechte Farbe"
L["Bad Scale"] = "Schlechte Skalierung"
L["Bad Transition Color"] = "Schlechte Übergangsfarbe"
L["Base Height for the Aura Icon"] = "Grundhöhe der Auren Symbole"
L["Border Glow"] = "Rahmen Leuchten"
L["Border"] = "Rand"
L["Boss Auras"] = "Boss Auren"
L["Cast Bar"] = "Zauberleiste"
L["Cast Color"] = "Zauberfarbe"
L["Cast No Interrupt Color"] = "Nicht unterbrechbare Zauberfarbe"
L["Cast Time Format"] = "Zauber Zeitformat"
L["Casting"] = "Zaubernd"
L["Channel Time Format"] = "Kanalisierung Zeitformat"
L["Clamp nameplates to the top of the screen when outside of view."] = "Hält die Namensplaketten am oberen Bildschirmrand, wenn nicht in Sicht."
L["Clamp Nameplates"] = "Namensplaketten halten"
L["Clear Filter"] = "Filter leeren"
L["Clickable Height"] = "Klickbare Höhe"
L["Clickable Width"] = "Klickbare Breite"
L["Color Tanked"] = "Färbe angetankt"
L["Control enemy nameplates toggling on or off when in combat."] = "Legt fest ob die Namensplaketten im Kampf für Gegner ein- oder ausgeblendet werden."
L["Control friendly nameplates toggling on or off when in combat."] = "Legt fest ob die Namensplaketten im Kampf für freundliche Einheiten ein- oder ausgeblendet werden."
L["Controls how big of an area on the screen will accept clicks to target unit."] = "Legt die Größe des Bereichs auf dem Bildschirm fest, welche die klicks durch die feindlichen Einheiten erlaubt."
L["Controls how many auras are displayed, this will also affect the size of the auras."] = "Legt fest wieviele Auren angezeigt werden. Dieses beeinflusst auch die Größe der Auren."
L["Controls which nameplates will be displayed."] = "Legt fest welche Namensplaketten angezeigt werden."
L["Copy settings from another unit."] = "Kopiere Einstellungen von einer anderen Einheit."
L["Copy Settings From"] = "Kopiere Einstellungen von"
L["Current Level"] = "Aktuelles Level"
L["Default Settings"] = "Standard Einstellungen"
L["Detection"] = "Aufspüren"
L["Display a healer icon over known healers inside battlegrounds or arenas."] = "Zeige auf Schlachtfeldern oder in Arenen ein Heilersymbol über Heilern an."
L["Display Minions"] = "Zeige Begleiter"
L["Display Minor Units"] = "Zeige kleine Einheiten"
L["Display NPC Titles whenever healthbars arent displayed and names are."] = "Zeige NPC Titel, wenn die Lebensleiste ausgeblendet, der Name aber aktiviert ist."
L["Display Style"] = "Anzeigestil"
L["Elite Icon"] = "Elite Symbol"
L["Enable/Disable the scaling of targetted nameplates."] = "Aktiviere/Deaktiviere die Skalierung von ausgefählten Namensplaketten."
L["Enemy Combat Toggle"] = "Im Kampf für Gegner umschalten"
L["Enemy NPC Frames"] = "Gegnerische NPC Rahmen"
L["Enemy Player Frames"] = "Gegnerische Spieler Rahmen"
L["Enemy"] = "Gegner" --Also used in UnitFrames
L["ENEMY_NPC"] = "Gegnerischer NPC"
L["ENEMY_PLAYER"] = "Gegnerischer Spieler"
L["Filter already exists!"] = "Filter existiert bereits!"
L["Filter Priority"] = "Filter Priorität"
L["Filter"] = true; --No need to translate
L["Filters Page"] = "Filter Seite"
L["Friendly Combat Toggle"] = "Im Kampf für freundliche umschalten"
L["Friendly NPC Frames"] = "Freundliche NPC Rahmen"
L["Friendly Player Frames"] = "Freundliche Spieler Rahmen"
L["FRIENDLY_NPC"] = "Freundlicher NPC"
L["FRIENDLY_PLAYER"] = "Freundlicher Spieler"
L["General Options"] = "Allgemeine Optionen"
L["Good Color"] = "Gute Farbe"
L["Good Scale"] = "Gute Skalierung"
L["Good Transition Color"] = "Gute Übergangsfarbe"
L["Healer Frames"] = "Heiler Rahmen"
L["Healer Icon"] = "Heilersymbol"
L["HEALER"] = "Healer"
L["Health Color"] = "Gesundheitsfarbe"
L["Health Threshold"] = "Gesundheit Schwellwert"
L["Hide Delay"] = "Versteckungsverzögerung"
L["Hide Frame"] = "Verstecke Fenster"
L["Hide Spell Name"] = "Verstecke Zaubername"
L["Hide Time"] = "Verstecke Zeit"
L["Hide When Empty"] = "Verstecke wenn leer"
L["Hide"] = "Verstecken" --Also used in DataTexts
L["How many seconds the castbar should stay visible after the cast failed or was interrupted."] = "Wieviele Sekunden die Zauberleiste sichtbar bleibt, nachdem ein Zauber abgebrochen oder unterbrochen wurde."
L["Icon Base Height"] = "Symbol Grundhöhe"
L["If enabled then it checks if auras are missing instead of being present on the unit."] = "Wenn aktiviert, wird überprüft ob Auren fehlen anstatt vorhanden zu sein auf der Einheit."
L["If enabled then it will require all auras to activate the filter. Otherwise it will only require any one of the auras to activate it."] = "Wenn aktiviert, benötigt es alle Auren um den Filter zu aktivieren. Andererseits benötigt es nur eine von den Auren um den Filter zu aktivieren."
L["If enabled then the filter will only activate if the level of the unit is equal to or higher than this value."] = "Wenn eingeschaltet, wird der Filter nur aktiviert wenn das Level der Einheit gleich oder höher diesem Level ist."
L["If enabled then the filter will only activate if the level of the unit is equal to or lower than this value."] = "Wenn eingeschaltet, wird der Filter nur aktiviert wenn das Level der Einheit gleich oder niedriger diesem Level ist."
L["If enabled then the filter will only activate if the level of the unit matches this value."] = "Wenn aktiviert, wird der Filter nur aktiviert wenn das Level der Einheit diesem Wert entspricht."
L["If enabled then the filter will only activate if the level of the unit matches your own."] = "Wenn eingeschaltet, wird der Filter nur aktiviert wenn das Level er Einheit deinem Level entspricht."
L["If enabled then the filter will only activate if the unit is casting interruptible spells."] = "Wenn eingeschaltet, wird der Filter nur aktiviert wenn die Einheit einen unterbrechbaren Zauber wirkt."
L["If enabled then the filter will only activate when the unit is in combat."] = "Wenn eingeschaltet, wird der Filter nur aktiviert, wenn die Einheit im Kampf ist."
L["If enabled then the filter will only activate when the unit is out of combat."] = "Wenn eingeschaltet, wird der Filter nur aktiviert, wenn die Einheit nicht im Kampf ist."
L["If enabled then the filter will only activate when you are in combat."] = "Wenn eingeschaltet, wird der Filter nur aktiviert wenn du im Kampf bist."
L["If enabled then the filter will only activate when you are out of combat."] = "Wenn eingeschaltet, wird der Filter nur aktiviert, wenn du nicht im Kampf bist."
L["If the aura is listed with a number then you need to use that to remove it from the list."] = "Wenn die Aura mit einer Nummer aufgeführt ist, dann musst du sie benutzten um sie aus der Liste zu entfernen."
L["If this list is empty, and if 'Interruptible' is checked, then the filter will activate on any type of cast that can be interrupted."] = "Wenn die Liste leer ist, und 'Unterbrechbar' ist ausgewählt, wird der Filter aktiviert bei jedem Zauber der unterbrechbar ist."
L["If this threshold is used then the health of the unit needs to be higher than this value in order for the filter to activate. Set to 0 to disable."] = "Wenn dieser Schwellenwert genutzt wird, muss die Gesundheit höher sein als dieser Wert um den Filter zu aktivieren. Setze auf 0 um zu deaktiveren."
L["If this threshold is used then the health of the unit needs to be lower than this value in order for the filter to activate. Set to 0 to disable."] = "Wenn dieser Schwellenwert genutzt wird, muss die Gesundheit niedriger sein als dieser Wert um den Filter zu aktivieren. Setze auf 0 um zu deaktiveren."
L["In Combat"] = "Im Kampf"
L["Interruptible"] = "Unterbrechbar"
L["Is Targeted"] = "Ist anvisiert"
L["LEVEL_BOSS"] = "Set level to -1 for boss units or set to 0 to disable.";
L["Load Distance"] = "Anzeige Distanz"
L["Low Health Threshold"] = "Niedrige Lebensbedrohung"
L["Lower numbers mean a higher priority. Filters are processed in order from 1 to 100."] = "Niedrigere Nummern bedeuten eine höhere Priorität. Filter werden von 1 bis 100 verarbeitet."
L["Make the unitframe glow yellow when it is below this percent of health, it will glow red when the health value is half of this value."] = "Färbe das Einheitenfensterleuchten gelb, wenn es unter diesen Prozentwert des Lebens sinkt. Es wird Rot angezeigt, wenn es die Hälfte des Wertes erreicht."
L["Match Player Level"] = "Entspreche Spieler Level"
L["Maximum Level"] = "Maximale Level"
L["Maximum Time Left"] = "Maximale Zeit verbleibend"
L["Minimum Level"] = "Minimale Level"
L["Minimum Time Left"] = "Minimale Zeit verbleibend"
L["Missing"] = "Fehlend"
L["Name Color"] = "Namen Farbe"
L["NamePlates"] = "Namensplaketten"
L["Non-Target Transparency"] = "Transparenz nicht ausgewählter Ziele"
L["Not Targeted"] = "Nicht anvisiert"
L["Only load nameplates for units within this range."] = "Namensplaketten werden nur angezeigt, wenn sie in Reichweite sind."
L["Only Show Target"] = "Zeige nur Gegner"
L["Out Of Combat"] = "Außerhalb des Kampfes"
L["Over Health Threshold"] = "Über den Gesundheit Schwellenwert"
L["Personal Auras"] = "Persönliche Auren"
L["Player in Combat"] = "Spieler im Kampf"
L["Player Nameplate"] = "Spieler Namensplaketten"
L["Player Out of Combat"] = "Spieler nicht im Kampf"
L["PLAYER"] = "Player"
L["Reaction Colors"] = "Reaktionsfarbe"
L["Reaction Type"] = "Reaktion Typ"
L["Remove a Name or NPC ID from the list."] = "Entferne einen Namen oder NPC ID von der Liste."
L["Remove Buff"] = "Stärkungszauber entfernen"
L["Remove Debuff"] = "Schwächungszauber entfernen"
L["Remove Name or NPC ID"] = "Entferne Name oder NPC ID"
L["Remove Name"] = "Name entfernen"
L["Remove Nameplate Filter"] = "Entferne Namensplaketten Filter"
L["Require All"] = "Benötigt alle"
L["Require of the selected auras."] = "Benötigt die ausgewählten Auren."
L["Reset filter priority to the default state."] = "Setze die Filter Priorität auf Standard zurück."
L["Reset Priority"] = "Setze die Priorität zurück"
L["Return filter to its default state."] = "Setzt den Filter auf Standard zurück."
L["Scale of the nameplate that is targetted."] = "Skalierung der Namensplaketten ausgewählter Einheiten."
L["Select Nameplate Filter"] = "Wähle den Namensplaketten Filter"
L["Set Settings to Default"] = "Setzte die Einstellungen auf Standard"
L["Set the transparency level of nameplates that are not the target nameplate."] = "Transparenzlevel von Namensplaketten die nicht ausgewählt sind."
L["Set to either stack nameplates vertically or allow them to overlap."] = "Namensplaketten übereinander stapeln oder überlappen."
L["Shortcut to 'Filters' section of the config."] = "Verknüpfung zur 'Filter' Sektion in den Einstellungen."
L["Shortcuts"] = "Verknüpfungen"
L["Show In Combat"] = "Im Kampf anzeigen"
L["Show NPC Titles"] = "Zeige NPC Titel"
L["Show With Target"] = "Zeige mit Ziel"
L["Side Arrows"] = "Seitliche Pfeile"
L["Style Filter"] = "Stil Filter"
L["Suramar Detection"] = "Surumar Aufspürung"
L["Tagged NPC"] = "Ausgewählter NPC"
L["Tanked Color"] = "Angetankte Farbe"
L["Target Glow Color"] = "Zielglühen Farbe"
L["Target Indicator"] = "Ziel Indikator"
L["Target Scale"] = "Ziel Skalierung"
L["Target, Quest, Combat"] = "Ziel, Quest, Kampf"
L["Targeted Nameplate"] = "Ausgewählte Namensplaketten"
L["Texture"] = "Textur"
L["These filters don't use a list of spells like the regular filters. Instead they use the WoW API and some code logic to determine if an aura should be allowed or blocked."] = "Diese Filter benutzen keine Liste von Zaubern wie die regulären Filter. Sie benutzen anstatt die WoW API um festzustellen ob eine Aura erlaubt oder geblockt wird."
L["These filters use a list of spells to determine if an aura should be allowed or blocked. The content of these filters can be modified in the 'Filters' section of the config."] = "Diese Filter nutzen eine Liste von Zaubern um festzustellen ob eine Aura erlaubt oder geblockt wird. Der Inhalt dieses Filter kann in der 'Filter' Sektion der Konfiguration bearbeitet werden."
L["Threat"] = "Bedrohung"
L["Time To Hold"] = "Anzeigezeit"
L["Toggle Off While In Combat"] = "Im Kampf ausblenden"
L["Toggle On While In Combat"] = "Im Kampf einblenden"
L["Top Arrow"] = "Oberer Pfeil"
L["Triggers"] = "Auslöser"
L["Under Health Threshold"] = "Unter Gesundheit Schwellenwert"
L["Unit in Combat"] = "Einheit im Kampf"
L["Unit Out of Combat"] = "Einheit nicht im Kampf"
L["Unit Type"] = "Einheiten Typ"
L["Use Class Color"] = "Benutze Klassenfarbe"
L["Use drag and drop to rearrange filter priority or right click to remove a filter."] = "Benutze Drag und Drop um die Filter Priorität zu arrangieren oder rechts klick um einen Filter zu entfernen."
L["Use Portrait"] = "Benutze Portrait"
L["Use Static Position"] = "Benutze statische Position"
L["Use Tanked Color when a nameplate is being effectively tanked by another tank."] = "Benutze 'Angetankte Farbe' für die Namensplakette, wenn die Einheit von einem anderen Tank getankt wird."
L["Use Target Glow"] = "Benutze Ziel Leuchten"
L["Use Target Scale"] = "Benutze Ziel Skalierung"
L["Use Threat Color"] = "Benutze Bedrohungsfarbe"
L["When enabled the nameplate will stay visible in a locked position."] = "Wenn aktiviert, sind die Namensplaketten in einer festen Position sichtbar."
L["You can't remove a default name from the filter, disabling the name."] = "Du kannst nicht einen Standard Namen vom Filter entfernen, deaktiviere den Namen."

--Profiles Export/Import
L["Aura Filters"] = "Auren Filter"
L["Choose Export Format"] = "Wähle Export Format"
L["Choose What To Export"] = "Wähle aus, was exportiert werden soll"
L["Decode Text"] = "Entschlüsselter Text"
L["Error decoding data. Import string may be corrupted!"] = "Fehler beim entschlüsseln der Daten. Die importierende Zeichenfolge scheint beschädigt zu sein!"
L["Error exporting profile!"] = "Fehler beim Exportieren des Profils!"
L["Export Now"] = "Jetzt exportieren"
L["Export Profile"] = "Exportiere Profil"
L["Exported"] = "Exportiert"
L["Filters (All)"] = "Filter (Alle)"
L["Filters (NamePlates)"] = "Filter (Namensplaketten)"
L["Filters (UnitFrames)"] = "Filter (Einheitenfenster)"
L["Global (Account Settings)"] = "Globale (Account Einstellungen)"
L["Import Now"] = "Jetzt importieren"
L["Import Profile"] = "Importiere Profil"
L["Importing"] = "Importiere"
L["NamePlate Style Filters"] = true;
L["Plugin"] = true; --no need to translate
L["Private (Character Settings)"] = "Private (Charakter Einstellungen)"
L["Profile imported successfully!"] = "Profil erfolgreich importiert!"
L["Profile Name"] = "Profil Name"
L["Profile"] = "Profil"
L["Table"] = "Tabelle"

--Skins
L["Achievement Frame"] = "Erfolgsfenster"
L["AddOn Manager"] = true; --no need to translate
L["Alert Frames"] = "Alarmfenster"
L["Archaeology Frame"] = "Archäologiefenster"
L["Auction Frame"] = "Auktionsfenster"
L["Barbershop Frame"] = "Barbier Fenster"
L["BG Map"] = "Schlachtfeldkarte"
L["BG Score"] = "Schlachtfeldpunkte"
L["Black Market AH"] = "Schwarzmarkt Auktionshaus"
L["Calendar Frame"] = "Kalender Fenster"
L["Character Frame"] = "Charakterfenster"
L["Contribution"] = "Beitragsfenster"
L["Death Recap"] = "Todesursache"
L["Debug Tools"] = "Debug Tools"
L["Gossip Frame"] = "Begrüßungsfenster"
L["Guild Control Frame"] = "Gildenkontrollfenster"
L["Guild Frame"] = "Gildenfenster"
L["Guild Registrar"] = "Gildenregister"
L["Help Frame"] = "Hilfefenster"
L["Inspect Frame"] = "Betrachten Fenster"
L["Item Upgrade"] = "Gegenstandsaufwertung"
L["KeyBinding Frame"] = "Tastenbelegungsfenster"
L["LF Guild Frame"] = "LF Gilde Fenster"
L["LFG Frame"] = "LFG Fenster"
L["Loot Frames"] = "Beutefenster"
L["Loss Control"] = "Kontrollverlust"
L["Macro Frame"] = "Makro Fenster"
L["Mail Frame"] = "Post Fenster"
L["Merchant Frame"] = "Handelsfenster"
L["Mirror Timers"] = "Spiegel Zeitgeber"
L["Misc Frames"] = "Verschiedene Fenster"
L["Non-Raid Frame"] = "Kein-Raid Fenster"
L["Orderhall"] = "Klassenhalle"
L["Pet Battle"] = "Haustierkampf"
L["Petition Frame"] = "Abstimmungsfenster"
L["PvP Frames"] = "Pvp Fenster"
L["Quest Choice"] = "Quest Auswahl"
L["Quest Frames"] = "Quest Fenster"
L["Raid Frame"] = "Schlachtzugsfenster"
L["Skins"] = "Skins"
L["Socket Frame"] = "Sockel Fenster"
L["Spellbook"] = "Zauberbuch"
L["Stable"] = "Stall"
L["Tabard Frame"] = "Wappenrockfenster"
L["Talent Frame"] = "Talentfenster"
L["TalkingHead"] = "Sprechender Kopf"
L["Taxi Frame"] = "Flugroutenfenster"
L["Time Manager"] = "Zeitmanager"
L["Trade Frame"] = "Handelsfenster"
L["TradeSkill Frame"] = "Berufsfenster"
L["Trainer Frame"] = "Lehrerfenster"
L["Transmogrify Frame"] = "Transmogrifikationsfenster"

--Tooltip
L["Always Hide"] = "Immer verstecken"
L["Bags Only"] = "Nur Taschen"
L["Bags/Bank"] = "Taschen/Bank"
L["Bank Only"] = "Nur Bank"
L["Both"] = "Beide"
L["Choose when you want the tooltip to show. If a modifer is chosen, then you need to hold that down to show the tooltip."] = "Wählt aus wann der Tooltip angezeigt wird. Wenn ein Modifikator ausgewählt ist, dann musst du ihn gedrückt halten um den Tooltip anzuzeigen."
L["Comparison Font Size"] = "Vergleich Schriftgröße"
L["Cursor Anchor"] = "Zeigeranker"
L["Custom Faction Colors"] = "Benutzerdefinierte Fraktionsfarben"
L["Display guild ranks if a unit is guilded."] = "Zeige Gildenränge von Spielern die in einer Gilde sind."
L["Display how many of a certain item you have in your possession."] = "Zeige wie viele sich von dem ausgewählten Gegenstand in deinem Besitz befinden."
L["Display player titles."] = "Zeige Spielertitel."
L["Display the players talent spec and item level in the tooltip, this may not immediately update when mousing over a unit."] = "Zeige die Spezialisierung und das Itemlevel des Spielers im Tooltip an, wird vielleicht nicht direkt aktualisiert"
L["Display the spell or item ID when mousing over a spell or item tooltip."] = "Zeige die ID des Zaubers oder des Gegenstands an, wenn du mit der Maus über einen Zauber oder Fegenstand ziehst."
L["Guild Ranks"] = "Gildenränge"
L["Header Font Size"] = "Kopfzeile Schriftgröße"
L["Health Bar"] = "Lebensleiste"
L["Hide tooltip while in combat."] = "Verstecke den Tooltip während des Kampfes."
L["Inspect Info"] = "Informationen betrachten"
L["Item Count"] = "Gegenstandsanzahl"
L["Never Hide"] = "Niemals verstecken"
L["Player Titles"] = "Spielertitel"
L["Should tooltip be anchored to mouse cursor"] = "Soll das Tooltip an den Mauszeiger geankert werden"
L["Spell/Item IDs"] = "Zauber/Gegenstand IDs"
L["Target Info"] = "Ziel Info"
L["Text Font Size"] = "Text Schriftgröße"
L["This setting controls the size of text in item comparison tooltips."] = "Diese Einstellung kontrolliert die Größe der Schrift vom Text im Item Vergleichs-Tooltip."
L["Tooltip Font Settings"] = "Tooltip Schrifteinstellung"
L["When in a raid group display if anyone in your raid is targeting the current tooltip unit."] = "Zeige ob jemand aus deiner Gruppe/Schlachtzug die Tooltip-Einheit ins Ziel genommen hat."

--UnitFrames
L["%s and then %s"] = "%s und dann %s"
L["2D"] = "2D"
L["3D"] = "3D"
L["Above"] = "Oben"
L["Absorbs"] = "Absorbierungen"
L["Add a spell to the filter. Use spell ID if you don't want to match all auras which share the same name."] = "Zauber zum Filter hinzufügen. Benutze Zauber ID wenn du nicht möchtest, dass Zauber hinzugefügt werden die alle den selben Namen haben."
L["Add a spell to the filter."] = "Zauber zum Filter hinzufügen"
L["Add Spell ID or Name"] = "Zauber ID oder Name hinzufügen"
L["Add SpellID"] = "ZauberID hinzufügen"
L["Additional Filter Override"] = "Zusätzlicher Filter überschreiben"
L["Additional Filter"] = "Zusätzlicher Filter"
L["Additional Power Text"] = "Zusätzlicher Kraft Text"
L["Allow auras considered to be part of a boss encounter."] = "Erlaube den Auren als Teil eines Bosskampfes betrachtet zu werden"
L["Allow Boss Encounter Auras"] = "Erlaube Bosskampf Auren"
L["Allow non-personal auras from additional filter when 'Block Non-Personal Auras' is enabled."] = "Erlaube nicht-persönliche Auren vom zusätzlichen Filter wenn 'Blocke Nicht-Persönliche Auren' aktiviert ist."
L["Allow Whitelisted Auras"] = "Erlaube Whitelisted Auren"
L["An X offset (in pixels) to be used when anchoring new frames."] = "X-Versatz (in Pixeln) der verwendet werden soll um neue Fenster zu ankern"
L["An Y offset (in pixels) to be used when anchoring new frames."] = "Y-Versatz (in Pixeln) der verwendet werden soll um neue Fenster zu ankern"
L["Anticipation"] = "Erwartung"
L["Ascending or Descending order."] = "Aufsteigende oder Absteigende Reihenfolge"
L["Assist Frames"] = "Assistent Fenster"
L["Assist Target"] = "Assistent Ziel"
L["At what point should the text be displayed. Set to -1 to disable."] = "An welchen Punkt sollte der text angezeigt werden. Auf -1 setzen um es zu deaktivieren."
L["Attach Text To"] = "Text anfügen an"
L["Attach To"] = "Anfügen an"
L["Aura Bars"] = "Auren Leisten"
L["Auto-Hide"] = "Automatisch verstecken"
L["Bad"] = "Schlecht"
L["Bars will transition smoothly."] = "Sanfter Übergang der Leisten."
L["Below"] = "Unten"
L["Blacklist Modifier"] = "Schwarze Liste Modifikator"
L["Blacklist"] = "Schwarze Liste"
L["Block Auras Without Duration"] = "Blocke Auren ohne Laufzeit"
L["Block Blacklisted Auras"] = "Blocke Auren der schwarzen Liste"
L["Block Non-Dispellable Auras"] = "Blocke Nicht-Bannbare Auren"
L["Block Non-Personal Auras"] = "Blocke Nicht-Persönliche Auren"
L["Borders"] = "Umrandungen"
L["Buff Indicator"] = "Buff Indikator"
L["Buffs"] = "Stärkungszauber"
L["By Type"] = "Nach Typ"
L["Camera Distance Scale"] = "Kameradistanz"
L["Castbar"] = "Zauberleiste"
L["Center"] = "Zentrum"
L["Check if you are in range to cast spells on this specific unit."] = "Überprüfe ob du dich in Reichweite befindest, um einen Zauber auf eine spezifische Einheit zu wirken."
L["Choose UIPARENT to prevent it from hiding with the unitframe."] = "Wähle UIPARENT um zu verhindern dass es mit dem Einheitenfenster versteckt wird."
L["Class Backdrop"] = "Klassen Hintergrund"
L["Class Castbars"] = "Klassen Zauberleisten"
L["Class Color Override"] = "Klassenfarben überschreiben"
L["Class Health"] = "Klassen Gesundheit"
L["Class Power"] = "Klassen Kraft"
L["Class Resources"] = "Klassenressourcen"
L["Click Through"] = "Klicke hindurch"
L["Color all buffs that reduce the unit's incoming damage."] = "Färbe alle Stärkungszauber die den einkommenden Schaden der Einheit verringern."
L["Color aurabar debuffs by type."] = "Färbe Schwächungszauber nach Typ."
L["Color castbars by the class of player units."] = "Fäbre die Zauberleiste entsprechend ihrer Klasse."
L["Color castbars by the reaction type of non-player units."] = "Färbe die Zauberleiste entsprechend der Reaktion der Einheit."
L["Color health by amount remaining."] = "Färbe die Gesundheitsleiste entsprechend der aktuell verbleibenden Lebenspunkte"
L["Color health by classcolor or reaction."] = "Gesundheitsfarbe nach Klassenfarbe oder Reaktion."
L["Color power by classcolor or reaction."] = "Färbe die Kraftleiste entsprechend ihrer Klasse."
L["Color the health backdrop by class or reaction."] = "Färbe den Gesundheitshintergrund nach Klasse oder Reaktion."
L["Color the unit healthbar if there is a debuff that can be dispelled by you."] = "Aktiviere die Hervorhebung von Einheitenfenstern, wenn ein von dir bannbarer Schwächungszauber vorhanden ist."
L["Color Turtle Buffs"] = "Färbe Turtle Stärkungszauber"
L["Colored Icon"] = "Buntes Symbol"
L["Coloring (Specific)"] = "Färben (Spezifisch)"
L["Coloring"] = "Färben"
L["Combat Fade"] = "Im Kampf einblenden"
L["Combat Icon"] = "Kampfsymbol"
L["Combo Point"] = "Kombopunkt"
L["Configure Auras"] = "Konfiguriere Auren"
L["Copy From"] = "Kopieren von"
L["Count Font Size"] = "Schriftart Größe der Anzahl"
L["Create a custom fontstring. Once you enter a name you will be able to select it from the elements dropdown list."] = "Erstelle einen benutzerdefinierten Anzeigetext. Sobald du einen Namen eingibst, wirst du ihn von der Dropdown-Liste auswählen können."
L["Create a filter, once created a filter can be set inside the buffs/debuffs section of each unit."] = "Erstelle einen Filter. Ist dieser Filter einmal erstellt, kann er bei jeder Einheit im Bereich Stärkungszauber/Schwächungszauber ausgewählt werden."
L["Create Filter"] = "Filter erstellen"
L["Current - Max | Percent"] = "Aktuell - Maximal | Prozent"
L["Current - Max"] = "Aktuell - Maximal"
L["Current - Percent"] = "Aktuell - Prozent"
L["Current / Max"] = "Aktuell / Maximal"
L["Current"] = "Aktuell"
L["Custom Dead Backdrop"] = "Benutzerdefinierte Hintergrundfarbe vom Tod"
L["Custom Health Backdrop"] = "Benutzerdefinierte Hintergrundfarbe vom Leben"
L["Custom Texts"] = "Benutzerdefinierte Texte"
L["Debuff Highlighting"] = "Hervorhebung von Schwächungszaubern"
L["Debuffs"] = "Schwächungszauber"
L["Decimal Threshold"] = "Dezimaler Schwellenwert"
L["Deficit"] = "Unterschied"
L["Delete a created filter, you cannot delete pre-existing filters, only custom ones."] = "Entferne einen erstellten Filter. Es können nur benutzerdefinierte Filter entfernt werden."
L["Delete Filter"] = "Filter löschen"
L["Detach From Frame"] = "Vom Fenster lösen"
L["Detached Width"] = "Freistehendes Breite"
L["Direction the health bar moves when gaining/losing health."] = "Richtung in die sich die Lebensleiste aufbaut, wenn man Leben gewinnt oder verliert."
L["Disable Debuff Highlight"] = "Deaktiviere Schwächungszauber-Hervorhebung"
L["Disabled Blizzard Frames"] = "Deaktivierte Blizzard Fenster"
L["Disables the focus and target of focus unitframes."] = "Deaktiviert das Fokus und Fokus-Ziel Einheitenfenster."
L["Disables the player and pet unitframes."] = "Deaktiviert das Spieler und Begleiter Einheitenfenster."
L["Disables the target and target of target unitframes."] = "Deaktiviert das Ziel und Ziel des Ziels Einheitenfenster."
L["Disconnected"] = "Nicht Verbunden"
L["Display a spark texture at the end of the castbar statusbar to help show the differance between castbar and backdrop."] = "Zeigt eine funkelnde Textur am Ende des Zauberbalken um den Unterschied zwischen Zauberbalken und Hintergrund zu verdeutlichen."
L["Display Frames"] = "Zeige Fenster"
L["Display icon on arena frame indicating the units talent specialization or the units faction if inside a battleground."] = "Zeige ein Symbol auf dem Arenafenster, welches innerhalb eines Schlachtfeldes die Talentspezialisierung oder die Fraktion anzeigt."
L["Display Player"] = "Zeige Spieler"
L["Display Target"] = "Zeige Ziel"
L["Display Text"] = "Zeige Text"
L["Display the castbar icon inside the castbar."] = "Zeigt das Zauberleisten Symbol in der Zauberleiste."
L["Display the castbar inside the information panel, the icon will be displayed outside the main unitframe."] = "Zeige die Zauberleiste im Information Panel, das Symbol wird ausserhalb des Einheitenfenster angezeigt."
L["Display the combat icon on the unitframe."] = "Zeige das Kampfsymbol auf den Einheitenfenster."
L["Display the rested icon on the unitframe."] = "Zeige das Ausgeruht-Symbol auf den Einheitenfenstern."
L["Display the target of your current cast. Useful for mouseover casts."] = "Zeige das Ziel deines derzeitigen Zaubers, für Mouseover Zauber nützlich"
L["Display tick marks on the castbar for channelled spells. This will adjust automatically for spells like Drain Soul and add additional ticks based on haste."] = "Anzeige der Zauberbalkenticks für kanalisierte Zauber. Dies ändert sich automatisch für Zauber wie Seelendieb, wenn zusätzliche Ticks durch einen hohen Tempowert entstehen."
L["Don't display any auras found on the 'Blacklist' filter."] = "Zeige keinerlei Auren die sich im 'Schwarzenlisten' filter befinden."
L["Don't display auras that are longer than this duration (in seconds). Set to zero to disable."] = "Keine Auren anzeigen die länger als diese Dauer (in Sekunden) sind"
L["Don't display auras that are not yours."] = "Zeige keine Auren die nicht von dir sind."
L["Don't display auras that are shorter than this duration (in seconds). Set to zero to disable."] = "Zeige keine Auren die kürzer als die Dauer (in Sekunden) sind. Auf 0 stellen um zu deaktivieren."
L["Don't display auras that cannot be purged or dispelled by your class."] = "Zeige keine Auren die nicht von deiner Klasse entzaubert oder gereinigt werden kann."
L["Don't display auras that have no duration."] = "Zeige keine Auren die keine Laufzeit haben."
L["Down"] = "Hinunter"
L["Duration Reverse"] = "Dauer umkehren"
L["Duration Text"] = "Dauer Text"
L["Duration"] = "Dauer"
L["Enabling this allows raid-wide sorting however you will not be able to distinguish between groups."] = "Aktivieren dieses Punktes erlaubt Raidweites sortieren, allerdings wirst du nicht zwischen Gruppen unterscheiden können"
L["Enabling this inverts the grouping order when the raid is not full, this will reverse the direction it starts from."] = "Aktivieren dieses Punktes kehrt die Gruppierungsrichtung um wenn der Raid nicht voll ist, die Startrichtung wird ebenfalls umgekehrt"
L["Enemy Aura Type"] = "Feindlicher Aurentyp"
L["Fade the unitframe when out of combat, not casting, no target exists."] = "Blende die Haupteinheitenfenster aus, wenn du dich nicht im Kampf befindest, keine Zauber wirkst oder kein Ziel anvisierst."
L["Fill"] = "Füllen"
L["Filled"] = "Gefüllt"
L["Filter Type"] = "Filter Typ"
L["Fluid Position Buffs on Debuffs"] = "Flüssige Position Stärkungszauber auf Schwächungszauber"
L["Fluid Position Debuffs on Buffs"] = "Flüssige Position Schwächungszauber auf Stärkungszauber"
L["Force Off"] = "Gezwungen aus"
L["Force On"] = "Gezwungen an"
L["Force Reaction Color"] = "Erzwinge Reaktionsfarbe"
L["Force the frames to show, they will act as if they are the player frame."] = "Zwinge die Fenster sichtbar zu werden. Diese Fenster werden sich wie das Spielerfenster verhalten."
L["Forces Debuff Highlight to be disabled for these frames"] = "Erzwinge die deaktivierung der Schwächungszauber-Hervorhebung für diese Fenster"
L["Forces reaction color instead of class color on units controlled by players."] = "Erzwinge Reaktionsfarbe anstatt Klassenfarbe auf übernommene Einheiten."
L["Format"] = "Formatierung"
L["Frame Level"] = "Fenster Ebene"
L["Frame Orientation"] = "Fenster Ausrichtung"
L["Frame Strata"] = "Fenster Schicht"
L["Frame"] = "Fenster"
L["Frequent Updates"] = "Häufigkeit der Aktualisierung"
L["Friendly Aura Type"] = "Freundlicher Aurentyp"
L["Friendly"] = "Freundlich"
L["Glow"] = "Glanz"
L["Good"] = "Gut"
L["Group By"] = "Gruppiert durch"
L["Grouping & Sorting"] = "Gruppierung und Sortierung"
L["Groups Per Row/Column"] = "Gruppen per Reihe/Spalte"
L["Growth direction from the first unitframe."] = "Wachstumsrichtung von dem ersten Einheitenfenster."
L["Growth Direction"] = "Wachstumsrichtung"
L["Heal Absorbs"] = "Heilung Absorbierungen"
L["Heal Prediction"] = "Eingehende Heilung"
L["Health Backdrop"] = "Gesundheitshintergrund"
L["Health Border"] = "Gesundheitsumrandung"
L["Health By Value"] = "Gesundheit nach dem Wert"
L["Health"] = "Leben"
L["Height"] = "Höhe"
L["Horizontal Spacing"] = "Horizontaler Abstand"
L["Horizontal"] = "Horizontal" --Also used in bags module
L["How far away the portrait is from the camera."] = "Entfernung der Kamera vom Portrait."
L["Icon Inside Castbar"] = "Symbol innerhalb Zauberleiste"
L["Icon Size"] = "Symbol Größe"
L["Icon"] = "Symbol"
L["Icon: BOTTOM"] = "Symbol: UNTEN"
L["Icon: BOTTOMLEFT"] = "Symbol: UNTENLINKS"
L["Icon: BOTTOMRIGHT"] = "Symbol: UNTENRECHTS"
L["Icon: LEFT"] = "Symbol: LINKS"
L["Icon: RIGHT"] = "Symbol: RECHTS"
L["Icon: TOP"] = "Symbol: OBEN"
L["Icon: TOPLEFT"] = "Symbol: OBENLINKS"
L["Icon: TOPRIGHT"] = "Symbol: OBENRECHTS"
L["If no other filter options are being used then it will block anything not on the 'Whitelist' filter, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = "Wenn du keine anderen Filteroptionen verwendest werden alle Filter blockiert die nicht im 'Weisenfilter' stehen, sonst füge einfach Auren der Weisenliste hinzu zusätzlich zu den anderen Filter Einstellungen."
L["If not set to 0 then override the size of the aura icon to this."] = "Wenn dieser Wert nicht auf 0 gesetzt wird, dann überschreibt dieser die größe des Aurensymbols."
L["If the unit is an enemy to you."] = "Wenn die Einheit feindlich zu dir ist."
L["If the unit is friendly to you."] = "Wenn die Einheit freundlich zu dir ist."
L["If you have a lot of 3D Portraits active then it will likely have a big impact on your FPS. Disable some portraits if you experience FPS issues."] = "Wenn du viele 3D Portraits aktiviert hast, wird es voraussichtlich enorm auf deine FPS auswirken. Deaktiviere bitte einige 3D Portraits sollte das der Fall sein."
L["Ignore mouse events."] = "Ignoriere Maus Events."
L["InfoPanel Border"] = "InfoPanel Rand"
L["Information Panel"] = true; --no need to translate this
L["Inset"] = "Einsatz"
L["Inside Information Panel"] = "Im Information Panel"
L["Interruptable"] = "Unterbrechbar"
L["Invert Grouping Order"] = "Gruppierungsreihenfolge umkehren"
L["JustifyH"] = "RechtfertigenH"
L["Latency"] = "Latenz"
L["Left to Right"] = "Links nach Rechts"
L["Main statusbar texture."] = "Haupt-Statusleisten Textur"
L["Main Tanks / Main Assist"] = "Haupt Tank / Haupt Assistent"
L["Make textures transparent."] = "Mache Texturen transparent."
L["Match Frame Width"] = "Passende Fensterbreite"
L["Max amount of overflow allowed to extend past the end of the health bar."] = "Maximale Menge des erlaubten Overflows um das Ende der Gesundheitsleiste zu erweitern."
L["Max Bars"] = "Leisten Anzahl"
L["Max Overflow"] = "Maximaler Overflow"
L["Maximum Duration"] = "Maximale Dauer"
L["Method to sort by."] = "Methode nach dem sortiert werden soll."
L["Middle Click - Set Focus"] = "Mittelklick - Setze Fokus"
L["Middle clicking the unit frame will cause your focus to match the unit."] = "Mittelklicken des Einheitenfensters passt deinen Fokus an die Einheit an."
L["Middle"] = "Mitte"
L["Minimum Duration"] = "Minimale Dauer"
L["Model Rotation"] = "Modellrotation"
L["Mouseover"] = "Mouseover"
L["Name"] = "Name" --Also used in Buffs and Debuffs
L["Neutral"] = "Neutral"
L["Non-Interruptable"] = "Nicht-Unterbrechbar"
L["Not valid spell id"] = "Keine gültige Zauber ID"
L["Num Rows"] = "Anzahl der Reihen"
L["Number of Groups"] = "Nummer der Gruppen"
L["Offset of the powerbar to the healthbar, set to 0 to disable."] = "Versatz der Powerleiste zu der Lebensleiste. Setze es auf 0 um den Versatz zu deaktivieren."
L["Offset position for text."] = "Versatz Positionen für Texte."
L["Offset"] = "Versatz"
L["OOR Alpha"] = "Außer Reichweite Alpha"
L["Others"] = "Andere"
L["Overlay the healthbar"] = "Überblendung der Gesundheitsleiste"
L["Overlay"] = "Überblenden"
L["Override any custom visibility setting in certain situations, EX: Only show groups 1 and 2 inside a 10 man instance."] = "Überschreibe alle benutzerdefinierten Einstellungen für die Sichtbarkeit in bestimmten Situationen. Beispiel: Zeige nur Gruppe 1 und 2 in einer 10er-Instanz."
L["Override the default class color setting."] = "Überschreibe die Standard Klassenfarben Einstellungen"
L["Owners Name"] = "Name des Besitzers"
L["Parent"] = true; --no need to translate this
L["Party Pets"] = "Gruppenbegleiter"
L["Party Targets"] = "Gruppenziele"
L["Per Row"] = "Pro Reihe"
L["Percent"] = "Prozent"
L["Personal"] = "Persönlich"
L["Pet Name"] = "Name des Pets"
L["Player Frame Aura Bars"] = "Spielerfenster Aurenleiste"
L["Portrait"] = "Portrait"
L["Position Buffs on Debuffs"] = "Positioniere Stärkungszauber zu Schwächungszauber"
L["Position Debuffs on Buffs"] = "Positioniere Schwächungszauber zu Stärkungszauber"
L["Position the Model horizontally."] = "Positioniere das Model horizontal."
L["Position the Model vertically."] = "Positioniere das Model vertikal."
L["Position"] = "Position"
L["Power text will be hidden on NPC targets, in addition the name text will be repositioned to the power texts anchor point."] = "Der Krafttext wird bei NPC-Zielen automatisch verborgen, zusätzlich wird der Namenstext relativ zu dem Energie/Mana-Ankerpunkt umpositioniert."
L["Power"] = "Kraft"
L["Powers"] = "Kräfte"
L["Priority"] = "Priorität"
L["Profile Specific"] = "Profilspezifisch"
L["PvP & Prestige Icon"] = "PvP & Prestige Symbol"
L["PvP Text"] = true; --no need to translate
L["PVP Trinket"] = "PVP Schmuck"
L["Raid Icon"] = "Schlachtzugssymbol"
L["Raid-Wide Sorting"] = "Raidweite Sortierung"
L["Raid40 Frames"] = "40er Schlachtzugsfenster"
L["RaidDebuff Indicator"] = "RaidDebuff Indikator"
L["Range Check"] = "Entfernungcheck"
L["Rapidly update the health, uses more memory and cpu. Only recommended for healing."] = "Schnelle Aktualisierung der Lebensleiste. Benutzt mehr Speicher und Prozessorleistung. Nur für Heiler zu empfehlen."
L["Reaction Castbars"] = "Reaktion Zauberleiste"
L["Reactions"] = "Reaktionen"
L["Ready Check Icon"] = "Bereitschaftssymbol"
L["Remaining"] = "Verbleibend"
L["Remove a spell from the filter. Use the spell ID if you see the ID as part of the spell name in the filter."] = "Entferne Zauber vom Filter. Benutze die Zauber ID, wenn du die ID siehst als Teil vom Zaubernamen im Filter."
L["Remove a spell from the filter."] = "Entfernt einen Zauber aus dem Filter."
L["Remove Spell ID or Name"] = "Entferne Zauber ID oder Name"
L["Remove SpellID"] = "Entferne Zauber ID"
L["Rest Icon"] = "Ausgeruht-Symbol"
L["Restore Defaults"] = "Standard wiederherstellen" --Also used in General and ActionBars sections
L["Right to Left"] = "Rechts nach Links"
L["RL / ML Icons"] = "RL / ML Symbole"
L["Role Icon"] = "Rollensymbol"
L["Seconds remaining on the aura duration before the bar starts moving. Set to 0 to disable."] = "Verbleibende Sekunden auf der Aura bis sie sich bewegt. Auf 0 setzen zum deaktivieren."
L["Select a unit to copy settings from."] = "Wähle eine Einheit um Einstellungen zu kopieren."
L["Select an additional filter to use. If the selected filter is a whitelist and no other filters are being used (with the exception of Block Non-Personal Auras) then it will block anything not on the whitelist, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = "Wähle einen Filter zum zusätzlichen verwenden. Wenn der ausgewählte Filter in einer Weisenliste ist und keine anderen Filter verwendet werden (mit Ausnahme von Blocke Nicht- Persönliche Auren), dann wird alles was nicht auf der Weisenliste steht blockiert, sonst füge einfach Auren der Weisenliste hinzu zusäzlich zu den anderen Filter Einstellungen."
L["Select Filter"] = "Filter auswählen"
L["Select Spell"] = "Zauber auswählen"
L["Select the display method of the portrait."] = "Wähle das Anzeigemethode für das Portrait."
L["Set the filter type. Blacklist will hide any auras in the list and show all others. Whitelist will show any auras in the filter and hide all others."] = "Wähle den Filtertyp. Blacklist versteckt alle Auren in der Liste und zeigt den Rest an. Whitelist zeigt alle Auren in der Liste an und versteckt den Rest."
L["Set the font size for unitframes."] = "Wähle die Schriftart für die Einheitenfenster."
L["Set the order that the group will sort."] = "Wähle die Richtung in welche die Gruppe sortiert werden soll."
L["Set the orientation of the UnitFrame."] = "Setzt die Ausrichtung des Einheitenfensters."
L["Set the priority order of the spell, please note that prioritys are only used for the raid debuff module, not the standard buff/debuff module. If you want to disable set to zero."] = "Wähle die Priorität des Zaubers. Bitte beachte, dass sich die Priorität nur auf das Schlachtzugsschwächungszauber-Modul auswirkt und nicht auf das Standard-Stärkungs/Schwächungszauber-Modul. Möchtest du es deaktivieren, dann setze es auf 0."
L["Set the type of auras to show when a unit is a foe."] = "Wähle den Aurentyp, der angezeigt werden soll, wenn das Ziel feindlich ist."
L["Set the type of auras to show when a unit is friendly."] = "Wähle den Aurentyp, der angezeigt werden soll, wenn das Ziel freundlich ist."
L["Sets the font instance's horizontal text alignment style."] = "Wähle die Schriftart Instanz horizontal zur Ausrichtung des Textes Stils."
L["Show a incomming heal prediction bar on the unitframe. Also display a slightly different colored bar for incoming overheals."] = "Zeige eingehende Heilung im Einheitenfenster. Zeigt eine etwas anders farbige Leiste für eingehende Überheilung."
L["Show Aura From Other Players"] = "Zeige Auren von anderen Spielern"
L["Show Auras"] = "Zeige Auren"
L["Show Dispellable Debuffs"] = "Zeige stehlbare Schwächungszauber"
L["Show For DPS"] = "Zeige für Schadensklassen"
L["Show For Healers"] = "Zeige für Heiler"
L["Show For Tanks"] = "Zeige für Tanks"
L["Show When Not Active"] = "Zeige, wenn nicht aktiv"
L["Size and Positions"] = "Größe und Positionen"
L["Size of the indicator icon."] = "Größe des Anzeigesymbole."
L["Size Override"] = "Größe überschreiben"
L["Size"] = "Größe"
L["Smart Aura Position"] = "Intelligente Aurenposition"
L["Smart Raid Filter"] = "Intelligenter Raid-Filter"
L["Smooth Bars"] = "Sanfte Leistenübergänge"
L["Sort By"] = "Sortieren nach"
L["Spaced"] = "Abgetrennt"
L["Spacing"] = "Abstand"
L["Spark"] = "Funken"
L["Spec Icon"] = "Talentspezialisierungssymbol"
L["Stack Counter"] = "Stapel Zähler"
L["Stack Threshold"] = "Stapel Schwellenwert"
L["Start Near Center"] = "Starte nahe der Mitte"
L["Statusbar Fill Orientation"] = "Füllrichtung der Statusleiste"
L["StatusBar Texture"] = "Statusleistentextur"
L["Strata and Level"] = "Schicht und Ebene"
L["Style"] = "Stil"
L["Tank Frames"] = "Tank Fenster"
L["Tank Target"] = "Tank Ziel"
L["Tapped"] = "Angeschlagen"
L["Target Glow"] = "Ziel Leuchten"
L["Target On Mouse-Down"] = "Ziel bei Maus-Runter"
L["Target units on mouse down rather than mouse up. \n\n|cffFF0000Warning: If you are using the addon 'Clique' you may have to adjust your clique settings when changing this."] = "Nimmt die Einheit ins Ziel bei Maus-Runter anstatt bei Maus-Hoch. |cffFF0000Warnung: Wenn du das Addon 'Clique' benutzt musst du das auch in den Clique Einstellungen ändern wenn du das hier benutzt."
L["Text Color"] = "Text Farbe"
L["Text Format"] = "Textformat"
L["Text Position"] = "Text Position"
L["Text Threshold"] = "Text Schwelle"
L["Text Toggle On NPC"] = "Textumschalter auf NPCs"
L["Text xOffset"] = "Text X-Versatz"
L["Text yOffset"] = "Text Y-Versatz"
L["Text"] = "Text"
L["Textured Icon"] = "Texturiertes Symbol"
L["The alpha to set units that are out of range to."] = "Setzt den Alphabereich für Einheiten, die ausserhalb deiner Reichweite sind."
L["The debuff needs to reach this amount of stacks before it is shown. Set to 0 to always show the debuff."] = "Der Schwächungszauber muss erst den angegebenen Wert erreichen um angezeigt zu werden. 0 zeigt den Schwächungszauber immer an."
L["The following macro must be true in order for the group to be shown, in addition to any filter that may already be set."] = "Das folgende Makro muss wahr sein um die Gruppe anzuzeigen. Dies gilt zusätzlich zu jeglichem Filter der möglicherweise bereits eingestellt ist."
L["The font that the unitframes will use."] = "Die Schriftart, welche die Einheitenfenster benutzen sollen."
L["The initial group will start near the center and grow out."] = "Die anfängliche Gruppe wird nahe der Mitte starten und dann wachsen"
L["The name you have selected is already in use by another element."] = "Den Namen den du ausgewählt hast, wird bereits von einem anderem Element benutzt."
L["The object you want to attach to."] = "Das Objekt, das du anhängen willst"
L["Thin Borders"] = "Dünne Rahmen"
L["This dictates the size of the icon when it is not attached to the castbar."] = "Dieses zwingt die Größe des Symbols wenn es nicht an der Zauberleiste angehängt ist."
L["This opens the UnitFrames Color settings. These settings affect all unitframes."] = "Dieses öffnet die Farbeinstellung für die Einheitenfenster. Diese Einstellungen wirken sich auf alle Einheitenfenster aus."
L["Threat Display Mode"] = "Bedrohungs Anzeige Modus"
L["Threshold before text goes into decimal form. Set to -1 to disable decimals."] = "Schwellenwert bevor der Text in die Dezimalform wechselt. Auf -1 setzen, um Dezimalstellen zu deaktivieren."
L["Ticks"] = "Ticks"
L["Time Remaining Reverse"] = "Zeit verbleibend umkehren"
L["Time Remaining"] = "Zeit verbleibend"
L["Transparent"] = "Transparent"
L["Turtle Color"] = "Turtle Farbe"
L["Uniform Threshold"] = "Einheitlicher Schwellenwert"
L["UnitFrames"] = "Einheitenfenster"
L["Up"] = "Hinauf"
L["Use Custom Level"] = "Benutze benutzerdefinierte Ebene"
L["Use Custom Strata"] = "Benutze benutzerdefinierte Schicht"
L["Use Dead Backdrop"] = "Benutze Hintergrundfarbe vom Tod"
L["Use Default"] = "Benutze Standard"
L["Use the custom health backdrop color instead of a multiple of the main health color."] = "Wähle eine eigene Hintergrundfarbe, andernfalls wird die aktuelle Gesundheitsleistenfarbe verwendet."
L["Use the profile specific filter 'Buff Indicator (Profile)' instead of the global filter 'Buff Indicator'."] = "Benutze den Profilspezifischen 'Buff Indikator (Profil)' anstatt des globalen Filter 'Buff Indikator'."
L["Use thin borders on certain unitframe elements."] = "Benutze dünne Rahmen auf bestimmten Einheitenfenster Elementen."
L["Use this backdrop color for units that are dead or ghosts."] = "Benutze diese Hintergrundfarbe für Einheiten die Tod oder als Geist sind."
L["Value must be a number"] = "Der Wert muss eine Zahl sein"
L["Vertical Orientation"] = "Vertikale Ausrichtung"
L["Vertical Spacing"] = "Vertikaler Abstand"
L["Vertical"] = "Vertikal" --Also used in bags section
L["Visibility"] = "Sichtbarkeit"
L["What point to anchor to the frame you set to attach to."] = "Welchen Punkt für das verankern der Fenster möchtest du wählen."
L["What to attach the buff anchor frame to."] = "Wo die Stärkungszauber angehängt werden sollen."
L["What to attach the debuff anchor frame to."] = "Wo die Schwächungszauber angehängt werden sollen."
L["When true, the header includes the player when not in a raid."] = "Wenn aktiv und sich der Spieler nicht in einem Raid befindet, dann wird das angezeigt."
L["Whitelist"] = "Weiße Liste"
L["Width"] = "Breite" --Also used in NamePlates module
L["Will show Buffs in the Debuff position when there are no Debuffs active, or vice versa."] = "Zeigt Stärkungszauber auf der Position der Schwächungszauber, wenn kein Schwächungszauber aktiv ist und vice versa."
L["xOffset"] = "X-Versatz"
L["yOffset"] = "Y-Versatz" --Another variation in bags section Y Offset
L["You can't remove a pre-existing filter."] = "Du kannst einen vorgefertigten Filter nicht löschen."
L["You cannot copy settings from the same unit."] = "Du kannst keine Einstellungen von der gleichen Einheit kopieren."
L["You may not remove a spell from a default filter that is not customly added. Setting spell to false instead."] = "Du kannst keinen Filter entfernen, der nicht von dir selbst hinzugefügt wurde. Setzte den Zauber einfach auf deaktiviert."
L["You need to hold this modifier down in order to blacklist an aura by right-clicking the icon. Set to None to disable the blacklist functionality."] = "Du musst den Modifikator gedrückt halten um mit rechtsklick auf ein Symbol es zur Schwarzen Liste hinzuzufügen. Setzte auf 'Kein' um die Funktion zu deaktivieren."
