-- French localization file for frFR.
local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("ElvUI", "frFR");
if not L then return; end

-- *_DESC locales
L["AURAS_DESC"] = "Configure les icônes qui apparaissent près de la Minicarte."
L["BAGS_DESC"] = "Ajuster les paramètres des sacs pour ElvUI."
L["CHAT_DESC"] = "Ajuste les paramètres du Chat pour ElvUI."
L["DATATEXT_DESC"] = "Affiche à l'écran des textes d'informations."
L["ELVUI_DESC"] = "ElvUI est une interface de remplacement complète pour World of Warcraft"
L["NAMEPLATE_DESC"] = "Modifier la configuration des noms d'unités"
L["UNITFRAME_DESC"] = "Modify the unitframe settings."
L["ACTIONBARS_DESC"] = "Modify the actionbar settings."
L["PANEL_DESC"] = "Ajuste la largeur et la hauteur des fenêtres de chat, cela ajuste aussi les sacs."
L["SKINS_DESC"] = "Ajuste les paramètres d'habillage."
L["TOGGLESKIN_DESC"] = "Active ou désactive l'habillage ElvUI des éléments ci-dessous."
L["TOOLTIP_DESC"] = "Configuration des Infobulles."
L["SEARCH_SYNTAX_DESC"] = [=[With the new addition of LibItemSearch, you now have access to much more advanced item searches. The following is a documentation of the search syntax. See the full explanation at: https://github.com/Jaliborc/LibItemSearch-1.2/wiki/Search-Syntax.

Specific Searching:
    • q:[quality] or quality:[quality]. For instance, q:epic will find all epic items.
    • l:[level], lvl:[level] or level:[level]. For example, l:30 will find all items with level 30.
    • t:[search], type:[search] or slot:[search]. For instance, t:weapon will find all weapons.
    • n:[name] or name:[name]. For instance, typing n:muffins will find all items with names containing "muffins".
    • s:[set] or set:[set]. For example, s:fire will find all items in equipment sets you have with names that start with fire.
    • tt:[search], tip:[search] or tooltip:[search]. For instance, tt:binds will find all items that can be bound to account, on equip, or on pickup.


Search Operators:
    • ! : Negates a search. For example, !q:epic will find all items that are NOT epic.
    • | : Joins two searches. Typing q:epic | t:weapon will find all items that are either epic OR weapons.
    • & : Intersects two searches. For instance, q:epic & t:weapon will find all items that are epic AND weapons
    • >, <, <=, => : Performs comparisons on numerical searches. For example, typing lvl: >30 will find all items with level HIGHER than 30.


The following search keywords can also be used:
    • soulbound, bound, bop : Bind on pickup items.
    • bou : Bind on use items.
    • boe : Bind on equip items.
    • boa : Bind on account items.
    • quest : Quest bound items.
    • reagents, reagent, crafting : Profession reagents.
    • naval : Naval equipment.
    • follower, followe, follow : Follower items.
    • relic, reli, rel : Artifact Relics.
    • power, powe, pow : Items granting Artifact Power.]=];
L["TEXT_FORMAT_DESC"] = [=[Entrer une séquence pour changer le format du texte.

Exemples:
[namecolor][name] [difficultycolor][smartlevel] [shortclassification]
[healthcolor][health:current-max]
[powercolor][power:current]

Formats de la Vie / des Ressources:
'current' - Quantité actuelle
'percent' - Quantité en pourcentage
'current-max' - Quantité actuelle maximale, n'affichera seulement la quantité maximale si la quantité actuelle est égale au maximum.
'current-percent' - Quantité actuelle suivie par quantité en pourcentage, n'affichera seulement la quantité maximale si la quantité actuelle est égale au maximum
'current-max-percent' -  Quantité actuelle, quantité maximale, suivie par quantité en pourcentage, n'affichera seulement la quantité maximale si la quantité actuelle est égale au maximum
'deficit' - Affiche la valeur du déficit, n'affichera rien si il n'y a pas de déficit

Format des Noms:
'name:short' - Nom limité à 10 caractères
'name:medium' - Nom limité à 15 caractères
'name:long' - Nom limité à 20 caractères

Pour désactiver, laisser le champs vide. Pour plus d'information, merci de visiter http://www.tukui.org]=];

--ActionBars
L["Action Paging"] = "Pagination d'action"
L["ActionBars"] = "Barres d'actions"
L["Allow Masque to handle the skinning of this element."] = "Autoriser Masque à gérer l'habillage de cet élement.";
L["Alpha"] = "Alpha"
L["Anchor Point"] = "Point d'ancrage" --also in unitframes
L["Automatic"] = "Auto"
L["Backdrop Spacing"] = true;
L["Backdrop"] = "Fond"
L["Button Size"] = "Taille des boutons"
L["Button Spacing"] = "Espacement des boutons"
L["Buttons Per Row"] = "Boutons par ligne"
L["Buttons"] = "Boutons"
L["Change the alpha level of the frame."] = "Changer le niveau alpha de la fenêtre."
L["Color of the actionbutton when not usable."] = true;
L["Color of the actionbutton when out of power (Mana, Rage, Focus, Holy Power)."] = "Couleur du bouton d'action quand il n'y a pas ressource (Mana, Rage, Focalisation, Puissance sacrée)."
L["Color of the actionbutton when out of range."] = "Couleur du bouton d'action quand hors de portée."
L["Color of the actionbutton when usable."] = true;
L["Color when the text is about to expire"] = "Couleur lorsque le texte est sur le point d'expirer."
L["Color when the text is in the days format."] = "Couleur quand le texte est exprimé en jours."
L["Color when the text is in the hours format."] = "Couleur quand le texte est exprimé en heure."
L["Color when the text is in the minutes format."] = "Couleur quand le texte est exprimé en minute."
L["Color when the text is in the seconds format."] = "Couleur quand le texte est exprimé en seconde."
L["Cooldown Text"] = "Texte temps de recharge"
L["Darken Inactive"] = "Foncé Inactif"
L["Days"] = "Jours"
L["Display bind names on action buttons."] = "Affiche les noms des raccourcis sur les boutons de la barre d'action."
L["Display cooldown text on anything with the cooldown spiral."] = "Affiche le temps de recharge au format numérique plutôt que la spirale d'origine."
L["Display macro names on action buttons."] = "Affiche les noms des macros sur les boutons dans la barre d'action."
L["Expiring"] = "Expiration"
L["Flyout Direction"] = true;
L["Global Fade Transparency"] = true;
L["Height Multiplier"] = "Multiplicateur hauteur"
L["Hide Cooldown Bling"] = "Masquer l'effet du temps de recharge";
L["Hides the bling animation on buttons at the end of the global cooldown."] = "Cacher l'animation des boutons à la fin du rechargement global.";
L["Hours"] = "Heures"
L["If you unlock actionbars then trying to move a spell might instantly cast it if you cast spells on key press instead of key release."] = true;
L["Inherit Global Fade"] = true;
L["Inherit the global fade, mousing over, targetting, setting focus, losing health, entering combat will set the remove transparency. Otherwise it will use the transparency level in the general actionbar settings for global fade alpha."] = true;
L["Key Down"] = "Touche enfoncée"
L["Keybind Mode"] = "Mode raccourcis"
L["Keybind Text"] = "Texte des raccourcis"
L["Low Threshold"] = "Seuil minimal"
L["Macro Text"] = "Texte sur Macro"
L["Masque Support"] = "Support de Maque";
L["Minutes"] = "Minutes"
L["Mouse Over"] = "Au survol"
L["Multiply the backdrops height or width by this value. This is usefull if you wish to have more than one bar behind a backdrop."] = "Multiplie la hauteur ou la largeur de l'arrière-plan par cette valeur. Très utile si vous souhaitez avoir une barre de plus en arrière-plan."
L["Not Usable"] = true;
L["Out of Power"] = "Sans ressource"
L["Out of Range"] = "Hors de portée"
L["Restore Bar"] = "Restaurer la barre"
L["Restore the actionbars default settings"] = "Restaure la barre d'actions avec ses paramètres par défaut."
L["Seconds"] = "Secondes"
L["Show Empty Buttons"] = true;
L["Shows a swipe animation when a spell is recharging but still has charges left."] = true;
L["The amount of buttons to display per row."] = "Nombre de boutons à afficher par ligne."
L["The amount of buttons to display."] = "Nombre de boutons à afficher."
L["The button you must hold down in order to drag an ability to another action button."] = "Définir la touche qui doit être maintenue enfoncée pour pouvoir glisser une capacité sur un autre bouton d'action."
L["The first button anchors itself to this point on the bar."] = "Ancrage du premier bouton sur le point de la barre."
L["The size of the action buttons."] = "Taille des boutons d'action."
L["The spacing between the backdrop and the buttons."] = true;
L["This setting will be updated upon changing stances."] = "Ce réglage sera activé lors d'un changement de posture"
L["Threshold before text turns red and is in decimal form. Set to -1 for it to never turn red"] = "Seuil avant que le texte devienne rouge sous forme de décimal. Mettre -1 pour qu'il ne devienne jamais rouge."
L["Toggles the display of the actionbars backdrop."] = "Affiche ou non la couleur de fond de la barre d'action."
L["Transparency level when not in combat, no target exists, full health, not casting, and no focus target exists."] = true;
L["Usable"] = true;
L["Use Draw Swipe"] = true;
L["Use Position Override"] = true;
L["Visibility State"] = "État de visibilité"
L["When enabled it will use the Anchor Point setting to determine growth direction, otherwise it will be determined by where the bar is positioned."] = true;
L["Width Multiplier"] = "Multiplicateur largeur"
L["Zone Ability"] = true;
L[ [=[This works like a macro, you can run different situations to get the actionbar to page differently.
 Example: '[combat] 2;']=] ] = [=[Ceci fonctionne comme une macro, vous pouvez exécuter différentes situations pour avoir une pagination de la barre d'actions différente.
Exemple: '[combat] 2;']=]
L[ [=[This works like a macro, you can run different situations to get the actionbar to show/hide differently.
 Example: '[combat] show;hide']=] ] = [=[Ceci fonctionne comme une macro, vous pouvez exécuter différentes situations pour afficher ou masquer la barre d'actions différemment.
Exemple: '[combat] show;hide']=]

--Bags
L["Add an item or search syntax to the ignored list. Items matching the search syntax will be ignored."] = true;
L["Add Item or Search Syntax"] = true;
L["Adjust the width of the bag frame."] = "Ajuster la largeur de la fenêtre du sac."
L["Adjust the width of the bank frame."] = "Ajuster la largeur de la fenêtre du sac de banque."
L["Ascending"] = "Ascendant"
L["Bag Sorting"] = "Tri des sacs";
L["Bag-Bar"] = "Barre des sacs"
L["Bar Direction"] = "Direction de la barre"
L["Blizzard Style"] = "Style Blizzard";
L["Bottom to Top"] = "Du bas vers le haut"
L["Button Size (Bag)"] = "Taille des boutons (Sac)"
L["Button Size (Bank)"] = "Taille des boutons (Banque)"
L["Clear Search On Close"] = true;
L["Condensed"] = "Condensé";
L["Currency Format"] = "Format monétaire"
L["Descending"] = "Descendant"
L["Direction the bag sorting will use to allocate the items."] = "Direction du tri du sac qui sera utilisé pour allouer les objets."
L["Disable Bag Sort"] = true;
L["Disable Bank Sort"] = true;
L["Display Item Level"] = "Afficher le niveau d'objet";
L["Display the junk icon on all grey items that can be vendored."] = "Afficher l'cône de camelotte sur tous les objets gris qui peuvent être vendu";
L["Display the upgrade icon on items that WoW considers an upgrade for your character."] = true;
L["Displays item level on equippable items."] = "Afficher le niveau d'objet sur les objets qui peuvent être équipés.";
L["Enable/Disable the all-in-one bag."] = "Activer / désactiver le sac tout-en-un."
L["Enable/Disable the Bag-Bar."] = "Activer / Désactiver la barre des sacs."
L["Full"] = "Plein"; -- we talk about bags, so full means "plein" instead of "complet"
L["Global"] = true;
L["Here you can add items or search terms that you want to be excluded from sorting. To remove an item just click on its name in the list."] = true;
L["Icons and Text (Short)"] = true;
L["Icons and Text"] = "Icônes et textes"
L["Ignored Items and Search Syntax (Global)"] = true;
L["Ignored Items and Search Syntax (Profile)"] = true;
L["Item Count Font"] = "Police d'équipement du compteur";  --need review
L["Item Level Threshold"] = "Seuil de niveau d'objet";
L["Item Level"] = "Niveau d'objet";
L["Money Format"] = "Format monétaire";
L["Panel Width (Bags)"] = "Largeur du panneau (Sac)"
L["Panel Width (Bank)"] = "Largeur du panneau (Banque)"
L["Search Syntax"] = "Syntaxe pour la recherche";
L["Set the size of your bag buttons."] = "Définissez la taille de vos boutons de sac."
L["Short (Whole Numbers)"] = "Court (nombres entiers)";
L["Show Coins"] = "Afficher les pièces";
L["Show Junk Icon"] = "Afficher l'icône camelotte";
L["Show Upgrade Icon"] = true;
L["Smart"] = "Intelligent";
L["Sort Direction"] = "Type de direction" --Also used in Buffs and Debuffs
L["Sort Inverted"] = "Tri inversé"
L["The direction that the bag frames be (Horizontal or Vertical)."] = "La direction des fenêtres de sac (Horizontale ou Verticale)."
L["The direction that the bag frames will grow from the anchor."] = "La direction que prendra la barre des sacs en partant du point d'ancrage."
L["The display format of the currency icons that get displayed below the main bag. (You have to be watching a currency for this to display)"] = "Le format d'affichage des icônes de devises qui sont affichés dans les sacs. (Vous devez montrer cette devise pour l'afficher)"
L["The display format of the money text that is shown at the top of the main bag."] = "Le format d'affichage de l'argent que vous avez visible en haut du sac principal.";
L["The frame is not shown unless you mouse over the frame."] = "Le cadre est invisible tant que vous n'avez pas passé votre souris dessus."
L["The minimum item level required for it to be shown."] = "Le niveau d'objet minimum requis pour être affiché";
L["The size of the individual buttons on the bag frame."] = "La taille des boutons individuels sur la fenêtre du sac."
L["The size of the individual buttons on the bank frame."] = "La taille des boutons individuels sur la fenêtre de la banque."
L["The spacing between buttons."] = "Espacement entre deux boutons."
L["Top to Bottom"] = "Du haut vers le bas"
L["Use coin icons instead of colored text."] = "Utiliser les icônes de pièces au lieu du texte coloré.";

--Buffs and Debuffs
L["Begin a new row or column after this many auras."] = "Commencer une nouvelle ligne ou colonne après cette limite d'auras."
L["Count xOffset"] = "Décalage X de la pile";
L["Count yOffset"] = "Décalage Y de la pile";
L["Defines how the group is sorted."] = "Définit la façon dont le groupe est trié."
L["Defines the sort order of the selected sort method."] = "Définit l'ordre de tri selon la méthode choisie (Ascendant/Descendant)"
L["Disabled Blizzard"] = "Désactiver Blizzard";
L["Fade Threshold"] = "Seuil du fondu"
L["Index"] = "Index"
L["Indicate whether buffs you cast yourself should be separated before or after."] = "Indique si les améliorations que vous lancez doivent être séparées avant ou après."
L["Limit the number of rows or columns."] = "Limiter le nombre de lignes ou de colonnes."
L["Max Wraps"] = "Retour à la ligne maximale"
L["No Sorting"] = "Aucun tri"
L["Other's First"] = "Les autres en premier"
L["Seperate"] = "Séparer"
L["Set the size of the individual auras."] = "Définit la taille de l'aura individuelle."
L["Sort Method"] = "Méthode de tri"
L["The direction the auras will grow and then the direction they will grow after they reach the wrap after limit."] = "Sens de progression des Auras sur la ligne et comment elles vont se comporter une fois la limite atteinte.";
L["Threshold before text changes red, goes into decimal form, and the icon will fade. Set to -1 to disable."] = "Seuil avant que le texte devienne rouge, se met en forme décimale, et l'icône s'estompera. Régler sur -1 pour désactiver."
L["Time xOffset"] = "Décalage X du temps";
L["Time yOffset"] = "Décalage Y du temps";
L["Time"] = "Temps"
L["Wrap After"] = "Retour à la ligne après"
L["Your Auras First"] = "Vos Auras en premier"

--Chat
L["Above Chat"] = "En-dessus du Chat"
L["Adjust the height of your right chat panel."] = "Ajuste la hauteur de la fenêtre de discussion de droite.";
L["Adjust the width of your right chat panel."] = "Ajuste la largeur de la fenêtre de discussion de droite.";
L["Alerts"] = "Alertes";
L["Allowed Combat Repeat"] = true;
L["Attempt to create URL links inside the chat."] = "Tentative pour créer un lien URL dans les fenêtres de discussion."
L["Attempt to lock the left and right chat frame positions. Disabling this option will allow you to move the main chat frame anywhere you wish."] = "Tentative pour verrouiller les positions gauche et droite du cadre de discussion. La désactivation de cette option vous permet de déplacer la fenêtre de discussion principale où vous le souhaitez."
L["Auto-Close Pet Battle Log"] = true;
L["Below Chat"] = "En-dessous du Chat"
L["Chat EditBox Position"] = "Position de la fenêtre de saisie du Chat"
L["Chat History"] = "historique de la discussion"
L["Class Color Mentions"] = true;
L["Custom Timestamp Color"] = true;
L["Display LFG Icons in group chat."] = "Afficher l'icône RDG dans la discussion de groupe.";
L["Display the hyperlink tooltip while hovering over a hyperlink."] = "Afficher une infobulle pendant le survol d'un lien d'objet, sort, etc...."
L["Enable the use of separate size options for the right chat panel."] = "Activer cette option pour utiliser une taille spécifique de la fenêtre de discussion de droite."
L["Exclude Name"] = true;
L["Excluded names will not be class colored."] = true;
L["Excluded Names"] = true;
L["Fade Chat"] = "Estomper la discussion"
L["Fade Tabs No Backdrop"] = "Estomper les onglets sans arrière-plan";
L["Fade the chat text when there is no activity."] = "Estomper la discussion quand il n'y a pas d'activité"
L["Fade Undocked Tabs"] = "Estompe l'affiche des onglets non groupés";
L["Fades the text on chat tabs that are docked in a panel where the backdrop is disabled."] = true;
L["Fades the text on chat tabs that are not docked at the left or right chat panel."] = true;
L["Font Outline"] = "Contours extérieurs de la police" --Also used in UnitFrames section
L["Font"] = "Police"
L["Hide Both"] = "Masquer les deux"
L["Hyperlink Hover"] = "Survol des liens"
L["Keyword Alert"] = "Alerte mots-clés"
L["Keywords"] = "Mots-clés"
L["Left Only"] = "Gauche seulement"
L["LFG Icons"] = "Icône RDG";
L["List of words to color in chat if found in a message. If you wish to add multiple words you must seperate the word with a comma. To search for your current name you can use %MYNAME%.\n\nExample:\n%MYNAME%, ElvUI, RBGs, Tank"] = "Liste des mots à colorer dans la fenêtre de discussion s'ils y sont trouvés. Si vous souhaitez ajouter plusieurs mots, vous devez séparer le mot avec une virgule. Pour rechercher votre nom actuel, vous pouvez utiliser %MYNAME%.\n\nExemple:\n%MYNAME%, ElvUI, RBG, Tank"
L["Lock Positions"] = "Verrouiller les positions"
L["Log the main chat frames history. So when you reloadui or log in and out you see the history from your last session."] = "Active la fenêtre principale de l'historique de discussion. Ainsi quand vous rechargez l'interface ou effectuez une connexion / déconnexion, vous voyez l'historique de la dernière session"
L["No Alert In Combat"] = "Pas d'alerte en combat";
L["Number of messages you scroll for each step."] = true;
L["Number of repeat characters while in combat before the chat editbox is automatically closed."] = true;
L["Number of time in seconds to scroll down to the bottom of the chat window if you are not scrolled down completely."] = "Temps en secondes pour faire défiler vers le bas de la fenêtre de discussion si vous ne l'avez pas fait défiler jusqu'en bas."
L["Panel Backdrop"] = "Arrière-plan de la fenêtre de discussion"
L["Panel Height"] = "Hauteur de la fenêtre de discussion"
L["Panel Texture (Left)"] = "Texture de la fenêtre de discussion (Gauche)"
L["Panel Texture (Right)"] = "Texture de la fenêtre de discussion (Droite)"
L["Panel Width"] = "Largeur de la fenêtre de discussion"
L["Position of the Chat EditBox, if datatexts are disabled this will be forced to be above chat."] = "Postion du cadre d'écriture de la fenêtre de Chat. Si les Texte d'informations sont désactivés, elle apparaitra au dessus du Chat."
L["Prevent the same messages from displaying in chat more than once within this set amount of seconds, set to zero to disable."] = "Empêche l'affichage du même message plus d'une fois dans la fenêtre de discussion durant un laps de temps. Définir sur 0 pour désactiver."
L["Require holding the Alt key down to move cursor or cycle through messages in the editbox."] = true;
L["Right Only"] = "Droite seulement"
L["Right Panel Height"] = "Hauteur de la fenêtre de discussion de droite";
L["Right Panel Width"] = "Largeur de la fenêtre de discussion de droite";
L["Scroll Interval"] = "Intervalle de défilement"
L["Scroll Messages"] = true;
L["Separate Panel Sizes"] = "Séparer la taille des fenêtres de discussion.";
L["Set the font outline."] = "Configure le contour extérieur de la police." --Also used in UnitFrames section
L["Short Channels"] = "Raccourcis canaux"
L["Shorten the channel names in chat."] = "Minimise le nom des canaux de discussion."
L["Show Both"] = "Afficher les deux"
L["Spam Interval"] = "Intervalle contre le Spam"
L["Sticky Chat"] = "Fenêtre de chat adhésive"
L["Tab Font Outline"] = "Contour de la police extérieure des onglets"
L["Tab Font Size"] = "Taille de la police des onglets"
L["Tab Font"] = "Police des onglets"
L["Tab Panel Transparency"] = "Transparence de l'étiquette"
L["Tab Panel"] = "Étiquette de l'onglet"
L["Timestamp Color"] = true;
L["Toggle showing of the left and right chat panels."] = "Afficher ou masquer le côté gauche / droit des panneaux de discussion."
L["Toggle the chat tab panel backdrop."] = "Affiche le fond de l'onglet du panneau de discussion."
L["URL Links"] = "Liens URL"
L["Use Alt Key"] = true;
L["Use class color for the names of players when they are mentioned."] = true;
L["When opening the Chat Editbox to type a message having this option set means it will retain the last channel you spoke in. If this option is turned off opening the Chat Editbox should always default to the SAY channel."] = "Permet de retenir les derniers messages sur le canal de discussion que vous avez utilisé . Si cette option est désactivé, le canal utilisé par défaut sera Dire."
L["Whisper Alert"] = "Alerte chuchotement"
L[ [=[Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.

Please Note:
-The image size recommended is 256x128
-You must do a complete game restart after adding a file to the folder.
-The file type must be tga format.

Example: Interface\AddOns\ElvUI\media\textures\copy

Or for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.]=] ] = [=[Indiquez un nom de fichier situé dans le répertoire World of Warcraft, le dossier des Textures que vous souhaitez utiliser en fond de panneau.

Notez:
La taille de l'image recommandée est de 256x128 pixels
Vous devez redémarrer le jeu après avoir ajouté un fichier dans le dossier.
Le format du fichier doit être en .tga

Exemple: Interface\AddOns\ElvUI\media\textures\copy

Ou pour la majorité des utilsateurs, il serait plus simple de mettre le fichier tga dans le dossier de World of Warcraft puis de taper son nom ici.]=]

--Credits
L["Coding:"] = "Codage: "
L["Credits"] = "Crédits"
L["Donations:"] = "Donateurs: "
L["ELVUI_CREDITS"] = "Je voudrais remercier tout spécialement ceux qui m'ont aidé à maintenir cet addon avec les codeurs, testeurs et les personnes qui m’ont aussi aidé via les dons. Veuillez noter que pour les dons, je n’affiche seulement les noms des personnes qui m’ont envoyés un message privé sur le forum. Si votre nom est absent et que vous désirez que je l'ajoute, merci de m’envoyer un message privé."
L["Testing:"] = "Testeurs: "

--DataBars
L["Current - Percent (Remaining)"] = true;
L["Current - Remaining"] = true;
L["DataBars"] = true;
L["Hide In Combat"] = true;
L["Hide Outside PvP"] = true;
L["Setup on-screen display of information bars."] = true;

--DataTexts
L["24-Hour Time"] = "Mode 24 Heures"
L["Add Currency ID"] = true;
L["Battleground Texts"] = "Textes des Champs de bataille"
L["Block Combat Click"] = "Emêcher le clic en combat";
L["Block Combat Hover"] = "Empêcher le survol en combat";
L["Blocks all click events while in combat."] = "Empêcher tous les clics d'évenements durant le combat.";
L["Blocks datatext tooltip from showing in combat."] = "Empêcher l'affichage des infobulles des textes d'informations en combat.";
L["BottomLeftMiniPanel"] = "Minimap BottomLeft (Inside)"
L["BottomMiniPanel"] = "Minimap Bottom (Inside)"
L["BottomRightMiniPanel"] = "Minimap BottomRight (Inside)"
L["Custom Currencies"] = true;
L["Custom Currency"] = true;
L["Datatext Panel (Left)"] = "Panneaux d'informations (Gauche)"
L["Datatext Panel (Right)"] = "Panneaux d'informations (Droite)"
L["DataTexts"] = "Textes d'informations"
L["Display data panels below the chat, used for datatexts."] = "Afficher les panneaux de données sous le Chat utilisés pour les textes d'information"
L["Display In Main Tooltip"] = true;
L["Display minimap panels below the minimap, used for datatexts."] = "Afficher les panneaux sous la minicarte utilisés pour les textes d'information."
L["Displayed Currency"] = true;
L["Gold Format"] = "Format monétaire";
L["If enabled, then this currency will be displayed in the main Currencies datatext tooltip."] = true;
L["If not set to true then the server time will be displayed instead."] = "Si non activé, l'heure du serveur sera affichée à la place."
L["left"] = "Gauche"
L["LeftChatDataPanel"] = "Fenêtre de discussion à gauche"
L["LeftMiniPanel"] = "Minicarte à gauche"
L["Local Time"] = "Heure Locale"
L["middle"] = "Milieu"
L["Minimap Panels"] = "Panneaux de la Minicarte"
L["Panel Transparency"] = "Transparence du panneau"
L["Panels"] = "Fenêtre"
L["right"] = "Droite"
L["RightChatDataPanel"] = "Fenêtre de discussion à droite"
L["RightMiniPanel"] = "Minicarte à droite"
L["Small Panels"] = true;
L["The display format of the money text that is shown in the gold datatext and its tooltip."] = "L'affichage du format de l'argent que vous possédez dans le texte d'informations Argent et dans son infobulle.";
L["This allows you to create a new datatext which will track the currency with the supplied currency ID. The datatext can be added to a panel immediately after creation."] = true;
L["Toggle 24-hour mode for the time datatext."] = "Affiche le mode 24 Heures"
L["TopLeftMiniPanel"] = "Minimap TopLeft (Inside)"
L["TopMiniPanel"] = "Minimap Top (Inside)"
L["TopRightMiniPanel"] = "Minimap TopRight (Inside)"
L["Use Tooltip"] = true;
L["When inside a battleground display personal scoreboard information on the main datatext bars."] = "Lorsqu'à l'intérieur d'un Champs de bataille, afficher le tableau des scores personnel dans la barre de textes d'informations principale."
L["Word Wrap"] = "Césure des mots"

--Distributor
L["Must be in group with the player if he isn't on the same server as you."] = "Doit être dans le même groupe avec le joueur s'il n'est pas du même serveur."
L["Sends your current profile to your target."] = "Envoi votre profil actuel à votre cible."
L["Sends your filter settings to your target."] = "Envoi vos paramètres de filtre à votre cible."
L["Share Current Profile"] = "Partagez votre profil actuel"
L["Share Filters"] = "Partagez les filtres"
L["This feature will allow you to transfer settings to other characters."] = "Cette fonctionnalité vous permettra de transférer les paramètres à d'autres personnages."
L["You must be targeting a player."] = "Vous devez cibler un joueur."

--General
L["Accept Invites"] = "Invitations automatiques"
L["Adjust the position of the threat bar to either the left or right datatext panels."] = "Ajustez la position de la barre de menace sur le panel des textes d'informations à gauche ou à droite."
L["AFK Mode"] = "Mode AFK";
L["Announce Interrupts"] = "Annoncer les Interruptions"
L["Announce when you interrupt a spell to the specified chat channel."] = "Annonce quand vous interrompez un sort dans le canal de chat spécifié."
L["Attempt to support eyefinity/nvidia surround."] = "Tente de supporter eyefinity/nvidia surround.";
L["Auto Greed/DE"] = "Dez / Cupidité Auto"
L["Auto Repair"] = "Réparation automatique"
L["Auto Scale"] = "Échelle Automatique"
L["Automatically accept invites from guild/friends."] = "Accepter automatiquement les invitations venant d'amis / joueurs de la Guilde."
L["Automatically repair using the following method when visiting a merchant."] = "Répare automatiquement votre équipement chez le marchand selon le mode de réparation sélectionné."
L["Automatically scale the User Interface based on your screen resolution"] = "Redimensionne automatiquement l'Interface Utilisateur en fonction de votre résolution d'écran."
L["Automatically select greed or disenchant (when available) on green quality items. This will only work if you are the max level."] = "Choisi automatiquement la cupidité ou le désenchantement (quand il est disponible) sur les objets inhabituels (vert). Ceci ne fonctionne que si vous êtes au niveau maximum."
L["Automatically vendor gray items when visiting a vendor."] = "Vendre automatiquement les objets gris quand vous rendez visite à un marchand."
L["Bonus Reward Position"] = "Position des récompenses bonus";
L["Bottom Panel"] = "Bandeau en bas"
L["Chat Bubbles Style"] = 'Style des bulles de discussion'
L["Chat Bubbles"] = "Bulles de discussion";
L["Direction the bar moves on gains/losses"] = "Direction que prend la barre quand gain / perte";
L["Disable Tutorial Buttons"] = true;
L["Disables the tutorial button found on some frames."] = true;
L["Display a panel across the bottom of the screen. This is for cosmetic only."] = "Affiche un bandeau au bas de l'écran. Option purement cosmétique."
L["Display a panel across the top of the screen. This is for cosmetic only."] = "Affiche un bandeau en haut de l'écran. Option purement cosmétique."
L["Display battleground messages in the middle of the screen."] = "Afficher le message du champs de bataille au milieu de l'écran";
L["Display emotion icons in chat."] = "Afficher les émoticônes dans le Chat"
L["Emotion Icons"] = "Emoticônes"
L["Enable + Adjust Movers"] = true;
L["Enable/Disable the loot frame."] = "Activer / désactiver le cadre de butin."
L["Enable/Disable the loot roll frame."] = "Activer / désactiver le cadre du tirage au sort du butin."
L["Enables the ElvUI Raid Control panel."] = true;
L["Enhanced PVP Messages"] = "Messages PVP améliorés";
L["General"] = "Général"
L["Height of the objective tracker. Increase size to be able to see more objectives."] = "Hauteur de la fenêtre des suivis d'objectif, augmenter pour afficher plus d'objectifs";
L["Hide At Max Level"] = true;
L["Hide Error Text"] = "Cacher les textes d'erreurs"
L["Hide In Vehicle"] = true;
L["Hides the red error text at the top of the screen while in combat."] = "Cacher les textes d'erreurs en haut de l'écran en combat."
L["Log Taints"] = "Journal  des corruptions"
L["Login Message"] = "Message de connexion"
L["Loot Roll"] = "Cadre de butin"
L["Loot"] = "Butin"
L["Lowest Allowed UI Scale"] = true;
L["Multi-Monitor Support"] = "Support Multi-Moniteur";
L["Name Font"] = "Nom de la police"
L["Number Prefix"] = true;
L["Objective Frame Height"] = "Hauteur du cadre d'objectif";
L["Order Hall Command Bar"] = true;
L["Party / Raid"] = "Groupe / Raid";
L["Party Only"] = "Groupe seulement";
L["Position of bonus quest reward frame relative to the objective tracker."] = "Position de la récompense de l'objectif par rapport à la fenêtre de suivi des objectifs";
L["Raid Only"] = "Raid seulement";
L["Remove Backdrop"] = 'Supprimer le fond'
L["Reset all frames to their original positions."] = "Réinitialiser les cadres à leurs positions initiales."
L["Reset Anchors"] = "Réinitialiser les ancres"
L["Reverse Fill Direction"] = "Inverser la direction de remplissage";
L["Send ADDON_ACTION_BLOCKED errors to the Lua Error frame. These errors are less important in most cases and will not effect your game performance. Also a lot of these errors cannot be fixed. Please only report these errors if you notice a Defect in gameplay."] = "Envoyer les ADDON_ACTION_BLOCKED dans la fenêtre d'erreur LUA. Ces erreurs sont minimes dans la plupart des cas et n'affecteront pas votre expérience de jeu. Tenez compte que nombreuses de celles-ci ne peuvent être fixé. Signalez-les uniquement si cela affecte grandement le jeu."
L["Skin Backdrop (No Borders)"] = true;
L["Skin Backdrop"] = 'Habiller le fond'
L["Skin the blizzard chat bubbles."] = "Habillage des bulles de Chat."
L["Talking Head Scale"] = true;
L["The font that appears on the text above players heads. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "Police qui apparait sur le texte au dessus de la tête des joueurs. |cffFF0000ATTENTION: requiert un redémarrage du jeu ou une reconnexion pour que les changements soient pris en compte.|r"
L["The Thin Border Theme option will change the overall apperance of your UI. Using Thin Border Theme is a slight performance increase over the traditional layout."] = true;
L["The unit prefixes you want to use when values are shortened in ElvUI. This is mostly used on UnitFrames."] = true;
L["Thin Border Theme"] = true;
L["Toggle Tutorials"] = "Afficher les tutoriels"
L["Top Panel"] = "Bandeau en haut"
L["When you go AFK display the AFK screen."] = "Quand vous êtes AFK, affiche un écran spécial.";

--Media
L["Applies the font and font size settings throughout the entire user interface. Note: Some font size settings will be skipped due to them having a smaller font size by default."] = true;
L["Applies the primary texture to all statusbars."] = true;
L["Apply Font To All"] = true;
L["Apply Texture To All"] = true;
L["Backdrop color of transparent frames"] = "Couleur de fond pour les cadres estompés."
L["Backdrop Color"] = "Couleur de fond"
L["Backdrop Faded Color"] = "Couleur de fond estompé"
L["Border Color"] = "Couleur de la bordure"
L["Color some texts use."] = "Couleur utilisée par les Textes d'informations."
L["CombatText Font"] = "Police des textes de combat"
L["Default Font"] = "Police par défaut"
L["Fonts"] = "Polices"
L["Main backdrop color of the UI."] = "Couleur principale de fond de l'Interface."
L["Main border color of the UI."] = true;
L["Media"] = "Média"
L["Primary Texture"] = "Texture primaire"
L["Replace Blizzard Fonts"] = "Remplace les polices Blizzard";
L["Replaces the default Blizzard fonts on various panels and frames with the fonts chosen in the Media section of the ElvUI config. NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this. Enabled by default."] = true;
L["Secondary Texture"] = "Texture secondaire"
L["Set the font size for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"] = "Définie la taille de la police d'écriture pour toute l'interface utilisateur. Note: Ceci n'affecte pas les modules qui ont leurs propres paramètres (Portait d'unité, Textes d'Informations, etc)"
L["Textures"] = "Textures"
L["The font that combat text will use. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = "La police qui sera utilisée pour les textes de combat. |cffFF0000Note : Ce changement nécessite de relancer le jeu ou d'une reconnexion pour prendre effet.|r"
L["The font that the core of the UI will use."] = "La police que le cœur de l'Interface utilisera"
L["The texture that will be used mainly for statusbars."] = "La texture qui sera utilisé principalement pour la barre de statut."
L["This texture will get used on objects like chat windows and dropdown menus."] = "Cette texture sera utilisée pour les fenêtres de discussion et les menus déroulants."
L["Value Color"] = "Couleur des Textes d'informations"

--Maps
L["Adjust the size of the minimap."] = "Ajuster la taille de la minicarte."
L["Always Display"] = "Toujours afficher"
L["Bottom Left"] = "En bas à gauche";
L["Bottom Right"] = "En bas à droite";
L["Bottom"] = "En bas";
L["Change settings for the display of the location text that is on the minimap."] = "Modifier les paramètres pour l'affichage du texte d'emplacement sur la minicarte."
L["Enable/Disable the minimap. |cffFF0000Warning: This will prevent you from seeing the minimap datatexts.|r"] = true;
L["Instance Difficulty"] = "Difficulté de l'instance";
L["Left"] = "Gauche"
L["LFG Queue"] = "Outil raid";
L["Location Text"] = "Texte de localisation"
L["Make the world map smaller."] = "Rendre la carte du monde plus petite";
L["Map Opacity When Moving"] = true;
L["Maps"] = "Cartes";
L["Minimap Buttons"] = "Bouton de la minimap";
L["Minimap Mouseover"] = "Au survol de la Minicarte"
L["Open Ticket"] = true;
L["Puts coordinates on the world map."] = "Mettre les coordonnées sur la Carte du Monde";
L["Reset Zoom"] = true;
L["Right"] = "Droite"
L["Scale"] = "Echelle";
L["Smaller World Map"] = "Carte du monde plus petite";
L["Top Left"] = "En haut à gauche";
L["Top Right"] = "En haut à droite";
L["Top"] = "En haut";
L["World Map Coordinates"] = "Coordonnées de la Carte du Monde";
L["X-Offset"] = true;
L["Y-Offset"] = true;

--Misc
L["Filters are not allowed to have commas in their name. Stripping commas from filter name."] = true;
L["Install"] = "Installer"
L["Run the installation process."] = "Démarrer le processus d'installation."
L["Toggle Anchors"] = "Afficher les ancres"
L["Unlock various elements of the UI to be repositioned."] = "Déverrouille divers éléments de l'interface utilisateur pour être repositionné."
L["Version"] = "Version"

--NamePlates
L["# Displayed Auras"] = true;
L["Actions"] = true;
L["Add a Name or NPC ID to the list."] = true;
L["Add Name or NPC ID"] = true;
L["Add Nameplate Filter"] = true;
L["Add Regular Filter"] = true;
L["Add Special Filter"] = true;
L["Always Show Target Health"] = true;
L["Always Show"] = true;
L["Apply this filter if a buff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a buff has remaining time less than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time less than this. Set to zero to disable."] = true;
L["Background Glow"] = true;
L["Bad Color"] = true;
L["Bad Scale"] = true;
L["Bad Transition Color"] = true;
L["Base Height for the Aura Icon"] = true;
L["Border Glow"] = true;
L["Border"] = true;
L["Boss Auras"] = true;
L["Cast Bar"] = "Barre d'incantation";
L["Cast Color"] = true;
L["Cast No Interrupt Color"] = true;
L["Cast Time Format"] = true;
L["Casting"] = true;
L["Channel Time Format"] = true;
L["Clamp nameplates to the top of the screen when outside of view."] = true;
L["Clamp Nameplates"] = true;
L["Clear Filter"] = true;
L["Clickable Height"] = true;
L["Clickable Width"] = true;
L["Color Tanked"] = true;
L["Control enemy nameplates toggling on or off when in combat."] = true;
L["Control friendly nameplates toggling on or off when in combat."] = true;
L["Controls how big of an area on the screen will accept clicks to target unit."] = true;
L["Controls how many auras are displayed, this will also affect the size of the auras."] = true;
L["Controls which nameplates will be displayed."] = true;
L["Copy settings from another unit."] = true;
L["Copy Settings From"] = true;
L["Current Level"] = true;
L["Default Settings"] = true;
L["Detection"] = true;
L["Display a healer icon over known healers inside battlegrounds or arenas."] = "Affiche un icône soigneur sur le ou les soigneur(s) connu(s) à l'intérieur d'un champ de bataille ou arène"
L["Display Minions"] = true;
L["Display Minor Units"] = true;
L["Display NPC Titles whenever healthbars arent displayed and names are."] = true;
L["Display Style"] = true;
L["Elite Icon"] = true
L["Enable/Disable the scaling of targetted nameplates."] = true;
L["Enemy Combat Toggle"] = true;
L["Enemy NPC Frames"] = true;
L["Enemy Player Frames"] = true;
L["Enemy"] = "Ennemi" --Also used in UnitFrames
L["ENEMY_NPC"] = "Enemy NPC"
L["ENEMY_PLAYER"] = "Enemy Player"
L["Filter already exists!"] = true;
L["Filter Priority"] = true;
L["Filter"] = true;
L["Filters Page"] = true;
L["Friendly Combat Toggle"] = true;
L["Friendly NPC Frames"] = true;
L["Friendly Player Frames"] = true;
L["FRIENDLY_NPC"] = "Friendly NPC"
L["FRIENDLY_PLAYER"] = "Friendly Player"
L["General Options"] = true;
L["Good Color"] = true;
L["Good Scale"] = true;
L["Good Transition Color"] = true;
L["Healer Frames"] = true;
L["Healer Icon"] = "Icône de soigneur"
L["HEALER"] = "Healer"
L["Health Color"] = true;
L["Health Threshold"] = true;
L["Hide Delay"] = true;
L["Hide Frame"] = true;
L["Hide Spell Name"] = true;
L["Hide Time"] = true;
L["Hide When Empty"] = true;
L["Hide"] = "Masquer" --Also used in DataTexts
L["How many seconds the castbar should stay visible after the cast failed or was interrupted."] = true;
L["Icon Base Height"] = true;
L["If enabled then it checks if auras are missing instead of being present on the unit."] = true;
L["If enabled then it will require all auras to activate the filter. Otherwise it will only require any one of the auras to activate it."] = true;
L["If enabled then the filter will only activate if the level of the unit is equal to or higher than this value."] = true;
L["If enabled then the filter will only activate if the level of the unit is equal to or lower than this value."] = true;
L["If enabled then the filter will only activate if the level of the unit matches this value."] = true;
L["If enabled then the filter will only activate if the level of the unit matches your own."] = true;
L["If enabled then the filter will only activate if the unit is casting interruptible spells."] = true;
L["If enabled then the filter will only activate when the unit is in combat."] = true;
L["If enabled then the filter will only activate when the unit is out of combat."] = true;
L["If enabled then the filter will only activate when you are in combat."] = true;
L["If enabled then the filter will only activate when you are out of combat."] = true;
L["If the aura is listed with a number then you need to use that to remove it from the list."] = true;
L["If this list is empty, and if 'Interruptible' is checked, then the filter will activate on any type of cast that can be interrupted."] = true;
L["If this threshold is used then the health of the unit needs to be higher than this value in order for the filter to activate. Set to 0 to disable."] = true;
L["If this threshold is used then the health of the unit needs to be lower than this value in order for the filter to activate. Set to 0 to disable."] = true;
L["In Combat"] = true;
L["Interruptible"] = true;
L["Is Targeted"] = true;
L["LEVEL_BOSS"] = "Set level to -1 for boss units or set to 0 to disable.";
L["Load Distance"] = true;
L["Low Health Threshold"] = "Seuil vie faible"
L["Lower numbers mean a higher priority. Filters are processed in order from 1 to 100."] = true;
L["Make the unitframe glow yellow when it is below this percent of health, it will glow red when the health value is half of this value."] = true;
L["Match Player Level"] = true;
L["Maximum Level"] = true;
L["Maximum Time Left"] = true;
L["Minimum Level"] = true;
L["Minimum Time Left"] = true;
L["Missing"] = true;
L["Name Color"] = true;
L["NamePlates"] = "Noms"
L["Non-Target Transparency"] = true;
L["Not Targeted"] = true;
L["Only load nameplates for units within this range."] = true;
L["Only Show Target"] = true;
L["Out Of Combat"] = true;
L["Over Health Threshold"] = true;
L["Personal Auras"] = true;
L["Player in Combat"] = true;
L["Player Nameplate"] = true;
L["Player Out of Combat"] = true;
L["PLAYER"] = "Player"
L["Reaction Colors"] = true;
L["Reaction Type"] = true;
L["Remove a Name or NPC ID from the list."] = true;
L["Remove Buff"] = true;
L["Remove Debuff"] = true;
L["Remove Name or NPC ID"] = true;
L["Remove Name"] = "Supprimer un nom"
L["Remove Nameplate Filter"] = true;
L["Require All"] = true;
L["Require of the selected auras."] = true;
L["Reset filter priority to the default state."] = true;
L["Reset Priority"] = true;
L["Return filter to its default state."] = true;
L["Scale of the nameplate that is targetted."] = true;
L["Select Nameplate Filter"] = true;
L["Set Settings to Default"] = true;
L["Set the transparency level of nameplates that are not the target nameplate."] = true;
L["Set to either stack nameplates vertically or allow them to overlap."] = true;
L["Shortcut to 'Filters' section of the config."] = true;
L["Shortcuts"] = true;
L["Show In Combat"] = true;
L["Show NPC Titles"] = true;
L["Show With Target"] = true;
L["Side Arrows"] = true;
L["Style Filter"] = true;
L["Suramar Detection"] = true;
L["Tagged NPC"] = "PNJ marqué";
L["Tanked Color"] = true;
L["Target Glow Color"] = true;
L["Target Indicator"] = true;
L["Target Scale"] = true;
L["Target, Quest, Combat"] = true;
L["Targeted Nameplate"] = true;
L["Texture"] = true;
L["These filters don't use a list of spells like the regular filters. Instead they use the WoW API and some code logic to determine if an aura should be allowed or blocked."] = true;
L["These filters use a list of spells to determine if an aura should be allowed or blocked. The content of these filters can be modified in the 'Filters' section of the config."] = true;
L["Threat"] = "Menace"
L["Time To Hold"] = true;
L["Toggle Off While In Combat"] = true;
L["Toggle On While In Combat"] = true;
L["Top Arrow"] = true;
L["Triggers"] = true;
L["Under Health Threshold"] = true;
L["Unit in Combat"] = true;
L["Unit Out of Combat"] = true;
L["Unit Type"] = true;
L["Use Class Color"] = true;
L["Use drag and drop to rearrange filter priority or right click to remove a filter."] = true;
L["Use Portrait"] = true;
L["Use Static Position"] = true;
L["Use Tanked Color when a nameplate is being effectively tanked by another tank."] = true;
L["Use Target Glow"] = true;
L["Use Target Scale"] = true;
L["Use Threat Color"] = true;
L["When enabled the nameplate will stay visible in a locked position."] = true;
L["You can't remove a default name from the filter, disabling the name."] = true;

--Profiles Export/Import
L["Aura Filters"] = true;
L["Choose Export Format"] = "Choisissez le format d'exportation";
L["Choose What To Export"] = "Choisissez quoi exporter";
L["Decode Text"] = "Texte décodé"; --need review
L["Error decoding data. Import string may be corrupted!"] = "Erreur lors du décodage des données. Celles-ci sont peut être corropues";
L["Error exporting profile!"] = "Erreur d'exportation du profil";
L["Export Now"] = "Exporter maintenant";
L["Export Profile"] = "Exporter le profil";
L["Exported"] = "Exporté";
L["Filters (All)"] = "Filres (Tous)";
L["Filters (NamePlates)"] = "Filtres (Noms d'unités)";
L["Filters (UnitFrames)"] = "Filtres (Cadres d'unités)";
L["Global (Account Settings)"] = "Global (Configuration du compte)";
L["Import Now"] = "Importer maintenant";
L["Import Profile"] = "Importer le profil";
L["Importing"] = "Importation";
L["NamePlate Style Filters"] = true;
L["Plugin"] = "Plugin";
L["Private (Character Settings)"] = "Privée (Paramètres du personnages)";
L["Profile imported successfully!"] = "Profil importé avec succès";
L["Profile Name"] = "Nom du profil";
L["Profile"] = "Profil";
L["Table"] = "Tableau";

--Skins
L["Achievement Frame"] = "Fenêtre des Hauts Faits"
L["AddOn Manager"] = "Fenêtre d'Add-ons";
L["Alert Frames"] = "Fenêtre d'Alerte"
L["Archaeology Frame"] = "Fenêtre d'Archéologie"
L["Auction Frame"] = "Fenêtre de l'Hôtel des ventes"
L["Barbershop Frame"] = "Salon de Coiffure"
L["BG Map"] = "Carte Champs de bataille"
L["BG Score"] = "Scores Champs de bataille"
L["Black Market AH"] = "HV du marché noir"
L["Calendar Frame"] = "Fenêtre du Calendrier"
L["Character Frame"] = "Fenêtre du Personnage"
L["Contribution"] = true;
L["Death Recap"] = "Récapitulatif lors de la mort";
L["Debug Tools"] = "Outils de débogage"
L["Gossip Frame"] = "Fenêtre PNJ"
L["Guild Control Frame"] = "Gestion de Guilde"
L["Guild Frame"] = "Fenêtre de Guilde"
L["Guild Registrar"] = "Bannière de Guilde"
L["Help Frame"] = "Fenêtre d'Assistance clientèle"
L["Inspect Frame"] = "Fenêtre d'Inspection"
L["Item Upgrade"] = "Amélioration d'objet"
L["KeyBinding Frame"] = "Raccourcis"
L["LF Guild Frame"] = "Recherche de Guilde"
L["LFG Frame"] = "Fenêtre Recherche de Raid"
L["Loot Frames"] = "Fenêtre de butin"
L["Loss Control"] = "Perte de contrôle"
L["Macro Frame"] = "Fenêtre de Macro"
L["Mail Frame"] = "Fenêtre du Courrier"
L["Merchant Frame"] = "Marchand"
L["Mirror Timers"] = "Fenêtre des Timers mirroirs"; --need review
L["Misc Frames"] = "Divers"
L["Non-Raid Frame"] = "Info Raid"
L["Orderhall"] = true;
L["Pet Battle"] = "Combats de mascottes"
L["Petition Frame"] = "Fenêtre de Charte"
L["PvP Frames"] = "Fenêtre JcJ"
L["Quest Choice"] = "Fenêtre du choix de la quête";
L["Quest Frames"] = "Fenêtre de Quête"
L["Raid Frame"] = "Fenêtre de Raid"
L["Skins"] = "Habillage"
L["Socket Frame"] = "Fenêtre de sertissage"
L["Spellbook"] = "Grimoire"
L["Stable"] = "Écurie"
L["Tabard Frame"] = "Tabard"
L["Talent Frame"] = "Fenêtre des talents"
L["TalkingHead"] = true;
L["Taxi Frame"] = "Trajets aériens"
L["Time Manager"] = "Chronomètre"
L["Trade Frame"] = "Fenêtre d'échange"
L["TradeSkill Frame"] = "Métiers"
L["Trainer Frame"] = "Entraîneur"
L["Transmogrify Frame"] = "Fenêtre de Transmogrification"

--Tooltip
L["Always Hide"] = "Toujours masqué"
L["Bags Only"] = "Sacs seulement";
L["Bags/Bank"] = "Sacs / banque";
L["Bank Only"] = "Banque seulement";
L["Both"] = "Les deux";
L["Choose when you want the tooltip to show. If a modifer is chosen, then you need to hold that down to show the tooltip."] = true;
L["Comparison Font Size"] = true;
L["Cursor Anchor"] = "Ancrage sur le curseur";
L["Custom Faction Colors"] = "Couleur de la faction";
L["Display guild ranks if a unit is guilded."] = "Affiche le rang de la guilde si un joueur est guildé"
L["Display how many of a certain item you have in your possession."] = "Affiche combien vous avez d'objets de ce type en votre possession."
L["Display player titles."] = "Affiche le titre du joueur"
L["Display the players talent spec and item level in the tooltip, this may not immediately update when mousing over a unit."] = "Affiche la spécialisation et le niveau d'équipement dans l'info-bulle, ceci peut ne pas être mis à jour immédiatement au premier survol de la souris sur l'unité.";
L["Display the spell or item ID when mousing over a spell or item tooltip."] = "Affiche le sort ou l'ID de l'objet dans une infobulle quand vous passez votre souris sur le sort ou l'objet."
L["Guild Ranks"] = "Rangs de la guilde"
L["Header Font Size"] = true;
L["Health Bar"] = "Barre de vie";
L["Hide tooltip while in combat."] = "Masquer toutes les infobulles quand vous êtes en combat."
L["Inspect Info"] = "Info inspection";
L["Item Count"] = "Nombre d'objet"
L["Never Hide"] = "Jamais caché"
L["Player Titles"] = "Titre du joueur"
L["Should tooltip be anchored to mouse cursor"] = "L'infobulle doit être ancrée sur le curseur de la souris";
L["Spell/Item IDs"] = "ID de l'objet / du sort"
L["Target Info"] = "Info de la cible";
L["Text Font Size"] = "Police d'écriture du texte";
L["This setting controls the size of text in item comparison tooltips."] = true;
L["Tooltip Font Settings"] = true;
L["When in a raid group display if anyone in your raid is targeting the current tooltip unit."] = "Dans un groupe de raid, affiche l'infobulle d une personne ciblée par une autre."

--UnitFrames
L["%s and then %s"] = "%s et alors %s" --Nedd review
L["2D"] = "2D"
L["3D"] = "3D"
L["Above"] = "Au-dessus"
L["Absorbs"] = "Absorbtions"
L["Add a spell to the filter. Use spell ID if you don't want to match all auras which share the same name."] = true;
L["Add a spell to the filter."] = "Ajouter un sort au filtre."
L["Add Spell ID or Name"] = true;
L["Add SpellID"] = "Ajouter l'identifiant d'un sort"
L["Additional Filter Override"] = true;
L["Additional Filter"] = "Filtre Additionnels"
L["Additional Power Text"] = true;
L["Allow auras considered to be part of a boss encounter."] = "Considérer que les Auras font partie d'un Boss.";
L["Allow Boss Encounter Auras"] = "Autoriser les Auras des Boss";
L["Allow non-personal auras from additional filter when 'Block Non-Personal Auras' is enabled."] = true;
L["Allow Whitelisted Auras"] = "Permettre les Auras en Liste Blanche"
L["An X offset (in pixels) to be used when anchoring new frames."] = "Un décalage X (en pixels) à utiliser lors d'un ancrage d'une nouvelle fenêtre."; --need review
L["An Y offset (in pixels) to be used when anchoring new frames."] = "Un décalage Y (en pixels) à utiliser lors d'un ancrage d'une nouvelle fenêtre."; --need review
L["Anticipation"] = true;
L["Ascending or Descending order."] = "Ordre ascendant ou descendant.";
L["Assist Frames"] = "Cadre des Soutiens"
L["Assist Target"] = 'Cible de soutien'
L["At what point should the text be displayed. Set to -1 to disable."] = "A quel moment le texte devrait être affiché. Mettre à -1 pour désactiver."
L["Attach Text To"] = true;
L["Attach To"] = "Attacher à"
L["Aura Bars"] = "Barre d'auras"
L["Auto-Hide"] = 'Masquer Automatiquement'
L["Bad"] = "Mauvais"
L["Bars will transition smoothly."] = "La transitions des barres seront fluides."
L["Below"] = "En dessous"
L["Blacklist Modifier"] = true;
L["Blacklist"] = "Liste noire"
L["Block Auras Without Duration"] = "Bloquer les Auras sans durée"
L["Block Blacklisted Auras"] = "Bloquer les Auras sur liste Noir"
L["Block Non-Dispellable Auras"] = "Bloquer les Auras non dissipable"
L["Block Non-Personal Auras"] = "Bloquer les Auras non personnelle"
L["Borders"] = "Bordures"
L["Buff Indicator"] = "Indicateur d'amélioration"
L["Buffs"] = "Améliorations"
L["By Type"] = "Par Catégorie"
L["Camera Distance Scale"] = "Distance de la caméra"
L["Castbar"] = "Barre d'incantation"
L["Center"] = "Centrer"
L["Check if you are in range to cast spells on this specific unit."] = "Vérifie si vous êtes à portée pour incanter des sorts sur ces unités spécifiques."
L["Choose UIPARENT to prevent it from hiding with the unitframe."] = true;
L["Class Backdrop"] = "Fond selon la classe"
L["Class Castbars"] = "Barres d'incantation selon la classe"
L["Class Color Override"] = 'Remplacer les couleurs de classes'
L["Class Health"] = "Santé selon la Classe"
L["Class Power"] = "Énergie selon la Classe"
L["Class Resources"] = "Ressources des Classes"
L["Click Through"] = "Clic à travers"
L["Color all buffs that reduce the unit's incoming damage."] = "Colorer toutes les améliorations réduisant les dégâts entrants de l'unité."
L["Color aurabar debuffs by type."] = "Colore les affaiblissement de la barre d'auras par catégorie."
L["Color castbars by the class of player units."] = true;
L["Color castbars by the reaction type of non-player units."] = true;
L["Color health by amount remaining."] = "Colore le cadre selon la vie restante."
L["Color health by classcolor or reaction."] = "Colore la vie par la couleur de la classe ou par l'aggro."
L["Color power by classcolor or reaction."] = "Colore l'énergie de la classe par la couleur de la classe ou par l'aggro."
L["Color the health backdrop by class or reaction."] = "Colore l'arrière-plan de la barre de vie par la couleur de la classe ou par l'aggro."
L["Color the unit healthbar if there is a debuff that can be dispelled by you."] = "Colore la barre de vie de l'unité qui peut être dissipé par vous-même."
L["Color Turtle Buffs"] = "Colore les améliorations 'Turtle'" -- Not yet official translation for this term
L["Colored Icon"] = "Icône Coloré"
L["Coloring (Specific)"] = "Coloration (Spécifique)"
L["Coloring"] = "Coloration"
L["Combat Fade"] = "Estomper hors combat"
L["Combat Icon"] = true;
L["Combo Point"] = true;
L["Configure Auras"] = "Configure les Auras"
L["Copy From"] = "Copier depuis"
L["Count Font Size"] = "Taille du texte du décompte" -- is  it count  when entering in the BattleGround? ;
L["Create a custom fontstring. Once you enter a name you will be able to select it from the elements dropdown list."] = "Créer une chaîne de caractères personnalisée. Une fois que vous aurez entré un nom, vous serez en mesure de la sélectionner au sein de la liste déroulante."
L["Create a filter, once created a filter can be set inside the buffs/debuffs section of each unit."] = "Créer un filtre, chaque filtre créé peut être configuré dans la section Amélioration / Affaiblissements de chaque unité."
L["Create Filter"] = "Créer un filtre"
L["Current - Max | Percent"] = "Actuel Max | Pourcentage"
L["Current - Max"] = "Actuel - Max"
L["Current - Percent"] = "Actuel - Pourcent"
L["Current / Max"] = "Actuel / Max"
L["Current"] = "Actuel"
L["Custom Dead Backdrop"] = true;
L["Custom Health Backdrop"] = "Fond de vie personnalisé"
L["Custom Texts"] = "Textes personnalisés"
L["Debuff Highlighting"] = "Surbrillance des affaiblissements" --can we traduct "highlighting" by "surbrillance" ? Yes :)
L["Debuffs"] = "Affaiblissements"
L["Decimal Threshold"] = "Seuil décimal";
L["Deficit"] = "Déficit"
L["Delete a created filter, you cannot delete pre-existing filters, only custom ones."] = "Supprimer un filtre créé. Vous ne pouvez pas supprimer un filtre préexistant mais seulement ceux que vous avez personnalisé."
L["Delete Filter"] = "Supprimer un filtre"
L["Detach From Frame"] = 'Détacher du cadre'
L["Detached Width"] = 'Largeur de détachement'
L["Direction the health bar moves when gaining/losing health."] = "Sens de direction de la barre de vie quand vous en gagnez ou perdez."
L["Disable Debuff Highlight"] = true;
L["Disabled Blizzard Frames"] = true;
L["Disables the focus and target of focus unitframes."] = true;
L["Disables the player and pet unitframes."] = true;
L["Disables the target and target of target unitframes."] = true;
L["Disconnected"] = "Déconnecté"
L["Display a spark texture at the end of the castbar statusbar to help show the differance between castbar and backdrop."] = "Affiche une texture lumineuse à la fin de la barre de sort pour aider à montrer la différence de couleur entre la barre de sort et le fond."
L["Display Frames"] = "Afficher les cadres"
L["Display icon on arena frame indicating the units talent specialization or the units faction if inside a battleground."] = "Afficher une icône sur les cadres d'arènes indiquant la spécialisation des unités ou leurs factions si vous êtes dans un champs de bataille."
L["Display Player"] = "Afficher le joueur"
L["Display Target"] = "Afficher la cible"
L["Display Text"] = "Afficher le texte"
L["Display the castbar icon inside the castbar."] = true;
L["Display the castbar inside the information panel, the icon will be displayed outside the main unitframe."] = true;
L["Display the combat icon on the unitframe."] = true;
L["Display the rested icon on the unitframe."] = "Afficher l'icône reposé sur le portrait d'unité"
L["Display the target of your current cast. Useful for mouseover casts."] = "Afficher la cible de votre incantation en courts. UTile pour les incantations en survol de souris."
L["Display tick marks on the castbar for channelled spells. This will adjust automatically for spells like Drain Soul and add additional ticks based on haste."] = "Affichage des marques de graduation (ticks) sur la barre de lancement de sort. Cela s'ajustera automatiquement pour les sorts comme Drain d'âme qui est basé sur la Hâte."
L["Don't display any auras found on the 'Blacklist' filter."] = "Ne pas afficher les auras trouvés dans la 'Liste noire' du filtre."
L["Don't display auras that are longer than this duration (in seconds). Set to zero to disable."] = "Ne pas afficher les auras qui dépassent cette durée (en secondes). Mettre 0 pour désactiver";
L["Don't display auras that are not yours."] = "Ne pas afficher les auras qui ne sont pas les votres."
L["Don't display auras that are shorter than this duration (in seconds). Set to zero to disable."] = true;
L["Don't display auras that cannot be purged or dispelled by your class."] = "Ne pas afficher les auras qui ne peuvent pas être purgé ou dissipé votre classe." ;
L["Don't display auras that have no duration."] = "Ne pas afficher les auras qui n'ont pas de durée."
L["Down"] = "En bas"
L["Duration Reverse"] = "Durée inversée"
L["Duration Text"] = true;
L["Duration"] = "Durée"
L["Enabling this allows raid-wide sorting however you will not be able to distinguish between groups."] = "Activer ceci permet d'afficher le raid en entier mais vous ne serez plus en mesure de distinguer les groupes."; --need review
L["Enabling this inverts the grouping order when the raid is not full, this will reverse the direction it starts from."] = "Activer ceci inverse l'ordre du groupe quand il n'est pas complet, ceci inversera son ordre de départ"; --need review
L["Enemy Aura Type"] = "Type d'Aura inamical"
L["Fade the unitframe when out of combat, not casting, no target exists."] = "Estompe les cadres d'unités quand vous êtes hors combat, quand vous ne lancez pas un sort, quand vous ne ciblez personne."
L["Fill"] = "Remplissage"
L["Filled"] = "Rempli"
L["Filter Type"] = "Type de filtre"
L["Fluid Position Buffs on Debuffs"] = true;
L["Fluid Position Debuffs on Buffs"] = true;
L["Force Off"] = 'Forcer Off'
L["Force On"] = 'Forcer On'
L["Force Reaction Color"] = true;
L["Force the frames to show, they will act as if they are the player frame."] = "Forcer l'affichage des cadres, ils agiront comme sur le cadre de joueur."
L["Forces Debuff Highlight to be disabled for these frames"] = true;
L["Forces reaction color instead of class color on units controlled by players."] = true;
L["Format"] = "Format"
L["Frame Level"] = true;
L["Frame Orientation"] = true;
L["Frame Strata"] = true;
L["Frame"] = "Fenêtre"
L["Frequent Updates"] = "Mise à Jours fréquentes"
L["Friendly Aura Type"] = "Type d'Aura amical"
L["Friendly"] = "Amical"
L["Glow"] = "Lueur"
L["Good"] = "Bonne"
L["Group By"] = "Groupe par"
L["Grouping & Sorting"] = "Regroupement et tri";
L["Groups Per Row/Column"] = "Nombres de groupes par ligne/colonne"
L["Growth direction from the first unitframe."] = "Direction de croissance du premier cadre d'unité."
L["Growth Direction"] = "Direction de la croissance"
L["Heal Absorbs"] = true;
L["Heal Prediction"] = "Soin prévisionnel"
L["Health Backdrop"] = "Fond de vie personnalisé"
L["Health Border"] = "Bordure de la santé personnalisée"
L["Health By Value"] = "Vie par valeur"
L["Health"] = "Vie"
L["Height"] = "Hauteur"
L["Horizontal Spacing"] = "Espace horizontal"
L["Horizontal"] = "Horizontale" --Also used in bags module
L["How far away the portrait is from the camera."] = "Configure la distance de la caméra par rapport au portrait."
L["Icon Inside Castbar"] = true;
L["Icon Size"] = true;
L["Icon"] = "Icône"
L["Icon: BOTTOM"] = "Icône: BAS"
L["Icon: BOTTOMLEFT"] = "Icône: BAS-GAUCHE"
L["Icon: BOTTOMRIGHT"] = "Icône: BAS-DROITE"
L["Icon: LEFT"] = "Icône: GAUCHE"
L["Icon: RIGHT"] = "Icône: DROITE"
L["Icon: TOP"] = "Icône: HAUT"
L["Icon: TOPLEFT"] = "Icône: HAUT-GAUCHE"
L["Icon: TOPRIGHT"] = "Icône: HAUT-DROITE"
L["If no other filter options are being used then it will block anything not on the 'Whitelist' filter, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = "S'il n'y a pas d'autres options de filtres utilisés alors il bloquera quoi que ce soit sur la 'ListeBlanche' du filtre. Sinon il suffira d'ajouter les auras sur la liste blanche en plus de tous les autres paramètres du filtre." --Need review
L["If not set to 0 then override the size of the aura icon to this."] = "Si ce n'est pas réglé sur 0, alors remplacer la taille de l'icône d'aura à celui ci."
L["If the unit is an enemy to you."] ="Si l'unité est votre ennemi."
L["If the unit is friendly to you."] = "Si l'unité vous est amicale."
L["If you have a lot of 3D Portraits active then it will likely have a big impact on your FPS. Disable some portraits if you experience FPS issues."] = true;
L["Ignore mouse events."] = "Ignorer les évènements de la souris."
L["InfoPanel Border"] = true;
L["Information Panel"] = true;
L["Inset"] = "Insérer"
L["Inside Information Panel"] = true;
L["Interruptable"] = "Interruptible"
L["Invert Grouping Order"] = "Inverser l'ordre des groupes"
L["JustifyH"] = "JustifierH"
L["Latency"] = "Latence"
L["Left to Right"] = true;
L["Main statusbar texture."] = "Texture de la barre principale."
L["Main Tanks / Main Assist"] = 'Tank Principal / Assistant Principal'
L["Make textures transparent."] = "Mettre les textures transparentes."
L["Match Frame Width"] = "Accorder à la largeur du cadre"
L["Max amount of overflow allowed to extend past the end of the health bar."] = true;
L["Max Bars"] = "Barres max";
L["Max Overflow"] = true;
L["Maximum Duration"] = "Durée maximum";
L["Method to sort by."] = true;
L["Middle Click - Set Focus"] = "Clic milieu - Réglage du Focus"
L["Middle clicking the unit frame will cause your focus to match the unit."] = "Le clic milieu sur une unité positionera le focus sur celle-ci." --need review
L["Middle"] = true;
L["Minimum Duration"] = true;
L["Model Rotation"] = "Rotation du Modèle"
L["Mouseover"] = "Au survol de la souris"
L["Name"] = "Nom" --Also used in Buffs and Debuffs
L["Neutral"] = "Neutre"
L["Non-Interruptable"] = "Non-interruptible"
L["Not valid spell id"] = "ID du sort invalide"
L["Num Rows"] = "Nombre de lignes"
L["Number of Groups"] = "Nombre de groupes"
L["Offset of the powerbar to the healthbar, set to 0 to disable."] = "Décalage de la barre de pouvoir à la barre de vie, mettre 0 pour désactiver."
L["Offset position for text."] = "Décalage de la position du texte."
L["Offset"] = "Décalage"
L["OOR Alpha"] = "Transparence Hors de portée"
L["Others"] = "Autres"
L["Overlay the healthbar"] = "Superposé sur la barre de vie"
L["Overlay"] = "Superposition"
L["Override any custom visibility setting in certain situations, EX: Only show groups 1 and 2 inside a 10 man instance."] = "Remplace tout paramètre de visibilité dans certaines situations, Ex: afficher seulement le groupe 1 et 2 quand vous êtes dans un raid à 10 joueurs."
L["Override the default class color setting."] = 'Remplacer les réglages des couleurs de classes par défaut.'
L["Owners Name"] = "Nom des propriétaires";
L["Parent"] = true;
L["Party Pets"] = "Familiers des coéquipiers"
L["Party Targets"] = "Cible des coéquipiers"
L["Per Row"] = "par ligne"
L["Percent"] = "Pourcent"
L["Personal"] = "Personnel"
L["Pet Name"] = "Nom familier";
L["Player Frame Aura Bars"] = true;
L["Portrait"] = "Portrait"
L["Position Buffs on Debuffs"] = true;
L["Position Debuffs on Buffs"] = true;
L["Position the Model horizontally."] = "Position horizontale du modèle";
L["Position the Model vertically."] = "Position verticale du modèle";
L["Position"] = "Position"
L["Power text will be hidden on NPC targets, in addition the name text will be repositioned to the power texts anchor point."] = "Le texte d'énergie sera masqué sur les PNJ ciblés, de plus le nom sera repositionné sur le texte d'énergie."
L["Power"] = "Énergie"
L["Powers"] = "Énergies"
L["Priority"] = "Priorité"
L["Profile Specific"] = true;
L["PvP & Prestige Icon"] = true;
L["PvP Text"] = true;
L["PVP Trinket"] = 'Bijou PVP'
L["Raid Icon"] = "Icône de Raid"
L["Raid-Wide Sorting"] = "Tri du Raid-Large";
L["Raid40 Frames"] = "Fenêtre de Raid40";
L["RaidDebuff Indicator"] = "Indicateur d'affaiblissement en Raid"
L["Range Check"] = "Verifie la portée"
L["Rapidly update the health, uses more memory and cpu. Only recommended for healing."] = "Mise à jour rapide de la santé, ce qui augmente la charge de la mémoire et du processeur. Recommandé seulement pour les soigneurs."
L["Reaction Castbars"] = true;
L["Reactions"] = "Réactions"
L["Ready Check Icon"] = true;
L["Remaining"] = "Restant"
L["Remove a spell from the filter. Use the spell ID if you see the ID as part of the spell name in the filter."] = true;
L["Remove a spell from the filter."] = "Supprimer un sort depuis le filtre."
L["Remove Spell ID or Name"] = true;
L["Remove SpellID"] = "Supprimer l'identifiant d'un sort"
L["Rest Icon"] = "Icône reposé"
L["Restore Defaults"] = "Restaurer les paramètres par défaut" --Also used in Media and ActionBars sections
L["Right to Left"] = true;
L["RL / ML Icons"] = "Icônes RL / ML"
L["Role Icon"] = "Icône de rôle"
L["Seconds remaining on the aura duration before the bar starts moving. Set to 0 to disable."] = true
L["Select a unit to copy settings from."] = "Sélectionnez les réglages d'un cadre à copier."
L["Select an additional filter to use. If the selected filter is a whitelist and no other filters are being used (with the exception of Block Non-Personal Auras) then it will block anything not on the whitelist, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] =  "Sélectionnez un filtre additionnel à utiliser. Si le filtre sélectionné est une liste blanche et qu'aucun autres filtres sont utilisés (à l'exception du bloc des Auras Non-Personnels) alors il bloquera quoi que ce soit qui n'est pas dans la liste blanche, sinon il suffira d'ajouter les auras dans la liste blanche en plus de tous les autres paramètres des filtres." -- headache
L["Select Filter"] = "Sélectionner un filtre"
L["Select Spell"] = "Sélectionner un sort"
L["Select the display method of the portrait."] = "Sélectionnez la méthode d'affichage du portrait."
L["Set the filter type. Blacklist will hide any auras in the list and show all others. Whitelist will show any auras in the filter and hide all others."] = true;
L["Set the font size for unitframes."] = "Configure la taille de la police d'écriture pour les cadres d'unités."
L["Set the order that the group will sort."] = "Définir l'ordre du groupe qui sera trié"
L["Set the orientation of the UnitFrame."] = true;
L["Set the priority order of the spell, please note that prioritys are only used for the raid debuff module, not the standard buff/debuff module. If you want to disable set to zero."] = "Définir l'ordre de priorité du sort, merci de noter que ces priorités ne sont utilisées que pour le mode d'affaiblissement de raid, ce n'est pas un module améliorations / affaiblissement standard. Si vous souhaitez le désactiver, mettez la valeur sur 0."
L["Set the type of auras to show when a unit is a foe."] = "Définir le type d'auras à afficher quand l'unité est hostile."
L["Set the type of auras to show when a unit is friendly."] = "Définir le type d'auras à afficher quand l'unité est amical."
L["Sets the font instance's horizontal text alignment style."] = "Réglages de l'alignement horizontal du texte de la police d'écriture."
L["Show a incomming heal prediction bar on the unitframe. Also display a slightly different colored bar for incoming overheals."] = "Affiche une barre sur la prédiction des soins à venir sur le cadre d'unité. Ainsi qu'une barre de couleur légèrement différente pour les soins entrants excédants."
L["Show Aura From Other Players"] = "N'importe quelle unité"
L["Show Auras"] = "Afficher les auras"
L["Show Dispellable Debuffs"] = true;
L["Show For DPS"] = true;
L["Show For Healers"] = true;
L["Show For Tanks"] = true;
L["Show When Not Active"] = "Afficher les manquants"
L["Size and Positions"] = "Taille et positions";
L["Size of the indicator icon."] = "Taille de l'indicateur de l'icône."
L["Size Override"] = "Forcer la taille"
L["Size"] = "Taille"
L["Smart Aura Position"] = true;
L["Smart Raid Filter"] = "Filtre intelligent de Raid"
L["Smooth Bars"] = "Barres fluides"
L["Sort By"] = true;
L["Spaced"] = "Espacé"
L["Spacing"] = true;
L["Spark"] = "Lueur"
L["Spec Icon"] = 'Icône de spécialisation'
L["Stack Counter"] = true;
L["Stack Threshold"] = "Seuil de stack";
L["Start Near Center"] = 'Démarrer près du centre'
L["Statusbar Fill Orientation"] = true;
L["StatusBar Texture"] = "Texture de la barre d'état."
L["Strata and Level"] = true;
L["Style"] = "Style" --Need review
L["Tank Frames"] = "Cadre des Tanks"
L["Tank Target"] = "Cible de Tank"
L["Tapped"] = "Collé"
L["Target Glow"] = true;
L["Target On Mouse-Down"] =  "Cibler lors d'un appui sur le clic (et non pas en relachant le clic)" --Need review
L["Target units on mouse down rather than mouse up. \n\n|cffFF0000Warning: If you are using the addon 'Clique' you may have to adjust your clique settings when changing this."] = "Cible les unités avec un appui sur le clic souris plutôt qu'au relâchement du clic. \n\n|cffFF0000Attention: Si vous utilisez l'addon 'Clique' vous devrez peut-être ajuster vos paramètres de clic lors du changement de celui-ci."
L["Text Color"] = "Couleur du texte"
L["Text Format"] = "Format du texte"
L["Text Position"] = "Position du texte"
L["Text Threshold"] = "Seuil du texte"
L["Text Toggle On NPC"] = "Afficher le texte des PNJ"
L["Text xOffset"] =  "Décalage de l'axe X du texte"
L["Text yOffset"] = "Décalage de l'axe Y du texte"
L["Text"] = "Texte"
L["Textured Icon"] = "Texture de l'icône"
L["The alpha to set units that are out of range to."] = "Règle la transparence des unités hors de portée."
L["The debuff needs to reach this amount of stacks before it is shown. Set to 0 to always show the debuff."] = "Le debuff doit atteindre ce nombre de stacks pour être affiché. Mettre à 0 pour toujours afficher le débuff";
L["The following macro must be true in order for the group to be shown, in addition to any filter that may already be set."] = "La macro suivante doit être cochée pour que le groupe soit affiché, en plus de la configuration des filtres."
L["The font that the unitframes will use."] = "Police utilisée par défaut pour les cadres d'unités."
L["The initial group will start near the center and grow out."] = "Le premier groupe commence à proximité du centre et s'en développe hors."
L["The name you have selected is already in use by another element."] = "Le nom que vous avez sélectionné est déjà utilisé par un autre élément."
L["The object you want to attach to."] = "L'objet que vous souhaitez attacher à."
L["Thin Borders"] = true;
L["This dictates the size of the icon when it is not attached to the castbar."] = true;
L["This opens the UnitFrames Color settings. These settings affect all unitframes."] = true;
L["Threat Display Mode"] = "Affichage du Mode de Menace."
L["Threshold before text goes into decimal form. Set to -1 to disable decimals."] = "Seuil avant que le texte ne s'affiche sous forme décimale. Mettre à -1 pour désactiver l'affichage en décimal.";
L["Ticks"] = "Ticks"
L["Time Remaining Reverse"] =  "Temps restant inversé"
L["Time Remaining"] = "Temps restant"
L["Transparent"] = "Transparent"
L["Turtle Color"] = "Couleur 'Turtle'" -- Same
L["Uniform Threshold"] = true;
L["UnitFrames"] = "Cadre d'unité"
L["Up"] = "Haut"
L["Use Custom Level"] = true;
L["Use Custom Strata"] = true;
L["Use Dead Backdrop"] = true;
L["Use Default"] = 'Utiliser par défaut'
L["Use the custom health backdrop color instead of a multiple of the main health color."] = "Utilise une couleur personnalisé pour colorer le fond de la barre de vie au lieu d'utiliser la couleur par défaut."
L["Use the profile specific filter 'Buff Indicator (Profile)' instead of the global filter 'Buff Indicator'."] = true;
L["Use thin borders on certain unitframe elements."] = true;
L["Use this backdrop color for units that are dead or ghosts."] = true;
L["Value must be a number"] = "La valeur doit être un nombre"
L["Vertical Orientation"] = true;
L["Vertical Spacing"] = "Espace vertical"
L["Vertical"] = "Verticale" --Also used in bags section
L["Visibility"] = "Visibilité"
L["What point to anchor to the frame you set to attach to."] = "Quel point d'ancrage sur le cadre vous choisissez à attacher."
L["What to attach the buff anchor frame to."] = "Choisissez à quoi vous voulez attacher les améliorations sur le cadre."
L["What to attach the debuff anchor frame to."] = "Choisissez à quoi vous voulez attacher les affaiblissements sur le cadre."
L["When true, the header includes the player when not in a raid."] = "Quand coché, l'en-tête est affiché lorsque le joueur n'est pas dans un raid."
L["Whitelist"] = "Liste blanche"
L["Width"] = "Largeur" --Also used in NamePlates module
L["Will show Buffs in the Debuff position when there are no Debuffs active, or vice versa."] = true;
L["xOffset"] = "Décalage de l'axe X"
L["yOffset"] = "Décalage de l'axe Y" --Another variation in bags section Y Offset
L["You can't remove a pre-existing filter."] = "Vous ne pouvez pas supprimer un filtre préexistant."
L["You cannot copy settings from the same unit."] = "Vous ne pouvez pas copier les réglages du même cadre."
L["You may not remove a spell from a default filter that is not customly added. Setting spell to false instead."] = "Vous ne pouvez pas supprimer un sort du filtre qui est par défaut.configurer le sort en 'désactivé'."
L["You need to hold this modifier down in order to blacklist an aura by right-clicking the icon. Set to None to disable the blacklist functionality."] = true;
