-- English localization file for enUS and enGB.
local AceLocale = LibStub:GetLibrary("AceLocale-3.0");
local L = AceLocale:NewLocale("ElvUI", "enUS", true, true);
if not L then return; end

-- *_DESC locales
L["AURAS_DESC"] = 'Configure the aura icons that appear near the minimap.'
L["BAGS_DESC"] = "Adjust bag settings for ElvUI."
L["CHAT_DESC"] = "Adjust chat settings for ElvUI."
L["DATATEXT_DESC"] = "Setup the on-screen display of info-texts."
L["ELVUI_DESC"] = "ElvUI is a complete User Interface replacement addon for World of Warcraft."
L["NAMEPLATE_DESC"] = "Modify the nameplate settings."
L["UNITFRAME_DESC"] = "Modify the unitframe settings."
L["ACTIONBARS_DESC"] = "Modify the actionbar settings."
L["PANEL_DESC"] = "Adjust the size of your left and right panels, this will effect your chat and bags."
L["SKINS_DESC"] = "Adjust Skin settings."
L["TOGGLESKIN_DESC"] = "Enable/Disable this skin."
L["TOOLTIP_DESC"] = "Setup options for the Tooltip."
L["SEARCH_SYNTAX_DESC"] = [=[With the new addition of LibItemSearch, you now have access to much more advanced item searches. The following is a documentation of the search syntax. See the full explanation at: https://github.com/Jaliborc/LibItemSearch-1.2/wiki/Search-Syntax.

Specific Searching:
    • q:[quality] or quality:[quality]. For instance, q:epic will find all epic items.
    • l:[level], lvl:[level] or level:[level]. For example, l:30 will find all items with level 30.
    • t:[search], type:[search] or slot:[search]. For instance, t:weapon will find all weapons.
    • n:[name] or name:[name]. For instance, typing n:muffins will find all items with names containing "muffins".
    • s:[set] or set:[set]. For example, s:fire will find all items in equipment sets you have with names that start with fire.
    • tt:[search], tip:[search] or tooltip:[search]. For instance, tt:binds will find all items that can be bound to account, on equip, or on pickup.


Search Operators:
    • ! : Negates a search. For example, !q:epic will find all items that are NOT epic.
    • | : Joins two searches. Typing q:epic | t:weapon will find all items that are either epic OR weapons.
    • & : Intersects two searches. For instance, q:epic & t:weapon will find all items that are epic AND weapons
    • >, <, <=, => : Performs comparisons on numerical searches. For example, typing lvl: >30 will find all items with level HIGHER than 30.


The following search keywords can also be used:
    • soulbound, bound, bop : Bind on pickup items.
    • bou : Bind on use items.
    • boe : Bind on equip items.
    • boa : Bind on account items.
    • quest : Quest bound items.
    • reagents, reagent, crafting : Profession reagents.
    • naval : Naval equipment.
    • follower, followe, follow : Follower items.
    • relic, reli, rel : Artifact Relics.
    • power, powe, pow : Items granting Artifact Power.]=];
L["TEXT_FORMAT_DESC"] = [=[Provide a string to change the text format.

Examples:
[namecolor][name] [difficultycolor][smartlevel] [shortclassification]
[healthcolor][health:current-max]
[powercolor][power:current]

Health / Power Formats:
'current' - current amount
'percent' - percentage amount
'current-max' - current amount followed by maximum amount, will display only max if current is equal to max
'current-percent' - current amount followed by percentage amount, will display only max if current is equal to max
'current-max-percent' - current amount, max amount, followed by percentage amount, will display only max if current is equal to max
'deficit' - display the deficit value, will display nothing if there is no deficit

Name Formats:
'name:short' - Name restricted to 10 characters
'name:medium' - Name restricted to 15 characters
'name:long' - Name restricted to 20 characters

To disable leave the field blank, if you need more information visit http://www.tukui.org]=];

--ActionBars
L["Action Paging"] = true;
L["ActionBars"] = true;
L["Allow Masque to handle the skinning of this element."] = true;
L["Alpha"] = true;
L["Anchor Point"] = true; --also in unitframes
L["Automatic"] = true;
L["Backdrop Spacing"] = true;
L["Backdrop"] = true;
L["Button Size"] = true; --Also used in Bags
L["Button Spacing"] = true; --Also used in Bags
L["Buttons Per Row"] = true;
L["Buttons"] = true;
L["Change the alpha level of the frame."] = true;
L["Color of the actionbutton when not usable."] = true;
L["Color of the actionbutton when out of power (Mana, Rage, Focus, Holy Power)."] = true;
L["Color of the actionbutton when out of range."] = true;
L["Color of the actionbutton when usable."] = true;
L["Color when the text is about to expire"] = true;
L["Color when the text is in the days format."] = true;
L["Color when the text is in the hours format."] = true;
L["Color when the text is in the minutes format."] = true;
L["Color when the text is in the seconds format."] = true;
L["Cooldown Text"] = true;
L["Darken Inactive"] = true;
L["Days"] = true;
L["Display bind names on action buttons."] = true;
L["Display cooldown text on anything with the cooldown spiral."] = true;
L["Display macro names on action buttons."] = true;
L["Expiring"] = true;
L["Flyout Direction"] = true;
L["Global Fade Transparency"] = true;
L["Height Multiplier"] = true;
L["Hide Cooldown Bling"] = true;
L["Hides the bling animation on buttons at the end of the global cooldown."] = true;
L["Hours"] = true;
L["If you unlock actionbars then trying to move a spell might instantly cast it if you cast spells on key press instead of key release."] = true;
L["Inherit Global Fade"] = true;
L["Inherit the global fade, mousing over, targetting, setting focus, losing health, entering combat will set the remove transparency. Otherwise it will use the transparency level in the general actionbar settings for global fade alpha."] = true;
L["Key Down"] = true;
L["Keybind Mode"] = true;
L["Keybind Text"] = true;
L["Low Threshold"] = true;
L["Macro Text"] = true;
L["Masque Support"] = true;
L["Minutes"] = true;
L["Mouse Over"] = true; --Also used in Bags
L["Multiply the backdrops height or width by this value. This is usefull if you wish to have more than one bar behind a backdrop."] = true;
L["Not Usable"] = true;
L["Out of Power"] = true;
L["Out of Range"] = true;
L["Restore Bar"] = true;
L["Restore the actionbars default settings"] = true;
L["Seconds"] = true;
L["Show Empty Buttons"] = true;
L["Shows a swipe animation when a spell is recharging but still has charges left."] = true;
L["The amount of buttons to display per row."] = true;
L["The amount of buttons to display."] = true;
L["The button you must hold down in order to drag an ability to another action button."] = true;
L["The first button anchors itself to this point on the bar."] = true;
L["The size of the action buttons."] = true;
L["The spacing between the backdrop and the buttons."] = true;
L["This setting will be updated upon changing stances."] = true;
L["Threshold before text turns red and is in decimal form. Set to -1 for it to never turn red"] = true;
L["Toggles the display of the actionbars backdrop."] = true;
L["Transparency level when not in combat, no target exists, full health, not casting, and no focus target exists."] = true;
L["Usable"] = true;
L["Use Draw Swipe"] = true;
L["Use Position Override"] = true;
L["Visibility State"] = true;
L["When enabled it will use the Anchor Point setting to determine growth direction, otherwise it will be determined by where the bar is positioned."] = true;
L["Width Multiplier"] = true;
L["Zone Ability"] = true;
L[ [=[This works like a macro, you can run different situations to get the actionbar to page differently.
 Example: '[combat] 2;']=] ] = true;
L[ [=[This works like a macro, you can run different situations to get the actionbar to show/hide differently.
 Example: '[combat] show;hide']=] ] = true;

--Bags
L["Add an item or search syntax to the ignored list. Items matching the search syntax will be ignored."] = true;
L["Add Item or Search Syntax"] = true;
L["Adjust the width of the bag frame."] = true;
L["Adjust the width of the bank frame."] = true;
L["Ascending"] = true;
L["Bag Sorting"] = true;
L["Bag-Bar"] = true;
L["Bar Direction"] = true;
L["Blizzard Style"] = true;
L["Bottom to Top"] = true;
L["Button Size (Bag)"] = true;
L["Button Size (Bank)"] = true;
L["Clear Search On Close"] = true;
L["Condensed"] = true;
L["Currency Format"] = true;
L["Descending"] = true;
L["Direction the bag sorting will use to allocate the items."] = true;
L["Disable Bag Sort"] = true;
L["Disable Bank Sort"] = true;
L["Display Item Level"] = true;
L["Display the junk icon on all grey items that can be vendored."] = true;
L["Display the upgrade icon on items that WoW considers an upgrade for your character."] = true;
L["Displays item level on equippable items."] = true;
L["Enable/Disable the all-in-one bag."] = true;
L["Enable/Disable the Bag-Bar."] = true;
L["Full"] = true;
L["Global"] = true;
L["Here you can add items or search terms that you want to be excluded from sorting. To remove an item just click on its name in the list."] = true;
L["Icons and Text (Short)"] = true;
L["Icons and Text"] = true;
L["Ignored Items and Search Syntax (Global)"] = true;
L["Ignored Items and Search Syntax (Profile)"] = true;
L["Item Count Font"] = true;
L["Item Level Threshold"] = true;
L["Item Level"] = true;
L["Money Format"] = true;
L["Panel Width (Bags)"] = true;
L["Panel Width (Bank)"] = true;
L["Search Syntax"] = true;
L["Set the size of your bag buttons."] = true;
L["Short (Whole Numbers)"] = true;
L["Show Coins"] = true;
L["Show Junk Icon"] = true;
L["Show Upgrade Icon"] = true;
L["Smart"] = true;
L["Sort Direction"] = true; --Also used in Buffs and Debuffs
L["Sort Inverted"] = true;
L["The direction that the bag frames be (Horizontal or Vertical)."] = true;
L["The direction that the bag frames will grow from the anchor."] = true;
L["The display format of the currency icons that get displayed below the main bag. (You have to be watching a currency for this to display)"] = true;
L["The display format of the money text that is shown at the top of the main bag."] = true;
L["The frame is not shown unless you mouse over the frame."] = true;
L["The minimum item level required for it to be shown."] = true;
L["The size of the individual buttons on the bag frame."] = true;
L["The size of the individual buttons on the bank frame."] = true;
L["The spacing between buttons."] = true;
L["Top to Bottom"] = true;
L["Use coin icons instead of colored text."] = true;

--Buffs and Debuffs
L["Begin a new row or column after this many auras."] = true;
L["Count xOffset"] = true;
L["Count yOffset"] = true;
L["Defines how the group is sorted."] = true;
L["Defines the sort order of the selected sort method."] = true;
L["Disabled Blizzard"] = true;
L["Fade Threshold"] = true;
L["Index"] = true;
L["Indicate whether buffs you cast yourself should be separated before or after."] = true;
L["Limit the number of rows or columns."] = true;
L["Max Wraps"] = true;
L["No Sorting"] = true;
L["Other's First"] = true;
L["Seperate"] = true;
L["Set the size of the individual auras."] = true;
L["Sort Method"] = true;
L["The direction the auras will grow and then the direction they will grow after they reach the wrap after limit."] = true;
L["Threshold before text changes red, goes into decimal form, and the icon will fade. Set to -1 to disable."] = true;
L["Time xOffset"] = true;
L["Time yOffset"] = true;
L["Time"] = true;
L["Wrap After"] = true;
L["Your Auras First"] = true;

--Chat
L["Above Chat"] = true;
L["Adjust the height of your right chat panel."] = true;
L["Adjust the width of your right chat panel."] = true;
L["Alerts"] = true;
L["Allowed Combat Repeat"] = true;
L["Attempt to create URL links inside the chat."] = true;
L["Attempt to lock the left and right chat frame positions. Disabling this option will allow you to move the main chat frame anywhere you wish."] = true;
L["Auto-Close Pet Battle Log"] = true;
L["Below Chat"] = true;
L["Chat EditBox Position"] = true;
L["Chat History"] = true;
L["Class Color Mentions"] = true;
L["Custom Timestamp Color"] = true;
L["Display LFG Icons in group chat."] = true;
L["Display the hyperlink tooltip while hovering over a hyperlink."] = true;
L["Enable the use of separate size options for the right chat panel."] = true;
L["Exclude Name"] = true;
L["Excluded names will not be class colored."] = true;
L["Excluded Names"] = true;
L["Fade Chat"] = true;
L["Fade Tabs No Backdrop"] = true;
L["Fade the chat text when there is no activity."] = true;
L["Fade Undocked Tabs"] = true;
L["Fades the text on chat tabs that are docked in a panel where the backdrop is disabled."] = true;
L["Fades the text on chat tabs that are not docked at the left or right chat panel."] = true;
L["Font Outline"] = true; --Also used in UnitFrames section
L["Font"] = true;
L["Hide Both"] = true;
L["Hyperlink Hover"] = true;
L["Keyword Alert"] = true;
L["Keywords"] = true;
L["Left Only"] = true;
L["LFG Icons"] = true;
L["List of words to color in chat if found in a message. If you wish to add multiple words you must seperate the word with a comma. To search for your current name you can use %MYNAME%.\n\nExample:\n%MYNAME%, ElvUI, RBGs, Tank"] = true;
L["Lock Positions"] = true;
L["Log the main chat frames history. So when you reloadui or log in and out you see the history from your last session."] = true;
L["No Alert In Combat"] = true;
L["Number of messages you scroll for each step."] = true;
L["Number of repeat characters while in combat before the chat editbox is automatically closed."] = true;
L["Number of time in seconds to scroll down to the bottom of the chat window if you are not scrolled down completely."] = true;
L["Panel Backdrop"] = true;
L["Panel Height"] = true;
L["Panel Texture (Left)"] = true;
L["Panel Texture (Right)"] = true;
L["Panel Width"] = true;
L["Position of the Chat EditBox, if datatexts are disabled this will be forced to be above chat."] = true;
L["Prevent the same messages from displaying in chat more than once within this set amount of seconds, set to zero to disable."] = true;
L["Require holding the Alt key down to move cursor or cycle through messages in the editbox."] = true;
L["Right Only"] = true;
L["Right Panel Height"] = true;
L["Right Panel Width"] = true;
L["Scroll Interval"] = true;
L["Scroll Messages"] = true;
L["Separate Panel Sizes"] = true;
L["Set the font outline."] = true; --Also used in UnitFrames section
L["Short Channels"] = true;
L["Shorten the channel names in chat."] = true;
L["Show Both"] = true;
L["Spam Interval"] = true;
L["Sticky Chat"] = true;
L["Tab Font Outline"] = true;
L["Tab Font Size"] = true;
L["Tab Font"] = true;
L["Tab Panel Transparency"] = true;
L["Tab Panel"] = true;
L["Timestamp Color"] = true;
L["Toggle showing of the left and right chat panels."] = true;
L["Toggle the chat tab panel backdrop."] = true;
L["URL Links"] = true;
L["Use Alt Key"] = true;
L["Use class color for the names of players when they are mentioned."] = true;
L["When opening the Chat Editbox to type a message having this option set means it will retain the last channel you spoke in. If this option is turned off opening the Chat Editbox should always default to the SAY channel."] = true;
L["Whisper Alert"] = true;
L[ [=[Specify a filename located inside the World of Warcraft directory. Textures folder that you wish to have set as a panel background.

Please Note:
-The image size recommended is 256x128
-You must do a complete game restart after adding a file to the folder.
-The file type must be tga format.

Example: Interface\AddOns\ElvUI\media\textures\copy

Or for most users it would be easier to simply put a tga file into your WoW folder, then type the name of the file here.]=] ] = true;

--Credits
L["Coding:"] = true;
L["Credits"] = true;
L["Donations:"] = true;
L["ELVUI_CREDITS"] = "I would like to give out a special shout out to the following people for helping me maintain this addon with testing and coding and people who also have helped me through donations. Please note for donations I'm only posting the names of people who PM'd me on the forums, if your name is missing and you wish to have your name added please PM me."
L["Testing:"] = true;

--DataBars
L["Current - Percent (Remaining)"] = true;
L["Current - Remaining"] = true;
L["DataBars"] = true;
L["Hide In Combat"] = true;
L["Hide Outside PvP"] = true;
L["Setup on-screen display of information bars."] = true;

--DataTexts
L["24-Hour Time"] = true;
L["Add Currency ID"] = true;
L["Battleground Texts"] = true;
L["Block Combat Click"] = true;
L["Block Combat Hover"] = true;
L["Blocks all click events while in combat."] = true;
L["Blocks datatext tooltip from showing in combat."] = true;
L["BottomLeftMiniPanel"] = "Minimap BottomLeft (Inside)"
L["BottomMiniPanel"] = "Minimap Bottom (Inside)"
L["BottomRightMiniPanel"] = "Minimap BottomRight (Inside)"
L["Custom Currencies"] = true;
L["Custom Currency"] = true;
L["Datatext Panel (Left)"] = true;
L["Datatext Panel (Right)"] = true;
L["DataTexts"] = true;
L["Display data panels below the chat, used for datatexts."] = true;
L["Display In Main Tooltip"] = true;
L["Display minimap panels below the minimap, used for datatexts."] = true;
L["Displayed Currency"] = true;
L["Gold Format"] = true;
L["If enabled, then this currency will be displayed in the main Currencies datatext tooltip."] = true;
L["If not set to true then the server time will be displayed instead."] = true;
L["left"] = "Left"
L["LeftChatDataPanel"] = "Left Chat"
L["LeftMiniPanel"] = "Minimap Left"
L["Local Time"] = true;
L["middle"] = "Middle"
L["Minimap Panels"] = true;
L["Panel Transparency"] = true;
L["Panels"] = true;
L["right"] = "Right"
L["RightChatDataPanel"] = "Right Chat"
L["RightMiniPanel"] = "Minimap Right"
L["Small Panels"] = true;
L["The display format of the money text that is shown in the gold datatext and its tooltip."] = true;
L["This allows you to create a new datatext which will track the currency with the supplied currency ID. The datatext can be added to a panel immediately after creation."] = true;
L["Toggle 24-hour mode for the time datatext."] = true;
L["TopLeftMiniPanel"] = "Minimap TopLeft (Inside)"
L["TopMiniPanel"] = "Minimap Top (Inside)"
L["TopRightMiniPanel"] = "Minimap TopRight (Inside)"
L["Use Tooltip"] = true;
L["When inside a battleground display personal scoreboard information on the main datatext bars."] = true;
L["Word Wrap"] = true;

--Distributor
L["Must be in group with the player if he isn't on the same server as you."] = true;
L["Sends your current profile to your target."] = true;
L["Sends your filter settings to your target."] = true;
L["Share Current Profile"] = true;
L["Share Filters"] = true;
L["This feature will allow you to transfer settings to other characters."] = true;
L["You must be targeting a player."] = true;

--General
L["Accept Invites"] = true;
L["Adjust the position of the threat bar to either the left or right datatext panels."] = true;
L["AFK Mode"] = true;
L["Announce Interrupts"] = true;
L["Announce when you interrupt a spell to the specified chat channel."] = true;
L["Attempt to support eyefinity/nvidia surround."] = true;
L["Auto Greed/DE"] = true;
L["Auto Repair"] = true;
L["Auto Scale"] = true;
L["Automatically accept invites from guild/friends."] = true;
L["Automatically repair using the following method when visiting a merchant."] = true;
L["Automatically scale the User Interface based on your screen resolution"] = true;
L["Automatically select greed or disenchant (when available) on green quality items. This will only work if you are the max level."] = true;
L["Automatically vendor gray items when visiting a vendor."] = true;
L["Bonus Reward Position"] = true;
L["Bottom Panel"] = true;
L["Chat Bubbles Style"] = true;
L["Chat Bubbles"] = true;
L["Direction the bar moves on gains/losses"] = true;
L["Disable Tutorial Buttons"] = true;
L["Disables the tutorial button found on some frames."] = true;
L["Display a panel across the bottom of the screen. This is for cosmetic only."] = true;
L["Display a panel across the top of the screen. This is for cosmetic only."] = true;
L["Display battleground messages in the middle of the screen."] = true;
L["Display emotion icons in chat."] = true;
L["Emotion Icons"] = true;
L["Enable + Adjust Movers"] = true;
L["Enable/Disable the loot frame."] = true;
L["Enable/Disable the loot roll frame."] = true;
L["Enables the ElvUI Raid Control panel."] = true;
L["Enhanced PVP Messages"] = true;
L["General"] = true;
L["Height of the objective tracker. Increase size to be able to see more objectives."] = true;
L["Hide At Max Level"] = true;
L["Hide Error Text"] = true;
L["Hide In Vehicle"] = true;
L["Hides the red error text at the top of the screen while in combat."] = true;
L["Log Taints"] = true;
L["Login Message"] = true;
L["Loot Roll"] = true;
L["Loot"] = true;
L["Lowest Allowed UI Scale"] = true;
L["Multi-Monitor Support"] = true;
L["Name Font"] = true;
L["Number Prefix"] = true;
L["Objective Frame Height"] = true;
L["Order Hall Command Bar"] = true;
L["Party / Raid"] = true;
L["Party Only"] = true;
L["Position of bonus quest reward frame relative to the objective tracker."] = true;
L["Raid Only"] = true;
L["Remove Backdrop"] = true;
L["Reset all frames to their original positions."] = true;
L["Reset Anchors"] = true;
L["Reverse Fill Direction"] = true;
L["Send ADDON_ACTION_BLOCKED errors to the Lua Error frame. These errors are less important in most cases and will not effect your game performance. Also a lot of these errors cannot be fixed. Please only report these errors if you notice a Defect in gameplay."] = true;
L["Skin Backdrop (No Borders)"] = true;
L["Skin Backdrop"] = true;
L["Skin the blizzard chat bubbles."] = true;
L["Talking Head Scale"] = true;
L["The font that appears on the text above players heads. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = true;
L["The Thin Border Theme option will change the overall apperance of your UI. Using Thin Border Theme is a slight performance increase over the traditional layout."] = true;
L["The unit prefixes you want to use when values are shortened in ElvUI. This is mostly used on UnitFrames."] = true;
L["Thin Border Theme"] = true;
L["Toggle Tutorials"] = true;
L["Top Panel"] = true;
L["When you go AFK display the AFK screen."] = true;

--Media
L["Applies the font and font size settings throughout the entire user interface. Note: Some font size settings will be skipped due to them having a smaller font size by default."] = true;
L["Applies the primary texture to all statusbars."] = true;
L["Apply Font To All"] = true;
L["Apply Texture To All"] = true;
L["Backdrop color of transparent frames"] = true;
L["Backdrop Color"] = true;
L["Backdrop Faded Color"] = true;
L["Border Color"] = true;
L["Color some texts use."] = true;
L["CombatText Font"] = true;
L["Default Font"] = true;
L["Fonts"] = true;
L["Main backdrop color of the UI."] = true;
L["Main border color of the UI."] = true;
L["Media"] = true;
L["Primary Texture"] = true;
L["Replace Blizzard Fonts"] = true;
L["Replaces the default Blizzard fonts on various panels and frames with the fonts chosen in the Media section of the ElvUI config. NOTE: Any font that inherits from the fonts ElvUI usually replaces will be affected as well if you disable this. Enabled by default."] = true;
L["Secondary Texture"] = true;
L["Set the font size for everything in UI. Note: This doesn't effect somethings that have their own seperate options (UnitFrame Font, Datatext Font, ect..)"] = true;
L["Textures"] = true;
L["The font that combat text will use. |cffFF0000WARNING: This requires a game restart or re-log for this change to take effect.|r"] = true;
L["The font that the core of the UI will use."] = true;
L["The texture that will be used mainly for statusbars."] = true;
L["This texture will get used on objects like chat windows and dropdown menus."] = true;
L["Value Color"] = true;

--Maps
L["Adjust the size of the minimap."] = true;
L["Always Display"] = true;
L["Bottom Left"] = true;
L["Bottom Right"] = true;
L["Bottom"] = true;
L["Change settings for the display of the location text that is on the minimap."] = true;
L["Enable/Disable the minimap. |cffFF0000Warning: This will prevent you from seeing the minimap datatexts.|r"] = true;
L["Instance Difficulty"] = true;
L["Left"] = true;
L["LFG Queue"] = true;
L["Location Text"] = true;
L["Make the world map smaller."] = true;
L["Map Opacity When Moving"] = true;
L["Maps"] = true;
L["Minimap Buttons"] = true;
L["Minimap Mouseover"] = true;
L["Open Ticket"] = true;
L["Puts coordinates on the world map."] = true;
L["Reset Zoom"] = true;
L["Right"] = true;
L["Scale"] = true;
L["Smaller World Map"] = true;
L["Top Left"] = true;
L["Top Right"] = true;
L["Top"] = true;
L["World Map Coordinates"] = true;
L["X-Offset"] = true;
L["Y-Offset"] = true;

--Misc
L["Filters are not allowed to have commas in their name. Stripping commas from filter name."] = true;
L["Install"] = true;
L["Run the installation process."] = true;
L["Toggle Anchors"] = true;
L["Unlock various elements of the UI to be repositioned."] = true;
L["Version"] = true;

--NamePlates
L["# Displayed Auras"] = true;
L["Actions"] = true;
L["Add a Name or NPC ID to the list."] = true;
L["Add Name or NPC ID"] = true;
L["Add Nameplate Filter"] = true;
L["Add Regular Filter"] = true;
L["Add Special Filter"] = true;
L["Always Show Target Health"] = true;
L["Always Show"] = true;
L["Apply this filter if a buff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a buff has remaining time less than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time greater than this. Set to zero to disable."] = true;
L["Apply this filter if a debuff has remaining time less than this. Set to zero to disable."] = true;
L["Background Glow"] = true;
L["Bad Color"] = true;
L["Bad Scale"] = true;
L["Bad Transition Color"] = true;
L["Base Height for the Aura Icon"] = true;
L["Border Glow"] = true;
L["Border"] = true;
L["Boss Auras"] = true;
L["Cast Bar"] = true;
L["Cast Color"] = true;
L["Cast No Interrupt Color"] = true;
L["Cast Time Format"] = true;
L["Casting"] = true;
L["Channel Time Format"] = true;
L["Clamp nameplates to the top of the screen when outside of view."] = true;
L["Clamp Nameplates"] = true;
L["Clear Filter"] = true;
L["Clickable Height"] = true;
L["Clickable Width"] = true;
L["Color Tanked"] = true;
L["Control enemy nameplates toggling on or off when in combat."] = true;
L["Control friendly nameplates toggling on or off when in combat."] = true;
L["Controls how big of an area on the screen will accept clicks to target unit."] = true;
L["Controls how many auras are displayed, this will also affect the size of the auras."] = true;
L["Controls which nameplates will be displayed."] = true;
L["Copy settings from another unit."] = true;
L["Copy Settings From"] = true;
L["Current Level"] = true;
L["Default Settings"] = true;
L["Detection"] = true;
L["Display a healer icon over known healers inside battlegrounds or arenas."] = true;
L["Display Minions"] = true;
L["Display Minor Units"] = true;
L["Display NPC Titles whenever healthbars arent displayed and names are."] = true;
L["Display Style"] = true;
L["Elite Icon"] = true
L["Enable/Disable the scaling of targetted nameplates."] = true;
L["Enemy Combat Toggle"] = true;
L["Enemy NPC Frames"] = true;
L["Enemy Player Frames"] = true;
L["Enemy"] = true; --Also used in UnitFrames
L["ENEMY_NPC"] = "Enemy NPC"
L["ENEMY_PLAYER"] = "Enemy Player"
L["Filter already exists!"] = true;
L["Filter Priority"] = true;
L["Filter"] = true;
L["Filters Page"] = true;
L["Friendly Combat Toggle"] = true;
L["Friendly NPC Frames"] = true;
L["Friendly Player Frames"] = true;
L["FRIENDLY_NPC"] = "Friendly NPC"
L["FRIENDLY_PLAYER"] = "Friendly Player"
L["General Options"] = true;
L["Good Color"] = true;
L["Good Scale"] = true;
L["Good Transition Color"] = true;
L["Healer Frames"] = true;
L["Healer Icon"] = true;
L["HEALER"] = "Healer"
L["Health Color"] = true;
L["Health Threshold"] = true;
L["Hide Delay"] = true;
L["Hide Frame"] = true;
L["Hide Spell Name"] = true;
L["Hide Time"] = true;
L["Hide When Empty"] = true;
L["Hide"] = true; --Also used in DataTexts
L["How many seconds the castbar should stay visible after the cast failed or was interrupted."] = true;
L["Icon Base Height"] = true;
L["If enabled then it checks if auras are missing instead of being present on the unit."] = true;
L["If enabled then it will require all auras to activate the filter. Otherwise it will only require any one of the auras to activate it."] = true;
L["If enabled then the filter will only activate if the level of the unit is equal to or higher than this value."] = true;
L["If enabled then the filter will only activate if the level of the unit is equal to or lower than this value."] = true;
L["If enabled then the filter will only activate if the level of the unit matches this value."] = true;
L["If enabled then the filter will only activate if the level of the unit matches your own."] = true;
L["If enabled then the filter will only activate if the unit is casting interruptible spells."] = true;
L["If enabled then the filter will only activate when the unit is in combat."] = true;
L["If enabled then the filter will only activate when the unit is out of combat."] = true;
L["If enabled then the filter will only activate when you are in combat."] = true;
L["If enabled then the filter will only activate when you are out of combat."] = true;
L["If the aura is listed with a number then you need to use that to remove it from the list."] = true;
L["If this list is empty, and if 'Interruptible' is checked, then the filter will activate on any type of cast that can be interrupted."] = true;
L["If this threshold is used then the health of the unit needs to be higher than this value in order for the filter to activate. Set to 0 to disable."] = true;
L["If this threshold is used then the health of the unit needs to be lower than this value in order for the filter to activate. Set to 0 to disable."] = true;
L["In Combat"] = true;
L["Interruptible"] = true;
L["Is Targeted"] = true;
L["LEVEL_BOSS"] = "Set level to -1 for boss units or set to 0 to disable.";
L["Load Distance"] = true;
L["Low Health Threshold"] = true;
L["Lower numbers mean a higher priority. Filters are processed in order from 1 to 100."] = true;
L["Make the unitframe glow yellow when it is below this percent of health, it will glow red when the health value is half of this value."] = true;
L["Match Player Level"] = true;
L["Maximum Level"] = true;
L["Maximum Time Left"] = true;
L["Minimum Level"] = true;
L["Minimum Time Left"] = true;
L["Missing"] = true;
L["Name Color"] = true;
L["NamePlates"] = true;
L["Non-Target Transparency"] = true;
L["Not Targeted"] = true;
L["Only load nameplates for units within this range."] = true;
L["Only Show Target"] = true;
L["Out Of Combat"] = true;
L["Over Health Threshold"] = true;
L["Personal Auras"] = true
L["Player in Combat"] = true;
L["Player Nameplate"] = true;
L["Player Out of Combat"] = true;
L["PLAYER"] = "Player"
L["Reaction Colors"] = true;
L["Reaction Type"] = true;
L["Remove a Name or NPC ID from the list."] = true;
L["Remove Buff"] = true;
L["Remove Debuff"] = true;
L["Remove Name or NPC ID"] = true;
L["Remove Name"] = true;
L["Remove Nameplate Filter"] = true;
L["Require All"] = true;
L["Require of the selected auras."] = true;
L["Reset filter priority to the default state."] = true;
L["Reset Priority"] = true;
L["Return filter to its default state."] = true;
L["Scale of the nameplate that is targetted."] = true;
L["Select Nameplate Filter"] = true;
L["Set Settings to Default"] = true;
L["Set the transparency level of nameplates that are not the target nameplate."] = true;
L["Set to either stack nameplates vertically or allow them to overlap."] = true;
L["Shortcut to 'Filters' section of the config."] = true;
L["Shortcuts"] = true;
L["Show In Combat"] = true;
L["Show NPC Titles"] = true;
L["Show With Target"] = true;
L["Side Arrows"] = true;
L["Style Filter"] = true;
L["Suramar Detection"] = true;
L["Tagged NPC"] = true;
L["Tanked Color"] = true;
L["Target Glow Color"] = true;
L["Target Indicator"] = true;
L["Target Scale"] = true;
L["Target, Quest, Combat"] = true;
L["Targeted Nameplate"] = true;
L["Texture"] = true;
L["These filters don't use a list of spells like the regular filters. Instead they use the WoW API and some code logic to determine if an aura should be allowed or blocked."] = true;
L["These filters use a list of spells to determine if an aura should be allowed or blocked. The content of these filters can be modified in the 'Filters' section of the config."] = true;
L["Threat"] = true;
L["Time To Hold"] = true;
L["Toggle Off While In Combat"] = true;
L["Toggle On While In Combat"] = true;
L["Top Arrow"] = true;
L["Triggers"] = true;
L["Under Health Threshold"] = true;
L["Unit in Combat"] = true;
L["Unit Out of Combat"] = true;
L["Unit Type"] = true;
L["Use Class Color"] = true;
L["Use drag and drop to rearrange filter priority or right click to remove a filter."] = true;
L["Use Portrait"] = true;
L["Use Static Position"] = true;
L["Use Tanked Color when a nameplate is being effectively tanked by another tank."] = true;
L["Use Target Glow"] = true;
L["Use Target Scale"] = true;
L["Use Threat Color"] = true;
L["When enabled the nameplate will stay visible in a locked position."] = true;
L["You can't remove a default name from the filter, disabling the name."] = true;

--Profiles Export/Import
L["Aura Filters"] = true;
L["Choose Export Format"] = true;
L["Choose What To Export"] = true;
L["Decode Text"] = true;
L["Error decoding data. Import string may be corrupted!"] = true;
L["Error exporting profile!"] = true;
L["Export Now"] = true;
L["Export Profile"] = true;
L["Exported"] = true;
L["Filters (All)"] = true;
L["Filters (NamePlates)"] = true;
L["Filters (UnitFrames)"] = true;
L["Global (Account Settings)"] = true;
L["Import Now"] = true;
L["Import Profile"] = true;
L["Importing"] = true;
L["NamePlate Style Filters"] = true;
L["Plugin"] = true;
L["Private (Character Settings)"] = true;
L["Profile imported successfully!"] = true;
L["Profile Name"] = true;
L["Profile"] = true;
L["Table"] = true;

--Skins
L["Achievement Frame"] = true;
L["AddOn Manager"] = true;
L["Alert Frames"] = true;
L["Archaeology Frame"] = true;
L["Auction Frame"] = true;
L["Barbershop Frame"] = true;
L["BG Map"] = true;
L["BG Score"] = true;
L["Black Market AH"] = true;
L["Calendar Frame"] = true;
L["Character Frame"] = true;
L["Contribution"] = true;
L["Death Recap"] = true;
L["Debug Tools"] = true;
L["Gossip Frame"] = true;
L["Guild Control Frame"] = true;
L["Guild Frame"] = true;
L["Guild Registrar"] = true;
L["Help Frame"] = true;
L["Inspect Frame"] = true;
L["Item Upgrade"] = true;
L["KeyBinding Frame"] = true;
L["LF Guild Frame"] = true;
L["LFG Frame"] = true;
L["Loot Frames"] = true;
L["Loss Control"] = true;
L["Macro Frame"] = true;
L["Mail Frame"] = true;
L["Merchant Frame"] = true;
L["Mirror Timers"] = true;
L["Misc Frames"] = true;
L["Non-Raid Frame"] = true;
L["Orderhall"] = true;
L["Pet Battle"] = true;
L["Petition Frame"] = true;
L["PvP Frames"] = true;
L["Quest Choice"] = true;
L["Quest Frames"] = true;
L["Raid Frame"] = true;
L["Skins"] = true;
L["Socket Frame"] = true;
L["Spellbook"] = true;
L["Stable"] = true;
L["Tabard Frame"] = true;
L["Talent Frame"] = true;
L["TalkingHead"] = true;
L["Taxi Frame"] = true;
L["Time Manager"] = true;
L["Trade Frame"] = true;
L["TradeSkill Frame"] = true;
L["Trainer Frame"] = true;
L["Transmogrify Frame"] = true;

--Tooltip
L["Always Hide"] = true;
L["Bags Only"] = true;
L["Bags/Bank"] = true;
L["Bank Only"] = true;
L["Both"] = true;
L["Choose when you want the tooltip to show. If a modifer is chosen, then you need to hold that down to show the tooltip."] = true;
L["Comparison Font Size"] = true;
L["Cursor Anchor"] = true;
L["Custom Faction Colors"] = true;
L["Display guild ranks if a unit is guilded."] = true;
L["Display how many of a certain item you have in your possession."] = true;
L["Display player titles."] = true;
L["Display the players talent spec and item level in the tooltip, this may not immediately update when mousing over a unit."] = true;
L["Display the spell or item ID when mousing over a spell or item tooltip."] = true;
L["Guild Ranks"] = true;
L["Header Font Size"] = true;
L["Health Bar"] = true;
L["Hide tooltip while in combat."] = true;
L["Inspect Info"] = true;
L["Item Count"] = true;
L["Never Hide"] = true;
L["Player Titles"] = true;
L["Should tooltip be anchored to mouse cursor"] = true;
L["Spell/Item IDs"] = true;
L["Target Info"] = true;
L["Text Font Size"] = true;
L["This setting controls the size of text in item comparison tooltips."] = true;
L["Tooltip Font Settings"] = true;
L["When in a raid group display if anyone in your raid is targeting the current tooltip unit."] = true;

--UnitFrames
L["%s and then %s"] = true;
L["2D"] = true;
L["3D"] = true;
L["Above"] = true;
L["Absorbs"] = true;
L["Add a spell to the filter. Use spell ID if you don't want to match all auras which share the same name."] = true;
L["Add a spell to the filter."] = true;
L["Add Spell ID or Name"] = true;
L["Add SpellID"] = true;
L["Additional Filter Override"] = true;
L["Additional Filter"] = true;
L["Additional Power Text"] = true;
L["Allow auras considered to be part of a boss encounter."] = true;
L["Allow Boss Encounter Auras"] = true;
L["Allow non-personal auras from additional filter when 'Block Non-Personal Auras' is enabled."] = true;
L["Allow Whitelisted Auras"] = true;
L["An X offset (in pixels) to be used when anchoring new frames."] = true;
L["An Y offset (in pixels) to be used when anchoring new frames."] = true;
L["Anticipation"] = true;
L["Ascending or Descending order."] = true;
L["Assist Frames"] = true;
L["Assist Target"] = true;
L["At what point should the text be displayed. Set to -1 to disable."] = true;
L["Attach Text To"] = true;
L["Attach To"] = true;
L["Aura Bars"] = true;
L["Auto-Hide"] = true;
L["Bad"] = true;
L["Bars will transition smoothly."] = true;
L["Below"] = true;
L["Blacklist Modifier"] = true;
L["Blacklist"] = true;
L["Block Auras Without Duration"] = true;
L["Block Blacklisted Auras"] = true;
L["Block Non-Dispellable Auras"] = true;
L["Block Non-Personal Auras"] = true;
L["Borders"] = true;
L["Buff Indicator"] = true;
L["Buffs"] = true;
L["By Type"] = true;
L["Camera Distance Scale"] = true;
L["Castbar"] = true;
L["Center"] = true;
L["Check if you are in range to cast spells on this specific unit."] = true;
L["Choose UIPARENT to prevent it from hiding with the unitframe."] = true;
L["Class Backdrop"] = true;
L["Class Castbars"] = true;
L["Class Color Override"] = true;
L["Class Health"] = true;
L["Class Power"] = true;
L["Class Resources"] = true;
L["Click Through"] = true;
L["Color all buffs that reduce the unit's incoming damage."] = true;
L["Color aurabar debuffs by type."] = true;
L["Color castbars by the class of player units."] = true;
L["Color castbars by the reaction type of non-player units."] = true;
L["Color health by amount remaining."] = true;
L["Color health by classcolor or reaction."] = true;
L["Color power by classcolor or reaction."] = true;
L["Color the health backdrop by class or reaction."] = true;
L["Color the unit healthbar if there is a debuff that can be dispelled by you."] = true;
L["Color Turtle Buffs"] = true;
L["Colored Icon"] = true;
L["Coloring (Specific)"] = true
L["Coloring"] = true
L["Combat Fade"] = true;
L["Combat Icon"] = true;
L["Combo Point"] = true;
L["Configure Auras"] = true;
L["Copy From"] = true;
L["Count Font Size"] = true;
L["Create a custom fontstring. Once you enter a name you will be able to select it from the elements dropdown list."] = true;
L["Create a filter, once created a filter can be set inside the buffs/debuffs section of each unit."] = true;
L["Create Filter"] = true;
L["Current - Max | Percent"] = true;
L["Current - Max"] = true;
L["Current - Percent"] = true;
L["Current / Max"] = true;
L["Current"] = true;
L["Custom Dead Backdrop"] = true;
L["Custom Health Backdrop"] = true;
L["Custom Texts"] = true;
L["Debuff Highlighting"] = true;
L["Debuffs"] = true;
L["Decimal Threshold"] = true;
L["Deficit"] = true;
L["Delete a created filter, you cannot delete pre-existing filters, only custom ones."] = true;
L["Delete Filter"] = true;
L["Detach From Frame"] = true;
L["Detached Width"] = true;
L["Direction the health bar moves when gaining/losing health."] = true;
L["Disable Debuff Highlight"] = true;
L["Disabled Blizzard Frames"] = true;
L["Disables the focus and target of focus unitframes."] = true;
L["Disables the player and pet unitframes."] = true;
L["Disables the target and target of target unitframes."] = true;
L["Disconnected"] = true;
L["Display a spark texture at the end of the castbar statusbar to help show the differance between castbar and backdrop."] = true;
L["Display Frames"] = true;
L["Display icon on arena frame indicating the units talent specialization or the units faction if inside a battleground."] = true;
L["Display Player"] = true;
L["Display Target"] = true;
L["Display Text"] = true;
L["Display the castbar icon inside the castbar."] = true;
L["Display the castbar inside the information panel, the icon will be displayed outside the main unitframe."] = true;
L["Display the combat icon on the unitframe."] = true;
L["Display the rested icon on the unitframe."] = true;
L["Display the target of your current cast. Useful for mouseover casts."] = true;
L["Display tick marks on the castbar for channelled spells. This will adjust automatically for spells like Drain Soul and add additional ticks based on haste."] = true;
L["Don't display any auras found on the 'Blacklist' filter."] = true;
L["Don't display auras that are longer than this duration (in seconds). Set to zero to disable."] = true;
L["Don't display auras that are not yours."] = true;
L["Don't display auras that are shorter than this duration (in seconds). Set to zero to disable."] = true;
L["Don't display auras that cannot be purged or dispelled by your class."] = true;
L["Don't display auras that have no duration."] = true;
L["Down"] = true;
L["Duration Reverse"] = true;
L["Duration Text"] = true;
L["Duration"] = true;
L["Enabling this allows raid-wide sorting however you will not be able to distinguish between groups."] = true;
L["Enabling this inverts the grouping order when the raid is not full, this will reverse the direction it starts from."] = true;
L["Enemy Aura Type"] = true;
L["Fade the unitframe when out of combat, not casting, no target exists."] = true;
L["Fill"] = true;
L["Filled"] = true;
L["Filter Type"] = true;
L["Fluid Position Buffs on Debuffs"] = true;
L["Fluid Position Debuffs on Buffs"] = true;
L["Force Off"] = true;
L["Force On"] = true;
L["Force Reaction Color"] = true;
L["Force the frames to show, they will act as if they are the player frame."] = true;
L["Forces Debuff Highlight to be disabled for these frames"] = true;
L["Forces reaction color instead of class color on units controlled by players."] = true;
L["Format"] = true;
L["Frame Level"] = true;
L["Frame Orientation"] = true;
L["Frame Strata"] = true;
L["Frame"] = true;
L["Frequent Updates"] = true;
L["Friendly Aura Type"] = true;
L["Friendly"] = true;
L["Glow"] = true; --Also used in NamePlates
L["Good"] = true;
L["Group By"] = true;
L["Grouping & Sorting"] = true;
L["Groups Per Row/Column"] = true;
L["Growth direction from the first unitframe."] = true;
L["Growth Direction"] = true;
L["Heal Absorbs"] = true;
L["Heal Prediction"] = true;
L["Health Backdrop"] = true;
L["Health Border"] = true;
L["Health By Value"] = true;
L["Health"] = true;
L["Height"] = true;
L["Horizontal Spacing"] = true;
L["Horizontal"] = true; --Also used in bags module
L["How far away the portrait is from the camera."] = true;
L["Icon Inside Castbar"] = true;
L["Icon Size"] = true;
L["Icon"] = true;
L["Icon: BOTTOM"] = true;
L["Icon: BOTTOMLEFT"] = true;
L["Icon: BOTTOMRIGHT"] = true;
L["Icon: LEFT"] = true;
L["Icon: RIGHT"] = true;
L["Icon: TOP"] = true;
L["Icon: TOPLEFT"] = true;
L["Icon: TOPRIGHT"] = true;
L["If no other filter options are being used then it will block anything not on the 'Whitelist' filter, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = true;
L["If not set to 0 then override the size of the aura icon to this."] = true;
L["If the unit is an enemy to you."] = true;
L["If the unit is friendly to you."] = true;
L["If you have a lot of 3D Portraits active then it will likely have a big impact on your FPS. Disable some portraits if you experience FPS issues."] = true;
L["Ignore mouse events."] = true;
L["InfoPanel Border"] = true;
L["Information Panel"] = true;
L["Inset"] = true;
L["Inside Information Panel"] = true;
L["Interruptable"] = true;
L["Invert Grouping Order"] = true;
L["JustifyH"] = true;
L["Latency"] = true;
L["Left to Right"] = true;
L["Main statusbar texture."] = true;
L["Main Tanks / Main Assist"] = true;
L["Make textures transparent."] = true;
L["Match Frame Width"] = true;
L["Max amount of overflow allowed to extend past the end of the health bar."] = true;
L["Max Bars"] = true;
L["Max Overflow"] = true;
L["Maximum Duration"] = true;
L["Method to sort by."] = true;
L["Middle Click - Set Focus"] = true;
L["Middle clicking the unit frame will cause your focus to match the unit."] = true;
L["Middle"] = true;
L["Minimum Duration"] = true;
L["Model Rotation"] = true;
L["Mouseover"] = true;
L["Name"] = true; --Also used in Buffs and Debuffs
L["Neutral"] = true;
L["Non-Interruptable"] = true;
L["Not valid spell id"] = true;
L["Num Rows"] = true;
L["Number of Groups"] = true;
L["Offset of the powerbar to the healthbar, set to 0 to disable."] = true;
L["Offset position for text."] = true;
L["Offset"] = true;
L["OOR Alpha"] = true;
L["Others"] = true;
L["Overlay the healthbar"] = true;
L["Overlay"] = true;
L["Override any custom visibility setting in certain situations, EX: Only show groups 1 and 2 inside a 10 man instance."] = true;
L["Override the default class color setting."] = true;
L["Owners Name"] = true;
L["Parent"] = true;
L["Party Pets"] = true;
L["Party Targets"] = true;
L["Per Row"] = true;
L["Percent"] = true;
L["Personal"] = true;
L["Pet Name"] = true;
L["Player Frame Aura Bars"] = true;
L["Portrait"] = true;
L["Position Buffs on Debuffs"] = true;
L["Position Debuffs on Buffs"] = true;
L["Position the Model horizontally."] = true;
L["Position the Model vertically."] = true;
L["Position"] = true;
L["Power text will be hidden on NPC targets, in addition the name text will be repositioned to the power texts anchor point."] = true;
L["Power"] = true;
L["Powers"] = true;
L["Priority"] = true;
L["Profile Specific"] = true;
L["PvP & Prestige Icon"] = true;
L["PvP Text"] = true;
L["PVP Trinket"] = true;
L["Raid Icon"] = true;
L["Raid-Wide Sorting"] = true;
L["Raid40 Frames"] = true;
L["RaidDebuff Indicator"] = true;
L["Range Check"] = true
L["Rapidly update the health, uses more memory and cpu. Only recommended for healing."] = true;
L["Reaction Castbars"] = true;
L["Reactions"] = true;
L["Ready Check Icon"] = true;
L["Remaining"] = true;
L["Remove a spell from the filter. Use the spell ID if you see the ID as part of the spell name in the filter."] = true;
L["Remove a spell from the filter."] = true;
L["Remove Spell ID or Name"] = true;
L["Remove SpellID"] = true;
L["Rest Icon"] = true;
L["Restore Defaults"] = true; --Also used in Media and ActionBars sections
L["Right to Left"] = true;
L["RL / ML Icons"] = true;
L["Role Icon"] = true;
L["Seconds remaining on the aura duration before the bar starts moving. Set to 0 to disable."] = true
L["Select a unit to copy settings from."] = true;
L["Select an additional filter to use. If the selected filter is a whitelist and no other filters are being used (with the exception of Block Non-Personal Auras) then it will block anything not on the whitelist, otherwise it will simply add auras on the whitelist in addition to any other filter settings."] = true;
L["Select Filter"] = true;
L["Select Spell"] = true;
L["Select the display method of the portrait."] = true;
L["Set the filter type. Blacklist will hide any auras in the list and show all others. Whitelist will show any auras in the filter and hide all others."] = true;
L["Set the font size for unitframes."] = true;
L["Set the order that the group will sort."] = true;
L["Set the orientation of the UnitFrame."] = true;
L["Set the priority order of the spell, please note that prioritys are only used for the raid debuff module, not the standard buff/debuff module. If you want to disable set to zero."] = true;
L["Set the type of auras to show when a unit is a foe."] = true;
L["Set the type of auras to show when a unit is friendly."] = true;
L["Sets the font instance's horizontal text alignment style."] = true;
L["Show a incomming heal prediction bar on the unitframe. Also display a slightly different colored bar for incoming overheals."] = true;
L["Show Aura From Other Players"] = true;
L["Show Auras"] = true;
L["Show Dispellable Debuffs"] = true;
L["Show For DPS"] = true;
L["Show For Healers"] = true;
L["Show For Tanks"] = true;
L["Show When Not Active"] = true;
L["Size and Positions"] = true;
L["Size of the indicator icon."] = true;
L["Size Override"] = true;
L["Size"] = true;
L["Smart Aura Position"] = true;
L["Smart Raid Filter"] = true;
L["Smooth Bars"] = true;
L["Sort By"] = true;
L["Spaced"] = true;
L["Spacing"] = true;
L["Spark"] = true;
L["Spec Icon"] = true;
L["Stack Counter"] = true;
L["Stack Threshold"] = true;
L["Start Near Center"] = true;
L["Statusbar Fill Orientation"] = true;
L["StatusBar Texture"] = true;
L["Strata and Level"] = true;
L["Style"] = true;
L["Tank Frames"] = true;
L["Tank Target"] = true;
L["Tapped"] = true;
L["Target Glow"] = true;
L["Target On Mouse-Down"] = true;
L["Target units on mouse down rather than mouse up. \n\n|cffFF0000Warning: If you are using the addon 'Clique' you may have to adjust your clique settings when changing this."] = true;
L["Text Color"] = true;
L["Text Format"] = true;
L["Text Position"] = true
L["Text Threshold"] = true;
L["Text Toggle On NPC"] = true;
L["Text xOffset"] = true
L["Text yOffset"] = true
L["Text"] = true;
L["Textured Icon"] = true;
L["The alpha to set units that are out of range to."] = true;
L["The debuff needs to reach this amount of stacks before it is shown. Set to 0 to always show the debuff."] = true;
L["The following macro must be true in order for the group to be shown, in addition to any filter that may already be set."] = true;
L["The font that the unitframes will use."] = true;
L["The initial group will start near the center and grow out."] = true;
L["The name you have selected is already in use by another element."] = true;
L["The object you want to attach to."] = true;
L["Thin Borders"] = true;
L["This dictates the size of the icon when it is not attached to the castbar."] = true;
L["This opens the UnitFrames Color settings. These settings affect all unitframes."] = true;
L["Threat Display Mode"] = true;
L["Threshold before text goes into decimal form. Set to -1 to disable decimals."] = true;
L["Ticks"] = true;
L["Time Remaining Reverse"] = true;
L["Time Remaining"] = true;
L["Transparent"] = true;
L["Turtle Color"] = true;
L["Uniform Threshold"] = true;
L["UnitFrames"] = true;
L["Up"] = true;
L["Use Custom Level"] = true;
L["Use Custom Strata"] = true;
L["Use Dead Backdrop"] = true;
L["Use Default"] = true;
L["Use the custom health backdrop color instead of a multiple of the main health color."] = true;
L["Use the profile specific filter 'Buff Indicator (Profile)' instead of the global filter 'Buff Indicator'."] = true;
L["Use thin borders on certain unitframe elements."] = true;
L["Use this backdrop color for units that are dead or ghosts."] = true;
L["Value must be a number"] = true;
L["Vertical Orientation"] = true;
L["Vertical Spacing"] = true;
L["Vertical"] = true; --Also used in bags section
L["Visibility"] = true;
L["What point to anchor to the frame you set to attach to."] = true;
L["What to attach the buff anchor frame to."] = true;
L["What to attach the debuff anchor frame to."] = true;
L["When true, the header includes the player when not in a raid."] = true;
L["Whitelist"] = true;
L["Width"] = true; --Also used in NamePlates module
L["Will show Buffs in the Debuff position when there are no Debuffs active, or vice versa."] = true;
L["xOffset"] = true;
L["yOffset"] = true;
L["You can't remove a pre-existing filter."] = true;
L["You cannot copy settings from the same unit."] = true;
L["You may not remove a spell from a default filter that is not customly added. Setting spell to false instead."] = true;
L["You need to hold this modifier down in order to blacklist an aura by right-clicking the icon. Set to None to disable the blacklist functionality."] = true;
