<?php
namespace Topxia\MobileBundle\Alipay;

require_once "lib/alipay_core.function.php";
require_once "lib/alipay_rsa.function.php";
require_once "lib/alipay_md5.function.php";

class AlipaySubmit
{
    public $alipay_config;
    /**
     * 支付宝网关地址
     */
    //var $alipay_gateway_new = 'https://mapi.alipay.com/gateway.do?';
    public $alipay_gateway_new = 'http://wappaygw.alipay.com/service/rest.htm?';

    public function __construct($alipay_config)
    {
        $this->alipay_config = $alipay_config;
    }

    public function AlipaySubmit($alipay_config)
    {
        $this->__construct($alipay_config);
    }

    /**
     * 生成签名结果
     * return 签名结果字符串
     * @param $para_sort 已排序要签名的数组
     */
    public function buildRequestMysign($para_sort)
    {
        //把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
        $prestr = createLinkstring($para_sort);

        $mysign = "";

        switch (strtoupper(trim($this->alipay_config['sign_type']))) {
            case "MD5":
                $mysign = md5Sign($prestr, $this->alipay_config['key']);
                break;
            case "RSA":
            case "0001":
                $mysign = rsaSign($prestr, $this->alipay_config['private_key_path']);
                break;
            default:
                $mysign = "";
        }

        return $mysign;
    }

    /**
     * 生成要请求给支付宝的参数数组
     * @param  $para_temp                 请求前的参数数组
     * @return 要请求的参数数组
     */
    public function buildRequestPara($para_temp)
    {
        //除去待签名参数数组中的空值和签名参数
        $para_filter = paraFilter($para_temp);

        //对待签名参数数组排序
        $para_sort = argSort($para_filter);

        //生成签名结果
        $mysign = $this->buildRequestMysign($para_sort);

        //签名结果与签名方式加入请求提交参数组中
        $para_sort['sign'] = $mysign;

        if ($para_sort['service'] != 'alipay.wap.trade.create.direct' && $para_sort['service'] != 'alipay.wap.auth.authAndExecute') {
            $para_sort['sign_type'] = strtoupper(trim($this->alipay_config['sign_type']));
        }

        return $para_sort;
    }

    /**
     * 生成要请求给支付宝的参数数组
     * @param  $para_temp                          请求前的参数数组
     * @return 要请求的参数数组字符串
     */
    public function buildRequestParaToString($para_temp)
    {
        //待请求参数数组
        $para = $this->buildRequestPara($para_temp);

        //把参数组中所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串，并对字符串做urlencode编码
        $request_data = createLinkstringUrlencode($para);

        return $request_data;
    }

    /**
     * 建立请求，以表单HTML形式构造（默认）
     * @param  $para_temp               请求参数数组
     * @param  $method                  提交方式。两个值可选：post、get
     * @param  $button_name             确认按钮显示文字
     * @return 提交表单HTML文本
     */
    public function buildRequestForm($para_temp, $method, $button_name)
    {
        //待请求参数数组
        $para = $this->buildRequestPara($para_temp);

        $sHtml = "<form id='alipaysubmit' name='alipaysubmit' action='".$this->alipay_gateway_new."_input_charset=".trim(strtolower($this->alipay_config['input_charset']))."' method='".$method."'>";

        while (list($key, $val) = each($para)) {
            $sHtml .= "<input type='hidden' name='".$key."' value='".$val."'/>";
        }

        //submit按钮控件请不要含有name属性
        $sHtml = $sHtml."<input type='submit' value='".$button_name."'></form>";

        $sHtml = $sHtml."<script>document.forms['alipaysubmit'].submit();</script>";

        return $sHtml;
    }

    /**
     * 建立请求，以模拟远程HTTP的POST请求方式构造并获取支付宝的处理结果
     * @param  $para_temp              请求参数数组
     * @return 支付宝处理结果
     */
    public function buildRequestHttp($para_temp)
    {
        $sResult = '';

        //待请求参数数组字符串
        $request_data = $this->buildRequestPara($para_temp);

        //远程获取数据
        $sResult = getHttpResponsePOST($this->alipay_gateway_new, $this->alipay_config['cacert'], $request_data, trim(strtolower($this->alipay_config['input_charset'])));

        return $sResult;
    }

    /**
     * 建立请求，以模拟远程HTTP的POST请求方式构造并获取支付宝的处理结果，带文件上传功能
     * @param  $para_temp                    请求参数数组
     * @param  $file_para_name               文件类型的参数名
     * @param  $file_name                    文件完整绝对路径
     * @return 支付宝返回处理结果
     */
    public function buildRequestHttpInFile($para_temp, $file_para_name, $file_name)
    {
        //待请求参数数组
        $para                  = $this->buildRequestPara($para_temp);
        $para[$file_para_name] = "@".$file_name;

        //远程获取数据
        $sResult = getHttpResponsePOST($this->alipay_gateway_new, $this->alipay_config['cacert'], $para, trim(strtolower($this->alipay_config['input_charset'])));

        return $sResult;
    }

    /**
     * 解析远程模拟提交后返回的信息
     * @param  $str_text      要解析的字符串
     * @return 解析结果
     */
    public function parseResponse($str_text)
    {
        //以“&”字符切割字符串
        $para_split = explode('&', $str_text);
        //把切割后的字符串数组变成变量与数值组合的数组

        foreach ($para_split as $item) {
            //获得第一个=字符的位置
            $nPos = strpos($item, '=');
            //获得字符串长度
            $nLen = strlen($item);
            //获得变量名
            $key = substr($item, 0, $nPos);
            //获得数值
            $value = substr($item, $nPos + 1, $nLen - $nPos - 1);
            //放入数组中
            $para_text[$key] = $value;
        }

        if (!empty($para_text['res_data'])) {
            //解析加密部分字符串

            if ($this->alipay_config['sign_type'] == '0001') {
                $para_text['res_data'] = rsaDecrypt($para_text['res_data'], $this->alipay_config['private_key_path']);
            }

            //token从res_data中解析出来（也就是说res_data中已经包含token的内容）

            //$doc = new \DOMDocument('1.0', 'UTF-8');
            //$doc->loadXML($para_text['res_data']);
            $doc                        = simplexml_load_string($para_text['res_data']);
            $para_text['request_token'] = $doc->getElementsByTagName("request_token")->item(0)->nodeValue;
        }

        return $para_text;
    }

    /**
     * 用于防钓鱼，调用接口query_timestamp来获取时间戳的处理函数
     * 注意：该功能PHP5环境及以上支持，因此必须服务器、本地电脑中装有支持DOMDocument、SSL的PHP配置环境。建议本地调试时使用PHP开发软件
     * return 时间戳字符串
     */
    public function query_timestamp()
    {
        $url         = $this->alipay_gateway_new."service=query_timestamp&partner=".trim(strtolower($this->alipay_config['partner']))."&_input_charset=".trim(strtolower($this->alipay_config['input_charset']));
        $encrypt_key = "";

        $doc = new \DOMDocument('1.0', 'UTF-8');
        $doc->load($url);
        $itemEncrypt_key = $doc->getElementsByTagName("encrypt_key");
        $encrypt_key     = $itemEncrypt_key->item(0)->nodeValue;

        return $encrypt_key;
    }
}
