<?php
//EditorTools全自动采集软件开源接口文件
//更多资源请访问软件官网：www.zzcity.net

if ( defined('ABSPATH') )
 require_once(ABSPATH . 'wp-load.php');
else
 require_once('../wp-load.php');
//nocache_headers();

function et_new_comment( $commentdata ) {
	if ( isset( $commentdata['user_ID'] ) ) {
		$commentdata['user_id'] = $commentdata['user_ID'] = (int) $commentdata['user_ID'];
	}

	$prefiltered_user_id = ( isset( $commentdata['user_id'] ) ) ? (int) $commentdata['user_id'] : 0;

	/**
	 * Filter a comment's data before it is sanitized and inserted into the database.
	 *
	 * @since 1.5.0
	 *
	 * @param array $commentdata Comment data.
	 */
 $commentdata = apply_filters('preprocess_comment', $commentdata);

	$commentdata['comment_post_ID'] = (int) $commentdata['comment_post_ID'];
	if ( isset( $commentdata['user_ID'] ) && $prefiltered_user_id !== (int) $commentdata['user_ID'] ) {
		$commentdata['user_id'] = $commentdata['user_ID'] = (int) $commentdata['user_ID'];
	} elseif ( isset( $commentdata['user_id'] ) ) {
		$commentdata['user_id'] = (int) $commentdata['user_id'];
	}

	$commentdata['comment_parent'] = isset($commentdata['comment_parent']) ? absint($commentdata['comment_parent']) : 0;
	$parent_status = ( 0 < $commentdata['comment_parent'] ) ? wp_get_comment_status($commentdata['comment_parent']) : '';
	$commentdata['comment_parent'] = ( 'approved' == $parent_status || 'unapproved' == $parent_status ) ? $commentdata['comment_parent'] : 0;

	$commentdata['comment_author_IP'] = preg_replace( '/[^0-9a-fA-F:., ]/', '',$_SERVER['REMOTE_ADDR'] );
	$commentdata['comment_agent']     = isset( $_SERVER['HTTP_USER_AGENT'] ) ? substr( $_SERVER['HTTP_USER_AGENT'], 0, 254 ) : '';

	$commentdata['comment_date']     = current_time('mysql');
	$commentdata['comment_date_gmt'] = current_time('mysql', 1);

	$commentdata = wp_filter_comment($commentdata);

 //$commentdata['comment_approved'] = wp_allow_comment($commentdata);
 $commentdata['comment_approved'] =1;
 
 $comment_ID = wp_insert_comment($commentdata);
	if ( ! $comment_ID ) {
		return false;
	}

	/**
	 * Fires immediately after a comment is inserted into the database.
	 *
	 * @since 1.2.0
	 *
	 * @param int $comment_ID       The comment ID.
	 * @param int $comment_approved 1 (true) if the comment is approved, 0 (false) if not.
	 */
	do_action( 'comment_post', $comment_ID, $commentdata['comment_approved'] );

	if ( 'spam' !== $commentdata['comment_approved'] ) { // If it's spam save it silently for later crunching
		if ( '0' == $commentdata['comment_approved'] ) {
			wp_notify_moderator( $comment_ID );
		}

		// wp_notify_postauthor() checks if notifying the author of their own comment.
		// By default, it won't, but filters can override this.
		if ( get_option( 'comments_notify' ) && $commentdata['comment_approved'] ) {
			wp_notify_postauthor( $comment_ID );
		}
	}

	return $comment_ID;
}


$comment_post_ID = isset($_POST['comment_post_ID']) ? (int) $_POST['comment_post_ID'] : 0;


$post = get_post($comment_post_ID);

if ( empty($post->comment_status) ) {
 //do_action('comment_id_not_found', $comment_post_ID);
 echo('[err]comment_post_ID not found[/err]');
	exit;
}

// get_post_status() will get the parent status for attachments.
$status = get_post_status($post);

$status_obj = get_post_status_object($status);

if ( !comments_open($comment_post_ID) ) {
 //do_action('comment_closed', $comment_post_ID);
 //wp_die( __('Sorry, comments are closed for this item.') );
 echo('[err]Sorry, comments are closed for this item.[/err]') ;
 exit;
} elseif ( 'trash' == $status ) {
 //do_action('comment_on_trash', $comment_post_ID);
 echo('[err]comment_on_trash[/err]');	
 exit;
} elseif ( ! $status_obj->public && ! $status_obj->private ) {
 //do_action( 'comment_on_draft', $comment_post_ID );
 echo('[err]comment_on_draft[/err]');	
 exit;
}elseif ( post_password_required($comment_post_ID) ) {
 //do_action('comment_on_password_protected', $comment_post_ID);
 echo('[err]comment_on_password_protected[/err]');
 exit;
} else {
 do_action('pre_comment_on_post', $comment_post_ID);
}
//zzcity add
$ruser=$_POST['ruser'];
if(isset($ruser)){
 $rusers=explode(",",$ruser);
 $ri=rand(0,count($rusers)-1);
 $comment_author       = ( isset($rusers[$ri]) )  ? trim(strip_tags($rusers[$ri])) : null;
}else{
 $ruser=$_POST['log'];
 $comment_author       = ( isset($ruser) )  ? trim(strip_tags($ruser)) : null;
}

//$comment_author_email = ( isset($_POST['email']) )   ? trim($_POST['email']) : null;
//$comment_author_url   = ( isset($_POST['url']) )     ? trim($_POST['url']) : null;
$comment_content      = ( isset($_POST['content']) ) ? trim($_POST['content']) : null; //zzcity


$comment_type = '';


if ( '' == $comment_content )
// wp_die( __('Error: please type a comment.') );
 exit('[err]comment is null[/err]');
$comment_parent = isset($_POST['comment_parent']) ? absint($_POST['comment_parent']) : 0;

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'comment_parent', 'user_ID');

$comment_id = et_new_comment( $commentdata );

if($comment_id ){
echo('[ok]comment_id='.$comment_id);}


?>
