/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.UIElement;

public class ToggleStatusBarHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID_TOGGLE_STATUSBAR = "org.eclipse.ui.window.togglestatusbar";
    private static final String BOTTOM_TRIM_ID = "org.eclipse.ui.trim.status";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
        if (!(window instanceof WorkbenchWindow)) {
            return null;
        }
        MUIElement trimStatus = ToggleStatusBarHandler.getTrimStatus((WorkbenchWindow)window);
        if (trimStatus != null) {
            trimStatus.setVisible(!trimStatus.isVisible());
            ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
            HashMap<String, WorkbenchWindow> filter = new HashMap<String, WorkbenchWindow>();
            filter.put("org.eclipse.ui.IWorkbenchWindow", (WorkbenchWindow)window);
            commandService.refreshElements(COMMAND_ID_TOGGLE_STATUSBAR, filter);
        }
        return null;
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchLocationService wls = element.getServiceLocator().getService(IWorkbenchLocationService.class);
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        if (!(window instanceof WorkbenchWindow)) {
            return;
        }
        MUIElement trimStatus = ToggleStatusBarHandler.getTrimStatus((WorkbenchWindow)window);
        if (trimStatus != null) {
            element.setText(trimStatus.isVisible() ? WorkbenchMessages.ToggleStatusBarVisibilityAction_hide_text : WorkbenchMessages.ToggleStatusBarVisibilityAction_show_text);
        }
    }

    private static MUIElement getTrimStatus(WorkbenchWindow window) {
        EModelService modelService = window.getService(EModelService.class);
        MWindow searchRoot = window.getModel();
        return modelService.find(BOTTOM_TRIM_ID, (MUIElement)searchRoot);
    }
}

