/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.tags.TagElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagRootElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TagSourceWorkbenchAdapter
implements IAdaptable,
IWorkbenchAdapter {
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_DATES = 16;
    public static final int INCLUDE_ALL_TAGS = 31;
    TagRootElement branches;
    TagRootElement versions;
    TagRootElement dates;
    int includeFlags;

    public static Object createInput(TagSource tagSource, int includeFlags) {
        if (includeFlags == 8) {
            return new TagRootElement(null, tagSource, 2);
        }
        return new TagSourceWorkbenchAdapter(tagSource, includeFlags);
    }

    public TagSourceWorkbenchAdapter(TagSource tagSource, int includeFlags) {
        this.includeFlags = includeFlags;
        if (this.includeFlags == 0) {
            this.includeFlags = 31;
        }
        if ((includeFlags & 4) > 0) {
            this.branches = new TagRootElement(this, tagSource, 1);
        }
        if ((includeFlags & 8) > 0) {
            this.versions = new TagRootElement(this, tagSource, 2);
        }
        if ((includeFlags & 0x10) > 0) {
            this.dates = new TagRootElement(this, tagSource, 3);
        }
    }

    public Object[] getChildren(Object o) {
        ArrayList<Object> children = new ArrayList<Object>(4);
        if ((this.includeFlags & 1) > 0) {
            children.add(new TagElement(this, CVSTag.DEFAULT));
        }
        if ((this.includeFlags & 2) > 0) {
            children.add(new TagElement(this, CVSTag.BASE));
        }
        if ((this.includeFlags & 4) > 0) {
            children.add(this.branches);
        }
        if ((this.includeFlags & 8) > 0) {
            children.add(this.versions);
        }
        if ((this.includeFlags & 0x10) > 0) {
            children.add(this.dates);
        }
        return children.toArray(new Object[children.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public static class ProjectElementComparator
    extends ViewerComparator {
        public int category(Object element) {
            if (element instanceof TagElement) {
                CVSTag tag = ((TagElement)element).getTag();
                if (tag == CVSTag.DEFAULT) {
                    return 1;
                }
                if (tag == CVSTag.BASE) {
                    return 5;
                }
                if (tag.getType() == 1) {
                    return 2;
                }
                if (tag.getType() == 2) {
                    return 3;
                }
                if (tag.getType() == 3) {
                    return 4;
                }
            } else if (element instanceof TagRootElement) {
                if (((TagRootElement)element).getTypeOfTagRoot() == 1) {
                    return 2;
                }
                if (((TagRootElement)element).getTypeOfTagRoot() == 2) {
                    return 3;
                }
                if (((TagRootElement)element).getTypeOfTagRoot() == 3) {
                    return 4;
                }
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof TagElement) {
                CVSTag tag1 = ((TagElement)e1).getTag();
                int type = tag1.getType();
                if (type == 2) {
                    return -1 * super.compare(viewer, e1, e2);
                }
                if (type == 3) {
                    return -1 * tag1.compareTo(((TagElement)e2).getTag());
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

