/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ActionMenu
extends Action
implements IMenuCreator {
    List<PDELauncherFormEditor.LauncherAction> fActions = new LinkedList<PDELauncherFormEditor.LauncherAction>();
    Menu fMenu;

    public ActionMenu(PDELauncherFormEditor.LauncherAction[] actions) {
        PDELauncherFormEditor.LauncherAction[] launcherActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            PDELauncherFormEditor.LauncherAction action = launcherActionArray[n2];
            this.fActions.add(action);
            ++n2;
        }
        if (!this.fActions.isEmpty()) {
            this.setToolTipText(this.fActions.get(0).getToolTipText());
            this.setImageDescriptor(this.fActions.get(0).getImageDescriptor());
            if (this.fActions.size() > 1) {
                this.setMenuCreator(this);
            }
        }
    }

    public void run() {
        if (!this.fActions.isEmpty()) {
            this.fActions.get(0).run();
        }
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (PDELauncherFormEditor.LauncherAction action : this.fActions) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.fMenu, -1);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void updateActionOrder(List<String> orderedLauncherIds) {
        if (!this.fActions.isEmpty()) {
            Collections.sort(this.fActions, (o1, o2) -> {
                String id1 = o1.getConfigurationElement().getAttribute("id");
                String id2 = o2.getConfigurationElement().getAttribute("id");
                int index1 = orderedLauncherIds.indexOf(id1);
                int index2 = orderedLauncherIds.indexOf(id2);
                if (index1 == -1 && index2 == -1) {
                    return 0;
                }
                if (index1 == -1) {
                    return 1;
                }
                if (index2 == -1) {
                    return -1;
                }
                if (index1 <= index2) {
                    return -1;
                }
                return 1;
            });
            this.setToolTipText(this.fActions.get(0).getToolTipText());
            this.setImageDescriptor(this.fActions.get(0).getImageDescriptor());
        }
    }
}

