/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend.bcel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;

public class AncestorAnalyzer
extends AbstractAnalyzer {
    public AncestorAnalyzer() {
        block2: {
            try {
                new ClassParser("force");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block2;
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        int maxCount;
        Hashtable<String, String> dependencies = new Hashtable<String, String>();
        Hashtable<File, File> containers = new Hashtable<File, File>();
        Hashtable<String, String> toAnalyze = new Hashtable<String, String>();
        Hashtable<String, String> nextAnalyze = new Hashtable<String, String>();
        Enumeration e = this.getRootClasses();
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            toAnalyze.put(classname, classname);
        }
        int count = 0;
        int n = maxCount = this.isClosureRequired() ? 1000 : 2;
        while (toAnalyze.size() != 0 && count++ < maxCount) {
            nextAnalyze.clear();
            for (String classname : toAnalyze.keySet()) {
                dependencies.put(classname, classname);
                try {
                    String superClass;
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.put(container, container);
                    ClassParser parser = null;
                    parser = container.getName().endsWith(".class") ? new ClassParser(container.getPath()) : new ClassParser(container.getPath(), classname.replace('.', '/') + ".class");
                    JavaClass javaClass = parser.parse();
                    String[] interfaces = javaClass.getInterfaceNames();
                    for (int i = 0; i < interfaces.length; ++i) {
                        String interfaceName = interfaces[i];
                        if (dependencies.containsKey(interfaceName)) continue;
                        nextAnalyze.put(interfaceName, interfaceName);
                    }
                    if (!javaClass.isClass() || dependencies.containsKey(superClass = javaClass.getSuperclassName())) continue;
                    nextAnalyze.put(superClass, superClass);
                }
                catch (IOException iOException) {}
            }
            Hashtable<String, String> temp = toAnalyze;
            toAnalyze = nextAnalyze;
            nextAnalyze = temp;
        }
        files.removeAllElements();
        for (File f : containers.keySet()) {
            files.add(f);
        }
        classes.removeAllElements();
        for (String dependency : dependencies.keySet()) {
            classes.add(dependency);
        }
    }

    protected boolean supportsFileDependencies() {
        return true;
    }
}

