/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model.xml;

import java.io.ByteArrayInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.TargetNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;

public class Parser {
    private static Parser instance;
    private LocationNode locationNode;
    private TargetNode target;
    private UnitNode unit;
    private XMLInputFactory inputFactory;

    public Parser() {
        this.initializeParser();
    }

    private void initializeParser() {
        this.inputFactory = XMLInputFactory.newInstance();
    }

    public void parse(IDocument document) throws XMLStreamException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(document.get().getBytes());
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(inputStream);
        while (eventReader.hasNext()) {
            String name;
            XMLEvent event = eventReader.nextEvent();
            Location locator = event.getLocation();
            if (event.isStartElement()) {
                int offset;
                int lineNr;
                StartElement startElement = event.asStartElement();
                name = startElement.getName().getLocalPart();
                if ("target".equalsIgnoreCase(name)) {
                    this.target = new TargetNode();
                    lineNr = locator.getLineNumber();
                    try {
                        offset = document.getLineOffset(lineNr - 1);
                        this.target.setOffsetStart(offset);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                if ("location".equalsIgnoreCase(name)) {
                    lineNr = locator.getLineNumber();
                    try {
                        offset = document.getLineOffset(lineNr - 1);
                        this.locationNode = new LocationNode();
                        this.locationNode.setOffsetStart(offset);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                if ("repository".equalsIgnoreCase(name)) {
                    String value;
                    Attribute locationAttribute = startElement.getAttributeByName(new QName("location"));
                    String string = value = locationAttribute == null ? "" : locationAttribute.getValue();
                    if (this.locationNode == null) {
                        return;
                    }
                    this.locationNode.setRepositoryLocation(value);
                }
                if ("unit".equalsIgnoreCase(name)) {
                    if (this.locationNode == null) {
                        return;
                    }
                    int lineNr2 = locator.getLineNumber();
                    try {
                        Attribute versionAttribute;
                        int offset2 = document.getLineOffset(lineNr2 - 1);
                        this.unit = new UnitNode();
                        Attribute idAttribute = startElement.getAttributeByName(new QName("id"));
                        if (idAttribute != null) {
                            this.unit.setId(idAttribute.getValue());
                        }
                        if ((versionAttribute = startElement.getAttributeByName(new QName("version"))) != null) {
                            this.unit.setVersion(versionAttribute.getValue());
                        }
                        this.unit.setOffsetStart(offset2);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!event.isEndElement()) continue;
            EndElement endElement = event.asEndElement();
            name = endElement.getName().getLocalPart();
            if ("target".equalsIgnoreCase(name)) {
                int lineNr = locator.getLineNumber();
                try {
                    int offset = document.getLineOffset(lineNr - 1);
                    this.target.setOffsetEnd(offset);
                    this.target.setNodeText(document.get(this.target.getOffsetStart(), this.target.getOffsetEnd() - this.target.getOffsetStart()));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            if ("location".equalsIgnoreCase(name)) {
                int lineNr = locator.getLineNumber();
                try {
                    int offset = document.getLineOffset(lineNr - 1);
                    this.locationNode.setOffsetEnd(offset);
                    this.target.getNodes().add(this.locationNode);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            if (!"unit".equalsIgnoreCase(name)) continue;
            if (this.unit == null) {
                return;
            }
            if (this.locationNode == null) {
                return;
            }
            int lineNr = locator.getLineNumber();
            try {
                int offset = document.getLineOffset(lineNr);
                this.unit.setOffsetEnd(offset);
                this.locationNode.addUnitNode(this.unit);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public static Parser getDefault() {
        if (instance == null) {
            instance = new Parser();
        }
        return instance;
    }

    public TargetNode getRootNode() {
        return this.target;
    }
}

