/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalTypeId
extends CPPDependentEvaluation {
    private final IType fInputType;
    private final ICPPEvaluation[] fArguments;
    private final boolean fRepresentsNewExpression;
    private IType fOutputType;
    private ICPPFunction fConstructor = CPPFunction.UNINITIALIZED_FUNCTION;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsTypeDependent;

    public EvalTypeId(IType type, IASTNode pointOfDefinition, ICPPEvaluation ... arguments) {
        this(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), false, arguments);
    }

    public EvalTypeId(IType type, IBinding templateDefinition, ICPPEvaluation ... arguments) {
        this(type, templateDefinition, false, arguments);
    }

    private EvalTypeId(IType type, IBinding templateDefinition, boolean forNewExpression, ICPPEvaluation ... arguments) {
        super(templateDefinition);
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        this.fInputType = type;
        this.fArguments = arguments;
        this.fRepresentsNewExpression = forNewExpression;
    }

    public static EvalTypeId createForNewExpression(IType type, IASTNode pointOfDefinition, ICPPEvaluation ... arguments) {
        return new EvalTypeId(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), true, arguments);
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType(IASTNode point) {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType;
    }

    private IType computeType() {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        IType type = ExpressionTypes.typeFromReturnType(this.fInputType);
        if (this.fRepresentsNewExpression) {
            return new CPPPointerType(type);
        }
        return type;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        if (this.isTypeDependent()) {
            return Value.create(this);
        }
        if (this.fRepresentsNewExpression) {
            return Value.UNKNOWN;
        }
        if (this.fOutputType instanceof ICPPClassType) {
            return Value.UNKNOWN;
        }
        if (this.fArguments.length == 1) {
            return this.fArguments[0].getValue(point);
        }
        return Value.UNKNOWN;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fInputType) || EvalTypeId.containsDependentType(this.fArguments);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (CPPTemplates.isDependentType(this.fInputType)) {
            return true;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return !this.fRepresentsNewExpression && EvalTypeId.areAllConstantExpressions(this.fArguments, point) && EvalTypeId.isNullOrConstexprFunc(this.getConstructor(point));
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return ExpressionTypes.valueCategoryFromReturnType(this.fInputType);
    }

    public ICPPFunction getConstructor(IASTNode point) {
        if (this.fConstructor == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fConstructor = this.computeConstructor(point);
        }
        return this.fConstructor;
    }

    private ICPPFunction computeConstructor(IASTNode point) {
        if (this.isTypeDependent()) {
            return null;
        }
        IType simplifiedType = SemanticUtil.getNestedType(this.fInputType, 1);
        if (simplifiedType instanceof ICPPClassType) {
            ICPPFunction[] constructors;
            ICPPClassType classType = (ICPPClassType)simplifiedType;
            LookupData data = new LookupData(classType.getNameCharArray(), null, point);
            data.foundItems = constructors = ClassTypeHelper.getConstructors(classType, point);
            data.setFunctionArguments(false, this.fArguments);
            try {
                IBinding binding = CPPSemantics.resolveFunction(data, constructors, true);
                if (binding instanceof ICPPFunction) {
                    return (ICPPFunction)binding;
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 14;
        if (this.fRepresentsNewExpression) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fInputType);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPEvaluation[] args = null;
        int len = buffer.getInt();
        args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        boolean forNewExpression = (firstBytes & 0x20) != 0;
        return new EvalTypeId(type, templateDefinition, forNewExpression, args);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPFunction constructor;
        IType simplifiedType;
        ICPPEvaluation[] args = EvalTypeId.instantiateCommaSeparatedSubexpressions(this.fArguments, context, maxDepth);
        IType type = CPPTemplates.instantiateType(this.fInputType, context);
        if (args == this.fArguments && type == this.fInputType) {
            return this;
        }
        EvalTypeId result = new EvalTypeId(type, this.getTemplateDefinition(), this.fRepresentsNewExpression, args);
        if (!result.isTypeDependent() && (simplifiedType = SemanticUtil.getNestedType(type, 1)) instanceof ICPPClassType && ((constructor = result.getConstructor(context.getPoint())) == null || constructor instanceof IProblemBinding || constructor.isDeleted())) {
            return EvalFixed.INCOMPLETE;
        }
        return result;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, context.recordStep());
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalTypeId(this.fInputType, this.getTemplateDefinition(), this.fRepresentsNewExpression, args);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fInputType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

