/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.HashSet;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;

public class CPPASTFunctionDefinition
extends CPPASTAttributeOwner
implements ICPPASTFunctionDefinition,
IASTImplicitNameOwner {
    private IASTDeclSpecifier declSpecifier;
    private IASTFunctionDeclarator declarator;
    private IASTStatement bodyStatement;
    private ICPPASTConstructorChainInitializer[] memInits;
    private IASTImplicitName[] implicitNames;
    private int memInitPos = -1;
    private boolean fDeleted;
    private boolean fDefaulted;

    public CPPASTFunctionDefinition() {
    }

    public CPPASTFunctionDefinition(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, IASTStatement bodyStatement) {
        this.setDeclSpecifier(declSpecifier);
        this.setDeclarator(declarator);
        this.setBody(bodyStatement);
    }

    @Override
    public CPPASTFunctionDefinition copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFunctionDefinition copy(IASTNode.CopyStyle style) {
        CPPASTFunctionDefinition copy = new CPPASTFunctionDefinition();
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy(style));
        if (this.declarator != null) {
            IASTDeclarator outer = ASTQueries.findOutermostDeclarator(this.declarator);
            outer = outer.copy(style);
            copy.setDeclarator((IASTFunctionDeclarator)ASTQueries.findTypeRelevantDeclarator(outer));
        }
        copy.setBody(this.bodyStatement == null ? null : this.bodyStatement.copy(style));
        ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = this.getMemberInitializers();
        int n = iCPPASTConstructorChainInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer initializer = iCPPASTConstructorChainInitializerArray[n2];
            copy.addMemberInitializer(initializer == null ? null : initializer.copy(style));
            ++n2;
        }
        copy.fDefaulted = this.fDefaulted;
        copy.fDeleted = this.fDeleted;
        return this.copy(copy, style);
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpecifier = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    @Override
    public IASTFunctionDeclarator getDeclarator() {
        return this.declarator;
    }

    @Override
    public void setDeclarator(IASTFunctionDeclarator declarator) {
        this.assertNotFrozen();
        this.declarator = declarator;
        if (declarator != null) {
            IASTDeclarator outerDtor = ASTQueries.findOutermostDeclarator(declarator);
            outerDtor.setParent(this);
            outerDtor.setPropertyInParent(DECLARATOR);
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.bodyStatement;
    }

    @Override
    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.bodyStatement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(FUNCTION_BODY);
        }
    }

    @Override
    public void addMemberInitializer(ICPPASTConstructorChainInitializer initializer) {
        this.assertNotFrozen();
        if (initializer != null) {
            this.memInits = ArrayUtil.appendAt(ICPPASTConstructorChainInitializer.class, this.memInits, ++this.memInitPos, initializer);
            initializer.setParent(this);
            initializer.setPropertyInParent(MEMBER_INITIALIZER);
        }
    }

    @Override
    public ICPPASTConstructorChainInitializer[] getMemberInitializers() {
        if (this.memInits == null) {
            return ICPPASTConstructorChainInitializer.EMPTY_CONSTRUCTORCHAININITIALIZER_ARRAY;
        }
        this.memInits = ArrayUtil.trimAt(ICPPASTConstructorChainInitializer.class, this.memInits, this.memInitPos);
        return this.memInits;
    }

    @Override
    public IScope getScope() {
        return ((ICPPASTFunctionDeclarator)this.declarator).getFunctionScope();
    }

    @Override
    public boolean isDefaulted() {
        return this.fDefaulted;
    }

    @Override
    public boolean isDeleted() {
        return this.fDeleted;
    }

    @Override
    public void setIsDefaulted(boolean isDefaulted) {
        this.assertNotFrozen();
        this.fDefaulted = isDefaulted;
    }

    @Override
    public void setIsDeleted(boolean isDeleted) {
        this.assertNotFrozen();
        this.fDeleted = isDeleted;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator outerDtor = ASTQueries.findOutermostDeclarator(this.declarator);
        if (outerDtor != null && !outerDtor.accept(action)) {
            return false;
        }
        ICPPASTConstructorChainInitializer[] chain = this.getMemberInitializers();
        IASTNode[] iASTNodeArray = chain;
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer memInit = iASTNodeArray[n2];
            if (!memInit.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (action.shouldVisitImplicitNames) {
            iASTNodeArray = this.getImplicitNames();
            n = iASTNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                IASTNode implicitName = iASTNodeArray[n2];
                if (!implicitName.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.bodyStatement != null && !this.bodyStatement.accept(action)) {
            return false;
        }
        if (!this.acceptCatchHandlers(action)) {
            return false;
        }
        return !action.shouldVisitDeclarations || action.leave(this) != 2;
    }

    protected boolean acceptCatchHandlers(ASTVisitor action) {
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.bodyStatement == child) {
            other.setPropertyInParent(this.bodyStatement.getPropertyInParent());
            other.setParent(this.bodyStatement.getParent());
            this.bodyStatement = (IASTStatement)other;
            return;
        }
        super.replace(child, other);
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            IASTName functionName = ASTQueries.findInnermostDeclarator(this.declarator).getName();
            IBinding function = functionName.resolveBinding();
            if (function instanceof ICPPConstructor) {
                ICPPClassType classOwner = ((ICPPConstructor)function).getClassOwner();
                HashSet<Cloneable> basesThatNeedInitialization = new HashSet<Cloneable>();
                Cloneable[] cloneableArray = ClassTypeHelper.getBases(classOwner, this);
                int n = cloneableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase iCPPBase = cloneableArray[n2];
                    IType baseType = iCPPBase.getBaseClassType();
                    if (baseType instanceof ICPPClassType) {
                        basesThatNeedInitialization.add((ICPPClassType)baseType);
                    }
                    ++n2;
                }
                cloneableArray = ClassTypeHelper.getVirtualBases(classOwner, this);
                n = cloneableArray.length;
                n2 = 0;
                while (n2 < n) {
                    Cloneable cloneable = cloneableArray[n2];
                    basesThatNeedInitialization.add(cloneable);
                    ++n2;
                }
                block2: for (ICPPClassType iCPPClassType : basesThatNeedInitialization) {
                    if (this.isInitializedExplicitly(iCPPClassType)) continue;
                    ICPPConstructor[] iCPPConstructorArray = ClassTypeHelper.getConstructors(iCPPClassType, this);
                    int n3 = iCPPConstructorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPConstructor constructor = iCPPConstructorArray[n4];
                        if (constructor.getRequiredArgumentCount() == 0) {
                            CPPASTImplicitName ctorName = new CPPASTImplicitName(constructor.getNameCharArray(), (IASTNode)this);
                            ctorName.setBinding(constructor);
                            ctorName.setOffsetAndLength((ASTNode)((Object)functionName));
                            this.implicitNames = ArrayUtil.append(this.implicitNames, ctorName);
                            continue block2;
                        }
                        ++n4;
                    }
                }
            }
            this.implicitNames = ArrayUtil.trim(this.implicitNames);
        }
        return this.implicitNames;
    }

    private boolean isInitializedExplicitly(ICPPClassType base) {
        ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = this.getMemberInitializers();
        int n = iCPPASTConstructorChainInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer memInitializer = iCPPASTConstructorChainInitializerArray[n2];
            IBinding binding = memInitializer.getMemberInitializerId().resolveBinding();
            if (binding instanceof IType && ((IType)((Object)binding)).isSameType(base)) {
                return true;
            }
            if (binding instanceof ICPPConstructor && ((ICPPConstructor)binding).getClassOwner().isSameType(base)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

