/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdElement;
import com.android.ide.common.vectordrawable.VdGroup;
import com.android.ide.common.vectordrawable.VdPath;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class VdTree {
    private static Logger logger = Logger.getLogger(VdTree.class.getSimpleName());
    VdGroup mCurrentGroup = new VdGroup();
    ArrayList<VdElement> mChildren;
    float mBaseWidth = 1.0f;
    float mBaseHeight = 1.0f;
    float mPortWidth = 1.0f;
    float mPortHeight = 1.0f;
    float mRootAlpha = 1.0f;

    VdTree() {
    }

    void parseFinish() {
        this.mChildren = this.mCurrentGroup.getChildren();
    }

    void add(VdElement pathOrGroup) {
        this.mCurrentGroup.add(pathOrGroup);
    }

    float getBaseWidth() {
        return this.mBaseWidth;
    }

    float getBaseHeight() {
        return this.mBaseHeight;
    }

    private void drawInternal(Graphics g, int w, int h) {
        float scaleX = (float)w / this.mPortWidth;
        float scaleY = (float)h / this.mPortHeight;
        float minScale = Math.min(scaleX, scaleY);
        if (this.mChildren == null) {
            logger.log(Level.FINE, "no pathes");
            return;
        }
        ((Graphics2D)g).scale(scaleX, scaleY);
        RectangularShape bounds = null;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            VdPath path = (VdPath)this.mChildren.get(i);
            logger.log(Level.FINE, "mCurrentPaths[" + i + "]=" + path.getName() + Integer.toHexString(path.mFillColor));
            if (this.mChildren.get(i) == null) continue;
            Rectangle r = this.drawPath(path, g, w, h, minScale);
            if (bounds == null) {
                bounds = r;
                continue;
            }
            ((Rectangle)bounds).add(r);
        }
        logger.log(Level.FINE, "Rectangle " + bounds);
        logger.log(Level.FINE, "Port  " + this.mPortWidth + "," + this.mPortHeight);
        double right = (double)this.mPortWidth - bounds.getMaxX();
        double bot = (double)this.mPortHeight - bounds.getMaxY();
        logger.log(Level.FINE, "x " + bounds.getMinX() + ", " + right);
        logger.log(Level.FINE, "y " + bounds.getMinY() + ", " + bot);
    }

    private Rectangle drawPath(VdPath path, Graphics canvas, int w, int h, float scale) {
        Path2D.Double path2d = new Path2D.Double();
        Graphics2D g = (Graphics2D)canvas;
        path.toPath(path2d);
        double theta = Math.toRadians(path.mRotate);
        g.rotate(theta, path.mRotateX, path.mRotateY);
        if (path.mClip) {
            logger.log(Level.FINE, "CLIP");
            g.setColor(Color.RED);
            g.fill(path2d);
        }
        if (path.mFillColor != 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(path.mFillColor, true));
            g.fill(path2d);
        }
        if (path.mStrokeColor != 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(new BasicStroke(path.mStrokeWidth));
            g.setColor(new Color(path.mStrokeColor, true));
            g.draw(path2d);
        }
        g.rotate(-theta, path.mRotateX, path.mRotateY);
        return path2d.getBounds();
    }

    public void drawIntoImage(BufferedImage image) {
        Graphics2D gFinal = (Graphics2D)image.getGraphics();
        int width = image.getWidth();
        int height = image.getHeight();
        gFinal.setColor(new Color(255, 255, 255, 0));
        gFinal.fillRect(0, 0, width, height);
        float rootAlpha = this.mRootAlpha;
        if ((double)rootAlpha < 1.0) {
            BufferedImage alphaImage = AssetUtil.newArgbBufferedImage(width, height);
            Graphics2D gTemp = (Graphics2D)alphaImage.getGraphics();
            this.drawInternal(gTemp, width, height);
            gFinal.setComposite(AlphaComposite.getInstance(3, rootAlpha));
            gFinal.drawImage((Image)alphaImage, 0, 0, null);
            gTemp.dispose();
        } else {
            this.drawInternal(gFinal, width, height);
        }
        gFinal.dispose();
    }
}

