/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import com.google.common.base.Charsets;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VdPreview {
    private static final String ANDROID_ALPHA = "android:alpha";
    private static final String ANDROID_AUTO_MIRRORED = "android:autoMirrored";
    private static final String ANDROID_HEIGHT = "android:height";
    private static final String ANDROID_WIDTH = "android:width";
    public static final int MAX_PREVIEW_IMAGE_SIZE = 4096;
    public static final int MIN_PREVIEW_IMAGE_SIZE = 1;

    private static OutputFormat getPrettyPrintFormat() {
        OutputFormat format = new OutputFormat();
        format.setLineWidth(120);
        format.setIndenting(true);
        format.setIndent(4);
        format.setEncoding("UTF-8");
        format.setOmitComments(true);
        return format;
    }

    public static SourceSize getVdOriginalSize(Document document) {
        Element root = document.getDocumentElement();
        SourceSize srcSize = new SourceSize();
        NamedNodeMap attr = root.getAttributes();
        Node nodeAttr = attr.getNamedItem(ANDROID_WIDTH);
        assert (nodeAttr != null);
        srcSize.mSourceWidth = VdPreview.parseDimension(0, nodeAttr, false);
        nodeAttr = attr.getNamedItem(ANDROID_HEIGHT);
        assert (nodeAttr != null);
        srcSize.mSourceHeight = VdPreview.parseDimension(0, nodeAttr, false);
        return srcSize;
    }

    public static String overrideXmlContent(Document document, VdOverrideInfo info, StringBuilder errorLog) {
        int originalValue;
        int overrideValue;
        Node nodeAttr;
        boolean isXmlFileContentChanged = false;
        Element root = document.getDocumentElement();
        NamedNodeMap attr = root.getAttributes();
        if (info.needsOverrideWidth()) {
            nodeAttr = attr.getNamedItem(ANDROID_WIDTH);
            overrideValue = info.getWidth();
            originalValue = VdPreview.parseDimension(overrideValue, nodeAttr, true);
            if (originalValue != overrideValue) {
                isXmlFileContentChanged = true;
            }
        }
        if (info.needsOverrideHeight()) {
            nodeAttr = attr.getNamedItem(ANDROID_HEIGHT);
            overrideValue = info.getHeight();
            originalValue = VdPreview.parseDimension(overrideValue, nodeAttr, true);
            if (originalValue != overrideValue) {
                isXmlFileContentChanged = true;
            }
        }
        if (info.needsOverrideOpacity()) {
            nodeAttr = attr.getNamedItem(ANDROID_ALPHA);
            String opacityValue = String.format("%.2f", Float.valueOf((float)info.getOpacity() / 100.0f));
            if (nodeAttr != null) {
                nodeAttr.setTextContent(opacityValue);
            } else {
                root.setAttribute(ANDROID_ALPHA, opacityValue);
            }
            isXmlFileContentChanged = true;
        }
        if (info.needsOverrideAutoMirrored()) {
            nodeAttr = attr.getNamedItem(ANDROID_AUTO_MIRRORED);
            if (nodeAttr != null) {
                nodeAttr.setTextContent("true");
            } else {
                root.setAttribute(ANDROID_AUTO_MIRRORED, "true");
            }
            isXmlFileContentChanged = true;
        }
        if (isXmlFileContentChanged) {
            StringWriter stringOut;
            block13: {
                stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer(stringOut, VdPreview.getPrettyPrintFormat());
                try {
                    serial.serialize(document);
                }
                catch (IOException e) {
                    if (errorLog == null) break block13;
                    errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
                }
            }
            return stringOut.toString();
        }
        return null;
    }

    private static int parseDimension(int overrideValue, Node nodeAttr, boolean override) {
        assert (nodeAttr != null);
        String content = nodeAttr.getTextContent();
        assert (content.endsWith("dp"));
        int originalValue = Integer.parseInt(content.substring(0, content.length() - 2));
        if (override) {
            nodeAttr.setTextContent(overrideValue + "dp");
        }
        return originalValue;
    }

    public static BufferedImage getPreviewFromVectorXml(TargetSize targetSize, String xmlFileContent, StringBuilder vdErrorLog) {
        float imageHeight;
        float imageWidth;
        if (xmlFileContent == null || xmlFileContent.isEmpty()) {
            return null;
        }
        VdParser p = new VdParser();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileContent.getBytes(Charsets.UTF_8));
        VdTree vdTree = p.parse(inputStream, vdErrorLog);
        if (vdTree == null) {
            return null;
        }
        float vdWidth = vdTree.getBaseWidth();
        float vdHeight = vdTree.getBaseHeight();
        int forceImageSize = targetSize.mImageMaxDimension;
        float imageScale = targetSize.mImageScale;
        if (forceImageSize > 0) {
            float maxVdSize = Math.max(vdWidth, vdHeight);
            float ratioToForceImageSize = (float)forceImageSize / maxVdSize;
            float scaledWidth = ratioToForceImageSize * vdWidth;
            float scaledHeight = ratioToForceImageSize * vdHeight;
            imageWidth = Math.max(1.0f, Math.min(4096.0f, scaledWidth));
            imageHeight = Math.max(1.0f, Math.min(4096.0f, scaledHeight));
            if (scaledWidth != imageWidth || scaledHeight != imageHeight) {
                vdErrorLog.append("Invalid image size, can't fit in a square whose size is" + forceImageSize);
            }
        } else {
            imageWidth = vdWidth * imageScale;
            imageHeight = vdHeight * imageScale;
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage((int)imageWidth, (int)imageHeight);
        vdTree.drawIntoImage(image);
        return image;
    }

    public static void main(String[] args) {
        System.out.println("Hello from sdk-common-lib.");
    }

    public static class SourceSize {
        private int mSourceWidth;
        private int mSourceHeight;

        public int getHeight() {
            return this.mSourceHeight;
        }

        public int getWidth() {
            return this.mSourceWidth;
        }
    }

    public static class TargetSize {
        private boolean mUseWidth;
        private int mImageMaxDimension;
        private float mImageScale;

        private TargetSize(boolean useWidth, int imageWidth, float imageScale) {
            this.mUseWidth = useWidth;
            this.mImageMaxDimension = imageWidth;
            this.mImageScale = imageScale;
        }

        public static TargetSize createSizeFromWidth(int imageWidth) {
            return new TargetSize(true, imageWidth, 0.0f);
        }

        public static TargetSize createSizeFromScale(float imageScale) {
            return new TargetSize(false, 0, imageScale);
        }
    }
}

