/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdGroup;
import com.android.ide.common.vectordrawable.VdPath;
import com.android.ide.common.vectordrawable.VdTree;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class VdParser {
    private static Logger logger = Logger.getLogger(VdParser.class.getSimpleName());
    private static final String PATH_SHIFT_X = "shift-x";
    private static final String PATH_SHIFT_Y = "shift-y";
    private static final String SHAPE_VECTOR = "vector";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_GROUP = "group";
    private static final String PATH_ID = "android:name";
    private static final String PATH_DESCRIPTION = "android:pathData";
    private static final String PATH_FILL = "android:fillColor";
    private static final String PATH_FILL_OPACTIY = "android:fillAlpha";
    private static final String PATH_STROKE = "android:strokeColor";
    private static final String PATH_STROKE_OPACTIY = "android:strokeAlpha";
    private static final String PATH_STROKE_WIDTH = "android:strokeWidth";
    private static final String PATH_ROTATION = "android:rotation";
    private static final String PATH_ROTATION_X = "android:pivotX";
    private static final String PATH_ROTATION_Y = "android:pivotY";
    private static final String PATH_TRIM_START = "android:trimPathStart";
    private static final String PATH_TRIM_END = "android:trimPathEnd";
    private static final String PATH_TRIM_OFFSET = "android:trimPathOffset";
    private static final String PATH_STROKE_LINECAP = "android:strokeLinecap";
    private static final String PATH_STROKE_LINEJOIN = "android:strokeLinejoin";
    private static final String PATH_STROKE_MITERLIMIT = "android:strokeMiterlimit";
    private static final String PATH_CLIP = "android:clipToPath";
    private static final String LINECAP_BUTT = "butt";
    private static final String LINECAP_ROUND = "round";
    private static final String LINECAP_SQUARE = "square";
    private static final String LINEJOIN_MITER = "miter";
    private static final String LINEJOIN_ROUND = "round";
    private static final String LINEJOIN_BEVEL = "bevel";
    ElemParser mParseSize = new ElemParser(){

        @Override
        public void parse(VdTree tree, Attributes attributes) {
            VdParser.this.parseSize(tree, attributes);
        }
    };
    ElemParser mParsePath = new ElemParser(){

        @Override
        public void parse(VdTree tree, Attributes attributes) {
            VdPath p = VdParser.this.parsePathAttributes(attributes);
            tree.add(p);
        }
    };
    ElemParser mParseGroup = new ElemParser(){

        @Override
        public void parse(VdTree tree, Attributes attributes) {
            VdGroup g = VdParser.this.parseGroupAttributes(attributes);
            tree.add(g);
        }
    };
    HashMap<String, ElemParser> tagSwitch = new HashMap();

    public VdTree parse(InputStream is, StringBuilder vdErrorLog) {
        try {
            final VdTree tree = new VdTree();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler(new ContentHandler(){
                String space = " ";

                @Override
                public void setDocumentLocator(Locator locator) {
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void endDocument() throws SAXException {
                }

                @Override
                public void startPrefixMapping(String s, String s2) throws SAXException {
                }

                @Override
                public void endPrefixMapping(String s) throws SAXException {
                }

                @Override
                public void startElement(String s, String s2, String s3, Attributes attributes) throws SAXException {
                    String name = s3;
                    if (VdParser.this.tagSwitch.containsKey(name)) {
                        VdParser.this.tagSwitch.get(name).parse(tree, attributes);
                    }
                    this.space = this.space + " ";
                }

                @Override
                public void endElement(String s, String s2, String s3) throws SAXException {
                    this.space = this.space.substring(1);
                }

                @Override
                public void characters(char[] chars, int i, int i2) throws SAXException {
                }

                @Override
                public void ignorableWhitespace(char[] chars, int i, int i2) throws SAXException {
                }

                @Override
                public void processingInstruction(String s, String s2) throws SAXException {
                }

                @Override
                public void skippedEntity(String s) throws SAXException {
                }
            });
            xr.parse(new InputSource(is));
            tree.parseFinish();
            return tree;
        }
        catch (Exception e) {
            vdErrorLog.append("Exception while parsing XML file:\n" + e.getMessage());
            return null;
        }
    }

    public VdParser() {
        this.tagSwitch.put(SHAPE_VECTOR, this.mParseSize);
        this.tagSwitch.put(SHAPE_PATH, this.mParsePath);
        this.tagSwitch.put(SHAPE_GROUP, this.mParseGroup);
    }

    private static int nextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }

    public static VdPath.Node[] parsePath(String value) {
        int start = 0;
        int end = 1;
        ArrayList<VdPath.Node> list = new ArrayList<VdPath.Node>();
        while (end < value.length()) {
            end = VdParser.nextStart(value, end);
            String s = value.substring(start, end);
            float[] val = VdParser.getFloats(s);
            VdParser.addNode(list, s.charAt(0), val);
            start = end++;
        }
        if (end - start == 1 && start < value.length()) {
            VdParser.addNode(list, value.charAt(start), new float[0]);
        }
        return list.toArray(new VdPath.Node[list.size()]);
    }

    private static float[] copyOfRange(float[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    private static void extract(String s, int start, ExtractFloatResult result) {
        int currentIndex;
        boolean foundSeparator = false;
        result.mEndWithNegOrDot = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case '.': {
                    if (!secondDot) {
                        secondDot = true;
                        break;
                    }
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator) break;
        }
        result.mEndPosition = currentIndex;
    }

    private static float[] getFloats(String s) {
        if (s.charAt(0) == 'z' || s.charAt(0) == 'Z') {
            return new float[0];
        }
        try {
            float[] results = new float[s.length()];
            int count = 0;
            int startPosition = 1;
            int endPosition = 0;
            ExtractFloatResult result = new ExtractFloatResult();
            int totalLength = s.length();
            while (startPosition < totalLength) {
                VdParser.extract(s, startPosition, result);
                endPosition = result.mEndPosition;
                if (startPosition < endPosition) {
                    results[count++] = Float.parseFloat(s.substring(startPosition, endPosition));
                }
                if (result.mEndWithNegOrDot) {
                    startPosition = endPosition;
                    continue;
                }
                startPosition = endPosition + 1;
            }
            return VdParser.copyOfRange(results, 0, count);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("error in parsing \"" + s + "\"", e);
        }
    }

    private static void addNode(ArrayList<VdPath.Node> list, char cmd, float[] val) {
        list.add(new VdPath.Node(cmd, val));
    }

    public VdTree parse(URL r, StringBuilder vdErrorLog) throws Exception {
        return this.parse(r.openStream(), vdErrorLog);
    }

    private void parseSize(VdTree vdTree, Attributes attributes) {
        Pattern pattern = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("px", 1);
        m.put("dip", 1);
        m.put("dp", 1);
        m.put("sp", 1);
        m.put("pt", 1);
        m.put("in", 1);
        m.put("mm", 1);
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            Matcher matcher = pattern.matcher(value);
            float size = 0.0f;
            if (matcher.matches()) {
                float v = Float.parseFloat(matcher.group(1));
                String unit = matcher.group(3).toLowerCase(Locale.getDefault());
                size = v;
            }
            if ("android:width".equals(name)) {
                vdTree.mBaseWidth = size;
                continue;
            }
            if ("android:height".equals(name)) {
                vdTree.mBaseHeight = size;
                continue;
            }
            if ("android:viewportWidth".equals(name)) {
                vdTree.mPortWidth = Float.parseFloat(value);
                continue;
            }
            if ("android:viewportHeight".equals(name)) {
                vdTree.mPortHeight = Float.parseFloat(value);
                continue;
            }
            if (!"android:alpha".equals(name)) continue;
            vdTree.mRootAlpha = Float.parseFloat(value);
        }
    }

    private VdPath parsePathAttributes(Attributes attributes) {
        int len = attributes.getLength();
        VdPath vgPath = new VdPath();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            logger.log(Level.FINE, "name " + name + "value " + value);
            this.setNameValue(vgPath, name, value);
        }
        return vgPath;
    }

    private VdGroup parseGroupAttributes(Attributes attributes) {
        int len = attributes.getLength();
        VdGroup vgGroup = new VdGroup();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            logger.log(Level.FINE, "name " + name + "value " + value);
        }
        return vgGroup;
    }

    public void setNameValue(VdPath vgPath, String name, String value) {
        if (PATH_DESCRIPTION.equals(name)) {
            vgPath.mNode = VdParser.parsePath(value);
        } else if (PATH_ID.equals(name)) {
            vgPath.mName = value;
        } else if (PATH_FILL.equals(name)) {
            vgPath.mFillColor = this.calculateColor(value);
            if (!Float.isNaN(vgPath.mFillOpacity)) {
                vgPath.mFillColor &= 0xFFFFFF;
                vgPath.mFillColor |= (int)(255.0f * vgPath.mFillOpacity) << 24;
            }
        } else if (PATH_STROKE.equals(name)) {
            vgPath.mStrokeColor = this.calculateColor(value);
            if (!Float.isNaN(vgPath.mStrokeOpacity)) {
                vgPath.mStrokeColor &= 0xFFFFFF;
                vgPath.mStrokeColor |= (int)(255.0f * vgPath.mStrokeOpacity) << 24;
            }
        } else if (PATH_FILL_OPACTIY.equals(name)) {
            vgPath.mFillOpacity = Float.parseFloat(value);
            vgPath.mFillColor &= 0xFFFFFF;
            vgPath.mFillColor |= (int)(255.0f * vgPath.mFillOpacity) << 24;
        } else if (PATH_STROKE_OPACTIY.equals(name)) {
            vgPath.mStrokeOpacity = Float.parseFloat(value);
            vgPath.mStrokeColor &= 0xFFFFFF;
            vgPath.mStrokeColor |= (int)(255.0f * vgPath.mStrokeOpacity) << 24;
        } else if (PATH_STROKE_WIDTH.equals(name)) {
            vgPath.mStrokeWidth = Float.parseFloat(value);
        } else if (PATH_ROTATION.equals(name)) {
            vgPath.mRotate = Float.parseFloat(value);
        } else if (PATH_SHIFT_X.equals(name)) {
            vgPath.mShiftX = Float.parseFloat(value);
        } else if (PATH_SHIFT_Y.equals(name)) {
            vgPath.mShiftY = Float.parseFloat(value);
        } else if (PATH_ROTATION_Y.equals(name)) {
            vgPath.mRotateY = Float.parseFloat(value);
        } else if (PATH_ROTATION_X.equals(name)) {
            vgPath.mRotateX = Float.parseFloat(value);
        } else if (PATH_CLIP.equals(name)) {
            vgPath.mClip = Boolean.parseBoolean(value);
        } else if (PATH_TRIM_START.equals(name)) {
            vgPath.mTrimPathStart = Float.parseFloat(value);
        } else if (PATH_TRIM_END.equals(name)) {
            vgPath.mTrimPathEnd = Float.parseFloat(value);
        } else if (PATH_TRIM_OFFSET.equals(name)) {
            vgPath.mTrimPathOffset = Float.parseFloat(value);
        } else if (PATH_STROKE_LINECAP.equals(name)) {
            if (LINECAP_BUTT.equals(value)) {
                vgPath.mStrokeLineCap = 0;
            } else if ("round".equals(value)) {
                vgPath.mStrokeLineCap = 1;
            } else if (LINECAP_SQUARE.equals(value)) {
                vgPath.mStrokeLineCap = 2;
            }
        } else if (PATH_STROKE_LINEJOIN.equals(name)) {
            if (LINEJOIN_MITER.equals(value)) {
                vgPath.mStrokeLineJoin = 0;
            } else if ("round".equals(value)) {
                vgPath.mStrokeLineJoin = 1;
            } else if (LINEJOIN_BEVEL.equals(value)) {
                vgPath.mStrokeLineJoin = 2;
            }
        } else if (PATH_STROKE_MITERLIMIT.equals(name)) {
            vgPath.mStrokeMiterlimit = Float.parseFloat(value);
        } else {
            logger.log(Level.FINE, ">>>>>> DID NOT UNDERSTAND ! \"" + name + "\" <<<<");
        }
    }

    private int calculateColor(String value) {
        int ret;
        int len = value.length();
        int k = 0;
        switch (len) {
            case 7: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                ret |= 0xFF000000;
                break;
            }
            case 9: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                break;
            }
            case 4: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                k |= (ret >> 8 & 0xF) * 0x110000;
                k |= (ret >> 4 & 0xF) * 4352;
                k |= (ret & 0xF) * 17;
                ret = k | 0xFF000000;
                break;
            }
            case 5: {
                ret = (int)Long.parseLong(value.substring(1), 16);
                k |= (ret >> 16 & 0xF) * 0x11000000;
                k |= (ret >> 8 & 0xF) * 0x110000;
                k |= (ret >> 4 & 0xF) * 4352;
                k |= (ret & 0xF) * 17;
                break;
            }
            default: {
                return -16777216;
            }
        }
        logger.log(Level.FINE, "color = " + value + " = " + Integer.toHexString(ret));
        return ret;
    }

    private static class ExtractFloatResult {
        int mEndPosition;
        boolean mEndWithNegOrDot;

        private ExtractFloatResult() {
        }
    }

    static interface ElemParser {
        public void parse(VdTree var1, Attributes var2);
    }
}

